/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmSequenceSupport;
import org.hibernate.dialect.DmSqlAstTranslator;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.identity.DMIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DmGeoDialect
extends Dialect {
    private BasicType<Boolean> booleanType;
    private BasicType<Character> characterType;
    private BasicType<String> stringType;
    private BasicType<Integer> integerType;
    private BasicType<Long> longType;
    private BasicType<Double> doubleType;
    private BasicType<Date> dateType;
    private BasicType<Date> timeType;
    private BasicType<Date> timestampType;
    private BasicType<Blob> blobType;
    private BasicType<Clob> clobType;
    private static final AbstractLimitHandler LIMIT_HANDLER = new AbstractLimitHandler(){

        public String processSql(String sql, Limit limit) {
            Integer firstRow = limit.getFirstRow();
            boolean hasOffset = firstRow != null && firstRow > 0;
            sql = sql.trim();
            while (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            boolean isForUpdate = false;
            if (sql.toLowerCase().endsWith(" for update")) {
                sql = sql.substring(0, sql.length() - 11);
                isForUpdate = true;
            }
            StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
            if (hasOffset) {
                pagingSelect.append(sql).append(" limit ? offset ? ");
            } else {
                pagingSelect.append(sql).append(" limit ? ");
            }
            if (isForUpdate) {
                pagingSelect.append(" for update");
            }
            return pagingSelect.toString();
        }

        public boolean supportsLimit() {
            return true;
        }

        public boolean supportsLimitOffset() {
            return this.supportsLimit();
        }

        public boolean supportsVariableLimit() {
            return this.supportsLimit();
        }

        public boolean bindLimitParametersInReverseOrder() {
            return true;
        }

        public boolean bindLimitParametersFirst() {
            return false;
        }

        public boolean useMaxForLimit() {
            return false;
        }

        public boolean forceLimitUsage() {
            return false;
        }

        public int convertToFirstRowValue(int zeroBasedFirstResult) {
            return zeroBasedFirstResult;
        }
    };
    int dmdbtype_cursor = 120;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new ViolatedConstraintNameExtractor(){

        public String extractConstraintName(SQLException sqle) {
            return null;
        }
    };

    public DmGeoDialect() {
        this.registerKeyword("last");
        this.registerKeyword("size");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DMIdentityColumnSupport();
    }

    public SequenceSupport getSequenceSupport() {
        return DmSequenceSupport.INSTANCE;
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-7, "bit", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(16, "bit", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-6, "tinyint", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(5, "smallint", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(4, "integer", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-5, "bigint", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(6, "float", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(8, "double", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2, "numeric($p,$s)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(7, "real", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3, "decimal($p,$s)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(91, "date", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(92, "time", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(93, "datetime", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-2, "binary($l)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-3, "varbinary($l)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-4, "image", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2004, "blob", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(1, "char(1)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(12, "varchar($l)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-1, "text", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2005, "clob", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-15, "char(1)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-9, "varchar($l)", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(-16, "text", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2011, "clob", (Dialect)this));
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        this.dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        this.timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        this.timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        this.longType = basicTypeRegistry.resolve(StandardBasicTypes.LONG);
        this.characterType = basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER);
        this.booleanType = basicTypeRegistry.resolve(StandardBasicTypes.BOOLEAN);
        this.stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        this.integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
        this.doubleType = basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE);
        this.blobType = basicTypeRegistry.resolve(StandardBasicTypes.BLOB);
        this.clobType = basicTypeRegistry.resolve(StandardBasicTypes.CLOB);
        SqmFunctionRegistry sqmFunctionRegistry = functionContributions.getFunctionRegistry();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.substring();
        sqmFunctionRegistry.namedDescriptorBuilder("locate").setInvariantType(this.integerType).setMinArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER}).setArgumentListSignature("(STRING pattern, STRING string, INTEGER start)").register();
        sqmFunctionRegistry.patternDescriptorBuilder("trim", "trim(?1 ?2 FROM ?3)").setInvariantType(this.stringType).setMinArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.STRING}).setArgumentListSignature("(STRING str1 STRING str2 FROM STRING str3)").register();
        sqmFunctionRegistry.register("length", (SqmFunctionDescriptor)new StandardSQLFunction("length", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("bit_length", (SqmFunctionDescriptor)new StandardSQLFunction("bit_length", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.namedDescriptorBuilder("coalesce").setMinArgumentCount(1).setInvariantType(this.stringType).register();
        sqmFunctionRegistry.namedDescriptorBuilder("nullif").setExactArgumentCount(2).setInvariantType(this.stringType).register();
        functionFactory.lowerUpper();
        sqmFunctionRegistry.patternDescriptorBuilder("extract", "extract(?1 FROM ?2)").setInvariantType(this.integerType).setExactArgumentCount(2).setArgumentListSignature("(TEMPORAL_UNIT unit FROM STRING str3)").register();
        functionFactory.hourMinuteSecond();
        functionFactory.yearMonthDay();
        sqmFunctionRegistry.register("str", (SqmFunctionDescriptor)new StandardSQLFunction("to_char", StandardBasicTypes.STRING));
        functionFactory.trigonometry();
        functionFactory.math();
        sqmFunctionRegistry.register("ceil", (SqmFunctionDescriptor)new StandardSQLFunction("ceil", StandardBasicTypes.INTEGER));
        functionFactory.cot();
        functionFactory.cosh();
        functionFactory.degrees();
        sqmFunctionRegistry.namedDescriptorBuilder("GREATEST").setMinArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE}).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionFactory.log();
        functionFactory.log10();
        functionFactory.pi();
        functionFactory.radians();
        sqmFunctionRegistry.namedDescriptorBuilder("rand").setArgumentCountBetween(0, 1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).setInvariantType(this.doubleType).setArgumentListSignature("()").register();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.trunc();
        sqmFunctionRegistry.namedDescriptorBuilder("truncate").setArgumentCountBetween(1, 2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC, FunctionParameterType.INTEGER}).setInvariantType(this.doubleType).setArgumentListSignature("(NUMERIC number[, INTEGER places])").register();
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.concat_pipeOperator();
        sqmFunctionRegistry.namedDescriptorBuilder("localdate").setArgumentCountBetween(0, 1).setInvariantType(this.dateType).register();
        sqmFunctionRegistry.namedDescriptorBuilder("localtime").setArgumentCountBetween(0, 1).setInvariantType(this.timeType).register();
        functionFactory.ascii();
        functionFactory.char_chr();
        sqmFunctionRegistry.register("difference", (SqmFunctionDescriptor)new StandardSQLFunction("difference", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("char_length", (SqmFunctionDescriptor)new StandardSQLFunction("char_length", StandardBasicTypes.LONG));
        sqmFunctionRegistry.register("character_length", (SqmFunctionDescriptor)new StandardSQLFunction("character_length", StandardBasicTypes.LONG));
        functionFactory.chr_char();
        sqmFunctionRegistry.register("initcap", (SqmFunctionDescriptor)new StandardSQLFunction("initcap", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("insert", (SqmFunctionDescriptor)new StandardSQLFunction("insert", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("insstr", (SqmFunctionDescriptor)new StandardSQLFunction("insstr", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("instr", (SqmFunctionDescriptor)new StandardSQLFunction("instr", StandardBasicTypes.LONG));
        sqmFunctionRegistry.register("instrb", (SqmFunctionDescriptor)new StandardSQLFunction("instrb", StandardBasicTypes.LONG));
        sqmFunctionRegistry.register("lcase", (SqmFunctionDescriptor)new StandardSQLFunction("lcase", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("left", (SqmFunctionDescriptor)new StandardSQLFunction("left", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("leftstr", (SqmFunctionDescriptor)new StandardSQLFunction("leftstr", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("len", (SqmFunctionDescriptor)new StandardSQLFunction("len", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("LENGTHB", (SqmFunctionDescriptor)new StandardSQLFunction("LENGTHB", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("octet_length", (SqmFunctionDescriptor)new StandardSQLFunction("octet_length", StandardBasicTypes.LONG));
        sqmFunctionRegistry.register("lpad", (SqmFunctionDescriptor)new StandardSQLFunction("lpad", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("ltrim", (SqmFunctionDescriptor)new StandardSQLFunction("ltrim", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("position", (SqmFunctionDescriptor)new StandardSQLFunction("position", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("INS", (SqmFunctionDescriptor)new StandardSQLFunction("INS", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("repeat", (SqmFunctionDescriptor)new StandardSQLFunction("repeat", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("REPLICATE", (SqmFunctionDescriptor)new StandardSQLFunction("REPLICATE", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("STUFF", (SqmFunctionDescriptor)new StandardSQLFunction("STUFF", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("repeatstr", (SqmFunctionDescriptor)new StandardSQLFunction("repeatstr", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("replace", (SqmFunctionDescriptor)new StandardSQLFunction("replace", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("reverse", (SqmFunctionDescriptor)new StandardSQLFunction("reverse", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("right", (SqmFunctionDescriptor)new StandardSQLFunction("right", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("rightstr", (SqmFunctionDescriptor)new StandardSQLFunction("rightstr", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("rpad", (SqmFunctionDescriptor)new StandardSQLFunction("rpad", StandardBasicTypes.STRING));
        sqmFunctionRegistry.namedDescriptorBuilder("to_number").setArgumentCountBetween(1, 2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.STRING, FunctionParameterType.STRING}).setInvariantType(this.doubleType).register();
        sqmFunctionRegistry.register("rtrim", (SqmFunctionDescriptor)new StandardSQLFunction("rtrim", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("soundex", (SqmFunctionDescriptor)new StandardSQLFunction("soundex", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("space", (SqmFunctionDescriptor)new StandardSQLFunction("space", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("substr", (SqmFunctionDescriptor)new StandardSQLFunction("substr", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("substrb", (SqmFunctionDescriptor)new StandardSQLFunction("substrb", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("to_char", (SqmFunctionDescriptor)new StandardSQLFunction("to_char", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("STRPOSDEC", (SqmFunctionDescriptor)new StandardSQLFunction("STRPOSDEC", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("STRPOSINC", (SqmFunctionDescriptor)new StandardSQLFunction("STRPOSINC", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("VSIZE", (SqmFunctionDescriptor)new StandardSQLFunction("VSIZE", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("translate", (SqmFunctionDescriptor)new StandardSQLFunction("translate", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("ucase", (SqmFunctionDescriptor)new StandardSQLFunction("ucase", StandardBasicTypes.STRING));
        sqmFunctionRegistry.patternDescriptorBuilder("OVERLAPS", "OVERLAPS(?1, ?2, ?3, ?4)").setInvariantType(this.integerType).setExactArgumentCount(4).setArgumentListSignature("(datetime1 datetime2 datetime3 datetime4)").register();
        sqmFunctionRegistry.patternDescriptorBuilder("DATEPART", "DATE_PART(?2, ?1)").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.ANY, FunctionParameterType.ANY}).setArgumentListSignature("(String field, String arg)").register();
        sqmFunctionRegistry.namedDescriptorBuilder("DATE_PART").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.ANY, FunctionParameterType.STRING}).setArgumentListSignature("(String arg, String field)").register();
        sqmFunctionRegistry.namedDescriptorBuilder("BLOB_EQUAL").setInvariantType(this.integerType).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.STRING, FunctionParameterType.STRING}).setArgumentListSignature("(String arg1, String arg2)").register();
        sqmFunctionRegistry.namedDescriptorBuilder("add_weeks").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE, FunctionParameterType.INTEGER}).setArgumentListSignature("(DATE datetime, INTEGER years)").register();
        sqmFunctionRegistry.namedDescriptorBuilder("add_months").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE, FunctionParameterType.INTEGER}).setArgumentListSignature("(DATE datetime, INTEGER months)").register();
        sqmFunctionRegistry.namedDescriptorBuilder("add_days").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE, FunctionParameterType.INTEGER}).setArgumentListSignature("(DATE datetime, INTEGER days)").register();
        sqmFunctionRegistry.registerNoArgs("curdate", "curdate", this.dateType);
        sqmFunctionRegistry.namedDescriptorBuilder("curtime").setInvariantType(this.timeType).setArgumentCountBetween(0, 1).register();
        sqmFunctionRegistry.registerNoArgs("current_date", "current_date", this.dateType);
        sqmFunctionRegistry.namedDescriptorBuilder("current_time").setInvariantType(this.timeType).setArgumentCountBetween(0, 1).register();
        sqmFunctionRegistry.namedDescriptorBuilder("current_timestamp").setInvariantType(this.timestampType).setArgumentCountBetween(0, 1).register();
        sqmFunctionRegistry.namedDescriptorBuilder("dateadd").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)3)).setExactArgumentCount(3).setArgumentListSignature("(ANY arg, INTEGER days, DATE daytime)").register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_year", "date_add(?1, INTERVAL ?2 year)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_month", "date_add(?1, INTERVAL ?2 month)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_day", "date_add(?1, INTERVAL ?2 day)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_hour", "date_add(?1, INTERVAL ?2 hour)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_minute", "date_add(?1, INTERVAL ?2 minute)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_second", "date_add(?1, INTERVAL ?2 second)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_day_to_second", "date_add(?1, INTERVAL ?2 day to second)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_day_to_minute", "date_add(?1, INTERVAL ?2 day to minute)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_hour_to_minute", "date_add(?1, INTERVAL ?2 hour to minute)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_hour_to_second", "date_add(?1, INTERVAL ?2 hour to second)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_add_year_to_month", "date_add(?1, INTERVAL ?2 year to month)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_year", "date_sub(?1, INTERVAL ?2 year)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_month", "date_sub(?1, INTERVAL ?2 month)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_day", "date_sub(?1, INTERVAL ?2 day)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_hour", "date_sub(?1, INTERVAL ?2 hour)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_minute", "date_sub(?1, INTERVAL ?2 minute)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_second", "date_sub(?1, INTERVAL ?2 second)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_day_to_second", "date_sub(?1, INTERVAL ?2 day to second)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_day_to_minute", "date_sub(?1, INTERVAL ?2 day to minute)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_hour_to_minute", "date_sub(?1, INTERVAL ?2 hour to minute)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_hour_to_second", "date_sub(?1, INTERVAL ?2 hour to second)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.patternDescriptorBuilder("date_sub_year_to_month", "date_sub(?1, INTERVAL ?2 year to month)").setInvariantType(this.timestampType).register();
        sqmFunctionRegistry.registerNamed("CUR_TICK_TIME", this.stringType);
        sqmFunctionRegistry.register("datediff", (SqmFunctionDescriptor)new StandardSQLFunction("datediff", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.namedDescriptorBuilder("datepart").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.ANY}).setArgumentListSignature("(TEMPORAL_UNIT field, TEMPORAL arg)").register();
        sqmFunctionRegistry.register("dayname", (SqmFunctionDescriptor)new StandardSQLFunction("dayname", StandardBasicTypes.STRING));
        sqmFunctionRegistry.register("dayofmonth", (SqmFunctionDescriptor)new StandardSQLFunction("dayofmonth", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("dayofweek", (SqmFunctionDescriptor)new StandardSQLFunction("dayofweek", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("dayofyear", (SqmFunctionDescriptor)new StandardSQLFunction("dayofyear", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("days_between", (SqmFunctionDescriptor)new StandardSQLFunction("days_between", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("getdate", (SqmFunctionDescriptor)new StandardSQLFunction("getdate", StandardBasicTypes.TIMESTAMP));
        sqmFunctionRegistry.namedDescriptorBuilder("localtimestamp").setArgumentCountBetween(0, 1).setInvariantType(this.timestampType).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).setArgumentListSignature("(INTERGER index)").register();
        sqmFunctionRegistry.registerNoArgs("NOW", "NOW", this.dateType);
        functionFactory.lastDay();
        sqmFunctionRegistry.register("month", (SqmFunctionDescriptor)new StandardSQLFunction("month", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("monthname", (SqmFunctionDescriptor)new StandardSQLFunction("monthname", StandardBasicTypes.STRING));
        functionFactory.monthsBetween();
        sqmFunctionRegistry.namedDescriptorBuilder("GREATEST").setMinArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE}).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        sqmFunctionRegistry.patternDescriptorBuilder("TO_DATETIME", "TO_DATETIME(?1, ?2, ?3, ?4, ?5)").setExactArgumentCount(5).setInvariantType(this.timestampType).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER}).setArgumentListSignature("(INTERGER month, INTEGER day, INTEHER hr, INTEGER min, INTEHER second)").register();
        sqmFunctionRegistry.patternDescriptorBuilder("next_day", "next_day(?1\uff0c ?2)").setExactArgumentCount(2).setInvariantType(this.dateType).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE, FunctionParameterType.STRING}).setArgumentListSignature("(DATE date, STRING days)").register();
        sqmFunctionRegistry.patternDescriptorBuilder("overlay", "overlay(?1 placing ?2 from ?3 for ?4)").setInvariantType(this.stringType).setExactArgumentCount(4).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER}).setArgumentListSignature("(STRING string, STRING replacement, INTEGER start, INTEGER length)").register();
        sqmFunctionRegistry.patternDescriptorBuilder("qt", "quarter(?1)").setExactArgumentCount(1).setInvariantType(this.integerType).setArgumentListSignature("(DATE datetime)").register();
        sqmFunctionRegistry.namedDescriptorBuilder("ROUND").setExactArgumentCount(2).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).setArgumentListSignature("(Date datetime, String str)").register();
        sqmFunctionRegistry.register("timestampadd", (SqmFunctionDescriptor)new StandardSQLFunction("timestampadd", StandardBasicTypes.TIMESTAMP));
        sqmFunctionRegistry.register("timestampdiff", (SqmFunctionDescriptor)new StandardSQLFunction("timestampdiff", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("BIGDATEDIFF", (SqmFunctionDescriptor)new StandardSQLFunction("BIGDATEDIFF", StandardBasicTypes.BIG_INTEGER));
        sqmFunctionRegistry.register("sysdate", (SqmFunctionDescriptor)new StandardSQLFunction("sysdate", StandardBasicTypes.TIME));
        sqmFunctionRegistry.namedDescriptorBuilder("LEAST").setMinArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.COMPARABLE, FunctionParameterType.COMPARABLE}).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        sqmFunctionRegistry.patternDescriptorBuilder("weekofyear", "week(?1)").setInvariantType(this.integerType).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.DATE}).register();
        sqmFunctionRegistry.register("weekday", (SqmFunctionDescriptor)new StandardSQLFunction("weekday", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("weeks_between", (SqmFunctionDescriptor)new StandardSQLFunction("weeks_between", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("year", (SqmFunctionDescriptor)new StandardSQLFunction("year", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("years_between", (SqmFunctionDescriptor)new StandardSQLFunction("years_between", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("to_date", (SqmFunctionDescriptor)new StandardSQLFunction("to_date", StandardBasicTypes.TIMESTAMP));
        sqmFunctionRegistry.register("systimestamp", (SqmFunctionDescriptor)new StandardSQLFunction("systimestamp", StandardBasicTypes.TIMESTAMP));
        sqmFunctionRegistry.namedDescriptorBuilder("ifnull").setExactArgumentCount(2).setInvariantType(this.stringType).register();
        sqmFunctionRegistry.namedDescriptorBuilder("isnull").setArgumentCountBetween(1, 2).setInvariantType(this.stringType).register();
        sqmFunctionRegistry.namedDescriptorBuilder("nvl").setExactArgumentCount(2).setInvariantType(this.stringType).register();
        sqmFunctionRegistry.namedDescriptorBuilder("decode").setInvariantType(this.stringType).setMinArgumentCount(5).register();
        sqmFunctionRegistry.registerNoArgs("cur_database", this.stringType);
        sqmFunctionRegistry.registerNoArgs("page", this.integerType);
        sqmFunctionRegistry.registerNoArgs("sessid", this.longType);
        sqmFunctionRegistry.registerNoArgs("uid", this.longType);
        sqmFunctionRegistry.registerNoArgs("user", this.stringType);
        sqmFunctionRegistry.register("vsize", (SqmFunctionDescriptor)new StandardSQLFunction("vsize", StandardBasicTypes.INTEGER));
        sqmFunctionRegistry.register("tabledef", (SqmFunctionDescriptor)new StandardSQLFunction("tabledef", StandardBasicTypes.STRING));
        sqmFunctionRegistry.noArgsBuilder("EMPTY_BLOB").setInvariantType(this.blobType).register();
        sqmFunctionRegistry.noArgsBuilder("EMPTY_CLOB").setInvariantType(this.clobType).register();
        sqmFunctionRegistry.namedDescriptorBuilder("TO_BLOB").setInvariantType(this.blobType).setExactArgumentCount(1).register();
        sqmFunctionRegistry.namedDescriptorBuilder("TO_CLOB").setInvariantType(this.clobType).setExactArgumentCount(1).register();
    }

    public String getQuerySequencesString() {
        return "select\r\n        SEQS.SEQUENCE_NAME NAME,\r\n        SEQS.*                        ,\r\n        '' sequence_catalog           ,\r\n        sequence_owner sequence_schema,\r\n        SEQ_OBJ.INFO3 start_value     ,\r\n        min_value minimum_value       ,\r\n        max_value maximum_value       ,\r\n        increment_by increment      ,\r\n        SEQ_OBJ.ID\r\nfrom\r\n        all_sequences SEQS\r\nleft join\r\n        (\r\n                select distinct\r\n                        SCH_OBJ.NAME SCHEMA_NAME,\r\n                        SEQ_OBJ_INNER.ID        ,\r\n                        SEQ_OBJ_INNER.NAME      ,\r\n                        SEQ_OBJ_INNER.INFO3\r\n                from\r\n                        SYS.SYSOBJECTS SEQ_OBJ_INNER,\r\n                        SYS.SYSOBJECTS SCH_OBJ\r\n                where\r\n                        SCH_OBJ.TYPE$          ='SCH'\r\n                    and SEQ_OBJ_INNER.SUBTYPE$ ='SEQ'\r\n                    and SEQ_OBJ_INNER.SCHID    = SCH_OBJ.ID\r\n        )\r\n        SEQ_OBJ\r\nON\r\n        SEQ_OBJ.NAME        = SEQS.SEQUENCE_NAME\r\n    AND SEQ_OBJ.SCHEMA_NAME = SEQS.SEQUENCE_OWNER";
    }

    public String getSelectGUIDString() {
        return "select GUID()";
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER_BOOLEAN: {
                String result = BooleanDecoder.toIntegerBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case BOOLEAN: 
            case TF_BOOLEAN: {
                String result = BooleanDecoder.toTrueFalseBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result = BooleanDecoder.toYesNoBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case DATE: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD')";
            }
            case TIME: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'HH24:MI:SS')";
            }
            case TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
            }
            case OFFSET_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
            }
            case ZONE_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
            }
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger((CastType)from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: 
                    case YN_BOOLEAN: 
                    case TF_BOOLEAN: {
                        return BooleanDecoder.toString((CastType)from);
                    }
                    case DATE: {
                        return "to_char(?1,'YYYY-MM-DD')";
                    }
                    case TIME: {
                        return "to_char(?1,'HH24:MI:SS')";
                    }
                    case TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                    }
                    case OFFSET_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                    }
                    case ZONE_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                    }
                }
            }
        }
        return super.castPattern(from, to);
    }

    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex != selectIndex ? 6 : 15);
    }

    public boolean supportsLockTimeouts() {
        return true;
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int timeout) {
        if (timeout == 0) {
            return " for update nowait";
        }
        if (timeout > 0) {
            float seconds = (float)timeout / 1000.0f;
            timeout = Math.round(seconds);
            return " for update wait " + timeout;
        }
        return " for update";
    }

    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return String.valueOf(this.getForUpdateString()) + " of " + aliases;
    }

    public String getForUpdateNowaitString() {
        return String.valueOf(this.getForUpdateString()) + " nowait";
    }

    public String getForUpdateNowaitString(String aliases) {
        return String.valueOf(this.getForUpdateString()) + " of " + aliases + " nowait";
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        if (this.dmdbtype_cursor == 0) {
            try {
                Class types = ReflectHelper.classForName((String)"dm.jdbc.driver.DmdbType");
                this.dmdbtype_cursor = types.getField("CURSOR").getInt(types.newInstance());
            }
            catch (Exception se) {
                throw new SQLException("Problem while trying to load or access DmdbType.CURSOR value", se);
            }
        }
        statement.registerOutParameter(col, this.dmdbtype_cursor);
        return ++col;
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        if (this.dmdbtype_cursor == 0) {
            try {
                Class types = ReflectHelper.classForName((String)"dm.jdbc.driver.DmdbType");
                this.dmdbtype_cursor = types.getField("CURSOR").getInt(types.newInstance());
            }
            catch (Exception se) {
                throw new SQLException("Problem while trying to load or access DmdbType.CURSOR value", se);
            }
        }
        statement.registerOutParameter(name, this.dmdbtype_cursor);
        return 1;
    }

    public ResultSet getResultSet(CallableStatement statement) throws SQLException {
        statement.execute();
        return (ResultSet)statement.getObject(1);
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp()";
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqlException)) {
                case 54: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 60: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 1013: {
                    throw new QueryTimeoutException(message, sqlException, sql);
                }
                case 1407: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                case 4020: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 4021: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 30006: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String transformSelectString(String select) {
        return select;
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public String getAddColumnString() {
        return " add column ";
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuffer res = new StringBuffer(30);
        res.append(" add constraint ").append(constraintName).append(" foreign key (").append(this.join(", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(this.join(", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String comment) {
        return "";
    }

    public String getColumnComment(String comment) {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return " cascade ";
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DmSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    public boolean supportsTupleCounts() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    private String join(String seperator, String[] strings) {
        int length = strings.length;
        if (length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(length * strings[0].length()).append(strings[0]);
        int i = 1;
        while (i < length) {
            buf.append(seperator).append(strings[i]);
            ++i;
        }
        return buf.toString();
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }
}

