/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.HSMessageLogger;
import org.hibernate.spatial.contributor.ContributorImplementor;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmGeographyJdbcType;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmGeometryJdbcType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.locationtech.jts.geom.Geometry;

public class DmDialectContributor
implements ContributorImplementor {
    private final ServiceRegistry serviceRegistry;
    private BasicType<?> spatialReturnType;
    private FunctionContributions functionContributions;
    private String geoModelType;

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    private void setGeoModelTypeFromSetting() {
        ConfigurationService configurationService = (ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class);
        this.geoModelType = (String)configurationService.getSetting("org.hibernate.spatial.dialect.geometry.model", String.class, (Object)"jts_geometry");
        if (this.geoModelType == null) {
            this.geoModelType = "jts_geometry";
        } else if (!this.geoModelType.equalsIgnoreCase("jts_geometry") && !this.geoModelType.equalsIgnoreCase("geolatte_geometry")) {
            this.geoModelType = "jts_geometry";
        }
    }

    public DmDialectContributor(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.functionContributions = null;
        this.geoModelType = null;
        this.setGeoModelTypeFromSetting();
    }

    private void registerReturnGeoFunction(String dialectName, String fullName, int minNumOfArgs, int maxNumOfArgs) {
        SqmFunctionRegistry functionRegistry = this.functionContributions.getFunctionRegistry();
        if (minNumOfArgs == maxNumOfArgs) {
            functionRegistry.register(dialectName, (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor(fullName, true, StandardArgumentsValidators.exactly((int)maxNumOfArgs), StandardFunctionReturnTypeResolvers.invariant(this.spatialReturnType)));
        } else {
            functionRegistry.register(dialectName, (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor(fullName, true, StandardArgumentsValidators.between((int)minNumOfArgs, (int)maxNumOfArgs), StandardFunctionReturnTypeResolvers.invariant(this.spatialReturnType)));
        }
    }

    private void registerFunction(String dialectName, String fullName, int minNumOfArgs, int maxNumOfArgs, BasicType<?> returnTypeResolver, FunctionKind functionKind, SqlAstNodeRenderingMode sqlAstNodeRenderingMode) {
        SqmFunctionRegistry functionRegistry = this.functionContributions.getFunctionRegistry();
        try {
            if (minNumOfArgs == maxNumOfArgs) {
                functionRegistry.register(dialectName, (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor(fullName, true, StandardArgumentsValidators.exactly((int)maxNumOfArgs), StandardFunctionReturnTypeResolvers.invariant(returnTypeResolver), null, fullName, functionKind, null, sqlAstNodeRenderingMode));
            } else {
                functionRegistry.register(dialectName, (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor(fullName, true, StandardArgumentsValidators.between((int)minNumOfArgs, (int)maxNumOfArgs), StandardFunctionReturnTypeResolvers.invariant(returnTypeResolver), null, fullName, functionKind, null, sqlAstNodeRenderingMode));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void contributeJdbcTypes(TypeContributions typeContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.typeContributions(this.getClass().getCanonicalName());
        this.contributeGeometryJdbcType(typeContributions);
        this.contributeGeographyJdbcType(typeContributions);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2002, "SYSGEO2.ST_Geometry", ((JdbcServices)this.serviceRegistry.getService(JdbcServices.class)).getDialect()));
    }

    public void contributeFunctions(FunctionContributions functionContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.functionContributions(this.getClass().getCanonicalName());
        this.functionContributions = functionContributions;
        TypeConfiguration typeConfiguration = this.functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        this.spatialReturnType = this.geoModelType.equals("geolatte_geometry") ? basicTypeRegistry.resolve(org.geolatte.geom.Geometry.class, 3200) : basicTypeRegistry.resolve(Geometry.class, 3200);
        this.registerSpatialFunctions();
    }

    protected void registerSpatialFunctions() {
        SqmFunctionRegistry functionRegistry = this.functionContributions.getFunctionRegistry();
        TypeConfiguration typeConfiguration = this.functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        functionRegistry.register("FIND_SRID", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.FIND_SRID", StandardBasicTypes.INTEGER));
        functionRegistry.register("ST_GeometryType", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_GeometryType", StandardBasicTypes.STRING));
        functionRegistry.register("GeometryType", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.GeometryType", StandardBasicTypes.STRING));
        functionRegistry.register("CoordDim", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_CoordDim", StandardBasicTypes.INTEGER));
        functionRegistry.register("Dimension", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Dimension", StandardBasicTypes.INTEGER));
        functionRegistry.register("HasArc", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_HasArc", StandardBasicTypes.INTEGER));
        functionRegistry.register("IsClosed", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsClosed", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsCollection", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsCollection", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsEmpty", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsEmpty", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsPolygonCCW", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsPolygonCCW", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsPolygonCW", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsPolygonCW", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsRing", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsRing", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsSimple", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsSimple", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("M", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_M", StandardBasicTypes.DOUBLE));
        functionRegistry.register("MemSize", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_MemSize", StandardBasicTypes.INTEGER));
        functionRegistry.register("NDims", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NDims", StandardBasicTypes.INTEGER));
        functionRegistry.register("NPoints", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NPoints", StandardBasicTypes.INTEGER));
        functionRegistry.register("NRings", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NRings", StandardBasicTypes.INTEGER));
        functionRegistry.register("NumGeometries", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NumGeometries", StandardBasicTypes.INTEGER));
        functionRegistry.register("NumInteriorRings", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NumInteriorRings", StandardBasicTypes.INTEGER));
        functionRegistry.register("NumInteriorRing", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NumInteriorRing", StandardBasicTypes.INTEGER));
        functionRegistry.register("NumPatches", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NumPatches", StandardBasicTypes.INTEGER));
        functionRegistry.register("NumPoints", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_NumPoints", StandardBasicTypes.INTEGER));
        functionRegistry.register("Summary", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Summary", StandardBasicTypes.STRING));
        functionRegistry.register("X", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_X", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Y", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Y", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Z", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Z", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Zmflag", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Zmflag", StandardBasicTypes.INTEGER));
        functionRegistry.register("GET_TYPE", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_GET_TYPE", StandardBasicTypes.INTEGER));
        functionRegistry.register("AsEWKT", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsEWKT", StandardBasicTypes.STRING));
        functionRegistry.register("AsText", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsText", StandardBasicTypes.STRING));
        functionRegistry.register("AsBinary", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsBinary", StandardBasicTypes.BINARY));
        functionRegistry.register("AsEWKB", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsEWKB", StandardBasicTypes.BINARY));
        functionRegistry.register("AsHexEWKB", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsHexEWKB", StandardBasicTypes.STRING));
        functionRegistry.register("AsEncodedPolyline", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsEncodedPolyline", StandardBasicTypes.STRING));
        functionRegistry.register("AsGeoJSON", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsGeoJSON", StandardBasicTypes.STRING));
        functionRegistry.register("AsGML", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsGML", StandardBasicTypes.STRING));
        functionRegistry.register("AsKML", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsKML", StandardBasicTypes.STRING));
        functionRegistry.register("AsLatLonText", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsLatLonText", StandardBasicTypes.STRING));
        functionRegistry.register("AsMARC21", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsMARC21", StandardBasicTypes.STRING));
        functionRegistry.register("AsSVG", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsSVG", StandardBasicTypes.STRING));
        functionRegistry.register("AsTWKB", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsTWKB", StandardBasicTypes.BINARY));
        functionRegistry.register("AsX3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_AsX3D", StandardBasicTypes.STRING));
        functionRegistry.register("GeoHash", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_GeoHash", StandardBasicTypes.STRING));
        functionRegistry.register("Intersects3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3Dintersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("GeomContains", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Contains", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("ContainsProperly", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_ContainsProperly", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("CoveredBy", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_CoveredBy", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Covers", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Covers", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Crosses", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Crosses", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("LineCrossingDirection", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_LineCrossingDirection", StandardBasicTypes.INTEGER));
        functionRegistry.register("Disjoint", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Disjoint", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Equals", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Equals", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Intersects", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Intersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("OrderingEquals", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_OrderingEquals", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("GeomOverlaps", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Overlaps", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Relate", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Relate", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("RelateMatch", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_RelateMatch", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Touches", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Touches", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("GeomWithin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Within", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("DWithin3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3DDWithin", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("DFullyWithin3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3DDFullyWithin", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("DFullyWithin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_DFullyWithin", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("DWithin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_DWithin", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("PointInsideCircle", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_PointInsideCircle", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Area", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Area", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Area2D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Area2D", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Azimuth", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Azimuth", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Angle", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Angle", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Distance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Distance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Distance3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3DDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("DistanceSphere", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_DistanceSphere", StandardBasicTypes.DOUBLE));
        functionRegistry.register("DistanceSpheroid", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_DistanceSpheroid", StandardBasicTypes.DOUBLE));
        functionRegistry.register("FrechetDistance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_FrechetDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("HausdorffDistance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_HausdorffDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("GeomLength", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Length", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Length2D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Length2D", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Length3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3DLength", StandardBasicTypes.DOUBLE));
        functionRegistry.register("LengthSpheroid", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_LengthSpheroid", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Length2DSpheroid", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Length2DSpheroid", StandardBasicTypes.DOUBLE));
        functionRegistry.register("MaxDistance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_MaxDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("MaxDistance3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3DMaxDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("MinimumClearance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_MinimumClearance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Perimeter", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Perimeter", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Perimeter2D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Perimeter2D", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Perimeter3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3DPerimeter", StandardBasicTypes.DOUBLE));
        functionRegistry.register("UNION_AGG", (SqmFunctionDescriptor)new StandardSQLFunction("ST_UNION_AGG", StandardBasicTypes.BINARY));
        functionRegistry.register("CENTROID_AGG", (SqmFunctionDescriptor)new StandardSQLFunction("ST_CENTROID_AGG", StandardBasicTypes.BINARY));
        functionRegistry.register("CONVEXHULL_AGG", (SqmFunctionDescriptor)new StandardSQLFunction("ST_CONVEXHULL_AGG", StandardBasicTypes.BINARY));
        functionRegistry.register("Extent", (SqmFunctionDescriptor)new StandardSQLFunction("ST_Extent", StandardBasicTypes.BINARY));
        functionRegistry.register("Extent3D", (SqmFunctionDescriptor)new StandardSQLFunction("ST_3DExtent", StandardBasicTypes.BINARY));
        functionRegistry.register("XMax", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_XMax", StandardBasicTypes.DOUBLE));
        functionRegistry.register("XMin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_XMin", StandardBasicTypes.DOUBLE));
        functionRegistry.register("YMax", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_YMax", StandardBasicTypes.DOUBLE));
        functionRegistry.register("YMin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_YMin", StandardBasicTypes.DOUBLE));
        functionRegistry.register("ZMax", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_ZMax", StandardBasicTypes.DOUBLE));
        functionRegistry.register("ZMin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_ZMin", StandardBasicTypes.DOUBLE));
        functionRegistry.register("BoxEquals", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_BoxEquals", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Distance2D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_2DDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Box2DDistance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Box2DDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("BoxnDDistance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_BoxnDDistance", StandardBasicTypes.DOUBLE));
        functionRegistry.register("Box2DIntersects", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Box2DIntersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("EnvIntersects", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_EnvIntersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Env2DIntersects", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Env2DIntersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("EnvnDIntersects", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_EnvnDIntersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("BoxnDIntersects", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_BoxnDIntersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("GeomLeft", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Left", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("GeomBelow", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Below", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("GeomRight", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Right", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("GeomAbove", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Above", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("StrictLeft", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_StrictLeft", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("StrictBelow", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_StrictBelow", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("StrictRight", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_StrictRight", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("StrictAbove", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_StrictAbove", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Accordance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Accordance", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("BoxContains", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_BoxContains", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("BoxWithin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_BoxWithin", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("MBR_AGG", (SqmFunctionDescriptor)new StandardSQLFunction("ST_MBR_AGG", StandardBasicTypes.BINARY));
        functionRegistry.register("LineLocatePoint", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_LineLocatePoint", StandardBasicTypes.DOUBLE));
        functionRegistry.register("InterpolatePoint", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_InterpolatePoint", StandardBasicTypes.DOUBLE));
        functionRegistry.register("IsValidTrajectory", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsValidTrajectory", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("ClosestPointOfApproach", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_ClosestPointOfApproach", StandardBasicTypes.DOUBLE));
        functionRegistry.register("DistanceCPA", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_DistanceCPA", StandardBasicTypes.DOUBLE));
        functionRegistry.register("CPAWithin", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_CPAWithin", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Area3D", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_3DArea", StandardBasicTypes.DOUBLE));
        functionRegistry.register("IsPlanar", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsPlanar", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsSolid", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsSolid", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("Orientation", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Orientation", StandardBasicTypes.INTEGER));
        functionRegistry.register("Volume", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_Volume", StandardBasicTypes.DOUBLE));
        functionRegistry.register("CONVERT_UNIT", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_CONVERT_UNIT", StandardBasicTypes.DOUBLE));
        functionRegistry.register("ST_COLLECT", (SqmFunctionDescriptor)new StandardSQLFunction("ST_COLLECT", StandardBasicTypes.BINARY));
        functionRegistry.register("Srid", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_SRID", StandardBasicTypes.INTEGER));
        functionRegistry.register("IsValid", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsValid", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("IsValidReason", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_IsValidReason", StandardBasicTypes.STRING));
        functionRegistry.register("Polygonize", (SqmFunctionDescriptor)new StandardSQLFunction("ST_Polygonize", StandardBasicTypes.BINARY));
        functionRegistry.register("HasBBox", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo2.ST_HasBBox", StandardBasicTypes.BOOLEAN));
        this.registerReturnGeoFunction("AddPoint", "dmgeo2.ST_AddPoint", 2, 3);
        this.registerReturnGeoFunction("CollectionExtract", "dmgeo2.ST_CollectionExtract", 1, 2);
        this.registerReturnGeoFunction("CollectionHomogenize", "dmgeo2.ST_CollectionHomogenize", 1, 1);
        this.registerReturnGeoFunction("CurveToLine", "dmgeo2.ST_CurveToLine", 2, 4);
        this.registerReturnGeoFunction("GeomScroll", "dmgeo2.ST_Scroll", 2, 2);
        this.registerReturnGeoFunction("FlipCoordinates", "dmgeo2.ST_FlipCoordinates", 1, 1);
        this.registerReturnGeoFunction("Force2D", "dmgeo2.ST_Force2D", 1, 1);
        this.registerReturnGeoFunction("Force3D", "dmgeo2.ST_Force3D", 1, 2);
        this.registerReturnGeoFunction("Force3DZ", "dmgeo2.ST_Force3DZ", 1, 2);
        this.registerReturnGeoFunction("Force3DM", "dmgeo2.ST_Force3DM", 1, 2);
        this.registerReturnGeoFunction("Force4D", "dmgeo2.ST_Force4D", 1, 3);
        this.registerReturnGeoFunction("ForcePolygonCCW", "dmgeo2.ST_ForcePolygonCCW", 1, 1);
        this.registerReturnGeoFunction("ForceCollection", "dmgeo2.ST_ForceCollection", 1, 1);
        this.registerReturnGeoFunction("ForcePolygonCW", "dmgeo2.ST_ForcePolygonCW", 1, 1);
        this.registerReturnGeoFunction("ForceSFS", "dmgeo2.ST_ForceSFS", 1, 2);
        this.registerReturnGeoFunction("ForceRHR", "dmgeo2.ST_ForceRHR", 1, 1);
        this.registerReturnGeoFunction("ForceCurve", "dmgeo2.ST_ForceCurve", 1, 1);
        this.registerReturnGeoFunction("LineToCurve", "dmgeo2.ST_LineToCurve", 1, 1);
        this.registerReturnGeoFunction("Multi", "dmgeo2.ST_Multi", 1, 1);
        this.registerReturnGeoFunction("Normalize", "dmgeo2.ST_Normalize", 1, 1);
        this.registerReturnGeoFunction("QuantizeCoordinates", "dmgeo2.ST_QuantizeCoordinates", 2, 5);
        this.registerReturnGeoFunction("RemovePoint", "dmgeo2.ST_RemovePoint", 2, 2);
        this.registerReturnGeoFunction("RemoveRepeatedPoints", "dmgeo2.ST_RemoveRepeatedPoints", 1, 2);
        this.registerReturnGeoFunction("GeomReverse", "dmgeo2.ST_Reverse", 1, 1);
        this.registerReturnGeoFunction("Segmentize", "dmgeo2.ST_Segmentize", 2, 2);
        this.registerReturnGeoFunction("SetPoint", "dmgeo2.ST_SetPoint", 3, 3);
        this.registerReturnGeoFunction("ShiftLongitude", "dmgeo2.ST_ShiftLongitude", 1, 1);
        this.registerReturnGeoFunction("WrapX", "dmgeo2.ST_WrapX", 3, 3);
        this.registerReturnGeoFunction("SnapToGrid", "dmgeo2.ST_SnapToGrid", 2, 6);
        this.registerReturnGeoFunction("Snap", "dmgeo2.ST_Snap", 3, 3);
        this.registerReturnGeoFunction("SwapOrdinates", "dmgeo2.ST_SwapOrdinates", 2, 2);
        this.registerReturnGeoFunction("ForcePolygon", "dmgeo2.ST_ForcePolygon", 1, 1);
        this.registerReturnGeoFunction("MakeValid", "dmgeo2.ST_MakeValid", 1, 2);
        this.registerReturnGeoFunction("CleanGeometry", "dmgeo2.ST_CleanGeometry", 1, 1);
        this.registerReturnGeoFunction("SetSRID", "dmgeo2.ST_SetSRID", 2, 2);
        this.registerReturnGeoFunction("Transform", "dmgeo2.ST_Transform", 2, 3);
        this.registerReturnGeoFunction("BdPolyFromText", "dmgeo2.ST_BdPolyFromText", 2, 2);
        this.registerReturnGeoFunction("BdMPolyFromText", "dmgeo2.ST_BdMPolyFromText", 2, 2);
        this.registerReturnGeoFunction("GeogFromText", "dmgeo2.ST_GeogFromText", 1, 1);
        this.registerReturnGeoFunction("GeographyFromText", "dmgeo2.ST_GeographyFromText", 1, 1);
        this.registerReturnGeoFunction("GeomCollFromText", "dmgeo2.ST_GeomCollFromText", 1, 2);
        this.registerReturnGeoFunction("GeomFromEWKT", "dmgeo2.ST_GeomFromEWKT", 1, 1);
        this.registerReturnGeoFunction("GeomFromMARC21", "dmgeo2.ST_GeomFromMARC21", 1, 1);
        this.registerReturnGeoFunction("GeometryFromText", "dmgeo2.ST_GeometryFromText", 1, 2);
        this.registerReturnGeoFunction("GeomFromText", "dmgeo2.ST_GeomFromText", 1, 2);
        this.registerReturnGeoFunction("LineFromText", "dmgeo2.ST_LineFromText", 1, 2);
        this.registerReturnGeoFunction("MultiLineStringFromText", "dmgeo2.ST_MultiLineStringFromText", 1, 2);
        this.registerReturnGeoFunction("MLineFromText", "dmgeo2.ST_MLineFromText", 1, 2);
        this.registerReturnGeoFunction("MultiPointFromText", "dmgeo2.ST_MultiPointFromText", 1, 2);
        this.registerReturnGeoFunction("MPointFromText", "dmgeo2.ST_MPointFromText", 1, 2);
        this.registerReturnGeoFunction("MultiPolygonFromText", "dmgeo2.ST_MultiPolygonFromText", 1, 2);
        this.registerReturnGeoFunction("MPolyFromText", "dmgeo2.ST_MPolyFromText", 1, 2);
        this.registerReturnGeoFunction("PointFromText", "dmgeo2.ST_PointFromText", 1, 2);
        this.registerReturnGeoFunction("PolygonFromText", "dmgeo2.ST_PolygonFromText", 1, 2);
        this.registerReturnGeoFunction("WKTToSQL", "dmgeo2.ST_WKTToSQL", 1, 1);
        this.registerReturnGeoFunction("GeogFromWKB", "dmgeo2.ST_GeogFromWKB", 1, 1);
        this.registerReturnGeoFunction("GeomFromEWKB", "dmgeo2.ST_GeomFromEWKB", 1, 1);
        this.registerReturnGeoFunction("GeomFromWKB", "dmgeo2.ST_GeomFromWKB", 1, 2);
        this.registerReturnGeoFunction("LineFromWKB", "dmgeo2.ST_LineFromWKB", 1, 2);
        this.registerReturnGeoFunction("LinestringFromWKB", "dmgeo2.ST_LinestringFromWKB", 1, 2);
        this.registerReturnGeoFunction("MultiLineFromWKB", "dmgeo2.ST_MultiLineFromWKB", 1, 2);
        this.registerReturnGeoFunction("PointFromWKB", "dmgeo2.ST_PointFromWKB", 1, 2);
        this.registerReturnGeoFunction("MultiPointFromWKB", "dmgeo2.ST_MultiPointFromWKB", 1, 2);
        this.registerReturnGeoFunction("PolygonFromWKB", "dmgeo2.ST_PolygonFromWKB", 1, 2);
        this.registerReturnGeoFunction("MultiPolyFromWKB", "dmgeo2.ST_MultiPolyFromWKB", 1, 2);
        this.registerReturnGeoFunction("GeomCollFromWKB", "dmgeo2.ST_GeomCollFromWKB", 1, 2);
        this.registerReturnGeoFunction("WKBToSQL", "dmgeo2.ST_WKBToSQL", 1, 1);
        this.registerReturnGeoFunction("GeomCollect", "dmgeo2.ST_Collect", 2, 2);
        this.registerReturnGeoFunction("LineFromMultiPoint", "dmgeo2.ST_LineFromMultiPoint", 1, 1);
        this.registerReturnGeoFunction("MakeEnvelope", "dmgeo2.ST_MakeEnvelope", 4, 5);
        this.registerReturnGeoFunction("MakeLine", "dmgeo2.ST_MakeLine", 2, 2);
        this.registerReturnGeoFunction("MakePoint", "dmgeo2.ST_MakePoint", 2, 4);
        this.registerReturnGeoFunction("MakePointM", "dmgeo2.ST_MakePointM", 3, 3);
        this.registerReturnGeoFunction("MakePolygon", "dmgeo2.ST_MakePolygon", 1, 1);
        this.registerReturnGeoFunction("Point", "dmgeo2.ST_Point", 2, 3);
        this.registerReturnGeoFunction("PointZ", "dmgeo2.ST_PointZ", 3, 4);
        this.registerReturnGeoFunction("PointM", "dmgeo2.ST_PointM", 3, 4);
        this.registerReturnGeoFunction("PointZM", "dmgeo2.ST_PointZM", 4, 5);
        this.registerReturnGeoFunction("Polygon", "dmgeo2.ST_Polygon", 2, 2);
        this.registerReturnGeoFunction("TileEnvelope", "dmgeo2.ST_TileEnvelope", 3, 5);
        this.registerReturnGeoFunction("Hexagon", "dmgeo2.ST_Hexagon", 3, 4);
        this.registerReturnGeoFunction("Square", "dmgeo2.ST_Square", 3, 4);
        this.registerReturnGeoFunction("CreateCircle", "dmgeo2.ST_CreateCircle", 2, 2);
        this.registerReturnGeoFunction("CreateArc", "dmgeo2.ST_CreateArc", 4, 4);
        this.registerReturnGeoFunction("CreateArcPolygon", "dmgeo2.ST_CreateArcPolygon", 4, 4);
        this.registerReturnGeoFunction("CreateAnnulus", "dmgeo2.ST_CreateAnnulus", 3, 3);
        this.registerReturnGeoFunction("CreateAnnularSector", "dmgeo2.ST_CreateAnnularSector", 5, 5);
        this.registerReturnGeoFunction("ELLIPSE_POLYGON", "dmgeo2.ST_ELLIPSE_POLYGON", 6, 6);
        this.registerReturnGeoFunction("CIRCLE_POLYGON", "dmgeo2.ST_CIRCLE_POLYGON", 4, 4);
        this.registerReturnGeoFunction("Boundary", "dmgeo2.ST_Boundary", 1, 1);
        this.registerReturnGeoFunction("BoundingDiagonal", "dmgeo2.ST_BoundingDiagonal", 1, 2);
        this.registerReturnGeoFunction("EndPoint", "dmgeo2.ST_EndPoint", 1, 1);
        this.registerReturnGeoFunction("Envelope", "dmgeo2.ST_Envelope", 1, 1);
        this.registerReturnGeoFunction("ExteriorRing", "dmgeo2.ST_ExteriorRing", 1, 1);
        this.registerReturnGeoFunction("GeometryN", "dmgeo2.ST_GeometryN", 2, 2);
        this.registerReturnGeoFunction("InteriorRingN", "dmgeo2.ST_InteriorRingN", 2, 2);
        this.registerReturnGeoFunction("PatchN", "dmgeo2.ST_PatchN", 2, 2);
        this.registerReturnGeoFunction("PointN", "dmgeo2.ST_PointN", 2, 2);
        this.registerReturnGeoFunction("Points", "dmgeo2.ST_Points", 1, 1);
        this.registerReturnGeoFunction("StartPoint", "dmgeo2.ST_StartPoint", 1, 1);
        this.registerReturnGeoFunction("GeomFromGeoHash", "dmgeo2.ST_GeomFromGeoHash", 1, 2);
        this.registerReturnGeoFunction("GeomFromGML", "dmgeo2.ST_GeomFromGML", 1, 2);
        this.registerReturnGeoFunction("GeomFromGeoJson", "dmgeo2.ST_GeomFromGeoJson", 1, 1);
        this.registerReturnGeoFunction("GeomFromKML", "dmgeo2.ST_GeomFromKML", 1, 1);
        this.registerReturnGeoFunction("GeomFromTWKB", "dmgeo2.ST_GeomFromTWKB", 1, 1);
        this.registerReturnGeoFunction("GMLToSQL", "dmgeo2.ST_GMLToSQL", 1, 2);
        this.registerReturnGeoFunction("LineFromEncodedPolyline", "dmgeo2.ST_LineFromEncodedPolyline", 1, 2);
        this.registerReturnGeoFunction("PointFromGeoHash", "dmgeo2.ST_PointFromGeoHash", 1, 2);
        this.registerReturnGeoFunction("AsMVTGeom", "dmgeo2.ST_AsMVTGeom", 2, 5);
        this.registerReturnGeoFunction("ClosestPoint", "dmgeo2.ST_ClosestPoint", 2, 2);
        this.registerReturnGeoFunction("ClosestPoint3D", "dmgeo2.ST_3DClosestPoint", 2, 2);
        this.registerReturnGeoFunction("LongestLine", "dmgeo2.ST_LongestLine", 2, 2);
        this.registerReturnGeoFunction("LongestLine3D", "dmgeo2.ST_3DLongestLine", 2, 2);
        this.registerReturnGeoFunction("MinimumClearanceLine", "dmgeo2.ST_MinimumClearanceLine", 1, 1);
        this.registerReturnGeoFunction("Project", "dmgeo2.ST_Project", 3, 3);
        this.registerReturnGeoFunction("ShortestLine", "dmgeo2.ST_ShortestLine", 2, 2);
        this.registerReturnGeoFunction("ShortestLine3D", "dmgeo2.ST_3DShortestLine", 2, 2);
        this.registerReturnGeoFunction("ClipByBox2D", "dmgeo2.ST_ClipByBox2D", 2, 2);
        this.registerReturnGeoFunction("GeomDifference", "dmgeo2.ST_Difference", 2, 3);
        this.registerReturnGeoFunction("Intersection", "dmgeo2.ST_Intersection", 2, 3);
        this.registerReturnGeoFunction("GeomNode", "dmgeo2.ST_Node", 1, 1);
        this.registerReturnGeoFunction("GeomSplit", "dmgeo2.ST_Split", 2, 2);
        this.registerReturnGeoFunction("SymDifference", "dmgeo2.ST_SymDifference", 2, 3);
        this.registerReturnGeoFunction("UnaryUnion", "dmgeo2.ST_UnaryUnion", 1, 2);
        this.registerReturnGeoFunction("SymMetricDifference", "dmgeo2.ST_SymMetricDifference", 2, 2);
        this.registerReturnGeoFunction("GeomUnion", "dmgeo2.ST_Union", 2, 3);
        this.registerReturnGeoFunction("Xor", "dmgeo2.ST_Xor", 2, 3);
        this.registerReturnGeoFunction("GeomBuffer", "dmgeo2.ST_Buffer", 2, 3);
        this.registerReturnGeoFunction("BuildArea", "dmgeo2.ST_BuildArea", 1, 1);
        this.registerReturnGeoFunction("Centroid", "dmgeo2.ST_Centroid", 1, 2);
        this.registerReturnGeoFunction("ConcaveHull", "dmgeo2.ST_ConcaveHull", 2, 3);
        this.registerReturnGeoFunction("ConvexHull", "dmgeo2.ST_ConvexHull", 1, 1);
        this.registerReturnGeoFunction("DelaunayTriangles", "dmgeo2.ST_DelaunayTriangles", 1, 3);
        this.registerReturnGeoFunction("FilterByM", "dmgeo2.ST_FilterByM", 2, 4);
        this.registerReturnGeoFunction("GeneratePoints", "dmgeo2.ST_GeneratePoints", 2, 3);
        this.registerReturnGeoFunction("GeometricMedian", "dmgeo2.ST_GeometricMedian", 1, 4);
        this.registerReturnGeoFunction("LineMerge", "dmgeo2.ST_LineMerge", 1, 1);
        this.registerReturnGeoFunction("MinimumBoundingCircle", "dmgeo2.ST_MinimumBoundingCircle", 1, 2);
        this.registerReturnGeoFunction("OrientedEnvelope", "dmgeo2.ST_OrientedEnvelope", 1, 1);
        this.registerReturnGeoFunction("OffsetCurve", "dmgeo2.ST_OffsetCurve", 2, 3);
        this.registerReturnGeoFunction("PointOnSurface", "dmgeo2.ST_PointOnSurface", 1, 1);
        this.registerReturnGeoFunction("ReducePrecision", "dmgeo2.ST_ReducePrecision", 2, 2);
        this.registerReturnGeoFunction("SharedPaths", "dmgeo2.ST_SharedPaths", 2, 2);
        this.registerReturnGeoFunction("Simplify", "dmgeo2.ST_Simplify", 2, 3);
        this.registerReturnGeoFunction("SimplifyPolygonHull", "dmgeo2.ST_SimplifyPolygonHull", 2, 3);
        this.registerReturnGeoFunction("SimplifyVW", "dmgeo2.ST_SimplifyVW", 2, 2);
        this.registerReturnGeoFunction("ChaikinSmoothing", "dmgeo2.ST_ChaikinSmoothing", 1, 3);
        this.registerReturnGeoFunction("SetEffectiveArea", "dmgeo2.ST_SetEffectiveArea", 1, 3);
        this.registerReturnGeoFunction("TriangulatePolygon", "dmgeo2.ST_TriangulatePolygon", 1, 1);
        this.registerReturnGeoFunction("VoronoiLines", "dmgeo2.ST_VoronoiLines", 1, 3);
        this.registerReturnGeoFunction("VoronoiPolygons", "dmgeo2.ST_VoronoiPolygons", 1, 3);
        this.registerReturnGeoFunction("Affine", "dmgeo2.ST_Affine", 7, 13);
        this.registerReturnGeoFunction("Rotate", "dmgeo2.ST_Rotate", 2, 4);
        this.registerReturnGeoFunction("RotateX", "dmgeo2.ST_RotateX", 2, 2);
        this.registerReturnGeoFunction("RotateY", "dmgeo2.ST_RotateY", 2, 2);
        this.registerReturnGeoFunction("RotateZ", "dmgeo2.ST_RotateZ", 2, 2);
        this.registerReturnGeoFunction("Scale", "dmgeo2.ST_Scale", 2, 4);
        this.registerReturnGeoFunction("GeomTranslate", "dmgeo2.ST_Translate", 3, 4);
        this.registerReturnGeoFunction("TransScale", "dmgeo2.ST_TransScale", 5, 5);
        this.registerReturnGeoFunction("BoxToGeom", "dmgeo2.ST_BoxToGeom", 1, 1);
        this.registerReturnGeoFunction("LineInterpolatePoint", "dmgeo2.ST_LineInterpolatePoint", 2, 2);
        this.registerReturnGeoFunction("LineInterpolatePoint3D", "dmgeo2.ST_3DLineInterpolatePoint", 2, 2);
        this.registerReturnGeoFunction("LineInterpolatePoints", "dmgeo2.ST_LineInterpolatePoints", 2, 3);
        this.registerReturnGeoFunction("LineSubstring", "dmgeo2.ST_LineSubstring", 3, 3);
        this.registerReturnGeoFunction("LocateAlong", "dmgeo2.ST_LocateAlong", 2, 3);
        this.registerReturnGeoFunction("LocateBetween", "dmgeo2.ST_LocateBetween", 3, 4);
        this.registerReturnGeoFunction("LocateBetweenElevations", "dmgeo2.ST_LocateBetweenElevations", 3, 3);
        this.registerReturnGeoFunction("AddMeasure", "dmgeo2.ST_AddMeasure", 3, 3);
        this.registerReturnGeoFunction("Intersection3D", "dmgeo2.ST_3DIntersection", 2, 2);
        this.registerReturnGeoFunction("Difference3D", "dmgeo2.ST_3DDifference", 2, 2);
        this.registerReturnGeoFunction("Union3D", "dmgeo2.ST_3DUnion", 2, 2);
        this.registerReturnGeoFunction("ApproximateMedialAxis", "dmgeo2.ST_ApproximateMedialAxis", 1, 1);
        this.registerReturnGeoFunction("ConstrainedDelaunayTriangles", "dmgeo2.ST_ConstrainedDelaunayTriangles", 1, 1);
        this.registerReturnGeoFunction("Extrude", "dmgeo2.ST_Extrude", 4, 4);
        this.registerReturnGeoFunction("ForceLHR", "dmgeo2.ST_ForceLHR", 1, 1);
        this.registerReturnGeoFunction("MakeSolid", "dmgeo2.ST_MakeSolid", 1, 1);
        this.registerReturnGeoFunction("MinkowskiSum", "dmgeo2.ST_MinkowskiSum", 2, 2);
        this.registerReturnGeoFunction("StraightSkeleton", "dmgeo2.ST_StraightSkeleton", 1, 1);
        this.registerReturnGeoFunction("Tesselate", "dmgeo2.ST_Tesselate", 1, 1);
        this.registerReturnGeoFunction("GeomToGeog", "dmgeo2.ST_GeomToGeog", 1, 1);
        this.registerReturnGeoFunction("GeogToGeom", "dmgeo2.ST_GeogToGeom", 1, 1);
        this.registerReturnGeoFunction("SELF_UNION", "dmgeo2.ST_SELF_UNION", 2, 2);
        this.registerReturnGeoFunction("GeomFromGserialized", "dmgeo2.ST_GeomFromGserialized", 1, 1);
        this.registerReturnGeoFunction("AddBBox", "dmgeo2.ST_AddBBox", 1, 1);
        this.registerReturnGeoFunction("DropBBox", "dmgeo2.ST_DropBBox", 1, 1);
        this.registerReturnGeoFunction("Expand", "dmgeo2.ST_Expand", 2, 5);
        this.registerReturnGeoFunction("CombineBBox", "dmgeo2.ST_CombineBBox", 2, 2);
        this.registerReturnGeoFunction("Box3D", "dmgeo2.Box3D", 1, 1);
        this.registerReturnGeoFunction("MakeBox3D", "dmgeo2.ST_3DMakeBox", 2, 2);
        this.registerReturnGeoFunction("Box2dFromGeoHash", "dmgeo2.ST_Box2dFromGeoHash", 1, 2);
        this.registerReturnGeoFunction("Box2D", "dmgeo2.Box2D", 1, 1);
        this.registerReturnGeoFunction("EstimatedExtent", "dmgeo2.ST_EstimatedExtent", 2, 3);
        this.registerReturnGeoFunction("FindExtent", "dmgeo2.ST_FindExtent", 2, 3);
        this.registerReturnGeoFunction("MakeBox2D", "dmgeo2.ST_MakeBox2D", 2, 2);
        BasicType returnIntResolver = basicTypeRegistry.resolve(Integer.class, 4);
        this.registerFunction("ClusterDBSCAN", "ST_ClusterDBSCAN", 3, 3, returnIntResolver, FunctionKind.WINDOW, SqlAstNodeRenderingMode.DEFAULT);
    }

    private void contributeGeometryJdbcType(TypeContributions typeContributions) {
        if (this.geoModelType == null || this.geoModelType.equalsIgnoreCase("jts_geometry")) {
            typeContributions.contributeJdbcType((JdbcType)DmGeometryJdbcType.GEOMETRY_CAST_JTS);
            typeContributions.contributeJdbcType((JdbcType)DmGeometryJdbcType.GEOMETRY_CAST_JTS_NATIVE);
        } else {
            typeContributions.contributeJdbcType((JdbcType)DmGeometryJdbcType.GEOMETRY_CAST_GEOLATTE);
            typeContributions.contributeJdbcType((JdbcType)DmGeometryJdbcType.GEOMETRY_CAST_GEOLATTE_NATIVE);
        }
    }

    private void contributeGeographyJdbcType(TypeContributions typeContributions) {
        if (this.geoModelType == null || this.geoModelType.equalsIgnoreCase("jts_geometry")) {
            typeContributions.contributeJdbcType((JdbcType)DmGeographyJdbcType.GEOGRAPHY_CAST_JTS);
        } else {
            typeContributions.contributeJdbcType((JdbcType)DmGeographyJdbcType.GEOGRAPHY_CAST_GEOLATTE);
        }
    }
}

