/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.HSMessageLogger;
import org.hibernate.spatial.contributor.ContributorImplementor;
import org.hibernate.spatial.dialect.dm.DmGeometryJdbcType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DmDialectContributor
implements ContributorImplementor {
    private final ServiceRegistry serviceRegistry;
    private BasicType<Object> objectType;

    public DmDialectContributor(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void contributeJdbcTypes(TypeContributions typeContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.typeContributions(this.getClass().getCanonicalName());
        typeContributions.contributeJdbcType((JdbcType)DmGeometryJdbcType.INSTANCE);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2002, "SYSGEO.st_geometry", ((JdbcServices)this.serviceRegistry.getService(JdbcServices.class)).getDialect()));
    }

    public void contributeFunctions(FunctionContributions functionContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.functionContributions(this.getClass().getCanonicalName());
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        this.objectType = basicTypeRegistry.resolve(Object.class, 2000);
        functionRegistry.register("dimension", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_dimension", StandardBasicTypes.INTEGER));
        functionRegistry.register("geometrytype", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_geometrytype", StandardBasicTypes.STRING));
        functionRegistry.register("srid", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_srid", StandardBasicTypes.INTEGER));
        functionRegistry.patternDescriptorBuilder("envelope", "dmgeo.ST_envelope(?1)").setInvariantType(this.objectType).setExactArgumentCount(1).register();
        functionRegistry.register("astext", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_astext", StandardBasicTypes.STRING));
        functionRegistry.register("asbinary", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_asbinary", StandardBasicTypes.BINARY));
        functionRegistry.register("isempty", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_isempty", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("issimple", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_issimple", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("boundary", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_boundary", null));
        functionRegistry.register("overlaps", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_overlaps", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("intersects", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_intersects", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("equals", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_equals", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("contains", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_contains", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("crosses", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_crosses", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("disjoint", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_disjoint", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("touches", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_touches", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("within", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_within", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("relate", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_relate", StandardBasicTypes.BOOLEAN));
        functionRegistry.register("distance", (SqmFunctionDescriptor)new StandardSQLFunction("dmgeo.ST_distance", StandardBasicTypes.DOUBLE));
        functionRegistry.patternDescriptorBuilder("buffer", "dmgeo.ST_buffer(?1, ?2)").setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.ANY, FunctionParameterType.NUMERIC}).setInvariantType(this.objectType).register();
        functionRegistry.patternDescriptorBuilder("convexhull", "dmgeo.ST_convexhull(?1)").setExactArgumentCount(1).setInvariantType(this.objectType).register();
        functionRegistry.patternDescriptorBuilder("difference", "dmgeo.ST_difference(?1, ?2)").setExactArgumentCount(2).setInvariantType(this.objectType).register();
        functionRegistry.patternDescriptorBuilder("intersection", "dmgeo.ST_intersection(?1, ?2)").setExactArgumentCount(2).setInvariantType(this.objectType).register();
        functionRegistry.patternDescriptorBuilder("symdifference", "dmgeo.ST_symdifference(?1, ?2)").setExactArgumentCount(2).setInvariantType(this.objectType).register();
        functionRegistry.patternDescriptorBuilder("geomunion", "dmgeo.ST_union(?1, ?2)").setExactArgumentCount(2).setInvariantType(this.objectType).register();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

