/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DmDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmGeometryTypeDescriptor;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DmSpatialDialect
extends DmDialect
implements SpatialDialect {
    private static final long serialVersionUID = -9174110675821610868L;
    private ServiceRegistry serviceRegistry;
    private String geoModelType;
    public static final String DM_SPATIAL_MODEL_PROPERTY_NAME = "org.hibernate.spatial.dialect.geometry.model";
    public static final String JTS_GEOMETRY = "jts_geometry";
    public static final String GEOLATTE_GEOMETRY = "geolatte_geometry";

    private DmGeometryTypeDescriptor mkDescriptor(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.setGeoModelTypeFromSetting();
        DmGeometryTypeDescriptor dmGeometryTypeDescriptor = new DmGeometryTypeDescriptor(this.geoModelType);
        this.registerTypesAndFunctions(dmGeometryTypeDescriptor);
        return dmGeometryTypeDescriptor;
    }

    private void setGeoModelTypeFromSetting() {
        if (this.serviceRegistry == null) {
            this.geoModelType = JTS_GEOMETRY;
            return;
        }
        ConfigurationService configurationService = (ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class);
        this.geoModelType = (String)configurationService.getSetting(DM_SPATIAL_MODEL_PROPERTY_NAME, String.class, (Object)JTS_GEOMETRY);
        if (this.geoModelType == null) {
            this.geoModelType = JTS_GEOMETRY;
        } else if (!this.geoModelType.equalsIgnoreCase(JTS_GEOMETRY) && !this.geoModelType.equalsIgnoreCase(GEOLATTE_GEOMETRY)) {
            this.geoModelType = JTS_GEOMETRY;
        }
    }

    protected void registerTypesAndFunctions(DmGeometryTypeDescriptor typeDescriptor) {
        Object returnGeometryType = this.geoModelType.equals(GEOLATTE_GEOMETRY) ? new GeolatteGeometryType((SqlTypeDescriptor)typeDescriptor) : new JTSGeometryType((SqlTypeDescriptor)typeDescriptor);
        this.registerHibernateType(2002, returnGeometryType.getName());
        this.registerColumnType(2002, "SYSGEO2.ST_Geometry");
        this.registerSpatialFunctions((Type)returnGeometryType);
    }

    protected void registerSpatialFunctions(Type returnGeometryType) {
        this.registerFunction("FIND_SRID", (SQLFunction)new StandardSQLFunction("dmgeo2.FIND_SRID", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("GeomCollect", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Collect", returnGeometryType));
        this.registerFunction("ST_COLLECT", (SQLFunction)new StandardSQLFunction("ST_COLLECT", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("LineFromMultiPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromMultiPoint", returnGeometryType));
        this.registerFunction("MakeEnvelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeEnvelope", returnGeometryType));
        this.registerFunction("MakeLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeLine", returnGeometryType));
        this.registerFunction("MakePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakePoint", returnGeometryType));
        this.registerFunction("MakePointM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakePointM", returnGeometryType));
        this.registerFunction("MakePolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakePolygon", returnGeometryType));
        this.registerFunction("Point", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Point", returnGeometryType));
        this.registerFunction("PointZ", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointZ", returnGeometryType));
        this.registerFunction("PointM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointM", returnGeometryType));
        this.registerFunction("PointZM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointZM", returnGeometryType));
        this.registerFunction("Polygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Polygon", returnGeometryType));
        this.registerFunction("TileEnvelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_TileEnvelope", returnGeometryType));
        this.registerFunction("Hexagon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Hexagon", returnGeometryType));
        this.registerFunction("Square", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Square", returnGeometryType));
        this.registerFunction("CreateCircle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateCircle", returnGeometryType));
        this.registerFunction("CreateArc", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateArc", returnGeometryType));
        this.registerFunction("CreateArcPolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateArcPolygon", returnGeometryType));
        this.registerFunction("CreateAnnulus", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateAnnulus", returnGeometryType));
        this.registerFunction("CreateAnnularSector", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CreateAnnularSector", returnGeometryType));
        this.registerFunction("ELLIPSE_POLYGON", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ELLIPSE_POLYGON", returnGeometryType));
        this.registerFunction("CIRCLE_POLYGON", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CIRCLE_POLYGON", returnGeometryType));
        this.registerFunction("ST_GeometryType", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometryType", (Type)StandardBasicTypes.STRING));
        this.registerFunction("GeometryType", (SQLFunction)new StandardSQLFunction("dmgeo2.GeometryType", (Type)StandardBasicTypes.STRING));
        this.registerFunction("Boundary", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Boundary", returnGeometryType));
        this.registerFunction("BoundingDiagonal", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoundingDiagonal", returnGeometryType));
        this.registerFunction("CoordDim", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CoordDim", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("Dimension", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Dimension", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("EndPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EndPoint", returnGeometryType));
        this.registerFunction("Envelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Envelope", returnGeometryType));
        this.registerFunction("ExteriorRing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ExteriorRing", returnGeometryType));
        this.registerFunction("GeometryN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometryN", returnGeometryType));
        this.registerFunction("HasArc", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_HasArc", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("InteriorRingN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_InteriorRingN", returnGeometryType));
        this.registerFunction("IsClosed", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsClosed", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsCollection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsCollection", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsEmpty", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsEmpty", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsPolygonCCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsPolygonCCW", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsPolygonCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsPolygonCW", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsRing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsRing", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsSimple", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsSimple", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("M", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_M", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("MemSize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MemSize", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NDims", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NDims", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NPoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NPoints", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NRings", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NRings", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumGeometries", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumGeometries", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumInteriorRings", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumInteriorRings", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumInteriorRing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumInteriorRing", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumPatches", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumPatches", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("NumPoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_NumPoints", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("PatchN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PatchN", returnGeometryType));
        this.registerFunction("PointN", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointN", returnGeometryType));
        this.registerFunction("Points", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Points", returnGeometryType));
        this.registerFunction("StartPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StartPoint", returnGeometryType));
        this.registerFunction("Summary", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Summary", (Type)StandardBasicTypes.STRING));
        this.registerFunction("X", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_X", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Y", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Y", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Z", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Z", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Zmflag", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Zmflag", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("GET_TYPE", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GET_TYPE", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("AddPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AddPoint", returnGeometryType));
        this.registerFunction("CollectionExtract", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CollectionExtract", returnGeometryType));
        this.registerFunction("CollectionHomogenize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CollectionHomogenize", returnGeometryType));
        this.registerFunction("CurveToLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CurveToLine", returnGeometryType));
        this.registerFunction("GeomScroll", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Scroll", returnGeometryType));
        this.registerFunction("FlipCoordinates", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FlipCoordinates", returnGeometryType));
        this.registerFunction("Force2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force2D", returnGeometryType));
        this.registerFunction("Force3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force3D", returnGeometryType));
        this.registerFunction("Force3DZ", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force3DZ", returnGeometryType));
        this.registerFunction("Force3DM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force3DM", returnGeometryType));
        this.registerFunction("Force4D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Force4D", returnGeometryType));
        this.registerFunction("ForcePolygonCCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForcePolygonCCW", returnGeometryType));
        this.registerFunction("ForceCollection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceCollection", returnGeometryType));
        this.registerFunction("ForcePolygonCW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForcePolygonCW", returnGeometryType));
        this.registerFunction("ForceSFS", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceSFS", returnGeometryType));
        this.registerFunction("ForceRHR", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceRHR", returnGeometryType));
        this.registerFunction("ForceCurve", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceCurve", returnGeometryType));
        this.registerFunction("LineToCurve", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineToCurve", returnGeometryType));
        this.registerFunction("Multi", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Multi", returnGeometryType));
        this.registerFunction("Normalize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Normalize", returnGeometryType));
        this.registerFunction("QuantizeCoordinates", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_QuantizeCoordinates", returnGeometryType));
        this.registerFunction("RemovePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RemovePoint", returnGeometryType));
        this.registerFunction("RemoveRepeatedPoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RemoveRepeatedPoints", returnGeometryType));
        this.registerFunction("GeomReverse", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Reverse", returnGeometryType));
        this.registerFunction("Segmentize", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Segmentize", returnGeometryType));
        this.registerFunction("SetPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SetPoint", returnGeometryType));
        this.registerFunction("ShiftLongitude", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ShiftLongitude", returnGeometryType));
        this.registerFunction("WrapX", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_WrapX", returnGeometryType));
        this.registerFunction("SnapToGrid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SnapToGrid", returnGeometryType));
        this.registerFunction("Snap", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Snap", returnGeometryType));
        this.registerFunction("SwapOrdinates", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SwapOrdinates", returnGeometryType));
        this.registerFunction("ForcePolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForcePolygon", returnGeometryType));
        this.registerFunction("IsValid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsValid", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsValidReason", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsValidReason", (Type)StandardBasicTypes.STRING));
        this.registerFunction("MakeValid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeValid", returnGeometryType));
        this.registerFunction("CleanGeometry", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CleanGeometry", returnGeometryType));
        this.registerFunction("SetSRID", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SetSRID", returnGeometryType));
        this.registerFunction("Srid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SRID", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("Transform", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Transform", returnGeometryType));
        this.registerFunction("BdPolyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BdPolyFromText", returnGeometryType));
        this.registerFunction("BdMPolyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BdMPolyFromText", returnGeometryType));
        this.registerFunction("GeogFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeogFromText", returnGeometryType));
        this.registerFunction("GeographyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeographyFromText", returnGeometryType));
        this.registerFunction("GeomCollFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomCollFromText", returnGeometryType));
        this.registerFunction("GeomFromEWKT", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromEWKT", returnGeometryType));
        this.registerFunction("GeomFromMARC21", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromMARC21", returnGeometryType));
        this.registerFunction("GeometryFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometryFromText", returnGeometryType));
        this.registerFunction("GeomFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromText", returnGeometryType));
        this.registerFunction("LineFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromText", returnGeometryType));
        this.registerFunction("MultiLineStringFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiLineStringFromText", returnGeometryType));
        this.registerFunction("MLineFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MLineFromText", returnGeometryType));
        this.registerFunction("MultiPointFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPointFromText", returnGeometryType));
        this.registerFunction("MPointFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MPointFromText", returnGeometryType));
        this.registerFunction("MultiPolygonFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPolygonFromText", returnGeometryType));
        this.registerFunction("MPolyFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MPolyFromText", returnGeometryType));
        this.registerFunction("PointFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointFromText", returnGeometryType));
        this.registerFunction("PolygonFromText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PolygonFromText", returnGeometryType));
        this.registerFunction("WKTToSQL", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_WKTToSQL", returnGeometryType));
        this.registerFunction("GeogFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeogFromWKB", returnGeometryType));
        this.registerFunction("GeomFromEWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromEWKB", returnGeometryType));
        this.registerFunction("GeomFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromWKB", returnGeometryType));
        this.registerFunction("LineFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromWKB", returnGeometryType));
        this.registerFunction("LinestringFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LinestringFromWKB", returnGeometryType));
        this.registerFunction("MultiLineFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiLineFromWKB", returnGeometryType));
        this.registerFunction("PointFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointFromWKB", returnGeometryType));
        this.registerFunction("MultiPointFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPointFromWKB", returnGeometryType));
        this.registerFunction("PolygonFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PolygonFromWKB", returnGeometryType));
        this.registerFunction("MultiPolyFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MultiPolyFromWKB", returnGeometryType));
        this.registerFunction("GeomCollFromWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomCollFromWKB", returnGeometryType));
        this.registerFunction("WKBToSQL", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_WKBToSQL", returnGeometryType));
        this.registerFunction("Box2dFromGeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Box2dFromGeoHash", returnGeometryType));
        this.registerFunction("GeomFromGeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromGeoHash", returnGeometryType));
        this.registerFunction("GeomFromGML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromGML", returnGeometryType));
        this.registerFunction("GeomFromGeoJson", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromGeoJson", returnGeometryType));
        this.registerFunction("GeomFromKML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromKML", returnGeometryType));
        this.registerFunction("GeomFromTWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromTWKB", returnGeometryType));
        this.registerFunction("GMLToSQL", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GMLToSQL", returnGeometryType));
        this.registerFunction("LineFromEncodedPolyline", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineFromEncodedPolyline", returnGeometryType));
        this.registerFunction("PointFromGeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointFromGeoHash", returnGeometryType));
        this.registerFunction("AsEWKT", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsEWKT", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsText", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsBinary", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsBinary", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("AsEWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsEWKB", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("AsHexEWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsHexEWKB", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsEncodedPolyline", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsEncodedPolyline", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsGeoJSON", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsGeoJSON", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsGML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsGML", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsKML", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsKML", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsLatLonText", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsLatLonText", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsMARC21", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsMARC21", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsMVTGeom", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsMVTGeom", returnGeometryType));
        this.registerFunction("AsSVG", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsSVG", (Type)StandardBasicTypes.STRING));
        this.registerFunction("AsTWKB", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsTWKB", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("AsX3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AsX3D", (Type)StandardBasicTypes.STRING));
        this.registerFunction("GeoHash", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeoHash", (Type)StandardBasicTypes.STRING));
        this.registerFunction("Intersects3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3Dintersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("GeomContains", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Contains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("ContainsProperly", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ContainsProperly", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("CoveredBy", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CoveredBy", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Covers", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Covers", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Crosses", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Crosses", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("LineCrossingDirection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineCrossingDirection", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("Disjoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Disjoint", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Equals", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Equals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Intersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Intersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("OrderingEquals", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_OrderingEquals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("GeomOverlaps", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Overlaps", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Relate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Relate", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("RelateMatch", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RelateMatch", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Touches", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Touches", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("GeomWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Within", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("DWithin3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("DFullyWithin3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDFullyWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("DFullyWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DFullyWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("DWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("PointInsideCircle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointInsideCircle", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Area", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Area", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Area2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Area2D", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Azimuth", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Azimuth", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Angle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Angle", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ClosestPoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClosestPoint", returnGeometryType));
        this.registerFunction("ClosestPoint3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DClosestPoint", returnGeometryType));
        this.registerFunction("Distance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Distance3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("DistanceSphere", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DistanceSphere", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("DistanceSpheroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DistanceSpheroid", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("FrechetDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FrechetDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("HausdorffDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_HausdorffDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("GeomLength", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Length", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Length2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Length2D", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Length3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DLength", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LengthSpheroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LengthSpheroid", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Length2DSpheroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Length2DSpheroid", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LongestLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LongestLine", returnGeometryType));
        this.registerFunction("LongestLine3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DLongestLine", returnGeometryType));
        this.registerFunction("MaxDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MaxDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("MaxDistance3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DMaxDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("MinimumClearance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinimumClearance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("MinimumClearanceLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinimumClearanceLine", returnGeometryType));
        this.registerFunction("Perimeter", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Perimeter", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Perimeter2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Perimeter2D", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Perimeter3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DPerimeter", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Project", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Project", returnGeometryType));
        this.registerFunction("ShortestLine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ShortestLine", returnGeometryType));
        this.registerFunction("ShortestLine3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DShortestLine", returnGeometryType));
        this.registerFunction("ClipByBox2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClipByBox2D", returnGeometryType));
        this.registerFunction("GeomDifference", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Difference", returnGeometryType));
        this.registerFunction("Intersection", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Intersection", returnGeometryType));
        this.registerFunction("GeomNode", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Node", returnGeometryType));
        this.registerFunction("GeomSplit", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Split", returnGeometryType));
        this.registerFunction("SymDifference", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SymDifference", returnGeometryType));
        this.registerFunction("UnaryUnion", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_UnaryUnion", returnGeometryType));
        this.registerFunction("SymMetricDifference", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SymMetricDifference", returnGeometryType));
        this.registerFunction("GeomUnion", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Union", returnGeometryType));
        this.registerFunction("Xor", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Xor", returnGeometryType));
        this.registerFunction("UNION_AGG", (SQLFunction)new StandardSQLFunction("ST_UNION_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("CombineBBox", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CombineBBox", returnGeometryType));
        this.registerFunction("GeomBuffer", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Buffer", returnGeometryType));
        this.registerFunction("BuildArea", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BuildArea", returnGeometryType));
        this.registerFunction("Centroid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Centroid", returnGeometryType));
        this.registerFunction("ConcaveHull", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ConcaveHull", returnGeometryType));
        this.registerFunction("ConvexHull", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ConvexHull", returnGeometryType));
        this.registerFunction("DelaunayTriangles", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DelaunayTriangles", returnGeometryType));
        this.registerFunction("FilterByM", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FilterByM", returnGeometryType));
        this.registerFunction("GeneratePoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeneratePoints", returnGeometryType));
        this.registerFunction("GeometricMedian", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeometricMedian", returnGeometryType));
        this.registerFunction("LineMerge", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineMerge", returnGeometryType));
        this.registerFunction("MinimumBoundingCircle", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinimumBoundingCircle", returnGeometryType));
        this.registerFunction("OrientedEnvelope", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_OrientedEnvelope", returnGeometryType));
        this.registerFunction("OffsetCurve", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_OffsetCurve", returnGeometryType));
        this.registerFunction("PointOnSurface", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_PointOnSurface", returnGeometryType));
        this.registerFunction("Polygonize", (SQLFunction)new StandardSQLFunction("ST_Polygonize", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("ReducePrecision", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ReducePrecision", returnGeometryType));
        this.registerFunction("SharedPaths", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SharedPaths", returnGeometryType));
        this.registerFunction("Simplify", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Simplify", returnGeometryType));
        this.registerFunction("SimplifyPolygonHull", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SimplifyPolygonHull", returnGeometryType));
        this.registerFunction("SimplifyVW", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SimplifyVW", returnGeometryType));
        this.registerFunction("ChaikinSmoothing", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ChaikinSmoothing", returnGeometryType));
        this.registerFunction("SetEffectiveArea", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SetEffectiveArea", returnGeometryType));
        this.registerFunction("TriangulatePolygon", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_TriangulatePolygon", returnGeometryType));
        this.registerFunction("VoronoiLines", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_VoronoiLines", returnGeometryType));
        this.registerFunction("VoronoiPolygons", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_VoronoiPolygons", returnGeometryType));
        this.registerFunction("CENTROID_AGG", (SQLFunction)new StandardSQLFunction("ST_CENTROID_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("CONVEXHULL_AGG", (SQLFunction)new StandardSQLFunction("ST_CONVEXHULL_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("Affine", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Affine", returnGeometryType));
        this.registerFunction("Rotate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Rotate", returnGeometryType));
        this.registerFunction("RotateX", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RotateX", returnGeometryType));
        this.registerFunction("RotateY", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RotateY", returnGeometryType));
        this.registerFunction("RotateZ", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_RotateZ", returnGeometryType));
        this.registerFunction("Scale", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Scale", returnGeometryType));
        this.registerFunction("GeomTranslate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Translate", returnGeometryType));
        this.registerFunction("TransScale", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_TransScale", returnGeometryType));
        this.registerFunction("Box2D", (SQLFunction)new StandardSQLFunction("dmgeo2.Box2D", returnGeometryType));
        this.registerFunction("Box3D", (SQLFunction)new StandardSQLFunction("dmgeo2.Box3D", returnGeometryType));
        this.registerFunction("EstimatedExtent", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EstimatedExtent", returnGeometryType));
        this.registerFunction("Expand", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Expand", returnGeometryType));
        this.registerFunction("Extent", (SQLFunction)new StandardSQLFunction("ST_Extent", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("Extent3D", (SQLFunction)new StandardSQLFunction("ST_3DExtent", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("FindExtent", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_FindExtent", returnGeometryType));
        this.registerFunction("MakeBox2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeBox2D", returnGeometryType));
        this.registerFunction("MakeBox3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DMakeBox", returnGeometryType));
        this.registerFunction("XMax", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_XMax", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("XMin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_XMin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("YMax", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_YMax", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("YMin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_YMin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ZMax", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ZMax", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ZMin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ZMin", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("BoxEquals", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxEquals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Distance2D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_2DDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Box2DDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Box2DDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("BoxnDDistance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxnDDistance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Box2DIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Box2DIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("EnvIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EnvIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Env2DIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Env2DIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("EnvnDIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_EnvnDIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxnDIntersects", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxnDIntersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("GeomLeft", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Left", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("GeomBelow", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Below", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("GeomRight", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Right", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("GeomAbove", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Above", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictLeft", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictLeft", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictBelow", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictBelow", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictRight", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictRight", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("StrictAbove", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StrictAbove", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Accordance", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Accordance", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxContains", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxContains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("BoxToGeom", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_BoxToGeom", returnGeometryType));
        this.registerFunction("MBR_AGG", (SQLFunction)new StandardSQLFunction("ST_MBR_AGG", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("LineInterpolatePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineInterpolatePoint", returnGeometryType));
        this.registerFunction("LineInterpolatePoint3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DLineInterpolatePoint", returnGeometryType));
        this.registerFunction("LineInterpolatePoints", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineInterpolatePoints", returnGeometryType));
        this.registerFunction("LineLocatePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineLocatePoint", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LineSubstring", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LineSubstring", returnGeometryType));
        this.registerFunction("LocateAlong", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LocateAlong", returnGeometryType));
        this.registerFunction("LocateBetween", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LocateBetween", returnGeometryType));
        this.registerFunction("LocateBetweenElevations", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_LocateBetweenElevations", returnGeometryType));
        this.registerFunction("InterpolatePoint", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_InterpolatePoint", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("AddMeasure", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AddMeasure", returnGeometryType));
        this.registerFunction("IsValidTrajectory", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsValidTrajectory", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("ClosestPointOfApproach", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ClosestPointOfApproach", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("DistanceCPA", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DistanceCPA", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("CPAWithin", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CPAWithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("Area3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DArea", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("Intersection3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DIntersection", returnGeometryType));
        this.registerFunction("Difference3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DDifference", returnGeometryType));
        this.registerFunction("Union3D", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_3DUnion", returnGeometryType));
        this.registerFunction("ApproximateMedialAxis", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ApproximateMedialAxis", returnGeometryType));
        this.registerFunction("ConstrainedDelaunayTriangles", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ConstrainedDelaunayTriangles", returnGeometryType));
        this.registerFunction("Extrude", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Extrude", returnGeometryType));
        this.registerFunction("ForceLHR", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_ForceLHR", returnGeometryType));
        this.registerFunction("IsPlanar", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsPlanar", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IsSolid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_IsSolid", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("MakeSolid", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MakeSolid", returnGeometryType));
        this.registerFunction("MinkowskiSum", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_MinkowskiSum", returnGeometryType));
        this.registerFunction("Orientation", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Orientation", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("StraightSkeleton", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_StraightSkeleton", returnGeometryType));
        this.registerFunction("Tesselate", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Tesselate", returnGeometryType));
        this.registerFunction("Volume", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_Volume", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("CONVERT_UNIT", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_CONVERT_UNIT", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("GeomToGeog", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomToGeog", returnGeometryType));
        this.registerFunction("GeogToGeom", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeogToGeom", returnGeometryType));
        this.registerFunction("SELF_UNION", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_SELF_UNION", returnGeometryType));
        this.registerFunction("GeomFromGserialized", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_GeomFromGserialized", returnGeometryType));
        this.registerFunction("AddBBox", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_AddBBox", returnGeometryType));
        this.registerFunction("DropBBox", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_DropBBox", returnGeometryType));
        this.registerFunction("HasBBox", (SQLFunction)new StandardSQLFunction("dmgeo2.ST_HasBBox", (Type)StandardBasicTypes.BOOLEAN));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        DmGeometryTypeDescriptor typeDescriptor = this.mkDescriptor(serviceRegistry);
        typeContributions.contributeType((BasicType)new GeolatteGeometryType((SqlTypeDescriptor)typeDescriptor));
        typeContributions.contributeType((BasicType)new JTSGeometryType((SqlTypeDescriptor)typeDescriptor));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    public String getDWithinSQL(String columnName) {
        return "( dmgeo2.ST_DWithin(" + columnName + ",?,?) = ?)";
    }

    public String getGeogDWithinSQL(String columnName) {
        return "( dmgeo2.ST_DWithin(" + columnName + ",?,?,?) = ?)";
    }

    public String getHavingSridSQL(String columnName) {
        return "( dmgeo2.ST_Srid(" + columnName + ") = ?)";
    }

    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " dmgeo2.ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            case 1: {
                StringBuilder stbuf = new StringBuilder();
                stbuf.append("ST_Extent(").append(columnName).append(")");
                return stbuf.toString();
            }
        }
        throw new IllegalArgumentException("Aggregation of type " + aggregation + " are not supported by this dialect");
    }

    public String getSpatialFilterExpression(String columnName) {
        return "dmgeo2.ST_Intersects(" + columnName + ", ?)";
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        StringBuffer sql = new StringBuffer("dmgeo2.");
        switch (spatialRelation) {
            case 6: {
                sql.append("ST_Contains");
                break;
            }
            case 3: {
                sql.append("ST_Crosses");
                break;
            }
            case 1: {
                sql.append("ST_Disjoint");
                break;
            }
            case 0: {
                sql.append("ST_Equals");
                break;
            }
            case 7: {
                sql.append("ST_Intersects");
                break;
            }
            case 5: {
                sql.append("ST_Overlaps");
                break;
            }
            case 2: {
                sql.append("ST_Touches");
                break;
            }
            case 4: {
                sql.append("ST_Within");
                break;
            }
            default: {
                throw new IllegalArgumentException("Spatial relation is not known by this dialect");
            }
        }
        sql.append("(").append(columnName).append(", ?) ");
        return sql.toString();
    }

    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }

    public boolean supportsFiltering() {
        return true;
    }
}

