/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DmDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.dm.DmGeometryTypeDescriptor;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DmSpatialDialect
extends DmDialect
implements SpatialDialect {
    private static final long serialVersionUID = 1L;

    public DmSpatialDialect() {
        this.registerTypesAndFunctions();
    }

    private DmGeometryTypeDescriptor mkDescriptor(ServiceRegistry serviceRegistry) {
        return new DmGeometryTypeDescriptor();
    }

    protected void registerTypesAndFunctions() {
        this.registerColumnType(2002, "SYSGEO.st_geometry");
        this.registerFunction("dimension", (SQLFunction)new StandardSQLFunction("dmgeo.ST_dimension", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("dmgeo.ST_geometrytype", (Type)StandardBasicTypes.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("dmgeo.ST_srid", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("dmgeo.ST_envelope", null));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("dmgeo.ST_astext", (Type)StandardBasicTypes.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("dmgeo.ST_asbinary", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("isempty", (SQLFunction)new StandardSQLFunction("dmgeo.ST_isempty", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("issimple", (SQLFunction)new StandardSQLFunction("dmgeo.ST_issimple", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("boundary", (SQLFunction)new StandardSQLFunction("dmgeo.ST_boundary", null));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("dmgeo.ST_overlaps", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("dmgeo.ST_intersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("dmgeo.ST_equals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("dmgeo.ST_contains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("dmgeo.ST_crosses", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("dmgeo.ST_disjoint", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("dmgeo.ST_touches", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("dmgeo.ST_within", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("relate", (SQLFunction)new StandardSQLFunction("dmgeo.ST_relate", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("distance", (SQLFunction)new StandardSQLFunction("dmgeo.ST_distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("dmgeo.ST_buffer", null));
        this.registerFunction("convexhull", (SQLFunction)new StandardSQLFunction("dmgeo.ST_convexhull", null));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("dmgeo.ST_difference", null));
        this.registerFunction("intersection", (SQLFunction)new StandardSQLFunction("dmgeo.ST_intersection", null));
        this.registerFunction("symdifference", (SQLFunction)new StandardSQLFunction("dmgeo.ST_symdifference", null));
        this.registerFunction("geomunion", (SQLFunction)new StandardSQLFunction("dmgeo.ST_union", null));
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        DmGeometryTypeDescriptor typeDescriptor = this.mkDescriptor(serviceRegistry);
        typeContributions.contributeType((BasicType)new GeolatteGeometryType((SqlTypeDescriptor)typeDescriptor));
        typeContributions.contributeType((BasicType)new JTSGeometryType((SqlTypeDescriptor)typeDescriptor));
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    public String getDWithinSQL(String columnName) {
        throw new UnsupportedOperationException(String.format("Dameng doesn't support the Dwithin function", new Object[0]));
    }

    public String getHavingSridSQL(String columnName) {
        return "( DMGEO.ST_srid(" + columnName + ") = ?)";
    }

    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " DMGEO.ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            case 1: {
                StringBuilder stbuf = new StringBuilder();
                stbuf.append("extent(").append(columnName).append(")");
                return stbuf.toString();
            }
        }
        throw new IllegalArgumentException("Aggregation of type " + aggregation + " are not supported by this dialect");
    }

    public String getSpatialFilterExpression(String columnName) {
        return "dmgeo.ST_intersects(" + columnName + ", ?)";
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        StringBuffer sql = new StringBuffer("DMGEO.");
        switch (spatialRelation) {
            case 6: {
                sql.append("ST_CONTAINS");
                break;
            }
            case 3: {
                sql.append("ST_CROSSES");
                break;
            }
            case 1: {
                sql.append("ST_DISJOINT");
                break;
            }
            case 0: {
                sql.append("ST_EQUALS");
                break;
            }
            case 7: {
                sql.append("ST_INTERSECTS");
                break;
            }
            case 5: {
                sql.append("ST_OVERLAPS");
                break;
            }
            case 2: {
                sql.append("ST_TOUCHES");
                break;
            }
            case 4: {
                sql.append("ST_WITHIN");
                break;
            }
            default: {
                throw new IllegalArgumentException("Spatial relation is not known by this dialect");
            }
        }
        sql.append("(").append(columnName).append(", ?) ");
        return sql.toString();
    }

    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }

    public boolean supportsFiltering() {
        return true;
    }
}

