/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.SQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.type.Type;

public class DmDialect
extends Dialect {
    public DmDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "text");
        this.registerColumnType(2005, "clob");
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("cosh", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("pi", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("rand", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("sinh", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("tanh", (SQLFunction)new StandardSQLFunction((Type)Hibernate.DOUBLE));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("truncate", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("bit_length", (SQLFunction)new StandardSQLFunction((Type)Hibernate.LONG));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction((Type)Hibernate.CHARACTER));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction((Type)Hibernate.LONG));
        this.registerFunction("character_length", (SQLFunction)new StandardSQLFunction((Type)Hibernate.LONG));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction((Type)Hibernate.CHARACTER));
        this.registerFunction("concat", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("insstr", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction((Type)Hibernate.LONG));
        this.registerFunction("instrb", (SQLFunction)new StandardSQLFunction((Type)Hibernate.LONG));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("leftstr", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction((Type)Hibernate.LONG));
        this.registerFunction("locate", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("position", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("repeatstr", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("reverse", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("rightstr", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("substrb", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("trim", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("add_days", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("add_months", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("add_weeks", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("curdate", (SQLFunction)new NoArgStandardSQLFunction((Type)Hibernate.DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgStandardSQLFunction((Type)Hibernate.TIME));
        this.registerFunction("current_date", (SQLFunction)new NoArgStandardSQLFunction((Type)Hibernate.DATE));
        this.registerFunction("current_time", (SQLFunction)new NoArgStandardSQLFunction((Type)Hibernate.TIME));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgStandardSQLFunction((Type)Hibernate.TIMESTAMP));
        this.registerFunction("dateadd", (SQLFunction)new NoArgStandardSQLFunction((Type)Hibernate.TIMESTAMP));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("datepart", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("days_between", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("extract", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("getdate", (SQLFunction)new StandardSQLFunction((Type)Hibernate.TIMESTAMP));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("last_day", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("months_between", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("next_day", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("timestampadd", (SQLFunction)new StandardSQLFunction((Type)Hibernate.TIMESTAMP));
        this.registerFunction("timestampdiff", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("sysdate", (SQLFunction)new StandardSQLFunction((Type)Hibernate.TIME));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("weekday", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("weeks_between", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("years_between", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("ifnull", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("nullif", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("cast", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("decode", (SQLFunction)new StandardSQLFunction());
        this.registerFunction("page", (SQLFunction)new StandardSQLFunction((Type)Hibernate.INTEGER));
        this.registerFunction("user", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.registerFunction("tabledef", (SQLFunction)new StandardSQLFunction((Type)Hibernate.STRING));
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String getIdentitySelectString() throws MappingException {
        return "select scope_identity()";
    }

    public String appendIdentitySelectToInsert(String s) {
        return String.valueOf(s) + " select scope_identity()";
    }

    public String getIdentityColumnString() throws MappingException {
        return "identity not null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String s) throws MappingException {
        return "select " + s + ".nextval";
    }

    public String getCreateSequenceString(String s) throws MappingException {
        return "create sequence " + s;
    }

    public String getDropSequenceString(String s) throws MappingException {
        return "drop sequence " + s;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsVariableLimit() {
        return true;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public String getLimitString(String s, boolean flag) {
        return new StringBuffer(s.length() + 24).append(s).append(flag ? " limit ? offset ? " : " limit ? ").toString();
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    class NoArgStandardSQLFunction
    extends StandardSQLFunction {
        public boolean hasArguments() {
            return false;
        }

        public boolean hasParenthesesIfNoArguments() {
            return false;
        }

        public NoArgStandardSQLFunction() {
        }

        public NoArgStandardSQLFunction(Type type) {
            super(type);
        }
    }
}

