/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;

public class DmDialect
extends Dialect {
    public DmDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "text");
        this.registerColumnType(2005, "clob");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String getIdentitySelectString() throws MappingException {
        return "select scope_identity()";
    }

    public String appendIdentitySelectToInsert(String s) {
        return String.valueOf(s) + " select scope_identity()";
    }

    public String getIdentityColumnString() throws MappingException {
        return "identity not null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String s) throws MappingException {
        return "select " + s + ".nextval";
    }

    public String getCreateSequenceString(String s) throws MappingException {
        return "create sequence " + s;
    }

    public String getDropSequenceString(String s) throws MappingException {
        return "drop sequence " + s;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    private int getAfterSelectInsertPoint(String s) {
        int i = s.toLowerCase().indexOf("select");
        int j = s.toLowerCase().indexOf("select distinct");
        return i + (j == i ? 15 : 6);
    }

    public String getLimitString(String s, boolean flag) {
        return new StringBuffer(s.length() + 8).append(s).insert(this.getAfterSelectInsertPoint(s), flag ? " top ?, ? " : " top ? ").toString();
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }
}

