/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
 * Description: DesignWare kunpeng libmath interface definition.
 * Author:
 * Create: 2020-08-28
 */

#ifndef KML_LIBM_L9_H
#define KML_LIBM_L9_H
#include <stdint.h>
#ifdef __cplusplus
extern "C" {
#endif
#ifndef complex
#define complex _Complex
#endif
#ifndef _Complex_I
#define _Complex_I (__extension__ 1.0iF)
#endif
#undef I
#define I _Complex_I

#define KM_VERSION_STRUCT_LEN 100
typedef struct {
    char productName[KM_VERSION_STRUCT_LEN];
    char productVersion[KM_VERSION_STRUCT_LEN];
    char componentName[KM_VERSION_STRUCT_LEN];
    char componentVersion[KM_VERSION_STRUCT_LEN];
    char componentAppendInfo[KM_VERSION_STRUCT_LEN];
    char softwareName[KM_VERSION_STRUCT_LEN];
    char softwareVersion[KM_VERSION_STRUCT_LEN];
} KML9Version;

int KML9GetVersion(KML9Version *ver);

// Trigonometric Functions
double acos(double);
float acosf(float);
long double acosl(long double);
long double acosl_k80(long double);
long double acosl_18(long double);
double acosd(double);
float acosdf(float);
long double acosdl(long double);
double acospi(double x);
float acospif(float x);
double asin(double);
float asinf(float);
long double asinl(long double);
long double asinl_k80(long double);
float asindf(float);
double asind(double);
double asind_18(double);
long double asindl(long double);
double asinpi(double x);
float asinpif(float x);
double atan(double);
float atanf(float);
double atanpi(double x);
float atanpif(float x);
long double atanl(long double);
long double atanl_k80(long double);
double atan2(double, double);
float atan2f(float, float);
long double atan2l(long double, long double);
long double atan2l_k80(long double, long double);
long double atan2dl(long double, long double);
double atan2d(double, double);
float atan2df(float, float);
double atan2pi(double y, double x);
float atan2pif(float y, float x);
double atand(double);
float atandf(float);
long double atandl(long double);
long double atandl_k80(long double);
double cos(double);
float cosf(float);
long double cosl(long double);
long double cosl_k80(long double);
long double cosl_18(long double);
float cosdf(float);
long double cosdl(long double);
double cosd(double);
double cosd_18(double);
double cospi(double x);
float cospif(float x);
double cot(double);
float cotf(float);
long double cotl(long double);
double cotd(double);
float cotdf(float);
long double cotdl(long double);
double sin(double);
float sinf(float);
long double sinl(long double);
long double sinl_k80(long double);
long double sinl_18(long double);
void sincos(double, double *, double *);
void sincosf(float, float *, float *);
void sincosf_18(float, float *, float *);
void sincosl(long double, long double *, long double *);
void sincosd(double, double *, double *);
void sincosdf(float, float *, float *);
void sincosdl(long double, long double *, long double *);
float sindf(float);
long double sindl(long double);
double sind(double);
double sind_18(double);
double sinpi(double x);
float sinpif(float x);
double tan(double);
float tanf(float);
long double tanl(long double);
long double tanl_k80(long double);
double tand(double);
float tandf(float);
long double tandl(long double);
double tanpi(double x);
float tanpif(float x);
double atand2(double, double);
float atand2f(float, float);
long double atand2l(long double, long double);
// Hyperbolic Functions
double acosh(double);
float acoshf(float);
long double acoshl(long double);
long double acoshl_k80(long double);
double asinh(double);
float asinhf(float);
long double asinhl(long double);
long double asinhl_k80(long double);
double atanh(double);
float atanhf(float);
long double atanhl(long double);
long double atanhl_k80(long double);
double cosh(double);
float coshf(float);
long double coshl(long double);
long double coshl_k80(long double);
double sinh(double);
float sinhf(float);
long double sinhl(long double);
long double sinhl_k80(long double);
void sincosh(double, double *, double *);
void sincoshf(float, float *, float *);
void sincoshl(long double, long double *, long double *);
void sincoshl_k80(long double, long double *, long double *);
void sinhcosh(double x, double *sinhval, double *coshval);
void sinhcoshf(float x, float *sinhval, float *coshval);
void sinhcoshl(long double, long double *, long double *);
void sinhcoshl_k80(long double, long double *, long double *);
double tanh(double);
float tanhf(float);
long double tanhl(long double);
long double tanhl_k80(long double);
// Exponential Functions
double cbrt(double);
float cbrtf(float);
double cbrt_18(double);
long double cbrtl(long double);
long double cbrtl_k80(long double);
double exp(double);
float expf(float);
long double expl(long double);
long double expl_k80(long double);
double exp10(double);
float exp10f(float);
long double exp10l(long double);
float exp2f(float);
double exp2(double);
long double exp2l(long double);
long double exp2l_k80(long double);
float expm1f(float);
double expm1(double);
long double expm1l(long double);
long double expm1l_k80(long double);
double frexp(double, int *);
float frexpf(float, int*);
long double frexpl(long double, int *);
long double frexpl_k80(long double, int *);
double hypot(double, double);
float hypotf(float, float);
long double hypotl(long double, long double);
long double hypotl_k80(long double, long double);
double invsqrt(double);
float invsqrtf(float);
long double invsqrtl(long double);
int ilogb(double);
int ilogbf(float);
int ilogbl(long double);
int ilogbl_k80(long double);
double ldexp(double, int);
float ldexpf(float, int);
long double ldexpl(long double, int);
long double ldexpl_k80(long double, int);
double log(double);
float logf(float);
double log_18(double);
long double logl(long double);
long double logl_k80(long double);
float log1pf(float);
double log1p(double);
long double log1pl(long double);
long double log1pl_k80(long double);
float log10f(float);
double log10(double);
long double log10l(long double);
long double log10l_k80(long double);
double log10_18(double);
float log2f(float);
double log2(double);
long double log2l(long double);
long double log2l_k80(long double);
float logbf(float);
double logb(double);
long double logbl(long double);
long double logbl_k80(long double);
double pow(double, double);
float powf(float, float);
double pow2o3(double x);
float pow2o3f(float x);
double pow3o2(double x);
float pow3o2f(float x);
double powr(double x, double y);
float powrf(float x, float y);
double powr8i4(double, int);
long double powl(long double, long double);
long double powl_k80(long double, long double);
complex double powc16i4(complex double, int);
complex double powc16i4_18(complex double, int);
int powi4i4(int, int);
int powi4i4_18(int, int);
int64_t powi8i4(int64_t, int32_t);
int64_t powi8i8(int64_t, int64_t);
long double powr16i4(long double, int32_t);
long double powr16i4_18(long double, int32_t);
float powr4i4(float, int32_t);
double scalb(double, double);
float scalbf(float, float);
long double scalbl(long double, long double);
long double scalbl_k80(long double, long double);
double scalbln(double, long int);
float scalblnf(float, long int);
long double scalblnl(long double, long int);
long double scalblnl_k80(long double, long int);
double scalbn(double, int);
float scalbnf(float, int);
long double scalbnl(long double, int);
long double scalbnl_k80(long double, int);
double sqrt(double);
float sqrtf(float);
long double sqrtl(long double);
long double sqrtl_k80(long double);
// Complex Functions
double cabs(double complex);
double cabs_18(double complex);
float cabsf(float complex);
long double cabsl(long double complex);
long double cabsl_k80(long double complex);
double complex cacos(double complex);
float complex cacosf(float complex);
long double complex cacosl(long double complex);
long double complex cacosl_k80(long double complex);
double complex cacosh(double complex);
float complex cacoshf(float complex);
long double complex cacoshl(long double complex);
long double complex cacoshl_k80(long double complex);
double carg(double complex);
float cargf(float complex);
long double cargl(long double complex);
long double cargl_k80(long double complex);
double complex casin(double complex);
float complex casinf(float complex);
long double complex casinl(long double complex);
long double complex casinl_k80(long double complex);
double complex casinh(double complex);
float complex casinhf(float complex);
long double complex casinhl(long double complex);
long double complex casinhl_k80(long double complex);
double complex catan(double complex);
float complex catanf(float complex);
long double complex catanl(long double complex);
long double complex catanl_k80(long double complex);
double complex catanh(double complex);
float complex catanhf(float complex);
long double complex catanhl(long double complex);
long double complex catanhl_k80(long double complex);
double complex ccos(double complex);
complex float ccosf(complex float);
long double complex ccosl(long double complex);
long double complex ccosl_k80(long double complex);
complex double cexp(complex double);
complex double cexp_18(complex double);
complex float cexpf(complex float);
long double complex cexpl(long double complex x);
long double complex cexpl_k80(long double complex x);
double complex cexp2(double complex);
float complex cexp2f(float complex);
double complex cexp10(double complex);
float complex cexp10f(float complex);
long double complex cexp2l(long double complex);
double cimag(double complex);
float cimagf(float complex);
long double cimagl(long double complex);
long double cimagl_k80(long double complex);
double complex cis(double);
float complex cisf(float);
double complex cisd(double);
float complex cisdf(float);
long double complex cisl(long double);
long double complex cisl_k80(long double);
complex double clog(complex double);
float complex clogf(float complex);
complex double clog2(complex double);
float complex clog2f(float complex);
long double complex clogl(long double complex x);
long double complex clogl_k80(long double complex x);
double complex clog10(double complex);
float complex clog10f(float complex);
long double complex clog10l(long double complex x);
double complex conj(double complex);
float complex conjf(float complex);
long double complex conjl(long double complex);
long double complex conjl_k80(long double complex);
double complex ccosh(double complex);
float complex ccoshf(float complex);
long double complex ccoshl(long double complex);
long double complex ccoshl_k80(long double complex);
double complex cpow(double complex, double complex);
float complex cpowf(float complex, float complex);
long double complex cpowl(long double complex x, long double complex y);
long double complex cpowl_k80(long double complex x, long double complex y);
double complex cproj(double complex);
float complex cprojf(float complex);
long double complex cprojl(long double complex);
long double complex cprojl_k80(long double complex);
double creal(double complex);
float crealf(float complex);
long double creall(long double complex);
long double creall_k80(long double complex);
complex double csin(complex double);
complex float csinf(complex float);
long double complex csinl(long double complex);
long double complex csinl_k80(long double complex);
double complex csinh(double complex);
float complex csinhf(float complex);
long double complex csinhl(long double complex);
long double complex csinhl_k80(long double complex);
double complex csqrt(double complex);
float complex csqrtf(float complex);
long double complex csqrtl(long double complex);
long double complex csqrtl_k80(long double complex);
double complex ctan(double complex);
float complex ctanf(float complex);
long double complex ctanl(long double complex);
long double complex ctanl_k80(long double complex);
double complex ctanh(double complex);
float complex ctanhf(float complex);
long double complex ctanhl(long double complex);
long double complex ctanhl_k80(long double complex);
complex double cceil(complex double);
complex float cceilf(complex float);
// Nearest Integer Functions
double ceil(double);
float ceilf(float);
long double ceill_k80(long double);
double floor(double);
float floorf(float);
long double floorl(long double);
long double floorl_k80(long double);
long long int llrintf(float);
long long int llrint(double);
long long int llrintl(long double);
long long int llrintl_k80(long double);
long long int llroundf(float);
long long int llround(double);
long long int llroundl(long double);
long long int llroundl_k80(long double);
long int lrintf(float);
long int lrint(double);
long int lrintl(long double);
long int lrintl_k80(long double);
long int lroundf(float);
long int lround(double);
long int lroundl(long double);
long int lroundl_k80(long double);
double modf(double, double *);
float modff(float, float *);
long double modfl(long double, long double *);
long double modfl_k80(long double, long double *);
double nearbyint(double);
float nearbyintf(float);
long double nearbyintl(long double);
long double nearbyintl_k80(long double);
float rintf(float);
double rint(double);
long double rintl(long double);
long double rintl_k80(long double);
float roundf(float);
double round(double);
long double roundl(long double);
long double roundl_k80(long double);
double trunc(double);
float truncf(float);
long double truncl(long double);
long double truncl_k80(long double);
// Remainder Functions
float fmodf(float, float);
double fmod(double, double);
long double fmodl(long double, long double);
long double fmodl_k80(long double, long double);
double remainder(double, double);
float remainderf(float, float);
long double remainderl(long double, long double);
long double remainderl_k80(long double, long double);
double drem(double, double);
float dremf(float, float);
double remquo(double, double, int *);
float remquof(float, float, int *);
long double remquol(long double, long double, int *);
long double remquol_k80(long double, long double, int *);
// Special Functions
double nextafter(double, double);
float nextafterf(float, float);
double significand(double);
float significandf(float);
double nexttoward(double, long double);
float nexttowardf(float, long double);
double annuity(double, double);
float annuityf(float, float);
long double annuityl(long double, long double);
long double annuityl_k80(long double, long double);
double compound(double, double);
float compoundf(float, float);
long double compoundl(long double, long double);
long double compoundl_k80(long double, long double);
float fabsf(float x);
double fabs(double x);
double erf(double);
double erf_18(double);
float erff(float);
long double erfl(long double);
long double erfl_k80(long double);
double erfcx(double);
float erfcxf(float);
double erfc(double);
float erfcf(float);
long double erfcl(long double);
long double erfcl_k80(long double);
double erfinv(double);
float erfinvf(float);
long double erfinvl(long double);
long double erfinvl_k80(long double);
float gammaf(float);
double gamma(double);
long double gammal(long double);
long double gammal_k80(long double);
double gamma_r(double, int *);
float gammaf_r(float, int *);
long double gammal_r(long double, int *);
long double gammal_r_k80(long double, int *);
double j0(double);
float j0f(float);
long double j0l(long double);
long double j0l_k80(long double);
double j1(double);
float j1f(float);
long double j1l(long double);
long double j1l_k80(long double);
double jn(int, double);
float jnf(int, float);
long double jnl(int, long double);
long double jnl_k80(int, long double);
double lgamma(double);
float lgammaf(float);
long double lgammal(long double);
long double lgammal_k80(long double);
double lgamma_r(double, int *);
float lgammaf_r(float, int *);
long double lgammal_r(long double, int *);
long double lgammal_r_k80(long double, int *);
float tgammaf(float);
float tgammaf_18(float);
double tgamma(double);
long double tgammal(long double);
long double tgammal_k80(long double);
double y0(double);
float y0f(float);
long double y0l(long double);
long double y0l_k80(long double);
double y1(double);
float y1f(float);
long double y1l(long double);
long double y1l_k80(long double);
double yn(int, double);
float ynf(int, float);
long double ynl(int, long double);
long double ynl_k80(int, long double);
// other functions non standard
double complex cdiv(double complex, double complex);
double complex cdiv_18(double complex, double complex);
float complex cdivf(float complex, float complex);
#ifdef __cplusplus
}
#endif

#endif
