var documenterSearchIndex = {"docs":
[{"title":"Tasks","location":"base/parallel.html#Tasks","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Core.Task\nBase.@task\nBase.@async\nBase.asyncmap\nBase.asyncmap!\nBase.current_task\nBase.istaskdone\nBase.istaskstarted\nBase.istaskfailed\nBase.task_local_storage(::Any)\nBase.task_local_storage(::Any, ::Any)\nBase.task_local_storage(::Function, ::Any, ::Any)","page":"Tasks"},{"title":"Core.Task","location":"base/parallel.html#Core.Task","category":"type","text":"Task(func)\n\nCreate a Task (i.e. coroutine) to execute the given function func (which must be callable with no arguments). The task exits when this function returns.\n\nExamples\n\njulia> a() = sum(i for i in 1:1000);\n\njulia> b = Task(a);\n\nIn this example, b is a runnable Task that hasn't started yet.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.@task","location":"base/parallel.html#Base.@task","category":"macro","text":"@task\n\nWrap an expression in a Task without executing it, and return the Task. This only creates a task, and does not run it.\n\nExamples\n\njulia> a1() = sum(i for i in 1:1000);\n\njulia> b = @task a1();\n\njulia> istaskstarted(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskdone(b)\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.@async","location":"base/parallel.html#Base.@async","category":"macro","text":"@async\n\nWrap an expression in a Task and add it to the local machine's scheduler queue.\n\nValues can be interpolated into @async via $, which copies the value directly into the constructed underlying closure. This allows you to insert the value of a variable, isolating the asynchronous code from changes to the variable's value in the current task.\n\ncompat: Julia 1.4\nInterpolating values via $ is available as of Julia 1.4.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.asyncmap","location":"base/parallel.html#Base.asyncmap","category":"function","text":"asyncmap(f, c...; ntasks=0, batch_size=nothing)\n\nUses multiple concurrent tasks to map f over a collection (or multiple equal length collections). For multiple collection arguments, f is applied elementwise.\n\nntasks specifies the number of tasks to run concurrently. Depending on the length of the collections, if ntasks is unspecified, up to 100 tasks will be used for concurrent mapping.\n\nntasks can also be specified as a zero-arg function. In this case, the number of tasks to run in parallel is checked before processing every element and a new task started if the value of ntasks_func is less than the current number of tasks.\n\nIf batch_size is specified, the collection is processed in batch mode. f must then be a function that must accept a Vector of argument tuples and must return a vector of results. The input vector will have a length of batch_size or less.\n\nThe following examples highlight execution in different tasks by returning the objectid of the tasks in which the mapping function is executed.\n\nFirst, with ntasks undefined, each element is processed in a different task.\n\njulia> tskoid() = objectid(current_task());\n\njulia> asyncmap(x->tskoid(), 1:5)\n5-element Array{UInt64,1}:\n 0x6e15e66c75c75853\n 0x440f8819a1baa682\n 0x9fb3eeadd0c83985\n 0xebd3e35fe90d4050\n 0x29efc93edce2b961\n\njulia> length(unique(asyncmap(x->tskoid(), 1:5)))\n5\n\nWith ntasks=2 all elements are processed in 2 tasks.\n\njulia> asyncmap(x->tskoid(), 1:5; ntasks=2)\n5-element Array{UInt64,1}:\n 0x027ab1680df7ae94\n 0xa23d2f80cd7cf157\n 0x027ab1680df7ae94\n 0xa23d2f80cd7cf157\n 0x027ab1680df7ae94\n\njulia> length(unique(asyncmap(x->tskoid(), 1:5; ntasks=2)))\n2\n\nWith batch_size defined, the mapping function needs to be changed to accept an array of argument tuples and return an array of results. map is used in the modified mapping function to achieve this.\n\njulia> batch_func(input) = map(x->string(\"args_tuple: \", x, \", element_val: \", x[1], \", task: \", tskoid()), input)\nbatch_func (generic function with 1 method)\n\njulia> asyncmap(batch_func, 1:5; ntasks=2, batch_size=2)\n5-element Array{String,1}:\n \"args_tuple: (1,), element_val: 1, task: 9118321258196414413\"\n \"args_tuple: (2,), element_val: 2, task: 4904288162898683522\"\n \"args_tuple: (3,), element_val: 3, task: 9118321258196414413\"\n \"args_tuple: (4,), element_val: 4, task: 4904288162898683522\"\n \"args_tuple: (5,), element_val: 5, task: 9118321258196414413\"\n\nnote: Note\nCurrently, all tasks in Julia are executed in a single OS thread co-operatively. Consequently, asyncmap is beneficial only when the mapping function involves any I/O - disk, network, remote worker invocation, etc.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.asyncmap!","location":"base/parallel.html#Base.asyncmap!","category":"function","text":"asyncmap!(f, results, c...; ntasks=0, batch_size=nothing)\n\nLike asyncmap, but stores output in results rather than returning a collection.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.current_task","location":"base/parallel.html#Base.current_task","category":"function","text":"current_task()\n\nGet the currently running Task.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.istaskdone","location":"base/parallel.html#Base.istaskdone","category":"function","text":"istaskdone(t::Task) -> Bool\n\nDetermine whether a task has exited.\n\nExamples\n\njulia> a2() = sum(i for i in 1:1000);\n\njulia> b = Task(a2);\n\njulia> istaskdone(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskdone(b)\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.istaskstarted","location":"base/parallel.html#Base.istaskstarted","category":"function","text":"istaskstarted(t::Task) -> Bool\n\nDetermine whether a task has started executing.\n\nExamples\n\njulia> a3() = sum(i for i in 1:1000);\n\njulia> b = Task(a3);\n\njulia> istaskstarted(b)\nfalse\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.istaskfailed","location":"base/parallel.html#Base.istaskfailed","category":"function","text":"istaskfailed(t::Task) -> Bool\n\nDetermine whether a task has exited because an exception was thrown.\n\nExamples\n\njulia> a4() = error(\"task failed\");\n\njulia> b = Task(a4);\n\njulia> istaskfailed(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskfailed(b)\ntrue\n\ncompat: Julia 1.3\nThis function requires at least Julia 1.3.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.task_local_storage","location":"base/parallel.html#Base.task_local_storage-Tuple{Any}","category":"method","text":"task_local_storage(key)\n\nLook up the value of a key in the current task's task-local storage.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.task_local_storage","location":"base/parallel.html#Base.task_local_storage-Tuple{Any, Any}","category":"method","text":"task_local_storage(key, value)\n\nAssign a value to a key in the current task's task-local storage.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.task_local_storage","location":"base/parallel.html#Base.task_local_storage-Tuple{Function, Any, Any}","category":"method","text":"task_local_storage(body, key, value)\n\nCall the function body with a modified task-local storage, in which value is assigned to key; the previous value of key, or lack thereof, is restored afterwards. Useful for emulating dynamic scoping.\n\n\n\n\n\n","page":"Tasks"},{"title":"Scheduling","location":"base/parallel.html#Scheduling","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Base.yield\nBase.yieldto\nBase.sleep\nBase.schedule","page":"Tasks"},{"title":"Base.yield","location":"base/parallel.html#Base.yield","category":"function","text":"yield()\n\nSwitch to the scheduler to allow another scheduled task to run. A task that calls this function is still runnable, and will be restarted immediately if there are no other runnable tasks.\n\n\n\n\n\nyield(t::Task, arg = nothing)\n\nA fast, unfair-scheduling version of schedule(t, arg); yield() which immediately yields to t before calling the scheduler.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.yieldto","location":"base/parallel.html#Base.yieldto","category":"function","text":"yieldto(t::Task, arg = nothing)\n\nSwitch to the given task. The first time a task is switched to, the task's function is called with no arguments. On subsequent switches, arg is returned from the task's last call to yieldto. This is a low-level call that only switches tasks, not considering states or scheduling in any way. Its use is discouraged.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.sleep","location":"base/parallel.html#Base.sleep","category":"function","text":"sleep(seconds)\n\nBlock the current task for a specified number of seconds. The minimum sleep time is 1 millisecond or input of 0.001.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.schedule","location":"base/parallel.html#Base.schedule","category":"function","text":"schedule(t::Task, [val]; error=false)\n\nAdd a Task to the scheduler's queue. This causes the task to run constantly when the system is otherwise idle, unless the task performs a blocking operation such as wait.\n\nIf a second argument val is provided, it will be passed to the task (via the return value of yieldto) when it runs again. If error is true, the value is raised as an exception in the woken task.\n\nExamples\n\njulia> a5() = sum(i for i in 1:1000);\n\njulia> b = Task(a5);\n\njulia> istaskstarted(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskstarted(b)\ntrue\n\njulia> istaskdone(b)\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Synchronization","location":"base/parallel.html#lib-task-sync","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Base.@sync\nBase.wait\nBase.fetch(t::Task)\nBase.timedwait\n\nBase.Condition\nBase.notify\n\nBase.Semaphore\nBase.acquire\nBase.release\n\nBase.AbstractLock\nBase.lock\nBase.unlock\nBase.trylock\nBase.islocked\nBase.ReentrantLock","page":"Tasks"},{"title":"Base.@sync","location":"base/parallel.html#Base.@sync","category":"macro","text":"@sync\n\nWait until all lexically-enclosed uses of @async, @spawn, @spawnat and @distributed are complete. All exceptions thrown by enclosed async operations are collected and thrown as a CompositeException.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.wait","location":"base/parallel.html#Base.wait","category":"function","text":"wait([x])\n\nBlock the current task until some event occurs, depending on the type of the argument:\n\nChannel: Wait for a value to be appended to the channel.\nCondition: Wait for notify on a condition.\nProcess: Wait for a process or process chain to exit. The exitcode field of a process can be used to determine success or failure.\nTask: Wait for a Task to finish. If the task fails with an exception, a TaskFailedException (which wraps the failed task) is thrown.\nRawFD: Wait for changes on a file descriptor (see the FileWatching package).\n\nIf no argument is passed, the task blocks for an undefined period. A task can only be restarted by an explicit call to schedule or yieldto.\n\nOften wait is called within a while loop to ensure a waited-for condition is met before proceeding.\n\n\n\n\n\nSpecial note for Threads.Condition:\n\nThe caller must be holding the lock that owns a Threads.Condition before calling this method. The calling task will be blocked until some other task wakes it, usually by calling notify on the same Threads.Condition object. The lock will be atomically released when blocking (even if it was locked recursively), and will be reacquired before returning.\n\n\n\n\n\nwait(r::Future)\n\nWait for a value to become available for the specified Future.\n\n\n\n\n\nwait(r::RemoteChannel, args...)\n\nWait for a value to become available on the specified RemoteChannel.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.fetch","location":"base/parallel.html#Base.fetch-Tuple{Task}","category":"method","text":"fetch(t::Task)\n\nWait for a Task to finish, then return its result value. If the task fails with an exception, a TaskFailedException (which wraps the failed task) is thrown.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.timedwait","location":"base/parallel.html#Base.timedwait","category":"function","text":"timedwait(callback::Function, timeout::Real; pollint::Real=0.1)\n\nWaits until callback returns true or timeout seconds have passed, whichever is earlier. callback is polled every pollint seconds. The minimum value for timeout and pollint is 0.001, that is, 1 millisecond.\n\nReturns :ok or :timed_out\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Condition","location":"base/parallel.html#Base.Condition","category":"type","text":"Condition()\n\nCreate an edge-triggered event source that tasks can wait for. Tasks that call wait on a Condition are suspended and queued. Tasks are woken up when notify is later called on the Condition. Edge triggering means that only tasks waiting at the time notify is called can be woken up. For level-triggered notifications, you must keep extra state to keep track of whether a notification has happened. The Channel and Threads.Event types do this, and can be used for level-triggered events.\n\nThis object is NOT thread-safe. See Threads.Condition for a thread-safe version.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.notify","location":"base/parallel.html#Base.notify","category":"function","text":"notify(condition, val=nothing; all=true, error=false)\n\nWake up tasks waiting for a condition, passing them val. If all is true (the default), all waiting tasks are woken, otherwise only one is. If error is true, the passed value is raised as an exception in the woken tasks.\n\nReturn the count of tasks woken up. Return 0 if no tasks are waiting on condition.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Semaphore","location":"base/parallel.html#Base.Semaphore","category":"type","text":"Semaphore(sem_size)\n\nCreate a counting semaphore that allows at most sem_size acquires to be in use at any time. Each acquire must be matched with a release.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.acquire","location":"base/parallel.html#Base.acquire","category":"function","text":"acquire(s::Semaphore)\n\nWait for one of the sem_size permits to be available, blocking until one can be acquired.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.release","location":"base/parallel.html#Base.release","category":"function","text":"release(s::Semaphore)\n\nReturn one permit to the pool, possibly allowing another task to acquire it and resume execution.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.AbstractLock","location":"base/parallel.html#Base.AbstractLock","category":"type","text":"AbstractLock\n\nAbstract supertype describing types that implement the synchronization primitives: lock, trylock, unlock, and islocked.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.lock","location":"base/parallel.html#Base.lock","category":"function","text":"lock(lock)\n\nAcquire the lock when it becomes available. If the lock is already locked by a different task/thread, wait for it to become available.\n\nEach lock must be matched by an unlock.\n\n\n\n\n\nlock(f::Function, lock)\n\nAcquire the lock, execute f with the lock held, and release the lock when f returns. If the lock is already locked by a different task/thread, wait for it to become available.\n\nWhen this function returns, the lock has been released, so the caller should not attempt to unlock it.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.unlock","location":"base/parallel.html#Base.unlock","category":"function","text":"unlock(lock)\n\nReleases ownership of the lock.\n\nIf this is a recursive lock which has been acquired before, decrement an internal counter and return immediately.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.trylock","location":"base/parallel.html#Base.trylock","category":"function","text":"trylock(lock) -> Success (Boolean)\n\nAcquire the lock if it is available, and return true if successful. If the lock is already locked by a different task/thread, return false.\n\nEach successful trylock must be matched by an unlock.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.islocked","location":"base/parallel.html#Base.islocked","category":"function","text":"islocked(lock) -> Status (Boolean)\n\nCheck whether the lock is held by any task/thread. This should not be used for synchronization (see instead trylock).\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.ReentrantLock","location":"base/parallel.html#Base.ReentrantLock","category":"type","text":"ReentrantLock()\n\nCreates a re-entrant lock for synchronizing Tasks. The same task can acquire the lock as many times as required. Each lock must be matched with an unlock.\n\nCalling 'lock' will also inhibit running of finalizers on that thread until the corresponding 'unlock'. Use of the standard lock pattern illustrated below should naturally be supported, but beware of inverting the try/lock order or missing the try block entirely (e.g. attempting to return with the lock still held):\n\nlock(l)\ntry\n    <atomic work>\nfinally\n    unlock(l)\nend\n\n\n\n\n\n","page":"Tasks"},{"title":"Channels","location":"base/parallel.html#Channels","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Base.Channel\nBase.Channel(::Function)\nBase.put!(::Channel, ::Any)\nBase.take!(::Channel)\nBase.isready(::Channel)\nBase.fetch(::Channel)\nBase.close(::Channel)\nBase.bind(c::Channel, task::Task)","page":"Tasks"},{"title":"Base.Channel","location":"base/parallel.html#Base.Channel","category":"type","text":"Channel{T=Any}(size::Int=0)\n\nConstructs a Channel with an internal buffer that can hold a maximum of size objects of type T. put! calls on a full channel block until an object is removed with take!.\n\nChannel(0) constructs an unbuffered channel. put! blocks until a matching take! is called. And vice-versa.\n\nOther constructors:\n\nChannel(): default constructor, equivalent to Channel{Any}(0)\nChannel(Inf): equivalent to Channel{Any}(typemax(Int))\nChannel(sz): equivalent to Channel{Any}(sz)\n\ncompat: Julia 1.3\nThe default constructor Channel() and default size=0 were added in Julia 1.3.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Channel","location":"base/parallel.html#Base.Channel-Tuple{Function}","category":"method","text":"Channel{T=Any}(func::Function, size=0; taskref=nothing, spawn=false)\n\nCreate a new task from func, bind it to a new channel of type T and size size, and schedule the task, all in a single call.\n\nfunc must accept the bound channel as its only argument.\n\nIf you need a reference to the created task, pass a Ref{Task} object via the keyword argument taskref.\n\nIf spawn = true, the Task created for func may be scheduled on another thread in parallel, equivalent to creating a task via Threads.@spawn.\n\nReturn a Channel.\n\nExamples\n\njulia> chnl = Channel() do ch\n           foreach(i -> put!(ch, i), 1:4)\n       end;\n\njulia> typeof(chnl)\nChannel{Any}\n\njulia> for i in chnl\n           @show i\n       end;\ni = 1\ni = 2\ni = 3\ni = 4\n\nReferencing the created task:\n\njulia> taskref = Ref{Task}();\n\njulia> chnl = Channel(taskref=taskref) do ch\n           println(take!(ch))\n       end;\n\njulia> istaskdone(taskref[])\nfalse\n\njulia> put!(chnl, \"Hello\");\nHello\n\njulia> istaskdone(taskref[])\ntrue\n\ncompat: Julia 1.3\nThe spawn= parameter was added in Julia 1.3. This constructor was added in Julia 1.3. In earlier versions of Julia, Channel used keyword arguments to set size and T, but those constructors are deprecated.\n\njulia> chnl = Channel{Char}(1, spawn=true) do ch\n           for c in \"hello world\"\n               put!(ch, c)\n           end\n       end\nChannel{Char}(1) (1 item available)\n\njulia> String(collect(chnl))\n\"hello world\"\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.put!","location":"base/parallel.html#Base.put!-Tuple{Channel, Any}","category":"method","text":"put!(c::Channel, v)\n\nAppend an item v to the channel c. Blocks if the channel is full.\n\nFor unbuffered channels, blocks until a take! is performed by a different task.\n\ncompat: Julia 1.1\nv now gets converted to the channel's type with convert as put! is called.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.take!","location":"base/parallel.html#Base.take!-Tuple{Channel}","category":"method","text":"take!(c::Channel)\n\nRemove and return a value from a Channel. Blocks until data is available.\n\nFor unbuffered channels, blocks until a put! is performed by a different task.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.isready","location":"base/parallel.html#Base.isready-Tuple{Channel}","category":"method","text":"isready(c::Channel)\n\nDetermine whether a Channel has a value stored to it. Returns immediately, does not block.\n\nFor unbuffered channels returns true if there are tasks waiting on a put!.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.fetch","location":"base/parallel.html#Base.fetch-Tuple{Channel}","category":"method","text":"fetch(c::Channel)\n\nWait for and get the first available item from the channel. Does not remove the item. fetch is unsupported on an unbuffered (0-size) channel.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.close","location":"base/parallel.html#Base.close-Tuple{Channel}","category":"method","text":"close(c::Channel[, excp::Exception])\n\nClose a channel. An exception (optionally given by excp), is thrown by:\n\nput! on a closed channel.\ntake! and fetch on an empty, closed channel.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.bind","location":"base/parallel.html#Base.bind-Tuple{Channel, Task}","category":"method","text":"bind(chnl::Channel, task::Task)\n\nAssociate the lifetime of chnl with a task. Channel chnl is automatically closed when the task terminates. Any uncaught exception in the task is propagated to all waiters on chnl.\n\nThe chnl object can be explicitly closed independent of task termination. Terminating tasks have no effect on already closed Channel objects.\n\nWhen a channel is bound to multiple tasks, the first task to terminate will close the channel. When multiple channels are bound to the same task, termination of the task will close all of the bound channels.\n\nExamples\n\njulia> c = Channel(0);\n\njulia> task = @async foreach(i->put!(c, i), 1:4);\n\njulia> bind(c,task);\n\njulia> for i in c\n           @show i\n       end;\ni = 1\ni = 2\ni = 3\ni = 4\n\njulia> isopen(c)\nfalse\n\njulia> c = Channel(0);\n\njulia> task = @async (put!(c, 1); error(\"foo\"));\n\njulia> bind(c, task);\n\njulia> take!(c)\n1\n\njulia> put!(c, 1);\nERROR: TaskFailedException\nStacktrace:\n[...]\n    nested task error: foo\n[...]\n\n\n\n\n\n","page":"Tasks"},{"title":"Missing Values","location":"manual/missing.html#missing","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Julia provides support for representing missing values in the statistical sense, that is for situations where no value is available for a variable in an observation, but a valid value theoretically exists. Missing values are represented via the missing object, which is the singleton instance of the type Missing. missing is equivalent to NULL in SQL and NA in R, and behaves like them in most situations.","page":"Missing Values"},{"title":"Propagation of Missing Values","location":"manual/missing.html#Propagation-of-Missing-Values","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"missing values propagate automatically when passed to standard mathematical operators and functions. For these functions, uncertainty about the value of one of the operands induces uncertainty about the result. In practice, this means a math operation involving a missing value generally returns missing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing + 1\nmissing\n\njulia> \"a\" * missing\nmissing\n\njulia> abs(missing)\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"As missing is a normal Julia object, this propagation rule only works for functions which have opted in to implement this behavior. This can be achieved either via a specific method defined for arguments of type Missing, or simply by accepting arguments of this type, and passing them to functions which propagate them (like standard math operators). Packages should consider whether it makes sense to propagate missing values when defining new functions, and define methods appropriately if that is the case. Passing a missing value to a function for which no method accepting arguments of type Missing is defined throws a MethodError, just like for any other type.","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Functions that do not propagate missing values can be made to do so by wrapping them in the passmissing function provided by the Missings.jl package. For example, f(x) becomes passmissing(f)(x).","page":"Missing Values"},{"title":"Equality and Comparison Operators","location":"manual/missing.html#Equality-and-Comparison-Operators","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Standard equality and comparison operators follow the propagation rule presented above: if any of the operands is missing, the result is missing. Here are a few examples","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing == 1\nmissing\n\njulia> missing == missing\nmissing\n\njulia> missing < 1\nmissing\n\njulia> 2 >= missing\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"In particular, note that missing == missing returns missing, so == cannot be used to test whether a value is missing. To test whether x is missing, use ismissing(x).","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Special comparison operators isequal and === are exceptions to the propagation rule: they always return a Bool value, even in the presence of missing values, considering missing as equal to missing and as different from any other value. They can therefore be used to test whether a value is missing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing === 1\nfalse\n\njulia> isequal(missing, 1)\nfalse\n\njulia> missing === missing\ntrue\n\njulia> isequal(missing, missing)\ntrue","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"The isless operator is another exception: missing is considered as greater than any other value. This operator is used by sort, which therefore places missing values after all other values.","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> isless(1, missing)\ntrue\n\njulia> isless(missing, Inf)\nfalse\n\njulia> isless(missing, missing)\nfalse","page":"Missing Values"},{"title":"Logical operators","location":"manual/missing.html#Logical-operators","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Logical (or boolean) operators |, & and xor are another special case, as they only propagate missing values when it is logically required. For these operators, whether or not the result is uncertain depends on the particular operation, following the well-established rules of three-valued logic which are also implemented by NULL in SQL and NA in R. This abstract definition actually corresponds to a relatively natural behavior which is best explained via concrete examples.","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Let us illustrate this principle with the logical \"or\" operator |. Following the rules of boolean logic, if one of the operands is true, the value of the other operand does not have an influence on the result, which will always be true","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | true\ntrue","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Based on this observation, we can conclude that if one of the operands is true and the other missing, we know that the result is true in spite of the uncertainty about the actual value of one of the operands. If we had been able to observe the actual value of the second operand, it could only be true or false, and in both cases the result would be true. Therefore, in this particular case, missingness does not propagate","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true | missing\ntrue\n\njulia> missing | true\ntrue","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"On the contrary, if one of the operands is false, the result could be either true or false depending on the value of the other operand. Therefore, if that operand is missing, the result has to be missing too","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> false | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | false\nfalse\n\njulia> false | missing\nmissing\n\njulia> missing | false\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"The behavior of the logical \"and\" operator & is similar to that of the | operator, with the difference that missingness does not propagate when one of the operands is false. For example, when that is the case of the first operand","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> false & false\nfalse\n\njulia> false & true\nfalse\n\njulia> false & missing\nfalse","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"On the other hand, missingness propagates when one of the operands is true, for example the first one","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true & true\ntrue\n\njulia> true & false\nfalse\n\njulia> true & missing\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Finally, the \"exclusive or\" logical operator xor always propagates missing values, since both operands always have an effect on the result. Also note that the negation operator ! returns missing when the operand is missing just like other unary operators.","page":"Missing Values"},{"title":"Control Flow and Short-Circuiting Operators","location":"manual/missing.html#Control-Flow-and-Short-Circuiting-Operators","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Control flow operators including if, while and the ternary operator x ? y : z do not allow for missing values. This is because of the uncertainty about whether the actual value would be true or false if we could observe it, which implies that we do not know how the program should behave. A TypeError is thrown as soon as a missing value is encountered in this context","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> if missing\n           println(\"here\")\n       end\nERROR: TypeError: non-boolean (Missing) used in boolean context","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"For the same reason, contrary to logical operators presented above, the short-circuiting boolean operators && and || do not allow for missing values in situations where the value of the operand determines whether the next operand is evaluated or not. For example","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing || false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> true && missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean context","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"On the other hand, no error is thrown when the result can be determined without the missing values. This is the case when the code short-circuits before evaluating the missing operand, and when the missing operand is the last one","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true && missing\nmissing\n\njulia> false && missing\nfalse","page":"Missing Values"},{"title":"Arrays With Missing Values","location":"manual/missing.html#Arrays-With-Missing-Values","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Arrays containing missing values can be created like other arrays","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> [1, missing]\n2-element Vector{Union{Missing, Int64}}:\n 1\n  missing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"As this example shows, the element type of such arrays is Union{Missing, T}, with T the type of the non-missing values. This simply reflects the fact that array entries can be either of type T (here, Int64) or of type Missing. This kind of array uses an efficient memory storage equivalent to an Array{T} holding the actual values combined with an Array{UInt8} indicating the type of the entry (i.e. whether it is Missing or T).","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Arrays allowing for missing values can be constructed with the standard syntax. Use Array{Union{Missing, T}}(missing, dims) to create arrays filled with missing values:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> Array{Union{Missing, String}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, String}}:\n missing  missing  missing\n missing  missing  missing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"note: Note\nUsing undef or similar may currently give an array filled with missing, but this is not the correct way to obtain such an array. Use a missing constructor as shown above instead.","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"An array allowing for missing values but which does not contain any such value can be converted back to an array which does not allow for missing values using convert. If the array contains missing values, a MethodError is thrown during conversion","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> x = Union{Missing, String}[\"a\", \"b\"]\n2-element Vector{Union{Missing, String}}:\n \"a\"\n \"b\"\n\njulia> convert(Array{String}, x)\n2-element Vector{String}:\n \"a\"\n \"b\"\n\njulia> y = Union{Missing, String}[missing, \"b\"]\n2-element Vector{Union{Missing, String}}:\n missing\n \"b\"\n\njulia> convert(Array{String}, y)\nERROR: MethodError: Cannot `convert` an object of type Missing to an object of type String","page":"Missing Values"},{"title":"Skipping Missing Values","location":"manual/missing.html#Skipping-Missing-Values","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Since missing values propagate with standard mathematical operators, reduction functions return missing when called on arrays which contain missing values","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> sum([1, missing])\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"In this situation, use the skipmissing function to skip missing values","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> sum(skipmissing([1, missing]))\n1","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"This convenience function returns an iterator which filters out missing values efficiently. It can therefore be used with any function which supports iterators","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> x = skipmissing([3, missing, 2, 1])\nskipmissing(Union{Missing, Int64}[3, missing, 2, 1])\n\njulia> maximum(x)\n3\n\njulia> mean(x)\n2.0\n\njulia> mapreduce(sqrt, +, x)\n4.146264369941973","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Objects created by calling skipmissing on an array can be indexed using indices from the parent array. Indices corresponding to missing values are not valid for these objects and an error is thrown when trying to use them (they are also skipped by keys and eachindex)","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> x[1]\n3\n\njulia> x[2]\nERROR: MissingException: the value at index (2,) is missing\n[...]","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"This allows functions which operate on indices to work in combination with skipmissing. This is notably the case for search and find functions, which return indices valid for the object returned by skipmissing which are also the indices of the matching entries in the parent array","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> findall(==(1), x)\n1-element Vector{Int64}:\n 4\n\njulia> findfirst(!iszero, x)\n1\n\njulia> argmax(x)\n1","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Use collect to extract non-missing values and store them in an array","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> collect(x)\n3-element Vector{Int64}:\n 3\n 2\n 1","page":"Missing Values"},{"title":"Logical Operations on Arrays","location":"manual/missing.html#Logical-Operations-on-Arrays","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"The three-valued logic described above for logical operators is also used by logical functions applied to arrays. Thus, array equality tests using the == operator return missing whenever the result cannot be determined without knowing the actual value of the missing entry. In practice, this means that missing is returned if all non-missing values of the compared arrays are equal, but one or both arrays contain missing values (possibly at different positions)","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> [1, missing] == [2, missing]\nfalse\n\njulia> [1, missing] == [1, missing]\nmissing\n\njulia> [1, 2, missing] == [1, missing, 2]\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"As for single values, use isequal to treat missing values as equal to other missing values but different from non-missing values","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> isequal([1, missing], [1, missing])\ntrue\n\njulia> isequal([1, 2, missing], [1, missing, 2])\nfalse","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Functions any and all also follow the rules of three-valued logic, returning missing when the result cannot be determined","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> all([true, missing])\nmissing\n\njulia> all([false, missing])\nfalse\n\njulia> any([true, missing])\ntrue\n\njulia> any([false, missing])\nmissing","page":"Missing Values"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html#Using-Valgrind-with-Julia","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Valgrind is a tool for memory debugging, memory leak detection, and profiling.  This section describes things to keep in mind when using Valgrind to debug memory issues with Julia.","page":"Using Valgrind with Julia"},{"title":"General considerations","location":"devdocs/valgrind.html#General-considerations","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"By default, Valgrind assumes that there is no self modifying code in the programs it runs.  This assumption works fine in most instances but fails miserably for a just-in-time compiler like julia.  For this reason it is crucial to pass --smc-check=all-non-file to valgrind, else code may crash or behave unexpectedly (often in subtle ways).","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"In some cases, to better detect memory errors using Valgrind it can help to compile julia with memory pools disabled.  The compile-time flag MEMDEBUG disables memory pools in Julia, and MEMDEBUG2 disables memory pools in FemtoLisp.  To build julia with both flags, add the following line to Make.user:","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"CFLAGS = -DMEMDEBUG -DMEMDEBUG2","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Another thing to note: if your program uses multiple workers processes, it is likely that you want all such worker processes to run under Valgrind, not just the parent process.  To do this, pass --trace-children=yes to valgrind.","page":"Using Valgrind with Julia"},{"title":"Suppressions","location":"devdocs/valgrind.html#Suppressions","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Valgrind will typically display spurious warnings as it runs.  To reduce the number of such warnings, it helps to provide a suppressions file to Valgrind.  A sample suppressions file is included in the Julia source distribution at contrib/valgrind-julia.supp.","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"The suppressions file can be used from the julia/ source directory as follows:","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"$ valgrind --smc-check=all-non-file --suppressions=contrib/valgrind-julia.supp ./julia progname.jl","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Any memory errors that are displayed should either be reported as bugs or contributed as additional suppressions.  Note that some versions of Valgrind are shipped with insufficient default suppressions, so that may be one thing to consider before submitting any bugs.","page":"Using Valgrind with Julia"},{"title":"Running the Julia test suite under Valgrind","location":"devdocs/valgrind.html#Running-the-Julia-test-suite-under-Valgrind","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"It is possible to run the entire Julia test suite under Valgrind, but it does take quite some time (typically several hours).  To do so, run the following command from the julia/test/ directory:","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"valgrind --smc-check=all-non-file --trace-children=yes --suppressions=$PWD/../contrib/valgrind-julia.supp ../julia runtests.jl all","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"If you would like to see a report of \"definite\" memory leaks, pass the flags --leak-check=full --show-leak-kinds=definite to valgrind as well.","page":"Using Valgrind with Julia"},{"title":"Caveats","location":"devdocs/valgrind.html#Caveats","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Valgrind currently does not support multiple rounding modes, so code that adjusts the rounding mode will behave differently when run under Valgrind.","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"In general, if after setting --smc-check=all-non-file you find that your program behaves differently when run under Valgrind, it may help to pass --tool=none to valgrind as you investigate further.  This will enable the minimal Valgrind machinery but will also run much faster than when the full memory checker is enabled.","page":"Using Valgrind with Julia"},{"title":"Metaprogramming","location":"manual/metaprogramming.html#Metaprogramming","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The strongest legacy of Lisp in the Julia language is its metaprogramming support. Like Lisp, Julia represents its own code as a data structure of the language itself. Since code is represented by objects that can be created and manipulated from within the language, it is possible for a program to transform and generate its own code. This allows sophisticated code generation without extra build steps, and also allows true Lisp-style macros operating at the level of abstract syntax trees. In contrast, preprocessor \"macro\" systems, like that of C and C++, perform textual manipulation and substitution before any actual parsing or interpretation occurs. Because all data types and code in Julia are represented by Julia data structures, powerful reflection capabilities are available to explore the internals of a program and its types just like any other data.","page":"Metaprogramming"},{"title":"Program representation","location":"manual/metaprogramming.html#Program-representation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Every Julia program starts life as a string:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> prog = \"1 + 1\"\n\"1 + 1\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"What happens next?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The next step is to parse each string into an object called an expression, represented by the Julia type Expr:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1 = Meta.parse(prog)\n:(1 + 1)\n\njulia> typeof(ex1)\nExpr","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expr objects contain two parts:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"a Symbol identifying the kind of expression. A symbol is an interned string identifier (more discussion below).","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1.head\n:call","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"the expression arguments, which may be symbols, other expressions, or literal values:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1.args\n3-element Vector{Any}:\n  :+\n 1\n 1","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expressions may also be constructed directly in prefix notation:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex2 = Expr(:call, :+, 1, 1)\n:(1 + 1)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The two expressions constructed above – by parsing and by direct construction – are equivalent:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1 == ex2\ntrue","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The key point here is that Julia code is internally represented as a data structure that is accessible from the language itself.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The dump function provides indented and annotated display of Expr objects:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> dump(ex2)\nExpr\n  head: Symbol call\n  args: Array{Any}((3,))\n    1: Symbol +\n    2: Int64 1\n    3: Int64 1","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expr objects may also be nested:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex3 = Meta.parse(\"(4 + 4) / 2\")\n:((4 + 4) / 2)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Another way to view expressions is with Meta.show_sexpr, which displays the S-expression form of a given Expr, which may look very familiar to users of Lisp. Here's an example illustrating the display on a nested Expr:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> Meta.show_sexpr(ex3)\n(:call, :/, (:call, :+, 4, 4), 2)","page":"Metaprogramming"},{"title":"Symbols","location":"manual/metaprogramming.html#Symbols","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The : character has two syntactic purposes in Julia. The first form creates a Symbol, an interned string used as one building-block of expressions:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> s = :foo\n:foo\n\njulia> typeof(s)\nSymbol","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The Symbol constructor takes any number of arguments and creates a new symbol by concatenating their string representations together:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> :foo == Symbol(\"foo\")\ntrue\n\njulia> Symbol(\"func\",10)\n:func10\n\njulia> Symbol(:var,'_',\"sym\")\n:var_sym","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that to use : syntax, the symbol's name must be a valid identifier. Otherwise the Symbol(str) constructor must be used.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In the context of an expression, symbols are used to indicate access to variables; when an expression is evaluated, a symbol is replaced with the value bound to that symbol in the appropriate scope.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Sometimes extra parentheses around the argument to : are needed to avoid ambiguity in parsing:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> :(:)\n:(:)\n\njulia> :(::)\n:(::)","page":"Metaprogramming"},{"title":"Expressions and evaluation","location":"manual/metaprogramming.html#Expressions-and-evaluation","category":"section","text":"","page":"Metaprogramming"},{"title":"Quoting","location":"manual/metaprogramming.html#Quoting","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The second syntactic purpose of the : character is to create expression objects without using the explicit Expr constructor. This is referred to as quoting. The : character, followed by paired parentheses around a single statement of Julia code, produces an Expr object based on the enclosed code. Here is example of the short form used to quote an arithmetic expression:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = :(a+b*c+1)\n:(a + b * c + 1)\n\njulia> typeof(ex)\nExpr","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"(to view the structure of this expression, try ex.head and ex.args, or use dump as above or Meta.@dump)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that equivalent expressions may be constructed using Meta.parse or the direct Expr form:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia>      :(a + b*c + 1)       ==\n       Meta.parse(\"a + b*c + 1\") ==\n       Expr(:call, :+, :a, Expr(:call, :*, :b, :c), 1)\ntrue","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expressions provided by the parser generally only have symbols, other expressions, and literal values as their args, whereas expressions constructed by Julia code can have arbitrary run-time values without literal forms as args. In this specific example, + and a are symbols, *(b,c) is a subexpression, and 1 is a literal 64-bit signed integer.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"There is a second syntactic form of quoting for multiple expressions: blocks of code enclosed in quote ... end.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = quote\n           x = 1\n           y = 2\n           x + y\n       end\nquote\n    #= none:2 =#\n    x = 1\n    #= none:3 =#\n    y = 2\n    #= none:4 =#\n    x + y\nend\n\njulia> typeof(ex)\nExpr","page":"Metaprogramming"},{"title":"Interpolation","location":"manual/metaprogramming.html#man-expression-interpolation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Direct construction of Expr objects with value arguments is powerful, but Expr constructors can be tedious compared to \"normal\" Julia syntax. As an alternative, Julia allows interpolation of literals or expressions into quoted expressions. Interpolation is indicated by a prefix $.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this example, the value of variable a is interpolated:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> a = 1;\n\njulia> ex = :($a + b)\n:(1 + b)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Interpolating into an unquoted expression is not supported and will cause a compile-time error:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> $a + b\nERROR: syntax: \"$\" expression outside quote","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this example, the tuple (1,2,3) is interpolated as an expression into a conditional test:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = :(a in $:((1,2,3)) )\n:(a in (1, 2, 3))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The use of $ for expression interpolation is intentionally reminiscent of string interpolation and command interpolation. Expression interpolation allows convenient, readable programmatic construction of complex Julia expressions.","page":"Metaprogramming"},{"title":"Splatting interpolation","location":"manual/metaprogramming.html#Splatting-interpolation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that the $ interpolation syntax allows inserting only a single expression into an enclosing expression. Occasionally, you have an array of expressions and need them all to become arguments of the surrounding expression. This can be done with the syntax $(xs...). For example, the following code generates a function call where the number of arguments is determined programmatically:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> args = [:x, :y, :z];\n\njulia> :(f(1, $(args...)))\n:(f(1, x, y, z))","page":"Metaprogramming"},{"title":"Nested quote","location":"manual/metaprogramming.html#Nested-quote","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Naturally, it is possible for quote expressions to contain other quote expressions. Understanding how interpolation works in these cases can be a bit tricky. Consider this example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> x = :(1 + 2);\n\njulia> e = quote quote $x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :x))\nend))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that the result contains $x, which means that x has not been evaluated yet. In other words, the $ expression \"belongs to\" the inner quote expression, and so its argument is only evaluated when the inner quote expression is:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    1 + 2\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However, the outer quote expression is able to interpolate values inside the $ in the inner quote. This is done with multiple $s:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> e = quote quote $$x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :(1 + 2)))\nend))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that (1 + 2) now appears in the result instead of the symbol x. Evaluating this expression yields an interpolated 3:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    3\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The intuition behind this behavior is that x is evaluated once for each $: one $ works similarly to eval(:x), giving x's value, while two $s do the equivalent of eval(eval(:x)).","page":"Metaprogramming"},{"title":"QuoteNode","location":"manual/metaprogramming.html#man-quote-node","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The usual representation of a quote form in an AST is an Expr with head :quote:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> dump(Meta.parse(\":(1+2)\"))\nExpr\n  head: Symbol quote\n  args: Array{Any}((1,))\n    1: Expr\n      head: Symbol call\n      args: Array{Any}((3,))\n        1: Symbol +\n        2: Int64 1\n        3: Int64 2","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"As we have seen, such expressions support interpolation with $. However, in some situations it is necessary to quote code without performing interpolation. This kind of quoting does not yet have syntax, but is represented internally as an object of type QuoteNode:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> eval(Meta.quot(Expr(:$, :(1+2))))\n3\n\njulia> eval(QuoteNode(Expr(:$, :(1+2))))\n:($(Expr(:$, :(1 + 2))))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The parser yields QuoteNodes for simple quoted items like symbols:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> dump(Meta.parse(\":x\"))\nQuoteNode\n  value: Symbol x","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"QuoteNode can also be used for certain advanced metaprogramming tasks.","page":"Metaprogramming"},{"title":"Evaluating expressions","location":"manual/metaprogramming.html#Evaluating-expressions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Given an expression object, one can cause Julia to evaluate (execute) it at global scope using eval:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1 = :(1 + 2)\n:(1 + 2)\n\njulia> eval(ex1)\n3\n\njulia> ex = :(a + b)\n:(a + b)\n\njulia> eval(ex)\nERROR: UndefVarError: b not defined\n[...]\n\njulia> a = 1; b = 2;\n\njulia> eval(ex)\n3","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Every module has its own eval function that evaluates expressions in its global scope. Expressions passed to eval are not limited to returning values – they can also have side-effects that alter the state of the enclosing module's environment:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = :(x = 1)\n:(x = 1)\n\njulia> x\nERROR: UndefVarError: x not defined\n\njulia> eval(ex)\n1\n\njulia> x\n1","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here, the evaluation of an expression object causes a value to be assigned to the global variable x.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Since expressions are just Expr objects which can be constructed programmatically and then evaluated, it is possible to dynamically generate arbitrary code which can then be run using eval. Here is a simple example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> a = 1;\n\njulia> ex = Expr(:call, :+, a, :b)\n:(1 + b)\n\njulia> a = 0; b = 2;\n\njulia> eval(ex)\n3","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The value of a is used to construct the expression ex which applies the + function to the value 1 and the variable b. Note the important distinction between the way a and b are used:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The value of the variable a at expression construction time is used as an immediate value in the expression. Thus, the value of a when the expression is evaluated no longer matters: the value in the expression is already 1, independent of whatever the value of a might be.\nOn the other hand, the symbol :b is used in the expression construction, so the value of the variable b at that time is irrelevant – :b is just a symbol and the variable b need not even be defined. At expression evaluation time, however, the value of the symbol :b is resolved by looking up the value of the variable b.","page":"Metaprogramming"},{"title":"Functions on Expressions","location":"manual/metaprogramming.html#Functions-on-Expressions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"As hinted above, one extremely useful feature of Julia is the capability to generate and manipulate Julia code within Julia itself. We have already seen one example of a function returning Expr objects: the parse function, which takes a string of Julia code and returns the corresponding Expr. A function can also take one or more Expr objects as arguments, and return another Expr. Here is a simple, motivating example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function math_expr(op, op1, op2)\n           expr = Expr(:call, op, op1, op2)\n           return expr\n       end\nmath_expr (generic function with 1 method)\n\njulia>  ex = math_expr(:+, 1, Expr(:call, :*, 4, 5))\n:(1 + 4 * 5)\n\njulia> eval(ex)\n21","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"As another example, here is a function that doubles any numeric argument, but leaves expressions alone:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function make_expr2(op, opr1, opr2)\n           opr1f, opr2f = map(x -> isa(x, Number) ? 2*x : x, (opr1, opr2))\n           retexpr = Expr(:call, op, opr1f, opr2f)\n           return retexpr\n       end\nmake_expr2 (generic function with 1 method)\n\njulia> make_expr2(:+, 1, 2)\n:(2 + 4)\n\njulia> ex = make_expr2(:+, 1, Expr(:call, :*, 5, 8))\n:(2 + 5 * 8)\n\njulia> eval(ex)\n42","page":"Metaprogramming"},{"title":"Macros","location":"manual/metaprogramming.html#man-macros","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros provide a method to include generated code in the final body of a program. A macro maps a tuple of arguments to a returned expression, and the resulting expression is compiled directly rather than requiring a runtime eval call. Macro arguments may include expressions, literal values, and symbols.","page":"Metaprogramming"},{"title":"Basics","location":"manual/metaprogramming.html#Basics","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here is an extraordinarily simple macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro sayhello()\n           return :( println(\"Hello, world!\") )\n       end\n@sayhello (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros have a dedicated character in Julia's syntax: the @ (at-sign), followed by the unique name declared in a macro NAME ... end block. In this example, the compiler will replace all instances of @sayhello with:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":":( println(\"Hello, world!\") )","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"When @sayhello is entered in the REPL, the expression executes immediately, thus we only see the evaluation result:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @sayhello()\nHello, world!","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Now, consider a slightly more complex macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro sayhello(name)\n           return :( println(\"Hello, \", $name) )\n       end\n@sayhello (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This macro takes one argument: name. When @sayhello is encountered, the quoted expression is expanded to interpolate the value of the argument into the final expression:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @sayhello(\"human\")\nHello, human","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We can view the quoted return expression using the function macroexpand (important note: this is an extremely useful tool for debugging macros):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = macroexpand(Main, :(@sayhello(\"human\")) )\n:(Main.println(\"Hello, \", \"human\"))\n\njulia> typeof(ex)\nExpr","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We can see that the \"human\" literal has been interpolated into the expression.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"There also exists a macro @macroexpand that is perhaps a bit more convenient than the macroexpand function:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @macroexpand @sayhello \"human\"\n:(println(\"Hello, \", \"human\"))","page":"Metaprogramming"},{"title":"Hold up: why macros?","location":"manual/metaprogramming.html#Hold-up:-why-macros?","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We have already seen a function f(::Expr...) -> Expr in a previous section. In fact, macroexpand is also such a function. So, why do macros exist?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros are necessary because they execute when code is parsed, therefore, macros allow the programmer to generate and include fragments of customized code before the full program is run. To illustrate the difference, consider the following example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro twostep(arg)\n           println(\"I execute at parse time. The argument is: \", arg)\n           return :(println(\"I execute at runtime. The argument is: \", $arg))\n       end\n@twostep (macro with 1 method)\n\njulia> ex = macroexpand(Main, :(@twostep :(1, 2, 3)) );\nI execute at parse time. The argument is: :((1, 2, 3))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The first call to println is executed when macroexpand is called. The resulting expression contains only the second println:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> typeof(ex)\nExpr\n\njulia> ex\n:(println(\"I execute at runtime. The argument is: \", $(Expr(:copyast, :($(QuoteNode(:((1, 2, 3)))))))))\n\njulia> eval(ex)\nI execute at runtime. The argument is: (1, 2, 3)","page":"Metaprogramming"},{"title":"Macro invocation","location":"manual/metaprogramming.html#Macro-invocation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros are invoked with the following general syntax:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@name expr1 expr2 ...\n@name(expr1, expr2, ...)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note the distinguishing @ before the macro name and the lack of commas between the argument expressions in the first form, and the lack of whitespace after @name in the second form. The two styles should not be mixed. For example, the following syntax is different from the examples above; it passes the tuple (expr1, expr2, ...) as one argument to the macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@name (expr1, expr2, ...)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An alternative way to invoke a macro over an array literal (or comprehension) is to juxtapose both without using parentheses. In this case, the array will be the only expression fed to the macro. The following syntax is equivalent (and different from @name [a b] * v):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@name[a b] * v\n@name([a b]) * v","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"It is important to emphasize that macros receive their arguments as expressions, literals, or symbols. One way to explore macro arguments is to call the show function within the macro body:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro showarg(x)\n           show(x)\n           # ... remainder of macro, returning an expression\n       end\n@showarg (macro with 1 method)\n\njulia> @showarg(a)\n:a\n\njulia> @showarg(1+1)\n:(1 + 1)\n\njulia> @showarg(println(\"Yo!\"))\n:(println(\"Yo!\"))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In addition to the given argument list, every macro is passed extra arguments named __source__ and __module__.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The argument __source__ provides information (in the form of a LineNumberNode object) about the parser location of the @ sign from the macro invocation. This allows macros to include better error diagnostic information, and is commonly used by logging, string-parser macros, and docs, for example, as well as to implement the @__LINE__, @__FILE__, and @__DIR__ macros.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The location information can be accessed by referencing __source__.line and __source__.file:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro __LOCATION__(); return QuoteNode(__source__); end\n@__LOCATION__ (macro with 1 method)\n\njulia> dump(\n            @__LOCATION__(\n       ))\nLineNumberNode\n  line: Int64 2\n  file: Symbol none","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The argument __module__ provides information (in the form of a Module object) about the expansion context of the macro invocation. This allows macros to look up contextual information, such as existing bindings, or to insert the value as an extra argument to a runtime function call doing self-reflection in the current module.","page":"Metaprogramming"},{"title":"Building an advanced macro","location":"manual/metaprogramming.html#Building-an-advanced-macro","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here is a simplified definition of Julia's @assert macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro assert(ex)\n           return :( $ex ? nothing : throw(AssertionError($(string(ex)))) )\n       end\n@assert (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This macro can be used like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @assert 1 == 1.0\n\njulia> @assert 1 == 0\nERROR: AssertionError: 1 == 0","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In place of the written syntax, the macro call is expanded at parse time to its returned result. This is equivalent to writing:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"1 == 1.0 ? nothing : throw(AssertionError(\"1 == 1.0\"))\n1 == 0 ? nothing : throw(AssertionError(\"1 == 0\"))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"That is, in the first call, the expression :(1 == 1.0) is spliced into the test condition slot, while the value of string(:(1 == 1.0)) is spliced into the assertion message slot. The entire expression, thus constructed, is placed into the syntax tree where the @assert macro call occurs. Then at execution time, if the test expression evaluates to true, then nothing is returned, whereas if the test is false, an error is raised indicating the asserted expression that was false. Notice that it would not be possible to write this as a function, since only the value of the condition is available and it would be impossible to display the expression that computed it in the error message.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The actual definition of @assert in Julia Base is more complicated. It allows the user to optionally specify their own error message, instead of just printing the failed expression. Just like in functions with a variable number of arguments (Varargs Functions), this is specified with an ellipses following the last argument:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro assert(ex, msgs...)\n           msg_body = isempty(msgs) ? ex : msgs[1]\n           msg = string(msg_body)\n           return :($ex ? nothing : throw(AssertionError($msg)))\n       end\n@assert (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Now @assert has two modes of operation, depending upon the number of arguments it receives! If there's only one argument, the tuple of expressions captured by msgs will be empty and it will behave the same as the simpler definition above. But now if the user specifies a second argument, it is printed in the message body instead of the failing expression. You can inspect the result of a macro expansion with the aptly named @macroexpand macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @macroexpand @assert a == b\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a == b\"))\n    end)\n\njulia> @macroexpand @assert a==b \"a should equal b!\"\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a should equal b!\"))\n    end)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"There is yet another case that the actual @assert macro handles: what if, in addition to printing \"a should equal b,\" we wanted to print their values? One might naively try to use string interpolation in the custom message, e.g., @assert a==b \"a ($a) should equal b ($b)!\", but this won't work as expected with the above macro. Can you see why? Recall from string interpolation that an interpolated string is rewritten to a call to string. Compare:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> typeof(:(\"a should equal b\"))\nString\n\njulia> typeof(:(\"a ($a) should equal b ($b)!\"))\nExpr\n\njulia> dump(:(\"a ($a) should equal b ($b)!\"))\nExpr\n  head: Symbol string\n  args: Array{Any}((5,))\n    1: String \"a (\"\n    2: Symbol a\n    3: String \") should equal b (\"\n    4: Symbol b\n    5: String \")!\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"So now instead of getting a plain string in msg_body, the macro is receiving a full expression that will need to be evaluated in order to display as expected. This can be spliced directly into the returned expression as an argument to the string call; see error.jl for the complete implementation.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The @assert macro makes great use of splicing into quoted expressions to simplify the manipulation of expressions inside the macro body.","page":"Metaprogramming"},{"title":"Hygiene","location":"manual/metaprogramming.html#Hygiene","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An issue that arises in more complex macros is that of hygiene. In short, macros must ensure that the variables they introduce in their returned expressions do not accidentally clash with existing variables in the surrounding code they expand into. Conversely, the expressions that are passed into a macro as arguments are often expected to evaluate in the context of the surrounding code, interacting with and modifying the existing variables. Another concern arises from the fact that a macro may be called in a different module from where it was defined. In this case we need to ensure that all global variables are resolved to the correct module. Julia already has a major advantage over languages with textual macro expansion (like C) in that it only needs to consider the returned expression. All the other variables (such as msg in @assert above) follow the normal scoping block behavior.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"To demonstrate these issues, let us consider writing a @time macro that takes an expression as its argument, records the time, evaluates the expression, records the time again, prints the difference between the before and after times, and then has the value of the expression as its final value. The macro might look like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro time(ex)\n    return quote\n        local t0 = time_ns()\n        local val = $ex\n        local t1 = time_ns()\n        println(\"elapsed time: \", (t1-t0)/1e9, \" seconds\")\n        val\n    end\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here, we want t0, t1, and val to be private temporary variables, and we want time_ns to refer to the time_ns function in Julia Base, not to any time_ns variable the user might have (the same applies to println). Imagine the problems that could occur if the user expression ex also contained assignments to a variable called t0, or defined its own time_ns variable. We might get errors, or mysteriously incorrect behavior.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Julia's macro expander solves these problems in the following way. First, variables within a macro result are classified as either local or global. A variable is considered local if it is assigned to (and not declared global), declared local, or used as a function argument name. Otherwise, it is considered global. Local variables are then renamed to be unique (using the gensym function, which generates new symbols), and global variables are resolved within the macro definition environment. Therefore both of the above concerns are handled; the macro's locals will not conflict with any user variables, and time_ns and println will refer to the Julia Base definitions.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"One problem remains however. Consider the following use of this macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"module MyModule\nimport Base.@time\n\ntime_ns() = ... # compute something\n\n@time time_ns()\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here the user expression ex is a call to time_ns, but not the same time_ns function that the macro uses. It clearly refers to MyModule.time_ns. Therefore we must arrange for the code in ex to be resolved in the macro call environment. This is done by \"escaping\" the expression with esc:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro time(ex)\n    ...\n    local val = $(esc(ex))\n    ...\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An expression wrapped in this manner is left alone by the macro expander and simply pasted into the output verbatim. Therefore it will be resolved in the macro call environment.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This escaping mechanism can be used to \"violate\" hygiene when necessary, in order to introduce or manipulate user variables. For example, the following macro sets x to zero in the call environment:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro zerox()\n           return esc(:(x = 0))\n       end\n@zerox (macro with 1 method)\n\njulia> function foo()\n           x = 1\n           @zerox\n           return x # is zero\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n0","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This kind of manipulation of variables should be used judiciously, but is occasionally quite handy.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Getting the hygiene rules correct can be a formidable challenge. Before using a macro, you might want to consider whether a function closure would be sufficient. Another useful strategy is to defer as much work as possible to runtime. For example, many macros simply wrap their arguments in a QuoteNode or other similar Expr. Some examples of this include @task body which simply returns schedule(Task(() -> $body)), and @eval expr, which simply returns eval(QuoteNode(expr)).","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"To demonstrate, we might rewrite the @time example above as:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro time(expr)\n    return :(timeit(() -> $(esc(expr))))\nend\nfunction timeit(f)\n    t0 = time_ns()\n    val = f()\n    t1 = time_ns()\n    println(\"elapsed time: \", (t1-t0)/1e9, \" seconds\")\n    return val\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However, we don't do this for a good reason: wrapping the expr in a new scope block (the anonymous function) also slightly changes the meaning of the expression (the scope of any variables in it), while we want @time to be usable with minimum impact on the wrapped code.","page":"Metaprogramming"},{"title":"Macros and dispatch","location":"manual/metaprogramming.html#Macros-and-dispatch","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros, just like Julia functions, are generic. This means they can also have multiple method definitions, thanks to multiple dispatch:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro m end\n@m (macro with 0 methods)\n\njulia> macro m(args...)\n           println(\"$(length(args)) arguments\")\n       end\n@m (macro with 1 method)\n\njulia> macro m(x,y)\n           println(\"Two arguments\")\n       end\n@m (macro with 2 methods)\n\njulia> @m \"asd\"\n1 arguments\n\njulia> @m 1 2\nTwo arguments","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However one should keep in mind, that macro dispatch is based on the types of AST that are handed to the macro, not the types that the AST evaluates to at runtime:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro m(::Int)\n           println(\"An Integer\")\n       end\n@m (macro with 3 methods)\n\njulia> @m 2\nAn Integer\n\njulia> x = 2\n2\n\njulia> @m x\n1 arguments","page":"Metaprogramming"},{"title":"Code Generation","location":"manual/metaprogramming.html#Code-Generation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"When a significant amount of repetitive boilerplate code is required, it is common to generate it programmatically to avoid redundancy. In most languages, this requires an extra build step, and a separate program to generate the repetitive code. In Julia, expression interpolation and eval allow such code generation to take place in the normal course of program execution. For example, consider the following custom type","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"struct MyNumber\n    x::Float64\nend\n# output\n","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for which we want to add a number of methods to. We can do this programmatically in the following loop:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(quote\n        Base.$op(a::MyNumber) = MyNumber($op(a.x))\n    end)\nend\n# output\n","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"and we can now use those functions with our custom type:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> x = MyNumber(π)\nMyNumber(3.141592653589793)\n\njulia> sin(x)\nMyNumber(1.2246467991473532e-16)\n\njulia> cos(x)\nMyNumber(-1.0)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this manner, Julia acts as its own preprocessor, and allows code generation from inside the language. The above code could be written slightly more tersely using the : prefix quoting form:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(:(Base.$op(a::MyNumber) = MyNumber($op(a.x))))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This sort of in-language code generation, however, using the eval(quote(...)) pattern, is common enough that Julia comes with a macro to abbreviate this pattern:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    @eval Base.$op(a::MyNumber) = MyNumber($op(a.x))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The @eval macro rewrites this call to be precisely equivalent to the above longer versions. For longer blocks of generated code, the expression argument given to @eval can be a block:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@eval begin\n    # multiple lines\nend","page":"Metaprogramming"},{"title":"Non-Standard String Literals","location":"manual/metaprogramming.html#Non-Standard-String-Literals","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Recall from Strings that string literals prefixed by an identifier are called non-standard string literals, and can have different semantics than un-prefixed string literals. For example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"r\"^\\s*(?:#|$)\" produces a regular expression object rather than a string\nb\"DATA\\xff\\u2200\" is a byte array literal for [68,65,84,65,255,226,136,128].","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Perhaps surprisingly, these behaviors are not hard-coded into the Julia parser or compiler. Instead, they are custom behaviors provided by a general mechanism that anyone can use: prefixed string literals are parsed as calls to specially-named macros. For example, the regular expression macro is just the following:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro r_str(p)\n    Regex(p)\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"That's all. This macro says that the literal contents of the string literal r\"^\\s*(?:#|$)\" should be passed to the @r_str macro and the result of that expansion should be placed in the syntax tree where the string literal occurs. In other words, the expression r\"^\\s*(?:#|$)\" is equivalent to placing the following object directly into the syntax tree:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Regex(\"^\\\\s*(?:#|\\$)\")","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Not only is the string literal form shorter and far more convenient, but it is also more efficient: since the regular expression is compiled and the Regex object is actually created when the code is compiled, the compilation occurs only once, rather than every time the code is executed. Consider if the regular expression occurs in a loop:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for line = lines\n    m = match(r\"^\\s*(?:#|$)\", line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Since the regular expression r\"^\\s*(?:#|$)\" is compiled and inserted into the syntax tree when this code is parsed, the expression is only compiled once instead of each time the loop is executed. In order to accomplish this without macros, one would have to write this loop like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"re = Regex(\"^\\\\s*(?:#|\\$)\")\nfor line = lines\n    m = match(re, line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Moreover, if the compiler could not determine that the regex object was constant over all loops, certain optimizations might not be possible, making this version still less efficient than the more convenient literal form above. Of course, there are still situations where the non-literal form is more convenient: if one needs to interpolate a variable into the regular expression, one must take this more verbose approach; in cases where the regular expression pattern itself is dynamic, potentially changing upon each loop iteration, a new regular expression object must be constructed on each iteration. In the vast majority of use cases, however, regular expressions are not constructed based on run-time data. In this majority of cases, the ability to write regular expressions as compile-time values is invaluable.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Like non-standard string literals, non-standard command literals exist using a prefixed variant of the command literal syntax. The command literal custom`literal` is parsed as @custom_cmd \"literal\". Julia itself does not contain any non-standard command literals, but packages can make use of this syntax. Aside from the different syntax and the _cmd suffix instead of the _str suffix, non-standard command literals behave exactly like non-standard string literals.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In the event that two modules provide non-standard string or command literals with the same name, it is possible to qualify the string or command literal with a module name. For instance, if both Foo and Bar provide non-standard string literal @x_str, then one can write Foo.x\"literal\" or Bar.x\"literal\" to disambiguate between the two.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The mechanism for user-defined string literals is deeply, profoundly powerful. Not only are Julia's non-standard literals implemented using it, but also the command literal syntax (`echo \"Hello, $person\"`) is implemented with the following innocuous-looking macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro cmd(str)\n    :(cmd_gen($(shell_parse(str)[1])))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Of course, a large amount of complexity is hidden in the functions used in this macro definition, but they are just functions, written entirely in Julia. You can read their source and see precisely what they do – and all they do is construct expression objects to be inserted into your program's syntax tree.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Another way to define a macro would be like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro foo_str(str, flag)\n    # do stuff\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This macro can then be called with the following syntax:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"foo\"str\"flag","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The type of flag in the above mentioned syntax would be a String with contents of whatever trails after the string literal.","page":"Metaprogramming"},{"title":"Generated functions","location":"manual/metaprogramming.html#Generated-functions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"A very special macro is @generated, which allows you to define so-called generated functions. These have the capability to generate specialized code depending on the types of their arguments with more flexibility and/or less code than what can be achieved with multiple dispatch. While macros work with expressions at parse time and cannot access the types of their inputs, a generated function gets expanded at a time when the types of the arguments are known, but the function is not yet compiled.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Instead of performing some calculation or action, a generated function declaration returns a quoted expression which then forms the body for the method corresponding to the types of the arguments. When a generated function is called, the expression it returns is compiled and then run. To make this efficient, the result is usually cached. And to make this inferable, only a limited subset of the language is usable. Thus, generated functions provide a flexible way to move work from run time to compile time, at the expense of greater restrictions on allowed constructs.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"When defining generated functions, there are five main differences to ordinary functions:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"You annotate the function declaration with the @generated macro. This adds some information to the AST that lets the compiler know that this is a generated function.\nIn the body of the generated function you only have access to the types of the arguments – not their values.\nInstead of calculating something or performing some action, you return a quoted expression which, when evaluated, does what you want.\nGenerated functions are only permitted to call functions that were defined before the definition of the generated function. (Failure to follow this may result in getting MethodErrors referring to functions from a future world-age.)\nGenerated functions must not mutate or observe any non-constant global state (including, for example, IO, locks, non-local dictionaries, or using hasmethod). This means they can only read global constants, and cannot have any side effects. In other words, they must be completely pure. Due to an implementation limitation, this also means that they currently cannot define a closure or generator.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"It's easiest to illustrate this with an example. We can declare a generated function foo as","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function foo(x)\n           Core.println(x)\n           return :(x * x)\n       end\nfoo (generic function with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that the body returns a quoted expression, namely :(x * x), rather than just the value of x * x.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"From the caller's perspective, this is identical to a regular function; in fact, you don't have to know whether you're calling a regular or generated function. Let's see how foo behaves:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> x = foo(2); # note: output is from println() statement in the body\nInt64\n\njulia> x           # now we print x\n4\n\njulia> y = foo(\"bar\");\nString\n\njulia> y\n\"barbar\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"So, we see that in the body of the generated function, x is the type of the passed argument, and the value returned by the generated function, is the result of evaluating the quoted expression we returned from the definition, now with the value of x.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"What happens if we evaluate foo again with a type that we have already used?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> foo(4)\n16","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that there is no printout of Int64. We can see that the body of the generated function was only executed once here, for the specific set of argument types, and the result was cached. After that, for this example, the expression returned from the generated function on the first invocation was re-used as the method body. However, the actual caching behavior is an implementation-defined performance optimization, so it is invalid to depend too closely on this behavior.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The number of times a generated function is generated might be only once, but it might also be more often, or appear to not happen at all. As a consequence, you should never write a generated function with side effects - when, and how often, the side effects occur is undefined. (This is true for macros too - and just like for macros, the use of eval in a generated function is a sign that you're doing something the wrong way.) However, unlike macros, the runtime system cannot correctly handle a call to eval, so it is disallowed.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"It is also important to see how @generated functions interact with method redefinition. Following the principle that a correct @generated function must not observe any mutable state or cause any mutation of global state, we see the following behavior. Observe that the generated function cannot call any method that was not defined prior to the definition of the generated function itself.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Initially f(x) has one definition","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> f(x) = \"original definition\";","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Define other operations that use f(x):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> g(x) = f(x);\n\njulia> @generated gen1(x) = f(x);\n\njulia> @generated gen2(x) = :(f(x));","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We now add some new definitions for f(x):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> f(x::Int) = \"definition for Int\";\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\";","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"and compare how these results differ:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> gen1(1)\n\"original definition\"\n\njulia> gen2(1)\n\"definition for Int\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Each method of a generated function has its own view of defined functions:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated gen1(x::Real) = f(x);\n\njulia> gen1(1)\n\"definition for Type{Int}\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The example generated function foo above did not do anything a normal function foo(x) = x * x could not do (except printing the type on the first invocation, and incurring higher overhead). However, the power of a generated function lies in its ability to compute different quoted expressions depending on the types passed to it:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function bar(x)\n           if x <: Integer\n               return :(x ^ 2)\n           else\n               return :(x)\n           end\n       end\nbar (generic function with 1 method)\n\njulia> bar(4)\n16\n\njulia> bar(\"baz\")\n\"baz\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"(although of course this contrived example would be more easily implemented using multiple dispatch...)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Abusing this will corrupt the runtime system and cause undefined behavior:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function baz(x)\n           if rand() < .9\n               return :(x^2)\n           else\n               return :(\"boo!\")\n           end\n       end\nbaz (generic function with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Since the body of the generated function is non-deterministic, its behavior, and the behavior of all subsequent code is undefined.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Don't copy these examples!","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"These examples are hopefully helpful to illustrate how generated functions work, both in the definition end and at the call site; however, don't copy them, for the following reasons:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"the foo function has side-effects (the call to Core.println), and it is undefined exactly when, how often or how many times these side-effects will occur\nthe bar function solves a problem that is better solved with multiple dispatch - defining bar(x) = x and bar(x::Integer) = x ^ 2 will do the same thing, but it is both simpler and faster.\nthe baz function is pathological","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that the set of operations that should not be attempted in a generated function is unbounded, and the runtime system can currently only detect a subset of the invalid operations. There are many other operations that will simply corrupt the runtime system without notification, usually in subtle ways not obviously connected to the bad definition. Because the function generator is run during inference, it must respect all of the limitations of that code.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Some operations that should not be attempted include:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Caching of native pointers.\nInteracting with the contents or methods of Core.Compiler in any way.\nObserving any mutable state.\nInference on the generated function may be run at any time, including while your code is attempting to observe or mutate this state.\nTaking any locks: C code you call out to may use locks internally, (for example, it is not problematic to call malloc, even though most implementations require locks internally) but don't attempt to hold or acquire any while executing Julia code.\nCalling any function that is defined after the body of the generated function. This condition is relaxed for incrementally-loaded precompiled modules to allow calling any function in the module.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Alright, now that we have a better understanding of how generated functions work, let's use them to build some more advanced (and valid) functionality...","page":"Metaprogramming"},{"title":"An advanced example","location":"manual/metaprogramming.html#An-advanced-example","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Julia's base library has an internal sub2ind function to calculate a linear index into an n-dimensional array, based on a set of n multilinear indices - in other words, to calculate the index i that can be used to index into an array A using A[i], instead of A[x,y,z,...]. One possible implementation is the following:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function sub2ind_loop(dims::NTuple{N}, I::Integer...) where N\n           ind = I[N] - 1\n           for i = N-1:-1:1\n               ind = I[i]-1 + dims[i]*ind\n           end\n           return ind + 1\n       end\nsub2ind_loop (generic function with 1 method)\n\njulia> sub2ind_loop((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The same thing can be done using recursion:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> sub2ind_rec(dims::Tuple{}) = 1;\n\njulia> sub2ind_rec(dims::Tuple{}, i1::Integer, I::Integer...) =\n           i1 == 1 ? sub2ind_rec(dims, I...) : throw(BoundsError());\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer) = i1;\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer, I::Integer...) =\n           i1 + dims[1] * (sub2ind_rec(Base.tail(dims), I...) - 1);\n\njulia> sub2ind_rec((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Both these implementations, although different, do essentially the same thing: a runtime loop over the dimensions of the array, collecting the offset in each dimension into the final index.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However, all the information we need for the loop is embedded in the type information of the arguments. Thus, we can utilize generated functions to move the iteration to compile-time; in compiler parlance, we use generated functions to manually unroll the loop. The body becomes almost identical, but instead of calculating the linear index, we build up an expression that calculates the index:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end\nsub2ind_gen (generic function with 1 method)\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"What code will this generate?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An easy way to find out is to extract the body into another (regular) function:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           return sub2ind_gen_impl(dims, I...)\n       end\nsub2ind_gen (generic function with 1 method)\n\njulia> function sub2ind_gen_impl(dims::Type{T}, I...) where T <: NTuple{N,Any} where N\n           length(I) == N || return :(error(\"partial indexing is unsupported\"))\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end\nsub2ind_gen_impl (generic function with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We can now execute sub2ind_gen_impl and examine the expression it returns:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> sub2ind_gen_impl(Tuple{Int,Int}, Int, Int)\n:(((I[1] - 1) + dims[1] * (I[2] - 1)) + 1)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"So, the method body that will be used here doesn't include a loop at all - just indexing into the two tuples, multiplication and addition/subtraction. All the looping is performed compile-time, and we avoid looping during execution entirely. Thus, we only loop once per type, in this case once per N (except in edge cases where the function is generated more than once - see disclaimer above).","page":"Metaprogramming"},{"title":"Optionally-generated functions","location":"manual/metaprogramming.html#Optionally-generated-functions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Generated functions can achieve high efficiency at run time, but come with a compile time cost: a new function body must be generated for every combination of concrete argument types. Typically, Julia is able to compile \"generic\" versions of functions that will work for any arguments, but with generated functions this is impossible. This means that programs making heavy use of generated functions might be impossible to statically compile.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"To solve this problem, the language provides syntax for writing normal, non-generated alternative implementations of generated functions. Applied to the sub2ind example above, it would look like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n    if N != length(I)\n        throw(ArgumentError(\"Number of dimensions must match number of indices.\"))\n    end\n    if @generated\n        ex = :(I[$N] - 1)\n        for i = (N - 1):-1:1\n            ex = :(I[$i] - 1 + dims[$i] * $ex)\n        end\n        return :($ex + 1)\n    else\n        ind = I[N] - 1\n        for i = (N - 1):-1:1\n            ind = I[i] - 1 + dims[i]*ind\n        end\n        return ind + 1\n    end\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Internally, this code creates two implementations of the function: a generated one where the first block in if @generated is used, and a normal one where the else block is used. Inside the then part of the if @generated block, code has the same semantics as other generated functions: argument names refer to types, and the code should return an expression. Multiple if @generated blocks may occur, in which case the generated implementation uses all of the then blocks and the alternate implementation uses all of the else blocks.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that we added an error check to the top of the function. This code will be common to both versions, and is run-time code in both versions (it will be quoted and returned as an expression from the generated version). That means that the values and types of local variables are not available at code generation time –- the code-generation code can only see the types of arguments.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this style of definition, the code generation feature is essentially an optional optimization. The compiler will use it if convenient, but otherwise may choose to use the normal implementation instead. This style is preferred, since it allows the compiler to make more decisions and compile programs in more ways, and since normal code is more readable than code-generating code. However, which implementation is used depends on compiler implementation details, so it is essential for the two implementations to behave identically.","page":"Metaprogramming"},{"title":"Serialization","location":"stdlib/Serialization.html#Serialization","category":"section","text":"","page":"Serialization"},{"title":"Serialization","location":"stdlib/Serialization.html","category":"page","text":"Serialization.serialize\nSerialization.deserialize\nSerialization.writeheader","page":"Serialization"},{"title":"Serialization.serialize","location":"stdlib/Serialization.html#Serialization.serialize","category":"function","text":"serialize(stream::IO, value)\n\nWrite an arbitrary value to a stream in an opaque format, such that it can be read back by deserialize. The read-back value will be as identical as possible to the original. In general, this process will not work if the reading and writing are done by different versions of Julia, or an instance of Julia with a different system image. Ptr values are serialized as all-zero bit patterns (NULL).\n\nAn 8-byte identifying header is written to the stream first. To avoid writing the header, construct a Serializer and use it as the first argument to serialize instead. See also Serialization.writeheader.\n\n\n\n\n\nserialize(filename::AbstractString, value)\n\nOpen a file and serialize the given value to it.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\n\n\n\n\n","page":"Serialization"},{"title":"Serialization.deserialize","location":"stdlib/Serialization.html#Serialization.deserialize","category":"function","text":"deserialize(stream)\n\nRead a value written by serialize. deserialize assumes the binary data read from stream is correct and has been serialized by a compatible implementation of serialize. It has been designed with simplicity and performance as a goal and does not validate the data read. Malformed data can result in process termination. The caller has to ensure the integrity and correctness of data read from stream.\n\n\n\n\n\ndeserialize(filename::AbstractString)\n\nOpen a file and deserialize its contents.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\n\n\n\n\n","page":"Serialization"},{"title":"Serialization.writeheader","location":"stdlib/Serialization.html#Serialization.writeheader","category":"function","text":"Serialization.writeheader(s::AbstractSerializer)\n\nWrite an identifying header to the specified serializer. The header consists of 8 bytes as follows:\n\nOffset Description\n0 tag byte (0x37)\n1-2 signature bytes \"JL\"\n3 protocol version\n4 bits 0-1: endianness: 0 = little, 1 = big\n4 bits 2-3: platform: 0 = 32-bit, 1 = 64-bit\n5-7 reserved\n\n\n\n\n\n","page":"Serialization"},{"title":"File Events","location":"stdlib/FileWatching.html#lib-filewatching","category":"section","text":"","page":"File Events"},{"title":"File Events","location":"stdlib/FileWatching.html","category":"page","text":"FileWatching.poll_fd\nFileWatching.poll_file\nFileWatching.watch_file\nFileWatching.watch_folder\nFileWatching.unwatch_folder","page":"File Events"},{"title":"FileWatching.poll_fd","location":"stdlib/FileWatching.html#FileWatching.poll_fd","category":"function","text":"poll_fd(fd, timeout_s::Real=-1; readable=false, writable=false)\n\nMonitor a file descriptor fd for changes in the read or write availability, and with a timeout given by timeout_s seconds.\n\nThe keyword arguments determine which of read and/or write status should be monitored; at least one of them must be set to true.\n\nThe returned value is an object with boolean fields readable, writable, and timedout, giving the result of the polling.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.poll_file","location":"stdlib/FileWatching.html#FileWatching.poll_file","category":"function","text":"poll_file(path::AbstractString, interval_s::Real=5.007, timeout_s::Real=-1) -> (previous::StatStruct, current)\n\nMonitor a file for changes by polling every interval_s seconds until a change occurs or timeout_s seconds have elapsed. The interval_s should be a long period; the default is 5.007 seconds.\n\nReturns a pair of status objects (previous, current) when a change is detected. The previous status is always a StatStruct, but it may have all of the fields zeroed (indicating the file didn't previously exist, or wasn't previously accessible).\n\nThe current status object may be a StatStruct, an EOFError (indicating the timeout elapsed), or some other Exception subtype (if the stat operation failed - for example, if the path does not exist).\n\nTo determine when a file was modified, compare current isa StatStruct && mtime(prev) != mtime(current) to detect notification of changes. However, using watch_file for this operation is preferred, since it is more reliable and efficient, although in some situations it may not be available.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.watch_file","location":"stdlib/FileWatching.html#FileWatching.watch_file","category":"function","text":"watch_file(path::AbstractString, timeout_s::Real=-1)\n\nWatch file or directory path for changes until a change occurs or timeout_s seconds have elapsed.\n\nThe returned value is an object with boolean fields changed, renamed, and timedout, giving the result of watching the file.\n\nThis behavior of this function varies slightly across platforms. See https://nodejs.org/api/fs.html#fs_caveats for more detailed information.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.watch_folder","location":"stdlib/FileWatching.html#FileWatching.watch_folder","category":"function","text":"watch_folder(path::AbstractString, timeout_s::Real=-1)\n\nWatches a file or directory path for changes until a change has occurred or timeout_s seconds have elapsed.\n\nThis will continuing tracking changes for path in the background until unwatch_folder is called on the same path.\n\nThe returned value is an pair where the first field is the name of the changed file (if available) and the second field is an object with boolean fields changed, renamed, and timedout, giving the event.\n\nThis behavior of this function varies slightly across platforms. See https://nodejs.org/api/fs.html#fs_caveats for more detailed information.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.unwatch_folder","location":"stdlib/FileWatching.html#FileWatching.unwatch_folder","category":"function","text":"unwatch_folder(path::AbstractString)\n\nStop background tracking of changes for path. It is not recommended to do this while another task is waiting for watch_folder to return on the same path, as the result may be unpredictable.\n\n\n\n\n\n","page":"File Events"},{"title":"Iteration utilities","location":"base/iterators.html#Iteration-utilities","category":"section","text":"","page":"Iteration utilities"},{"title":"Iteration utilities","location":"base/iterators.html","category":"page","text":"Base.Iterators.Stateful\nBase.Iterators.zip\nBase.Iterators.enumerate\nBase.Iterators.rest\nBase.Iterators.countfrom\nBase.Iterators.take\nBase.Iterators.takewhile\nBase.Iterators.drop\nBase.Iterators.dropwhile\nBase.Iterators.cycle\nBase.Iterators.repeated\nBase.Iterators.product\nBase.Iterators.flatten\nBase.Iterators.partition\nBase.Iterators.map\nBase.Iterators.filter\nBase.Iterators.accumulate\nBase.Iterators.reverse\nBase.Iterators.only\nBase.Iterators.peel","page":"Iteration utilities"},{"title":"Base.Iterators.Stateful","location":"base/iterators.html#Base.Iterators.Stateful","category":"type","text":"Stateful(itr)\n\nThere are several different ways to think about this iterator wrapper:\n\nIt provides a mutable wrapper around an iterator and its iteration state.\nIt turns an iterator-like abstraction into a Channel-like abstraction.\nIt's an iterator that mutates to become its own rest iterator whenever an item is produced.\n\nStateful provides the regular iterator interface. Like other mutable iterators (e.g. Channel), if iteration is stopped early (e.g. by a break in a for loop), iteration can be resumed from the same spot by continuing to iterate over the same iterator object (in contrast, an immutable iterator would restart from the beginning).\n\nExamples\n\njulia> a = Iterators.Stateful(\"abcdef\");\n\njulia> isempty(a)\nfalse\n\njulia> popfirst!(a)\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> collect(Iterators.take(a, 3))\n3-element Vector{Char}:\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n 'd': ASCII/Unicode U+0064 (category Ll: Letter, lowercase)\n\njulia> collect(a)\n2-element Vector{Char}:\n 'e': ASCII/Unicode U+0065 (category Ll: Letter, lowercase)\n 'f': ASCII/Unicode U+0066 (category Ll: Letter, lowercase)\n\njulia> a = Iterators.Stateful([1,1,1,2,3,4]);\n\njulia> for x in a; x == 1 || break; end\n\njulia> peek(a)\n3\n\njulia> sum(a) # Sum the remaining elements\n7\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.zip","location":"base/iterators.html#Base.Iterators.zip","category":"function","text":"zip(iters...)\n\nRun multiple iterators at the same time, until any of them is exhausted. The value type of the zip iterator is a tuple of values of its subiterators.\n\nnote: Note\nzip orders the calls to its subiterators in such a way that stateful iterators will not advance when another iterator finishes in the current iteration.\n\nExamples\n\njulia> a = 1:5\n1:5\n\njulia> b = [\"e\",\"d\",\"b\",\"c\",\"a\"]\n5-element Vector{String}:\n \"e\"\n \"d\"\n \"b\"\n \"c\"\n \"a\"\n\njulia> c = zip(a,b)\nzip(1:5, [\"e\", \"d\", \"b\", \"c\", \"a\"])\n\njulia> length(c)\n5\n\njulia> first(c)\n(1, \"e\")\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.enumerate","location":"base/iterators.html#Base.Iterators.enumerate","category":"function","text":"enumerate(iter)\n\nAn iterator that yields (i, x) where i is a counter starting at 1, and x is the ith value from the given iterator. It's useful when you need not only the values x over which you are iterating, but also the number of iterations so far. Note that i may not be valid for indexing iter; it's also possible that x != iter[i], if iter has indices that do not start at 1. See the pairs(IndexLinear(), iter) method if you want to ensure that i is an index.\n\nExamples\n\njulia> a = [\"a\", \"b\", \"c\"];\n\njulia> for (index, value) in enumerate(a)\n           println(\"$index $value\")\n       end\n1 a\n2 b\n3 c\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.rest","location":"base/iterators.html#Base.Iterators.rest","category":"function","text":"rest(iter, state)\n\nAn iterator that yields the same elements as iter, but starting at the given state.\n\nExamples\n\njulia> collect(Iterators.rest([1,2,3,4], 2))\n3-element Vector{Int64}:\n 2\n 3\n 4\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.countfrom","location":"base/iterators.html#Base.Iterators.countfrom","category":"function","text":"countfrom(start=1, step=1)\n\nAn iterator that counts forever, starting at start and incrementing by step.\n\nExamples\n\njulia> for v in Iterators.countfrom(5, 2)\n           v > 10 && break\n           println(v)\n       end\n5\n7\n9\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.take","location":"base/iterators.html#Base.Iterators.take","category":"function","text":"take(iter, n)\n\nAn iterator that generates at most the first n elements of iter.\n\nExamples\n\njulia> a = 1:2:11\n1:2:11\n\njulia> collect(a)\n6-element Vector{Int64}:\n  1\n  3\n  5\n  7\n  9\n 11\n\njulia> collect(Iterators.take(a,3))\n3-element Vector{Int64}:\n 1\n 3\n 5\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.takewhile","location":"base/iterators.html#Base.Iterators.takewhile","category":"function","text":"takewhile(pred, iter)\n\nAn iterator that generates element from iter as long as predicate pred is true, afterwards, drops every element.\n\ncompat: Julia 1.4\nThis function requires at least Julia 1.4.\n\nExamples\n\njulia> s = collect(1:5)\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> collect(Iterators.takewhile(<(3),s))\n2-element Vector{Int64}:\n 1\n 2\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.drop","location":"base/iterators.html#Base.Iterators.drop","category":"function","text":"drop(iter, n)\n\nAn iterator that generates all but the first n elements of iter.\n\nExamples\n\njulia> a = 1:2:11\n1:2:11\n\njulia> collect(a)\n6-element Vector{Int64}:\n  1\n  3\n  5\n  7\n  9\n 11\n\njulia> collect(Iterators.drop(a,4))\n2-element Vector{Int64}:\n  9\n 11\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.dropwhile","location":"base/iterators.html#Base.Iterators.dropwhile","category":"function","text":"dropwhile(pred, iter)\n\nAn iterator that drops element from iter as long as predicate pred is true, afterwards, returns every element.\n\ncompat: Julia 1.4\nThis function requires at least Julia 1.4.\n\nExamples\n\njulia> s = collect(1:5)\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> collect(Iterators.dropwhile(<(3),s))\n3-element Vector{Int64}:\n 3\n 4\n 5\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.cycle","location":"base/iterators.html#Base.Iterators.cycle","category":"function","text":"cycle(iter)\n\nAn iterator that cycles through iter forever. If iter is empty, so is cycle(iter).\n\nExamples\n\njulia> for (i, v) in enumerate(Iterators.cycle(\"hello\"))\n           print(v)\n           i > 10 && break\n       end\nhellohelloh\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.repeated","location":"base/iterators.html#Base.Iterators.repeated","category":"function","text":"repeated(x[, n::Int])\n\nAn iterator that generates the value x forever. If n is specified, generates x that many times (equivalent to take(repeated(x), n)).\n\nExamples\n\njulia> a = Iterators.repeated([1 2], 4);\n\njulia> collect(a)\n4-element Vector{Matrix{Int64}}:\n [1 2]\n [1 2]\n [1 2]\n [1 2]\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.product","location":"base/iterators.html#Base.Iterators.product","category":"function","text":"product(iters...)\n\nReturn an iterator over the product of several iterators. Each generated element is a tuple whose ith element comes from the ith argument iterator. The first iterator changes the fastest.\n\nExamples\n\njulia> collect(Iterators.product(1:2, 3:5))\n2×3 Matrix{Tuple{Int64, Int64}}:\n (1, 3)  (1, 4)  (1, 5)\n (2, 3)  (2, 4)  (2, 5)\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.flatten","location":"base/iterators.html#Base.Iterators.flatten","category":"function","text":"flatten(iter)\n\nGiven an iterator that yields iterators, return an iterator that yields the elements of those iterators. Put differently, the elements of the argument iterator are concatenated.\n\nExamples\n\njulia> collect(Iterators.flatten((1:2, 8:9)))\n4-element Vector{Int64}:\n 1\n 2\n 8\n 9\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.partition","location":"base/iterators.html#Base.Iterators.partition","category":"function","text":"partition(collection, n)\n\nIterate over a collection n elements at a time.\n\nExamples\n\njulia> collect(Iterators.partition([1,2,3,4,5], 2))\n3-element Vector{SubArray{Int64, 1, Vector{Int64}, Tuple{UnitRange{Int64}}, true}}:\n [1, 2]\n [3, 4]\n [5]\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.map","location":"base/iterators.html#Base.Iterators.map","category":"function","text":"Iterators.map(f, iterators...)\n\nCreate a lazy mapping.  This is another syntax for writing (f(args...) for args in zip(iterators...)).\n\ncompat: Julia 1.6\nThis function requires at least Julia 1.6.\n\nExamples\n\njulia> collect(Iterators.map(x -> x^2, 1:3))\n3-element Vector{Int64}:\n 1\n 4\n 9\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.filter","location":"base/iterators.html#Base.Iterators.filter","category":"function","text":"Iterators.filter(flt, itr)\n\nGiven a predicate function flt and an iterable object itr, return an iterable object which upon iteration yields the elements x of itr that satisfy flt(x). The order of the original iterator is preserved.\n\nThis function is lazy; that is, it is guaranteed to return in Θ(1) time and use Θ(1) additional space, and flt will not be called by an invocation of filter. Calls to flt will be made when iterating over the returned iterable object. These calls are not cached and repeated calls will be made when reiterating.\n\nSee Base.filter for an eager implementation of filtering for arrays.\n\nExamples\n\njulia> f = Iterators.filter(isodd, [1, 2, 3, 4, 5])\nBase.Iterators.Filter{typeof(isodd), Vector{Int64}}(isodd, [1, 2, 3, 4, 5])\n\njulia> foreach(println, f)\n1\n3\n5\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.accumulate","location":"base/iterators.html#Base.Iterators.accumulate","category":"function","text":"Iterators.accumulate(f, itr; [init])\n\nGiven a 2-argument function f and an iterator itr, return a new iterator that successively applies f to the previous value and the next element of itr.\n\nThis is effectively a lazy version of Base.accumulate.\n\ncompat: Julia 1.5\nKeyword argument init is added in Julia 1.5.\n\nExamples\n\njulia> f = Iterators.accumulate(+, [1,2,3,4]);\n\njulia> foreach(println, f)\n1\n3\n6\n10\n\njulia> f = Iterators.accumulate(+, [1,2,3]; init = 100);\n\njulia> foreach(println, f)\n101\n103\n106\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.reverse","location":"base/iterators.html#Base.Iterators.reverse","category":"function","text":"Iterators.reverse(itr)\n\nGiven an iterator itr, then reverse(itr) is an iterator over the same collection but in the reverse order.\n\nThis iterator is \"lazy\" in that it does not make a copy of the collection in order to reverse it; see Base.reverse for an eager implementation.\n\nNot all iterator types T support reverse-order iteration.  If T doesn't, then iterating over Iterators.reverse(itr::T) will throw a MethodError because of the missing iterate methods for Iterators.Reverse{T}. (To implement these methods, the original iterator itr::T can be obtained from r = Iterators.reverse(itr) by r.itr.)\n\nExamples\n\njulia> foreach(println, Iterators.reverse(1:5))\n5\n4\n3\n2\n1\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.only","location":"base/iterators.html#Base.Iterators.only","category":"function","text":"only(x)\n\nReturns the one and only element of collection x, and throws an ArgumentError if the collection has zero or multiple elements.\n\nSee also: first, last.\n\ncompat: Julia 1.4\nThis method requires at least Julia 1.4.\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.peel","location":"base/iterators.html#Base.Iterators.peel","category":"function","text":"peel(iter)\n\nReturns the first element and an iterator over the remaining elements.\n\nExamples\n\njulia> (a, rest) = Iterators.peel(\"abc\");\n\njulia> a\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> collect(rest)\n2-element Vector{Char}:\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Bounds checking","location":"devdocs/boundscheck.html#Bounds-checking","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Like many modern programming languages, Julia uses bounds checking to ensure program safety when accessing arrays. In tight inner loops or other performance critical situations, you may wish to skip these bounds checks to improve runtime performance. For instance, in order to emit vectorized (SIMD) instructions, your loop body cannot contain branches, and thus cannot contain bounds checks. Consequently, Julia includes an @inbounds(...) macro to tell the compiler to skip such bounds checks within the given block. User-defined array types can use the @boundscheck(...) macro to achieve context-sensitive code selection.","page":"Bounds checking"},{"title":"Eliding bounds checks","location":"devdocs/boundscheck.html#Eliding-bounds-checks","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"The @boundscheck(...) macro marks blocks of code that perform bounds checking. When such blocks are inlined into an @inbounds(...) block, the compiler may remove these blocks. The compiler removes the @boundscheck block only if it is inlined into the calling function. For example, you might write the method sum as:","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"function sum(A::AbstractArray)\n    r = zero(eltype(A))\n    for i = 1:length(A)\n        @inbounds r += A[i]\n    end\n    return r\nend","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"With a custom array-like type MyArray having:","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"@inline getindex(A::MyArray, i::Real) = (@boundscheck checkbounds(A,i); A.data[to_index(i)])","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Then when getindex is inlined into sum, the call to checkbounds(A,i) will be elided. If your function contains multiple layers of inlining, only @boundscheck blocks at most one level of inlining deeper are eliminated. The rule prevents unintended changes in program behavior from code further up the stack.","page":"Bounds checking"},{"title":"Propagating inbounds","location":"devdocs/boundscheck.html#Propagating-inbounds","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"There may be certain scenarios where for code-organization reasons you want more than one layer between the @inbounds and @boundscheck declarations. For instance, the default getindex methods have the chain getindex(A::AbstractArray, i::Real) calls getindex(IndexStyle(A), A, i) calls _getindex(::IndexLinear, A, i).","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"To override the \"one layer of inlining\" rule, a function may be marked with Base.@propagate_inbounds to propagate an inbounds context (or out of bounds context) through one additional layer of inlining.","page":"Bounds checking"},{"title":"The bounds checking call hierarchy","location":"devdocs/boundscheck.html#The-bounds-checking-call-hierarchy","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"The overall hierarchy is:","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"checkbounds(A, I...) which calls\ncheckbounds(Bool, A, I...) which calls\ncheckbounds_indices(Bool, axes(A), I) which recursively calls\ncheckindex for each dimension","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Here A is the array, and I contains the \"requested\" indices. axes(A) returns a tuple of \"permitted\" indices of A.","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"checkbounds(A, I...) throws an error if the indices are invalid, whereas checkbounds(Bool, A, I...) returns false in that circumstance.  checkbounds_indices discards any information about the array other than its axes tuple, and performs a pure indices-vs-indices comparison: this allows relatively few compiled methods to serve a huge variety of array types. Indices are specified as tuples, and are usually compared in a 1-1 fashion with individual dimensions handled by calling another important function, checkindex: typically,","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"checkbounds_indices(Bool, (IA1, IA...), (I1, I...)) = checkindex(Bool, IA1, I1) &\n                                                      checkbounds_indices(Bool, IA, I)","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"so checkindex checks a single dimension.  All of these functions, including the unexported checkbounds_indices have docstrings accessible with ? .","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"If you have to customize bounds checking for a specific array type, you should specialize checkbounds(Bool, A, I...). However, in most cases you should be able to rely on checkbounds_indices as long as you supply useful axes for your array type.","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"If you have novel index types, first consider specializing checkindex, which handles a single index for a particular dimension of an array.  If you have a custom multidimensional index type (similar to CartesianIndex), then you may have to consider specializing checkbounds_indices.","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Note this hierarchy has been designed to reduce the likelihood of method ambiguities.  We try to make checkbounds the place to specialize on array type, and try to avoid specializations on index types; conversely, checkindex is intended to be specialized only on index type (especially, the last argument).","page":"Bounds checking"},{"title":"Interfaces","location":"manual/interfaces.html#Interfaces","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A lot of the power and extensibility in Julia comes from a collection of informal interfaces.  By extending a few specific methods to work for a custom type, objects of that type not only receive those functionalities, but they are also able to be used in other methods that are written to generically build upon those behaviors.","page":"Interfaces"},{"title":"Iteration","location":"manual/interfaces.html#man-interface-iteration","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Required methods  Brief description\niterate(iter)  Returns either a tuple of the first item and initial state or nothing if empty\niterate(iter, state)  Returns either a tuple of the next item and next state or nothing if no items remain\nImportant optional methods Default definition Brief description\nIteratorSize(IterType) HasLength() One of HasLength(), HasShape{N}(), IsInfinite(), or SizeUnknown() as appropriate\nIteratorEltype(IterType) HasEltype() Either EltypeUnknown() or HasEltype() as appropriate\neltype(IterType) Any The type of the first entry of the tuple returned by iterate()\nlength(iter) (undefined) The number of items, if known\nsize(iter, [dim]) (undefined) The number of items in each dimension, if known","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Value returned by IteratorSize(IterType) Required Methods\nHasLength() length(iter)\nHasShape{N}() length(iter)  and size(iter, [dim])\nIsInfinite() (none)\nSizeUnknown() (none)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Value returned by IteratorEltype(IterType) Required Methods\nHasEltype() eltype(IterType)\nEltypeUnknown() (none)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Sequential iteration is implemented by the iterate function. Instead of mutating objects as they are iterated over, Julia iterators may keep track of the iteration state externally from the object. The return value from iterate is always either a tuple of a value and a state, or nothing if no elements remain. The state object will be passed back to the iterate function on the next iteration and is generally considered an implementation detail private to the iterable object.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Any object that defines this function is iterable and can be used in the many functions that rely upon iteration. It can also be used directly in a for loop since the syntax:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"for item in iter   # or  \"for item = iter\"\n    # body\nend","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"is translated into:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"next = iterate(iter)\nwhile next !== nothing\n    (item, state) = next\n    # body\n    next = iterate(iter, state)\nend","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A simple example is an iterable sequence of square numbers with a defined length:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> struct Squares\n           count::Int\n       end\n\njulia> Base.iterate(S::Squares, state=1) = state > S.count ? nothing : (state*state, state+1)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"With only iterate definition, the Squares type is already pretty powerful. We can iterate over all the elements:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> for item in Squares(7)\n           println(item)\n       end\n1\n4\n9\n16\n25\n36\n49","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"We can use many of the builtin methods that work with iterables, like in, or mean and std from the Statistics standard library module:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> 25 in Squares(10)\ntrue\n\njulia> using Statistics\n\njulia> mean(Squares(100))\n3383.5\n\njulia> std(Squares(100))\n3024.355854282583","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"There are a few more methods we can extend to give Julia more information about this iterable collection.  We know that the elements in a Squares sequence will always be Int. By extending the eltype method, we can give that information to Julia and help it make more specialized code in the more complicated methods. We also know the number of elements in our sequence, so we can extend length, too:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.eltype(::Type{Squares}) = Int # Note that this is defined for the type\n\njulia> Base.length(S::Squares) = S.count","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Now, when we ask Julia to collect all the elements into an array it can preallocate a Vector{Int} of the right size instead of naively push!ing each element into a Vector{Any}:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> collect(Squares(4))\n4-element Vector{Int64}:\n  1\n  4\n  9\n 16","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"While we can rely upon generic implementations, we can also extend specific methods where we know there is a simpler algorithm. For example, there's a formula to compute the sum of squares, so we can override the generic iterative version with a more performant solution:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.sum(S::Squares) = (n = S.count; return n*(n+1)*(2n+1)÷6)\n\njulia> sum(Squares(1803))\n1955361914","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This is a very common pattern throughout Julia Base: a small set of required methods define an informal interface that enable many fancier behaviors. In some cases, types will want to additionally specialize those extra behaviors when they know a more efficient algorithm can be used in their specific case.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"It is also often useful to allow iteration over a collection in reverse order by iterating over Iterators.reverse(iterator).  To actually support reverse-order iteration, however, an iterator type T needs to implement iterate for Iterators.Reverse{T}. (Given r::Iterators.Reverse{T}, the underling iterator of type T is r.itr.) In our Squares example, we would implement Iterators.Reverse{Squares} methods:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.iterate(rS::Iterators.Reverse{Squares}, state=rS.itr.count) = state < 1 ? nothing : (state*state, state-1)\n\njulia> collect(Iterators.reverse(Squares(4)))\n4-element Vector{Int64}:\n 16\n  9\n  4\n  1","page":"Interfaces"},{"title":"Indexing","location":"manual/interfaces.html#Indexing","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement Brief description\ngetindex(X, i) X[i], indexed element access\nsetindex!(X, v, i) X[i] = v, indexed assignment\nfirstindex(X) The first index, used in X[begin]\nlastindex(X) The last index, used in X[end]","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For the Squares iterable above, we can easily compute the ith element of the sequence by squaring it.  We can expose this as an indexing expression S[i]. To opt into this behavior, Squares simply needs to define getindex:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> function Base.getindex(S::Squares, i::Int)\n           1 <= i <= S.count || throw(BoundsError(S, i))\n           return i*i\n       end\n\njulia> Squares(100)[23]\n529","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Additionally, to support the syntax S[begin] and S[end], we must define firstindex and lastindex to specify the first and last valid indices, respectively:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.firstindex(S::Squares) = 1\n\njulia> Base.lastindex(S::Squares) = length(S)\n\njulia> Squares(23)[end]\n529","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For multi-dimensional begin/end indexing as in a[3, begin, 7], for example, you should define firstindex(a, dim) and lastindex(a, dim) (which default to calling first and last on axes(a, dim), respectively).","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Note, though, that the above only defines getindex with one integer index. Indexing with anything other than an Int will throw a MethodError saying that there was no matching method. In order to support indexing with ranges or vectors of Ints, separate methods must be written:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.getindex(S::Squares, i::Number) = S[convert(Int, i)]\n\njulia> Base.getindex(S::Squares, I) = [S[i] for i in I]\n\njulia> Squares(10)[[3,4.,5]]\n3-element Vector{Int64}:\n  9\n 16\n 25","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"While this is starting to support more of the indexing operations supported by some of the builtin types, there's still quite a number of behaviors missing. This Squares sequence is starting to look more and more like a vector as we've added behaviors to it. Instead of defining all these behaviors ourselves, we can officially define it as a subtype of an AbstractArray.","page":"Interfaces"},{"title":"Abstract Arrays","location":"manual/interfaces.html#man-interface-array","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement  Brief description\nsize(A)  Returns a tuple containing the dimensions of A\ngetindex(A, i::Int)  (if IndexLinear) Linear scalar indexing\ngetindex(A, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexing\nsetindex!(A, v, i::Int)  (if IndexLinear) Scalar indexed assignment\nsetindex!(A, v, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexed assignment\nOptional methods Default definition Brief description\nIndexStyle(::Type) IndexCartesian() Returns either IndexLinear() or IndexCartesian(). See the description below.\ngetindex(A, I...) defined in terms of scalar getindex Multidimensional and nonscalar indexing\nsetindex!(A, X, I...) defined in terms of scalar setindex! Multidimensional and nonscalar indexed assignment\niterate defined in terms of scalar getindex Iteration\nlength(A) prod(size(A)) Number of elements\nsimilar(A) similar(A, eltype(A), size(A)) Return a mutable array with the same shape and element type\nsimilar(A, ::Type{S}) similar(A, S, size(A)) Return a mutable array with the same shape and the specified element type\nsimilar(A, dims::Dims) similar(A, eltype(A), dims) Return a mutable array with the same element type and size dims\nsimilar(A, ::Type{S}, dims::Dims) Array{S}(undef, dims) Return a mutable array with the specified element type and size\nNon-traditional indices Default definition Brief description\naxes(A) map(OneTo, size(A)) Return the a tuple of AbstractUnitRange{<:Integer} of valid indices\nsimilar(A, ::Type{S}, inds) similar(A, S, Base.to_shape(inds)) Return a mutable array with the specified indices inds (see below)\nsimilar(T::Union{Type,Function}, inds) T(Base.to_shape(inds)) Return an array similar to T with the specified indices inds (see below)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If a type is defined as a subtype of AbstractArray, it inherits a very large set of rich behaviors including iteration and multidimensional indexing built on top of single-element access.  See the arrays manual page and the Julia Base section for more supported methods.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A key part in defining an AbstractArray subtype is IndexStyle. Since indexing is such an important part of an array and often occurs in hot loops, it's important to make both indexing and indexed assignment as efficient as possible.  Array data structures are typically defined in one of two ways: either it most efficiently accesses its elements using just one index (linear indexing) or it intrinsically accesses the elements with indices specified for every dimension.  These two modalities are identified by Julia as IndexLinear() and IndexCartesian().  Converting a linear index to multiple indexing subscripts is typically very expensive, so this provides a traits-based mechanism to enable efficient generic code for all array types.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This distinction determines which scalar indexing methods the type must define. IndexLinear() arrays are simple: just define getindex(A::ArrayType, i::Int).  When the array is subsequently indexed with a multidimensional set of indices, the fallback getindex(A::AbstractArray, I...)() efficiently converts the indices into one linear index and then calls the above method. IndexCartesian() arrays, on the other hand, require methods to be defined for each supported dimensionality with ndims(A) Int indices. For example, SparseMatrixCSC from the SparseArrays standard library module, only supports two dimensions, so it just defines getindex(A::SparseMatrixCSC, i::Int, j::Int). The same holds for setindex!.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Returning to the sequence of squares from above, we could instead define it as a subtype of an AbstractArray{Int, 1}:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> struct SquaresVector <: AbstractArray{Int, 1}\n           count::Int\n       end\n\njulia> Base.size(S::SquaresVector) = (S.count,)\n\njulia> Base.IndexStyle(::Type{<:SquaresVector}) = IndexLinear()\n\njulia> Base.getindex(S::SquaresVector, i::Int) = i*i","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Note that it's very important to specify the two parameters of the AbstractArray; the first defines the eltype, and the second defines the ndims. That supertype and those three methods are all it takes for SquaresVector to be an iterable, indexable, and completely functional array:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> s = SquaresVector(4)\n4-element SquaresVector:\n  1\n  4\n  9\n 16\n\njulia> s[s .> 8]\n2-element Vector{Int64}:\n  9\n 16\n\njulia> s + s\n4-element Vector{Int64}:\n  2\n  8\n 18\n 32\n\njulia> sin.(s)\n4-element Vector{Float64}:\n  0.8414709848078965\n -0.7568024953079282\n  0.4121184852417566\n -0.2879033166650653","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"As a more complicated example, let's define our own toy N-dimensional sparse-like array type built on top of Dict:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> struct SparseArray{T,N} <: AbstractArray{T,N}\n           data::Dict{NTuple{N,Int}, T}\n           dims::NTuple{N,Int}\n       end\n\njulia> SparseArray(::Type{T}, dims::Int...) where {T} = SparseArray(T, dims);\n\njulia> SparseArray(::Type{T}, dims::NTuple{N,Int}) where {T,N} = SparseArray{T,N}(Dict{NTuple{N,Int}, T}(), dims);\n\njulia> Base.size(A::SparseArray) = A.dims\n\njulia> Base.similar(A::SparseArray, ::Type{T}, dims::Dims) where {T} = SparseArray(T, dims)\n\njulia> Base.getindex(A::SparseArray{T,N}, I::Vararg{Int,N}) where {T,N} = get(A.data, I, zero(T))\n\njulia> Base.setindex!(A::SparseArray{T,N}, v, I::Vararg{Int,N}) where {T,N} = (A.data[I] = v)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Notice that this is an IndexCartesian array, so we must manually define getindex and setindex! at the dimensionality of the array. Unlike the SquaresVector, we are able to define setindex!, and so we can mutate the array:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> A = SparseArray(Float64, 3, 3)\n3×3 SparseArray{Float64, 2}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n\njulia> fill!(A, 2)\n3×3 SparseArray{Float64, 2}:\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n\njulia> A[:] = 1:length(A); A\n3×3 SparseArray{Float64, 2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The result of indexing an AbstractArray can itself be an array (for instance when indexing by an AbstractRange). The AbstractArray fallback methods use similar to allocate an Array of the appropriate size and element type, which is filled in using the basic indexing method described above. However, when implementing an array wrapper you often want the result to be wrapped as well:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> A[1:2,:]\n2×3 SparseArray{Float64, 2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In this example it is accomplished by defining Base.similar{T}(A::SparseArray, ::Type{T}, dims::Dims) to create the appropriate wrapped array. (Note that while similar supports 1- and 2-argument forms, in most case you only need to specialize the 3-argument form.) For this to work it's important that SparseArray is mutable (supports setindex!). Defining similar, getindex and setindex! for SparseArray also makes it possible to copy the array:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> copy(A)\n3×3 SparseArray{Float64, 2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In addition to all the iterable and indexable methods from above, these types can also interact with each other and use most of the methods defined in Julia Base for AbstractArrays:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> A[SquaresVector(3)]\n3-element SparseArray{Float64, 1}:\n 1.0\n 4.0\n 9.0\n\njulia> sum(A)\n45.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If you are defining an array type that allows non-traditional indexing (indices that start at something other than 1), you should specialize axes. You should also specialize similar so that the dims argument (ordinarily a Dims size-tuple) can accept AbstractUnitRange objects, perhaps range-types Ind of your own design. For more information, see Arrays with custom indices.","page":"Interfaces"},{"title":"Strided Arrays","location":"manual/interfaces.html#man-interface-strided-arrays","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement  Brief description\nstrides(A)  Return the distance in memory (in number of elements) between adjacent elements in each dimension as a tuple. If A is an AbstractArray{T,0}, this should return an empty tuple.\nBase.unsafe_convert(::Type{Ptr{T}}, A)  Return the native address of an array.\nBase.elsize(::Type{<:A})  Return the stride between consecutive elements in the array.\nOptional methods Default definition Brief description\nstride(A, i::Int) strides(A)[i] Return the distance in memory (in number of elements) between adjacent elements in dimension k.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A strided array is a subtype of AbstractArray whose entries are stored in memory with fixed strides. Provided the element type of the array is compatible with BLAS, a strided array can utilize BLAS and LAPACK routines for more efficient linear algebra routines.  A typical example of a user-defined strided array is one that wraps a standard Array with additional structure.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Warning: do not implement these methods if the underlying storage is not actually strided, as it may lead to incorrect results or segmentation faults.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Here are some examples to demonstrate which type of arrays are strided and which are not:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"1:5   # not strided (there is no storage associated with this array.)\nVector(1:5)  # is strided with strides (1,)\nA = [1 5; 2 6; 3 7; 4 8]  # is strided with strides (1,4)\nV = view(A, 1:2, :)   # is strided with strides (1,4)\nV = view(A, 1:2:3, 1:2)   # is strided with strides (2,4)\nV = view(A, [1,2,4], :)   # is not strided, as the spacing between rows is not fixed.","page":"Interfaces"},{"title":"Customizing broadcasting","location":"manual/interfaces.html#man-interfaces-broadcasting","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement Brief description\nBase.BroadcastStyle(::Type{SrcType}) = SrcStyle() Broadcasting behavior of SrcType\nBase.similar(bc::Broadcasted{DestStyle}, ::Type{ElType}) Allocation of output container\nOptional methods \nBase.BroadcastStyle(::Style1, ::Style2) = Style12() Precedence rules for mixing styles\nBase.axes(x) Declaration of the indices of x, as per axes(x).\nBase.broadcastable(x) Convert x to an object that has axes and supports indexing\nBypassing default machinery \nBase.copy(bc::Broadcasted{DestStyle}) Custom implementation of broadcast\nBase.copyto!(dest, bc::Broadcasted{DestStyle}) Custom implementation of broadcast!, specializing on DestStyle\nBase.copyto!(dest::DestType, bc::Broadcasted{Nothing}) Custom implementation of broadcast!, specializing on DestType\nBase.Broadcast.broadcasted(f, args...) Override the default lazy behavior within a fused expression\nBase.Broadcast.instantiate(bc::Broadcasted{DestStyle}) Override the computation of the lazy broadcast's axes","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Broadcasting is triggered by an explicit call to broadcast or broadcast!, or implicitly by \"dot\" operations like A .+ b or f.(x, y). Any object that has axes and supports indexing can participate as an argument in broadcasting, and by default the result is stored in an Array. This basic framework is extensible in three major ways:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Ensuring that all arguments support broadcast\nSelecting an appropriate output array for the given set of arguments\nSelecting an efficient implementation for the given set of arguments","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Not all types support axes and indexing, but many are convenient to allow in broadcast. The Base.broadcastable function is called on each argument to broadcast, allowing it to return something different that supports axes and indexing. By default, this is the identity function for all AbstractArrays and Numbers — they already support axes and indexing. For a handful of other types (including but not limited to types themselves, functions, special singletons like missing and nothing, and dates), Base.broadcastable returns the argument wrapped in a Ref to act as a 0-dimensional \"scalar\" for the purposes of broadcasting. Custom types can similarly specialize Base.broadcastable to define their shape, but they should follow the convention that collect(Base.broadcastable(x)) == collect(x). A notable exception is AbstractString; strings are special-cased to behave as scalars for the purposes of broadcast even though they are iterable collections of their characters (see Strings for more).","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The next two steps (selecting the output array and implementation) are dependent upon determining a single answer for a given set of arguments. Broadcast must take all the varied types of its arguments and collapse them down to just one output array and one implementation. Broadcast calls this single answer a \"style.\" Every broadcastable object each has its own preferred style, and a promotion-like system is used to combine these styles into a single answer — the \"destination style\".","page":"Interfaces"},{"title":"Broadcast Styles","location":"manual/interfaces.html#Broadcast-Styles","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle is the abstract type from which all broadcast styles are derived. When used as a function it has two possible forms, unary (single-argument) and binary. The unary variant states that you intend to implement specific broadcasting behavior and/or output type, and do not wish to rely on the default fallback Broadcast.DefaultArrayStyle.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"To override these defaults, you can define a custom BroadcastStyle for your object:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"struct MyStyle <: Broadcast.BroadcastStyle end\nBase.BroadcastStyle(::Type{<:MyType}) = MyStyle()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In some cases it might be convenient not to have to define MyStyle, in which case you can leverage one of the general broadcast wrappers:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Type{<:MyType}) = Broadcast.Style{MyType}() can be used for arbitrary types.\nBase.BroadcastStyle(::Type{<:MyType}) = Broadcast.ArrayStyle{MyType}() is preferred if MyType is an AbstractArray.\nFor AbstractArrays that only support a certain dimensionality, create a subtype of Broadcast.AbstractArrayStyle{N} (see below).","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"When your broadcast operation involves several arguments, individual argument styles get combined to determine a single DestStyle that controls the type of the output container. For more details, see below.","page":"Interfaces"},{"title":"Selecting an appropriate output array","location":"manual/interfaces.html#Selecting-an-appropriate-output-array","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The broadcast style is computed for every broadcasting operation to allow for dispatch and specialization. The actual allocation of the result array is handled by similar, using the Broadcasted object as its first argument.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.similar(bc::Broadcasted{DestStyle}, ::Type{ElType})","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The fallback definition is","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"similar(bc::Broadcasted{DefaultArrayStyle{N}}, ::Type{ElType}) where {N,ElType} =\n    similar(Array{ElType}, axes(bc))","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"However, if needed you can specialize on any or all of these arguments. The final argument bc is a lazy representation of a (potentially fused) broadcast operation, a Broadcasted object.  For these purposes, the most important fields of the wrapper are f and args, describing the function and argument list, respectively.  Note that the argument list can — and often does — include other nested Broadcasted wrappers.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For a complete example, let's say you have created a type, ArrayAndChar, that stores an array and a single character:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"struct ArrayAndChar{T,N} <: AbstractArray{T,N}\n    data::Array{T,N}\n    char::Char\nend\nBase.size(A::ArrayAndChar) = size(A.data)\nBase.getindex(A::ArrayAndChar{T,N}, inds::Vararg{Int,N}) where {T,N} = A.data[inds...]\nBase.setindex!(A::ArrayAndChar{T,N}, val, inds::Vararg{Int,N}) where {T,N} = A.data[inds...] = val\nBase.showarg(io::IO, A::ArrayAndChar, toplevel) = print(io, typeof(A), \" with char '\", A.char, \"'\")","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"You might want broadcasting to preserve the char \"metadata.\" First we define","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Type{<:ArrayAndChar}) = Broadcast.ArrayStyle{ArrayAndChar}()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This means we must also define a corresponding similar method:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"function Base.similar(bc::Broadcast.Broadcasted{Broadcast.ArrayStyle{ArrayAndChar}}, ::Type{ElType}) where ElType\n    # Scan the inputs for the ArrayAndChar:\n    A = find_aac(bc)\n    # Use the char field of A to create the output\n    ArrayAndChar(similar(Array{ElType}, axes(bc)), A.char)\nend\n\n\"`A = find_aac(As)` returns the first ArrayAndChar among the arguments.\"\nfind_aac(bc::Base.Broadcast.Broadcasted) = find_aac(bc.args)\nfind_aac(args::Tuple) = find_aac(find_aac(args[1]), Base.tail(args))\nfind_aac(x) = x\nfind_aac(::Tuple{}) = nothing\nfind_aac(a::ArrayAndChar, rest) = a\nfind_aac(::Any, rest) = find_aac(rest)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"From these definitions, one obtains the following behavior:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> a = ArrayAndChar([1 2; 3 4], 'x')\n2×2 ArrayAndChar{Int64, 2} with char 'x':\n 1  2\n 3  4\n\njulia> a .+ 1\n2×2 ArrayAndChar{Int64, 2} with char 'x':\n 2  3\n 4  5\n\njulia> a .+ [5,10]\n2×2 ArrayAndChar{Int64, 2} with char 'x':\n  6   7\n 13  14","page":"Interfaces"},{"title":"Extending broadcast with custom implementations","location":"manual/interfaces.html#extending-in-place-broadcast","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In general, a broadcast operation is represented by a lazy Broadcasted container that holds onto the function to be applied alongside its arguments. Those arguments may themselves be more nested Broadcasted containers, forming a large expression tree to be evaluated. A nested tree of Broadcasted containers is directly constructed by the implicit dot syntax; 5 .+ 2.*x is transiently represented by Broadcasted(+, 5, Broadcasted(*, 2, x)), for example. This is invisible to users as it is immediately realized through a call to copy, but it is this container that provides the basis for broadcast's extensibility for authors of custom types. The built-in broadcast machinery will then determine the result type and size based upon the arguments, allocate it, and then finally copy the realization of the Broadcasted object into it with a default copyto!(::AbstractArray, ::Broadcasted) method. The built-in fallback broadcast and broadcast! methods similarly construct a transient Broadcasted representation of the operation so they can follow the same codepath. This allows custom array implementations to provide their own copyto! specialization to customize and optimize broadcasting. This is again determined by the computed broadcast style. This is such an important part of the operation that it is stored as the first type parameter of the Broadcasted type, allowing for dispatch and specialization.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For some types, the machinery to \"fuse\" operations across nested levels of broadcasting is not available or could be done more efficiently incrementally. In such cases, you may need or want to evaluate x .* (x .+ 1) as if it had been written broadcast(*, x, broadcast(+, x, 1)), where the inner operation is evaluated before tackling the outer operation. This sort of eager operation is directly supported by a bit of indirection; instead of directly constructing Broadcasted objects, Julia lowers the fused expression x .* (x .+ 1) to Broadcast.broadcasted(*, x, Broadcast.broadcasted(+, x, 1)). Now, by default, broadcasted just calls the Broadcasted constructor to create the lazy representation of the fused expression tree, but you can choose to override it for a particular combination of function and arguments.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"As an example, the builtin AbstractRange objects use this machinery to optimize pieces of broadcasted expressions that can be eagerly evaluated purely in terms of the start, step, and length (or stop) instead of computing every single element. Just like all the other machinery, broadcasted also computes and exposes the combined broadcast style of its arguments, so instead of specializing on broadcasted(f, args...), you can specialize on broadcasted(::DestStyle, f, args...) for any combination of style, function, and arguments.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For example, the following definition supports the negation of ranges:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"broadcasted(::DefaultArrayStyle{1}, ::typeof(-), r::OrdinalRange) = range(-first(r), step=-step(r), length=length(r))","page":"Interfaces"},{"title":"Extending in-place broadcasting","location":"manual/interfaces.html#extending-in-place-broadcast-2","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In-place broadcasting can be supported by defining the appropriate copyto!(dest, bc::Broadcasted) method. Because you might want to specialize either on dest or the specific subtype of bc, to avoid ambiguities between packages we recommend the following convention.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If you wish to specialize on a particular style DestStyle, define a method for","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"copyto!(dest, bc::Broadcasted{DestStyle})","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Optionally, with this form you can also specialize on the type of dest.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If instead you want to specialize on the destination type DestType without specializing on DestStyle, then you should define a method with the following signature:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"copyto!(dest::DestType, bc::Broadcasted{Nothing})","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This leverages a fallback implementation of copyto! that converts the wrapper into a Broadcasted{Nothing}. Consequently, specializing on DestType has lower precedence than methods that specialize on DestStyle.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Similarly, you can completely override out-of-place broadcasting with a copy(::Broadcasted) method.","page":"Interfaces"},{"title":"Working with Broadcasted objects","location":"manual/interfaces.html#Working-with-Broadcasted-objects","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In order to implement such a copy or copyto!, method, of course, you must work with the Broadcasted wrapper to compute each element. There are two main ways of doing so:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Broadcast.flatten recomputes the potentially nested operation into a single function and flat list of arguments. You are responsible for implementing the broadcasting shape rules yourself, but this may be helpful in limited situations.\nIterating over the CartesianIndices of the axes(::Broadcasted) and using indexing with the resulting CartesianIndex object to compute the result.","page":"Interfaces"},{"title":"Writing binary broadcasting rules","location":"manual/interfaces.html#writing-binary-broadcasting-rules","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The precedence rules are defined by binary BroadcastStyle calls:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Style1, ::Style2) = Style12()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"where Style12 is the BroadcastStyle you want to choose for outputs involving arguments of Style1 and Style2. For example,","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Broadcast.Style{Tuple}, ::Broadcast.AbstractArrayStyle{0}) = Broadcast.Style{Tuple}()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"indicates that Tuple \"wins\" over zero-dimensional arrays (the output container will be a tuple). It is worth noting that you do not need to (and should not) define both argument orders of this call; defining one is sufficient no matter what order the user supplies the arguments in.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For AbstractArray types, defining a BroadcastStyle supersedes the fallback choice, Broadcast.DefaultArrayStyle. DefaultArrayStyle and the abstract supertype, AbstractArrayStyle, store the dimensionality as a type parameter to support specialized array types that have fixed dimensionality requirements.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"DefaultArrayStyle \"loses\" to any other AbstractArrayStyle that has been defined because of the following methods:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"BroadcastStyle(a::AbstractArrayStyle{Any}, ::DefaultArrayStyle) = a\nBroadcastStyle(a::AbstractArrayStyle{N}, ::DefaultArrayStyle{N}) where N = a\nBroadcastStyle(a::AbstractArrayStyle{M}, ::DefaultArrayStyle{N}) where {M,N} =\n    typeof(a)(_max(Val(M),Val(N)))","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"You do not need to write binary BroadcastStyle rules unless you want to establish precedence for two or more non-DefaultArrayStyle types.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If your array type does have fixed dimensionality requirements, then you should subtype AbstractArrayStyle. For example, the sparse array code has the following definitions:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"struct SparseVecStyle <: Broadcast.AbstractArrayStyle{1} end\nstruct SparseMatStyle <: Broadcast.AbstractArrayStyle{2} end\nBase.BroadcastStyle(::Type{<:SparseVector}) = SparseVecStyle()\nBase.BroadcastStyle(::Type{<:SparseMatrixCSC}) = SparseMatStyle()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Whenever you subtype AbstractArrayStyle, you also need to define rules for combining dimensionalities, by creating a constructor for your style that takes a Val(N) argument. For example:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"SparseVecStyle(::Val{0}) = SparseVecStyle()\nSparseVecStyle(::Val{1}) = SparseVecStyle()\nSparseVecStyle(::Val{2}) = SparseMatStyle()\nSparseVecStyle(::Val{N}) where N = Broadcast.DefaultArrayStyle{N}()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"These rules indicate that the combination of a SparseVecStyle with 0- or 1-dimensional arrays yields another SparseVecStyle, that its combination with a 2-dimensional array yields a SparseMatStyle, and anything of higher dimensionality falls back to the dense arbitrary-dimensional framework. These rules allow broadcasting to keep the sparse representation for operations that result in one or two dimensional outputs, but produce an Array for any other dimensionality.","page":"Interfaces"},{"title":"Julia ASTs","location":"devdocs/ast.html#Julia-ASTs","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Julia has two representations of code. First there is a surface syntax AST returned by the parser (e.g. the Meta.parse function), and manipulated by macros. It is a structured representation of code as it is written, constructed by julia-parser.scm from a character stream. Next there is a lowered form, or IR (intermediate representation), which is used by type inference and code generation. In the lowered form there are fewer types of nodes, all macros are expanded, and all control flow is converted to explicit branches and sequences of statements. The lowered form is constructed by julia-syntax.scm.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"First we will focus on the AST, since it is needed to write macros.","page":"Julia ASTs"},{"title":"Surface syntax AST","location":"devdocs/ast.html#Surface-syntax-AST","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Front end ASTs consist almost entirely of Exprs and atoms (e.g. symbols, numbers). There is generally a different expression head for each visually distinct syntactic form. Examples will be given in s-expression syntax. Each parenthesized list corresponds to an Expr, where the first element is the head. For example (call f x) corresponds to Expr(:call, :f, :x) in Julia.","page":"Julia ASTs"},{"title":"Calls","location":"devdocs/ast.html#Calls","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\nf(x) (call f x)\nf(x, y=1, z=2) (call f x (kw y 1) (kw z 2))\nf(x; y=1) (call f (parameters (kw y 1)) x)\nf(x...) (call f (... x))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"do syntax:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"f(x) do a,b\n    body\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as (do (call f x) (-> (tuple a b) (block body))).","page":"Julia ASTs"},{"title":"Operators","location":"devdocs/ast.html#Operators","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Most uses of operators are just function calls, so they are parsed with the head call. However some operators are special forms (not necessarily function calls), and in those cases the operator itself is the expression head. In julia-parser.scm these are referred to as \"syntactic operators\". Some operators (+ and *) use N-ary parsing; chained calls are parsed as a single N-argument call. Finally, chains of comparisons have their own special expression structure.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\nx+y (call + x y)\na+b+c+d (call + a b c d)\n2x (call * 2 x)\na&&b (&& a b)\nx += 1 (+= x 1)\na ? 1 : 2 (if a 1 2)\na:b (: a b)\na:b:c (: a b c)\na,b (tuple a b)\na==b (call == a b)\n1<i<=n (comparison 1 < i <= n)\na.b (. a (quote b))\na.(b) (. a (tuple b))","page":"Julia ASTs"},{"title":"Bracketed forms","location":"devdocs/ast.html#Bracketed-forms","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\na[i] (ref a i)\nt[i;j] (typed_vcat t i j)\nt[i j] (typed_hcat t i j)\nt[a b; c d] (typed_vcat t (row a b) (row c d))\na{b} (curly a b)\na{b;c} (curly a (parameters c) b)\n[x] (vect x)\n[x,y] (vect x y)\n[x;y] (vcat x y)\n[x y] (hcat x y)\n[x y; z t] (vcat (row x y) (row z t))\n[x for y in z, a in b] (comprehension x (= y z) (= a b))\nT[x for y in z] (typed_comprehension T x (= y z))\n(a, b, c) (tuple a b c)\n(a; b; c) (block a (block b c))","page":"Julia ASTs"},{"title":"Macros","location":"devdocs/ast.html#Macros","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\n@m x y (macrocall @m (line) x y)\nBase.@m x y (macrocall (. Base (quote @m)) (line) x y)\n@Base.m x y (macrocall (. Base (quote @m)) (line) x y)","page":"Julia ASTs"},{"title":"Strings","location":"devdocs/ast.html#Strings","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\n\"a\" \"a\"\nx\"y\" (macrocall @x_str (line) \"y\")\nx\"y\"z (macrocall @x_str (line) \"y\" \"z\")\n\"x = $x\" (string \"x = \" x)\n`a b c` (macrocall @cmd (line) \"a b c\")","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Doc string syntax:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"\"some docs\"\nf(x) = x","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as (macrocall (|.| Core '@doc) (line) \"some docs\" (= (call f x) (block x))).","page":"Julia ASTs"},{"title":"Imports and such","location":"devdocs/ast.html#Imports-and-such","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\nimport a (import (. a))\nimport a.b.c (import (. a b c))\nimport ...a (import (. . . . a))\nimport a.b, c.d (import (. a b) (. c d))\nimport Base: x (import (: (. Base) (. x)))\nimport Base: x, y (import (: (. Base) (. x) (. y)))\nexport a, b (export a b)","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"using has the same representation as import, but with expression head :using instead of :import.","page":"Julia ASTs"},{"title":"Numbers","location":"devdocs/ast.html#Numbers","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Julia supports more number types than many scheme implementations, so not all numbers are represented directly as scheme numbers in the AST.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\n11111111111111111111 (macrocall @int128_str (null) \"11111111111111111111\")\n0xfffffffffffffffff (macrocall @uint128_str (null) \"0xfffffffffffffffff\")\n1111...many digits... (macrocall @big_str (null) \"1111....\")","page":"Julia ASTs"},{"title":"Block forms","location":"devdocs/ast.html#Block-forms","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A block of statements is parsed as (block stmt1 stmt2 ...).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"If statement:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"if a\n    b\nelseif c\n    d\nelse\n    e\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"(if a (block (line 2) b)\n    (elseif (block (line 3) c) (block (line 4) d)\n            (block (line 5 e))))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A while loop parses as (while condition body).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A for loop parses as (for (= var iter) body). If there is more than one iteration specification, they are parsed as a block: (for (block (= v1 iter1) (= v2 iter2)) body).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"break and continue are parsed as 0-argument expressions (break) and (continue).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"let is parsed as (let (= var val) body) or (let (block (= var1 val1) (= var2 val2) ...) body), like for loops.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A basic function definition is parsed as (function (call f x) body). A more complex example:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"function f(x::T; k = 1) where T\n    return x+1\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"(function (where (call f (parameters (kw k 1))\n                       (:: x T))\n                 T)\n          (block (line 2) (return (call + x 1))))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Type definition:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"mutable struct Foo{T<:S}\n    x::T\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"(struct true (curly Foo (<: T S))\n        (block (line 2) (:: x T)))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"The first argument is a boolean telling whether the type is mutable.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"try blocks parse as (try try_block var catch_block finally_block). If no variable is present after catch, var is #f. If there is no finally clause, then the last argument is not present.","page":"Julia ASTs"},{"title":"Quote expressions","location":"devdocs/ast.html#Quote-expressions","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Julia source syntax forms for code quoting (quote and :( )) support interpolation with $. In Lisp terminology, this means they are actually \"backquote\" or \"quasiquote\" forms. Internally, there is also a need for code quoting without interpolation. In Julia's scheme code, non-interpolating quote is represented with the expression head inert.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"inert expressions are converted to Julia QuoteNode objects. These objects wrap a single value of any type, and when evaluated simply return that value.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A quote expression whose argument is an atom also gets converted to a QuoteNode.","page":"Julia ASTs"},{"title":"Line numbers","location":"devdocs/ast.html#Line-numbers","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Source location information is represented as (line line_num file_name) where the third component is optional (and omitted when the current line number, but not file name, changes).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"These expressions are represented as LineNumberNodes in Julia.","page":"Julia ASTs"},{"title":"Macros","location":"devdocs/ast.html#Macros-2","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Macro hygiene is represented through the expression head pair escape and hygienic-scope. The result of a macro expansion is automatically wrapped in (hygienic-scope block module), to represent the result of the new scope. The user can insert (escape block) inside to interpolate code from the caller.","page":"Julia ASTs"},{"title":"Lowered form","location":"devdocs/ast.html#Lowered-form","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Lowered form (IR) is more important to the compiler, since it is used for type inference, optimizations like inlining, and code generation. It is also less obvious to the human, since it results from a significant rearrangement of the input syntax.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"In addition to Symbols and some number types, the following data types exist in lowered form:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Expr\nHas a node type indicated by the head field, and an args field which is a Vector{Any} of subexpressions. While almost every part of a surface AST is represented by an Expr, the IR uses only a limited number of Exprs, mostly for calls and some top-level-only forms.\nSlot\nIdentifies arguments and local variables by consecutive numbering. Slot is an abstract type with subtypes SlotNumber and TypedSlot. Both types have an integer-valued id field giving the slot index. Most slots have the same type at all uses, and so are represented with SlotNumber. The types of these slots are found in the slottypes field of their MethodInstance object. Slots that require per-use type annotations are represented with TypedSlot, which has a typ field.\nArgument\nThe same as SlotNumber, but appears only post-optimization. Indicates that the referenced slot is an argument of the enclosing function.\nCodeInfo\nWraps the IR of a group of statements. Its code field is an array of expressions to execute.\nGotoNode\nUnconditional branch. The argument is the branch target, represented as an index in the code array to jump to.\nGotoIfNot\nConditional branch. If the cond field evaluates to false, goes to the index identified by the dest field.\nReturnNode\nReturns its argument (the val field) as the value of the enclosing function. If the val field is undefined, then this represents an unreachable statement.\nQuoteNode\nWraps an arbitrary value to reference as data. For example, the function f() = :a contains a QuoteNode whose value field is the symbol a, in order to return the symbol itself instead of evaluating it.\nGlobalRef\nRefers to global variable name in module mod.\nSSAValue\nRefers to a consecutively-numbered (starting at 1) static single assignment (SSA) variable inserted by the compiler. The number (id) of an SSAValue is the code array index of the expression whose value it represents.\nNewvarNode\nMarks a point where a variable (slot) is created. This has the effect of resetting a variable to undefined.","page":"Julia ASTs"},{"title":"Expr types","location":"devdocs/ast.html#Expr-types","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"These symbols appear in the head field of Exprs in lowered form.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"call\nFunction call (dynamic dispatch). args[1] is the function to call, args[2:end] are the arguments.\ninvoke\nFunction call (static dispatch). args[1] is the MethodInstance to call, args[2:end] are the arguments (including the function that is being called, at args[2]).\nstatic_parameter\nReference a static parameter by index.\n=\nAssignment. In the IR, the first argument is always a Slot or a GlobalRef.\nmethod\nAdds a method to a generic function and assigns the result if necessary.\nHas a 1-argument form and a 3-argument form. The 1-argument form arises from the syntax function foo end. In the 1-argument form, the argument is a symbol. If this symbol already names a function in the current scope, nothing happens. If the symbol is undefined, a new function is created and assigned to the identifier specified by the symbol. If the symbol is defined but names a non-function, an error is raised. The definition of \"names a function\" is that the binding is constant, and refers to an object of singleton type. The rationale for this is that an instance of a singleton type uniquely identifies the type to add the method to. When the type has fields, it wouldn't be clear whether the method was being added to the instance or its type.\nThe 3-argument form has the following arguments:\nargs[1]\nA function name, or nothing if unknown or unneeded. If a symbol, then the expression first behaves like the 1-argument form above. This argument is ignored from then on. It can be nothing when methods are added strictly by type, (::T)(x) = x, or when a method is being added to an existing function, MyModule.f(x) = x.\nargs[2]\nA SimpleVector of argument type data. args[2][1] is a SimpleVector of the argument types, and args[2][2] is a SimpleVector of type variables corresponding to the method's static parameters.\nargs[3]\nA CodeInfo of the method itself. For \"out of scope\" method definitions (adding a method to a function that also has methods defined in different scopes) this is an expression that evaluates to a :lambda expression.\nstruct_type\nA 7-argument expression that defines a new struct:\nargs[1]\nThe name of the struct\nargs[2]\nA call expression that creates a SimpleVector specifying its parameters\nargs[3]\nA call expression that creates a SimpleVector specifying its fieldnames\nargs[4]\nA Symbol, GlobalRef, or Expr specifying the supertype (e.g., :Integer, GlobalRef(Core, :Any), or :(Core.apply_type(AbstractArray, T, N)))\nargs[5]\nA call expression that creates a SimpleVector specifying its fieldtypes\nargs[6]\nA Bool, true if mutable\nargs[7]\nThe number of arguments to initialize. This will be the number of fields, or the minimum number of fields called by an inner constructor's new statement.\nabstract_type\nA 3-argument expression that defines a new abstract type. The arguments are the same as arguments 1, 2, and 4 of struct_type expressions.\nprimitive_type\nA 4-argument expression that defines a new primitive type. Arguments 1, 2, and 4 are the same as struct_type. Argument 3 is the number of bits.\ncompat: Julia 1.5\nstruct_type, abstract_type, and primitive_type were removed in Julia 1.5 and replaced by calls to new builtins.\nglobal\nDeclares a global binding.\nconst\nDeclares a (global) variable as constant.\nnew\nAllocates a new struct-like object. First argument is the type. The new pseudo-function is lowered to this, and the type is always inserted by the compiler.  This is very much an internal-only feature, and does no checking. Evaluating arbitrary new expressions can easily segfault.\nsplatnew\nSimilar to new, except field values are passed as a single tuple. Works similarly to Base.splat(new) if new were a first-class function, hence the name.\nisdefined\nExpr(:isdefined, :x) returns a Bool indicating whether x has already been defined in the current scope.\nthe_exception\nYields the caught exception inside a catch block, as returned by jl_current_exception().\nenter\nEnters an exception handler (setjmp). args[1] is the label of the catch block to jump to on error.  Yields a token which is consumed by pop_exception.\nleave\nPop exception handlers. args[1] is the number of handlers to pop.\npop_exception\nPop the stack of current exceptions back to the state at the associated enter when leaving a catch block. args[1] contains the token from the associated enter.\ncompat: Julia 1.1\npop_exception is new in Julia 1.1.\ninbounds\nControls turning bounds checks on or off. A stack is maintained; if the first argument of this expression is true or false (true means bounds checks are disabled), it is pushed onto the stack. If the first argument is :pop, the stack is popped.\nboundscheck\nHas the value false if inlined into a section of code marked with @inbounds, otherwise has the value true.\nloopinfo\nMarks the end of the a loop. Contains metadata that is passed to LowerSimdLoop to either mark the inner loop of @simd expression, or to propagate information to LLVM loop passes.\ncopyast\nPart of the implementation of quasi-quote. The argument is a surface syntax AST that is simply copied recursively and returned at run time.\nmeta\nMetadata. args[1] is typically a symbol specifying the kind of metadata, and the rest of the arguments are free-form. The following kinds of metadata are commonly used:\n:inline and :noinline: Inlining hints.\nforeigncall\nStatically-computed container for ccall information. The fields are:\nargs[1] : name\nThe expression that'll be parsed for the foreign function.\nargs[2]::Type : RT\nThe (literal) return type, computed statically when the containing method was defined.\nargs[3]::SimpleVector (of Types) : AT\nThe (literal) vector of argument types, computed statically when the containing method was defined.\nargs[4]::Int : nreq\nThe number of required arguments for a varargs function definition.\nargs[5]::QuoteNode{Symbol} : calling convention\nThe calling convention for the call.\nargs[6:length(args[3])] : arguments\nThe values for all the arguments (with types of each given in args[3]).\nargs[(length(args[3]) + 1):end] : gc-roots\nThe additional objects that may need to be gc-rooted for the duration of the call. See Working with LLVM for where these are derived from and how they get handled.","page":"Julia ASTs"},{"title":"Method","location":"devdocs/ast.html#ast-lowered-method","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A unique'd container describing the shared metadata for a single method.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"name, module, file, line, sig\nMetadata to uniquely identify the method for the computer and the human.\nambig\nCache of other methods that may be ambiguous with this one.\nspecializations\nCache of all MethodInstance ever created for this Method, used to ensure uniqueness. Uniqueness is required for efficiency, especially for incremental precompile and tracking of method invalidation.\nsource\nThe original source code (if available, usually compressed).\ngenerator\nA callable object which can be executed to get specialized source for a specific method signature.\nroots\nPointers to non-AST things that have been interpolated into the AST, required by compression of the AST, type-inference, or the generation of native code.\nnargs, isva, called, isstaged, pure\nDescriptive bit-fields for the source code of this Method.\nprimary_world\nThe world age that \"owns\" this Method.","page":"Julia ASTs"},{"title":"MethodInstance","location":"devdocs/ast.html#MethodInstance","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A unique'd container describing a single callable signature for a Method. See especially Proper maintenance and care of multi-threading locks for important details on how to modify these fields safely.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"specTypes\nThe primary key for this MethodInstance. Uniqueness is guaranteed through a def.specializations lookup.\ndef\nThe Method that this function describes a specialization of. Or a Module, if this is a top-level Lambda expanded in Module, and which is not part of a Method.\nsparam_vals\nThe values of the static parameters in specTypes indexed by def.sparam_syms. For the MethodInstance at Method.unspecialized, this is the empty SimpleVector. But for a runtime MethodInstance from the MethodTable cache, this will always be defined and indexable.\nuninferred\nThe uncompressed source code for a toplevel thunk. Additionally, for a generated function, this is one of many places that the source code might be found.\nbackedges\nWe store the reverse-list of cache dependencies for efficient tracking of incremental reanalysis/recompilation work that may be needed after a new method definitions. This works by keeping a list of the other MethodInstance that have been inferred or optimized to contain a possible call to this MethodInstance. Those optimization results might be stored somewhere in the cache, or it might have been the result of something we didn't want to cache, such as constant propagation. Thus we merge all of those backedges to various cache entries here (there's almost always only the one applicable cache entry with a sentinel value for max_world anyways).\ncache\nCache of CodeInstance objects that share this template instantiation.","page":"Julia ASTs"},{"title":"CodeInstance","location":"devdocs/ast.html#CodeInstance","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"def\nThe MethodInstance that this cache entry is derived from.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"rettype/rettype_const\nThe inferred return type for the specFunctionObject field, which (in most cases) is also the computed return type for the function in general.\ninferred\nMay contain a cache of the inferred source for this function, or it could be set to nothing to just indicate rettype is inferred.\nftpr\nThe generic jlcall entry point.\njlcall_api\nThe ABI to use when calling fptr. Some significant ones include:\n0 - Not compiled yet\n1 - JLCALLABLE `jlvaluet ()(jlfunctiont *f, jlvaluet *args[nargs], uint32t nargs)`\n2 - Constant (value stored in rettype_const)\n3 - With Static-parameters forwarded jl_value_t *(*)(jl_svec_t *sparams, jl_function_t *f, jl_value_t *args[nargs], uint32_t nargs)\n4 - Run in interpreter jl_value_t *(*)(jl_method_instance_t *meth, jl_function_t *f, jl_value_t *args[nargs], uint32_t nargs)\nmin_world / max_world\nThe range of world ages for which this method instance is valid to be called. If max_world is the special token value -1, the value is not yet known. It may continue to be used until we encounter a backedge that requires us to reconsider.","page":"Julia ASTs"},{"title":"CodeInfo","location":"devdocs/ast.html#CodeInfo","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A (usually temporary) container for holding lowered source code.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"code\nAn Any array of statements\nslotnames\nAn array of symbols giving names for each slot (argument or local variable).\nslotflags\nA UInt8 array of slot properties, represented as bit flags:\n2  - assigned (only false if there are no assignment statements with this var on the left)\n8  - const (currently unused for local variables)\n16 - statically assigned once\n32 - might be used before assigned. This flag is only valid after type inference.\nssavaluetypes\nEither an array or an Int.\nIf an Int, it gives the number of compiler-inserted temporary locations in the function (the length of code array). If an array, specifies a type for each location.\nssaflags\nStatement-level flags for each expression in the function. Many of these are reserved, but not yet implemented:\n0 = inbounds\n1,2 = <reserved> inlinehint,always-inline,noinline\n3 = <reserved> strict-ieee (strictfp)\n4-6 = <unused>\n7 = <reserved> has out-of-band info\nlinetable\nAn array of source location objects\ncodelocs\nAn array of integer indices into the linetable, giving the location associated with each statement.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Optional Fields:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"slottypes\nAn array of types for the slots.\nrettype\nThe inferred return type of the lowered form (IR). Default value is Any.\nmethod_for_inference_limit_heuristics\nThe method_for_inference_heuristics will expand the given method's generator if necessary during inference.\nparent\nThe MethodInstance that \"owns\" this object (if applicable).\nmin_world/max_world\nThe range of world ages for which this code was valid at the time when it had been inferred.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Boolean properties:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"inferred\nWhether this has been produced by type inference.\ninlineable\nWhether this should be eligible for inlining.\npropagate_inbounds\nWhether this should propagate @inbounds when inlined for the purpose of eliding @boundscheck blocks.\npure\nWhether this is known to be a pure function of its arguments, without respect to the state of the method caches or other mutable global state.","page":"Julia ASTs"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html#man-custom-indices","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Conventionally, Julia's arrays are indexed starting at 1, whereas some other languages start numbering at 0, and yet others (e.g., Fortran) allow you to specify arbitrary starting indices.  While there is much merit in picking a standard (i.e., 1 for Julia), there are some algorithms which simplify considerably if you can index outside the range 1:size(A,d) (and not just 0:size(A,d)-1, either). To facilitate such computations, Julia supports arrays with arbitrary indices.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"The purpose of this page is to address the question, \"what do I have to do to support such arrays in my own code?\"  First, let's address the simplest case: if you know that your code will never need to handle arrays with unconventional indexing, hopefully the answer is \"nothing.\" Old code, on conventional arrays, should function essentially without alteration as long as it was using the exported interfaces of Julia. If you find it more convenient to just force your users to supply traditional arrays where indexing starts at one, you can add","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.require_one_based_indexing(arrays...)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"where arrays... is a list of the array objects that you wish to check for anything that violates 1-based indexing.","page":"Arrays with custom indices"},{"title":"Generalizing existing code","location":"devdocs/offset-arrays.html#Generalizing-existing-code","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"As an overview, the steps are:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"replace many uses of size with axes\nreplace 1:length(A) with eachindex(A), or in some cases LinearIndices(A)\nreplace explicit allocations like Array{Int}(undef, size(B)) with similar(Array{Int}, axes(B))","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"These are described in more detail below.","page":"Arrays with custom indices"},{"title":"Things to watch out for","location":"devdocs/offset-arrays.html#Things-to-watch-out-for","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Because unconventional indexing breaks many people's assumptions that all arrays start indexing with 1, there is always the chance that using such arrays will trigger errors. The most frustrating bugs would be incorrect results or segfaults (total crashes of Julia). For example, consider the following function:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"function mycopy!(dest::AbstractVector, src::AbstractVector)\n    length(dest) == length(src) || throw(DimensionMismatch(\"vectors must match\"))\n    # OK, now we're safe to use @inbounds, right? (not anymore!)\n    for i = 1:length(src)\n        @inbounds dest[i] = src[i]\n    end\n    dest\nend","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"This code implicitly assumes that vectors are indexed from 1; if dest starts at a different index than src, there is a chance that this code would trigger a segfault. (If you do get segfaults, to help locate the cause try running julia with the option --check-bounds=yes.)","page":"Arrays with custom indices"},{"title":"Using axes for bounds checks and loop iteration","location":"devdocs/offset-arrays.html#Using-axes-for-bounds-checks-and-loop-iteration","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"axes(A) (reminiscent of size(A)) returns a tuple of AbstractUnitRange{<:Integer} objects, specifying the range of valid indices along each dimension of A.  When A has unconventional indexing, the ranges may not start at 1.  If you just want the range for a particular dimension d, there is axes(A, d).","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base implements a custom range type, OneTo, where OneTo(n) means the same thing as 1:n but in a form that guarantees (via the type system) that the lower index is 1. For any new AbstractArray type, this is the default returned by axes, and it indicates that this array type uses \"conventional\" 1-based indexing.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"For bounds checking, note that there are dedicated functions checkbounds and checkindex which can sometimes simplify such tests.","page":"Arrays with custom indices"},{"title":"Linear indexing (LinearIndices)","location":"devdocs/offset-arrays.html#Linear-indexing-(LinearIndices)","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Some algorithms are most conveniently (or efficiently) written in terms of a single linear index, A[i] even if A is multi-dimensional. Regardless of the array's native indices, linear indices always range from 1:length(A). However, this raises an ambiguity for one-dimensional arrays (a.k.a., AbstractVector): does v[i] mean linear indexing , or Cartesian indexing with the array's native indices?","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"For this reason, your best option may be to iterate over the array with eachindex(A), or, if you require the indices to be sequential integers, to get the index range by calling LinearIndices(A). This will return axes(A, 1) if A is an AbstractVector, and the equivalent of 1:length(A) otherwise.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"By this definition, 1-dimensional arrays always use Cartesian indexing with the array's native indices. To help enforce this, it's worth noting that the index conversion functions will throw an error if shape indicates a 1-dimensional array with unconventional indexing (i.e., is a Tuple{UnitRange} rather than a tuple of OneTo). For arrays with conventional indexing, these functions continue to work the same as always.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Using axes and LinearIndices, here is one way you could rewrite mycopy!:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"function mycopy!(dest::AbstractVector, src::AbstractVector)\n    axes(dest) == axes(src) || throw(DimensionMismatch(\"vectors must match\"))\n    for i in LinearIndices(src)\n        @inbounds dest[i] = src[i]\n    end\n    dest\nend","page":"Arrays with custom indices"},{"title":"Allocating storage using generalizations of similar","location":"devdocs/offset-arrays.html#Allocating-storage-using-generalizations-of-similar","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Storage is often allocated with Array{Int}(undef, dims) or similar(A, args...). When the result needs to match the indices of some other array, this may not always suffice. The generic replacement for such patterns is to use similar(storagetype, shape).  storagetype indicates the kind of underlying \"conventional\" behavior you'd like, e.g., Array{Int} or BitArray or even dims->zeros(Float32, dims) (which would allocate an all-zeros array). shape is a tuple of Integer or AbstractUnitRange values, specifying the indices that you want the result to use. Note that a convenient way of producing an all-zeros array that matches the indices of A is simply zeros(A).","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Let's walk through a couple of explicit examples. First, if A has conventional indices, then similar(Array{Int}, axes(A)) would end up calling Array{Int}(undef, size(A)), and thus return an array.  If A is an AbstractArray type with unconventional indexing, then similar(Array{Int}, axes(A)) should return something that \"behaves like\" an Array{Int} but with a shape (including indices) that matches A.  (The most obvious implementation is to allocate an Array{Int}(undef, size(A)) and then \"wrap\" it in a type that shifts the indices.)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Note also that similar(Array{Int}, (axes(A, 2),)) would allocate an AbstractVector{Int} (i.e., 1-dimensional array) that matches the indices of the columns of A.","page":"Arrays with custom indices"},{"title":"Writing custom array types with non-1 indexing","location":"devdocs/offset-arrays.html#Writing-custom-array-types-with-non-1-indexing","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Most of the methods you'll need to define are standard for any AbstractArray type, see Abstract Arrays. This page focuses on the steps needed to define unconventional indexing.","page":"Arrays with custom indices"},{"title":"Custom AbstractUnitRange types","location":"devdocs/offset-arrays.html#Custom-AbstractUnitRange-types","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"If you're writing a non-1 indexed array type, you will want to specialize axes so it returns a UnitRange, or (perhaps better) a custom AbstractUnitRange.  The advantage of a custom type is that it \"signals\" the allocation type for functions like similar. If we're writing an array type for which indexing will start at 0, we likely want to begin by creating a new AbstractUnitRange, ZeroRange, where ZeroRange(n) is equivalent to 0:n-1.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"In general, you should probably not export ZeroRange from your package: there may be other packages that implement their own ZeroRange, and having multiple distinct ZeroRange types is (perhaps counterintuitively) an advantage: ModuleA.ZeroRange indicates that similar should create a ModuleA.ZeroArray, whereas ModuleB.ZeroRange indicates a ModuleB.ZeroArray type.  This design allows peaceful coexistence among many different custom array types.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Note that the Julia package CustomUnitRanges.jl can sometimes be used to avoid the need to write your own ZeroRange type.","page":"Arrays with custom indices"},{"title":"Specializing axes","location":"devdocs/offset-arrays.html#Specializing-axes","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Once you have your AbstractUnitRange type, then specialize axes:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.axes(A::ZeroArray) = map(n->ZeroRange(n), A.size)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"where here we imagine that ZeroArray has a field called size (there would be other ways to implement this).","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"In some cases, the fallback definition for axes(A, d):","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"axes(A::AbstractArray{T,N}, d) where {T,N} = d <= N ? axes(A)[d] : OneTo(1)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"may not be what you want: you may need to specialize it to return something other than OneTo(1) when d > ndims(A).  Likewise, in Base there is a dedicated function axes1 which is equivalent to axes(A, 1) but which avoids checking (at runtime) whether ndims(A) > 0. (This is purely a performance optimization.)  It is defined as:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"axes1(A::AbstractArray{T,0}) where {T} = OneTo(1)\naxes1(A::AbstractArray) = axes(A)[1]","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"If the first of these (the zero-dimensional case) is problematic for your custom array type, be sure to specialize it appropriately.","page":"Arrays with custom indices"},{"title":"Specializing similar","location":"devdocs/offset-arrays.html#Specializing-similar","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Given your custom ZeroRange type, then you should also add the following two specializations for similar:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"function Base.similar(A::AbstractArray, T::Type, shape::Tuple{ZeroRange,Vararg{ZeroRange}})\n    # body\nend\n\nfunction Base.similar(f::Union{Function,DataType}, shape::Tuple{ZeroRange,Vararg{ZeroRange}})\n    # body\nend","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Both of these should allocate your custom array type.","page":"Arrays with custom indices"},{"title":"Specializing reshape","location":"devdocs/offset-arrays.html#Specializing-reshape","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Optionally, define a method","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.reshape(A::AbstractArray, shape::Tuple{ZeroRange,Vararg{ZeroRange}}) = ...","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"and you can reshape an array so that the result has custom indices.","page":"Arrays with custom indices"},{"title":"For objects that mimic AbstractArray but are not subtypes","location":"devdocs/offset-arrays.html#For-objects-that-mimic-AbstractArray-but-are-not-subtypes","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"has_offset_axes depends on having axes defined for the objects you call it on. If there is some reason you don't have an axes method defined for your object, consider defining a method","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.has_offset_axes(obj::MyNon1IndexedArraylikeObject) = true","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"This will allow code that assumes 1-based indexing to detect a problem and throw a helpful error, rather than returning incorrect results or segfaulting julia.","page":"Arrays with custom indices"},{"title":"Catching errors","location":"devdocs/offset-arrays.html#Catching-errors","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"If your new array type triggers errors in other code, one helpful debugging step can be to comment out @boundscheck in your getindex and setindex! implementation. This will ensure that every element access checks bounds. Or, restart julia with --check-bounds=yes.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"In some cases it may also be helpful to temporarily disable size and length for your new array type, since code that makes incorrect assumptions frequently uses these functions.","page":"Arrays with custom indices"},{"title":"SubArrays","location":"devdocs/subarrays.html#SubArrays","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Julia's SubArray type is a container encoding a \"view\" of a parent AbstractArray.  This page documents some of the design principles and implementation of SubArrays.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"One of the major design goals is to ensure high performance for views of both IndexLinear and IndexCartesian arrays. Furthermore, views of IndexLinear arrays should themselves be IndexLinear to the extent that it is possible.","page":"SubArrays"},{"title":"Index replacement","location":"devdocs/subarrays.html#Index-replacement","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Consider making 2d slices of a 3d array:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"DocTestSetup = :(import Random; Random.seed!(1234))","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> A = rand(2,3,4);\n\njulia> S1 = view(A, :, 1, 2:3)\n2×2 view(::Array{Float64, 3}, :, 1, 2:3) with eltype Float64:\n 0.200586  0.066423\n 0.298614  0.956753\n\njulia> S2 = view(A, 1, :, 2:3)\n3×2 view(::Array{Float64, 3}, 1, :, 2:3) with eltype Float64:\n 0.200586  0.066423\n 0.246837  0.646691\n 0.648882  0.276021","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"DocTestSetup = nothing","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"view drops \"singleton\" dimensions (ones that are specified by an Int), so both S1 and S2 are two-dimensional SubArrays. Consequently, the natural way to index these is with S1[i,j]. To extract the value from the parent array A, the natural approach is to replace S1[i,j] with A[i,1,(2:3)[j]] and S2[i,j] with A[1,i,(2:3)[j]].","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"The key feature of the design of SubArrays is that this index replacement can be performed without any runtime overhead.","page":"SubArrays"},{"title":"SubArray design","location":"devdocs/subarrays.html#SubArray-design","category":"section","text":"","page":"SubArrays"},{"title":"Type parameters and fields","location":"devdocs/subarrays.html#Type-parameters-and-fields","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"The strategy adopted is first and foremost expressed in the definition of the type:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"struct SubArray{T,N,P,I,L} <: AbstractArray{T,N}\n    parent::P\n    indices::I\n    offset1::Int       # for linear indexing and pointer, only valid when L==true\n    stride1::Int       # used only for linear indexing\n    ...\nend","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"SubArray has 5 type parameters.  The first two are the standard element type and dimensionality.  The next is the type of the parent AbstractArray.  The most heavily-used is the fourth parameter, a Tuple of the types of the indices for each dimension. The final one, L, is only provided as a convenience for dispatch; it's a boolean that represents whether the index types support fast linear indexing. More on that later.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"If in our example above A is a Array{Float64, 3}, our S1 case above would be a SubArray{Float64,2,Array{Float64,3},Tuple{Base.Slice{Base.OneTo{Int64}},Int64,UnitRange{Int64}},false}. Note in particular the tuple parameter, which stores the types of the indices used to create S1. Likewise,","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> S1.indices\n(Base.Slice(Base.OneTo(2)), 1, 2:3)","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Storing these values allows index replacement, and having the types encoded as parameters allows one to dispatch to efficient algorithms.","page":"SubArrays"},{"title":"Index translation","location":"devdocs/subarrays.html#Index-translation","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Performing index translation requires that you do different things for different concrete SubArray types.  For example, for S1, one needs to apply the i,j indices to the first and third dimensions of the parent array, whereas for S2 one needs to apply them to the second and third.  The simplest approach to indexing would be to do the type-analysis at runtime:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"parentindices = Vector{Any}()\nfor thisindex in S.indices\n    ...\n    if isa(thisindex, Int)\n        # Don't consume one of the input indices\n        push!(parentindices, thisindex)\n    elseif isa(thisindex, AbstractVector)\n        # Consume an input index\n        push!(parentindices, thisindex[inputindex[j]])\n        j += 1\n    elseif isa(thisindex, AbstractMatrix)\n        # Consume two input indices\n        push!(parentindices, thisindex[inputindex[j], inputindex[j+1]])\n        j += 2\n    elseif ...\nend\nS.parent[parentindices...]","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Unfortunately, this would be disastrous in terms of performance: each element access would allocate memory, and involves the running of a lot of poorly-typed code.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"The better approach is to dispatch to specific methods to handle each type of stored index. That's what reindex does: it dispatches on the type of the first stored index and consumes the appropriate number of input indices, and then it recurses on the remaining indices. In the case of S1, this expands to","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Base.reindex(S1, S1.indices, (i, j)) == (i, S1.indices[2], S1.indices[3][j])","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"for any pair of indices (i,j) (except CartesianIndexs and arrays thereof, see below).","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"This is the core of a SubArray; indexing methods depend upon reindex to do this index translation. Sometimes, though, we can avoid the indirection and make it even faster.","page":"SubArrays"},{"title":"Linear indexing","location":"devdocs/subarrays.html#Linear-indexing","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Linear indexing can be implemented efficiently when the entire array has a single stride that separates successive elements, starting from some offset. This means that we can pre-compute these values and represent linear indexing simply as an addition and multiplication, avoiding the indirection of reindex and (more importantly) the slow computation of the cartesian coordinates entirely.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"For SubArray types, the availability of efficient linear indexing is based purely on the types of the indices, and does not depend on values like the size of the parent array. You can ask whether a given set of indices supports fast linear indexing with the internal Base.viewindexing function:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> Base.viewindexing(S1.indices)\nIndexCartesian()\n\njulia> Base.viewindexing(S2.indices)\nIndexLinear()","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"This is computed during construction of the SubArray and stored in the L type parameter as a boolean that encodes fast linear indexing support. While not strictly necessary, it means that we can define dispatch directly on SubArray{T,N,A,I,true} without any intermediaries.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Since this computation doesn't depend on runtime values, it can miss some cases in which the stride happens to be uniform:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> A = reshape(1:4*2, 4, 2)\n4×2 reshape(::UnitRange{Int64}, 4, 2) with eltype Int64:\n 1  5\n 2  6\n 3  7\n 4  8\n\njulia> diff(A[2:2:4,:][:])\n3-element Vector{Int64}:\n 2\n 2\n 2","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"A view constructed as view(A, 2:2:4, :) happens to have uniform stride, and therefore linear indexing indeed could be performed efficiently.  However, success in this case depends on the size of the array: if the first dimension instead were odd,","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> A = reshape(1:5*2, 5, 2)\n5×2 reshape(::UnitRange{Int64}, 5, 2) with eltype Int64:\n 1   6\n 2   7\n 3   8\n 4   9\n 5  10\n\njulia> diff(A[2:2:4,:][:])\n3-element Vector{Int64}:\n 2\n 3\n 2","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"then A[2:2:4,:] does not have uniform stride, so we cannot guarantee efficient linear indexing.  Since we have to base this decision based purely on types encoded in the parameters of the SubArray, S = view(A, 2:2:4, :) cannot implement efficient linear indexing.","page":"SubArrays"},{"title":"A few details","location":"devdocs/subarrays.html#A-few-details","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Note that the Base.reindex function is agnostic to the types of the input indices; it simply determines how and where the stored indices should be reindexed. It not only supports integer indices, but it supports non-scalar indexing, too. This means that views of views don't need two levels of indirection; they can simply re-compute the indices into the original parent array!\nHopefully by now it's fairly clear that supporting slices means that the dimensionality, given by the parameter N, is not necessarily equal to the dimensionality of the parent array or the length of the indices tuple.  Neither do user-supplied indices necessarily line up with entries in the indices tuple (e.g., the second user-supplied index might correspond to the third dimension of the parent array, and the third element in the indices tuple).\nWhat might be less obvious is that the dimensionality of the stored parent array must be equal to the number of effective indices in the indices tuple. Some examples:\nA = reshape(1:35, 5, 7) # A 2d parent Array\nS = view(A, 2:7)         # A 1d view created by linear indexing\nS = view(A, :, :, 1:1)   # Appending extra indices is supported\nNaively, you'd think you could just set S.parent = A and S.indices = (:,:,1:1), but supporting this dramatically complicates the reindexing process, especially for views of views. Not only do you need to dispatch on the types of the stored indices, but you need to examine whether a given index is the final one and \"merge\" any remaining stored indices together. This is not an easy task, and even worse: it's slow since it implicitly depends upon linear indexing.\nFortunately, this is precisely the computation that ReshapedArray performs, and it does so linearly if possible. Consequently, view ensures that the parent array is the appropriate dimensionality for the given indices by reshaping it if needed. The inner SubArray constructor ensures that this invariant is satisfied.\nCartesianIndex and arrays thereof throw a nasty wrench into the reindex scheme. Recall that reindex simply dispatches on the type of the stored indices in order to determine how many passed indices should be used and where they should go. But with CartesianIndex, there's no longer a one-to-one correspondence between the number of passed arguments and the number of dimensions that they index into. If we return to the above example of Base.reindex(S1, S1.indices, (i, j)), you can see that the expansion is incorrect for i, j = CartesianIndex(), CartesianIndex(2,1). It should skip the CartesianIndex() entirely and return:\n(CartesianIndex(2,1)[1], S1.indices[2], S1.indices[3][CartesianIndex(2,1)[2]])\nInstead, though, we get:\n(CartesianIndex(), S1.indices[2], S1.indices[3][CartesianIndex(2,1)])\nDoing this correctly would require combined dispatch on both the stored and passed indices across all combinations of dimensionalities in an intractable manner. As such, reindex must never be called with CartesianIndex indices. Fortunately, the scalar case is easily handled by first flattening the CartesianIndex arguments to plain integers. Arrays of CartesianIndex, however, cannot be split apart into orthogonal pieces so easily. Before attempting to use reindex, view must ensure that there are no arrays of CartesianIndex in the argument list. If there are, it can simply \"punt\" by avoiding the reindex calculation entirely, constructing a nested SubArray with two levels of indirection instead.","page":"SubArrays"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html#Networking-and-Streams","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Julia provides a rich interface to deal with streaming I/O objects such as terminals, pipes and TCP sockets. This interface, though asynchronous at the system level, is presented in a synchronous manner to the programmer and it is usually unnecessary to think about the underlying asynchronous operation. This is achieved by making heavy use of Julia cooperative threading (coroutine) functionality.","page":"Networking and Streams"},{"title":"Basic Stream I/O","location":"manual/networking-and-streams.html#Basic-Stream-I/O","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"All Julia streams expose at least a read and a write method, taking the stream as their first argument, e.g.:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> write(stdout, \"Hello World\");  # suppress return value 11 with ;\nHello World\njulia> read(stdin, Char)\n\n'\\n': ASCII/Unicode U+000a (category Cc: Other, control)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that write returns 11, the number of bytes (in \"Hello World\") written to stdout, but this return value is suppressed with the ;.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Here Enter was pressed again so that Julia would read the newline. Now, as you can see from this example, write takes the data to write as its second argument, while read takes the type of the data to be read as the second argument.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"For example, to read a simple byte array, we could do:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> x = zeros(UInt8, 4)\n4-element Array{UInt8,1}:\n 0x00\n 0x00\n 0x00\n 0x00\n\njulia> read!(stdin, x)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"However, since this is slightly cumbersome, there are several convenience methods provided. For example, we could have written the above as:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> read(stdin, 4)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"or if we had wanted to read the entire line instead:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> readline(stdin)\nabcd\n\"abcd\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that depending on your terminal settings, your TTY may be line buffered and might thus require an additional enter before the data is sent to Julia.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To read every line from stdin you can use eachline:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"for line in eachline(stdin)\n    print(\"Found $line\")\nend","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"or read if you wanted to read by character instead:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"while !eof(stdin)\n    x = read(stdin, Char)\n    println(\"Found: $x\")\nend","page":"Networking and Streams"},{"title":"Text I/O","location":"manual/networking-and-streams.html#Text-I/O","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that the write method mentioned above operates on binary streams. In particular, values do not get converted to any canonical text representation but are written out as is:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> write(stdout, 0x61);  # suppress return value 1 with ;\na","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that a is written to stdout by the write function and that the returned value is 1 (since 0x61 is one byte).","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"For text I/O, use the print or show methods, depending on your needs (see the documentation for these two methods for a detailed discussion of the difference between them):","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> print(stdout, 0x61)\n97","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"See Custom pretty-printing for more information on how to implement display methods for custom types.","page":"Networking and Streams"},{"title":"IO Output Contextual Properties","location":"manual/networking-and-streams.html#IO-Output-Contextual-Properties","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Sometimes IO output can benefit from the ability to pass contextual information into show methods. The IOContext object provides this framework for associating arbitrary metadata with an IO object. For example, :compact => true adds a hinting parameter to the IO object that the invoked show method should print a shorter output (if applicable). See the IOContext documentation for a list of common properties.","page":"Networking and Streams"},{"title":"Working with Files","location":"manual/networking-and-streams.html#Working-with-Files","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Like many other environments, Julia has an open function, which takes a filename and returns an IOStream object that you can use to read and write things from the file. For example, if we have a file, hello.txt, whose contents are Hello, World!:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> f = open(\"hello.txt\")\nIOStream(<file hello.txt>)\n\njulia> readlines(f)\n1-element Array{String,1}:\n \"Hello, World!\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"If you want to write to a file, you can open it with the write (\"w\") flag:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> f = open(\"hello.txt\",\"w\")\nIOStream(<file hello.txt>)\n\njulia> write(f,\"Hello again.\")\n12","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"If you examine the contents of hello.txt at this point, you will notice that it is empty; nothing has actually been written to disk yet. This is because the IOStream must be closed before the write is actually flushed to disk:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> close(f)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Examining hello.txt again will show its contents have been changed.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Opening a file, doing something to its contents, and closing it again is a very common pattern. To make this easier, there exists another invocation of open which takes a function as its first argument and filename as its second, opens the file, calls the function with the file as an argument, and then closes it again. For example, given a function:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"function read_and_capitalize(f::IOStream)\n    return uppercase(read(f, String))\nend","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"You can call:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> open(read_and_capitalize, \"hello.txt\")\n\"HELLO AGAIN.\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"to open hello.txt, call read_and_capitalize on it, close hello.txt and return the capitalized contents.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To avoid even having to define a named function, you can use the do syntax, which creates an anonymous function on the fly:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> open(\"hello.txt\") do f\n           uppercase(read(f, String))\n       end\n\"HELLO AGAIN.\"","page":"Networking and Streams"},{"title":"A simple TCP example","location":"manual/networking-and-streams.html#A-simple-TCP-example","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Let's jump right in with a simple example involving TCP sockets. This functionality is in a standard library package called Sockets. Let's first create a simple server:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> using Sockets\n\njulia> @async begin\n           server = listen(2000)\n           while true\n               sock = accept(server)\n               println(\"Hello World\\n\")\n           end\n       end\nTask (runnable) @0x00007fd31dc11ae0","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To those familiar with the Unix socket API, the method names will feel familiar, though their usage is somewhat simpler than the raw Unix socket API. The first call to listen will create a server waiting for incoming connections on the specified port (2000) in this case. The same function may also be used to create various other kinds of servers:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> listen(2000) # Listens on localhost:2000 (IPv4)\nSockets.TCPServer(active)\n\njulia> listen(ip\"127.0.0.1\",2000) # Equivalent to the first\nSockets.TCPServer(active)\n\njulia> listen(ip\"::1\",2000) # Listens on localhost:2000 (IPv6)\nSockets.TCPServer(active)\n\njulia> listen(IPv4(0),2001) # Listens on port 2001 on all IPv4 interfaces\nSockets.TCPServer(active)\n\njulia> listen(IPv6(0),2001) # Listens on port 2001 on all IPv6 interfaces\nSockets.TCPServer(active)\n\njulia> listen(\"testsocket\") # Listens on a UNIX domain socket\nSockets.PipeServer(active)\n\njulia> listen(\"\\\\\\\\.\\\\pipe\\\\testsocket\") # Listens on a Windows named pipe\nSockets.PipeServer(active)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that the return type of the last invocation is different. This is because this server does not listen on TCP, but rather on a named pipe (Windows) or UNIX domain socket. Also note that Windows named pipe format has to be a specific pattern such that the name prefix (\\\\.\\pipe\\) uniquely identifies the file type. The difference between TCP and named pipes or UNIX domain sockets is subtle and has to do with the accept and connect methods. The accept method retrieves a connection to the client that is connecting on the server we just created, while the connect function connects to a server using the specified method. The connect function takes the same arguments as listen, so, assuming the environment (i.e. host, cwd, etc.) is the same you should be able to pass the same arguments to connect as you did to listen to establish the connection. So let's try that out (after having created the server above):","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> connect(2000)\nTCPSocket(open, 0 bytes waiting)\n\njulia> Hello World","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"As expected we saw \"Hello World\" printed. So, let's actually analyze what happened behind the scenes. When we called connect, we connect to the server we had just created. Meanwhile, the accept function returns a server-side connection to the newly created socket and prints \"Hello World\" to indicate that the connection was successful.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"A great strength of Julia is that since the API is exposed synchronously even though the I/O is actually happening asynchronously, we didn't have to worry about callbacks or even making sure that the server gets to run. When we called connect the current task waited for the connection to be established and only continued executing after that was done. In this pause, the server task resumed execution (because a connection request was now available), accepted the connection, printed the message and waited for the next client. Reading and writing works in the same way. To see this, consider the following simple echo server:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> @async begin\n           server = listen(2001)\n           while true\n               sock = accept(server)\n               @async while isopen(sock)\n                   write(sock, readline(sock, keep=true))\n               end\n           end\n       end\nTask (runnable) @0x00007fd31dc12e60\n\njulia> clientside = connect(2001)\nTCPSocket(RawFD(28) open, 0 bytes waiting)\n\njulia> @async while isopen(clientside)\n           write(stdout, readline(clientside, keep=true))\n       end\nTask (runnable) @0x00007fd31dc11870\n\njulia> println(clientside,\"Hello World from the Echo Server\")\nHello World from the Echo Server","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"As with other streams, use close to disconnect the socket:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> close(clientside)","page":"Networking and Streams"},{"title":"Resolving IP Addresses","location":"manual/networking-and-streams.html#Resolving-IP-Addresses","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"One of the connect methods that does not follow the listen methods is connect(host::String,port), which will attempt to connect to the host given by the host parameter on the port given by the port parameter. It allows you to do things like:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> connect(\"google.com\", 80)\nTCPSocket(RawFD(30) open, 0 bytes waiting)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"At the base of this functionality is getaddrinfo, which will do the appropriate address resolution:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> getaddrinfo(\"google.com\")\nip\"74.125.226.225\"","page":"Networking and Streams"},{"title":"Asynchronous I/O","location":"manual/networking-and-streams.html#Asynchronous-I/O","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"All I/O operations exposed by Base.read and Base.write can be performed asynchronously through the use of coroutines. You can create a new coroutine to read from or write to a stream using the @async macro:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> task = @async open(\"foo.txt\", \"w\") do io\n           write(io, \"Hello, World!\")\n       end;\n\njulia> wait(task)\n\njulia> readlines(\"foo.txt\")\n1-element Array{String,1}:\n \"Hello, World!\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"It's common to run into situations where you want to perform multiple asynchronous operations concurrently and wait until they've all completed. You can use the @sync macro to cause your program to block until all of the coroutines it wraps around have exited:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> using Sockets\n\njulia> @sync for hostname in (\"google.com\", \"github.com\", \"julialang.org\")\n           @async begin\n               conn = connect(hostname, 80)\n               write(conn, \"GET / HTTP/1.1\\r\\nHost:$(hostname)\\r\\n\\r\\n\")\n               readline(conn, keep=true)\n               println(\"Finished connection to $(hostname)\")\n           end\n       end\nFinished connection to google.com\nFinished connection to julialang.org\nFinished connection to github.com","page":"Networking and Streams"},{"title":"SHA","location":"stdlib/SHA.html#SHA","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Usage is very straightforward:","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"julia> using SHA\n\njulia> bytes2hex(sha256(\"test\"))\n\"9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08\"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Each exported function (at the time of this writing, SHA-1, SHA-2 224, 256, 384 and 512, and SHA-3 224, 256, 384 and 512 functions are implemented) takes in either an AbstractVector{UInt8}, an AbstractString or an IO object.  This makes it trivial to checksum a file:","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"shell> cat /tmp/test.txt\ntest\njulia> using SHA\n\njulia> open(\"/tmp/test.txt\") do f\n           sha2_256(f)\n       end\n32-element Array{UInt8,1}:\n 0x9f\n 0x86\n 0xd0\n 0x81\n 0x88\n 0x4c\n 0x7d\n 0x65\n    ⋮\n 0x5d\n 0x6c\n 0x15\n 0xb0\n 0xf0\n 0x0a\n 0x08","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Due to the colloquial usage of sha256 to refer to sha2_256, convenience functions are provided, mapping shaxxx() function calls to sha2_xxx().  For SHA-3, no such colloquialisms exist and the user must use the full sha3_xxx() names.","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"shaxxx() takes AbstractString and array-like objects (NTuple and Array) with elements of type UInt8.","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"To create a hash from multiple items the SHAX_XXX_CTX() types can be used to create a stateful hash object that is updated with update! and finalized with digest!","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"julia> ctx = SHA2_256_CTX()\nSHA2 256-bit hash state\n\njulia> update!(ctx, b\"some data\")\n0x0000000000000009\n\njulia> update!(ctx, b\"some more data\")\n0x0000000000000017\n\njulia> digest!(ctx)\n32-element Vector{UInt8}:\n 0xbe\n 0xcf\n 0x23\n 0xda\n 0xaf\n 0x02\n    ⋮\n 0x25\n 0x52\n 0x19\n 0xa0\n 0x8b\n 0xc5","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Note that, at the time of this writing, the SHA3 code is not optimized, and as such is roughly an order of magnitude slower than SHA2.","page":"SHA"},{"title":"TOML","location":"stdlib/TOML.html#TOML","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"TOML.jl is a Julia standard library for parsing and writing TOML v1.0 files.","page":"TOML"},{"title":"Parsing TOML data","location":"stdlib/TOML.html#Parsing-TOML-data","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> data = \"\"\"\n           [database]\n           server = \"192.168.1.1\"\n           ports = [ 8001, 8001, 8002 ]\n       \"\"\";\n\njulia> TOML.parse(data)\nDict{String, Any} with 1 entry:\n  \"database\" => Dict{String, Any}(\"server\"=>\"192.168.1.1\", \"ports\"=>[8001, 8001…","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"To parse a file, use TOML.parsefile. If the file has a syntax error, an exception is thrown:","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> TOML.parse(\"\"\"\n           value = 0.0.0\n       \"\"\")\nERROR: TOML Parser error:\nnone:1:16 error: failed to parse value\n      value = 0.0.0\n                 ^\n[...]","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"There are other versions of the parse functions (TOML.tryparse and [TOML.tryparsefile]) that instead of throwing exceptions on parser error returns a TOML.ParserError with information:","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> err = TOML.tryparse(\"\"\"\n           value = 0.0.0\n       \"\"\");\n\njulia> err.type\nErrGenericValueError::ErrorType = 14\n\njulia> err.line\n1\n\njulia> err.column\n16","page":"TOML"},{"title":"Exporting data to TOML file","location":"stdlib/TOML.html#Exporting-data-to-TOML-file","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"The TOML.print function is used to print (or serialize) data into TOML format.","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> fname = tempname();\n\njulia> data = Dict(\n          \"names\" => [\"Julia\", \"Julio\"],\n          \"age\" => [10, 20],\n       );\n\njulia> TOML.print(data)\nnames = [\"Julia\", \"Julio\"]\nage = [10, 20]","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"Keys can be sorted according to some value","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> TOML.print(Dict(\n       \"abc\"  => 1,\n       \"ab\"   => 2,\n       \"abcd\" => 3,\n       ); sorted=true, by=length)\nab = 2\nabc = 1\nabcd = 3","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"For custom structs, pass a function that converts the struct to a supported type","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> struct MyStruct\n           a::Int\n           b::String\n       end\n\njulia> TOML.print(Dict(\"foo\" => MyStruct(5, \"bar\"))) do x\n           x isa MyStruct && return [x.a, x.b]\n           error(\"unhandled type $(typeof(x))\")\n       end\nfoo = [5, \"bar\"]","page":"TOML"},{"title":"References","location":"stdlib/TOML.html#References","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"TOML.parse\nTOML.parsefile\nTOML.tryparse\nTOML.tryparsefile\nTOML.print\nTOML.Parser\nTOML.ParserError","page":"TOML"},{"title":"TOML.parse","location":"stdlib/TOML.html#TOML.parse","category":"function","text":"parse(x::Union{AbstractString, IO})\nparse(p::Parser, x::Union{AbstractString, IO})\n\nParse the string  or stream x, and return the resulting table (dictionary). Throw a ParserError upon failure.\n\nSee also: TOML.tryparse\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.parsefile","location":"stdlib/TOML.html#TOML.parsefile","category":"function","text":"parsefile(f::AbstractString)\nparsefile(p::Parser, f::AbstractString)\n\nParse file f and return the resulting table (dictionary). Throw a ParserError upon failure.\n\nSee also: TOML.tryparsefile\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.tryparse","location":"stdlib/TOML.html#TOML.tryparse","category":"function","text":"tryparse(x::Union{AbstractString, IO})\ntryparse(p::Parser, x::Union{AbstractString, IO})\n\nParse the string or stream x, and return the resulting table (dictionary). Return a ParserError upon failure.\n\nSee also: TOML.parse\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.tryparsefile","location":"stdlib/TOML.html#TOML.tryparsefile","category":"function","text":"tryparsefile(f::AbstractString)\ntryparsefile(p::Parser, f::AbstractString)\n\nParse file f and return the resulting table (dictionary). Return a ParserError upon failure.\n\nSee also: TOML.parsefile\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.print","location":"stdlib/TOML.html#TOML.print","category":"function","text":"print([to_toml::Function], io::IO [=stdout], data::AbstractDict; sorted=false, by=identity)\n\nWrite data as TOML syntax to the stream io. If the keyword argument sorted is set to true, sort tables according to the function given by the keyword argument by.\n\nThe following data types are supported: AbstractDict, Integer, AbstractFloat, Bool, Dates.DateTime, Dates.Time, Dates.Date. Note that the integers and floats need to be convertible to Float64 and Int64 respectively. For other data types, pass the function to_toml that takes the data types and returns a value of a supported type.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.Parser","location":"stdlib/TOML.html#TOML.Parser","category":"type","text":"Parser()\n\nConstructor for a TOML Parser.  Note that in most cases one does not need to explicitly create a Parser but instead one directly use use TOML.parsefile or TOML.parse.  Using an explicit parser will however reuse some internal data structures which can be beneficial for performance if a larger number of small files are parsed.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.ParserError","location":"stdlib/TOML.html#TOML.ParserError","category":"type","text":"ParserError\n\nType that is returned from tryparse and tryparsefile when parsing fails. It contains (among others) the following fields:\n\npos, the position in the string when the error happened\ntable, the result that so far was successfully parsed\ntype, an error type, different for different types of errors\n\n\n\n\n\n","page":"TOML"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html#Sparse-Linear-Algebra","category":"section","text":"","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"DocTestSetup = :(using LinearAlgebra, SparseArrays, SuiteSparse)","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"Sparse matrix solvers call functions from SuiteSparse. The following factorizations are available:","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"Type Description\nSuiteSparse.CHOLMOD.Factor Cholesky factorization\nSuiteSparse.UMFPACK.UmfpackLU LU factorization\nSuiteSparse.SPQR.QRSparse QR factorization","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"Other solvers such as Pardiso.jl are as external packages. Arpack.jl provides eigs and svds for iterative solution of eigensystems and singular value decompositions.","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"These factorizations are described in the Linear Algebra section of the manual:","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"cholesky\nldlt\nlu\nqr","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"SuiteSparse.CHOLMOD.lowrankupdate\nSuiteSparse.CHOLMOD.lowrankupdate!\nSuiteSparse.CHOLMOD.lowrankdowndate\nSuiteSparse.CHOLMOD.lowrankdowndate!\nSuiteSparse.CHOLMOD.lowrankupdowndate!","page":"Sparse Linear Algebra"},{"title":"SuiteSparse.CHOLMOD.lowrankupdate","location":"stdlib/SuiteSparse.html#SuiteSparse.CHOLMOD.lowrankupdate","category":"function","text":"lowrankupdate(F::CHOLMOD.Factor, C::AbstractArray) -> FF::CHOLMOD.Factor\n\nGet an LDLt Factorization of A + C*C' given an LDLt or LLt factorization F of A.\n\nThe returned factor is always an LDLt factorization.\n\nSee also lowrankupdate!, lowrankdowndate, lowrankdowndate!.\n\n\n\n\n\n","page":"Sparse Linear Algebra"},{"title":"SuiteSparse.CHOLMOD.lowrankupdate!","location":"stdlib/SuiteSparse.html#SuiteSparse.CHOLMOD.lowrankupdate!","category":"function","text":"lowrankupdate!(F::CHOLMOD.Factor, C::AbstractArray)\n\nUpdate an LDLt or LLt Factorization F of A to a factorization of A + C*C'.\n\nLLt factorizations are converted to LDLt.\n\nSee also lowrankupdate, lowrankdowndate, lowrankdowndate!.\n\n\n\n\n\n","page":"Sparse Linear Algebra"},{"title":"SuiteSparse.CHOLMOD.lowrankdowndate","location":"stdlib/SuiteSparse.html#SuiteSparse.CHOLMOD.lowrankdowndate","category":"function","text":"lowrankupdate(F::CHOLMOD.Factor, C::AbstractArray) -> FF::CHOLMOD.Factor\n\nGet an LDLt Factorization of A + C*C' given an LDLt or LLt factorization F of A.\n\nThe returned factor is always an LDLt factorization.\n\nSee also lowrankdowndate!, lowrankupdate, lowrankupdate!.\n\n\n\n\n\n","page":"Sparse Linear Algebra"},{"title":"SuiteSparse.CHOLMOD.lowrankdowndate!","location":"stdlib/SuiteSparse.html#SuiteSparse.CHOLMOD.lowrankdowndate!","category":"function","text":"lowrankdowndate!(F::CHOLMOD.Factor, C::AbstractArray)\n\nUpdate an LDLt or LLt Factorization F of A to a factorization of A - C*C'.\n\nLLt factorizations are converted to LDLt.\n\nSee also lowrankdowndate, lowrankupdate, lowrankupdate!.\n\n\n\n\n\n","page":"Sparse Linear Algebra"},{"title":"SuiteSparse.CHOLMOD.lowrankupdowndate!","location":"stdlib/SuiteSparse.html#SuiteSparse.CHOLMOD.lowrankupdowndate!","category":"function","text":"lowrankupdowndate!(F::CHOLMOD.Factor, C::Sparse, update::Cint)\n\nUpdate an LDLt or LLt Factorization F of A to a factorization of A ± C*C'.\n\nIf sparsity preserving factorization is used, i.e. L*L' == P*A*P' then the new factor will be L*L' == P*A*P' + C'*C\n\nupdate: Cint(1) for A + CC', Cint(0) for A - CC'\n\n\n\n\n\n","page":"Sparse Linear Algebra"},{"title":"Sparse Linear Algebra","location":"stdlib/SuiteSparse.html","category":"page","text":"DocTestSetup = nothing","page":"Sparse Linear Algebra"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html#Static-analyzer-annotations-for-GC-correctness-in-C-code","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Running the analysis","location":"devdocs/gc-sa.html#Running-the-analysis","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The analyzer plugin that drives the anlysis ships with julia. Its source code can be found in src/clangsa. Running it requires the clang dependency to be build. Set the BUILD_LLVM_CLANG variable in your Make.user in order to build an appropriate version of clang. You may also want to use the prebuilt binaries using the USE_BINARYBUILDER_LLVM options. Afterwards, running the analysis over the source tree is as simple as running make -C src analyzegc.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"General Overview","location":"devdocs/gc-sa.html#General-Overview","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Since Julia's GC is precise, it needs to maintain correct rooting information for any value that may be referenced at any time GC may occur. These places are known as safepoints and in the function local context, we extend this designation to any function call that may recursively end up at a safepoint.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"In generated code, this is taken care of automatically by the GC root placement pass (see the chapter on GC rooting in the LLVM codegen devdocs). However, in C code, we need to inform the runtime of any GC roots manually. This is done using the following macros:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"// The value assigned to any slot passed as an argument to these\n// is rooted for the duration of this GC frame.\nJL_GC_PUSH{1,...,6}(args...)\n// The values assigned into the size `n` array `rts` are rooted\n// for the duration of this GC frame.\nJL_GC_PUSHARGS(rts, n)\n// Pop a GC frame\nJL_GC_POP","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"If these macros are not used where they need to be, or they are used incorrectly, the result is silent memory corruption. As such it is very important that they are placed correctly in all applicable code.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"As such, we employ static analysis (and in particular the clang static analyzer) to help ensure that these macros are used correctly. The remainder of this document gives an overview of this static analysis and describes the support needed in the julia code base to make things work.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"GC Invariants","location":"devdocs/gc-sa.html#GC-Invariants","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"There is two simple invariants correctness:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"All GC_PUSH calls need to be followed by an appropriate GC_POP (in practice we enforce this at the function level)\nIf a value was previously not rooted at any safepoint, it may no longer be referenced afterwards","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Of course the devil is in the details here. In particular to satisfy the second of the above conditions, we need to know:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Which calls are safepoints and which are not\nWhich values are rooted at any given safepoint and which are not\nWhen is a value referenced","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"For the second point in particular, we need to know which memory locations will be considered rooting at runtime (i.e. values assigned to such locations are rooted). This includes locations explicitly designated as such by passing them to one of the GC_PUSH macros, globally rooted locations and values, as well as any location recursively reachable from one of those locations.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static Analysis Algorithm","location":"devdocs/gc-sa.html#Static-Analysis-Algorithm","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The idea itself is very simple, although the implementation is quite a bit more complicated (mainly due to a large number of special cases and intricacies of C and C++). In essence, we keep track of all locations that are rooting, all values that are rootable and any expression (assignments, allocations, etc) affect the rootedness of any rootable values. Then, at any safepoint, we perform a \"symbolic GC\" and poison any values that are not rooted at said location. If these values are later referenced, we emit an error.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The clang static analyzer works by constructing a graph of states and exploring this graph for sources of errors. Several nodes in this graph are generated by the analyzer itself (e.g. for control flow), but the definitions above augment this graph with our own state.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The static analyzer is interprocedural and can analyze control flow across function boundaries. However, the static analyzer is not fully recursive and makes heuristic decisions about which calls to explore (additionally some calls are cross-translation unit and invisible to the analyzer). In our case, our definition of correctness requires total information. As such, we need to annotate the prototypes of all function calls with whatever information the analysis required, even if that information would otherwise be available by interprocedural static analysis.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Luckily however, we can still use this interprocedural analysis to ensure that the annotations we place on a given function are indeed correct given the implementation of said function.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"The analyzer annotations","location":"devdocs/gc-sa.html#The-analyzer-annotations","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"These annotations are found in src/support/analyzer_annotations.h. The are only active when the analyzer is being used and expand either to nothing (for prototype annotations) or to no-ops (for function like annotations).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_NOTSAFEPOINT","location":"devdocs/gc-sa.html#JL_NOTSAFEPOINT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This is perhaps the most common annotation, and should be placed on any function that is known not to possibly lead to reaching a GC safepoint. In general, it is only safe for such a function to perform arithmetic, memory accesses and calls to functions either annotated JL_NOTSAFEPOINT or otherwise known not to be safepoints (e.g. function in the C standard library, which are hardcoded as such in the analyzer)","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"It is valid to keep values unrooted across calls to any function annotated with this attribute:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage Example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_get_one() JL_NOTSAFEPOINT {\n  return 1;\n}\n\njl_value_t *example() {\n  jl_value_t *val = jl_alloc_whatever();\n  // This is valid, even though `val` is unrooted, because\n  // jl_get_one is not a safepoint\n  jl_get_one();\n  return val;\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_MAYBE_UNROOTED/JL_ROOTS_TEMPORARILY","location":"devdocs/gc-sa.html#JL_MAYBE_UNROOTED/JL_ROOTS_TEMPORARILY","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"When JL_MAYBE_UNROOTED is annotated as an argument on a function, indicates that said argument may be passed, even if it is not rooted. In the ordinary course of events, the julia ABI guarantees that callers root values before passing them to callees. However, some functions do not follow this ABI and allow values to be passed to them even though they are not rooted. Note however, that this does not automatically imply that said argument will be preserved. The ROOTS_TEMPORARILY annotation provides the stronger guarantee that, not only may the value be unrooted when passed, it will also be preserved across any internal safepoints by the callee.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Note that JL_NOTSAFEPOINT essentially implies JL_MAYBE_UNROOTED/JL_ROOTS_TEMPORARILY, because the rootedness of an argument is irrelevant if the function contains no safepoints.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"One additional point to note is that these annotations apply on both the caller and the callee side. On the caller side, they lift rootedness restrictions that are normally required for julia ABI functions. On the callee side, they have the reverse effect of preventing these arguments from being considered implicitly rooted.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"If either of these annotations is applied to the function as a whole, it applies to all arguments of the function. This should generally only be necessary for varargs functions.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"JL_DLLEXPORT void JL_NORETURN jl_throw(jl_value_t *e JL_MAYBE_UNROOTED);\njl_value_t *jl_alloc_error();\n\nvoid example() {\n  // The return value of the allocation is unrooted. This would normally\n  // be an error, but is allowed because of the above annotation.\n  jl_throw(jl_alloc_error());\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_PROPAGATES_ROOT","location":"devdocs/gc-sa.html#JL_PROPAGATES_ROOT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation is commonly found on accessor functions that return one rootable object stored within another. When annotated on a function argument, it tells the analyzer that the root for that argument also applies to the value returned by the function.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage Example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"jl_value_t *jl_svecref(jl_svec_t *t JL_PROPAGATES_ROOT, size_t i) JL_NOTSAFEPOINT;\n\nsize_t example(jl_svec_t *svec) {\n  jl_value_t *val = jl_svecref(svec, 1)\n  // This is valid, because, as annotated by the PROPAGATES_ROOT annotation,\n  // jl_svecref propagates the rooted-ness from `svec` to `val`\n  jl_gc_safepoint();\n  return jl_unbox_long(val);\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_ROOTING_ARGUMENT/JL_ROOTED_ARGUMENT","location":"devdocs/gc-sa.html#JL_ROOTING_ARGUMENT/JL_ROOTED_ARGUMENT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This is essentially the assignment counterpart to JL_PROPAGATES_ROOT. When assigning a value to a field of another value that is already rooted, the assigned value will inherit the root of the value it is assigned into.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage Example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_svecset(void *t JL_ROOTING_ARGUMENT, size_t i, void *x JL_ROOTED_ARGUMENT) JL_NOTSAFEPOINT\n\n\nsize_t example(jl_svec_t *svec) {\n  jl_value_t *val = jl_box_long(10000);\n  jl_svecset(svec, val);\n  // This is valid, because the annotations imply that the\n  // jl_svecset propagates the rooted-ness from `svec` to `val`\n  jl_gc_safepoint();\n  return jl_unbox_long(val);\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_GC_DISABLED","location":"devdocs/gc-sa.html#JL_GC_DISABLED","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation implies that this function is only called with the GC runtime-disabled. Functions of this kind are most often encountered during startup and in the GC code itself. Note that this annotation is checked against the runtime enable/disable calls, so clang will know if you lie. This is not a good way to disable processing of a given function if the GC is not actually disabled (use ifdef __clang_analyzer__ for that if you must).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_do_magic() JL_GC_DISABLED {\n  // Wildly allocate here with no regard for roots\n}\n\nvoid example() {\n  int en = jl_gc_enable(0);\n  jl_do_magic();\n  jl_gc_enable(en);\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_REQUIRE_ROOTED_SLOT","location":"devdocs/gc-sa.html#JL_REQUIRE_ROOTED_SLOT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation requires the caller to pass in a slot that is rooted (i.e. values assigned to this slot will be rooted).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_do_processing(jl_value_t **slot JL_REQUIRE_ROOTED_SLOT) {\n  *slot = jl_box_long(1);\n  // Ok, only, because the slot was annotated as rooting\n  jl_gc_safepoint();\n}\n\nvoid example() {\n  jl_value_t *slot = NULL;\n  JL_GC_PUSH1(&slot);\n  jl_do_processing(&slot);\n  JL_GC_POP();\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_GLOBALLY_ROOTED","location":"devdocs/gc-sa.html#JL_GLOBALLY_ROOTED","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation implies that a given value is always globally rooted. It can be applied to global variable declarations, in which case it will apply to the value of those variables (or values if the declaration if for an array), or to functions, in which case it will apply to the return value of such functions (e.g. for functions that always return some private, globally rooted value).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"extern JL_DLLEXPORT jl_datatype_t *jl_any_type JL_GLOBALLY_ROOTED;\njl_ast_context_t *jl_ast_ctx(fl_context_t *fl) JL_GLOBALLY_ROOTED;","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_ALWAYS_LEAFTYPE","location":"devdocs/gc-sa.html#JL_ALWAYS_LEAFTYPE","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotations is essentially equivalent to JL_GLOBALLY_ROOTED, except that is should only be used if those values are globally rooted by virtue of being a leaftype. The rooting of leaftypes is a bit complicated. They are generally rooted through cache field of the corresponding TypeName, which itself is rooted by the containing module (so they're rooted as long as the containing module is ok) and we can generally assume that leaftypes are rooted where they are used, but we may refine this property in the future, so the separate annotation helps split out the reason for being globally rooted.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The analyzer also automatically detects checks for leaftype-ness and will not complain about missing GC roots on these paths.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"JL_DLLEXPORT jl_value_t *jl_apply_array_type(jl_value_t *type, size_t dim) JL_ALWAYS_LEAFTYPE;","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_GC_PROMISE_ROOTED","location":"devdocs/gc-sa.html#JL_GC_PROMISE_ROOTED","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This is a function-like annotation. Any value passed to this annotation will be considered rooted for the scope of the current function. It is designed as an escape hatch for analyzer inadequacy or complicated situations. However, it should be used sparingly, in favor of improving the analyzer itself.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void example() {\n  jl_value_t *val = jl_alloc_something();\n  if (some_condition) {\n    // We happen to know for complicated external reasons\n    // that val is rooted under these conditions\n    JL_GC_PROMISE_ROOTED(val);\n  }\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Completeness of analysis","location":"devdocs/gc-sa.html#Completeness-of-analysis","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The analyzer only looks at local information. In particular, e.g. in the PROPAGATES_ROOT case above, it assumes that such memory is only modified in ways it can see, not in any called functions (unless it happens to decide to consider them in its analysis) and not in any concurrently running threads. As such, it may miss a few problematic cases, though in practice such concurrent modification is fairly rare. Improving the analyzer to handle more such cases may be an interesting topic for future work.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Collections and Data Structures","location":"base/collections.html#Collections-and-Data-Structures","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Iteration","location":"base/collections.html#lib-collections-iteration","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Sequential iteration is implemented by the iterate function. The general for loop:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"for i in iter   # or  \"for i = iter\"\n    # body\nend","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"is translated into:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"next = iterate(iter)\nwhile next !== nothing\n    (i, state) = next\n    # body\n    next = iterate(iter, state)\nend","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"The state object may be anything, and should be chosen appropriately for each iterable type. See the manual section on the iteration interface for more details about defining a custom iterable type.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.iterate\nBase.IteratorSize\nBase.IteratorEltype","page":"Collections and Data Structures"},{"title":"Base.iterate","location":"base/collections.html#Base.iterate","category":"function","text":"iterate(iter [, state]) -> Union{Nothing, Tuple{Any, Any}}\n\nAdvance the iterator to obtain the next element. If no elements remain, nothing should be returned. Otherwise, a 2-tuple of the next element and the new iteration state should be returned.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.IteratorSize","location":"base/collections.html#Base.IteratorSize","category":"type","text":"IteratorSize(itertype::Type) -> IteratorSize\n\nGiven the type of an iterator, return one of the following values:\n\nSizeUnknown() if the length (number of elements) cannot be determined in advance.\nHasLength() if there is a fixed, finite length.\nHasShape{N}() if there is a known length plus a notion of multidimensional shape (as for an array).  In this case N should give the number of dimensions, and the axes function is valid  for the iterator.\nIsInfinite() if the iterator yields values forever.\n\nThe default value (for iterators that do not define this function) is HasLength(). This means that most iterators are assumed to implement length.\n\nThis trait is generally used to select between algorithms that pre-allocate space for their result, and algorithms that resize their result incrementally.\n\njulia> Base.IteratorSize(1:5)\nBase.HasShape{1}()\n\njulia> Base.IteratorSize((2,3))\nBase.HasLength()\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.IteratorEltype","location":"base/collections.html#Base.IteratorEltype","category":"type","text":"IteratorEltype(itertype::Type) -> IteratorEltype\n\nGiven the type of an iterator, return one of the following values:\n\nEltypeUnknown() if the type of elements yielded by the iterator is not known in advance.\nHasEltype() if the element type is known, and eltype would return a meaningful value.\n\nHasEltype() is the default, since iterators are assumed to implement eltype.\n\nThis trait is generally used to select between algorithms that pre-allocate a specific type of result, and algorithms that pick a result type based on the types of yielded values.\n\njulia> Base.IteratorEltype(1:5)\nBase.HasEltype()\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"AbstractRange\nUnitRange\nTuple\nNumber\nAbstractArray\nBitSet\nIdDict\nDict\nWeakKeyDict\nEachLine\nAbstractString\nSet\nPair\nNamedTuple","page":"Collections and Data Structures"},{"title":"Constructors and Types","location":"base/collections.html#Constructors-and-Types","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.AbstractRange\nBase.OrdinalRange\nBase.AbstractUnitRange\nBase.StepRange\nBase.UnitRange\nBase.LinRange","page":"Collections and Data Structures"},{"title":"Base.AbstractRange","location":"base/collections.html#Base.AbstractRange","category":"type","text":"AbstractRange{T}\n\nSupertype for ranges with elements of type T. UnitRange and other types are subtypes of this.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.OrdinalRange","location":"base/collections.html#Base.OrdinalRange","category":"type","text":"OrdinalRange{T, S} <: AbstractRange{T}\n\nSupertype for ordinal ranges with elements of type T with spacing(s) of type S. The steps should be always-exact multiples of oneunit, and T should be a \"discrete\" type, which cannot have values smaller than oneunit. For example, Integer or Date types would qualify, whereas Float64 would not (since this type can represent values smaller than oneunit(Float64). UnitRange, StepRange, and other types are subtypes of this.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.AbstractUnitRange","location":"base/collections.html#Base.AbstractUnitRange","category":"type","text":"AbstractUnitRange{T} <: OrdinalRange{T, T}\n\nSupertype for ranges with a step size of oneunit(T) with elements of type T. UnitRange and other types are subtypes of this.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.StepRange","location":"base/collections.html#Base.StepRange","category":"type","text":"StepRange{T, S} <: OrdinalRange{T, S}\n\nRanges with elements of type T with spacing of type S. The step between each element is constant, and the range is defined in terms of a start and stop of type T and a step of type S. Neither T nor S should be floating point types. The syntax a:b:c with b > 1 and a, b, and c all integers creates a StepRange.\n\nExamples\n\njulia> collect(StepRange(1, Int8(2), 10))\n5-element Vector{Int64}:\n 1\n 3\n 5\n 7\n 9\n\njulia> typeof(StepRange(1, Int8(2), 10))\nStepRange{Int64, Int8}\n\njulia> typeof(1:3:6)\nStepRange{Int64, Int64}\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.UnitRange","location":"base/collections.html#Base.UnitRange","category":"type","text":"UnitRange{T<:Real}\n\nA range parameterized by a start and stop of type T, filled with elements spaced by 1 from start until stop is exceeded. The syntax a:b with a and b both Integers creates a UnitRange.\n\nExamples\n\njulia> collect(UnitRange(2.3, 5.2))\n3-element Vector{Float64}:\n 2.3\n 3.3\n 4.3\n\njulia> typeof(1:10)\nUnitRange{Int64}\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.LinRange","location":"base/collections.html#Base.LinRange","category":"type","text":"LinRange{T}\n\nA range with len linearly spaced elements between its start and stop. The size of the spacing is controlled by len, which must be an Int.\n\nExamples\n\njulia> LinRange(1.5, 5.5, 9)\n9-element LinRange{Float64}:\n 1.5,2.0,2.5,3.0,3.5,4.0,4.5,5.0,5.5\n\nCompared to using range, directly constructing a LinRange should have less overhead but won't try to correct for floating point errors:\n\njulia> collect(range(-0.1, 0.3, length=5))\n5-element Array{Float64,1}:\n -0.1\n  0.0\n  0.1\n  0.2\n  0.3\n\njulia> collect(LinRange(-0.1, 0.3, 5))\n5-element Array{Float64,1}:\n -0.1\n -1.3877787807814457e-17\n  0.09999999999999999\n  0.19999999999999998\n  0.3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"General Collections","location":"base/collections.html#General-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.isempty\nBase.empty!\nBase.length","page":"Collections and Data Structures"},{"title":"Base.isempty","location":"base/collections.html#Base.isempty","category":"function","text":"isempty(collection) -> Bool\n\nDetermine whether a collection is empty (has no elements).\n\nExamples\n\njulia> isempty([])\ntrue\n\njulia> isempty([1 2 3])\nfalse\n\n\n\n\n\nisempty(condition)\n\nReturn true if no tasks are waiting on the condition, false otherwise.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.empty!","location":"base/collections.html#Base.empty!","category":"function","text":"empty!(collection) -> collection\n\nRemove all elements from a collection.\n\nExamples\n\njulia> A = Dict(\"a\" => 1, \"b\" => 2)\nDict{String, Int64} with 2 entries:\n  \"b\" => 2\n  \"a\" => 1\n\njulia> empty!(A);\n\njulia> A\nDict{String, Int64}()\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.length","location":"base/collections.html#Base.length","category":"function","text":"length(collection) -> Integer\n\nReturn the number of elements in the collection.\n\nUse lastindex to get the last valid index of an indexable collection.\n\nExamples\n\njulia> length(1:5)\n5\n\njulia> length([1, 2, 3, 4])\n4\n\njulia> length([1 2; 3 4])\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"AbstractRange\nUnitRange\nTuple\nNumber\nAbstractArray\nBitSet\nIdDict\nDict\nWeakKeyDict\nAbstractString\nSet\nNamedTuple","page":"Collections and Data Structures"},{"title":"Iterable Collections","location":"base/collections.html#Iterable-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.in\nBase.:∉\nBase.eltype\nBase.indexin\nBase.unique\nBase.unique!\nBase.allunique\nBase.reduce(::Any, ::Any)\nBase.foldl(::Any, ::Any)\nBase.foldr(::Any, ::Any)\nBase.maximum\nBase.maximum!\nBase.minimum\nBase.minimum!\nBase.extrema\nBase.argmax\nBase.argmin\nBase.findmax\nBase.findmin\nBase.findmax!\nBase.findmin!\nBase.sum\nBase.sum!\nBase.prod\nBase.prod!\nBase.any(::Any)\nBase.any(::AbstractArray, ::Any)\nBase.any!\nBase.all(::Any)\nBase.all(::AbstractArray, ::Any)\nBase.all!\nBase.count\nBase.any(::Any, ::Any)\nBase.all(::Any, ::Any)\nBase.foreach\nBase.map\nBase.map!\nBase.mapreduce(::Any, ::Any, ::Any)\nBase.mapfoldl(::Any, ::Any, ::Any)\nBase.mapfoldr(::Any, ::Any, ::Any)\nBase.first\nBase.last\nBase.front\nBase.tail\nBase.step\nBase.collect(::Any)\nBase.collect(::Type, ::Any)\nBase.filter\nBase.filter!\nBase.replace(::Any, ::Pair...)\nBase.replace(::Base.Callable, ::Any)\nBase.replace!\nBase.rest","page":"Collections and Data Structures"},{"title":"Base.in","location":"base/collections.html#Base.in","category":"function","text":"in(item, collection) -> Bool\n∈(item, collection) -> Bool\n\nDetermine whether an item is in the given collection, in the sense that it is == to one of the values generated by iterating over the collection. Returns a Bool value, except if item is missing or collection contains missing but not item, in which case missing is returned (three-valued logic, matching the behavior of any and ==).\n\nSome collections follow a slightly different definition. For example, Sets check whether the item isequal to one of the elements. Dicts look for key=>value pairs, and the key is compared using isequal. To test for the presence of a key in a dictionary, use haskey or k in keys(dict). For these collections, the result is always a Bool and never missing.\n\nTo determine whether an item is not in a given collection, see :∉. You may also negate the in by doing !(a in b) which is logically similar to \"not in\".\n\nWhen broadcasting with in.(items, collection) or items .∈ collection, both item and collection are broadcasted over, which is often not what is intended. For example, if both arguments are vectors (and the dimensions match), the result is a vector indicating whether each value in collection items is in the value at the corresponding position in collection. To get a vector indicating whether each value in items is in collection, wrap collection in a tuple or a Ref like this: in.(items, Ref(collection)) or items .∈ Ref(collection).\n\nExamples\n\njulia> a = 1:3:20\n1:3:19\n\njulia> 4 in a\ntrue\n\njulia> 5 in a\nfalse\n\njulia> missing in [1, 2]\nmissing\n\njulia> 1 in [2, missing]\nmissing\n\njulia> 1 in [1, missing]\ntrue\n\njulia> missing in Set([1, 2])\nfalse\n\njulia> !(21 in a)\ntrue\n\njulia> !(19 in a)\nfalse\n\njulia> [1, 2] .∈ [2, 3]\n2-element BitVector:\n 0\n 0\n\njulia> [1, 2] .∈ ([2, 3],)\n2-element BitVector:\n 0\n 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.:∉","location":"base/collections.html#Base.:∉","category":"function","text":"∉(item, collection) -> Bool\n∌(collection, item) -> Bool\n\nNegation of ∈ and ∋, i.e. checks that item is not in collection.\n\nWhen broadcasting with items .∉ collection, both item and collection are broadcasted over, which is often not what is intended. For example, if both arguments are vectors (and the dimensions match), the result is a vector indicating whether each value in collection items is not in the value at the corresponding position in collection. To get a vector indicating whether each value in items is not in collection, wrap collection in a tuple or a Ref like this: items .∉ Ref(collection).\n\nExamples\n\njulia> 1 ∉ 2:4\ntrue\n\njulia> 1 ∉ 1:3\nfalse\n\njulia> [1, 2] .∉ [2, 3]\n2-element BitVector:\n 1\n 1\n\njulia> [1, 2] .∉ ([2, 3],)\n2-element BitVector:\n 1\n 0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.eltype","location":"base/collections.html#Base.eltype","category":"function","text":"eltype(type)\n\nDetermine the type of the elements generated by iterating a collection of the given type. For dictionary types, this will be a Pair{KeyType,ValType}. The definition eltype(x) = eltype(typeof(x)) is provided for convenience so that instances can be passed instead of types. However the form that accepts a type argument should be defined for new types.\n\nExamples\n\njulia> eltype(fill(1f0, (2,2)))\nFloat32\n\njulia> eltype(fill(0x1, (2,2)))\nUInt8\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.indexin","location":"base/collections.html#Base.indexin","category":"function","text":"indexin(a, b)\n\nReturn an array containing the first index in b for each value in a that is a member of b. The output array contains nothing wherever a is not a member of b.\n\nExamples\n\njulia> a = ['a', 'b', 'c', 'b', 'd', 'a'];\n\njulia> b = ['a', 'b', 'c'];\n\njulia> indexin(a, b)\n6-element Vector{Union{Nothing, Int64}}:\n 1\n 2\n 3\n 2\n  nothing\n 1\n\njulia> indexin(b, a)\n3-element Vector{Union{Nothing, Int64}}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.unique","location":"base/collections.html#Base.unique","category":"function","text":"unique(itr)\n\nReturn an array containing only the unique elements of collection itr, as determined by isequal, in the order that the first of each set of equivalent elements originally appears. The element type of the input is preserved.\n\nExamples\n\njulia> unique([1, 2, 6, 2])\n3-element Vector{Int64}:\n 1\n 2\n 6\n\njulia> unique(Real[1, 1.0, 2])\n2-element Vector{Real}:\n 1\n 2\n\n\n\n\n\nunique(f, itr)\n\nReturns an array containing one value from itr for each unique value produced by f applied to elements of itr.\n\nExamples\n\njulia> unique(x -> x^2, [1, -1, 3, -3, 4])\n3-element Vector{Int64}:\n 1\n 3\n 4\n\n\n\n\n\nunique(A::AbstractArray; dims::Int)\n\nReturn unique regions of A along dimension dims.\n\nExamples\n\njulia> A = map(isodd, reshape(Vector(1:8), (2,2,2)))\n2×2×2 Array{Bool, 3}:\n[:, :, 1] =\n 1  1\n 0  0\n\n[:, :, 2] =\n 1  1\n 0  0\n\njulia> unique(A)\n2-element Vector{Bool}:\n 1\n 0\n\njulia> unique(A, dims=2)\n2×1×2 Array{Bool, 3}:\n[:, :, 1] =\n 1\n 0\n\n[:, :, 2] =\n 1\n 0\n\njulia> unique(A, dims=3)\n2×2×1 Array{Bool, 3}:\n[:, :, 1] =\n 1  1\n 0  0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.unique!","location":"base/collections.html#Base.unique!","category":"function","text":"unique!(f, A::AbstractVector)\n\nSelects one value from A for each unique value produced by f applied to elements of A, then return the modified A.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\nExamples\n\njulia> unique!(x -> x^2, [1, -1, 3, -3, 4])\n3-element Vector{Int64}:\n 1\n 3\n 4\n\njulia> unique!(n -> n%3, [5, 1, 8, 9, 3, 4, 10, 7, 2, 6])\n3-element Vector{Int64}:\n 5\n 1\n 9\n\njulia> unique!(iseven, [2, 3, 5, 7, 9])\n2-element Vector{Int64}:\n 2\n 3\n\n\n\n\n\nunique!(A::AbstractVector)\n\nRemove duplicate items as determined by isequal, then return the modified A. unique! will return the elements of A in the order that they occur. If you do not care about the order of the returned data, then calling (sort!(A); unique!(A)) will be much more efficient as long as the elements of A can be sorted.\n\nExamples\n\njulia> unique!([1, 1, 1])\n1-element Vector{Int64}:\n 1\n\njulia> A = [7, 3, 2, 3, 7, 5];\n\njulia> unique!(A)\n4-element Vector{Int64}:\n 7\n 3\n 2\n 5\n\njulia> B = [7, 6, 42, 6, 7, 42];\n\njulia> sort!(B);  # unique! is able to process sorted data much more efficiently.\n\njulia> unique!(B)\n3-element Vector{Int64}:\n  6\n  7\n 42\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.allunique","location":"base/collections.html#Base.allunique","category":"function","text":"allunique(itr) -> Bool\n\nReturn true if all values from itr are distinct when compared with isequal.\n\nExamples\n\njulia> a = [1; 2; 3]\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> allunique([a, a])\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.reduce","location":"base/collections.html#Base.reduce-Tuple{Any, Any}","category":"method","text":"reduce(op, itr; [init])\n\nReduce the given collection itr with the given binary operator op. If provided, the initial value init must be a neutral element for op that will be returned for empty collections. It is unspecified whether init is used for non-empty collections.\n\nFor empty collections, providing init will be necessary, except for some special cases (e.g. when op is one of +, *, max, min, &, |) when Julia can determine the neutral element of op.\n\nReductions for certain commonly-used operators may have special implementations, and should be used instead: maximum(itr), minimum(itr), sum(itr), prod(itr),  any(itr), all(itr).\n\nThe associativity of the reduction is implementation dependent. This means that you can't use non-associative operations like - because it is undefined whether reduce(-,[1,2,3]) should be evaluated as (1-2)-3 or 1-(2-3). Use foldl or foldr instead for guaranteed left or right associativity.\n\nSome operations accumulate error. Parallelism will be easier if the reduction can be executed in groups. Future versions of Julia might change the algorithm. Note that the elements are not reordered if you use an ordered collection.\n\nExamples\n\njulia> reduce(*, [2; 3; 4])\n24\n\njulia> reduce(*, [2; 3; 4]; init=-1)\n-24\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.foldl","location":"base/collections.html#Base.foldl-Tuple{Any, Any}","category":"method","text":"foldl(op, itr; [init])\n\nLike reduce, but with guaranteed left associativity. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\nExamples\n\njulia> foldl(=>, 1:4)\n((1 => 2) => 3) => 4\n\njulia> foldl(=>, 1:4; init=0)\n(((0 => 1) => 2) => 3) => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.foldr","location":"base/collections.html#Base.foldr-Tuple{Any, Any}","category":"method","text":"foldr(op, itr; [init])\n\nLike reduce, but with guaranteed right associativity. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\nExamples\n\njulia> foldr(=>, 1:4)\n1 => (2 => (3 => 4))\n\njulia> foldr(=>, 1:4; init=0)\n1 => (2 => (3 => (4 => 0)))\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.maximum","location":"base/collections.html#Base.maximum","category":"function","text":"maximum(f, itr; [init])\n\nReturns the largest result of calling function f on each element of itr.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for max (i.e. which is less than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> maximum(length, [\"Julion\", \"Julia\", \"Jule\"])\n6\n\njulia> maximum(length, []; init=-1)\n-1\n\njulia> maximum(sin, Real[]; init=-1.0)  # good, since output of sin is >= -1\n-1.0\n\n\n\n\n\nmaximum(itr; [init])\n\nReturns the largest element in a collection.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for max (i.e. which is less than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> maximum(-20.5:10)\n9.5\n\njulia> maximum([1,2,3])\n3\n\njulia> maximum(())\nERROR: ArgumentError: reducing over an empty collection is not allowed\nStacktrace:\n[...]\n\njulia> maximum((); init=-Inf)\n-Inf\n\n\n\n\n\nmaximum(A::AbstractArray; dims)\n\nCompute the maximum value of an array over the given dimensions. See also the max(a,b) function to take the maximum of two or more arguments, which can be applied elementwise to arrays via max.(a,b).\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> maximum(A, dims=1)\n1×2 Matrix{Int64}:\n 3  4\n\njulia> maximum(A, dims=2)\n2×1 Matrix{Int64}:\n 2\n 4\n\n\n\n\n\nmaximum(f, A::AbstractArray; dims)\n\nCompute the maximum value from of calling the function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> maximum(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 9  16\n\njulia> maximum(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n  4\n 16\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.maximum!","location":"base/collections.html#Base.maximum!","category":"function","text":"maximum!(r, A)\n\nCompute the maximum value of A over the singleton dimensions of r, and write results to r.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> maximum!([1; 1], A)\n2-element Vector{Int64}:\n 2\n 4\n\njulia> maximum!([1 1], A)\n1×2 Matrix{Int64}:\n 3  4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.minimum","location":"base/collections.html#Base.minimum","category":"function","text":"minimum(f, itr; [init])\n\nReturns the smallest result of calling function f on each element of itr.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for min (i.e. which is greater than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> minimum(length, [\"Julion\", \"Julia\", \"Jule\"])\n4\n\njulia> minimum(length, []; init=typemax(Int64))\n9223372036854775807\n\njulia> minimum(sin, Real[]; init=1.0)  # good, since output of sin is <= 1\n1.0\n\n\n\n\n\nminimum(itr; [init])\n\nReturns the smallest element in a collection.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for min (i.e. which is greater than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> minimum(-20.5:10)\n-20.5\n\njulia> minimum([1,2,3])\n1\n\njulia> minimum([])\nERROR: ArgumentError: reducing over an empty collection is not allowed\nStacktrace:\n[...]\n\njulia> minimum([]; init=Inf)\nInf\n\n\n\n\n\nminimum(A::AbstractArray; dims)\n\nCompute the minimum value of an array over the given dimensions. See also the min(a,b) function to take the minimum of two or more arguments, which can be applied elementwise to arrays via min.(a,b).\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> minimum(A, dims=1)\n1×2 Matrix{Int64}:\n 1  2\n\njulia> minimum(A, dims=2)\n2×1 Matrix{Int64}:\n 1\n 3\n\n\n\n\n\nminimum(f, A::AbstractArray; dims)\n\nCompute the minimum value from of calling the function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> minimum(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 1  4\n\njulia> minimum(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n 1\n 9\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.minimum!","location":"base/collections.html#Base.minimum!","category":"function","text":"minimum!(r, A)\n\nCompute the minimum value of A over the singleton dimensions of r, and write results to r.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> minimum!([1; 1], A)\n2-element Vector{Int64}:\n 1\n 3\n\njulia> minimum!([1 1], A)\n1×2 Matrix{Int64}:\n 1  2\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.extrema","location":"base/collections.html#Base.extrema","category":"function","text":"extrema(itr) -> Tuple\n\nCompute both the minimum and maximum element in a single pass, and return them as a 2-tuple.\n\nExamples\n\njulia> extrema(2:10)\n(2, 10)\n\njulia> extrema([9,pi,4.5])\n(3.141592653589793, 9.0)\n\n\n\n\n\nextrema(f, itr) -> Tuple\n\nCompute both the minimum and maximum of f applied to each element in itr and return them as a 2-tuple. Only one pass is made over itr.\n\ncompat: Julia 1.2\nThis method requires Julia 1.2 or later.\n\nExamples\n\njulia> extrema(sin, 0:π)\n(0.0, 0.9092974268256817)\n\n\n\n\n\nextrema(A::AbstractArray; dims) -> Array{Tuple}\n\nCompute the minimum and maximum elements of an array over the given dimensions.\n\nExamples\n\njulia> A = reshape(Vector(1:2:16), (2,2,2))\n2×2×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  5\n 3  7\n\n[:, :, 2] =\n  9  13\n 11  15\n\njulia> extrema(A, dims = (1,2))\n1×1×2 Array{Tuple{Int64, Int64}, 3}:\n[:, :, 1] =\n (1, 7)\n\n[:, :, 2] =\n (9, 15)\n\n\n\n\n\nextrema(f, A::AbstractArray; dims) -> Array{Tuple}\n\nCompute the minimum and maximum of f applied to each element in the given dimensions of A.\n\ncompat: Julia 1.2\nThis method requires Julia 1.2 or later.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.argmax","location":"base/collections.html#Base.argmax","category":"function","text":"argmax(r::AbstractRange)\n\nRanges can have multiple maximal elements. In that case argmax will return a maximal index, but not necessarily the first one.\n\n\n\n\n\nargmax(itr)\n\nReturn the index or key of the maximum element in a collection. If there are multiple maximal elements, then the first one will be returned.\n\nThe collection must not be empty.\n\nExamples\n\njulia> argmax([8,0.1,-9,pi])\n1\n\njulia> argmax([1,7,7,6])\n2\n\njulia> argmax([1,7,7,NaN])\n4\n\n\n\n\n\nargmax(A; dims) -> indices\n\nFor an array input, return the indices of the maximum elements over the given dimensions. NaN is treated as greater than all other values.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> argmax(A, dims=1)\n1×2 Matrix{CartesianIndex{2}}:\n CartesianIndex(2, 1)  CartesianIndex(2, 2)\n\njulia> argmax(A, dims=2)\n2×1 Matrix{CartesianIndex{2}}:\n CartesianIndex(1, 2)\n CartesianIndex(2, 2)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.argmin","location":"base/collections.html#Base.argmin","category":"function","text":"argmin(r::AbstractRange)\n\nRanges can have multiple minimal elements. In that case argmin will return a minimal index, but not necessarily the first one.\n\n\n\n\n\nargmin(itr)\n\nReturn the index or key of the minimum element in a collection. If there are multiple minimal elements, then the first one will be returned.\n\nThe collection must not be empty.\n\nExamples\n\njulia> argmin([8,0.1,-9,pi])\n3\n\njulia> argmin([7,1,1,6])\n2\n\njulia> argmin([7,1,1,NaN])\n4\n\n\n\n\n\nargmin(A; dims) -> indices\n\nFor an array input, return the indices of the minimum elements over the given dimensions. NaN is treated as less than all other values.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> argmin(A, dims=1)\n1×2 Matrix{CartesianIndex{2}}:\n CartesianIndex(1, 1)  CartesianIndex(1, 2)\n\njulia> argmin(A, dims=2)\n2×1 Matrix{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 1)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmax","location":"base/collections.html#Base.findmax","category":"function","text":"findmax(itr) -> (x, index)\n\nReturn the maximum element of the collection itr and its index or key. If there are multiple maximal elements, then the first one will be returned. If any data element is NaN, this element is returned. The result is in line with max.\n\nThe collection must not be empty.\n\nExamples\n\njulia> findmax([8,0.1,-9,pi])\n(8.0, 1)\n\njulia> findmax([1,7,7,6])\n(7, 2)\n\njulia> findmax([1,7,7,NaN])\n(NaN, 4)\n\n\n\n\n\nfindmax(A; dims) -> (maxval, index)\n\nFor an array input, returns the value and index of the maximum over the given dimensions. NaN is treated as greater than all other values.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> findmax(A, dims=1)\n([3.0 4.0], CartesianIndex{2}[CartesianIndex(2, 1) CartesianIndex(2, 2)])\n\njulia> findmax(A, dims=2)\n([2.0; 4.0], CartesianIndex{2}[CartesianIndex(1, 2); CartesianIndex(2, 2)])\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmin","location":"base/collections.html#Base.findmin","category":"function","text":"findmin(itr) -> (x, index)\n\nReturn the minimum element of the collection itr and its index or key. If there are multiple minimal elements, then the first one will be returned. If any data element is NaN, this element is returned. The result is in line with min.\n\nThe collection must not be empty.\n\nExamples\n\njulia> findmin([8,0.1,-9,pi])\n(-9.0, 3)\n\njulia> findmin([7,1,1,6])\n(1, 2)\n\njulia> findmin([7,1,1,NaN])\n(NaN, 4)\n\n\n\n\n\nfindmin(A; dims) -> (minval, index)\n\nFor an array input, returns the value and index of the minimum over the given dimensions. NaN is treated as less than all other values.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> findmin(A, dims=1)\n([1.0 2.0], CartesianIndex{2}[CartesianIndex(1, 1) CartesianIndex(1, 2)])\n\njulia> findmin(A, dims=2)\n([1.0; 3.0], CartesianIndex{2}[CartesianIndex(1, 1); CartesianIndex(2, 1)])\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmax!","location":"base/collections.html#Base.findmax!","category":"function","text":"findmax!(rval, rind, A) -> (maxval, index)\n\nFind the maximum of A and the corresponding linear index along singleton dimensions of rval and rind, and store the results in rval and rind. NaN is treated as greater than all other values.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmin!","location":"base/collections.html#Base.findmin!","category":"function","text":"findmin!(rval, rind, A) -> (minval, index)\n\nFind the minimum of A and the corresponding linear index along singleton dimensions of rval and rind, and store the results in rval and rind. NaN is treated as less than all other values.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.sum","location":"base/collections.html#Base.sum","category":"function","text":"sum(f, itr; [init])\n\nSum the results of calling function f on each element of itr.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the additive identity (i.e. zero) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> sum(abs2, [2; 3; 4])\n29\n\nNote the important difference between sum(A) and reduce(+, A) for arrays with small integer eltype:\n\njulia> sum(Int8[100, 28])\n128\n\njulia> reduce(+, Int8[100, 28])\n-128\n\nIn the former case, the integers are widened to system word size and therefore the result is 128. In the latter case, no such widening happens and integer overflow results in -128.\n\n\n\n\n\nsum(itr; [init])\n\nReturns the sum of all elements in a collection.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the additive identity (i.e. zero) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> sum(1:20)\n210\n\njulia> sum(1:20; init = 0.0)\n210.0\n\n\n\n\n\nsum(A::AbstractArray; dims)\n\nSum elements of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> sum(A, dims=1)\n1×2 Matrix{Int64}:\n 4  6\n\njulia> sum(A, dims=2)\n2×1 Matrix{Int64}:\n 3\n 7\n\n\n\n\n\nsum(f, A::AbstractArray; dims)\n\nSum the results of calling function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> sum(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 10  20\n\njulia> sum(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n  5\n 25\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.sum!","location":"base/collections.html#Base.sum!","category":"function","text":"sum!(r, A)\n\nSum elements of A over the singleton dimensions of r, and write results to r.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> sum!([1; 1], A)\n2-element Vector{Int64}:\n 3\n 7\n\njulia> sum!([1 1], A)\n1×2 Matrix{Int64}:\n 4  6\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.prod","location":"base/collections.html#Base.prod","category":"function","text":"prod(f, itr; [init])\n\nReturns the product of f applied to each element of itr.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the multiplicative identity (i.e. one) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> prod(abs2, [2; 3; 4])\n576\n\n\n\n\n\nprod(itr; [init])\n\nReturns the product of all elements of a collection.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the multiplicative identity (i.e. one) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> prod(1:5)\n120\n\njulia> prod(1:5; init = 1.0)\n120.0\n\n\n\n\n\nprod(A::AbstractArray; dims)\n\nMultiply elements of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prod(A, dims=1)\n1×2 Matrix{Int64}:\n 3  8\n\njulia> prod(A, dims=2)\n2×1 Matrix{Int64}:\n  2\n 12\n\n\n\n\n\nprod(f, A::AbstractArray; dims)\n\nMultiply the results of calling the function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prod(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 9  64\n\njulia> prod(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n   4\n 144\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.prod!","location":"base/collections.html#Base.prod!","category":"function","text":"prod!(r, A)\n\nMultiply elements of A over the singleton dimensions of r, and write results to r.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prod!([1; 1], A)\n2-element Vector{Int64}:\n  2\n 12\n\njulia> prod!([1 1], A)\n1×2 Matrix{Int64}:\n 3  8\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.any","location":"base/collections.html#Base.any-Tuple{Any}","category":"method","text":"any(itr) -> Bool\n\nTest whether any elements of a boolean collection are true, returning true as soon as the first true value in itr is encountered (short-circuiting).\n\nIf the input contains missing values, return missing if all non-missing values are false (or equivalently, if the input contains no true value), following three-valued logic.\n\nExamples\n\njulia> a = [true,false,false,true]\n4-element Vector{Bool}:\n 1\n 0\n 0\n 1\n\njulia> any(a)\ntrue\n\njulia> any((println(i); v) for (i, v) in enumerate(a))\n1\ntrue\n\njulia> any([missing, true])\ntrue\n\njulia> any([false, missing])\nmissing\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.any","location":"base/collections.html#Base.any-Tuple{AbstractArray, Any}","category":"method","text":"any(p, itr) -> Bool\n\nDetermine whether predicate p returns true for any elements of itr, returning true as soon as the first item in itr for which p returns true is encountered (short-circuiting).\n\nIf the input contains missing values, return missing if all non-missing values are false (or equivalently, if the input contains no true value), following three-valued logic.\n\nExamples\n\njulia> any(i->(4<=i<=6), [3,5,7])\ntrue\n\njulia> any(i -> (println(i); i > 3), 1:10)\n1\n2\n3\n4\ntrue\n\njulia> any(i -> i > 0, [1, missing])\ntrue\n\njulia> any(i -> i > 0, [-1, missing])\nmissing\n\njulia> any(i -> i > 0, [-1, 0])\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.any!","location":"base/collections.html#Base.any!","category":"function","text":"any!(r, A)\n\nTest whether any values in A along the singleton dimensions of r are true, and write results to r.\n\nExamples\n\njulia> A = [true false; true false]\n2×2 Matrix{Bool}:\n 1  0\n 1  0\n\njulia> any!([1; 1], A)\n2-element Vector{Int64}:\n 1\n 1\n\njulia> any!([1 1], A)\n1×2 Matrix{Int64}:\n 1  0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.all","location":"base/collections.html#Base.all-Tuple{Any}","category":"method","text":"all(itr) -> Bool\n\nTest whether all elements of a boolean collection are true, returning false as soon as the first false value in itr is encountered (short-circuiting).\n\nIf the input contains missing values, return missing if all non-missing values are true (or equivalently, if the input contains no false value), following three-valued logic.\n\nExamples\n\njulia> a = [true,false,false,true]\n4-element Vector{Bool}:\n 1\n 0\n 0\n 1\n\njulia> all(a)\nfalse\n\njulia> all((println(i); v) for (i, v) in enumerate(a))\n1\n2\nfalse\n\njulia> all([missing, false])\nfalse\n\njulia> all([true, missing])\nmissing\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.all","location":"base/collections.html#Base.all-Tuple{AbstractArray, Any}","category":"method","text":"all(p, itr) -> Bool\n\nDetermine whether predicate p returns true for all elements of itr, returning false as soon as the first item in itr for which p returns false is encountered (short-circuiting).\n\nIf the input contains missing values, return missing if all non-missing values are true (or equivalently, if the input contains no false value), following three-valued logic.\n\nExamples\n\njulia> all(i->(4<=i<=6), [4,5,6])\ntrue\n\njulia> all(i -> (println(i); i < 3), 1:10)\n1\n2\n3\nfalse\n\njulia> all(i -> i > 0, [1, missing])\nmissing\n\njulia> all(i -> i > 0, [-1, missing])\nfalse\n\njulia> all(i -> i > 0, [1, 2])\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.all!","location":"base/collections.html#Base.all!","category":"function","text":"all!(r, A)\n\nTest whether all values in A along the singleton dimensions of r are true, and write results to r.\n\nExamples\n\njulia> A = [true false; true false]\n2×2 Matrix{Bool}:\n 1  0\n 1  0\n\njulia> all!([1; 1], A)\n2-element Vector{Int64}:\n 0\n 0\n\njulia> all!([1 1], A)\n1×2 Matrix{Int64}:\n 1  0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.count","location":"base/collections.html#Base.count","category":"function","text":"count([f=identity,] itr; init=0) -> Integer\n\nCount the number of elements in itr for which the function f returns true. If f is omitted, count the number of true elements in itr (which should be a collection of boolean values). init optionally specifies the value to start counting from and therefore also determines the output type.\n\ncompat: Julia 1.6\ninit keyword was added in Julia 1.6.\n\nExamples\n\njulia> count(i->(4<=i<=6), [2,3,4,5,6])\n3\n\njulia> count([true, false, true, true])\n3\n\njulia> count(>(3), 1:7, init=0x03)\n0x07\n\n\n\n\n\ncount(\n    pattern::Union{AbstractString,AbstractPattern},\n    string::AbstractString;\n    overlap::Bool = false,\n)\n\nReturn the number of matches for pattern in string. This is equivalent to calling length(findall(pattern, string)) but more efficient.\n\nIf overlap=true, the matching sequences are allowed to overlap indices in the original string, otherwise they must be from disjoint character ranges.\n\ncompat: Julia 1.3\nThis method requires at least Julia 1.3.\n\n\n\n\n\ncount([f=identity,] A::AbstractArray; dims=:)\n\nCount the number of elements in A for which f returns true over the given dimensions.\n\ncompat: Julia 1.5\ndims keyword was added in Julia 1.5.\n\ncompat: Julia 1.6\ninit keyword was added in Julia 1.6.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> count(<=(2), A, dims=1)\n1×2 Matrix{Int64}:\n 1  1\n\njulia> count(<=(2), A, dims=2)\n2×1 Matrix{Int64}:\n 2\n 0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.any","location":"base/collections.html#Base.any-Tuple{Any, Any}","category":"method","text":"any(p, itr) -> Bool\n\nDetermine whether predicate p returns true for any elements of itr, returning true as soon as the first item in itr for which p returns true is encountered (short-circuiting).\n\nIf the input contains missing values, return missing if all non-missing values are false (or equivalently, if the input contains no true value), following three-valued logic.\n\nExamples\n\njulia> any(i->(4<=i<=6), [3,5,7])\ntrue\n\njulia> any(i -> (println(i); i > 3), 1:10)\n1\n2\n3\n4\ntrue\n\njulia> any(i -> i > 0, [1, missing])\ntrue\n\njulia> any(i -> i > 0, [-1, missing])\nmissing\n\njulia> any(i -> i > 0, [-1, 0])\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.all","location":"base/collections.html#Base.all-Tuple{Any, Any}","category":"method","text":"all(p, itr) -> Bool\n\nDetermine whether predicate p returns true for all elements of itr, returning false as soon as the first item in itr for which p returns false is encountered (short-circuiting).\n\nIf the input contains missing values, return missing if all non-missing values are true (or equivalently, if the input contains no false value), following three-valued logic.\n\nExamples\n\njulia> all(i->(4<=i<=6), [4,5,6])\ntrue\n\njulia> all(i -> (println(i); i < 3), 1:10)\n1\n2\n3\nfalse\n\njulia> all(i -> i > 0, [1, missing])\nmissing\n\njulia> all(i -> i > 0, [-1, missing])\nfalse\n\njulia> all(i -> i > 0, [1, 2])\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.foreach","location":"base/collections.html#Base.foreach","category":"function","text":"foreach(f, c...) -> Nothing\n\nCall function f on each element of iterable c. For multiple iterable arguments, f is called elementwise. foreach should be used instead of map when the results of f are not needed, for example in foreach(println, array).\n\nExamples\n\njulia> a = 1:3:7;\n\njulia> foreach(x -> println(x^2), a)\n1\n16\n49\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.map","location":"base/collections.html#Base.map","category":"function","text":"map(f, c...) -> collection\n\nTransform collection c by applying f to each element. For multiple collection arguments, apply f elementwise.\n\nSee also: mapslices\n\nExamples\n\njulia> map(x -> x * 2, [1, 2, 3])\n3-element Vector{Int64}:\n 2\n 4\n 6\n\njulia> map(+, [1, 2, 3], [10, 20, 30])\n3-element Vector{Int64}:\n 11\n 22\n 33\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.map!","location":"base/collections.html#Base.map!","category":"function","text":"map!(function, destination, collection...)\n\nLike map, but stores the result in destination rather than a new collection. destination must be at least as large as the first collection.\n\nExamples\n\njulia> a = zeros(3);\n\njulia> map!(x -> x * 2, a, [1, 2, 3]);\n\njulia> a\n3-element Vector{Float64}:\n 2.0\n 4.0\n 6.0\n\n\n\n\n\nmap!(f, values(dict::AbstractDict))\n\nModifies dict by transforming each value from val to f(val). Note that the type of dict cannot be changed: if f(val) is not an instance of the value type of dict then it will be converted to the value type if possible and otherwise raise an error.\n\ncompat: Julia 1.2\nmap!(f, values(dict::AbstractDict)) requires Julia 1.2 or later.\n\nExamples\n\njulia> d = Dict(:a => 1, :b => 2)\nDict{Symbol, Int64} with 2 entries:\n  :a => 1\n  :b => 2\n\njulia> map!(v -> v-1, values(d))\nValueIterator for a Dict{Symbol, Int64} with 2 entries. Values:\n  0\n  1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mapreduce","location":"base/collections.html#Base.mapreduce-Tuple{Any, Any, Any}","category":"method","text":"mapreduce(f, op, itrs...; [init])\n\nApply function f to each element(s) in itrs, and then reduce the result using the binary function op. If provided, init must be a neutral element for op that will be returned for empty collections. It is unspecified whether init is used for non-empty collections. In general, it will be necessary to provide init to work with empty collections.\n\nmapreduce is functionally equivalent to calling reduce(op, map(f, itr); init=init), but will in general execute faster since no intermediate collection needs to be created. See documentation for reduce and map.\n\ncompat: Julia 1.2\nmapreduce with multiple iterators requires Julia 1.2 or later.\n\nExamples\n\njulia> mapreduce(x->x^2, +, [1:3;]) # == 1 + 4 + 9\n14\n\nThe associativity of the reduction is implementation-dependent. Additionally, some implementations may reuse the return value of f for elements that appear multiple times in itr. Use mapfoldl or mapfoldr instead for guaranteed left or right associativity and invocation of f for every value.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mapfoldl","location":"base/collections.html#Base.mapfoldl-Tuple{Any, Any, Any}","category":"method","text":"mapfoldl(f, op, itr; [init])\n\nLike mapreduce, but with guaranteed left associativity, as in foldl. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mapfoldr","location":"base/collections.html#Base.mapfoldr-Tuple{Any, Any, Any}","category":"method","text":"mapfoldr(f, op, itr; [init])\n\nLike mapreduce, but with guaranteed right associativity, as in foldr. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.first","location":"base/collections.html#Base.first","category":"function","text":"first(coll)\n\nGet the first element of an iterable collection. Return the start point of an AbstractRange even if it is empty.\n\nExamples\n\njulia> first(2:2:10)\n2\n\njulia> first([1; 2; 3; 4])\n1\n\n\n\n\n\nfirst(itr, n::Integer)\n\nGet the first n elements of the iterable collection itr, or fewer elements if v is not long enough.\n\ncompat: Julia 1.6\nThis method requires at least Julia 1.6.\n\nExamples\n\njulia> first([\"foo\", \"bar\", \"qux\"], 2)\n2-element Vector{String}:\n \"foo\"\n \"bar\"\n\njulia> first(1:6, 10)\n1:6\n\njulia> first(Bool[], 1)\nBool[]\n\n\n\n\n\nfirst(s::AbstractString, n::Integer)\n\nGet a string consisting of the first n characters of s.\n\nExamples\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 0)\n\"\"\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 1)\n\"∀\"\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 3)\n\"∀ϵ≠\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.last","location":"base/collections.html#Base.last","category":"function","text":"last(coll)\n\nGet the last element of an ordered collection, if it can be computed in O(1) time. This is accomplished by calling lastindex to get the last index. Return the end point of an AbstractRange even if it is empty.\n\nExamples\n\njulia> last(1:2:10)\n9\n\njulia> last([1; 2; 3; 4])\n4\n\n\n\n\n\nlast(itr, n::Integer)\n\nGet the last n elements of the iterable collection itr, or fewer elements if v is not long enough.\n\ncompat: Julia 1.6\nThis method requires at least Julia 1.6.\n\nExamples\n\njulia> last([\"foo\", \"bar\", \"qux\"], 2)\n2-element Vector{String}:\n \"bar\"\n \"qux\"\n\njulia> last(1:6, 10)\n1:6\n\njulia> last(Float64[], 1)\nFloat64[]\n\n\n\n\n\nlast(s::AbstractString, n::Integer)\n\nGet a string consisting of the last n characters of s.\n\nExamples\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 0)\n\"\"\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 1)\n\"0\"\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 3)\n\"²>0\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.front","location":"base/collections.html#Base.front","category":"function","text":"front(x::Tuple)::Tuple\n\nReturn a Tuple consisting of all but the last component of x.\n\nExamples\n\njulia> Base.front((1,2,3))\n(1, 2)\n\njulia> Base.front(())\nERROR: ArgumentError: Cannot call front on an empty tuple.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.tail","location":"base/collections.html#Base.tail","category":"function","text":"tail(x::Tuple)::Tuple\n\nReturn a Tuple consisting of all but the first component of x.\n\nExamples\n\njulia> Base.tail((1,2,3))\n(2, 3)\n\njulia> Base.tail(())\nERROR: ArgumentError: Cannot call tail on an empty tuple.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.step","location":"base/collections.html#Base.step","category":"function","text":"step(r)\n\nGet the step size of an AbstractRange object.\n\nExamples\n\njulia> step(1:10)\n1\n\njulia> step(1:2:10)\n2\n\njulia> step(2.5:0.3:10.9)\n0.3\n\njulia> step(range(2.5, stop=10.9, length=85))\n0.1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.collect","location":"base/collections.html#Base.collect-Tuple{Any}","category":"method","text":"collect(collection)\n\nReturn an Array of all items in a collection or iterator. For dictionaries, returns Pair{KeyType, ValType}. If the argument is array-like or is an iterator with the HasShape trait, the result will have the same shape and number of dimensions as the argument.\n\nExamples\n\njulia> collect(1:2:13)\n7-element Vector{Int64}:\n  1\n  3\n  5\n  7\n  9\n 11\n 13\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.collect","location":"base/collections.html#Base.collect-Tuple{Type, Any}","category":"method","text":"collect(element_type, collection)\n\nReturn an Array with the given element type of all items in a collection or iterable. The result has the same shape and number of dimensions as collection.\n\nExamples\n\njulia> collect(Float64, 1:2:5)\n3-element Vector{Float64}:\n 1.0\n 3.0\n 5.0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.filter","location":"base/collections.html#Base.filter","category":"function","text":"filter(f, a)\n\nReturn a copy of collection a, removing elements for which f is false. The function f is passed one argument.\n\ncompat: Julia 1.4\nSupport for a as a tuple requires at least Julia 1.4.\n\nExamples\n\njulia> a = 1:10\n1:10\n\njulia> filter(isodd, a)\n5-element Vector{Int64}:\n 1\n 3\n 5\n 7\n 9\n\n\n\n\n\nfilter(f, d::AbstractDict)\n\nReturn a copy of d, removing elements for which f is false. The function f is passed key=>value pairs.\n\nExamples\n\njulia> d = Dict(1=>\"a\", 2=>\"b\")\nDict{Int64, String} with 2 entries:\n  2 => \"b\"\n  1 => \"a\"\n\njulia> filter(p->isodd(p.first), d)\nDict{Int64, String} with 1 entry:\n  1 => \"a\"\n\n\n\n\n\nfilter(f, itr::SkipMissing{<:AbstractArray})\n\nReturn a vector similar to the array wrapped by the given SkipMissing iterator but with all missing elements and those for which f returns false removed.\n\ncompat: Julia 1.2\nThis method requires Julia 1.2 or later.\n\nExamples\n\njulia> x = [1 2; missing 4]\n2×2 Matrix{Union{Missing, Int64}}:\n 1         2\n  missing  4\n\njulia> filter(isodd, skipmissing(x))\n1-element Vector{Int64}:\n 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.filter!","location":"base/collections.html#Base.filter!","category":"function","text":"filter!(f, a)\n\nUpdate collection a, removing elements for which f is false. The function f is passed one argument.\n\nExamples\n\njulia> filter!(isodd, Vector(1:10))\n5-element Vector{Int64}:\n 1\n 3\n 5\n 7\n 9\n\n\n\n\n\nfilter!(f, d::AbstractDict)\n\nUpdate d, removing elements for which f is false. The function f is passed key=>value pairs.\n\nExample\n\njulia> d = Dict(1=>\"a\", 2=>\"b\", 3=>\"c\")\nDict{Int64, String} with 3 entries:\n  2 => \"b\"\n  3 => \"c\"\n  1 => \"a\"\n\njulia> filter!(p->isodd(p.first), d)\nDict{Int64, String} with 2 entries:\n  3 => \"c\"\n  1 => \"a\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.replace","location":"base/collections.html#Base.replace-Tuple{Any, Vararg{Pair, N} where N}","category":"method","text":"replace(A, old_new::Pair...; [count::Integer])\n\nReturn a copy of collection A where, for each pair old=>new in old_new, all occurrences of old are replaced by new. Equality is determined using isequal. If count is specified, then replace at most count occurrences in total.\n\nThe element type of the result is chosen using promotion (see promote_type) based on the element type of A and on the types of the new values in pairs. If count is omitted and the element type of A is a Union, the element type of the result will not include singleton types which are replaced with values of a different type: for example, Union{T,Missing} will become T if missing is replaced.\n\nSee also replace!.\n\nExamples\n\njulia> replace([1, 2, 1, 3], 1=>0, 2=>4, count=2)\n4-element Vector{Int64}:\n 0\n 4\n 1\n 3\n\njulia> replace([1, missing], missing=>0)\n2-element Vector{Int64}:\n 1\n 0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.replace","location":"base/collections.html#Base.replace-Tuple{Union{Function, Type}, Any}","category":"method","text":"replace(new::Function, A; [count::Integer])\n\nReturn a copy of A where each value x in A is replaced by new(x). If count is specified, then replace at most count values in total (replacements being defined as new(x) !== x).\n\nExamples\n\njulia> replace(x -> isodd(x) ? 2x : x, [1, 2, 3, 4])\n4-element Vector{Int64}:\n 2\n 2\n 6\n 4\n\njulia> replace(Dict(1=>2, 3=>4)) do kv\n           first(kv) < 3 ? first(kv)=>3 : kv\n       end\nDict{Int64, Int64} with 2 entries:\n  3 => 4\n  1 => 3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.replace!","location":"base/collections.html#Base.replace!","category":"function","text":"replace!(A, old_new::Pair...; [count::Integer])\n\nFor each pair old=>new in old_new, replace all occurrences of old in collection A by new. Equality is determined using isequal. If count is specified, then replace at most count occurrences in total. See also replace.\n\nExamples\n\njulia> replace!([1, 2, 1, 3], 1=>0, 2=>4, count=2)\n4-element Vector{Int64}:\n 0\n 4\n 1\n 3\n\njulia> replace!(Set([1, 2, 3]), 1=>0)\nSet{Int64} with 3 elements:\n  0\n  2\n  3\n\n\n\n\n\nreplace!(new::Function, A; [count::Integer])\n\nReplace each element x in collection A by new(x). If count is specified, then replace at most count values in total (replacements being defined as new(x) !== x).\n\nExamples\n\njulia> replace!(x -> isodd(x) ? 2x : x, [1, 2, 3, 4])\n4-element Vector{Int64}:\n 2\n 2\n 6\n 4\n\njulia> replace!(Dict(1=>2, 3=>4)) do kv\n           first(kv) < 3 ? first(kv)=>3 : kv\n       end\nDict{Int64, Int64} with 2 entries:\n  3 => 4\n  1 => 3\n\njulia> replace!(x->2x, Set([3, 6]))\nSet{Int64} with 2 elements:\n  6\n  12\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.rest","location":"base/collections.html#Base.rest","category":"function","text":"Base.rest(collection[, itr_state])\n\nGeneric function for taking the tail of collection, starting from a specific iteration state itr_state. Return a Tuple, if collection itself is a Tuple, a subtype of AbstractVector, if collection is an AbstractArray, a subtype of AbstractString if collection is an AbstractString, and an arbitrary iterator, falling back to Iterators.rest(collection[, itr_state]), otherwise. Can be overloaded for user-defined collection types to customize the behavior of slurping in assignments, like a, b... = collection.\n\ncompat: Julia 1.6\nBase.rest requires at least Julia 1.6.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> first, state = iterate(a)\n(1, 2)\n\njulia> first, Base.rest(a, state)\n(1, [3, 2, 4])\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Indexable Collections","location":"base/collections.html#Indexable-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.getindex\nBase.setindex!\nBase.firstindex\nBase.lastindex","page":"Collections and Data Structures"},{"title":"Base.getindex","location":"base/collections.html#Base.getindex","category":"function","text":"getindex(collection, key...)\n\nRetrieve the value(s) stored at the given key or index within a collection. The syntax a[i,j,...] is converted by the compiler to getindex(a, i, j, ...).\n\nExamples\n\njulia> A = Dict(\"a\" => 1, \"b\" => 2)\nDict{String, Int64} with 2 entries:\n  \"b\" => 2\n  \"a\" => 1\n\njulia> getindex(A, \"a\")\n1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.setindex!","location":"base/collections.html#Base.setindex!","category":"function","text":"setindex!(collection, value, key...)\n\nStore the given value at the given key or index within a collection. The syntax a[i,j,...] = x is converted by the compiler to (setindex!(a, x, i, j, ...); x).\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.firstindex","location":"base/collections.html#Base.firstindex","category":"function","text":"firstindex(collection) -> Integer\nfirstindex(collection, d) -> Integer\n\nReturn the first index of collection. If d is given, return the first index of collection along dimension d.\n\nExamples\n\njulia> firstindex([1,2,4])\n1\n\njulia> firstindex(rand(3,4,5), 2)\n1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.lastindex","location":"base/collections.html#Base.lastindex","category":"function","text":"lastindex(collection) -> Integer\nlastindex(collection, d) -> Integer\n\nReturn the last index of collection. If d is given, return the last index of collection along dimension d.\n\nThe syntaxes A[end] and A[end, end] lower to A[lastindex(A)] and A[lastindex(A, 1), lastindex(A, 2)], respectively.\n\nExamples\n\njulia> lastindex([1,2,4])\n3\n\njulia> lastindex(rand(3,4,5), 2)\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Array\nBitArray\nAbstractArray\nSubArray","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Partially implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"AbstractRange\nUnitRange\nTuple\nAbstractString\nDict\nIdDict\nWeakKeyDict\nNamedTuple","page":"Collections and Data Structures"},{"title":"Dictionaries","location":"base/collections.html#Dictionaries","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Dict is the standard dictionary. Its implementation uses hash as the hashing function for the key, and isequal to determine equality. Define these two functions for custom types to override how they are stored in a hash table.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"IdDict is a special hash table where the keys are always object identities.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"WeakKeyDict is a hash table implementation where the keys are weak references to objects, and thus may be garbage collected even when referenced in a hash table. Like Dict it uses hash for hashing and isequal for equality, unlike Dict it does not convert keys on insertion.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Dicts can be created by passing pair objects constructed with => to a Dict constructor: Dict(\"A\"=>1, \"B\"=>2). This call will attempt to infer type information from the keys and values (i.e. this example creates a Dict{String, Int64}). To explicitly specify types use the syntax Dict{KeyType,ValueType}(...). For example, Dict{String,Int32}(\"A\"=>1, \"B\"=>2).","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Dictionaries may also be created with generators. For example, Dict(i => f(i) for i = 1:10).","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Given a dictionary D, the syntax D[x] returns the value of key x (if it exists) or throws an error, and D[x] = y stores the key-value pair x => y in D (replacing any existing value for the key x).  Multiple arguments to D[...] are converted to tuples; for example, the syntax D[x,y]  is equivalent to D[(x,y)], i.e. it refers to the value keyed by the tuple (x,y).","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.AbstractDict\nBase.Dict\nBase.IdDict\nBase.WeakKeyDict\nBase.ImmutableDict\nBase.haskey\nBase.get(::Any, ::Any, ::Any)\nBase.get\nBase.get!(::Any, ::Any, ::Any)\nBase.get!(::Function, ::Any, ::Any)\nBase.getkey\nBase.delete!\nBase.pop!(::Any, ::Any, ::Any)\nBase.keys\nBase.values\nBase.pairs\nBase.merge\nBase.mergewith\nBase.merge!\nBase.mergewith!\nBase.sizehint!\nBase.keytype\nBase.valtype","page":"Collections and Data Structures"},{"title":"Base.AbstractDict","location":"base/collections.html#Base.AbstractDict","category":"type","text":"AbstractDict{K, V}\n\nSupertype for dictionary-like types with keys of type K and values of type V. Dict, IdDict and other types are subtypes of this. An AbstractDict{K, V} should be an iterator of Pair{K, V}.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.Dict","location":"base/collections.html#Base.Dict","category":"type","text":"Dict([itr])\n\nDict{K,V}() constructs a hash table with keys of type K and values of type V. Keys are compared with isequal and hashed with hash.\n\nGiven a single iterable argument, constructs a Dict whose key-value pairs are taken from 2-tuples (key,value) generated by the argument.\n\nExamples\n\njulia> Dict([(\"A\", 1), (\"B\", 2)])\nDict{String, Int64} with 2 entries:\n  \"B\" => 2\n  \"A\" => 1\n\nAlternatively, a sequence of pair arguments may be passed.\n\njulia> Dict(\"A\"=>1, \"B\"=>2)\nDict{String, Int64} with 2 entries:\n  \"B\" => 2\n  \"A\" => 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.IdDict","location":"base/collections.html#Base.IdDict","category":"type","text":"IdDict([itr])\n\nIdDict{K,V}() constructs a hash table using object-id as hash and === as equality with keys of type K and values of type V.\n\nSee Dict for further help.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.WeakKeyDict","location":"base/collections.html#Base.WeakKeyDict","category":"type","text":"WeakKeyDict([itr])\n\nWeakKeyDict() constructs a hash table where the keys are weak references to objects which may be garbage collected even when referenced in a hash table.\n\nSee Dict for further help.  Note, unlike Dict, WeakKeyDict does not convert keys on insertion, as this would imply the key object was unreferenced anywhere before insertion.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.ImmutableDict","location":"base/collections.html#Base.ImmutableDict","category":"type","text":"ImmutableDict\n\nImmutableDict is a dictionary implemented as an immutable linked list, which is optimal for small dictionaries that are constructed over many individual insertions. Note that it is not possible to remove a value, although it can be partially overridden and hidden by inserting a new value with the same key.\n\nImmutableDict(KV::Pair)\n\nCreate a new entry in the ImmutableDict for a key => value pair\n\nuse (key => value) in dict to see if this particular combination is in the properties set\nuse get(dict, key, default) to retrieve the most recent value for a particular key\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.haskey","location":"base/collections.html#Base.haskey","category":"function","text":"haskey(collection, key) -> Bool\n\nDetermine whether a collection has a mapping for a given key.\n\nExamples\n\njulia> D = Dict('a'=>2, 'b'=>3)\nDict{Char, Int64} with 2 entries:\n  'a' => 2\n  'b' => 3\n\njulia> haskey(D, 'a')\ntrue\n\njulia> haskey(D, 'c')\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.get","location":"base/collections.html#Base.get-Tuple{Any, Any, Any}","category":"method","text":"get(collection, key, default)\n\nReturn the value stored for the given key, or the given default value if no mapping for the key is present.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2);\n\njulia> get(d, \"a\", 3)\n1\n\njulia> get(d, \"c\", 3)\n3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.get","location":"base/collections.html#Base.get","category":"function","text":"get(collection, key, default)\n\nReturn the value stored for the given key, or the given default value if no mapping for the key is present.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2);\n\njulia> get(d, \"a\", 3)\n1\n\njulia> get(d, \"c\", 3)\n3\n\n\n\n\n\nget(f::Function, collection, key)\n\nReturn the value stored for the given key, or if no mapping for the key is present, return f().  Use get! to also store the default value in the dictionary.\n\nThis is intended to be called using do block syntax\n\nget(dict, key) do\n    # default value calculated here\n    time()\nend\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.get!","location":"base/collections.html#Base.get!-Tuple{Any, Any, Any}","category":"method","text":"get!(collection, key, default)\n\nReturn the value stored for the given key, or if no mapping for the key is present, store key => default, and return default.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2, \"c\"=>3);\n\njulia> get!(d, \"a\", 5)\n1\n\njulia> get!(d, \"d\", 4)\n4\n\njulia> d\nDict{String, Int64} with 4 entries:\n  \"c\" => 3\n  \"b\" => 2\n  \"a\" => 1\n  \"d\" => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.get!","location":"base/collections.html#Base.get!-Tuple{Function, Any, Any}","category":"method","text":"get!(f::Function, collection, key)\n\nReturn the value stored for the given key, or if no mapping for the key is present, store key => f(), and return f().\n\nThis is intended to be called using do block syntax.\n\nExamples\n\njulia> squares = Dict{Int, Int}();\n\njulia> function get_square!(d, i)\n           get!(d, i) do\n               i^2\n           end\n       end\nget_square! (generic function with 1 method)\n\njulia> get_square!(squares, 2)\n4\n\njulia> squares\nDict{Int64, Int64} with 1 entry:\n  2 => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.getkey","location":"base/collections.html#Base.getkey","category":"function","text":"getkey(collection, key, default)\n\nReturn the key matching argument key if one exists in collection, otherwise return default.\n\nExamples\n\njulia> D = Dict('a'=>2, 'b'=>3)\nDict{Char, Int64} with 2 entries:\n  'a' => 2\n  'b' => 3\n\njulia> getkey(D, 'a', 1)\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> getkey(D, 'd', 'a')\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.delete!","location":"base/collections.html#Base.delete!","category":"function","text":"delete!(collection, key)\n\nDelete the mapping for the given key in a collection, if any, and return the collection.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2)\nDict{String, Int64} with 2 entries:\n  \"b\" => 2\n  \"a\" => 1\n\njulia> delete!(d, \"b\")\nDict{String, Int64} with 1 entry:\n  \"a\" => 1\n\njulia> delete!(d, \"b\") # d is left unchanged\nDict{String, Int64} with 1 entry:\n  \"a\" => 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pop!","location":"base/collections.html#Base.pop!-Tuple{Any, Any, Any}","category":"method","text":"pop!(collection, key[, default])\n\nDelete and return the mapping for key if it exists in collection, otherwise return default, or throw an error if default is not specified.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2, \"c\"=>3);\n\njulia> pop!(d, \"a\")\n1\n\njulia> pop!(d, \"d\")\nERROR: KeyError: key \"d\" not found\nStacktrace:\n[...]\n\njulia> pop!(d, \"e\", 4)\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.keys","location":"base/collections.html#Base.keys","category":"function","text":"keys(iterator)\n\nFor an iterator or collection that has keys and values (e.g. arrays and dictionaries), return an iterator over the keys.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.values","location":"base/collections.html#Base.values","category":"function","text":"values(iterator)\n\nFor an iterator or collection that has keys and values, return an iterator over the values. This function simply returns its argument by default, since the elements of a general iterator are normally considered its \"values\".\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2);\n\njulia> values(d)\nValueIterator for a Dict{String, Int64} with 2 entries. Values:\n  2\n  1\n\njulia> values([2])\n1-element Vector{Int64}:\n 2\n\n\n\n\n\nvalues(a::AbstractDict)\n\nReturn an iterator over all values in a collection. collect(values(a)) returns an array of values. When the values are stored internally in a hash table, as is the case for Dict, the order in which they are returned may vary. But keys(a) and values(a) both iterate a and return the elements in the same order.\n\nExamples\n\njulia> D = Dict('a'=>2, 'b'=>3)\nDict{Char, Int64} with 2 entries:\n  'a' => 2\n  'b' => 3\n\njulia> collect(values(D))\n2-element Vector{Int64}:\n 2\n 3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pairs","location":"base/collections.html#Base.pairs","category":"function","text":"pairs(collection)\n\nReturn an iterator over key => value pairs for any collection that maps a set of keys to a set of values. This includes arrays, where the keys are the array indices.\n\n\n\n\n\npairs(IndexLinear(), A)\npairs(IndexCartesian(), A)\npairs(IndexStyle(A), A)\n\nAn iterator that accesses each element of the array A, returning i => x, where i is the index for the element and x = A[i]. Identical to pairs(A), except that the style of index can be selected. Also similar to enumerate(A), except i will be a valid index for A, while enumerate always counts from 1 regardless of the indices of A.\n\nSpecifying IndexLinear() ensures that i will be an integer; specifying IndexCartesian() ensures that i will be a CartesianIndex; specifying IndexStyle(A) chooses whichever has been defined as the native indexing style for array A.\n\nMutation of the bounds of the underlying array will invalidate this iterator.\n\nExamples\n\njulia> A = [\"a\" \"d\"; \"b\" \"e\"; \"c\" \"f\"];\n\njulia> for (index, value) in pairs(IndexStyle(A), A)\n           println(\"$index $value\")\n       end\n1 a\n2 b\n3 c\n4 d\n5 e\n6 f\n\njulia> S = view(A, 1:2, :);\n\njulia> for (index, value) in pairs(IndexStyle(S), S)\n           println(\"$index $value\")\n       end\nCartesianIndex(1, 1) a\nCartesianIndex(2, 1) b\nCartesianIndex(1, 2) d\nCartesianIndex(2, 2) e\n\nSee also: IndexStyle, axes.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.merge","location":"base/collections.html#Base.merge","category":"function","text":"merge(d::AbstractDict, others::AbstractDict...)\n\nConstruct a merged collection from the given collections. If necessary, the types of the resulting collection will be promoted to accommodate the types of the merged collections. If the same key is present in another collection, the value for that key will be the value it has in the last collection listed. See also mergewith for custom handling of values with the same key.\n\nExamples\n\njulia> a = Dict(\"foo\" => 0.0, \"bar\" => 42.0)\nDict{String, Float64} with 2 entries:\n  \"bar\" => 42.0\n  \"foo\" => 0.0\n\njulia> b = Dict(\"baz\" => 17, \"bar\" => 4711)\nDict{String, Int64} with 2 entries:\n  \"bar\" => 4711\n  \"baz\" => 17\n\njulia> merge(a, b)\nDict{String, Float64} with 3 entries:\n  \"bar\" => 4711.0\n  \"baz\" => 17.0\n  \"foo\" => 0.0\n\njulia> merge(b, a)\nDict{String, Float64} with 3 entries:\n  \"bar\" => 42.0\n  \"baz\" => 17.0\n  \"foo\" => 0.0\n\n\n\n\n\nmerge(a::NamedTuple, bs::NamedTuple...)\n\nConstruct a new named tuple by merging two or more existing ones, in a left-associative manner. Merging proceeds left-to-right, between pairs of named tuples, and so the order of fields present in both the leftmost and rightmost named tuples take the same position as they are found in the leftmost named tuple. However, values are taken from matching fields in the rightmost named tuple that contains that field. Fields present in only the rightmost named tuple of a pair are appended at the end. A fallback is implemented for when only a single named tuple is supplied, with signature merge(a::NamedTuple).\n\ncompat: Julia 1.1\nMerging 3 or more NamedTuple requires at least Julia 1.1.\n\nExamples\n\njulia> merge((a=1, b=2, c=3), (b=4, d=5))\n(a = 1, b = 4, c = 3, d = 5)\n\njulia> merge((a=1, b=2), (b=3, c=(d=1,)), (c=(d=2,),))\n(a = 1, b = 3, c = (d = 2,))\n\n\n\n\n\nmerge(a::NamedTuple, iterable)\n\nInterpret an iterable of key-value pairs as a named tuple, and perform a merge.\n\njulia> merge((a=1, b=2, c=3), [:b=>4, :d=>5])\n(a = 1, b = 4, c = 3, d = 5)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mergewith","location":"base/collections.html#Base.mergewith","category":"function","text":"mergewith(combine, d::AbstractDict, others::AbstractDict...)\nmergewith(combine)\nmerge(combine, d::AbstractDict, others::AbstractDict...)\n\nConstruct a merged collection from the given collections. If necessary, the types of the resulting collection will be promoted to accommodate the types of the merged collections. Values with the same key will be combined using the combiner function.  The curried form mergewith(combine) returns the function (args...) -> mergewith(combine, args...).\n\nMethod merge(combine::Union{Function,Type}, args...) as an alias of mergewith(combine, args...) is still available for backward compatibility.\n\ncompat: Julia 1.5\nmergewith requires Julia 1.5 or later.\n\nExamples\n\njulia> a = Dict(\"foo\" => 0.0, \"bar\" => 42.0)\nDict{String, Float64} with 2 entries:\n  \"bar\" => 42.0\n  \"foo\" => 0.0\n\njulia> b = Dict(\"baz\" => 17, \"bar\" => 4711)\nDict{String, Int64} with 2 entries:\n  \"bar\" => 4711\n  \"baz\" => 17\n\njulia> mergewith(+, a, b)\nDict{String, Float64} with 3 entries:\n  \"bar\" => 4753.0\n  \"baz\" => 17.0\n  \"foo\" => 0.0\n\njulia> ans == mergewith(+)(a, b)\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.merge!","location":"base/collections.html#Base.merge!","category":"function","text":"merge!(d::AbstractDict, others::AbstractDict...)\n\nUpdate collection with pairs from the other collections. See also merge.\n\nExamples\n\njulia> d1 = Dict(1 => 2, 3 => 4);\n\njulia> d2 = Dict(1 => 4, 4 => 5);\n\njulia> merge!(d1, d2);\n\njulia> d1\nDict{Int64, Int64} with 3 entries:\n  4 => 5\n  3 => 4\n  1 => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mergewith!","location":"base/collections.html#Base.mergewith!","category":"function","text":"mergewith!(combine, d::AbstractDict, others::AbstractDict...) -> d\nmergewith!(combine)\nmerge!(combine, d::AbstractDict, others::AbstractDict...) -> d\n\nUpdate collection with pairs from the other collections. Values with the same key will be combined using the combiner function.  The curried form mergewith!(combine) returns the function (args...) -> mergewith!(combine, args...).\n\nMethod merge!(combine::Union{Function,Type}, args...) as an alias of mergewith!(combine, args...) is still available for backward compatibility.\n\ncompat: Julia 1.5\nmergewith! requires Julia 1.5 or later.\n\nExamples\n\njulia> d1 = Dict(1 => 2, 3 => 4);\n\njulia> d2 = Dict(1 => 4, 4 => 5);\n\njulia> mergewith!(+, d1, d2);\n\njulia> d1\nDict{Int64, Int64} with 3 entries:\n  4 => 5\n  3 => 4\n  1 => 6\n\njulia> mergewith!(-, d1, d1);\n\njulia> d1\nDict{Int64, Int64} with 3 entries:\n  4 => 0\n  3 => 0\n  1 => 0\n\njulia> foldl(mergewith!(+), [d1, d2]; init=Dict{Int64, Int64}())\nDict{Int64, Int64} with 3 entries:\n  4 => 5\n  3 => 0\n  1 => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.sizehint!","location":"base/collections.html#Base.sizehint!","category":"function","text":"sizehint!(s, n)\n\nSuggest that collection s reserve capacity for at least n elements. This can improve performance.\n\nNotes on the performance model\n\nFor types that support sizehint!,\n\npush! and append! methods generally may (but are not required to) preallocate extra\n\nstorage. For types implemented in Base, they typically do, using a heuristic optimized for a general use case.\n\nsizehint! may control this preallocation. Again, it typically does this for types in\n\nBase.\n\nempty! is nearly costless (and O(1)) for types that support this kind of preallocation.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.keytype","location":"base/collections.html#Base.keytype","category":"function","text":"keytype(T::Type{<:AbstractArray})\nkeytype(A::AbstractArray)\n\nReturn the key type of an array. This is equal to the eltype of the result of keys(...), and is provided mainly for compatibility with the dictionary interface.\n\nExamples\n\njulia> keytype([1, 2, 3]) == Int\ntrue\n\njulia> keytype([1 2; 3 4])\nCartesianIndex{2}\n\ncompat: Julia 1.2\nFor arrays, this function requires at least Julia 1.2.\n\n\n\n\n\nkeytype(type)\n\nGet the key type of an dictionary type. Behaves similarly to eltype.\n\nExamples\n\njulia> keytype(Dict(Int32(1) => \"foo\"))\nInt32\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.valtype","location":"base/collections.html#Base.valtype","category":"function","text":"valtype(T::Type{<:AbstractArray})\nvaltype(A::AbstractArray)\n\nReturn the value type of an array. This is identical to eltype and is provided mainly for compatibility with the dictionary interface.\n\nExamples\n\njulia> valtype([\"one\", \"two\", \"three\"])\nString\n\ncompat: Julia 1.2\nFor arrays, this function requires at least Julia 1.2.\n\n\n\n\n\nvaltype(type)\n\nGet the value type of an dictionary type. Behaves similarly to eltype.\n\nExamples\n\njulia> valtype(Dict(Int32(1) => \"foo\"))\nString\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"IdDict\nDict\nWeakKeyDict","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Partially implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"BitSet\nSet\nEnvDict\nArray\nBitArray\nImmutableDict\nIterators.Pairs","page":"Collections and Data Structures"},{"title":"Set-Like Collections","location":"base/collections.html#Set-Like-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.AbstractSet\nBase.Set\nBase.BitSet\nBase.union\nBase.union!\nBase.intersect\nBase.setdiff\nBase.setdiff!\nBase.symdiff\nBase.symdiff!\nBase.intersect!\nBase.issubset\nBase.:⊈\nBase.:⊊\nBase.issetequal\nBase.isdisjoint","page":"Collections and Data Structures"},{"title":"Base.AbstractSet","location":"base/collections.html#Base.AbstractSet","category":"type","text":"AbstractSet{T}\n\nSupertype for set-like types whose elements are of type T. Set, BitSet and other types are subtypes of this.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.Set","location":"base/collections.html#Base.Set","category":"type","text":"Set([itr])\n\nConstruct a Set of the values generated by the given iterable object, or an empty set. Should be used instead of BitSet for sparse integer sets, or for sets of arbitrary objects.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.BitSet","location":"base/collections.html#Base.BitSet","category":"type","text":"BitSet([itr])\n\nConstruct a sorted set of Ints generated by the given iterable object, or an empty set. Implemented as a bit string, and therefore designed for dense integer sets. If the set will be sparse (for example, holding a few very large integers), use Set instead.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.union","location":"base/collections.html#Base.union","category":"function","text":"union(s, itrs...)\n∪(s, itrs...)\n\nConstruct the union of sets. Maintain order with arrays.\n\nExamples\n\njulia> union([1, 2], [3, 4])\n4-element Vector{Int64}:\n 1\n 2\n 3\n 4\n\njulia> union([1, 2], [2, 4])\n3-element Vector{Int64}:\n 1\n 2\n 4\n\njulia> union([4, 2], 1:2)\n3-element Vector{Int64}:\n 4\n 2\n 1\n\njulia> union(Set([1, 2]), 2:3)\nSet{Int64} with 3 elements:\n  2\n  3\n  1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.union!","location":"base/collections.html#Base.union!","category":"function","text":"union!(s::Union{AbstractSet,AbstractVector}, itrs...)\n\nConstruct the union of passed in sets and overwrite s with the result. Maintain order with arrays.\n\nExamples\n\njulia> a = Set([1, 3, 4, 5]);\n\njulia> union!(a, 1:2:8);\n\njulia> a\nSet{Int64} with 5 elements:\n  5\n  4\n  7\n  3\n  1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.intersect","location":"base/collections.html#Base.intersect","category":"function","text":"intersect(s, itrs...)\n∩(s, itrs...)\n\nConstruct the intersection of sets. Maintain order with arrays.\n\nExamples\n\njulia> intersect([1, 2, 3], [3, 4, 5])\n1-element Vector{Int64}:\n 3\n\njulia> intersect([1, 4, 4, 5, 6], [4, 6, 6, 7, 8])\n2-element Vector{Int64}:\n 4\n 6\n\njulia> intersect(Set([1, 2]), BitSet([2, 3]))\nSet{Int64} with 1 element:\n  2\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.setdiff","location":"base/collections.html#Base.setdiff","category":"function","text":"setdiff(s, itrs...)\n\nConstruct the set of elements in s but not in any of the iterables in itrs. Maintain order with arrays.\n\nExamples\n\njulia> setdiff([1,2,3], [3,4,5])\n2-element Vector{Int64}:\n 1\n 2\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.setdiff!","location":"base/collections.html#Base.setdiff!","category":"function","text":"setdiff!(s, itrs...)\n\nRemove from set s (in-place) each element of each iterable from itrs. Maintain order with arrays.\n\nExamples\n\njulia> a = Set([1, 3, 4, 5]);\n\njulia> setdiff!(a, 1:2:6);\n\njulia> a\nSet{Int64} with 1 element:\n  4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.symdiff","location":"base/collections.html#Base.symdiff","category":"function","text":"symdiff(s, itrs...)\n\nConstruct the symmetric difference of elements in the passed in sets. When s is not an AbstractSet, the order is maintained. Note that in this case the multiplicity of elements matters.\n\nExamples\n\njulia> symdiff([1,2,3], [3,4,5], [4,5,6])\n3-element Vector{Int64}:\n 1\n 2\n 6\n\njulia> symdiff([1,2,1], [2, 1, 2])\n2-element Vector{Int64}:\n 1\n 2\n\njulia> symdiff(unique([1,2,1]), unique([2, 1, 2]))\nInt64[]\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.symdiff!","location":"base/collections.html#Base.symdiff!","category":"function","text":"symdiff!(s::Union{AbstractSet,AbstractVector}, itrs...)\n\nConstruct the symmetric difference of the passed in sets, and overwrite s with the result. When s is an array, the order is maintained. Note that in this case the multiplicity of elements matters.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.intersect!","location":"base/collections.html#Base.intersect!","category":"function","text":"intersect!(s::Union{AbstractSet,AbstractVector}, itrs...)\n\nIntersect all passed in sets and overwrite s with the result. Maintain order with arrays.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.issubset","location":"base/collections.html#Base.issubset","category":"function","text":"issubset(a, b) -> Bool\n⊆(a, b) -> Bool\n⊇(b, a) -> Bool\n\nDetermine whether every element of a is also in b, using in.\n\nExamples\n\njulia> issubset([1, 2], [1, 2, 3])\ntrue\n\njulia> [1, 2, 3] ⊆ [1, 2]\nfalse\n\njulia> [1, 2, 3] ⊇ [1, 2]\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.:⊈","location":"base/collections.html#Base.:⊈","category":"function","text":"⊈(a, b) -> Bool\n⊉(b, a) -> Bool\n\nNegation of ⊆ and ⊇, i.e. checks that a is not a subset of b.\n\nExamples\n\njulia> (1, 2) ⊈ (2, 3)\ntrue\n\njulia> (1, 2) ⊈ (1, 2, 3)\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.:⊊","location":"base/collections.html#Base.:⊊","category":"function","text":"⊊(a, b) -> Bool\n⊋(b, a) -> Bool\n\nDetermines if a is a subset of, but not equal to, b.\n\nExamples\n\njulia> (1, 2) ⊊ (1, 2, 3)\ntrue\n\njulia> (1, 2) ⊊ (1, 2)\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.issetequal","location":"base/collections.html#Base.issetequal","category":"function","text":"issetequal(a, b) -> Bool\n\nDetermine whether a and b have the same elements. Equivalent to a ⊆ b && b ⊆ a but more efficient when possible.\n\nExamples\n\njulia> issetequal([1, 2], [1, 2, 3])\nfalse\n\njulia> issetequal([1, 2], [2, 1])\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.isdisjoint","location":"base/collections.html#Base.isdisjoint","category":"function","text":"isdisjoint(v1, v2) -> Bool\n\nReturn whether the collections v1 and v2 are disjoint, i.e. whether their intersection is empty.\n\ncompat: Julia 1.5\nThis function requires at least Julia 1.5.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"BitSet\nSet","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Partially implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Array","page":"Collections and Data Structures"},{"title":"Dequeues","location":"base/collections.html#Dequeues","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.push!\nBase.pop!\nBase.popat!\nBase.pushfirst!\nBase.popfirst!\nBase.insert!\nBase.deleteat!\nBase.splice!\nBase.resize!\nBase.append!\nBase.prepend!","page":"Collections and Data Structures"},{"title":"Base.push!","location":"base/collections.html#Base.push!","category":"function","text":"push!(collection, items...) -> collection\n\nInsert one or more items in collection. If collection is an ordered container, the items are inserted at the end (in the given order).\n\nExamples\n\njulia> push!([1, 2, 3], 4, 5, 6)\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\nIf collection is ordered, use append! to add all the elements of another collection to it. The result of the preceding example is equivalent to append!([1, 2, 3], [4, 5, 6]). For AbstractSet objects, union! can be used instead.\n\nSee sizehint! for notes about the performance model.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pop!","location":"base/collections.html#Base.pop!","category":"function","text":"pop!(collection) -> item\n\nRemove an item in collection and return it. If collection is an ordered container, the last item is returned; for unordered containers, an arbitrary element is returned.\n\nExamples\n\njulia> A=[1, 2, 3]\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> pop!(A)\n3\n\njulia> A\n2-element Vector{Int64}:\n 1\n 2\n\njulia> S = Set([1, 2])\nSet{Int64} with 2 elements:\n  2\n  1\n\njulia> pop!(S)\n2\n\njulia> S\nSet{Int64} with 1 element:\n  1\n\njulia> pop!(Dict(1=>2))\n1 => 2\n\n\n\n\n\npop!(collection, key[, default])\n\nDelete and return the mapping for key if it exists in collection, otherwise return default, or throw an error if default is not specified.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2, \"c\"=>3);\n\njulia> pop!(d, \"a\")\n1\n\njulia> pop!(d, \"d\")\nERROR: KeyError: key \"d\" not found\nStacktrace:\n[...]\n\njulia> pop!(d, \"e\", 4)\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.popat!","location":"base/collections.html#Base.popat!","category":"function","text":"popat!(a::Vector, i::Integer, [default])\n\nRemove the item at the given i and return it. Subsequent items are shifted to fill the resulting gap. When i is not a valid index for a, return default, or throw an error if default is not specified. See also deleteat! and splice!.\n\ncompat: Julia 1.5\nThis function is available as of Julia 1.5.\n\nExamples\n\njulia> a = [4, 3, 2, 1]; popat!(a, 2)\n3\n\njulia> a\n3-element Vector{Int64}:\n 4\n 2\n 1\n\njulia> popat!(a, 4, missing)\nmissing\n\njulia> popat!(a, 4)\nERROR: BoundsError: attempt to access 3-element Vector{Int64} at index [4]\n[...]\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pushfirst!","location":"base/collections.html#Base.pushfirst!","category":"function","text":"pushfirst!(collection, items...) -> collection\n\nInsert one or more items at the beginning of collection.\n\nExamples\n\njulia> pushfirst!([1, 2, 3, 4], 5, 6)\n6-element Vector{Int64}:\n 5\n 6\n 1\n 2\n 3\n 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.popfirst!","location":"base/collections.html#Base.popfirst!","category":"function","text":"popfirst!(collection) -> item\n\nRemove the first item from collection.\n\nExamples\n\njulia> A = [1, 2, 3, 4, 5, 6]\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\njulia> popfirst!(A)\n1\n\njulia> A\n5-element Vector{Int64}:\n 2\n 3\n 4\n 5\n 6\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.insert!","location":"base/collections.html#Base.insert!","category":"function","text":"insert!(a::Vector, index::Integer, item)\n\nInsert an item into a at the given index. index is the index of item in the resulting a.\n\nExamples\n\njulia> insert!([6, 5, 4, 2, 1], 4, 3)\n6-element Vector{Int64}:\n 6\n 5\n 4\n 3\n 2\n 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.deleteat!","location":"base/collections.html#Base.deleteat!","category":"function","text":"deleteat!(a::Vector, i::Integer)\n\nRemove the item at the given i and return the modified a. Subsequent items are shifted to fill the resulting gap.\n\nExamples\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], 2)\n5-element Vector{Int64}:\n 6\n 4\n 3\n 2\n 1\n\n\n\n\n\ndeleteat!(a::Vector, inds)\n\nRemove the items at the indices given by inds, and return the modified a. Subsequent items are shifted to fill the resulting gap.\n\ninds can be either an iterator or a collection of sorted and unique integer indices, or a boolean vector of the same length as a with true indicating entries to delete.\n\nExamples\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], 1:2:5)\n3-element Vector{Int64}:\n 5\n 3\n 1\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], [true, false, true, false, true, false])\n3-element Vector{Int64}:\n 5\n 3\n 1\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], (2, 2))\nERROR: ArgumentError: indices must be unique and sorted\nStacktrace:\n[...]\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.splice!","location":"base/collections.html#Base.splice!","category":"function","text":"splice!(a::Vector, index::Integer, [replacement]) -> item\n\nRemove the item at the given index, and return the removed item. Subsequent items are shifted left to fill the resulting gap. If specified, replacement values from an ordered collection will be spliced in place of the removed item.\n\nExamples\n\njulia> A = [6, 5, 4, 3, 2, 1]; splice!(A, 5)\n2\n\njulia> A\n5-element Vector{Int64}:\n 6\n 5\n 4\n 3\n 1\n\njulia> splice!(A, 5, -1)\n1\n\njulia> A\n5-element Vector{Int64}:\n  6\n  5\n  4\n  3\n -1\n\njulia> splice!(A, 1, [-1, -2, -3])\n6\n\njulia> A\n7-element Vector{Int64}:\n -1\n -2\n -3\n  5\n  4\n  3\n -1\n\nTo insert replacement before an index n without removing any items, use splice!(collection, n:n-1, replacement).\n\n\n\n\n\nsplice!(a::Vector, indices, [replacement]) -> items\n\nRemove items at specified indices, and return a collection containing the removed items. Subsequent items are shifted left to fill the resulting gaps. If specified, replacement values from an ordered collection will be spliced in place of the removed items; in this case, indices must be a UnitRange.\n\nTo insert replacement before an index n without removing any items, use splice!(collection, n:n-1, replacement).\n\ncompat: Julia 1.5\nPrior to Julia 1.5, indices must always be a UnitRange.\n\nExamples\n\njulia> A = [-1, -2, -3, 5, 4, 3, -1]; splice!(A, 4:3, 2)\nInt64[]\n\njulia> A\n8-element Vector{Int64}:\n -1\n -2\n -3\n  2\n  5\n  4\n  3\n -1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.resize!","location":"base/collections.html#Base.resize!","category":"function","text":"resize!(a::Vector, n::Integer) -> Vector\n\nResize a to contain n elements. If n is smaller than the current collection length, the first n elements will be retained. If n is larger, the new elements are not guaranteed to be initialized.\n\nExamples\n\njulia> resize!([6, 5, 4, 3, 2, 1], 3)\n3-element Vector{Int64}:\n 6\n 5\n 4\n\njulia> a = resize!([6, 5, 4, 3, 2, 1], 8);\n\njulia> length(a)\n8\n\njulia> a[1:6]\n6-element Vector{Int64}:\n 6\n 5\n 4\n 3\n 2\n 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.append!","location":"base/collections.html#Base.append!","category":"function","text":"append!(collection, collections...) -> collection.\n\nFor an ordered container collection, add the elements of each collections to the end of it.\n\ncompat: Julia 1.6\nSpecifying multiple collections to be appended requires at least Julia 1.6.\n\nExamples\n\njulia> append!([1], [2, 3])\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> append!([1, 2, 3], [4, 5], [6])\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\nUse push! to add individual items to collection which are not already themselves in another collection. The result of the preceding example is equivalent to push!([1, 2, 3], 4, 5, 6).\n\nSee sizehint! for notes about the performance model.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.prepend!","location":"base/collections.html#Base.prepend!","category":"function","text":"prepend!(a::Vector, collections...) -> collection\n\nInsert the elements of each collections to the beginning of a.\n\nWhen collections specifies multiple collections, order is maintained: elements of collections[1] will appear leftmost in a, and so on.\n\ncompat: Julia 1.6\nSpecifying multiple collections to be prepended requires at least Julia 1.6.\n\nExamples\n\njulia> prepend!([3], [1, 2])\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> prepend!([6], [1, 2], [3, 4, 5])\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Vector (a.k.a. 1-dimensional Array)\nBitVector (a.k.a. 1-dimensional BitArray)","page":"Collections and Data Structures"},{"title":"Utility Collections","location":"base/collections.html#Utility-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.Pair\nIterators.Pairs","page":"Collections and Data Structures"},{"title":"Base.Pair","location":"base/collections.html#Base.Pair","category":"type","text":"Pair(x, y)\nx => y\n\nConstruct a Pair object with type Pair{typeof(x), typeof(y)}. The elements are stored in the fields first and second. They can also be accessed via iteration (but a Pair is treated as a single \"scalar\" for broadcasting operations).\n\nSee also: Dict\n\nExamples\n\njulia> p = \"foo\" => 7\n\"foo\" => 7\n\njulia> typeof(p)\nPair{String, Int64}\n\njulia> p.first\n\"foo\"\n\njulia> for x in p\n           println(x)\n       end\nfoo\n7\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.Iterators.Pairs","location":"base/collections.html#Base.Iterators.Pairs","category":"type","text":"Iterators.Pairs(values, keys) <: AbstractDict{eltype(keys), eltype(values)}\n\nTransforms an indexable container into an Dictionary-view of the same data. Modifying the key-space of the underlying data may invalidate this object.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Random Numbers","location":"stdlib/Random.html#Random-Numbers","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"DocTestSetup = :(using Random)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random number generation in Julia uses the Mersenne Twister library via MersenneTwister objects. Julia has a global RNG, which is used by default. Other RNG types can be plugged in by inheriting the AbstractRNG type; they can then be used to have multiple streams of random numbers. Besides MersenneTwister, Julia also provides the RandomDevice RNG type, which is a wrapper over the OS provided entropy.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Most functions related to random generation accept an optional AbstractRNG object as first argument, which defaults to the global one if not provided. Moreover, some of them accept optionally dimension specifications dims... (which can be given as a tuple) to generate arrays of random values.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"A MersenneTwister or RandomDevice RNG can generate uniformly random numbers of the following types: Float16, Float32, Float64, BigFloat, Bool, Int8, UInt8, Int16, UInt16, Int32, UInt32, Int64, UInt64, Int128, UInt128, BigInt (or complex numbers of those types). Random floating point numbers are generated uniformly in 0 1). As BigInt represents unbounded integers, the interval must be specified (e.g. rand(big.(1:6))).","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Additionally, normal and exponential distributions are implemented for some AbstractFloat and Complex types, see randn and randexp for details.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"warning: Warning\nBecause the precise way in which random numbers are generated is considered an implementation detail, bug fixes and speed improvements may change the stream of numbers that are generated after a version change. Relying on a specific seed or generated stream of numbers during unit testing is thus discouraged - consider testing properties of the methods in question instead.","page":"Random Numbers"},{"title":"Random numbers module","location":"stdlib/Random.html#Random-numbers-module","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.Random","page":"Random Numbers"},{"title":"Random.Random","location":"stdlib/Random.html#Random.Random","category":"module","text":"Random\n\nSupport for generating random numbers. Provides rand, randn, AbstractRNG, MersenneTwister, and RandomDevice.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random generation functions","location":"stdlib/Random.html#Random-generation-functions","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.rand\nRandom.rand!\nRandom.bitrand\nRandom.randn\nRandom.randn!\nRandom.randexp\nRandom.randexp!\nRandom.randstring","page":"Random Numbers"},{"title":"Base.rand","location":"stdlib/Random.html#Base.rand","category":"function","text":"rand([rng=GLOBAL_RNG], [S], [dims...])\n\nPick a random element or array of random elements from the set of values specified by S; S can be\n\nan indexable collection (for example 1:9 or ('x', \"y\", :z)),\nan AbstractDict or AbstractSet object,\na string (considered as a collection of characters), or\na type: the set of values to pick from is then equivalent to typemin(S):typemax(S) for integers (this is not applicable to BigInt), to 0 1) for floating point numbers and to 0 1)+i0 1) for complex floating point numbers;\n\nS defaults to Float64. When only one argument is passed besides the optional rng and is a Tuple, it is interpreted as a collection of values (S) and not as dims.\n\ncompat: Julia 1.1\nSupport for S as a tuple requires at least Julia 1.1.\n\nExamples\n\njulia> rand(Int, 2)\n2-element Array{Int64,1}:\n 1339893410598768192\n 1575814717733606317\n\njulia> using Random\n\njulia> rand(MersenneTwister(0), Dict(1=>2, 3=>4))\n1=>2\n\njulia> rand((2, 3))\n3\n\njulia> rand(Float64, (2, 3))\n2×3 Array{Float64,2}:\n 0.999717  0.0143835  0.540787\n 0.696556  0.783855   0.938235\n\nnote: Note\nThe complexity of rand(rng, s::Union{AbstractDict,AbstractSet}) is linear in the length of s, unless an optimized method with constant complexity is available, which is the case for Dict, Set and BitSet. For more than a few calls, use rand(rng, collect(s)) instead, or either rand(rng, Dict(s)) or rand(rng, Set(s)) as appropriate.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.rand!","location":"stdlib/Random.html#Random.rand!","category":"function","text":"rand!([rng=GLOBAL_RNG], A, [S=eltype(A)])\n\nPopulate the array A with random values. If S is specified (S can be a type or a collection, cf. rand for details), the values are picked randomly from S. This is equivalent to copyto!(A, rand(rng, S, size(A))) but without allocating a new array.\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> rand!(rng, zeros(5))\n5-element Vector{Float64}:\n 0.5908446386657102\n 0.7667970365022592\n 0.5662374165061859\n 0.4600853424625171\n 0.7940257103317943\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.bitrand","location":"stdlib/Random.html#Random.bitrand","category":"function","text":"bitrand([rng=GLOBAL_RNG], [dims...])\n\nGenerate a BitArray of random boolean values.\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> bitrand(rng, 10)\n10-element BitVector:\n 0\n 0\n 0\n 0\n 1\n 0\n 0\n 0\n 1\n 1\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Base.randn","location":"stdlib/Random.html#Base.randn","category":"function","text":"randn([rng=GLOBAL_RNG], [T=Float64], [dims...])\n\nGenerate a normally-distributed random number of type T with mean 0 and standard deviation 1. Optionally generate an array of normally-distributed random numbers. The Base module currently provides an implementation for the types Float16, Float32, and Float64 (the default), and their Complex counterparts. When the type argument is complex, the values are drawn from the circularly symmetric complex normal distribution of variance 1 (corresponding to real and imaginary part having independent normal distribution with mean zero and variance 1/2).\n\nExamples\n\njulia> using Random\n\njulia> rng = MersenneTwister(1234);\n\njulia> randn(rng, ComplexF64)\n0.6133070881429037 - 0.6376291670853887im\n\njulia> randn(rng, ComplexF32, (2, 3))\n2×3 Matrix{ComplexF32}:\n -0.349649-0.638457im  0.376756-0.192146im  -0.396334-0.0136413im\n  0.611224+1.56403im   0.355204-0.365563im  0.0905552+1.31012im\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randn!","location":"stdlib/Random.html#Random.randn!","category":"function","text":"randn!([rng=GLOBAL_RNG], A::AbstractArray) -> A\n\nFill the array A with normally-distributed (mean 0, standard deviation 1) random numbers. Also see the rand function.\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> randn!(rng, zeros(5))\n5-element Vector{Float64}:\n  0.8673472019512456\n -0.9017438158568171\n -0.4944787535042339\n -0.9029142938652416\n  0.8644013132535154\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randexp","location":"stdlib/Random.html#Random.randexp","category":"function","text":"randexp([rng=GLOBAL_RNG], [T=Float64], [dims...])\n\nGenerate a random number of type T according to the exponential distribution with scale 1. Optionally generate an array of such random numbers. The Base module currently provides an implementation for the types Float16, Float32, and Float64 (the default).\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> randexp(rng, Float32)\n2.4835055f0\n\njulia> randexp(rng, 3, 3)\n3×3 Matrix{Float64}:\n 1.5167    1.30652   0.344435\n 0.604436  2.78029   0.418516\n 0.695867  0.693292  0.643644\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randexp!","location":"stdlib/Random.html#Random.randexp!","category":"function","text":"randexp!([rng=GLOBAL_RNG], A::AbstractArray) -> A\n\nFill the array A with random numbers following the exponential distribution (with scale 1).\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> randexp!(rng, zeros(5))\n5-element Vector{Float64}:\n 2.4835053723904896\n 1.516703605376473\n 0.6044364871025417\n 0.6958665886385867\n 1.3065196315496677\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randstring","location":"stdlib/Random.html#Random.randstring","category":"function","text":"randstring([rng=GLOBAL_RNG], [chars], [len=8])\n\nCreate a random string of length len, consisting of characters from chars, which defaults to the set of upper- and lower-case letters and the digits 0-9. The optional rng argument specifies a random number generator, see Random Numbers.\n\nExamples\n\njulia> Random.seed!(3); randstring()\n\"Y7m62wOj\"\n\njulia> randstring(MersenneTwister(3), 'a':'z', 6)\n\"ocucay\"\n\njulia> randstring(\"ACGT\")\n\"ATTTGCGT\"\n\nnote: Note\nchars can be any collection of characters, of type Char or UInt8 (more efficient), provided rand can randomly pick characters from it.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Subsequences, permutations and shuffling","location":"stdlib/Random.html#Subsequences,-permutations-and-shuffling","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.randsubseq\nRandom.randsubseq!\nRandom.randperm\nRandom.randperm!\nRandom.randcycle\nRandom.randcycle!\nRandom.shuffle\nRandom.shuffle!","page":"Random Numbers"},{"title":"Random.randsubseq","location":"stdlib/Random.html#Random.randsubseq","category":"function","text":"randsubseq([rng=GLOBAL_RNG,] A, p) -> Vector\n\nReturn a vector consisting of a random subsequence of the given array A, where each element of A is included (in order) with independent probability p. (Complexity is linear in p*length(A), so this function is efficient even if p is small and A is large.) Technically, this process is known as \"Bernoulli sampling\" of A.\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> randsubseq(rng, 1:8, 0.3)\n2-element Vector{Int64}:\n 7\n 8\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randsubseq!","location":"stdlib/Random.html#Random.randsubseq!","category":"function","text":"randsubseq!([rng=GLOBAL_RNG,] S, A, p)\n\nLike randsubseq, but the results are stored in S (which is resized as needed).\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> S = Int64[];\n\njulia> randsubseq!(rng, S, 1:8, 0.3)\n2-element Vector{Int64}:\n 7\n 8\n\njulia> S\n2-element Vector{Int64}:\n 7\n 8\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randperm","location":"stdlib/Random.html#Random.randperm","category":"function","text":"randperm([rng=GLOBAL_RNG,] n::Integer)\n\nConstruct a random permutation of length n. The optional rng argument specifies a random number generator (see Random Numbers). The element type of the result is the same as the type of n.\n\nTo randomly permute an arbitrary vector, see shuffle or shuffle!.\n\ncompat: Julia 1.1\nIn Julia 1.1 randperm returns a vector v with eltype(v) == typeof(n) while in Julia 1.0 eltype(v) == Int.\n\nExamples\n\njulia> randperm(MersenneTwister(1234), 4)\n4-element Vector{Int64}:\n 2\n 1\n 4\n 3\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randperm!","location":"stdlib/Random.html#Random.randperm!","category":"function","text":"randperm!([rng=GLOBAL_RNG,] A::Array{<:Integer})\n\nConstruct in A a random permutation of length length(A). The optional rng argument specifies a random number generator (see Random Numbers). To randomly permute an arbitrary vector, see shuffle or shuffle!.\n\nExamples\n\njulia> randperm!(MersenneTwister(1234), Vector{Int}(undef, 4))\n4-element Vector{Int64}:\n 2\n 1\n 4\n 3\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randcycle","location":"stdlib/Random.html#Random.randcycle","category":"function","text":"randcycle([rng=GLOBAL_RNG,] n::Integer)\n\nConstruct a random cyclic permutation of length n. The optional rng argument specifies a random number generator, see Random Numbers. The element type of the result is the same as the type of n.\n\ncompat: Julia 1.1\nIn Julia 1.1 randcycle returns a vector v with eltype(v) == typeof(n) while in Julia 1.0 eltype(v) == Int.\n\nExamples\n\njulia> randcycle(MersenneTwister(1234), 6)\n6-element Vector{Int64}:\n 3\n 5\n 4\n 6\n 1\n 2\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randcycle!","location":"stdlib/Random.html#Random.randcycle!","category":"function","text":"randcycle!([rng=GLOBAL_RNG,] A::Array{<:Integer})\n\nConstruct in A a random cyclic permutation of length length(A). The optional rng argument specifies a random number generator, see Random Numbers.\n\nExamples\n\njulia> randcycle!(MersenneTwister(1234), Vector{Int}(undef, 6))\n6-element Vector{Int64}:\n 3\n 5\n 4\n 6\n 1\n 2\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.shuffle","location":"stdlib/Random.html#Random.shuffle","category":"function","text":"shuffle([rng=GLOBAL_RNG,] v::AbstractArray)\n\nReturn a randomly permuted copy of v. The optional rng argument specifies a random number generator (see Random Numbers). To permute v in-place, see shuffle!. To obtain randomly permuted indices, see randperm.\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> shuffle(rng, Vector(1:10))\n10-element Vector{Int64}:\n  6\n  1\n 10\n  2\n  3\n  9\n  5\n  7\n  4\n  8\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.shuffle!","location":"stdlib/Random.html#Random.shuffle!","category":"function","text":"shuffle!([rng=GLOBAL_RNG,] v::AbstractArray)\n\nIn-place version of shuffle: randomly permute v in-place, optionally supplying the random-number generator rng.\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> shuffle!(rng, Vector(1:16))\n16-element Vector{Int64}:\n  2\n 15\n  5\n 14\n  1\n  9\n 10\n  6\n 11\n  3\n 16\n  7\n  4\n 12\n  8\n 13\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Generators (creation and seeding)","location":"stdlib/Random.html#Generators-(creation-and-seeding)","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.seed!\nRandom.AbstractRNG\nRandom.MersenneTwister\nRandom.RandomDevice","page":"Random Numbers"},{"title":"Random.seed!","location":"stdlib/Random.html#Random.seed!","category":"function","text":"seed!([rng=GLOBAL_RNG], seed) -> rng\nseed!([rng=GLOBAL_RNG]) -> rng\n\nReseed the random number generator: rng will give a reproducible sequence of numbers if and only if a seed is provided. Some RNGs don't accept a seed, like RandomDevice. After the call to seed!, rng is equivalent to a newly created object initialized with the same seed.\n\nIf rng is not specified, it defaults to seeding the state of the shared thread-local generator.\n\nExamples\n\njulia> Random.seed!(1234);\n\njulia> x1 = rand(2)\n2-element Array{Float64,1}:\n 0.590845\n 0.766797\n\njulia> Random.seed!(1234);\n\njulia> x2 = rand(2)\n2-element Array{Float64,1}:\n 0.590845\n 0.766797\n\njulia> x1 == x2\ntrue\n\njulia> rng = MersenneTwister(1234); rand(rng, 2) == x1\ntrue\n\njulia> MersenneTwister(1) == Random.seed!(rng, 1)\ntrue\n\njulia> rand(Random.seed!(rng), Bool) # not reproducible\ntrue\n\njulia> rand(Random.seed!(rng), Bool)\nfalse\n\njulia> rand(MersenneTwister(), Bool) # not reproducible either\ntrue\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.AbstractRNG","location":"stdlib/Random.html#Random.AbstractRNG","category":"type","text":"AbstractRNG\n\nSupertype for random number generators such as MersenneTwister and RandomDevice.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.MersenneTwister","location":"stdlib/Random.html#Random.MersenneTwister","category":"type","text":"MersenneTwister(seed)\nMersenneTwister()\n\nCreate a MersenneTwister RNG object. Different RNG objects can have their own seeds, which may be useful for generating different streams of random numbers. The seed may be a non-negative integer or a vector of UInt32 integers. If no seed is provided, a randomly generated one is created (using entropy from the system). See the seed! function for reseeding an already existing MersenneTwister object.\n\nExamples\n\njulia> rng = MersenneTwister(1234);\n\njulia> x1 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.5908446386657102\n 0.7667970365022592\n\njulia> rng = MersenneTwister(1234);\n\njulia> x2 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.5908446386657102\n 0.7667970365022592\n\njulia> x1 == x2\ntrue\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.RandomDevice","location":"stdlib/Random.html#Random.RandomDevice","category":"type","text":"RandomDevice()\n\nCreate a RandomDevice RNG object. Two such objects will always generate different streams of random numbers. The entropy is obtained from the operating system.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Hooking into the Random API","location":"stdlib/Random.html#Hooking-into-the-Random-API","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"There are two mostly orthogonal ways to extend Random functionalities:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"generating random values of custom types\ncreating new generators","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The API for 1) is quite functional, but is relatively recent so it may still have to evolve in subsequent releases of the Random module. For example, it's typically sufficient to implement one rand method in order to have all other usual methods work automatically.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The API for 2) is still rudimentary, and may require more work than strictly necessary from the implementor, in order to support usual types of generated values.","page":"Random Numbers"},{"title":"Generating random values of custom types","location":"stdlib/Random.html#Generating-random-values-of-custom-types","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Generating random values for some distributions may involve various trade-offs. Pre-computed values, such as an alias table for discrete distributions, or “squeezing” functions for univariate distributions, can speed up sampling considerably. How much information should be pre-computed can depend on the number of values we plan to draw from a distribution. Also, some random number generators can have certain properties that various algorithms may want to exploit.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The Random module defines a customizable framework for obtaining random values that can address these issues. Each invocation of rand generates a sampler which can be customized with the above trade-offs in mind, by adding methods to Sampler, which in turn can dispatch on the random number generator, the object that characterizes the distribution, and a suggestion for the number of repetitions. Currently, for the latter, Val{1} (for a single sample) and Val{Inf} (for an arbitrary number) are used, with Random.Repetition an alias for both.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The object returned by Sampler is then used to generate the random values. When implementing the random generation interface for a value X that can be sampled from, the implementor should define the method","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"rand(rng, sampler)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"for the particular sampler returned by Sampler(rng, X, repetition).","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Samplers can be arbitrary values that implement rand(rng, sampler), but for most applications the following predefined samplers may be sufficient:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"SamplerType{T}() can be used for implementing samplers that draw from type T (e.g. rand(Int)). This is the default returned by Sampler for types.\nSamplerTrivial(self) is a simple wrapper for self, which can be accessed with []. This is the recommended sampler when no pre-computed information is needed (e.g. rand(1:3)), and is the default returned by Sampler for values.\nSamplerSimple(self, data) also contains the additional data field, which can be used to store arbitrary pre-computed values, which should be computed in a custom method of Sampler.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"We provide examples for each of these. We assume here that the choice of algorithm is independent of the RNG, so we use AbstractRNG in our signatures.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.Sampler\nRandom.SamplerType\nRandom.SamplerTrivial\nRandom.SamplerSimple","page":"Random Numbers"},{"title":"Random.Sampler","location":"stdlib/Random.html#Random.Sampler","category":"type","text":"Sampler(rng, x, repetition = Val(Inf))\n\nReturn a sampler object that can be used to generate random values from rng for x.\n\nWhen sp = Sampler(rng, x, repetition), rand(rng, sp) will be used to draw random values, and should be defined accordingly.\n\nrepetition can be Val(1) or Val(Inf), and should be used as a suggestion for deciding the amount of precomputation, if applicable.\n\nRandom.SamplerType and Random.SamplerTrivial are default fallbacks for types and values, respectively. Random.SamplerSimple can be used to store pre-computed values without defining extra types for only this purpose.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.SamplerType","location":"stdlib/Random.html#Random.SamplerType","category":"type","text":"SamplerType{T}()\n\nA sampler for types, containing no other information. The default fallback for Sampler when called with types.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.SamplerTrivial","location":"stdlib/Random.html#Random.SamplerTrivial","category":"type","text":"SamplerTrivial(x)\n\nCreate a sampler that just wraps the given value x. This is the default fall-back for values. The eltype of this sampler is equal to eltype(x).\n\nThe recommended use case is sampling from values without precomputed data.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.SamplerSimple","location":"stdlib/Random.html#Random.SamplerSimple","category":"type","text":"SamplerSimple(x, data)\n\nCreate a sampler that wraps the given value x and the data. The eltype of this sampler is equal to eltype(x).\n\nThe recommended use case is sampling from values with precomputed data.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Decoupling pre-computation from actually generating the values is part of the API, and is also available to the user. As an example, assume that rand(rng, 1:20) has to be called repeatedly in a loop: the way to take advantage of this decoupling is as follows:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"rng = MersenneTwister()\nsp = Random.Sampler(rng, 1:20) # or Random.Sampler(MersenneTwister, 1:20)\nfor x in X\n    n = rand(rng, sp) # similar to n = rand(rng, 1:20)\n    # use n\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"This is the mechanism that is also used in the standard library, e.g. by the default implementation of random array generation (like in rand(1:20, 10)).","page":"Random Numbers"},{"title":"Generating values from a type","location":"stdlib/Random.html#Generating-values-from-a-type","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Given a type T, it's currently assumed that if rand(T) is defined, an object of type T will be produced. SamplerType is the default sampler for types. In order to define random generation of values of type T, the rand(rng::AbstractRNG, ::Random.SamplerType{T}) method should be defined, and should return values what rand(rng, T) is expected to return.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Let's take the following example: we implement a Die type, with a variable number n of sides, numbered from 1 to n. We want rand(Die) to produce a Die with a random number of up to 20 sides (and at least 4):","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"struct Die\n    nsides::Int # number of sides\nend\n\nRandom.rand(rng::AbstractRNG, ::Random.SamplerType{Die}) = Die(rand(rng, 4:20))\n\n# output\n","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Scalar and array methods for Die now work as expected:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"julia> rand(Die)\nDie(15)\n\njulia> rand(MersenneTwister(0), Die)\nDie(11)\n\njulia> rand(Die, 3)\n3-element Vector{Die}:\n Die(18)\n Die(5)\n Die(4)\n\njulia> a = Vector{Die}(undef, 3); rand!(a)\n3-element Vector{Die}:\n Die(5)\n Die(20)\n Die(15)","page":"Random Numbers"},{"title":"A simple sampler without pre-computed data","location":"stdlib/Random.html#A-simple-sampler-without-pre-computed-data","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Here we define a sampler for a collection. If no pre-computed data is required, it can be implemented with a SamplerTrivial sampler, which is in fact the default fallback for values.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"In order to define random generation out of objects of type S, the following method should be defined: rand(rng::AbstractRNG, sp::Random.SamplerTrivial{S}). Here, sp simply wraps an object of type S, which can be accessed via sp[]. Continuing the Die example, we want now to define rand(d::Die) to produce an Int corresponding to one of d's sides:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"julia> Random.rand(rng::AbstractRNG, d::Random.SamplerTrivial{Die}) = rand(rng, 1:d[].nsides);\n\njulia> rand(Die(4))\n3\n\njulia> rand(Die(4), 3)\n3-element Vector{Any}:\n 4\n 1\n 1","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Given a collection type S, it's currently assumed that if rand(::S) is defined, an object of type eltype(S) will be produced. In the last example, a Vector{Any} is produced; the reason is that eltype(Die) == Any. The remedy is to define Base.eltype(::Type{Die}) = Int.","page":"Random Numbers"},{"title":"Generating values for an AbstractFloat type","location":"stdlib/Random.html#Generating-values-for-an-AbstractFloat-type","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"AbstractFloat types are special-cased, because by default random values are not produced in the whole type domain, but rather in [0,1). The following method should be implemented for T <: AbstractFloat: Random.rand(::AbstractRNG, ::Random.SamplerTrivial{Random.CloseOpen01{T}})","page":"Random Numbers"},{"title":"An optimized sampler with pre-computed data","location":"stdlib/Random.html#An-optimized-sampler-with-pre-computed-data","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Consider a discrete distribution, where numbers 1:n are drawn with given probabilities that sum to one. When many values are needed from this distribution, the fastest method is using an alias table. We don't provide the algorithm for building such a table here, but suppose it is available in make_alias_table(probabilities) instead, and draw_number(rng, alias_table) can be used to draw a random number from it.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Suppose that the distribution is described by","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"struct DiscreteDistribution{V <: AbstractVector}\n    probabilities::V\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"and that we always want to build an alias table, regardless of the number of values needed (we learn how to customize this below). The methods","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.eltype(::Type{<:DiscreteDistribution}) = Int\n\nfunction Random.Sampler(::Type{<:AbstractRNG}, distribution::DiscreteDistribution, ::Repetition)\n    SamplerSimple(disribution, make_alias_table(distribution.probabilities))\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"should be defined to return a sampler with pre-computed data, then","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"function rand(rng::AbstractRNG, sp::SamplerSimple{<:DiscreteDistribution})\n    draw_number(rng, sp.data)\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"will be used to draw the values.","page":"Random Numbers"},{"title":"Custom sampler types","location":"stdlib/Random.html#Custom-sampler-types","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The SamplerSimple type is sufficient for most use cases with precomputed data. However, in order to demonstrate how to use custom sampler types, here we implement something similar to SamplerSimple.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Going back to our Die example: rand(::Die) uses random generation from a range, so there is an opportunity for this optimization. We call our custom sampler SamplerDie.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"import Random: Sampler, rand\n\nstruct SamplerDie <: Sampler{Int} # generates values of type Int\n    die::Die\n    sp::Sampler{Int} # this is an abstract type, so this could be improved\nend\n\nSampler(RNG::Type{<:AbstractRNG}, die::Die, r::Random.Repetition) =\n    SamplerDie(die, Sampler(RNG, 1:die.nsides, r))\n# the `r` parameter will be explained later on\n\nrand(rng::AbstractRNG, sp::SamplerDie) = rand(rng, sp.sp)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"It's now possible to get a sampler with sp = Sampler(rng, die), and use sp instead of die in any rand call involving rng. In the simplistic example above, die doesn't need to be stored in SamplerDie but this is often the case in practice.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Of course, this pattern is so frequent that the helper type used above, namely Random.SamplerSimple, is available, saving us the definition of SamplerDie: we could have implemented our decoupling with:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Sampler(RNG::Type{<:AbstractRNG}, die::Die, r::Random.Repetition) =\n    SamplerSimple(die, Sampler(RNG, 1:die.nsides, r))\n\nrand(rng::AbstractRNG, sp::SamplerSimple{Die}) = rand(rng, sp.data)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Here, sp.data refers to the second parameter in the call to the SamplerSimple constructor (in this case equal to Sampler(rng, 1:die.nsides, r)), while the Die object can be accessed via sp[].","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Like SamplerDie, any custom sampler must be a subtype of Sampler{T} where T is the type of the generated values. Note that SamplerSimple(x, data) isa Sampler{eltype(x)}, so this constrains what the first argument to SamplerSimple can be (it's recommended to use SamplerSimple like in the Die example, where x is simply forwarded while defining a Sampler method). Similarly, SamplerTrivial(x) isa Sampler{eltype(x)}.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Another helper type is currently available for other cases, Random.SamplerTag, but is considered as internal API, and can break at any time without proper deprecations.","page":"Random Numbers"},{"title":"Using distinct algorithms for scalar or array generation","location":"stdlib/Random.html#Using-distinct-algorithms-for-scalar-or-array-generation","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"In some cases, whether one wants to generate only a handful of values or a large number of values will have an impact on the choice of algorithm. This is handled with the third parameter of the Sampler constructor. Let's assume we defined two helper types for Die, say SamplerDie1 which should be used to generate only few random values, and SamplerDieMany for many values. We can use those types as follows:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Sampler(RNG::Type{<:AbstractRNG}, die::Die, ::Val{1}) = SamplerDie1(...)\nSampler(RNG::Type{<:AbstractRNG}, die::Die, ::Val{Inf}) = SamplerDieMany(...)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Of course, rand must also be defined on those types (i.e. rand(::AbstractRNG, ::SamplerDie1) and rand(::AbstractRNG, ::SamplerDieMany)). Note that, as usual, SamplerTrivial and SamplerSimple can be used if custom types are not necessary.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Note: Sampler(rng, x) is simply a shorthand for Sampler(rng, x, Val(Inf)), and Random.Repetition is an alias for Union{Val{1}, Val{Inf}}.","page":"Random Numbers"},{"title":"Creating new generators","location":"stdlib/Random.html#Creating-new-generators","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The API is not clearly defined yet, but as a rule of thumb:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"any rand method producing \"basic\" types (isbitstype integer and floating types in Base) should be defined for this specific RNG, if they are needed;\nother documented rand methods accepting an AbstractRNG should work out of the box, (provided the methods from 1) what are relied on are implemented), but can of course be specialized for this RNG if there is room for optimization;\ncopy for pseudo-RNGs should return an independent copy that generates the exact same random sequence as the original from that point when called in the same way. When this is not feasible (e.g. hardware-based RNGs), copy must not be implemented.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Concerning 1), a rand method may happen to work automatically, but it's not officially supported and may break without warnings in a subsequent release.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"To define a new rand method for an hypothetical MyRNG generator, and a value specification s (e.g. s == Int, or s == 1:10) of type S==typeof(s) or S==Type{s} if s is a type, the same two methods as we saw before must be defined:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Sampler(::Type{MyRNG}, ::S, ::Repetition), which returns an object of type say SamplerS\nrand(rng::MyRNG, sp::SamplerS)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"It can happen that Sampler(rng::AbstractRNG, ::S, ::Repetition) is already defined in the Random module. It would then be possible to skip step 1) in practice (if one wants to specialize generation for this particular RNG type), but the corresponding SamplerS type is considered as internal detail, and may be changed without warning.","page":"Random Numbers"},{"title":"Specializing array generation","location":"stdlib/Random.html#Specializing-array-generation","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"In some cases, for a given RNG type, generating an array of random values can be more efficient with a specialized method than by merely using the decoupling technique explained before. This is for example the case for MersenneTwister, which natively writes random values in an array.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"To implement this specialization for MyRNG and for a specification s, producing elements of type S, the following method can be defined: rand!(rng::MyRNG, a::AbstractArray{S}, ::SamplerS), where SamplerS is the type of the sampler returned by Sampler(MyRNG, s, Val(Inf)). Instead of AbstractArray, it's possible to implement the functionality only for a subtype, e.g. Array{S}. The non-mutating array method of rand will automatically call this specialization internally.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"DocTestSetup = nothing","page":"Random Numbers"},{"title":"Reproducibility","location":"stdlib/Random.html#Reproducibility","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"By using an RNG parameter initialized with a given seed, you can reproduce the same pseudorandom number sequence when running your program multiple times. However, a minor release of Julia (e.g. 1.3 to 1.4) may change the sequence of pseudorandom numbers generated from a specific seed, in particular if MersenneTwister is used. (Even if the sequence produced by a low-level function like rand does not change, the output of higher-level functions like randsubseq may change due to algorithm updates.) Rationale: guaranteeing that pseudorandom streams never change prohibits many algorithmic improvements.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"If you need to guarantee exact reproducibility of random data, it is advisable to simply save the data (e.g. as a supplementary attachment in a scientific publication). (You can also, of course, specify a particular Julia version and package manifest, especially if you require bit reproducibility.)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Software tests that rely on specific \"random\" data should also generally either save the data, embed it into the test code, or use third-party packages like StableRNGs.jl. On the other hand, tests that should pass for most random data (e.g. testing A \\ (A*x) ≈ x for a random matrix A = randn(n,n)) can use an RNG with a fixed seed to ensure that simply running the test many times does not encounter a failure due to very improbable data (e.g. an extremely ill-conditioned matrix).","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The statistical distribution from which random samples are drawn is guaranteed to be the same across any minor Julia releases.","page":"Random Numbers"},{"title":"Arrays","location":"base/arrays.html#lib-arrays","category":"section","text":"","page":"Arrays"},{"title":"Constructors and Types","location":"base/arrays.html#Constructors-and-Types","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Core.AbstractArray\nBase.AbstractVector\nBase.AbstractMatrix\nBase.AbstractVecOrMat\nCore.Array\nCore.Array(::UndefInitializer, ::Any)\nCore.Array(::Nothing, ::Any)\nCore.Array(::Missing, ::Any)\nCore.UndefInitializer\nCore.undef\nBase.Vector\nBase.Vector(::UndefInitializer, ::Any)\nBase.Vector(::Nothing, ::Any)\nBase.Vector(::Missing, ::Any)\nBase.Matrix\nBase.Matrix(::UndefInitializer, ::Any, ::Any)\nBase.Matrix(::Nothing, ::Any, ::Any)\nBase.Matrix(::Missing, ::Any, ::Any)\nBase.VecOrMat\nCore.DenseArray\nBase.DenseVector\nBase.DenseMatrix\nBase.DenseVecOrMat\nBase.StridedArray\nBase.StridedVector\nBase.StridedMatrix\nBase.StridedVecOrMat\nBase.getindex(::Type, ::Any...)\nBase.zeros\nBase.ones\nBase.BitArray\nBase.BitArray(::UndefInitializer, ::Integer...)\nBase.BitArray(::Any)\nBase.trues\nBase.falses\nBase.fill\nBase.fill!\nBase.similar","page":"Arrays"},{"title":"Core.AbstractArray","location":"base/arrays.html#Core.AbstractArray","category":"type","text":"AbstractArray{T,N}\n\nSupertype for N-dimensional arrays (or array-like types) with elements of type T. Array and other types are subtypes of this. See the manual section on the AbstractArray interface.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.AbstractVector","location":"base/arrays.html#Base.AbstractVector","category":"type","text":"AbstractVector{T}\n\nSupertype for one-dimensional arrays (or array-like types) with elements of type T. Alias for AbstractArray{T,1}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.AbstractMatrix","location":"base/arrays.html#Base.AbstractMatrix","category":"type","text":"AbstractMatrix{T}\n\nSupertype for two-dimensional arrays (or array-like types) with elements of type T. Alias for AbstractArray{T,2}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.AbstractVecOrMat","location":"base/arrays.html#Base.AbstractVecOrMat","category":"type","text":"AbstractVecOrMat{T}\n\nUnion type of AbstractVector{T} and AbstractMatrix{T}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array","category":"type","text":"Array{T,N} <: AbstractArray{T,N}\n\nN-dimensional dense array with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array-Tuple{UndefInitializer, Any}","category":"method","text":"Array{T}(undef, dims)\nArray{T,N}(undef, dims)\n\nConstruct an uninitialized N-dimensional Array containing elements of type T. N can either be supplied explicitly, as in Array{T,N}(undef, dims), or be determined by the length or number of dims. dims may be a tuple or a series of integer arguments corresponding to the lengths in each dimension. If the rank N is supplied explicitly, then it must match the length or number of dims. See undef.\n\nExamples\n\njulia> A = Array{Float64, 2}(undef, 2, 3) # N given explicitly\n2×3 Array{Float64, 2}:\n 6.90198e-310  6.90198e-310  6.90198e-310\n 6.90198e-310  6.90198e-310  0.0\n\njulia> B = Array{Float64}(undef, 2) # N determined by the input\n2-element Array{Float64, 1}:\n 1.87103e-320\n 0.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array-Tuple{Nothing, Any}","category":"method","text":"Array{T}(nothing, dims)\nArray{T,N}(nothing, dims)\n\nConstruct an N-dimensional Array containing elements of type T, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Array{Union{Nothing, String}}(nothing, 2)\n2-element Vector{Union{Nothing, String}}:\n nothing\n nothing\n\njulia> Array{Union{Nothing, Int}}(nothing, 2, 3)\n2×3 Matrix{Union{Nothing, Int64}}:\n nothing  nothing  nothing\n nothing  nothing  nothing\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array-Tuple{Missing, Any}","category":"method","text":"Array{T}(missing, dims)\nArray{T,N}(missing, dims)\n\nConstruct an N-dimensional Array containing elements of type T, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Array{Union{Missing, String}}(missing, 2)\n2-element Vector{Union{Missing, String}}:\n missing\n missing\n\njulia> Array{Union{Missing, Int}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, Int64}}:\n missing  missing  missing\n missing  missing  missing\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.UndefInitializer","location":"base/arrays.html#Core.UndefInitializer","category":"type","text":"UndefInitializer\n\nSingleton type used in array initialization, indicating the array-constructor-caller would like an uninitialized array. See also undef, an alias for UndefInitializer().\n\nExamples\n\njulia> Array{Float64, 1}(UndefInitializer(), 3)\n3-element Array{Float64, 1}:\n 2.2752528595e-314\n 2.202942107e-314\n 2.275252907e-314\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.undef","location":"base/arrays.html#Core.undef","category":"constant","text":"undef\n\nAlias for UndefInitializer(), which constructs an instance of the singleton type UndefInitializer, used in array initialization to indicate the array-constructor-caller would like an uninitialized array.\n\nExamples\n\njulia> Array{Float64, 1}(undef, 3)\n3-element Array{Float64, 1}:\n 2.2752528595e-314\n 2.202942107e-314\n 2.275252907e-314\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector","category":"type","text":"Vector{T} <: AbstractVector{T}\n\nOne-dimensional dense array with elements of type T, often used to represent a mathematical vector. Alias for Array{T,1}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector-Tuple{UndefInitializer, Any}","category":"method","text":"Vector{T}(undef, n)\n\nConstruct an uninitialized Vector{T} of length n. See undef.\n\nExamples\n\njulia> Vector{Float64}(undef, 3)\n3-element Array{Float64, 1}:\n 6.90966e-310\n 6.90966e-310\n 6.90966e-310\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector-Tuple{Nothing, Any}","category":"method","text":"Vector{T}(nothing, m)\n\nConstruct a Vector{T} of length m, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Vector{Union{Nothing, String}}(nothing, 2)\n2-element Vector{Union{Nothing, String}}:\n nothing\n nothing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector-Tuple{Missing, Any}","category":"method","text":"Vector{T}(missing, m)\n\nConstruct a Vector{T} of length m, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Vector{Union{Missing, String}}(missing, 2)\n2-element Vector{Union{Missing, String}}:\n missing\n missing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix","category":"type","text":"Matrix{T} <: AbstractMatrix{T}\n\nTwo-dimensional dense array with elements of type T, often used to represent a mathematical matrix. Alias for Array{T,2}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix-Tuple{UndefInitializer, Any, Any}","category":"method","text":"Matrix{T}(undef, m, n)\n\nConstruct an uninitialized Matrix{T} of size m×n. See undef.\n\nExamples\n\njulia> Matrix{Float64}(undef, 2, 3)\n2×3 Array{Float64, 2}:\n 6.93517e-310  6.93517e-310  6.93517e-310\n 6.93517e-310  6.93517e-310  1.29396e-320\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix-Tuple{Nothing, Any, Any}","category":"method","text":"Matrix{T}(nothing, m, n)\n\nConstruct a Matrix{T} of size m×n, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Matrix{Union{Nothing, String}}(nothing, 2, 3)\n2×3 Matrix{Union{Nothing, String}}:\n nothing  nothing  nothing\n nothing  nothing  nothing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix-Tuple{Missing, Any, Any}","category":"method","text":"Matrix{T}(missing, m, n)\n\nConstruct a Matrix{T} of size m×n, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Matrix{Union{Missing, String}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, String}}:\n missing  missing  missing\n missing  missing  missing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.VecOrMat","location":"base/arrays.html#Base.VecOrMat","category":"type","text":"VecOrMat{T}\n\nUnion type of Vector{T} and Matrix{T}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.DenseArray","location":"base/arrays.html#Core.DenseArray","category":"type","text":"DenseArray{T, N} <: AbstractArray{T,N}\n\nN-dimensional dense array with elements of type T. The elements of a dense array are stored contiguously in memory.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.DenseVector","location":"base/arrays.html#Base.DenseVector","category":"type","text":"DenseVector{T}\n\nOne-dimensional DenseArray with elements of type T. Alias for DenseArray{T,1}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.DenseMatrix","location":"base/arrays.html#Base.DenseMatrix","category":"type","text":"DenseMatrix{T}\n\nTwo-dimensional DenseArray with elements of type T. Alias for DenseArray{T,2}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.DenseVecOrMat","location":"base/arrays.html#Base.DenseVecOrMat","category":"type","text":"DenseVecOrMat{T}\n\nUnion type of DenseVector{T} and DenseMatrix{T}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedArray","location":"base/arrays.html#Base.StridedArray","category":"type","text":"StridedArray{T, N}\n\nA hard-coded Union of common array types that follow the strided array interface, with elements of type T and N dimensions.\n\nIf A is a StridedArray, then its elements are stored in memory with offsets, which may vary between dimensions but are constant within a dimension. For example, A could have stride 2 in dimension 1, and stride 3 in dimension 2. Incrementing A along dimension d jumps in memory by [strides(A, d)] slots. Strided arrays are particularly important and useful because they can sometimes be passed directly as pointers to foreign language libraries like BLAS.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedVector","location":"base/arrays.html#Base.StridedVector","category":"type","text":"StridedVector{T}\n\nOne dimensional StridedArray with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedMatrix","location":"base/arrays.html#Base.StridedMatrix","category":"type","text":"StridedMatrix{T}\n\nTwo dimensional StridedArray with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedVecOrMat","location":"base/arrays.html#Base.StridedVecOrMat","category":"type","text":"StridedVecOrMat{T}\n\nUnion type of StridedVector and StridedMatrix with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.getindex","location":"base/arrays.html#Base.getindex-Tuple{Type, Vararg{Any, N} where N}","category":"method","text":"getindex(type[, elements...])\n\nConstruct a 1-d array of the specified type. This is usually called with the syntax Type[]. Element values can be specified using Type[a,b,c,...].\n\nExamples\n\njulia> Int8[1, 2, 3]\n3-element Vector{Int8}:\n 1\n 2\n 3\n\njulia> getindex(Int8, 1, 2, 3)\n3-element Vector{Int8}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.zeros","location":"base/arrays.html#Base.zeros","category":"function","text":"zeros([T=Float64,] dims::Tuple)\nzeros([T=Float64,] dims...)\n\nCreate an Array, with element type T, of all zeros with size specified by dims. See also fill, ones.\n\nExamples\n\njulia> zeros(1)\n1-element Vector{Float64}:\n 0.0\n\njulia> zeros(Int8, 2, 3)\n2×3 Matrix{Int8}:\n 0  0  0\n 0  0  0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.ones","location":"base/arrays.html#Base.ones","category":"function","text":"ones([T=Float64,] dims::Tuple)\nones([T=Float64,] dims...)\n\nCreate an Array, with element type T, of all ones with size specified by dims. See also: fill, zeros.\n\nExamples\n\njulia> ones(1,2)\n1×2 Matrix{Float64}:\n 1.0  1.0\n\njulia> ones(ComplexF64, 2, 3)\n2×3 Matrix{ComplexF64}:\n 1.0+0.0im  1.0+0.0im  1.0+0.0im\n 1.0+0.0im  1.0+0.0im  1.0+0.0im\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.BitArray","location":"base/arrays.html#Base.BitArray","category":"type","text":"BitArray{N} <: AbstractArray{Bool, N}\n\nSpace-efficient N-dimensional boolean array, using just one bit for each boolean value.\n\nBitArrays pack up to 64 values into every 8 bytes, resulting in an 8x space efficiency over Array{Bool, N} and allowing some operations to work on 64 values at once.\n\nBy default, Julia returns BitArrays from broadcasting operations that generate boolean elements (including dotted-comparisons like .==) as well as from the functions trues and falses.\n\nnote: Note\nDue to its packed storage format, concurrent access to the elements of a BitArray where at least one of them is a write is not thread safe.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.BitArray","location":"base/arrays.html#Base.BitArray-Tuple{UndefInitializer, Vararg{Integer, N} where N}","category":"method","text":"BitArray(undef, dims::Integer...)\nBitArray{N}(undef, dims::NTuple{N,Int})\n\nConstruct an undef BitArray with the given dimensions. Behaves identically to the Array constructor. See undef.\n\nExamples\n\njulia> BitArray(undef, 2, 2)\n2×2 BitMatrix:\n 0  0\n 0  0\n\njulia> BitArray(undef, (3, 1))\n3×1 BitMatrix:\n 0\n 0\n 0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.BitArray","location":"base/arrays.html#Base.BitArray-Tuple{Any}","category":"method","text":"BitArray(itr)\n\nConstruct a BitArray generated by the given iterable object. The shape is inferred from the itr object.\n\nExamples\n\njulia> BitArray([1 0; 0 1])\n2×2 BitMatrix:\n 1  0\n 0  1\n\njulia> BitArray(x+y == 3 for x = 1:2, y = 1:3)\n2×3 BitMatrix:\n 0  1  0\n 1  0  0\n\njulia> BitArray(x+y == 3 for x = 1:2 for y = 1:3)\n6-element BitVector:\n 0\n 1\n 0\n 1\n 0\n 0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.trues","location":"base/arrays.html#Base.trues","category":"function","text":"trues(dims)\n\nCreate a BitArray with all values set to true.\n\nExamples\n\njulia> trues(2,3)\n2×3 BitMatrix:\n 1  1  1\n 1  1  1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.falses","location":"base/arrays.html#Base.falses","category":"function","text":"falses(dims)\n\nCreate a BitArray with all values set to false.\n\nExamples\n\njulia> falses(2,3)\n2×3 BitMatrix:\n 0  0  0\n 0  0  0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.fill","location":"base/arrays.html#Base.fill","category":"function","text":"fill(x, dims::Tuple)\nfill(x, dims...)\n\nCreate an array filled with the value x. For example, fill(1.0, (5,5)) returns a 5×5 array of floats, with each element initialized to 1.0.\n\ndims may be specified as either a tuple or a sequence of arguments. For example, the common idiom fill(x) creates a zero-dimensional array containing the single value x.\n\nExamples\n\njulia> fill(1.0, (2,3))\n2×3 Matrix{Float64}:\n 1.0  1.0  1.0\n 1.0  1.0  1.0\n\njulia> fill(42)\n0-dimensional Array{Int64, 0}:\n42\n\nIf x is an object reference, all elements will refer to the same object:\n\njulia> A = fill(zeros(2), 2);\n\njulia> A[1][1] = 42; # modifies both A[1][1] and A[2][1]\n\njulia> A\n2-element Vector{Vector{Float64}}:\n [42.0, 0.0]\n [42.0, 0.0]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.fill!","location":"base/arrays.html#Base.fill!","category":"function","text":"fill!(A, x)\n\nFill array A with the value x. If x is an object reference, all elements will refer to the same object. fill!(A, Foo()) will return A filled with the result of evaluating Foo() once.\n\nExamples\n\njulia> A = zeros(2,3)\n2×3 Matrix{Float64}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n\njulia> fill!(A, 2.)\n2×3 Matrix{Float64}:\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n\njulia> a = [1, 1, 1]; A = fill!(Vector{Vector{Int}}(undef, 3), a); a[1] = 2; A\n3-element Vector{Vector{Int64}}:\n [2, 1, 1]\n [2, 1, 1]\n [2, 1, 1]\n\njulia> x = 0; f() = (global x += 1; x); fill!(Vector{Int}(undef, 3), f())\n3-element Vector{Int64}:\n 1\n 1\n 1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.similar","location":"base/arrays.html#Base.similar","category":"function","text":"similar(array, [element_type=eltype(array)], [dims=size(array)])\n\nCreate an uninitialized mutable array with the given element type and size, based upon the given source array. The second and third arguments are both optional, defaulting to the given array's eltype and size. The dimensions may be specified either as a single tuple argument or as a series of integer arguments.\n\nCustom AbstractArray subtypes may choose which specific array type is best-suited to return for the given element type and dimensionality. If they do not specialize this method, the default is an Array{element_type}(undef, dims...).\n\nFor example, similar(1:10, 1, 4) returns an uninitialized Array{Int,2} since ranges are neither mutable nor support 2 dimensions:\n\njulia> similar(1:10, 1, 4)\n1×4 Array{Int64,2}:\n 4419743872  4374413872  4419743888  0\n\nConversely, similar(trues(10,10), 2) returns an uninitialized BitVector with two elements since BitArrays are both mutable and can support 1-dimensional arrays:\n\njulia> similar(trues(10,10), 2)\n2-element BitVector:\n 0\n 0\n\nSince BitArrays can only store elements of type Bool, however, if you request a different element type it will create a regular Array instead:\n\njulia> similar(falses(10), Float64, 2, 4)\n2×4 Array{Float64,2}:\n 2.18425e-314  2.18425e-314  2.18425e-314  2.18425e-314\n 2.18425e-314  2.18425e-314  2.18425e-314  2.18425e-314\n\n\n\n\n\nsimilar(storagetype, axes)\n\nCreate an uninitialized mutable array analogous to that specified by storagetype, but with axes specified by the last argument.\n\nExamples:\n\nsimilar(Array{Int}, axes(A))\n\ncreates an array that \"acts like\" an Array{Int} (and might indeed be backed by one), but which is indexed identically to A. If A has conventional indexing, this will be identical to Array{Int}(undef, size(A)), but if A has unconventional indexing then the indices of the result will match A.\n\nsimilar(BitArray, (axes(A, 2),))\n\nwould create a 1-dimensional logical array whose indices match those of the columns of A.\n\n\n\n\n\n","page":"Arrays"},{"title":"Basic functions","location":"base/arrays.html#Basic-functions","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.ndims\nBase.size\nBase.axes(::Any)\nBase.axes(::AbstractArray, ::Any)\nBase.length(::AbstractArray)\nBase.eachindex\nBase.IndexStyle\nBase.IndexLinear\nBase.IndexCartesian\nBase.conj!\nBase.stride\nBase.strides","page":"Arrays"},{"title":"Base.ndims","location":"base/arrays.html#Base.ndims","category":"function","text":"ndims(A::AbstractArray) -> Integer\n\nReturn the number of dimensions of A.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> ndims(A)\n3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.size","location":"base/arrays.html#Base.size","category":"function","text":"size(A::AbstractArray, [dim])\n\nReturn a tuple containing the dimensions of A. Optionally you can specify a dimension to just get the length of that dimension.\n\nNote that size may not be defined for arrays with non-standard indices, in which case axes may be useful. See the manual chapter on arrays with custom indices.\n\nExamples\n\njulia> A = fill(1, (2,3,4));\n\njulia> size(A)\n(2, 3, 4)\n\njulia> size(A, 2)\n3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.axes","location":"base/arrays.html#Base.axes-Tuple{Any}","category":"method","text":"axes(A)\n\nReturn the tuple of valid indices for array A.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> axes(A)\n(Base.OneTo(5), Base.OneTo(6), Base.OneTo(7))\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.axes","location":"base/arrays.html#Base.axes-Tuple{AbstractArray, Any}","category":"method","text":"axes(A, d)\n\nReturn the valid range of indices for array A along dimension d.\n\nSee also size, and the manual chapter on arrays with custom indices.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> axes(A, 2)\nBase.OneTo(6)\n\nUsage note\n\nEach of the indices has to be an AbstractUnitRange{<:Integer}, but at the same time can be a type that uses custom indices. So, for example, if you need a subset, use generalized indexing constructs like begin/end or firstindex/lastindex:\n\nix = axes(v, 1)\nix[2:end]          # will work for eg Vector, but may fail in general\nix[(begin+1):end]  # works for generalized indexes\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.length","location":"base/arrays.html#Base.length-Tuple{AbstractArray}","category":"method","text":"length(A::AbstractArray)\n\nReturn the number of elements in the array, defaults to prod(size(A)).\n\nExamples\n\njulia> length([1, 2, 3, 4])\n4\n\njulia> length([1 2; 3 4])\n4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachindex","location":"base/arrays.html#Base.eachindex","category":"function","text":"eachindex(A...)\n\nCreate an iterable object for visiting each index of an AbstractArray A in an efficient manner. For array types that have opted into fast linear indexing (like Array), this is simply the range 1:length(A). For other array types, return a specialized Cartesian range to efficiently index into the array with indices specified for every dimension. For other iterables, including strings and dictionaries, return an iterator object supporting arbitrary index types (e.g. unevenly spaced or non-integer indices).\n\nIf you supply more than one AbstractArray argument, eachindex will create an iterable object that is fast for all arguments (a UnitRange if all inputs have fast linear indexing, a CartesianIndices otherwise). If the arrays have different sizes and/or dimensionalities, a DimensionMismatch exception will be thrown.\n\nExamples\n\njulia> A = [1 2; 3 4];\n\njulia> for i in eachindex(A) # linear indexing\n           println(i)\n       end\n1\n2\n3\n4\n\njulia> for i in eachindex(view(A, 1:2, 1:1)) # Cartesian indexing\n           println(i)\n       end\nCartesianIndex(1, 1)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IndexStyle","location":"base/arrays.html#Base.IndexStyle","category":"type","text":"IndexStyle(A)\nIndexStyle(typeof(A))\n\nIndexStyle specifies the \"native indexing style\" for array A. When you define a new AbstractArray type, you can choose to implement either linear indexing (with IndexLinear) or cartesian indexing. If you decide to only implement linear indexing, then you must set this trait for your array type:\n\nBase.IndexStyle(::Type{<:MyArray}) = IndexLinear()\n\nThe default is IndexCartesian().\n\nJulia's internal indexing machinery will automatically (and invisibly) recompute all indexing operations into the preferred style. This allows users to access elements of your array using any indexing style, even when explicit methods have not been provided.\n\nIf you define both styles of indexing for your AbstractArray, this trait can be used to select the most performant indexing style. Some methods check this trait on their inputs, and dispatch to different algorithms depending on the most efficient access pattern. In particular, eachindex creates an iterator whose type depends on the setting of this trait.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IndexLinear","location":"base/arrays.html#Base.IndexLinear","category":"type","text":"IndexLinear()\n\nSubtype of IndexStyle used to describe arrays which are optimally indexed by one linear index.\n\nA linear indexing style uses one integer index to describe the position in the array (even if it's a multidimensional array) and column-major ordering is used to efficiently access the elements. This means that requesting eachindex from an array that is IndexLinear will return a simple one-dimensional range, even if it is multidimensional.\n\nA custom array that reports its IndexStyle as IndexLinear only needs to implement indexing (and indexed assignment) with a single Int index; all other indexing expressions — including multidimensional accesses — will be recomputed to the linear index.  For example, if A were a 2×3 custom matrix with linear indexing, and we referenced A[1, 3], this would be recomputed to the equivalent linear index and call A[5] since 2*1 + 3 = 5.\n\nSee also IndexCartesian.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IndexCartesian","location":"base/arrays.html#Base.IndexCartesian","category":"type","text":"IndexCartesian()\n\nSubtype of IndexStyle used to describe arrays which are optimally indexed by a Cartesian index. This is the default for new custom AbstractArray subtypes.\n\nA Cartesian indexing style uses multiple integer indices to describe the position in a multidimensional array, with exactly one index per dimension. This means that requesting eachindex from an array that is IndexCartesian will return a range of CartesianIndices.\n\nA N-dimensional custom array that reports its IndexStyle as IndexCartesian needs to implement indexing (and indexed assignment) with exactly N Int indices; all other indexing expressions — including linear indexing — will be recomputed to the equivalent Cartesian location.  For example, if A were a 2×3 custom matrix with cartesian indexing, and we referenced A[5], this would be recomputed to the equivalent Cartesian index and call A[1, 3] since 5 = 2*1 + 3.\n\nIt is significantly more expensive to compute Cartesian indices from a linear index than it is to go the other way.  The former operation requires division — a very costly operation — whereas the latter only uses multiplication and addition and is essentially free. This asymmetry means it is far more costly to use linear indexing with an IndexCartesian array than it is to use Cartesian indexing with an IndexLinear array.\n\nSee also IndexLinear.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.conj!","location":"base/arrays.html#Base.conj!","category":"function","text":"conj!(A)\n\nTransform an array to its complex conjugate in-place.\n\nSee also conj.\n\nExamples\n\njulia> A = [1+im 2-im; 2+2im 3+im]\n2×2 Matrix{Complex{Int64}}:\n 1+1im  2-1im\n 2+2im  3+1im\n\njulia> conj!(A);\n\njulia> A\n2×2 Matrix{Complex{Int64}}:\n 1-1im  2+1im\n 2-2im  3-1im\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.stride","location":"base/arrays.html#Base.stride","category":"function","text":"stride(A, k::Integer)\n\nReturn the distance in memory (in number of elements) between adjacent elements in dimension k.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> stride(A,2)\n3\n\njulia> stride(A,3)\n12\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.strides","location":"base/arrays.html#Base.strides","category":"function","text":"strides(A)\n\nReturn a tuple of the memory strides in each dimension.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> strides(A)\n(1, 3, 12)\n\n\n\n\n\n","page":"Arrays"},{"title":"Broadcast and vectorization","location":"base/arrays.html#Broadcast-and-vectorization","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"See also the dot syntax for vectorizing functions; for example, f.(args...) implicitly calls broadcast(f, args...). Rather than relying on \"vectorized\" methods of functions like sin to operate on arrays, you should use sin.(a) to vectorize via broadcast.","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.broadcast\nBase.Broadcast.broadcast!\nBase.@__dot__","page":"Arrays"},{"title":"Base.Broadcast.broadcast","location":"base/arrays.html#Base.Broadcast.broadcast","category":"function","text":"broadcast(f, As...)\n\nBroadcast the function f over the arrays, tuples, collections, Refs and/or scalars As.\n\nBroadcasting applies the function f over the elements of the container arguments and the scalars themselves in As. Singleton and missing dimensions are expanded to match the extents of the other arguments by virtually repeating the value. By default, only a limited number of types are considered scalars, including Numbers, Strings, Symbols, Types, Functions and some common singletons like missing and nothing. All other arguments are iterated over or indexed into elementwise.\n\nThe resulting container type is established by the following rules:\n\nIf all the arguments are scalars or zero-dimensional arrays, it returns an unwrapped scalar.\nIf at least one argument is a tuple and all others are scalars or zero-dimensional arrays, it returns a tuple.\nAll other combinations of arguments default to returning an Array, but custom container types can define their own implementation and promotion-like rules to customize the result when they appear as arguments.\n\nA special syntax exists for broadcasting: f.(args...) is equivalent to broadcast(f, args...), and nested f.(g.(args...)) calls are fused into a single broadcast loop.\n\nExamples\n\njulia> A = [1, 2, 3, 4, 5]\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> B = [1 2; 3 4; 5 6; 7 8; 9 10]\n5×2 Matrix{Int64}:\n 1   2\n 3   4\n 5   6\n 7   8\n 9  10\n\njulia> broadcast(+, A, B)\n5×2 Matrix{Int64}:\n  2   3\n  5   6\n  8   9\n 11  12\n 14  15\n\njulia> parse.(Int, [\"1\", \"2\"])\n2-element Vector{Int64}:\n 1\n 2\n\njulia> abs.((1, -2))\n(1, 2)\n\njulia> broadcast(+, 1.0, (0, -2.0))\n(1.0, -1.0)\n\njulia> (+).([[0,2], [1,3]], Ref{Vector{Int}}([1,-1]))\n2-element Vector{Vector{Int64}}:\n [1, 1]\n [2, 2]\n\njulia> string.((\"one\",\"two\",\"three\",\"four\"), \": \", 1:4)\n4-element Vector{String}:\n \"one: 1\"\n \"two: 2\"\n \"three: 3\"\n \"four: 4\"\n\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.broadcast!","location":"base/arrays.html#Base.Broadcast.broadcast!","category":"function","text":"broadcast!(f, dest, As...)\n\nLike broadcast, but store the result of broadcast(f, As...) in the dest array. Note that dest is only used to store the result, and does not supply arguments to f unless it is also listed in the As, as in broadcast!(f, A, A, B) to perform A[:] = broadcast(f, A, B).\n\nExamples\n\njulia> A = [1.0; 0.0]; B = [0.0; 0.0];\n\njulia> broadcast!(+, B, A, (0, -2.0));\n\njulia> B\n2-element Vector{Float64}:\n  1.0\n -2.0\n\njulia> A\n2-element Vector{Float64}:\n 1.0\n 0.0\n\njulia> broadcast!(+, A, A, (0, -2.0));\n\njulia> A\n2-element Vector{Float64}:\n  1.0\n -2.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.@__dot__","location":"base/arrays.html#Base.Broadcast.@__dot__","category":"macro","text":"@. expr\n\nConvert every function call or operator in expr into a \"dot call\" (e.g. convert f(x) to f.(x)), and convert every assignment in expr to a \"dot assignment\" (e.g. convert += to .+=).\n\nIf you want to avoid adding dots for selected function calls in expr, splice those function calls in with $.  For example, @. sqrt(abs($sort(x))) is equivalent to sqrt.(abs.(sort(x))) (no dot for sort).\n\n(@. is equivalent to a call to @__dot__.)\n\nExamples\n\njulia> x = 1.0:3.0; y = similar(x);\n\njulia> @. y = x + 3 * sin(x)\n3-element Vector{Float64}:\n 3.5244129544236893\n 4.727892280477045\n 3.4233600241796016\n\n\n\n\n\n","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"For specializing broadcast on custom types, see","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.BroadcastStyle\nBase.Broadcast.AbstractArrayStyle\nBase.Broadcast.ArrayStyle\nBase.Broadcast.DefaultArrayStyle\nBase.Broadcast.broadcastable\nBase.Broadcast.combine_axes\nBase.Broadcast.combine_styles\nBase.Broadcast.result_style","page":"Arrays"},{"title":"Base.Broadcast.BroadcastStyle","location":"base/arrays.html#Base.Broadcast.BroadcastStyle","category":"type","text":"BroadcastStyle is an abstract type and trait-function used to determine behavior of objects under broadcasting. BroadcastStyle(typeof(x)) returns the style associated with x. To customize the broadcasting behavior of a type, one can declare a style by defining a type/method pair\n\nstruct MyContainerStyle <: BroadcastStyle end\nBase.BroadcastStyle(::Type{<:MyContainer}) = MyContainerStyle()\n\nOne then writes method(s) (at least similar) operating on Broadcasted{MyContainerStyle}. There are also several pre-defined subtypes of BroadcastStyle that you may be able to leverage; see the Interfaces chapter for more information.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.AbstractArrayStyle","location":"base/arrays.html#Base.Broadcast.AbstractArrayStyle","category":"type","text":"Broadcast.AbstractArrayStyle{N} <: BroadcastStyle is the abstract supertype for any style associated with an AbstractArray type. The N parameter is the dimensionality, which can be handy for AbstractArray types that only support specific dimensionalities:\n\nstruct SparseMatrixStyle <: Broadcast.AbstractArrayStyle{2} end\nBase.BroadcastStyle(::Type{<:SparseMatrixCSC}) = SparseMatrixStyle()\n\nFor AbstractArray types that support arbitrary dimensionality, N can be set to Any:\n\nstruct MyArrayStyle <: Broadcast.AbstractArrayStyle{Any} end\nBase.BroadcastStyle(::Type{<:MyArray}) = MyArrayStyle()\n\nIn cases where you want to be able to mix multiple AbstractArrayStyles and keep track of dimensionality, your style needs to support a Val constructor:\n\nstruct MyArrayStyleDim{N} <: Broadcast.AbstractArrayStyle{N} end\n(::Type{<:MyArrayStyleDim})(::Val{N}) where N = MyArrayStyleDim{N}()\n\nNote that if two or more AbstractArrayStyle subtypes conflict, broadcasting machinery will fall back to producing Arrays. If this is undesirable, you may need to define binary BroadcastStyle rules to control the output type.\n\nSee also Broadcast.DefaultArrayStyle.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.ArrayStyle","location":"base/arrays.html#Base.Broadcast.ArrayStyle","category":"type","text":"Broadcast.ArrayStyle{MyArrayType}() is a BroadcastStyle indicating that an object behaves as an array for broadcasting. It presents a simple way to construct Broadcast.AbstractArrayStyles for specific AbstractArray container types. Broadcast styles created this way lose track of dimensionality; if keeping track is important for your type, you should create your own custom Broadcast.AbstractArrayStyle.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.DefaultArrayStyle","location":"base/arrays.html#Base.Broadcast.DefaultArrayStyle","category":"type","text":"Broadcast.DefaultArrayStyle{N}() is a BroadcastStyle indicating that an object behaves as an N-dimensional array for broadcasting. Specifically, DefaultArrayStyle is used for any AbstractArray type that hasn't defined a specialized style, and in the absence of overrides from other broadcast arguments the resulting output type is Array. When there are multiple inputs to broadcast, DefaultArrayStyle \"loses\" to any other Broadcast.ArrayStyle.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.broadcastable","location":"base/arrays.html#Base.Broadcast.broadcastable","category":"function","text":"Broadcast.broadcastable(x)\n\nReturn either x or an object like x such that it supports axes, indexing, and its type supports ndims.\n\nIf x supports iteration, the returned value should have the same axes and indexing behaviors as collect(x).\n\nIf x is not an AbstractArray but it supports axes, indexing, and its type supports ndims, then broadcastable(::typeof(x)) may be implemented to just return itself. Further, if x defines its own BroadcastStyle, then it must define its broadcastable method to return itself for the custom style to have any effect.\n\nExamples\n\njulia> Broadcast.broadcastable([1,2,3]) # like `identity` since arrays already support axes and indexing\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> Broadcast.broadcastable(Int) # Types don't support axes, indexing, or iteration but are commonly used as scalars\nBase.RefValue{Type{Int64}}(Int64)\n\njulia> Broadcast.broadcastable(\"hello\") # Strings break convention of matching iteration and act like a scalar instead\nBase.RefValue{String}(\"hello\")\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.combine_axes","location":"base/arrays.html#Base.Broadcast.combine_axes","category":"function","text":"combine_axes(As...) -> Tuple\n\nDetermine the result axes for broadcasting across all values in As.\n\njulia> Broadcast.combine_axes([1], [1 2; 3 4; 5 6])\n(Base.OneTo(3), Base.OneTo(2))\n\njulia> Broadcast.combine_axes(1, 1, 1)\n()\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.combine_styles","location":"base/arrays.html#Base.Broadcast.combine_styles","category":"function","text":"combine_styles(cs...) -> BroadcastStyle\n\nDecides which BroadcastStyle to use for any number of value arguments. Uses BroadcastStyle to get the style for each argument, and uses result_style to combine styles.\n\nExamples\n\njulia> Broadcast.combine_styles([1], [1 2; 3 4])\nBase.Broadcast.DefaultArrayStyle{2}()\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.result_style","location":"base/arrays.html#Base.Broadcast.result_style","category":"function","text":"result_style(s1::BroadcastStyle[, s2::BroadcastStyle]) -> BroadcastStyle\n\nTakes one or two BroadcastStyles and combines them using BroadcastStyle to determine a common BroadcastStyle.\n\nExamples\n\njulia> Broadcast.result_style(Broadcast.DefaultArrayStyle{0}(), Broadcast.DefaultArrayStyle{3}())\nBase.Broadcast.DefaultArrayStyle{3}()\n\njulia> Broadcast.result_style(Broadcast.Unknown(), Broadcast.DefaultArrayStyle{1}())\nBase.Broadcast.DefaultArrayStyle{1}()\n\n\n\n\n\n","page":"Arrays"},{"title":"Indexing and assignment","location":"base/arrays.html#Indexing-and-assignment","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.getindex(::AbstractArray, ::Any...)\nBase.setindex!(::AbstractArray, ::Any, ::Any...)\nBase.copyto!(::AbstractArray, ::CartesianIndices, ::AbstractArray, ::CartesianIndices)\nBase.isassigned\nBase.Colon\nBase.CartesianIndex\nBase.CartesianIndices\nBase.Dims\nBase.LinearIndices\nBase.to_indices\nBase.checkbounds\nBase.checkindex\nBase.elsize","page":"Arrays"},{"title":"Base.getindex","location":"base/arrays.html#Base.getindex-Tuple{AbstractArray, Vararg{Any, N} where N}","category":"method","text":"getindex(A, inds...)\n\nReturn a subset of array A as specified by inds, where each ind may be, for example, an Int, an AbstractRange, or a Vector. See the manual section on array indexing for details.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> getindex(A, 1)\n1\n\njulia> getindex(A, [2, 1])\n2-element Vector{Int64}:\n 3\n 1\n\njulia> getindex(A, 2:4)\n3-element Vector{Int64}:\n 3\n 2\n 4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.setindex!","location":"base/arrays.html#Base.setindex!-Tuple{AbstractArray, Any, Vararg{Any, N} where N}","category":"method","text":"setindex!(A, X, inds...)\nA[inds...] = X\n\nStore values from array X within some subset of A as specified by inds. The syntax A[inds...] = X is equivalent to (setindex!(A, X, inds...); X).\n\nExamples\n\njulia> A = zeros(2,2);\n\njulia> setindex!(A, [10, 20], [1, 2]);\n\njulia> A[[3, 4]] = [30, 40];\n\njulia> A\n2×2 Matrix{Float64}:\n 10.0  30.0\n 20.0  40.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.copyto!","location":"base/arrays.html#Base.copyto!-Tuple{AbstractArray, CartesianIndices, AbstractArray, CartesianIndices}","category":"method","text":"copyto!(dest, Rdest::CartesianIndices, src, Rsrc::CartesianIndices) -> dest\n\nCopy the block of src in the range of Rsrc to the block of dest in the range of Rdest. The sizes of the two regions must match.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.isassigned","location":"base/arrays.html#Base.isassigned","category":"function","text":"isassigned(array, i) -> Bool\n\nTest whether the given array has a value associated with index i. Return false if the index is out of bounds, or has an undefined reference.\n\nExamples\n\njulia> isassigned(rand(3, 3), 5)\ntrue\n\njulia> isassigned(rand(3, 3), 3 * 3 + 1)\nfalse\n\njulia> mutable struct Foo end\n\njulia> v = similar(rand(3), Foo)\n3-element Vector{Foo}:\n #undef\n #undef\n #undef\n\njulia> isassigned(v, 1)\nfalse\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Colon","location":"base/arrays.html#Base.Colon","category":"type","text":"Colon()\n\nColons (:) are used to signify indexing entire objects or dimensions at once.\n\nVery few operations are defined on Colons directly; instead they are converted by to_indices to an internal vector type (Base.Slice) to represent the collection of indices they span before being used.\n\nThe singleton instance of Colon is also a function used to construct ranges; see :.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IteratorsMD.CartesianIndex","location":"base/arrays.html#Base.IteratorsMD.CartesianIndex","category":"type","text":"CartesianIndex(i, j, k...)   -> I\nCartesianIndex((i, j, k...)) -> I\n\nCreate a multidimensional index I, which can be used for indexing a multidimensional array A.  In particular, A[I] is equivalent to A[i,j,k...].  One can freely mix integer and CartesianIndex indices; for example, A[Ipre, i, Ipost] (where Ipre and Ipost are CartesianIndex indices and i is an Int) can be a useful expression when writing algorithms that work along a single dimension of an array of arbitrary dimensionality.\n\nA CartesianIndex is sometimes produced by eachindex, and always when iterating with an explicit CartesianIndices.\n\nExamples\n\njulia> A = reshape(Vector(1:16), (2, 2, 2, 2))\n2×2×2×2 Array{Int64, 4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\n[:, :, 2, 1] =\n 5  7\n 6  8\n\n[:, :, 1, 2] =\n  9  11\n 10  12\n\n[:, :, 2, 2] =\n 13  15\n 14  16\n\njulia> A[CartesianIndex((1, 1, 1, 1))]\n1\n\njulia> A[CartesianIndex((1, 1, 1, 2))]\n9\n\njulia> A[CartesianIndex((1, 1, 2, 1))]\n5\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IteratorsMD.CartesianIndices","location":"base/arrays.html#Base.IteratorsMD.CartesianIndices","category":"type","text":"CartesianIndices(sz::Dims) -> R\nCartesianIndices((istart:[istep:]istop, jstart:[jstep:]jstop, ...)) -> R\n\nDefine a region R spanning a multidimensional rectangular range of integer indices. These are most commonly encountered in the context of iteration, where for I in R ... end will return CartesianIndex indices I equivalent to the nested loops\n\nfor j = jstart:jstep:jstop\n    for i = istart:istep:istop\n        ...\n    end\nend\n\nConsequently these can be useful for writing algorithms that work in arbitrary dimensions.\n\nCartesianIndices(A::AbstractArray) -> R\n\nAs a convenience, constructing a CartesianIndices from an array makes a range of its indices.\n\ncompat: Julia 1.6\nThe step range method CartesianIndices((istart:istep:istop, jstart:[jstep:]jstop, ...)) requires at least Julia 1.6.\n\nExamples\n\njulia> foreach(println, CartesianIndices((2, 2, 2)))\nCartesianIndex(1, 1, 1)\nCartesianIndex(2, 1, 1)\nCartesianIndex(1, 2, 1)\nCartesianIndex(2, 2, 1)\nCartesianIndex(1, 1, 2)\nCartesianIndex(2, 1, 2)\nCartesianIndex(1, 2, 2)\nCartesianIndex(2, 2, 2)\n\njulia> CartesianIndices(fill(1, (2,3)))\n2×3 CartesianIndices{2, Tuple{Base.OneTo{Int64}, Base.OneTo{Int64}}}:\n CartesianIndex(1, 1)  CartesianIndex(1, 2)  CartesianIndex(1, 3)\n CartesianIndex(2, 1)  CartesianIndex(2, 2)  CartesianIndex(2, 3)\n\nConversion between linear and cartesian indices\n\nLinear index to cartesian index conversion exploits the fact that a CartesianIndices is an AbstractArray and can be indexed linearly:\n\njulia> cartesian = CartesianIndices((1:3, 1:2))\n3×2 CartesianIndices{2, Tuple{UnitRange{Int64}, UnitRange{Int64}}}:\n CartesianIndex(1, 1)  CartesianIndex(1, 2)\n CartesianIndex(2, 1)  CartesianIndex(2, 2)\n CartesianIndex(3, 1)  CartesianIndex(3, 2)\n\njulia> cartesian[4]\nCartesianIndex(1, 2)\n\njulia> cartesian = CartesianIndices((1:2:5, 1:2))\n3×2 CartesianIndices{2, Tuple{StepRange{Int64, Int64}, UnitRange{Int64}}}:\n CartesianIndex(1, 1)  CartesianIndex(1, 2)\n CartesianIndex(3, 1)  CartesianIndex(3, 2)\n CartesianIndex(5, 1)  CartesianIndex(5, 2)\n\njulia> cartesian[2, 2]\nCartesianIndex(3, 2)\n\nBroadcasting\n\nCartesianIndices support broadcasting arithmetic (+ and -) with a CartesianIndex.\n\ncompat: Julia 1.1\nBroadcasting of CartesianIndices requires at least Julia 1.1.\n\njulia> CIs = CartesianIndices((2:3, 5:6))\n2×2 CartesianIndices{2, Tuple{UnitRange{Int64}, UnitRange{Int64}}}:\n CartesianIndex(2, 5)  CartesianIndex(2, 6)\n CartesianIndex(3, 5)  CartesianIndex(3, 6)\n\njulia> CI = CartesianIndex(3, 4)\nCartesianIndex(3, 4)\n\njulia> CIs .+ CI\n2×2 CartesianIndices{2, Tuple{UnitRange{Int64}, UnitRange{Int64}}}:\n CartesianIndex(5, 9)  CartesianIndex(5, 10)\n CartesianIndex(6, 9)  CartesianIndex(6, 10)\n\nFor cartesian to linear index conversion, see LinearIndices.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Dims","location":"base/arrays.html#Base.Dims","category":"type","text":"Dims{N}\n\nAn NTuple of N Ints used to represent the dimensions of an AbstractArray.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.LinearIndices","location":"base/arrays.html#Base.LinearIndices","category":"type","text":"LinearIndices(A::AbstractArray)\n\nReturn a LinearIndices array with the same shape and axes as A, holding the linear index of each entry in A. Indexing this array with cartesian indices allows mapping them to linear indices.\n\nFor arrays with conventional indexing (indices start at 1), or any multidimensional array, linear indices range from 1 to length(A). However, for AbstractVectors linear indices are axes(A, 1), and therefore do not start at 1 for vectors with unconventional indexing.\n\nCalling this function is the \"safe\" way to write algorithms that exploit linear indexing.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> b = LinearIndices(A);\n\njulia> extrema(b)\n(1, 210)\n\nLinearIndices(inds::CartesianIndices) -> R\nLinearIndices(sz::Dims) -> R\nLinearIndices((istart:istop, jstart:jstop, ...)) -> R\n\nReturn a LinearIndices array with the specified shape or axes.\n\nExample\n\nThe main purpose of this constructor is intuitive conversion from cartesian to linear indexing:\n\njulia> linear = LinearIndices((1:3, 1:2))\n3×2 LinearIndices{2, Tuple{UnitRange{Int64}, UnitRange{Int64}}}:\n 1  4\n 2  5\n 3  6\n\njulia> linear[1,2]\n4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.to_indices","location":"base/arrays.html#Base.to_indices","category":"function","text":"to_indices(A, I::Tuple)\n\nConvert the tuple I to a tuple of indices for use in indexing into array A.\n\nThe returned tuple must only contain either Ints or AbstractArrays of scalar indices that are supported by array A. It will error upon encountering a novel index type that it does not know how to process.\n\nFor simple index types, it defers to the unexported Base.to_index(A, i) to process each index i. While this internal function is not intended to be called directly, Base.to_index may be extended by custom array or index types to provide custom indexing behaviors.\n\nMore complicated index types may require more context about the dimension into which they index. To support those cases, to_indices(A, I) calls to_indices(A, axes(A), I), which then recursively walks through both the given tuple of indices and the dimensional indices of A in tandem. As such, not all index types are guaranteed to propagate to Base.to_index.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.checkbounds","location":"base/arrays.html#Base.checkbounds","category":"function","text":"checkbounds(Bool, A, I...)\n\nReturn true if the specified indices I are in bounds for the given array A. Subtypes of AbstractArray should specialize this method if they need to provide custom bounds checking behaviors; however, in many cases one can rely on A's indices and checkindex.\n\nSee also checkindex.\n\nExamples\n\njulia> A = rand(3, 3);\n\njulia> checkbounds(Bool, A, 2)\ntrue\n\njulia> checkbounds(Bool, A, 3, 4)\nfalse\n\njulia> checkbounds(Bool, A, 1:3)\ntrue\n\njulia> checkbounds(Bool, A, 1:3, 2:4)\nfalse\n\n\n\n\n\ncheckbounds(A, I...)\n\nThrow an error if the specified indices I are not in bounds for the given array A.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.checkindex","location":"base/arrays.html#Base.checkindex","category":"function","text":"checkindex(Bool, inds::AbstractUnitRange, index)\n\nReturn true if the given index is within the bounds of inds. Custom types that would like to behave as indices for all arrays can extend this method in order to provide a specialized bounds checking implementation.\n\nExamples\n\njulia> checkindex(Bool, 1:20, 8)\ntrue\n\njulia> checkindex(Bool, 1:20, 21)\nfalse\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.elsize","location":"base/arrays.html#Base.elsize","category":"function","text":"elsize(type)\n\nCompute the memory stride in bytes between consecutive elements of eltype stored inside the given type, if the array elements are stored densely with a uniform linear stride.\n\n\n\n\n\n","page":"Arrays"},{"title":"Views (SubArrays and other view types)","location":"base/arrays.html#Views-(SubArrays-and-other-view-types)","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"A “view” is a data structure that acts like an array (it is a subtype of AbstractArray), but the underlying data is actually part of another array.","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"For example, if x is an array and v = @view x[1:10], then v acts like a 10-element array, but its data is actually accessing the first 10 elements of x. Writing to a view, e.g. v[3] = 2, writes directly to the underlying array x (in this case modifying x[3]).","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Slicing operations like x[1:10] create a copy by default in Julia. @view x[1:10] changes it to make a view. The @views macro can be used on a whole block of code (e.g. @views function foo() .... end or @views begin ... end) to change all the slicing operations in that block to use views.  Sometimes making a copy of the data is faster and sometimes using a view is faster, as described in the performance tips.","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.view\nBase.@view\nBase.@views\nBase.parent\nBase.parentindices\nBase.selectdim\nBase.reinterpret\nBase.reshape\nBase.dropdims\nBase.vec\nBase.SubArray","page":"Arrays"},{"title":"Base.view","location":"base/arrays.html#Base.view","category":"function","text":"view(A, inds...)\n\nLike getindex, but returns a lightweight array that lazily references (or is effectively a view into) the parent array A at the given index or indices inds instead of eagerly extracting elements or constructing a copied subset. Calling getindex or setindex! on the returned value (often a SubArray) computes the indices to access or modify the parent array on the fly.  The behavior is undefined if the shape of the parent array is changed after view is called because there is no bound check for the parent array; e.g., it may cause a segmentation fault.\n\nSome immutable parent arrays (like ranges) may choose to simply recompute a new array in some circumstances instead of returning a SubArray if doing so is efficient and provides compatible semantics.\n\ncompat: Julia 1.6\nIn Julia 1.6 or later, view can be called on an AbstractString, returning a SubString.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> b = view(A, :, 1)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\njulia> fill!(b, 0)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 0\n 0\n\njulia> A # Note A has changed even though we modified b\n2×2 Matrix{Int64}:\n 0  2\n 0  4\n\njulia> view(2:5, 2:3) # returns a range as type is immutable\n3:4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.@view","location":"base/arrays.html#Base.@view","category":"macro","text":"@view A[inds...]\n\nCreates a SubArray from an indexing expression. This can only be applied directly to a reference expression (e.g. @view A[1,2:end]), and should not be used as the target of an assignment (e.g. @view(A[1,2:end]) = ...).  See also @views to switch an entire block of code to use views for slicing.\n\ncompat: Julia 1.5\nUsing begin in an indexing expression to refer to the first index requires at least Julia 1.5.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> b = @view A[:, 1]\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\njulia> fill!(b, 0)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 0\n 0\n\njulia> A\n2×2 Matrix{Int64}:\n 0  2\n 0  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.@views","location":"base/arrays.html#Base.@views","category":"macro","text":"@views expression\n\nConvert every array-slicing operation in the given expression (which may be a begin/end block, loop, function, etc.) to return a view. Scalar indices, non-array types, and explicit getindex calls (as opposed to array[...]) are unaffected.\n\nnote: Note\nThe @views macro only affects array[...] expressions that appear explicitly in the given expression, not array slicing that occurs in functions called by that code.\n\ncompat: Julia 1.5\nUsing begin in an indexing expression to refer to the first index requires at least Julia 1.5.\n\nExamples\n\njulia> A = zeros(3, 3);\n\njulia> @views for row in 1:3\n           b = A[row, :]\n           b[:] .= row\n       end\n\njulia> A\n3×3 Matrix{Float64}:\n 1.0  1.0  1.0\n 2.0  2.0  2.0\n 3.0  3.0  3.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.parent","location":"base/arrays.html#Base.parent","category":"function","text":"parent(A)\n\nReturn the underlying \"parent array”. This parent array of objects of types SubArray, ReshapedArray or LinearAlgebra.Transpose is what was passed as an argument to view, reshape, transpose, etc. during object creation. If the input is not a wrapped object, return the input itself.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> V = view(A, 1:2, :)\n2×2 view(::Matrix{Int64}, 1:2, :) with eltype Int64:\n 1  2\n 3  4\n\njulia> parent(V)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.parentindices","location":"base/arrays.html#Base.parentindices","category":"function","text":"parentindices(A)\n\nReturn the indices in the parent which correspond to the array view A.\n\nExamples\n\njulia> A = [1 2; 3 4];\n\njulia> V = view(A, 1, :)\n2-element view(::Matrix{Int64}, 1, :) with eltype Int64:\n 1\n 2\n\njulia> parentindices(V)\n(1, Base.Slice(Base.OneTo(2)))\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.selectdim","location":"base/arrays.html#Base.selectdim","category":"function","text":"selectdim(A, d::Integer, i)\n\nReturn a view of all the data of A where the index for dimension d equals i.\n\nEquivalent to view(A,:,:,...,i,:,:,...) where i is in position d.\n\nExamples\n\njulia> A = [1 2 3 4; 5 6 7 8]\n2×4 Matrix{Int64}:\n 1  2  3  4\n 5  6  7  8\n\njulia> selectdim(A, 2, 3)\n2-element view(::Matrix{Int64}, :, 3) with eltype Int64:\n 3\n 7\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reinterpret","location":"base/arrays.html#Base.reinterpret","category":"function","text":"reinterpret(type, A)\n\nChange the type-interpretation of a block of memory. For arrays, this constructs a view of the array with the same binary data as the given array, but with the specified element type. For example, reinterpret(Float32, UInt32(7)) interprets the 4 bytes corresponding to UInt32(7) as a Float32.\n\nExamples\n\njulia> reinterpret(Float32, UInt32(7))\n1.0f-44\n\njulia> reinterpret(Float32, UInt32[1 2 3 4 5])\n1×5 reinterpret(Float32, ::Matrix{UInt32}):\n 1.0f-45  3.0f-45  4.0f-45  6.0f-45  7.0f-45\n\n\n\n\n\nreinterpret(reshape, T, A::AbstractArray{S}) -> B\n\nChange the type-interpretation of A while consuming or adding a \"channel dimension.\"\n\nIf sizeof(T) = n*sizeof(S) for n>1, A's first dimension must be of size n and B lacks A's first dimension. Conversely, if sizeof(S) = n*sizeof(T) for n>1, B gets a new first dimension of size n. The dimensionality is unchanged if sizeof(T) == sizeof(S).\n\ncompat: Julia 1.6\nThis method requires at least Julia 1.6.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int32}:\n 1  2\n 3  4\n\njulia> reinterpret(reshape, Complex{Int}, A)    # the result is a vector\n2-element reinterpret(reshape, Complex{Int32}, ::Matrix{Int32}) with eltype Complex{Int32}:\n 1 + 3im\n 2 + 4im\n\njulia> a = [(1,2,3), (4,5,6)]\n2-element Vector{Tuple{Int32, Int32, Int32}}:\n (1, 2, 3)\n (4, 5, 6)\n\njulia> reinterpret(reshape, Int, a)             # the result is a matrix\n3×2 reinterpret(reshape, Int32, ::Vector{Tuple{Int32, Int32, Int32}}) with eltype Int32:\n 1  4\n 2  5\n 3  6\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reshape","location":"base/arrays.html#Base.reshape","category":"function","text":"reshape(A, dims...) -> AbstractArray\nreshape(A, dims) -> AbstractArray\n\nReturn an array with the same data as A, but with different dimension sizes or number of dimensions. The two arrays share the same underlying data, so that the result is mutable if and only if A is mutable, and setting elements of one alters the values of the other.\n\nThe new dimensions may be specified either as a list of arguments or as a shape tuple. At most one dimension may be specified with a :, in which case its length is computed such that its product with all the specified dimensions is equal to the length of the original array A. The total number of elements must not change.\n\nExamples\n\njulia> A = Vector(1:16)\n16-element Vector{Int64}:\n  1\n  2\n  3\n  4\n  5\n  6\n  7\n  8\n  9\n 10\n 11\n 12\n 13\n 14\n 15\n 16\n\njulia> reshape(A, (4, 4))\n4×4 Matrix{Int64}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> reshape(A, 2, :)\n2×8 Matrix{Int64}:\n 1  3  5  7   9  11  13  15\n 2  4  6  8  10  12  14  16\n\njulia> reshape(1:6, 2, 3)\n2×3 reshape(::UnitRange{Int64}, 2, 3) with eltype Int64:\n 1  3  5\n 2  4  6\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.dropdims","location":"base/arrays.html#Base.dropdims","category":"function","text":"dropdims(A; dims)\n\nRemove the dimensions specified by dims from array A. Elements of dims must be unique and within the range 1:ndims(A). size(A,i) must equal 1 for all i in dims.\n\nExamples\n\njulia> a = reshape(Vector(1:4),(2,2,1,1))\n2×2×1×1 Array{Int64, 4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\njulia> dropdims(a; dims=3)\n2×2×1 Array{Int64, 3}:\n[:, :, 1] =\n 1  3\n 2  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.vec","location":"base/arrays.html#Base.vec","category":"function","text":"vec(a::AbstractArray) -> AbstractVector\n\nReshape the array a as a one-dimensional column vector. Return a if it is already an AbstractVector. The resulting array shares the same underlying data as a, so it will only be mutable if a is mutable, in which case modifying one will also modify the other.\n\nExamples\n\njulia> a = [1 2 3; 4 5 6]\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> vec(a)\n6-element Vector{Int64}:\n 1\n 4\n 2\n 5\n 3\n 6\n\njulia> vec(1:3)\n1:3\n\nSee also reshape.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.SubArray","location":"base/arrays.html#Base.SubArray","category":"type","text":"SubArray{T,N,P,I,L} <: AbstractArray{T,N}\n\nN-dimensional view into a parent array (of type P) with an element type T, restricted by a tuple of indices (of type I). L is true for types that support fast linear indexing, and false otherwise.\n\nConstruct SubArrays using the view function.\n\n\n\n\n\n","page":"Arrays"},{"title":"Concatenation and permutation","location":"base/arrays.html#Concatenation-and-permutation","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.cat\nBase.vcat\nBase.hcat\nBase.hvcat\nBase.vect\nBase.circshift\nBase.circshift!\nBase.circcopy!\nBase.findall(::Any)\nBase.findall(::Function, ::Any)\nBase.findfirst(::Any)\nBase.findfirst(::Function, ::Any)\nBase.findlast(::Any)\nBase.findlast(::Function, ::Any)\nBase.findnext(::Any, ::Integer)\nBase.findnext(::Function, ::Any, ::Integer)\nBase.findprev(::Any, ::Integer)\nBase.findprev(::Function, ::Any, ::Integer)\nBase.permutedims\nBase.permutedims!\nBase.PermutedDimsArray\nBase.promote_shape","page":"Arrays"},{"title":"Base.cat","location":"base/arrays.html#Base.cat","category":"function","text":"cat(A...; dims=dims)\n\nConcatenate the input arrays along the specified dimensions in the iterable dims. For dimensions not in dims, all input arrays should have the same size, which will also be the size of the output array along that dimension. For dimensions in dims, the size of the output array is the sum of the sizes of the input arrays along that dimension. If dims is a single number, the different arrays are tightly stacked along that dimension. If dims is an iterable containing several dimensions, this allows one to construct block diagonal matrices and their higher-dimensional analogues by simultaneously increasing several dimensions for every new input array and putting zero blocks elsewhere. For example, cat(matrices...; dims=(1,2)) builds a block diagonal matrix, i.e. a block matrix with matrices[1], matrices[2], ... as diagonal blocks and matching zero blocks away from the diagonal.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.vcat","location":"base/arrays.html#Base.vcat","category":"function","text":"vcat(A...)\n\nConcatenate along dimension 1.\n\nExamples\n\njulia> a = [1 2 3 4 5]\n1×5 Matrix{Int64}:\n 1  2  3  4  5\n\njulia> b = [6 7 8 9 10; 11 12 13 14 15]\n2×5 Matrix{Int64}:\n  6   7   8   9  10\n 11  12  13  14  15\n\njulia> vcat(a,b)\n3×5 Matrix{Int64}:\n  1   2   3   4   5\n  6   7   8   9  10\n 11  12  13  14  15\n\njulia> c = ([1 2 3], [4 5 6])\n([1 2 3], [4 5 6])\n\njulia> vcat(c...)\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.hcat","location":"base/arrays.html#Base.hcat","category":"function","text":"hcat(A...)\n\nConcatenate along dimension 2.\n\nExamples\n\njulia> a = [1; 2; 3; 4; 5]\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> b = [6 7; 8 9; 10 11; 12 13; 14 15]\n5×2 Matrix{Int64}:\n  6   7\n  8   9\n 10  11\n 12  13\n 14  15\n\njulia> hcat(a,b)\n5×3 Matrix{Int64}:\n 1   6   7\n 2   8   9\n 3  10  11\n 4  12  13\n 5  14  15\n\njulia> c = ([1; 2; 3], [4; 5; 6])\n([1, 2, 3], [4, 5, 6])\n\njulia> hcat(c...)\n3×2 Matrix{Int64}:\n 1  4\n 2  5\n 3  6\n\njulia> x = Matrix(undef, 3, 0)  # x = [] would have created an Array{Any, 1}, but need an Array{Any, 2}\n3×0 Matrix{Any}\n\njulia> hcat(x, [1; 2; 3])\n3×1 Matrix{Any}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.hvcat","location":"base/arrays.html#Base.hvcat","category":"function","text":"hvcat(rows::Tuple{Vararg{Int}}, values...)\n\nHorizontal and vertical concatenation in one call. This function is called for block matrix syntax. The first argument specifies the number of arguments to concatenate in each block row.\n\nExamples\n\njulia> a, b, c, d, e, f = 1, 2, 3, 4, 5, 6\n(1, 2, 3, 4, 5, 6)\n\njulia> [a b c; d e f]\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> hvcat((3,3), a,b,c,d,e,f)\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> [a b;c d; e f]\n3×2 Matrix{Int64}:\n 1  2\n 3  4\n 5  6\n\njulia> hvcat((2,2,2), a,b,c,d,e,f)\n3×2 Matrix{Int64}:\n 1  2\n 3  4\n 5  6\n\nIf the first argument is a single integer n, then all block rows are assumed to have n block columns.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.vect","location":"base/arrays.html#Base.vect","category":"function","text":"vect(X...)\n\nCreate a Vector with element type computed from the promote_typeof of the argument, containing the argument list.\n\nExamples\n\njulia> a = Base.vect(UInt8(1), 2.5, 1//2)\n3-element Vector{Float64}:\n 1.0\n 2.5\n 0.5\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.circshift","location":"base/arrays.html#Base.circshift","category":"function","text":"circshift(A, shifts)\n\nCircularly shift, i.e. rotate, the data in an array. The second argument is a tuple or vector giving the amount to shift in each dimension, or an integer to shift only in the first dimension.\n\nExamples\n\njulia> b = reshape(Vector(1:16), (4,4))\n4×4 Matrix{Int64}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> circshift(b, (0,2))\n4×4 Matrix{Int64}:\n  9  13  1  5\n 10  14  2  6\n 11  15  3  7\n 12  16  4  8\n\njulia> circshift(b, (-1,0))\n4×4 Matrix{Int64}:\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n 1  5   9  13\n\njulia> a = BitArray([true, true, false, false, true])\n5-element BitVector:\n 1\n 1\n 0\n 0\n 1\n\njulia> circshift(a, 1)\n5-element BitVector:\n 1\n 1\n 1\n 0\n 0\n\njulia> circshift(a, -1)\n5-element BitVector:\n 1\n 0\n 0\n 1\n 1\n\nSee also circshift!.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.circshift!","location":"base/arrays.html#Base.circshift!","category":"function","text":"circshift!(dest, src, shifts)\n\nCircularly shift, i.e. rotate, the data in src, storing the result in dest. shifts specifies the amount to shift in each dimension.\n\nThe dest array must be distinct from the src array (they cannot alias each other).\n\nSee also circshift.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.circcopy!","location":"base/arrays.html#Base.circcopy!","category":"function","text":"circcopy!(dest, src)\n\nCopy src to dest, indexing each dimension modulo its length. src and dest must have the same size, but can be offset in their indices; any offset results in a (circular) wraparound. If the arrays have overlapping indices, then on the domain of the overlap dest agrees with src.\n\nExamples\n\njulia> src = reshape(Vector(1:16), (4,4))\n4×4 Array{Int64,2}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> dest = OffsetArray{Int}(undef, (0:3,2:5))\n\njulia> circcopy!(dest, src)\nOffsetArrays.OffsetArray{Int64,2,Array{Int64,2}} with indices 0:3×2:5:\n 8  12  16  4\n 5   9  13  1\n 6  10  14  2\n 7  11  15  3\n\njulia> dest[1:3,2:4] == src[1:3,2:4]\ntrue\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findall","location":"base/arrays.html#Base.findall-Tuple{Any}","category":"method","text":"findall(A)\n\nReturn a vector I of the true indices or keys of A. If there are no such elements of A, return an empty array. To search for other kinds of values, pass a predicate as the first argument.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [true, false, false, true]\n4-element Vector{Bool}:\n 1\n 0\n 0\n 1\n\njulia> findall(A)\n2-element Vector{Int64}:\n 1\n 4\n\njulia> A = [true false; false true]\n2×2 Matrix{Bool}:\n 1  0\n 0  1\n\njulia> findall(A)\n2-element Vector{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 2)\n\njulia> findall(falses(3))\nInt64[]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findall","location":"base/arrays.html#Base.findall-Tuple{Function, Any}","category":"method","text":"findall(f::Function, A)\n\nReturn a vector I of the indices or keys of A where f(A[I]) returns true. If there are no such elements of A, return an empty array.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> x = [1, 3, 4]\n3-element Vector{Int64}:\n 1\n 3\n 4\n\njulia> findall(isodd, x)\n2-element Vector{Int64}:\n 1\n 2\n\njulia> A = [1 2 0; 3 4 0]\n2×3 Matrix{Int64}:\n 1  2  0\n 3  4  0\njulia> findall(isodd, A)\n2-element Vector{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 1)\n\njulia> findall(!iszero, A)\n4-element Vector{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 1)\n CartesianIndex(1, 2)\n CartesianIndex(2, 2)\n\njulia> d = Dict(:A => 10, :B => -1, :C => 0)\nDict{Symbol, Int64} with 3 entries:\n  :A => 10\n  :B => -1\n  :C => 0\n\njulia> findall(x -> x >= 0, d)\n2-element Vector{Symbol}:\n :A\n :C\n\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findfirst","location":"base/arrays.html#Base.findfirst-Tuple{Any}","category":"method","text":"findfirst(A)\n\nReturn the index or key of the first true value in A. Return nothing if no such value is found. To search for other kinds of values, pass a predicate as the first argument.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [false, false, true, false]\n4-element Vector{Bool}:\n 0\n 0\n 1\n 0\n\njulia> findfirst(A)\n3\n\njulia> findfirst(falses(3)) # returns nothing, but not printed in the REPL\n\njulia> A = [false false; true false]\n2×2 Matrix{Bool}:\n 0  0\n 1  0\n\njulia> findfirst(A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findfirst","location":"base/arrays.html#Base.findfirst-Tuple{Function, Any}","category":"method","text":"findfirst(predicate::Function, A)\n\nReturn the index or key of the first element of A for which predicate returns true. Return nothing if there is no such element.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [1, 4, 2, 2]\n4-element Vector{Int64}:\n 1\n 4\n 2\n 2\n\njulia> findfirst(iseven, A)\n2\n\njulia> findfirst(x -> x>10, A) # returns nothing, but not printed in the REPL\n\njulia> findfirst(isequal(4), A)\n2\n\njulia> A = [1 4; 2 2]\n2×2 Matrix{Int64}:\n 1  4\n 2  2\n\njulia> findfirst(iseven, A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findlast","location":"base/arrays.html#Base.findlast-Tuple{Any}","category":"method","text":"findlast(A)\n\nReturn the index or key of the last true value in A. Return nothing if there is no true value in A.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [true, false, true, false]\n4-element Vector{Bool}:\n 1\n 0\n 1\n 0\n\njulia> findlast(A)\n3\n\njulia> A = falses(2,2);\n\njulia> findlast(A) # returns nothing, but not printed in the REPL\n\njulia> A = [true false; true false]\n2×2 Matrix{Bool}:\n 1  0\n 1  0\n\njulia> findlast(A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findlast","location":"base/arrays.html#Base.findlast-Tuple{Function, Any}","category":"method","text":"findlast(predicate::Function, A)\n\nReturn the index or key of the last element of A for which predicate returns true. Return nothing if there is no such element.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [1, 2, 3, 4]\n4-element Vector{Int64}:\n 1\n 2\n 3\n 4\n\njulia> findlast(isodd, A)\n3\n\njulia> findlast(x -> x > 5, A) # returns nothing, but not printed in the REPL\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> findlast(isodd, A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findnext","location":"base/arrays.html#Base.findnext-Tuple{Any, Integer}","category":"method","text":"findnext(A, i)\n\nFind the next index after or including i of a true element of A, or nothing if not found.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [false, false, true, false]\n4-element Vector{Bool}:\n 0\n 0\n 1\n 0\n\njulia> findnext(A, 1)\n3\n\njulia> findnext(A, 4) # returns nothing, but not printed in the REPL\n\njulia> A = [false false; true false]\n2×2 Matrix{Bool}:\n 0  0\n 1  0\n\njulia> findnext(A, CartesianIndex(1, 1))\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findnext","location":"base/arrays.html#Base.findnext-Tuple{Function, Any, Integer}","category":"method","text":"findnext(predicate::Function, A, i)\n\nFind the next index after or including i of an element of A for which predicate returns true, or nothing if not found.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [1, 4, 2, 2];\n\njulia> findnext(isodd, A, 1)\n1\n\njulia> findnext(isodd, A, 2) # returns nothing, but not printed in the REPL\n\njulia> A = [1 4; 2 2];\n\njulia> findnext(isodd, A, CartesianIndex(1, 1))\nCartesianIndex(1, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findprev","location":"base/arrays.html#Base.findprev-Tuple{Any, Integer}","category":"method","text":"findprev(A, i)\n\nFind the previous index before or including i of a true element of A, or nothing if not found.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [false, false, true, true]\n4-element Vector{Bool}:\n 0\n 0\n 1\n 1\n\njulia> findprev(A, 3)\n3\n\njulia> findprev(A, 1) # returns nothing, but not printed in the REPL\n\njulia> A = [false false; true true]\n2×2 Matrix{Bool}:\n 0  0\n 1  1\n\njulia> findprev(A, CartesianIndex(2, 1))\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findprev","location":"base/arrays.html#Base.findprev-Tuple{Function, Any, Integer}","category":"method","text":"findprev(predicate::Function, A, i)\n\nFind the previous index before or including i of an element of A for which predicate returns true, or nothing if not found.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [4, 6, 1, 2]\n4-element Vector{Int64}:\n 4\n 6\n 1\n 2\n\njulia> findprev(isodd, A, 1) # returns nothing, but not printed in the REPL\n\njulia> findprev(isodd, A, 3)\n3\n\njulia> A = [4 6; 1 2]\n2×2 Matrix{Int64}:\n 4  6\n 1  2\n\njulia> findprev(isodd, A, CartesianIndex(1, 2))\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.permutedims","location":"base/arrays.html#Base.permutedims","category":"function","text":"permutedims(A::AbstractArray, perm)\n\nPermute the dimensions of array A. perm is a vector specifying a permutation of length ndims(A).\n\nSee also: PermutedDimsArray.\n\nExamples\n\njulia> A = reshape(Vector(1:8), (2,2,2))\n2×2×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  3\n 2  4\n\n[:, :, 2] =\n 5  7\n 6  8\n\njulia> permutedims(A, [3, 2, 1])\n2×2×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  3\n 5  7\n\n[:, :, 2] =\n 2  4\n 6  8\n\n\n\n\n\npermutedims(m::AbstractMatrix)\n\nPermute the dimensions of the matrix m, by flipping the elements across the diagonal of the matrix. Differs from LinearAlgebra's transpose in that the operation is not recursive.\n\nExamples\n\njulia> a = [1 2; 3 4];\n\njulia> b = [5 6; 7 8];\n\njulia> c = [9 10; 11 12];\n\njulia> d = [13 14; 15 16];\n\njulia> X = [[a] [b]; [c] [d]]\n2×2 Matrix{Matrix{Int64}}:\n [1 2; 3 4]     [5 6; 7 8]\n [9 10; 11 12]  [13 14; 15 16]\n\njulia> permutedims(X)\n2×2 Matrix{Matrix{Int64}}:\n [1 2; 3 4]  [9 10; 11 12]\n [5 6; 7 8]  [13 14; 15 16]\n\njulia> transpose(X)\n2×2 transpose(::Matrix{Matrix{Int64}}) with eltype Transpose{Int64, Matrix{Int64}}:\n [1 3; 2 4]  [9 11; 10 12]\n [5 7; 6 8]  [13 15; 14 16]\n\n\n\n\n\npermutedims(v::AbstractVector)\n\nReshape vector v into a 1 × length(v) row matrix. Differs from LinearAlgebra's transpose in that the operation is not recursive.\n\nExamples\n\njulia> permutedims([1, 2, 3, 4])\n1×4 Matrix{Int64}:\n 1  2  3  4\n\njulia> V = [[[1 2; 3 4]]; [[5 6; 7 8]]]\n2-element Vector{Matrix{Int64}}:\n [1 2; 3 4]\n [5 6; 7 8]\n\njulia> permutedims(V)\n1×2 Matrix{Matrix{Int64}}:\n [1 2; 3 4]  [5 6; 7 8]\n\njulia> transpose(V)\n1×2 transpose(::Vector{Matrix{Int64}}) with eltype Transpose{Int64, Matrix{Int64}}:\n [1 3; 2 4]  [5 7; 6 8]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.permutedims!","location":"base/arrays.html#Base.permutedims!","category":"function","text":"permutedims!(dest, src, perm)\n\nPermute the dimensions of array src and store the result in the array dest. perm is a vector specifying a permutation of length ndims(src). The preallocated array dest should have size(dest) == size(src)[perm] and is completely overwritten. No in-place permutation is supported and unexpected results will happen if src and dest have overlapping memory regions.\n\nSee also permutedims.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.PermutedDimsArrays.PermutedDimsArray","location":"base/arrays.html#Base.PermutedDimsArrays.PermutedDimsArray","category":"type","text":"PermutedDimsArray(A, perm) -> B\n\nGiven an AbstractArray A, create a view B such that the dimensions appear to be permuted. Similar to permutedims, except that no copying occurs (B shares storage with A).\n\nSee also: permutedims.\n\nExamples\n\njulia> A = rand(3,5,4);\n\njulia> B = PermutedDimsArray(A, (3,1,2));\n\njulia> size(B)\n(4, 3, 5)\n\njulia> B[3,1,2] == A[1,2,3]\ntrue\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.promote_shape","location":"base/arrays.html#Base.promote_shape","category":"function","text":"promote_shape(s1, s2)\n\nCheck two array shapes for compatibility, allowing trailing singleton dimensions, and return whichever shape has more dimensions.\n\nExamples\n\njulia> a = fill(1, (3,4,1,1,1));\n\njulia> b = fill(1, (3,4));\n\njulia> promote_shape(a,b)\n(Base.OneTo(3), Base.OneTo(4), Base.OneTo(1), Base.OneTo(1), Base.OneTo(1))\n\njulia> promote_shape((2,3,1,4), (2, 3, 1, 4, 1))\n(2, 3, 1, 4, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Array functions","location":"base/arrays.html#Array-functions","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.accumulate\nBase.accumulate!\nBase.cumprod\nBase.cumprod!\nBase.cumsum\nBase.cumsum!\nBase.diff\nBase.repeat\nBase.rot180\nBase.rotl90\nBase.rotr90\nBase.mapslices\nBase.eachrow\nBase.eachcol\nBase.eachslice","page":"Arrays"},{"title":"Base.accumulate","location":"base/arrays.html#Base.accumulate","category":"function","text":"accumulate(op, A; dims::Integer, [init])\n\nCumulative operation op along the dimension dims of A (providing dims is optional for vectors). An initial value init may optionally be provided by a keyword argument. See also accumulate! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow). For common operations there are specialized variants of accumulate, see: cumsum, cumprod\n\ncompat: Julia 1.5\naccumulate on a non-array iterator requires at least Julia 1.5.\n\nExamples\n\njulia> accumulate(+, [1,2,3])\n3-element Vector{Int64}:\n 1\n 3\n 6\n\njulia> accumulate(*, [1,2,3])\n3-element Vector{Int64}:\n 1\n 2\n 6\n\njulia> accumulate(+, [1,2,3]; init=100)\n3-element Vector{Int64}:\n 101\n 103\n 106\n\njulia> accumulate(min, [1,2,-1]; init=0)\n3-element Vector{Int64}:\n  0\n  0\n -1\n\njulia> accumulate(+, fill(1, 3, 3), dims=1)\n3×3 Matrix{Int64}:\n 1  1  1\n 2  2  2\n 3  3  3\n\njulia> accumulate(+, fill(1, 3, 3), dims=2)\n3×3 Matrix{Int64}:\n 1  2  3\n 1  2  3\n 1  2  3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.accumulate!","location":"base/arrays.html#Base.accumulate!","category":"function","text":"accumulate!(op, B, A; [dims], [init])\n\nCumulative operation op on A along the dimension dims, storing the result in B. Providing dims is optional for vectors.  If the keyword argument init is given, its value is used to instantiate the accumulation. See also accumulate.\n\nExamples\n\njulia> x = [1, 0, 2, 0, 3];\n\njulia> y = [0, 0, 0, 0, 0];\n\njulia> accumulate!(+, y, x);\n\njulia> y\n5-element Vector{Int64}:\n 1\n 1\n 3\n 3\n 6\n\njulia> A = [1 2; 3 4];\n\njulia> B = [0 0; 0 0];\n\njulia> accumulate!(-, B, A, dims=1);\n\njulia> B\n2×2 Matrix{Int64}:\n  1   2\n -2  -2\n\njulia> accumulate!(-, B, A, dims=2);\n\njulia> B\n2×2 Matrix{Int64}:\n 1  -1\n 3  -1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumprod","location":"base/arrays.html#Base.cumprod","category":"function","text":"cumprod(A; dims::Integer)\n\nCumulative product along the dimension dim. See also cumprod! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow).\n\nExamples\n\njulia> a = [1 2 3; 4 5 6]\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> cumprod(a, dims=1)\n2×3 Matrix{Int64}:\n 1   2   3\n 4  10  18\n\njulia> cumprod(a, dims=2)\n2×3 Matrix{Int64}:\n 1   2    6\n 4  20  120\n\n\n\n\n\ncumprod(itr)\n\nCumulative product of an iterator. See also cumprod! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow).\n\ncompat: Julia 1.5\ncumprod on a non-array iterator requires at least Julia 1.5.\n\nExamples\n\njulia> cumprod(fill(1//2, 3))\n3-element Vector{Rational{Int64}}:\n 1//2\n 1//4\n 1//8\n\njulia> cumprod([fill(1//3, 2, 2) for i in 1:3])\n3-element Vector{Matrix{Rational{Int64}}}:\n [1//3 1//3; 1//3 1//3]\n [2//9 2//9; 2//9 2//9]\n [4//27 4//27; 4//27 4//27]\n\njulia> cumprod((1, 2, 1))\n(1, 2, 2)\n\njulia> cumprod(x^2 for x in 1:3)\n3-element Vector{Int64}:\n  1\n  4\n 36\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumprod!","location":"base/arrays.html#Base.cumprod!","category":"function","text":"cumprod!(B, A; dims::Integer)\n\nCumulative product of A along the dimension dims, storing the result in B. See also cumprod.\n\n\n\n\n\ncumprod!(y::AbstractVector, x::AbstractVector)\n\nCumulative product of a vector x, storing the result in y. See also cumprod.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumsum","location":"base/arrays.html#Base.cumsum","category":"function","text":"cumsum(A; dims::Integer)\n\nCumulative sum along the dimension dims. See also cumsum! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow).\n\nExamples\n\njulia> a = [1 2 3; 4 5 6]\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> cumsum(a, dims=1)\n2×3 Matrix{Int64}:\n 1  2  3\n 5  7  9\n\njulia> cumsum(a, dims=2)\n2×3 Matrix{Int64}:\n 1  3   6\n 4  9  15\n\nnote: Note\nThe return array's eltype is Int for signed integers of less than system word size  and UInt for unsigned integers of less than system word size. To preserve eltype of arrays with small signed or unsigned integer accumulate(+, A) should be used.julia> cumsum(Int8[100, 28])\n2-element Vector{Int64}:\n 100\n 128\n\njulia> accumulate(+,Int8[100, 28])\n2-element Vector{Int8}:\n  100\n -128In the former case, the integers are widened to system word size and therefore the result is Int64[100, 128]. In the latter case, no such widening happens and integer overflow results in Int8[100, -128].\n\n\n\n\n\ncumsum(itr)\n\nCumulative sum an iterator. See also cumsum! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow).\n\ncompat: Julia 1.5\ncumsum on a non-array iterator requires at least Julia 1.5.\n\nExamples\n\njulia> cumsum([1, 1, 1])\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> cumsum([fill(1, 2) for i in 1:3])\n3-element Vector{Vector{Int64}}:\n [1, 1]\n [2, 2]\n [3, 3]\n\njulia> cumsum((1, 1, 1))\n(1, 2, 3)\n\njulia> cumsum(x^2 for x in 1:3)\n3-element Vector{Int64}:\n  1\n  5\n 14\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumsum!","location":"base/arrays.html#Base.cumsum!","category":"function","text":"cumsum!(B, A; dims::Integer)\n\nCumulative sum of A along the dimension dims, storing the result in B. See also cumsum.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.diff","location":"base/arrays.html#Base.diff","category":"function","text":"diff(A::AbstractVector)\ndiff(A::AbstractArray; dims::Integer)\n\nFinite difference operator on a vector or a multidimensional array A. In the latter case the dimension to operate on needs to be specified with the dims keyword argument.\n\ncompat: Julia 1.1\ndiff for arrays with dimension higher than 2 requires at least Julia 1.1.\n\nExamples\n\njulia> a = [2 4; 6 16]\n2×2 Matrix{Int64}:\n 2   4\n 6  16\n\njulia> diff(a, dims=2)\n2×1 Matrix{Int64}:\n  2\n 10\n\njulia> diff(vec(a))\n3-element Vector{Int64}:\n  4\n -2\n 12\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.repeat","location":"base/arrays.html#Base.repeat","category":"function","text":"repeat(A::AbstractArray, counts::Integer...)\n\nConstruct an array by repeating array A a given number of times in each dimension, specified by counts.\n\nExamples\n\njulia> repeat([1, 2, 3], 2)\n6-element Vector{Int64}:\n 1\n 2\n 3\n 1\n 2\n 3\n\njulia> repeat([1, 2, 3], 2, 3)\n6×3 Matrix{Int64}:\n 1  1  1\n 2  2  2\n 3  3  3\n 1  1  1\n 2  2  2\n 3  3  3\n\n\n\n\n\nrepeat(A::AbstractArray; inner=ntuple(x->1, ndims(A)), outer=ntuple(x->1, ndims(A)))\n\nConstruct an array by repeating the entries of A. The i-th element of inner specifies the number of times that the individual entries of the i-th dimension of A should be repeated. The i-th element of outer specifies the number of times that a slice along the i-th dimension of A should be repeated. If inner or outer are omitted, no repetition is performed.\n\nExamples\n\njulia> repeat(1:2, inner=2)\n4-element Vector{Int64}:\n 1\n 1\n 2\n 2\n\njulia> repeat(1:2, outer=2)\n4-element Vector{Int64}:\n 1\n 2\n 1\n 2\n\njulia> repeat([1 2; 3 4], inner=(2, 1), outer=(1, 3))\n4×6 Matrix{Int64}:\n 1  2  1  2  1  2\n 1  2  1  2  1  2\n 3  4  3  4  3  4\n 3  4  3  4  3  4\n\n\n\n\n\nrepeat(s::AbstractString, r::Integer)\n\nRepeat a string r times. This can be written as s^r.\n\nSee also: ^\n\nExamples\n\njulia> repeat(\"ha\", 3)\n\"hahaha\"\n\n\n\n\n\nrepeat(c::AbstractChar, r::Integer) -> String\n\nRepeat a character r times. This can equivalently be accomplished by calling c^r.\n\nExamples\n\njulia> repeat('A', 3)\n\"AAA\"\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.rot180","location":"base/arrays.html#Base.rot180","category":"function","text":"rot180(A)\n\nRotate matrix A 180 degrees.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rot180(a)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\n\n\n\n\nrot180(A, k)\n\nRotate matrix A 180 degrees an integer k number of times. If k is even, this is equivalent to a copy.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rot180(a,1)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\njulia> rot180(a,2)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.rotl90","location":"base/arrays.html#Base.rotl90","category":"function","text":"rotl90(A)\n\nRotate matrix A left 90 degrees.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotl90(a)\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\n\n\n\n\nrotl90(A, k)\n\nLeft-rotate matrix A 90 degrees counterclockwise an integer k number of times. If k is a multiple of four (including zero), this is equivalent to a copy.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotl90(a,1)\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\njulia> rotl90(a,2)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\njulia> rotl90(a,3)\n2×2 Matrix{Int64}:\n 3  1\n 4  2\n\njulia> rotl90(a,4)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.rotr90","location":"base/arrays.html#Base.rotr90","category":"function","text":"rotr90(A)\n\nRotate matrix A right 90 degrees.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotr90(a)\n2×2 Matrix{Int64}:\n 3  1\n 4  2\n\n\n\n\n\nrotr90(A, k)\n\nRight-rotate matrix A 90 degrees clockwise an integer k number of times. If k is a multiple of four (including zero), this is equivalent to a copy.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotr90(a,1)\n2×2 Matrix{Int64}:\n 3  1\n 4  2\n\njulia> rotr90(a,2)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\njulia> rotr90(a,3)\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\njulia> rotr90(a,4)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.mapslices","location":"base/arrays.html#Base.mapslices","category":"function","text":"mapslices(f, A; dims)\n\nTransform the given dimensions of array A using function f. f is called on each slice of A of the form A[...,:,...,:,...]. dims is an integer vector specifying where the colons go in this expression. The results are concatenated along the remaining dimensions. For example, if dims is [1,2] and A is 4-dimensional, f is called on A[:,:,i,j] for all i and j.\n\nExamples\n\njulia> a = reshape(Vector(1:16),(2,2,2,2))\n2×2×2×2 Array{Int64, 4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\n[:, :, 2, 1] =\n 5  7\n 6  8\n\n[:, :, 1, 2] =\n  9  11\n 10  12\n\n[:, :, 2, 2] =\n 13  15\n 14  16\n\njulia> mapslices(sum, a, dims = [1,2])\n1×1×2×2 Array{Int64, 4}:\n[:, :, 1, 1] =\n 10\n\n[:, :, 2, 1] =\n 26\n\n[:, :, 1, 2] =\n 42\n\n[:, :, 2, 2] =\n 58\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachrow","location":"base/arrays.html#Base.eachrow","category":"function","text":"eachrow(A::AbstractVecOrMat)\n\nCreate a generator that iterates over the first dimension of vector or matrix A, returning the rows as AbstractVector views.\n\nSee also eachcol and eachslice.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\nExample\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> first(eachrow(a))\n2-element view(::Matrix{Int64}, 1, :) with eltype Int64:\n 1\n 2\n\njulia> collect(eachrow(a))\n2-element Vector{SubArray{Int64, 1, Matrix{Int64}, Tuple{Int64, Base.Slice{Base.OneTo{Int64}}}, true}}:\n [1, 2]\n [3, 4]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachcol","location":"base/arrays.html#Base.eachcol","category":"function","text":"eachcol(A::AbstractVecOrMat)\n\nCreate a generator that iterates over the second dimension of matrix A, returning the columns as AbstractVector views.\n\nSee also eachrow and eachslice.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\nExample\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> first(eachcol(a))\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\njulia> collect(eachcol(a))\n2-element Vector{SubArray{Int64, 1, Matrix{Int64}, Tuple{Base.Slice{Base.OneTo{Int64}}, Int64}, true}}:\n [1, 3]\n [2, 4]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachslice","location":"base/arrays.html#Base.eachslice","category":"function","text":"eachslice(A::AbstractArray; dims)\n\nCreate a generator that iterates over dimensions dims of A, returning views that select all the data from the other dimensions in A.\n\nOnly a single dimension in dims is currently supported. Equivalent to (view(A,:,:,...,i,:,: ...)) for i in axes(A, dims)), where i is in position dims.\n\nSee also eachrow, eachcol, and selectdim.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\nExample\n\njulia> M = [1 2 3; 4 5 6; 7 8 9]\n3×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n 7  8  9\n\njulia> first(eachslice(M, dims=1))\n3-element view(::Matrix{Int64}, 1, :) with eltype Int64:\n 1\n 2\n 3\n\njulia> collect(eachslice(M, dims=2))\n3-element Vector{SubArray{Int64, 1, Matrix{Int64}, Tuple{Base.Slice{Base.OneTo{Int64}}, Int64}, true}}:\n [1, 4, 7]\n [2, 5, 8]\n [3, 6, 9]\n\n\n\n\n\n","page":"Arrays"},{"title":"Combinatorics","location":"base/arrays.html#Combinatorics","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.invperm\nBase.isperm\nBase.permute!(::Any, ::AbstractVector)\nBase.invpermute!\nBase.reverse(::AbstractVector; kwargs...)\nBase.reverseind\nBase.reverse!","page":"Arrays"},{"title":"Base.invperm","location":"base/arrays.html#Base.invperm","category":"function","text":"invperm(v)\n\nReturn the inverse permutation of v. If B = A[v], then A == B[invperm(v)].\n\nExamples\n\njulia> v = [2; 4; 3; 1];\n\njulia> invperm(v)\n4-element Vector{Int64}:\n 4\n 1\n 3\n 2\n\njulia> A = ['a','b','c','d'];\n\njulia> B = A[v]\n4-element Vector{Char}:\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'd': ASCII/Unicode U+0064 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n 'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> B[invperm(v)]\n4-element Vector{Char}:\n 'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n 'd': ASCII/Unicode U+0064 (category Ll: Letter, lowercase)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.isperm","location":"base/arrays.html#Base.isperm","category":"function","text":"isperm(v) -> Bool\n\nReturn true if v is a valid permutation.\n\nExamples\n\njulia> isperm([1; 2])\ntrue\n\njulia> isperm([1; 3])\nfalse\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.permute!","location":"base/arrays.html#Base.permute!-Tuple{Any, AbstractVector{T} where T}","category":"method","text":"permute!(v, p)\n\nPermute vector v in-place, according to permutation p. No checking is done to verify that p is a permutation.\n\nTo return a new permutation, use v[p]. Note that this is generally faster than permute!(v,p) for large vectors.\n\nSee also invpermute!.\n\nExamples\n\njulia> A = [1, 1, 3, 4];\n\njulia> perm = [2, 4, 3, 1];\n\njulia> permute!(A, perm);\n\njulia> A\n4-element Vector{Int64}:\n 1\n 4\n 3\n 1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.invpermute!","location":"base/arrays.html#Base.invpermute!","category":"function","text":"invpermute!(v, p)\n\nLike permute!, but the inverse of the given permutation is applied.\n\nExamples\n\njulia> A = [1, 1, 3, 4];\n\njulia> perm = [2, 4, 3, 1];\n\njulia> invpermute!(A, perm);\n\njulia> A\n4-element Vector{Int64}:\n 4\n 1\n 3\n 1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reverse","location":"base/arrays.html#Base.reverse-Tuple{AbstractVector{T} where T}","category":"method","text":"reverse(A; dims=:)\n\nReverse A along dimension dims, which can be an integer (a single dimension), a tuple of integers (a tuple of dimensions) or : (reverse along all the dimensions, the default).  See also reverse! for in-place reversal.\n\nExamples\n\njulia> b = Int64[1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> reverse(b, dims=2)\n2×2 Matrix{Int64}:\n 2  1\n 4  3\n\njulia> reverse(b)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\ncompat: Julia 1.6\nPrior to Julia 1.6, only single-integer dims are supported in reverse.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reverseind","location":"base/arrays.html#Base.reverseind","category":"function","text":"reverseind(v, i)\n\nGiven an index i in reverse(v), return the corresponding index in v so that v[reverseind(v,i)] == reverse(v)[i]. (This can be nontrivial in cases where v contains non-ASCII characters.)\n\nExamples\n\njulia> r = reverse(\"Julia\")\n\"ailuJ\"\n\njulia> for i in 1:length(r)\n           print(r[reverseind(\"Julia\", i)])\n       end\nJulia\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reverse!","location":"base/arrays.html#Base.reverse!","category":"function","text":"reverse!(v [, start=1 [, stop=length(v) ]]) -> v\n\nIn-place version of reverse.\n\nExamples\n\njulia> A = Vector(1:5)\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> reverse!(A);\n\njulia> A\n5-element Vector{Int64}:\n 5\n 4\n 3\n 2\n 1\n\n\n\n\n\nreverse!(A; dims=:)\n\nLike reverse, but operates in-place in A.\n\ncompat: Julia 1.6\nMultidimensional reverse! requires Julia 1.6.\n\n\n\n\n\n","page":"Arrays"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html#Julia-SSA-form-IR","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Background","location":"devdocs/ssair.html#Background","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Beginning in Julia 0.7, parts of the compiler use a new SSA-form intermediate representation. Historically, the compiler used to directly generate LLVM IR, from a lowered form of the Julia AST. This form had most syntactic abstractions removed, but still looked a lot like an abstract syntax tree. Over time, in order to facilitate optimizations, SSA values were introduced to this IR and the IR was linearized (i.e. a form where function arguments may only be SSA values or constants). However, non-SSA values (slots) remained in the IR due to the lack of Phi nodes in the IR (necessary for back-edges and re-merging of conditional control flow), negating much of the usefulness of the SSA form representation to perform middle end optimizations. Some heroic effort was put into making these optimizations work without a complete SSA form representation, but the lack of such a representation ultimately proved prohibitive.","page":"Julia SSA-form IR"},{"title":"New IR nodes","location":"devdocs/ssair.html#New-IR-nodes","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"With the new IR representation, the compiler learned to handle four new IR nodes, Phi nodes, Pi nodes as well as PhiC nodes and Upsilon nodes (the latter two are only used for exception handling).","page":"Julia SSA-form IR"},{"title":"Phi nodes and Pi nodes","location":"devdocs/ssair.html#Phi-nodes-and-Pi-nodes","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Phi nodes are part of generic SSA abstraction (see the link above if you're not familiar with the concept). In the Julia IR, these nodes are represented as:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"struct PhiNode\n    edges::Vector{Int}\n    values::Vector{Any}\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"where we ensure that both vectors always have the same length. In the canonical representation (the one handled by codegen and the interpreter), the edge values indicate come-from statement numbers (i.e. if edge has an entry of 15, there must be a goto, gotoifnot or implicit fall through from statement 15 that targets this phi node). Values are either SSA values or constants. It is also possible for a value to be unassigned if the variable was not defined on this path. However, undefinedness checks get explicitly inserted and represented as booleans after middle end optimizations, so code generators may assume that any use of a Phi node will have an assigned value in the corresponding slot. It is also legal for the mapping to be incomplete, i.e. for a Phi node to have missing incoming edges. In that case, it must be dynamically guaranteed that the corresponding value will not be used.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"PiNodes encode statically proven information that may be implicitly assumed in basic blocks dominated by a given pi node. They are conceptually equivalent to the technique introduced in the paper ABCD: Eliminating Array Bounds Checks on Demand or the predicate info nodes in LLVM. To see how they work, consider, e.g.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"%x::Union{Int, Float64} # %x is some Union{Int, Float64} typed ssa value\nif isa(x, Int)\n    # use x\nelse\n    # use x\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"We can perform predicate insertion and turn this into:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"%x::Union{Int, Float64} # %x is some Union{Int, Float64} typed ssa value\nif isa(x, Int)\n    %x_int = PiNode(x, Int)\n    # use %x_int\nelse\n    %x_float = PiNode(x, Float64)\n    # use %x_float\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Pi nodes are generally ignored in the interpreter, since they don't have any effect on the values, but they may sometimes lead to code generation in the compiler (e.g. to change from an implicitly union split representation to a plain unboxed representation). The main usefulness of PiNodes stems from the fact that path conditions of the values can be accumulated simply by def-use chain walking that is generally done for most optimizations that care about these conditions anyway.","page":"Julia SSA-form IR"},{"title":"PhiC nodes and Upsilon nodes","location":"devdocs/ssair.html#PhiC-nodes-and-Upsilon-nodes","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Exception handling complicates the SSA story moderately, because exception handling introduces additional control flow edges into the IR across which values must be tracked. One approach to do so, which is followed by LLVM is to make calls which may throw exceptions into basic block terminators and add an explicit control flow edge to the catch handler:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"invoke @function_that_may_throw() to label %regular unwind to %catch\n\nregular:\n# Control flow continues here\n\ncatch:\n# Exceptions go here","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"However, this is problematic in a language like julia where at the start of the optimization pipeline, we do not know which calls throw. We would have to conservatively assume that every call (which in julia is every statement) throws. This would have several negative effects. On the one hand, it would essentially reduce the scope of every basic block to a single call, defeating the purpose of having operations be performed at the basic block level. On the other hand, every catch basic block would have n*m phi node arguments (n, the number of statements in the critical region, m the number of live values through the catch block). To work around this, we use a combination of Upsilon and PhiC (the C standing for catch, written φᶜ in the IR pretty printer, because unicode subscript c is not available) nodes. There are several ways to think of these nodes, but perhaps the easiest is to think of each PhiC as a load from a unique store-many, read-once slot, with Upsilon being the corresponding store operation. The PhiC has an operand list of all the upsilon nodes that store to its implicit slot. The Upsilon nodes however, do not record which PhiC node they store to. This is done for more natural integration with the rest of the SSA IR. E.g. if there are no more uses of a PhiC node, it is safe to delete it, and the same is true of an Upsilon node. In most IR passes, PhiC nodes can be treated like Phi nodes. One can follow use-def chains through them, and they can be lifted to new PhiC nodes and new Upsilon nodes (in the same places as the original Upsilon nodes). The result of this scheme is that the number of Upsilon nodes (and PhiC arguments) is proportional to the number of assigned values to a particular variable (before SSA conversion), rather than the number of statements in the critical region.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"To see this scheme in action, consider the function","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"@noinline opaque() = invokelatest(identity, nothing) # Something opaque\nfunction foo()\n    local y\n    x = 1\n    try\n        y = 2\n        opaque()\n        y = 3\n        error()\n    catch\n    end\n    (x, y)\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The corresponding IR (with irrelevant types stripped) is:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"1 ─       nothing::Nothing\n2 ─ %2  = $(Expr(:enter, #4))\n3 ─ %3  = ϒ (false)\n│   %4  = ϒ (#undef)\n│   %5  = ϒ (1)\n│   %6  = ϒ (true)\n│   %7  = ϒ (2)\n│         invoke Main.opaque()::Any\n│   %9  = ϒ (true)\n│   %10 = ϒ (3)\n│         invoke Main.error()::Union{}\n└──       $(Expr(:unreachable))::Union{}\n4 ┄ %13 = φᶜ (%3, %6, %9)::Bool\n│   %14 = φᶜ (%4, %7, %10)::Core.Compiler.MaybeUndef(Int64)\n│   %15 = φᶜ (%5)::Core.Const(1)\n└──       $(Expr(:leave, 1))\n5 ─       $(Expr(:pop_exception, :(%2)))::Any\n│         $(Expr(:throw_undef_if_not, :y, :(%13)))::Any\n│   %19 = Core.tuple(%15, %14)\n└──       return %19","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Note in particular that every value live into the critical region gets an upsilon node at the top of the critical region. This is because catch blocks are considered to have an invisible control flow edge from outside the function. As a result, no SSA value dominates the catch blocks, and all incoming values have to come through a φᶜ node.","page":"Julia SSA-form IR"},{"title":"Main SSA data structure","location":"devdocs/ssair.html#Main-SSA-data-structure","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The main SSAIR data structure is worthy of discussion. It draws inspiration from LLVM and Webkit's B3 IR. The core of the data structure is a flat vector of statements. Each statement is implicitly assigned an SSA value based on its position in the vector (i.e. the result of the statement at idx 1 can be accessed using SSAValue(1) etc). For each SSA value, we additionally maintain its type. Since, SSA values are definitionally assigned only once, this type is also the result type of the expression at the corresponding index. However, while this representation is rather efficient (since the assignments don't need to be explicitly encoded), it of course carries the drawback that order is semantically significant, so reorderings and insertions change statement numbers. Additionally, we do not keep use lists (i.e. it is impossible to walk from a def to all its uses without explicitly computing this map–def lists however are trivial since you can look up the corresponding statement from the index), so the LLVM-style RAUW (replace-all-uses-with) operation is unavailable.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Instead, we do the following:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"We keep a separate buffer of nodes to insert (including the position to insert them at, the type of the corresponding value and the node itself). These nodes are numbered by their occurrence in the insertion buffer, allowing their values to be immediately used elsewhere in the IR (i.e. if there are 12 statements in the original statement list, the first new statement will be accessible as SSAValue(13)).\nRAUW style operations are performed by setting the corresponding statement index to the replacement value.\nStatements are erased by setting the corresponding statement to nothing (this is essentially just a special-case convention of the above.\nIf there are any uses of the statement being erased, they will be set to nothing.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"There is a compact! function that compacts the above data structure by performing the insertion of nodes in the appropriate place, trivial copy propagation, and renaming of uses to any changed SSA values. However, the clever part of this scheme is that this compaction can be done lazily as part of the subsequent pass. Most optimization passes need to walk over the entire list of statements, performing analysis or modifications along the way. We provide an IncrementalCompact iterator that can be used to iterate over the statement list. It will perform any necessary compaction and return the new index of the node, as well as the node itself. It is legal at this point to walk def-use chains, as well as make any modifications or deletions to the IR (insertions are disallowed however).","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The idea behind this arrangement is that, since the optimization passes need to touch the corresponding memory anyway and incur the corresponding memory access penalty, performing the extra housekeeping should have comparatively little overhead (and save the overhead of maintaining these data structures during IR modification).","page":"Julia SSA-form IR"},{"title":"StackTraces","location":"base/stacktraces.html#StackTraces","category":"section","text":"","page":"StackTraces"},{"title":"StackTraces","location":"base/stacktraces.html","category":"page","text":"Base.StackTraces.StackFrame\nBase.StackTraces.StackTrace\nBase.StackTraces.stacktrace","page":"StackTraces"},{"title":"Base.StackTraces.StackFrame","location":"base/stacktraces.html#Base.StackTraces.StackFrame","category":"type","text":"StackFrame\n\nStack information representing execution context, with the following fields:\n\nfunc::Symbol\nThe name of the function containing the execution context.\nlinfo::Union{Core.MethodInstance, CodeInfo, Nothing}\nThe MethodInstance containing the execution context (if it could be found).\nfile::Symbol\nThe path to the file containing the execution context.\nline::Int\nThe line number in the file containing the execution context.\nfrom_c::Bool\nTrue if the code is from C.\ninlined::Bool\nTrue if the code is from an inlined frame.\npointer::UInt64\nRepresentation of the pointer to the execution context as returned by backtrace.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Base.StackTraces.StackTrace","location":"base/stacktraces.html#Base.StackTraces.StackTrace","category":"type","text":"StackTrace\n\nAn alias for Vector{StackFrame} provided for convenience; returned by calls to stacktrace.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Base.StackTraces.stacktrace","location":"base/stacktraces.html#Base.StackTraces.stacktrace","category":"function","text":"stacktrace([trace::Vector{Ptr{Cvoid}},] [c_funcs::Bool=false]) -> StackTrace\n\nReturns a stack trace in the form of a vector of StackFrames. (By default stacktrace doesn't return C functions, but this can be enabled.) When called without specifying a trace, stacktrace first calls backtrace.\n\n\n\n\n\n","page":"StackTraces"},{"title":"StackTraces","location":"base/stacktraces.html","category":"page","text":"The following methods and types in Base.StackTraces are not exported and need to be called e.g. as StackTraces.lookup(ptr).","page":"StackTraces"},{"title":"StackTraces","location":"base/stacktraces.html","category":"page","text":"Base.StackTraces.lookup\nBase.StackTraces.remove_frames!","page":"StackTraces"},{"title":"Base.StackTraces.lookup","location":"base/stacktraces.html#Base.StackTraces.lookup","category":"function","text":"lookup(pointer::Ptr{Cvoid}) -> Vector{StackFrame}\n\nGiven a pointer to an execution context (usually generated by a call to backtrace), looks up stack frame context information. Returns an array of frame information for all functions inlined at that point, innermost function first.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Base.StackTraces.remove_frames!","location":"base/stacktraces.html#Base.StackTraces.remove_frames!","category":"function","text":"remove_frames!(stack::StackTrace, name::Symbol)\n\nTakes a StackTrace (a vector of StackFrames) and a function name (a Symbol) and removes the StackFrame specified by the function name from the StackTrace (also removing all frames above the specified function). Primarily used to remove StackTraces functions from the StackTrace prior to returning it.\n\n\n\n\n\nremove_frames!(stack::StackTrace, m::Module)\n\nReturns the StackTrace with all StackFrames from the provided Module removed.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Julia Functions","location":"devdocs/functions.html#Julia-Functions","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This document will explain how functions, method definitions, and method tables work.","page":"Julia Functions"},{"title":"Method Tables","location":"devdocs/functions.html#Method-Tables","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Every function in Julia is a generic function. A generic function is conceptually a single function, but consists of many definitions, or methods. The methods of a generic function are stored in a method table. Method tables (type MethodTable) are associated with TypeNames. A TypeName describes a family of parameterized types. For example Complex{Float32} and Complex{Float64} share the same Complex type name object.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"All objects in Julia are potentially callable, because every object has a type, which in turn has a TypeName.","page":"Julia Functions"},{"title":"Function calls","location":"devdocs/functions.html#Function-calls","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Given the call f(x,y), the following steps are performed: first, the method table to use is accessed as typeof(f).name.mt. Second, an argument tuple type is formed, Tuple{typeof(f), typeof(x), typeof(y)}. Note that the type of the function itself is the first element. This is because the type might have parameters, and so needs to take part in dispatch. This tuple type is looked up in the method table.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This dispatch process is performed by jl_apply_generic, which takes two arguments: a pointer to an array of the values f, x, and y, and the number of values (in this case 3).","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Throughout the system, there are two kinds of APIs that handle functions and argument lists: those that accept the function and arguments separately, and those that accept a single argument structure. In the first kind of API, the \"arguments\" part does not contain information about the function, since that is passed separately. In the second kind of API, the function is the first element of the argument structure.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"For example, the following function for performing a call accepts just an args pointer, so the first element of the args array will be the function to call:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"jl_value_t *jl_apply(jl_value_t **args, uint32_t nargs)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This entry point for the same functionality accepts the function separately, so the args array does not contain the function:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"jl_value_t *jl_call(jl_function_t *f, jl_value_t **args, int32_t nargs);","page":"Julia Functions"},{"title":"Adding methods","location":"devdocs/functions.html#Adding-methods","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Given the above dispatch process, conceptually all that is needed to add a new method is (1) a tuple type, and (2) code for the body of the method. jl_method_def implements this operation. jl_first_argument_datatype is called to extract the relevant method table from what would be the type of the first argument. This is much more complicated than the corresponding procedure during dispatch, since the argument tuple type might be abstract. For example, we can define:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"(::Union{Foo{Int},Foo{Int8}})(x) = 0","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"which works since all possible matching methods would belong to the same method table.","page":"Julia Functions"},{"title":"Creating generic functions","location":"devdocs/functions.html#Creating-generic-functions","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Since every object is callable, nothing special is needed to create a generic function. Therefore jl_new_generic_function simply creates a new singleton (0 size) subtype of Function and returns its instance. A function can have a mnemonic \"display name\" which is used in debug info and when printing objects. For example the name of Base.sin is sin. By convention, the name of the created type is the same as the function name, with a # prepended. So typeof(sin) is Base.#sin.","page":"Julia Functions"},{"title":"Closures","location":"devdocs/functions.html#Closures","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"A closure is simply a callable object with field names corresponding to captured variables. For example, the following code:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function adder(x)\n    return y->x+y\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"is lowered to (roughly):","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"struct ##1{T}\n    x::T\nend\n\n(_::##1)(y) = _.x + y\n\nfunction adder(x)\n    return ##1(x)\nend","page":"Julia Functions"},{"title":"Constructors","location":"devdocs/functions.html#Constructors","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"A constructor call is just a call to a type. The method table for Type contains all constructor definitions. All subtypes of Type (Type, UnionAll, Union, and DataType) currently share a method table via special arrangement.","page":"Julia Functions"},{"title":"Builtins","location":"devdocs/functions.html#Builtins","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The \"builtin\" functions, defined in the Core module, are:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"=== typeof sizeof <: isa typeassert throw tuple getfield setfield! fieldtype\nnfields isdefined arrayref arrayset arraysize applicable invoke apply_type _apply\n_expr svec","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"These are all singleton objects whose types are subtypes of Builtin, which is a subtype of Function. Their purpose is to expose entry points in the run time that use the \"jlcall\" calling convention:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"jl_value_t *(jl_value_t*, jl_value_t**, uint32_t)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The method tables of builtins are empty. Instead, they have a single catch-all method cache entry (Tuple{Vararg{Any}}) whose jlcall fptr points to the correct function. This is kind of a hack but works reasonably well.","page":"Julia Functions"},{"title":"Keyword arguments","location":"devdocs/functions.html#Keyword-arguments","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Keyword arguments work by associating a special, hidden function object with each method table that has definitions with keyword arguments. This function is called the \"keyword argument sorter\" or \"keyword sorter\", or \"kwsorter\", and is stored in the kwsorter field of MethodTable objects. Every definition in the kwsorter function has the same arguments as some definition in the normal method table, except with a single NamedTuple argument prepended, which gives the names and values of passed keyword arguments. The kwsorter's job is to move keyword arguments into their canonical positions based on name, plus evaluate and substitute any needed default value expressions. The result is a normal positional argument list, which is then passed to yet another compiler-generated function.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The easiest way to understand the process is to look at how a keyword argument method definition is lowered. The code:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function circle(center, radius; color = black, fill::Bool = true, options...)\n    # draw\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"actually produces three method definitions. The first is a function that accepts all arguments (including keyword arguments) as positional arguments, and includes the code for the method body. It has an auto-generated name:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function #circle#1(color, fill::Bool, options, circle, center, radius)\n    # draw\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The second method is an ordinary definition for the original circle function, which handles the case where no keyword arguments are passed:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function circle(center, radius)\n    #circle#1(black, true, pairs(NamedTuple()), circle, center, radius)\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This simply dispatches to the first method, passing along default values. pairs is applied to the named tuple of rest arguments to provide key-value pair iteration. Note that if the method doesn't accept rest keyword arguments then this argument is absent.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Finally there is the kwsorter definition:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function (::Core.kwftype(typeof(circle)))(kws, circle, center, radius)\n    if haskey(kws, :color)\n        color = kws.color\n    else\n        color = black\n    end\n    # etc.\n\n    # put remaining kwargs in `options`\n    options = structdiff(kws, NamedTuple{(:color, :fill)})\n\n    # if the method doesn't accept rest keywords, throw an error\n    # unless `options` is empty\n\n    #circle#1(color, fill, pairs(options), circle, center, radius)\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The function Core.kwftype(t) creates the field t.name.mt.kwsorter (if it hasn't been created yet), and returns the type of that function.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This design has the feature that call sites that don't use keyword arguments require no special handling; everything works as if they were not part of the language at all. Call sites that do use keyword arguments are dispatched directly to the called function's kwsorter. For example the call:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"circle((0,0), 1.0, color = red; other...)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"is lowered to:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"kwfunc(circle)(merge((color = red,), other), circle, (0,0), 1.0)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"kwfunc (also inCore) fetches the kwsorter for the called function. The keyword splatting operation (written as other...) calls the named tuple merge function. This function further unpacks each element of other, expecting each one to contain two values (a symbol and a value). Naturally, a more efficient implementation is available if all splatted arguments are named tuples. Notice that the original circle function is passed through, to handle closures.","page":"Julia Functions"},{"title":"Compiler efficiency issues","location":"devdocs/functions.html#compiler-efficiency-issues","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Generating a new type for every function has potentially serious consequences for compiler resource use when combined with Julia's \"specialize on all arguments by default\" design. Indeed, the initial implementation of this design suffered from much longer build and test times, higher memory use, and a system image nearly 2x larger than the baseline. In a naive implementation, the problem is bad enough to make the system nearly unusable. Several significant optimizations were needed to make the design practical.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The first issue is excessive specialization of functions for different values of function-valued arguments. Many functions simply \"pass through\" an argument to somewhere else, e.g. to another function or to a storage location. Such functions do not need to be specialized for every closure that might be passed in. Fortunately this case is easy to distinguish by simply considering whether a function calls one of its arguments (i.e. the argument appears in \"head position\" somewhere). Performance-critical higher-order functions like map certainly call their argument function and so will still be specialized as expected. This optimization is implemented by recording which arguments are called during the analyze-variables pass in the front end. When cache_method sees an argument in the Function type hierarchy passed to a slot declared as Any or Function, it behaves as if the @nospecialize annotation were applied. This heuristic seems to be extremely effective in practice.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The next issue concerns the structure of method cache hash tables. Empirical studies show that the vast majority of dynamically-dispatched calls involve one or two arguments. In turn, many of these cases can be resolved by considering only the first argument. (Aside: proponents of single dispatch would not be surprised by this at all. However, this argument means \"multiple dispatch is easy to optimize in practice\", and that we should therefore use it, not \"we should use single dispatch\"!) So the method cache uses the type of the first argument as its primary key. Note, however, that this corresponds to the second element of the tuple type for a function call (the first element being the type of the function itself). Typically, type variation in head position is extremely low – indeed, the majority of functions belong to singleton types with no parameters. However, this is not the case for constructors, where a single method table holds constructors for every type. Therefore the Type method table is special-cased to use the first tuple type element instead of the second.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The front end generates type declarations for all closures. Initially, this was implemented by generating normal type declarations. However, this produced an extremely large number of constructors, all of which were trivial (simply passing all arguments through to new). Since methods are partially ordered, inserting all of these methods is O(n^2), plus there are just too many of them to keep around. This was optimized by generating struct_type expressions directly (bypassing default constructor generation), and using new directly to create closure instances. Not the prettiest thing ever, but you do what you gotta do.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The next problem was the @test macro, which generated a 0-argument closure for each test case. This is not really necessary, since each test case is simply run once in place. Therefore, @test was modified to expand to a try-catch block that records the test result (true, false, or exception raised) and calls the test suite handler on it.","page":"Julia Functions"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/NEWS.md\"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html#Julia-v1.6-Release-Notes","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"New language features","location":"NEWS.html#New-language-features","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Types written with where syntax can now be used to define constructors, e.g. (Foo{T} where T)(x) = ....\n<-- and <--> are now available as infix operators, with the same precedence and associativity as other arrow-like operators (#36666).\nCompilation and type inference can now be enabled or disabled at the module level using the experimental macro Base.Experimental.@compiler_options (#37041).\nThe library name passed to ccall or @ccall can now be an expression involving global variables and function calls. The expression will be evaluated the first time the ccall executes (#36458).\nꜛ (U+A71B), ꜜ (U+A71C) and ꜝ (U+A71D) can now also be used as operator suffixes. They can be tab-completed from \\^uparrow, \\^downarrow and \\^! in the REPL (#37542).\nStandalone \"dotted\" operators now get parsed as Expr(:., :op), which gets lowered to Base.BroadcastFunction(op). This means .op is functionally equivalent to (x...) -> (op).(x...), which can be useful for passing the broadcasted version of an operator to higher-order functions, for example map(.*, A, B) for an elementwise product of two arrays of arrays (#37583).\nThe syntax import A as B (plus import A: x as y, import A.x as y, and using A: x as y) can now be used to rename imported modules and identifiers (#1255).\nUnsigned literals (starting with 0x) which are too big to fit in a UInt128 object are now interpreted as BigInt (#23546).\nIt is now possible to use ... on the left-hand side of assignments for taking any number of items from the front of an iterable collection, while also collecting the rest, for example a, b... = [1, 2, 3]. This syntax is implemented using Base.rest, which can be overloaded to customize its behavior for different collection types (#37410).","page":"Julia v1.6 Release Notes"},{"title":"Language changes","location":"NEWS.html#Language-changes","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"The postfix conjugate transpose operator ' now accepts Unicode modifiers as suffixes, so e.g. a'ᵀ is parsed as var\"'ᵀ\"(a), which can be defined by the user. a'ᵀ parsed as a' * ᵀ before, so this is a minor breaking change (#37247).\nMacros that return :quote expressions (e.g. via Expr(:quote, ...)) were previously able to work without escaping (esc(...)) their output when needed. This has been corrected, and now esc must be used in these macros as it is in other macros (#37540).\nThe --> operator now lowers to a :call expression, so it can be defined as a function like other operators. The dotted version .--> is now parsed as well. For backwards compatibility, --> still parses using its own expression head instead of :call.\nThe a[begin, k] syntax now calls firstindex(a, 1) rather than first(axes(a, 1)) (#35779), but the former now defaults to the latter for any a (#38742).\n⌿ (U+233F) and ¦ (U+00A6) are now infix operators with times-like and plus-like precedence, respectively. Previously they were parsed as identifier characters (#37973).","page":"Julia v1.6 Release Notes"},{"title":"Compiler/Runtime improvements","location":"NEWS.html#Compiler/Runtime-improvements","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"All platforms can now use @executable_path within jl_load_dynamic_library(). This allows executable-relative paths to be embedded within executables on all platforms, not just MacOS, which the syntax is borrowed from (#35627).\nConstant propagation now occurs through keyword arguments (#35976).\nThe precompilation cache is now created atomically (#36416). Invoking n Julia processes simultaneously may create n temporary caches.","page":"Julia v1.6 Release Notes"},{"title":"Command-line option changes","location":"NEWS.html#Command-line-option-changes","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"There is no longer a concept of \"home project\": starting julia --project=dir is now exactly equivalent to starting julia and then doing pkg> activate $dir and julia --project is exactly equivalent to doing that where dir = Base.current_project(). In particular, this means that if you do pkg> activate after starting julia with the --project option (or with JULIA_PROJECT set) it will take you to the default active project, which is @v1.6 unless you have modified LOAD_PATH (#36434).","page":"Julia v1.6 Release Notes"},{"title":"Multi-threading changes","location":"NEWS.html#Multi-threading-changes","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Locks now automatically inhibit finalizers from running, to avoid deadlock (#38487).\nNew function Base.Threads.foreach(f, channel::Channel) for multithreaded Channel consumption (#34543).\nThere is no longer a restriction on the number of threads (#36778).","page":"Julia v1.6 Release Notes"},{"title":"Build system changes","location":"NEWS.html#Build-system-changes","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Windows Installer now has the option to 'Add Julia to Path'. To unselect this option from the commandline simply remove the tasks you do not want to be installed: e.g. ./julia-installer.exe /TASKS=\"desktopicon,startmenu,addtopath\", adds a desktop icon, a startmenu group icon, and adds Julia to system PATH.","page":"Julia v1.6 Release Notes"},{"title":"New library functions","location":"NEWS.html#New-library-functions","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"New function Base.kron! and corresponding overloads for various matrix types for performing Kronecker product in-place (#31069).\nNew function Base.readeach(io, T) for iteratively performing read(io, T) (#36150).\nIterators.map is added. It provides another syntax Iterators.map(f, iterators...) for writing (f(args...) for args in zip(iterators...)), i.e. a lazy map (#34352).\nNew function sincospi for simultaneously computing sinpi(x) and cospi(x) more efficiently (#35816).\nNew function cispi(x) for more accurately computing cis(pi * x) (#38449).\nNew function addenv for adding environment mappings into a Cmd object, returning the new Cmd object.\nNew function insorted for determining whether an element is in a sorted collection or not (#37490).\nNew function Base.rest for taking the rest of a collection, starting from a specific iteration state, in a generic way (#37410).","page":"Julia v1.6 Release Notes"},{"title":"New library features","location":"NEWS.html#New-library-features","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"The redirect_* functions now accept devnull to discard all output redirected to it, and as an empty input (#36146).\nThe redirect_* functions can now be called on IOContext objects (#36688).\nfindfirst, findnext, findlast, and findall now support AbstractVector{<:Union{Int8,UInt8}} (pattern, array) arguments (#37283).\nNew constructor NamedTuple(iterator) that constructs a named tuple from a key-value pair iterator.\nA new reinterpret(reshape, T, a::AbstractArray{S}) reinterprets a to have eltype T while potentially inserting or consuming the first dimension depending on the ratio of sizeof(T) and sizeof(S).\nNew append!(vector, collections...) and prepend!(vector, collections...) methods accept multiple collections to be appended or prepended (#36227).\nThe postfix operator 'ᵀ can now be used as an alias for transpose (#38062).\nkeys(io::IO) has been added, which returns all keys of io if io is an IOContext and an empty Base.KeySet otherwise (#37753).\ncount now accepts an optional init argument to control the accumulation type (#37461).\nNew method occursin(haystack) that returns a function that checks whether its argument occurs in haystack (#38475).\nNew methods ∉(collection), ∋(item), and ∌(item) returning corresponding containment-testing functions (#38475).\nThe nextprod function now accepts tuples and other array types for its first argument (#35791).\nThe reverse(A; dims) function for multidimensional A can now reverse multiple dimensions at once by passing a tuple for dims, and defaults to reversing all dimensions; there is also a multidimensional in-place reverse!(A; dims) (#37367).\nThe function isapprox(x,y) now accepts the norm keyword argument also for numeric (i.e., non-array) arguments x and y (#35883).\nispow2(x) now supports non-Integer arguments x (#37635).\nview, @view, and @views now work on AbstractStrings, returning a SubString when appropriate (#35879).\nAll AbstractUnitRange{<:Integer}s now work with SubString, view, @view and @views on strings (#35879).\nsum, prod, maximum, and minimum now support init keyword argument (#36188, #35839).\nunique(f, itr; seen=Set{T}()) now allows you to declare the container type used for keeping track of values returned by f on elements of itr (#36280).\nfirst and last functions now accept an integer as second argument to get that many leading or trailing elements of any iterable (#34868).\nCartesianIndices now supports step different from 1. It can also be constructed from three CartesianIndexes I, S, J using I:S:J. step for CartesianIndices now returns a CartesianIndex (#37829).\nRegexMatch objects can now be probed for whether a named capture group exists within it through haskey() (#36717).\nFor consistency haskey(r::RegexMatch, i::Integer) has also been added and returns if the capture group for i exists (#37300).","page":"Julia v1.6 Release Notes"},{"title":"Standard library changes","location":"NEWS.html#Standard-library-changes","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"A new standard library TOML has been added for parsing and printing TOML files (#37034).\nA new standard library Downloads has been added, which replaces the old Base.download function with Downloads.download, providing cross-platform, multi-protocol, in-process download functionality implemented with libcurl (#37340).\nLibdl has been moved to Base.Libc.Libdl, however it is still accessible as an stdlib (#35628).\nTo download artifacts lazily, LazyArtifacts now must be explicitly listed as a dependency, to avoid needing the support machinery to be available when it is not commonly needed (#37844).\nIt is no longer possible to create a LinRange, StepRange, or StepRangeLen with a <: Integer eltype but non-integer step (#32439).\nintersect on CartesianIndices now returns CartesianIndices instead of Vector{<:CartesianIndex} (#36643).\npush!(c::Channel, v) now returns channel c. Previously, it returned the pushed value v (#34202).\nThe composition operator ∘ now returns a Base.ComposedFunction instead of an anonymous function (#37517).\nLogging (such as @warn) no longer catches exceptions in the logger itself (#36600).\n@time now reports if the time presented included any compilation time, which is shown as a percentage (#37678).\n@varinfo can now report non-exported objects within modules, look recursively into submodules, and return a sorted results table (#38042).\n@testset now supports the option verbose to show the test result summary of the children even if they all pass (#33755).","page":"Julia v1.6 Release Notes"},{"title":"Package Manager","location":"NEWS.html#Package-Manager","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"pkg> precompile is now parallelized through depth-first precompilation of dependencies. Errors will only throw for direct dependencies listed in the Project.toml.\npkg> precompile is now automatically triggered whenever Pkg changes the active manifest. Auto-precompilation will remember if a package has errored within the given environment and will not retry until it changes. Auto-precompilation can be gracefully interrupted with a ctrl-c and disabled by setting the environment variable JULIA_PKG_PRECOMPILE_AUTO=0.\nThe Pkg.BinaryPlatforms module has been moved into Base as Base.BinaryPlatforms and heavily reworked. Applications that want to be compatible with the old API should continue to import Pkg.BinaryPlatforms, however new users should use Base.BinaryPlatforms directly (#37320).\nThe Pkg.Artifacts module has been imported as a separate standard library.  It is still available as Pkg.Artifacts, however starting from Julia v1.6+, packages may import simply Artifacts without importing all of Pkg alongside (#37320).","page":"Julia v1.6 Release Notes"},{"title":"LinearAlgebra","location":"NEWS.html#LinearAlgebra","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"New method LinearAlgebra.issuccess(::CholeskyPivoted) for checking whether pivoted Cholesky factorization was successful (#36002).\nUniformScaling can now be indexed into using ranges to return dense matrices and vectors (#24359).\nNew function LinearAlgebra.BLAS.get_num_threads() for getting the number of BLAS threads (#36360).\n(+)(::UniformScaling) is now defined, making +I a valid unary operation (#36784).\nInstances of UniformScaling are no longer isequal to matrices. Previous behaviour violated the rule that isequal(x, y) implies hash(x) == hash(y).\nTransposing *Triangular matrices now returns matrices of the opposite triangular type, consistently with adjoint!(::*Triangular) and transpose!(::*Triangular). Packages containing methods with, e.g., Adjoint{<:Any,<:LowerTriangular{<:Any,<:OwnMatrixType}} should replace that by UpperTriangular{<:Any,<:Adjoint{<:Any,<:OwnMatrixType}} in the method signature (#38168).","page":"Julia v1.6 Release Notes"},{"title":"Markdown","location":"NEWS.html#Markdown","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Printf","location":"NEWS.html#Printf","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Complete overhaul of internal code to use the ryu float printing algorithms (from Julia 1.4); leads to consistent 2-5x performance improvements.\nNew Printf.tofloat function allowing custom float types to more easily integrate with Printf formatting by converting their type to Float16, Float32, Float64, or BigFloat.\nNew Printf.format\"...\" and Printf.Format(...) functions that allow creating Printf.Format objects that can be passed to Printf.format for easier dynamic printf formatting.\nPrintf.format(f::Printf.Format, args...) as a non-macro function that applies a printf format f to provided args.","page":"Julia v1.6 Release Notes"},{"title":"Random","location":"NEWS.html#Random","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"REPL","location":"NEWS.html#REPL","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"The AbstractMenu extension interface of REPL.TerminalMenus has been extensively overhauled. The new interface does not rely on global configuration variables, is more consistent in delegating printing of the navigation/selection markers, and provides improved support for dynamic menus.  These changes are compatible with the previous (deprecated) interface, so are non-breaking.\nThe new API offers several enhancements:\nMenus are configured in their constructors via keyword arguments.\nFor custom menu types, the new Config and MultiSelectConfig replace the global CONFIG Dict.\nrequest(menu; cursor=1) allows you to control the initial cursor position in the menu (defaults to first item).\nMultiSelectMenu allows you to pass a list of initially-selected items with the selected keyword argument.\nwriteLine was deprecated to writeline, and writeline methods are not expected to print the cursor indicator. The old writeLine continues to work, and any of its method extensions should print the cursor indicator as before.\nprintMenu has been deprecated to printmenu, and it both accepts a state input and returns a state output that controls the number of terminal lines erased when the menu is next refreshed. This plus related changes makes printmenu work properly when the number of menu items might change depending on user choices.\nnumoptions, returning the number of items in the menu, has been added as an alternative to implementing options.\nsuppress_output (primarily a testing option) has been added as a keyword argument to request, rather than a configuration option.\nTab completion now supports runs of consecutive sub/superscript characters, e.g. \\^(3) tab-completes to ⁽³⁾ (#38649).\nWindows REPL now supports 24-bit colors, by correctly interpreting virtual terminal escapes.","page":"Julia v1.6 Release Notes"},{"title":"SparseArrays","location":"NEWS.html#SparseArrays","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Display large sparse matrices with a Unicode \"spy\" plot of their nonzero patterns, and display small sparse matrices by an Matrix-like 2d layout of their contents (#33821).\nNew convenient spdiagm([m, n,] v::AbstractVector) methods which call spdiagm([m, n,] 0 => v), consistently with their dense diagm counterparts (#37684).","page":"Julia v1.6 Release Notes"},{"title":"Dates","location":"NEWS.html#Dates","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Quarter period is defined (#35519).\ncanonicalize can now take Period as an input (#37391).\nZero-valued FixedPeriods and OtherPeriods now compare equal, e.g., Year(0) == Day(0). The behavior of non-zero Periods is not changed (#37486).","page":"Julia v1.6 Release Notes"},{"title":"Statistics","location":"NEWS.html#Statistics","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Sockets","location":"NEWS.html#Sockets","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Distributed","location":"NEWS.html#Distributed","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Now supports invoking Windows workers via ssh (via new keyword argument shell=:wincmd in addprocs) (#30614).\nOther new keyword arguments in addprocs: ssh to specify the ssh client path, env to pass environment variables to workers, and cmdline_cookie to work around an ssh problem with Windows workers that run older (pre-ConPTY) versions of Windows, Julia or OpenSSH (#30614).","page":"Julia v1.6 Release Notes"},{"title":"UUIDs","location":"NEWS.html#UUIDs","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"Change uuid1 and uuid4 to use Random.RandomDevice() as default random number generator (#35872).\nAdded parse(::Type{UUID}, ::AbstractString) method.","page":"Julia v1.6 Release Notes"},{"title":"Mmap","location":"NEWS.html#Mmap","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"On Unix systems, the Mmap.madvise! function (along with OS-specific Mmap.MADV_* constants) has been added to give advice on handling of memory-mapped arrays (#37369).","page":"Julia v1.6 Release Notes"},{"title":"Deprecated or removed","location":"NEWS.html#Deprecated-or-removed","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Julia v1.6 Release Notes","location":"NEWS.html","category":"page","text":"The Base.download function has been deprecated (silently, by default) in favor of the new Downloads.download standard library function (#37340).\nThe Base.Grisu code has been officially removed (float printing was switched to the ryu algorithm code in 1.4). The code is available from JuliaAttic if needed.","page":"Julia v1.6 Release Notes"},{"title":"External dependencies","location":"NEWS.html#External-dependencies","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Tooling Improvements","location":"NEWS.html#Tooling-Improvements","category":"section","text":"","page":"Julia v1.6 Release Notes"},{"title":"Environment Variables","location":"manual/environment-variables.html#Environment-Variables","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Julia can be configured with a number of environment variables, set either in the usual way for each operating system, or in a portable way from within Julia. Supposing that you want to set the environment variable JULIA_EDITOR to vim, you can type ENV[\"JULIA_EDITOR\"] = \"vim\" (for instance, in the REPL) to make this change on a case by case basis, or add the same to the user configuration file ~/.julia/config/startup.jl in the user's home directory to have a permanent effect. The current value of the same environment variable can be determined by evaluating ENV[\"JULIA_EDITOR\"].","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The environment variables that Julia uses generally start with JULIA. If InteractiveUtils.versioninfo is called with the keyword verbose=true, then the output will list any defined environment variables relevant for Julia, including those which include JULIA in their names.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nSome variables, such as JULIA_NUM_THREADS and JULIA_PROJECT, need to be set before Julia starts, therefore adding these to ~/.julia/config/startup.jl is too late in the startup process. In Bash, environment variables can either be set manually by running, e.g., export JULIA_NUM_THREADS=4 before starting Julia, or by adding the same command to ~/.bashrc or ~/.bash_profile to set the variable each time Bash is started.","page":"Environment Variables"},{"title":"File locations","location":"manual/environment-variables.html#File-locations","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_BINDIR","location":"manual/environment-variables.html#JULIA_BINDIR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The absolute path of the directory containing the Julia executable, which sets the global variable Sys.BINDIR. If $JULIA_BINDIR is not set, then Julia determines the value Sys.BINDIR at run-time.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The executable itself is one of","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_BINDIR/julia\n$JULIA_BINDIR/julia-debug","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"by default.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The global variable Base.DATAROOTDIR determines a relative path from Sys.BINDIR to the data directory associated with Julia. Then the path","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_BINDIR/$DATAROOTDIR/julia/base","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"determines the directory in which Julia initially searches for source files (via Base.find_source_file()).","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Likewise, the global variable Base.SYSCONFDIR determines a relative path to the configuration file directory. Then Julia searches for a startup.jl file at","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_BINDIR/$SYSCONFDIR/julia/startup.jl\n$JULIA_BINDIR/../etc/julia/startup.jl","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"by default (via Base.load_julia_startup()).","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"For example, a Linux installation with a Julia executable located at /bin/julia, a DATAROOTDIR of ../share, and a SYSCONFDIR of ../etc will have JULIA_BINDIR set to /bin, a source-file search path of","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"/share/julia/base","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"and a global configuration search path of","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"/etc/julia/startup.jl","page":"Environment Variables"},{"title":"JULIA_PROJECT","location":"manual/environment-variables.html#JULIA_PROJECT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"A directory path that indicates which project should be the initial active project. Setting this environment variable has the same effect as specifying the --project start-up option, but --project has higher precedence. If the variable is set to @. then Julia tries to find a project directory that contains Project.toml or JuliaProject.toml file from the current directory and its parents. See also the chapter on Code Loading.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nJULIA_PROJECT must be defined before starting julia; defining it in startup.jl is too late in the startup process.","page":"Environment Variables"},{"title":"JULIA_LOAD_PATH","location":"manual/environment-variables.html#JULIA_LOAD_PATH","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The JULIA_LOAD_PATH environment variable is used to populate the global Julia LOAD_PATH variable, which determines which packages can be loaded via import and using (see Code Loading).","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Unlike the shell PATH variable, empty entries in JULIA_LOAD_PATH are expanded to the default value of LOAD_PATH, [\"@\", \"@v#.#\", \"@stdlib\"] when populating LOAD_PATH. This allows easy appending, prepending, etc. of the load path value in shell scripts regardless of whether JULIA_LOAD_PATH is already set or not. For example, to prepend the directory /foo/bar to LOAD_PATH just do","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"export JULIA_LOAD_PATH=\"/foo/bar:$JULIA_LOAD_PATH\"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If the JULIA_LOAD_PATH environment variable is already set, its old value will be prepended with /foo/bar. On the other hand, if JULIA_LOAD_PATH is not set, then it will be set to /foo/bar: which will expand to a LOAD_PATH value of [\"/foo/bar\", \"@\", \"@v#.#\", \"@stdlib\"]. If JULIA_LOAD_PATH is set to the empty string, it expands to an empty LOAD_PATH array. In other words, the empty string is interpreted as a zero-element array, not a one-element array of the empty string. This behavior was chosen so that it would be possible to set an empty load path via the environment variable. If you want the default load path, either unset the environment variable or if it must have a value, set it to the string :.","page":"Environment Variables"},{"title":"JULIA_DEPOT_PATH","location":"manual/environment-variables.html#JULIA_DEPOT_PATH","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The JULIA_DEPOT_PATH environment variable is used to populate the global Julia DEPOT_PATH variable, which controls where the package manager, as well as Julia's code loading mechanisms, look for package registries, installed packages, named environments, repo clones, cached compiled package images, configuration files, and the default location of the REPL's history file.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Unlike the shell PATH variable but similar to JULIA_LOAD_PATH, empty entries in JULIA_DEPOT_PATH are expanded to the default value of DEPOT_PATH. This allows easy appending, prepending, etc. of the depot path value in shell scripts regardless of whether JULIA_DEPOT_PATH is already set or not. For example, to prepend the directory /foo/bar to DEPOT_PATH just do","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"export JULIA_DEPOT_PATH=\"/foo/bar:$JULIA_DEPOT_PATH\"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If the JULIA_DEPOT_PATH environment variable is already set, its old value will be prepended with /foo/bar. On the other hand, if JULIA_DEPOT_PATH is not set, then it will be set to /foo/bar: which will have the effect of prepending /foo/bar to the default depot path. If JULIA_DEPOT_PATH is set to the empty string, it expands to an empty DEPOT_PATH array. In other words, the empty string is interpreted as a zero-element array, not a one-element array of the empty string. This behavior was chosen so that it would be possible to set an empty depot path via the environment variable. If you want the default depot path, either unset the environment variable or if it must have a value, set it to the string :.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nOn Windows, path elements are separated by the ; character, as is the case with most path lists on Windows.","page":"Environment Variables"},{"title":"JULIA_HISTORY","location":"manual/environment-variables.html#JULIA_HISTORY","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The absolute path REPL.find_hist_file() of the REPL's history file. If $JULIA_HISTORY is not set, then REPL.find_hist_file() defaults to","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$(DEPOT_PATH[1])/logs/repl_history.jl","page":"Environment Variables"},{"title":"External applications","location":"manual/environment-variables.html#External-applications","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_SHELL","location":"manual/environment-variables.html#JULIA_SHELL","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The absolute path of the shell with which Julia should execute external commands (via Base.repl_cmd()). Defaults to the environment variable $SHELL, and falls back to /bin/sh if $SHELL is unset.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nOn Windows, this environment variable is ignored, and external commands are executed directly.","page":"Environment Variables"},{"title":"JULIA_EDITOR","location":"manual/environment-variables.html#JULIA_EDITOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The editor returned by InteractiveUtils.editor() and used in, e.g., InteractiveUtils.edit, referring to the command of the preferred editor, for instance vim.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_EDITOR takes precedence over $VISUAL, which in turn takes precedence over $EDITOR. If none of these environment variables is set, then the editor is taken to be open on Windows and OS X, or /etc/alternatives/editor if it exists, or emacs otherwise.","page":"Environment Variables"},{"title":"Parallelization","location":"manual/environment-variables.html#Parallelization","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_CPU_THREADS","location":"manual/environment-variables.html#JULIA_CPU_THREADS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Overrides the global variable Base.Sys.CPU_THREADS, the number of logical CPU cores available.","page":"Environment Variables"},{"title":"JULIA_WORKER_TIMEOUT","location":"manual/environment-variables.html#JULIA_WORKER_TIMEOUT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"A Float64 that sets the value of Distributed.worker_timeout() (default: 60.0). This function gives the number of seconds a worker process will wait for a master process to establish a connection before dying.","page":"Environment Variables"},{"title":"JULIA_NUM_THREADS","location":"manual/environment-variables.html#JULIA_NUM_THREADS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"An unsigned 64-bit integer (uint64_t) that sets the maximum number of threads available to Julia. If $JULIA_NUM_THREADS is not positive or is not set, or if the number of CPU threads cannot be determined through system calls, then the number of threads is set to 1.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nJULIA_NUM_THREADS must be defined before starting julia; defining it in startup.jl is too late in the startup process.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.5\nIn Julia 1.5 and above the number of threads can also be specified on startup using the -t/--threads command line argument.","page":"Environment Variables"},{"title":"JULIA_THREAD_SLEEP_THRESHOLD","location":"manual/environment-variables.html#JULIA_THREAD_SLEEP_THRESHOLD","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to a string that starts with the case-insensitive substring \"infinite\", then spinning threads never sleep. Otherwise, $JULIA_THREAD_SLEEP_THRESHOLD is interpreted as an unsigned 64-bit integer (uint64_t) and gives, in nanoseconds, the amount of time after which spinning threads should sleep.","page":"Environment Variables"},{"title":"JULIA_EXCLUSIVE","location":"manual/environment-variables.html#JULIA_EXCLUSIVE","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then Julia's thread policy is consistent with running on a dedicated machine: the master thread is on proc 0, and threads are affinitized. Otherwise, Julia lets the operating system handle thread policy.","page":"Environment Variables"},{"title":"REPL formatting","location":"manual/environment-variables.html#REPL-formatting","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Environment variables that determine how REPL output should be formatted at the terminal. Generally, these variables should be set to ANSI terminal escape sequences. Julia provides a high-level interface with much of the same functionality; see the section on The Julia REPL.","page":"Environment Variables"},{"title":"JULIA_ERROR_COLOR","location":"manual/environment-variables.html#JULIA_ERROR_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.error_color() (default: light red, \"\\033[91m\") that errors should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_WARN_COLOR","location":"manual/environment-variables.html#JULIA_WARN_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.warn_color() (default: yellow, \"\\033[93m\") that warnings should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_INFO_COLOR","location":"manual/environment-variables.html#JULIA_INFO_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.info_color() (default: cyan, \"\\033[36m\") that info should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_INPUT_COLOR","location":"manual/environment-variables.html#JULIA_INPUT_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.input_color() (default: normal, \"\\033[0m\") that input should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_ANSWER_COLOR","location":"manual/environment-variables.html#JULIA_ANSWER_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.answer_color() (default: normal, \"\\033[0m\") that output should have at the terminal.","page":"Environment Variables"},{"title":"Debugging and profiling","location":"manual/environment-variables.html#Debugging-and-profiling","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_DEBUG","location":"manual/environment-variables.html#JULIA_DEBUG","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Enable debug logging for a file or module, see Logging for more information.","page":"Environment Variables"},{"title":"JULIA_GC_ALLOC_POOL, JULIA_GC_ALLOC_OTHER, JULIA_GC_ALLOC_PRINT","location":"manual/environment-variables.html#JULIA_GC_ALLOC_POOL,-JULIA_GC_ALLOC_OTHER,-JULIA_GC_ALLOC_PRINT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set, these environment variables take strings that optionally start with the character 'r', followed by a string interpolation of a colon-separated list of three signed 64-bit integers (int64_t). This triple of integers a:b:c represents the arithmetic sequence a, a + b, a + 2*b, ... c.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If it's the nth time that jl_gc_pool_alloc() has been called, and n   belongs to the arithmetic sequence represented by $JULIA_GC_ALLOC_POOL,   then garbage collection is forced.\nIf it's the nth time that maybe_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_OTHER, then garbage   collection is forced.\nIf it's the nth time that jl_gc_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_PRINT, then counts   for the number of calls to jl_gc_pool_alloc() and maybe_collect() are   printed.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If the value of the environment variable begins with the character 'r', then the interval between garbage collection events is randomized.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThese environment variables only have an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","page":"Environment Variables"},{"title":"JULIA_GC_NO_GENERATIONAL","location":"manual/environment-variables.html#JULIA_GC_NO_GENERATIONAL","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then the Julia garbage collector never performs \"quick sweeps\" of memory.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","page":"Environment Variables"},{"title":"JULIA_GC_WAIT_FOR_DEBUGGER","location":"manual/environment-variables.html#JULIA_GC_WAIT_FOR_DEBUGGER","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then the Julia garbage collector will wait for a debugger to attach instead of aborting whenever there's a critical error.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","page":"Environment Variables"},{"title":"ENABLE_JITPROFILING","location":"manual/environment-variables.html#ENABLE_JITPROFILING","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then the compiler will create and register an event listener for just-in-time (JIT) profiling.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with JIT profiling support, using eitherIntel's VTune™ Amplifier (USE_INTEL_JITEVENTS set to 1 in the build configuration), or\nOProfile (USE_OPROFILE_JITEVENTS set to 1 in the build configuration).\nPerf (USE_PERF_JITEVENTS set to 1 in the build configuration). This integration is enabled by default.","page":"Environment Variables"},{"title":"ENABLE_GDBLISTENER","location":"manual/environment-variables.html#ENABLE_GDBLISTENER","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0 enables GDB registration of Julia code on release builds. On debug builds of Julia this is always enabled. Recommended to use with -g 2.","page":"Environment Variables"},{"title":"JULIA_LLVM_ARGS","location":"manual/environment-variables.html#JULIA_LLVM_ARGS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Arguments to be passed to the LLVM backend.","page":"Environment Variables"},{"title":"Future","location":"stdlib/Future.html#Future","category":"section","text":"","page":"Future"},{"title":"Future","location":"stdlib/Future.html","category":"page","text":"The Future module implements future behavior of already existing functions, which will replace the current version in a future release of Julia.","page":"Future"},{"title":"Future","location":"stdlib/Future.html","category":"page","text":"Future.copy!\nFuture.randjump","page":"Future"},{"title":"Future.copy!","location":"stdlib/Future.html#Future.copy!","category":"function","text":"Future.copy!(dst, src) -> dst\n\nCopy src into dst.\n\ncompat: Julia 1.1\nThis function has moved to Base with Julia 1.1, consider using copy!(dst, src) instead. Future.copy! will be deprecated in the future.\n\n\n\n\n\n","page":"Future"},{"title":"Future.randjump","location":"stdlib/Future.html#Future.randjump","category":"function","text":"randjump(r::MersenneTwister, steps::Integer) -> MersenneTwister\n\nCreate an initialized MersenneTwister object, whose state is moved forward (without generating numbers) from r by steps steps. One such step corresponds to the generation of two Float64 numbers. For each different value of steps, a large polynomial has to be generated internally. One is already pre-computed for steps=big(10)^20.\n\n\n\n\n\n","page":"Future"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html#Complex-and-Rational-Numbers","category":"section","text":"","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Julia includes predefined types for both complex and rational numbers, and supports all the standard Mathematical Operations and Elementary Functions on them. Conversion and Promotion are defined so that operations on any combination of predefined numeric types, whether primitive or composite, behave as expected.","page":"Complex and Rational Numbers"},{"title":"Complex Numbers","location":"manual/complex-and-rational-numbers.html#Complex-Numbers","category":"section","text":"","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"The global constant im is bound to the complex number i, representing the principal square root of -1. (Using mathematicians' i or engineers' j for this global constant were rejected since they are such popular index variable names.) Since Julia allows numeric literals to be juxtaposed with identifiers as coefficients, this binding suffices to provide convenient syntax for complex numbers, similar to the traditional mathematical notation:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 1+2im\n1 + 2im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"You can perform all the standard arithmetic operations with complex numbers:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> (1 + 2im)*(2 - 3im)\n8 + 1im\n\njulia> (1 + 2im)/(1 - 2im)\n-0.6 + 0.8im\n\njulia> (1 + 2im) + (1 - 2im)\n2 + 0im\n\njulia> (-3 + 2im) - (5 - 1im)\n-8 + 3im\n\njulia> (-1 + 2im)^2\n-3 - 4im\n\njulia> (-1 + 2im)^2.5\n2.729624464784009 - 6.9606644595719im\n\njulia> (-1 + 2im)^(1 + 1im)\n-0.27910381075826657 + 0.08708053414102428im\n\njulia> 3(2 - 5im)\n6 - 15im\n\njulia> 3(2 - 5im)^2\n-63 - 60im\n\njulia> 3(2 - 5im)^-1.0\n0.20689655172413796 + 0.5172413793103449im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"The promotion mechanism ensures that combinations of operands of different types just work:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 2(1 - 1im)\n2 - 2im\n\njulia> (2 + 3im) - 1\n1 + 3im\n\njulia> (1 + 2im) + 0.5\n1.5 + 2.0im\n\njulia> (2 + 3im) - 0.5im\n2.0 + 2.5im\n\njulia> 0.75(1 + 2im)\n0.75 + 1.5im\n\njulia> (2 + 3im) / 2\n1.0 + 1.5im\n\njulia> (1 - 3im) / (2 + 2im)\n-0.5 - 1.0im\n\njulia> 2im^2\n-2 + 0im\n\njulia> 1 + 3/4im\n1.0 - 0.75im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Note that 3/4im == 3/(4*im) == -(3/4*im), since a literal coefficient binds more tightly than division.","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Standard functions to manipulate complex values are provided:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> z = 1 + 2im\n1 + 2im\n\njulia> real(1 + 2im) # real part of z\n1\n\njulia> imag(1 + 2im) # imaginary part of z\n2\n\njulia> conj(1 + 2im) # complex conjugate of z\n1 - 2im\n\njulia> abs(1 + 2im) # absolute value of z\n2.23606797749979\n\njulia> abs2(1 + 2im) # squared absolute value\n5\n\njulia> angle(1 + 2im) # phase angle in radians\n1.1071487177940904","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"As usual, the absolute value (abs) of a complex number is its distance from zero. abs2 gives the square of the absolute value, and is of particular use for complex numbers since it avoids taking a square root. angle returns the phase angle in radians (also known as the argument or arg function). The full gamut of other Elementary Functions is also defined for complex numbers:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> sqrt(1im)\n0.7071067811865476 + 0.7071067811865475im\n\njulia> sqrt(1 + 2im)\n1.272019649514069 + 0.7861513777574233im\n\njulia> cos(1 + 2im)\n2.0327230070196656 - 3.0518977991517997im\n\njulia> exp(1 + 2im)\n-1.1312043837568135 + 2.4717266720048188im\n\njulia> sinh(1 + 2im)\n-0.4890562590412937 + 1.4031192506220405im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Note that mathematical functions typically return real values when applied to real numbers and complex values when applied to complex numbers. For example, sqrt behaves differently when applied to -1 versus -1 + 0im even though -1 == -1 + 0im:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> sqrt(-1)\nERROR: DomainError with -1.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]\n\njulia> sqrt(-1 + 0im)\n0.0 + 1.0im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"The literal numeric coefficient notation does not work when constructing a complex number from variables. Instead, the multiplication must be explicitly written out:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> a = 1; b = 2; a + b*im\n1 + 2im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"However, this is not recommended. Instead, use the more efficient complex function to construct a complex value directly from its real and imaginary parts:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> a = 1; b = 2; complex(a, b)\n1 + 2im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"This construction avoids the multiplication and addition operations.","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Inf and NaN propagate through complex numbers in the real and imaginary parts of a complex number as described in the Special floating-point values section:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 1 + Inf*im\n1.0 + Inf*im\n\njulia> 1 + NaN*im\n1.0 + NaN*im","page":"Complex and Rational Numbers"},{"title":"Rational Numbers","location":"manual/complex-and-rational-numbers.html#Rational-Numbers","category":"section","text":"","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Julia has a rational number type to represent exact ratios of integers. Rationals are constructed using the // operator:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 2//3\n2//3","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"If the numerator and denominator of a rational have common factors, they are reduced to lowest terms such that the denominator is non-negative:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 6//9\n2//3\n\njulia> -4//8\n-1//2\n\njulia> 5//-15\n-1//3\n\njulia> -4//-12\n1//3","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"This normalized form for a ratio of integers is unique, so equality of rational values can be tested by checking for equality of the numerator and denominator. The standardized numerator and denominator of a rational value can be extracted using the numerator and denominator functions:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> numerator(2//3)\n2\n\njulia> denominator(2//3)\n3","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Direct comparison of the numerator and denominator is generally not necessary, since the standard arithmetic and comparison operations are defined for rational values:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 2//3 == 6//9\ntrue\n\njulia> 2//3 == 9//27\nfalse\n\njulia> 3//7 < 1//2\ntrue\n\njulia> 3//4 > 2//3\ntrue\n\njulia> 2//4 + 1//6\n2//3\n\njulia> 5//12 - 1//4\n1//6\n\njulia> 5//8 * 3//12\n5//32\n\njulia> 6//5 / 10//7\n21//25","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Rationals can easily be converted to floating-point numbers:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> float(3//4)\n0.75","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Conversion from rational to floating-point respects the following identity for any integral values of a and b, with the exception of the case a == 0 and b == 0:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> a = 1; b = 2;\n\njulia> isequal(float(a//b), a/b)\ntrue","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Constructing infinite rational values is acceptable:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 5//0\n1//0\n\njulia> x = -3//0\n-1//0\n\njulia> typeof(x)\nRational{Int64}","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Trying to construct a NaN rational value, however, is invalid:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 0//0\nERROR: ArgumentError: invalid rational: zero(Int64)//zero(Int64)\nStacktrace:\n[...]","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"As usual, the promotion system makes interactions with other numeric types effortless:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 3//5 + 1\n8//5\n\njulia> 3//5 - 0.5\n0.09999999999999998\n\njulia> 2//7 * (1 + 2im)\n2//7 + 4//7*im\n\njulia> 2//7 * (1.5 + 2im)\n0.42857142857142855 + 0.5714285714285714im\n\njulia> 3//2 / (1 + 2im)\n3//10 - 3//5*im\n\njulia> 1//2 + 2im\n1//2 + 2//1*im\n\njulia> 1 + 2//3im\n1//1 - 2//3*im\n\njulia> 0.5 == 1//2\ntrue\n\njulia> 0.33 == 1//3\nfalse\n\njulia> 0.33 < 1//3\ntrue\n\njulia> 1//3 - 0.33\n0.0033333333333332993","page":"Complex and Rational Numbers"},{"title":"More about types","location":"devdocs/types.html#More-about-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If you've used Julia for a while, you understand the fundamental role that types play.  Here we try to get under the hood, focusing particularly on Parametric Types.","page":"More about types"},{"title":"Types and sets (and Any and Union{}/Bottom)","location":"devdocs/types.html#Types-and-sets-(and-Any-and-Union{}/Bottom)","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"It's perhaps easiest to conceive of Julia's type system in terms of sets. While programs manipulate individual values, a type refers to a set of values. This is not the same thing as a collection; for example a Set of values is itself a single Set value. Rather, a type describes a set of possible values, expressing uncertainty about which value we have.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"A concrete type T describes the set of values whose direct tag, as returned by the typeof function, is T. An abstract type describes some possibly-larger set of values.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Any describes the entire universe of possible values. Integer is a subset of Any that includes Int, Int8, and other concrete types. Internally, Julia also makes heavy use of another type known as Bottom, which can also be written as Union{}. This corresponds to the empty set.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Julia's types support the standard operations of set theory: you can ask whether T1 is a \"subset\" (subtype) of T2 with T1 <: T2. Likewise, you intersect two types using typeintersect, take their union with Union, and compute a type that contains their union with typejoin:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> typeintersect(Int, Float64)\nUnion{}\n\njulia> Union{Int, Float64}\nUnion{Float64, Int64}\n\njulia> typejoin(Int, Float64)\nReal\n\njulia> typeintersect(Signed, Union{UInt8, Int8})\nInt8\n\njulia> Union{Signed, Union{UInt8, Int8}}\nUnion{UInt8, Signed}\n\njulia> typejoin(Signed, Union{UInt8, Int8})\nInteger\n\njulia> typeintersect(Tuple{Integer, Float64}, Tuple{Int, Real})\nTuple{Int64, Float64}\n\njulia> Union{Tuple{Integer, Float64}, Tuple{Int, Real}}\nUnion{Tuple{Int64, Real}, Tuple{Integer, Float64}}\n\njulia> typejoin(Tuple{Integer, Float64}, Tuple{Int, Real})\nTuple{Integer, Real}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"While these operations may seem abstract, they lie at the heart of Julia.  For example, method dispatch is implemented by stepping through the items in a method list until reaching one for which the type of the argument tuple is a subtype of the method signature. For this algorithm to work, it's important that methods be sorted by their specificity, and that the search begins with the most specific methods. Consequently, Julia also implements a partial order on types; this is achieved by functionality that is similar to <:, but with differences that will be discussed below.","page":"More about types"},{"title":"UnionAll types","location":"devdocs/types.html#UnionAll-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Julia's type system can also express an iterated union of types: a union of types over all values of some variable. This is needed to describe parametric types where the values of some parameters are not known.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"For example, Array has two parameters as in Array{Int,2}. If we did not know the element type, we could write Array{T,2} where T, which is the union of Array{T,2} for all values of T: Union{Array{Int8,2}, Array{Int16,2}, ...}.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Such a type is represented by a UnionAll object, which contains a variable (T in this example, of type TypeVar), and a wrapped type (Array{T,2} in this example).","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Consider the following methods:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f1(A::Array) = 1\nf2(A::Array{Int}) = 2\nf3(A::Array{T}) where {T<:Any} = 3\nf4(A::Array{Any}) = 4","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The signature - as described in Function calls - of f3 is a UnionAll type wrapping a tuple type: Tuple{typeof(f3), Array{T}} where T. All but f4 can be called with a = [1,2]; all but f2 can be called with b = Any[1,2].","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Let's look at these types a little more closely:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> dump(Array)\nUnionAll\n  var: TypeVar\n    name: Symbol T\n    lb: Union{}\n    ub: Any\n  body: UnionAll\n    var: TypeVar\n      name: Symbol N\n      lb: Union{}\n      ub: Any\n    body: Array{T, N} <: DenseArray{T, N}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"This indicates that Array actually names a UnionAll type. There is one UnionAll type for each parameter, nested. The syntax Array{Int,2} is equivalent to Array{Int}{2}; internally each UnionAll is instantiated with a particular variable value, one at a time, outermost-first. This gives a natural meaning to the omission of trailing type parameters; Array{Int} gives a type equivalent to Array{Int,N} where N.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"A TypeVar is not itself a type, but rather should be considered part of the structure of a UnionAll type. Type variables have lower and upper bounds on their values (in the fields lb and ub). The symbol name is purely cosmetic. Internally, TypeVars are compared by address, so they are defined as mutable types to ensure that \"different\" type variables can be distinguished. However, by convention they should not be mutated.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"One can construct TypeVars manually:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> TypeVar(:V, Signed, Real)\nSigned<:V<:Real","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"There are convenience versions that allow you to omit any of these arguments except the name symbol.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The syntax Array{T} where T<:Integer is lowered to","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"let T = TypeVar(:T,Integer)\n    UnionAll(T, Array{T})\nend","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"so it is seldom necessary to construct a TypeVar manually (indeed, this is to be avoided).","page":"More about types"},{"title":"Free variables","location":"devdocs/types.html#Free-variables","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The concept of a free type variable is extremely important in the type system. We say that a variable V is free in type T if T does not contain the UnionAll that introduces variable V. For example, the type Array{Array{V} where V<:Integer} has no free variables, but the Array{V} part inside of it does have a free variable, V.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"A type with free variables is, in some sense, not really a type at all. Consider the type Array{Array{T}} where T, which refers to all homogeneous arrays of arrays. The inner type Array{T}, seen by itself, might seem to refer to any kind of array. However, every element of the outer array must have the same array type, so Array{T} cannot refer to just any old array. One could say that Array{T} effectively \"occurs\" multiple times, and T must have the same value each \"time\".","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"For this reason, the function jl_has_free_typevars in the C API is very important. Types for which it returns true will not give meaningful answers in subtyping and other type functions.","page":"More about types"},{"title":"TypeNames","location":"devdocs/types.html#TypeNames","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The following two Array types are functionally equivalent, yet print differently:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> TV, NV = TypeVar(:T), TypeVar(:N)\n(T, N)\n\njulia> Array\nArray\n\njulia> Array{TV, NV}\nArray{T, N}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"These can be distinguished by examining the name field of the type, which is an object of type TypeName:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> dump(Array{Int,1}.name)\nTypeName\n  name: Symbol Array\n  module: Module Core\n  names: empty SimpleVector\n  wrapper: UnionAll\n    var: TypeVar\n      name: Symbol T\n      lb: Union{}\n      ub: Any\n    body: UnionAll\n      var: TypeVar\n        name: Symbol N\n        lb: Union{}\n        ub: Any\n      body: Array{T, N} <: DenseArray{T, N}\n  cache: SimpleVector\n    ...\n\n  linearcache: SimpleVector\n    ...\n\n  hash: Int64 -7900426068641098781\n  mt: MethodTable\n    name: Symbol Array\n    defs: Nothing nothing\n    cache: Nothing nothing\n    max_args: Int64 0\n    kwsorter: #undef\n    module: Module Core\n    : Int64 0\n    : Int64 0","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"In this case, the relevant field is wrapper, which holds a reference to the top-level type used to make new Array types.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> pointer_from_objref(Array)\nPtr{Cvoid} @0x00007fcc7de64850\n\njulia> pointer_from_objref(Array.body.body.name.wrapper)\nPtr{Cvoid} @0x00007fcc7de64850\n\njulia> pointer_from_objref(Array{TV,NV})\nPtr{Cvoid} @0x00007fcc80c4d930\n\njulia> pointer_from_objref(Array{TV,NV}.name.wrapper)\nPtr{Cvoid} @0x00007fcc7de64850","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The wrapper field of Array points to itself, but for Array{TV,NV} it points back to the original definition of the type.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"What about the other fields? hash assigns an integer to each type.  To examine the cache field, it's helpful to pick a type that is less heavily used than Array. Let's first create our own type:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> struct MyType{T,N} end\n\njulia> MyType{Int,2}\nMyType{Int64, 2}\n\njulia> MyType{Float32, 5}\nMyType{Float32, 5}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"When you instantiate a parametric type, each concrete type gets saved in a type cache (MyType.body.body.name.cache). However, instances containing free type variables are not cached.","page":"More about types"},{"title":"Tuple types","location":"devdocs/types.html#Tuple-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Tuple types constitute an interesting special case.  For dispatch to work on declarations like x::Tuple, the type has to be able to accommodate any tuple.  Let's check the parameters:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> Tuple\nTuple\n\njulia> Tuple.parameters\nsvec(Vararg{Any, N} where N)","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Unlike other types, tuple types are covariant in their parameters, so this definition permits Tuple to match any type of tuple:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> typeintersect(Tuple, Tuple{Int,Float64})\nTuple{Int64, Float64}\n\njulia> typeintersect(Tuple{Vararg{Any}}, Tuple{Int,Float64})\nTuple{Int64, Float64}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"However, if a variadic (Vararg) tuple type has free variables it can describe different kinds of tuples:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> typeintersect(Tuple{Vararg{T} where T}, Tuple{Int,Float64})\nTuple{Int64, Float64}\n\njulia> typeintersect(Tuple{Vararg{T}} where T, Tuple{Int,Float64})\nUnion{}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Notice that when T is free with respect to the Tuple type (i.e. its binding UnionAll type is outside the Tuple type), only one T value must work over the whole type. Therefore a heterogeneous tuple does not match.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Finally, it's worth noting that Tuple{} is distinct:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> Tuple{}\nTuple{}\n\njulia> Tuple{}.parameters\nsvec()\n\njulia> typeintersect(Tuple{}, Tuple{Int})\nUnion{}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"What is the \"primary\" tuple-type?","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> pointer_from_objref(Tuple)\nPtr{Cvoid} @0x00007f5998a04370\n\njulia> pointer_from_objref(Tuple{})\nPtr{Cvoid} @0x00007f5998a570d0\n\njulia> pointer_from_objref(Tuple.name.wrapper)\nPtr{Cvoid} @0x00007f5998a04370\n\njulia> pointer_from_objref(Tuple{}.name.wrapper)\nPtr{Cvoid} @0x00007f5998a04370","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"so Tuple == Tuple{Vararg{Any}} is indeed the primary type.","page":"More about types"},{"title":"Diagonal types","location":"devdocs/types.html#Diagonal-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Consider the type Tuple{T,T} where T. A method with this signature would look like:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(x::T, y::T) where {T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"According to the usual interpretation of a UnionAll type, this T ranges over all types, including Any, so this type should be equivalent to Tuple{Any,Any}. However, this interpretation causes some practical problems.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"First, a value of T needs to be available inside the method definition. For a call like f(1, 1.0), it's not clear what T should be. It could be Union{Int,Float64}, or perhaps Real. Intuitively, we expect the declaration x::T to mean T === typeof(x). To make sure that invariant holds, we need typeof(x) === typeof(y) === T in this method. That implies the method should only be called for arguments of the exact same type.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"It turns out that being able to dispatch on whether two values have the same type is very useful (this is used by the promotion system for example), so we have multiple reasons to want a different interpretation of Tuple{T,T} where T. To make this work we add the following rule to subtyping: if a variable occurs more than once in covariant position, it is restricted to ranging over only concrete types. (\"Covariant position\" means that only Tuple and Union types occur between an occurrence of a variable and the UnionAll type that introduces it.) Such variables are called \"diagonal variables\" or \"concrete variables\".","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"So for example, Tuple{T,T} where T can be seen as Union{Tuple{Int8,Int8}, Tuple{Int16,Int16}, ...}, where T ranges over all concrete types. This gives rise to some interesting subtyping results. For example Tuple{Real,Real} is not a subtype of Tuple{T,T} where T, because it includes some types like Tuple{Int8,Int16} where the two elements have different types. Tuple{Real,Real} and Tuple{T,T} where T have the non-trivial intersection Tuple{T,T} where T<:Real. However, Tuple{Real} is a subtype of Tuple{T} where T, because in that case T occurs only once and so is not diagonal.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Next consider a signature like the following:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(a::Array{T}, x::T, y::T) where {T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"In this case, T occurs in invariant position inside Array{T}. That means whatever type of array is passed unambiguously determines the value of T – we say T has an equality constraint on it. Therefore in this case the diagonal rule is not really necessary, since the array determines T and we can then allow x and y to be of any subtypes of T. So variables that occur in invariant position are never considered diagonal. This choice of behavior is slightly controversial – some feel this definition should be written as","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(a::Array{T}, x::S, y::S) where {T, S<:T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"to clarify whether x and y need to have the same type. In this version of the signature they would, or we could introduce a third variable for the type of y if x and y can have different types.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The next complication is the interaction of unions and diagonal variables, e.g.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(x::Union{Nothing,T}, y::T) where {T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Consider what this declaration means. y has type T. x then can have either the same type T, or else be of type Nothing. So all of the following calls should match:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(1, 1)\nf(\"\", \"\")\nf(2.0, 2.0)\nf(nothing, 1)\nf(nothing, \"\")\nf(nothing, 2.0)","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"These examples are telling us something: when x is nothing::Nothing, there are no extra constraints on y. It is as if the method signature had y::Any. Indeed, we have the following type equivalence:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"(Tuple{Union{Nothing,T},T} where T) == Union{Tuple{Nothing,Any}, Tuple{T,T} where T}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The general rule is: a concrete variable in covariant position acts like it's not concrete if the subtyping algorithm only uses it once. When x has type Nothing, we don't need to use the T in Union{Nothing,T}; we only use it in the second slot. This arises naturally from the observation that in Tuple{T} where T restricting T to concrete types makes no difference; the type is equal to Tuple{Any} either way.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"However, appearing in invariant position disqualifies a variable from being concrete whether that appearance of the variable is used or not. Otherwise types can behave differently depending on which other types they are compared to, making subtyping not transitive. For example, consider","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Tuple{Int,Int8,Vector{Integer}} <: Tuple{T,T,Vector{Union{Integer,T}}} where T","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If the T inside the Union is ignored, then T is concrete and the answer is \"false\" since the first two types aren't the same. But consider instead","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Tuple{Int,Int8,Vector{Any}} <: Tuple{T,T,Vector{Union{Integer,T}}} where T","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Now we cannot ignore the T in the Union (we must have T == Any), so T is not concrete and the answer is \"true\". That would make the concreteness of T depend on the other type, which is not acceptable since a type must have a clear meaning on its own. Therefore the appearance of T inside Vector is considered in both cases.","page":"More about types"},{"title":"Subtyping diagonal variables","location":"devdocs/types.html#Subtyping-diagonal-variables","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The subtyping algorithm for diagonal variables has two components: (1) identifying variable occurrences, and (2) ensuring that diagonal variables range over concrete types only.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The first task is accomplished by keeping counters occurs_inv and occurs_cov (in src/subtype.c) for each variable in the environment, tracking the number of invariant and covariant occurrences, respectively. A variable is diagonal when occurs_inv == 0 && occurs_cov > 1.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The second task is accomplished by imposing a condition on a variable's lower bound. As the subtyping algorithm runs, it narrows the bounds of each variable (raising lower bounds and lowering upper bounds) to keep track of the range of variable values for which the subtype relation would hold. When we are done evaluating the body of a UnionAll type whose variable is diagonal, we look at the final values of the bounds. Since the variable must be concrete, a contradiction occurs if its lower bound could not be a subtype of a concrete type. For example, an abstract type like AbstractArray cannot be a subtype of a concrete type, but a concrete type like Int can be, and the empty type Bottom can be as well. If a lower bound fails this test the algorithm stops with the answer false.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"For example, in the problem Tuple{Int,String} <: Tuple{T,T} where T, we derive that this would be true if T were a supertype of Union{Int,String}. However, Union{Int,String} is an abstract type, so the relation does not hold.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"This concreteness test is done by the function is_leaf_bound. Note that this test is slightly different from jl_is_leaf_type, since it also returns true for Bottom. Currently this function is heuristic, and does not catch all possible concrete types. The difficulty is that whether a lower bound is concrete might depend on the values of other type variable bounds. For example, Vector{T} is equivalent to the concrete type Vector{Int} only if both the upper and lower bounds of T equal Int. We have not yet worked out a complete algorithm for this.","page":"More about types"},{"title":"Introduction to the internal machinery","location":"devdocs/types.html#Introduction-to-the-internal-machinery","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Most operations for dealing with types are found in the files jltypes.c and subtype.c. A good way to start is to watch subtyping in action. Build Julia with make debug and fire up Julia within a debugger. gdb debugging tips has some tips which may be useful.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Because the subtyping code is used heavily in the REPL itself – and hence breakpoints in this code get triggered often – it will be easiest if you make the following definition:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> function mysubtype(a,b)\n           ccall(:jl_breakpoint, Cvoid, (Any,), nothing)\n           a <: b\n       end","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"and then set a breakpoint in jl_breakpoint.  Once this breakpoint gets triggered, you can set breakpoints in other functions.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"As a warm-up, try the following:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"mysubtype(Tuple{Int, Float64}, Tuple{Integer, Real})","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"We can make it more interesting by trying a more complex case:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"mysubtype(Tuple{Array{Int,2}, Int8}, Tuple{Array{T}, T} where T)","page":"More about types"},{"title":"Subtyping and method sorting","location":"devdocs/types.html#Subtyping-and-method-sorting","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The type_morespecific functions are used for imposing a partial order on functions in method tables (from most-to-least specific). Specificity is strict; if a is more specific than b, then a does not equal b and b is not more specific than a.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If a is a strict subtype of b, then it is automatically considered more specific. From there, type_morespecific employs some less formal rules. For example, subtype is sensitive to the number of arguments, but type_morespecific may not be. In particular, Tuple{Int,AbstractFloat} is more specific than Tuple{Integer}, even though it is not a subtype.  (Of Tuple{Int,AbstractFloat} and Tuple{Integer,Float64}, neither is more specific than the other.)  Likewise, Tuple{Int,Vararg{Int}} is not a subtype of Tuple{Integer}, but it is considered more specific. However, morespecific does get a bonus for length: in particular, Tuple{Int,Int} is more specific than Tuple{Int,Vararg{Int}}.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If you're debugging how methods get sorted, it can be convenient to define the function:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"type_morespecific(a, b) = ccall(:jl_type_morespecific, Cint, (Any,Any), a, b)","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"which allows you to test whether tuple type a is more specific than tuple type b.","page":"More about types"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html#Handling-Operating-System-Variation","category":"section","text":"","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"When writing cross-platform applications or libraries, it is often necessary to allow for differences between operating systems. The variable Sys.KERNEL can be used to handle such cases. There are several functions in the Sys module intended to make this easier, such as isunix, islinux, isapple, isbsd, isfreebsd, and iswindows. These may be used as follows:","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"if Sys.iswindows()\n    windows_specific_thing(a)\nend","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"Note that islinux, isapple, and isfreebsd are mutually exclusive subsets of isunix. Additionally, there is a macro @static which makes it possible to use these functions to conditionally hide invalid code, as demonstrated in the following examples.","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"Simple blocks:","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"ccall((@static Sys.iswindows() ? :_fopen : :fopen), ...)","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"Complex blocks:","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"@static if Sys.islinux()\n    linux_specific_thing(a)\nelse\n    generic_thing(a)\nend","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"When chaining conditionals (including if/elseif/end), the @static must be repeated for each level (parentheses optional, but recommended for readability):","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"@static Sys.iswindows() ? :a : (@static Sys.isapple() ? :b : :c)","page":"Handling Operating System Variation"},{"title":"SIMD Support","location":"base/simd-types.html#SIMD-Support","category":"section","text":"","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"Type VecElement{T} is intended for building libraries of SIMD operations. Practical use of it requires using llvmcall. The type is defined as:","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"struct VecElement{T}\n    value::T\nend","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"It has a special compilation rule: a homogeneous tuple of VecElement{T} maps to an LLVM vector type when T is a primitive bits type.","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"At -O3, the compiler might automatically vectorize operations on such tuples. For example, the following program, when compiled with julia -O3 generates two SIMD addition instructions (addps) on x86 systems:","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"const m128 = NTuple{4,VecElement{Float32}}\n\nfunction add(a::m128, b::m128)\n    (VecElement(a[1].value+b[1].value),\n     VecElement(a[2].value+b[2].value),\n     VecElement(a[3].value+b[3].value),\n     VecElement(a[4].value+b[4].value))\nend\n\ntriple(c::m128) = add(add(c,c),c)\n\ncode_native(triple,(m128,))","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"However, since the automatic vectorization cannot be relied upon, future use will mostly be via libraries that use llvmcall.","page":"SIMD Support"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html#gdb-debugging-tips","category":"section","text":"","page":"gdb debugging tips"},{"title":"Displaying Julia variables","location":"devdocs/debuggingtips.html#Displaying-Julia-variables","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Within gdb, any jl_value_t* object obj can be displayed using","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) call jl_(obj)","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"The object will be displayed in the julia session, not in the gdb session. This is a useful way to discover the types and values of objects being manipulated by Julia's C code.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Similarly, if you're debugging some of Julia's internals (e.g., compiler.jl), you can print obj using","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"ccall(:jl_, Cvoid, (Any,), obj)","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"This is a good way to circumvent problems that arise from the order in which julia's output streams are initialized.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Julia's flisp interpreter uses value_t objects; these can be displayed with call fl_print(fl_ctx, ios_stdout, obj).","page":"gdb debugging tips"},{"title":"Useful Julia variables for Inspecting","location":"devdocs/debuggingtips.html#Useful-Julia-variables-for-Inspecting","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"While the addresses of many variables, like singletons, can be useful to print for many failures, there are a number of additional variables (see julia.h for a complete list) that are even more useful.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(when in jl_apply_generic) mfunc and jl_uncompress_ast(mfunc->def, mfunc->code) :: for figuring out a bit about the call-stack\njl_lineno and jl_filename :: for figuring out what line in a test to go start debugging from (or figure out how far into a file has been parsed)\n$1 :: not really a variable, but still a useful shorthand for referring to the result of the last gdb command (such as print)\njl_options :: sometimes useful, since it lists all of the command line options that were successfully parsed\njl_uv_stderr :: because who doesn't like to be able to interact with stdio","page":"gdb debugging tips"},{"title":"Useful Julia functions for Inspecting those variables","location":"devdocs/debuggingtips.html#Useful-Julia-functions-for-Inspecting-those-variables","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"jl_gdblookup($rip) :: For looking up the current function and line. (use $eip on i686 platforms)\njlbacktrace() :: For dumping the current Julia backtrace stack to stderr. Only usable after record_backtrace() has been called.\njl_dump_llvm_value(Value*) :: For invoking Value->dump() in gdb, where it doesn't work natively. For example, f->linfo->functionObject, f->linfo->specFunctionObject, and to_function(f->linfo).\nType->dump() :: only works in lldb. Note: add something like ;1 to prevent lldb from printing its prompt over the output\njl_eval_string(\"expr\") :: for invoking side-effects to modify the current state or to lookup symbols\njl_typeof(jl_value_t*) :: for extracting the type tag of a Julia value (in gdb, call macro define jl_typeof jl_typeof first, or pick something short like ty for the first arg to define a shorthand)","page":"gdb debugging tips"},{"title":"Inserting breakpoints for inspection from gdb","location":"devdocs/debuggingtips.html#Inserting-breakpoints-for-inspection-from-gdb","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"In your gdb session, set a breakpoint in jl_breakpoint like so:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) break jl_breakpoint","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then within your Julia code, insert a call to jl_breakpoint by adding","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"ccall(:jl_breakpoint, Cvoid, (Any,), obj)","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"where obj can be any variable or tuple you want to be accessible in the breakpoint.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"It's particularly helpful to back up to the jl_apply frame, from which you can display the arguments to a function using, e.g.,","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) call jl_(args[0])","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Another useful frame is to_function(jl_method_instance_t *li, bool cstyle). The jl_method_instance_t* argument is a struct with a reference to the final AST sent into the compiler. However, the AST at this point will usually be compressed; to view the AST, call jl_uncompress_ast and then pass the result to jl_:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"#2  0x00007ffff7928bf7 in to_function (li=0x2812060, cstyle=false) at codegen.cpp:584\n584          abort();\n(gdb) p jl_(jl_uncompress_ast(li, li->ast))","page":"gdb debugging tips"},{"title":"Inserting breakpoints upon certain conditions","location":"devdocs/debuggingtips.html#Inserting-breakpoints-upon-certain-conditions","category":"section","text":"","page":"gdb debugging tips"},{"title":"Loading a particular file","location":"devdocs/debuggingtips.html#Loading-a-particular-file","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Let's say the file is sysimg.jl:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) break jl_load if strcmp(fname, \"sysimg.jl\")==0","page":"gdb debugging tips"},{"title":"Calling a particular method","location":"devdocs/debuggingtips.html#Calling-a-particular-method","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) break jl_apply_generic if strcmp((char*)(jl_symbol_name)(jl_gf_mtable(F)->name), \"method_to_break\")==0","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Since this function is used for every call, you will make everything 1000x slower if you do this.","page":"gdb debugging tips"},{"title":"Dealing with signals","location":"devdocs/debuggingtips.html#Dealing-with-signals","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Julia requires a few signal to function property. The profiler uses SIGUSR2 for sampling and the garbage collector uses SIGSEGV for threads synchronization. If you are debugging some code that uses the profiler or multiple threads, you may want to let the debugger ignore these signals since they can be triggered very often during normal operations. The command to do this in GDB is (replace SIGSEGV with SIGUSRS or other signals you want to ignore):","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) handle SIGSEGV noprint nostop pass","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"The corresponding LLDB command is (after the process is started):","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(lldb) pro hand -p true -s false -n false SIGSEGV","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"If you are debugging a segfault with threaded code, you can set a breakpoint on jl_critical_error (sigdie_handler should also work on Linux and BSD) in order to only catch the actual segfault rather than the GC synchronization points.","page":"gdb debugging tips"},{"title":"Debugging during Julia's build process (bootstrap)","location":"devdocs/debuggingtips.html#Debugging-during-Julia's-build-process-(bootstrap)","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Errors that occur during make need special handling. Julia is built in two stages, constructing sys0 and sys.ji. To see what commands are running at the time of failure, use make VERBOSE=1.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"At the time of this writing, you can debug build errors during the sys0 phase from the base directory using:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"julia/base$ gdb --args ../usr/bin/julia-debug -C native --build ../usr/lib/julia/sys0 sysimg.jl","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"You might need to delete all the files in usr/lib/julia/ to get this to work.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"You can debug the sys.ji phase using:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"julia/base$ gdb --args ../usr/bin/julia-debug -C native --build ../usr/lib/julia/sys -J ../usr/lib/julia/sys0.ji sysimg.jl","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"By default, any errors will cause Julia to exit, even under gdb. To catch an error \"in the act\", set a breakpoint in jl_error (there are several other useful spots, for specific kinds of failures, including: jl_too_few_args, jl_too_many_args, and jl_throw).","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Once an error is caught, a useful technique is to walk up the stack and examine the function by inspecting the related call to jl_apply. To take a real-world example:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Breakpoint 1, jl_throw (e=0x7ffdf42de400) at task.c:802\n802 {\n(gdb) p jl_(e)\nErrorException(\"auto_unbox: unable to determine argument type\")\n$2 = void\n(gdb) bt 10\n#0  jl_throw (e=0x7ffdf42de400) at task.c:802\n#1  0x00007ffff65412fe in jl_error (str=0x7ffde56be000 <_j_str267> \"auto_unbox:\n   unable to determine argument type\")\n   at builtins.c:39\n#2  0x00007ffde56bd01a in julia_convert_16886 ()\n#3  0x00007ffff6541154 in jl_apply (f=0x7ffdf367f630, args=0x7fffffffc2b0, nargs=2) at julia.h:1281\n...","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"The most recent jl_apply is at frame #3, so we can go back there and look at the AST for the function julia_convert_16886. This is the uniqued name for some method of convert. f in this frame is a jl_function_t*, so we can look at the type signature, if any, from the specTypes field:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) f 3\n#3  0x00007ffff6541154 in jl_apply (f=0x7ffdf367f630, args=0x7fffffffc2b0, nargs=2) at julia.h:1281\n1281            return f->fptr((jl_value_t*)f, args, nargs);\n(gdb) p f->linfo->specTypes\n$4 = (jl_tupletype_t *) 0x7ffdf39b1030\n(gdb) p jl_( f->linfo->specTypes )\nTuple{Type{Float32}, Float64}           # <-- type signature for julia_convert_16886","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then, we can look at the AST for this function:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) p jl_( jl_uncompress_ast(f->linfo, f->linfo->ast) )\nExpr(:lambda, Array{Any, 1}[:#s29, :x], Array{Any, 1}[Array{Any, 1}[], Array{Any, 1}[Array{Any, 1}[:#s29, :Any, 0], Array{Any, 1}[:x, :Any, 0]], Array{Any, 1}[], 0], Expr(:body,\nExpr(:line, 90, :float.jl)::Any,\nExpr(:return, Expr(:call, :box, :Float32, Expr(:call, :fptrunc, :Float32, :x)::Any)::Any)::Any)::Any)::Any","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Finally, and perhaps most usefully, we can force the function to be recompiled in order to step through the codegen process. To do this, clear the cached functionObject from the jl_lamdbda_info_t*:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) p f->linfo->functionObject\n$8 = (void *) 0x1289d070\n(gdb) set f->linfo->functionObject = NULL","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then, set a breakpoint somewhere useful (e.g. emit_function, emit_expr, emit_call, etc.), and run codegen:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) p jl_compile(f)\n... # your breakpoint here","page":"gdb debugging tips"},{"title":"Debugging precompilation errors","location":"devdocs/debuggingtips.html#Debugging-precompilation-errors","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Module precompilation spawns a separate Julia process to precompile each module. Setting a breakpoint or catching failures in a precompile worker requires attaching a debugger to the worker. The easiest approach is to set the debugger watch for new process launches matching a given name. For example:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) attach -w -n julia-debug","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"or:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(lldb) process attach -w -n julia-debug","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then run a script/command to start precompilation. As described earlier, use conditional breakpoints in the parent process to catch specific file-loading events and narrow the debugging window. (some operating systems may require alternative approaches, such as following each fork from the parent process)","page":"gdb debugging tips"},{"title":"Mozilla's Record and Replay Framework (rr)","location":"devdocs/debuggingtips.html#Mozilla's-Record-and-Replay-Framework-(rr)","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Julia now works out of the box with rr, the lightweight recording and deterministic debugging framework from Mozilla. This allows you to replay the trace of an execution deterministically.  The replayed execution's address spaces, register contents, syscall data etc are exactly the same in every run.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"A recent version of rr (3.1.0 or higher) is required.","page":"gdb debugging tips"},{"title":"Reproducing concurrency bugs with rr","location":"devdocs/debuggingtips.html#Reproducing-concurrency-bugs-with-rr","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"rr simulates a single-threaded machine by default. In order to debug concurrent code you can use rr record --chaos which will cause rr to simulate between one to eight cores, chosen randomly. You might therefore want to set JULIA_NUM_THREADS=8 and rerun your code under rr until you have caught your bug.","page":"gdb debugging tips"},{"title":"LibGit2","location":"stdlib/LibGit2.html#LibGit2","category":"section","text":"","page":"LibGit2"},{"title":"LibGit2","location":"stdlib/LibGit2.html","category":"page","text":"The LibGit2 module provides bindings to libgit2, a portable C library that implements core functionality for the Git version control system. These bindings are currently used to power Julia's package manager. It is expected that this module will eventually be moved into a separate package.","page":"LibGit2"},{"title":"Functionality","location":"stdlib/LibGit2.html#Functionality","category":"section","text":"","page":"LibGit2"},{"title":"LibGit2","location":"stdlib/LibGit2.html","category":"page","text":"Some of this documentation assumes some prior knowledge of the libgit2 API. For more information on some of the objects and methods referenced here, consult the upstream libgit2 API reference.","page":"LibGit2"},{"title":"LibGit2","location":"stdlib/LibGit2.html","category":"page","text":"LibGit2.Buffer\nLibGit2.CheckoutOptions\nLibGit2.CloneOptions\nLibGit2.DescribeOptions\nLibGit2.DescribeFormatOptions\nLibGit2.DiffDelta\nLibGit2.DiffFile\nLibGit2.DiffOptionsStruct\nLibGit2.FetchHead\nLibGit2.FetchOptions\nLibGit2.GitAnnotated\nLibGit2.GitBlame\nLibGit2.GitBlob\nLibGit2.GitCommit\nLibGit2.GitHash\nLibGit2.GitObject\nLibGit2.GitRemote\nLibGit2.GitRemoteAnon\nLibGit2.GitRepo\nLibGit2.GitRepoExt\nLibGit2.GitRevWalker\nLibGit2.GitShortHash\nLibGit2.GitSignature\nLibGit2.GitStatus\nLibGit2.GitTag\nLibGit2.GitTree\nLibGit2.IndexEntry\nLibGit2.IndexTime\nLibGit2.BlameOptions\nLibGit2.MergeOptions\nLibGit2.ProxyOptions\nLibGit2.PushOptions\nLibGit2.RebaseOperation\nLibGit2.RebaseOptions\nLibGit2.RemoteCallbacks\nLibGit2.SignatureStruct\nLibGit2.StatusEntry\nLibGit2.StatusOptions\nLibGit2.StrArrayStruct\nLibGit2.TimeStruct\nLibGit2.add!\nLibGit2.add_fetch!\nLibGit2.add_push!\nLibGit2.addblob!\nLibGit2.author\nLibGit2.authors\nLibGit2.branch\nLibGit2.branch!\nLibGit2.checkout!\nLibGit2.clone\nLibGit2.commit\nLibGit2.committer\nLibGit2.count\nLibGit2.counthunks\nLibGit2.create_branch\nLibGit2.credentials_callback\nLibGit2.credentials_cb\nLibGit2.default_signature\nLibGit2.delete_branch\nLibGit2.diff_files\nLibGit2.entryid\nLibGit2.entrytype\nLibGit2.fetch\nLibGit2.fetchheads\nLibGit2.fetch_refspecs\nLibGit2.fetchhead_foreach_cb\nLibGit2.merge_base\nLibGit2.merge!(::LibGit2.GitRepo; ::Any...)\nLibGit2.merge!(::LibGit2.GitRepo, ::Vector{LibGit2.GitAnnotated}; ::LibGit2.MergeOptions, ::LibGit2.CheckoutOptions)\nLibGit2.merge!(::LibGit2.GitRepo, ::Vector{LibGit2.GitAnnotated}, ::Bool; ::LibGit2.MergeOptions, ::LibGit2.CheckoutOptions)\nLibGit2.ffmerge!\nLibGit2.fullname\nLibGit2.features\nLibGit2.filename\nLibGit2.filemode\nLibGit2.gitdir\nLibGit2.git_url\nLibGit2.@githash_str\nLibGit2.head\nLibGit2.head!\nLibGit2.head_oid\nLibGit2.headname\nLibGit2.init\nLibGit2.is_ancestor_of\nLibGit2.isbinary\nLibGit2.iscommit\nLibGit2.isdiff\nLibGit2.isdirty\nLibGit2.isorphan\nLibGit2.isset\nLibGit2.iszero\nLibGit2.lookup_branch\nLibGit2.map\nLibGit2.mirror_callback\nLibGit2.mirror_cb\nLibGit2.message\nLibGit2.merge_analysis\nLibGit2.name\nLibGit2.need_update\nLibGit2.objtype\nLibGit2.path\nLibGit2.peel\nLibGit2.posixpath\nLibGit2.push\nLibGit2.push!(::LibGit2.GitRevWalker, ::LibGit2.GitHash)\nLibGit2.push_head!\nLibGit2.push_refspecs\nLibGit2.raw\nLibGit2.read_tree!\nLibGit2.rebase!\nLibGit2.ref_list\nLibGit2.reftype\nLibGit2.remotes\nLibGit2.remove!\nLibGit2.reset\nLibGit2.reset!\nLibGit2.restore\nLibGit2.revcount\nLibGit2.set_remote_url\nLibGit2.shortname\nLibGit2.snapshot\nLibGit2.split_cfg_entry\nLibGit2.status\nLibGit2.stage\nLibGit2.tag_create\nLibGit2.tag_delete\nLibGit2.tag_list\nLibGit2.target\nLibGit2.toggle\nLibGit2.transact\nLibGit2.treewalk\nLibGit2.upstream\nLibGit2.update!\nLibGit2.url\nLibGit2.version\nLibGit2.with\nLibGit2.with_warn\nLibGit2.workdir\nLibGit2.GitObject(::LibGit2.GitTreeEntry)\nLibGit2.UserPasswordCredential\nLibGit2.SSHCredential\nLibGit2.isfilled\nLibGit2.CachedCredentials\nLibGit2.CredentialPayload\nLibGit2.approve\nLibGit2.reject","page":"LibGit2"},{"title":"LibGit2.Buffer","location":"stdlib/LibGit2.html#LibGit2.Buffer","category":"type","text":"LibGit2.Buffer\n\nA data buffer for exporting data from libgit2. Matches the git_buf struct.\n\nWhen fetching data from LibGit2, a typical usage would look like:\n\nbuf_ref = Ref(Buffer())\n@check ccall(..., (Ptr{Buffer},), buf_ref)\n# operation on buf_ref\nfree(buf_ref)\n\nIn particular, note that LibGit2.free should be called afterward on the Ref object.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.CheckoutOptions","location":"stdlib/LibGit2.html#LibGit2.CheckoutOptions","category":"type","text":"LibGit2.CheckoutOptions\n\nMatches the git_checkout_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncheckout_strategy: determine how to handle conflicts and whether to force the  checkout/recreate missing files.\ndisable_filters: if nonzero, do not apply filters like CLRF (to convert file newlines between UNIX and DOS).\ndir_mode: read/write/access mode for any directories involved in the checkout. Default is 0755.\nfile_mode: read/write/access mode for any files involved in the checkout.  Default is 0755 or 0644, depending on the blob.\nfile_open_flags: bitflags used to open any files during the checkout.\nnotify_flags: Flags for what sort of conflicts the user should be notified about.\nnotify_cb: An optional callback function to notify the user if a checkout conflict occurs.  If this function returns a non-zero value, the checkout will be cancelled.\nnotify_payload: Payload for the notify callback function.\nprogress_cb: An optional callback function to display checkout progress.\nprogress_payload: Payload for the progress callback.\npaths: If not empty, describes which paths to search during the checkout.  If empty, the checkout will occur over all files in the repository.\nbaseline: Expected content of the workdir, captured in a (pointer to a)  GitTree. Defaults to the state of the tree at HEAD.\nbaseline_index: Expected content of the workdir, captured in a (pointer to a)  GitIndex. Defaults to the state of the index at HEAD.\ntarget_directory: If not empty, checkout to this directory instead of the workdir.\nancestor_label: In case of conflicts, the name of the common ancestor side.\nour_label: In case of conflicts, the name of \"our\" side.\ntheir_label: In case of conflicts, the name of \"their\" side.\nperfdata_cb: An optional callback function to display performance data.\nperfdata_payload: Payload for the performance callback.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.CloneOptions","location":"stdlib/LibGit2.html#LibGit2.CloneOptions","category":"type","text":"LibGit2.CloneOptions\n\nMatches the git_clone_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncheckout_opts: The options for performing the checkout of the remote as part of the clone.\nfetch_opts: The options for performing the pre-checkout fetch of the remote as part of the clone.\nbare: If 0, clone the full remote repository. If non-zero, perform a bare clone, in which  there is no local copy of the source files in the repository and the gitdir and workdir  are the same.\nlocalclone: Flag whether to clone a local object database or do a fetch. The default is to let git decide.  It will not use the git-aware transport for a local clone, but will use it for URLs which begin with file://.\ncheckout_branch: The name of the branch to checkout. If an empty string, the default branch of the  remote will be checked out.\nrepository_cb: An optional callback which will be used to create the new repository into which  the clone is made.\nrepository_cb_payload: The payload for the repository callback.\nremote_cb: An optional callback used to create the GitRemote before making the clone from it.\nremote_cb_payload: The payload for the remote callback.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DescribeOptions","location":"stdlib/LibGit2.html#LibGit2.DescribeOptions","category":"type","text":"LibGit2.DescribeOptions\n\nMatches the git_describe_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nmax_candidates_tags: consider this many most recent tags in refs/tags to describe a commit.  Defaults to 10 (so that the 10 most recent tags would be examined to see if they describe a commit).\ndescribe_strategy: whether to consider all entries in refs/tags (equivalent to git-describe --tags)  or all entries in refs/ (equivalent to git-describe --all). The default is to only show annotated tags.  If Consts.DESCRIBE_TAGS is passed, all tags, annotated or not, will be considered.  If Consts.DESCRIBE_ALL is passed, any ref in refs/ will be considered.\npattern: only consider tags which match pattern. Supports glob expansion.\nonly_follow_first_parent: when finding the distance from a matching reference to the described  object, only consider the distance from the first parent.\nshow_commit_oid_as_fallback: if no matching reference can be found which describes a commit, show the  commit's GitHash instead of throwing an error (the default behavior).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DescribeFormatOptions","location":"stdlib/LibGit2.html#LibGit2.DescribeFormatOptions","category":"type","text":"LibGit2.DescribeFormatOptions\n\nMatches the git_describe_format_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nabbreviated_size: lower bound on the size of the abbreviated GitHash to use, defaulting to 7.\nalways_use_long_format: set to 1 to use the long format for strings even if a short format can be used.\ndirty_suffix: if set, this will be appended to the end of the description string if the workdir is dirty.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DiffDelta","location":"stdlib/LibGit2.html#LibGit2.DiffDelta","category":"type","text":"LibGit2.DiffDelta\n\nDescription of changes to one entry. Matches the git_diff_delta struct.\n\nThe fields represent:\n\nstatus: One of Consts.DELTA_STATUS, indicating whether the file has been added/modified/deleted.\nflags: Flags for the delta and the objects on each side. Determines whether to treat the file(s)  as binary/text, whether they exist on each side of the diff, and whether the object ids are known  to be correct.\nsimilarity: Used to indicate if a file has been renamed or copied.\nnfiles: The number of files in the delta (for instance, if the delta  was run on a submodule commit id, it may contain more than one file).\nold_file: A DiffFile containing information about the file(s) before the changes.\nnew_file: A DiffFile containing information about the file(s) after the changes.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DiffFile","location":"stdlib/LibGit2.html#LibGit2.DiffFile","category":"type","text":"LibGit2.DiffFile\n\nDescription of one side of a delta. Matches the git_diff_file struct.\n\nThe fields represent:\n\nid: the GitHash of the item in the diff. If the item is empty on this  side of the diff (for instance, if the diff is of the removal of a file), this will  be GitHash(0).\npath: a NULL terminated path to the item relative to the working directory of the repository.\nsize: the size of the item in bytes.\nflags: a combination of the git_diff_flag_t  flags. The ith bit of this integer sets the ith flag.\nmode: the stat mode for the item.\nid_abbrev: only present in LibGit2 versions newer than or equal to 0.25.0.  The length of the id field when converted using string. Usually equal to OID_HEXSZ (40).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DiffOptionsStruct","location":"stdlib/LibGit2.html#LibGit2.DiffOptionsStruct","category":"type","text":"LibGit2.DiffOptionsStruct\n\nMatches the git_diff_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: flags controlling which files will appear in the diff. Defaults to DIFF_NORMAL.\nignore_submodules: whether to look at files in submodules or not. Defaults to SUBMODULE_IGNORE_UNSPECIFIED, which means the submodule's configuration will control  whether it appears in the diff or not.\npathspec: path to files to include in the diff. Default is to use all files in the repository.\nnotify_cb: optional callback which will notify the user of changes to the diff as file deltas are  added to it.\nprogress_cb: optional callback which will display diff progress. Only relevant on libgit2 versions  at least as new as 0.24.0.\npayload: the payload to pass to notify_cb and progress_cb.\ncontext_lines: the number of unchanged lines used to define the edges of a hunk.  This is also the number of lines which will be shown before/after a hunk to provide  context. Default is 3.\ninterhunk_lines: the maximum number of unchanged lines between two separate  hunks allowed before the hunks will be combined. Default is 0.\nid_abbrev: sets the length of the abbreviated GitHash to print.  Default is 7.\nmax_size: the maximum file size of a blob. Above this size, it will be treated  as a binary blob. The default is 512 MB.\nold_prefix: the virtual file directory in which to place old files on one side  of the diff. Default is \"a\".\nnew_prefix: the virtual file directory in which to place new files on one side  of the diff. Default is \"b\".\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.FetchHead","location":"stdlib/LibGit2.html#LibGit2.FetchHead","category":"type","text":"LibGit2.FetchHead\n\nContains the information about HEAD during a fetch, including the name and URL of the branch fetched from, the oid of the HEAD, and whether the fetched HEAD has been merged locally.\n\nThe fields represent:\n\nname: The name in the local reference database of the fetch head, for example,  \"refs/heads/master\".\nurl: The URL of the fetch head.\noid: The GitHash of the tip of the fetch head.\nismerge: Boolean flag indicating whether the changes at the  remote have been merged into the local copy yet or not. If true, the local  copy is up to date with the remote fetch head.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.FetchOptions","location":"stdlib/LibGit2.html#LibGit2.FetchOptions","category":"type","text":"LibGit2.FetchOptions\n\nMatches the git_fetch_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncallbacks: remote callbacks to use during the fetch.\nprune: whether to perform a prune after the fetch or not. The default is to  use the setting from the GitConfig.\nupdate_fetchhead: whether to update the FetchHead after the fetch.  The default is to perform the update, which is the normal git behavior.\ndownload_tags: whether to download tags present at the remote or not. The default  is to request the tags for objects which are being downloaded anyway from the server.\nproxy_opts: options for connecting to the remote through a proxy. See ProxyOptions.  Only present on libgit2 versions newer than or equal to 0.25.0.\ncustom_headers: any extra headers needed for the fetch. Only present on libgit2 versions  newer than or equal to 0.24.0.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitAnnotated","location":"stdlib/LibGit2.html#LibGit2.GitAnnotated","category":"type","text":"GitAnnotated(repo::GitRepo, commit_id::GitHash)\nGitAnnotated(repo::GitRepo, ref::GitReference)\nGitAnnotated(repo::GitRepo, fh::FetchHead)\nGitAnnotated(repo::GitRepo, committish::AbstractString)\n\nAn annotated git commit carries with it information about how it was looked up and why, so that rebase or merge operations have more information about the context of the commit. Conflict files contain information about the source/target branches in the merge which are conflicting, for instance. An annotated commit can refer to the tip of a remote branch, for instance when a FetchHead is passed, or to a branch head described using GitReference.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitBlame","location":"stdlib/LibGit2.html#LibGit2.GitBlame","category":"type","text":"GitBlame(repo::GitRepo, path::AbstractString; options::BlameOptions=BlameOptions())\n\nConstruct a GitBlame object for the file at path, using change information gleaned from the history of repo. The GitBlame object records who changed which chunks of the file when, and how. options controls how to separate the contents of the file and which commits to probe - see BlameOptions for more information.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitBlob","location":"stdlib/LibGit2.html#LibGit2.GitBlob","category":"type","text":"GitBlob(repo::GitRepo, hash::AbstractGitHash)\nGitBlob(repo::GitRepo, spec::AbstractString)\n\nReturn a GitBlob object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitCommit","location":"stdlib/LibGit2.html#LibGit2.GitCommit","category":"type","text":"GitCommit(repo::GitRepo, hash::AbstractGitHash)\nGitCommit(repo::GitRepo, spec::AbstractString)\n\nReturn a GitCommit object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitHash","location":"stdlib/LibGit2.html#LibGit2.GitHash","category":"type","text":"GitHash\n\nA git object identifier, based on the sha-1 hash. It is a 20 byte string (40 hex digits) used to identify a GitObject in a repository.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitObject","location":"stdlib/LibGit2.html#LibGit2.GitObject","category":"type","text":"GitObject(repo::GitRepo, hash::AbstractGitHash)\nGitObject(repo::GitRepo, spec::AbstractString)\n\nReturn the specified object (GitCommit, GitBlob, GitTree or GitTag) from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRemote","location":"stdlib/LibGit2.html#LibGit2.GitRemote","category":"type","text":"GitRemote(repo::GitRepo, rmt_name::AbstractString, rmt_url::AbstractString) -> GitRemote\n\nLook up a remote git repository using its name and URL. Uses the default fetch refspec.\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nremote = LibGit2.GitRemote(repo, \"upstream\", repo_url)\n\n\n\n\n\nGitRemote(repo::GitRepo, rmt_name::AbstractString, rmt_url::AbstractString, fetch_spec::AbstractString) -> GitRemote\n\nLook up a remote git repository using the repository's name and URL, as well as specifications for how to fetch from the remote (e.g. which remote branch to fetch from).\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nrefspec = \"+refs/heads/mybranch:refs/remotes/origin/mybranch\"\nremote = LibGit2.GitRemote(repo, \"upstream\", repo_url, refspec)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRemoteAnon","location":"stdlib/LibGit2.html#LibGit2.GitRemoteAnon","category":"function","text":"GitRemoteAnon(repo::GitRepo, url::AbstractString) -> GitRemote\n\nLook up a remote git repository using only its URL, not its name.\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nremote = LibGit2.GitRemoteAnon(repo, repo_url)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRepo","location":"stdlib/LibGit2.html#LibGit2.GitRepo","category":"type","text":"LibGit2.GitRepo(path::AbstractString)\n\nOpen a git repository at path.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRepoExt","location":"stdlib/LibGit2.html#LibGit2.GitRepoExt","category":"function","text":"LibGit2.GitRepoExt(path::AbstractString, flags::Cuint = Cuint(Consts.REPOSITORY_OPEN_DEFAULT))\n\nOpen a git repository at path with extended controls (for instance, if the current user must be a member of a special access group to read path).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRevWalker","location":"stdlib/LibGit2.html#LibGit2.GitRevWalker","category":"type","text":"GitRevWalker(repo::GitRepo)\n\nA GitRevWalker walks through the revisions (i.e. commits) of a git repository repo. It is a collection of the commits in the repository, and supports iteration and calls to map and count (for instance, count could be used to determine what percentage of commits in a repository were made by a certain author).\n\ncnt = LibGit2.with(LibGit2.GitRevWalker(repo)) do walker\n    count((oid,repo)->(oid == commit_oid1), walker, oid=commit_oid1, by=LibGit2.Consts.SORT_TIME)\nend\n\nHere, count finds the number of commits along the walk with a certain GitHash. Since the GitHash is unique to a commit, cnt will be 1.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitShortHash","location":"stdlib/LibGit2.html#LibGit2.GitShortHash","category":"type","text":"GitShortHash(hash::GitHash, len::Integer)\n\nA shortened git object identifier, which can be used to identify a git object when it is unique, consisting of the initial len hexadecimal digits of hash (the remaining digits are ignored).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitSignature","location":"stdlib/LibGit2.html#LibGit2.GitSignature","category":"type","text":"LibGit2.GitSignature\n\nThis is a Julia wrapper around a pointer to a git_signature object.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitStatus","location":"stdlib/LibGit2.html#LibGit2.GitStatus","category":"type","text":"LibGit2.GitStatus(repo::GitRepo; status_opts=StatusOptions())\n\nCollect information about the status of each file in the git repository repo (e.g. is the file modified, staged, etc.). status_opts can be used to set various options, for instance whether or not to look at untracked files or whether to include submodules or not. See StatusOptions for more information.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitTag","location":"stdlib/LibGit2.html#LibGit2.GitTag","category":"type","text":"GitTag(repo::GitRepo, hash::AbstractGitHash)\nGitTag(repo::GitRepo, spec::AbstractString)\n\nReturn a GitTag object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitTree","location":"stdlib/LibGit2.html#LibGit2.GitTree","category":"type","text":"GitTree(repo::GitRepo, hash::AbstractGitHash)\nGitTree(repo::GitRepo, spec::AbstractString)\n\nReturn a GitTree object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.IndexEntry","location":"stdlib/LibGit2.html#LibGit2.IndexEntry","category":"type","text":"LibGit2.IndexEntry\n\nIn-memory representation of a file entry in the index. Matches the git_index_entry struct.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.IndexTime","location":"stdlib/LibGit2.html#LibGit2.IndexTime","category":"type","text":"LibGit2.IndexTime\n\nMatches the git_index_time struct.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.BlameOptions","location":"stdlib/LibGit2.html#LibGit2.BlameOptions","category":"type","text":"LibGit2.BlameOptions\n\nMatches the git_blame_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: one of Consts.BLAME_NORMAL or Consts.BLAME_FIRST_PARENT (the other blame flags  are not yet implemented by libgit2).\nmin_match_characters: the minimum number of alphanumeric characters which much change in a commit in order for the change to be associated with that commit. The default is 20. Only takes effect if one of the Consts.BLAME_*_COPIES flags are used, which libgit2 does not implement yet.\nnewest_commit: the GitHash of the newest commit from which to look at changes.\noldest_commit: the GitHash of the oldest commit from which to look at changes.\nmin_line: the first line of the file from which to starting blaming. The default is 1.\nmax_line: the last line of the file to which to blame. The default is 0, meaning the last line of the file.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.MergeOptions","location":"stdlib/LibGit2.html#LibGit2.MergeOptions","category":"type","text":"LibGit2.MergeOptions\n\nMatches the git_merge_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: an enum for flags describing merge behavior.  Defined in git_merge_flag_t.  The corresponding Julia enum is GIT_MERGE and has values:\nMERGE_FIND_RENAMES: detect if a file has been renamed between the common ancestor and the \"ours\" or \"theirs\" side of the merge. Allows merges where a file has been renamed.\nMERGE_FAIL_ON_CONFLICT: exit immediately if a conflict is found rather than trying to resolve it.\nMERGE_SKIP_REUC: do not write the REUC extension on the index resulting from the merge.\nMERGE_NO_RECURSIVE: if the commits being merged have multiple merge bases, use the first one, rather than trying to recursively merge the bases.\nrename_threshold: how similar two files must to consider one a rename of the other. This is an integer that sets the percentage similarity. The default is 50.\ntarget_limit: the maximum number of files to compare with to look for renames. The default is 200.\nmetric: optional custom function to use to determine the similarity between two files for rename detection.\nrecursion_limit: the upper limit on the number of merges of common ancestors to perform to try to build a new virtual merge base for the merge. The default is no limit. This field is only present on libgit2 versions newer than 0.24.0.\ndefault_driver: the merge driver to use if both sides have changed. This field is only present on libgit2 versions newer than 0.25.0.\nfile_favor: how to handle conflicting file contents for the text driver.\nMERGE_FILE_FAVOR_NORMAL: if both sides of the merge have changes to a section,  make a note of the conflict in the index which git checkout will use to create  a merge file, which the user can then reference to resolve the conflicts. This is  the default.\nMERGE_FILE_FAVOR_OURS: if both sides of the merge have changes to a section,  use the version in the \"ours\" side of the merge in the index.\nMERGE_FILE_FAVOR_THEIRS: if both sides of the merge have changes to a section,  use the version in the \"theirs\" side of the merge in the index.\nMERGE_FILE_FAVOR_UNION: if both sides of the merge have changes to a section,  include each unique line from both sides in the file which is put into the index.\nfile_flags: guidelines for merging files.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.ProxyOptions","location":"stdlib/LibGit2.html#LibGit2.ProxyOptions","category":"type","text":"LibGit2.ProxyOptions\n\nOptions for connecting through a proxy.\n\nMatches the git_proxy_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nproxytype: an enum for the type of proxy to use.  Defined in git_proxy_t.  The corresponding Julia enum is GIT_PROXY and has values:\nPROXY_NONE: do not attempt the connection through a proxy.\nPROXY_AUTO: attempt to figure out the proxy configuration from the git configuration.\nPROXY_SPECIFIED: connect using the URL given in the url field of this struct.\nDefault is to auto-detect the proxy type.\nurl: the URL of the proxy.\ncredential_cb: a pointer to a callback function which will be called if the remote requires authentication to connect.\ncertificate_cb: a pointer to a callback function which will be called if certificate verification fails. This lets the user decide whether or not to keep connecting. If the function returns 1, connecting will be allowed. If it returns 0, the connection will not be allowed. A negative value can be used to return errors.\npayload: the payload to be provided to the two callback functions.\n\nExamples\n\njulia> fo = LibGit2.FetchOptions(\n           proxy_opts = LibGit2.ProxyOptions(url = Cstring(\"https://my_proxy_url.com\")))\n\njulia> fetch(remote, \"master\", options=fo)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.PushOptions","location":"stdlib/LibGit2.html#LibGit2.PushOptions","category":"type","text":"LibGit2.PushOptions\n\nMatches the git_push_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nparallelism: if a pack file must be created, this variable sets the number of worker  threads which will be spawned by the packbuilder. If 0, the packbuilder will auto-set  the number of threads to use. The default is 1.\ncallbacks: the callbacks (e.g. for authentication with the remote) to use for the push.\nproxy_opts: only relevant if the LibGit2 version is greater than or equal to 0.25.0.  Sets options for using a proxy to communicate with a remote. See ProxyOptions  for more information.\ncustom_headers: only relevant if the LibGit2 version is greater than or equal to 0.24.0.  Extra headers needed for the push operation.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.RebaseOperation","location":"stdlib/LibGit2.html#LibGit2.RebaseOperation","category":"type","text":"LibGit2.RebaseOperation\n\nDescribes a single instruction/operation to be performed during the rebase. Matches the git_rebase_operation struct.\n\nThe fields represent:\n\noptype: the type of rebase operation currently being performed. The options are:\nREBASE_OPERATION_PICK: cherry-pick the commit in question.\nREBASE_OPERATION_REWORD: cherry-pick the commit in question, but rewrite its message using the prompt.\nREBASE_OPERATION_EDIT: cherry-pick the commit in question, but allow the user to edit the commit's contents and its message.\nREBASE_OPERATION_SQUASH: squash the commit in question into the previous commit. The commit messages of the two commits will be merged.\nREBASE_OPERATION_FIXUP: squash the commit in question into the previous commit. Only the commit message of the previous commit will be used.\nREBASE_OPERATION_EXEC: do not cherry-pick a commit. Run a command and continue if the command exits successfully.\nid: the GitHash of the commit being worked on during this rebase step.\nexec: in case REBASE_OPERATION_EXEC is used, the command to run during this step (for instance, running the test suite after each commit).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.RebaseOptions","location":"stdlib/LibGit2.html#LibGit2.RebaseOptions","category":"type","text":"LibGit2.RebaseOptions\n\nMatches the git_rebase_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nquiet: inform other git clients helping with/working on the rebase that the rebase should be done \"quietly\". Used for interoperability. The default is 1.\ninmemory: start an in-memory rebase. Callers working on the rebase can go through its steps and commit any changes, but cannot rewind HEAD or update the repository. The workdir will not be modified. Only present on libgit2 versions newer than or equal to 0.24.0.\nrewrite_notes_ref: name of the reference to notes to use to rewrite the commit notes as the rebase is finished.\nmerge_opts: merge options controlling how the trees will be merged at each rebase step.  Only present on libgit2 versions newer than or equal to 0.24.0.\ncheckout_opts: checkout options for writing files when initializing the rebase, stepping through it, and aborting it. See CheckoutOptions for more information.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.RemoteCallbacks","location":"stdlib/LibGit2.html#LibGit2.RemoteCallbacks","category":"type","text":"LibGit2.RemoteCallbacks\n\nCallback settings. Matches the git_remote_callbacks struct.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.SignatureStruct","location":"stdlib/LibGit2.html#LibGit2.SignatureStruct","category":"type","text":"LibGit2.SignatureStruct\n\nAn action signature (e.g. for committers, taggers, etc). Matches the git_signature struct.\n\nThe fields represent:\n\nname: The full name of the committer or author of the commit.\nemail: The email at which the committer/author can be contacted.\nwhen: a TimeStruct indicating when the commit was  authored/committed into the repository.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.StatusEntry","location":"stdlib/LibGit2.html#LibGit2.StatusEntry","category":"type","text":"LibGit2.StatusEntry\n\nProviding the differences between the file as it exists in HEAD and the index, and providing the differences between the index and the working directory. Matches the git_status_entry struct.\n\nThe fields represent:\n\nstatus: contains the status flags for the file, indicating if it is current, or has been changed in some way in the index or work tree.\nhead_to_index: a pointer to a DiffDelta which encapsulates the difference(s) between the file as it exists in HEAD and in the index.\nindex_to_workdir: a pointer to a DiffDelta which encapsulates the difference(s) between the file as it exists in the index and in the workdir.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.StatusOptions","location":"stdlib/LibGit2.html#LibGit2.StatusOptions","category":"type","text":"LibGit2.StatusOptions\n\nOptions to control how git_status_foreach_ext() will issue callbacks. Matches the git_status_opt_t struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nshow: a flag for which files to examine and in which order. The default is Consts.STATUS_SHOW_INDEX_AND_WORKDIR.\nflags: flags for controlling any callbacks used in a status call.\npathspec: an array of paths to use for path-matching. The behavior of the path-matching will vary depending on the values of show and flags.\nThe baseline is the tree to be used for comparison to the working directory and index; defaults to HEAD.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.StrArrayStruct","location":"stdlib/LibGit2.html#LibGit2.StrArrayStruct","category":"type","text":"LibGit2.StrArrayStruct\n\nA LibGit2 representation of an array of strings. Matches the git_strarray struct.\n\nWhen fetching data from LibGit2, a typical usage would look like:\n\nsa_ref = Ref(StrArrayStruct())\n@check ccall(..., (Ptr{StrArrayStruct},), sa_ref)\nres = convert(Vector{String}, sa_ref[])\nfree(sa_ref)\n\nIn particular, note that LibGit2.free should be called afterward on the Ref object.\n\nConversely, when passing a vector of strings to LibGit2, it is generally simplest to rely on implicit conversion:\n\nstrs = String[...]\n@check ccall(..., (Ptr{StrArrayStruct},), strs)\n\nNote that no call to free is required as the data is allocated by Julia.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.TimeStruct","location":"stdlib/LibGit2.html#LibGit2.TimeStruct","category":"type","text":"LibGit2.TimeStruct\n\nTime in a signature. Matches the git_time struct.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.add!","location":"stdlib/LibGit2.html#LibGit2.add!","category":"function","text":"add!(repo::GitRepo, files::AbstractString...; flags::Cuint = Consts.INDEX_ADD_DEFAULT)\nadd!(idx::GitIndex, files::AbstractString...; flags::Cuint = Consts.INDEX_ADD_DEFAULT)\n\nAdd all the files with paths specified by files to the index idx (or the index of the repo). If the file already exists, the index entry will be updated. If the file does not exist already, it will be newly added into the index. files may contain glob patterns which will be expanded and any matching files will be added (unless INDEX_ADD_DISABLE_PATHSPEC_MATCH is set, see below). If a file has been ignored (in .gitignore or in the config), it will not be added, unless it is already being tracked in the index, in which case it will be updated. The keyword argument flags is a set of bit-flags which control the behavior with respect to ignored files:\n\nConsts.INDEX_ADD_DEFAULT - default, described above.\nConsts.INDEX_ADD_FORCE - disregard the existing ignore rules and force addition of the file to the index even if it is already ignored.\nConsts.INDEX_ADD_CHECK_PATHSPEC - cannot be used at the same time as INDEX_ADD_FORCE. Check that each file in files which exists on disk is not in the ignore list. If one of the files is ignored, the function will return EINVALIDSPEC.\nConsts.INDEX_ADD_DISABLE_PATHSPEC_MATCH - turn off glob matching, and only add files to the index which exactly match the paths specified in files.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.add_fetch!","location":"stdlib/LibGit2.html#LibGit2.add_fetch!","category":"function","text":"add_fetch!(repo::GitRepo, rmt::GitRemote, fetch_spec::String)\n\nAdd a fetch refspec for the specified rmt. This refspec will contain information about which branch(es) to fetch from.\n\nExamples\n\njulia> LibGit2.add_fetch!(repo, remote, \"upstream\");\n\njulia> LibGit2.fetch_refspecs(remote)\nString[\"+refs/heads/*:refs/remotes/upstream/*\"]\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.add_push!","location":"stdlib/LibGit2.html#LibGit2.add_push!","category":"function","text":"add_push!(repo::GitRepo, rmt::GitRemote, push_spec::String)\n\nAdd a push refspec for the specified rmt. This refspec will contain information about which branch(es) to push to.\n\nExamples\n\njulia> LibGit2.add_push!(repo, remote, \"refs/heads/master\");\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, branch);\n\njulia> LibGit2.push_refspecs(remote)\nString[\"refs/heads/master\"]\n\nnote: Note\nYou may need to close and reopen the GitRemote in question after updating its push refspecs in order for the change to take effect and for calls to push to work.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.addblob!","location":"stdlib/LibGit2.html#LibGit2.addblob!","category":"function","text":"LibGit2.addblob!(repo::GitRepo, path::AbstractString)\n\nRead the file at path and adds it to the object database of repo as a loose blob. Return the GitHash of the resulting blob.\n\nExamples\n\nhash_str = string(commit_oid)\nblob_file = joinpath(repo_path, \".git\", \"objects\", hash_str[1:2], hash_str[3:end])\nid = LibGit2.addblob!(repo, blob_file)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.author","location":"stdlib/LibGit2.html#LibGit2.author","category":"function","text":"author(c::GitCommit)\n\nReturn the Signature of the author of the commit c. The author is the person who made changes to the relevant file(s). See also committer.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.authors","location":"stdlib/LibGit2.html#LibGit2.authors","category":"function","text":"authors(repo::GitRepo) -> Vector{Signature}\n\nReturn all authors of commits to the repo repository.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nrepo_file = open(joinpath(repo_path, test_file), \"a\")\n\nprintln(repo_file, commit_msg)\nflush(repo_file)\nLibGit2.add!(repo, test_file)\nsig = LibGit2.Signature(\"TEST\", \"TEST@TEST.COM\", round(time(), 0), 0)\ncommit_oid1 = LibGit2.commit(repo, \"commit1\"; author=sig, committer=sig)\nprintln(repo_file, randstring(10))\nflush(repo_file)\nLibGit2.add!(repo, test_file)\ncommit_oid2 = LibGit2.commit(repo, \"commit2\"; author=sig, committer=sig)\n\n# will be a Vector of [sig, sig]\nauths = LibGit2.authors(repo)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.branch","location":"stdlib/LibGit2.html#LibGit2.branch","category":"function","text":"branch(repo::GitRepo)\n\nEquivalent to git branch. Create a new branch from the current HEAD.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.branch!","location":"stdlib/LibGit2.html#LibGit2.branch!","category":"function","text":"branch!(repo::GitRepo, branch_name::AbstractString, commit::AbstractString=\"\"; kwargs...)\n\nCheckout a new git branch in the repo repository. commit is the GitHash, in string form, which will be the start of the new branch. If commit is an empty string, the current HEAD will be used.\n\nThe keyword arguments are:\n\ntrack::AbstractString=\"\": the name of the remote branch this new branch should track, if any. If empty (the default), no remote branch will be tracked.\nforce::Bool=false: if true, branch creation will be forced.\nset_head::Bool=true: if true, after the branch creation finishes the branch head will be set as the HEAD of repo.\n\nEquivalent to git checkout [-b|-B] <branch_name> [<commit>] [--track <track>].\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nLibGit2.branch!(repo, \"new_branch\", set_head=false)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.checkout!","location":"stdlib/LibGit2.html#LibGit2.checkout!","category":"function","text":"checkout!(repo::GitRepo, commit::AbstractString=\"\"; force::Bool=true)\n\nEquivalent to git checkout [-f] --detach <commit>. Checkout the git commit commit (a GitHash in string form) in repo. If force is true, force the checkout and discard any current changes. Note that this detaches the current HEAD.\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nopen(joinpath(LibGit2.path(repo), \"file1\"), \"w\") do f\n    write(f, \"111\n\")\nend\nLibGit2.add!(repo, \"file1\")\ncommit_oid = LibGit2.commit(repo, \"add file1\")\nopen(joinpath(LibGit2.path(repo), \"file1\"), \"w\") do f\n    write(f, \"112\n\")\nend\n# would fail without the force=true\n# since there are modifications to the file\nLibGit2.checkout!(repo, string(commit_oid), force=true)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.clone","location":"stdlib/LibGit2.html#LibGit2.clone","category":"function","text":"clone(repo_url::AbstractString, repo_path::AbstractString, clone_opts::CloneOptions)\n\nClone the remote repository at repo_url (which can be a remote URL or a path on the local filesystem) to repo_path (which must be a path on the local filesystem). Options for the clone, such as whether to perform a bare clone or not, are set by CloneOptions.\n\nExamples\n\nrepo_url = \"https://github.com/JuliaLang/Example.jl\"\nrepo = LibGit2.clone(repo_url, \"/home/me/projects/Example\")\n\n\n\n\n\nclone(repo_url::AbstractString, repo_path::AbstractString; kwargs...)\n\nClone a remote repository located at repo_url to the local filesystem location repo_path.\n\nThe keyword arguments are:\n\nbranch::AbstractString=\"\": which branch of the remote to clone, if not the default repository branch (usually master).\nisbare::Bool=false: if true, clone the remote as a bare repository, which will make repo_path itself the git directory instead of repo_path/.git. This means that a working tree cannot be checked out. Plays the role of the git CLI argument --bare.\nremote_cb::Ptr{Cvoid}=C_NULL: a callback which will be used to create the remote before it is cloned. If C_NULL (the default), no attempt will be made to create the remote - it will be assumed to already exist.\ncredentials::Creds=nothing: provides credentials and/or settings when authenticating against a private repository.\ncallbacks::Callbacks=Callbacks(): user provided callbacks and payloads.\n\nEquivalent to git clone [-b <branch>] [--bare] <repo_url> <repo_path>.\n\nExamples\n\nrepo_url = \"https://github.com/JuliaLang/Example.jl\"\nrepo1 = LibGit2.clone(repo_url, \"test_path\")\nrepo2 = LibGit2.clone(repo_url, \"test_path\", isbare=true)\njulia_url = \"https://github.com/JuliaLang/julia\"\njulia_repo = LibGit2.clone(julia_url, \"julia_path\", branch=\"release-0.6\")\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.commit","location":"stdlib/LibGit2.html#LibGit2.commit","category":"function","text":"commit(repo::GitRepo, msg::AbstractString; kwargs...) -> GitHash\n\nWrapper around git_commit_create. Create a commit in the repository repo. msg is the commit message. Return the OID of the new commit.\n\nThe keyword arguments are:\n\nrefname::AbstractString=Consts.HEAD_FILE: if not NULL, the name of the reference to update to point to the new commit. For example, \"HEAD\" will update the HEAD of the current branch. If the reference does not yet exist, it will be created.\nauthor::Signature = Signature(repo) is a Signature containing information about the person who authored the commit.\ncommitter::Signature = Signature(repo) is a Signature containing information about the person who committed the commit to the repository. Not necessarily the same as author, for instance if author emailed a patch to committer who committed it.\ntree_id::GitHash = GitHash() is a git tree to use to create the commit, showing its ancestry and relationship with any other history. tree must belong to repo.\nparent_ids::Vector{GitHash}=GitHash[] is a list of commits by GitHash to use as parent commits for the new one, and may be empty. A commit might have multiple parents if it is a merge commit, for example.\n\n\n\n\n\nLibGit2.commit(rb::GitRebase, sig::GitSignature)\n\nCommit the current patch to the rebase rb, using sig as the committer. Is silent if the commit has already been applied.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.committer","location":"stdlib/LibGit2.html#LibGit2.committer","category":"function","text":"committer(c::GitCommit)\n\nReturn the Signature of the committer of the commit c. The committer is the person who committed the changes originally authored by the author, but need not be the same as the author, for example, if the author emailed a patch to a committer who committed it.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.count","location":"stdlib/LibGit2.html#LibGit2.count","category":"function","text":"LibGit2.count(f::Function, walker::GitRevWalker; oid::GitHash=GitHash(), by::Cint=Consts.SORT_NONE, rev::Bool=false)\n\nUsing the GitRevWalker walker to \"walk\" over every commit in the repository's history, find the number of commits which return true when f is applied to them. The keyword arguments are:     * oid: The GitHash of the commit to begin the walk from. The default is to use       push_head! and therefore the HEAD commit and all its ancestors.     * by: The sorting method. The default is not to sort. Other options are to sort by       topology (LibGit2.Consts.SORT_TOPOLOGICAL), to sort forwards in time       (LibGit2.Consts.SORT_TIME, most ancient first) or to sort backwards in time       (LibGit2.Consts.SORT_REVERSE, most recent first).     * rev: Whether to reverse the sorted order (for instance, if topological sorting is used).\n\nExamples\n\ncnt = LibGit2.with(LibGit2.GitRevWalker(repo)) do walker\n    count((oid, repo)->(oid == commit_oid1), walker, oid=commit_oid1, by=LibGit2.Consts.SORT_TIME)\nend\n\ncount finds the number of commits along the walk with a certain GitHash commit_oid1, starting the walk from that commit and moving forwards in time from it. Since the GitHash is unique to a commit, cnt will be 1.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.counthunks","location":"stdlib/LibGit2.html#LibGit2.counthunks","category":"function","text":"counthunks(blame::GitBlame)\n\nReturn the number of distinct \"hunks\" with a file. A hunk may contain multiple lines. A hunk is usually a piece of a file that was added/changed/removed together, for example, a function added to a source file or an inner loop that was optimized out of that function later.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.create_branch","location":"stdlib/LibGit2.html#LibGit2.create_branch","category":"function","text":"LibGit2.create_branch(repo::GitRepo, bname::AbstractString, commit_obj::GitCommit; force::Bool=false)\n\nCreate a new branch in the repository repo with name bname, which points to commit commit_obj (which has to be part of repo). If force is true, overwrite an existing branch named bname if it exists. If force is false and a branch already exists named bname, this function will throw an error.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.credentials_callback","location":"stdlib/LibGit2.html#LibGit2.credentials_callback","category":"function","text":"credential_callback(...) -> Cint\n\nA LibGit2 credential callback function which provides different credential acquisition functionality w.r.t. a connection protocol. The payload_ptr is required to contain a LibGit2.CredentialPayload object which will keep track of state and settings.\n\nThe allowed_types contains a bitmask of LibGit2.Consts.GIT_CREDTYPE values specifying which authentication methods should be attempted.\n\nCredential authentication is done in the following order (if supported):\n\nSSH agent\nSSH private/public key pair\nUsername/password plain text\n\nIf a user is presented with a credential prompt they can abort the prompt by typing ^D (pressing the control key together with the d key).\n\nNote: Due to the specifics of the libgit2 authentication procedure, when authentication fails, this function is called again without any indication whether authentication was successful or not. To avoid an infinite loop from repeatedly using the same faulty credentials, we will keep track of state using the payload.\n\nFor addition details see the LibGit2 guide on authenticating against a server.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.credentials_cb","location":"stdlib/LibGit2.html#LibGit2.credentials_cb","category":"function","text":"C function pointer for credentials_callback\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.default_signature","location":"stdlib/LibGit2.html#LibGit2.default_signature","category":"function","text":"Return signature object. Free it after use.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.delete_branch","location":"stdlib/LibGit2.html#LibGit2.delete_branch","category":"function","text":"LibGit2.delete_branch(branch::GitReference)\n\nDelete the branch pointed to by branch.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.diff_files","location":"stdlib/LibGit2.html#LibGit2.diff_files","category":"function","text":"diff_files(repo::GitRepo, branch1::AbstractString, branch2::AbstractString; kwarg...) -> Vector{AbstractString}\n\nShow which files have changed in the git repository repo between branches branch1 and branch2.\n\nThe keyword argument is:\n\nfilter::Set{Consts.DELTA_STATUS}=Set([Consts.DELTA_ADDED, Consts.DELTA_MODIFIED, Consts.DELTA_DELETED])), and it sets options for the diff. The default is to show files added, modified, or deleted.\n\nReturn only the names of the files which have changed, not their contents.\n\nExamples\n\nLibGit2.branch!(repo, \"branch/a\")\nLibGit2.branch!(repo, \"branch/b\")\n# add a file to repo\nopen(joinpath(LibGit2.path(repo),\"file\"),\"w\") do f\n    write(f, \"hello repo\n\")\nend\nLibGit2.add!(repo, \"file\")\nLibGit2.commit(repo, \"add file\")\n# returns [\"file\"]\nfilt = Set([LibGit2.Consts.DELTA_ADDED])\nfiles = LibGit2.diff_files(repo, \"branch/a\", \"branch/b\", filter=filt)\n# returns [] because existing files weren't modified\nfilt = Set([LibGit2.Consts.DELTA_MODIFIED])\nfiles = LibGit2.diff_files(repo, \"branch/a\", \"branch/b\", filter=filt)\n\nEquivalent to git diff --name-only --diff-filter=<filter> <branch1> <branch2>.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.entryid","location":"stdlib/LibGit2.html#LibGit2.entryid","category":"function","text":"entryid(te::GitTreeEntry)\n\nReturn the GitHash of the object to which te refers.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.entrytype","location":"stdlib/LibGit2.html#LibGit2.entrytype","category":"function","text":"entrytype(te::GitTreeEntry)\n\nReturn the type of the object to which te refers. The result will be one of the types which objtype returns, e.g. a GitTree or GitBlob.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.fetch","location":"stdlib/LibGit2.html#LibGit2.fetch","category":"function","text":"fetch(rmt::GitRemote, refspecs; options::FetchOptions=FetchOptions(), msg=\"\")\n\nFetch from the specified rmt remote git repository, using refspecs to determine which remote branch(es) to fetch. The keyword arguments are:\n\noptions: determines the options for the fetch, e.g. whether to prune afterwards. See FetchOptions for more information.\nmsg: a message to insert into the reflogs.\n\n\n\n\n\nfetch(repo::GitRepo; kwargs...)\n\nFetches updates from an upstream of the repository repo.\n\nThe keyword arguments are:\n\nremote::AbstractString=\"origin\": which remote, specified by name, of repo to fetch from. If this is empty, the URL will be used to construct an anonymous remote.\nremoteurl::AbstractString=\"\": the URL of remote. If not specified, will be assumed based on the given name of remote.\nrefspecs=AbstractString[]: determines properties of the fetch.\ncredentials=nothing: provides credentials and/or settings when authenticating against a private remote.\ncallbacks=Callbacks(): user provided callbacks and payloads.\n\nEquivalent to git fetch [<remoteurl>|<repo>] [<refspecs>].\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.fetchheads","location":"stdlib/LibGit2.html#LibGit2.fetchheads","category":"function","text":"fetchheads(repo::GitRepo) -> Vector{FetchHead}\n\nReturn the list of all the fetch heads for repo, each represented as a FetchHead, including their names, URLs, and merge statuses.\n\nExamples\n\njulia> fetch_heads = LibGit2.fetchheads(repo);\n\njulia> fetch_heads[1].name\n\"refs/heads/master\"\n\njulia> fetch_heads[1].ismerge\ntrue\n\njulia> fetch_heads[2].name\n\"refs/heads/test_branch\"\n\njulia> fetch_heads[2].ismerge\nfalse\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.fetch_refspecs","location":"stdlib/LibGit2.html#LibGit2.fetch_refspecs","category":"function","text":"fetch_refspecs(rmt::GitRemote) -> Vector{String}\n\nGet the fetch refspecs for the specified rmt. These refspecs contain information about which branch(es) to fetch from.\n\nExamples\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, \"upstream\");\n\njulia> LibGit2.add_fetch!(repo, remote, \"upstream\");\n\njulia> LibGit2.fetch_refspecs(remote)\nString[\"+refs/heads/*:refs/remotes/upstream/*\"]\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.fetchhead_foreach_cb","location":"stdlib/LibGit2.html#LibGit2.fetchhead_foreach_cb","category":"function","text":"C function pointer for fetchhead_foreach_callback\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.merge_base","location":"stdlib/LibGit2.html#LibGit2.merge_base","category":"function","text":"merge_base(repo::GitRepo, one::AbstractString, two::AbstractString) -> GitHash\n\nFind a merge base (a common ancestor) between the commits one and two. one and two may both be in string form. Return the GitHash of the merge base.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.merge!","location":"stdlib/LibGit2.html#LibGit2.merge!-Tuple{GitRepo}","category":"method","text":"merge!(repo::GitRepo; kwargs...) -> Bool\n\nPerform a git merge on the repository repo, merging commits with diverging history into the current branch. Return true if the merge succeeded, false if not.\n\nThe keyword arguments are:\n\ncommittish::AbstractString=\"\": Merge the named commit(s) in committish.\nbranch::AbstractString=\"\": Merge the branch branch and all its commits since it diverged from the current branch.\nfastforward::Bool=false: If fastforward is true, only merge if the merge is a fast-forward (the current branch head is an ancestor of the commits to be merged), otherwise refuse to merge and return false. This is equivalent to the git CLI option --ff-only.\nmerge_opts::MergeOptions=MergeOptions(): merge_opts specifies options for the merge, such as merge strategy in case of conflicts.\ncheckout_opts::CheckoutOptions=CheckoutOptions(): checkout_opts specifies options for the checkout step.\n\nEquivalent to git merge [--ff-only] [<committish> | <branch>].\n\nnote: Note\nIf you specify a branch, this must be done in reference format, since the string will be turned into a GitReference. For example, if you wanted to merge branch branch_a, you would call merge!(repo, branch=\"refs/heads/branch_a\").\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.merge!","location":"stdlib/LibGit2.html#LibGit2.merge!-Tuple{GitRepo, Vector{LibGit2.GitAnnotated}}","category":"method","text":"merge!(repo::GitRepo, anns::Vector{GitAnnotated}; kwargs...) -> Bool\n\nMerge changes from the annotated commits (captured as GitAnnotated objects) anns into the HEAD of the repository repo. The keyword arguments are:\n\nmerge_opts::MergeOptions = MergeOptions(): options for how to perform the merge, including whether fastforwarding is allowed. See MergeOptions for more information.\ncheckout_opts::CheckoutOptions = CheckoutOptions(): options for how to perform the checkout. See CheckoutOptions for more information.\n\nanns may refer to remote or local branch heads. Return true if the merge is successful, otherwise return false (for instance, if no merge is possible because the branches have no common ancestor).\n\nExamples\n\nupst_ann = LibGit2.GitAnnotated(repo, \"branch/a\")\n\n# merge the branch in\nLibGit2.merge!(repo, [upst_ann])\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.merge!","location":"stdlib/LibGit2.html#LibGit2.merge!-Tuple{GitRepo, Vector{LibGit2.GitAnnotated}, Bool}","category":"method","text":"merge!(repo::GitRepo, anns::Vector{GitAnnotated}, fastforward::Bool; kwargs...) -> Bool\n\nMerge changes from the annotated commits (captured as GitAnnotated objects) anns into the HEAD of the repository repo. If fastforward is true, only a fastforward merge is allowed. In this case, if conflicts occur, the merge will fail. Otherwise, if fastforward is false, the merge may produce a conflict file which the user will need to resolve.\n\nThe keyword arguments are:\n\nmerge_opts::MergeOptions = MergeOptions(): options for how to perform the merge, including whether fastforwarding is allowed. See MergeOptions for more information.\ncheckout_opts::CheckoutOptions = CheckoutOptions(): options for how to perform the checkout. See CheckoutOptions for more information.\n\nanns may refer to remote or local branch heads. Return true if the merge is successful, otherwise return false (for instance, if no merge is possible because the branches have no common ancestor).\n\nExamples\n\nupst_ann_1 = LibGit2.GitAnnotated(repo, \"branch/a\")\n\n# merge the branch in, fastforward\nLibGit2.merge!(repo, [upst_ann_1], true)\n\n# merge conflicts!\nupst_ann_2 = LibGit2.GitAnnotated(repo, \"branch/b\")\n# merge the branch in, try to fastforward\nLibGit2.merge!(repo, [upst_ann_2], true) # will return false\nLibGit2.merge!(repo, [upst_ann_2], false) # will return true\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.ffmerge!","location":"stdlib/LibGit2.html#LibGit2.ffmerge!","category":"function","text":"ffmerge!(repo::GitRepo, ann::GitAnnotated)\n\nFastforward merge changes into current HEAD. This is only possible if the commit referred to by ann is descended from the current HEAD (e.g. if pulling changes from a remote branch which is simply ahead of the local branch tip).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.fullname","location":"stdlib/LibGit2.html#LibGit2.fullname","category":"function","text":"LibGit2.fullname(ref::GitReference)\n\nReturn the name of the reference pointed to by the symbolic reference ref. If ref is not a symbolic reference, return an empty string.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.features","location":"stdlib/LibGit2.html#LibGit2.features","category":"function","text":"features()\n\nReturn a list of git features the current version of libgit2 supports, such as threading or using HTTPS or SSH.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.filename","location":"stdlib/LibGit2.html#LibGit2.filename","category":"function","text":"filename(te::GitTreeEntry)\n\nReturn the filename of the object on disk to which te refers.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.filemode","location":"stdlib/LibGit2.html#LibGit2.filemode","category":"function","text":"filemode(te::GitTreeEntry) -> Cint\n\nReturn the UNIX filemode of the object on disk to which te refers as an integer.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.gitdir","location":"stdlib/LibGit2.html#LibGit2.gitdir","category":"function","text":"LibGit2.gitdir(repo::GitRepo)\n\nReturn the location of the \"git\" files of repo:\n\nfor normal repositories, this is the location of the .git folder.\nfor bare repositories, this is the location of the repository itself.\n\nSee also workdir, path.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.git_url","location":"stdlib/LibGit2.html#LibGit2.git_url","category":"function","text":"LibGit2.git_url(; kwargs...) -> String\n\nCreate a string based upon the URL components provided. When the scheme keyword is not provided the URL produced will use the alternative scp-like syntax.\n\nKeywords\n\nscheme::AbstractString=\"\": the URL scheme which identifies the protocol to be used. For HTTP use \"http\", SSH use \"ssh\", etc. When scheme is not provided the output format will be \"ssh\" but using the scp-like syntax.\nusername::AbstractString=\"\": the username to use in the output if provided.\npassword::AbstractString=\"\": the password to use in the output if provided.\nhost::AbstractString=\"\": the hostname to use in the output. A hostname is required to be specified.\nport::Union{AbstractString,Integer}=\"\": the port number to use in the output if provided. Cannot be specified when using the scp-like syntax.\npath::AbstractString=\"\": the path to use in the output if provided.\n\nwarning: Warning\nAvoid using passwords in URLs. Unlike the credential objects, Julia is not able to securely zero or destroy the sensitive data after use and the password may remain in memory; possibly to be exposed by an uninitialized memory.\n\nExamples\n\njulia> LibGit2.git_url(username=\"git\", host=\"github.com\", path=\"JuliaLang/julia.git\")\n\"git@github.com:JuliaLang/julia.git\"\n\njulia> LibGit2.git_url(scheme=\"https\", host=\"github.com\", path=\"/JuliaLang/julia.git\")\n\"https://github.com/JuliaLang/julia.git\"\n\njulia> LibGit2.git_url(scheme=\"ssh\", username=\"git\", host=\"github.com\", port=2222, path=\"JuliaLang/julia.git\")\n\"ssh://git@github.com:2222/JuliaLang/julia.git\"\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.@githash_str","location":"stdlib/LibGit2.html#LibGit2.@githash_str","category":"macro","text":"@githash_str -> AbstractGitHash\n\nConstruct a git hash object from the given string, returning a GitShortHash if the string is shorter than 40 hexadecimal digits, otherwise a GitHash.\n\nExamples\n\njulia> LibGit2.githash\"d114feb74ce633\"\nGitShortHash(\"d114feb74ce633\")\n\njulia> LibGit2.githash\"d114feb74ce63307afe878a5228ad014e0289a85\"\nGitHash(\"d114feb74ce63307afe878a5228ad014e0289a85\")\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.head","location":"stdlib/LibGit2.html#LibGit2.head","category":"function","text":"LibGit2.head(repo::GitRepo) -> GitReference\n\nReturn a GitReference to the current HEAD of repo.\n\n\n\n\n\nhead(pkg::AbstractString) -> String\n\nReturn current HEAD GitHash of the pkg repo as a string.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.head!","location":"stdlib/LibGit2.html#LibGit2.head!","category":"function","text":"LibGit2.head!(repo::GitRepo, ref::GitReference) -> GitReference\n\nSet the HEAD of repo to the object pointed to by ref.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.head_oid","location":"stdlib/LibGit2.html#LibGit2.head_oid","category":"function","text":"LibGit2.head_oid(repo::GitRepo) -> GitHash\n\nLookup the object id of the current HEAD of git repository repo.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.headname","location":"stdlib/LibGit2.html#LibGit2.headname","category":"function","text":"LibGit2.headname(repo::GitRepo)\n\nLookup the name of the current HEAD of git repository repo. If repo is currently detached, return the name of the HEAD it's detached from.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.init","location":"stdlib/LibGit2.html#LibGit2.init","category":"function","text":"LibGit2.init(path::AbstractString, bare::Bool=false) -> GitRepo\n\nOpen a new git repository at path. If bare is false, the working tree will be created in path/.git. If bare is true, no working directory will be created.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.is_ancestor_of","location":"stdlib/LibGit2.html#LibGit2.is_ancestor_of","category":"function","text":"is_ancestor_of(a::AbstractString, b::AbstractString, repo::GitRepo) -> Bool\n\nReturn true if a, a GitHash in string form, is an ancestor of b, a GitHash in string form.\n\nExamples\n\njulia> repo = LibGit2.GitRepo(repo_path);\n\njulia> LibGit2.add!(repo, test_file1);\n\njulia> commit_oid1 = LibGit2.commit(repo, \"commit1\");\n\njulia> LibGit2.add!(repo, test_file2);\n\njulia> commit_oid2 = LibGit2.commit(repo, \"commit2\");\n\njulia> LibGit2.is_ancestor_of(string(commit_oid1), string(commit_oid2), repo)\ntrue\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.isbinary","location":"stdlib/LibGit2.html#LibGit2.isbinary","category":"function","text":"isbinary(blob::GitBlob) -> Bool\n\nUse a heuristic to guess if a file is binary: searching for NULL bytes and looking for a reasonable ratio of printable to non-printable characters among the first 8000 bytes.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.iscommit","location":"stdlib/LibGit2.html#LibGit2.iscommit","category":"function","text":"iscommit(id::AbstractString, repo::GitRepo) -> Bool\n\nCheck if commit id (which is a GitHash in string form) is in the repository.\n\nExamples\n\njulia> repo = LibGit2.GitRepo(repo_path);\n\njulia> LibGit2.add!(repo, test_file);\n\njulia> commit_oid = LibGit2.commit(repo, \"add test_file\");\n\njulia> LibGit2.iscommit(string(commit_oid), repo)\ntrue\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.isdiff","location":"stdlib/LibGit2.html#LibGit2.isdiff","category":"function","text":"LibGit2.isdiff(repo::GitRepo, treeish::AbstractString, pathspecs::AbstractString=\"\"; cached::Bool=false)\n\nChecks if there are any differences between the tree specified by treeish and the tracked files in the working tree (if cached=false) or the index (if cached=true). pathspecs are the specifications for options for the diff.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nLibGit2.isdiff(repo, \"HEAD\") # should be false\nopen(joinpath(repo_path, new_file), \"a\") do f\n    println(f, \"here's my cool new file\")\nend\nLibGit2.isdiff(repo, \"HEAD\") # now true\n\nEquivalent to git diff-index <treeish> [-- <pathspecs>].\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.isdirty","location":"stdlib/LibGit2.html#LibGit2.isdirty","category":"function","text":"LibGit2.isdirty(repo::GitRepo, pathspecs::AbstractString=\"\"; cached::Bool=false) -> Bool\n\nCheck if there have been any changes to tracked files in the working tree (if cached=false) or the index (if cached=true). pathspecs are the specifications for options for the diff.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nLibGit2.isdirty(repo) # should be false\nopen(joinpath(repo_path, new_file), \"a\") do f\n    println(f, \"here's my cool new file\")\nend\nLibGit2.isdirty(repo) # now true\nLibGit2.isdirty(repo, new_file) # now true\n\nEquivalent to git diff-index HEAD [-- <pathspecs>].\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.isorphan","location":"stdlib/LibGit2.html#LibGit2.isorphan","category":"function","text":"LibGit2.isorphan(repo::GitRepo)\n\nCheck if the current branch is an \"orphan\" branch, i.e. has no commits. The first commit to this branch will have no parents.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.isset","location":"stdlib/LibGit2.html#LibGit2.isset","category":"function","text":"isset(val::Integer, flag::Integer)\n\nTest whether the bits of val indexed by flag are set (1) or unset (0).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.iszero","location":"stdlib/LibGit2.html#LibGit2.iszero","category":"function","text":"iszero(id::GitHash) -> Bool\n\nDetermine whether all hexadecimal digits of the given GitHash are zero.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.lookup_branch","location":"stdlib/LibGit2.html#LibGit2.lookup_branch","category":"function","text":"lookup_branch(repo::GitRepo, branch_name::AbstractString, remote::Bool=false) -> Union{GitReference, Nothing}\n\nDetermine if the branch specified by branch_name exists in the repository repo. If remote is true, repo is assumed to be a remote git repository. Otherwise, it is part of the local filesystem.\n\nReturn either a GitReference to the requested branch if it exists, or nothing if not.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.map","location":"stdlib/LibGit2.html#LibGit2.map","category":"function","text":"LibGit2.map(f::Function, walker::GitRevWalker; oid::GitHash=GitHash(), range::AbstractString=\"\", by::Cint=Consts.SORT_NONE, rev::Bool=false)\n\nUsing the GitRevWalker walker to \"walk\" over every commit in the repository's history, apply f to each commit in the walk. The keyword arguments are:     * oid: The GitHash of the commit to begin the walk from. The default is to use       push_head! and therefore the HEAD commit and all its ancestors.     * range: A range of GitHashs in the format oid1..oid2. f will be       applied to all commits between the two.     * by: The sorting method. The default is not to sort. Other options are to sort by       topology (LibGit2.Consts.SORT_TOPOLOGICAL), to sort forwards in time       (LibGit2.Consts.SORT_TIME, most ancient first) or to sort backwards in time       (LibGit2.Consts.SORT_REVERSE, most recent first).     * rev: Whether to reverse the sorted order (for instance, if topological sorting is used).\n\nExamples\n\noids = LibGit2.with(LibGit2.GitRevWalker(repo)) do walker\n    LibGit2.map((oid, repo)->string(oid), walker, by=LibGit2.Consts.SORT_TIME)\nend\n\nHere, map visits each commit using the GitRevWalker and finds its GitHash.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.mirror_callback","location":"stdlib/LibGit2.html#LibGit2.mirror_callback","category":"function","text":"Mirror callback function\n\nFunction sets +refs/*:refs/* refspecs and mirror flag for remote reference.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.mirror_cb","location":"stdlib/LibGit2.html#LibGit2.mirror_cb","category":"function","text":"C function pointer for mirror_callback\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.message","location":"stdlib/LibGit2.html#LibGit2.message","category":"function","text":"message(c::GitCommit, raw::Bool=false)\n\nReturn the commit message describing the changes made in commit c. If raw is false, return a slightly \"cleaned up\" message (which has any leading newlines removed). If raw is true, the message is not stripped of any such newlines.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.merge_analysis","location":"stdlib/LibGit2.html#LibGit2.merge_analysis","category":"function","text":"merge_analysis(repo::GitRepo, anns::Vector{GitAnnotated}) -> analysis, preference\n\nRun analysis on the branches pointed to by the annotated branch tips anns and determine under what circumstances they can be merged. For instance, if anns[1] is simply an ancestor of ann[2], then merge_analysis will report that a fast-forward merge is possible.\n\nReturn two outputs, analysis and preference. analysis has several possible values:     * MERGE_ANALYSIS_NONE: it is not possible to merge the elements of anns.     * MERGE_ANALYSIS_NORMAL: a regular merge, when HEAD and the commits that the       user wishes to merge have all diverged from a common ancestor. In this case the       changes have to be resolved and conflicts may occur.     * MERGE_ANALYSIS_UP_TO_DATE: all the input commits the user wishes to merge can       be reached from HEAD, so no merge needs to be performed.     * MERGE_ANALYSIS_FASTFORWARD: the input commit is a descendant of HEAD and so no       merge needs to be performed - instead, the user can simply checkout the       input commit(s).     * MERGE_ANALYSIS_UNBORN: the HEAD of the repository refers to a commit which does not       exist. It is not possible to merge, but it may be possible to checkout the input       commits. preference also has several possible values:     * MERGE_PREFERENCE_NONE: the user has no preference.     * MERGE_PREFERENCE_NO_FASTFORWARD: do not allow any fast-forward merges.     * MERGE_PREFERENCE_FASTFORWARD_ONLY: allow only fast-forward merges and no       other type (which may introduce conflicts). preference can be controlled through the repository or global git configuration.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.name","location":"stdlib/LibGit2.html#LibGit2.name","category":"function","text":"LibGit2.name(ref::GitReference)\n\nReturn the full name of ref.\n\n\n\n\n\nname(rmt::GitRemote)\n\nGet the name of a remote repository, for instance \"origin\". If the remote is anonymous (see GitRemoteAnon) the name will be an empty string \"\".\n\nExamples\n\njulia> repo_url = \"https://github.com/JuliaLang/Example.jl\";\n\njulia> repo = LibGit2.clone(cache_repo, \"test_directory\");\n\njulia> remote = LibGit2.GitRemote(repo, \"origin\", repo_url);\n\njulia> name(remote)\n\"origin\"\n\n\n\n\n\nLibGit2.name(tag::GitTag)\n\nThe name of tag (e.g. \"v0.5\").\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.need_update","location":"stdlib/LibGit2.html#LibGit2.need_update","category":"function","text":"need_update(repo::GitRepo)\n\nEquivalent to git update-index. Return true if repo needs updating.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.objtype","location":"stdlib/LibGit2.html#LibGit2.objtype","category":"function","text":"objtype(obj_type::Consts.OBJECT)\n\nReturn the type corresponding to the enum value.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.path","location":"stdlib/LibGit2.html#LibGit2.path","category":"function","text":"LibGit2.path(repo::GitRepo)\n\nReturn the base file path of the repository repo.\n\nfor normal repositories, this will typically be the parent directory of the \".git\" directory (note: this may be different than the working directory, see workdir for more details).\nfor bare repositories, this is the location of the \"git\" files.\n\nSee also gitdir, workdir.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.peel","location":"stdlib/LibGit2.html#LibGit2.peel","category":"function","text":"peel([T,] ref::GitReference)\n\nRecursively peel ref until an object of type T is obtained. If no T is provided, then ref will be peeled until an object other than a GitTag is obtained.\n\nA GitTag will be peeled to the object it references.\nA GitCommit will be peeled to a GitTree.\n\nnote: Note\nOnly annotated tags can be peeled to GitTag objects. Lightweight tags (the default) are references under refs/tags/ which point directly to GitCommit objects.\n\n\n\n\n\npeel([T,] obj::GitObject)\n\nRecursively peel obj until an object of type T is obtained. If no T is provided, then obj will be peeled until the type changes.\n\nA GitTag will be peeled to the object it references.\nA GitCommit will be peeled to a GitTree.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.posixpath","location":"stdlib/LibGit2.html#LibGit2.posixpath","category":"function","text":"LibGit2.posixpath(path)\n\nStandardise the path string path to use POSIX separators.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.push","location":"stdlib/LibGit2.html#LibGit2.push","category":"function","text":"push(rmt::GitRemote, refspecs; force::Bool=false, options::PushOptions=PushOptions())\n\nPush to the specified rmt remote git repository, using refspecs to determine which remote branch(es) to push to. The keyword arguments are:\n\nforce: if true, a force-push will occur, disregarding conflicts.\noptions: determines the options for the push, e.g. which proxy headers to use. See PushOptions for more information.\n\nnote: Note\nYou can add information about the push refspecs in two other ways: by setting an option in the repository's GitConfig (with push.default as the key) or by calling add_push!. Otherwise you will need to explicitly specify a push refspec in the call to push for it to have any effect, like so: LibGit2.push(repo, refspecs=[\"refs/heads/master\"]).\n\n\n\n\n\npush(repo::GitRepo; kwargs...)\n\nPushes updates to an upstream of repo.\n\nThe keyword arguments are:\n\nremote::AbstractString=\"origin\": the name of the upstream remote to push to.\nremoteurl::AbstractString=\"\": the URL of remote.\nrefspecs=AbstractString[]: determines properties of the push.\nforce::Bool=false: determines if the push will be a force push,  overwriting the remote branch.\ncredentials=nothing: provides credentials and/or settings when authenticating against  a private remote.\ncallbacks=Callbacks(): user provided callbacks and payloads.\n\nEquivalent to git push [<remoteurl>|<repo>] [<refspecs>].\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.push!","location":"stdlib/LibGit2.html#LibGit2.push!-Tuple{LibGit2.GitRevWalker, LibGit2.GitHash}","category":"method","text":"LibGit2.push!(w::GitRevWalker, cid::GitHash)\n\nStart the GitRevWalker walker at commit cid. This function can be used to apply a function to all commits since a certain year, by passing the first commit of that year as cid and then passing the resulting w to map.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.push_head!","location":"stdlib/LibGit2.html#LibGit2.push_head!","category":"function","text":"LibGit2.push_head!(w::GitRevWalker)\n\nPush the HEAD commit and its ancestors onto the GitRevWalker w. This ensures that HEAD and all its ancestor commits will be encountered during the walk.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.push_refspecs","location":"stdlib/LibGit2.html#LibGit2.push_refspecs","category":"function","text":"push_refspecs(rmt::GitRemote) -> Vector{String}\n\nGet the push refspecs for the specified rmt. These refspecs contain information about which branch(es) to push to.\n\nExamples\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, \"upstream\");\n\njulia> LibGit2.add_push!(repo, remote, \"refs/heads/master\");\n\njulia> close(remote);\n\njulia> remote = LibGit2.get(LibGit2.GitRemote, repo, \"upstream\");\n\njulia> LibGit2.push_refspecs(remote)\nString[\"refs/heads/master\"]\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.raw","location":"stdlib/LibGit2.html#LibGit2.raw","category":"function","text":"raw(id::GitHash) -> Vector{UInt8}\n\nObtain the raw bytes of the GitHash as a vector of length 20.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.read_tree!","location":"stdlib/LibGit2.html#LibGit2.read_tree!","category":"function","text":"LibGit2.read_tree!(idx::GitIndex, tree::GitTree)\nLibGit2.read_tree!(idx::GitIndex, treehash::AbstractGitHash)\n\nRead the tree tree (or the tree pointed to by treehash in the repository owned by idx) into the index idx. The current index contents will be replaced.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.rebase!","location":"stdlib/LibGit2.html#LibGit2.rebase!","category":"function","text":"LibGit2.rebase!(repo::GitRepo, upstream::AbstractString=\"\", newbase::AbstractString=\"\")\n\nAttempt an automatic merge rebase of the current branch, from upstream if provided, or otherwise from the upstream tracking branch. newbase is the branch to rebase onto. By default this is upstream.\n\nIf any conflicts arise which cannot be automatically resolved, the rebase will abort, leaving the repository and working tree in its original state, and the function will throw a GitError. This is roughly equivalent to the following command line statement:\n\ngit rebase --merge [<upstream>]\nif [ -d \".git/rebase-merge\" ]; then\n    git rebase --abort\nfi\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.ref_list","location":"stdlib/LibGit2.html#LibGit2.ref_list","category":"function","text":"LibGit2.ref_list(repo::GitRepo) -> Vector{String}\n\nGet a list of all reference names in the repo repository.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.reftype","location":"stdlib/LibGit2.html#LibGit2.reftype","category":"function","text":"LibGit2.reftype(ref::GitReference) -> Cint\n\nReturn a Cint corresponding to the type of ref:\n\n0 if the reference is invalid\n1 if the reference is an object id\n2 if the reference is symbolic\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.remotes","location":"stdlib/LibGit2.html#LibGit2.remotes","category":"function","text":"LibGit2.remotes(repo::GitRepo)\n\nReturn a vector of the names of the remotes of repo.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.remove!","location":"stdlib/LibGit2.html#LibGit2.remove!","category":"function","text":"remove!(repo::GitRepo, files::AbstractString...)\nremove!(idx::GitIndex, files::AbstractString...)\n\nRemove all the files with paths specified by files in the index idx (or the index of the repo).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.reset","location":"stdlib/LibGit2.html#LibGit2.reset","category":"function","text":"reset(val::Integer, flag::Integer)\n\nUnset the bits of val indexed by flag, returning them to 0.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.reset!","location":"stdlib/LibGit2.html#LibGit2.reset!","category":"function","text":"reset!(payload, [config]) -> CredentialPayload\n\nReset the payload state back to the initial values so that it can be used again within the credential callback. If a config is provided the configuration will also be updated.\n\n\n\n\n\nUpdates some entries, determined by the pathspecs, in the index from the target commit tree.\n\n\n\n\n\nSets the current head to the specified commit oid and optionally resets the index and working tree to match.\n\n\n\n\n\ngit reset [<committish>] [–] <pathspecs>... \n\n\n\n\n\nreset!(repo::GitRepo, id::GitHash, mode::Cint=Consts.RESET_MIXED)\n\nReset the repository repo to its state at id, using one of three modes set by mode:\n\nConsts.RESET_SOFT - move HEAD to id.\nConsts.RESET_MIXED - default, move HEAD to id and reset the index to id.\nConsts.RESET_HARD - move HEAD to id, reset the index to id, and discard all working changes.\n\nExamples\n\n# fetch changes\nLibGit2.fetch(repo)\nisfile(joinpath(repo_path, our_file)) # will be false\n\n# fastforward merge the changes\nLibGit2.merge!(repo, fastforward=true)\n\n# because there was not any file locally, but there is\n# a file remotely, we need to reset the branch\nhead_oid = LibGit2.head_oid(repo)\nnew_head = LibGit2.reset!(repo, head_oid, LibGit2.Consts.RESET_HARD)\n\nIn this example, the remote which is being fetched from does have a file called our_file in its index, which is why we must reset.\n\nEquivalent to git reset [--soft | --mixed | --hard] <id>.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nhead_oid = LibGit2.head_oid(repo)\nopen(joinpath(repo_path, \"file1\"), \"w\") do f\n    write(f, \"111\n\")\nend\nLibGit2.add!(repo, \"file1\")\nmode = LibGit2.Consts.RESET_HARD\n# will discard the changes to file1\n# and unstage it\nnew_head = LibGit2.reset!(repo, head_oid, mode)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.restore","location":"stdlib/LibGit2.html#LibGit2.restore","category":"function","text":"restore(s::State, repo::GitRepo)\n\nReturn a repository repo to a previous State s, for example the HEAD of a branch before a merge attempt. s can be generated using the snapshot function.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.revcount","location":"stdlib/LibGit2.html#LibGit2.revcount","category":"function","text":"LibGit2.revcount(repo::GitRepo, commit1::AbstractString, commit2::AbstractString)\n\nList the number of revisions between commit1 and commit2 (committish OIDs in string form). Since commit1 and commit2 may be on different branches, revcount performs a \"left-right\" revision list (and count), returning a tuple of Ints - the number of left and right commits, respectively. A left (or right) commit refers to which side of a symmetric difference in a tree the commit is reachable from.\n\nEquivalent to git rev-list --left-right --count <commit1> <commit2>.\n\nExamples\n\nrepo = LibGit2.GitRepo(repo_path)\nrepo_file = open(joinpath(repo_path, test_file), \"a\")\nprintln(repo_file, \"hello world\")\nflush(repo_file)\nLibGit2.add!(repo, test_file)\ncommit_oid1 = LibGit2.commit(repo, \"commit 1\")\nprintln(repo_file, \"hello world again\")\nflush(repo_file)\nLibGit2.add!(repo, test_file)\ncommit_oid2 = LibGit2.commit(repo, \"commit 2\")\nLibGit2.revcount(repo, string(commit_oid1), string(commit_oid2))\n\nThis will return (-1, 0).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.set_remote_url","location":"stdlib/LibGit2.html#LibGit2.set_remote_url","category":"function","text":"set_remote_url(repo::GitRepo, remote_name, url)\nset_remote_url(repo::String, remote_name, url)\n\nSet both the fetch and push url for remote_name for the GitRepo or the git repository located at path. Typically git repos use \"origin\" as the remote name.\n\nExamples\n\nrepo_path = joinpath(tempdir(), \"Example\")\nrepo = LibGit2.init(repo_path)\nLibGit2.set_remote_url(repo, \"upstream\", \"https://github.com/JuliaLang/Example.jl\")\nLibGit2.set_remote_url(repo_path, \"upstream2\", \"https://github.com/JuliaLang/Example2.jl\")\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.shortname","location":"stdlib/LibGit2.html#LibGit2.shortname","category":"function","text":"LibGit2.shortname(ref::GitReference)\n\nReturn a shortened version of the name of ref that's \"human-readable\".\n\njulia> repo = LibGit2.GitRepo(path_to_repo);\n\njulia> branch_ref = LibGit2.head(repo);\n\njulia> LibGit2.name(branch_ref)\n\"refs/heads/master\"\n\njulia> LibGit2.shortname(branch_ref)\n\"master\"\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.snapshot","location":"stdlib/LibGit2.html#LibGit2.snapshot","category":"function","text":"snapshot(repo::GitRepo) -> State\n\nTake a snapshot of the current state of the repository repo, storing the current HEAD, index, and any uncommitted work. The output State can be used later during a call to restore to return the repository to the snapshotted state.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.split_cfg_entry","location":"stdlib/LibGit2.html#LibGit2.split_cfg_entry","category":"function","text":"LibGit2.split_cfg_entry(ce::LibGit2.ConfigEntry) -> Tuple{String,String,String,String}\n\nBreak the ConfigEntry up to the following pieces: section, subsection, name, and value.\n\nExamples\n\nGiven the git configuration file containing:\n\n[credential \"https://example.com\"]\n    username = me\n\nThe ConfigEntry would look like the following:\n\njulia> entry\nConfigEntry(\"credential.https://example.com.username\", \"me\")\n\njulia> LibGit2.split_cfg_entry(entry)\n(\"credential\", \"https://example.com\", \"username\", \"me\")\n\nRefer to the git config syntax documentation for more details.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.status","location":"stdlib/LibGit2.html#LibGit2.status","category":"function","text":"LibGit2.status(repo::GitRepo, path::String) -> Union{Cuint, Cvoid}\n\nLookup the status of the file at path in the git repository repo. For instance, this can be used to check if the file at path has been modified and needs to be staged and committed.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.stage","location":"stdlib/LibGit2.html#LibGit2.stage","category":"function","text":"stage(ie::IndexEntry) -> Cint\n\nGet the stage number of ie. The stage number 0 represents the current state of the working tree, but other numbers can be used in the case of a merge conflict. In such a case, the various stage numbers on an IndexEntry describe which side(s) of the conflict the current state of the file belongs to. Stage 0 is the state before the attempted merge, stage 1 is the changes which have been made locally, stages 2 and larger are for changes from other branches (for instance, in the case of a multi-branch \"octopus\" merge, stages 2, 3, and 4 might be used).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.tag_create","location":"stdlib/LibGit2.html#LibGit2.tag_create","category":"function","text":"LibGit2.tag_create(repo::GitRepo, tag::AbstractString, commit; kwargs...)\n\nCreate a new git tag tag (e.g. \"v0.5\") in the repository repo, at the commit commit.\n\nThe keyword arguments are:\n\nmsg::AbstractString=\"\": the message for the tag.\nforce::Bool=false: if true, existing references will be overwritten.\nsig::Signature=Signature(repo): the tagger's signature.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.tag_delete","location":"stdlib/LibGit2.html#LibGit2.tag_delete","category":"function","text":"LibGit2.tag_delete(repo::GitRepo, tag::AbstractString)\n\nRemove the git tag tag from the repository repo.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.tag_list","location":"stdlib/LibGit2.html#LibGit2.tag_list","category":"function","text":"LibGit2.tag_list(repo::GitRepo) -> Vector{String}\n\nGet a list of all tags in the git repository repo.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.target","location":"stdlib/LibGit2.html#LibGit2.target","category":"function","text":"LibGit2.target(tag::GitTag)\n\nThe GitHash of the target object of tag.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.toggle","location":"stdlib/LibGit2.html#LibGit2.toggle","category":"function","text":"toggle(val::Integer, flag::Integer)\n\nFlip the bits of val indexed by flag, so that if a bit is 0 it will be 1 after the toggle, and vice-versa.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.transact","location":"stdlib/LibGit2.html#LibGit2.transact","category":"function","text":"transact(f::Function, repo::GitRepo)\n\nApply function f to the git repository repo, taking a snapshot before applying f. If an error occurs within f, repo will be returned to its snapshot state using restore. The error which occurred will be rethrown, but the state of repo will not be corrupted.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.treewalk","location":"stdlib/LibGit2.html#LibGit2.treewalk","category":"function","text":"treewalk(f, tree::GitTree, post::Bool=false)\n\nTraverse the entries in tree and its subtrees in post or pre order. Preorder means beginning at the root and then traversing the leftmost subtree (and recursively on down through that subtree's leftmost subtrees) and moving right through the subtrees. Postorder means beginning at the bottom of the leftmost subtree, traversing upwards through it, then traversing the next right subtree (again beginning at the bottom) and finally visiting the tree root last of all.\n\nThe function parameter f should have following signature:\n\n(String, GitTreeEntry) -> Cint\n\nA negative value returned from f stops the tree walk. A positive value means that the entry will be skipped if post is false.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.upstream","location":"stdlib/LibGit2.html#LibGit2.upstream","category":"function","text":"upstream(ref::GitReference) -> Union{GitReference, Nothing}\n\nDetermine if the branch containing ref has a specified upstream branch.\n\nReturn either a GitReference to the upstream branch if it exists, or nothing if the requested branch does not have an upstream counterpart.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.update!","location":"stdlib/LibGit2.html#LibGit2.update!","category":"function","text":"update!(repo::GitRepo, files::AbstractString...)\nupdate!(idx::GitIndex, files::AbstractString...)\n\nUpdate all the files with paths specified by files in the index idx (or the index of the repo). Match the state of each file in the index with the current state on disk, removing it if it has been removed on disk, or updating its entry in the object database.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.url","location":"stdlib/LibGit2.html#LibGit2.url","category":"function","text":"url(rmt::GitRemote)\n\nGet the fetch URL of a remote git repository.\n\nExamples\n\njulia> repo_url = \"https://github.com/JuliaLang/Example.jl\";\n\njulia> repo = LibGit2.init(mktempdir());\n\njulia> remote = LibGit2.GitRemote(repo, \"origin\", repo_url);\n\njulia> LibGit2.url(remote)\n\"https://github.com/JuliaLang/Example.jl\"\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.version","location":"stdlib/LibGit2.html#LibGit2.version","category":"function","text":"version() -> VersionNumber\n\nReturn the version of libgit2 in use, as a VersionNumber.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.with","location":"stdlib/LibGit2.html#LibGit2.with","category":"function","text":"with(f::Function, obj)\n\nResource management helper function. Applies f to obj, making sure to call close on obj after f successfully returns or throws an error. Ensures that allocated git resources are finalized as soon as they are no longer needed.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.with_warn","location":"stdlib/LibGit2.html#LibGit2.with_warn","category":"function","text":"with_warn(f::Function, ::Type{T}, args...)\n\nResource management helper function. Apply f to args, first constructing an instance of type T from args. Makes sure to call close on the resulting object after f successfully returns or throws an error. Ensures that allocated git resources are finalized as soon as they are no longer needed. If an error is thrown by f, a warning is shown containing the error.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.workdir","location":"stdlib/LibGit2.html#LibGit2.workdir","category":"function","text":"LibGit2.workdir(repo::GitRepo)\n\nReturn the location of the working directory of repo. This will throw an error for bare repositories.\n\nnote: Note\nThis will typically be the parent directory of gitdir(repo), but can be different in some cases: e.g. if either the core.worktree configuration variable or the GIT_WORK_TREE environment variable is set.\n\nSee also gitdir, path.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitObject","location":"stdlib/LibGit2.html#LibGit2.GitObject-Tuple{LibGit2.GitTreeEntry}","category":"method","text":"(::Type{T})(te::GitTreeEntry) where T<:GitObject\n\nGet the git object to which te refers and return it as its actual type (the type entrytype would show), for instance a GitBlob or GitTag.\n\nExamples\n\ntree = LibGit2.GitTree(repo, \"HEAD^{tree}\")\ntree_entry = tree[1]\nblob = LibGit2.GitBlob(tree_entry)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.UserPasswordCredential","location":"stdlib/LibGit2.html#LibGit2.UserPasswordCredential","category":"type","text":"Credential that support only user and password parameters\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.SSHCredential","location":"stdlib/LibGit2.html#LibGit2.SSHCredential","category":"type","text":"SSH credential type\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.isfilled","location":"stdlib/LibGit2.html#LibGit2.isfilled","category":"function","text":"isfilled(cred::AbstractCredential) -> Bool\n\nVerifies that a credential is ready for use in authentication.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.CachedCredentials","location":"stdlib/LibGit2.html#LibGit2.CachedCredentials","category":"type","text":"Caches credential information for re-use\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.CredentialPayload","location":"stdlib/LibGit2.html#LibGit2.CredentialPayload","category":"type","text":"LibGit2.CredentialPayload\n\nRetains the state between multiple calls to the credential callback for the same URL. A CredentialPayload instance is expected to be reset! whenever it will be used with a different URL.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.approve","location":"stdlib/LibGit2.html#LibGit2.approve","category":"function","text":"approve(payload::CredentialPayload; shred::Bool=true) -> Nothing\n\nStore the payload credential for re-use in a future authentication. Should only be called when authentication was successful.\n\nThe shred keyword controls whether sensitive information in the payload credential field should be destroyed. Should only be set to false during testing.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.reject","location":"stdlib/LibGit2.html#LibGit2.reject","category":"function","text":"reject(payload::CredentialPayload; shred::Bool=true) -> Nothing\n\nDiscard the payload credential from begin re-used in future authentication. Should only be called when authentication was unsuccessful.\n\nThe shred keyword controls whether sensitive information in the payload credential field should be destroyed. Should only be set to false during testing.\n\n\n\n\n\n","page":"LibGit2"},{"title":"Multi-Threading","location":"base/multi-threading.html#lib-multithreading","category":"section","text":"","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"Base.Threads.@threads\nBase.Threads.foreach\nBase.Threads.@spawn\nBase.Threads.threadid\nBase.Threads.nthreads","page":"Multi-Threading"},{"title":"Base.Threads.@threads","location":"base/multi-threading.html#Base.Threads.@threads","category":"macro","text":"Threads.@threads [schedule] for ... end\n\nA macro to parallelize a for loop to run with multiple threads. Splits the iteration space among multiple tasks and runs those tasks on threads according to a scheduling policy. A barrier is placed at the end of the loop which waits for all tasks to finish execution.\n\nThe schedule argument can be used to request a particular scheduling policy. The only currently supported value is :static, which creates one task per thread and divides the iterations equally among them. Specifying :static is an error if used from inside another @threads loop or from a thread other than 1.\n\nThe default schedule (used when no schedule argument is present) is subject to change.\n\ncompat: Julia 1.5\nThe schedule argument is available as of Julia 1.5.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.foreach","location":"base/multi-threading.html#Base.Threads.foreach","category":"function","text":"Threads.foreach(f, channel::Channel;\n                schedule::Threads.AbstractSchedule=Threads.FairSchedule(),\n                ntasks=Threads.nthreads())\n\nSimilar to foreach(f, channel), but iteration over channel and calls to f are split across ntasks tasks spawned by Threads.@spawn. This function will wait for all internally spawned tasks to complete before returning.\n\nIf schedule isa FairSchedule, Threads.foreach will attempt to spawn tasks in a manner that enables Julia's scheduler to more freely load-balance work items across threads. This approach generally has higher per-item overhead, but may perform better than StaticSchedule in concurrence with other multithreaded workloads.\n\nIf schedule isa StaticSchedule, Threads.foreach will spawn tasks in a manner that incurs lower per-item overhead than FairSchedule, but is less amenable to load-balancing. This approach thus may be more suitable for fine-grained, uniform workloads, but may perform worse than FairSchedule in concurrence with other multithreaded workloads.\n\ncompat: Julia 1.6\nThis function requires Julia 1.6 or later.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.@spawn","location":"base/multi-threading.html#Base.Threads.@spawn","category":"macro","text":"Threads.@spawn expr\n\nCreate and run a Task on any available thread. To wait for the task to finish, call wait on the result of this macro, or call fetch to wait and then obtain its return value.\n\nValues can be interpolated into @spawn via $, which copies the value directly into the constructed underlying closure. This allows you to insert the value of a variable, isolating the asynchronous code from changes to the variable's value in the current task.\n\nnote: Note\nSee the manual chapter on threading for important caveats.\n\ncompat: Julia 1.3\nThis macro is available as of Julia 1.3.\n\ncompat: Julia 1.4\nInterpolating values via $ is available as of Julia 1.4.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.threadid","location":"base/multi-threading.html#Base.Threads.threadid","category":"function","text":"Threads.threadid()\n\nGet the ID number of the current thread of execution. The master thread has ID 1.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.nthreads","location":"base/multi-threading.html#Base.Threads.nthreads","category":"function","text":"Threads.nthreads()\n\nGet the number of threads available to the Julia process. This is the inclusive upper bound on threadid().\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Synchronization","location":"base/multi-threading.html#Synchronization","category":"section","text":"","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"Base.Threads.Condition\nBase.Threads.Event","page":"Multi-Threading"},{"title":"Base.Threads.Condition","location":"base/multi-threading.html#Base.Threads.Condition","category":"type","text":"Threads.Condition([lock])\n\nA thread-safe version of Base.Condition.\n\nTo call wait or notify on a Threads.Condition, you must first call lock on it. When wait is called, the lock is atomically released during blocking, and will be reacquired before wait returns. Therefore idiomatic use of a Threads.Condition c looks like the following:\n\nlock(c)\ntry\n    while !thing_we_are_waiting_for\n        wait(c)\n    end\nfinally\n    unlock(c)\nend\n\ncompat: Julia 1.2\nThis functionality requires at least Julia 1.2.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Event","location":"base/multi-threading.html#Base.Event","category":"type","text":"Event()\n\nCreate a level-triggered event source. Tasks that call wait on an Event are suspended and queued until notify is called on the Event. After notify is called, the Event remains in a signaled state and tasks will no longer block when waiting for it.\n\ncompat: Julia 1.1\nThis functionality requires at least Julia 1.1.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"See also Synchronization.","page":"Multi-Threading"},{"title":"Atomic operations","location":"base/multi-threading.html#Atomic-operations","category":"section","text":"","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"warning: Warning\nThe API for atomic operations has not yet been finalized and is likely to change.","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"Base.Threads.Atomic\nBase.Threads.atomic_cas!\nBase.Threads.atomic_xchg!\nBase.Threads.atomic_add!\nBase.Threads.atomic_sub!\nBase.Threads.atomic_and!\nBase.Threads.atomic_nand!\nBase.Threads.atomic_or!\nBase.Threads.atomic_xor!\nBase.Threads.atomic_max!\nBase.Threads.atomic_min!\nBase.Threads.atomic_fence","page":"Multi-Threading"},{"title":"Base.Threads.Atomic","location":"base/multi-threading.html#Base.Threads.Atomic","category":"type","text":"Threads.Atomic{T}\n\nHolds a reference to an object of type T, ensuring that it is only accessed atomically, i.e. in a thread-safe manner.\n\nOnly certain \"simple\" types can be used atomically, namely the primitive boolean, integer, and float-point types. These are Bool, Int8...Int128, UInt8...UInt128, and Float16...Float64.\n\nNew atomic objects can be created from a non-atomic values; if none is specified, the atomic object is initialized with zero.\n\nAtomic objects can be accessed using the [] notation:\n\nExamples\n\njulia> x = Threads.Atomic{Int}(3)\nBase.Threads.Atomic{Int64}(3)\n\njulia> x[] = 1\n1\n\njulia> x[]\n1\n\nAtomic operations use an atomic_ prefix, such as atomic_add!, atomic_xchg!, etc.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_cas!","location":"base/multi-threading.html#Base.Threads.atomic_cas!","category":"function","text":"Threads.atomic_cas!(x::Atomic{T}, cmp::T, newval::T) where T\n\nAtomically compare-and-set x\n\nAtomically compares the value in x with cmp. If equal, write newval to x. Otherwise, leaves x unmodified. Returns the old value in x. By comparing the returned value to cmp (via ===) one knows whether x was modified and now holds the new value newval.\n\nFor further details, see LLVM's cmpxchg instruction.\n\nThis function can be used to implement transactional semantics. Before the transaction, one records the value in x. After the transaction, the new value is stored only if x has not been modified in the mean time.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(3)\nBase.Threads.Atomic{Int64}(3)\n\njulia> Threads.atomic_cas!(x, 4, 2);\n\njulia> x\nBase.Threads.Atomic{Int64}(3)\n\njulia> Threads.atomic_cas!(x, 3, 2);\n\njulia> x\nBase.Threads.Atomic{Int64}(2)\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_xchg!","location":"base/multi-threading.html#Base.Threads.atomic_xchg!","category":"function","text":"Threads.atomic_xchg!(x::Atomic{T}, newval::T) where T\n\nAtomically exchange the value in x\n\nAtomically exchanges the value in x with newval. Returns the old value.\n\nFor further details, see LLVM's atomicrmw xchg instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(3)\nBase.Threads.Atomic{Int64}(3)\n\njulia> Threads.atomic_xchg!(x, 2)\n3\n\njulia> x[]\n2\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_add!","location":"base/multi-threading.html#Base.Threads.atomic_add!","category":"function","text":"Threads.atomic_add!(x::Atomic{T}, val::T) where T <: ArithmeticTypes\n\nAtomically add val to x\n\nPerforms x[] += val atomically. Returns the old value. Not defined for Atomic{Bool}.\n\nFor further details, see LLVM's atomicrmw add instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(3)\nBase.Threads.Atomic{Int64}(3)\n\njulia> Threads.atomic_add!(x, 2)\n3\n\njulia> x[]\n5\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_sub!","location":"base/multi-threading.html#Base.Threads.atomic_sub!","category":"function","text":"Threads.atomic_sub!(x::Atomic{T}, val::T) where T <: ArithmeticTypes\n\nAtomically subtract val from x\n\nPerforms x[] -= val atomically. Returns the old value. Not defined for Atomic{Bool}.\n\nFor further details, see LLVM's atomicrmw sub instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(3)\nBase.Threads.Atomic{Int64}(3)\n\njulia> Threads.atomic_sub!(x, 2)\n3\n\njulia> x[]\n1\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_and!","location":"base/multi-threading.html#Base.Threads.atomic_and!","category":"function","text":"Threads.atomic_and!(x::Atomic{T}, val::T) where T\n\nAtomically bitwise-and x with val\n\nPerforms x[] &= val atomically. Returns the old value.\n\nFor further details, see LLVM's atomicrmw and instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(3)\nBase.Threads.Atomic{Int64}(3)\n\njulia> Threads.atomic_and!(x, 2)\n3\n\njulia> x[]\n2\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_nand!","location":"base/multi-threading.html#Base.Threads.atomic_nand!","category":"function","text":"Threads.atomic_nand!(x::Atomic{T}, val::T) where T\n\nAtomically bitwise-nand (not-and) x with val\n\nPerforms x[] = ~(x[] & val) atomically. Returns the old value.\n\nFor further details, see LLVM's atomicrmw nand instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(3)\nBase.Threads.Atomic{Int64}(3)\n\njulia> Threads.atomic_nand!(x, 2)\n3\n\njulia> x[]\n-3\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_or!","location":"base/multi-threading.html#Base.Threads.atomic_or!","category":"function","text":"Threads.atomic_or!(x::Atomic{T}, val::T) where T\n\nAtomically bitwise-or x with val\n\nPerforms x[] |= val atomically. Returns the old value.\n\nFor further details, see LLVM's atomicrmw or instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(5)\nBase.Threads.Atomic{Int64}(5)\n\njulia> Threads.atomic_or!(x, 7)\n5\n\njulia> x[]\n7\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_xor!","location":"base/multi-threading.html#Base.Threads.atomic_xor!","category":"function","text":"Threads.atomic_xor!(x::Atomic{T}, val::T) where T\n\nAtomically bitwise-xor (exclusive-or) x with val\n\nPerforms x[] $= val atomically. Returns the old value.\n\nFor further details, see LLVM's atomicrmw xor instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(5)\nBase.Threads.Atomic{Int64}(5)\n\njulia> Threads.atomic_xor!(x, 7)\n5\n\njulia> x[]\n2\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_max!","location":"base/multi-threading.html#Base.Threads.atomic_max!","category":"function","text":"Threads.atomic_max!(x::Atomic{T}, val::T) where T\n\nAtomically store the maximum of x and val in x\n\nPerforms x[] = max(x[], val) atomically. Returns the old value.\n\nFor further details, see LLVM's atomicrmw max instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(5)\nBase.Threads.Atomic{Int64}(5)\n\njulia> Threads.atomic_max!(x, 7)\n5\n\njulia> x[]\n7\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_min!","location":"base/multi-threading.html#Base.Threads.atomic_min!","category":"function","text":"Threads.atomic_min!(x::Atomic{T}, val::T) where T\n\nAtomically store the minimum of x and val in x\n\nPerforms x[] = min(x[], val) atomically. Returns the old value.\n\nFor further details, see LLVM's atomicrmw min instruction.\n\nExamples\n\njulia> x = Threads.Atomic{Int}(7)\nBase.Threads.Atomic{Int64}(7)\n\njulia> Threads.atomic_min!(x, 5)\n7\n\njulia> x[]\n5\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Base.Threads.atomic_fence","location":"base/multi-threading.html#Base.Threads.atomic_fence","category":"function","text":"Threads.atomic_fence()\n\nInsert a sequential-consistency memory fence\n\nInserts a memory fence with sequentially-consistent ordering semantics. There are algorithms where this is needed, i.e. where an acquire/release ordering is insufficient.\n\nThis is likely a very expensive operation. Given that all other atomic operations in Julia already have acquire/release semantics, explicit fences should not be necessary in most cases.\n\nFor further details, see LLVM's fence instruction.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"ccall using a threadpool (Experimental)","location":"base/multi-threading.html#ccall-using-a-threadpool-(Experimental)","category":"section","text":"","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"Base.@threadcall","page":"Multi-Threading"},{"title":"Base.@threadcall","location":"base/multi-threading.html#Base.@threadcall","category":"macro","text":"@threadcall((cfunc, clib), rettype, (argtypes...), argvals...)\n\nThe @threadcall macro is called in the same way as ccall but does the work in a different thread. This is useful when you want to call a blocking C function without causing the main julia thread to become blocked. Concurrency is limited by size of the libuv thread pool, which defaults to 4 threads but can be increased by setting the UV_THREADPOOL_SIZE environment variable and restarting the julia process.\n\nNote that the called function should never call back into Julia.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"Low-level synchronization primitives","location":"base/multi-threading.html#Low-level-synchronization-primitives","category":"section","text":"","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"These building blocks are used to create the regular synchronization objects.","page":"Multi-Threading"},{"title":"Multi-Threading","location":"base/multi-threading.html","category":"page","text":"Base.Threads.SpinLock","page":"Multi-Threading"},{"title":"Base.Threads.SpinLock","location":"base/multi-threading.html#Base.Threads.SpinLock","category":"type","text":"SpinLock()\n\nCreate a non-reentrant, test-and-test-and-set spin lock. Recursive use will result in a deadlock. This kind of lock should only be used around code that takes little time to execute and does not block (e.g. perform I/O). In general, ReentrantLock should be used instead.\n\nEach lock must be matched with an unlock.\n\nTest-and-test-and-set spin locks are quickest up to about 30ish contending threads. If you have more contention than that, different synchronization approaches should be considered.\n\n\n\n\n\n","page":"Multi-Threading"},{"title":"C Standard Library","location":"base/libc.html#C-Standard-Library","category":"section","text":"","page":"C Standard Library"},{"title":"C Standard Library","location":"base/libc.html","category":"page","text":"Base.Libc.malloc\nBase.Libc.calloc\nBase.Libc.realloc\nBase.Libc.free\nBase.Libc.errno\nBase.Libc.strerror\nBase.Libc.GetLastError\nBase.Libc.FormatMessage\nBase.Libc.time(::Base.Libc.TmStruct)\nBase.Libc.strftime\nBase.Libc.strptime\nBase.Libc.TmStruct\nBase.Libc.flush_cstdio\nBase.Libc.systemsleep","page":"C Standard Library"},{"title":"Base.Libc.malloc","location":"base/libc.html#Base.Libc.malloc","category":"function","text":"malloc(size::Integer) -> Ptr{Cvoid}\n\nCall malloc from the C standard library.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.calloc","location":"base/libc.html#Base.Libc.calloc","category":"function","text":"calloc(num::Integer, size::Integer) -> Ptr{Cvoid}\n\nCall calloc from the C standard library.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.realloc","location":"base/libc.html#Base.Libc.realloc","category":"function","text":"realloc(addr::Ptr, size::Integer) -> Ptr{Cvoid}\n\nCall realloc from the C standard library.\n\nSee warning in the documentation for free regarding only using this on memory originally obtained from malloc.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.free","location":"base/libc.html#Base.Libc.free","category":"function","text":"free(addr::Ptr)\n\nCall free from the C standard library. Only use this on memory obtained from malloc, not on pointers retrieved from other C libraries. Ptr objects obtained from C libraries should be freed by the free functions defined in that library, to avoid assertion failures if multiple libc libraries exist on the system.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.errno","location":"base/libc.html#Base.Libc.errno","category":"function","text":"errno([code])\n\nGet the value of the C library's errno. If an argument is specified, it is used to set the value of errno.\n\nThe value of errno is only valid immediately after a ccall to a C library routine that sets it. Specifically, you cannot call errno at the next prompt in a REPL, because lots of code is executed between prompts.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.strerror","location":"base/libc.html#Base.Libc.strerror","category":"function","text":"strerror(n=errno())\n\nConvert a system call error code to a descriptive string\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.GetLastError","location":"base/libc.html#Base.Libc.GetLastError","category":"function","text":"GetLastError()\n\nCall the Win32 GetLastError function [only available on Windows].\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.FormatMessage","location":"base/libc.html#Base.Libc.FormatMessage","category":"function","text":"FormatMessage(n=GetLastError())\n\nConvert a Win32 system call error code to a descriptive string [only available on Windows].\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.time","location":"base/libc.html#Base.Libc.time-Tuple{Base.Libc.TmStruct}","category":"method","text":"time(t::TmStruct)\n\nConverts a TmStruct struct to a number of seconds since the epoch.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.strftime","location":"base/libc.html#Base.Libc.strftime","category":"function","text":"strftime([format], time)\n\nConvert time, given as a number of seconds since the epoch or a TmStruct, to a formatted string using the given format. Supported formats are the same as those in the standard C library.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.strptime","location":"base/libc.html#Base.Libc.strptime","category":"function","text":"strptime([format], timestr)\n\nParse a formatted time string into a TmStruct giving the seconds, minute, hour, date, etc. Supported formats are the same as those in the standard C library. On some platforms, timezones will not be parsed correctly. If the result of this function will be passed to time to convert it to seconds since the epoch, the isdst field should be filled in manually. Setting it to -1 will tell the C library to use the current system settings to determine the timezone.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.TmStruct","location":"base/libc.html#Base.Libc.TmStruct","category":"type","text":"TmStruct([seconds])\n\nConvert a number of seconds since the epoch to broken-down format, with fields sec, min, hour, mday, month, year, wday, yday, and isdst.\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.flush_cstdio","location":"base/libc.html#Base.Libc.flush_cstdio","category":"function","text":"flush_cstdio()\n\nFlushes the C stdout and stderr streams (which may have been written to by external C code).\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Base.Libc.systemsleep","location":"base/libc.html#Base.Libc.systemsleep","category":"function","text":"systemsleep(s::Real)\n\nSuspends execution for s seconds. This function does not yield to Julia's scheduler and therefore blocks the Julia thread that it is running on for the duration of the sleep time.\n\nSee also: sleep\n\n\n\n\n\n","page":"C Standard Library"},{"title":"Modules","location":"manual/modules.html#modules","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Modules in Julia help organize code into coherent units. They are delimited syntactically inside module NameOfModule ... end, and have the following features:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Modules are separate namespaces, each introducing a new global scope. This is useful, because it allows the same name to be used for different functions or global variables without conflict, as long as they are in separate modules.\nModules have facilities for detailed namespace management: each defines a set of names it exports, and can import names from other modules with using and import (we explain these below).\nModules can be precompiled for faster loading, and contain code for runtime initialization.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Typically, in larger Julia packages you will see module code organized into files, eg","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"module SomeModule\n\n# export, using, import statements are usually here; we discuss these below\n\ninclude(\"file1.jl\")\ninclude(\"file2.jl\")\n\nend","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Files and file names are mostly unrelated to modules; modules are associated only with module expressions. One can have multiple files per module, and multiple modules per file. include behaves as if the contents of the source file were evaluated in its place. In this chapter, we use short and simplified examples, so we won't use include.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"The recommended style is not to indent the body of the module, since that would typically lead to whole files being indented. Also, it is common to use UpperCamelCase for module names (just like types), and use the plural form if applicable, especially if the module contains a similarly named identifier, to avoid name clashes. For example,","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"module FastThings\n\nstruct FastThing\n    ...\nend\n\nend","page":"Modules"},{"title":"Namespace management","location":"manual/modules.html#namespace-management","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Namespace management refers to the facilities the language offers for making names in a module available in other modules. We discuss the related concepts and functionality below in detail.","page":"Modules"},{"title":"Qualified names","location":"manual/modules.html#Qualified-names","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Names for functions, variables and types in the global scope like sin, ARGS, and UnitRange always belong to a module, called the parent module, which can be found interactively with parentmodule, for example","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"julia> parentmodule(UnitRange)\nBase","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"One can also refer to these names outside their parent module by prefixing them with their module, eg Base.UnitRange. This is called a qualified name. The parent module may be accessible using a chain of submodules like Base.Math.sin, where Base.Math is called the module path. Due to syntactic ambiguities, qualifying a name that contains only symbols, such as an operator, requires inserting a colon, e.g. Base.:+. A small number of operators additionally require parentheses, e.g. Base.:(==).","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"If a name is qualified, then it is always accessible, and in case of a function, it can also have methods added to it by using the qualified name as the function name.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Within a module, a variable name can be “reserved” without assigning to it by declaring it as global x. This prevents name conflicts for globals initialized after load time. The syntax M.x = y does not work to assign a global in another module; global assignment is always module-local.","page":"Modules"},{"title":"Export lists","location":"manual/modules.html#Export-lists","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Names (referring to functions, types, global variables, and constants) can be added to the export list of a module with export. Typically, they are at or near the top of the module definition so that readers of the source code can find them easily, as in","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"module NiceStuff\n\nexport nice, DOG\n\nstruct Dog end      # singleton type, not exported\n\nconst DOG = Dog()   # named instance, exported\n\nnice(x) = \"nice $x\" # function, exported\n\nend","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"but this is just a style suggestion — a module can have multiple export statements in arbitrary locations.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"It is common to export names which form part of the API (application programming interface). In the above code, the export list suggests that users should use nice and DOG. However, since qualified names always make identifiers accessible, this is just an option for organizing APIs: unlike other languages, Julia has no facilities for truly hiding module internals.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Also, some modules don't export names at all. This is usually done if they use common words, such as derivative, in their API, which could easily clash with the export lists of other modules. We will see how to manage name clashes below.","page":"Modules"},{"title":"Standalone using and import","location":"manual/modules.html#Standalone-using-and-import","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Possibly the most common way of loading a module is using ModuleName. This loads the code associated with ModuleName, and brings","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"the module name\nand the elements of the export list into the surrounding global namespace.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Technically, the statement using ModuleName means that a module called ModuleName will be available for resolving names as needed. When a global variable is encountered that has no definition in the current module, the system will search for it among variables exported by ModuleName and use it if it is found there. This means that all uses of that global within the current module will resolve to the definition of that variable in ModuleName.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"To continue with our example,","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"using NiceStuff","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"would load the above code, making NiceStuff (the module name), DOG and nice available. Dog is not on the export list, but it can be accessed if the name is qualified with the module path (which here is just the module name) as NiceStuff.Dog.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Importantly, using ModuleName is the only form for which export lists matter at all.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"In contrast,","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"import NiceStuff","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"brings only the module name into scope. Users would need to use NiceStuff.DOG, NiceStuff.Dog, and NiceStuff.nice to access its contents. Usually, import ModuleName is used in contexts when the user wants to keep the namespace clean. As we will see in the next section import NiceStuff is equivalent to using NiceStuff: NiceStuff.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"You can combine multiple using and import statements of the same kind in a comma-separated expression, e.g.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"using LinearAlgebra, Statistics","page":"Modules"},{"title":"using and import with specific identifiers, and adding methods","location":"manual/modules.html#using-and-import-with-specific-identifiers,-and-adding-methods","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"When using ModuleName: or import ModuleName: is followed by a comma-separated list of names, the module is loaded, but only those specific names are brought into the namespace by the statement. For example,","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"using NiceStuff: nice, DOG","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"will import the names nice and DOG.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Importantly, the module name NiceStuff will not be in the namespace. If you want to make it accessible, you have to list it explicitly, as","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"using NiceStuff: nice, DOG, NiceStuff","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Julia has two forms for seemingly the same thing because only import ModuleName: f allows adding methods to f without a module path. That is to say, the following example will give an error:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"using NiceStuff: nice\nstruct Cat end\nnice(::Cat) = \"nice 😸\"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"This error prevents accidentally adding methods to functions in other modules that you only intended to use.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"There are two ways to deal with this. You can always qualify function names with a module path:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"using NiceStuff\nstruct Cat end\nNiceStuff.nice(::Cat) = \"nice 😸\"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Alternatively, you can import the specific function name:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"import NiceStuff: nice\nstruct Cat end\nnice(::Cat) = \"nice 😸\"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Which one you choose is a matter of style. The first form makes it clear that you are adding a method to a function in another module (remember, that the imports and the method defintion may be in separate files), while the second one is shorter, which is especially convenient if you are defining multiple methods.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Once a variable is made visible via using or import, a module may not create its own variable with the same name. Imported variables are read-only; assigning to a global variable always affects a variable owned by the current module, or else raises an error.","page":"Modules"},{"title":"Renaming with as","location":"manual/modules.html#Renaming-with-as","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"An identifier brought into scope by import or using can be renamed with the keyword as. This is useful for working around name conflicts as well as for shortening names. For example, Base exports the function name read, but the CSV.jl package also provides CSV.read. If we are going to invoke CSV reading many times, it would be convenient to drop the CSV. qualifier. But then it is ambiguous whether we are referring to Base.read or CSV.read:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"julia> read;\n\njulia> import CSV: read\nWARNING: ignoring conflicting import of CSV.read into Main","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Renaming provides a solution:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"julia> import CSV: read as rd","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Imported packages themselves can also be renamed:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"import BenchmarkTools as BT","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"as works with using only when a single identifier is brought into scope. For example using CSV: read as rd works, but using CSV as C does not, since it operates on all of the exported names in CSV.","page":"Modules"},{"title":"Mixing multiple using and import statements","location":"manual/modules.html#Mixing-multiple-using-and-import-statements","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"When multiple using or import statements of any of the forms above are used, their effect is combined in the order they appear. For example,","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"using NiceStuff         # exported names and the module name\nimport NiceStuff: nice  # allows adding methods to unqualified functions","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"would bring all the exported names of NiceStuff and the module name itself into scope, and also allow adding methods to nice without prefixing it with a module name.","page":"Modules"},{"title":"Handling name conflicts","location":"manual/modules.html#Handling-name-conflicts","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Consider the situation where two (or more) packages export the same name, as in","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"module A\nexport f\nf() = 1\nend\n\nmodule B\nexport f\nf() = 2\nend","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"The statement using A, B works, but when you try to call f, you get a warning","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"WARNING: both B and A export \"f\"; uses of it in module Main must be qualified\nERROR: LoadError: UndefVarError: f not defined","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Here, Julia cannot decide which f you are referring to, so you have to make a choice. The following solutions are commonly used:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Simply proceed with qualified names like A.f and B.f. This makes the context clear to the reader of your code, especially if f just happens to coincide but has different meaning in various packages. For example, degree has various uses in mathematics, the natural sciences, and in everyday life, and these meanings should be kept separate.\nUse the as keyword above to rename one or both identifiers, eg\nusing A: f as f\nusing B: f as g\nwould make B.f available as g. Here, we are assuming that you did not use using A before, which would have brought f into the namespace.\nWhen the names in question do share a meaning, it is common for one module to import it from another, or have a lightweight “base” package with the sole function of defining an interface like this, which can be used by other packages. It is conventional to have such package names end in ...Base (which has nothing to do with Julia's Base module).","page":"Modules"},{"title":"Default top-level definitions and bare modules","location":"manual/modules.html#Default-top-level-definitions-and-bare-modules","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Modules automatically contain using Core, using Base, and definitions of the eval and include functions, which evaluate expressions/files within the global scope of that module.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"If these default definitions are not wanted, modules can be defined using the keyword baremodule instead (note: Core is still imported). In terms of baremodule, a standard module looks like this:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"baremodule Mod\n\nusing Base\n\neval(x) = Core.eval(Mod, x)\ninclude(p) = Base.include(Mod, p)\n\n...\n\nend","page":"Modules"},{"title":"Standard modules","location":"manual/modules.html#Standard-modules","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"There are three important standard modules:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Core contains all functionality \"built into\" the language.\nBase contains basic functionality that is useful in almost all cases.\nMain is the top-level module and the current module, when Julia is started.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"note: Standard library modules\nBy default Julia ships with some standard library modules. These behave like regular Julia packages except that you don't need to install them explicitly. For example, if you wanted to perform some unit testing, you could load the Test standard library as follows:using Test","page":"Modules"},{"title":"Submodules and relative paths","location":"manual/modules.html#Submodules-and-relative-paths","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Modules can contain submodules, nesting the same syntax module ... end. They can be used to introduce separate namespaces, which can be helpful for organizing complex codebases. Note that each module introduces its own scope, so submodules do not automatically “inherit” names from their parent.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"It is recommended that submodules refer to other modules within the enclosing parent module (including the latter) using relative module qualifiers in using and import statements. A relative module qualifier starts with a period (.), which corresponds to the current module, and each successive . leads to the parent of the current module. This should be followed by modules if necessary, and eventually the actual name to access, all separated by .s.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Consider the following example, where the submodule SubA defines a function, which is then extended in its “sibling” module:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"module ParentModule\n\nmodule SubA\nexport add_D  # exported interface\nconst D = 3\nadd_D(x) = x + D\nend\n\nusing .SubA  # brings `add_D` into the namespace\n\nexport add_D # export it from ParentModule too\n\nmodule SubB\nimport ..SubA: add_D # relative path for a “sibling” module\nstruct Infinity end\nadd_D(x::Infinity) = x\nend\n\nend","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"You may see code in packages, which, in a similar situation, uses","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"import ParentModule.SubA: add_D","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"However, this operates through code loading, and thus only works if ParentModule is in a package. It is better to use relative paths.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Note that the order of definitions also matters if you are evaluating values. Consider","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"module TestPackage\n\nexport x, y\n\nx = 0\n\nmodule Sub\nusing ..TestPackage\nz = y # ERROR: UndefVarError: y not defined\nend\n\ny = 1\n\nend","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"where Sub is trying to use TestPackage.y before it was defined, so it does not have a value.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"For similar reasons, you cannot use a cyclic ordering:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"module A\n\nmodule B\nusing ..C # ERROR: UndefVarError: C not defined\nend\n\nmodule C\nusing ..B\nend\n\nend","page":"Modules"},{"title":"Module initialization and precompilation","location":"manual/modules.html#Module-initialization-and-precompilation","category":"section","text":"","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Large modules can take several seconds to load because executing all of the statements in a module often involves compiling a large amount of code. Julia creates precompiled caches of the module to reduce this time.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"The incremental precompiled module file are created and used automatically when using import or using to load a module.  This will cause it to be automatically compiled the first time it is imported. Alternatively, you can manually call Base.compilecache(modulename). The resulting cache files will be stored in DEPOT_PATH[1]/compiled/. Subsequently, the module is automatically recompiled upon using or import whenever any of its dependencies change; dependencies are modules it imports, the Julia build, files it includes, or explicit dependencies declared by include_dependency(path) in the module file(s).","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"For file dependencies, a change is determined by examining whether the modification time (mtime) of each file loaded by include or added explicitly by include_dependency is unchanged, or equal to the modification time truncated to the nearest second (to accommodate systems that can't copy mtime with sub-second accuracy). It also takes into account whether the path to the file chosen by the search logic in require matches the path that had created the precompile file. It also takes into account the set of dependencies already loaded into the current process and won't recompile those modules, even if their files change or disappear, in order to avoid creating incompatibilities between the running system and the precompile cache.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"If you know that a module is not safe to precompile your module (for example, for one of the reasons described below), you should put __precompile__(false) in the module file (typically placed at the top). This will cause Base.compilecache to throw an error, and will cause using / import to load it directly into the current process and skip the precompile and caching. This also thereby prevents the module from being imported by any other precompiled module.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"You may need to be aware of certain behaviors inherent in the creation of incremental shared libraries which may require care when writing your module. For example, external state is not preserved. To accommodate this, explicitly separate any initialization steps that must occur at runtime from steps that can occur at compile time. For this purpose, Julia allows you to define an __init__() function in your module that executes any initialization steps that must occur at runtime. This function will not be called during compilation (--output-*). Effectively, you can assume it will be run exactly once in the lifetime of the code. You may, of course, call it manually if necessary, but the default is to assume this function deals with computing state for the local machine, which does not need to be – or even should not be – captured in the compiled image. It will be called after the module is loaded into a process, including if it is being loaded into an incremental compile (--output-incremental=yes), but not if it is being loaded into a full-compilation process.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"In particular, if you define a function __init__() in a module, then Julia will call __init__() immediately after the module is loaded (e.g., by import, using, or require) at runtime for the first time (i.e., __init__ is only called once, and only after all statements in the module have been executed). Because it is called after the module is fully imported, any submodules or other imported modules have their __init__ functions called before the __init__ of the enclosing module.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Two typical uses of __init__ are calling runtime initialization functions of external C libraries and initializing global constants that involve pointers returned by external libraries.  For example, suppose that we are calling a C library libfoo that requires us to call a foo_init() initialization function at runtime. Suppose that we also want to define a global constant foo_data_ptr that holds the return value of a void *foo_data() function defined by libfoo – this constant must be initialized at runtime (not at compile time) because the pointer address will change from run to run.  You could accomplish this by defining the following __init__ function in your module:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"const foo_data_ptr = Ref{Ptr{Cvoid}}(0)\nfunction __init__()\n    ccall((:foo_init, :libfoo), Cvoid, ())\n    foo_data_ptr[] = ccall((:foo_data, :libfoo), Ptr{Cvoid}, ())\n    nothing\nend","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Notice that it is perfectly possible to define a global inside a function like __init__; this is one of the advantages of using a dynamic language. But by making it a constant at global scope, we can ensure that the type is known to the compiler and allow it to generate better optimized code. Obviously, any other globals in your module that depends on foo_data_ptr would also have to be initialized in __init__.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Constants involving most Julia objects that are not produced by ccall do not need to be placed in __init__: their definitions can be precompiled and loaded from the cached module image. This includes complicated heap-allocated objects like arrays. However, any routine that returns a raw pointer value must be called at runtime for precompilation to work (Ptr objects will turn into null pointers unless they are hidden inside an isbits object). This includes the return values of the Julia functions @cfunction and pointer.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Dictionary and set types, or in general anything that depends on the output of a hash(key) method, are a trickier case.  In the common case where the keys are numbers, strings, symbols, ranges, Expr, or compositions of these types (via arrays, tuples, sets, pairs, etc.) they are safe to precompile.  However, for a few other key types, such as Function or DataType and generic user-defined types where you haven't defined a hash method, the fallback hash method depends on the memory address of the object (via its objectid) and hence may change from run to run. If you have one of these key types, or if you aren't sure, to be safe you can initialize this dictionary from within your __init__ function. Alternatively, you can use the IdDict dictionary type, which is specially handled by precompilation so that it is safe to initialize at compile-time.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"When using precompilation, it is important to keep a clear sense of the distinction between the compilation phase and the execution phase. In this mode, it will often be much more clearly apparent that Julia is a compiler which allows execution of arbitrary Julia code, not a standalone interpreter that also generates compiled code.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Other known potential failure scenarios include:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Global counters (for example, for attempting to uniquely identify objects). Consider the following code snippet:\nmutable struct UniquedById\n    myid::Int\n    let counter = 0\n        UniquedById() = new(counter += 1)\n    end\nend\nwhile the intent of this code was to give every instance a unique id, the counter value is recorded at the end of compilation. All subsequent usages of this incrementally compiled module will start from that same counter value.\nNote that objectid (which works by hashing the memory pointer) has similar issues (see notes on Dict usage below).\nOne alternative is to use a macro to capture @__MODULE__ and store it alone with the current counter value, however, it may be better to redesign the code to not depend on this global state.\nAssociative collections (such as Dict and Set) need to be re-hashed in __init__. (In the future, a mechanism may be provided to register an initializer function.)\nDepending on compile-time side-effects persisting through load-time. Example include: modifying arrays or other variables in other Julia modules; maintaining handles to open files or devices; storing pointers to other system resources (including memory);\nCreating accidental \"copies\" of global state from another module, by referencing it directly instead of via its lookup path. For example, (in global scope):\n#mystdout = Base.stdout #= will not work correctly, since this will copy Base.stdout into this module =#\n# instead use accessor functions:\ngetstdout() = Base.stdout #= best option =#\n# or move the assignment into the runtime:\n__init__() = global mystdout = Base.stdout #= also works =#","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Several additional restrictions are placed on the operations that can be done while precompiling code to help the user avoid other wrong-behavior situations:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"Calling eval to cause a side-effect in another module. This will also cause a warning to be emitted when the incremental precompile flag is set.\nglobal const statements from local scope after __init__() has been started (see issue #12010 for plans to add an error for this)\nReplacing a module is a runtime error while doing an incremental precompile.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"A few other points to be aware of:","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"No code reload / cache invalidation is performed after changes are made to the source files themselves, (including by Pkg.update), and no cleanup is done after Pkg.rm\nThe memory sharing behavior of a reshaped array is disregarded by precompilation (each view gets its own copy)\nExpecting the filesystem to be unchanged between compile-time and runtime e.g. @__FILE__/source_path() to find resources at runtime, or the BinDeps @checked_lib macro. Sometimes this is unavoidable. However, when possible, it can be good practice to copy resources into the module at compile-time so they won't need to be found at runtime.\nWeakRef objects and finalizers are not currently handled properly by the serializer (this will be fixed in an upcoming release).\nIt is usually best to avoid capturing references to instances of internal metadata objects such as Method, MethodInstance, MethodTable, TypeMapLevel, TypeMapEntry and fields of those objects, as this can confuse the serializer and may not lead to the outcome you desire. It is not necessarily an error to do this, but you simply need to be prepared that the system will try to copy some of these and to create a single unique instance of others.","page":"Modules"},{"title":"Modules","location":"manual/modules.html","category":"page","text":"It is sometimes helpful during module development to turn off incremental precompilation. The command line flag --compiled-modules={yes|no} enables you to toggle module precompilation on and off. When Julia is started with --compiled-modules=no the serialized modules in the compile cache are ignored when loading modules and module dependencies. Base.compilecache can still be called manually. The state of this command line flag is passed to Pkg.build to disable automatic precompilation triggering when installing, updating, and explicitly building packages.","page":"Modules"},{"title":"Distributed Computing","location":"stdlib/Distributed.html#Distributed-Computing","category":"section","text":"","page":"Distributed Computing"},{"title":"Distributed Computing","location":"stdlib/Distributed.html","category":"page","text":"Distributed.addprocs\nDistributed.nprocs\nDistributed.nworkers\nDistributed.procs()\nDistributed.procs(::Integer)\nDistributed.workers\nDistributed.rmprocs\nDistributed.interrupt\nDistributed.myid\nDistributed.pmap\nDistributed.RemoteException\nDistributed.Future\nDistributed.RemoteChannel\nDistributed.fetch(::Distributed.Future)\nDistributed.fetch(::RemoteChannel)\nDistributed.remotecall(::Any, ::Integer, ::Any...)\nDistributed.remotecall_wait(::Any, ::Integer, ::Any...)\nDistributed.remotecall_fetch(::Any, ::Integer, ::Any...)\nDistributed.remote_do(::Any, ::Integer, ::Any...)\nDistributed.put!(::RemoteChannel, ::Any...)\nDistributed.put!(::Distributed.Future, ::Any)\nDistributed.take!(::RemoteChannel, ::Any...)\nDistributed.isready(::RemoteChannel, ::Any...)\nDistributed.isready(::Distributed.Future)\nDistributed.AbstractWorkerPool\nDistributed.WorkerPool\nDistributed.CachingPool\nDistributed.default_worker_pool\nDistributed.clear!(::CachingPool)\nDistributed.remote\nDistributed.remotecall(::Any, ::AbstractWorkerPool, ::Any...)\nDistributed.remotecall_wait(::Any, ::AbstractWorkerPool, ::Any...)\nDistributed.remotecall_fetch(::Any, ::AbstractWorkerPool, ::Any...)\nDistributed.remote_do(::Any, ::AbstractWorkerPool, ::Any...)\nDistributed.@spawnat\nDistributed.@fetch\nDistributed.@fetchfrom\nDistributed.@distributed\nDistributed.@everywhere\nDistributed.clear!(::Any, ::Any; ::Any)\nDistributed.remoteref_id\nDistributed.channel_from_id\nDistributed.worker_id_from_socket\nDistributed.cluster_cookie()\nDistributed.cluster_cookie(::Any)","page":"Distributed Computing"},{"title":"Distributed.addprocs","location":"stdlib/Distributed.html#Distributed.addprocs","category":"function","text":"addprocs(manager::ClusterManager; kwargs...) -> List of process identifiers\n\nLaunches worker processes via the specified cluster manager.\n\nFor example, Beowulf clusters are supported via a custom cluster manager implemented in the package ClusterManagers.jl.\n\nThe number of seconds a newly launched worker waits for connection establishment from the master can be specified via variable JULIA_WORKER_TIMEOUT in the worker process's environment. Relevant only when using TCP/IP as transport.\n\nTo launch workers without blocking the REPL, or the containing function if launching workers programmatically, execute addprocs in its own task.\n\nExamples\n\n# On busy clusters, call `addprocs` asynchronously\nt = @async addprocs(...)\n\n# Utilize workers as and when they come online\nif nprocs() > 1   # Ensure at least one new worker is available\n   ....   # perform distributed execution\nend\n\n# Retrieve newly launched worker IDs, or any error messages\nif istaskdone(t)   # Check if `addprocs` has completed to ensure `fetch` doesn't block\n    if nworkers() == N\n        new_pids = fetch(t)\n    else\n        fetch(t)\n    end\n  end\n\n\n\n\n\naddprocs(machines; tunnel=false, sshflags=``, max_parallel=10, kwargs...) -> List of process identifiers\n\nAdd processes on remote machines via SSH. See exename to set the path to the julia installation on remote machines.\n\nmachines is a vector of machine specifications. Workers are started for each specification.\n\nA machine specification is either a string machine_spec or a tuple - (machine_spec, count).\n\nmachine_spec is a string of the form [user@]host[:port] [bind_addr[:port]]. user defaults to current user, port to the standard ssh port. If [bind_addr[:port]] is specified, other workers will connect to this worker at the specified bind_addr and port.\n\ncount is the number of workers to be launched on the specified host. If specified as :auto it will launch as many workers as the number of CPU threads on the specific host.\n\nKeyword arguments:\n\ntunnel: if true then SSH tunneling will be used to connect to the worker from the master process. Default is false.\nmultiplex: if true then SSH multiplexing is used for SSH tunneling. Default is false.\nssh: the name or path of the SSH client executable used to start the workers. Default is \"ssh\".\nsshflags: specifies additional ssh options, e.g. sshflags=`-i /home/foo/bar.pem`\nmax_parallel: specifies the maximum number of workers connected to in parallel at a host. Defaults to 10.\nshell: specifies the type of shell to which ssh connects on the workers.\nshell=:posix: a POSIX-compatible Unix/Linux shell (bash, sh, etc.). The default.\nshell=:wincmd: Microsoft Windows cmd.exe.\ndir: specifies the working directory on the workers. Defaults to the host's current directory (as found by pwd())\nenable_threaded_blas: if true then  BLAS will run on multiple threads in added processes. Default is false.\nexename: name of the julia executable. Defaults to \"$(Sys.BINDIR)/julia\" or \"$(Sys.BINDIR)/julia-debug\" as the case may be.\nexeflags: additional flags passed to the worker processes.\ntopology: Specifies how the workers connect to each other. Sending a message between unconnected workers results in an error.\ntopology=:all_to_all: All processes are connected to each other. The default.\ntopology=:master_worker: Only the driver process, i.e. pid 1 connects to the workers. The workers do not connect to each other.\ntopology=:custom: The launch method of the cluster manager specifies the connection topology via fields ident and connect_idents in WorkerConfig. A worker with a cluster manager identity ident will connect to all workers specified in connect_idents.\nlazy: Applicable only with topology=:all_to_all. If true, worker-worker connections are setup lazily, i.e. they are setup at the first instance of a remote call between workers. Default is true.\nenv: provide an array of string pairs such as env=[\"JULIA_DEPOT_PATH\"=>\"/depot\"] to request that environment variables are set on the remote machine. By default only the environment variable JULIA_WORKER_TIMEOUT is passed automatically from the local to the remote environment.\ncmdline_cookie: pass the authentication cookie via the --worker commandline  option. The (more secure) default behaviour of passing the cookie via ssh stdio  may hang with Windows workers that use older (pre-ConPTY) Julia or Windows versions,  in which case cmdline_cookie=true offers a work-around.\n\ncompat: Julia 1.6\nThe keyword arguments ssh, shell, env and cmdline_cookie were added in Julia 1.6.\n\nEnvironment variables:\n\nIf the master process fails to establish a connection with a newly launched worker within 60.0 seconds, the worker treats it as a fatal situation and terminates. This timeout can be controlled via environment variable JULIA_WORKER_TIMEOUT. The value of JULIA_WORKER_TIMEOUT on the master process specifies the number of seconds a newly launched worker waits for connection establishment.\n\n\n\n\n\naddprocs(; kwargs...) -> List of process identifiers\n\nEquivalent to addprocs(Sys.CPU_THREADS; kwargs...)\n\nNote that workers do not run a .julia/config/startup.jl startup script, nor do they synchronize their global state (such as global variables, new method definitions, and loaded modules) with any of the other running processes.\n\n\n\n\n\naddprocs(np::Integer; restrict=true, kwargs...) -> List of process identifiers\n\nLaunches workers using the in-built LocalManager which only launches workers on the local host. This can be used to take advantage of multiple cores. addprocs(4) will add 4 processes on the local machine. If restrict is true, binding is restricted to 127.0.0.1. Keyword args dir, exename, exeflags, topology, lazy and enable_threaded_blas have the same effect as documented for addprocs(machines).\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.nprocs","location":"stdlib/Distributed.html#Distributed.nprocs","category":"function","text":"nprocs()\n\nGet the number of available processes.\n\nExamples\n\njulia> nprocs()\n3\n\njulia> workers()\n5-element Array{Int64,1}:\n 2\n 3\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.nworkers","location":"stdlib/Distributed.html#Distributed.nworkers","category":"function","text":"nworkers()\n\nGet the number of available worker processes. This is one less than nprocs(). Equal to nprocs() if nprocs() == 1.\n\nExamples\n\n$ julia -p 2\n\njulia> nprocs()\n3\n\njulia> nworkers()\n2\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.procs","location":"stdlib/Distributed.html#Distributed.procs-Tuple{}","category":"method","text":"procs()\n\nReturn a list of all process identifiers, including pid 1 (which is not included by workers()).\n\nExamples\n\n$ julia -p 2\n\njulia> procs()\n3-element Array{Int64,1}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.procs","location":"stdlib/Distributed.html#Distributed.procs-Tuple{Integer}","category":"method","text":"procs(pid::Integer)\n\nReturn a list of all process identifiers on the same physical node. Specifically all workers bound to the same ip-address as pid are returned.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.workers","location":"stdlib/Distributed.html#Distributed.workers","category":"function","text":"workers()\n\nReturn a list of all worker process identifiers.\n\nExamples\n\n$ julia -p 2\n\njulia> workers()\n2-element Array{Int64,1}:\n 2\n 3\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.rmprocs","location":"stdlib/Distributed.html#Distributed.rmprocs","category":"function","text":"rmprocs(pids...; waitfor=typemax(Int))\n\nRemove the specified workers. Note that only process 1 can add or remove workers.\n\nArgument waitfor specifies how long to wait for the workers to shut down:\n\nIf unspecified, rmprocs will wait until all requested pids are removed.\nAn ErrorException is raised if all workers cannot be terminated before the requested waitfor seconds.\nWith a waitfor value of 0, the call returns immediately with the workers scheduled for removal in a different task. The scheduled Task object is returned. The user should call wait on the task before invoking any other parallel calls.\n\nExamples\n\n$ julia -p 5\n\njulia> t = rmprocs(2, 3, waitfor=0)\nTask (runnable) @0x0000000107c718d0\n\njulia> wait(t)\n\njulia> workers()\n3-element Array{Int64,1}:\n 4\n 5\n 6\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.interrupt","location":"stdlib/Distributed.html#Distributed.interrupt","category":"function","text":"interrupt(pids::Integer...)\n\nInterrupt the current executing task on the specified workers. This is equivalent to pressing Ctrl-C on the local machine. If no arguments are given, all workers are interrupted.\n\n\n\n\n\ninterrupt(pids::AbstractVector=workers())\n\nInterrupt the current executing task on the specified workers. This is equivalent to pressing Ctrl-C on the local machine. If no arguments are given, all workers are interrupted.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.myid","location":"stdlib/Distributed.html#Distributed.myid","category":"function","text":"myid()\n\nGet the id of the current process.\n\nExamples\n\njulia> myid()\n1\n\njulia> remotecall_fetch(() -> myid(), 4)\n4\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.pmap","location":"stdlib/Distributed.html#Distributed.pmap","category":"function","text":"pmap(f, [::AbstractWorkerPool], c...; distributed=true, batch_size=1, on_error=nothing, retry_delays=[], retry_check=nothing) -> collection\n\nTransform collection c by applying f to each element using available workers and tasks.\n\nFor multiple collection arguments, apply f elementwise.\n\nNote that f must be made available to all worker processes; see Code Availability and Loading Packages for details.\n\nIf a worker pool is not specified, all available workers, i.e., the default worker pool is used.\n\nBy default, pmap distributes the computation over all specified workers. To use only the local process and distribute over tasks, specify distributed=false. This is equivalent to using asyncmap. For example, pmap(f, c; distributed=false) is equivalent to asyncmap(f,c; ntasks=()->nworkers())\n\npmap can also use a mix of processes and tasks via the batch_size argument. For batch sizes greater than 1, the collection is processed in multiple batches, each of length batch_size or less. A batch is sent as a single request to a free worker, where a local asyncmap processes elements from the batch using multiple concurrent tasks.\n\nAny error stops pmap from processing the remainder of the collection. To override this behavior you can specify an error handling function via argument on_error which takes in a single argument, i.e., the exception. The function can stop the processing by rethrowing the error, or, to continue, return any value which is then returned inline with the results to the caller.\n\nConsider the following two examples. The first one returns the exception object inline, the second a 0 in place of any exception:\n\njulia> pmap(x->iseven(x) ? error(\"foo\") : x, 1:4; on_error=identity)\n4-element Array{Any,1}:\n 1\n  ErrorException(\"foo\")\n 3\n  ErrorException(\"foo\")\n\njulia> pmap(x->iseven(x) ? error(\"foo\") : x, 1:4; on_error=ex->0)\n4-element Array{Int64,1}:\n 1\n 0\n 3\n 0\n\nErrors can also be handled by retrying failed computations. Keyword arguments retry_delays and retry_check are passed through to retry as keyword arguments delays and check respectively. If batching is specified, and an entire batch fails, all items in the batch are retried.\n\nNote that if both on_error and retry_delays are specified, the on_error hook is called before retrying. If on_error does not throw (or rethrow) an exception, the element will not be retried.\n\nExample: On errors, retry f on an element a maximum of 3 times without any delay between retries.\n\npmap(f, c; retry_delays = zeros(3))\n\nExample: Retry f only if the exception is not of type InexactError, with exponentially increasing delays up to 3 times. Return a NaN in place for all InexactError occurrences.\n\npmap(f, c; on_error = e->(isa(e, InexactError) ? NaN : rethrow()), retry_delays = ExponentialBackOff(n = 3))\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.RemoteException","location":"stdlib/Distributed.html#Distributed.RemoteException","category":"type","text":"RemoteException(captured)\n\nExceptions on remote computations are captured and rethrown locally.  A RemoteException wraps the pid of the worker and a captured exception. A CapturedException captures the remote exception and a serializable form of the call stack when the exception was raised.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.Future","location":"stdlib/Distributed.html#Distributed.Future","category":"type","text":"Future(w::Int, rrid::RRID, v::Union{Some, Nothing}=nothing)\n\nA Future is a placeholder for a single computation of unknown termination status and time. For multiple potential computations, see RemoteChannel. See remoteref_id for identifying an AbstractRemoteRef.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.RemoteChannel","location":"stdlib/Distributed.html#Distributed.RemoteChannel","category":"type","text":"RemoteChannel(pid::Integer=myid())\n\nMake a reference to a Channel{Any}(1) on process pid. The default pid is the current process.\n\nRemoteChannel(f::Function, pid::Integer=myid())\n\nCreate references to remote channels of a specific size and type. f is a function that when executed on pid must return an implementation of an AbstractChannel.\n\nFor example, RemoteChannel(()->Channel{Int}(10), pid), will return a reference to a channel of type Int and size 10 on pid.\n\nThe default pid is the current process.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.fetch","location":"stdlib/Distributed.html#Base.fetch-Tuple{Distributed.Future}","category":"method","text":"fetch(x::Future)\n\nWait for and get the value of a Future. The fetched value is cached locally. Further calls to fetch on the same reference return the cached value. If the remote value is an exception, throws a RemoteException which captures the remote exception and backtrace.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.fetch","location":"stdlib/Distributed.html#Base.fetch-Tuple{RemoteChannel}","category":"method","text":"fetch(c::RemoteChannel)\n\nWait for and get a value from a RemoteChannel. Exceptions raised are the same as for a Future. Does not remove the item fetched.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remotecall","location":"stdlib/Distributed.html#Distributed.remotecall-Tuple{Any, Integer, Vararg{Any, N} where N}","category":"method","text":"remotecall(f, id::Integer, args...; kwargs...) -> Future\n\nCall a function f asynchronously on the given arguments on the specified process. Return a Future. Keyword arguments, if any, are passed through to f.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remotecall_wait","location":"stdlib/Distributed.html#Distributed.remotecall_wait-Tuple{Any, Integer, Vararg{Any, N} where N}","category":"method","text":"remotecall_wait(f, id::Integer, args...; kwargs...)\n\nPerform a faster wait(remotecall(...)) in one message on the Worker specified by worker id id. Keyword arguments, if any, are passed through to f.\n\nSee also wait and remotecall.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remotecall_fetch","location":"stdlib/Distributed.html#Distributed.remotecall_fetch-Tuple{Any, Integer, Vararg{Any, N} where N}","category":"method","text":"remotecall_fetch(f, id::Integer, args...; kwargs...)\n\nPerform fetch(remotecall(...)) in one message. Keyword arguments, if any, are passed through to f. Any remote exceptions are captured in a RemoteException and thrown.\n\nSee also fetch and remotecall.\n\nExamples\n\n$ julia -p 2\n\njulia> remotecall_fetch(sqrt, 2, 4)\n2.0\n\njulia> remotecall_fetch(sqrt, 2, -4)\nERROR: On worker 2:\nDomainError with -4.0:\nsqrt will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\n...\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remote_do","location":"stdlib/Distributed.html#Distributed.remote_do-Tuple{Any, Integer, Vararg{Any, N} where N}","category":"method","text":"remote_do(f, id::Integer, args...; kwargs...) -> nothing\n\nExecutes f on worker id asynchronously. Unlike remotecall, it does not store the result of computation, nor is there a way to wait for its completion.\n\nA successful invocation indicates that the request has been accepted for execution on the remote node.\n\nWhile consecutive remotecalls to the same worker are serialized in the order they are invoked, the order of executions on the remote worker is undetermined. For example, remote_do(f1, 2); remotecall(f2, 2); remote_do(f3, 2) will serialize the call to f1, followed by f2 and f3 in that order. However, it is not guaranteed that f1 is executed before f3 on worker 2.\n\nAny exceptions thrown by f are printed to stderr on the remote worker.\n\nKeyword arguments, if any, are passed through to f.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.put!","location":"stdlib/Distributed.html#Base.put!-Tuple{RemoteChannel, Vararg{Any, N} where N}","category":"method","text":"put!(rr::RemoteChannel, args...)\n\nStore a set of values to the RemoteChannel. If the channel is full, blocks until space is available. Return the first argument.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.put!","location":"stdlib/Distributed.html#Base.put!-Tuple{Distributed.Future, Any}","category":"method","text":"put!(rr::Future, v)\n\nStore a value to a Future rr. Futures are write-once remote references. A put! on an already set Future throws an Exception. All asynchronous remote calls return Futures and set the value to the return value of the call upon completion.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.take!","location":"stdlib/Distributed.html#Base.take!-Tuple{RemoteChannel, Vararg{Any, N} where N}","category":"method","text":"take!(rr::RemoteChannel, args...)\n\nFetch value(s) from a RemoteChannel rr, removing the value(s) in the process.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.isready","location":"stdlib/Distributed.html#Base.isready-Tuple{RemoteChannel, Vararg{Any, N} where N}","category":"method","text":"isready(rr::RemoteChannel, args...)\n\nDetermine whether a RemoteChannel has a value stored to it. Note that this function can cause race conditions, since by the time you receive its result it may no longer be true. However, it can be safely used on a Future since they are assigned only once.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.isready","location":"stdlib/Distributed.html#Base.isready-Tuple{Distributed.Future}","category":"method","text":"isready(rr::Future)\n\nDetermine whether a Future has a value stored to it.\n\nIf the argument Future is owned by a different node, this call will block to wait for the answer. It is recommended to wait for rr in a separate task instead or to use a local Channel as a proxy:\n\np = 1\nf = Future(p)\n@async put!(f, remotecall_fetch(long_computation, p))\nisready(f)  # will not block\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.AbstractWorkerPool","location":"stdlib/Distributed.html#Distributed.AbstractWorkerPool","category":"type","text":"AbstractWorkerPool\n\nSupertype for worker pools such as WorkerPool and CachingPool. An AbstractWorkerPool should implement:\n\npush! - add a new worker to the overall pool (available + busy)\nput! - put back a worker to the available pool\ntake! - take a worker from the available pool (to be used for remote function execution)\nlength - number of workers available in the overall pool\nisready - return false if a take! on the pool would block, else true\n\nThe default implementations of the above (on a AbstractWorkerPool) require fields\n\nchannel::Channel{Int}\nworkers::Set{Int}\n\nwhere channel contains free worker pids and workers is the set of all workers associated with this pool.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.WorkerPool","location":"stdlib/Distributed.html#Distributed.WorkerPool","category":"type","text":"WorkerPool(workers::Vector{Int})\n\nCreate a WorkerPool from a vector of worker ids.\n\nExamples\n\n$ julia -p 3\n\njulia> WorkerPool([2, 3])\nWorkerPool(Channel{Int64}(sz_max:9223372036854775807,sz_curr:2), Set([2, 3]), RemoteChannel{Channel{Any}}(1, 1, 6))\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.CachingPool","location":"stdlib/Distributed.html#Distributed.CachingPool","category":"type","text":"CachingPool(workers::Vector{Int})\n\nAn implementation of an AbstractWorkerPool. remote, remotecall_fetch, pmap (and other remote calls which execute functions remotely) benefit from caching the serialized/deserialized functions on the worker nodes, especially closures (which may capture large amounts of data).\n\nThe remote cache is maintained for the lifetime of the returned CachingPool object. To clear the cache earlier, use clear!(pool).\n\nFor global variables, only the bindings are captured in a closure, not the data. let blocks can be used to capture global data.\n\nExamples\n\nconst foo = rand(10^8);\nwp = CachingPool(workers())\nlet foo = foo\n    pmap(i -> sum(foo) + i, wp, 1:100);\nend\n\nThe above would transfer foo only once to each worker.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.default_worker_pool","location":"stdlib/Distributed.html#Distributed.default_worker_pool","category":"function","text":"default_worker_pool()\n\nWorkerPool containing idle workers - used by remote(f) and pmap (by default).\n\nExamples\n\n$ julia -p 3\n\njulia> default_worker_pool()\nWorkerPool(Channel{Int64}(sz_max:9223372036854775807,sz_curr:3), Set([4, 2, 3]), RemoteChannel{Channel{Any}}(1, 1, 4))\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.clear!","location":"stdlib/Distributed.html#Distributed.clear!-Tuple{CachingPool}","category":"method","text":"clear!(pool::CachingPool) -> pool\n\nRemoves all cached functions from all participating workers.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remote","location":"stdlib/Distributed.html#Distributed.remote","category":"function","text":"remote([p::AbstractWorkerPool], f) -> Function\n\nReturn an anonymous function that executes function f on an available worker (drawn from WorkerPool p if provided) using remotecall_fetch.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remotecall","location":"stdlib/Distributed.html#Distributed.remotecall-Tuple{Any, AbstractWorkerPool, Vararg{Any, N} where N}","category":"method","text":"remotecall(f, pool::AbstractWorkerPool, args...; kwargs...) -> Future\n\nWorkerPool variant of remotecall(f, pid, ....). Wait for and take a free worker from pool and perform a remotecall on it.\n\nExamples\n\n$ julia -p 3\n\njulia> wp = WorkerPool([2, 3]);\n\njulia> A = rand(3000);\n\njulia> f = remotecall(maximum, wp, A)\nFuture(2, 1, 6, nothing)\n\nIn this example, the task ran on pid 2, called from pid 1.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remotecall_wait","location":"stdlib/Distributed.html#Distributed.remotecall_wait-Tuple{Any, AbstractWorkerPool, Vararg{Any, N} where N}","category":"method","text":"remotecall_wait(f, pool::AbstractWorkerPool, args...; kwargs...) -> Future\n\nWorkerPool variant of remotecall_wait(f, pid, ....). Wait for and take a free worker from pool and perform a remotecall_wait on it.\n\nExamples\n\n$ julia -p 3\n\njulia> wp = WorkerPool([2, 3]);\n\njulia> A = rand(3000);\n\njulia> f = remotecall_wait(maximum, wp, A)\nFuture(3, 1, 9, nothing)\n\njulia> fetch(f)\n0.9995177101692958\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remotecall_fetch","location":"stdlib/Distributed.html#Distributed.remotecall_fetch-Tuple{Any, AbstractWorkerPool, Vararg{Any, N} where N}","category":"method","text":"remotecall_fetch(f, pool::AbstractWorkerPool, args...; kwargs...) -> result\n\nWorkerPool variant of remotecall_fetch(f, pid, ....). Waits for and takes a free worker from pool and performs a remotecall_fetch on it.\n\nExamples\n\n$ julia -p 3\n\njulia> wp = WorkerPool([2, 3]);\n\njulia> A = rand(3000);\n\njulia> remotecall_fetch(maximum, wp, A)\n0.9995177101692958\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remote_do","location":"stdlib/Distributed.html#Distributed.remote_do-Tuple{Any, AbstractWorkerPool, Vararg{Any, N} where N}","category":"method","text":"remote_do(f, pool::AbstractWorkerPool, args...; kwargs...) -> nothing\n\nWorkerPool variant of remote_do(f, pid, ....). Wait for and take a free worker from pool and perform a remote_do on it.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.@spawnat","location":"stdlib/Distributed.html#Distributed.@spawnat","category":"macro","text":"@spawnat p expr\n\nCreate a closure around an expression and run the closure asynchronously on process p. Return a Future to the result. If p is the quoted literal symbol :any, then the system will pick a processor to use automatically.\n\nExamples\n\njulia> addprocs(3);\n\njulia> f = @spawnat 2 myid()\nFuture(2, 1, 3, nothing)\n\njulia> fetch(f)\n2\n\njulia> f = @spawnat :any myid()\nFuture(3, 1, 7, nothing)\n\njulia> fetch(f)\n3\n\ncompat: Julia 1.3\nThe :any argument is available as of Julia 1.3.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.@fetch","location":"stdlib/Distributed.html#Distributed.@fetch","category":"macro","text":"@fetch expr\n\nEquivalent to fetch(@spawnat :any expr). See fetch and @spawnat.\n\nExamples\n\njulia> addprocs(3);\n\njulia> @fetch myid()\n2\n\njulia> @fetch myid()\n3\n\njulia> @fetch myid()\n4\n\njulia> @fetch myid()\n2\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.@fetchfrom","location":"stdlib/Distributed.html#Distributed.@fetchfrom","category":"macro","text":"@fetchfrom\n\nEquivalent to fetch(@spawnat p expr). See fetch and @spawnat.\n\nExamples\n\njulia> addprocs(3);\n\njulia> @fetchfrom 2 myid()\n2\n\njulia> @fetchfrom 4 myid()\n4\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.@distributed","location":"stdlib/Distributed.html#Distributed.@distributed","category":"macro","text":"@distributed\n\nA distributed memory, parallel for loop of the form :\n\n@distributed [reducer] for var = range\n    body\nend\n\nThe specified range is partitioned and locally executed across all workers. In case an optional reducer function is specified, @distributed performs local reductions on each worker with a final reduction on the calling process.\n\nNote that without a reducer function, @distributed executes asynchronously, i.e. it spawns independent tasks on all available workers and returns immediately without waiting for completion. To wait for completion, prefix the call with @sync, like :\n\n@sync @distributed for var = range\n    body\nend\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.@everywhere","location":"stdlib/Distributed.html#Distributed.@everywhere","category":"macro","text":"@everywhere [procs()] expr\n\nExecute an expression under Main on all procs. Errors on any of the processes are collected into a CompositeException and thrown. For example:\n\n@everywhere bar = 1\n\nwill define Main.bar on all current processes. Any processes added later (say with addprocs()) will not have the expression defined.\n\nUnlike @spawnat, @everywhere does not capture any local variables. Instead, local variables can be broadcast using interpolation:\n\nfoo = 1\n@everywhere bar = $foo\n\nThe optional argument procs allows specifying a subset of all processes to have execute the expression.\n\nSimilar to calling remotecall_eval(Main, procs, expr), but with two extra features:\n\n- `using` and `import` statements run on the calling process first, to ensure\n  packages are precompiled.\n- The current source file path used by `include` is propagated to other processes.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.clear!","location":"stdlib/Distributed.html#Distributed.clear!-Tuple{Any, Any}","category":"method","text":"clear!(syms, pids=workers(); mod=Main)\n\nClears global bindings in modules by initializing them to nothing. syms should be of type Symbol or a collection of Symbols . pids and mod identify the processes and the module in which global variables are to be reinitialized. Only those names found to be defined under mod are cleared.\n\nAn exception is raised if a global constant is requested to be cleared.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.remoteref_id","location":"stdlib/Distributed.html#Distributed.remoteref_id","category":"function","text":"remoteref_id(r::AbstractRemoteRef) -> RRID\n\nFutures and RemoteChannels are identified by fields:\n\nwhere - refers to the node where the underlying object/storage referred to by the reference actually exists.\nwhence - refers to the node the remote reference was created from. Note that this is different from the node where the underlying object referred to actually exists. For example calling RemoteChannel(2) from the master process would result in a where value of 2 and a whence value of 1.\nid is unique across all references created from the worker specified by whence.\n\nTaken together,  whence and id uniquely identify a reference across all workers.\n\nremoteref_id is a low-level API which returns a RRID object that wraps whence and id values of a remote reference.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.channel_from_id","location":"stdlib/Distributed.html#Distributed.channel_from_id","category":"function","text":"channel_from_id(id) -> c\n\nA low-level API which returns the backing AbstractChannel for an id returned by remoteref_id. The call is valid only on the node where the backing channel exists.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.worker_id_from_socket","location":"stdlib/Distributed.html#Distributed.worker_id_from_socket","category":"function","text":"worker_id_from_socket(s) -> pid\n\nA low-level API which, given a IO connection or a Worker, returns the pid of the worker it is connected to. This is useful when writing custom serialize methods for a type, which optimizes the data written out depending on the receiving process id.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.cluster_cookie","location":"stdlib/Distributed.html#Distributed.cluster_cookie-Tuple{}","category":"method","text":"cluster_cookie() -> cookie\n\nReturn the cluster cookie.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.cluster_cookie","location":"stdlib/Distributed.html#Distributed.cluster_cookie-Tuple{Any}","category":"method","text":"cluster_cookie(cookie) -> cookie\n\nSet the passed cookie as the cluster cookie, then returns it.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Cluster Manager Interface","location":"stdlib/Distributed.html#Cluster-Manager-Interface","category":"section","text":"","page":"Distributed Computing"},{"title":"Distributed Computing","location":"stdlib/Distributed.html","category":"page","text":"This interface provides a mechanism to launch and manage Julia workers on different cluster environments. There are two types of managers present in Base: LocalManager, for launching additional workers on the same host, and SSHManager, for launching on remote hosts via ssh. TCP/IP sockets are used to connect and transport messages between processes. It is possible for Cluster Managers to provide a different transport.","page":"Distributed Computing"},{"title":"Distributed Computing","location":"stdlib/Distributed.html","category":"page","text":"Distributed.ClusterManager\nDistributed.WorkerConfig\nDistributed.launch\nDistributed.manage\nDistributed.kill(::ClusterManager, ::Int, ::WorkerConfig)\nDistributed.connect(::ClusterManager, ::Int, ::WorkerConfig)\nDistributed.init_worker\nDistributed.start_worker\nDistributed.process_messages\nDistributed.default_addprocs_params","page":"Distributed Computing"},{"title":"Distributed.ClusterManager","location":"stdlib/Distributed.html#Distributed.ClusterManager","category":"type","text":"ClusterManager\n\nSupertype for cluster managers, which control workers processes as a cluster. Cluster managers implement how workers can be added, removed and communicated with. SSHManager and LocalManager are subtypes of this.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.WorkerConfig","location":"stdlib/Distributed.html#Distributed.WorkerConfig","category":"type","text":"WorkerConfig\n\nType used by ClusterManagers to control workers added to their clusters. Some fields are used by all cluster managers to access a host:\n\nio – the connection used to access the worker (a subtype of IO or Nothing)\nhost – the host address (either a String or Nothing)\nport – the port on the host used to connect to the worker (either an Int or Nothing)\n\nSome are used by the cluster manager to add workers to an already-initialized host:\n\ncount – the number of workers to be launched on the host\nexename – the path to the Julia executable on the host, defaults to \"$(Sys.BINDIR)/julia\" or \"$(Sys.BINDIR)/julia-debug\"\nexeflags – flags to use when lauching Julia remotely\n\nThe userdata field is used to store information for each worker by external managers.\n\nSome fields are used by SSHManager and similar managers:\n\ntunnel – true (use tunneling), false (do not use tunneling), or nothing (use default for the manager)\nmultiplex – true (use SSH multiplexing for tunneling) or false\nforward – the forwarding option used for -L option of ssh\nbind_addr – the address on the remote host to bind to\nsshflags – flags to use in establishing the SSH connection\nmax_parallel – the maximum number of workers to connect to in parallel on the host\n\nSome fields are used by both LocalManagers and SSHManagers:\n\nconnect_at – determines whether this is a worker-to-worker or driver-to-worker setup call\nprocess – the process which will be connected (usually the manager will assign this during addprocs)\nospid – the process ID according to the host OS, used to interrupt worker processes\nenviron – private dictionary used to store temporary information by Local/SSH managers\nident – worker as identified by the ClusterManager\nconnect_idents – list of worker ids the worker must connect to if using a custom topology\nenable_threaded_blas – true, false, or nothing, whether to use threaded BLAS or not on the workers\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.launch","location":"stdlib/Distributed.html#Distributed.launch","category":"function","text":"launch(manager::ClusterManager, params::Dict, launched::Array, launch_ntfy::Condition)\n\nImplemented by cluster managers. For every Julia worker launched by this function, it should append a WorkerConfig entry to launched and notify launch_ntfy. The function MUST exit once all workers, requested by manager have been launched. params is a dictionary of all keyword arguments addprocs was called with.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.manage","location":"stdlib/Distributed.html#Distributed.manage","category":"function","text":"manage(manager::ClusterManager, id::Integer, config::WorkerConfig. op::Symbol)\n\nImplemented by cluster managers. It is called on the master process, during a worker's lifetime, with appropriate op values:\n\nwith :register/:deregister when a worker is added / removed from the Julia worker pool.\nwith :interrupt when interrupt(workers) is called. The ClusterManager should signal the appropriate worker with an interrupt signal.\nwith :finalize for cleanup purposes.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Base.kill","location":"stdlib/Distributed.html#Base.kill-Tuple{ClusterManager, Int32, WorkerConfig}","category":"method","text":"kill(manager::ClusterManager, pid::Int, config::WorkerConfig)\n\nImplemented by cluster managers. It is called on the master process, by rmprocs. It should cause the remote worker specified by pid to exit. kill(manager::ClusterManager.....) executes a remote exit() on pid.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Sockets.connect","location":"stdlib/Distributed.html#Sockets.connect-Tuple{ClusterManager, Int32, WorkerConfig}","category":"method","text":"connect(manager::ClusterManager, pid::Int, config::WorkerConfig) -> (instrm::IO, outstrm::IO)\n\nImplemented by cluster managers using custom transports. It should establish a logical connection to worker with id pid, specified by config and return a pair of IO objects. Messages from pid to current process will be read off instrm, while messages to be sent to pid will be written to outstrm. The custom transport implementation must ensure that messages are delivered and received completely and in order. connect(manager::ClusterManager.....) sets up TCP/IP socket connections in-between workers.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.init_worker","location":"stdlib/Distributed.html#Distributed.init_worker","category":"function","text":"init_worker(cookie::AbstractString, manager::ClusterManager=DefaultClusterManager())\n\nCalled by cluster managers implementing custom transports. It initializes a newly launched process as a worker. Command line argument --worker[=<cookie>] has the effect of initializing a process as a worker using TCP/IP sockets for transport. cookie is a cluster_cookie.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.start_worker","location":"stdlib/Distributed.html#Distributed.start_worker","category":"function","text":"start_worker([out::IO=stdout], cookie::AbstractString=readline(stdin); close_stdin::Bool=true, stderr_to_stdout::Bool=true)\n\nstart_worker is an internal function which is the default entry point for worker processes connecting via TCP/IP. It sets up the process as a Julia cluster worker.\n\nhost:port information is written to stream out (defaults to stdout).\n\nThe function reads the cookie from stdin if required, and  listens on a free port (or if specified, the port in the --bind-to command line option) and schedules tasks to process incoming TCP connections and requests. It also (optionally) closes stdin and redirects stderr to stdout.\n\nIt does not return.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.process_messages","location":"stdlib/Distributed.html#Distributed.process_messages","category":"function","text":"process_messages(r_stream::IO, w_stream::IO, incoming::Bool=true)\n\nCalled by cluster managers using custom transports. It should be called when the custom transport implementation receives the first message from a remote worker. The custom transport must manage a logical connection to the remote worker and provide two IO objects, one for incoming messages and the other for messages addressed to the remote worker. If incoming is true, the remote peer initiated the connection. Whichever of the pair initiates the connection sends the cluster cookie and its Julia version number to perform the authentication handshake.\n\nSee also cluster_cookie.\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"Distributed.default_addprocs_params","location":"stdlib/Distributed.html#Distributed.default_addprocs_params","category":"function","text":"default_addprocs_params(mgr::ClusterManager) -> Dict{Symbol, Any}\n\nImplemented by cluster managers. The default keyword parameters passed when calling addprocs(mgr). The minimal set of options is available by calling default_addprocs_params()\n\n\n\n\n\n","page":"Distributed Computing"},{"title":"CRC32c","location":"stdlib/CRC32c.html#CRC32c","category":"section","text":"","page":"CRC32c"},{"title":"CRC32c","location":"stdlib/CRC32c.html","category":"page","text":"CRC32c.crc32c\nCRC32c.crc32c(::IO, ::Integer, ::UInt32)","page":"CRC32c"},{"title":"CRC32c.crc32c","location":"stdlib/CRC32c.html#CRC32c.crc32c","category":"function","text":"crc32c(data, crc::UInt32=0x00000000)\n\nCompute the CRC-32c checksum of the given data, which can be an Array{UInt8}, a contiguous subarray thereof, or a String.  Optionally, you can pass a starting crc integer to be mixed in with the checksum.  The crc parameter can be used to compute a checksum on data divided into chunks: performing crc32c(data2, crc32c(data1)) is equivalent to the checksum of [data1; data2]. (Technically, a little-endian checksum is computed.)\n\nThere is also a method crc32c(io, nb, crc) to checksum nb bytes from a stream io, or crc32c(io, crc) to checksum all the remaining bytes. Hence you can do open(crc32c, filename) to checksum an entire file, or crc32c(seekstart(buf)) to checksum an IOBuffer without calling take!.\n\nFor a String, note that the result is specific to the UTF-8 encoding (a different checksum would be obtained from a different Unicode encoding). To checksum an a::Array of some other bitstype, you can do crc32c(reinterpret(UInt8,a)), but note that the result may be endian-dependent.\n\n\n\n\n\n","page":"CRC32c"},{"title":"CRC32c.crc32c","location":"stdlib/CRC32c.html#CRC32c.crc32c-Tuple{IO, Integer, UInt32}","category":"method","text":"crc32c(io::IO, [nb::Integer,] crc::UInt32=0x00000000)\n\nRead up to nb bytes from io and return the CRC-32c checksum, optionally mixed with a starting crc integer.  If nb is not supplied, then io will be read until the end of the stream.\n\n\n\n\n\n","page":"CRC32c"},{"title":"Dynamic Linker","location":"stdlib/Libdl.html#Dynamic-Linker","category":"section","text":"","page":"Dynamic Linker"},{"title":"Dynamic Linker","location":"stdlib/Libdl.html","category":"page","text":"Libdl.dlopen\nLibdl.dlopen_e\nLibdl.RTLD_NOW\nLibdl.dlsym\nLibdl.dlsym_e\nLibdl.dlclose\nLibdl.dlext\nLibdl.dllist\nLibdl.dlpath\nLibdl.find_library\nLibdl.DL_LOAD_PATH","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dlopen","location":"stdlib/Libdl.html#Base.Libc.Libdl.dlopen","category":"function","text":"dlopen(libfile::AbstractString [, flags::Integer]; throw_error:Bool = true)\n\nLoad a shared library, returning an opaque handle.\n\nThe extension given by the constant dlext (.so, .dll, or .dylib) can be omitted from the libfile string, as it is automatically appended if needed.   If libfile is not an absolute path name, then the paths in the array DL_LOAD_PATH are searched for libfile, followed by the system load path.\n\nThe optional flags argument is a bitwise-or of zero or more of RTLD_LOCAL, RTLD_GLOBAL, RTLD_LAZY, RTLD_NOW, RTLD_NODELETE, RTLD_NOLOAD, RTLD_DEEPBIND, and RTLD_FIRST. These are converted to the corresponding flags of the POSIX (and/or GNU libc and/or MacOS) dlopen command, if possible, or are ignored if the specified functionality is not available on the current platform. The default flags are platform specific. On MacOS the default dlopen flags are RTLD_LAZY|RTLD_DEEPBIND|RTLD_GLOBAL while on other platforms the defaults are RTLD_LAZY|RTLD_DEEPBIND|RTLD_LOCAL. An important usage of these flags is to specify non default behavior for when the dynamic library loader binds library references to exported symbols and if the bound references are put into process local or global scope. For instance RTLD_LAZY|RTLD_DEEPBIND|RTLD_GLOBAL allows the library's symbols to be available for usage in other shared libraries, addressing situations where there are dependencies between shared libraries.\n\nIf the library cannot be found, this method throws an error, unless the keyword argument throw_error is set to false, in which case this method returns nothing.\n\nnote: Note\nFrom Julia 1.6 on, this method replaces paths starting with @executable_path/ with  the path to the Julia executable, allowing for relocatable relative-path loads. In  Julia 1.5 and earlier, this only worked on macOS.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dlopen_e","location":"stdlib/Libdl.html#Base.Libc.Libdl.dlopen_e","category":"function","text":"dlopen_e(libfile::AbstractString [, flags::Integer])\n\nSimilar to dlopen, except returns C_NULL instead of raising errors. This method is now deprecated in favor of dlopen(libfile::AbstractString [, flags::Integer]; throw_error=false).\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.RTLD_NOW","location":"stdlib/Libdl.html#Base.Libc.Libdl.RTLD_NOW","category":"constant","text":"RTLD_DEEPBIND\nRTLD_FIRST\nRTLD_GLOBAL\nRTLD_LAZY\nRTLD_LOCAL\nRTLD_NODELETE\nRTLD_NOLOAD\nRTLD_NOW\n\nEnum constant for dlopen. See your platform man page for details, if applicable.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dlsym","location":"stdlib/Libdl.html#Base.Libc.Libdl.dlsym","category":"function","text":"dlsym(handle, sym)\n\nLook up a symbol from a shared library handle, return callable function pointer on success.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dlsym_e","location":"stdlib/Libdl.html#Base.Libc.Libdl.dlsym_e","category":"function","text":"dlsym_e(handle, sym)\n\nLook up a symbol from a shared library handle, silently return C_NULL on lookup failure. This method is now deprecated in favor of dlsym(handle, sym; throw_error=false).\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dlclose","location":"stdlib/Libdl.html#Base.Libc.Libdl.dlclose","category":"function","text":"dlclose(handle)\n\nClose shared library referenced by handle.\n\n\n\n\n\ndlclose(::Nothing)\n\nFor the very common pattern usage pattern of\n\ntry\n    hdl = dlopen(library_name)\n    ... do something\nfinally\n    dlclose(hdl)\nend\n\nWe define a dlclose() method that accepts a parameter of type Nothing, so that user code does not have to change its behavior for the case that library_name was not found.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dlext","location":"stdlib/Libdl.html#Base.Libc.Libdl.dlext","category":"constant","text":"dlext\n\nFile extension for dynamic libraries (e.g. dll, dylib, so) on the current platform.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dllist","location":"stdlib/Libdl.html#Base.Libc.Libdl.dllist","category":"function","text":"dllist()\n\nReturn the paths of dynamic libraries currently loaded in a Vector{String}.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.dlpath","location":"stdlib/Libdl.html#Base.Libc.Libdl.dlpath","category":"function","text":"dlpath(handle::Ptr{Cvoid})\n\nGiven a library handle from dlopen, return the full path.\n\n\n\n\n\ndlpath(libname::Union{AbstractString, Symbol})\n\nGet the full path of the library libname.\n\nExample\n\njulia> dlpath(\"libjulia\")\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.Libc.Libdl.find_library","location":"stdlib/Libdl.html#Base.Libc.Libdl.find_library","category":"function","text":"find_library(names, locations)\n\nSearches for the first library in names in the paths in the locations list, DL_LOAD_PATH, or system library paths (in that order) which can successfully be dlopen'd. On success, the return value will be one of the names (potentially prefixed by one of the paths in locations). This string can be assigned to a global const and used as the library name in future ccall's. On failure, it returns the empty string.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Base.DL_LOAD_PATH","location":"stdlib/Libdl.html#Base.DL_LOAD_PATH","category":"constant","text":"DL_LOAD_PATH\n\nWhen calling dlopen, the paths in this list will be searched first, in order, before searching the system locations for a valid library handle.\n\n\n\n\n\n","page":"Dynamic Linker"},{"title":"Memory-mapped I/O","location":"stdlib/Mmap.html#Memory-mapped-I/O","category":"section","text":"","page":"Memory-mapped I/O"},{"title":"Memory-mapped I/O","location":"stdlib/Mmap.html","category":"page","text":"Mmap.Anonymous\nMmap.mmap\nMmap.sync!","page":"Memory-mapped I/O"},{"title":"Mmap.Anonymous","location":"stdlib/Mmap.html#Mmap.Anonymous","category":"type","text":"Mmap.Anonymous(name::AbstractString=\"\", readonly::Bool=false, create::Bool=true)\n\nCreate an IO-like object for creating zeroed-out mmapped-memory that is not tied to a file for use in Mmap.mmap. Used by SharedArray for creating shared memory arrays.\n\nExamples\n\njulia> using Mmap\n\njulia> anon = Mmap.Anonymous();\n\njulia> isreadable(anon)\ntrue\n\njulia> iswritable(anon)\ntrue\n\njulia> isopen(anon)\ntrue\n\n\n\n\n\n","page":"Memory-mapped I/O"},{"title":"Mmap.mmap","location":"stdlib/Mmap.html#Mmap.mmap","category":"function","text":"Mmap.mmap(io::Union{IOStream,AbstractString,Mmap.AnonymousMmap}[, type::Type{Array{T,N}}, dims, offset]; grow::Bool=true, shared::Bool=true)\nMmap.mmap(type::Type{Array{T,N}}, dims)\n\nCreate an Array whose values are linked to a file, using memory-mapping. This provides a convenient way of working with data too large to fit in the computer's memory.\n\nThe type is an Array{T,N} with a bits-type element of T and dimension N that determines how the bytes of the array are interpreted. Note that the file must be stored in binary format, and no format conversions are possible (this is a limitation of operating systems, not Julia).\n\ndims is a tuple or single Integer specifying the size or length of the array.\n\nThe file is passed via the stream argument, either as an open IOStream or filename string. When you initialize the stream, use \"r\" for a \"read-only\" array, and \"w+\" to create a new array used to write values to disk.\n\nIf no type argument is specified, the default is Vector{UInt8}.\n\nOptionally, you can specify an offset (in bytes) if, for example, you want to skip over a header in the file. The default value for the offset is the current stream position for an IOStream.\n\nThe grow keyword argument specifies whether the disk file should be grown to accommodate the requested size of array (if the total file size is < requested array size). Write privileges are required to grow the file.\n\nThe shared keyword argument specifies whether the resulting Array and changes made to it will be visible to other processes mapping the same file.\n\nFor example, the following code\n\n# Create a file for mmapping\n# (you could alternatively use mmap to do this step, too)\nusing Mmap\nA = rand(1:20, 5, 30)\ns = open(\"/tmp/mmap.bin\", \"w+\")\n# We'll write the dimensions of the array as the first two Ints in the file\nwrite(s, size(A,1))\nwrite(s, size(A,2))\n# Now write the data\nwrite(s, A)\nclose(s)\n\n# Test by reading it back in\ns = open(\"/tmp/mmap.bin\")   # default is read-only\nm = read(s, Int)\nn = read(s, Int)\nA2 = Mmap.mmap(s, Matrix{Int}, (m,n))\n\ncreates a m-by-n Matrix{Int}, linked to the file associated with stream s.\n\nA more portable file would need to encode the word size – 32 bit or 64 bit – and endianness information in the header. In practice, consider encoding binary data using standard formats like HDF5 (which can be used with memory-mapping).\n\n\n\n\n\nMmap.mmap(io, BitArray, [dims, offset])\n\nCreate a BitArray whose values are linked to a file, using memory-mapping; it has the same purpose, works in the same way, and has the same arguments, as mmap, but the byte representation is different.\n\nExamples\n\njulia> using Mmap\n\njulia> io = open(\"mmap.bin\", \"w+\");\n\njulia> B = Mmap.mmap(io, BitArray, (25,30000));\n\njulia> B[3, 4000] = true;\n\njulia> Mmap.sync!(B);\n\njulia> close(io);\n\njulia> io = open(\"mmap.bin\", \"r+\");\n\njulia> C = Mmap.mmap(io, BitArray, (25,30000));\n\njulia> C[3, 4000]\ntrue\n\njulia> C[2, 4000]\nfalse\n\njulia> close(io)\n\njulia> rm(\"mmap.bin\")\n\nThis creates a 25-by-30000 BitArray, linked to the file associated with stream io.\n\n\n\n\n\n","page":"Memory-mapped I/O"},{"title":"Mmap.sync!","location":"stdlib/Mmap.html#Mmap.sync!","category":"function","text":"Mmap.sync!(array)\n\nForces synchronization between the in-memory version of a memory-mapped Array or BitArray and the on-disk version.\n\n\n\n\n\n","page":"Memory-mapped I/O"},{"title":"Profiling","location":"stdlib/Profile.html#lib-profiling","category":"section","text":"","page":"Profiling"},{"title":"Profiling","location":"stdlib/Profile.html","category":"page","text":"Profile.@profile","page":"Profiling"},{"title":"Profile.@profile","location":"stdlib/Profile.html#Profile.@profile","category":"macro","text":"@profile\n\n@profile <expression> runs your expression while taking periodic backtraces. These are appended to an internal buffer of backtraces.\n\n\n\n\n\n","page":"Profiling"},{"title":"Profiling","location":"stdlib/Profile.html","category":"page","text":"The methods in Profile are not exported and need to be called e.g. as Profile.print().","page":"Profiling"},{"title":"Profiling","location":"stdlib/Profile.html","category":"page","text":"Profile.clear\nProfile.print\nProfile.init\nProfile.fetch\nProfile.retrieve\nProfile.callers\nProfile.clear_malloc_data","page":"Profiling"},{"title":"Profile.clear","location":"stdlib/Profile.html#Profile.clear","category":"function","text":"clear()\n\nClear any existing backtraces from the internal buffer.\n\n\n\n\n\n","page":"Profiling"},{"title":"Profile.print","location":"stdlib/Profile.html#Profile.print","category":"function","text":"print([io::IO = stdout,] [data::Vector]; kwargs...)\n\nPrints profiling results to io (by default, stdout). If you do not supply a data vector, the internal buffer of accumulated backtraces will be used.\n\nThe keyword arguments can be any combination of:\n\nformat – Determines whether backtraces are printed with (default, :tree) or without (:flat) indentation indicating tree structure.\nC – If true, backtraces from C and Fortran code are shown (normally they are excluded).\ncombine – If true (default), instruction pointers are merged that correspond to the same line of code.\nmaxdepth – Limits the depth higher than maxdepth in the :tree format.\nsortedby – Controls the order in :flat format. :filefuncline (default) sorts by the source  line, :count sorts in order of number of collected samples, and :overhead sorts by the number of samples  incurred by each function by itself.\nnoisefloor – Limits frames that exceed the heuristic noise floor of the sample (only applies to format :tree).  A suggested value to try for this is 2.0 (the default is 0). This parameter hides samples for which n <= noisefloor * √N,  where n is the number of samples on this line, and N is the number of samples for the callee.\nmincount – Limits the printout to only those lines with at least mincount occurrences.\nrecur – Controls the recursion handling in :tree format. :off (default) prints the tree as normal. :flat instead  compresses any recursion (by ip), showing the approximate effect of converting any self-recursion into an iterator.  :flatc does the same but also includes collapsing of C frames (may do odd things around jl_apply).\n\n\n\n\n\nprint([io::IO = stdout,] data::Vector, lidict::LineInfoDict; kwargs...)\n\nPrints profiling results to io. This variant is used to examine results exported by a previous call to retrieve. Supply the vector data of backtraces and a dictionary lidict of line information.\n\nSee Profile.print([io], data) for an explanation of the valid keyword arguments.\n\n\n\n\n\n","page":"Profiling"},{"title":"Profile.init","location":"stdlib/Profile.html#Profile.init","category":"function","text":"init(; n::Integer, delay::Real))\n\nConfigure the delay between backtraces (measured in seconds), and the number n of instruction pointers that may be stored. Each instruction pointer corresponds to a single line of code; backtraces generally consist of a long list of instruction pointers. Current settings can be obtained by calling this function with no arguments, and each can be set independently using keywords or in the order (n, delay).\n\n\n\n\n\n","page":"Profiling"},{"title":"Profile.fetch","location":"stdlib/Profile.html#Profile.fetch","category":"function","text":"fetch() -> data\n\nReturns a copy of the buffer of profile backtraces. Note that the values in data have meaning only on this machine in the current session, because it depends on the exact memory addresses used in JIT-compiling. This function is primarily for internal use; retrieve may be a better choice for most users.\n\n\n\n\n\n","page":"Profiling"},{"title":"Profile.retrieve","location":"stdlib/Profile.html#Profile.retrieve","category":"function","text":"retrieve() -> data, lidict\n\n\"Exports\" profiling results in a portable format, returning the set of all backtraces (data) and a dictionary that maps the (session-specific) instruction pointers in data to LineInfo values that store the file name, function name, and line number. This function allows you to save profiling results for future analysis.\n\n\n\n\n\n","page":"Profiling"},{"title":"Profile.callers","location":"stdlib/Profile.html#Profile.callers","category":"function","text":"callers(funcname, [data, lidict], [filename=<filename>], [linerange=<start:stop>]) -> Vector{Tuple{count, lineinfo}}\n\nGiven a previous profiling run, determine who called a particular function. Supplying the filename (and optionally, range of line numbers over which the function is defined) allows you to disambiguate an overloaded method. The returned value is a vector containing a count of the number of calls and line information about the caller. One can optionally supply backtrace data obtained from retrieve; otherwise, the current internal profile buffer is used.\n\n\n\n\n\n","page":"Profiling"},{"title":"Profile.clear_malloc_data","location":"stdlib/Profile.html#Profile.clear_malloc_data","category":"function","text":"clear_malloc_data()\n\nClears any stored memory allocation data when running julia with --track-allocation. Execute the command(s) you want to test (to force JIT-compilation), then call clear_malloc_data. Then execute your command(s) again, quit Julia, and examine the resulting *.mem files.\n\n\n\n\n\n","page":"Profiling"},{"title":"Delimited Files","location":"stdlib/DelimitedFiles.html#Delimited-Files","category":"section","text":"","page":"Delimited Files"},{"title":"Delimited Files","location":"stdlib/DelimitedFiles.html","category":"page","text":"DelimitedFiles.readdlm(::Any, ::AbstractChar, ::Type, ::AbstractChar)\nDelimitedFiles.readdlm(::Any, ::AbstractChar, ::AbstractChar)\nDelimitedFiles.readdlm(::Any, ::AbstractChar, ::Type)\nDelimitedFiles.readdlm(::Any, ::AbstractChar)\nDelimitedFiles.readdlm(::Any, ::Type)\nDelimitedFiles.readdlm(::Any)\nDelimitedFiles.writedlm","page":"Delimited Files"},{"title":"DelimitedFiles.readdlm","location":"stdlib/DelimitedFiles.html#DelimitedFiles.readdlm-Tuple{Any, AbstractChar, Type, AbstractChar}","category":"method","text":"readdlm(source, delim::AbstractChar, T::Type, eol::AbstractChar; header=false, skipstart=0, skipblanks=true, use_mmap, quotes=true, dims, comments=false, comment_char='#')\n\nRead a matrix from the source where each line (separated by eol) gives one row, with elements separated by the given delimiter. The source can be a text file, stream or byte array. Memory mapped files can be used by passing the byte array representation of the mapped segment as source.\n\nIf T is a numeric type, the result is an array of that type, with any non-numeric elements as NaN for floating-point types, or zero. Other useful values of T include String, AbstractString, and Any.\n\nIf header is true, the first row of data will be read as header and the tuple (data_cells, header_cells) is returned instead of only data_cells.\n\nSpecifying skipstart will ignore the corresponding number of initial lines from the input.\n\nIf skipblanks is true, blank lines in the input will be ignored.\n\nIf use_mmap is true, the file specified by source is memory mapped for potential speedups. Default is true except on Windows. On Windows, you may want to specify true if the file is large, and is only read once and not written to.\n\nIf quotes is true, columns enclosed within double-quote (\") characters are allowed to contain new lines and column delimiters. Double-quote characters within a quoted field must be escaped with another double-quote.  Specifying dims as a tuple of the expected rows and columns (including header, if any) may speed up reading of large files.  If comments is true, lines beginning with comment_char and text following comment_char in any line are ignored.\n\nExamples\n\njulia> using DelimitedFiles\n\njulia> x = [1; 2; 3; 4];\n\njulia> y = [5; 6; 7; 8];\n\njulia> open(\"delim_file.txt\", \"w\") do io\n           writedlm(io, [x y])\n       end\n\njulia> readdlm(\"delim_file.txt\", '\\t', Int, '\\n')\n4×2 Matrix{Int64}:\n 1  5\n 2  6\n 3  7\n 4  8\n\njulia> rm(\"delim_file.txt\")\n\n\n\n\n\n","page":"Delimited Files"},{"title":"DelimitedFiles.readdlm","location":"stdlib/DelimitedFiles.html#DelimitedFiles.readdlm-Tuple{Any, AbstractChar, AbstractChar}","category":"method","text":"readdlm(source, delim::AbstractChar, eol::AbstractChar; options...)\n\nIf all data is numeric, the result will be a numeric array. If some elements cannot be parsed as numbers, a heterogeneous array of numbers and strings is returned.\n\n\n\n\n\n","page":"Delimited Files"},{"title":"DelimitedFiles.readdlm","location":"stdlib/DelimitedFiles.html#DelimitedFiles.readdlm-Tuple{Any, AbstractChar, Type}","category":"method","text":"readdlm(source, delim::AbstractChar, T::Type; options...)\n\nThe end of line delimiter is taken as \\n.\n\nExamples\n\njulia> using DelimitedFiles\n\njulia> x = [1; 2; 3; 4];\n\njulia> y = [1.1; 2.2; 3.3; 4.4];\n\njulia> open(\"delim_file.txt\", \"w\") do io\n           writedlm(io, [x y], ',')\n       end;\n\njulia> readdlm(\"delim_file.txt\", ',', Float64)\n4×2 Matrix{Float64}:\n 1.0  1.1\n 2.0  2.2\n 3.0  3.3\n 4.0  4.4\n\njulia> rm(\"delim_file.txt\")\n\n\n\n\n\n","page":"Delimited Files"},{"title":"DelimitedFiles.readdlm","location":"stdlib/DelimitedFiles.html#DelimitedFiles.readdlm-Tuple{Any, AbstractChar}","category":"method","text":"readdlm(source, delim::AbstractChar; options...)\n\nThe end of line delimiter is taken as \\n. If all data is numeric, the result will be a numeric array. If some elements cannot be parsed as numbers, a heterogeneous array of numbers and strings is returned.\n\nExamples\n\njulia> using DelimitedFiles\n\njulia> x = [1; 2; 3; 4];\n\njulia> y = [1.1; 2.2; 3.3; 4.4];\n\njulia> open(\"delim_file.txt\", \"w\") do io\n           writedlm(io, [x y], ',')\n       end;\n\njulia> readdlm(\"delim_file.txt\", ',')\n4×2 Matrix{Float64}:\n 1.0  1.1\n 2.0  2.2\n 3.0  3.3\n 4.0  4.4\n\njulia> z = [\"a\"; \"b\"; \"c\"; \"d\"];\n\njulia> open(\"delim_file.txt\", \"w\") do io\n           writedlm(io, [x z], ',')\n       end;\n\njulia> readdlm(\"delim_file.txt\", ',')\n4×2 Matrix{Any}:\n 1  \"a\"\n 2  \"b\"\n 3  \"c\"\n 4  \"d\"\n\njulia> rm(\"delim_file.txt\")\n\n\n\n\n\n","page":"Delimited Files"},{"title":"DelimitedFiles.readdlm","location":"stdlib/DelimitedFiles.html#DelimitedFiles.readdlm-Tuple{Any, Type}","category":"method","text":"readdlm(source, T::Type; options...)\n\nThe columns are assumed to be separated by one or more whitespaces. The end of line delimiter is taken as \\n.\n\nExamples\n\njulia> using DelimitedFiles\n\njulia> x = [1; 2; 3; 4];\n\njulia> y = [5; 6; 7; 8];\n\njulia> open(\"delim_file.txt\", \"w\") do io\n           writedlm(io, [x y])\n       end;\n\njulia> readdlm(\"delim_file.txt\", Int64)\n4×2 Matrix{Int64}:\n 1  5\n 2  6\n 3  7\n 4  8\n\njulia> readdlm(\"delim_file.txt\", Float64)\n4×2 Matrix{Float64}:\n 1.0  5.0\n 2.0  6.0\n 3.0  7.0\n 4.0  8.0\n\njulia> rm(\"delim_file.txt\")\n\n\n\n\n\n","page":"Delimited Files"},{"title":"DelimitedFiles.readdlm","location":"stdlib/DelimitedFiles.html#DelimitedFiles.readdlm-Tuple{Any}","category":"method","text":"readdlm(source; options...)\n\nThe columns are assumed to be separated by one or more whitespaces. The end of line delimiter is taken as \\n. If all data is numeric, the result will be a numeric array. If some elements cannot be parsed as numbers, a heterogeneous array of numbers and strings is returned.\n\nExamples\n\njulia> using DelimitedFiles\n\njulia> x = [1; 2; 3; 4];\n\njulia> y = [\"a\"; \"b\"; \"c\"; \"d\"];\n\njulia> open(\"delim_file.txt\", \"w\") do io\n           writedlm(io, [x y])\n       end;\n\njulia> readdlm(\"delim_file.txt\")\n4×2 Matrix{Any}:\n 1  \"a\"\n 2  \"b\"\n 3  \"c\"\n 4  \"d\"\n\njulia> rm(\"delim_file.txt\")\n\n\n\n\n\n","page":"Delimited Files"},{"title":"DelimitedFiles.writedlm","location":"stdlib/DelimitedFiles.html#DelimitedFiles.writedlm","category":"function","text":"writedlm(f, A, delim='\\t'; opts)\n\nWrite A (a vector, matrix, or an iterable collection of iterable rows) as text to f (either a filename string or an IO stream) using the given delimiter delim (which defaults to tab, but can be any printable Julia object, typically a Char or AbstractString).\n\nFor example, two vectors x and y of the same length can be written as two columns of tab-delimited text to f by either writedlm(f, [x y]) or by writedlm(f, zip(x, y)).\n\nExamples\n\njulia> using DelimitedFiles\n\njulia> x = [1; 2; 3; 4];\n\njulia> y = [5; 6; 7; 8];\n\njulia> open(\"delim_file.txt\", \"w\") do io\n           writedlm(io, [x y])\n       end\n\njulia> readdlm(\"delim_file.txt\", '\\t', Int, '\\n')\n4×2 Matrix{Int64}:\n 1  5\n 2  6\n 3  7\n 4  8\n\njulia> rm(\"delim_file.txt\")\n\n\n\n\n\n","page":"Delimited Files"},{"title":"Working with LLVM","location":"devdocs/llvm.html#Working-with-LLVM","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"This is not a replacement for the LLVM documentation, but a collection of tips for working on LLVM for Julia.","page":"Working with LLVM"},{"title":"Overview of Julia to LLVM Interface","location":"devdocs/llvm.html#Overview-of-Julia-to-LLVM-Interface","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Julia dynamically links against LLVM by default. Build with USE_LLVM_SHLIB=0 to link statically.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The code for lowering Julia AST to LLVM IR or interpreting it directly is in directory src/.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"File Description\nbuiltins.c Builtin functions\nccall.cpp Lowering ccall\ncgutils.cpp Lowering utilities, notably for array and tuple accesses\ncodegen.cpp Top-level of code generation, pass list, lowering builtins\ndebuginfo.cpp Tracks debug information for JIT code\ndisasm.cpp Handles native object file and JIT code diassembly\ngf.c Generic functions\nintrinsics.cpp Lowering intrinsics\nllvm-simdloop.cpp Custom LLVM pass for @simd\nsys.c I/O and operating system utility functions","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Some of the .cpp files form a group that compile to a single object.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The difference between an intrinsic and a builtin is that a builtin is a first class function that can be used like any other Julia function.  An intrinsic can operate only on unboxed data, and therefore its arguments must be statically typed.","page":"Working with LLVM"},{"title":"Alias Analysis","location":"devdocs/llvm.html#Alias-Analysis","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Julia currently uses LLVM's Type Based Alias Analysis. To find the comments that document the inclusion relationships, look for static MDNode* in src/codegen.cpp.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The -O option enables LLVM's Basic Alias Analysis.","page":"Working with LLVM"},{"title":"Building Julia with a different version of LLVM","location":"devdocs/llvm.html#Building-Julia-with-a-different-version-of-LLVM","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The default version of LLVM is specified in deps/Versions.make. You can override it by creating a file called Make.user in the top-level directory and adding a line to it such as:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"LLVM_VER = 6.0.1","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Besides the LLVM release numerals, you can also use LLVM_VER = svn to build against the latest development version of LLVM.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"You can also specify to build a debug version of LLVM, by setting either LLVM_DEBUG = 1 or LLVM_DEBUG = Release in your Make.user file. The former will be a fully unoptimized build of LLVM and the latter will produce an optimized build of LLVM. Depending on your needs the latter will suffice and it quite a bit faster. If you use LLVM_DEBUG = Release you will also want to set LLVM_ASSERTIONS = 1 to enable diagnostics for different passes. Only LLVM_DEBUG = 1 implies that option by default.","page":"Working with LLVM"},{"title":"Passing options to LLVM","location":"devdocs/llvm.html#Passing-options-to-LLVM","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"You can pass options to LLVM via the environment variable JULIA_LLVM_ARGS. Here are example settings using bash syntax:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"export JULIA_LLVM_ARGS=-print-after-all dumps IR after each pass.\nexport JULIA_LLVM_ARGS=-debug-only=loop-vectorize dumps LLVM DEBUG(...) diagnostics for loop vectorizer. If you get warnings about \"Unknown command line argument\", rebuild LLVM with LLVM_ASSERTIONS = 1.","page":"Working with LLVM"},{"title":"Debugging LLVM transformations in isolation","location":"devdocs/llvm.html#Debugging-LLVM-transformations-in-isolation","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"On occasion, it can be useful to debug LLVM's transformations in isolation from the rest of the Julia system, e.g. because reproducing the issue inside julia would take too long, or because one wants to take advantage of LLVM's tooling (e.g. bugpoint). To get unoptimized IR for the entire system image, pass the --output-unopt-bc unopt.bc option to the system image build process, which will output the unoptimized IR to an unopt.bc file. This file can then be passed to LLVM tools as usual. libjulia can function as an LLVM pass plugin and can be loaded into LLVM tools, to make julia-specific passes available in this environment. In addition, it exposes the -julia meta-pass, which runs the entire Julia pass-pipeline over the IR. As an example, to generate a system image, one could do:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"opt -load libjulia-internal.so -julia -o opt.bc unopt.bc\nllc -o sys.o opt.bc\ncc -shared -o sys.so sys.o","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"This system image can then be loaded by julia as usual.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Alternatively, you can use --output-jit-bc jit.bc to obtain a trace of all IR passed to the JIT. This is useful for code that cannot be run as part of the sysimg generation process (e.g. because it creates unserializable state). However, the resulting jit.bc does not include sysimage data, and can thus not be used as such.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"It is also possible to dump an LLVM IR module for just one Julia function, using:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"fun, T = +, Tuple{Int,Int} # Substitute your function of interest here\noptimize = false\nopen(\"plus.ll\", \"w\") do file\n    println(file, InteractiveUtils._dump_function(fun, T, false, false, false, true, :att, optimize, :default))\nend","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"These files can be processed the same way as the unoptimized sysimg IR shown above.","page":"Working with LLVM"},{"title":"Improving LLVM optimizations for Julia","location":"devdocs/llvm.html#Improving-LLVM-optimizations-for-Julia","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Improving LLVM code generation usually involves either changing Julia lowering to be more friendly to LLVM's passes, or improving a pass.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"If you are planning to improve a pass, be sure to read the LLVM developer policy. The best strategy is to create a code example in a form where you can use LLVM's opt tool to study it and the pass of interest in isolation.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Create an example Julia code of interest.\nUse JULIA_LLVM_ARGS=-print-after-all to dump the IR.\nPick out the IR at the point just before the pass of interest runs.\nStrip the debug metadata and fix up the TBAA metadata by hand.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The last step is labor intensive.  Suggestions on a better way would be appreciated.","page":"Working with LLVM"},{"title":"The jlcall calling convention","location":"devdocs/llvm.html#The-jlcall-calling-convention","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Julia has a generic calling convention for unoptimized code, which looks somewhat as follows:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"jl_value_t *any_unoptimized_call(jl_value_t *, jl_value_t **, int);","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"where the first argument is the boxed function object, the second argument is an on-stack array of arguments and the third is the number of arguments. Now, we could perform a straightforward lowering and emit an alloca for the argument array. However, this would betray the SSA nature of the uses at the call site, making optimizations (including GC root placement), significantly harder. Instead, we emit it as follows:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"%bitcast = bitcast @any_unoptimized_call to %jl_value_t *(*)(%jl_value_t *, %jl_value_t *)\ncall cc 37 %jl_value_t *%bitcast(%jl_value_t *%arg1, %jl_value_t *%arg2)","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The special cc 37 annotation marks the fact that this call site is really using the jlcall calling convention. This allows us to retain the SSA-ness of the uses throughout the optimizer. GC root placement will later lower this call to the original C ABI. In the code the calling convention number is represented by the JLCALL_F_CC constant. In addition, there is the JLCALL_CC calling convention which functions similarly, but omits the first argument.","page":"Working with LLVM"},{"title":"GC root placement","location":"devdocs/llvm.html#GC-root-placement","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"GC root placement is done by an LLVM pass late in the pass pipeline. Doing GC root placement this late enables LLVM to make more aggressive optimizations around code that requires GC roots, as well as allowing us to reduce the number of required GC roots and GC root store operations (since LLVM doesn't understand our GC, it wouldn't otherwise know what it is and is not allowed to do with values stored to the GC frame, so it'll conservatively do very little). As an example, consider an error path","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"if some_condition()\n    #= Use some variables maybe =#\n    error(\"An error occurred\")\nend","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"During constant folding, LLVM may discover that the condition is always false, and can remove the basic block. However, if GC root lowering is done early, the GC root slots used in the deleted block, as well as any values kept alive in those slots only because they were used in the error path, would be kept alive by LLVM. By doing GC root lowering late, we give LLVM the license to do any of its usual optimizations (constant folding, dead code elimination, etc.), without having to worry (too much) about which values may or may not be GC tracked.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"However, in order to be able to do late GC root placement, we need to be able to identify a) which pointers are GC tracked and b) all uses of such pointers. The goal of the GC placement pass is thus simple:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Minimize the number of needed GC roots/stores to them subject to the constraint that at every safepoint, any live GC-tracked pointer (i.e. for which there is a path after this point that contains a use of this pointer) is in some GC slot.","page":"Working with LLVM"},{"title":"Representation","location":"devdocs/llvm.html#Representation","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The primary difficulty is thus choosing an IR representation that allows us to identify GC-tracked pointers and their uses, even after the program has been run through the optimizer. Our design makes use of three LLVM features to achieve this:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Custom address spaces\nOperand Bundles\nNon-integral pointers","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Custom address spaces allow us to tag every point with an integer that needs to be preserved through optimizations. The compiler may not insert casts between address spaces that did not exist in the original program and it must never change the address space of a pointer on a load/store/etc operation. This allows us to annotate which pointers are GC-tracked in an optimizer-resistant way. Note that metadata would not be able to achieve the same purpose. Metadata is supposed to always be discardable without altering the semantics of the program. However, failing to identify a GC-tracked pointer alters the resulting program behavior dramatically - it'll probably crash or return wrong results. We currently use three different address spaces (their numbers are defined in src/codegen_shared.cpp):","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"GC Tracked Pointers (currently 10): These are pointers to boxed values that may be put into a GC frame. It is loosely equivalent to a jl_value_t* pointer on the C side. N.B. It is illegal to ever have a pointer in this address space that may not be stored to a GC slot.\nDerived Pointers (currently 11): These are pointers that are derived from some GC tracked pointer. Uses of these pointers generate uses of the original pointer. However, they need not themselves be known to the GC. The GC root placement pass MUST always find the GC tracked pointer from which this pointer is derived and use that as the pointer to root.\nCallee Rooted Pointers (currently 12): This is a utility address space to express the notion of a callee rooted value. All values of this address space MUST be storable to a GC root (though it is possible to relax this condition in the future), but unlike the other pointers need not be rooted if passed to a call (they do still need to be rooted if they are live across another safepoint between the definition and the call).\nPointers loaded from tracked object (currently 13): This is used by arrays, which themselves contain a pointer to the managed data. This data area is owned by the array, but is not a GC-tracked object by itself. The compiler guarantees that as long as this pointer is live, the object that this pointer was loaded from will keep being live.","page":"Working with LLVM"},{"title":"Invariants","location":"devdocs/llvm.html#Invariants","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The GC root placement pass makes use of several invariants, which need to be observed by the frontend and are preserved by the optimizer.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"First, only the following address space casts are allowed:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"0->{Tracked,Derived,CalleeRooted}: It is allowable to decay an untracked pointer to any of the others. However, do note that the optimizer has broad license to not root such a value. It is never safe to have a value in address space 0 in any part of the program if it is (or is derived from) a value that requires a GC root.\nTracked->Derived: This is the standard decay route for interior values. The placement pass will look for these to identify the base pointer for any use.\nTracked->CalleeRooted: Addrspace CalleeRooted serves merely as a hint that a GC root is not required. However, do note that the Derived->CalleeRooted decay is prohibited, since pointers should generally be storable to a GC slot, even in this address space.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Now let us consider what constitutes a use:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Loads whose loaded values is in one of the address spaces\nStores of a value in one of the address spaces to a location\nStores to a pointer in one of the address spaces\nCalls for which a value in one of the address spaces is an operand\nCalls in jlcall ABI, for which the argument array contains a value\nReturn instructions.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"We explicitly allow load/stores and simple calls in address spaces Tracked/Derived. Elements of jlcall argument arrays must always be in address space Tracked (it is required by the ABI that they are valid jl_value_t* pointers). The same is true for return instructions (though note that struct return arguments are allowed to have any of the address spaces). The only allowable use of an address space CalleeRooted pointer is to pass it to a call (which must have an appropriately typed operand).","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Further, we disallow getelementptr in addrspace Tracked. This is because unless the operation is a noop, the resulting pointer will not be validly storable to a GC slot and may thus not be in this address space. If such a pointer is required, it should be decayed to addrspace Derived first.","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"Lastly, we disallow inttoptr/ptrtoint instructions in these address spaces. Having these instructions would mean that some i64 values are really GC tracked. This is problematic, because it breaks that stated requirement that we're able to identify GC-relevant pointers. This invariant is accomplished using the LLVM \"non-integral pointers\" feature, which is new in LLVM 5.0. It prohibits the optimizer from making optimizations that would introduce these operations. Note we can still insert static constants at JIT time by using inttoptr in address space 0 and then decaying to the appropriate address space afterwards.","page":"Working with LLVM"},{"title":"Supporting ccall","location":"devdocs/llvm.html#Supporting-[ccall](@ref)","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"One important aspect missing from the discussion so far is the handling of ccall. ccall has the peculiar feature that the location and scope of a use do not coincide. As an example consider:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"A = randn(1024)\nccall(:foo, Cvoid, (Ptr{Float64},), A)","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"In lowering, the compiler will insert a conversion from the array to the pointer which drops the reference to the array value. However, we of course need to make sure that the array does stay alive while we're doing the ccall. To understand how this is done, first recall the lowering of the above code:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"return $(Expr(:foreigncall, :(:foo), Cvoid, svec(Ptr{Float64}), 0, :(:ccall), Expr(:foreigncall, :(:jl_array_ptr), Ptr{Float64}, svec(Any), 0, :(:ccall), :(A)), :(A)))","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The last :(A), is an extra argument list inserted during lowering that informs the code generator which Julia level values need to be kept alive for the duration of this ccall. We then take this information and represent it in an \"operand bundle\" at the IR level. An operand bundle is essentially a fake use that is attached to the call site. At the IR level, this looks like so:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"call void inttoptr (i64 ... to void (double*)*)(double* %5) [ \"jl_roots\"(%jl_value_t addrspace(10)* %A) ]","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"The GC root placement pass will treat the jl_roots operand bundle as if it were a regular operand. However, as a final step, after the GC roots are inserted, it will drop the operand bundle to avoid confusing instruction selection.","page":"Working with LLVM"},{"title":"Supporting pointer_from_objref","location":"devdocs/llvm.html#Supporting-[pointer_from_objref](@ref)","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"pointer_from_objref is special because it requires the user to take explicit control of GC rooting. By our above invariants, this function is illegal, because it performs an address space cast from 10 to 0. However, it can be useful, in certain situations, so we provide a special intrinsic:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"declared %jl_value_t *julia.pointer_from_objref(%jl_value_t addrspace(10)*)","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"which is lowered to the corresponding address space cast after GC root lowering. Do note however that by using this intrinsic, the caller assumes all responsibility for making sure that the value in question is rooted. Further this intrinsic is not considered a use, so the GC root placement pass will not provide a GC root for the function. As a result, the external rooting must be arranged while the value is still tracked by the system. I.e. it is not valid to attempt to use the result of this operation to establish a global root - the optimizer may have already dropped the value.","page":"Working with LLVM"},{"title":"Keeping values alive in the absence of uses","location":"devdocs/llvm.html#Keeping-values-alive-in-the-absence-of-uses","category":"section","text":"","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"In certain cases it is necessary to keep an object alive, even though there is no compiler-visible use of said object. This may be case for low level code that operates on the memory-representation of an object directly or code that needs to interface with C code. In order to allow this, we provide the following intrinsics at the LLVM level:","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"token @llvm.julia.gc_preserve_begin(...)\nvoid @llvm.julia.gc_preserve_end(token)","page":"Working with LLVM"},{"title":"Working with LLVM","location":"devdocs/llvm.html","category":"page","text":"(The llvm. in the name is required in order to be able to use the token type). The semantics of these intrinsics are as follows: At any safepoint that is dominated by a gc_preserve_begin call, but that is not not dominated by a corresponding gc_preserve_end call (i.e. a call whose argument is the token returned by a gc_preserve_begin call), the values passed as arguments to that gc_preserve_begin will be kept live. Note that the gc_preserve_begin still counts as a regular use of those values, so the standard lifetime semantics will ensure that the values will be kept alive before entering the preserve region.","page":"Working with LLVM"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html#Multi-processing-and-Distributed-Computing","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"An implementation of distributed memory parallel computing is provided by module Distributed as part of the standard library shipped with Julia.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Most modern computers possess more than one CPU, and several computers can be combined together in a cluster. Harnessing the power of these multiple CPUs allows many computations to be completed more quickly. There are two major factors that influence performance: the speed of the CPUs themselves, and the speed of their access to memory. In a cluster, it's fairly obvious that a given CPU will have fastest access to the RAM within the same computer (node). Perhaps more surprisingly, similar issues are relevant on a typical multicore laptop, due to differences in the speed of main memory and the cache. Consequently, a good multiprocessing environment should allow control over the \"ownership\" of a chunk of memory by a particular CPU. Julia provides a multiprocessing environment based on message passing to allow programs to run on multiple processes in separate memory domains at once.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Julia's implementation of message passing is different from other environments such as MPI[1]. Communication in Julia is generally \"one-sided\", meaning that the programmer needs to explicitly manage only one process in a two-process operation. Furthermore, these operations typically do not look like \"message send\" and \"message receive\" but rather resemble higher-level operations like calls to user functions.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Distributed programming in Julia is built on two primitives: remote references and remote calls. A remote reference is an object that can be used from any process to refer to an object stored on a particular process. A remote call is a request by one process to call a certain function on certain arguments on another (possibly the same) process.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Remote references come in two flavors: Future and RemoteChannel.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"A remote call returns a Future to its result. Remote calls return immediately; the process that made the call proceeds to its next operation while the remote call happens somewhere else. You can wait for a remote call to finish by calling wait on the returned Future, and you can obtain the full value of the result using fetch.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"On the other hand, RemoteChannel s are rewritable. For example, multiple processes can co-ordinate their processing by referencing the same remote Channel.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Each process has an associated identifier. The process providing the interactive Julia prompt always has an id equal to 1. The processes used by default for parallel operations are referred to as \"workers\". When there is only one process, process 1 is considered a worker. Otherwise, workers are considered to be all processes other than process 1. As a result, adding 2 or more processes is required to gain benefits from parallel processing methods like pmap. Adding a single process is beneficial if you just wish to do other things in the main process while a long computation is running on the worker.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Let's try this out. Starting with julia -p n provides n worker processes on the local machine. Generally it makes sense for n to equal the number of CPU threads (logical cores) on the machine. Note that the -p argument implicitly loads module Distributed.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"$ ./julia -p 2\n\njulia> r = remotecall(rand, 2, 2, 2)\nFuture(2, 1, 4, nothing)\n\njulia> s = @spawnat 2 1 .+ fetch(r)\nFuture(2, 1, 5, nothing)\n\njulia> fetch(s)\n2×2 Array{Float64,2}:\n 1.18526  1.50912\n 1.16296  1.60607","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The first argument to remotecall is the function to call. Most parallel programming in Julia does not reference specific processes or the number of processes available, but remotecall is considered a low-level interface providing finer control. The second argument to remotecall is the id of the process that will do the work, and the remaining arguments will be passed to the function being called.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"As you can see, in the first line we asked process 2 to construct a 2-by-2 random matrix, and in the second line we asked it to add 1 to it. The result of both calculations is available in the two futures, r and s. The @spawnat macro evaluates the expression in the second argument on the process specified by the first argument.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Occasionally you might want a remotely-computed value immediately. This typically happens when you read from a remote object to obtain data needed by the next local operation. The function remotecall_fetch exists for this purpose. It is equivalent to fetch(remotecall(...)) but is more efficient.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> remotecall_fetch(getindex, 2, r, 1, 1)\n0.18526337335308085","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Remember that getindex(r,1,1) is equivalent to r[1,1], so this call fetches the first element of the future r.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"To make things easier, the symbol :any can be passed to @spawnat, which picks where to do the operation for you:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> r = @spawnat :any rand(2,2)\nFuture(2, 1, 4, nothing)\n\njulia> s = @spawnat :any 1 .+ fetch(r)\nFuture(3, 1, 5, nothing)\n\njulia> fetch(s)\n2×2 Array{Float64,2}:\n 1.38854  1.9098\n 1.20939  1.57158","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Note that we used 1 .+ fetch(r) instead of 1 .+ r. This is because we do not know where the code will run, so in general a fetch might be required to move r to the process doing the addition. In this case, @spawnat is smart enough to perform the computation on the process that owns r, so the fetch will be a no-op (no work is done).","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"(It is worth noting that @spawnat is not built-in but defined in Julia as a macro. It is possible to define your own such constructs.)","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"An important thing to remember is that, once fetched, a Future will cache its value locally. Further fetch calls do not entail a network hop. Once all referencing Futures have fetched, the remote stored value is deleted.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"@async is similar to @spawnat, but only runs tasks on the local process. We use it to create a \"feeder\" task for each process. Each task picks the next index that needs to be computed, then waits for its process to finish, then repeats until we run out of indices. Note that the feeder tasks do not begin to execute until the main task reaches the end of the @sync block, at which point it surrenders control and waits for all the local tasks to complete before returning from the function. As for v0.7 and beyond, the feeder tasks are able to share state via nextidx because they all run on the same process. Even if Tasks are scheduled cooperatively, locking may still be required in some contexts, as in asynchronous I/O. This means context switches only occur at well-defined points: in this case, when remotecall_fetch is called. This is the current state of implementation and it may change for future Julia versions, as it is intended to make it possible to run up to N Tasks on M Process, aka M:N Threading. Then a lock acquiring\\releasing model for nextidx will be needed, as it is not safe to let multiple processes read-write a resource at the same time.","page":"Multi-processing and Distributed Computing"},{"title":"Code Availability and Loading Packages","location":"manual/distributed-computing.html#code-availability","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Your code must be available on any process that runs it. For example, type the following into the Julia prompt:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> function rand2(dims...)\n           return 2*rand(dims...)\n       end\n\njulia> rand2(2,2)\n2×2 Array{Float64,2}:\n 0.153756  0.368514\n 1.15119   0.918912\n\njulia> fetch(@spawnat :any rand2(2,2))\nERROR: RemoteException(2, CapturedException(UndefVarError(Symbol(\"#rand2\"))\nStacktrace:\n[...]","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Process 1 knew about the function rand2, but process 2 did not.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Most commonly you'll be loading code from files or packages, and you have a considerable amount of flexibility in controlling which processes load code. Consider a file, DummyModule.jl, containing the following code:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"module DummyModule\n\nexport MyType, f\n\nmutable struct MyType\n    a::Int\nend\n\nf(x) = x^2+1\n\nprintln(\"loaded\")\n\nend","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"In order to refer to MyType across all processes, DummyModule.jl needs to be loaded on every process.  Calling include(\"DummyModule.jl\") loads it only on a single process.  To load it on every process, use the @everywhere macro (starting Julia with julia -p 2):","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> @everywhere include(\"DummyModule.jl\")\nloaded\n      From worker 3:    loaded\n      From worker 2:    loaded","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"As usual, this does not bring DummyModule into scope on any of the process, which requires using or import.  Moreover, when DummyModule is brought into scope on one process, it is not on any other:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> using .DummyModule\n\njulia> MyType(7)\nMyType(7)\n\njulia> fetch(@spawnat 2 MyType(7))\nERROR: On worker 2:\nUndefVarError: MyType not defined\n⋮\n\njulia> fetch(@spawnat 2 DummyModule.MyType(7))\nMyType(7)","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"However, it's still possible, for instance, to send a MyType to a process which has loaded DummyModule even if it's not in scope:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> put!(RemoteChannel(2), MyType(7))\nRemoteChannel{Channel{Any}}(2, 1, 13)","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"A file can also be preloaded on multiple processes at startup with the -L flag, and a driver script can be used to drive the computation:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia -p <n> -L file1.jl -L file2.jl driver.jl","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The Julia process running the driver script in the example above has an id equal to 1, just like a process providing an interactive prompt.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Finally, if DummyModule.jl is not a standalone file but a package, then using DummyModule will load DummyModule.jl on all processes, but only bring it into scope on the process where using was called.","page":"Multi-processing and Distributed Computing"},{"title":"Starting and managing worker processes","location":"manual/distributed-computing.html#Starting-and-managing-worker-processes","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The base Julia installation has in-built support for two types of clusters:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"A local cluster specified with the -p option as shown above.\nA cluster spanning machines using the --machine-file option. This uses a passwordless ssh login to start Julia worker processes (from the same path as the current host) on the specified machines. Each machine definition takes the form [count*][user@]host[:port] [bind_addr[:port]]. user defaults to current user, port to the standard ssh port. count is the number of workers to spawn on the node, and defaults to 1. The optional bind-to bind_addr[:port] specifies the IP address and port that other workers should use to connect to this worker.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Functions addprocs, rmprocs, workers, and others are available as a programmatic means of adding, removing and querying the processes in a cluster.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> using Distributed\n\njulia> addprocs(2)\n2-element Array{Int64,1}:\n 2\n 3","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Module Distributed must be explicitly loaded on the master process before invoking addprocs. It is automatically made available on the worker processes.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Note that workers do not run a ~/.julia/config/startup.jl startup script, nor do they synchronize their global state (such as global variables, new method definitions, and loaded modules) with any of the other running processes. You may use addprocs(exeflags=\"--project\") to initialize a worker with a particular environment, and then @everywhere using <modulename> or @everywhere include(\"file.jl\").","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Other types of clusters can be supported by writing your own custom ClusterManager, as described below in the ClusterManagers section.","page":"Multi-processing and Distributed Computing"},{"title":"Data Movement","location":"manual/distributed-computing.html#Data-Movement","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Sending messages and moving data constitute most of the overhead in a distributed program. Reducing the number of messages and the amount of data sent is critical to achieving performance and scalability. To this end, it is important to understand the data movement performed by Julia's various distributed programming constructs.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"fetch can be considered an explicit data movement operation, since it directly asks that an object be moved to the local machine. @spawnat (and a few related constructs) also moves data, but this is not as obvious, hence it can be called an implicit data movement operation. Consider these two approaches to constructing and squaring a random matrix:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Method 1:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> A = rand(1000,1000);\n\njulia> Bref = @spawnat :any A^2;\n\n[...]\n\njulia> fetch(Bref);","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Method 2:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> Bref = @spawnat :any rand(1000,1000)^2;\n\n[...]\n\njulia> fetch(Bref);","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The difference seems trivial, but in fact is quite significant due to the behavior of @spawnat. In the first method, a random matrix is constructed locally, then sent to another process where it is squared. In the second method, a random matrix is both constructed and squared on another process. Therefore the second method sends much less data than the first.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"In this toy example, the two methods are easy to distinguish and choose from. However, in a real program designing data movement might require more thought and likely some measurement. For example, if the first process needs matrix A then the first method might be better. Or, if computing A is expensive and only the current process has it, then moving it to another process might be unavoidable. Or, if the current process has very little to do between the @spawnat and fetch(Bref), it might be better to eliminate the parallelism altogether. Or imagine rand(1000,1000) is replaced with a more expensive operation. Then it might make sense to add another @spawnat statement just for this step.","page":"Multi-processing and Distributed Computing"},{"title":"Global variables","location":"manual/distributed-computing.html#Global-variables","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Expressions executed remotely via @spawnat, or closures specified for remote execution using remotecall may refer to global variables. Global bindings under module Main are treated a little differently compared to global bindings in other modules. Consider the following code snippet:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"A = rand(10,10)\nremotecall_fetch(()->sum(A), 2)","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"In this case sum MUST be defined in the remote process. Note that A is a global variable defined in the local workspace. Worker 2 does not have a variable called A under Main. The act of shipping the closure ()->sum(A) to worker 2 results in Main.A being defined on 2. Main.A continues to exist on worker 2 even after the call remotecall_fetch returns. Remote calls with embedded global references (under Main module only) manage globals as follows:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"New global bindings are created on destination workers if they are referenced as part of a remote call.\nGlobal constants are declared as constants on remote nodes too.\nGlobals are re-sent to a destination worker only in the context of a remote call, and then only if its value has changed. Also, the cluster does not synchronize global bindings across nodes. For example:\nA = rand(10,10)\nremotecall_fetch(()->sum(A), 2) # worker 2\nA = rand(10,10)\nremotecall_fetch(()->sum(A), 3) # worker 3\nA = nothing\nExecuting the above snippet results in Main.A on worker 2 having a different value from Main.A on worker 3, while the value of Main.A on node 1 is set to nothing.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"As you may have realized, while memory associated with globals may be collected when they are reassigned on the master, no such action is taken on the workers as the bindings continue to be valid. clear! can be used to manually reassign specific globals on remote nodes to nothing once they are no longer required. This will release any memory associated with them as part of a regular garbage collection cycle.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Thus programs should be careful referencing globals in remote calls. In fact, it is preferable to avoid them altogether if possible. If you must reference globals, consider using let blocks to localize global variables.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"For example:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> A = rand(10,10);\n\njulia> remotecall_fetch(()->A, 2);\n\njulia> B = rand(10,10);\n\njulia> let B = B\n           remotecall_fetch(()->B, 2)\n       end;\n\njulia> @fetchfrom 2 InteractiveUtils.varinfo()\nname           size summary\n––––––––– ––––––––– ––––––––––––––––––––––\nA         800 bytes 10×10 Array{Float64,2}\nBase                Module\nCore                Module\nMain                Module","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"As can be seen, global variable A is defined on worker 2, but B is captured as a local variable and hence a binding for B does not exist on worker 2.","page":"Multi-processing and Distributed Computing"},{"title":"Parallel Map and Loops","location":"manual/distributed-computing.html#Parallel-Map-and-Loops","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Fortunately, many useful parallel computations do not require data movement. A common example is a Monte Carlo simulation, where multiple processes can handle independent simulation trials simultaneously. We can use @spawnat to flip coins on two processes. First, write the following function in count_heads.jl:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"function count_heads(n)\n    c::Int = 0\n    for i = 1:n\n        c += rand(Bool)\n    end\n    c\nend","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The function count_heads simply adds together n random bits. Here is how we can perform some trials on two machines, and add together the results:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> @everywhere include_string(Main, $(read(\"count_heads.jl\", String)), \"count_heads.jl\")\n\njulia> a = @spawnat :any count_heads(100000000)\nFuture(2, 1, 6, nothing)\n\njulia> b = @spawnat :any count_heads(100000000)\nFuture(3, 1, 7, nothing)\n\njulia> fetch(a)+fetch(b)\n100001564","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"This example demonstrates a powerful and often-used parallel programming pattern. Many iterations run independently over several processes, and then their results are combined using some function. The combination process is called a reduction, since it is generally tensor-rank-reducing: a vector of numbers is reduced to a single number, or a matrix is reduced to a single row or column, etc. In code, this typically looks like the pattern x = f(x,v[i]), where x is the accumulator, f is the reduction function, and the v[i] are the elements being reduced. It is desirable for f to be associative, so that it does not matter what order the operations are performed in.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Notice that our use of this pattern with count_heads can be generalized. We used two explicit @spawnat statements, which limits the parallelism to two processes. To run on any number of processes, we can use a parallel for loop, running in distributed memory, which can be written in Julia using @distributed like this:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"nheads = @distributed (+) for i = 1:200000000\n    Int(rand(Bool))\nend","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"This construct implements the pattern of assigning iterations to multiple processes, and combining them with a specified reduction (in this case (+)). The result of each iteration is taken as the value of the last expression inside the loop. The whole parallel loop expression itself evaluates to the final answer.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Note that although parallel for loops look like serial for loops, their behavior is dramatically different. In particular, the iterations do not happen in a specified order, and writes to variables or arrays will not be globally visible since iterations run on different processes. Any variables used inside the parallel loop will be copied and broadcast to each process.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"For example, the following code will not work as intended:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"a = zeros(100000)\n@distributed for i = 1:100000\n    a[i] = i\nend","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"This code will not initialize all of a, since each process will have a separate copy of it. Parallel for loops like these must be avoided. Fortunately, Shared Arrays can be used to get around this limitation:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"using SharedArrays\n\na = SharedArray{Float64}(10)\n@distributed for i = 1:10\n    a[i] = i\nend","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Using \"outside\" variables in parallel loops is perfectly reasonable if the variables are read-only:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"a = randn(1000)\n@distributed (+) for i = 1:100000\n    f(a[rand(1:end)])\nend","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Here each iteration applies f to a randomly-chosen sample from a vector a shared by all processes.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"As you could see, the reduction operator can be omitted if it is not needed. In that case, the loop executes asynchronously, i.e. it spawns independent tasks on all available workers and returns an array of Future immediately without waiting for completion. The caller can wait for the Future completions at a later point by calling fetch on them, or wait for completion at the end of the loop by prefixing it with @sync, like @sync @distributed for.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"In some cases no reduction operator is needed, and we merely wish to apply a function to all integers in some range (or, more generally, to all elements in some collection). This is another useful operation called parallel map, implemented in Julia as the pmap function. For example, we could compute the singular values of several large random matrices in parallel as follows:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> M = Matrix{Float64}[rand(1000,1000) for i = 1:10];\n\njulia> pmap(svdvals, M);","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Julia's pmap is designed for the case where each function call does a large amount of work. In contrast, @distributed for can handle situations where each iteration is tiny, perhaps merely summing two numbers. Only worker processes are used by both pmap and @distributed for for the parallel computation. In case of @distributed for, the final reduction is done on the calling process.","page":"Multi-processing and Distributed Computing"},{"title":"Remote References and AbstractChannels","location":"manual/distributed-computing.html#Remote-References-and-AbstractChannels","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Remote references always refer to an implementation of an AbstractChannel.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"A concrete implementation of an AbstractChannel (like Channel), is required to implement put!, take!, fetch, isready and wait. The remote object referred to by a Future is stored in a Channel{Any}(1), i.e., a Channel of size 1 capable of holding objects of Any type.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"RemoteChannel, which is rewritable, can point to any type and size of channels, or any other implementation of an AbstractChannel.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The constructor RemoteChannel(f::Function, pid)() allows us to construct references to channels holding more than one value of a specific type. f is a function executed on pid and it must return an AbstractChannel.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"For example, RemoteChannel(()->Channel{Int}(10), pid), will return a reference to a channel of type Int and size 10. The channel exists on worker pid.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Methods put!, take!, fetch, isready and wait on a RemoteChannel are proxied onto the backing store on the remote process.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"RemoteChannel can thus be used to refer to user implemented AbstractChannel objects. A simple example of this is provided in dictchannel.jl in the Examples repository, which uses a dictionary as its remote store.","page":"Multi-processing and Distributed Computing"},{"title":"Channels and RemoteChannels","location":"manual/distributed-computing.html#Channels-and-RemoteChannels","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"A Channel is local to a process. Worker 2 cannot directly refer to a Channel on worker 3 and vice-versa. A RemoteChannel, however, can put and take values across workers.\nA RemoteChannel can be thought of as a handle to a Channel.\nThe process id, pid, associated with a RemoteChannel identifies the process where the backing store, i.e., the backing Channel exists.\nAny process with a reference to a RemoteChannel can put and take items from the channel. Data is automatically sent to (or retrieved from) the process a RemoteChannel is associated with.\nSerializing  a Channel also serializes any data present in the channel. Deserializing it therefore effectively makes a copy of the original object.\nOn the other hand, serializing a RemoteChannel only involves the serialization of an identifier that identifies the location and instance of Channel referred to by the handle. A deserialized RemoteChannel object (on any worker), therefore also points to the same backing store as the original.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The channels example from above can be modified for interprocess communication, as shown below.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"We start 4 workers to process a single jobs remote channel. Jobs, identified by an id (job_id), are written to the channel. Each remotely executing task in this simulation reads a job_id, waits for a random amount of time and writes back a tuple of job_id, time taken and its own pid to the results channel. Finally all the results are printed out on the master process.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> addprocs(4); # add worker processes\n\njulia> const jobs = RemoteChannel(()->Channel{Int}(32));\n\njulia> const results = RemoteChannel(()->Channel{Tuple}(32));\n\njulia> @everywhere function do_work(jobs, results) # define work function everywhere\n           while true\n               job_id = take!(jobs)\n               exec_time = rand()\n               sleep(exec_time) # simulates elapsed time doing actual work\n               put!(results, (job_id, exec_time, myid()))\n           end\n       end\n\njulia> function make_jobs(n)\n           for i in 1:n\n               put!(jobs, i)\n           end\n       end;\n\njulia> n = 12;\n\njulia> @async make_jobs(n); # feed the jobs channel with \"n\" jobs\n\njulia> for p in workers() # start tasks on the workers to process requests in parallel\n           remote_do(do_work, p, jobs, results)\n       end\n\njulia> @elapsed while n > 0 # print out results\n           job_id, exec_time, where = take!(results)\n           println(\"$job_id finished in $(round(exec_time; digits=2)) seconds on worker $where\")\n           global n = n - 1\n       end\n1 finished in 0.18 seconds on worker 4\n2 finished in 0.26 seconds on worker 5\n6 finished in 0.12 seconds on worker 4\n7 finished in 0.18 seconds on worker 4\n5 finished in 0.35 seconds on worker 5\n4 finished in 0.68 seconds on worker 2\n3 finished in 0.73 seconds on worker 3\n11 finished in 0.01 seconds on worker 3\n12 finished in 0.02 seconds on worker 3\n9 finished in 0.26 seconds on worker 5\n8 finished in 0.57 seconds on worker 4\n10 finished in 0.58 seconds on worker 2\n0.055971741","page":"Multi-processing and Distributed Computing"},{"title":"Remote References and Distributed Garbage Collection","location":"manual/distributed-computing.html#Remote-References-and-Distributed-Garbage-Collection","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Objects referred to by remote references can be freed only when all held references in the cluster are deleted.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The node where the value is stored keeps track of which of the workers have a reference to it. Every time a RemoteChannel or a (unfetched) Future is serialized to a worker, the node pointed to by the reference is notified. And every time a RemoteChannel or a (unfetched) Future is garbage collected locally, the node owning the value is again notified. This is implemented in an internal cluster aware serializer. Remote references are only valid in the context of a running cluster. Serializing and deserializing references to and from regular IO objects is not supported.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The notifications are done via sending of \"tracking\" messages–an \"add reference\" message when a reference is serialized to a different process and a \"delete reference\" message when a reference is locally garbage collected.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Since Futures are write-once and cached locally, the act of fetching a Future also updates reference tracking information on the node owning the value.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The node which owns the value frees it once all references to it are cleared.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"With Futures, serializing an already fetched Future to a different node also sends the value since the original remote store may have collected the value by this time.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"It is important to note that when an object is locally garbage collected depends on the size of the object and the current memory pressure in the system.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"In case of remote references, the size of the local reference object is quite small, while the value stored on the remote node may be quite large. Since the local object may not be collected immediately, it is a good practice to explicitly call finalize on local instances of a RemoteChannel, or on unfetched Futures. Since calling fetch on a Future also removes its reference from the remote store, this is not required on fetched Futures. Explicitly calling finalize results in an immediate message sent to the remote node to go ahead and remove its reference to the value.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Once finalized, a reference becomes invalid and cannot be used in any further calls.","page":"Multi-processing and Distributed Computing"},{"title":"Local invocations","location":"manual/distributed-computing.html#Local-invocations","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Data is necessarily copied over to the remote node for execution. This is the case for both remotecalls and when data is stored to aRemoteChannel / Future on a different node. As expected, this results in a copy of the serialized objects on the remote node. However, when the destination node is the local node, i.e. the calling process id is the same as the remote node id, it is executed as a local call. It is usually (not always) executed in a different task - but there is no serialization/deserialization of data. Consequently, the call refers to the same object instances as passed - no copies are created. This behavior is highlighted below:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> using Distributed;\n\njulia> rc = RemoteChannel(()->Channel(3));   # RemoteChannel created on local node\n\njulia> v = [0];\n\njulia> for i in 1:3\n           v[1] = i                          # Reusing `v`\n           put!(rc, v)\n       end;\n\njulia> result = [take!(rc) for _ in 1:3];\n\njulia> println(result);\nArray{Int64,1}[[3], [3], [3]]\n\njulia> println(\"Num Unique objects : \", length(unique(map(objectid, result))));\nNum Unique objects : 1\n\njulia> addprocs(1);\n\njulia> rc = RemoteChannel(()->Channel(3), workers()[1]);   # RemoteChannel created on remote node\n\njulia> v = [0];\n\njulia> for i in 1:3\n           v[1] = i\n           put!(rc, v)\n       end;\n\njulia> result = [take!(rc) for _ in 1:3];\n\njulia> println(result);\nArray{Int64,1}[[1], [2], [3]]\n\njulia> println(\"Num Unique objects : \", length(unique(map(objectid, result))));\nNum Unique objects : 3","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"As can be seen, put! on a locally owned RemoteChannel with the same object v modifed between calls results in the same single object instance stored. As opposed to copies of v being created when the node owning rc is a different node.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"It is to be noted that this is generally not an issue. It is something to be factored in only if the object is both being stored locally and modifed post the call. In such cases it may be appropriate to store a deepcopy of the object.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"This is also true for remotecalls on the local node as seen in the following example:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"julia> using Distributed; addprocs(1);\n\njulia> v = [0];\n\njulia> v2 = remotecall_fetch(x->(x[1] = 1; x), myid(), v);     # Executed on local node\n\njulia> println(\"v=$v, v2=$v2, \", v === v2);\nv=[1], v2=[1], true\n\njulia> v = [0];\n\njulia> v2 = remotecall_fetch(x->(x[1] = 1; x), workers()[1], v); # Executed on remote node\n\njulia> println(\"v=$v, v2=$v2, \", v === v2);\nv=[0], v2=[1], false","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"As can be seen once again, a remote call onto the local node behaves just like a direct invocation. The call modifies local objects passed as arguments. In the remote invocation, it operates on a copy of the arguments.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"To repeat, in general this is not an issue. If the local node is also being used as a compute node, and the arguments used post the call, this behavior needs to be factored in and if required deep copies of arguments must be passed to the call invoked on the local node. Calls on remote nodes will always operate on copies of arguments.","page":"Multi-processing and Distributed Computing"},{"title":"Shared Arrays","location":"manual/distributed-computing.html#man-shared-arrays","category":"section","text":"","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Shared Arrays use system shared memory to map the same array across many processes. While there are some similarities to a DArray, the behavior of a SharedArray is quite different. In a DArray, each process has local access to just a chunk of the data, and no two processes share the same chunk; in contrast, in a SharedArray each \"participating\" process has access to the entire array.  A SharedArray is a good choice when you want to have a large amount of data jointly accessible to two or more processes on the same machine.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"Shared Array support is available via module SharedArrays which must be explicitly loaded on all participating workers.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"SharedArray indexing (assignment and accessing values) works just as with regular arrays, and is efficient because the underlying memory is available to the local process. Therefore, most algorithms work naturally on SharedArrays, albeit in single-process mode. In cases where an algorithm insists on an Array input, the underlying array can be retrieved from a SharedArray by calling sdata. For other AbstractArray types, sdata just returns the object itself, so it's safe to use sdata on any Array-type object.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"The constructor for a shared array is of the form:","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"SharedArray{T,N}(dims::NTuple; init=false, pids=Int[])","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"which creates an N-dimensional shared array of a bits type T and size dims across the processes specified by pids. Unlike distributed arrays, a shared array is accessible only from those participating workers specified by the pids named argument (and the creating process too, if it is on the same host). Note that only elements that are isbits are supported in a SharedArray.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","location":"manual/distributed-computing.html","category":"page","text":"If an init function, of signature initfn(S::SharedArray), is specified, it is called on all the participating workers. You can specify that each worker runs the init function on a distinct portion of the array, thereby parallelizing initialization.","page":"Multi-processing and Distributed Computing"},{"title":"Multi-processing and Distributed Computing","loca