var documenterSearchIndex = {"docs":
[{"title":"Tasks","location":"base/parallel.html#Tasks","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Core.Task\nBase.@task\nBase.@async\nBase.asyncmap\nBase.asyncmap!\nBase.current_task\nBase.istaskdone\nBase.istaskstarted\nBase.istaskfailed\nBase.task_local_storage(::Any)\nBase.task_local_storage(::Any, ::Any)\nBase.task_local_storage(::Function, ::Any, ::Any)","page":"Tasks"},{"title":"Core.Task","location":"base/parallel.html#Core.Task","category":"type","text":"Task(func)\n\nCreate a Task (i.e. coroutine) to execute the given function func (which must be callable with no arguments). The task exits when this function returns. The task will run in the \"world age\" from the parent at construction when scheduled.\n\nwarning: Warning\nBy default tasks will have the sticky bit set to true t.sticky. This models the historic default for @async. Sticky tasks can only be run on the worker thread they are first scheduled on, and when scheduled will make the task that they were scheduled from sticky. To obtain the behavior of Threads.@spawn set the sticky bit manually to false.\n\nExamples\n\njulia> a() = sum(i for i in 1:1000);\n\njulia> b = Task(a);\n\nIn this example, b is a runnable Task that hasn't started yet.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.@task","location":"base/parallel.html#Base.@task","category":"macro","text":"@task\n\nWrap an expression in a Task without executing it, and return the Task. This only creates a task, and does not run it.\n\nwarning: Warning\nBy default tasks will have the sticky bit set to true t.sticky. This models the historic default for @async. Sticky tasks can only be run on the worker thread they are first scheduled on, and when scheduled will make the task that they were scheduled from sticky. To obtain the behavior of Threads.@spawn set the sticky bit manually to false.\n\nExamples\n\njulia> a1() = sum(i for i in 1:1000);\n\njulia> b = @task a1();\n\njulia> istaskstarted(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskdone(b)\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.@async","location":"base/parallel.html#Base.@async","category":"macro","text":"@async\n\nWrap an expression in a Task and add it to the local machine's scheduler queue.\n\nValues can be interpolated into @async via $, which copies the value directly into the constructed underlying closure. This allows you to insert the value of a variable, isolating the asynchronous code from changes to the variable's value in the current task.\n\nwarning: Warning\nIt is strongly encouraged to favor Threads.@spawn over @async always even when no parallelism is required especially in publicly distributed libraries.  This is because a use of @async disables the migration of the parent task across worker threads in the current implementation of Julia.  Thus, seemingly innocent use of @async in a library function can have a large impact on the performance of very different parts of user applications.\n\ncompat: Julia 1.4\nInterpolating values via $ is available as of Julia 1.4.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.asyncmap","location":"base/parallel.html#Base.asyncmap","category":"function","text":"asyncmap(f, c...; ntasks=0, batch_size=nothing)\n\nUses multiple concurrent tasks to map f over a collection (or multiple equal length collections). For multiple collection arguments, f is applied elementwise.\n\nntasks specifies the number of tasks to run concurrently. Depending on the length of the collections, if ntasks is unspecified, up to 100 tasks will be used for concurrent mapping.\n\nntasks can also be specified as a zero-arg function. In this case, the number of tasks to run in parallel is checked before processing every element and a new task started if the value of ntasks_func is greater than the current number of tasks.\n\nIf batch_size is specified, the collection is processed in batch mode. f must then be a function that must accept a Vector of argument tuples and must return a vector of results. The input vector will have a length of batch_size or less.\n\nThe following examples highlight execution in different tasks by returning the objectid of the tasks in which the mapping function is executed.\n\nFirst, with ntasks undefined, each element is processed in a different task.\n\njulia> tskoid() = objectid(current_task());\n\njulia> asyncmap(x->tskoid(), 1:5)\n5-element Array{UInt64,1}:\n 0x6e15e66c75c75853\n 0x440f8819a1baa682\n 0x9fb3eeadd0c83985\n 0xebd3e35fe90d4050\n 0x29efc93edce2b961\n\njulia> length(unique(asyncmap(x->tskoid(), 1:5)))\n5\n\nWith ntasks=2 all elements are processed in 2 tasks.\n\njulia> asyncmap(x->tskoid(), 1:5; ntasks=2)\n5-element Array{UInt64,1}:\n 0x027ab1680df7ae94\n 0xa23d2f80cd7cf157\n 0x027ab1680df7ae94\n 0xa23d2f80cd7cf157\n 0x027ab1680df7ae94\n\njulia> length(unique(asyncmap(x->tskoid(), 1:5; ntasks=2)))\n2\n\nWith batch_size defined, the mapping function needs to be changed to accept an array of argument tuples and return an array of results. map is used in the modified mapping function to achieve this.\n\njulia> batch_func(input) = map(x->string(\"args_tuple: \", x, \", element_val: \", x[1], \", task: \", tskoid()), input)\nbatch_func (generic function with 1 method)\n\njulia> asyncmap(batch_func, 1:5; ntasks=2, batch_size=2)\n5-element Array{String,1}:\n \"args_tuple: (1,), element_val: 1, task: 9118321258196414413\"\n \"args_tuple: (2,), element_val: 2, task: 4904288162898683522\"\n \"args_tuple: (3,), element_val: 3, task: 9118321258196414413\"\n \"args_tuple: (4,), element_val: 4, task: 4904288162898683522\"\n \"args_tuple: (5,), element_val: 5, task: 9118321258196414413\"\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.asyncmap!","location":"base/parallel.html#Base.asyncmap!","category":"function","text":"asyncmap!(f, results, c...; ntasks=0, batch_size=nothing)\n\nLike asyncmap, but stores output in results rather than returning a collection.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.current_task","location":"base/parallel.html#Base.current_task","category":"function","text":"current_task()\n\nGet the currently running Task.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.istaskdone","location":"base/parallel.html#Base.istaskdone","category":"function","text":"istaskdone(t::Task) -> Bool\n\nDetermine whether a task has exited.\n\nExamples\n\njulia> a2() = sum(i for i in 1:1000);\n\njulia> b = Task(a2);\n\njulia> istaskdone(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskdone(b)\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.istaskstarted","location":"base/parallel.html#Base.istaskstarted","category":"function","text":"istaskstarted(t::Task) -> Bool\n\nDetermine whether a task has started executing.\n\nExamples\n\njulia> a3() = sum(i for i in 1:1000);\n\njulia> b = Task(a3);\n\njulia> istaskstarted(b)\nfalse\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.istaskfailed","location":"base/parallel.html#Base.istaskfailed","category":"function","text":"istaskfailed(t::Task) -> Bool\n\nDetermine whether a task has exited because an exception was thrown.\n\nExamples\n\njulia> a4() = error(\"task failed\");\n\njulia> b = Task(a4);\n\njulia> istaskfailed(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskfailed(b)\ntrue\n\ncompat: Julia 1.3\nThis function requires at least Julia 1.3.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.task_local_storage","location":"base/parallel.html#Base.task_local_storage-Tuple{Any}","category":"method","text":"task_local_storage(key)\n\nLook up the value of a key in the current task's task-local storage.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.task_local_storage","location":"base/parallel.html#Base.task_local_storage-Tuple{Any, Any}","category":"method","text":"task_local_storage(key, value)\n\nAssign a value to a key in the current task's task-local storage.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.task_local_storage","location":"base/parallel.html#Base.task_local_storage-Tuple{Function, Any, Any}","category":"method","text":"task_local_storage(body, key, value)\n\nCall the function body with a modified task-local storage, in which value is assigned to key; the previous value of key, or lack thereof, is restored afterwards. Useful for emulating dynamic scoping.\n\n\n\n\n\n","page":"Tasks"},{"title":"Scheduling","location":"base/parallel.html#Scheduling","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Base.yield\nBase.yieldto\nBase.sleep\nBase.schedule","page":"Tasks"},{"title":"Base.yield","location":"base/parallel.html#Base.yield","category":"function","text":"yield()\n\nSwitch to the scheduler to allow another scheduled task to run. A task that calls this function is still runnable, and will be restarted immediately if there are no other runnable tasks.\n\n\n\n\n\nyield(t::Task, arg = nothing)\n\nA fast, unfair-scheduling version of schedule(t, arg); yield() which immediately yields to t before calling the scheduler.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.yieldto","location":"base/parallel.html#Base.yieldto","category":"function","text":"yieldto(t::Task, arg = nothing)\n\nSwitch to the given task. The first time a task is switched to, the task's function is called with no arguments. On subsequent switches, arg is returned from the task's last call to yieldto. This is a low-level call that only switches tasks, not considering states or scheduling in any way. Its use is discouraged.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.sleep","location":"base/parallel.html#Base.sleep","category":"function","text":"sleep(seconds)\n\nBlock the current task for a specified number of seconds. The minimum sleep time is 1 millisecond or input of 0.001.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.schedule","location":"base/parallel.html#Base.schedule","category":"function","text":"schedule(t::Task, [val]; error=false)\n\nAdd a Task to the scheduler's queue. This causes the task to run constantly when the system is otherwise idle, unless the task performs a blocking operation such as wait.\n\nIf a second argument val is provided, it will be passed to the task (via the return value of yieldto) when it runs again. If error is true, the value is raised as an exception in the woken task.\n\nwarning: Warning\nIt is incorrect to use schedule on an arbitrary Task that has already been started. See the API reference for more information.\n\nwarning: Warning\nBy default tasks will have the sticky bit set to true t.sticky. This models the historic default for @async. Sticky tasks can only be run on the worker thread they are first scheduled on, and when scheduled will make the task that they were scheduled from sticky. To obtain the behavior of Threads.@spawn set the sticky bit manually to false.\n\nExamples\n\njulia> a5() = sum(i for i in 1:1000);\n\njulia> b = Task(a5);\n\njulia> istaskstarted(b)\nfalse\n\njulia> schedule(b);\n\njulia> yield();\n\njulia> istaskstarted(b)\ntrue\n\njulia> istaskdone(b)\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Synchronization","location":"base/parallel.html#lib-task-sync","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Base.errormonitor\nBase.@sync\nBase.wait\nBase.fetch(t::Task)\nBase.fetch(x::Any)\nBase.timedwait\n\nBase.Condition\nBase.Threads.Condition\nBase.Threads.Event\nBase.notify\nBase.reset(::Base.Threads.Event)\n\nBase.Semaphore\nBase.acquire\nBase.release\n\nBase.AbstractLock\nBase.lock\nBase.unlock\nBase.trylock\nBase.islocked\nBase.ReentrantLock\nBase.@lock\nBase.Lockable","page":"Tasks"},{"title":"Base.errormonitor","location":"base/parallel.html#Base.errormonitor","category":"function","text":"errormonitor(t::Task)\n\nPrint an error log to stderr if task t fails.\n\nExamples\n\njulia> Base._wait(errormonitor(Threads.@spawn error(\"task failed\")))\nUnhandled Task ERROR: task failed\nStacktrace:\n[...]\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.@sync","location":"base/parallel.html#Base.@sync","category":"macro","text":"@sync\n\nWait until all lexically-enclosed uses of @async, @spawn, Distributed.@spawnat and Distributed.@distributed are complete. All exceptions thrown by enclosed async operations are collected and thrown as a CompositeException.\n\nExamples\n\njulia> Threads.nthreads()\n4\n\njulia> @sync begin\n           Threads.@spawn println(\"Thread-id $(Threads.threadid()), task 1\")\n           Threads.@spawn println(\"Thread-id $(Threads.threadid()), task 2\")\n       end;\nThread-id 3, task 1\nThread-id 1, task 2\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.wait","location":"base/parallel.html#Base.wait","category":"function","text":"Special note for Threads.Condition:\n\nThe caller must be holding the lock that owns a Threads.Condition before calling this method. The calling task will be blocked until some other task wakes it, usually by calling notify on the same Threads.Condition object. The lock will be atomically released when blocking (even if it was locked recursively), and will be reacquired before returning.\n\n\n\n\n\nwait(r::Future)\n\nWait for a value to become available for the specified Future.\n\n\n\n\n\nwait(r::RemoteChannel, args...)\n\nWait for a value to become available on the specified RemoteChannel.\n\n\n\n\n\nwait([x])\n\nBlock the current task until some event occurs, depending on the type of the argument:\n\nChannel: Wait for a value to be appended to the channel.\nCondition: Wait for notify on a condition and return the val parameter passed to notify. Waiting on a condition additionally allows passing first=true which results in the waiter being put first in line to wake up on notify instead of the usual first-in-first-out behavior.\nProcess: Wait for a process or process chain to exit. The exitcode field of a process can be used to determine success or failure.\nTask: Wait for a Task to finish. If the task fails with an exception, a TaskFailedException (which wraps the failed task) is thrown.\nRawFD: Wait for changes on a file descriptor (see the FileWatching package).\n\nIf no argument is passed, the task blocks for an undefined period. A task can only be restarted by an explicit call to schedule or yieldto.\n\nOften wait is called within a while loop to ensure a waited-for condition is met before proceeding.\n\n\n\n\n\nwait(c::Channel)\n\nBlocks until the Channel isready.\n\njulia> c = Channel(1);\n\njulia> isready(c)\nfalse\n\njulia> task = Task(() -> wait(c));\n\njulia> schedule(task);\n\njulia> istaskdone(task)  # task is blocked because channel is not ready\nfalse\n\njulia> put!(c, 1);\n\njulia> istaskdone(task)  # task is now unblocked\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.fetch","location":"base/parallel.html#Base.fetch-Tuple{Task}","category":"method","text":"fetch(t::Task)\n\nWait for a Task to finish, then return its result value. If the task fails with an exception, a TaskFailedException (which wraps the failed task) is thrown.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.fetch","location":"base/parallel.html#Base.fetch-Tuple{Any}","category":"method","text":"fetch(x::Any)\n\nReturn x.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.timedwait","location":"base/parallel.html#Base.timedwait","category":"function","text":"timedwait(testcb, timeout::Real; pollint::Real=0.1)\n\nWait until testcb() returns true or timeout seconds have passed, whichever is earlier. The test function is polled every pollint seconds. The minimum value for pollint is 0.001 seconds, that is, 1 millisecond.\n\nReturn :ok or :timed_out.\n\nExamples\n\njulia> cb() = (sleep(5); return);\n\njulia> t = @async cb();\n\njulia> timedwait(()->istaskdone(t), 1)\n:timed_out\n\njulia> timedwait(()->istaskdone(t), 6.5)\n:ok\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Condition","location":"base/parallel.html#Base.Condition","category":"type","text":"Condition()\n\nCreate an edge-triggered event source that tasks can wait for. Tasks that call wait on a Condition are suspended and queued. Tasks are woken up when notify is later called on the Condition. Waiting on a condition can return a value or raise an error if the optional arguments of notify are used. Edge triggering means that only tasks waiting at the time notify is called can be woken up. For level-triggered notifications, you must keep extra state to keep track of whether a notification has happened. The Channel and Threads.Event types do this, and can be used for level-triggered events.\n\nThis object is NOT thread-safe. See Threads.Condition for a thread-safe version.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Threads.Condition","location":"base/parallel.html#Base.Threads.Condition","category":"type","text":"Threads.Condition([lock])\n\nA thread-safe version of Base.Condition.\n\nTo call wait or notify on a Threads.Condition, you must first call lock on it. When wait is called, the lock is atomically released during blocking, and will be reacquired before wait returns. Therefore idiomatic use of a Threads.Condition c looks like the following:\n\nlock(c)\ntry\n    while !thing_we_are_waiting_for\n        wait(c)\n    end\nfinally\n    unlock(c)\nend\n\ncompat: Julia 1.2\nThis functionality requires at least Julia 1.2.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Event","location":"base/parallel.html#Base.Event","category":"type","text":"Event([autoreset=false])\n\nCreate a level-triggered event source. Tasks that call wait on an Event are suspended and queued until notify is called on the Event. After notify is called, the Event remains in a signaled state and tasks will no longer block when waiting for it, until reset is called.\n\nIf autoreset is true, at most one task will be released from wait for each call to notify.\n\nThis provides an acquire & release memory ordering on notify/wait.\n\ncompat: Julia 1.1\nThis functionality requires at least Julia 1.1.\n\ncompat: Julia 1.8\nThe autoreset functionality and memory ordering guarantee requires at least Julia 1.8.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.notify","location":"base/parallel.html#Base.notify","category":"function","text":"notify(condition, val=nothing; all=true, error=false)\n\nWake up tasks waiting for a condition, passing them val. If all is true (the default), all waiting tasks are woken, otherwise only one is. If error is true, the passed value is raised as an exception in the woken tasks.\n\nReturn the count of tasks woken up. Return 0 if no tasks are waiting on condition.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.reset","location":"base/parallel.html#Base.reset-Tuple{Base.Event}","category":"method","text":"reset(::Event)\n\nReset an Event back into an un-set state. Then any future calls to wait will block until notify is called again.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Semaphore","location":"base/parallel.html#Base.Semaphore","category":"type","text":"Semaphore(sem_size)\n\nCreate a counting semaphore that allows at most sem_size acquires to be in use at any time. Each acquire must be matched with a release.\n\nThis provides a acquire & release memory ordering on acquire/release calls.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.acquire","location":"base/parallel.html#Base.acquire","category":"function","text":"acquire(s::Semaphore)\n\nWait for one of the sem_size permits to be available, blocking until one can be acquired.\n\n\n\n\n\nacquire(f, s::Semaphore)\n\nExecute f after acquiring from Semaphore s, and release on completion or error.\n\nFor example, a do-block form that ensures only 2 calls of foo will be active at the same time:\n\ns = Base.Semaphore(2)\n@sync for _ in 1:100\n    Threads.@spawn begin\n        Base.acquire(s) do\n            foo()\n        end\n    end\nend\n\ncompat: Julia 1.8\nThis method requires at least Julia 1.8.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.release","location":"base/parallel.html#Base.release","category":"function","text":"release(s::Semaphore)\n\nReturn one permit to the pool, possibly allowing another task to acquire it and resume execution.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.AbstractLock","location":"base/parallel.html#Base.AbstractLock","category":"type","text":"AbstractLock\n\nAbstract supertype describing types that implement the synchronization primitives: lock, trylock, unlock, and islocked.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.lock","location":"base/parallel.html#Base.lock","category":"function","text":"lock(lock)\n\nAcquire the lock when it becomes available. If the lock is already locked by a different task/thread, wait for it to become available.\n\nEach lock must be matched by an unlock.\n\n\n\n\n\nlock(f::Function, lock)\n\nAcquire the lock, execute f with the lock held, and release the lock when f returns. If the lock is already locked by a different task/thread, wait for it to become available.\n\nWhen this function returns, the lock has been released, so the caller should not attempt to unlock it.\n\nSee also: @lock.\n\ncompat: Julia 1.7\nUsing a Channel as the second argument requires Julia 1.7 or later.\n\n\n\n\n\nlock(f::Function, l::Lockable)\n\nAcquire the lock associated with l, execute f with the lock held, and release the lock when f returns. f will receive one positional argument: the value wrapped by l. If the lock is already locked by a different task/thread, wait for it to become available. When this function returns, the lock has been released, so the caller should not attempt to unlock it.\n\ncompat: Julia 1.11\nRequires at least Julia 1.11.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.unlock","location":"base/parallel.html#Base.unlock","category":"function","text":"unlock(lock)\n\nReleases ownership of the lock.\n\nIf this is a recursive lock which has been acquired before, decrement an internal counter and return immediately.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.trylock","location":"base/parallel.html#Base.trylock","category":"function","text":"trylock(lock) -> Success (Boolean)\n\nAcquire the lock if it is available, and return true if successful. If the lock is already locked by a different task/thread, return false.\n\nEach successful trylock must be matched by an unlock.\n\nFunction trylock combined with islocked can be used for writing the test-and-test-and-set or exponential backoff algorithms if it is supported by the typeof(lock) (read its documentation).\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.islocked","location":"base/parallel.html#Base.islocked","category":"function","text":"islocked(lock) -> Status (Boolean)\n\nCheck whether the lock is held by any task/thread. This function alone should not be used for synchronization. However, islocked combined with trylock can be used for writing the test-and-test-and-set or exponential backoff algorithms if it is supported by the typeof(lock) (read its documentation).\n\nExtended help\n\nFor example, an exponential backoff can be implemented as follows if the lock implementation satisfied the properties documented below.\n\nnspins = 0\nwhile true\n    while islocked(lock)\n        GC.safepoint()\n        nspins += 1\n        nspins > LIMIT && error(\"timeout\")\n    end\n    trylock(lock) && break\n    backoff()\nend\n\nImplementation\n\nA lock implementation is advised to define islocked with the following properties and note it in its docstring.\n\nislocked(lock) is data-race-free.\nIf islocked(lock) returns false, an immediate invocation of trylock(lock) must succeed (returns true) if there is no interference from other tasks.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.ReentrantLock","location":"base/parallel.html#Base.ReentrantLock","category":"type","text":"ReentrantLock()\n\nCreates a re-entrant lock for synchronizing Tasks. The same task can acquire the lock as many times as required (this is what the \"Reentrant\" part of the name means). Each lock must be matched with an unlock.\n\nCalling lock will also inhibit running of finalizers on that thread until the corresponding unlock. Use of the standard lock pattern illustrated below should naturally be supported, but beware of inverting the try/lock order or missing the try block entirely (e.g. attempting to return with the lock still held):\n\nThis provides a acquire/release memory ordering on lock/unlock calls.\n\nlock(l)\ntry\n    <atomic work>\nfinally\n    unlock(l)\nend\n\nIf !islocked(lck::ReentrantLock) holds, trylock(lck) succeeds unless there are other tasks attempting to hold the lock \"at the same time.\"\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.@lock","location":"base/parallel.html#Base.@lock","category":"macro","text":"@lock l expr\n\nMacro version of lock(f, l::AbstractLock) but with expr instead of f function. Expands to:\n\nlock(l)\ntry\n    expr\nfinally\n    unlock(l)\nend\n\nThis is similar to using lock with a do block, but avoids creating a closure and thus can improve the performance.\n\ncompat: Compat\n@lock was added in Julia 1.3, and exported in Julia 1.10.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Lockable","location":"base/parallel.html#Base.Lockable","category":"type","text":"Lockable(value, lock = ReentrantLock())\n\nCreates a Lockable object that wraps value and associates it with the provided lock. This object supports @lock, lock, trylock, unlock. To access the value, index the lockable object while holding the lock.\n\ncompat: Julia 1.11\nRequires at least Julia 1.11.\n\nExample\n\njulia> locked_list = Base.Lockable(Int[]);\n\njulia> @lock(locked_list, push!(locked_list[], 1)) # must hold the lock to access the value\n1-element Vector{Int64}:\n 1\n\njulia> lock(summary, locked_list)\n\"1-element Vector{Int64}\"\n\n\n\n\n\n","page":"Tasks"},{"title":"Channels","location":"base/parallel.html#Channels","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"Base.AbstractChannel\nBase.Channel\nBase.Channel(::Function)\nBase.put!(::Channel, ::Any)\nBase.take!(::Channel)\nBase.isready(::Channel)\nBase.fetch(::Channel)\nBase.close(::Channel)\nBase.bind(c::Channel, task::Task)","page":"Tasks"},{"title":"Base.AbstractChannel","location":"base/parallel.html#Base.AbstractChannel","category":"type","text":"AbstractChannel{T}\n\nRepresentation of a channel passing objects of type T.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Channel","location":"base/parallel.html#Base.Channel","category":"type","text":"Channel{T=Any}(size::Int=0)\n\nConstructs a Channel with an internal buffer that can hold a maximum of size objects of type T. put! calls on a full channel block until an object is removed with take!.\n\nChannel(0) constructs an unbuffered channel. put! blocks until a matching take! is called. And vice-versa.\n\nOther constructors:\n\nChannel(): default constructor, equivalent to Channel{Any}(0)\nChannel(Inf): equivalent to Channel{Any}(typemax(Int))\nChannel(sz): equivalent to Channel{Any}(sz)\n\ncompat: Julia 1.3\nThe default constructor Channel() and default size=0 were added in Julia 1.3.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.Channel","location":"base/parallel.html#Base.Channel-Tuple{Function}","category":"method","text":"Channel{T=Any}(func::Function, size=0; taskref=nothing, spawn=false, threadpool=nothing)\n\nCreate a new task from func, bind it to a new channel of type T and size size, and schedule the task, all in a single call. The channel is automatically closed when the task terminates.\n\nfunc must accept the bound channel as its only argument.\n\nIf you need a reference to the created task, pass a Ref{Task} object via the keyword argument taskref.\n\nIf spawn=true, the Task created for func may be scheduled on another thread in parallel, equivalent to creating a task via Threads.@spawn.\n\nIf spawn=true and the threadpool argument is not set, it defaults to :default.\n\nIf the threadpool argument is set (to :default or :interactive), this implies that spawn=true and the new Task is spawned to the specified threadpool.\n\nReturn a Channel.\n\nExamples\n\njulia> chnl = Channel() do ch\n           foreach(i -> put!(ch, i), 1:4)\n       end;\n\njulia> typeof(chnl)\nChannel{Any}\n\njulia> for i in chnl\n           @show i\n       end;\ni = 1\ni = 2\ni = 3\ni = 4\n\nReferencing the created task:\n\njulia> taskref = Ref{Task}();\n\njulia> chnl = Channel(taskref=taskref) do ch\n           println(take!(ch))\n       end;\n\njulia> istaskdone(taskref[])\nfalse\n\njulia> put!(chnl, \"Hello\");\nHello\n\njulia> istaskdone(taskref[])\ntrue\n\ncompat: Julia 1.3\nThe spawn= parameter was added in Julia 1.3. This constructor was added in Julia 1.3. In earlier versions of Julia, Channel used keyword arguments to set size and T, but those constructors are deprecated.\n\ncompat: Julia 1.9\nThe threadpool= argument was added in Julia 1.9.\n\njulia> chnl = Channel{Char}(1, spawn=true) do ch\n           for c in \"hello world\"\n               put!(ch, c)\n           end\n       end\nChannel{Char}(1) (2 items available)\n\njulia> String(collect(chnl))\n\"hello world\"\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.put!","location":"base/parallel.html#Base.put!-Tuple{Channel, Any}","category":"method","text":"put!(c::Channel, v)\n\nAppend an item v to the channel c. Blocks if the channel is full.\n\nFor unbuffered channels, blocks until a take! is performed by a different task.\n\ncompat: Julia 1.1\nv now gets converted to the channel's type with convert as put! is called.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.take!","location":"base/parallel.html#Base.take!-Tuple{Channel}","category":"method","text":"take!(c::Channel)\n\nRemoves and returns a value from a Channel in order. Blocks until data is available. For unbuffered channels, blocks until a put! is performed by a different task.\n\nExamples\n\nBuffered channel:\n\njulia> c = Channel(1);\n\njulia> put!(c, 1);\n\njulia> take!(c)\n1\n\nUnbuffered channel:\n\njulia> c = Channel(0);\n\njulia> task = Task(() -> put!(c, 1));\n\njulia> schedule(task);\n\njulia> take!(c)\n1\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.isready","location":"base/parallel.html#Base.isready-Tuple{Channel}","category":"method","text":"isready(c::Channel)\n\nDetermines whether a Channel has a value stored in it. Returns immediately, does not block.\n\nFor unbuffered channels returns true if there are tasks waiting on a put!.\n\nExamples\n\nBuffered channel:\n\njulia> c = Channel(1);\n\njulia> isready(c)\nfalse\n\njulia> put!(c, 1);\n\njulia> isready(c)\ntrue\n\nUnbuffered channel:\n\njulia> c = Channel();\n\njulia> isready(c)  # no tasks waiting to put!\nfalse\n\njulia> task = Task(() -> put!(c, 1));\n\njulia> schedule(task);  # schedule a put! task\n\njulia> isready(c)\ntrue\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.fetch","location":"base/parallel.html#Base.fetch-Tuple{Channel}","category":"method","text":"fetch(c::Channel)\n\nWaits for and returns (without removing) the first available item from the Channel. Note: fetch is unsupported on an unbuffered (0-size) Channel.\n\nExamples\n\nBuffered channel:\n\njulia> c = Channel(3) do ch\n           foreach(i -> put!(ch, i), 1:3)\n       end;\n\njulia> fetch(c)\n1\n\njulia> collect(c)  # item is not removed\n3-element Vector{Any}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.close","location":"base/parallel.html#Base.close-Tuple{Channel}","category":"method","text":"close(c::Channel[, excp::Exception])\n\nClose a channel. An exception (optionally given by excp), is thrown by:\n\nput! on a closed channel.\ntake! and fetch on an empty, closed channel.\n\n\n\n\n\n","page":"Tasks"},{"title":"Base.bind","location":"base/parallel.html#Base.bind-Tuple{Channel, Task}","category":"method","text":"bind(chnl::Channel, task::Task)\n\nAssociate the lifetime of chnl with a task. Channel chnl is automatically closed when the task terminates. Any uncaught exception in the task is propagated to all waiters on chnl.\n\nThe chnl object can be explicitly closed independent of task termination. Terminating tasks have no effect on already closed Channel objects.\n\nWhen a channel is bound to multiple tasks, the first task to terminate will close the channel. When multiple channels are bound to the same task, termination of the task will close all of the bound channels.\n\nExamples\n\njulia> c = Channel(0);\n\njulia> task = @async foreach(i->put!(c, i), 1:4);\n\njulia> bind(c,task);\n\njulia> for i in c\n           @show i\n       end;\ni = 1\ni = 2\ni = 3\ni = 4\n\njulia> isopen(c)\nfalse\n\njulia> c = Channel(0);\n\njulia> task = @async (put!(c, 1); error(\"foo\"));\n\njulia> bind(c, task);\n\njulia> take!(c)\n1\n\njulia> put!(c, 1);\nERROR: TaskFailedException\nStacktrace:\n[...]\n    nested task error: foo\n[...]\n\n\n\n\n\n","page":"Tasks"},{"title":"Low-level synchronization using schedule and wait","location":"base/parallel.html#low-level-schedule-wait","category":"section","text":"","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"The easiest correct use of schedule is on a Task that is not started (scheduled) yet.  However, it is possible to use schedule and wait as a very low-level building block for constructing synchronization interfaces.  A crucial pre-condition of calling schedule(task) is that the caller must \"own\" the task; i.e., it must know that the call to wait in the given task is happening at the locations known to the code calling schedule(task).  One strategy for ensuring such pre-condition is to use atomics, as demonstrated in the following example:","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"@enum OWEState begin\n    OWE_EMPTY\n    OWE_WAITING\n    OWE_NOTIFYING\nend\n\nmutable struct OneWayEvent\n    @atomic state::OWEState\n    task::Task\n    OneWayEvent() = new(OWE_EMPTY)\nend\n\nfunction Base.notify(ev::OneWayEvent)\n    state = @atomic ev.state\n    while state !== OWE_NOTIFYING\n        # Spin until we successfully update the state to OWE_NOTIFYING:\n        state, ok = @atomicreplace(ev.state, state => OWE_NOTIFYING)\n        if ok\n            if state == OWE_WAITING\n                # OWE_WAITING -> OWE_NOTIFYING transition means that the waiter task is\n                # already waiting or about to call `wait`. The notifier task must wake up\n                # the waiter task.\n                schedule(ev.task)\n            else\n                @assert state == OWE_EMPTY\n                # Since we are assuming that there is only one notifier task (for\n                # simplicity), we know that the other possible case here is OWE_EMPTY.\n                # We do not need to do anything because we know that the waiter task has\n                # not called `wait(ev::OneWayEvent)` yet.\n            end\n            break\n        end\n    end\n    return\nend\n\nfunction Base.wait(ev::OneWayEvent)\n    ev.task = current_task()\n    state, ok = @atomicreplace(ev.state, OWE_EMPTY => OWE_WAITING)\n    if ok\n        # OWE_EMPTY -> OWE_WAITING transition means that the notifier task is guaranteed to\n        # invoke OWE_WAITING -> OWE_NOTIFYING transition.  The waiter task must call\n        # `wait()` immediately.  In particular, it MUST NOT invoke any function that may\n        # yield to the scheduler at this point in code.\n        wait()\n    else\n        @assert state == OWE_NOTIFYING\n        # Otherwise, the `state` must have already been moved to OWE_NOTIFYING by the\n        # notifier task.\n    end\n    return\nend\n\nev = OneWayEvent()\n@sync begin\n    @async begin\n        wait(ev)\n        println(\"done\")\n    end\n    println(\"notifying...\")\n    notify(ev)\nend\n\n# output\nnotifying...\ndone","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"OneWayEvent lets one task to wait for another task's notify.  It is a limited communication interface since wait can only be used once from a single task (note the non-atomic assignment of ev.task)","page":"Tasks"},{"title":"Tasks","location":"base/parallel.html","category":"page","text":"In this example, notify(ev::OneWayEvent) is allowed to call schedule(ev.task) if and only if it modifies the state from OWE_WAITING to OWE_NOTIFYING.  This lets us know that the task executing wait(ev::OneWayEvent) is now in the ok branch and that there cannot be other tasks that tries to schedule(ev.task) since their @atomicreplace(ev.state, state => OWE_NOTIFYING) will fail.","page":"Tasks"},{"title":"Missing Values","location":"manual/missing.html#missing","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Julia provides support for representing missing values in the statistical sense. This is for situations where no value is available for a variable in an observation, but a valid value theoretically exists. Missing values are represented via the missing object, which is the singleton instance of the type Missing. missing is equivalent to NULL in SQL and NA in R, and behaves like them in most situations.","page":"Missing Values"},{"title":"Propagation of Missing Values","location":"manual/missing.html#Propagation-of-Missing-Values","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"missing values propagate automatically when passed to standard mathematical operators and functions. For these functions, uncertainty about the value of one of the operands induces uncertainty about the result. In practice, this means a math operation involving a missing value generally returns missing:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing + 1\nmissing\n\njulia> \"a\" * missing\nmissing\n\njulia> abs(missing)\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Since missing is a normal Julia object, this propagation rule only works for functions which have opted in to implement this behavior. This can be achieved by:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"adding a specific method defined for arguments of type Missing,\naccepting arguments of this type, and passing them to functions which propagate them (like standard math operators).","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Packages should consider whether it makes sense to propagate missing values when defining new functions, and define methods appropriately if this is the case. Passing a missing value to a function which does not have a method accepting arguments of type Missing throws a MethodError, just like for any other type.","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Functions that do not propagate missing values can be made to do so by wrapping them in the passmissing function provided by the Missings.jl package. For example, f(x) becomes passmissing(f)(x).","page":"Missing Values"},{"title":"Equality and Comparison Operators","location":"manual/missing.html#Equality-and-Comparison-Operators","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Standard equality and comparison operators follow the propagation rule presented above: if any of the operands is missing, the result is missing. Here are a few examples:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing == 1\nmissing\n\njulia> missing == missing\nmissing\n\njulia> missing < 1\nmissing\n\njulia> 2 >= missing\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"In particular, note that missing == missing returns missing, so == cannot be used to test whether a value is missing. To test whether x is missing, use ismissing(x).","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Special comparison operators isequal and === are exceptions to the propagation rule. They will always return a Bool value, even in the presence of missing values, considering missing as equal to missing and as different from any other value. They can therefore be used to test whether a value is missing:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing === 1\nfalse\n\njulia> isequal(missing, 1)\nfalse\n\njulia> missing === missing\ntrue\n\njulia> isequal(missing, missing)\ntrue","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"The isless operator is another exception: missing is considered as greater than any other value. This operator is used by sort!, which therefore places missing values after all other values:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> isless(1, missing)\ntrue\n\njulia> isless(missing, Inf)\nfalse\n\njulia> isless(missing, missing)\nfalse","page":"Missing Values"},{"title":"Logical operators","location":"manual/missing.html#Logical-operators","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Logical (or boolean) operators |, & and xor are another special case since they only propagate missing values when it is logically required. For these operators, whether or not the result is uncertain, depends on the particular operation. This follows the well-established rules of three-valued logic which are implemented by e.g. NULL in SQL and NA in R. This abstract definition corresponds to a relatively natural behavior which is best explained via concrete examples.","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Let us illustrate this principle with the logical \"or\" operator |. Following the rules of boolean logic, if one of the operands is true, the value of the other operand does not have an influence on the result, which will always be true:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | true\ntrue","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Based on this observation, we can conclude if one of the operands is true and the other missing, we know that the result is true in spite of the uncertainty about the actual value of one of the operands. If we had been able to observe the actual value of the second operand, it could only be true or false, and in both cases the result would be true. Therefore, in this particular case, missingness does not propagate:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true | missing\ntrue\n\njulia> missing | true\ntrue","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"On the contrary, if one of the operands is false, the result could be either true or false depending on the value of the other operand. Therefore, if that operand is missing, the result has to be missing too:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> false | true\ntrue\n\njulia> true | false\ntrue\n\njulia> false | false\nfalse\n\njulia> false | missing\nmissing\n\njulia> missing | false\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"The behavior of the logical \"and\" operator & is similar to that of the | operator, with the difference that missingness does not propagate when one of the operands is false. For example, when that is the case of the first operand:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> false & false\nfalse\n\njulia> false & true\nfalse\n\njulia> false & missing\nfalse","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"On the other hand, missingness propagates when one of the operands is true, for example the first one:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true & true\ntrue\n\njulia> true & false\nfalse\n\njulia> true & missing\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Finally, the \"exclusive or\" logical operator xor always propagates missing values, since both operands always have an effect on the result. Also note that the negation operator ! returns missing when the operand is missing, just like other unary operators.","page":"Missing Values"},{"title":"Control Flow and Short-Circuiting Operators","location":"manual/missing.html#Control-Flow-and-Short-Circuiting-Operators","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Control flow operators including if, while and the ternary operator x ? y : z do not allow for missing values. This is because of the uncertainty about whether the actual value would be true or false if we could observe it. This implies we do not know how the program should behave. In this case, a TypeError is thrown as soon as a missing value is encountered in this context:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> if missing\n           println(\"here\")\n       end\nERROR: TypeError: non-boolean (Missing) used in boolean context","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"For the same reason, contrary to logical operators presented above, the short-circuiting boolean operators && and || do not allow for missing values in situations where the value of the operand determines whether the next operand is evaluated or not. For example:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> missing || false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean context\n\njulia> true && missing && false\nERROR: TypeError: non-boolean (Missing) used in boolean context","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"In contrast, there is no error thrown when the result can be determined without the missing values. This is the case when the code short-circuits before evaluating the missing operand, and when the missing operand is the last one:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> true && missing\nmissing\n\njulia> false && missing\nfalse","page":"Missing Values"},{"title":"Arrays With Missing Values","location":"manual/missing.html#Arrays-With-Missing-Values","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Arrays containing missing values can be created like other arrays:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> [1, missing]\n2-element Vector{Union{Missing, Int64}}:\n 1\n  missing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"As this example shows, the element type of such arrays is Union{Missing, T}, with T the type of the non-missing values. This reflects the fact that array entries can be either of type T (here, Int64) or of type Missing. This kind of array uses an efficient memory storage equivalent to an Array{T} holding the actual values combined with an Array{UInt8} indicating the type of the entry (i.e. whether it is Missing or T).","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Arrays allowing for missing values can be constructed with the standard syntax. Use Array{Union{Missing, T}}(missing, dims) to create arrays filled with missing values:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> Array{Union{Missing, String}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, String}}:\n missing  missing  missing\n missing  missing  missing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"note: Note\nUsing undef or similar may currently give an array filled with missing, but this is not the correct way to obtain such an array. Use a missing constructor as shown above instead.","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"An array with element type allowing missing entries (e.g. Vector{Union{Missing, T}}) which does not contain any missing entries can be converted to an array type that does not allow for missing entries (e.g. Vector{T}) using convert. If the array contains missing values, a MethodError is thrown during conversion:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> x = Union{Missing, String}[\"a\", \"b\"]\n2-element Vector{Union{Missing, String}}:\n \"a\"\n \"b\"\n\njulia> convert(Array{String}, x)\n2-element Vector{String}:\n \"a\"\n \"b\"\n\njulia> y = Union{Missing, String}[missing, \"b\"]\n2-element Vector{Union{Missing, String}}:\n missing\n \"b\"\n\njulia> convert(Array{String}, y)\nERROR: MethodError: Cannot `convert` an object of type Missing to an object of type String","page":"Missing Values"},{"title":"Skipping Missing Values","location":"manual/missing.html#Skipping-Missing-Values","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Since missing values propagate with standard mathematical operators, reduction functions return missing when called on arrays which contain missing values:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> sum([1, missing])\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"In this situation, use the skipmissing function to skip missing values:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> sum(skipmissing([1, missing]))\n1","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"This convenience function returns an iterator which filters out missing values efficiently. It can therefore be used with any function which supports iterators:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> x = skipmissing([3, missing, 2, 1])\nskipmissing(Union{Missing, Int64}[3, missing, 2, 1])\n\njulia> maximum(x)\n3\n\njulia> sum(x)\n6\n\njulia> mapreduce(sqrt, +, x)\n4.146264369941973","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Objects created by calling skipmissing on an array can be indexed using indices from the parent array. Indices corresponding to missing values are not valid for these objects, and an error is thrown when trying to use them (they are also skipped by keys and eachindex):","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> x[1]\n3\n\njulia> x[2]\nERROR: MissingException: the value at index (2,) is missing\n[...]","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"This allows functions which operate on indices to work in combination with skipmissing. This is notably the case for search and find functions. These functions return indices valid for the object returned by skipmissing, and are also the indices of the matching entries in the parent array:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> findall(==(1), x)\n1-element Vector{Int64}:\n 4\n\njulia> findfirst(!iszero, x)\n1\n\njulia> argmax(x)\n1","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Use collect to extract non-missing values and store them in an array:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> collect(x)\n3-element Vector{Int64}:\n 3\n 2\n 1","page":"Missing Values"},{"title":"Logical Operations on Arrays","location":"manual/missing.html#Logical-Operations-on-Arrays","category":"section","text":"","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"The three-valued logic described above for logical operators is also used by logical functions applied to arrays. Thus, array equality tests using the == operator return missing whenever the result cannot be determined without knowing the actual value of the missing entry. In practice, this means missing is returned if all non-missing values of the compared arrays are equal, but one or both arrays contain missing values (possibly at different positions):","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> [1, missing] == [2, missing]\nfalse\n\njulia> [1, missing] == [1, missing]\nmissing\n\njulia> [1, 2, missing] == [1, missing, 2]\nmissing","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"As for single values, use isequal to treat missing values as equal to other missing values, but different from non-missing values:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> isequal([1, missing], [1, missing])\ntrue\n\njulia> isequal([1, 2, missing], [1, missing, 2])\nfalse","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"Functions any and all also follow the rules of three-valued logic. Thus, returning missing when the result cannot be determined:","page":"Missing Values"},{"title":"Missing Values","location":"manual/missing.html","category":"page","text":"julia> all([true, missing])\nmissing\n\njulia> all([false, missing])\nfalse\n\njulia> any([true, missing])\ntrue\n\njulia> any([false, missing])\nmissing","page":"Missing Values"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html#Using-Valgrind-with-Julia","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Valgrind is a tool for memory debugging, memory leak detection, and profiling.  This section describes things to keep in mind when using Valgrind to debug memory issues with Julia.","page":"Using Valgrind with Julia"},{"title":"General considerations","location":"devdocs/valgrind.html#General-considerations","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"By default, Valgrind assumes that there is no self modifying code in the programs it runs.  This assumption works fine in most instances but fails miserably for a just-in-time compiler like julia.  For this reason it is crucial to pass --smc-check=all-non-file to valgrind, else code may crash or behave unexpectedly (often in subtle ways).","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"In some cases, to better detect memory errors using Valgrind, it can help to compile julia with memory pools disabled.  The compile-time flag MEMDEBUG disables memory pools in Julia, and MEMDEBUG2 disables memory pools in FemtoLisp.  To build julia with both flags, add the following line to Make.user:","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"CFLAGS = -DMEMDEBUG -DMEMDEBUG2","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Another thing to note: if your program uses multiple worker processes, it is likely that you want all such worker processes to run under Valgrind, not just the parent process.  To do this, pass --trace-children=yes to valgrind.","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Yet another thing to note: if using valgrind errors with Unable to find compatible target in system image, try rebuilding the sysimage with target generic or julia with JULIA_CPU_TARGET=generic.","page":"Using Valgrind with Julia"},{"title":"Suppressions","location":"devdocs/valgrind.html#Suppressions","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Valgrind will typically display spurious warnings as it runs.  To reduce the number of such warnings, it helps to provide a suppressions file to Valgrind.  A sample suppressions file is included in the Julia source distribution at contrib/valgrind-julia.supp.","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"The suppressions file can be used from the julia/ source directory as follows:","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"$ valgrind --smc-check=all-non-file --suppressions=contrib/valgrind-julia.supp ./julia progname.jl","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Any memory errors that are displayed should either be reported as bugs or contributed as additional suppressions.  Note that some versions of Valgrind are shipped with insufficient default suppressions, so that may be one thing to consider before submitting any bugs.","page":"Using Valgrind with Julia"},{"title":"Running the Julia test suite under Valgrind","location":"devdocs/valgrind.html#Running-the-Julia-test-suite-under-Valgrind","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"It is possible to run the entire Julia test suite under Valgrind, but it does take quite some time (typically several hours).  To do so, run the following command from the julia/test/ directory:","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"valgrind --smc-check=all-non-file --trace-children=yes --suppressions=$PWD/../contrib/valgrind-julia.supp ../julia runtests.jl all","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"If you would like to see a report of \"definite\" memory leaks, pass the flags --leak-check=full --show-leak-kinds=definite to valgrind as well.","page":"Using Valgrind with Julia"},{"title":"Additional spurious warnings","location":"devdocs/valgrind.html#Additional-spurious-warnings","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"This section covers Valgrind warnings that cannot be added to the suppressions file yet are nonetheless safe to ignore.","page":"Using Valgrind with Julia"},{"title":"Unhandled rr system calls","location":"devdocs/valgrind.html#Unhandled-rr-system-calls","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Valgrind will emit a warning if it encounters any of the system calls that are specific to rr, the Record and Replay Framework.  In particular, a warning about an unhandled 1008 syscall will be shown when julia tries to detect whether it is running under rr:","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"--xxxxxx-- WARNING: unhandled amd64-linux syscall: 1008\n--xxxxxx-- You may be able to write your own handler.\n--xxxxxx-- Read the file README_MISSING_SYSCALL_OR_IOCTL.\n--xxxxxx-- Nevertheless we consider this a bug.  Please report\n--xxxxxx-- it at http://valgrind.org/support/bug_reports.html.","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"This issue has been reported to the Valgrind developers as they have requested.","page":"Using Valgrind with Julia"},{"title":"Caveats","location":"devdocs/valgrind.html#Caveats","category":"section","text":"","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"Valgrind currently does not support multiple rounding modes, so code that adjusts the rounding mode will behave differently when run under Valgrind.","page":"Using Valgrind with Julia"},{"title":"Using Valgrind with Julia","location":"devdocs/valgrind.html","category":"page","text":"In general, if after setting --smc-check=all-non-file you find that your program behaves differently when run under Valgrind, it may help to pass --tool=none to valgrind as you investigate further.  This will enable the minimal Valgrind machinery but will also run much faster than when the full memory checker is enabled.","page":"Using Valgrind with Julia"},{"title":"Windows","location":"devdocs/build/windows.html#Windows","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"This file describes how to install, or build, and use Julia on Windows.","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"For more general information about Julia, please see the main README or the documentation.","page":"Windows"},{"title":"General Information for Windows","location":"devdocs/build/windows.html#General-Information-for-Windows","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"We highly recommend running Julia using a modern terminal application, in particular Windows Terminal, which can be installed from the Microsoft Store.","page":"Windows"},{"title":"Line endings","location":"devdocs/build/windows.html#Line-endings","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Julia uses binary-mode files exclusively. Unlike many other Windows programs, if you write \\n to a file, you get a \\n in the file, not some other bit pattern. This matches the behavior exhibited by other operating systems. If you have installed Git for Windows, it is suggested, but not required, that you configure your system Git to use the same convention:","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"git config --global core.eol lf\ngit config --global core.autocrlf input","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"or edit %USERPROFILE%\\.gitconfig and add/edit the lines:","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"[core]\n    eol = lf\n    autocrlf = input","page":"Windows"},{"title":"Binary distribution","location":"devdocs/build/windows.html#Binary-distribution","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"For the binary distribution installation notes on Windows please see the instructions at https://julialang.org/downloads/platform/#windows.","page":"Windows"},{"title":"Source distribution","location":"devdocs/build/windows.html#Source-distribution","category":"section","text":"","page":"Windows"},{"title":"Cygwin-to-MinGW cross-compiling","location":"devdocs/build/windows.html#Cygwin-to-MinGW-cross-compiling","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"The recommended way of compiling Julia from source on Windows is by cross compiling from Cygwin, using versions of the MinGW-w64 compilers available through Cygwin's package manager.","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Download and run Cygwin setup for 32 bit or 64 bit. Note, that you can compile either 32 or 64 bit Julia from either 32 or 64 bit Cygwin. 64 bit Cygwin has a slightly smaller but often more up-to-date selection of packages.\nAdvanced: you may skip steps 2-4 by running:\nsetup-x86_64.exe -s <url> -q -P cmake,gcc-g++,git,make,patch,curl,m4,python3,p7zip,mingw64-i686-gcc-g++,mingw64-i686-gcc-fortran,mingw64-x86_64-gcc-g++,mingw64-x86_64-gcc-fortran\nreplacing <url> with a site from https://cygwin.com/mirrors.html or run setup manually first and select a mirror.\nSelect installation location and a mirror to download from.\nAt the Select Packages step, select the following:\nFrom the Devel category: cmake, gcc-g++, git, make, patch\nFrom the Net category: curl\nFrom Interpreters (or Python) category: m4, python3\nFrom the Archive category: p7zip\nFor 32 bit Julia, and also from the Devel category:  mingw64-i686-gcc-g++ and mingw64-i686-gcc-fortran\nFor 64 bit Julia, and also from the Devel category:  mingw64-x86_64-gcc-g++ and mingw64-x86_64-gcc-fortran\nAllow Cygwin installation to finish, then start from the installed shortcut 'Cygwin Terminal', or 'Cygwin64 Terminal', respectively.\nBuild Julia and its dependencies from source:\nGet the Julia sources\ngit clone https://github.com/JuliaLang/julia.git\ncd julia\nTip: If you get an error: cannot fork() for fetch-pack: Resource temporarily unavailable from git, add alias git=\"env PATH=/usr/bin git\" to ~/.bashrc and restart Cygwin.\nSet the XC_HOST variable in Make.user to indicate MinGW-w64 cross compilation\necho 'XC_HOST = i686-w64-mingw32' > Make.user     # for 32 bit Julia\n# or\necho 'XC_HOST = x86_64-w64-mingw32' > Make.user   # for 64 bit Julia\nStart the build\nmake -j 4       # Adjust the number of threads (4) to match your build environment.\nmake -j 4 debug # This builds julia-debug.exe\nRun Julia using the Julia executables directly\nusr/bin/julia.exe\nusr/bin/julia-debug.exe","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"note: Pro tip: build both!\nmake O=julia-win32 configure\nmake O=julia-win64 configure\necho 'XC_HOST = i686-w64-mingw32' > julia-win32/Make.user\necho 'XC_HOST = x86_64-w64-mingw32' > julia-win64/Make.user\necho 'ifeq ($(BUILDROOT),$(JULIAHOME))\n        $(error \"in-tree build disabled\")\n      endif' >> Make.user\nmake -C julia-win32  # build for Windows x86 in julia-win32 folder\nmake -C julia-win64  # build for Windows x86-64 in julia-win64 folder","page":"Windows"},{"title":"Compiling with MinGW/MSYS2","location":"devdocs/build/windows.html#Compiling-with-MinGW/MSYS2","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"MSYS2 is a software distribution and build environment for Windows.","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Note: MSYS2 requires 64 bit Windows 7 or newer.","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Install and configure MSYS2.\nDownload and run the latest installer for the  64-bit distribution.  The installer will have a name like msys2-x86_64-yyyymmdd.exe.\nOpen the MSYS2 shell. Update the package database and base packages:\npacman -Syu\nExit and restart MSYS2. Update the rest of the base packages:\npacman -Syu\nThen install tools required to build julia:\npacman -S cmake diffutils git m4 make patch tar p7zip curl python\nFor 64 bit Julia, install the x86_64 version:\npacman -S mingw-w64-x86_64-gcc\nFor 32 bit Julia, install the i686 version:\npacman -S mingw-w64-i686-gcc\nConfiguration of MSYS2 is complete. Now exit the MSYS2 shell.\nBuild Julia and its dependencies with pre-build dependencies.\nOpen a new MINGW64/MINGW32 shell.  Currently we can't use both mingw32 and mingw64,  so if you want to build the x86_64 and i686 versions,  you'll need to build them in each environment separately.\nClone the Julia sources:\ngit clone https://github.com/JuliaLang/julia.git  cd julia\nStart the build\nmake -j$(nproc)","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"note: Pro tip: build in dir\nmake O=julia-mingw-w64 configure\necho 'ifeq ($(BUILDROOT),$(JULIAHOME))\n        $(error \"in-tree build disabled\")\n      endif' >> Make.user\nmake -C julia-mingw-w64","page":"Windows"},{"title":"Cross-compiling from Unix (Linux/Mac/WSL)","location":"devdocs/build/windows.html#Cross-compiling-from-Unix-(Linux/Mac/WSL)","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"You can also use MinGW-w64 cross compilers to build a Windows version of Julia from Linux, Mac, or the Windows Subsystem for Linux (WSL).","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"First, you will need to ensure your system has the required dependencies. We need wine (>=1.7.5), a system compiler, and some downloaders. Note: a Cygwin install might interfere with this method if using WSL.","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"On Ubuntu (on other Linux systems the dependency names are likely to be similar):","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"apt-get install wine-stable gcc wget p7zip-full winbind mingw-w64 gfortran-mingw-w64\ndpkg --add-architecture i386 && apt-get update && apt-get install wine32 # add sudo to each if needed\n# switch all of the following to their \"-posix\" variants (interactively):\nfor pkg in i686-w64-mingw32-g++ i686-w64-mingw32-gcc i686-w64-mingw32-gfortran x86_64-w64-mingw32-g++ x86_64-w64-mingw32-gcc x86_64-w64-mingw32-gfortran; do\n    sudo update-alternatives --config $pkg\ndone","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"On Mac: Install XCode, XCode command line tools, X11 (now XQuartz), and MacPorts or Homebrew.  Then run port install wine wget mingw-w64, or brew install wine wget mingw-w64, as appropriate.","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Then run the build:","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"git clone https://github.com/JuliaLang/julia.git julia-win32\ncd julia-win32\necho override XC_HOST = i686-w64-mingw32 >> Make.user\nmake\nmake win-extras (Necessary before running make binary-dist)\nmake binary-dist then make exe to create the Windows installer.\nmove the julia-*.exe installer to the target machine","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"If you are building for 64-bit Windows, the steps are essentially the same. Just replace i686 in XC_HOST with x86_64. (Note: on Mac, wine only runs in 32-bit mode).","page":"Windows"},{"title":"Debugging a cross-compiled build under wine","location":"devdocs/build/windows.html#Debugging-a-cross-compiled-build-under-wine","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"The most effective way to debug a cross-compiled version of Julia on the cross-compilation host is to install a Windows version of GDB and run it under wine as usual. The pre-built packages available as part of the MSYS2 project are known to work. Apart from the GDB package you may also need the python and termcap packages. Finally, GDB's prompt may not work when launched from the command line. This can be worked around by prepending wineconsole to the regular GDB invocation.","page":"Windows"},{"title":"After compiling","location":"devdocs/build/windows.html#After-compiling","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Compiling using one of the options above creates a basic Julia build, but not some extra components that are included if you run the full Julia binary installer. If you need these components, the easiest way to get them is to build the installer yourself using make win-extras followed by make binary-dist and make exe. Then run the resulting installer.","page":"Windows"},{"title":"Windows Build Debugging","location":"devdocs/build/windows.html#Windows-Build-Debugging","category":"section","text":"","page":"Windows"},{"title":"GDB hangs with Cygwin mintty","location":"devdocs/build/windows.html#GDB-hangs-with-Cygwin-mintty","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Run GDB under the Windows console (cmd) instead. GDB may not function properly under mintty with non- Cygwin applications. You can use cmd /c start to start the Windows console from mintty if necessary.","page":"Windows"},{"title":"GDB not attaching to the right process","location":"devdocs/build/windows.html#GDB-not-attaching-to-the-right-process","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Use the PID from the Windows task manager or WINPID from the ps command instead of the PID from unix-style command line tools (e.g. pgrep).  You may need to add the PID column if it is not shown by default in the Windows task manager.","page":"Windows"},{"title":"GDB not showing the right backtrace","location":"devdocs/build/windows.html#GDB-not-showing-the-right-backtrace","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"When attaching to the julia process, GDB may not be attaching to the right thread.  Use info threads command to show all the threads and thread <threadno> to switch threads.\nBe sure to use a 32 bit version of GDB to debug a 32 bit build of Julia, or a 64 bit version of GDB to debug a 64 bit build of Julia.","page":"Windows"},{"title":"Build process is slow/eats memory/hangs my computer","location":"devdocs/build/windows.html#Build-process-is-slow/eats-memory/hangs-my-computer","category":"section","text":"","page":"Windows"},{"title":"Windows","location":"devdocs/build/windows.html","category":"page","text":"Disable the Windows Superfetch and Program Compatibility Assistant services, as they are known to have spurious interactions with MinGW/Cygwin.\nAs mentioned in the link above: excessive memory use by svchost specifically may be investigated in the Task Manager by clicking on the high-memory svchost.exe process and selecting Go to Services. Disable child services one-by-one until a culprit is found.\nBeware of BLODA. The vmmap tool is indispensable for identifying such software conflicts. Use vmmap to inspect the list of loaded DLLs for bash, mintty, or another persistent process used to drive the build. Essentially any DLL outside of the Windows System directory is potential BLODA.","page":"Windows"},{"title":"Metaprogramming","location":"manual/metaprogramming.html#Metaprogramming","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The strongest legacy of Lisp in the Julia language is its metaprogramming support. Like Lisp, Julia represents its own code as a data structure of the language itself. Since code is represented by objects that can be created and manipulated from within the language, it is possible for a program to transform and generate its own code. This allows sophisticated code generation without extra build steps, and also allows true Lisp-style macros operating at the level of abstract syntax trees. In contrast, preprocessor \"macro\" systems, like that of C and C++, perform textual manipulation and substitution before any actual parsing or interpretation occurs. Because all data types and code in Julia are represented by Julia data structures, powerful reflection capabilities are available to explore the internals of a program and its types just like any other data.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"warning: Warning\nMetaprogramming is a powerful tool, but it introduces complexity that can make code more difficult to understand. For example, it can be surprisingly hard to get scope rules correct. Metaprogramming should typically be used only when other approaches such as higher order functions and closures cannot be applied.eval and defining new macros should be typically used as a last resort. It is almost never a good idea to use Meta.parse or convert an arbitrary string into Julia code. For manipulating Julia code, use the Expr data structure directly to avoid the complexity of how Julia syntax is parsed.The best uses of metaprogramming often implement most of their functionality in runtime helper functions, striving to minimize the amount of code they generate.","page":"Metaprogramming"},{"title":"Program representation","location":"manual/metaprogramming.html#Program-representation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Every Julia program starts life as a string:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> prog = \"1 + 1\"\n\"1 + 1\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"What happens next?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The next step is to parse each string into an object called an expression, represented by the Julia type Expr:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1 = Meta.parse(prog)\n:(1 + 1)\n\njulia> typeof(ex1)\nExpr","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expr objects contain two parts:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"a Symbol identifying the kind of expression. A symbol is an interned string identifier (more discussion below).","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1.head\n:call","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"the expression arguments, which may be symbols, other expressions, or literal values:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1.args\n3-element Vector{Any}:\n  :+\n 1\n 1","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expressions may also be constructed directly in prefix notation:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex2 = Expr(:call, :+, 1, 1)\n:(1 + 1)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The two expressions constructed above – by parsing and by direct construction – are equivalent:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1 == ex2\ntrue","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The key point here is that Julia code is internally represented as a data structure that is accessible from the language itself.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The dump function provides indented and annotated display of Expr objects:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> dump(ex2)\nExpr\n  head: Symbol call\n  args: Array{Any}((3,))\n    1: Symbol +\n    2: Int64 1\n    3: Int64 1","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expr objects may also be nested:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex3 = Meta.parse(\"(4 + 4) / 2\")\n:((4 + 4) / 2)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Another way to view expressions is with Meta.show_sexpr, which displays the S-expression form of a given Expr, which may look very familiar to users of Lisp. Here's an example illustrating the display on a nested Expr:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> Meta.show_sexpr(ex3)\n(:call, :/, (:call, :+, 4, 4), 2)","page":"Metaprogramming"},{"title":"Symbols","location":"manual/metaprogramming.html#Symbols","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The : character has two syntactic purposes in Julia. The first form creates a Symbol, an interned string used as one building-block of expressions, from valid identifiers:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> s = :foo\n:foo\n\njulia> typeof(s)\nSymbol","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The Symbol constructor takes any number of arguments and creates a new symbol by concatenating their string representations together:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> :foo === Symbol(\"foo\")\ntrue\n\njulia> Symbol(\"1foo\") # `:1foo` would not work, as `1foo` is not a valid identifier\nSymbol(\"1foo\")\n\njulia> Symbol(\"func\",10)\n:func10\n\njulia> Symbol(:var,'_',\"sym\")\n:var_sym","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In the context of an expression, symbols are used to indicate access to variables; when an expression is evaluated, a symbol is replaced with the value bound to that symbol in the appropriate scope.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Sometimes extra parentheses around the argument to : are needed to avoid ambiguity in parsing:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> :(:)\n:(:)\n\njulia> :(::)\n:(::)","page":"Metaprogramming"},{"title":"Expressions and evaluation","location":"manual/metaprogramming.html#Expressions-and-evaluation","category":"section","text":"","page":"Metaprogramming"},{"title":"Quoting","location":"manual/metaprogramming.html#Quoting","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The second syntactic purpose of the : character is to create expression objects without using the explicit Expr constructor. This is referred to as quoting. The : character, followed by paired parentheses around a single statement of Julia code, produces an Expr object based on the enclosed code. Here is an example of the short form used to quote an arithmetic expression:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = :(a+b*c+1)\n:(a + b * c + 1)\n\njulia> typeof(ex)\nExpr","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"(to view the structure of this expression, try ex.head and ex.args, or use dump as above or Meta.@dump)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that equivalent expressions may be constructed using Meta.parse or the direct Expr form:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia>      :(a + b*c + 1)       ==\n       Meta.parse(\"a + b*c + 1\") ==\n       Expr(:call, :+, :a, Expr(:call, :*, :b, :c), 1)\ntrue","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Expressions provided by the parser generally only have symbols, other expressions, and literal values as their args, whereas expressions constructed by Julia code can have arbitrary run-time values without literal forms as args. In this specific example, + and a are symbols, *(b,c) is a subexpression, and 1 is a literal 64-bit signed integer.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"There is a second syntactic form of quoting for multiple expressions: blocks of code enclosed in quote ... end.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = quote\n           x = 1\n           y = 2\n           x + y\n       end\nquote\n    #= none:2 =#\n    x = 1\n    #= none:3 =#\n    y = 2\n    #= none:4 =#\n    x + y\nend\n\njulia> typeof(ex)\nExpr","page":"Metaprogramming"},{"title":"Interpolation","location":"manual/metaprogramming.html#man-expression-interpolation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Direct construction of Expr objects with value arguments is powerful, but Expr constructors can be tedious compared to \"normal\" Julia syntax. As an alternative, Julia allows interpolation of literals or expressions into quoted expressions. Interpolation is indicated by a prefix $.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this example, the value of variable a is interpolated:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> a = 1;\n\njulia> ex = :($a + b)\n:(1 + b)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Interpolating into an unquoted expression is not supported and will cause a compile-time error:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> $a + b\nERROR: syntax: \"$\" expression outside quote","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this example, the tuple (1,2,3) is interpolated as an expression into a conditional test:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = :(a in $:((1,2,3)) )\n:(a in (1, 2, 3))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The use of $ for expression interpolation is intentionally reminiscent of string interpolation and command interpolation. Expression interpolation allows convenient, readable programmatic construction of complex Julia expressions.","page":"Metaprogramming"},{"title":"Splatting interpolation","location":"manual/metaprogramming.html#Splatting-interpolation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that the $ interpolation syntax allows inserting only a single expression into an enclosing expression. Occasionally, you have an array of expressions and need them all to become arguments of the surrounding expression. This can be done with the syntax $(xs...). For example, the following code generates a function call where the number of arguments is determined programmatically:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> args = [:x, :y, :z];\n\njulia> :(f(1, $(args...)))\n:(f(1, x, y, z))","page":"Metaprogramming"},{"title":"Nested quote","location":"manual/metaprogramming.html#Nested-quote","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Naturally, it is possible for quote expressions to contain other quote expressions. Understanding how interpolation works in these cases can be a bit tricky. Consider this example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> x = :(1 + 2);\n\njulia> e = quote quote $x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :x))\nend))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that the result contains $x, which means that x has not been evaluated yet. In other words, the $ expression \"belongs to\" the inner quote expression, and so its argument is only evaluated when the inner quote expression is:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    1 + 2\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However, the outer quote expression is able to interpolate values inside the $ in the inner quote. This is done with multiple $s:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> e = quote quote $$x end end\nquote\n    #= none:1 =#\n    $(Expr(:quote, quote\n    #= none:1 =#\n    $(Expr(:$, :(1 + 2)))\nend))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that (1 + 2) now appears in the result instead of the symbol x. Evaluating this expression yields an interpolated 3:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> eval(e)\nquote\n    #= none:1 =#\n    3\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The intuition behind this behavior is that x is evaluated once for each $: one $ works similarly to eval(:x), giving x's value, while two $s do the equivalent of eval(eval(:x)).","page":"Metaprogramming"},{"title":"QuoteNode","location":"manual/metaprogramming.html#man-quote-node","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The usual representation of a quote form in an AST is an Expr with head :quote:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> dump(Meta.parse(\":(1+2)\"))\nExpr\n  head: Symbol quote\n  args: Array{Any}((1,))\n    1: Expr\n      head: Symbol call\n      args: Array{Any}((3,))\n        1: Symbol +\n        2: Int64 1\n        3: Int64 2","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"As we have seen, such expressions support interpolation with $. However, in some situations it is necessary to quote code without performing interpolation. This kind of quoting does not yet have syntax, but is represented internally as an object of type QuoteNode:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> eval(Meta.quot(Expr(:$, :(1+2))))\n3\n\njulia> eval(QuoteNode(Expr(:$, :(1+2))))\n:($(Expr(:$, :(1 + 2))))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The parser yields QuoteNodes for simple quoted items like symbols:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> dump(Meta.parse(\":x\"))\nQuoteNode\n  value: Symbol x","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"QuoteNode can also be used for certain advanced metaprogramming tasks.","page":"Metaprogramming"},{"title":"Evaluating expressions","location":"manual/metaprogramming.html#Evaluating-expressions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Given an expression object, one can cause Julia to evaluate (execute) it at global scope using eval:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex1 = :(1 + 2)\n:(1 + 2)\n\njulia> eval(ex1)\n3\n\njulia> ex = :(a + b)\n:(a + b)\n\njulia> eval(ex)\nERROR: UndefVarError: `b` not defined in `Main`\n[...]\n\njulia> a = 1; b = 2;\n\njulia> eval(ex)\n3","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Every module has its own eval function that evaluates expressions in its global scope. Expressions passed to eval are not limited to returning values – they can also have side-effects that alter the state of the enclosing module's environment:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = :(x = 1)\n:(x = 1)\n\njulia> x\nERROR: UndefVarError: `x` not defined in `Main`\n\njulia> eval(ex)\n1\n\njulia> x\n1","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here, the evaluation of an expression object causes a value to be assigned to the global variable x.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Since expressions are just Expr objects which can be constructed programmatically and then evaluated, it is possible to dynamically generate arbitrary code which can then be run using eval. Here is a simple example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> a = 1;\n\njulia> ex = Expr(:call, :+, a, :b)\n:(1 + b)\n\njulia> a = 0; b = 2;\n\njulia> eval(ex)\n3","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The value of a is used to construct the expression ex which applies the + function to the value 1 and the variable b. Note the important distinction between the way a and b are used:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The value of the variable a at expression construction time is used as an immediate value in the expression. Thus, the value of a when the expression is evaluated no longer matters: the value in the expression is already 1, independent of whatever the value of a might be.\nOn the other hand, the symbol :b is used in the expression construction, so the value of the variable b at that time is irrelevant – :b is just a symbol and the variable b need not even be defined. At expression evaluation time, however, the value of the symbol :b is resolved by looking up the value of the variable b.","page":"Metaprogramming"},{"title":"Functions on Expressions","location":"manual/metaprogramming.html#Functions-on-Expressions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"As hinted above, one extremely useful feature of Julia is the capability to generate and manipulate Julia code within Julia itself. We have already seen one example of a function returning Expr objects: the Meta.parse function, which takes a string of Julia code and returns the corresponding Expr. A function can also take one or more Expr objects as arguments, and return another Expr. Here is a simple, motivating example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function math_expr(op, op1, op2)\n           expr = Expr(:call, op, op1, op2)\n           return expr\n       end\nmath_expr (generic function with 1 method)\n\njulia>  ex = math_expr(:+, 1, Expr(:call, :*, 4, 5))\n:(1 + 4 * 5)\n\njulia> eval(ex)\n21","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"As another example, here is a function that doubles any numeric argument, but leaves expressions alone:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function make_expr2(op, opr1, opr2)\n           opr1f, opr2f = map(x -> isa(x, Number) ? 2*x : x, (opr1, opr2))\n           retexpr = Expr(:call, op, opr1f, opr2f)\n           return retexpr\n       end\nmake_expr2 (generic function with 1 method)\n\njulia> make_expr2(:+, 1, 2)\n:(2 + 4)\n\njulia> ex = make_expr2(:+, 1, Expr(:call, :*, 5, 8))\n:(2 + 5 * 8)\n\njulia> eval(ex)\n42","page":"Metaprogramming"},{"title":"Macros","location":"manual/metaprogramming.html#man-macros","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros provide a mechanism to include generated code in the final body of a program. A macro maps a tuple of arguments to a returned expression, and the resulting expression is compiled directly rather than requiring a runtime eval call. Macro arguments may include expressions, literal values, and symbols.","page":"Metaprogramming"},{"title":"Basics","location":"manual/metaprogramming.html#Basics","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here is an extraordinarily simple macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro sayhello()\n           return :( println(\"Hello, world!\") )\n       end\n@sayhello (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros have a dedicated character in Julia's syntax: the @ (at-sign), followed by the unique name declared in a macro NAME ... end block. In this example, the compiler will replace all instances of @sayhello with:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":":( println(\"Hello, world!\") )","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"When @sayhello is entered in the REPL, the expression executes immediately, thus we only see the evaluation result:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @sayhello()\nHello, world!","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Now, consider a slightly more complex macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro sayhello(name)\n           return :( println(\"Hello, \", $name) )\n       end\n@sayhello (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This macro takes one argument: name. When @sayhello is encountered, the quoted expression is expanded to interpolate the value of the argument into the final expression:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @sayhello(\"human\")\nHello, human","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We can view the quoted return expression using the function macroexpand (important note: this is an extremely useful tool for debugging macros):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> ex = macroexpand(Main, :(@sayhello(\"human\")) )\n:(Main.println(\"Hello, \", \"human\"))\n\njulia> typeof(ex)\nExpr","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We can see that the \"human\" literal has been interpolated into the expression.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"There also exists a macro @macroexpand that is perhaps a bit more convenient than the macroexpand function:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @macroexpand @sayhello \"human\"\n:(println(\"Hello, \", \"human\"))","page":"Metaprogramming"},{"title":"Hold up: why macros?","location":"manual/metaprogramming.html#Hold-up:-why-macros?","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We have already seen a function f(::Expr...) -> Expr in a previous section. In fact, macroexpand is also such a function. So, why do macros exist?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros are necessary because they execute when code is parsed, therefore, macros allow the programmer to generate and include fragments of customized code before the full program is run. To illustrate the difference, consider the following example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro twostep(arg)\n           println(\"I execute at parse time. The argument is: \", arg)\n           return :(println(\"I execute at runtime. The argument is: \", $arg))\n       end\n@twostep (macro with 1 method)\n\njulia> ex = macroexpand(Main, :(@twostep :(1, 2, 3)) );\nI execute at parse time. The argument is: :((1, 2, 3))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The first call to println is executed when macroexpand is called. The resulting expression contains only the second println:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> typeof(ex)\nExpr\n\njulia> ex\n:(println(\"I execute at runtime. The argument is: \", $(Expr(:copyast, :($(QuoteNode(:((1, 2, 3)))))))))\n\njulia> eval(ex)\nI execute at runtime. The argument is: (1, 2, 3)","page":"Metaprogramming"},{"title":"Macro invocation","location":"manual/metaprogramming.html#Macro-invocation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros are invoked with the following general syntax:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@name expr1 expr2 ...\n@name(expr1, expr2, ...)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note the distinguishing @ before the macro name and the lack of commas between the argument expressions in the first form, and the lack of whitespace after @name in the second form. The two styles should not be mixed. For example, the following syntax is different from the examples above; it passes the tuple (expr1, expr2, ...) as one argument to the macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@name (expr1, expr2, ...)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An alternative way to invoke a macro over an array literal (or comprehension) is to juxtapose both without using parentheses. In this case, the array will be the only expression fed to the macro. The following syntax is equivalent (and different from @name [a b] * v):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@name[a b] * v\n@name([a b]) * v","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"It is important to emphasize that macros receive their arguments as expressions, literals, or symbols. One way to explore macro arguments is to call the show function within the macro body:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro showarg(x)\n           show(x)\n           # ... remainder of macro, returning an expression\n       end\n@showarg (macro with 1 method)\n\njulia> @showarg(a)\n:a\n\njulia> @showarg(1+1)\n:(1 + 1)\n\njulia> @showarg(println(\"Yo!\"))\n:(println(\"Yo!\"))\n\njulia> @showarg(1)        # Numeric literal\n1\n\njulia> @showarg(\"Yo!\")    # String literal\n\"Yo!\"\n\njulia> @showarg(\"Yo! $(\"hello\")\")    # String with interpolation is an Expr rather than a String\n:(\"Yo! $(\"hello\")\")","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In addition to the given argument list, every macro is passed extra arguments named __source__ and __module__.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The argument __source__ provides information (in the form of a LineNumberNode object) about the parser location of the @ sign from the macro invocation. This allows macros to include better error diagnostic information, and is commonly used by logging, string-parser macros, and docs, for example, as well as to implement the @__LINE__, @__FILE__, and @__DIR__ macros.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The location information can be accessed by referencing __source__.line and __source__.file:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro __LOCATION__(); return QuoteNode(__source__); end\n@__LOCATION__ (macro with 1 method)\n\njulia> dump(\n            @__LOCATION__(\n       ))\nLineNumberNode\n  line: Int64 2\n  file: Symbol none","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The argument __module__ provides information (in the form of a Module object) about the expansion context of the macro invocation. This allows macros to look up contextual information, such as existing bindings, or to insert the value as an extra argument to a runtime function call doing self-reflection in the current module.","page":"Metaprogramming"},{"title":"Building an advanced macro","location":"manual/metaprogramming.html#Building-an-advanced-macro","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here is a simplified definition of Julia's @assert macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro assert(ex)\n           return :( $ex ? nothing : throw(AssertionError($(string(ex)))) )\n       end\n@assert (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This macro can be used like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @assert 1 == 1.0\n\njulia> @assert 1 == 0\nERROR: AssertionError: 1 == 0","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In place of the written syntax, the macro call is expanded at parse time to its returned result. This is equivalent to writing:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"1 == 1.0 ? nothing : throw(AssertionError(\"1 == 1.0\"))\n1 == 0 ? nothing : throw(AssertionError(\"1 == 0\"))","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"That is, in the first call, the expression :(1 == 1.0) is spliced into the test condition slot, while the value of string(:(1 == 1.0)) is spliced into the assertion message slot. The entire expression, thus constructed, is placed into the syntax tree where the @assert macro call occurs. Then at execution time, if the test expression evaluates to true, then nothing is returned, whereas if the test is false, an error is raised indicating the asserted expression that was false. Notice that it would not be possible to write this as a function, since only the value of the condition is available and it would be impossible to display the expression that computed it in the error message.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The actual definition of @assert in Julia Base is more complicated. It allows the user to optionally specify their own error message, instead of just printing the failed expression. Just like in functions with a variable number of arguments (Varargs Functions), this is specified with an ellipses following the last argument:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro assert(ex, msgs...)\n           msg_body = isempty(msgs) ? ex : msgs[1]\n           msg = string(msg_body)\n           return :($ex ? nothing : throw(AssertionError($msg)))\n       end\n@assert (macro with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Now @assert has two modes of operation, depending upon the number of arguments it receives! If there's only one argument, the tuple of expressions captured by msgs will be empty and it will behave the same as the simpler definition above. But now if the user specifies a second argument, it is printed in the message body instead of the failing expression. You can inspect the result of a macro expansion with the aptly named @macroexpand macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @macroexpand @assert a == b\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a == b\"))\n    end)\n\njulia> @macroexpand @assert a==b \"a should equal b!\"\n:(if Main.a == Main.b\n        Main.nothing\n    else\n        Main.throw(Main.AssertionError(\"a should equal b!\"))\n    end)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"There is yet another case that the actual @assert macro handles: what if, in addition to printing \"a should equal b,\" we wanted to print their values? One might naively try to use string interpolation in the custom message, e.g., @assert a==b \"a ($a) should equal b ($b)!\", but this won't work as expected with the above macro. Can you see why? Recall from string interpolation that an interpolated string is rewritten to a call to string. Compare:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> typeof(:(\"a should equal b\"))\nString\n\njulia> typeof(:(\"a ($a) should equal b ($b)!\"))\nExpr\n\njulia> dump(:(\"a ($a) should equal b ($b)!\"))\nExpr\n  head: Symbol string\n  args: Array{Any}((5,))\n    1: String \"a (\"\n    2: Symbol a\n    3: String \") should equal b (\"\n    4: Symbol b\n    5: String \")!\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"So now instead of getting a plain string in msg_body, the macro is receiving a full expression that will need to be evaluated in order to display as expected. This can be spliced directly into the returned expression as an argument to the string call; see error.jl for the complete implementation.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The @assert macro makes great use of splicing into quoted expressions to simplify the manipulation of expressions inside the macro body.","page":"Metaprogramming"},{"title":"Hygiene","location":"manual/metaprogramming.html#Hygiene","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An issue that arises in more complex macros is that of hygiene. In short, macros must ensure that the variables they introduce in their returned expressions do not accidentally clash with existing variables in the surrounding code they expand into. Conversely, the expressions that are passed into a macro as arguments are often expected to evaluate in the context of the surrounding code, interacting with and modifying the existing variables. Another concern arises from the fact that a macro may be called in a different module from where it was defined. In this case we need to ensure that all global variables are resolved to the correct module. Julia already has a major advantage over languages with textual macro expansion (like C) in that it only needs to consider the returned expression. All the other variables (such as msg in @assert above) follow the normal scoping block behavior.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"To demonstrate these issues, let us consider writing a @time macro that takes an expression as its argument, records the time, evaluates the expression, records the time again, prints the difference between the before and after times, and then has the value of the expression as its final value. The macro might look like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro time(ex)\n    return quote\n        local t0 = time_ns()\n        local val = $ex\n        local t1 = time_ns()\n        println(\"elapsed time: \", (t1-t0)/1e9, \" seconds\")\n        val\n    end\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here, we want t0, t1, and val to be private temporary variables, and we want time_ns to refer to the time_ns function in Julia Base, not to any time_ns variable the user might have (the same applies to println). Imagine the problems that could occur if the user expression ex also contained assignments to a variable called t0, or defined its own time_ns variable. We might get errors, or mysteriously incorrect behavior.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Julia's macro expander solves these problems in the following way. First, variables within a macro result are classified as either local or global. A variable is considered local if it is assigned to (and not declared global), declared local, or used as a function argument name. Otherwise, it is considered global. Local variables are then renamed to be unique (using the gensym function, which generates new symbols), and global variables are resolved within the macro definition environment. Therefore both of the above concerns are handled; the macro's locals will not conflict with any user variables, and time_ns and println will refer to the Julia Base definitions.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"One problem remains however. Consider the following use of this macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"module MyModule\nimport Base.@time\n\ntime_ns() = ... # compute something\n\n@time time_ns()\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Here the user expression ex is a call to time_ns, but not the same time_ns function that the macro uses. It clearly refers to MyModule.time_ns. Therefore we must arrange for the code in ex to be resolved in the macro call environment. This is done by \"escaping\" the expression with esc:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro time(ex)\n    ...\n    local val = $(esc(ex))\n    ...\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An expression wrapped in this manner is left alone by the macro expander and simply pasted into the output verbatim. Therefore it will be resolved in the macro call environment.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This escaping mechanism can be used to \"violate\" hygiene when necessary, in order to introduce or manipulate user variables. For example, the following macro sets x to zero in the call environment:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro zerox()\n           return esc(:(x = 0))\n       end\n@zerox (macro with 1 method)\n\njulia> function foo()\n           x = 1\n           @zerox\n           return x # is zero\n       end\nfoo (generic function with 1 method)\n\njulia> foo()\n0","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This kind of manipulation of variables should be used judiciously, but is occasionally quite handy.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Getting the hygiene rules correct can be a formidable challenge. Before using a macro, you might want to consider whether a function closure would be sufficient. Another useful strategy is to defer as much work as possible to runtime. For example, many macros simply wrap their arguments in a QuoteNode or other similar Expr. Some examples of this include @task body which simply returns schedule(Task(() -> $body)), and @eval expr, which simply returns eval(QuoteNode(expr)).","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"To demonstrate, we might rewrite the @time example above as:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro time(expr)\n    return :(timeit(() -> $(esc(expr))))\nend\nfunction timeit(f)\n    t0 = time_ns()\n    val = f()\n    t1 = time_ns()\n    println(\"elapsed time: \", (t1-t0)/1e9, \" seconds\")\n    return val\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However, we don't do this for a good reason: wrapping the expr in a new scope block (the anonymous function) also slightly changes the meaning of the expression (the scope of any variables in it), while we want @time to be usable with minimum impact on the wrapped code.","page":"Metaprogramming"},{"title":"Macros and dispatch","location":"manual/metaprogramming.html#Macros-and-dispatch","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Macros, just like Julia functions, are generic. This means they can also have multiple method definitions, thanks to multiple dispatch:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro m end\n@m (macro with 0 methods)\n\njulia> macro m(args...)\n           println(\"$(length(args)) arguments\")\n       end\n@m (macro with 1 method)\n\njulia> macro m(x,y)\n           println(\"Two arguments\")\n       end\n@m (macro with 2 methods)\n\njulia> @m \"asd\"\n1 arguments\n\njulia> @m 1 2\nTwo arguments","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However one should keep in mind, that macro dispatch is based on the types of AST that are handed to the macro, not the types that the AST evaluates to at runtime:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> macro m(::Int)\n           println(\"An Integer\")\n       end\n@m (macro with 3 methods)\n\njulia> @m 2\nAn Integer\n\njulia> x = 2\n2\n\njulia> @m x\n1 arguments","page":"Metaprogramming"},{"title":"Code Generation","location":"manual/metaprogramming.html#Code-Generation","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"When a significant amount of repetitive boilerplate code is required, it is common to generate it programmatically to avoid redundancy. In most languages, this requires an extra build step, and a separate program to generate the repetitive code. In Julia, expression interpolation and eval allow such code generation to take place in the normal course of program execution. For example, consider the following custom type","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"struct MyNumber\n    x::Float64\nend\n# output\n","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for which we want to add a number of methods to. We can do this programmatically in the following loop:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(quote\n        Base.$op(a::MyNumber) = MyNumber($op(a.x))\n    end)\nend\n# output\n","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"and we can now use those functions with our custom type:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> x = MyNumber(π)\nMyNumber(3.141592653589793)\n\njulia> sin(x)\nMyNumber(1.2246467991473532e-16)\n\njulia> cos(x)\nMyNumber(-1.0)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this manner, Julia acts as its own preprocessor, and allows code generation from inside the language. The above code could be written slightly more tersely using the : prefix quoting form:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    eval(:(Base.$op(a::MyNumber) = MyNumber($op(a.x))))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This sort of in-language code generation, however, using the eval(quote(...)) pattern, is common enough that Julia comes with a macro to abbreviate this pattern:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for op = (:sin, :cos, :tan, :log, :exp)\n    @eval Base.$op(a::MyNumber) = MyNumber($op(a.x))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The @eval macro rewrites this call to be precisely equivalent to the above longer versions. For longer blocks of generated code, the expression argument given to @eval can be a block:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"@eval begin\n    # multiple lines\nend","page":"Metaprogramming"},{"title":"Non-Standard String Literals","location":"manual/metaprogramming.html#meta-non-standard-string-literals","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Recall from Strings that string literals prefixed by an identifier are called non-standard string literals, and can have different semantics than un-prefixed string literals. For example:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"r\"^\\s*(?:#|$)\" produces a regular expression object rather than a string\nb\"DATA\\xff\\u2200\" is a byte array literal for [68,65,84,65,255,226,136,128].","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Perhaps surprisingly, these behaviors are not hard-coded into the Julia parser or compiler. Instead, they are custom behaviors provided by a general mechanism that anyone can use: prefixed string literals are parsed as calls to specially-named macros. For example, the regular expression macro is just the following:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro r_str(p)\n    Regex(p)\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"That's all. This macro says that the literal contents of the string literal r\"^\\s*(?:#|$)\" should be passed to the @r_str macro and the result of that expansion should be placed in the syntax tree where the string literal occurs. In other words, the expression r\"^\\s*(?:#|$)\" is equivalent to placing the following object directly into the syntax tree:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Regex(\"^\\\\s*(?:#|\\$)\")","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Not only is the string literal form shorter and far more convenient, but it is also more efficient: since the regular expression is compiled and the Regex object is actually created when the code is compiled, the compilation occurs only once, rather than every time the code is executed. Consider if the regular expression occurs in a loop:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"for line = lines\n    m = match(r\"^\\s*(?:#|$)\", line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Since the regular expression r\"^\\s*(?:#|$)\" is compiled and inserted into the syntax tree when this code is parsed, the expression is only compiled once instead of each time the loop is executed. In order to accomplish this without macros, one would have to write this loop like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"re = Regex(\"^\\\\s*(?:#|\\$)\")\nfor line = lines\n    m = match(re, line)\n    if m === nothing\n        # non-comment\n    else\n        # comment\n    end\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Moreover, if the compiler could not determine that the regex object was constant over all loops, certain optimizations might not be possible, making this version still less efficient than the more convenient literal form above. Of course, there are still situations where the non-literal form is more convenient: if one needs to interpolate a variable into the regular expression, one must take this more verbose approach; in cases where the regular expression pattern itself is dynamic, potentially changing upon each loop iteration, a new regular expression object must be constructed on each iteration. In the vast majority of use cases, however, regular expressions are not constructed based on run-time data. In this majority of cases, the ability to write regular expressions as compile-time values is invaluable.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The mechanism for user-defined string literals is deeply, profoundly powerful. Not only are Julia's non-standard literals implemented using it, but the command literal syntax (`echo \"Hello, $person\"`) is also implemented using the following innocuous-looking macro:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro cmd(str)\n    :(cmd_gen($(shell_parse(str)[1])))\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Of course, a large amount of complexity is hidden in the functions used in this macro definition, but they are just functions, written entirely in Julia. You can read their source and see precisely what they do – and all they do is construct expression objects to be inserted into your program's syntax tree.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Like string literals, command literals can also be prefixed by an identifier to form what are called non-standard command literals. These command literals are parsed as calls to specially-named macros. For example, the syntax custom`literal` is parsed as @custom_cmd \"literal\". Julia itself does not contain any non-standard command literals, but packages can make use of this syntax. Aside from the different syntax and the _cmd suffix instead of the _str suffix, non-standard command literals behave exactly like non-standard string literals.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In the event that two modules provide non-standard string or command literals with the same name, it is possible to qualify the string or command literal with a module name. For instance, if both Foo and Bar provide non-standard string literal @x_str, then one can write Foo.x\"literal\" or Bar.x\"literal\" to disambiguate between the two.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Another way to define a macro would be like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"macro foo_str(str, flag)\n    # do stuff\nend","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"This macro can then be called with the following syntax:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"foo\"str\"flag","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The type of flag in the above mentioned syntax would be a String with contents of whatever trails after the string literal.","page":"Metaprogramming"},{"title":"Generated functions","location":"manual/metaprogramming.html#Generated-functions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"A very special macro is @generated, which allows you to define so-called generated functions. These have the capability to generate specialized code depending on the types of their arguments with more flexibility and/or less code than what can be achieved with multiple dispatch. While macros work with expressions at parse time and cannot access the types of their inputs, a generated function gets expanded at a time when the types of the arguments are known, but the function is not yet compiled.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Instead of performing some calculation or action, a generated function declaration returns a quoted expression which then forms the body for the method corresponding to the types of the arguments. When a generated function is called, the expression it returns is compiled and then run. To make this efficient, the result is usually cached. And to make this inferable, only a limited subset of the language is usable. Thus, generated functions provide a flexible way to move work from run time to compile time, at the expense of greater restrictions on allowed constructs.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"When defining generated functions, there are five main differences to ordinary functions:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"You annotate the function declaration with the @generated macro. This adds some information to the AST that lets the compiler know that this is a generated function.\nIn the body of the generated function you only have access to the types of the arguments – not their values.\nInstead of calculating something or performing some action, you return a quoted expression which, when evaluated, does what you want.\nGenerated functions are only permitted to call functions that were defined before the definition of the generated function. (Failure to follow this may result in getting MethodErrors referring to functions from a future world-age.)\nGenerated functions must not mutate or observe any non-constant global state (including, for example, IO, locks, non-local dictionaries, or using hasmethod). This means they can only read global constants, and cannot have any side effects. In other words, they must be completely pure. Due to an implementation limitation, this also means that they currently cannot define a closure or generator.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"It's easiest to illustrate this with an example. We can declare a generated function foo as","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function foo(x)\n           Core.println(x)\n           return :(x * x)\n       end\nfoo (generic function with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that the body returns a quoted expression, namely :(x * x), rather than just the value of x * x.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"From the caller's perspective, this is identical to a regular function; in fact, you don't have to know whether you're calling a regular or generated function. Let's see how foo behaves:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> x = foo(2); # note: output is from println() statement in the body\nInt64\n\njulia> x           # now we print x\n4\n\njulia> y = foo(\"bar\");\nString\n\njulia> y\n\"barbar\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"So, we see that in the body of the generated function, x is the type of the passed argument, and the value returned by the generated function, is the result of evaluating the quoted expression we returned from the definition, now with the value of x.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"What happens if we evaluate foo again with a type that we have already used?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> foo(4)\n16","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that there is no printout of Int64. We can see that the body of the generated function was only executed once here, for the specific set of argument types, and the result was cached. After that, for this example, the expression returned from the generated function on the first invocation was re-used as the method body. However, the actual caching behavior is an implementation-defined performance optimization, so it is invalid to depend too closely on this behavior.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The number of times a generated function is generated might be only once, but it might also be more often, or appear to not happen at all. As a consequence, you should never write a generated function with side effects - when, and how often, the side effects occur is undefined. (This is true for macros too - and just like for macros, the use of eval in a generated function is a sign that you're doing something the wrong way.) However, unlike macros, the runtime system cannot correctly handle a call to eval, so it is disallowed.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"It is also important to see how @generated functions interact with method redefinition. Following the principle that a correct @generated function must not observe any mutable state or cause any mutation of global state, we see the following behavior. Observe that the generated function cannot call any method that was not defined prior to the definition of the generated function itself.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Initially f(x) has one definition","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> f(x) = \"original definition\";","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Define other operations that use f(x):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> g(x) = f(x);\n\njulia> @generated gen1(x) = f(x);\n\njulia> @generated gen2(x) = :(f(x));","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We now add some new definitions for f(x):","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> f(x::Int) = \"definition for Int\";\n\njulia> f(x::Type{Int}) = \"definition for Type{Int}\";","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"and compare how these results differ:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> f(1)\n\"definition for Int\"\n\njulia> g(1)\n\"definition for Int\"\n\njulia> gen1(1)\n\"original definition\"\n\njulia> gen2(1)\n\"definition for Int\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Each method of a generated function has its own view of defined functions:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated gen1(x::Real) = f(x);\n\njulia> gen1(1)\n\"definition for Type{Int}\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The example generated function foo above did not do anything a normal function foo(x) = x * x could not do (except printing the type on the first invocation, and incurring higher overhead). However, the power of a generated function lies in its ability to compute different quoted expressions depending on the types passed to it:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function bar(x)\n           if x <: Integer\n               return :(x ^ 2)\n           else\n               return :(x)\n           end\n       end\nbar (generic function with 1 method)\n\njulia> bar(4)\n16\n\njulia> bar(\"baz\")\n\"baz\"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"(although of course this contrived example would be more easily implemented using multiple dispatch...)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Abusing this will corrupt the runtime system and cause undefined behavior:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function baz(x)\n           if rand() < .9\n               return :(x^2)\n           else\n               return :(\"boo!\")\n           end\n       end\nbaz (generic function with 1 method)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Since the body of the generated function is non-deterministic, its behavior, and the behavior of all subsequent code is undefined.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Don't copy these examples!","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"These examples are hopefully helpful to illustrate how generated functions work, both in the definition end and at the call site; however, don't copy them, for the following reasons:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"the foo function has side-effects (the call to Core.println), and it is undefined exactly when, how often or how many times these side-effects will occur\nthe bar function solves a problem that is better solved with multiple dispatch - defining bar(x) = x and bar(x::Integer) = x ^ 2 will do the same thing, but it is both simpler and faster.\nthe baz function is pathological","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Note that the set of operations that should not be attempted in a generated function is unbounded, and the runtime system can currently only detect a subset of the invalid operations. There are many other operations that will simply corrupt the runtime system without notification, usually in subtle ways not obviously connected to the bad definition. Because the function generator is run during inference, it must respect all of the limitations of that code.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Some operations that should not be attempted include:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Caching of native pointers.\nInteracting with the contents or methods of Core.Compiler in any way.\nObserving any mutable state.\nInference on the generated function may be run at any time, including while your code is attempting to observe or mutate this state.\nTaking any locks: C code you call out to may use locks internally, (for example, it is not problematic to call malloc, even though most implementations require locks internally) but don't attempt to hold or acquire any while executing Julia code.\nCalling any function that is defined after the body of the generated function. This condition is relaxed for incrementally-loaded precompiled modules to allow calling any function in the module.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Alright, now that we have a better understanding of how generated functions work, let's use them to build some more advanced (and valid) functionality...","page":"Metaprogramming"},{"title":"An advanced example","location":"manual/metaprogramming.html#An-advanced-example","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Julia's base library has an internal sub2ind function to calculate a linear index into an n-dimensional array, based on a set of n multilinear indices - in other words, to calculate the index i that can be used to index into an array A using A[i], instead of A[x,y,z,...]. One possible implementation is the following:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function sub2ind_loop(dims::NTuple{N}, I::Integer...) where N\n           ind = I[N] - 1\n           for i = N-1:-1:1\n               ind = I[i]-1 + dims[i]*ind\n           end\n           return ind + 1\n       end;\n\njulia> sub2ind_loop((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"The same thing can be done using recursion:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> sub2ind_rec(dims::Tuple{}) = 1;\n\njulia> sub2ind_rec(dims::Tuple{}, i1::Integer, I::Integer...) =\n           i1 == 1 ? sub2ind_rec(dims, I...) : throw(BoundsError());\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer) = i1;\n\njulia> sub2ind_rec(dims::Tuple{Integer, Vararg{Integer}}, i1::Integer, I::Integer...) =\n           i1 + dims[1] * (sub2ind_rec(Base.tail(dims), I...) - 1);\n\njulia> sub2ind_rec((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Both these implementations, although different, do essentially the same thing: a runtime loop over the dimensions of the array, collecting the offset in each dimension into the final index.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"However, all the information we need for the loop is embedded in the type information of the arguments. This allows the compiler to move the iteration to compile time and eliminate the runtime loops altogether. We can utilize generated functions to achieve a similar effect; in compiler parlance, we use generated functions to manually unroll the loop. The body becomes almost identical, but instead of calculating the linear index, we build up an expression that calculates the index:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end;\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"What code will this generate?","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"An easy way to find out is to extract the body into another (regular) function:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function sub2ind_gen_impl(dims::Type{T}, I...) where T <: NTuple{N,Any} where N\n           length(I) == N || return :(error(\"partial indexing is unsupported\"))\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end;\n\njulia> @generated function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           return sub2ind_gen_impl(dims, I...)\n       end;\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"We can now execute sub2ind_gen_impl and examine the expression it returns:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> sub2ind_gen_impl(Tuple{Int,Int}, Int, Int)\n:(((I[1] - 1) + dims[1] * (I[2] - 1)) + 1)","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"So, the method body that will be used here doesn't include a loop at all - just indexing into the two tuples, multiplication and addition/subtraction. All the looping is performed compile-time, and we avoid looping during execution entirely. Thus, we only loop once per type, in this case once per N (except in edge cases where the function is generated more than once - see disclaimer above).","page":"Metaprogramming"},{"title":"Optionally-generated functions","location":"manual/metaprogramming.html#Optionally-generated-functions","category":"section","text":"","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Generated functions can achieve high efficiency at run time, but come with a compile time cost: a new function body must be generated for every combination of concrete argument types. Typically, Julia is able to compile \"generic\" versions of functions that will work for any arguments, but with generated functions this is impossible. This means that programs making heavy use of generated functions might be impossible to statically compile.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"To solve this problem, the language provides syntax for writing normal, non-generated alternative implementations of generated functions. Applied to the sub2ind example above, it would look like this:","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"julia> function sub2ind_gen_impl(dims::Type{T}, I...) where T <: NTuple{N,Any} where N\n           ex = :(I[$N] - 1)\n           for i = (N - 1):-1:1\n               ex = :(I[$i] - 1 + dims[$i] * $ex)\n           end\n           return :($ex + 1)\n       end;\n\njulia> function sub2ind_gen_fallback(dims::NTuple{N}, I) where N\n           ind = I[N] - 1\n           for i = (N - 1):-1:1\n               ind = I[i] - 1 + dims[i]*ind\n           end\n           return ind + 1\n       end;\n\njulia> function sub2ind_gen(dims::NTuple{N}, I::Integer...) where N\n           length(I) == N || error(\"partial indexing is unsupported\")\n           if @generated\n               return sub2ind_gen_impl(dims, I...)\n           else\n               return sub2ind_gen_fallback(dims, I)\n           end\n       end;\n\njulia> sub2ind_gen((3, 5), 1, 2)\n4","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Internally, this code creates two implementations of the function: a generated one where the first block in if @generated is used, and a normal one where the else block is used. Inside the then part of the if @generated block, code has the same semantics as other generated functions: argument names refer to types, and the code should return an expression. Multiple if @generated blocks may occur, in which case the generated implementation uses all of the then blocks and the alternate implementation uses all of the else blocks.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"Notice that we added an error check to the top of the function. This code will be common to both versions, and is run-time code in both versions (it will be quoted and returned as an expression from the generated version). That means that the values and types of local variables are not available at code generation time –- the code-generation code can only see the types of arguments.","page":"Metaprogramming"},{"title":"Metaprogramming","location":"manual/metaprogramming.html","category":"page","text":"In this style of definition, the code generation feature is essentially an optional optimization. The compiler will use it if convenient, but otherwise may choose to use the normal implementation instead. This style is preferred, since it allows the compiler to make more decisions and compile programs in more ways, and since normal code is more readable than code-generating code. However, which implementation is used depends on compiler implementation details, so it is essential for the two implementations to behave identically.","page":"Metaprogramming"},{"title":"Network Options","location":"stdlib/NetworkOptions.html#Network-Options","category":"section","text":"","page":"Network Options"},{"title":"Network Options","location":"stdlib/NetworkOptions.html","category":"page","text":"NetworkOptions.ca_roots\nNetworkOptions.ca_roots_path\nNetworkOptions.ssh_dir\nNetworkOptions.ssh_key_pass\nNetworkOptions.ssh_key_name\nNetworkOptions.ssh_key_path\nNetworkOptions.ssh_pub_key_path\nNetworkOptions.ssh_known_hosts_files\nNetworkOptions.ssh_known_hosts_file\nNetworkOptions.verify_host","page":"Network Options"},{"title":"NetworkOptions.ca_roots","location":"stdlib/NetworkOptions.html#NetworkOptions.ca_roots","category":"function","text":"ca_roots() :: Union{Nothing, String}\n\nThe ca_roots() function tells the caller where, if anywhere, to find a file or directory of PEM-encoded certificate authority roots. By default, on systems like Windows and macOS where the built-in TLS engines know how to verify hosts using the system's built-in certificate verification mechanism, this function will return nothing. On classic UNIX systems (excluding macOS), root certificates are typically stored in a file in /etc: the common places for the current UNIX system will be searched and if one of these paths exists, it will be returned; if none of these typical root certificate paths exist, then the path to the set of root certificates that are bundled with Julia is returned.\n\nThe default value returned by ca_roots() may be overridden by setting the JULIA_SSL_CA_ROOTS_PATH, SSL_CERT_DIR, or SSL_CERT_FILE environment variables, in which case this function will always return the value of the first of these variables that is set (whether the path exists or not). If JULIA_SSL_CA_ROOTS_PATH is set to the empty string, then the other variables are ignored (as if unset); if the other variables are set to the empty string, they behave is if they are not set.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ca_roots_path","location":"stdlib/NetworkOptions.html#NetworkOptions.ca_roots_path","category":"function","text":"ca_roots_path() :: String\n\nThe ca_roots_path() function is similar to the ca_roots() function except that it always returns a path to a file or directory of PEM-encoded certificate authority roots. When called on a system like Windows or macOS, where system root certificates are not stored in the file system, it will currently return the path to the set of root certificates that are bundled with Julia. (In the future, this function may instead extract the root certificates from the system and save them to a file whose path would be returned.)\n\nIf it is possible to configure a library that uses TLS to use the system certificates that is generally preferable: i.e. it is better to use ca_roots() which returns nothing to indicate that the system certs should be used. The ca_roots_path() function should only be used when configuring libraries which require a path to a file or directory for root certificates.\n\nThe default value returned by ca_roots_path() may be overridden by setting the JULIA_SSL_CA_ROOTS_PATH, SSL_CERT_DIR, or SSL_CERT_FILE environment variables, in which case this function will always return the value of the first of these variables that is set (whether the path exists or not). If JULIA_SSL_CA_ROOTS_PATH is set to the empty string, then the other variables are ignored (as if unset); if the other variables are set to the empty string, they behave is if they are not set.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ssh_dir","location":"stdlib/NetworkOptions.html#NetworkOptions.ssh_dir","category":"function","text":"ssh_dir() :: String\n\nThe ssh_dir() function returns the location of the directory where the ssh program keeps/looks for configuration files. By default this is ~/.ssh but this can be overridden by setting the environment variable SSH_DIR.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ssh_key_pass","location":"stdlib/NetworkOptions.html#NetworkOptions.ssh_key_pass","category":"function","text":"ssh_key_pass() :: String\n\nThe ssh_key_pass() function returns the value of the environment variable SSH_KEY_PASS if it is set or nothing if it is not set. In the future, this may be able to find a password by other means, such as secure system storage, so packages that need a password to decrypt an SSH private key should use this API instead of directly checking the environment variable so that they gain such capabilities automatically when they are added.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ssh_key_name","location":"stdlib/NetworkOptions.html#NetworkOptions.ssh_key_name","category":"function","text":"ssh_key_name() :: String\n\nThe ssh_key_name() function returns the base name of key files that SSH should use for when establishing a connection. There is usually no reason that this function should be called directly and libraries should generally use the ssh_key_path and ssh_pub_key_path functions to get full paths. If the environment variable SSH_KEY_NAME is set then this function returns that; otherwise it returns id_rsa by default.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ssh_key_path","location":"stdlib/NetworkOptions.html#NetworkOptions.ssh_key_path","category":"function","text":"ssh_key_path() :: String\n\nThe ssh_key_path() function returns the path of the SSH private key file that should be used for SSH connections. If the SSH_KEY_PATH environment variable is set then it will return that value. Otherwise it defaults to returning\n\njoinpath(ssh_dir(), ssh_key_name())\n\nThis default value in turn depends on the SSH_DIR and SSH_KEY_NAME environment variables.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ssh_pub_key_path","location":"stdlib/NetworkOptions.html#NetworkOptions.ssh_pub_key_path","category":"function","text":"ssh_pub_key_path() :: String\n\nThe ssh_pub_key_path() function returns the path of the SSH public key file that should be used for SSH connections. If the SSH_PUB_KEY_PATH environment variable is set then it will return that value. If that isn't set but SSH_KEY_PATH is set, it will return that path with the .pub suffix appended. If neither is set, it defaults to returning\n\njoinpath(ssh_dir(), ssh_key_name() * \".pub\")\n\nThis default value in turn depends on the SSH_DIR and SSH_KEY_NAME environment variables.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ssh_known_hosts_files","location":"stdlib/NetworkOptions.html#NetworkOptions.ssh_known_hosts_files","category":"function","text":"ssh_known_hosts_files() :: Vector{String}\n\nThe ssh_known_hosts_files() function returns a vector of paths of SSH known hosts files that should be used when establishing the identities of remote servers for SSH connections. By default this function returns\n\n[joinpath(ssh_dir(), \"known_hosts\"), bundled_known_hosts]\n\nwhere bundled_known_hosts is the path of a copy of a known hosts file that is bundled with this package (containing known hosts keys for github.com and gitlab.com). If the environment variable SSH_KNOWN_HOSTS_FILES is set, however, then its value is split into paths on the : character (or on ; on Windows) and this vector of paths is returned instead. If any component of this vector is empty, it is expanded to the default known hosts paths.\n\nPackages that use ssh_known_hosts_files() should ideally look for matching entries by comparing the host name and key types, considering the first entry in any of the files which matches to be the definitive identity of the host. If the caller cannot compare the key type (e.g. because it has been hashes) then it must approximate the above algorithm by looking for all matching entries for a host in each file: if a file has any entries for a host then one of them must match; the caller should only continue to search further known hosts files if there are no entries for the host in question in an earlier file.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.ssh_known_hosts_file","location":"stdlib/NetworkOptions.html#NetworkOptions.ssh_known_hosts_file","category":"function","text":"ssh_known_hosts_file() :: String\n\nThe ssh_known_hosts_file() function returns a single path of an SSH known hosts file that should be used when establishing the identities of remote servers for SSH connections. It returns the first path returned by ssh_known_hosts_files that actually exists. Callers who can look in more than one known hosts file should use ssh_known_hosts_files instead and look for host matches in all the files returned as described in that function's docs.\n\n\n\n\n\n","page":"Network Options"},{"title":"NetworkOptions.verify_host","location":"stdlib/NetworkOptions.html#NetworkOptions.verify_host","category":"function","text":"verify_host(url::AbstractString, [transport::AbstractString]) :: Bool\n\nThe verify_host function tells the caller whether the identity of a host should be verified when communicating over secure transports like TLS or SSH. The url argument may be:\n\na proper URL staring with proto://\nan ssh-style bare host name or host name prefixed with user@\nan scp-style host as above, followed by : and a path location\n\nIn each case the host name part is parsed out and the decision about whether to verify or not is made based solely on the host name, not anything else about the input URL. In particular, the protocol of the URL does not matter (more below).\n\nThe transport argument indicates the kind of transport that the query is about. The currently known values are SSL/ssl (alias TLS/tls) and SSH/ssh. If the transport is omitted, the query will return true only if the host name should not be verified regardless of transport.\n\nThe host name is matched against the host patterns in the relevant environment variables depending on whether transport is supplied and what its value is:\n\nJULIA_NO_VERIFY_HOSTS — hosts that should not be verified for any transport\nJULIA_SSL_NO_VERIFY_HOSTS — hosts that should not be verified for SSL/TLS\nJULIA_SSH_NO_VERIFY_HOSTS — hosts that should not be verified for SSH\nJULIA_ALWAYS_VERIFY_HOSTS — hosts that should always be verified\n\nThe values of each of these variables is a comma-separated list of host name patterns with the following syntax — each pattern is split on . into parts and each part must one of:\n\nA literal domain name component consisting of one or more ASCII letter, digit, hyphen or underscore (technically not part of a legal host name, but sometimes used). A literal domain name component matches only itself.\nA **, which matches zero or more domain name components.\nA *, which match any one domain name component.\n\nWhen matching a host name against a pattern list in one of these variables, the host name is split on . into components and that sequence of words is matched against the pattern: a literal pattern matches exactly one host name component with that value; a * pattern matches exactly one host name component with any value; a ** pattern matches any number of host name components. For example:\n\n** matches any host name\n**.org matches any host name in the .org top-level domain\nexample.com matches only the exact host name example.com\n*.example.com matches api.example.com but not example.com or v1.api.example.com\n**.example.com matches any domain under example.com, including example.com itself, api.example.com and v1.api.example.com\n\n\n\n\n\n","page":"Network Options"},{"title":"Serialization","location":"stdlib/Serialization.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Serialization/docs/src/index.md\"","page":"Serialization"},{"title":"Serialization","location":"stdlib/Serialization.html#Serialization","category":"section","text":"","page":"Serialization"},{"title":"Serialization","location":"stdlib/Serialization.html","category":"page","text":"Provides serialization of Julia objects.","page":"Serialization"},{"title":"Serialization","location":"stdlib/Serialization.html","category":"page","text":"Serialization.serialize\nSerialization.deserialize\nSerialization.writeheader","page":"Serialization"},{"title":"Serialization.serialize","location":"stdlib/Serialization.html#Serialization.serialize","category":"function","text":"serialize(stream::IO, value)\n\nWrite an arbitrary value to a stream in an opaque format, such that it can be read back by deserialize. The read-back value will be as identical as possible to the original, but note that Ptr values are serialized as all-zero bit patterns (NULL).\n\nAn 8-byte identifying header is written to the stream first. To avoid writing the header, construct a Serializer and use it as the first argument to serialize instead. See also Serialization.writeheader.\n\nThe data format can change in minor (1.x) Julia releases, but files written by prior 1.x versions will remain readable. The main exception to this is when the definition of a type in an external package changes. If that occurs, it may be necessary to specify an explicit compatible version of the affected package in your environment. Renaming functions, even private functions, inside packages can also put existing files out of sync. Anonymous functions require special care: because their names are automatically generated, minor code changes can cause them to be renamed. Serializing anonymous functions should be avoided in files intended for long-term storage.\n\nIn some cases, the word size (32- or 64-bit) of the reading and writing machines must match. In rarer cases the OS or architecture must also match, for example when using packages that contain platform-dependent code.\n\n\n\n\n\nserialize(filename::AbstractString, value)\n\nOpen a file and serialize the given value to it.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\n\n\n\n\n","page":"Serialization"},{"title":"Serialization.deserialize","location":"stdlib/Serialization.html#Serialization.deserialize","category":"function","text":"deserialize(stream)\n\nRead a value written by serialize. deserialize assumes the binary data read from stream is correct and has been serialized by a compatible implementation of serialize. deserialize is designed for simplicity and performance, and so does not validate the data read. Malformed data can result in process termination. The caller must ensure the integrity and correctness of data read from stream.\n\n\n\n\n\ndeserialize(filename::AbstractString)\n\nOpen a file and deserialize its contents.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\n\n\n\n\n","page":"Serialization"},{"title":"Serialization.writeheader","location":"stdlib/Serialization.html#Serialization.writeheader","category":"function","text":"Serialization.writeheader(s::AbstractSerializer)\n\nWrite an identifying header to the specified serializer. The header consists of 8 bytes as follows:\n\nOffset Description\n0 tag byte (0x37)\n1-2 signature bytes \"JL\"\n3 protocol version\n4 bits 0-1: endianness: 0 = little, 1 = big\n4 bits 2-3: platform: 0 = 32-bit, 1 = 64-bit\n5-7 reserved\n\n\n\n\n\n","page":"Serialization"},{"title":"File Events","location":"stdlib/FileWatching.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/FileWatching/docs/src/index.md\"","page":"File Events"},{"title":"File Events","location":"stdlib/FileWatching.html#lib-filewatching","category":"section","text":"","page":"File Events"},{"title":"File Events","location":"stdlib/FileWatching.html","category":"page","text":"FileWatching.poll_fd\nFileWatching.poll_file\nFileWatching.watch_file\nFileWatching.watch_folder\nFileWatching.unwatch_folder","page":"File Events"},{"title":"FileWatching.poll_fd","location":"stdlib/FileWatching.html#FileWatching.poll_fd","category":"function","text":"poll_fd(fd, timeout_s::Real=-1; readable=false, writable=false)\n\nMonitor a file descriptor fd for changes in the read or write availability, and with a timeout given by timeout_s seconds.\n\nThe keyword arguments determine which of read and/or write status should be monitored; at least one of them must be set to true.\n\nThe returned value is an object with boolean fields readable, writable, and timedout, giving the result of the polling.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.poll_file","location":"stdlib/FileWatching.html#FileWatching.poll_file","category":"function","text":"poll_file(path::AbstractString, interval_s::Real=5.007, timeout_s::Real=-1) -> (previous::StatStruct, current)\n\nMonitor a file for changes by polling every interval_s seconds until a change occurs or timeout_s seconds have elapsed. The interval_s should be a long period; the default is 5.007 seconds.\n\nReturns a pair of status objects (previous, current) when a change is detected. The previous status is always a StatStruct, but it may have all of the fields zeroed (indicating the file didn't previously exist, or wasn't previously accessible).\n\nThe current status object may be a StatStruct, an EOFError (indicating the timeout elapsed), or some other Exception subtype (if the stat operation failed - for example, if the path does not exist).\n\nTo determine when a file was modified, compare current isa StatStruct && mtime(prev) != mtime(current) to detect notification of changes. However, using watch_file for this operation is preferred, since it is more reliable and efficient, although in some situations it may not be available.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.watch_file","location":"stdlib/FileWatching.html#FileWatching.watch_file","category":"function","text":"watch_file(path::AbstractString, timeout_s::Real=-1)\n\nWatch file or directory path for changes until a change occurs or timeout_s seconds have elapsed. This function does not poll the file system and instead uses platform-specific functionality to receive notifications from the operating system (e.g. via inotify on Linux). See the NodeJS documentation linked below for details.\n\nThe returned value is an object with boolean fields renamed, changed, and timedout, giving the result of watching the file.\n\nThis behavior of this function varies slightly across platforms. See https://nodejs.org/api/fs.html#fs_caveats for more detailed information.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.watch_folder","location":"stdlib/FileWatching.html#FileWatching.watch_folder","category":"function","text":"watch_folder(path::AbstractString, timeout_s::Real=-1)\n\nWatches a file or directory path for changes until a change has occurred or timeout_s seconds have elapsed. This function does not poll the file system and instead uses platform-specific functionality to receive notifications from the operating system (e.g. via inotify on Linux). See the NodeJS documentation linked below for details.\n\nThis will continuing tracking changes for path in the background until unwatch_folder is called on the same path.\n\nThe returned value is an pair where the first field is the name of the changed file (if available) and the second field is an object with boolean fields renamed, changed, and timedout, giving the event.\n\nThis behavior of this function varies slightly across platforms. See https://nodejs.org/api/fs.html#fs_caveats for more detailed information.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.unwatch_folder","location":"stdlib/FileWatching.html#FileWatching.unwatch_folder","category":"function","text":"unwatch_folder(path::AbstractString)\n\nStop background tracking of changes for path. It is not recommended to do this while another task is waiting for watch_folder to return on the same path, as the result may be unpredictable.\n\n\n\n\n\n","page":"File Events"},{"title":"Pidfile","location":"stdlib/FileWatching.html#Pidfile","category":"section","text":"","page":"File Events"},{"title":"File Events","location":"stdlib/FileWatching.html","category":"page","text":"CurrentModule = FileWatching.Pidfile","page":"File Events"},{"title":"File Events","location":"stdlib/FileWatching.html","category":"page","text":"A simple utility tool for creating advisory pidfiles (lock files).","page":"File Events"},{"title":"Primary Functions","location":"stdlib/FileWatching.html#Primary-Functions","category":"section","text":"","page":"File Events"},{"title":"File Events","location":"stdlib/FileWatching.html","category":"page","text":"mkpidlock\ntrymkpidlock\nclose(lock::LockMonitor)","page":"File Events"},{"title":"FileWatching.Pidfile.mkpidlock","location":"stdlib/FileWatching.html#FileWatching.Pidfile.mkpidlock","category":"function","text":"mkpidlock([f::Function], at::String, [pid::Cint]; kwopts...)\nmkpidlock(at::String, proc::Process; kwopts...)\n\nCreate a pidfile lock for the path \"at\" for the current process or the process identified by pid or proc. Can take a function to execute once locked, for usage in do blocks, after which the lock will be automatically closed. If the lock fails and wait is false, then an error is thrown.\n\nThe lock will be released by either close, a finalizer, or shortly after proc exits. Make sure the return value is live through the end of the critical section of your program, so the finalizer does not reclaim it early.\n\nOptional keyword arguments:\n\nmode: file access mode (modified by the process umask). Defaults to world-readable.\npoll_interval: Specify the maximum time to between attempts (if watch_file doesn't work)\nstale_age: Delete an existing pidfile (ignoring the lock) if it is older than this many seconds, based on its mtime.   The file won't be deleted until 5x longer than this if the pid in the file appears that it may be valid.   Or 25x longer if refresh is overridden to 0 to disable lock refreshing.   By default this is disabled (stale_age = 0), but a typical recommended value would be about 3-5x an   estimated normal completion time.\nrefresh: Keeps a lock from becoming stale by updating the mtime every interval of time that passes.   By default, this is set to stale_age/2, which is the recommended value.\nwait: If true, block until we get the lock, if false, raise error if lock fails.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.Pidfile.trymkpidlock","location":"stdlib/FileWatching.html#FileWatching.Pidfile.trymkpidlock","category":"function","text":"trymkpidlock([f::Function], at::String, [pid::Cint]; kwopts...)\ntrymkpidlock(at::String, proc::Process; kwopts...)\n\nLike mkpidlock except returns false instead of waiting if the file is already locked.\n\ncompat: Julia 1.10\nThis function requires at least Julia 1.10.\n\n\n\n\n\n","page":"File Events"},{"title":"Base.close","location":"stdlib/FileWatching.html#Base.close-Tuple{FileWatching.Pidfile.LockMonitor}","category":"method","text":"close(lock::LockMonitor)\n\nRelease a pidfile lock.\n\n\n\n\n\n","page":"File Events"},{"title":"Helper Functions","location":"stdlib/FileWatching.html#Helper-Functions","category":"section","text":"","page":"File Events"},{"title":"File Events","location":"stdlib/FileWatching.html","category":"page","text":"Pidfile.open_exclusive\nPidfile.tryopen_exclusive\nPidfile.write_pidfile\nPidfile.parse_pidfile\nPidfile.stale_pidfile\nPidfile.isvalidpid\nBase.touch(::Pidfile.LockMonitor)","page":"File Events"},{"title":"FileWatching.Pidfile.open_exclusive","location":"stdlib/FileWatching.html#FileWatching.Pidfile.open_exclusive","category":"function","text":"open_exclusive(path::String; mode, poll_interval, wait, stale_age, refresh) :: File\n\nCreate a new a file for read-write advisory-exclusive access. If wait is false then error out if the lock files exist otherwise block until we get the lock.\n\nFor a description of the keyword arguments, see mkpidlock.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.Pidfile.tryopen_exclusive","location":"stdlib/FileWatching.html#FileWatching.Pidfile.tryopen_exclusive","category":"function","text":"tryopen_exclusive(path::String, mode::Integer = 0o444) :: Union{Void, File}\n\nTry to create a new file for read-write advisory-exclusive access, return nothing if it already exists.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.Pidfile.write_pidfile","location":"stdlib/FileWatching.html#FileWatching.Pidfile.write_pidfile","category":"function","text":"write_pidfile(io, pid)\n\nWrite our pidfile format to an open IO descriptor.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.Pidfile.parse_pidfile","location":"stdlib/FileWatching.html#FileWatching.Pidfile.parse_pidfile","category":"function","text":"parse_pidfile(file::Union{IO, String}) => (pid, hostname, age)\n\nAttempt to parse our pidfile format, replaced an element with (0, \"\", 0.0), respectively, for any read that failed.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.Pidfile.stale_pidfile","location":"stdlib/FileWatching.html#FileWatching.Pidfile.stale_pidfile","category":"function","text":"stale_pidfile(path::String, stale_age::Real, refresh::Real) :: Bool\n\nHelper function for open_exclusive for deciding if a pidfile is stale.\n\n\n\n\n\n","page":"File Events"},{"title":"FileWatching.Pidfile.isvalidpid","location":"stdlib/FileWatching.html#FileWatching.Pidfile.isvalidpid","category":"function","text":"isvalidpid(hostname::String, pid::Cuint) :: Bool\n\nAttempt to conservatively estimate whether pid is a valid process id.\n\n\n\n\n\n","page":"File Events"},{"title":"Base.Filesystem.touch","location":"stdlib/FileWatching.html#Base.Filesystem.touch-Tuple{FileWatching.Pidfile.LockMonitor}","category":"method","text":"Base.touch(::Pidfile.LockMonitor)\n\nUpdate the mtime on the lock, to indicate it is still fresh.\n\nSee also the refresh keyword in the mkpidlock constructor.\n\n\n\n\n\n","page":"File Events"},{"title":"Iteration utilities","location":"base/iterators.html#Iteration-utilities","category":"section","text":"","page":"Iteration utilities"},{"title":"Iteration utilities","location":"base/iterators.html","category":"page","text":"Base.Iterators.Stateful\nBase.Iterators.zip\nBase.Iterators.enumerate\nBase.Iterators.rest\nBase.Iterators.countfrom\nBase.Iterators.take\nBase.Iterators.takewhile\nBase.Iterators.drop\nBase.Iterators.dropwhile\nBase.Iterators.cycle\nBase.Iterators.repeated\nBase.Iterators.product\nBase.Iterators.flatten\nBase.Iterators.flatmap\nBase.Iterators.partition\nBase.Iterators.map\nBase.Iterators.filter\nBase.Iterators.accumulate\nBase.Iterators.reverse\nBase.Iterators.only\nBase.Iterators.peel","page":"Iteration utilities"},{"title":"Base.Iterators.Stateful","location":"base/iterators.html#Base.Iterators.Stateful","category":"type","text":"Stateful(itr)\n\nThere are several different ways to think about this iterator wrapper:\n\nIt provides a mutable wrapper around an iterator and its iteration state.\nIt turns an iterator-like abstraction into a Channel-like abstraction.\nIt's an iterator that mutates to become its own rest iterator whenever an item is produced.\n\nStateful provides the regular iterator interface. Like other mutable iterators (e.g. Base.Channel), if iteration is stopped early (e.g. by a break in a for loop), iteration can be resumed from the same spot by continuing to iterate over the same iterator object (in contrast, an immutable iterator would restart from the beginning).\n\nExamples\n\njulia> a = Iterators.Stateful(\"abcdef\");\n\njulia> isempty(a)\nfalse\n\njulia> popfirst!(a)\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> collect(Iterators.take(a, 3))\n3-element Vector{Char}:\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n 'd': ASCII/Unicode U+0064 (category Ll: Letter, lowercase)\n\njulia> collect(a)\n2-element Vector{Char}:\n 'e': ASCII/Unicode U+0065 (category Ll: Letter, lowercase)\n 'f': ASCII/Unicode U+0066 (category Ll: Letter, lowercase)\n\njulia> Iterators.reset!(a); popfirst!(a)\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> Iterators.reset!(a, \"hello\"); popfirst!(a)\n'h': ASCII/Unicode U+0068 (category Ll: Letter, lowercase)\n\njulia> a = Iterators.Stateful([1,1,1,2,3,4]);\n\njulia> for x in a; x == 1 || break; end\n\njulia> peek(a)\n3\n\njulia> sum(a) # Sum the remaining elements\n7\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.zip","location":"base/iterators.html#Base.Iterators.zip","category":"function","text":"zip(iters...)\n\nRun multiple iterators at the same time, until any of them is exhausted. The value type of the zip iterator is a tuple of values of its subiterators.\n\nnote: Note\nzip orders the calls to its subiterators in such a way that stateful iterators will not advance when another iterator finishes in the current iteration.\n\nnote: Note\nzip() with no arguments yields an infinite iterator of empty tuples.\n\nSee also: enumerate, Base.splat.\n\nExamples\n\njulia> a = 1:5\n1:5\n\njulia> b = [\"e\",\"d\",\"b\",\"c\",\"a\"]\n5-element Vector{String}:\n \"e\"\n \"d\"\n \"b\"\n \"c\"\n \"a\"\n\njulia> c = zip(a,b)\nzip(1:5, [\"e\", \"d\", \"b\", \"c\", \"a\"])\n\njulia> length(c)\n5\n\njulia> first(c)\n(1, \"e\")\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.enumerate","location":"base/iterators.html#Base.Iterators.enumerate","category":"function","text":"enumerate(iter)\n\nAn iterator that yields (i, x) where i is a counter starting at 1, and x is the ith value from the given iterator. It's useful when you need not only the values x over which you are iterating, but also the number of iterations so far.\n\nNote that i may not be valid for indexing iter, or may index a different element. This will happen if iter has indices that do not start at 1, and may happen for strings, dictionaries, etc. See the pairs(IndexLinear(), iter) method if you want to ensure that i is an index.\n\nExamples\n\njulia> a = [\"a\", \"b\", \"c\"];\n\njulia> for (index, value) in enumerate(a)\n           println(\"$index $value\")\n       end\n1 a\n2 b\n3 c\n\njulia> str = \"naïve\";\n\njulia> for (i, val) in enumerate(str)\n           print(\"i = \", i, \", val = \", val, \", \")\n           try @show(str[i]) catch e println(e) end\n       end\ni = 1, val = n, str[i] = 'n'\ni = 2, val = a, str[i] = 'a'\ni = 3, val = ï, str[i] = 'ï'\ni = 4, val = v, StringIndexError(\"naïve\", 4)\ni = 5, val = e, str[i] = 'v'\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.rest","location":"base/iterators.html#Base.Iterators.rest","category":"function","text":"rest(iter, state)\n\nAn iterator that yields the same elements as iter, but starting at the given state.\n\nSee also: Iterators.drop, Iterators.peel, Base.rest.\n\nExamples\n\njulia> collect(Iterators.rest([1,2,3,4], 2))\n3-element Vector{Int64}:\n 2\n 3\n 4\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.countfrom","location":"base/iterators.html#Base.Iterators.countfrom","category":"function","text":"countfrom(start=1, step=1)\n\nAn iterator that counts forever, starting at start and incrementing by step.\n\nExamples\n\njulia> for v in Iterators.countfrom(5, 2)\n           v > 10 && break\n           println(v)\n       end\n5\n7\n9\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.take","location":"base/iterators.html#Base.Iterators.take","category":"function","text":"take(iter, n)\n\nAn iterator that generates at most the first n elements of iter.\n\nSee also: drop, peel, first, Base.take!.\n\nExamples\n\njulia> a = 1:2:11\n1:2:11\n\njulia> collect(a)\n6-element Vector{Int64}:\n  1\n  3\n  5\n  7\n  9\n 11\n\njulia> collect(Iterators.take(a,3))\n3-element Vector{Int64}:\n 1\n 3\n 5\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.takewhile","location":"base/iterators.html#Base.Iterators.takewhile","category":"function","text":"takewhile(pred, iter)\n\nAn iterator that generates element from iter as long as predicate pred is true, afterwards, drops every element.\n\ncompat: Julia 1.4\nThis function requires at least Julia 1.4.\n\nExamples\n\njulia> s = collect(1:5)\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> collect(Iterators.takewhile(<(3),s))\n2-element Vector{Int64}:\n 1\n 2\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.drop","location":"base/iterators.html#Base.Iterators.drop","category":"function","text":"drop(iter, n)\n\nAn iterator that generates all but the first n elements of iter.\n\nExamples\n\njulia> a = 1:2:11\n1:2:11\n\njulia> collect(a)\n6-element Vector{Int64}:\n  1\n  3\n  5\n  7\n  9\n 11\n\njulia> collect(Iterators.drop(a,4))\n2-element Vector{Int64}:\n  9\n 11\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.dropwhile","location":"base/iterators.html#Base.Iterators.dropwhile","category":"function","text":"dropwhile(pred, iter)\n\nAn iterator that drops element from iter as long as predicate pred is true, afterwards, returns every element.\n\ncompat: Julia 1.4\nThis function requires at least Julia 1.4.\n\nExamples\n\njulia> s = collect(1:5)\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> collect(Iterators.dropwhile(<(3),s))\n3-element Vector{Int64}:\n 3\n 4\n 5\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.cycle","location":"base/iterators.html#Base.Iterators.cycle","category":"function","text":"cycle(iter[, n::Int])\n\nAn iterator that cycles through iter forever. If n is specified, then it cycles through iter that many times. When iter is empty, so are cycle(iter) and cycle(iter, n).\n\nIterators.cycle(iter, n) is the lazy equivalent of Base.repeat(vector, n), while Iterators.repeated(iter, n) is the lazy Base.fill(item, n).\n\ncompat: Julia 1.11\nThe method cycle(iter, n) was added in Julia 1.11.\n\nExamples\n\njulia> for (i, v) in enumerate(Iterators.cycle(\"hello\"))\n           print(v)\n           i > 10 && break\n       end\nhellohelloh\n\njulia> foreach(print, Iterators.cycle(['j', 'u', 'l', 'i', 'a'], 3))\njuliajuliajulia\n\njulia> repeat([1,2,3], 4) == collect(Iterators.cycle([1,2,3], 4))\ntrue\n\njulia> fill([1,2,3], 4) == collect(Iterators.repeated([1,2,3], 4))\ntrue\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.repeated","location":"base/iterators.html#Base.Iterators.repeated","category":"function","text":"repeated(x[, n::Int])\n\nAn iterator that generates the value x forever. If n is specified, generates x that many times (equivalent to take(repeated(x), n)).\n\nSee also fill, and compare Iterators.cycle.\n\nExamples\n\njulia> a = Iterators.repeated([1 2], 4);\n\njulia> collect(a)\n4-element Vector{Matrix{Int64}}:\n [1 2]\n [1 2]\n [1 2]\n [1 2]\n\njulia> ans == fill([1 2], 4)\ntrue\n\njulia> Iterators.cycle([1 2], 4) |> collect |> println\n[1, 2, 1, 2, 1, 2, 1, 2]\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.product","location":"base/iterators.html#Base.Iterators.product","category":"function","text":"product(iters...)\n\nReturn an iterator over the product of several iterators. Each generated element is a tuple whose ith element comes from the ith argument iterator. The first iterator changes the fastest.\n\nSee also: zip, Iterators.flatten.\n\nExamples\n\njulia> collect(Iterators.product(1:2, 3:5))\n2×3 Matrix{Tuple{Int64, Int64}}:\n (1, 3)  (1, 4)  (1, 5)\n (2, 3)  (2, 4)  (2, 5)\n\njulia> ans == [(x,y) for x in 1:2, y in 3:5]  # collects a generator involving Iterators.product\ntrue\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.flatten","location":"base/iterators.html#Base.Iterators.flatten","category":"function","text":"flatten(iter)\n\nGiven an iterator that yields iterators, return an iterator that yields the elements of those iterators. Put differently, the elements of the argument iterator are concatenated.\n\nExamples\n\njulia> collect(Iterators.flatten((1:2, 8:9)))\n4-element Vector{Int64}:\n 1\n 2\n 8\n 9\n\njulia> [(x,y) for x in 0:1 for y in 'a':'c']  # collects generators involving Iterators.flatten\n6-element Vector{Tuple{Int64, Char}}:\n (0, 'a')\n (0, 'b')\n (0, 'c')\n (1, 'a')\n (1, 'b')\n (1, 'c')\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.flatmap","location":"base/iterators.html#Base.Iterators.flatmap","category":"function","text":"Iterators.flatmap(f, iterators...)\n\nEquivalent to flatten(map(f, iterators...)).\n\nSee also Iterators.flatten, Iterators.map.\n\ncompat: Julia 1.9\nThis function was added in Julia 1.9.\n\nExamples\n\njulia> Iterators.flatmap(n -> -n:2:n, 1:3) |> collect\n9-element Vector{Int64}:\n -1\n  1\n -2\n  0\n  2\n -3\n -1\n  1\n  3\n\njulia> stack(n -> -n:2:n, 1:3)\nERROR: DimensionMismatch: stack expects uniform slices, got axes(x) == (1:3,) while first had (1:2,)\n[...]\n\njulia> Iterators.flatmap(n -> (-n, 10n), 1:2) |> collect\n4-element Vector{Int64}:\n -1\n 10\n -2\n 20\n\njulia> ans == vec(stack(n -> (-n, 10n), 1:2))\ntrue\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.partition","location":"base/iterators.html#Base.Iterators.partition","category":"function","text":"partition(collection, n)\n\nIterate over a collection n elements at a time.\n\nExamples\n\njulia> collect(Iterators.partition([1,2,3,4,5], 2))\n3-element Vector{SubArray{Int64, 1, Vector{Int64}, Tuple{UnitRange{Int64}}, true}}:\n [1, 2]\n [3, 4]\n [5]\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.map","location":"base/iterators.html#Base.Iterators.map","category":"function","text":"Iterators.map(f, iterators...)\n\nCreate a lazy mapping.  This is another syntax for writing (f(args...) for args in zip(iterators...)).\n\ncompat: Julia 1.6\nThis function requires at least Julia 1.6.\n\nExamples\n\njulia> collect(Iterators.map(x -> x^2, 1:3))\n3-element Vector{Int64}:\n 1\n 4\n 9\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.filter","location":"base/iterators.html#Base.Iterators.filter","category":"function","text":"Iterators.filter(flt, itr)\n\nGiven a predicate function flt and an iterable object itr, return an iterable object which upon iteration yields the elements x of itr that satisfy flt(x). The order of the original iterator is preserved.\n\nThis function is lazy; that is, it is guaranteed to return in Θ(1) time and use Θ(1) additional space, and flt will not be called by an invocation of filter. Calls to flt will be made when iterating over the returned iterable object. These calls are not cached and repeated calls will be made when reiterating.\n\nwarning: Warning\nSubsequent lazy transformations on the iterator returned from filter, such as those performed by Iterators.reverse or cycle, will also delay calls to flt until collecting or iterating over the returned iterable object. If the filter predicate is nondeterministic or its return values depend on the order of iteration over the elements of itr, composition with lazy transformations may result in surprising behavior. If this is undesirable, either ensure that flt is a pure function or collect intermediate filter iterators before further transformations.\n\nSee Base.filter for an eager implementation of filtering for arrays.\n\nExamples\n\njulia> f = Iterators.filter(isodd, [1, 2, 3, 4, 5])\nBase.Iterators.Filter{typeof(isodd), Vector{Int64}}(isodd, [1, 2, 3, 4, 5])\n\njulia> foreach(println, f)\n1\n3\n5\n\njulia> [x for x in [1, 2, 3, 4, 5] if isodd(x)]  # collects a generator over Iterators.filter\n3-element Vector{Int64}:\n 1\n 3\n 5\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.accumulate","location":"base/iterators.html#Base.Iterators.accumulate","category":"function","text":"Iterators.accumulate(f, itr; [init])\n\nGiven a 2-argument function f and an iterator itr, return a new iterator that successively applies f to the previous value and the next element of itr.\n\nThis is effectively a lazy version of Base.accumulate.\n\ncompat: Julia 1.5\nKeyword argument init is added in Julia 1.5.\n\nExamples\n\njulia> a = Iterators.accumulate(+, [1,2,3,4]);\n\njulia> foreach(println, a)\n1\n3\n6\n10\n\njulia> b = Iterators.accumulate(/, (2, 5, 2, 5); init = 100);\n\njulia> collect(b)\n4-element Vector{Float64}:\n 50.0\n 10.0\n  5.0\n  1.0\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.reverse","location":"base/iterators.html#Base.Iterators.reverse","category":"function","text":"Iterators.reverse(itr)\n\nGiven an iterator itr, then reverse(itr) is an iterator over the same collection but in the reverse order. This iterator is \"lazy\" in that it does not make a copy of the collection in order to reverse it; see Base.reverse for an eager implementation.\n\n(By default, this returns an Iterators.Reverse object wrapping itr, which is iterable if the corresponding iterate methods are defined, but some itr types may implement more specialized Iterators.reverse behaviors.)\n\nNot all iterator types T support reverse-order iteration.  If T doesn't, then iterating over Iterators.reverse(itr::T) will throw a MethodError because of the missing iterate methods for Iterators.Reverse{T}. (To implement these methods, the original iterator itr::T can be obtained from an r::Iterators.Reverse{T} object by r.itr; more generally, one can use Iterators.reverse(r).)\n\nExamples\n\njulia> foreach(println, Iterators.reverse(1:5))\n5\n4\n3\n2\n1\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.only","location":"base/iterators.html#Base.Iterators.only","category":"function","text":"only(x)\n\nReturn the one and only element of collection x, or throw an ArgumentError if the collection has zero or multiple elements.\n\nSee also first, last.\n\ncompat: Julia 1.4\nThis method requires at least Julia 1.4.\n\nExamples\n\njulia> only([\"a\"])\n\"a\"\n\njulia> only(\"a\")\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> only(())\nERROR: ArgumentError: Tuple contains 0 elements, must contain exactly 1 element\nStacktrace:\n[...]\n\njulia> only(('a', 'b'))\nERROR: ArgumentError: Tuple contains 2 elements, must contain exactly 1 element\nStacktrace:\n[...]\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Base.Iterators.peel","location":"base/iterators.html#Base.Iterators.peel","category":"function","text":"peel(iter)\n\nReturns the first element and an iterator over the remaining elements.\n\nIf the iterator is empty return nothing (like iterate).\n\ncompat: Julia 1.7\nPrior versions throw a BoundsError if the iterator is empty.\n\nSee also: Iterators.drop, Iterators.take.\n\nExamples\n\njulia> (a, rest) = Iterators.peel(\"abc\");\n\njulia> a\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> collect(rest)\n2-element Vector{Char}:\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n\n\n\n\n\n","page":"Iteration utilities"},{"title":"Bounds checking","location":"devdocs/boundscheck.html#Bounds-checking","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Like many modern programming languages, Julia uses bounds checking to ensure program safety when accessing arrays. In tight inner loops or other performance critical situations, you may wish to skip these bounds checks to improve runtime performance. For instance, in order to emit vectorized (SIMD) instructions, your loop body cannot contain branches, and thus cannot contain bounds checks. Consequently, Julia includes an @inbounds(...) macro to tell the compiler to skip such bounds checks within the given block. User-defined array types can use the @boundscheck(...) macro to achieve context-sensitive code selection.","page":"Bounds checking"},{"title":"Eliding bounds checks","location":"devdocs/boundscheck.html#Eliding-bounds-checks","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"The @boundscheck(...) macro marks blocks of code that perform bounds checking. When such blocks are inlined into an @inbounds(...) block, the compiler may remove these blocks. The compiler removes the @boundscheck block only if it is inlined into the calling function. For example, you might write the method sum as:","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"function sum(A::AbstractArray)\n    r = zero(eltype(A))\n    for i in eachindex(A)\n        @inbounds r += A[i]\n    end\n    return r\nend","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"With a custom array-like type MyArray having:","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"@inline getindex(A::MyArray, i::Real) = (@boundscheck checkbounds(A, i); A.data[to_index(i)])","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Then when getindex is inlined into sum, the call to checkbounds(A, i) will be elided. If your function contains multiple layers of inlining, only @boundscheck blocks at most one level of inlining deeper are eliminated. The rule prevents unintended changes in program behavior from code further up the stack.","page":"Bounds checking"},{"title":"Caution!","location":"devdocs/boundscheck.html#Caution!","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"It is easy to accidentally expose unsafe operations with @inbounds. You might be tempted to write the above example as","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"function sum(A::AbstractArray)\n    r = zero(eltype(A))\n    for i in 1:length(A)\n        @inbounds r += A[i]\n    end\n    return r\nend","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Which quietly assumes 1-based indexing and therefore exposes unsafe memory access when used with OffsetArrays:","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"julia> using OffsetArrays\n\njulia> sum(OffsetArray([1, 2, 3], -10))\n9164911648 # inconsistent results or segfault","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"While the original source of the error here is 1:length(A), the use of @inbounds increases the consequences from a bounds error to a less easily caught and debugged unsafe memory access. It is often difficult or impossible to prove that a method which uses @inbounds is safe, so one must weigh the benefits of performance improvements against the risk of segfaults and silent misbehavior, especially in public facing APIs.","page":"Bounds checking"},{"title":"Propagating inbounds","location":"devdocs/boundscheck.html#Propagating-inbounds","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"There may be certain scenarios where for code-organization reasons you want more than one layer between the @inbounds and @boundscheck declarations. For instance, the default getindex methods have the chain getindex(A::AbstractArray, i::Real) calls getindex(IndexStyle(A), A, i) calls _getindex(::IndexLinear, A, i).","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"To override the \"one layer of inlining\" rule, a function may be marked with Base.@propagate_inbounds to propagate an inbounds context (or out of bounds context) through one additional layer of inlining.","page":"Bounds checking"},{"title":"The bounds checking call hierarchy","location":"devdocs/boundscheck.html#The-bounds-checking-call-hierarchy","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"The overall hierarchy is:","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"checkbounds(A, I...) which calls\ncheckbounds(Bool, A, I...) which calls\ncheckbounds_indices(Bool, axes(A), I) which recursively calls\ncheckindex for each dimension","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Here A is the array, and I contains the \"requested\" indices. axes(A) returns a tuple of \"permitted\" indices of A.","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"checkbounds(A, I...) throws an error if the indices are invalid, whereas checkbounds(Bool, A, I...) returns false in that circumstance.  checkbounds_indices discards any information about the array other than its axes tuple, and performs a pure indices-vs-indices comparison: this allows relatively few compiled methods to serve a huge variety of array types. Indices are specified as tuples, and are usually compared in a 1-1 fashion with individual dimensions handled by calling another important function, checkindex: typically,","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"checkbounds_indices(Bool, (IA1, IA...), (I1, I...)) = checkindex(Bool, IA1, I1) &\n                                                      checkbounds_indices(Bool, IA, I)","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"so checkindex checks a single dimension.  All of these functions, including the unexported checkbounds_indices have docstrings accessible with ? .","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"If you have to customize bounds checking for a specific array type, you should specialize checkbounds(Bool, A, I...). However, in most cases you should be able to rely on checkbounds_indices as long as you supply useful axes for your array type.","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"If you have novel index types, first consider specializing checkindex, which handles a single index for a particular dimension of an array.  If you have a custom multidimensional index type (similar to CartesianIndex), then you may have to consider specializing checkbounds_indices.","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Note this hierarchy has been designed to reduce the likelihood of method ambiguities.  We try to make checkbounds the place to specialize on array type, and try to avoid specializations on index types; conversely, checkindex is intended to be specialized only on index type (especially, the last argument).","page":"Bounds checking"},{"title":"Emit bounds checks","location":"devdocs/boundscheck.html#Emit-bounds-checks","category":"section","text":"","page":"Bounds checking"},{"title":"Bounds checking","location":"devdocs/boundscheck.html","category":"page","text":"Julia can be launched with --check-bounds={yes|no|auto} to emit bounds checks always, never, or respect @inbounds declarations.","page":"Bounds checking"},{"title":"Interfaces","location":"manual/interfaces.html#Interfaces","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A lot of the power and extensibility in Julia comes from a collection of informal interfaces.  By extending a few specific methods to work for a custom type, objects of that type not only receive those functionalities, but they are also able to be used in other methods that are written to generically build upon those behaviors.","page":"Interfaces"},{"title":"Iteration","location":"manual/interfaces.html#man-interface-iteration","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"There are two methods that are always required:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Required method Brief description\niterate(iter) Returns either a tuple of the first item and initial state or nothing if empty\niterate(iter, state) Returns either a tuple of the next item and next state or nothing if no items remain","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"There are several more methods that should be defined in some circumstances. Please note that you should always define at least one of Base.IteratorSize(IterType) and length(iter) because the default definition of Base.IteratorSize(IterType) is Base.HasLength().","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Method When should this method be defined? Default definition Brief description\nBase.IteratorSize(IterType) If default is not appropriate Base.HasLength() One of Base.HasLength(), Base.HasShape{N}(), Base.IsInfinite(), or Base.SizeUnknown() as appropriate\nlength(iter) If Base.IteratorSize() returns Base.HasLength() or Base.HasShape{N}() (undefined) The number of items, if known\nsize(iter, [dim]) If Base.IteratorSize() returns Base.HasShape{N}() (undefined) The number of items in each dimension, if known\nBase.IteratorEltype(IterType) If default is not appropriate Base.HasEltype() Either Base.EltypeUnknown() or Base.HasEltype() as appropriate\neltype(IterType) If default is not appropriate Any The type of the first entry of the tuple returned by iterate()\nBase.isdone(iter, [state]) Must be defined if iterator is stateful missing Fast-path hint for iterator completion. If not defined for a stateful iterator then functions that check for done-ness, like isempty() and zip(), may mutate the iterator and cause buggy behaviour!","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Sequential iteration is implemented by the iterate function. Instead of mutating objects as they are iterated over, Julia iterators may keep track of the iteration state externally from the object. The return value from iterate is always either a tuple of a value and a state, or nothing if no elements remain. The state object will be passed back to the iterate function on the next iteration and is generally considered an implementation detail private to the iterable object.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Any object that defines this function is iterable and can be used in the many functions that rely upon iteration. It can also be used directly in a for loop since the syntax:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"for item in iter   # or  \"for item = iter\"\n    # body\nend","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"is translated into:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"next = iterate(iter)\nwhile next !== nothing\n    (item, state) = next\n    # body\n    next = iterate(iter, state)\nend","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A simple example is an iterable sequence of square numbers with a defined length:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> struct Squares\n           count::Int\n       end\n\njulia> Base.iterate(S::Squares, state=1) = state > S.count ? nothing : (state*state, state+1)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"With only iterate definition, the Squares type is already pretty powerful. We can iterate over all the elements:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> for item in Squares(7)\n           println(item)\n       end\n1\n4\n9\n16\n25\n36\n49","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"We can use many of the builtin methods that work with iterables, like in or sum:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> 25 in Squares(10)\ntrue\n\njulia> sum(Squares(100))\n338350","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"There are a few more methods we can extend to give Julia more information about this iterable collection.  We know that the elements in a Squares sequence will always be Int. By extending the eltype method, we can give that information to Julia and help it make more specialized code in the more complicated methods. We also know the number of elements in our sequence, so we can extend length, too:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.eltype(::Type{Squares}) = Int # Note that this is defined for the type\n\njulia> Base.length(S::Squares) = S.count","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Now, when we ask Julia to collect all the elements into an array it can preallocate a Vector{Int} of the right size instead of naively push!ing each element into a Vector{Any}:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> collect(Squares(4))\n4-element Vector{Int64}:\n  1\n  4\n  9\n 16","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"While we can rely upon generic implementations, we can also extend specific methods where we know there is a simpler algorithm. For example, there's a formula to compute the sum of squares, so we can override the generic iterative version with a more performant solution:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.sum(S::Squares) = (n = S.count; return n*(n+1)*(2n+1)÷6)\n\njulia> sum(Squares(1803))\n1955361914","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This is a very common pattern throughout Julia Base: a small set of required methods define an informal interface that enable many fancier behaviors. In some cases, types will want to additionally specialize those extra behaviors when they know a more efficient algorithm can be used in their specific case.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"It is also often useful to allow iteration over a collection in reverse order by iterating over Iterators.reverse(iterator).  To actually support reverse-order iteration, however, an iterator type T needs to implement iterate for Iterators.Reverse{T}. (Given r::Iterators.Reverse{T}, the underling iterator of type T is r.itr.) In our Squares example, we would implement Iterators.Reverse{Squares} methods:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.iterate(rS::Iterators.Reverse{Squares}, state=rS.itr.count) = state < 1 ? nothing : (state*state, state-1)\n\njulia> collect(Iterators.reverse(Squares(4)))\n4-element Vector{Int64}:\n 16\n  9\n  4\n  1","page":"Interfaces"},{"title":"Indexing","location":"manual/interfaces.html#Indexing","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement Brief description\ngetindex(X, i) X[i], indexed access, non-scalar i should allocate a copy\nsetindex!(X, v, i) X[i] = v, indexed assignment\nfirstindex(X) The first index, used in X[begin]\nlastindex(X) The last index, used in X[end]","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For the Squares iterable above, we can easily compute the ith element of the sequence by squaring it.  We can expose this as an indexing expression S[i]. To opt into this behavior, Squares simply needs to define getindex:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> function Base.getindex(S::Squares, i::Int)\n           1 <= i <= S.count || throw(BoundsError(S, i))\n           return i*i\n       end\n\njulia> Squares(100)[23]\n529","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Additionally, to support the syntax S[begin] and S[end], we must define firstindex and lastindex to specify the first and last valid indices, respectively:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.firstindex(S::Squares) = 1\n\njulia> Base.lastindex(S::Squares) = length(S)\n\njulia> Squares(23)[end]\n529","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For multi-dimensional begin/end indexing as in a[3, begin, 7], for example, you should define firstindex(a, dim) and lastindex(a, dim) (which default to calling first and last on axes(a, dim), respectively).","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Note, though, that the above only defines getindex with one integer index. Indexing with anything other than an Int will throw a MethodError saying that there was no matching method. In order to support indexing with ranges or vectors of Ints, separate methods must be written:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.getindex(S::Squares, i::Number) = S[convert(Int, i)]\n\njulia> Base.getindex(S::Squares, I) = [S[i] for i in I]\n\njulia> Squares(10)[[3,4.,5]]\n3-element Vector{Int64}:\n  9\n 16\n 25","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"While this is starting to support more of the indexing operations supported by some of the builtin types, there's still quite a number of behaviors missing. This Squares sequence is starting to look more and more like a vector as we've added behaviors to it. Instead of defining all these behaviors ourselves, we can officially define it as a subtype of an AbstractArray.","page":"Interfaces"},{"title":"Abstract Arrays","location":"manual/interfaces.html#man-interface-array","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement  Brief description\nsize(A)  Returns a tuple containing the dimensions of A\ngetindex(A, i::Int)  (if IndexLinear) Linear scalar indexing\ngetindex(A, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexing\nOptional methods Default definition Brief description\nIndexStyle(::Type) IndexCartesian() Returns either IndexLinear() or IndexCartesian(). See the description below.\nsetindex!(A, v, i::Int)  (if IndexLinear) Scalar indexed assignment\nsetindex!(A, v, I::Vararg{Int, N})  (if IndexCartesian, where N = ndims(A)) N-dimensional scalar indexed assignment\ngetindex(A, I...) defined in terms of scalar getindex Multidimensional and nonscalar indexing\nsetindex!(A, X, I...) defined in terms of scalar setindex! Multidimensional and nonscalar indexed assignment\niterate defined in terms of scalar getindex Iteration\nlength(A) prod(size(A)) Number of elements\nsimilar(A) similar(A, eltype(A), size(A)) Return a mutable array with the same shape and element type\nsimilar(A, ::Type{S}) similar(A, S, size(A)) Return a mutable array with the same shape and the specified element type\nsimilar(A, dims::Dims) similar(A, eltype(A), dims) Return a mutable array with the same element type and size dims\nsimilar(A, ::Type{S}, dims::Dims) Array{S}(undef, dims) Return a mutable array with the specified element type and size\nNon-traditional indices Default definition Brief description\naxes(A) map(OneTo, size(A)) Return a tuple of AbstractUnitRange{<:Integer} of valid indices. The axes should be their own axes, that is axes.(axes(A),1) == axes(A) should be satisfied.\nsimilar(A, ::Type{S}, inds) similar(A, S, Base.to_shape(inds)) Return a mutable array with the specified indices inds (see below)\nsimilar(T::Union{Type,Function}, inds) T(Base.to_shape(inds)) Return an array similar to T with the specified indices inds (see below)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If a type is defined as a subtype of AbstractArray, it inherits a very large set of rich behaviors including iteration and multidimensional indexing built on top of single-element access.  See the arrays manual page and the Julia Base section for more supported methods.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A key part in defining an AbstractArray subtype is IndexStyle. Since indexing is such an important part of an array and often occurs in hot loops, it's important to make both indexing and indexed assignment as efficient as possible.  Array data structures are typically defined in one of two ways: either it most efficiently accesses its elements using just one index (linear indexing) or it intrinsically accesses the elements with indices specified for every dimension.  These two modalities are identified by Julia as IndexLinear() and IndexCartesian().  Converting a linear index to multiple indexing subscripts is typically very expensive, so this provides a traits-based mechanism to enable efficient generic code for all array types.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This distinction determines which scalar indexing methods the type must define. IndexLinear() arrays are simple: just define getindex(A::ArrayType, i::Int).  When the array is subsequently indexed with a multidimensional set of indices, the fallback getindex(A::AbstractArray, I...) efficiently converts the indices into one linear index and then calls the above method. IndexCartesian() arrays, on the other hand, require methods to be defined for each supported dimensionality with ndims(A) Int indices. For example, SparseMatrixCSC from the SparseArrays standard library module, only supports two dimensions, so it just defines getindex(A::SparseMatrixCSC, i::Int, j::Int). The same holds for setindex!.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Returning to the sequence of squares from above, we could instead define it as a subtype of an AbstractArray{Int, 1}:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> struct SquaresVector <: AbstractArray{Int, 1}\n           count::Int\n       end\n\njulia> Base.size(S::SquaresVector) = (S.count,)\n\njulia> Base.IndexStyle(::Type{<:SquaresVector}) = IndexLinear()\n\njulia> Base.getindex(S::SquaresVector, i::Int) = i*i","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Note that it's very important to specify the two parameters of the AbstractArray; the first defines the eltype, and the second defines the ndims. That supertype and those three methods are all it takes for SquaresVector to be an iterable, indexable, and completely functional array:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> s = SquaresVector(4)\n4-element SquaresVector:\n  1\n  4\n  9\n 16\n\njulia> s[s .> 8]\n2-element Vector{Int64}:\n  9\n 16\n\njulia> s + s\n4-element Vector{Int64}:\n  2\n  8\n 18\n 32\n\njulia> sin.(s)\n4-element Vector{Float64}:\n  0.8414709848078965\n -0.7568024953079282\n  0.4121184852417566\n -0.2879033166650653","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"As a more complicated example, let's define our own toy N-dimensional sparse-like array type built on top of Dict:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> struct SparseArray{T,N} <: AbstractArray{T,N}\n           data::Dict{NTuple{N,Int}, T}\n           dims::NTuple{N,Int}\n       end\n\njulia> SparseArray(::Type{T}, dims::Int...) where {T} = SparseArray(T, dims);\n\njulia> SparseArray(::Type{T}, dims::NTuple{N,Int}) where {T,N} = SparseArray{T,N}(Dict{NTuple{N,Int}, T}(), dims);\n\njulia> Base.size(A::SparseArray) = A.dims\n\njulia> Base.similar(A::SparseArray, ::Type{T}, dims::Dims) where {T} = SparseArray(T, dims)\n\njulia> Base.getindex(A::SparseArray{T,N}, I::Vararg{Int,N}) where {T,N} = get(A.data, I, zero(T))\n\njulia> Base.setindex!(A::SparseArray{T,N}, v, I::Vararg{Int,N}) where {T,N} = (A.data[I] = v)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Notice that this is an IndexCartesian array, so we must manually define getindex and setindex! at the dimensionality of the array. Unlike the SquaresVector, we are able to define setindex!, and so we can mutate the array:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> A = SparseArray(Float64, 3, 3)\n3×3 SparseArray{Float64, 2}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n\njulia> fill!(A, 2)\n3×3 SparseArray{Float64, 2}:\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n\njulia> A[:] = 1:length(A); A\n3×3 SparseArray{Float64, 2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The result of indexing an AbstractArray can itself be an array (for instance when indexing by an AbstractRange). The AbstractArray fallback methods use similar to allocate an Array of the appropriate size and element type, which is filled in using the basic indexing method described above. However, when implementing an array wrapper you often want the result to be wrapped as well:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> A[1:2,:]\n2×3 SparseArray{Float64, 2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In this example it is accomplished by defining Base.similar(A::SparseArray, ::Type{T}, dims::Dims) where T to create the appropriate wrapped array. (Note that while similar supports 1- and 2-argument forms, in most case you only need to specialize the 3-argument form.) For this to work it's important that SparseArray is mutable (supports setindex!). Defining similar, getindex and setindex! for SparseArray also makes it possible to copy the array:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> copy(A)\n3×3 SparseArray{Float64, 2}:\n 1.0  4.0  7.0\n 2.0  5.0  8.0\n 3.0  6.0  9.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In addition to all the iterable and indexable methods from above, these types can also interact with each other and use most of the methods defined in Julia Base for AbstractArrays:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> A[SquaresVector(3)]\n3-element SparseArray{Float64, 1}:\n 1.0\n 4.0\n 9.0\n\njulia> sum(A)\n45.0","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If you are defining an array type that allows non-traditional indexing (indices that start at something other than 1), you should specialize axes. You should also specialize similar so that the dims argument (ordinarily a Dims size-tuple) can accept AbstractUnitRange objects, perhaps range-types Ind of your own design. For more information, see Arrays with custom indices.","page":"Interfaces"},{"title":"Strided Arrays","location":"manual/interfaces.html#man-interface-strided-arrays","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement  Brief description\nstrides(A)  Return the distance in memory (in number of elements) between adjacent elements in each dimension as a tuple. If A is an AbstractArray{T,0}, this should return an empty tuple.\nBase.unsafe_convert(::Type{Ptr{T}}, A)  Return the native address of an array.\nBase.elsize(::Type{<:A})  Return the stride between consecutive elements in the array.\nOptional methods Default definition Brief description\nstride(A, i::Int) strides(A)[i] Return the distance in memory (in number of elements) between adjacent elements in dimension k.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"A strided array is a subtype of AbstractArray whose entries are stored in memory with fixed strides. Provided the element type of the array is compatible with BLAS, a strided array can utilize BLAS and LAPACK routines for more efficient linear algebra routines.  A typical example of a user-defined strided array is one that wraps a standard Array with additional structure.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Warning: do not implement these methods if the underlying storage is not actually strided, as it may lead to incorrect results or segmentation faults.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Here are some examples to demonstrate which type of arrays are strided and which are not:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"1:5   # not strided (there is no storage associated with this array.)\nVector(1:5)  # is strided with strides (1,)\nA = [1 5; 2 6; 3 7; 4 8]  # is strided with strides (1,4)\nV = view(A, 1:2, :)   # is strided with strides (1,4)\nV = view(A, 1:2:3, 1:2)   # is strided with strides (2,4)\nV = view(A, [1,2,4], :)   # is not strided, as the spacing between rows is not fixed.","page":"Interfaces"},{"title":"Customizing broadcasting","location":"manual/interfaces.html#man-interfaces-broadcasting","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement Brief description\nBase.BroadcastStyle(::Type{SrcType}) = SrcStyle() Broadcasting behavior of SrcType\nBase.similar(bc::Broadcasted{DestStyle}, ::Type{ElType}) Allocation of output container\nOptional methods \nBase.BroadcastStyle(::Style1, ::Style2) = Style12() Precedence rules for mixing styles\nBase.axes(x) Declaration of the indices of x, as per axes(x).\nBase.broadcastable(x) Convert x to an object that has axes and supports indexing\nBypassing default machinery \nBase.copy(bc::Broadcasted{DestStyle}) Custom implementation of broadcast\nBase.copyto!(dest, bc::Broadcasted{DestStyle}) Custom implementation of broadcast!, specializing on DestStyle\nBase.copyto!(dest::DestType, bc::Broadcasted{Nothing}) Custom implementation of broadcast!, specializing on DestType\nBase.Broadcast.broadcasted(f, args...) Override the default lazy behavior within a fused expression\nBase.Broadcast.instantiate(bc::Broadcasted{DestStyle}) Override the computation of the lazy broadcast's axes","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Broadcasting is triggered by an explicit call to broadcast or broadcast!, or implicitly by \"dot\" operations like A .+ b or f.(x, y). Any object that has axes and supports indexing can participate as an argument in broadcasting, and by default the result is stored in an Array. This basic framework is extensible in three major ways:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Ensuring that all arguments support broadcast\nSelecting an appropriate output array for the given set of arguments\nSelecting an efficient implementation for the given set of arguments","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Not all types support axes and indexing, but many are convenient to allow in broadcast. The Base.broadcastable function is called on each argument to broadcast, allowing it to return something different that supports axes and indexing. By default, this is the identity function for all AbstractArrays and Numbers — they already support axes and indexing.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If a type is intended to act like a \"0-dimensional scalar\" (a single object) rather than as a container for broadcasting, then the following method should be defined:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.broadcastable(o::MyType) = Ref(o)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"that returns the argument wrapped in a 0-dimensional Ref container.   For example, such a wrapper method is defined for types themselves, functions, special singletons like missing and nothing, and dates.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Custom array-like types can specialize Base.broadcastable to define their shape, but they should follow the convention that collect(Base.broadcastable(x)) == collect(x). A notable exception is AbstractString; strings are special-cased to behave as scalars for the purposes of broadcast even though they are iterable collections of their characters (see Strings for more).","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The next two steps (selecting the output array and implementation) are dependent upon determining a single answer for a given set of arguments. Broadcast must take all the varied types of its arguments and collapse them down to just one output array and one implementation. Broadcast calls this single answer a \"style\". Every broadcastable object each has its own preferred style, and a promotion-like system is used to combine these styles into a single answer — the \"destination style\".","page":"Interfaces"},{"title":"Broadcast Styles","location":"manual/interfaces.html#Broadcast-Styles","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle is the abstract type from which all broadcast styles are derived. When used as a function it has two possible forms, unary (single-argument) and binary. The unary variant states that you intend to implement specific broadcasting behavior and/or output type, and do not wish to rely on the default fallback Broadcast.DefaultArrayStyle.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"To override these defaults, you can define a custom BroadcastStyle for your object:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"struct MyStyle <: Broadcast.BroadcastStyle end\nBase.BroadcastStyle(::Type{<:MyType}) = MyStyle()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In some cases it might be convenient not to have to define MyStyle, in which case you can leverage one of the general broadcast wrappers:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Type{<:MyType}) = Broadcast.Style{MyType}() can be used for arbitrary types.\nBase.BroadcastStyle(::Type{<:MyType}) = Broadcast.ArrayStyle{MyType}() is preferred if MyType is an AbstractArray.\nFor AbstractArrays that only support a certain dimensionality, create a subtype of Broadcast.AbstractArrayStyle{N} (see below).","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"When your broadcast operation involves several arguments, individual argument styles get combined to determine a single DestStyle that controls the type of the output container. For more details, see below.","page":"Interfaces"},{"title":"Selecting an appropriate output array","location":"manual/interfaces.html#Selecting-an-appropriate-output-array","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The broadcast style is computed for every broadcasting operation to allow for dispatch and specialization. The actual allocation of the result array is handled by similar, using the Broadcasted object as its first argument.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.similar(bc::Broadcasted{DestStyle}, ::Type{ElType})","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The fallback definition is","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"similar(bc::Broadcasted{DefaultArrayStyle{N}}, ::Type{ElType}) where {N,ElType} =\n    similar(Array{ElType}, axes(bc))","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"However, if needed you can specialize on any or all of these arguments. The final argument bc is a lazy representation of a (potentially fused) broadcast operation, a Broadcasted object.  For these purposes, the most important fields of the wrapper are f and args, describing the function and argument list, respectively.  Note that the argument list can — and often does — include other nested Broadcasted wrappers.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For a complete example, let's say you have created a type, ArrayAndChar, that stores an array and a single character:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"struct ArrayAndChar{T,N} <: AbstractArray{T,N}\n    data::Array{T,N}\n    char::Char\nend\nBase.size(A::ArrayAndChar) = size(A.data)\nBase.getindex(A::ArrayAndChar{T,N}, inds::Vararg{Int,N}) where {T,N} = A.data[inds...]\nBase.setindex!(A::ArrayAndChar{T,N}, val, inds::Vararg{Int,N}) where {T,N} = A.data[inds...] = val\nBase.showarg(io::IO, A::ArrayAndChar, toplevel) = print(io, typeof(A), \" with char '\", A.char, \"'\")","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"You might want broadcasting to preserve the char \"metadata\". First we define","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Type{<:ArrayAndChar}) = Broadcast.ArrayStyle{ArrayAndChar}()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This means we must also define a corresponding similar method:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"function Base.similar(bc::Broadcast.Broadcasted{Broadcast.ArrayStyle{ArrayAndChar}}, ::Type{ElType}) where ElType\n    # Scan the inputs for the ArrayAndChar:\n    A = find_aac(bc)\n    # Use the char field of A to create the output\n    ArrayAndChar(similar(Array{ElType}, axes(bc)), A.char)\nend\n\n\"`A = find_aac(As)` returns the first ArrayAndChar among the arguments.\"\nfind_aac(bc::Base.Broadcast.Broadcasted) = find_aac(bc.args)\nfind_aac(args::Tuple) = find_aac(find_aac(args[1]), Base.tail(args))\nfind_aac(x) = x\nfind_aac(::Tuple{}) = nothing\nfind_aac(a::ArrayAndChar, rest) = a\nfind_aac(::Any, rest) = find_aac(rest)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"From these definitions, one obtains the following behavior:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> a = ArrayAndChar([1 2; 3 4], 'x')\n2×2 ArrayAndChar{Int64, 2} with char 'x':\n 1  2\n 3  4\n\njulia> a .+ 1\n2×2 ArrayAndChar{Int64, 2} with char 'x':\n 2  3\n 4  5\n\njulia> a .+ [5,10]\n2×2 ArrayAndChar{Int64, 2} with char 'x':\n  6   7\n 13  14","page":"Interfaces"},{"title":"Extending broadcast with custom implementations","location":"manual/interfaces.html#extending-in-place-broadcast","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In general, a broadcast operation is represented by a lazy Broadcasted container that holds onto the function to be applied alongside its arguments. Those arguments may themselves be more nested Broadcasted containers, forming a large expression tree to be evaluated. A nested tree of Broadcasted containers is directly constructed by the implicit dot syntax; 5 .+ 2.*x is transiently represented by Broadcasted(+, 5, Broadcasted(*, 2, x)), for example. This is invisible to users as it is immediately realized through a call to copy, but it is this container that provides the basis for broadcast's extensibility for authors of custom types. The built-in broadcast machinery will then determine the result type and size based upon the arguments, allocate it, and then finally copy the realization of the Broadcasted object into it with a default copyto!(::AbstractArray, ::Broadcasted) method. The built-in fallback broadcast and broadcast! methods similarly construct a transient Broadcasted representation of the operation so they can follow the same codepath. This allows custom array implementations to provide their own copyto! specialization to customize and optimize broadcasting. This is again determined by the computed broadcast style. This is such an important part of the operation that it is stored as the first type parameter of the Broadcasted type, allowing for dispatch and specialization.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For some types, the machinery to \"fuse\" operations across nested levels of broadcasting is not available or could be done more efficiently incrementally. In such cases, you may need or want to evaluate x .* (x .+ 1) as if it had been written broadcast(*, x, broadcast(+, x, 1)), where the inner operation is evaluated before tackling the outer operation. This sort of eager operation is directly supported by a bit of indirection; instead of directly constructing Broadcasted objects, Julia lowers the fused expression x .* (x .+ 1) to Broadcast.broadcasted(*, x, Broadcast.broadcasted(+, x, 1)). Now, by default, broadcasted just calls the Broadcasted constructor to create the lazy representation of the fused expression tree, but you can choose to override it for a particular combination of function and arguments.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"As an example, the builtin AbstractRange objects use this machinery to optimize pieces of broadcasted expressions that can be eagerly evaluated purely in terms of the start, step, and length (or stop) instead of computing every single element. Just like all the other machinery, broadcasted also computes and exposes the combined broadcast style of its arguments, so instead of specializing on broadcasted(f, args...), you can specialize on broadcasted(::DestStyle, f, args...) for any combination of style, function, and arguments.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For example, the following definition supports the negation of ranges:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"broadcasted(::DefaultArrayStyle{1}, ::typeof(-), r::OrdinalRange) = range(-first(r), step=-step(r), length=length(r))","page":"Interfaces"},{"title":"Extending in-place broadcasting","location":"manual/interfaces.html#extending-in-place-broadcast-2","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In-place broadcasting can be supported by defining the appropriate copyto!(dest, bc::Broadcasted) method. Because you might want to specialize either on dest or the specific subtype of bc, to avoid ambiguities between packages we recommend the following convention.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If you wish to specialize on a particular style DestStyle, define a method for","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"copyto!(dest, bc::Broadcasted{DestStyle})","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Optionally, with this form you can also specialize on the type of dest.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If instead you want to specialize on the destination type DestType without specializing on DestStyle, then you should define a method with the following signature:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"copyto!(dest::DestType, bc::Broadcasted{Nothing})","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"This leverages a fallback implementation of copyto! that converts the wrapper into a Broadcasted{Nothing}. Consequently, specializing on DestType has lower precedence than methods that specialize on DestStyle.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Similarly, you can completely override out-of-place broadcasting with a copy(::Broadcasted) method.","page":"Interfaces"},{"title":"Working with Broadcasted objects","location":"manual/interfaces.html#Working-with-Broadcasted-objects","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In order to implement such a copy or copyto!, method, of course, you must work with the Broadcasted wrapper to compute each element. There are two main ways of doing so:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Broadcast.flatten recomputes the potentially nested operation into a single function and flat list of arguments. You are responsible for implementing the broadcasting shape rules yourself, but this may be helpful in limited situations.\nIterating over the CartesianIndices of the axes(::Broadcasted) and using indexing with the resulting CartesianIndex object to compute the result.","page":"Interfaces"},{"title":"Writing binary broadcasting rules","location":"manual/interfaces.html#writing-binary-broadcasting-rules","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"The precedence rules are defined by binary BroadcastStyle calls:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Style1, ::Style2) = Style12()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"where Style12 is the BroadcastStyle you want to choose for outputs involving arguments of Style1 and Style2. For example,","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Base.BroadcastStyle(::Broadcast.Style{Tuple}, ::Broadcast.AbstractArrayStyle{0}) = Broadcast.Style{Tuple}()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"indicates that Tuple \"wins\" over zero-dimensional arrays (the output container will be a tuple). It is worth noting that you do not need to (and should not) define both argument orders of this call; defining one is sufficient no matter what order the user supplies the arguments in.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For AbstractArray types, defining a BroadcastStyle supersedes the fallback choice, Broadcast.DefaultArrayStyle. DefaultArrayStyle and the abstract supertype, AbstractArrayStyle, store the dimensionality as a type parameter to support specialized array types that have fixed dimensionality requirements.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"DefaultArrayStyle \"loses\" to any other AbstractArrayStyle that has been defined because of the following methods:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"BroadcastStyle(a::AbstractArrayStyle{Any}, ::DefaultArrayStyle) = a\nBroadcastStyle(a::AbstractArrayStyle{N}, ::DefaultArrayStyle{N}) where N = a\nBroadcastStyle(a::AbstractArrayStyle{M}, ::DefaultArrayStyle{N}) where {M,N} =\n    typeof(a)(Val(max(M, N)))","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"You do not need to write binary BroadcastStyle rules unless you want to establish precedence for two or more non-DefaultArrayStyle types.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"If your array type does have fixed dimensionality requirements, then you should subtype AbstractArrayStyle. For example, the sparse array code has the following definitions:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"struct SparseVecStyle <: Broadcast.AbstractArrayStyle{1} end\nstruct SparseMatStyle <: Broadcast.AbstractArrayStyle{2} end\nBase.BroadcastStyle(::Type{<:SparseVector}) = SparseVecStyle()\nBase.BroadcastStyle(::Type{<:SparseMatrixCSC}) = SparseMatStyle()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Whenever you subtype AbstractArrayStyle, you also need to define rules for combining dimensionalities, by creating a constructor for your style that takes a Val(N) argument. For example:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"SparseVecStyle(::Val{0}) = SparseVecStyle()\nSparseVecStyle(::Val{1}) = SparseVecStyle()\nSparseVecStyle(::Val{2}) = SparseMatStyle()\nSparseVecStyle(::Val{N}) where N = Broadcast.DefaultArrayStyle{N}()","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"These rules indicate that the combination of a SparseVecStyle with 0- or 1-dimensional arrays yields another SparseVecStyle, that its combination with a 2-dimensional array yields a SparseMatStyle, and anything of higher dimensionality falls back to the dense arbitrary-dimensional framework. These rules allow broadcasting to keep the sparse representation for operations that result in one or two dimensional outputs, but produce an Array for any other dimensionality.","page":"Interfaces"},{"title":"Instance Properties","location":"manual/interfaces.html#man-instance-properties","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement Default definition Brief description\npropertynames(x::ObjType, private::Bool=false) fieldnames(typeof(x)) Return a tuple of the properties (x.property) of an object x. If private=true, also return property names intended to be kept as private\ngetproperty(x::ObjType, s::Symbol) getfield(x, s) Return property s of x. x.s calls getproperty(x, :s).\nsetproperty!(x::ObjType, s::Symbol, v) setfield!(x, s, v) Set property s of x to v. x.s = v calls setproperty!(x, :s, v). Should return v.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Sometimes, it is desirable to change how the end-user interacts with the fields of an object. Instead of granting direct access to type fields, an extra layer of abstraction between the user and the code can be provided by overloading object.field. Properties are what the user sees of the object, fields what the object actually is.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"By default, properties and fields are the same. However, this behavior can be changed. For example, take this representation of a point in a plane in polar coordinates:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> mutable struct Point\n           r::Float64\n           ϕ::Float64\n       end\n\njulia> p = Point(7.0, pi/4)\nPoint(7.0, 0.7853981633974483)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"As described in the table above dot access p.r is the same as getproperty(p, :r) which is by default the same as getfield(p, :r):","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> propertynames(p)\n(:r, :ϕ)\n\njulia> getproperty(p, :r), getproperty(p, :ϕ)\n(7.0, 0.7853981633974483)\n\njulia> p.r, p.ϕ\n(7.0, 0.7853981633974483)\n\njulia> getfield(p, :r), getproperty(p, :ϕ)\n(7.0, 0.7853981633974483)","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"However, we may want users to be unaware that Point stores the coordinates as r and ϕ (fields), and instead interact with x and y (properties). The methods in the first column can be defined to add new functionality:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> Base.propertynames(::Point, private::Bool=false) = private ? (:x, :y, :r, :ϕ) : (:x, :y)\n\njulia> function Base.getproperty(p::Point, s::Symbol)\n           if s === :x\n               return getfield(p, :r) * cos(getfield(p, :ϕ))\n           elseif s === :y\n               return getfield(p, :r) * sin(getfield(p, :ϕ))\n           else\n               # This allows accessing fields with p.r and p.ϕ\n               return getfield(p, s)\n           end\n       end\n\njulia> function Base.setproperty!(p::Point, s::Symbol, f)\n           if s === :x\n               y = p.y\n               setfield!(p, :r, sqrt(f^2 + y^2))\n               setfield!(p, :ϕ, atan(y, f))\n               return f\n           elseif s === :y\n               x = p.x\n               setfield!(p, :r, sqrt(x^2 + f^2))\n               setfield!(p, :ϕ, atan(f, x))\n               return f\n           else\n               # This allow modifying fields with p.r and p.ϕ\n               return setfield!(p, s, f)\n           end\n       end","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"It is important that getfield and setfield are used inside getproperty and setproperty! instead of the dot syntax, since the dot syntax would make the functions recursive which can lead to type inference issues. We can now try out the new functionality:","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> propertynames(p)\n(:x, :y)\n\njulia> p.x\n4.949747468305833\n\njulia> p.y = 4.0\n4.0\n\njulia> p.r\n6.363961030678928","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Finally, it is worth noting that adding instance properties like this is quite rarely done in Julia and should in general only be done if there is a good reason for doing so.","page":"Interfaces"},{"title":"Rounding","location":"manual/interfaces.html#man-rounding-interface","category":"section","text":"","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"Methods to implement Default definition Brief description\nround(x::ObjType, r::RoundingMode) none Round x and return the result. If possible, round should return an object of the same type as x\nround(T::Type, x::ObjType, r::RoundingMode) convert(T, round(x, r)) Round x, returning the result as a T","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"To support rounding on a new type it is typically sufficient to define the single method round(x::ObjType, r::RoundingMode). The passed rounding mode determines in which direction the value should be rounded. The most commonly used rounding modes are RoundNearest, RoundToZero, RoundDown, and RoundUp, as these rounding modes are used in the definitions of the one argument round, method, and trunc, floor, and ceil, respectively.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"In some cases, it is possible to define a three-argument round method that is more accurate or performant than the two-argument method followed by conversion. In this case it is acceptable to define the three argument method in addition to the two argument method. If it is impossible to represent the rounded result as an object of the type T, then the three argument method should throw an InexactError.","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"For example, if we have an Interval type which represents a range of possible values similar to https://github.com/JuliaPhysics/Measurements.jl, we may define rounding on that type with the following","page":"Interfaces"},{"title":"Interfaces","location":"manual/interfaces.html","category":"page","text":"julia> struct Interval{T}\n           min::T\n           max::T\n       end\n\njulia> Base.round(x::Interval, r::RoundingMode) = Interval(round(x.min, r), round(x.max, r))\n\njulia> x = Interval(1.7, 2.2)\nInterval{Float64}(1.7, 2.2)\n\njulia> round(x)\nInterval{Float64}(2.0, 2.0)\n\njulia> floor(x)\nInterval{Float64}(1.0, 2.0)\n\njulia> ceil(x)\nInterval{Float64}(2.0, 3.0)\n\njulia> trunc(x)\nInterval{Float64}(1.0, 2.0)","page":"Interfaces"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html#Fixing-precompilation-hangs-due-to-open-tasks-or-IO","category":"section","text":"","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"On Julia 1.10 or higher, you might see the following message:","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"(Image: Screenshot of precompilation hang)","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"This may repeat. If it continues to repeat with no hints that it will resolve itself, you may have a \"precompilation hang\" that requires fixing. Even if it's transient, you might prefer to resolve it so that users will not be bothered by this warning.  This page walks you through how to analyze and fix such issues.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"If you follow the advice and hit Ctrl-C, you might see","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"^C Interrupted: Exiting precompilation...\n\n  1 dependency had warnings during precompilation:\n┌ Test1 [ac89d554-e2ba-40bc-bc5c-de68b658c982]\n│  [pid 2745] waiting for IO to finish:\n│   Handle type        uv_handle_t->data\n│   timer              0x55580decd1e0->0x7f94c3a4c340","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"This message conveys two key pieces of information:","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"the hang is occurring during precompilation of Test1, a dependency of Test2 (the package we were trying to load with using Test2)\nduring precompilation of Test1, Julia created a Timer object (use ?Timer if you're unfamiliar with Timers) which is still open; until that closes, the process is hung","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"If this is enough of a hint for you to figure out how timer = Timer(args...) is being created, one good solution is to add wait(timer) if timer eventually finishes on its own, or close(timer) if you need to force-close it, before the final end of the module.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"However, there are cases that may not be that straightforward. Usually the best option is to start by determining whether the hang is due to code in Test1 or whether it is due to one of Test1's dependencies:","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"Option 1: Pkg.add(\"Aqua\") and use Aqua.test_persistent_tasks. This should help you identify which package is causing the problem, after which the instructions below should be followed. If needed, you can create a PkgId as Base.PkgId(UUID(\"...\"), \"Test1\"), where ... comes from the uuid entry in Test1/Project.toml.\nOption 2: manually diagnose the source of the hang.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"To manually diagnose:","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"Pkg.develop(\"Test1\")\nComment out all the code included or defined in Test1, except the using/import statements.\nTry using Test2 (or even using Test1 assuming that hangs too) again","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"Now we arrive at a fork in the road: either","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"the hang persists, indicating it is due to one of your dependencies\nthe hang disappears, indicating that it is due to something in your code.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Diagnosing and fixing hangs due to a package dependency","location":"devdocs/precompile_hang.html#pchang_deps","category":"section","text":"","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"Use a binary search to identify the problematic dependency: start by commenting out half your dependencies, then when you isolate which half is responsible comment out half of that half, etc. (You don't have to remove them from the project, just comment out the using/import statements.)","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"Once you've identified a suspect (here we'll call it ThePackageYouThinkIsCausingTheProblem), first try precompiling that package. If it also hangs during precompilation, continue chasing the problem backwards.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"However, most likely ThePackageYouThinkIsCausingTheProblem will precompile fine. This suggests it's in the function ThePackageYouThinkIsCausingTheProblem.__init__, which does not run during precompilation of ThePackageYouThinkIsCausingTheProblem but does in any package that loads ThePackageYouThinkIsCausingTheProblem.  To test this theory, set up a minimal working example (MWE), something like","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"(@v1.10) pkg> generate MWE\n  Generating  project MWE:\n    MWE\\Project.toml\n    MWE\\src\\MWE.jl","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"where the source code of MWE.jl is","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"module MWE\nusing ThePackageYouThinkIsCausingTheProblem\nend","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"and you've added ThePackageYouThinkIsCausingTheProblem to MWE's dependencies.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"If that MWE reproduces the hang, you've found your culprit: ThePackageYouThinkIsCausingTheProblem.__init__ must be creating the Timer object. If the timer object can be safely closed, that's a good option. Otherwise, the most common solution is to avoid creating the timer while any package is being precompiled: add","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"ccall(:jl_generating_output, Cint, ()) == 1 && return nothing","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"as the first line of ThePackageYouThinkIsCausingTheProblem.__init__, and it will avoid doing any initialization in any Julia process whose purpose is to precompile packages.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing package code to avoid hangs","location":"devdocs/precompile_hang.html#pchang_fix","category":"section","text":"","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"Search your package for suggestive words (here like \"Timer\") and see if you can identify where the problem is being created. Note that a method definition like","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"maketimer() = Timer(timer -> println(\"hi\"), 0; interval=1)","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"is not problematic in and of itself: it can cause this problem only if maketimer gets called while the module is being defined. This might be happening from a top-level statement such as","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"const GLOBAL_TIMER = maketimer()","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"or it might conceivably occur in a precompile workload.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Fixing precompilation hangs due to open tasks or IO","location":"devdocs/precompile_hang.html","category":"page","text":"If you struggle to identify the causative lines, then consider doing a binary search: comment out sections of your package (or include lines to omit entire files) until you've reduced the problem in scope.","page":"Fixing precompilation hangs due to open tasks or IO"},{"title":"Linux","location":"devdocs/build/linux.html#Linux","category":"section","text":"","page":"Linux"},{"title":"Linux","location":"devdocs/build/linux.html","category":"page","text":"GCC version 4.7 or later is required to build Julia.\nTo use external shared libraries not in the system library search path, set USE_SYSTEM_XXX=1 and LDFLAGS=-Wl,-rpath,/path/to/dir/contains/libXXX.so in Make.user.\nInstead of setting LDFLAGS, putting the library directory into the environment variable LD_LIBRARY_PATH (at both compile and run time) also works.\nThe USE_SYSTEM_* flags should be used with caution. These are meant only for troubleshooting, porting, and packaging, where package maintainers work closely with the Julia developers to make sure that Julia is built correctly. Production use cases should use the officially provided binaries. Issues arising from the use of these flags will generally not be accepted.\nSee also the external dependencies.","page":"Linux"},{"title":"Architecture Customization","location":"devdocs/build/linux.html#Architecture-Customization","category":"section","text":"","page":"Linux"},{"title":"Linux","location":"devdocs/build/linux.html","category":"page","text":"Julia can be built for a non-generic architecture by configuring the ARCH Makefile variable in a Make.user file. See the appropriate section of Make.inc for additional customization options, such as MARCH and JULIA_CPU_TARGET.","page":"Linux"},{"title":"Linux","location":"devdocs/build/linux.html","category":"page","text":"For example, to build for Pentium 4, set MARCH=pentium4 and install the necessary system libraries for linking. On Ubuntu, these may include lib32gfortran-6-dev, lib32gcc1, and lib32stdc++6, among others.","page":"Linux"},{"title":"Linux","location":"devdocs/build/linux.html","category":"page","text":"You can also set MARCH=native in Make.user for a maximum-performance build customized for the current machine CPU.","page":"Linux"},{"title":"Linux Build Troubleshooting","location":"devdocs/build/linux.html#Linux-Build-Troubleshooting","category":"section","text":"","page":"Linux"},{"title":"Linux","location":"devdocs/build/linux.html","category":"page","text":"Problem Possible Solution\nOpenBLAS build failure Set one of the following build options in Make.user and build again: <ul><li> OPENBLAS_TARGET_ARCH=BARCELONA (AMD CPUs) or OPENBLAS_TARGET_ARCH=NEHALEM (Intel CPUs)<ul>Set OPENBLAS_DYNAMIC_ARCH = 0 to disable compiling multiple architectures in a single binary.</ul></li><li> OPENBLAS_NO_AVX2 = 1 disables AVX2 instructions, allowing OpenBLAS to compile with OPENBLAS_DYNAMIC_ARCH = 1 using old versions of binutils </li><li> USE_SYSTEM_BLAS=1 uses the system provided libblas <ul><li>Set LIBBLAS=-lopenblas and LIBBLASNAME=libopenblas to force the use of the system provided OpenBLAS when multiple BLAS versions are installed. </li></ul></li></ul><p> If you get an error that looks like ../kernel/x86_64/dgemm_kernel_4x4_haswell.S:1709: Error: no such instruction: `vpermpd $ 0xb1,%ymm0,%ymm0', then you need to set OPENBLAS_DYNAMIC_ARCH = 0 or OPENBLAS_NO_AVX2 = 1, or you need a newer version of binutils (2.18 or newer). (Issue #7653)</p><p> If the linker cannot find gfortran and you get an error like julia /usr/bin/x86_64-linux-gnu-ld: cannot find -lgfortran, check the path with gfortran -print-file-name=libgfortran.so and use the output to export something similar to this: export LDFLAGS=-L/usr/lib/gcc/x86_64-linux-gnu/8/. See Issue #6150.</p>\nIllegal Instruction error Check if your CPU supports AVX while your OS does not (e.g. through virtualization, as described in this issue).","page":"Linux"},{"title":"Julia ASTs","location":"devdocs/ast.html#Julia-ASTs","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Julia has two representations of code. First there is a surface syntax AST returned by the parser (e.g. the Meta.parse function), and manipulated by macros. It is a structured representation of code as it is written, constructed by julia-parser.scm from a character stream. Next there is a lowered form, or IR (intermediate representation), which is used by type inference and code generation. In the lowered form there are fewer types of nodes, all macros are expanded, and all control flow is converted to explicit branches and sequences of statements. The lowered form is constructed by julia-syntax.scm.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"First we will focus on the AST, since it is needed to write macros.","page":"Julia ASTs"},{"title":"Surface syntax AST","location":"devdocs/ast.html#Surface-syntax-AST","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Front end ASTs consist almost entirely of Exprs and atoms (e.g. symbols, numbers). There is generally a different expression head for each visually distinct syntactic form. Examples will be given in s-expression syntax. Each parenthesized list corresponds to an Expr, where the first element is the head. For example (call f x) corresponds to Expr(:call, :f, :x) in Julia.","page":"Julia ASTs"},{"title":"Calls","location":"devdocs/ast.html#Calls","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\nf(x) (call f x)\nf(x, y=1, z=2) (call f x (kw y 1) (kw z 2))\nf(x; y=1) (call f (parameters (kw y 1)) x)\nf(x...) (call f (... x))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"do syntax:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"f(x) do a,b\n    body\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as (do (call f x) (-> (tuple a b) (block body))).","page":"Julia ASTs"},{"title":"Operators","location":"devdocs/ast.html#Operators","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Most uses of operators are just function calls, so they are parsed with the head call. However some operators are special forms (not necessarily function calls), and in those cases the operator itself is the expression head. In julia-parser.scm these are referred to as \"syntactic operators\". Some operators (+ and *) use N-ary parsing; chained calls are parsed as a single N-argument call. Finally, chains of comparisons have their own special expression structure.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\nx+y (call + x y)\na+b+c+d (call + a b c d)\n2x (call * 2 x)\na&&b (&& a b)\nx += 1 (+= x 1)\na ? 1 : 2 (if a 1 2)\na,b (tuple a b)\na==b (call == a b)\n1<i<=n (comparison 1 < i <= n)\na.b (. a (quote b))\na.(b) (. a (tuple b))","page":"Julia ASTs"},{"title":"Bracketed forms","location":"devdocs/ast.html#Bracketed-forms","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\na[i] (ref a i)\nt[i;j] (typed_vcat t i j)\nt[i j] (typed_hcat t i j)\nt[a b; c d] (typed_vcat t (row a b) (row c d))\nt[a b;;; c d] (typed_ncat t 3 (row a b) (row c d))\na{b} (curly a b)\na{b;c} (curly a (parameters c) b)\n[x] (vect x)\n[x,y] (vect x y)\n[x;y] (vcat x y)\n[x y] (hcat x y)\n[x y; z t] (vcat (row x y) (row z t))\n[x;y;; z;t;;;] (ncat 3 (nrow 2 (nrow 1 x y) (nrow 1 z t)))\n[x for y in z, a in b] (comprehension (generator x (= y z) (= a b)))\nT[x for y in z] (typed_comprehension T (generator x (= y z)))\n(a, b, c) (tuple a b c)\n(a; b; c) (block a b c)","page":"Julia ASTs"},{"title":"Macros","location":"devdocs/ast.html#Macros","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\n@m x y (macrocall @m (line) x y)\nBase.@m x y (macrocall (. Base (quote @m)) (line) x y)\n@Base.m x y (macrocall (. Base (quote @m)) (line) x y)","page":"Julia ASTs"},{"title":"Strings","location":"devdocs/ast.html#Strings","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\n\"a\" \"a\"\nx\"y\" (macrocall @x_str (line) \"y\")\nx\"y\"z (macrocall @x_str (line) \"y\" \"z\")\n\"x = $x\" (string \"x = \" x)\n`a b c` (macrocall @cmd (line) \"a b c\")","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Doc string syntax:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"\"some docs\"\nf(x) = x","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as (macrocall (|.| Core '@doc) (line) \"some docs\" (= (call f x) (block x))).","page":"Julia ASTs"},{"title":"Imports and such","location":"devdocs/ast.html#Imports-and-such","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\nimport a (import (. a))\nimport a.b.c (import (. a b c))\nimport ...a (import (. . . . a))\nimport a.b, c.d (import (. a b) (. c d))\nimport Base: x (import (: (. Base) (. x)))\nimport Base: x, y (import (: (. Base) (. x) (. y)))\nexport a, b (export a b)","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"using has the same representation as import, but with expression head :using instead of :import.","page":"Julia ASTs"},{"title":"Numbers","location":"devdocs/ast.html#Numbers","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Julia supports more number types than many scheme implementations, so not all numbers are represented directly as scheme numbers in the AST.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Input AST\n11111111111111111111 (macrocall @int128_str nothing \"11111111111111111111\")\n0xfffffffffffffffff (macrocall @uint128_str nothing \"0xfffffffffffffffff\")\n1111...many digits... (macrocall @big_str nothing \"1111....\")","page":"Julia ASTs"},{"title":"Block forms","location":"devdocs/ast.html#Block-forms","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A block of statements is parsed as (block stmt1 stmt2 ...).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"If statement:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"if a\n    b\nelseif c\n    d\nelse\n    e\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"(if a (block (line 2) b)\n    (elseif (block (line 3) c) (block (line 4) d)\n            (block (line 6 e))))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A while loop parses as (while condition body).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A for loop parses as (for (= var iter) body). If there is more than one iteration specification, they are parsed as a block: (for (block (= v1 iter1) (= v2 iter2)) body).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"break and continue are parsed as 0-argument expressions (break) and (continue).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"let is parsed as (let (= var val) body) or (let (block (= var1 val1) (= var2 val2) ...) body), like for loops.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A basic function definition is parsed as (function (call f x) body). A more complex example:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"function f(x::T; k = 1) where T\n    return x+1\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"(function (where (call f (parameters (kw k 1))\n                       (:: x T))\n                 T)\n          (block (line 2) (return (call + x 1))))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Type definition:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"mutable struct Foo{T<:S}\n    x::T\nend","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"parses as:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"(struct true (curly Foo (<: T S))\n        (block (line 2) (:: x T)))","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"The first argument is a boolean telling whether the type is mutable.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"try blocks parse as (try try_block var catch_block finally_block). If no variable is present after catch, var is #f. If there is no finally clause, then the last argument is not present.","page":"Julia ASTs"},{"title":"Quote expressions","location":"devdocs/ast.html#Quote-expressions","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Julia source syntax forms for code quoting (quote and :( )) support interpolation with $. In Lisp terminology, this means they are actually \"backquote\" or \"quasiquote\" forms. Internally, there is also a need for code quoting without interpolation. In Julia's scheme code, non-interpolating quote is represented with the expression head inert.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"inert expressions are converted to Julia QuoteNode objects. These objects wrap a single value of any type, and when evaluated simply return that value.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A quote expression whose argument is an atom also gets converted to a QuoteNode.","page":"Julia ASTs"},{"title":"Line numbers","location":"devdocs/ast.html#Line-numbers","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Source location information is represented as (line line_num file_name) where the third component is optional (and omitted when the current line number, but not file name, changes).","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"These expressions are represented as LineNumberNodes in Julia.","page":"Julia ASTs"},{"title":"Macros","location":"devdocs/ast.html#Macros-2","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Macro hygiene is represented through the expression head pair escape and hygienic-scope. The result of a macro expansion is automatically wrapped in (hygienic-scope block module), to represent the result of the new scope. The user can insert (escape block) inside to interpolate code from the caller.","page":"Julia ASTs"},{"title":"Lowered form","location":"devdocs/ast.html#Lowered-form","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Lowered form (IR) is more important to the compiler, since it is used for type inference, optimizations like inlining, and code generation. It is also less obvious to the human, since it results from a significant rearrangement of the input syntax.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"In addition to Symbols and some number types, the following data types exist in lowered form:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Expr\nHas a node type indicated by the head field, and an args field which is a Vector{Any} of subexpressions. While almost every part of a surface AST is represented by an Expr, the IR uses only a limited number of Exprs, mostly for calls and some top-level-only forms.\nSlotNumber\nIdentifies arguments and local variables by consecutive numbering. It has an integer-valued id field giving the slot index. The types of these slots can be found in the slottypes field of their CodeInfo object.\nArgument\nThe same as SlotNumber, but appears only post-optimization. Indicates that the referenced slot is an argument of the enclosing function.\nCodeInfo\nWraps the IR of a group of statements. Its code field is an array of expressions to execute.\nGotoNode\nUnconditional branch. The argument is the branch target, represented as an index in the code array to jump to.\nGotoIfNot\nConditional branch. If the cond field evaluates to false, goes to the index identified by the dest field.\nReturnNode\nReturns its argument (the val field) as the value of the enclosing function. If the val field is undefined, then this represents an unreachable statement.\nQuoteNode\nWraps an arbitrary value to reference as data. For example, the function f() = :a contains a QuoteNode whose value field is the symbol a, in order to return the symbol itself instead of evaluating it.\nGlobalRef\nRefers to global variable name in module mod.\nSSAValue\nRefers to a consecutively-numbered (starting at 1) static single assignment (SSA) variable inserted by the compiler. The number (id) of an SSAValue is the code array index of the expression whose value it represents.\nNewvarNode\nMarks a point where a variable (slot) is created. This has the effect of resetting a variable to undefined.","page":"Julia ASTs"},{"title":"Expr types","location":"devdocs/ast.html#Expr-types","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"These symbols appear in the head field of Exprs in lowered form.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"call\nFunction call (dynamic dispatch). args[1] is the function to call, args[2:end] are the arguments.\ninvoke\nFunction call (static dispatch). args[1] is the MethodInstance to call, args[2:end] are the arguments (including the function that is being called, at args[2]).\nstatic_parameter\nReference a static parameter by index.\n=\nAssignment. In the IR, the first argument is always a SlotNumber or a GlobalRef.\nmethod\nAdds a method to a generic function and assigns the result if necessary.\nHas a 1-argument form and a 3-argument form. The 1-argument form arises from the syntax function foo end. In the 1-argument form, the argument is a symbol. If this symbol already names a function in the current scope, nothing happens. If the symbol is undefined, a new function is created and assigned to the identifier specified by the symbol. If the symbol is defined but names a non-function, an error is raised. The definition of \"names a function\" is that the binding is constant, and refers to an object of singleton type. The rationale for this is that an instance of a singleton type uniquely identifies the type to add the method to. When the type has fields, it wouldn't be clear whether the method was being added to the instance or its type.\nThe 3-argument form has the following arguments:\nargs[1]\nA function name, or nothing if unknown or unneeded. If a symbol, then the expression first behaves like the 1-argument form above. This argument is ignored from then on. It can be nothing when methods are added strictly by type, (::T)(x) = x, or when a method is being added to an existing function, MyModule.f(x) = x.\nargs[2]\nA SimpleVector of argument type data. args[2][1] is a SimpleVector of the argument types, and args[2][2] is a SimpleVector of type variables corresponding to the method's static parameters.\nargs[3]\nA CodeInfo of the method itself. For \"out of scope\" method definitions (adding a method to a function that also has methods defined in different scopes) this is an expression that evaluates to a :lambda expression.\nstruct_type\nA 7-argument expression that defines a new struct:\nargs[1]\nThe name of the struct\nargs[2]\nA call expression that creates a SimpleVector specifying its parameters\nargs[3]\nA call expression that creates a SimpleVector specifying its fieldnames\nargs[4]\nA Symbol, GlobalRef, or Expr specifying the supertype (e.g., :Integer, GlobalRef(Core, :Any), or :(Core.apply_type(AbstractArray, T, N)))\nargs[5]\nA call expression that creates a SimpleVector specifying its fieldtypes\nargs[6]\nA Bool, true if mutable\nargs[7]\nThe number of arguments to initialize. This will be the number of fields, or the minimum number of fields called by an inner constructor's new statement.\nabstract_type\nA 3-argument expression that defines a new abstract type. The arguments are the same as arguments 1, 2, and 4 of struct_type expressions.\nprimitive_type\nA 4-argument expression that defines a new primitive type. Arguments 1, 2, and 4 are the same as struct_type. Argument 3 is the number of bits.\ncompat: Julia 1.5\nstruct_type, abstract_type, and primitive_type were removed in Julia 1.5 and replaced by calls to new builtins.\nglobal\nDeclares a global binding.\nconst\nDeclares a (global) variable as constant.\nnew\nAllocates a new struct-like object. First argument is the type. The new pseudo-function is lowered to this, and the type is always inserted by the compiler.  This is very much an internal-only feature, and does no checking. Evaluating arbitrary new expressions can easily segfault.\nsplatnew\nSimilar to new, except field values are passed as a single tuple. Works similarly to splat(new) if new were a first-class function, hence the name.\nisdefined\nExpr(:isdefined, :x) returns a Bool indicating whether x has already been defined in the current scope.\nthe_exception\nYields the caught exception inside a catch block, as returned by jl_current_exception(ct).\nenter\nEnters an exception handler (setjmp). args[1] is the label of the catch block to jump to on error.  Yields a token which is consumed by pop_exception.\nleave\nPop exception handlers. args[1] is the number of handlers to pop.\npop_exception\nPop the stack of current exceptions back to the state at the associated enter when leaving a catch block. args[1] contains the token from the associated enter.\ncompat: Julia 1.1\npop_exception is new in Julia 1.1.\ninbounds\nControls turning bounds checks on or off. A stack is maintained; if the first argument of this expression is true or false (true means bounds checks are disabled), it is pushed onto the stack. If the first argument is :pop, the stack is popped.\nboundscheck\nHas the value false if inlined into a section of code marked with @inbounds, otherwise has the value true.\nloopinfo\nMarks the end of the a loop. Contains metadata that is passed to LowerSimdLoop to either mark the inner loop of @simd expression, or to propagate information to LLVM loop passes.\ncopyast\nPart of the implementation of quasi-quote. The argument is a surface syntax AST that is simply copied recursively and returned at run time.\nmeta\nMetadata. args[1] is typically a symbol specifying the kind of metadata, and the rest of the arguments are free-form. The following kinds of metadata are commonly used:\n:inline and :noinline: Inlining hints.\nforeigncall\nStatically-computed container for ccall information. The fields are:\nargs[1] : name\nThe expression that'll be parsed for the foreign function.\nargs[2]::Type : RT\nThe (literal) return type, computed statically when the containing method was defined.\nargs[3]::SimpleVector (of Types) : AT\nThe (literal) vector of argument types, computed statically when the containing method was defined.\nargs[4]::Int : nreq\nThe number of required arguments for a varargs function definition.\nargs[5]::QuoteNode{Symbol} : calling convention\nThe calling convention for the call.\nargs[6:5+length(args[3])] : arguments\nThe values for all the arguments (with types of each given in args[3]).\nargs[6+length(args[3])+1:end] : gc-roots\nThe additional objects that may need to be gc-rooted for the duration of the call. See Working with LLVM for where these are derived from and how they get handled.\nnew_opaque_closure\nConstructs a new opaque closure. The fields are:\nargs[1] : signature\nThe function signature of the opaque closure. Opaque closures don't participate in dispatch, but the input types can be restricted.\nargs[2] : isva\nIndicates whether the closure accepts varargs.\nargs[3] : lb\nLower bound on the output type. (Defaults to Union{})\nargs[4] : ub\nUpper bound on the output type. (Defaults to Any)\nargs[5] : method\nThe actual method as an opaque_closure_method expression.\nargs[6:end] : captures\nThe values captured by the opaque closure.\ncompat: Julia 1.7\nOpaque closures were added in Julia 1.7","page":"Julia ASTs"},{"title":"Method","location":"devdocs/ast.html#ast-lowered-method","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A unique'd container describing the shared metadata for a single method.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"name, module, file, line, sig\nMetadata to uniquely identify the method for the computer and the human.\nambig\nCache of other methods that may be ambiguous with this one.\nspecializations\nCache of all MethodInstance ever created for this Method, used to ensure uniqueness. Uniqueness is required for efficiency, especially for incremental precompile and tracking of method invalidation.\nsource\nThe original source code (if available, usually compressed).\ngenerator\nA callable object which can be executed to get specialized source for a specific method signature.\nroots\nPointers to non-AST things that have been interpolated into the AST, required by compression of the AST, type-inference, or the generation of native code.\nnargs, isva, called, is_for_opaque_closure,\nDescriptive bit-fields for the source code of this Method.\nprimary_world\nThe world age that \"owns\" this Method.","page":"Julia ASTs"},{"title":"MethodInstance","location":"devdocs/ast.html#MethodInstance","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A unique'd container describing a single callable signature for a Method. See especially Proper maintenance and care of multi-threading locks for important details on how to modify these fields safely.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"specTypes\nThe primary key for this MethodInstance. Uniqueness is guaranteed through a def.specializations lookup.\ndef\nThe Method that this function describes a specialization of. Or a Module, if this is a top-level Lambda expanded in Module, and which is not part of a Method.\nsparam_vals\nThe values of the static parameters in specTypes. For the MethodInstance at Method.unspecialized, this is the empty SimpleVector. But for a runtime MethodInstance from the MethodTable cache, this will always be defined and indexable.\nuninferred\nThe uncompressed source code for a toplevel thunk. Additionally, for a generated function, this is one of many places that the source code might be found.\nbackedges\nWe store the reverse-list of cache dependencies for efficient tracking of incremental reanalysis/recompilation work that may be needed after a new method definitions. This works by keeping a list of the other MethodInstance that have been inferred or optimized to contain a possible call to this MethodInstance. Those optimization results might be stored somewhere in the cache, or it might have been the result of something we didn't want to cache, such as constant propagation. Thus we merge all of those backedges to various cache entries here (there's almost always only the one applicable cache entry with a sentinel value for max_world anyways).\ncache\nCache of CodeInstance objects that share this template instantiation.","page":"Julia ASTs"},{"title":"CodeInstance","location":"devdocs/ast.html#CodeInstance","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"def\nThe MethodInstance that this cache entry is derived from.\nowner\nA token that represents the owner of this CodeInstance. Will use jl_egal to match.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"rettype/rettype_const\nThe inferred return type for the specFunctionObject field, which (in most cases) is also the computed return type for the function in general.\ninferred\nMay contain a cache of the inferred source for this function, or it could be set to nothing to just indicate rettype is inferred.\nftpr\nThe generic jlcall entry point.\njlcall_api\nThe ABI to use when calling fptr. Some significant ones include:\n0 - Not compiled yet\n1 - JL_CALLABLE jl_value_t *(*)(jl_function_t *f, jl_value_t *args[nargs], uint32_t nargs)\n2 - Constant (value stored in rettype_const)\n3 - With Static-parameters forwarded jl_value_t *(*)(jl_svec_t *sparams, jl_function_t *f, jl_value_t *args[nargs], uint32_t nargs)\n4 - Run in interpreter jl_value_t *(*)(jl_method_instance_t *meth, jl_function_t *f, jl_value_t *args[nargs], uint32_t nargs)\nmin_world / max_world\nThe range of world ages for which this method instance is valid to be called. If max_world is the special token value -1, the value is not yet known. It may continue to be used until we encounter a backedge that requires us to reconsider.","page":"Julia ASTs"},{"title":"CodeInfo","location":"devdocs/ast.html#CodeInfo","category":"section","text":"","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"A (usually temporary) container for holding lowered source code.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"code\nAn Any array of statements\nslotnames\nAn array of symbols giving names for each slot (argument or local variable).\nslotflags\nA UInt8 array of slot properties, represented as bit flags:\n0x02 - assigned (only false if there are no assignment statements with this var on the left)\n0x08 - used (if there is any read or write of the slot)\n0x10 - statically assigned once\n0x20 - might be used before assigned. This flag is only valid after type inference.\nssavaluetypes\nEither an array or an Int.\nIf an Int, it gives the number of compiler-inserted temporary locations in the function (the length of code array). If an array, specifies a type for each location.\nssaflags\nStatement-level 32 bits flags for each expression in the function. See the definition of jl_code_info_t in julia.h for more details.\nlinetable\nAn array of source location objects\ncodelocs\nAn array of integer indices into the linetable, giving the location associated with each statement.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Optional Fields:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"slottypes\nAn array of types for the slots.\nrettype\nThe inferred return type of the lowered form (IR). Default value is Any.\nmethod_for_inference_limit_heuristics\nThe method_for_inference_heuristics will expand the given method's generator if necessary during inference.\nparent\nThe MethodInstance that \"owns\" this object (if applicable).\nedges\nForward edges to method instances that must be invalidated.\nmin_world/max_world\nThe range of world ages for which this code was valid at the time when it had been inferred.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"Boolean properties:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"inferred\nWhether this has been produced by type inference.\ninlineable\nWhether this should be eligible for inlining.\npropagate_inbounds\nWhether this should propagate @inbounds when inlined for the purpose of eliding @boundscheck blocks.","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"UInt8 settings:","page":"Julia ASTs"},{"title":"Julia ASTs","location":"devdocs/ast.html","category":"page","text":"constprop\n0 = use heuristic\n1 = aggressive\n2 = none\npurity Constructed from 5 bit flags:\n0x01 << 0 = this method is guaranteed to return or terminate consistently (:consistent)\n0x01 << 1 = this method is free from externally semantically visible side effects (:effect_free)\n0x01 << 2 = this method is guaranteed to not throw an exception (:nothrow)\n0x01 << 3 = this method is guaranteed to terminate (:terminates_globally)\n0x01 << 4 = the syntactic control flow within this method is guaranteed to terminate (:terminates_locally)\nSee the documentation of Base.@assume_effects for more details.","page":"Julia ASTs"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html#man-custom-indices","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Conventionally, Julia's arrays are indexed starting at 1, whereas some other languages start numbering at 0, and yet others (e.g., Fortran) allow you to specify arbitrary starting indices.  While there is much merit in picking a standard (i.e., 1 for Julia), there are some algorithms which simplify considerably if you can index outside the range 1:size(A,d) (and not just 0:size(A,d)-1, either). To facilitate such computations, Julia supports arrays with arbitrary indices.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"The purpose of this page is to address the question, \"what do I have to do to support such arrays in my own code?\"  First, let's address the simplest case: if you know that your code will never need to handle arrays with unconventional indexing, hopefully the answer is \"nothing.\" Old code, on conventional arrays, should function essentially without alteration as long as it was using the exported interfaces of Julia. If you find it more convenient to just force your users to supply traditional arrays where indexing starts at one, you can add","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.require_one_based_indexing(arrays...)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"where arrays... is a list of the array objects that you wish to check for anything that violates 1-based indexing.","page":"Arrays with custom indices"},{"title":"Generalizing existing code","location":"devdocs/offset-arrays.html#Generalizing-existing-code","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"As an overview, the steps are:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"replace many uses of size with axes\nreplace 1:length(A) with eachindex(A), or in some cases LinearIndices(A)\nreplace explicit allocations like Array{Int}(undef, size(B)) with similar(Array{Int}, axes(B))","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"These are described in more detail below.","page":"Arrays with custom indices"},{"title":"Things to watch out for","location":"devdocs/offset-arrays.html#Things-to-watch-out-for","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Because unconventional indexing breaks many people's assumptions that all arrays start indexing with 1, there is always the chance that using such arrays will trigger errors. The most frustrating bugs would be incorrect results or segfaults (total crashes of Julia). For example, consider the following function:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"function mycopy!(dest::AbstractVector, src::AbstractVector)\n    length(dest) == length(src) || throw(DimensionMismatch(\"vectors must match\"))\n    # OK, now we're safe to use @inbounds, right? (not anymore!)\n    for i = 1:length(src)\n        @inbounds dest[i] = src[i]\n    end\n    dest\nend","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"This code implicitly assumes that vectors are indexed from 1; if dest starts at a different index than src, there is a chance that this code would trigger a segfault. (If you do get segfaults, to help locate the cause try running julia with the option --check-bounds=yes.)","page":"Arrays with custom indices"},{"title":"Using axes for bounds checks and loop iteration","location":"devdocs/offset-arrays.html#Using-axes-for-bounds-checks-and-loop-iteration","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"axes(A) (reminiscent of size(A)) returns a tuple of AbstractUnitRange{<:Integer} objects, specifying the range of valid indices along each dimension of A.  When A has unconventional indexing, the ranges may not start at 1.  If you just want the range for a particular dimension d, there is axes(A, d).","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base implements a custom range type, OneTo, where OneTo(n) means the same thing as 1:n but in a form that guarantees (via the type system) that the lower index is 1. For any new AbstractArray type, this is the default returned by axes, and it indicates that this array type uses \"conventional\" 1-based indexing.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"For bounds checking, note that there are dedicated functions checkbounds and checkindex which can sometimes simplify such tests.","page":"Arrays with custom indices"},{"title":"Linear indexing (LinearIndices)","location":"devdocs/offset-arrays.html#Linear-indexing-(LinearIndices)","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Some algorithms are most conveniently (or efficiently) written in terms of a single linear index, A[i] even if A is multi-dimensional. Regardless of the array's native indices, linear indices always range from 1:length(A). However, this raises an ambiguity for one-dimensional arrays (a.k.a., AbstractVector): does v[i] mean linear indexing , or Cartesian indexing with the array's native indices?","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"For this reason, your best option may be to iterate over the array with eachindex(A), or, if you require the indices to be sequential integers, to get the index range by calling LinearIndices(A). This will return axes(A, 1) if A is an AbstractVector, and the equivalent of 1:length(A) otherwise.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"By this definition, 1-dimensional arrays always use Cartesian indexing with the array's native indices. To help enforce this, it's worth noting that the index conversion functions will throw an error if shape indicates a 1-dimensional array with unconventional indexing (i.e., is a Tuple{UnitRange} rather than a tuple of OneTo). For arrays with conventional indexing, these functions continue to work the same as always.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Using axes and LinearIndices, here is one way you could rewrite mycopy!:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"function mycopy!(dest::AbstractVector, src::AbstractVector)\n    axes(dest) == axes(src) || throw(DimensionMismatch(\"vectors must match\"))\n    for i in LinearIndices(src)\n        @inbounds dest[i] = src[i]\n    end\n    dest\nend","page":"Arrays with custom indices"},{"title":"Allocating storage using generalizations of similar","location":"devdocs/offset-arrays.html#Allocating-storage-using-generalizations-of-similar","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Storage is often allocated with Array{Int}(undef, dims) or similar(A, args...). When the result needs to match the indices of some other array, this may not always suffice. The generic replacement for such patterns is to use similar(storagetype, shape).  storagetype indicates the kind of underlying \"conventional\" behavior you'd like, e.g., Array{Int} or BitArray or even dims->zeros(Float32, dims) (which would allocate an all-zeros array). shape is a tuple of Integer or AbstractUnitRange values, specifying the indices that you want the result to use. Note that a convenient way of producing an all-zeros array that matches the indices of A is simply zeros(A).","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Let's walk through a couple of explicit examples. First, if A has conventional indices, then similar(Array{Int}, axes(A)) would end up calling Array{Int}(undef, size(A)), and thus return an array.  If A is an AbstractArray type with unconventional indexing, then similar(Array{Int}, axes(A)) should return something that \"behaves like\" an Array{Int} but with a shape (including indices) that matches A.  (The most obvious implementation is to allocate an Array{Int}(undef, size(A)) and then \"wrap\" it in a type that shifts the indices.)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Note also that similar(Array{Int}, (axes(A, 2),)) would allocate an AbstractVector{Int} (i.e., 1-dimensional array) that matches the indices of the columns of A.","page":"Arrays with custom indices"},{"title":"Writing custom array types with non-1 indexing","location":"devdocs/offset-arrays.html#Writing-custom-array-types-with-non-1-indexing","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Most of the methods you'll need to define are standard for any AbstractArray type, see Abstract Arrays. This page focuses on the steps needed to define unconventional indexing.","page":"Arrays with custom indices"},{"title":"Custom AbstractUnitRange types","location":"devdocs/offset-arrays.html#Custom-AbstractUnitRange-types","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"If you're writing a non-1 indexed array type, you will want to specialize axes so it returns a UnitRange, or (perhaps better) a custom AbstractUnitRange.  The advantage of a custom type is that it \"signals\" the allocation type for functions like similar. If we're writing an array type for which indexing will start at 0, we likely want to begin by creating a new AbstractUnitRange, ZeroRange, where ZeroRange(n) is equivalent to 0:n-1.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"In general, you should probably not export ZeroRange from your package: there may be other packages that implement their own ZeroRange, and having multiple distinct ZeroRange types is (perhaps counterintuitively) an advantage: ModuleA.ZeroRange indicates that similar should create a ModuleA.ZeroArray, whereas ModuleB.ZeroRange indicates a ModuleB.ZeroArray type.  This design allows peaceful coexistence among many different custom array types.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Note that the Julia package CustomUnitRanges.jl can sometimes be used to avoid the need to write your own ZeroRange type.","page":"Arrays with custom indices"},{"title":"Specializing axes","location":"devdocs/offset-arrays.html#Specializing-axes","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Once you have your AbstractUnitRange type, then specialize axes:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.axes(A::ZeroArray) = map(n->ZeroRange(n), A.size)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"where here we imagine that ZeroArray has a field called size (there would be other ways to implement this).","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"In some cases, the fallback definition for axes(A, d):","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"axes(A::AbstractArray{T,N}, d) where {T,N} = d <= N ? axes(A)[d] : OneTo(1)","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"may not be what you want: you may need to specialize it to return something other than OneTo(1) when d > ndims(A).  Likewise, in Base there is a dedicated function axes1 which is equivalent to axes(A, 1) but which avoids checking (at runtime) whether ndims(A) > 0. (This is purely a performance optimization.)  It is defined as:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"axes1(A::AbstractArray{T,0}) where {T} = OneTo(1)\naxes1(A::AbstractArray) = axes(A)[1]","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"If the first of these (the zero-dimensional case) is problematic for your custom array type, be sure to specialize it appropriately.","page":"Arrays with custom indices"},{"title":"Specializing similar","location":"devdocs/offset-arrays.html#Specializing-similar","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Given your custom ZeroRange type, then you should also add the following two specializations for similar:","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"function Base.similar(A::AbstractArray, T::Type, shape::Tuple{ZeroRange,Vararg{ZeroRange}})\n    # body\nend\n\nfunction Base.similar(f::Union{Function,DataType}, shape::Tuple{ZeroRange,Vararg{ZeroRange}})\n    # body\nend","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Both of these should allocate your custom array type.","page":"Arrays with custom indices"},{"title":"Specializing reshape","location":"devdocs/offset-arrays.html#Specializing-reshape","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Optionally, define a method","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.reshape(A::AbstractArray, shape::Tuple{ZeroRange,Vararg{ZeroRange}}) = ...","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"and you can reshape an array so that the result has custom indices.","page":"Arrays with custom indices"},{"title":"For objects that mimic AbstractArray but are not subtypes","location":"devdocs/offset-arrays.html#For-objects-that-mimic-AbstractArray-but-are-not-subtypes","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"has_offset_axes depends on having axes defined for the objects you call it on. If there is some reason you don't have an axes method defined for your object, consider defining a method","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"Base.has_offset_axes(obj::MyNon1IndexedArraylikeObject) = true","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"This will allow code that assumes 1-based indexing to detect a problem and throw a helpful error, rather than returning incorrect results or segfaulting julia.","page":"Arrays with custom indices"},{"title":"Catching errors","location":"devdocs/offset-arrays.html#Catching-errors","category":"section","text":"","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"If your new array type triggers errors in other code, one helpful debugging step can be to comment out @boundscheck in your getindex and setindex! implementation. This will ensure that every element access checks bounds. Or, restart julia with --check-bounds=yes.","page":"Arrays with custom indices"},{"title":"Arrays with custom indices","location":"devdocs/offset-arrays.html","category":"page","text":"In some cases it may also be helpful to temporarily disable size and length for your new array type, since code that makes incorrect assumptions frequently uses these functions.","page":"Arrays with custom indices"},{"title":"SubArrays","location":"devdocs/subarrays.html#SubArrays","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Julia's SubArray type is a container encoding a \"view\" of a parent AbstractArray.  This page documents some of the design principles and implementation of SubArrays.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"One of the major design goals is to ensure high performance for views of both IndexLinear and IndexCartesian arrays. Furthermore, views of IndexLinear arrays should themselves be IndexLinear to the extent that it is possible.","page":"SubArrays"},{"title":"Index replacement","location":"devdocs/subarrays.html#Index-replacement","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Consider making 2d slices of a 3d array:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"DocTestSetup = :(import Random; Random.seed!(1234))","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> A = rand(2,3,4);\n\njulia> S1 = view(A, :, 1, 2:3)\n2×2 view(::Array{Float64, 3}, :, 1, 2:3) with eltype Float64:\n 0.839622  0.711389\n 0.967143  0.103929\n\njulia> S2 = view(A, 1, :, 2:3)\n3×2 view(::Array{Float64, 3}, 1, :, 2:3) with eltype Float64:\n 0.839622  0.711389\n 0.789764  0.806704\n 0.566704  0.962715","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"DocTestSetup = nothing","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"view drops \"singleton\" dimensions (ones that are specified by an Int), so both S1 and S2 are two-dimensional SubArrays. Consequently, the natural way to index these is with S1[i,j]. To extract the value from the parent array A, the natural approach is to replace S1[i,j] with A[i,1,(2:3)[j]] and S2[i,j] with A[1,i,(2:3)[j]].","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"The key feature of the design of SubArrays is that this index replacement can be performed without any runtime overhead.","page":"SubArrays"},{"title":"SubArray design","location":"devdocs/subarrays.html#SubArray-design","category":"section","text":"","page":"SubArrays"},{"title":"Type parameters and fields","location":"devdocs/subarrays.html#Type-parameters-and-fields","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"The strategy adopted is first and foremost expressed in the definition of the type:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"struct SubArray{T,N,P,I,L} <: AbstractArray{T,N}\n    parent::P\n    indices::I\n    offset1::Int       # for linear indexing and pointer, only valid when L==true\n    stride1::Int       # used only for linear indexing\n    ...\nend","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"SubArray has 5 type parameters.  The first two are the standard element type and dimensionality.  The next is the type of the parent AbstractArray.  The most heavily-used is the fourth parameter, a Tuple of the types of the indices for each dimension. The final one, L, is only provided as a convenience for dispatch; it's a boolean that represents whether the index types support fast linear indexing. More on that later.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"If in our example above A is a Array{Float64, 3}, our S1 case above would be a SubArray{Float64,2,Array{Float64,3},Tuple{Base.Slice{Base.OneTo{Int64}},Int64,UnitRange{Int64}},false}. Note in particular the tuple parameter, which stores the types of the indices used to create S1. Likewise,","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> S1.indices\n(Base.Slice(Base.OneTo(2)), 1, 2:3)","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Storing these values allows index replacement, and having the types encoded as parameters allows one to dispatch to efficient algorithms.","page":"SubArrays"},{"title":"Index translation","location":"devdocs/subarrays.html#Index-translation","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Performing index translation requires that you do different things for different concrete SubArray types.  For example, for S1, one needs to apply the i,j indices to the first and third dimensions of the parent array, whereas for S2 one needs to apply them to the second and third.  The simplest approach to indexing would be to do the type-analysis at runtime:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"parentindices = Vector{Any}()\nfor thisindex in S.indices\n    ...\n    if isa(thisindex, Int)\n        # Don't consume one of the input indices\n        push!(parentindices, thisindex)\n    elseif isa(thisindex, AbstractVector)\n        # Consume an input index\n        push!(parentindices, thisindex[inputindex[j]])\n        j += 1\n    elseif isa(thisindex, AbstractMatrix)\n        # Consume two input indices\n        push!(parentindices, thisindex[inputindex[j], inputindex[j+1]])\n        j += 2\n    elseif ...\nend\nS.parent[parentindices...]","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Unfortunately, this would be disastrous in terms of performance: each element access would allocate memory, and involves the running of a lot of poorly-typed code.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"The better approach is to dispatch to specific methods to handle each type of stored index. That's what reindex does: it dispatches on the type of the first stored index and consumes the appropriate number of input indices, and then it recurses on the remaining indices. In the case of S1, this expands to","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Base.reindex(S1, S1.indices, (i, j)) == (i, S1.indices[2], S1.indices[3][j])","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"for any pair of indices (i,j) (except CartesianIndexs and arrays thereof, see below).","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"This is the core of a SubArray; indexing methods depend upon reindex to do this index translation. Sometimes, though, we can avoid the indirection and make it even faster.","page":"SubArrays"},{"title":"Linear indexing","location":"devdocs/subarrays.html#Linear-indexing","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Linear indexing can be implemented efficiently when the entire array has a single stride that separates successive elements, starting from some offset. This means that we can pre-compute these values and represent linear indexing simply as an addition and multiplication, avoiding the indirection of reindex and (more importantly) the slow computation of the cartesian coordinates entirely.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"For SubArray types, the availability of efficient linear indexing is based purely on the types of the indices, and does not depend on values like the size of the parent array. You can ask whether a given set of indices supports fast linear indexing with the internal Base.viewindexing function:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> Base.viewindexing(S1.indices)\nIndexCartesian()\n\njulia> Base.viewindexing(S2.indices)\nIndexLinear()","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"This is computed during construction of the SubArray and stored in the L type parameter as a boolean that encodes fast linear indexing support. While not strictly necessary, it means that we can define dispatch directly on SubArray{T,N,A,I,true} without any intermediaries.","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Since this computation doesn't depend on runtime values, it can miss some cases in which the stride happens to be uniform:","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> A = reshape(1:4*2, 4, 2)\n4×2 reshape(::UnitRange{Int64}, 4, 2) with eltype Int64:\n 1  5\n 2  6\n 3  7\n 4  8\n\njulia> diff(A[2:2:4,:][:])\n3-element Vector{Int64}:\n 2\n 2\n 2","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"A view constructed as view(A, 2:2:4, :) happens to have uniform stride, and therefore linear indexing indeed could be performed efficiently.  However, success in this case depends on the size of the array: if the first dimension instead were odd,","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"julia> A = reshape(1:5*2, 5, 2)\n5×2 reshape(::UnitRange{Int64}, 5, 2) with eltype Int64:\n 1   6\n 2   7\n 3   8\n 4   9\n 5  10\n\njulia> diff(A[2:2:4,:][:])\n3-element Vector{Int64}:\n 2\n 3\n 2","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"then A[2:2:4,:] does not have uniform stride, so we cannot guarantee efficient linear indexing.  Since we have to base this decision based purely on types encoded in the parameters of the SubArray, S = view(A, 2:2:4, :) cannot implement efficient linear indexing.","page":"SubArrays"},{"title":"A few details","location":"devdocs/subarrays.html#A-few-details","category":"section","text":"","page":"SubArrays"},{"title":"SubArrays","location":"devdocs/subarrays.html","category":"page","text":"Note that the Base.reindex function is agnostic to the types of the input indices; it simply determines how and where the stored indices should be reindexed. It not only supports integer indices, but it supports non-scalar indexing, too. This means that views of views don't need two levels of indirection; they can simply re-compute the indices into the original parent array!\nHopefully by now it's fairly clear that supporting slices means that the dimensionality, given by the parameter N, is not necessarily equal to the dimensionality of the parent array or the length of the indices tuple.  Neither do user-supplied indices necessarily line up with entries in the indices tuple (e.g., the second user-supplied index might correspond to the third dimension of the parent array, and the third element in the indices tuple).\nWhat might be less obvious is that the dimensionality of the stored parent array must be equal to the number of effective indices in the indices tuple. Some examples:\nA = reshape(1:35, 5, 7) # A 2d parent Array\nS = view(A, 2:7)         # A 1d view created by linear indexing\nS = view(A, :, :, 1:1)   # Appending extra indices is supported\nNaively, you'd think you could just set S.parent = A and S.indices = (:,:,1:1), but supporting this dramatically complicates the reindexing process, especially for views of views. Not only do you need to dispatch on the types of the stored indices, but you need to examine whether a given index is the final one and \"merge\" any remaining stored indices together. This is not an easy task, and even worse: it's slow since it implicitly depends upon linear indexing.\nFortunately, this is precisely the computation that ReshapedArray performs, and it does so linearly if possible. Consequently, view ensures that the parent array is the appropriate dimensionality for the given indices by reshaping it if needed. The inner SubArray constructor ensures that this invariant is satisfied.\nCartesianIndex and arrays thereof throw a nasty wrench into the reindex scheme. Recall that reindex simply dispatches on the type of the stored indices in order to determine how many passed indices should be used and where they should go. But with CartesianIndex, there's no longer a one-to-one correspondence between the number of passed arguments and the number of dimensions that they index into. If we return to the above example of Base.reindex(S1, S1.indices, (i, j)), you can see that the expansion is incorrect for i, j = CartesianIndex(), CartesianIndex(2,1). It should skip the CartesianIndex() entirely and return:\n(CartesianIndex(2,1)[1], S1.indices[2], S1.indices[3][CartesianIndex(2,1)[2]])\nInstead, though, we get:\n(CartesianIndex(), S1.indices[2], S1.indices[3][CartesianIndex(2,1)])\nDoing this correctly would require combined dispatch on both the stored and passed indices across all combinations of dimensionalities in an intractable manner. As such, reindex must never be called with CartesianIndex indices. Fortunately, the scalar case is easily handled by first flattening the CartesianIndex arguments to plain integers. Arrays of CartesianIndex, however, cannot be split apart into orthogonal pieces so easily. Before attempting to use reindex, view must ensure that there are no arrays of CartesianIndex in the argument list. If there are, it can simply \"punt\" by avoiding the reindex calculation entirely, constructing a nested SubArray with two levels of indirection instead.","page":"SubArrays"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html#Custom-LLVM-Passes","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Julia has a number of custom LLVM passes. Broadly, they can be classified into passes that are required to be run to maintain Julia semantics, and passes that take advantage of Julia semantics to optimize LLVM IR.","page":"Custom LLVM Passes"},{"title":"Semantic Passes","location":"devdocs/llvm-passes.html#Semantic-Passes","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"These passes are used to transform LLVM IR into code that is legal to be run on a CPU. Their main purpose is to enable simpler IR to be emitted by codegen, which then enables other LLVM passes to optimize common patterns.","page":"Custom LLVM Passes"},{"title":"CPUFeatures","location":"devdocs/llvm-passes.html#CPUFeatures","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-cpufeatures.cpp\nClass Name: CPUFeaturesPass\nOpt Name: module(CPUFeatures)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass lowers the julia.cpu.have_fma.(f32|f64) intrinsic to either true or false, depending on the target architecture and target features present on the function. This intrinsic is often used to determine if using algorithms dependent on fast fused multiply-add operations is better than using standard algorithms not dependent on such instructions.","page":"Custom LLVM Passes"},{"title":"DemoteFloat16","location":"devdocs/llvm-passes.html#DemoteFloat16","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-demote-float16.cpp\nClassName: DemoteFloat16Pass\nOpt Name function(DemoteFloat16)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass replaces float16 operations with float32 operations on architectures that do not natively support float16 operations. This is done by inserting fpext and fptrunc instructions around any float16 operation. On architectures that do support native float16 operations, this pass is a no-op.","page":"Custom LLVM Passes"},{"title":"LateGCLowering","location":"devdocs/llvm-passes.html#LateGCLowering","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-late-gc-lowering.cpp\nClass Name: LateLowerGCPass\nOpt Name: function(LateLowerGCFrame)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass performs most of the GC rooting work required to track pointers between GC safepoints. It also lowers several intrinsics to their corresponding instruction translation, and is permitted to violate the non-integral invariants previously established (pointer_from_objref is lowered to a ptrtoint instruction here). This pass typically occupies the most time out of all the custom Julia passes, due to its dataflow algorithm to minimize the number of objects live at any safepoint.","page":"Custom LLVM Passes"},{"title":"FinalGCLowering","location":"devdocs/llvm-passes.html#FinalGCLowering","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-final-gc-lowering.cpp\nClass Name: FinalLowerGCPass\nOpt Name: module(FinalLowerGC)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass lowers a few last intrinsics to their final form targeting functions in the libjulia library. Separating this from LateGCLowering enables other backends (GPU compilation) to supply their own custom lowerings for these intrinsics, enabling the Julia pipeline to be used on those backends as well.","page":"Custom LLVM Passes"},{"title":"LowerHandlers","location":"devdocs/llvm-passes.html#LowerHandlers","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-lower-handlers.cpp\nClass Name: LowerExcHandlersPass\nOpt Name: function(LowerExcHandlers)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass lowers exception handling intrinsics into calls to runtime functions that are actually called when handling exceptions.","page":"Custom LLVM Passes"},{"title":"RemoveNI","location":"devdocs/llvm-passes.html#RemoveNI","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-remove-ni.cpp\nClass Name: RemoveNIPass\nOpt Name: module(RemoveNI)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass removes the non-integral address spaces from the module's datalayout string. This enables the backend to lower Julia's custom address spaces directly to machine code, without a costly rewrite of every pointer operation to address space 0.","page":"Custom LLVM Passes"},{"title":"SIMDLoop","location":"devdocs/llvm-passes.html#SIMDLoop","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-simdloop.cpp\nClass Name: LowerSIMDLoopPass\nOpt Name: loop(LowerSIMDLoop)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass acts as the main driver of the @simd annotation. Codegen inserts a !llvm.loopid marker at the back branch of a loop, which this pass uses to identify loops that were originally marked with @simd. Then, this pass looks for a chain of floating point operations that form a reduce and adds the contract and reassoc fast math flags to allow reassociation (and thus vectorization). This pass does not preserve either loop information nor inference correctness, so it may violate Julia semantics in surprising ways. If the loop was annotated with ivdep as well, then the pass marks the loop as having no loop-carried dependencies (the resulting behavior is undefined if the user annotation was incorrect or gets applied to the wrong loop).","page":"Custom LLVM Passes"},{"title":"LowerPTLS","location":"devdocs/llvm-passes.html#LowerPTLS","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-ptls.cpp\nClass Name: LowerPTLSPass\nOpt Name: module(LowerPTLSPass)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass lowers thread-local Julia intrinsics to assembly instructions. Julia relies on thread-local storage for garbage collection and multithreading task scheduling. When compiling code for system images and package images, this pass replaces calls to intrinsics with loads from global variables that are initialized at load time.","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"If codegen produces a function with a swiftself argument and calling convention, this pass assumes the swiftself argument is the pgcstack and will replace the intrinsics with that argument. Doing so provides speedups on architectures that have slow thread local storage accesses.","page":"Custom LLVM Passes"},{"title":"RemoveAddrspaces","location":"devdocs/llvm-passes.html#RemoveAddrspaces","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-remove-addrspaces.cpp\nClass Name: RemoveAddrspacesPass\nOpt Name: module(RemoveAddrspaces)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass renames pointers in one address space to another address space. This is used to remove Julia-specific address spaces from LLVM IR.","page":"Custom LLVM Passes"},{"title":"RemoveJuliaAddrspaces","location":"devdocs/llvm-passes.html#RemoveJuliaAddrspaces","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-remove-addrspaces.cpp\nClass Name: RemoveJuliaAddrspacesPass\nOpt Name: module(RemoveJuliaAddrspaces)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass removes Julia-specific address spaces from LLVM IR. It is mostly used for displaying LLVM IR in a less cluttered format. Internally, it is implemented off the RemoveAddrspaces pass.","page":"Custom LLVM Passes"},{"title":"Multiversioning","location":"devdocs/llvm-passes.html#Multiversioning","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-multiversioning.cpp\nClass Name: MultiVersioningPass\nOpt Name: module(JuliaMultiVersioning)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass performs modifications to a module to create functions that are optimized for running on different architectures (see sysimg.md and pkgimg.md for more details). Implementation-wise, it clones functions and applies different target-specific attributes to them to allow the optimizer to use advanced features such as vectorization and instruction scheduling for that platform. It also creates some infrastructure to enable the Julia image loader to select the appropriate version of the function to call based on the architecture the loader is running on. The target-specific attributes are controlled by the julia.mv.specs module flag, which during compilation is derived from the JULIA_CPU_TARGET environment variable. The pass must also be enabled by providing a julia.mv.enable module flag with a value of 1.","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"warning: Warning\n","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Use of llvmcall with multiversioning is dangerous. llvmcall enables access to features not typically exposed by the Julia APIs, and are therefore usually not available on all architectures. If multiversioning is enabled and code generation is requested for a target architecture that does not support the feature required by an llvmcall expression, LLVM will probably error out, likely with an abort and the message LLVM ERROR: Do not know how to split the result of this operator!.","page":"Custom LLVM Passes"},{"title":"GCInvariantVerifier","location":"devdocs/llvm-passes.html#GCInvariantVerifier","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-gc-invariant-verifier.cpp\nClass Name: GCInvariantVerifierPass\nOpt Name: module(GCInvariantVerifier)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass is used to verify Julia's invariants about LLVM IR. This includes things such as the nonexistence of ptrtoint in Julia's non-integral address spaces [nislides] and the existence of only blessed addrspacecast instructions (Tracked -> Derived, 0 -> Tracked, etc). It performs no transformations on IR.","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"[nislides]: https://llvm.org/devmtg/2015-02/slides/chisnall-pointers-not-int.pdf","page":"Custom LLVM Passes"},{"title":"Optimization Passes","location":"devdocs/llvm-passes.html#Optimization-Passes","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"These passes are used to perform transformations on LLVM IR that LLVM will not perform itself, e.g. fast math flag propagation, escape analysis, and optimizations on Julia-specific internal functions. They use knowledge about Julia's semantics to perform these optimizations.","page":"Custom LLVM Passes"},{"title":"CombineMulAdd","location":"devdocs/llvm-passes.html#CombineMulAdd","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-muladd.cpp\nClass Name: CombineMulAddPass\nOpt Name: function(CombineMulAdd)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass serves to optimize the particular combination of a regular fmul with a fast fadd into a contract fmul with a fast fadd. This is later optimized by the backend to a fused multiply-add instruction, which can provide significantly faster operations at the cost of more unpredictable semantics.","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"note: Note\nThis optimization only occurs when the fmul has a single use, which is the fast fadd.","page":"Custom LLVM Passes"},{"title":"AllocOpt","location":"devdocs/llvm-passes.html#AllocOpt","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-alloc-opt.cpp\nClass Name: AllocOptPass\nOpt Name: function(AllocOpt)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Julia does not have the concept of a program stack as a place to allocate mutable objects. However, allocating objects on the stack reduces GC pressure and is critical for GPU compilation. Thus, AllocOpt performs heap to stack conversion of objects that it can prove do not escape the current function. It also performs a number of other optimizations on allocations, such as removing allocations that are never used, optimizing typeof calls to freshly allocated objects, and removing stores to allocations that are immediately overwritten. The escape analysis implementation is located in llvm-alloc-helpers.cpp. Currently, this pass does not use information from EscapeAnalysis.jl, though that may change in the future.","page":"Custom LLVM Passes"},{"title":"PropagateJuliaAddrspaces","location":"devdocs/llvm-passes.html#PropagateJuliaAddrspaces","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-propagate-addrspaces.cpp\nClass Name: PropagateJuliaAddrspacesPass\nOpt Name: function(PropagateJuliaAddrspaces)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass is used to propagate Julia-specific address spaces through operations on pointers. LLVM is not allowed to introduce or remove addrspacecast instructions by optimizations, so this pass acts to eliminate redundant addrspace casts by replacing operations with their equivalent in a Julia address space. For more information on Julia's address spaces, see (TODO link to llvm.md).","page":"Custom LLVM Passes"},{"title":"JuliaLICM","location":"devdocs/llvm-passes.html#JuliaLICM","category":"section","text":"","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Filename: llvm-julia-licm.cpp\nClass Name: JuliaLICMPass\nOpt Name: loop(JuliaLICM)","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass is used to hoist Julia-specific intrinsics out of loops. Specifically, it performs the following transformations:","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"Hoist gc_preserve_begin and sink gc_preserve_end out of loops when the preserved objects are loop-invariant.\nSince objects preserved within a loop are likely preserved for the duration of the loop, this transformation can reduce the number of gc_preserve_begin/gc_preserve_end pairs in the IR. This makes it easier for the LateLowerGCPass to identify where particular objects are preserved.\nHoist write barriers with invariant objects\nHere we assume that there are only two generations that an object can be a part of. Given that, a write barrier needs to only execute once for any pair of the same object. Thus, we can hoist write barriers out of loops when the object being written to is loop-invariant.\nHoist allocations out of loops when they do not escape the loop\nWe use a very conservative definition of escape here, the same as the one used in AllocOptPass. This transformation can reduce the number of allocations in the IR, even when an allocation escapes the function altogether.","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"!!!note","page":"Custom LLVM Passes"},{"title":"Custom LLVM Passes","location":"devdocs/llvm-passes.html","category":"page","text":"This pass is required to preserve LLVM's [MemorySSA](https://llvm.org/docs/MemorySSA.html) ([Short Video](https://www.youtube.com/watch?v=bdxWmryoHak), [Longer Video](https://www.youtube.com/watch?v=1e5y6WDbXCQ)) and [ScalarEvolution](https://baziotis.cs.illinois.edu/compilers/introduction-to-scalar-evolution.html) ([Newer Slides](https://llvm.org/devmtg/2018-04/slides/Absar-ScalarEvolution.pdf) [Older Slides](https://llvm.org/devmtg/2009-10/ScalarEvolutionAndLoopOptimization.pdf)) analyses.","page":"Custom LLVM Passes"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html#Networking-and-Streams","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Julia provides a rich interface to deal with streaming I/O objects such as terminals, pipes and TCP sockets. These objects allow data to be sent and received in a stream-like fashion, which means that data is processed sequentially as it becomes available. This interface, though asynchronous at the system level, is presented in a synchronous manner to the programmer. This is achieved by making heavy use of Julia cooperative threading (coroutine) functionality.","page":"Networking and Streams"},{"title":"Basic Stream I/O","location":"manual/networking-and-streams.html#Basic-Stream-I/O","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"All Julia streams expose at least a read and a write method, taking the stream as their first argument, e.g.:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> write(stdout, \"Hello World\");  # suppress return value 11 with ;\nHello World\njulia> read(stdin, Char)\n\n'\\n': ASCII/Unicode U+000a (category Cc: Other, control)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that write returns 11, the number of bytes (in \"Hello World\") written to stdout, but this return value is suppressed with the ;.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Here Enter was pressed again so that Julia would read the newline. Now, as you can see from this example, write takes the data to write as its second argument, while read takes the type of the data to be read as the second argument.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"For example, to read a simple byte array, we could do:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> x = zeros(UInt8, 4)\n4-element Array{UInt8,1}:\n 0x00\n 0x00\n 0x00\n 0x00\n\njulia> read!(stdin, x)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"However, since this is slightly cumbersome, there are several convenience methods provided. For example, we could have written the above as:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> read(stdin, 4)\nabcd\n4-element Array{UInt8,1}:\n 0x61\n 0x62\n 0x63\n 0x64","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"or if we had wanted to read the entire line instead:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> readline(stdin)\nabcd\n\"abcd\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that depending on your terminal settings, your TTY (\"teletype terminal\") may be line buffered and might thus require an additional enter before stdin data is sent to Julia. When running Julia from the command line in a TTY, output is sent to the console by default, and standard input is read from the keyboard.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To read every line from stdin you can use eachline:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"for line in eachline(stdin)\n    print(\"Found $line\")\nend","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"or read if you wanted to read by character instead:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"while !eof(stdin)\n    x = read(stdin, Char)\n    println(\"Found: $x\")\nend","page":"Networking and Streams"},{"title":"Text I/O","location":"manual/networking-and-streams.html#Text-I/O","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that the write method mentioned above operates on binary streams. In particular, values do not get converted to any canonical text representation but are written out as is:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> write(stdout, 0x61);  # suppress return value 1 with ;\na","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that a is written to stdout by the write function and that the returned value is 1 (since 0x61 is one byte).","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"For text I/O, use the print or show methods, depending on your needs (see the documentation for these two methods for a detailed discussion of the difference between them):","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> print(stdout, 0x61)\n97","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"See Custom pretty-printing for more information on how to implement display methods for custom types.","page":"Networking and Streams"},{"title":"IO Output Contextual Properties","location":"manual/networking-and-streams.html#IO-Output-Contextual-Properties","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Sometimes IO output can benefit from the ability to pass contextual information into show methods. The IOContext object provides this framework for associating arbitrary metadata with an IO object. For example, :compact => true adds a hinting parameter to the IO object that the invoked show method should print a shorter output (if applicable). See the IOContext documentation for a list of common properties.","page":"Networking and Streams"},{"title":"Working with Files","location":"manual/networking-and-streams.html#Working-with-Files","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"You can write content to a file with the write(filename::String, content) method:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> write(\"hello.txt\", \"Hello, World!\")\n13","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"(13 is the number of bytes written.)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"You can read the contents of a file with the read(filename::String) method, or read(filename::String, String) to the contents as a string:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> read(\"hello.txt\", String)\n\"Hello, World!\"","page":"Networking and Streams"},{"title":"Advanced: streaming files","location":"manual/networking-and-streams.html#Advanced:-streaming-files","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"The read and write methods above allow you to read and write file contents. Like many other environments, Julia also has an open function, which takes a filename and returns an IOStream object that you can use to read and write things from the file. For example, if we have a file, hello.txt, whose contents are Hello, World!:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> f = open(\"hello.txt\")\nIOStream(<file hello.txt>)\n\njulia> readlines(f)\n1-element Array{String,1}:\n \"Hello, World!\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"If you want to write to a file, you can open it with the write (\"w\") flag:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> f = open(\"hello.txt\",\"w\")\nIOStream(<file hello.txt>)\n\njulia> write(f,\"Hello again.\")\n12","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"If you examine the contents of hello.txt at this point, you will notice that it is empty; nothing has actually been written to disk yet. This is because the IOStream must be closed before the write is actually flushed to disk:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> close(f)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Examining hello.txt again will show its contents have been changed.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Opening a file, doing something to its contents, and closing it again is a very common pattern. To make this easier, there exists another invocation of open which takes a function as its first argument and filename as its second, opens the file, calls the function with the file as an argument, and then closes it again. For example, given a function:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"function read_and_capitalize(f::IOStream)\n    return uppercase(read(f, String))\nend","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"You can call:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> open(read_and_capitalize, \"hello.txt\")\n\"HELLO AGAIN.\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"to open hello.txt, call read_and_capitalize on it, close hello.txt and return the capitalized contents.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To avoid even having to define a named function, you can use the do syntax, which creates an anonymous function on the fly:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> open(\"hello.txt\") do f\n           uppercase(read(f, String))\n       end\n\"HELLO AGAIN.\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"If you want to redirect stdout to a file","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"out_file = open(\"output.txt\", \"w\")\n\n# Redirect stdout to file\nredirect_stdout(out_file) do\n    # Your code here\n    println(\"This output goes to `out_file` via the `stdout` variable.\")\nend\n\n# Close file\nclose(out_file)\n","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Redirecting stdout to a file can help you save and analyze program output, automate processes, and meet compliance requirements.","page":"Networking and Streams"},{"title":"A simple TCP example","location":"manual/networking-and-streams.html#A-simple-TCP-example","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Let's jump right in with a simple example involving TCP sockets. This functionality is in a standard library package called Sockets. Let's first create a simple server:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> using Sockets\n\njulia> errormonitor(@async begin\n           server = listen(2000)\n           while true\n               sock = accept(server)\n               println(\"Hello World\\n\")\n           end\n       end)\nTask (runnable) @0x00007fd31dc11ae0","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To those familiar with the Unix socket API, the method names will feel familiar, though their usage is somewhat simpler than the raw Unix socket API. The first call to listen will create a server waiting for incoming connections on the specified port (2000) in this case. The same function may also be used to create various other kinds of servers:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> listen(2000) # Listens on localhost:2000 (IPv4)\nSockets.TCPServer(active)\n\njulia> listen(ip\"127.0.0.1\",2000) # Equivalent to the first\nSockets.TCPServer(active)\n\njulia> listen(ip\"::1\",2000) # Listens on localhost:2000 (IPv6)\nSockets.TCPServer(active)\n\njulia> listen(IPv4(0),2001) # Listens on port 2001 on all IPv4 interfaces\nSockets.TCPServer(active)\n\njulia> listen(IPv6(0),2001) # Listens on port 2001 on all IPv6 interfaces\nSockets.TCPServer(active)\n\njulia> listen(\"testsocket\") # Listens on a UNIX domain socket\nSockets.PipeServer(active)\n\njulia> listen(\"\\\\\\\\.\\\\pipe\\\\testsocket\") # Listens on a Windows named pipe\nSockets.PipeServer(active)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Note that the return type of the last invocation is different. This is because this server does not listen on TCP, but rather on a named pipe (Windows) or UNIX domain socket. Also note that Windows named pipe format has to be a specific pattern such that the name prefix (\\\\.\\pipe\\) uniquely identifies the file type. The difference between TCP and named pipes or UNIX domain sockets is subtle and has to do with the accept and connect methods. The accept method retrieves a connection to the client that is connecting on the server we just created, while the connect function connects to a server using the specified method. The connect function takes the same arguments as listen, so, assuming the environment (i.e. host, cwd, etc.) is the same you should be able to pass the same arguments to connect as you did to listen to establish the connection. So let's try that out (after having created the server above):","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> connect(2000)\nTCPSocket(open, 0 bytes waiting)\n\njulia> Hello World","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"As expected we saw \"Hello World\" printed. So, let's actually analyze what happened behind the scenes. When we called connect, we connect to the server we had just created. Meanwhile, the accept function returns a server-side connection to the newly created socket and prints \"Hello World\" to indicate that the connection was successful.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"A great strength of Julia is that since the API is exposed synchronously even though the I/O is actually happening asynchronously, we didn't have to worry about callbacks or even making sure that the server gets to run. When we called connect the current task waited for the connection to be established and only continued executing after that was done. In this pause, the server task resumed execution (because a connection request was now available), accepted the connection, printed the message and waited for the next client. Reading and writing works in the same way. To see this, consider the following simple echo server:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> errormonitor(@async begin\n           server = listen(2001)\n           while true\n               sock = accept(server)\n               @async while isopen(sock)\n                   write(sock, readline(sock, keep=true))\n               end\n           end\n       end)\nTask (runnable) @0x00007fd31dc12e60\n\njulia> clientside = connect(2001)\nTCPSocket(RawFD(28) open, 0 bytes waiting)\n\njulia> errormonitor(@async while isopen(clientside)\n           write(stdout, readline(clientside, keep=true))\n       end)\nTask (runnable) @0x00007fd31dc11870\n\njulia> println(clientside,\"Hello World from the Echo Server\")\nHello World from the Echo Server","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"As with other streams, use close to disconnect the socket:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> close(clientside)","page":"Networking and Streams"},{"title":"Resolving IP Addresses","location":"manual/networking-and-streams.html#Resolving-IP-Addresses","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"One of the connect methods that does not follow the listen methods is connect(host::String,port), which will attempt to connect to the host given by the host parameter on the port given by the port parameter. It allows you to do things like:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> connect(\"google.com\", 80)\nTCPSocket(RawFD(30) open, 0 bytes waiting)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"At the base of this functionality is getaddrinfo, which will do the appropriate address resolution:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> getaddrinfo(\"google.com\")\nip\"74.125.226.225\"","page":"Networking and Streams"},{"title":"Asynchronous I/O","location":"manual/networking-and-streams.html#Asynchronous-I/O","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"All I/O operations exposed by Base.read and Base.write can be performed asynchronously through the use of coroutines. You can create a new coroutine to read from or write to a stream using the @async macro:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> task = @async open(\"foo.txt\", \"w\") do io\n           write(io, \"Hello, World!\")\n       end;\n\njulia> wait(task)\n\njulia> readlines(\"foo.txt\")\n1-element Array{String,1}:\n \"Hello, World!\"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"It's common to run into situations where you want to perform multiple asynchronous operations concurrently and wait until they've all completed. You can use the @sync macro to cause your program to block until all of the coroutines it wraps around have exited:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"julia> using Sockets\n\njulia> @sync for hostname in (\"google.com\", \"github.com\", \"julialang.org\")\n           @async begin\n               conn = connect(hostname, 80)\n               write(conn, \"GET / HTTP/1.1\\r\\nHost:$(hostname)\\r\\n\\r\\n\")\n               readline(conn, keep=true)\n               println(\"Finished connection to $(hostname)\")\n           end\n       end\nFinished connection to google.com\nFinished connection to julialang.org\nFinished connection to github.com","page":"Networking and Streams"},{"title":"Multicast","location":"manual/networking-and-streams.html#Multicast","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Julia supports multicast over IPv4 and IPv6 using the User Datagram Protocol (UDP) as transport.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Unlike the Transmission Control Protocol (TCP), UDP makes almost no assumptions about the needs of the application. TCP provides flow control (it accelerates and decelerates to maximize throughput), reliability (lost or corrupt packets are automatically retransmitted), sequencing (packets are ordered by the operating system before they are given to the application), segment size, and session setup and teardown. UDP provides no such features.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"A common use for UDP is in multicast applications. TCP is a stateful protocol for communication between exactly two devices. UDP can use special multicast addresses to allow simultaneous communication between many devices.","page":"Networking and Streams"},{"title":"Receiving IP Multicast Packets","location":"manual/networking-and-streams.html#Receiving-IP-Multicast-Packets","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To transmit data over UDP multicast, simply recv on the socket, and the first packet received will be returned. Note that it may not be the first packet that you sent however!","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"using Sockets\ngroup = ip\"228.5.6.7\"\nsocket = Sockets.UDPSocket()\nbind(socket, ip\"0.0.0.0\", 6789)\njoin_multicast_group(socket, group)\nprintln(String(recv(socket)))\nleave_multicast_group(socket, group)\nclose(socket)","page":"Networking and Streams"},{"title":"Sending IP Multicast Packets","location":"manual/networking-and-streams.html#Sending-IP-Multicast-Packets","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"To transmit data over UDP multicast, simply send to the socket. Notice that it is not necessary for a sender to join the multicast group.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"using Sockets\ngroup = ip\"228.5.6.7\"\nsocket = Sockets.UDPSocket()\nsend(socket, group, 6789, \"Hello over IPv4\")\nclose(socket)","page":"Networking and Streams"},{"title":"IPv6 Example","location":"manual/networking-and-streams.html#IPv6-Example","category":"section","text":"","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"This example gives the same functionality as the previous program, but uses IPv6 as the network-layer protocol.","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Listener:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"using Sockets\ngroup = Sockets.IPv6(\"ff05::5:6:7\")\nsocket = Sockets.UDPSocket()\nbind(socket, Sockets.IPv6(\"::\"), 6789)\njoin_multicast_group(socket, group)\nprintln(String(recv(socket)))\nleave_multicast_group(socket, group)\nclose(socket)","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"Sender:","page":"Networking and Streams"},{"title":"Networking and Streams","location":"manual/networking-and-streams.html","category":"page","text":"using Sockets\ngroup = Sockets.IPv6(\"ff05::5:6:7\")\nsocket = Sockets.UDPSocket()\nsend(socket, group, 6789, \"Hello over IPv6\")\nclose(socket)","page":"Networking and Streams"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html#JIT-Design-and-Implementation","category":"section","text":"","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"This document explains the design and implementation of Julia's JIT, after codegen has finished and unoptimized LLVM IR has been produced. The JIT is responsible for optimizing and compiling this IR to machine code, and for linking it into the current process and making the code available for execution.","page":"JIT Design and Implementation"},{"title":"Introduction","location":"devdocs/jit.html#Introduction","category":"section","text":"","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"The JIT is responsible for managing compilation resources, looking up previously compiled code, and compiling new code. It is primarily built on LLVM's On-Request-Compilation (ORCv2) technology, which provides support for a number of useful features such as concurrent compilation, lazy compilation, and the ability to compile code in a separate process. Though LLVM provides a basic JIT compiler in the form of LLJIT, Julia uses many ORCv2 APIs directly to create its own custom JIT compiler.","page":"JIT Design and Implementation"},{"title":"Overview","location":"devdocs/jit.html#Overview","category":"section","text":"","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"(Image: Diagram of the compiler flow)","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"Codegen produces an LLVM module containing IR for one or more Julia functions from the original Julia SSA IR produced by type inference (labeled as translate on the compiler diagram above). It also produces a mapping of code-instance to LLVM function name. However, though some optimizations have been applied by the Julia-based compiler on Julia IR, the LLVM IR produced by codegen still contains many opportunities for optimization. Thus, the first step the JIT takes is to run a target-independent optimization pipeline[tdp] on the LLVM module. Then, the JIT runs a target-dependent optimization pipeline, which includes target-specific optimizations and code generation, and outputs an object file. Finally, the JIT links the resulting object file into the current process and makes the code available for execution. All of this is controlled by code in src/jitlayers.cpp.","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"[tdp]: This is not a totally-target independent pipeline, as transformations such as vectorization rely upon target information such as vector register width and cost modeling. Additionally, codegen itself makes a few target-dependent assumptions, and the optimization pipeline will take advantage of that knowledge.","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"Currently, only one thread at a time is permitted to enter the optimize-compile-link pipeline at a time, due to restrictions imposed by one of our linkers (RuntimeDyld). However, the JIT is designed to support concurrent optimization and compilation, and the linker restriction is expected to be lifted in the future when RuntimeDyld has been fully superseded on all platforms.","page":"JIT Design and Implementation"},{"title":"Optimization Pipeline","location":"devdocs/jit.html#Optimization-Pipeline","category":"section","text":"","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"The optimization pipeline is based off LLVM's new pass manager, but the pipeline is customized for Julia's needs. The pipeline is defined in src/pipeline.cpp, and broadly proceeds through a number of stages as detailed below.","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"Early Simplification\nThese passes are mainly used to simplify the IR and canonicalize patterns so that later passes can identify those patterns more easily. Additionally, various intrinsic calls such as branch prediction hints and annotations are lowered into other metadata or other IR features. SimplifyCFG (simplify control flow graph), DCE (dead code elimination), and SROA (scalar replacement of aggregates) are some of the key players here.\nEarly Optimization\nThese passes are typically cheap and are primarily focused around reducing the number of instructions in the IR and propagating knowledge to other instructions. For example, EarlyCSE is used to perform common subexpression elimination, and InstCombine and InstSimplify perform a number of small peephole optimizations to make operations less expensive.\nLoop Optimization\nThese passes canonicalize and simplify loops. Loops are often hot code, which makes loop optimization extremely important for performance. Key players here include LoopRotate, LICM, and LoopFullUnroll. Some bounds check elimination also happens here, as a result of the IRCE pass which can prove certain bounds are never exceeded.\nScalar Optimization\nThe scalar optimization pipeline contains a number of more expensive, but more powerful passes such as GVN (global value numbering), SCCP (sparse conditional constant propagation), and another round of bounds check elimination. These passes are expensive, but they can often remove large amounts of code and make vectorization much more successful and effective. Several other simplification and optimization passes intersperse the more expensive ones to reduce the amount of work they have to do.\nVectorization\nAutomatic vectorization is an extremely powerful transformation for CPU-intensive code. Briefly, vectorization allows execution of a single instruction on multiple data (SIMD), e.g. performing 8 addition operations at the same time. However, proving code to be both capable of vectorization and profitable to vectorize is difficult, and this relies heavily on the prior optimization passes to massage the IR into a state where vectorization is worth it.\nIntrinsic Lowering\nJulia inserts a number of custom intrinsics, for reasons such as object allocation, garbage collection, and exception handling. These intrinsics were originally placed to make optimization opportunities more obvious, but they are now lowered into LLVM IR to enable the IR to be emitted as machine code.\nCleanup\nThese passes are last-chance optimizations, and perform small optimizations such as fused multiply-add propagation and division-remainder simplification. Additionally, targets that do not support half-precision floating point numbers will have their half-precision instructions lowered into single-precision instructions here, and passes are added to provide sanitizer support.","page":"JIT Design and Implementation"},{"title":"Target-Dependent Optimization and Code Generation","location":"devdocs/jit.html#Target-Dependent-Optimization-and-Code-Generation","category":"section","text":"","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"LLVM provides target-dependent optimization and machine code generation in the same pipeline, located in the TargetMachine for a given platform. These passes include instruction selection, instruction scheduling, register allocation, and machine code emission. The LLVM documentation provides a good overview of the process, and the LLVM source code is the best place to look for details on the pipeline and passes.","page":"JIT Design and Implementation"},{"title":"Linking","location":"devdocs/jit.html#Linking","category":"section","text":"","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"Currently, Julia is transitioning between two linkers: the older RuntimeDyld linker, and the newer JITLink linker. JITLink contains a number of features that RuntimeDyld does not have, such as concurrent and reentrant linking, but currently lacks good support for profiling integrations and does not yet support all of the platforms that RuntimeDyld supports. Over time, JITLink is expected to replace RuntimeDyld entirely. Further details on JITLink can be found in the LLVM documentation.","page":"JIT Design and Implementation"},{"title":"Execution","location":"devdocs/jit.html#Execution","category":"section","text":"","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"Once the code has been linked into the current process, it is available for execution. This fact is made known to the generating codeinst by updating the invoke, specsigflags, and specptr fields appropriately. Codeinsts support upgrading invoke, specsigflags, and specptr fields, so long as every combination of these fields that exists at any given point in time is valid to be called. This allows the JIT to update these fields without invalidating existing codeinsts, supporting a potential future concurrent JIT. Specifically, the following states may be valid:","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"invoke is NULL, specsigflags is 0b00, specptr is NULL\nThis is the initial state of a codeinst, and indicates that the codeinst has not yet been compiled.\ninvoke is non-null, specsigflags is 0b00, specptr is NULL\nThis indicates that the codeinst was not compiled with any specialization, and that the codeinst should be invoked directly. Note that in this instance, invoke does not read either the specsigflags or specptr fields, and therefore they may be modified without invalidating the invoke pointer.\ninvoke is non-null, specsigflags is 0b10, specptr is non-null\nThis indicates that the codeinst was compiled, but a specialized function signature was deemed unnecessary by codegen.\ninvoke is non-null, specsigflags is 0b11, specptr is non-null\nThis indicates that the codeinst was compiled, and a specialized function signature was deemed necessary by codegen. The specptr field contains a pointer to the specialized function signature. The invoke pointer is permitted to read both specsigflags and specptr fields.","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"In addition, there are a number of different transitional states that occur during the update process. To account for these potential situations, the following write and read patterns should be used when dealing with these codeinst fields.","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"When writing invoke, specsigflags, and specptr:\nPerform an atomic compare-exchange operation of specptr assuming the old value was NULL. This compare-exchange operation should have at least acquire-release ordering, to provide ordering guarantees of the remaining memory operations in the write.\nIf specptr was non-null, cease the write operation and wait for bit 0b10 of specsigflags to be written.\nWrite the new low bit of specsigflags to its final value. This may be a relaxed write.\nWrite the new invoke pointer to its final value. This must have at least a release memory ordering to synchronize with reads of invoke.\nSet the second bit of specsigflags to 1. This must be at least a release memory ordering to synchronize with reads of specsigflags. This step completes the write operation and announces to all other threads that all fields have been set.\nWhen reading all of invoke, specsigflags, and specptr:\nRead the invoke field with at least an acquire memory ordering. This load will be referred to as initial_invoke.\nIf initial_invoke is NULL, the codeinst is not yet executable. invoke is NULL, specsigflags may be treated as 0b00, specptr may be treated as NULL.\nRead the specptr field with at least an acquire memory ordering.\nIf specptr is NULL, then the initial_invoke pointer must not be relying on specptr to guarantee correct execution. Therefore, invoke is non-null, specsigflags may be treated as 0b00, specptr may be treated as NULL.\nIf specptr is non-null, then initial_invoke might not be the final invoke field that uses specptr. This can occur if specptr has been written, but invoke has not yet been written. Therefore, spin on the second bit of specsigflags until it is set to 1 with at least acquire memory ordering.\nRe-read the invoke field with at least an acquire memory ordering. This load will be referred to as final_invoke.\nRead the specsigflags field with any memory ordering.\ninvoke is final_invoke, specsigflags is the value read in step 7, specptr is the value read in step 3.\nWhen updating a specptr to a different but equivalent function pointer:\nPerform a release store of the new function pointer to specptr. Races here must be benign, as the old function pointer is required to still be valid, and any new ones are also required to be valid as well. Once a pointer has been written to specptr, it must always be callable whether or not it is later overwritten.","page":"JIT Design and Implementation"},{"title":"JIT Design and Implementation","location":"devdocs/jit.html","category":"page","text":"Although these write, read, and update steps are complicated, they ensure that the JIT can update codeinsts without invalidating existing codeinsts, and that the JIT can update codeinsts without invalidating existing invoke pointers. This allows the JIT to potentially reoptimize functions at higher optimization levels in the future, and also will allow the JIT to support concurrent compilation of functions in the future.","page":"JIT Design and Implementation"},{"title":"SHA","location":"stdlib/SHA.html#SHA","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"DocTestSetup = quote\n    using SHA\n    using InteractiveUtils\nend","page":"SHA"},{"title":"SHA functions","location":"stdlib/SHA.html#SHA-functions","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Usage is very straightforward:","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"julia> using SHA\n\njulia> bytes2hex(sha256(\"test\"))\n\"9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08\"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Each exported function (at the time of this writing, SHA-1, SHA-2 224, 256, 384 and 512, and SHA-3 224, 256, 384 and 512 functions are implemented) takes in either an AbstractVector{UInt8}, an AbstractString or an IO object.  This makes it trivial to checksum a file:","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"shell> cat /tmp/test.txt\ntest\njulia> using SHA\n\njulia> open(\"/tmp/test.txt\") do f\n           sha2_256(f)\n       end\n32-element Array{UInt8,1}:\n 0x9f\n 0x86\n 0xd0\n 0x81\n 0x88\n 0x4c\n 0x7d\n 0x65\n    ⋮\n 0x5d\n 0x6c\n 0x15\n 0xb0\n 0xf0\n 0x0a\n 0x08","page":"SHA"},{"title":"All SHA functions","location":"stdlib/SHA.html#All-SHA-functions","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Due to the colloquial usage of sha256 to refer to sha2_256, convenience functions are provided, mapping shaxxx() function calls to sha2_xxx(). For SHA-3, no such colloquialisms exist and the user must use the full sha3_xxx() names.","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"shaxxx() takes AbstractString and array-like objects (NTuple and Array) with elements of type UInt8.","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-1","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"sha1","page":"SHA"},{"title":"SHA.sha1","location":"stdlib/SHA.html#SHA.sha1","category":"function","text":"sha1(data)\n\nHash data using the sha1 algorithm and return the resulting digest. See also SHA1_CTX.\n\n\n\n\n\nsha1(io::IO)\n\nHash data from io using sha1 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-2","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"sha224\nsha256\nsha384\nsha512\nsha2_224\nsha2_256\nsha2_384\nsha2_512","page":"SHA"},{"title":"SHA.sha224","location":"stdlib/SHA.html#SHA.sha224","category":"function","text":"sha224(data)\n\nHash data using the sha224 algorithm and return the resulting digest. See also SHA2_224_CTX.\n\n\n\n\n\nsha224(io::IO)\n\nHash data from io using sha224 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha256","location":"stdlib/SHA.html#SHA.sha256","category":"function","text":"sha256(data)\n\nHash data using the sha256 algorithm and return the resulting digest. See also SHA2_256_CTX.\n\n\n\n\n\nsha256(io::IO)\n\nHash data from io using sha256 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha384","location":"stdlib/SHA.html#SHA.sha384","category":"function","text":"sha384(data)\n\nHash data using the sha384 algorithm and return the resulting digest. See also SHA2_384_CTX.\n\n\n\n\n\nsha384(io::IO)\n\nHash data from io using sha384 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha512","location":"stdlib/SHA.html#SHA.sha512","category":"function","text":"sha512(data)\n\nHash data using the sha512 algorithm and return the resulting digest. See also SHA2_512_CTX.\n\n\n\n\n\nsha512(io::IO)\n\nHash data from io using sha512 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha2_224","location":"stdlib/SHA.html#SHA.sha2_224","category":"function","text":"sha2_224(data)\n\nHash data using the sha2_224 algorithm and return the resulting digest. See also SHA2_224_CTX.\n\n\n\n\n\nsha2_224(io::IO)\n\nHash data from io using sha2_224 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha2_256","location":"stdlib/SHA.html#SHA.sha2_256","category":"function","text":"sha2_256(data)\n\nHash data using the sha2_256 algorithm and return the resulting digest. See also SHA2_256_CTX.\n\n\n\n\n\nsha2_256(io::IO)\n\nHash data from io using sha2_256 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha2_384","location":"stdlib/SHA.html#SHA.sha2_384","category":"function","text":"sha2_384(data)\n\nHash data using the sha2_384 algorithm and return the resulting digest. See also SHA2_384_CTX.\n\n\n\n\n\nsha2_384(io::IO)\n\nHash data from io using sha2_384 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha2_512","location":"stdlib/SHA.html#SHA.sha2_512","category":"function","text":"sha2_512(data)\n\nHash data using the sha2_512 algorithm and return the resulting digest. See also SHA2_512_CTX.\n\n\n\n\n\nsha2_512(io::IO)\n\nHash data from io using sha2_512 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-3","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"sha3_224\nsha3_256\nsha3_384\nsha3_512","page":"SHA"},{"title":"SHA.sha3_224","location":"stdlib/SHA.html#SHA.sha3_224","category":"function","text":"sha3_224(data)\n\nHash data using the sha3_224 algorithm and return the resulting digest. See also SHA3_224_CTX.\n\n\n\n\n\nsha3_224(io::IO)\n\nHash data from io using sha3_224 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha3_256","location":"stdlib/SHA.html#SHA.sha3_256","category":"function","text":"sha3_256(data)\n\nHash data using the sha3_256 algorithm and return the resulting digest. See also SHA3_256_CTX.\n\n\n\n\n\nsha3_256(io::IO)\n\nHash data from io using sha3_256 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha3_384","location":"stdlib/SHA.html#SHA.sha3_384","category":"function","text":"sha3_384(data)\n\nHash data using the sha3_384 algorithm and return the resulting digest. See also SHA3_384_CTX.\n\n\n\n\n\nsha3_384(io::IO)\n\nHash data from io using sha3_384 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.sha3_512","location":"stdlib/SHA.html#SHA.sha3_512","category":"function","text":"sha3_512(data)\n\nHash data using the sha3_512 algorithm and return the resulting digest. See also SHA3_512_CTX.\n\n\n\n\n\nsha3_512(io::IO)\n\nHash data from io using sha3_512 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"Working with context","location":"stdlib/SHA.html#Working-with-context","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"To create a hash from multiple items the SHAX_XXX_CTX() types can be used to create a stateful hash object that is updated with update! and finalized with digest!","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"julia> using SHA\n\njulia> ctx = SHA2_256_CTX()\nSHA2 256-bit hash state\n\njulia> update!(ctx, b\"some data\")\n0x0000000000000009\n\njulia> update!(ctx, b\"some more data\")\n0x0000000000000017\n\njulia> digest!(ctx)\n32-element Vector{UInt8}:\n 0xbe\n 0xcf\n 0x23\n 0xda\n 0xaf\n 0x02\n 0xf7\n 0xa3\n 0x57\n 0x92\n    ⋮\n 0x89\n 0x4f\n 0x59\n 0xd8\n 0xb3\n 0xb4\n 0x81\n 0x8b\n 0xc5","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Note that, at the time of this writing, the SHA3 code is not optimized, and as such is roughly an order of magnitude slower than SHA2.","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"update!\ndigest!","page":"SHA"},{"title":"SHA.update!","location":"stdlib/SHA.html#SHA.update!","category":"function","text":"update!(context, data[, datalen])\n\nUpdate the SHA context with the bytes in data. See also digest! for finalizing the hash.\n\nExamples\n\njulia> ctx = SHA1_CTX()\nSHA1 hash state\n\njulia> update!(ctx, b\"data to to be hashed\")\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.digest!","location":"stdlib/SHA.html#SHA.digest!","category":"function","text":"digest!(context)\n\nFinalize the SHA context and return the hash as array of bytes (Array{Uint8, 1}). Updating the context after calling digest! on it will error.\n\nExamples\n\njulia> ctx = SHA1_CTX()\nSHA1 hash state\n\njulia> update!(ctx, b\"data to to be hashed\")\n\njulia> digest!(ctx)\n20-element Array{UInt8,1}:\n 0x83\n 0xe4\n ⋮\n 0x89\n 0xf5\n\njulia> update!(ctx, b\"more data\")\nERROR: Cannot update CTX after `digest!` has been called on it\n[...]\n\n\n\n\n\n","page":"SHA"},{"title":"All SHA context types","location":"stdlib/SHA.html#All-SHA-context-types","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-1","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA1_CTX","page":"SHA"},{"title":"SHA.SHA1_CTX","location":"stdlib/SHA.html#SHA.SHA1_CTX","category":"type","text":"SHA1_CTX()\n\nConstruct an empty SHA1 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-2","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"Convenience types are also provided, where SHAXXX_CTX is a type alias for SHA2_XXX_CTX.","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA224_CTX\nSHA256_CTX\nSHA384_CTX\nSHA512_CTX\nSHA2_224_CTX\nSHA2_256_CTX\nSHA2_384_CTX\nSHA2_512_CTX","page":"SHA"},{"title":"SHA.SHA224_CTX","location":"stdlib/SHA.html#SHA.SHA224_CTX","category":"type","text":"SHA2_224_CTX()\n\nConstruct an empty SHA2_224 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA256_CTX","location":"stdlib/SHA.html#SHA.SHA256_CTX","category":"type","text":"SHA2_256_CTX()\n\nConstruct an empty SHA2_256 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA384_CTX","location":"stdlib/SHA.html#SHA.SHA384_CTX","category":"type","text":"SHA2_384()\n\nConstruct an empty SHA2_384 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA512_CTX","location":"stdlib/SHA.html#SHA.SHA512_CTX","category":"type","text":"SHA2_512_CTX()\n\nConstruct an empty SHA2_512 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA2_224_CTX","location":"stdlib/SHA.html#SHA.SHA2_224_CTX","category":"type","text":"SHA2_224_CTX()\n\nConstruct an empty SHA2_224 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA2_256_CTX","location":"stdlib/SHA.html#SHA.SHA2_256_CTX","category":"type","text":"SHA2_256_CTX()\n\nConstruct an empty SHA2_256 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA2_384_CTX","location":"stdlib/SHA.html#SHA.SHA2_384_CTX","category":"type","text":"SHA2_384()\n\nConstruct an empty SHA2_384 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA2_512_CTX","location":"stdlib/SHA.html#SHA.SHA2_512_CTX","category":"type","text":"SHA2_512_CTX()\n\nConstruct an empty SHA2_512 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-3","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA3_224_CTX\nSHA3_256_CTX\nSHA3_384_CTX\nSHA3_512_CTX","page":"SHA"},{"title":"SHA.SHA3_224_CTX","location":"stdlib/SHA.html#SHA.SHA3_224_CTX","category":"type","text":"SHA3_224_CTX()\n\nConstruct an empty SHA3_224 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA3_256_CTX","location":"stdlib/SHA.html#SHA.SHA3_256_CTX","category":"type","text":"SHA3_256_CTX()\n\nConstruct an empty SHA3_256 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA3_384_CTX","location":"stdlib/SHA.html#SHA.SHA3_384_CTX","category":"type","text":"SHA3_384_CTX()\n\nConstruct an empty SHA3_384 context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.SHA3_512_CTX","location":"stdlib/SHA.html#SHA.SHA3_512_CTX","category":"type","text":"SHA3_512_CTX()\n\nConstruct an empty SHA3_512 context.\n\n\n\n\n\n","page":"SHA"},{"title":"HMAC functions","location":"stdlib/SHA.html#HMAC-functions","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"julia> using SHA\n\njulia> key = collect(codeunits(\"key_string\"))\n10-element Vector{UInt8}:\n 0x6b\n 0x65\n 0x79\n 0x5f\n 0x73\n 0x74\n 0x72\n 0x69\n 0x6e\n 0x67\n\njulia> bytes2hex(hmac_sha3_256(key, \"test-message\"))\n\"bc49a6f2aa29b27ee5ed1e944edd7f3d153e8a01535d98b5e24dac9a589a6248\"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"To create a hash from multiple items, the HMAC_CTX() types can be used to create a stateful hash object that is updated with update! and finalized with digest!.","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"julia> using SHA\n\njulia> key = collect(codeunits(\"key_string\"))\n10-element Vector{UInt8}:\n 0x6b\n 0x65\n 0x79\n 0x5f\n 0x73\n 0x74\n 0x72\n 0x69\n 0x6e\n 0x67\n\njulia> ctx = HMAC_CTX(SHA3_256_CTX(), key);\n\njulia> update!(ctx, b\"test-\")\n0x0000000000000000000000000000008d\n\njulia> update!(ctx, b\"message\")\n0x00000000000000000000000000000094\n\njulia> bytes2hex(digest!(ctx))\n\"bc49a6f2aa29b27ee5ed1e944edd7f3d153e8a01535d98b5e24dac9a589a6248\"","page":"SHA"},{"title":"All HMAC functions","location":"stdlib/SHA.html#All-HMAC-functions","category":"section","text":"","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"HMAC context type","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"HMAC_CTX","page":"SHA"},{"title":"SHA.HMAC_CTX","location":"stdlib/SHA.html#SHA.HMAC_CTX","category":"type","text":"HMAC_CTX(ctx::CTX, key::Vector{UInt8}) where {CTX<:SHA_CTX}\n\nConstruct an empty HMAC_CTX context.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-1","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"hmac_sha1","page":"SHA"},{"title":"SHA.hmac_sha1","location":"stdlib/SHA.html#SHA.hmac_sha1","category":"function","text":"hmac_sha1(key, data)\n\nHash data using the sha1 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha1(key, io::IO)\n\nHash data from io with the passed key using sha1 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-2","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"hmac_sha224\nhmac_sha256\nhmac_sha384\nhmac_sha512\nhmac_sha2_224\nhmac_sha2_256\nhmac_sha2_384\nhmac_sha2_512","page":"SHA"},{"title":"SHA.hmac_sha224","location":"stdlib/SHA.html#SHA.hmac_sha224","category":"function","text":"hmac_sha224(key, data)\n\nHash data using the sha224 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha224(key, io::IO)\n\nHash data from io with the passed key using sha224 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha256","location":"stdlib/SHA.html#SHA.hmac_sha256","category":"function","text":"hmac_sha256(key, data)\n\nHash data using the sha256 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha256(key, io::IO)\n\nHash data from io with the passed key using sha256 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha384","location":"stdlib/SHA.html#SHA.hmac_sha384","category":"function","text":"hmac_sha384(key, data)\n\nHash data using the sha384 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha384(key, io::IO)\n\nHash data from io with the passed key using sha384 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha512","location":"stdlib/SHA.html#SHA.hmac_sha512","category":"function","text":"hmac_sha512(key, data)\n\nHash data using the sha512 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha512(key, io::IO)\n\nHash data from io with the passed key using sha512 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha2_224","location":"stdlib/SHA.html#SHA.hmac_sha2_224","category":"function","text":"hmac_sha2_224(key, data)\n\nHash data using the sha2_224 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha2_224(key, io::IO)\n\nHash data from io with the passed key using sha2_224 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha2_256","location":"stdlib/SHA.html#SHA.hmac_sha2_256","category":"function","text":"hmac_sha2_256(key, data)\n\nHash data using the sha2_256 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha2_256(key, io::IO)\n\nHash data from io with the passed key using sha2_256 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha2_384","location":"stdlib/SHA.html#SHA.hmac_sha2_384","category":"function","text":"hmac_sha2_384(key, data)\n\nHash data using the sha2_384 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha2_384(key, io::IO)\n\nHash data from io with the passed key using sha2_384 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha2_512","location":"stdlib/SHA.html#SHA.hmac_sha2_512","category":"function","text":"hmac_sha2_512(key, data)\n\nHash data using the sha2_512 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha2_512(key, io::IO)\n\nHash data from io with the passed key using sha2_512 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"SHA-3","page":"SHA"},{"title":"SHA","location":"stdlib/SHA.html","category":"page","text":"hmac_sha3_224\nhmac_sha3_256\nhmac_sha3_384\nhmac_sha3_512","page":"SHA"},{"title":"SHA.hmac_sha3_224","location":"stdlib/SHA.html#SHA.hmac_sha3_224","category":"function","text":"hmac_sha3_224(key, data)\n\nHash data using the sha3_224 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha3_224(key, io::IO)\n\nHash data from io with the passed key using sha3_224 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha3_256","location":"stdlib/SHA.html#SHA.hmac_sha3_256","category":"function","text":"hmac_sha3_256(key, data)\n\nHash data using the sha3_256 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha3_256(key, io::IO)\n\nHash data from io with the passed key using sha3_256 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha3_384","location":"stdlib/SHA.html#SHA.hmac_sha3_384","category":"function","text":"hmac_sha3_384(key, data)\n\nHash data using the sha3_384 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha3_384(key, io::IO)\n\nHash data from io with the passed key using sha3_384 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"SHA.hmac_sha3_512","location":"stdlib/SHA.html#SHA.hmac_sha3_512","category":"function","text":"hmac_sha3_512(key, data)\n\nHash data using the sha3_512 algorithm using the passed key. See also HMAC_CTX.\n\n\n\n\n\nhmac_sha3_512(key, io::IO)\n\nHash data from io with the passed key using sha3_512 algorithm.\n\n\n\n\n\n","page":"SHA"},{"title":"Reflection and introspection","location":"base/reflection.html#Reflection-and-introspection","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Julia provides a variety of runtime reflection capabilities.","page":"Reflection and introspection"},{"title":"Module bindings","location":"base/reflection.html#Module-bindings","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The public names for a Module are available using names(m::Module), which will return an array of Symbol elements representing the public bindings. names(m::Module, all = true) returns symbols for all bindings in m, regardless of public status.","page":"Reflection and introspection"},{"title":"DataType fields","location":"base/reflection.html#DataType-fields","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The names of DataType fields may be interrogated using fieldnames. For example, given the following type, fieldnames(Point) returns a tuple of Symbols representing the field names:","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> struct Point\n           x::Int\n           y\n       end\n\njulia> fieldnames(Point)\n(:x, :y)","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The type of each field in a Point object is stored in the types field of the Point variable itself:","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> Point.types\nsvec(Int64, Any)","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"While x is annotated as an Int, y was unannotated in the type definition, therefore y defaults to the Any type.","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Types are themselves represented as a structure called DataType:","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> typeof(Point)\nDataType","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Note that fieldnames(DataType) gives the names for each field of DataType itself, and one of these fields is the types field observed in the example above.","page":"Reflection and introspection"},{"title":"Subtypes","location":"base/reflection.html#Subtypes","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The direct subtypes of any DataType may be listed using subtypes. For example, the abstract DataType AbstractFloat has four (concrete) subtypes:","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> InteractiveUtils.subtypes(AbstractFloat)\n5-element Vector{Any}:\n BigFloat\n Core.BFloat16\n Float16\n Float32\n Float64","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Any abstract subtype will also be included in this list, but further subtypes thereof will not; recursive application of subtypes may be used to inspect the full type tree.","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Note that subtypes is located inside InteractiveUtils but is automatically exported when using the REPL.","page":"Reflection and introspection"},{"title":"DataType layout","location":"base/reflection.html#DataType-layout","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The internal representation of a DataType is critically important when interfacing with C code and several functions are available to inspect these details. isbitstype(T::DataType) returns true if T is stored with C-compatible alignment. fieldoffset(T::DataType, i::Integer) returns the (byte) offset for field i relative to the start of the type.","page":"Reflection and introspection"},{"title":"Function methods","location":"base/reflection.html#Function-methods","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The methods of any generic function may be listed using methods. The method dispatch table may be searched for methods accepting a given type using methodswith.","page":"Reflection and introspection"},{"title":"Expansion and lowering","location":"base/reflection.html#Expansion-and-lowering","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"As discussed in the Metaprogramming section, the macroexpand function gives the unquoted and interpolated expression (Expr) form for a given macro. To use macroexpand, quote the expression block itself (otherwise, the macro will be evaluated and the result will be passed instead!). For example:","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> InteractiveUtils.macroexpand(@__MODULE__, :(@edit println(\"\")) )\n:(InteractiveUtils.edit(println, (Base.typesof)(\"\")))","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The functions Base.Meta.show_sexpr and dump are used to display S-expr style views and depth-nested detail views for any expression.","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Finally, the Meta.lower function gives the lowered form of any expression and is of particular interest for understanding how language constructs map to primitive operations such as assignments, branches, and calls:","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> Meta.lower(@__MODULE__, :( [1+2, sin(0.5)] ))\n:($(Expr(:thunk, CodeInfo(\n    @ none within `top-level scope`\n1 ─ %1 = 1 + 2\n│   %2 = sin(0.5)\n│   %3 = Base.vect(%1, %2)\n└──      return %3\n))))","page":"Reflection and introspection"},{"title":"Intermediate and compiled representations","location":"base/reflection.html#Intermediate-and-compiled-representations","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Inspecting the lowered form for functions requires selection of the specific method to display, because generic functions may have many methods with different type signatures. For this purpose, method-specific code-lowering is available using code_lowered, and the type-inferred form is available using code_typed. code_warntype adds highlighting to the output of code_typed.","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Closer to the machine, the LLVM intermediate representation of a function may be printed using by code_llvm, and finally the compiled machine code is available using code_native (this will trigger JIT compilation/code generation for any function which has not previously been called).","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"For convenience, there are macro versions of the above functions which take standard function calls and expand argument types automatically:","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> @code_llvm +(1,1)\n;  @ int.jl:87 within `+`\n; Function Attrs: sspstrong uwtable\ndefine i64 @\"julia_+_476\"(i64 signext %0, i64 signext %1) #0 {\ntop:\n  %2 = add i64 %1, %0\n  ret i64 %2\n}","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"For more information see @code_lowered, @code_typed, @code_warntype, @code_llvm, and @code_native.","page":"Reflection and introspection"},{"title":"Printing of debug information","location":"base/reflection.html#Printing-of-debug-information","category":"section","text":"","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"The aforementioned functions and macros take the keyword argument debuginfo that controls the level debug information printed.","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"julia> InteractiveUtils.@code_typed debuginfo=:source +(1,1)\nCodeInfo(\n    @ int.jl:87 within `+`\n1 ─ %1 = Base.add_int(x, y)::Int64\n└──      return %1\n) => Int64","page":"Reflection and introspection"},{"title":"Reflection and introspection","location":"base/reflection.html","category":"page","text":"Possible values for debuginfo are: :none, :source, and :default. Per default debug information is not printed, but that can be changed by setting Base.IRShow.default_debuginfo[] = :source.","page":"Reflection and introspection"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/TOML/docs/src/index.md\"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html#TOML","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"TOML.jl is a Julia standard library for parsing and writing TOML v1.0 files.","page":"TOML"},{"title":"Parsing TOML data","location":"stdlib/TOML.html#Parsing-TOML-data","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> data = \"\"\"\n           [database]\n           server = \"192.168.1.1\"\n           ports = [ 8001, 8001, 8002 ]\n       \"\"\";\n\njulia> TOML.parse(data)\nDict{String, Any} with 1 entry:\n  \"database\" => Dict{String, Any}(\"server\"=>\"192.168.1.1\", \"ports\"=>[8001, 8001…","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"To parse a file, use TOML.parsefile. If the file has a syntax error, an exception is thrown:","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> TOML.parse(\"\"\"\n           value = 0.0.0\n       \"\"\")\nERROR: TOML Parser error:\nnone:1:16 error: failed to parse value\n      value = 0.0.0\n                 ^\n[...]","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"There are other versions of the parse functions (TOML.tryparse and TOML.tryparsefile) that instead of throwing exceptions on parser error returns a TOML.ParserError with information:","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> err = TOML.tryparse(\"\"\"\n           value = 0.0.0\n       \"\"\");\n\njulia> err.type\nErrGenericValueError::ErrorType = 14\n\njulia> err.line\n1\n\njulia> err.column\n16","page":"TOML"},{"title":"Exporting data to TOML file","location":"stdlib/TOML.html#Exporting-data-to-TOML-file","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"The TOML.print function is used to print (or serialize) data into TOML format.","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> data = Dict(\n          \"names\" => [\"Julia\", \"Julio\"],\n          \"age\" => [10, 20],\n       );\n\njulia> TOML.print(data)\nnames = [\"Julia\", \"Julio\"]\nage = [10, 20]\n\njulia> fname = tempname();\n\njulia> open(fname, \"w\") do io\n           TOML.print(io, data)\n       end\n\njulia> TOML.parsefile(fname)\nDict{String, Any} with 2 entries:\n  \"names\" => [\"Julia\", \"Julio\"]\n  \"age\"   => [10, 20]","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"Keys can be sorted according to some value","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> TOML.print(Dict(\n       \"abc\"  => 1,\n       \"ab\"   => 2,\n       \"abcd\" => 3,\n       ); sorted=true, by=length)\nab = 2\nabc = 1\nabcd = 3","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"For custom structs, pass a function that converts the struct to a supported type","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"julia> using TOML\n\njulia> struct MyStruct\n           a::Int\n           b::String\n       end\n\njulia> TOML.print(Dict(\"foo\" => MyStruct(5, \"bar\"))) do x\n           x isa MyStruct && return [x.a, x.b]\n           error(\"unhandled type $(typeof(x))\")\n       end\nfoo = [5, \"bar\"]","page":"TOML"},{"title":"References","location":"stdlib/TOML.html#References","category":"section","text":"","page":"TOML"},{"title":"TOML","location":"stdlib/TOML.html","category":"page","text":"TOML.parse\nTOML.parsefile\nTOML.tryparse\nTOML.tryparsefile\nTOML.print\nTOML.Parser\nTOML.ParserError","page":"TOML"},{"title":"TOML.parse","location":"stdlib/TOML.html#TOML.parse","category":"function","text":"parse(x::Union{AbstractString, IO})\nparse(p::Parser, x::Union{AbstractString, IO})\n\nParse the string  or stream x, and return the resulting table (dictionary). Throw a ParserError upon failure.\n\nSee also TOML.tryparse.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.parsefile","location":"stdlib/TOML.html#TOML.parsefile","category":"function","text":"parsefile(f::AbstractString)\nparsefile(p::Parser, f::AbstractString)\n\nParse file f and return the resulting table (dictionary). Throw a ParserError upon failure.\n\nSee also TOML.tryparsefile.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.tryparse","location":"stdlib/TOML.html#TOML.tryparse","category":"function","text":"tryparse(x::Union{AbstractString, IO})\ntryparse(p::Parser, x::Union{AbstractString, IO})\n\nParse the string or stream x, and return the resulting table (dictionary). Return a ParserError upon failure.\n\nSee also TOML.parse.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.tryparsefile","location":"stdlib/TOML.html#TOML.tryparsefile","category":"function","text":"tryparsefile(f::AbstractString)\ntryparsefile(p::Parser, f::AbstractString)\n\nParse file f and return the resulting table (dictionary). Return a ParserError upon failure.\n\nSee also TOML.parsefile.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.print","location":"stdlib/TOML.html#TOML.print","category":"function","text":"print([to_toml::Function], io::IO [=stdout], data::AbstractDict; sorted=false, by=identity, inline_tables::IdSet{<:AbstractDict})\n\nWrite data as TOML syntax to the stream io. If the keyword argument sorted is set to true, sort tables according to the function given by the keyword argument by. If the keyword argument inline_tables is given, it should be a set of tables that should be printed \"inline\".\n\nThe following data types are supported: AbstractDict, AbstractVector, AbstractString, Integer, AbstractFloat, Bool, Dates.DateTime, Dates.Time, Dates.Date. Note that the integers and floats need to be convertible to Float64 and Int64 respectively. For other data types, pass the function to_toml that takes the data types and returns a value of a supported type.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.Parser","location":"stdlib/TOML.html#TOML.Parser","category":"type","text":"Parser()\n\nConstructor for a TOML Parser.  Note that in most cases one does not need to explicitly create a Parser but instead one directly use use TOML.parsefile or TOML.parse.  Using an explicit parser will however reuse some internal data structures which can be beneficial for performance if a larger number of small files are parsed.\n\n\n\n\n\n","page":"TOML"},{"title":"TOML.ParserError","location":"stdlib/TOML.html#TOML.ParserError","category":"type","text":"ParserError\n\nType that is returned from tryparse and tryparsefile when parsing fails. It contains (among others) the following fields:\n\npos, the position in the string when the error happened\ntable, the result that so far was successfully parsed\ntype, an error type, different for different types of errors\n\n\n\n\n\n","page":"TOML"},{"title":"FreeBSD","location":"devdocs/build/freebsd.html#FreeBSD","category":"section","text":"","page":"FreeBSD"},{"title":"FreeBSD","location":"devdocs/build/freebsd.html","category":"page","text":"Clang is the default compiler on FreeBSD 11.0-RELEASE and above. The remaining build tools are available from the Ports Collection, and can be installed using pkg install git gcc gmake cmake pkgconf. To build Julia, simply run gmake. (Note that gmake must be used rather than make, since make on FreeBSD corresponds to the incompatible BSD Make rather than GNU Make.)","page":"FreeBSD"},{"title":"FreeBSD","location":"devdocs/build/freebsd.html","category":"page","text":"As mentioned above, it is important to note that the USE_SYSTEM_* flags should be used with caution on FreeBSD. This is because many system libraries, and even libraries from the Ports Collection, link to the system's libgcc_s.so.1, or to another library which links to the system libgcc_s. This library declares its GCC version to be 4.6, which is too old to build Julia, and conflicts with other libraries when linking. Thus it is highly recommended to simply allow Julia to build all of its dependencies. If you do choose to use the USE_SYSTEM_* flags, note that /usr/local is not on the compiler path by default, so you may need to add LDFLAGS=-L/usr/local/lib and CPPFLAGS=-I/usr/local/include to your Make.user, though doing so may interfere with other dependencies.","page":"FreeBSD"},{"title":"FreeBSD","location":"devdocs/build/freebsd.html","category":"page","text":"Note that the x86 architecture does not support threading due to lack of compiler runtime library support, so you may need to set JULIA_THREADS=0 in your Make.user if you're on a 32-bit system.","page":"FreeBSD"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html#Static-analyzer-annotations-for-GC-correctness-in-C-code","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Running the analysis","location":"devdocs/gc-sa.html#Running-the-analysis","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The analyzer plugin that drives the analysis ships with julia. Its source code can be found in src/clangsa. Running it requires the clang dependency to be build. Set the BUILD_LLVM_CLANG variable in your Make.user in order to build an appropriate version of clang. You may also want to use the prebuilt binaries using the USE_BINARYBUILDER_LLVM options.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Alternatively (or if these do not suffice), try","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"make -C src install-analysis-deps","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"from Julia's toplevel directory.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Afterwards, running the analysis over the source tree is as simple as running make -C src analyzegc.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"General Overview","location":"devdocs/gc-sa.html#General-Overview","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Since Julia's GC is precise, it needs to maintain correct rooting information for any value that may be referenced at any time GC may occur. These places are known as safepoints and in the function local context, we extend this designation to any function call that may recursively end up at a safepoint.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"In generated code, this is taken care of automatically by the GC root placement pass (see the chapter on GC rooting in the LLVM codegen devdocs). However, in C code, we need to inform the runtime of any GC roots manually. This is done using the following macros:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"// The value assigned to any slot passed as an argument to these\n// is rooted for the duration of this GC frame.\nJL_GC_PUSH{1,...,6}(args...)\n// The values assigned into the size `n` array `rts` are rooted\n// for the duration of this GC frame.\nJL_GC_PUSHARGS(rts, n)\n// Pop a GC frame\nJL_GC_POP","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"If these macros are not used where they need to be, or they are used incorrectly, the result is silent memory corruption. As such it is very important that they are placed correctly in all applicable code.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"As such, we employ static analysis (and in particular the clang static analyzer) to help ensure that these macros are used correctly. The remainder of this document gives an overview of this static analysis and describes the support needed in the julia code base to make things work.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"GC Invariants","location":"devdocs/gc-sa.html#GC-Invariants","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"There is two simple invariants correctness:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"All GC_PUSH calls need to be followed by an appropriate GC_POP (in practice we enforce this at the function level)\nIf a value was previously not rooted at any safepoint, it may no longer be referenced afterwards","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Of course the devil is in the details here. In particular to satisfy the second of the above conditions, we need to know:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Which calls are safepoints and which are not\nWhich values are rooted at any given safepoint and which are not\nWhen is a value referenced","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"For the second point in particular, we need to know which memory locations will be considered rooting at runtime (i.e. values assigned to such locations are rooted). This includes locations explicitly designated as such by passing them to one of the GC_PUSH macros, globally rooted locations and values, as well as any location recursively reachable from one of those locations.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static Analysis Algorithm","location":"devdocs/gc-sa.html#Static-Analysis-Algorithm","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The idea itself is very simple, although the implementation is quite a bit more complicated (mainly due to a large number of special cases and intricacies of C and C++). In essence, we keep track of all locations that are rooting, all values that are rootable and any expression (assignments, allocations, etc) affect the rootedness of any rootable values. Then, at any safepoint, we perform a \"symbolic GC\" and poison any values that are not rooted at said location. If these values are later referenced, we emit an error.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The clang static analyzer works by constructing a graph of states and exploring this graph for sources of errors. Several nodes in this graph are generated by the analyzer itself (e.g. for control flow), but the definitions above augment this graph with our own state.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The static analyzer is interprocedural and can analyze control flow across function boundaries. However, the static analyzer is not fully recursive and makes heuristic decisions about which calls to explore (additionally some calls are cross-translation unit and invisible to the analyzer). In our case, our definition of correctness requires total information. As such, we need to annotate the prototypes of all function calls with whatever information the analysis required, even if that information would otherwise be available by interprocedural static analysis.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Luckily however, we can still use this interprocedural analysis to ensure that the annotations we place on a given function are indeed correct given the implementation of said function.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"The analyzer annotations","location":"devdocs/gc-sa.html#The-analyzer-annotations","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"These annotations are found in src/support/analyzer_annotations.h. The are only active when the analyzer is being used and expand either to nothing (for prototype annotations) or to no-ops (for function like annotations).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_NOTSAFEPOINT","location":"devdocs/gc-sa.html#JL_NOTSAFEPOINT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This is perhaps the most common annotation, and should be placed on any function that is known not to possibly lead to reaching a GC safepoint. In general, it is only safe for such a function to perform arithmetic, memory accesses and calls to functions either annotated JL_NOTSAFEPOINT or otherwise known not to be safepoints (e.g. function in the C standard library, which are hardcoded as such in the analyzer)","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"It is valid to keep values unrooted across calls to any function annotated with this attribute:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage Example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_get_one() JL_NOTSAFEPOINT {\n  return 1;\n}\n\njl_value_t *example() {\n  jl_value_t *val = jl_alloc_whatever();\n  // This is valid, even though `val` is unrooted, because\n  // jl_get_one is not a safepoint\n  jl_get_one();\n  return val;\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_MAYBE_UNROOTED/JL_ROOTS_TEMPORARILY","location":"devdocs/gc-sa.html#JL_MAYBE_UNROOTED/JL_ROOTS_TEMPORARILY","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"When JL_MAYBE_UNROOTED is annotated as an argument on a function, indicates that said argument may be passed, even if it is not rooted. In the ordinary course of events, the julia ABI guarantees that callers root values before passing them to callees. However, some functions do not follow this ABI and allow values to be passed to them even though they are not rooted. Note however, that this does not automatically imply that said argument will be preserved. The ROOTS_TEMPORARILY annotation provides the stronger guarantee that, not only may the value be unrooted when passed, it will also be preserved across any internal safepoints by the callee.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Note that JL_NOTSAFEPOINT essentially implies JL_MAYBE_UNROOTED/JL_ROOTS_TEMPORARILY, because the rootedness of an argument is irrelevant if the function contains no safepoints.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"One additional point to note is that these annotations apply on both the caller and the callee side. On the caller side, they lift rootedness restrictions that are normally required for julia ABI functions. On the callee side, they have the reverse effect of preventing these arguments from being considered implicitly rooted.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"If either of these annotations is applied to the function as a whole, it applies to all arguments of the function. This should generally only be necessary for varargs functions.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"JL_DLLEXPORT void JL_NORETURN jl_throw(jl_value_t *e JL_MAYBE_UNROOTED);\njl_value_t *jl_alloc_error();\n\nvoid example() {\n  // The return value of the allocation is unrooted. This would normally\n  // be an error, but is allowed because of the above annotation.\n  jl_throw(jl_alloc_error());\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_PROPAGATES_ROOT","location":"devdocs/gc-sa.html#JL_PROPAGATES_ROOT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation is commonly found on accessor functions that return one rootable object stored within another. When annotated on a function argument, it tells the analyzer that the root for that argument also applies to the value returned by the function.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage Example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"jl_value_t *jl_svecref(jl_svec_t *t JL_PROPAGATES_ROOT, size_t i) JL_NOTSAFEPOINT;\n\nsize_t example(jl_svec_t *svec) {\n  jl_value_t *val = jl_svecref(svec, 1)\n  // This is valid, because, as annotated by the PROPAGATES_ROOT annotation,\n  // jl_svecref propagates the rooted-ness from `svec` to `val`\n  jl_gc_safepoint();\n  return jl_unbox_long(val);\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_ROOTING_ARGUMENT/JL_ROOTED_ARGUMENT","location":"devdocs/gc-sa.html#JL_ROOTING_ARGUMENT/JL_ROOTED_ARGUMENT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This is essentially the assignment counterpart to JL_PROPAGATES_ROOT. When assigning a value to a field of another value that is already rooted, the assigned value will inherit the root of the value it is assigned into.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage Example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_svecset(void *t JL_ROOTING_ARGUMENT, size_t i, void *x JL_ROOTED_ARGUMENT) JL_NOTSAFEPOINT\n\n\nsize_t example(jl_svec_t *svec) {\n  jl_value_t *val = jl_box_long(10000);\n  jl_svecset(svec, val);\n  // This is valid, because the annotations imply that the\n  // jl_svecset propagates the rooted-ness from `svec` to `val`\n  jl_gc_safepoint();\n  return jl_unbox_long(val);\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_GC_DISABLED","location":"devdocs/gc-sa.html#JL_GC_DISABLED","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation implies that this function is only called with the GC runtime-disabled. Functions of this kind are most often encountered during startup and in the GC code itself. Note that this annotation is checked against the runtime enable/disable calls, so clang will know if you lie. This is not a good way to disable processing of a given function if the GC is not actually disabled (use ifdef __clang_analyzer__ for that if you must).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_do_magic() JL_GC_DISABLED {\n  // Wildly allocate here with no regard for roots\n}\n\nvoid example() {\n  int en = jl_gc_enable(0);\n  jl_do_magic();\n  jl_gc_enable(en);\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_REQUIRE_ROOTED_SLOT","location":"devdocs/gc-sa.html#JL_REQUIRE_ROOTED_SLOT","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation requires the caller to pass in a slot that is rooted (i.e. values assigned to this slot will be rooted).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void jl_do_processing(jl_value_t **slot JL_REQUIRE_ROOTED_SLOT) {\n  *slot = jl_box_long(1);\n  // Ok, only, because the slot was annotated as rooting\n  jl_gc_safepoint();\n}\n\nvoid example() {\n  jl_value_t *slot = NULL;\n  JL_GC_PUSH1(&slot);\n  jl_do_processing(&slot);\n  JL_GC_POP();\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_GLOBALLY_ROOTED","location":"devdocs/gc-sa.html#JL_GLOBALLY_ROOTED","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotation implies that a given value is always globally rooted. It can be applied to global variable declarations, in which case it will apply to the value of those variables (or values if the declaration if for an array), or to functions, in which case it will apply to the return value of such functions (e.g. for functions that always return some private, globally rooted value).","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"Usage example:","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"extern JL_DLLEXPORT jl_datatype_t *jl_any_type JL_GLOBALLY_ROOTED;\njl_ast_context_t *jl_ast_ctx(fl_context_t *fl) JL_GLOBALLY_ROOTED;","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_ALWAYS_LEAFTYPE","location":"devdocs/gc-sa.html#JL_ALWAYS_LEAFTYPE","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This annotations is essentially equivalent to JL_GLOBALLY_ROOTED, except that is should only be used if those values are globally rooted by virtue of being a leaftype. The rooting of leaftypes is a bit complicated. They are generally rooted through cache field of the corresponding TypeName, which itself is rooted by the containing module (so they're rooted as long as the containing module is ok) and we can generally assume that leaftypes are rooted where they are used, but we may refine this property in the future, so the separate annotation helps split out the reason for being globally rooted.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The analyzer also automatically detects checks for leaftype-ness and will not complain about missing GC roots on these paths.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"JL_DLLEXPORT jl_value_t *jl_apply_array_type(jl_value_t *type, size_t dim) JL_ALWAYS_LEAFTYPE;","page":"Static analyzer annotations for GC correctness in C code"},{"title":"JL_GC_PROMISE_ROOTED","location":"devdocs/gc-sa.html#JL_GC_PROMISE_ROOTED","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"This is a function-like annotation. Any value passed to this annotation will be considered rooted for the scope of the current function. It is designed as an escape hatch for analyzer inadequacy or complicated situations. However, it should be used sparingly, in favor of improving the analyzer itself.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"void example() {\n  jl_value_t *val = jl_alloc_something();\n  if (some_condition) {\n    // We happen to know for complicated external reasons\n    // that val is rooted under these conditions\n    JL_GC_PROMISE_ROOTED(val);\n  }\n}","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Completeness of analysis","location":"devdocs/gc-sa.html#Completeness-of-analysis","category":"section","text":"","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Static analyzer annotations for GC correctness in C code","location":"devdocs/gc-sa.html","category":"page","text":"The analyzer only looks at local information. In particular, e.g. in the PROPAGATES_ROOT case above, it assumes that such memory is only modified in ways it can see, not in any called functions (unless it happens to decide to consider them in its analysis) and not in any concurrently running threads. As such, it may miss a few problematic cases, though in practice such concurrent modification is fairly rare. Improving the analyzer to handle more such cases may be an interesting topic for future work.","page":"Static analyzer annotations for GC correctness in C code"},{"title":"Collections and Data Structures","location":"base/collections.html#Collections-and-Data-Structures","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Iteration","location":"base/collections.html#lib-collections-iteration","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Sequential iteration is implemented by the iterate function. The general for loop:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"for i in iter   # or  \"for i = iter\"\n    # body\nend","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"is translated into:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"next = iterate(iter)\nwhile next !== nothing\n    (i, state) = next\n    # body\n    next = iterate(iter, state)\nend","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"The state object may be anything, and should be chosen appropriately for each iterable type. See the manual section on the iteration interface for more details about defining a custom iterable type.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.iterate\nBase.IteratorSize\nBase.IteratorEltype","page":"Collections and Data Structures"},{"title":"Base.iterate","location":"base/collections.html#Base.iterate","category":"function","text":"iterate(iter [, state]) -> Union{Nothing, Tuple{Any, Any}}\n\nAdvance the iterator to obtain the next element. If no elements remain, nothing should be returned. Otherwise, a 2-tuple of the next element and the new iteration state should be returned.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.IteratorSize","location":"base/collections.html#Base.IteratorSize","category":"type","text":"IteratorSize(itertype::Type) -> IteratorSize\n\nGiven the type of an iterator, return one of the following values:\n\nSizeUnknown() if the length (number of elements) cannot be determined in advance.\nHasLength() if there is a fixed, finite length.\nHasShape{N}() if there is a known length plus a notion of multidimensional shape (as for an array).  In this case N should give the number of dimensions, and the axes function is valid  for the iterator.\nIsInfinite() if the iterator yields values forever.\n\nThe default value (for iterators that do not define this function) is HasLength(). This means that most iterators are assumed to implement length.\n\nThis trait is generally used to select between algorithms that pre-allocate space for their result, and algorithms that resize their result incrementally.\n\njulia> Base.IteratorSize(1:5)\nBase.HasShape{1}()\n\njulia> Base.IteratorSize((2,3))\nBase.HasLength()\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.IteratorEltype","location":"base/collections.html#Base.IteratorEltype","category":"type","text":"IteratorEltype(itertype::Type) -> IteratorEltype\n\nGiven the type of an iterator, return one of the following values:\n\nEltypeUnknown() if the type of elements yielded by the iterator is not known in advance.\nHasEltype() if the element type is known, and eltype would return a meaningful value.\n\nHasEltype() is the default, since iterators are assumed to implement eltype.\n\nThis trait is generally used to select between algorithms that pre-allocate a specific type of result, and algorithms that pick a result type based on the types of yielded values.\n\njulia> Base.IteratorEltype(1:5)\nBase.HasEltype()\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"AbstractRange\nUnitRange\nTuple\nNumber\nAbstractArray\nBitSet\nIdDict\nDict\nWeakKeyDict\nEachLine\nAbstractString\nSet\nPair\nNamedTuple","page":"Collections and Data Structures"},{"title":"Constructors and Types","location":"base/collections.html#Constructors-and-Types","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.AbstractRange\nBase.OrdinalRange\nBase.AbstractUnitRange\nBase.StepRange\nBase.UnitRange\nBase.LinRange","page":"Collections and Data Structures"},{"title":"Base.AbstractRange","location":"base/collections.html#Base.AbstractRange","category":"type","text":"AbstractRange{T} <: AbstractVector{T}\n\nSupertype for linear ranges with elements of type T. UnitRange, LinRange and other types are subtypes of this.\n\nAll subtypes must define step. Thus LogRange is not a subtype of AbstractRange.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.OrdinalRange","location":"base/collections.html#Base.OrdinalRange","category":"type","text":"OrdinalRange{T, S} <: AbstractRange{T}\n\nSupertype for ordinal ranges with elements of type T with spacing(s) of type S. The steps should be always-exact multiples of oneunit, and T should be a \"discrete\" type, which cannot have values smaller than oneunit. For example, Integer or Date types would qualify, whereas Float64 would not (since this type can represent values smaller than oneunit(Float64). UnitRange, StepRange, and other types are subtypes of this.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.AbstractUnitRange","location":"base/collections.html#Base.AbstractUnitRange","category":"type","text":"AbstractUnitRange{T} <: OrdinalRange{T, T}\n\nSupertype for ranges with a step size of oneunit(T) with elements of type T. UnitRange and other types are subtypes of this.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.StepRange","location":"base/collections.html#Base.StepRange","category":"type","text":"StepRange{T, S} <: OrdinalRange{T, S}\n\nRanges with elements of type T with spacing of type S. The step between each element is constant, and the range is defined in terms of a start and stop of type T and a step of type S. Neither T nor S should be floating point types. The syntax a:b:c with b != 0 and a, b, and c all integers creates a StepRange.\n\nExamples\n\njulia> collect(StepRange(1, Int8(2), 10))\n5-element Vector{Int64}:\n 1\n 3\n 5\n 7\n 9\n\njulia> typeof(StepRange(1, Int8(2), 10))\nStepRange{Int64, Int8}\n\njulia> typeof(1:3:6)\nStepRange{Int64, Int64}\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.UnitRange","location":"base/collections.html#Base.UnitRange","category":"type","text":"UnitRange{T<:Real}\n\nA range parameterized by a start and stop of type T, filled with elements spaced by 1 from start until stop is exceeded. The syntax a:b with a and b both Integers creates a UnitRange.\n\nExamples\n\njulia> collect(UnitRange(2.3, 5.2))\n3-element Vector{Float64}:\n 2.3\n 3.3\n 4.3\n\njulia> typeof(1:10)\nUnitRange{Int64}\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.LinRange","location":"base/collections.html#Base.LinRange","category":"type","text":"LinRange{T,L}\n\nA range with len linearly spaced elements between its start and stop. The size of the spacing is controlled by len, which must be an Integer.\n\nExamples\n\njulia> LinRange(1.5, 5.5, 9)\n9-element LinRange{Float64, Int64}:\n 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5\n\nCompared to using range, directly constructing a LinRange should have less overhead but won't try to correct for floating point errors:\n\njulia> collect(range(-0.1, 0.3, length=5))\n5-element Vector{Float64}:\n -0.1\n  0.0\n  0.1\n  0.2\n  0.3\n\njulia> collect(LinRange(-0.1, 0.3, 5))\n5-element Vector{Float64}:\n -0.1\n -1.3877787807814457e-17\n  0.09999999999999999\n  0.19999999999999998\n  0.3\n\nSee also Logrange for logarithmically spaced points.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"General Collections","location":"base/collections.html#General-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.isempty\nBase.isdone\nBase.empty!\nBase.length\nBase.checked_length","page":"Collections and Data Structures"},{"title":"Base.isempty","location":"base/collections.html#Base.isempty","category":"function","text":"isempty(collection) -> Bool\n\nDetermine whether a collection is empty (has no elements).\n\nwarning: Warning\nisempty(itr) may consume the next element of a stateful iterator itr unless an appropriate Base.isdone(itr) method is defined. Stateful iterators should implement isdone, but you may want to avoid using isempty when writing generic code which should support any iterator type.\n\nExamples\n\njulia> isempty([])\ntrue\n\njulia> isempty([1 2 3])\nfalse\n\n\n\n\n\nisempty(condition)\n\nReturn true if no tasks are waiting on the condition, false otherwise.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.isdone","location":"base/collections.html#Base.isdone","category":"function","text":"isdone(itr, [state]) -> Union{Bool, Missing}\n\nThis function provides a fast-path hint for iterator completion. This is useful for stateful iterators that want to avoid having elements consumed if they are not going to be exposed to the user (e.g. when checking for done-ness in isempty or zip).\n\nStateful iterators that want to opt into this feature should define an isdone method that returns true/false depending on whether the iterator is done or not. Stateless iterators need not implement this function.\n\nIf the result is missing, callers may go ahead and compute iterate(x, state) === nothing to compute a definite answer.\n\nSee also iterate, isempty\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.empty!","location":"base/collections.html#Base.empty!","category":"function","text":"empty!(collection) -> collection\n\nRemove all elements from a collection.\n\nExamples\n\njulia> A = Dict(\"a\" => 1, \"b\" => 2)\nDict{String, Int64} with 2 entries:\n  \"b\" => 2\n  \"a\" => 1\n\njulia> empty!(A);\n\njulia> A\nDict{String, Int64}()\n\n\n\n\n\nempty!(c::Channel)\n\nEmpty a Channel c by calling empty! on the internal buffer. Return the empty channel.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.length","location":"base/collections.html#Base.length","category":"function","text":"length(collection) -> Integer\n\nReturn the number of elements in the collection.\n\nUse lastindex to get the last valid index of an indexable collection.\n\nSee also: size, ndims, eachindex.\n\nExamples\n\njulia> length(1:5)\n5\n\njulia> length([1, 2, 3, 4])\n4\n\njulia> length([1 2; 3 4])\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.checked_length","location":"base/collections.html#Base.checked_length","category":"function","text":"Base.checked_length(r)\n\nCalculates length(r), but may check for overflow errors where applicable when the result doesn't fit into Union{Integer(eltype(r)),Int}.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"AbstractRange\nUnitRange\nTuple\nNumber\nAbstractArray\nBitSet\nIdDict\nDict\nWeakKeyDict\nAbstractString\nSet\nNamedTuple","page":"Collections and Data Structures"},{"title":"Iterable Collections","location":"base/collections.html#Iterable-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.in\nBase.:∉\nBase.hasfastin\nBase.eltype\nBase.indexin\nBase.unique\nBase.unique!\nBase.allunique\nBase.allequal\nBase.reduce(::Any, ::Any)\nBase.reduce(::Any, ::AbstractArray)\nBase.foldl(::Any, ::Any)\nBase.foldr(::Any, ::Any)\nBase.maximum\nBase.maximum!\nBase.minimum\nBase.minimum!\nBase.extrema\nBase.extrema!\nBase.argmax\nBase.argmin\nBase.findmax\nBase.findmin\nBase.findmax!\nBase.findmin!\nBase.sum\nBase.sum!\nBase.prod\nBase.prod!\nBase.any(::Any)\nBase.any(::AbstractArray, ::Any)\nBase.any!\nBase.all(::Any)\nBase.all(::AbstractArray, ::Any)\nBase.all!\nBase.count\nBase.foreach\nBase.map\nBase.map!\nBase.mapreduce(::Any, ::Any, ::Any)\nBase.mapfoldl(::Any, ::Any, ::Any)\nBase.mapfoldr(::Any, ::Any, ::Any)\nBase.first\nBase.last\nBase.front\nBase.tail\nBase.step\nBase.collect(::Any)\nBase.collect(::Type, ::Any)\nBase.filter\nBase.filter!\nBase.replace(::Any, ::Pair...)\nBase.replace(::Base.Callable, ::Any)\nBase.replace!\nBase.rest\nBase.split_rest","page":"Collections and Data Structures"},{"title":"Base.in","location":"base/collections.html#Base.in","category":"function","text":"in(item, collection) -> Bool\n∈(item, collection) -> Bool\n\nDetermine whether an item is in the given collection, in the sense that it is == to one of the values generated by iterating over the collection. Return a Bool value, except if item is missing or collection contains missing but not item, in which case missing is returned (three-valued logic, matching the behavior of any and ==).\n\nSome collections follow a slightly different definition. For example, Sets check whether the item isequal to one of the elements; Dicts look for key=>value pairs, and the key is compared using isequal.\n\nTo test for the presence of a key in a dictionary, use haskey or k in keys(dict). For the collections mentioned above, the result is always a Bool.\n\nWhen broadcasting with in.(items, collection) or items .∈ collection, both item and collection are broadcasted over, which is often not what is intended. For example, if both arguments are vectors (and the dimensions match), the result is a vector indicating whether each value in collection items is in the value at the corresponding position in collection. To get a vector indicating whether each value in items is in collection, wrap collection in a tuple or a Ref like this: in.(items, Ref(collection)) or items .∈ Ref(collection).\n\nSee also: ∉, insorted, contains, occursin, issubset.\n\nExamples\n\njulia> a = 1:3:20\n1:3:19\n\njulia> 4 in a\ntrue\n\njulia> 5 in a\nfalse\n\njulia> missing in [1, 2]\nmissing\n\njulia> 1 in [2, missing]\nmissing\n\njulia> 1 in [1, missing]\ntrue\n\njulia> missing in Set([1, 2])\nfalse\n\njulia> (1=>missing) in Dict(1=>10, 2=>20)\nmissing\n\njulia> [1, 2] .∈ [2, 3]\n2-element BitVector:\n 0\n 0\n\njulia> [1, 2] .∈ ([2, 3],)\n2-element BitVector:\n 0\n 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.:∉","location":"base/collections.html#Base.:∉","category":"function","text":"∉(item, collection) -> Bool\n∌(collection, item) -> Bool\n\nNegation of ∈ and ∋, i.e. checks that item is not in collection.\n\nWhen broadcasting with items .∉ collection, both item and collection are broadcasted over, which is often not what is intended. For example, if both arguments are vectors (and the dimensions match), the result is a vector indicating whether each value in collection items is not in the value at the corresponding position in collection. To get a vector indicating whether each value in items is not in collection, wrap collection in a tuple or a Ref like this: items .∉ Ref(collection).\n\nExamples\n\njulia> 1 ∉ 2:4\ntrue\n\njulia> 1 ∉ 1:3\nfalse\n\njulia> [1, 2] .∉ [2, 3]\n2-element BitVector:\n 1\n 1\n\njulia> [1, 2] .∉ ([2, 3],)\n2-element BitVector:\n 1\n 0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.hasfastin","location":"base/collections.html#Base.hasfastin","category":"function","text":"Base.hasfastin(T)\n\nDetermine whether the computation x ∈ collection where collection::T can be considered as a \"fast\" operation (typically constant or logarithmic complexity). The definition hasfastin(x) = hasfastin(typeof(x)) is provided for convenience so that instances can be passed instead of types. However the form that accepts a type argument should be defined for new types.\n\nThe default for hasfastin(T) is true for subtypes of AbstractSet, AbstractDict and AbstractRange and false otherwise.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.eltype","location":"base/collections.html#Base.eltype","category":"function","text":"eltype(type)\n\nDetermine the type of the elements generated by iterating a collection of the given type. For dictionary types, this will be a Pair{KeyType,ValType}. The definition eltype(x) = eltype(typeof(x)) is provided for convenience so that instances can be passed instead of types. However the form that accepts a type argument should be defined for new types.\n\nSee also: keytype, typeof.\n\nExamples\n\njulia> eltype(fill(1f0, (2,2)))\nFloat32\n\njulia> eltype(fill(0x1, (2,2)))\nUInt8\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.indexin","location":"base/collections.html#Base.indexin","category":"function","text":"indexin(a, b)\n\nReturn an array containing the first index in b for each value in a that is a member of b. The output array contains nothing wherever a is not a member of b.\n\nSee also: sortperm, findfirst.\n\nExamples\n\njulia> a = ['a', 'b', 'c', 'b', 'd', 'a'];\n\njulia> b = ['a', 'b', 'c'];\n\njulia> indexin(a, b)\n6-element Vector{Union{Nothing, Int64}}:\n 1\n 2\n 3\n 2\n  nothing\n 1\n\njulia> indexin(b, a)\n3-element Vector{Union{Nothing, Int64}}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.unique","location":"base/collections.html#Base.unique","category":"function","text":"unique(itr)\n\nReturn an array containing only the unique elements of collection itr, as determined by isequal and hash, in the order that the first of each set of equivalent elements originally appears. The element type of the input is preserved.\n\nSee also: unique!, allunique, allequal.\n\nExamples\n\njulia> unique([1, 2, 6, 2])\n3-element Vector{Int64}:\n 1\n 2\n 6\n\njulia> unique(Real[1, 1.0, 2])\n2-element Vector{Real}:\n 1\n 2\n\n\n\n\n\nunique(f, itr)\n\nReturn an array containing one value from itr for each unique value produced by f applied to elements of itr.\n\nExamples\n\njulia> unique(x -> x^2, [1, -1, 3, -3, 4])\n3-element Vector{Int64}:\n 1\n 3\n 4\n\nThis functionality can also be used to extract the indices of the first occurrences of unique elements in an array:\n\njulia> a = [3.1, 4.2, 5.3, 3.1, 3.1, 3.1, 4.2, 1.7];\n\njulia> i = unique(i -> a[i], eachindex(a))\n4-element Vector{Int64}:\n 1\n 2\n 3\n 8\n\njulia> a[i]\n4-element Vector{Float64}:\n 3.1\n 4.2\n 5.3\n 1.7\n\njulia> a[i] == unique(a)\ntrue\n\n\n\n\n\nunique(A::AbstractArray; dims::Int)\n\nReturn unique regions of A along dimension dims.\n\nExamples\n\njulia> A = map(isodd, reshape(Vector(1:8), (2,2,2)))\n2×2×2 Array{Bool, 3}:\n[:, :, 1] =\n 1  1\n 0  0\n\n[:, :, 2] =\n 1  1\n 0  0\n\njulia> unique(A)\n2-element Vector{Bool}:\n 1\n 0\n\njulia> unique(A, dims=2)\n2×1×2 Array{Bool, 3}:\n[:, :, 1] =\n 1\n 0\n\n[:, :, 2] =\n 1\n 0\n\njulia> unique(A, dims=3)\n2×2×1 Array{Bool, 3}:\n[:, :, 1] =\n 1  1\n 0  0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.unique!","location":"base/collections.html#Base.unique!","category":"function","text":"unique!(f, A::AbstractVector)\n\nSelects one value from A for each unique value produced by f applied to elements of A, then return the modified A.\n\ncompat: Julia 1.1\nThis method is available as of Julia 1.1.\n\nExamples\n\njulia> unique!(x -> x^2, [1, -1, 3, -3, 4])\n3-element Vector{Int64}:\n 1\n 3\n 4\n\njulia> unique!(n -> n%3, [5, 1, 8, 9, 3, 4, 10, 7, 2, 6])\n3-element Vector{Int64}:\n 5\n 1\n 9\n\njulia> unique!(iseven, [2, 3, 5, 7, 9])\n2-element Vector{Int64}:\n 2\n 3\n\n\n\n\n\nunique!(A::AbstractVector)\n\nRemove duplicate items as determined by isequal and hash, then return the modified A. unique! will return the elements of A in the order that they occur. If you do not care about the order of the returned data, then calling (sort!(A); unique!(A)) will be much more efficient as long as the elements of A can be sorted.\n\nExamples\n\njulia> unique!([1, 1, 1])\n1-element Vector{Int64}:\n 1\n\njulia> A = [7, 3, 2, 3, 7, 5];\n\njulia> unique!(A)\n4-element Vector{Int64}:\n 7\n 3\n 2\n 5\n\njulia> B = [7, 6, 42, 6, 7, 42];\n\njulia> sort!(B);  # unique! is able to process sorted data much more efficiently.\n\njulia> unique!(B)\n3-element Vector{Int64}:\n  6\n  7\n 42\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.allunique","location":"base/collections.html#Base.allunique","category":"function","text":"allunique(itr) -> Bool\nallunique(f, itr) -> Bool\n\nReturn true if all values from itr are distinct when compared with isequal. Or if all of [f(x) for x in itr] are distinct, for the second method.\n\nNote that allunique(f, itr) may call f fewer than length(itr) times. The precise number of calls is regarded as an implementation detail.\n\nallunique may use a specialized implementation when the input is sorted.\n\nSee also: unique, issorted, allequal.\n\ncompat: Julia 1.11\nThe method allunique(f, itr) requires at least Julia 1.11.\n\nExamples\n\njulia> allunique([1, 2, 3])\ntrue\n\njulia> allunique([1, 2, 1, 2])\nfalse\n\njulia> allunique(Real[1, 1.0, 2])\nfalse\n\njulia> allunique([NaN, 2.0, NaN, 4.0])\nfalse\n\njulia> allunique(abs, [1, -1, 2])\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.allequal","location":"base/collections.html#Base.allequal","category":"function","text":"allequal(itr) -> Bool\nallequal(f, itr) -> Bool\n\nReturn true if all values from itr are equal when compared with isequal. Or if all of [f(x) for x in itr] are equal, for the second method.\n\nNote that allequal(f, itr) may call f fewer than length(itr) times. The precise number of calls is regarded as an implementation detail.\n\nSee also: unique, allunique.\n\ncompat: Julia 1.8\nThe allequal function requires at least Julia 1.8.\n\ncompat: Julia 1.11\nThe method allequal(f, itr) requires at least Julia 1.11.\n\nExamples\n\njulia> allequal([])\ntrue\n\njulia> allequal([1])\ntrue\n\njulia> allequal([1, 1])\ntrue\n\njulia> allequal([1, 2])\nfalse\n\njulia> allequal(Dict(:a => 1, :b => 1))\nfalse\n\njulia> allequal(abs2, [1, -1])\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.reduce","location":"base/collections.html#Base.reduce-Tuple{Any, Any}","category":"method","text":"reduce(op, itr; [init])\n\nReduce the given collection itr with the given binary operator op. If provided, the initial value init must be a neutral element for op that will be returned for empty collections. It is unspecified whether init is used for non-empty collections.\n\nFor empty collections, providing init will be necessary, except for some special cases (e.g. when op is one of +, *, max, min, &, |) when Julia can determine the neutral element of op.\n\nReductions for certain commonly-used operators may have special implementations, and should be used instead: maximum(itr), minimum(itr), sum(itr), prod(itr), any(itr), all(itr). There are efficient methods for concatenating certain arrays of arrays by calling reduce(vcat, arr) or reduce(hcat, arr).\n\nThe associativity of the reduction is implementation dependent. This means that you can't use non-associative operations like - because it is undefined whether reduce(-,[1,2,3]) should be evaluated as (1-2)-3 or 1-(2-3). Use foldl or foldr instead for guaranteed left or right associativity.\n\nSome operations accumulate error. Parallelism will be easier if the reduction can be executed in groups. Future versions of Julia might change the algorithm. Note that the elements are not reordered if you use an ordered collection.\n\nExamples\n\njulia> reduce(*, [2; 3; 4])\n24\n\njulia> reduce(*, [2; 3; 4]; init=-1)\n-24\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.reduce","location":"base/collections.html#Base.reduce-Tuple{Any, AbstractArray}","category":"method","text":"reduce(f, A::AbstractArray; dims=:, [init])\n\nReduce 2-argument function f along dimensions of A. dims is a vector specifying the dimensions to reduce, and the keyword argument init is the initial value to use in the reductions. For +, *, max and min the init argument is optional.\n\nThe associativity of the reduction is implementation-dependent; if you need a particular associativity, e.g. left-to-right, you should write your own loop or consider using foldl or foldr. See documentation for reduce.\n\nExamples\n\njulia> a = reshape(Vector(1:16), (4,4))\n4×4 Matrix{Int64}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> reduce(max, a, dims=2)\n4×1 Matrix{Int64}:\n 13\n 14\n 15\n 16\n\njulia> reduce(max, a, dims=1)\n1×4 Matrix{Int64}:\n 4  8  12  16\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.foldl","location":"base/collections.html#Base.foldl-Tuple{Any, Any}","category":"method","text":"foldl(op, itr; [init])\n\nLike reduce, but with guaranteed left associativity. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\nSee also mapfoldl, foldr, accumulate.\n\nExamples\n\njulia> foldl(=>, 1:4)\n((1 => 2) => 3) => 4\n\njulia> foldl(=>, 1:4; init=0)\n(((0 => 1) => 2) => 3) => 4\n\njulia> accumulate(=>, (1,2,3,4))\n(1, 1 => 2, (1 => 2) => 3, ((1 => 2) => 3) => 4)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.foldr","location":"base/collections.html#Base.foldr-Tuple{Any, Any}","category":"method","text":"foldr(op, itr; [init])\n\nLike reduce, but with guaranteed right associativity. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\nExamples\n\njulia> foldr(=>, 1:4)\n1 => (2 => (3 => 4))\n\njulia> foldr(=>, 1:4; init=0)\n1 => (2 => (3 => (4 => 0)))\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.maximum","location":"base/collections.html#Base.maximum","category":"function","text":"maximum(f, itr; [init])\n\nReturn the largest result of calling function f on each element of itr.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for max (i.e. which is less than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> maximum(length, [\"Julion\", \"Julia\", \"Jule\"])\n6\n\njulia> maximum(length, []; init=-1)\n-1\n\njulia> maximum(sin, Real[]; init=-1.0)  # good, since output of sin is >= -1\n-1.0\n\n\n\n\n\nmaximum(itr; [init])\n\nReturn the largest element in a collection.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for max (i.e. which is less than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> maximum(-20.5:10)\n9.5\n\njulia> maximum([1,2,3])\n3\n\njulia> maximum(())\nERROR: ArgumentError: reducing over an empty collection is not allowed; consider supplying `init` to the reducer\nStacktrace:\n[...]\n\njulia> maximum((); init=-Inf)\n-Inf\n\n\n\n\n\nmaximum(A::AbstractArray; dims)\n\nCompute the maximum value of an array over the given dimensions. See also the max(a,b) function to take the maximum of two or more arguments, which can be applied elementwise to arrays via max.(a,b).\n\nSee also: maximum!, extrema, findmax, argmax.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> maximum(A, dims=1)\n1×2 Matrix{Int64}:\n 3  4\n\njulia> maximum(A, dims=2)\n2×1 Matrix{Int64}:\n 2\n 4\n\n\n\n\n\nmaximum(f, A::AbstractArray; dims)\n\nCompute the maximum value by calling the function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> maximum(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 9  16\n\njulia> maximum(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n  4\n 16\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.maximum!","location":"base/collections.html#Base.maximum!","category":"function","text":"maximum!(r, A)\n\nCompute the maximum value of A over the singleton dimensions of r, and write results to r.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> maximum!([1; 1], A)\n2-element Vector{Int64}:\n 2\n 4\n\njulia> maximum!([1 1], A)\n1×2 Matrix{Int64}:\n 3  4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.minimum","location":"base/collections.html#Base.minimum","category":"function","text":"minimum(f, itr; [init])\n\nReturn the smallest result of calling function f on each element of itr.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for min (i.e. which is greater than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> minimum(length, [\"Julion\", \"Julia\", \"Jule\"])\n4\n\njulia> minimum(length, []; init=typemax(Int64))\n9223372036854775807\n\njulia> minimum(sin, Real[]; init=1.0)  # good, since output of sin is <= 1\n1.0\n\n\n\n\n\nminimum(itr; [init])\n\nReturn the smallest element in a collection.\n\nThe value returned for empty itr can be specified by init. It must be a neutral element for min (i.e. which is greater than or equal to any other element) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> minimum(-20.5:10)\n-20.5\n\njulia> minimum([1,2,3])\n1\n\njulia> minimum([])\nERROR: ArgumentError: reducing over an empty collection is not allowed; consider supplying `init` to the reducer\nStacktrace:\n[...]\n\njulia> minimum([]; init=Inf)\nInf\n\n\n\n\n\nminimum(A::AbstractArray; dims)\n\nCompute the minimum value of an array over the given dimensions. See also the min(a,b) function to take the minimum of two or more arguments, which can be applied elementwise to arrays via min.(a,b).\n\nSee also: minimum!, extrema, findmin, argmin.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> minimum(A, dims=1)\n1×2 Matrix{Int64}:\n 1  2\n\njulia> minimum(A, dims=2)\n2×1 Matrix{Int64}:\n 1\n 3\n\n\n\n\n\nminimum(f, A::AbstractArray; dims)\n\nCompute the minimum value by calling the function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> minimum(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 1  4\n\njulia> minimum(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n 1\n 9\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.minimum!","location":"base/collections.html#Base.minimum!","category":"function","text":"minimum!(r, A)\n\nCompute the minimum value of A over the singleton dimensions of r, and write results to r.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> minimum!([1; 1], A)\n2-element Vector{Int64}:\n 1\n 3\n\njulia> minimum!([1 1], A)\n1×2 Matrix{Int64}:\n 1  2\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.extrema","location":"base/collections.html#Base.extrema","category":"function","text":"extrema(itr; [init]) -> (mn, mx)\n\nCompute both the minimum mn and maximum mx element in a single pass, and return them as a 2-tuple.\n\nThe value returned for empty itr can be specified by init. It must be a 2-tuple whose first and second elements are neutral elements for min and max respectively (i.e. which are greater/less than or equal to any other element). As a consequence, when itr is empty the returned (mn, mx) tuple will satisfy mn ≥ mx. When init is specified it may be used even for non-empty itr.\n\ncompat: Julia 1.8\nKeyword argument init requires Julia 1.8 or later.\n\nExamples\n\njulia> extrema(2:10)\n(2, 10)\n\njulia> extrema([9,pi,4.5])\n(3.141592653589793, 9.0)\n\njulia> extrema([]; init = (Inf, -Inf))\n(Inf, -Inf)\n\n\n\n\n\nextrema(f, itr; [init]) -> (mn, mx)\n\nCompute both the minimum mn and maximum mx of f applied to each element in itr and return them as a 2-tuple. Only one pass is made over itr.\n\nThe value returned for empty itr can be specified by init. It must be a 2-tuple whose first and second elements are neutral elements for min and max respectively (i.e. which are greater/less than or equal to any other element). It is used for non-empty collections. Note: it implies that, for empty itr, the returned value (mn, mx) satisfies mn ≥ mx even though for non-empty itr it  satisfies mn ≤ mx.  This is a \"paradoxical\" but yet expected result.\n\ncompat: Julia 1.2\nThis method requires Julia 1.2 or later.\n\ncompat: Julia 1.8\nKeyword argument init requires Julia 1.8 or later.\n\nExamples\n\njulia> extrema(sin, 0:π)\n(0.0, 0.9092974268256817)\n\njulia> extrema(sin, Real[]; init = (1.0, -1.0))  # good, since -1 ≤ sin(::Real) ≤ 1\n(1.0, -1.0)\n\n\n\n\n\nextrema(A::AbstractArray; dims) -> Array{Tuple}\n\nCompute the minimum and maximum elements of an array over the given dimensions.\n\nSee also: minimum, maximum, extrema!.\n\nExamples\n\njulia> A = reshape(Vector(1:2:16), (2,2,2))\n2×2×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  5\n 3  7\n\n[:, :, 2] =\n  9  13\n 11  15\n\njulia> extrema(A, dims = (1,2))\n1×1×2 Array{Tuple{Int64, Int64}, 3}:\n[:, :, 1] =\n (1, 7)\n\n[:, :, 2] =\n (9, 15)\n\n\n\n\n\nextrema(f, A::AbstractArray; dims) -> Array{Tuple}\n\nCompute the minimum and maximum of f applied to each element in the given dimensions of A.\n\ncompat: Julia 1.2\nThis method requires Julia 1.2 or later.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.extrema!","location":"base/collections.html#Base.extrema!","category":"function","text":"extrema!(r, A)\n\nCompute the minimum and maximum value of A over the singleton dimensions of r, and write results to r.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\ncompat: Julia 1.8\nThis method requires Julia 1.8 or later.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> extrema!([(1, 1); (1, 1)], A)\n2-element Vector{Tuple{Int64, Int64}}:\n (1, 2)\n (3, 4)\n\njulia> extrema!([(1, 1);; (1, 1)], A)\n1×2 Matrix{Tuple{Int64, Int64}}:\n (1, 3)  (2, 4)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.argmax","location":"base/collections.html#Base.argmax","category":"function","text":"argmax(r::AbstractRange)\n\nRanges can have multiple maximal elements. In that case argmax will return a maximal index, but not necessarily the first one.\n\n\n\n\n\nargmax(f, domain)\n\nReturn a value x from domain for which f(x) is maximised. If there are multiple maximal values for f(x) then the first one will be found.\n\ndomain must be a non-empty iterable.\n\nValues are compared with isless.\n\ncompat: Julia 1.7\nThis method requires Julia 1.7 or later.\n\nSee also argmin, findmax.\n\nExamples\n\njulia> argmax(abs, -10:5)\n-10\n\njulia> argmax(cos, 0:π/2:2π)\n0.0\n\n\n\n\n\nargmax(itr)\n\nReturn the index or key of the maximal element in a collection. If there are multiple maximal elements, then the first one will be returned.\n\nThe collection must not be empty.\n\nIndices are of the same type as those returned by keys(itr) and pairs(itr).\n\nValues are compared with isless.\n\nSee also: argmin, findmax.\n\nExamples\n\njulia> argmax([8, 0.1, -9, pi])\n1\n\njulia> argmax([1, 7, 7, 6])\n2\n\njulia> argmax([1, 7, 7, NaN])\n4\n\n\n\n\n\nargmax(A; dims) -> indices\n\nFor an array input, return the indices of the maximum elements over the given dimensions. NaN is treated as greater than all other values except missing.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> argmax(A, dims=1)\n1×2 Matrix{CartesianIndex{2}}:\n CartesianIndex(2, 1)  CartesianIndex(2, 2)\n\njulia> argmax(A, dims=2)\n2×1 Matrix{CartesianIndex{2}}:\n CartesianIndex(1, 2)\n CartesianIndex(2, 2)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.argmin","location":"base/collections.html#Base.argmin","category":"function","text":"argmin(r::AbstractRange)\n\nRanges can have multiple minimal elements. In that case argmin will return a minimal index, but not necessarily the first one.\n\n\n\n\n\nargmin(f, domain)\n\nReturn a value x from domain for which f(x) is minimised. If there are multiple minimal values for f(x) then the first one will be found.\n\ndomain must be a non-empty iterable.\n\nNaN is treated as less than all other values except missing.\n\ncompat: Julia 1.7\nThis method requires Julia 1.7 or later.\n\nSee also argmax, findmin.\n\nExamples\n\njulia> argmin(sign, -10:5)\n-10\n\njulia> argmin(x -> -x^3 + x^2 - 10, -5:5)\n5\n\njulia> argmin(acos, 0:0.1:1)\n1.0\n\n\n\n\n\nargmin(itr)\n\nReturn the index or key of the minimal element in a collection. If there are multiple minimal elements, then the first one will be returned.\n\nThe collection must not be empty.\n\nIndices are of the same type as those returned by keys(itr) and pairs(itr).\n\nNaN is treated as less than all other values except missing.\n\nSee also: argmax, findmin.\n\nExamples\n\njulia> argmin([8, 0.1, -9, pi])\n3\n\njulia> argmin([7, 1, 1, 6])\n2\n\njulia> argmin([7, 1, 1, NaN])\n4\n\n\n\n\n\nargmin(A; dims) -> indices\n\nFor an array input, return the indices of the minimum elements over the given dimensions. NaN is treated as less than all other values except missing.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> argmin(A, dims=1)\n1×2 Matrix{CartesianIndex{2}}:\n CartesianIndex(1, 1)  CartesianIndex(1, 2)\n\njulia> argmin(A, dims=2)\n2×1 Matrix{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 1)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmax","location":"base/collections.html#Base.findmax","category":"function","text":"findmax(f, domain) -> (f(x), index)\n\nReturn a pair of a value in the codomain (outputs of f) and the index or key of the corresponding value in the domain (inputs to f) such that f(x) is maximised. If there are multiple maximal points, then the first one will be returned.\n\ndomain must be a non-empty iterable supporting keys. Indices are of the same type as those returned by keys(domain).\n\nValues are compared with isless.\n\ncompat: Julia 1.7\nThis method requires Julia 1.7 or later.\n\nExamples\n\njulia> findmax(identity, 5:9)\n(9, 5)\n\njulia> findmax(-, 1:10)\n(-1, 1)\n\njulia> findmax(first, [(1, :a), (3, :b), (3, :c)])\n(3, 2)\n\njulia> findmax(cos, 0:π/2:2π)\n(1.0, 1)\n\n\n\n\n\nfindmax(itr) -> (x, index)\n\nReturn the maximal element of the collection itr and its index or key. If there are multiple maximal elements, then the first one will be returned. Values are compared with isless.\n\nIndices are of the same type as those returned by keys(itr) and pairs(itr).\n\nSee also: findmin, argmax, maximum.\n\nExamples\n\njulia> findmax([8, 0.1, -9, pi])\n(8.0, 1)\n\njulia> findmax([1, 7, 7, 6])\n(7, 2)\n\njulia> findmax([1, 7, 7, NaN])\n(NaN, 4)\n\n\n\n\n\nfindmax(A; dims) -> (maxval, index)\n\nFor an array input, returns the value and index of the maximum over the given dimensions. NaN is treated as greater than all other values except missing.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> findmax(A, dims=1)\n([3.0 4.0], CartesianIndex{2}[CartesianIndex(2, 1) CartesianIndex(2, 2)])\n\njulia> findmax(A, dims=2)\n([2.0; 4.0;;], CartesianIndex{2}[CartesianIndex(1, 2); CartesianIndex(2, 2);;])\n\n\n\n\n\nfindmax(f, A; dims) -> (f(x), index)\n\nFor an array input, returns the value in the codomain and index of the corresponding value which maximize f over the given dimensions.\n\nExamples\n\njulia> A = [-1.0 1; -0.5 2]\n2×2 Matrix{Float64}:\n -1.0  1.0\n -0.5  2.0\n\njulia> findmax(abs2, A, dims=1)\n([1.0 4.0], CartesianIndex{2}[CartesianIndex(1, 1) CartesianIndex(2, 2)])\n\njulia> findmax(abs2, A, dims=2)\n([1.0; 4.0;;], CartesianIndex{2}[CartesianIndex(1, 1); CartesianIndex(2, 2);;])\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmin","location":"base/collections.html#Base.findmin","category":"function","text":"findmin(f, domain) -> (f(x), index)\n\nReturn a pair of a value in the codomain (outputs of f) and the index or key of the corresponding value in the domain (inputs to f) such that f(x) is minimised. If there are multiple minimal points, then the first one will be returned.\n\ndomain must be a non-empty iterable.\n\nIndices are of the same type as those returned by keys(domain) and pairs(domain).\n\nNaN is treated as less than all other values except missing.\n\ncompat: Julia 1.7\nThis method requires Julia 1.7 or later.\n\nExamples\n\njulia> findmin(identity, 5:9)\n(5, 1)\n\njulia> findmin(-, 1:10)\n(-10, 10)\n\njulia> findmin(first, [(2, :a), (2, :b), (3, :c)])\n(2, 1)\n\njulia> findmin(cos, 0:π/2:2π)\n(-1.0, 3)\n\n\n\n\n\nfindmin(itr) -> (x, index)\n\nReturn the minimal element of the collection itr and its index or key. If there are multiple minimal elements, then the first one will be returned. NaN is treated as less than all other values except missing.\n\nIndices are of the same type as those returned by keys(itr) and pairs(itr).\n\nSee also: findmax, argmin, minimum.\n\nExamples\n\njulia> findmin([8, 0.1, -9, pi])\n(-9.0, 3)\n\njulia> findmin([1, 7, 7, 6])\n(1, 1)\n\njulia> findmin([1, 7, 7, NaN])\n(NaN, 4)\n\n\n\n\n\nfindmin(A; dims) -> (minval, index)\n\nFor an array input, returns the value and index of the minimum over the given dimensions. NaN is treated as less than all other values except missing.\n\nExamples\n\njulia> A = [1.0 2; 3 4]\n2×2 Matrix{Float64}:\n 1.0  2.0\n 3.0  4.0\n\njulia> findmin(A, dims=1)\n([1.0 2.0], CartesianIndex{2}[CartesianIndex(1, 1) CartesianIndex(1, 2)])\n\njulia> findmin(A, dims=2)\n([1.0; 3.0;;], CartesianIndex{2}[CartesianIndex(1, 1); CartesianIndex(2, 1);;])\n\n\n\n\n\nfindmin(f, A; dims) -> (f(x), index)\n\nFor an array input, returns the value in the codomain and index of the corresponding value which minimize f over the given dimensions.\n\nExamples\n\njulia> A = [-1.0 1; -0.5 2]\n2×2 Matrix{Float64}:\n -1.0  1.0\n -0.5  2.0\n\njulia> findmin(abs2, A, dims=1)\n([0.25 1.0], CartesianIndex{2}[CartesianIndex(2, 1) CartesianIndex(1, 2)])\n\njulia> findmin(abs2, A, dims=2)\n([1.0; 0.25;;], CartesianIndex{2}[CartesianIndex(1, 1); CartesianIndex(2, 1);;])\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmax!","location":"base/collections.html#Base.findmax!","category":"function","text":"findmax!(rval, rind, A) -> (maxval, index)\n\nFind the maximum of A and the corresponding linear index along singleton dimensions of rval and rind, and store the results in rval and rind. NaN is treated as greater than all other values except missing.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.findmin!","location":"base/collections.html#Base.findmin!","category":"function","text":"findmin!(rval, rind, A) -> (minval, index)\n\nFind the minimum of A and the corresponding linear index along singleton dimensions of rval and rind, and store the results in rval and rind. NaN is treated as less than all other values except missing.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.sum","location":"base/collections.html#Base.sum","category":"function","text":"sum(f, itr; [init])\n\nSum the results of calling function f on each element of itr.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the additive identity (i.e. zero) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> sum(abs2, [2; 3; 4])\n29\n\nNote the important difference between sum(A) and reduce(+, A) for arrays with small integer eltype:\n\njulia> sum(Int8[100, 28])\n128\n\njulia> reduce(+, Int8[100, 28])\n-128\n\nIn the former case, the integers are widened to system word size and therefore the result is 128. In the latter case, no such widening happens and integer overflow results in -128.\n\n\n\n\n\nsum(itr; [init])\n\nReturn the sum of all elements in a collection.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the additive identity (i.e. zero) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nSee also: reduce, mapreduce, count, union.\n\nExamples\n\njulia> sum(1:20)\n210\n\njulia> sum(1:20; init = 0.0)\n210.0\n\n\n\n\n\nsum(A::AbstractArray; dims)\n\nSum elements of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> sum(A, dims=1)\n1×2 Matrix{Int64}:\n 4  6\n\njulia> sum(A, dims=2)\n2×1 Matrix{Int64}:\n 3\n 7\n\n\n\n\n\nsum(f, A::AbstractArray; dims)\n\nSum the results of calling function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> sum(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 10  20\n\njulia> sum(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n  5\n 25\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.sum!","location":"base/collections.html#Base.sum!","category":"function","text":"sum!(r, A)\n\nSum elements of A over the singleton dimensions of r, and write results to r.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> sum!([1; 1], A)\n2-element Vector{Int64}:\n 3\n 7\n\njulia> sum!([1 1], A)\n1×2 Matrix{Int64}:\n 4  6\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.prod","location":"base/collections.html#Base.prod","category":"function","text":"prod(f, itr; [init])\n\nReturn the product of f applied to each element of itr.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the multiplicative identity (i.e. one) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nExamples\n\njulia> prod(abs2, [2; 3; 4])\n576\n\n\n\n\n\nprod(itr; [init])\n\nReturn the product of all elements of a collection.\n\nThe return type is Int for signed integers of less than system word size, and UInt for unsigned integers of less than system word size.  For all other arguments, a common return type is found to which all arguments are promoted.\n\nThe value returned for empty itr can be specified by init. It must be the multiplicative identity (i.e. one) as it is unspecified whether init is used for non-empty collections.\n\ncompat: Julia 1.6\nKeyword argument init requires Julia 1.6 or later.\n\nSee also: reduce, cumprod, any.\n\nExamples\n\njulia> prod(1:5)\n120\n\njulia> prod(1:5; init = 1.0)\n120.0\n\n\n\n\n\nprod(A::AbstractArray; dims)\n\nMultiply elements of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prod(A, dims=1)\n1×2 Matrix{Int64}:\n 3  8\n\njulia> prod(A, dims=2)\n2×1 Matrix{Int64}:\n  2\n 12\n\n\n\n\n\nprod(f, A::AbstractArray; dims)\n\nMultiply the results of calling the function f on each element of an array over the given dimensions.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prod(abs2, A, dims=1)\n1×2 Matrix{Int64}:\n 9  64\n\njulia> prod(abs2, A, dims=2)\n2×1 Matrix{Int64}:\n   4\n 144\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.prod!","location":"base/collections.html#Base.prod!","category":"function","text":"prod!(r, A)\n\nMultiply elements of A over the singleton dimensions of r, and write results to r.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prod!([1; 1], A)\n2-element Vector{Int64}:\n  2\n 12\n\njulia> prod!([1 1], A)\n1×2 Matrix{Int64}:\n 3  8\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.any","location":"base/collections.html#Base.any-Tuple{Any}","category":"method","text":"any(itr) -> Bool\n\nTest whether any elements of a boolean collection are true, returning true as soon as the first true value in itr is encountered (short-circuiting). To short-circuit on false, use all.\n\nIf the input contains missing values, return missing if all non-missing values are false (or equivalently, if the input contains no true value), following three-valued logic.\n\nSee also: all, count, sum, |, , ||.\n\nExamples\n\njulia> a = [true,false,false,true]\n4-element Vector{Bool}:\n 1\n 0\n 0\n 1\n\njulia> any(a)\ntrue\n\njulia> any((println(i); v) for (i, v) in enumerate(a))\n1\ntrue\n\njulia> any([missing, true])\ntrue\n\njulia> any([false, missing])\nmissing\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.any","location":"base/collections.html#Base.any-Tuple{AbstractArray, Any}","category":"method","text":"any(p, itr) -> Bool\n\nDetermine whether predicate p returns true for any elements of itr, returning true as soon as the first item in itr for which p returns true is encountered (short-circuiting). To short-circuit on false, use all.\n\nIf the input contains missing values, return missing if all non-missing values are false (or equivalently, if the input contains no true value), following three-valued logic.\n\nExamples\n\njulia> any(i->(4<=i<=6), [3,5,7])\ntrue\n\njulia> any(i -> (println(i); i > 3), 1:10)\n1\n2\n3\n4\ntrue\n\njulia> any(i -> i > 0, [1, missing])\ntrue\n\njulia> any(i -> i > 0, [-1, missing])\nmissing\n\njulia> any(i -> i > 0, [-1, 0])\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.any!","location":"base/collections.html#Base.any!","category":"function","text":"any!(r, A)\n\nTest whether any values in A along the singleton dimensions of r are true, and write results to r.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = [true false; true false]\n2×2 Matrix{Bool}:\n 1  0\n 1  0\n\njulia> any!([1; 1], A)\n2-element Vector{Int64}:\n 1\n 1\n\njulia> any!([1 1], A)\n1×2 Matrix{Int64}:\n 1  0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.all","location":"base/collections.html#Base.all-Tuple{Any}","category":"method","text":"all(itr) -> Bool\n\nTest whether all elements of a boolean collection are true, returning false as soon as the first false value in itr is encountered (short-circuiting). To short-circuit on true, use any.\n\nIf the input contains missing values, return missing if all non-missing values are true (or equivalently, if the input contains no false value), following three-valued logic.\n\nSee also: all!, any, count, &, , &&, allunique.\n\nExamples\n\njulia> a = [true,false,false,true]\n4-element Vector{Bool}:\n 1\n 0\n 0\n 1\n\njulia> all(a)\nfalse\n\njulia> all((println(i); v) for (i, v) in enumerate(a))\n1\n2\nfalse\n\njulia> all([missing, false])\nfalse\n\njulia> all([true, missing])\nmissing\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.all","location":"base/collections.html#Base.all-Tuple{AbstractArray, Any}","category":"method","text":"all(p, itr) -> Bool\n\nDetermine whether predicate p returns true for all elements of itr, returning false as soon as the first item in itr for which p returns false is encountered (short-circuiting). To short-circuit on true, use any.\n\nIf the input contains missing values, return missing if all non-missing values are true (or equivalently, if the input contains no false value), following three-valued logic.\n\nExamples\n\njulia> all(i->(4<=i<=6), [4,5,6])\ntrue\n\njulia> all(i -> (println(i); i < 3), 1:10)\n1\n2\n3\nfalse\n\njulia> all(i -> i > 0, [1, missing])\nmissing\n\njulia> all(i -> i > 0, [-1, missing])\nfalse\n\njulia> all(i -> i > 0, [1, 2])\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.all!","location":"base/collections.html#Base.all!","category":"function","text":"all!(r, A)\n\nTest whether all values in A along the singleton dimensions of r are true, and write results to r.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = [true false; true false]\n2×2 Matrix{Bool}:\n 1  0\n 1  0\n\njulia> all!([1; 1], A)\n2-element Vector{Int64}:\n 0\n 0\n\njulia> all!([1 1], A)\n1×2 Matrix{Int64}:\n 1  0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.count","location":"base/collections.html#Base.count","category":"function","text":"count([f=identity,] itr; init=0) -> Integer\n\nCount the number of elements in itr for which the function f returns true. If f is omitted, count the number of true elements in itr (which should be a collection of boolean values). init optionally specifies the value to start counting from and therefore also determines the output type.\n\ncompat: Julia 1.6\ninit keyword was added in Julia 1.6.\n\nSee also: any, sum.\n\nExamples\n\njulia> count(i->(4<=i<=6), [2,3,4,5,6])\n3\n\njulia> count([true, false, true, true])\n3\n\njulia> count(>(3), 1:7, init=0x03)\n0x07\n\n\n\n\n\ncount(\n    pattern::Union{AbstractChar,AbstractString,AbstractPattern},\n    string::AbstractString;\n    overlap::Bool = false,\n)\n\nReturn the number of matches for pattern in string. This is equivalent to calling length(findall(pattern, string)) but more efficient.\n\nIf overlap=true, the matching sequences are allowed to overlap indices in the original string, otherwise they must be from disjoint character ranges.\n\ncompat: Julia 1.3\nThis method requires at least Julia 1.3.\n\ncompat: Julia 1.7\nUsing a character as the pattern requires at least Julia 1.7.\n\nExamples\n\njulia> count('a', \"JuliaLang\")\n2\n\njulia> count(r\"a(.)a\", \"cabacabac\", overlap=true)\n3\n\njulia> count(r\"a(.)a\", \"cabacabac\")\n2\n\n\n\n\n\ncount([f=identity,] A::AbstractArray; dims=:)\n\nCount the number of elements in A for which f returns true over the given dimensions.\n\ncompat: Julia 1.5\ndims keyword was added in Julia 1.5.\n\ncompat: Julia 1.6\ninit keyword was added in Julia 1.6.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> count(<=(2), A, dims=1)\n1×2 Matrix{Int64}:\n 1  1\n\njulia> count(<=(2), A, dims=2)\n2×1 Matrix{Int64}:\n 2\n 0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.foreach","location":"base/collections.html#Base.foreach","category":"function","text":"foreach(f, c...) -> Nothing\n\nCall function f on each element of iterable c. For multiple iterable arguments, f is called elementwise, and iteration stops when any iterator is finished.\n\nforeach should be used instead of map when the results of f are not needed, for example in foreach(println, array).\n\nExamples\n\njulia> tri = 1:3:7; res = Int[];\n\njulia> foreach(x -> push!(res, x^2), tri)\n\njulia> res\n3-element Vector{Int32}:\n  1\n 16\n 49\n\njulia> foreach((x, y) -> println(x, \" with \", y), tri, 'a':'z')\n1 with a\n4 with b\n7 with c\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.map","location":"base/collections.html#Base.map","category":"function","text":"map(f, c...) -> collection\n\nTransform collection c by applying f to each element. For multiple collection arguments, apply f elementwise, and stop when any of them is exhausted.\n\nSee also map!, foreach, mapreduce, mapslices, zip, Iterators.map.\n\nExamples\n\njulia> map(x -> x * 2, [1, 2, 3])\n3-element Vector{Int64}:\n 2\n 4\n 6\n\njulia> map(+, [1, 2, 3], [10, 20, 30, 400, 5000])\n3-element Vector{Int64}:\n 11\n 22\n 33\n\n\n\n\n\nmap(f, A::AbstractArray...) -> N-array\n\nWhen acting on multi-dimensional arrays of the same ndims, they must all have the same axes, and the answer will too.\n\nSee also broadcast, which allows mismatched sizes.\n\nExamples\n\njulia> map(//, [1 2; 3 4], [4 3; 2 1])\n2×2 Matrix{Rational{Int32}}:\n 1//4  2//3\n 3//2  4//1\n\njulia> map(+, [1 2; 3 4], zeros(2,1))\nERROR: DimensionMismatch\n\njulia> map(+, [1 2; 3 4], [1,10,100,1000], zeros(3,1))  # iterates until 3rd is exhausted\n3-element Vector{Float64}:\n   2.0\n  13.0\n 102.0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.map!","location":"base/collections.html#Base.map!","category":"function","text":"map!(function, destination, collection...)\n\nLike map, but stores the result in destination rather than a new collection. destination must be at least as large as the smallest collection.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nSee also: map, foreach, zip, copyto!.\n\nExamples\n\njulia> a = zeros(3);\n\njulia> map!(x -> x * 2, a, [1, 2, 3]);\n\njulia> a\n3-element Vector{Float64}:\n 2.0\n 4.0\n 6.0\n\njulia> map!(+, zeros(Int, 5), 100:999, 1:3)\n5-element Vector{Int32}:\n 101\n 103\n 105\n   0\n   0\n\n\n\n\n\nmap!(f, values(dict::AbstractDict))\n\nModifies dict by transforming each value from val to f(val). Note that the type of dict cannot be changed: if f(val) is not an instance of the value type of dict then it will be converted to the value type if possible and otherwise raise an error.\n\ncompat: Julia 1.2\nmap!(f, values(dict::AbstractDict)) requires Julia 1.2 or later.\n\nExamples\n\njulia> d = Dict(:a => 1, :b => 2)\nDict{Symbol, Int64} with 2 entries:\n  :a => 1\n  :b => 2\n\njulia> map!(v -> v-1, values(d))\nValueIterator for a Dict{Symbol, Int64} with 2 entries. Values:\n  0\n  1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mapreduce","location":"base/collections.html#Base.mapreduce-Tuple{Any, Any, Any}","category":"method","text":"mapreduce(f, op, itrs...; [init])\n\nApply function f to each element(s) in itrs, and then reduce the result using the binary function op. If provided, init must be a neutral element for op that will be returned for empty collections. It is unspecified whether init is used for non-empty collections. In general, it will be necessary to provide init to work with empty collections.\n\nmapreduce is functionally equivalent to calling reduce(op, map(f, itr); init=init), but will in general execute faster since no intermediate collection needs to be created. See documentation for reduce and map.\n\ncompat: Julia 1.2\nmapreduce with multiple iterators requires Julia 1.2 or later.\n\nExamples\n\njulia> mapreduce(x->x^2, +, [1:3;]) # == 1 + 4 + 9\n14\n\nThe associativity of the reduction is implementation-dependent. Additionally, some implementations may reuse the return value of f for elements that appear multiple times in itr. Use mapfoldl or mapfoldr instead for guaranteed left or right associativity and invocation of f for every value.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mapfoldl","location":"base/collections.html#Base.mapfoldl-Tuple{Any, Any, Any}","category":"method","text":"mapfoldl(f, op, itr; [init])\n\nLike mapreduce, but with guaranteed left associativity, as in foldl. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mapfoldr","location":"base/collections.html#Base.mapfoldr-Tuple{Any, Any, Any}","category":"method","text":"mapfoldr(f, op, itr; [init])\n\nLike mapreduce, but with guaranteed right associativity, as in foldr. If provided, the keyword argument init will be used exactly once. In general, it will be necessary to provide init to work with empty collections.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.first","location":"base/collections.html#Base.first","category":"function","text":"first(coll)\n\nGet the first element of an iterable collection. Return the start point of an AbstractRange even if it is empty.\n\nSee also: only, firstindex, last.\n\nExamples\n\njulia> first(2:2:10)\n2\n\njulia> first([1; 2; 3; 4])\n1\n\n\n\n\n\nfirst(itr, n::Integer)\n\nGet the first n elements of the iterable collection itr, or fewer elements if itr is not long enough.\n\nSee also: startswith, Iterators.take.\n\ncompat: Julia 1.6\nThis method requires at least Julia 1.6.\n\nExamples\n\njulia> first([\"foo\", \"bar\", \"qux\"], 2)\n2-element Vector{String}:\n \"foo\"\n \"bar\"\n\njulia> first(1:6, 10)\n1:6\n\njulia> first(Bool[], 1)\nBool[]\n\n\n\n\n\nfirst(s::AbstractString, n::Integer)\n\nGet a string consisting of the first n characters of s.\n\nExamples\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 0)\n\"\"\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 1)\n\"∀\"\n\njulia> first(\"∀ϵ≠0: ϵ²>0\", 3)\n\"∀ϵ≠\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.last","location":"base/collections.html#Base.last","category":"function","text":"last(coll)\n\nGet the last element of an ordered collection, if it can be computed in O(1) time. This is accomplished by calling lastindex to get the last index. Return the end point of an AbstractRange even if it is empty.\n\nSee also first, endswith.\n\nExamples\n\njulia> last(1:2:10)\n9\n\njulia> last([1; 2; 3; 4])\n4\n\n\n\n\n\nlast(itr, n::Integer)\n\nGet the last n elements of the iterable collection itr, or fewer elements if itr is not long enough.\n\ncompat: Julia 1.6\nThis method requires at least Julia 1.6.\n\nExamples\n\njulia> last([\"foo\", \"bar\", \"qux\"], 2)\n2-element Vector{String}:\n \"bar\"\n \"qux\"\n\njulia> last(1:6, 10)\n1:6\n\njulia> last(Float64[], 1)\nFloat64[]\n\n\n\n\n\nlast(s::AbstractString, n::Integer)\n\nGet a string consisting of the last n characters of s.\n\nExamples\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 0)\n\"\"\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 1)\n\"0\"\n\njulia> last(\"∀ϵ≠0: ϵ²>0\", 3)\n\"²>0\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.front","location":"base/collections.html#Base.front","category":"function","text":"front(x::Tuple)::Tuple\n\nReturn a Tuple consisting of all but the last component of x.\n\nSee also: first, tail.\n\nExamples\n\njulia> Base.front((1,2,3))\n(1, 2)\n\njulia> Base.front(())\nERROR: ArgumentError: Cannot call front on an empty tuple.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.tail","location":"base/collections.html#Base.tail","category":"function","text":"tail(x::Tuple)::Tuple\n\nReturn a Tuple consisting of all but the first component of x.\n\nSee also: front, rest, first, Iterators.peel.\n\nExamples\n\njulia> Base.tail((1,2,3))\n(2, 3)\n\njulia> Base.tail(())\nERROR: ArgumentError: Cannot call tail on an empty tuple.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.step","location":"base/collections.html#Base.step","category":"function","text":"step(r)\n\nGet the step size of an AbstractRange object.\n\nExamples\n\njulia> step(1:10)\n1\n\njulia> step(1:2:10)\n2\n\njulia> step(2.5:0.3:10.9)\n0.3\n\njulia> step(range(2.5, stop=10.9, length=85))\n0.1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.collect","location":"base/collections.html#Base.collect-Tuple{Any}","category":"method","text":"collect(collection)\n\nReturn an Array of all items in a collection or iterator. For dictionaries, returns a Vector of key=>value Pairs. If the argument is array-like or is an iterator with the HasShape trait, the result will have the same shape and number of dimensions as the argument.\n\nUsed by comprehensions to turn a generator expression into an Array. Thus, on generators, the square-brackets notation may be used instead of calling collect, see second example.\n\nExamples\n\nCollect items from a UnitRange{Int64} collection:\n\njulia> collect(1:3)\n3-element Vector{Int64}:\n 1\n 2\n 3\n\nCollect items from a generator (same output as [x^2 for x in 1:3]):\n\njulia> collect(x^2 for x in 1:3)\n3-element Vector{Int64}:\n 1\n 4\n 9\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.collect","location":"base/collections.html#Base.collect-Tuple{Type, Any}","category":"method","text":"collect(element_type, collection)\n\nReturn an Array with the given element type of all items in a collection or iterable. The result has the same shape and number of dimensions as collection.\n\nExamples\n\njulia> collect(Float64, 1:2:5)\n3-element Vector{Float64}:\n 1.0\n 3.0\n 5.0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.filter","location":"base/collections.html#Base.filter","category":"function","text":"filter(f, a)\n\nReturn a copy of collection a, removing elements for which f is false. The function f is passed one argument.\n\ncompat: Julia 1.4\nSupport for a as a tuple requires at least Julia 1.4.\n\nSee also: filter!, Iterators.filter.\n\nExamples\n\njulia> a = 1:10\n1:10\n\njulia> filter(isodd, a)\n5-element Vector{Int64}:\n 1\n 3\n 5\n 7\n 9\n\n\n\n\n\nfilter(f)\n\nCreate a function that filters its arguments with function f using filter, i.e. a function equivalent to x -> filter(f, x).\n\nThe returned function is of type Base.Fix1{typeof(filter)}, which can be used to implement specialized methods.\n\nExamples\n\njulia> (1, 2, Inf, 4, NaN, 6) |> filter(isfinite)\n(1, 2, 4, 6)\n\njulia> map(filter(iseven), [1:3, 2:4, 3:5])\n3-element Vector{Vector{Int64}}:\n [2]\n [2, 4]\n [4]\n\ncompat: Julia 1.9\nThis method requires at least Julia 1.9.\n\n\n\n\n\nfilter(f, d::AbstractDict)\n\nReturn a copy of d, removing elements for which f is false. The function f is passed key=>value pairs.\n\nExamples\n\njulia> d = Dict(1=>\"a\", 2=>\"b\")\nDict{Int64, String} with 2 entries:\n  2 => \"b\"\n  1 => \"a\"\n\njulia> filter(p->isodd(p.first), d)\nDict{Int64, String} with 1 entry:\n  1 => \"a\"\n\n\n\n\n\nfilter(f, itr::SkipMissing{<:AbstractArray})\n\nReturn a vector similar to the array wrapped by the given SkipMissing iterator but with all missing elements and those for which f returns false removed.\n\ncompat: Julia 1.2\nThis method requires Julia 1.2 or later.\n\nExamples\n\njulia> x = [1 2; missing 4]\n2×2 Matrix{Union{Missing, Int64}}:\n 1         2\n  missing  4\n\njulia> filter(isodd, skipmissing(x))\n1-element Vector{Int64}:\n 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.filter!","location":"base/collections.html#Base.filter!","category":"function","text":"filter!(f, a)\n\nUpdate collection a, removing elements for which f is false. The function f is passed one argument.\n\nExamples\n\njulia> filter!(isodd, Vector(1:10))\n5-element Vector{Int64}:\n 1\n 3\n 5\n 7\n 9\n\n\n\n\n\nfilter!(f, d::AbstractDict)\n\nUpdate d, removing elements for which f is false. The function f is passed key=>value pairs.\n\nExamples\n\njulia> d = Dict(1=>\"a\", 2=>\"b\", 3=>\"c\")\nDict{Int64, String} with 3 entries:\n  2 => \"b\"\n  3 => \"c\"\n  1 => \"a\"\n\njulia> filter!(p->isodd(p.first), d)\nDict{Int64, String} with 2 entries:\n  3 => \"c\"\n  1 => \"a\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.replace","location":"base/collections.html#Base.replace-Tuple{Any, Vararg{Pair}}","category":"method","text":"replace(A, old_new::Pair...; [count::Integer])\n\nReturn a copy of collection A where, for each pair old=>new in old_new, all occurrences of old are replaced by new. Equality is determined using isequal. If count is specified, then replace at most count occurrences in total.\n\nThe element type of the result is chosen using promotion (see promote_type) based on the element type of A and on the types of the new values in pairs. If count is omitted and the element type of A is a Union, the element type of the result will not include singleton types which are replaced with values of a different type: for example, Union{T,Missing} will become T if missing is replaced.\n\nSee also replace!, splice!, delete!, insert!.\n\ncompat: Julia 1.7\nVersion 1.7 is required to replace elements of a Tuple.\n\nExamples\n\njulia> replace([1, 2, 1, 3], 1=>0, 2=>4, count=2)\n4-element Vector{Int64}:\n 0\n 4\n 1\n 3\n\njulia> replace([1, missing], missing=>0)\n2-element Vector{Int64}:\n 1\n 0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.replace","location":"base/collections.html#Base.replace-Tuple{Union{Function, Type}, Any}","category":"method","text":"replace(new::Union{Function, Type}, A; [count::Integer])\n\nReturn a copy of A where each value x in A is replaced by new(x). If count is specified, then replace at most count values in total (replacements being defined as new(x) !== x).\n\ncompat: Julia 1.7\nVersion 1.7 is required to replace elements of a Tuple.\n\nExamples\n\njulia> replace(x -> isodd(x) ? 2x : x, [1, 2, 3, 4])\n4-element Vector{Int64}:\n 2\n 2\n 6\n 4\n\njulia> replace(Dict(1=>2, 3=>4)) do kv\n           first(kv) < 3 ? first(kv)=>3 : kv\n       end\nDict{Int64, Int64} with 2 entries:\n  3 => 4\n  1 => 3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.replace!","location":"base/collections.html#Base.replace!","category":"function","text":"replace!(A, old_new::Pair...; [count::Integer])\n\nFor each pair old=>new in old_new, replace all occurrences of old in collection A by new. Equality is determined using isequal. If count is specified, then replace at most count occurrences in total. See also replace.\n\nExamples\n\njulia> replace!([1, 2, 1, 3], 1=>0, 2=>4, count=2)\n4-element Vector{Int64}:\n 0\n 4\n 1\n 3\n\njulia> replace!(Set([1, 2, 3]), 1=>0)\nSet{Int64} with 3 elements:\n  0\n  2\n  3\n\n\n\n\n\nreplace!(new::Union{Function, Type}, A; [count::Integer])\n\nReplace each element x in collection A by new(x). If count is specified, then replace at most count values in total (replacements being defined as new(x) !== x).\n\nExamples\n\njulia> replace!(x -> isodd(x) ? 2x : x, [1, 2, 3, 4])\n4-element Vector{Int64}:\n 2\n 2\n 6\n 4\n\njulia> replace!(Dict(1=>2, 3=>4)) do kv\n           first(kv) < 3 ? first(kv)=>3 : kv\n       end\nDict{Int64, Int64} with 2 entries:\n  3 => 4\n  1 => 3\n\njulia> replace!(x->2x, Set([3, 6]))\nSet{Int64} with 2 elements:\n  6\n  12\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.rest","location":"base/collections.html#Base.rest","category":"function","text":"Base.rest(collection[, itr_state])\n\nGeneric function for taking the tail of collection, starting from a specific iteration state itr_state. Return a Tuple, if collection itself is a Tuple, a subtype of AbstractVector, if collection is an AbstractArray, a subtype of AbstractString if collection is an AbstractString, and an arbitrary iterator, falling back to Iterators.rest(collection[, itr_state]), otherwise.\n\nCan be overloaded for user-defined collection types to customize the behavior of slurping in assignments in final position, like a, b... = collection.\n\ncompat: Julia 1.6\nBase.rest requires at least Julia 1.6.\n\nSee also: first, Iterators.rest, Base.split_rest.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> first, state = iterate(a)\n(1, 2)\n\njulia> first, Base.rest(a, state)\n(1, [3, 2, 4])\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.split_rest","location":"base/collections.html#Base.split_rest","category":"function","text":"Base.split_rest(collection, n::Int[, itr_state]) -> (rest_but_n, last_n)\n\nGeneric function for splitting the tail of collection, starting from a specific iteration state itr_state. Returns a tuple of two new collections. The first one contains all elements of the tail but the n last ones, which make up the second collection.\n\nThe type of the first collection generally follows that of Base.rest, except that the fallback case is not lazy, but is collected eagerly into a vector.\n\nCan be overloaded for user-defined collection types to customize the behavior of slurping in assignments in non-final position, like a, b..., c = collection.\n\ncompat: Julia 1.9\nBase.split_rest requires at least Julia 1.9.\n\nSee also: Base.rest.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> first, state = iterate(a)\n(1, 2)\n\njulia> first, Base.split_rest(a, 1, state)\n(1, ([3, 2], [4]))\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Indexable Collections","location":"base/collections.html#Indexable-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.getindex\nBase.setindex!\nBase.firstindex\nBase.lastindex","page":"Collections and Data Structures"},{"title":"Base.getindex","location":"base/collections.html#Base.getindex","category":"function","text":"getindex(collection, key...)\n\nRetrieve the value(s) stored at the given key or index within a collection. The syntax a[i,j,...] is converted by the compiler to getindex(a, i, j, ...).\n\nSee also get, keys, eachindex.\n\nExamples\n\njulia> A = Dict(\"a\" => 1, \"b\" => 2)\nDict{String, Int64} with 2 entries:\n  \"b\" => 2\n  \"a\" => 1\n\njulia> getindex(A, \"a\")\n1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.setindex!","location":"base/collections.html#Base.setindex!","category":"function","text":"setindex!(collection, value, key...)\n\nStore the given value at the given key or index within a collection. The syntax a[i,j,...] = x is converted by the compiler to (setindex!(a, x, i, j, ...); x).\n\nExamples\n\njulia> a = Dict(\"a\"=>1)\nDict{String, Int64} with 1 entry:\n  \"a\" => 1\n\njulia> setindex!(a, 2, \"b\")\nDict{String, Int64} with 2 entries:\n  \"b\" => 2\n  \"a\" => 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.firstindex","location":"base/collections.html#Base.firstindex","category":"function","text":"firstindex(collection) -> Integer\nfirstindex(collection, d) -> Integer\n\nReturn the first index of collection. If d is given, return the first index of collection along dimension d.\n\nThe syntaxes A[begin] and A[1, begin] lower to A[firstindex(A)] and A[1, firstindex(A, 2)], respectively.\n\nSee also: first, axes, lastindex, nextind.\n\nExamples\n\njulia> firstindex([1,2,4])\n1\n\njulia> firstindex(rand(3,4,5), 2)\n1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.lastindex","location":"base/collections.html#Base.lastindex","category":"function","text":"lastindex(collection) -> Integer\nlastindex(collection, d) -> Integer\n\nReturn the last index of collection. If d is given, return the last index of collection along dimension d.\n\nThe syntaxes A[end] and A[end, end] lower to A[lastindex(A)] and A[lastindex(A, 1), lastindex(A, 2)], respectively.\n\nSee also: axes, firstindex, eachindex, prevind.\n\nExamples\n\njulia> lastindex([1,2,4])\n3\n\njulia> lastindex(rand(3,4,5), 2)\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Array\nBitArray\nAbstractArray\nSubArray","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Partially implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"AbstractRange\nUnitRange\nTuple\nAbstractString\nDict\nIdDict\nWeakKeyDict\nNamedTuple","page":"Collections and Data Structures"},{"title":"Dictionaries","location":"base/collections.html#Dictionaries","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Dict is the standard dictionary. Its implementation uses hash as the hashing function for the key, and isequal to determine equality. Define these two functions for custom types to override how they are stored in a hash table.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"IdDict is a special hash table where the keys are always object identities.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"WeakKeyDict is a hash table implementation where the keys are weak references to objects, and thus may be garbage collected even when referenced in a hash table. Like Dict it uses hash for hashing and isequal for equality, unlike Dict it does not convert keys on insertion.","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Dicts can be created by passing pair objects constructed with => to a Dict constructor: Dict(\"A\"=>1, \"B\"=>2). This call will attempt to infer type information from the keys and values (i.e. this example creates a Dict{String, Int64}). To explicitly specify types use the syntax Dict{KeyType,ValueType}(...). For example, Dict{String,Int32}(\"A\"=>1, \"B\"=>2).","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Dictionaries may also be created with generators. For example, Dict(i => f(i) for i = 1:10).","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Given a dictionary D, the syntax D[x] returns the value of key x (if it exists) or throws an error, and D[x] = y stores the key-value pair x => y in D (replacing any existing value for the key x).  Multiple arguments to D[...] are converted to tuples; for example, the syntax D[x,y]  is equivalent to D[(x,y)], i.e. it refers to the value keyed by the tuple (x,y).","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.AbstractDict\nBase.Dict\nBase.IdDict\nBase.WeakKeyDict\nBase.ImmutableDict\nBase.PersistentDict\nBase.haskey\nBase.get\nBase.get!\nBase.getkey\nBase.delete!\nBase.pop!(::Any, ::Any, ::Any)\nBase.keys\nBase.values\nBase.pairs\nBase.merge\nBase.mergewith\nBase.merge!\nBase.mergewith!\nBase.sizehint!\nBase.keytype\nBase.valtype","page":"Collections and Data Structures"},{"title":"Base.AbstractDict","location":"base/collections.html#Base.AbstractDict","category":"type","text":"AbstractDict{K, V}\n\nSupertype for dictionary-like types with keys of type K and values of type V. Dict, IdDict and other types are subtypes of this. An AbstractDict{K, V} should be an iterator of Pair{K, V}.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.Dict","location":"base/collections.html#Base.Dict","category":"type","text":"Dict([itr])\n\nDict{K,V}() constructs a hash table with keys of type K and values of type V. Keys are compared with isequal and hashed with hash.\n\nGiven a single iterable argument, constructs a Dict whose key-value pairs are taken from 2-tuples (key,value) generated by the argument.\n\nExamples\n\njulia> Dict([(\"A\", 1), (\"B\", 2)])\nDict{String, Int64} with 2 entries:\n  \"B\" => 2\n  \"A\" => 1\n\nAlternatively, a sequence of pair arguments may be passed.\n\njulia> Dict(\"A\"=>1, \"B\"=>2)\nDict{String, Int64} with 2 entries:\n  \"B\" => 2\n  \"A\" => 1\n\nwarning: Warning\nKeys are allowed to be mutable, but if you do mutate stored keys, the hash table may become internally inconsistent, in which case the Dict will not work properly. IdDict can be an alternative if you need to mutate keys.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.IdDict","location":"base/collections.html#Base.IdDict","category":"type","text":"IdDict([itr])\n\nIdDict{K,V}() constructs a hash table using objectid as hash and === as equality with keys of type K and values of type V. See Dict for further help and IdSet for the set version of this.\n\nIn the example below, the Dict keys are all isequal and therefore get hashed the same, so they get overwritten. The IdDict hashes by object-id, and thus preserves the 3 different keys.\n\nExamples\n\njulia> Dict(true => \"yes\", 1 => \"no\", 1.0 => \"maybe\")\nDict{Real, String} with 1 entry:\n  1.0 => \"maybe\"\n\njulia> IdDict(true => \"yes\", 1 => \"no\", 1.0 => \"maybe\")\nIdDict{Any, String} with 3 entries:\n  true => \"yes\"\n  1.0  => \"maybe\"\n  1    => \"no\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.WeakKeyDict","location":"base/collections.html#Base.WeakKeyDict","category":"type","text":"WeakKeyDict([itr])\n\nWeakKeyDict() constructs a hash table where the keys are weak references to objects which may be garbage collected even when referenced in a hash table.\n\nSee Dict for further help.  Note, unlike Dict, WeakKeyDict does not convert keys on insertion, as this would imply the key object was unreferenced anywhere before insertion.\n\nSee also WeakRef.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.ImmutableDict","location":"base/collections.html#Base.ImmutableDict","category":"type","text":"ImmutableDict\n\nImmutableDict is a dictionary implemented as an immutable linked list, which is optimal for small dictionaries that are constructed over many individual insertions. Note that it is not possible to remove a value, although it can be partially overridden and hidden by inserting a new value with the same key.\n\nImmutableDict(KV::Pair)\n\nCreate a new entry in the ImmutableDict for a key => value pair\n\nuse (key => value) in dict to see if this particular combination is in the properties set\nuse get(dict, key, default) to retrieve the most recent value for a particular key\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.PersistentDict","location":"base/collections.html#Base.PersistentDict","category":"type","text":"PersistentDict\n\nPersistentDict is a dictionary implemented as an hash array mapped trie, which is optimal for situations where you need persistence, each operation returns a new dictionary separate from the previous one, but the underlying implementation is space-efficient and may share storage across multiple separate dictionaries.\n\nnote: Note\nIt behaves like an IdDict.\n\nPersistentDict(KV::Pair)\n\nExamples\n\njulia> dict = Base.PersistentDict(:a=>1)\nBase.PersistentDict{Symbol, Int64} with 1 entry:\n  :a => 1\n\njulia> dict2 = Base.delete(dict, :a)\nBase.PersistentDict{Symbol, Int64}()\n\njulia> dict3 = Base.PersistentDict(dict, :a=>2)\nBase.PersistentDict{Symbol, Int64} with 1 entry:\n  :a => 2\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.haskey","location":"base/collections.html#Base.haskey","category":"function","text":"haskey(collection, key) -> Bool\n\nDetermine whether a collection has a mapping for a given key.\n\nExamples\n\njulia> D = Dict('a'=>2, 'b'=>3)\nDict{Char, Int64} with 2 entries:\n  'a' => 2\n  'b' => 3\n\njulia> haskey(D, 'a')\ntrue\n\njulia> haskey(D, 'c')\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.get","location":"base/collections.html#Base.get","category":"function","text":"get(collection, key, default)\n\nReturn the value stored for the given key, or the given default value if no mapping for the key is present.\n\ncompat: Julia 1.7\nFor tuples and numbers, this function requires at least Julia 1.7.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2);\n\njulia> get(d, \"a\", 3)\n1\n\njulia> get(d, \"c\", 3)\n3\n\n\n\n\n\nget(f::Union{Function, Type}, collection, key)\n\nReturn the value stored for the given key, or if no mapping for the key is present, return f().  Use get! to also store the default value in the dictionary.\n\nThis is intended to be called using do block syntax\n\nget(dict, key) do\n    # default value calculated here\n    time()\nend\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.get!","location":"base/collections.html#Base.get!","category":"function","text":"get!(collection, key, default)\n\nReturn the value stored for the given key, or if no mapping for the key is present, store key => default, and return default.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2, \"c\"=>3);\n\njulia> get!(d, \"a\", 5)\n1\n\njulia> get!(d, \"d\", 4)\n4\n\njulia> d\nDict{String, Int64} with 4 entries:\n  \"c\" => 3\n  \"b\" => 2\n  \"a\" => 1\n  \"d\" => 4\n\n\n\n\n\nget!(f::Union{Function, Type}, collection, key)\n\nReturn the value stored for the given key, or if no mapping for the key is present, store key => f(), and return f().\n\nThis is intended to be called using do block syntax.\n\nExamples\n\njulia> squares = Dict{Int, Int}();\n\njulia> function get_square!(d, i)\n           get!(d, i) do\n               i^2\n           end\n       end\nget_square! (generic function with 1 method)\n\njulia> get_square!(squares, 2)\n4\n\njulia> squares\nDict{Int64, Int64} with 1 entry:\n  2 => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.getkey","location":"base/collections.html#Base.getkey","category":"function","text":"getkey(collection, key, default)\n\nReturn the key matching argument key if one exists in collection, otherwise return default.\n\nExamples\n\njulia> D = Dict('a'=>2, 'b'=>3)\nDict{Char, Int64} with 2 entries:\n  'a' => 2\n  'b' => 3\n\njulia> getkey(D, 'a', 1)\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> getkey(D, 'd', 'a')\n'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.delete!","location":"base/collections.html#Base.delete!","category":"function","text":"delete!(collection, key)\n\nDelete the mapping for the given key in a collection, if any, and return the collection.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2)\nDict{String, Int64} with 2 entries:\n  \"b\" => 2\n  \"a\" => 1\n\njulia> delete!(d, \"b\")\nDict{String, Int64} with 1 entry:\n  \"a\" => 1\n\njulia> delete!(d, \"b\") # d is left unchanged\nDict{String, Int64} with 1 entry:\n  \"a\" => 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pop!","location":"base/collections.html#Base.pop!-Tuple{Any, Any, Any}","category":"method","text":"pop!(collection, key[, default])\n\nDelete and return the mapping for key if it exists in collection, otherwise return default, or throw an error if default is not specified.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2, \"c\"=>3);\n\njulia> pop!(d, \"a\")\n1\n\njulia> pop!(d, \"d\")\nERROR: KeyError: key \"d\" not found\nStacktrace:\n[...]\n\njulia> pop!(d, \"e\", 4)\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.keys","location":"base/collections.html#Base.keys","category":"function","text":"keys(iterator)\n\nFor an iterator or collection that has keys and values (e.g. arrays and dictionaries), return an iterator over the keys.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.values","location":"base/collections.html#Base.values","category":"function","text":"values(iterator)\n\nFor an iterator or collection that has keys and values, return an iterator over the values. This function simply returns its argument by default, since the elements of a general iterator are normally considered its \"values\".\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2);\n\njulia> values(d)\nValueIterator for a Dict{String, Int64} with 2 entries. Values:\n  2\n  1\n\njulia> values([2])\n1-element Vector{Int64}:\n 2\n\n\n\n\n\nvalues(a::AbstractDict)\n\nReturn an iterator over all values in a collection. collect(values(a)) returns an array of values. When the values are stored internally in a hash table, as is the case for Dict, the order in which they are returned may vary. But keys(a) and values(a) both iterate a and return the elements in the same order.\n\nExamples\n\njulia> D = Dict('a'=>2, 'b'=>3)\nDict{Char, Int64} with 2 entries:\n  'a' => 2\n  'b' => 3\n\njulia> collect(values(D))\n2-element Vector{Int64}:\n 2\n 3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pairs","location":"base/collections.html#Base.pairs","category":"function","text":"pairs(IndexLinear(), A)\npairs(IndexCartesian(), A)\npairs(IndexStyle(A), A)\n\nAn iterator that accesses each element of the array A, returning i => x, where i is the index for the element and x = A[i]. Identical to pairs(A), except that the style of index can be selected. Also similar to enumerate(A), except i will be a valid index for A, while enumerate always counts from 1 regardless of the indices of A.\n\nSpecifying IndexLinear() ensures that i will be an integer; specifying IndexCartesian() ensures that i will be a Base.CartesianIndex; specifying IndexStyle(A) chooses whichever has been defined as the native indexing style for array A.\n\nMutation of the bounds of the underlying array will invalidate this iterator.\n\nExamples\n\njulia> A = [\"a\" \"d\"; \"b\" \"e\"; \"c\" \"f\"];\n\njulia> for (index, value) in pairs(IndexStyle(A), A)\n           println(\"$index $value\")\n       end\n1 a\n2 b\n3 c\n4 d\n5 e\n6 f\n\njulia> S = view(A, 1:2, :);\n\njulia> for (index, value) in pairs(IndexStyle(S), S)\n           println(\"$index $value\")\n       end\nCartesianIndex(1, 1) a\nCartesianIndex(2, 1) b\nCartesianIndex(1, 2) d\nCartesianIndex(2, 2) e\n\nSee also IndexStyle, axes.\n\n\n\n\n\npairs(collection)\n\nReturn an iterator over key => value pairs for any collection that maps a set of keys to a set of values. This includes arrays, where the keys are the array indices.\n\nExamples\n\njulia> a = Dict(zip([\"a\", \"b\", \"c\"], [1, 2, 3]))\nDict{String, Int64} with 3 entries:\n  \"c\" => 3\n  \"b\" => 2\n  \"a\" => 1\n\njulia> pairs(a)\nDict{String, Int64} with 3 entries:\n  \"c\" => 3\n  \"b\" => 2\n  \"a\" => 1\n\njulia> foreach(println, pairs([\"a\", \"b\", \"c\"]))\n1 => \"a\"\n2 => \"b\"\n3 => \"c\"\n\njulia> (;a=1, b=2, c=3) |> pairs |> collect\n3-element Vector{Pair{Symbol, Int64}}:\n :a => 1\n :b => 2\n :c => 3\n\njulia> (;a=1, b=2, c=3) |> collect\n3-element Vector{Int64}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.merge","location":"base/collections.html#Base.merge","category":"function","text":"merge(initial::Face, others::Face...)\n\nMerge the properties of the initial face and others, with later faces taking priority.\n\n\n\n\n\nmerge(d::AbstractDict, others::AbstractDict...)\n\nConstruct a merged collection from the given collections. If necessary, the types of the resulting collection will be promoted to accommodate the types of the merged collections. If the same key is present in another collection, the value for that key will be the value it has in the last collection listed. See also mergewith for custom handling of values with the same key.\n\nExamples\n\njulia> a = Dict(\"foo\" => 0.0, \"bar\" => 42.0)\nDict{String, Float64} with 2 entries:\n  \"bar\" => 42.0\n  \"foo\" => 0.0\n\njulia> b = Dict(\"baz\" => 17, \"bar\" => 4711)\nDict{String, Int64} with 2 entries:\n  \"bar\" => 4711\n  \"baz\" => 17\n\njulia> merge(a, b)\nDict{String, Float64} with 3 entries:\n  \"bar\" => 4711.0\n  \"baz\" => 17.0\n  \"foo\" => 0.0\n\njulia> merge(b, a)\nDict{String, Float64} with 3 entries:\n  \"bar\" => 42.0\n  \"baz\" => 17.0\n  \"foo\" => 0.0\n\n\n\n\n\nmerge(a::NamedTuple, bs::NamedTuple...)\n\nConstruct a new named tuple by merging two or more existing ones, in a left-associative manner. Merging proceeds left-to-right, between pairs of named tuples, and so the order of fields present in both the leftmost and rightmost named tuples take the same position as they are found in the leftmost named tuple. However, values are taken from matching fields in the rightmost named tuple that contains that field. Fields present in only the rightmost named tuple of a pair are appended at the end. A fallback is implemented for when only a single named tuple is supplied, with signature merge(a::NamedTuple).\n\ncompat: Julia 1.1\nMerging 3 or more NamedTuple requires at least Julia 1.1.\n\nExamples\n\njulia> merge((a=1, b=2, c=3), (b=4, d=5))\n(a = 1, b = 4, c = 3, d = 5)\n\njulia> merge((a=1, b=2), (b=3, c=(d=1,)), (c=(d=2,),))\n(a = 1, b = 3, c = (d = 2,))\n\n\n\n\n\nmerge(a::NamedTuple, iterable)\n\nInterpret an iterable of key-value pairs as a named tuple, and perform a merge.\n\njulia> merge((a=1, b=2, c=3), [:b=>4, :d=>5])\n(a = 1, b = 4, c = 3, d = 5)\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mergewith","location":"base/collections.html#Base.mergewith","category":"function","text":"mergewith(combine, d::AbstractDict, others::AbstractDict...)\nmergewith(combine)\nmerge(combine, d::AbstractDict, others::AbstractDict...)\n\nConstruct a merged collection from the given collections. If necessary, the types of the resulting collection will be promoted to accommodate the types of the merged collections. Values with the same key will be combined using the combiner function.  The curried form mergewith(combine) returns the function (args...) -> mergewith(combine, args...).\n\nMethod merge(combine::Union{Function,Type}, args...) as an alias of mergewith(combine, args...) is still available for backward compatibility.\n\ncompat: Julia 1.5\nmergewith requires Julia 1.5 or later.\n\nExamples\n\njulia> a = Dict(\"foo\" => 0.0, \"bar\" => 42.0)\nDict{String, Float64} with 2 entries:\n  \"bar\" => 42.0\n  \"foo\" => 0.0\n\njulia> b = Dict(\"baz\" => 17, \"bar\" => 4711)\nDict{String, Int64} with 2 entries:\n  \"bar\" => 4711\n  \"baz\" => 17\n\njulia> mergewith(+, a, b)\nDict{String, Float64} with 3 entries:\n  \"bar\" => 4753.0\n  \"baz\" => 17.0\n  \"foo\" => 0.0\n\njulia> ans == mergewith(+)(a, b)\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.merge!","location":"base/collections.html#Base.merge!","category":"function","text":"merge!(d::AbstractDict, others::AbstractDict...)\n\nUpdate collection with pairs from the other collections. See also merge.\n\nExamples\n\njulia> d1 = Dict(1 => 2, 3 => 4);\n\njulia> d2 = Dict(1 => 4, 4 => 5);\n\njulia> merge!(d1, d2);\n\njulia> d1\nDict{Int64, Int64} with 3 entries:\n  4 => 5\n  3 => 4\n  1 => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.mergewith!","location":"base/collections.html#Base.mergewith!","category":"function","text":"mergewith!(combine, d::AbstractDict, others::AbstractDict...) -> d\nmergewith!(combine)\nmerge!(combine, d::AbstractDict, others::AbstractDict...) -> d\n\nUpdate collection with pairs from the other collections. Values with the same key will be combined using the combiner function.  The curried form mergewith!(combine) returns the function (args...) -> mergewith!(combine, args...).\n\nMethod merge!(combine::Union{Function,Type}, args...) as an alias of mergewith!(combine, args...) is still available for backward compatibility.\n\ncompat: Julia 1.5\nmergewith! requires Julia 1.5 or later.\n\nExamples\n\njulia> d1 = Dict(1 => 2, 3 => 4);\n\njulia> d2 = Dict(1 => 4, 4 => 5);\n\njulia> mergewith!(+, d1, d2);\n\njulia> d1\nDict{Int64, Int64} with 3 entries:\n  4 => 5\n  3 => 4\n  1 => 6\n\njulia> mergewith!(-, d1, d1);\n\njulia> d1\nDict{Int64, Int64} with 3 entries:\n  4 => 0\n  3 => 0\n  1 => 0\n\njulia> foldl(mergewith!(+), [d1, d2]; init=Dict{Int64, Int64}())\nDict{Int64, Int64} with 3 entries:\n  4 => 5\n  3 => 0\n  1 => 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.sizehint!","location":"base/collections.html#Base.sizehint!","category":"function","text":"sizehint!(s, n; first::Bool=false, shrink::Bool=true) -> s\n\nSuggest that collection s reserve capacity for at least n elements. That is, if you expect that you're going to have to push a lot of values onto s, you can avoid the cost of incremental reallocation by doing it once up front; this can improve performance.\n\nIf first is true, then any additional space is reserved before the start of the collection. This way, subsequent calls to pushfirst! (instead of push!) may become faster. Supplying this keyword may result in an error if the collection is not ordered or if pushfirst! is not supported for this collection.\n\nIf shrink=true (the default), the collection's capacity may be reduced if its current capacity is greater than n.\n\nSee also resize!.\n\nNotes on the performance model\n\nFor types that support sizehint!,\n\npush! and append! methods generally may (but are not required to) preallocate extra storage. For types implemented in Base, they typically do, using a heuristic optimized for a general use case.\nsizehint! may control this preallocation. Again, it typically does this for types in Base.\nempty! is nearly costless (and O(1)) for types that support this kind of preallocation.\n\ncompat: Julia 1.11\nThe shrink and first arguments were added in Julia 1.11.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.keytype","location":"base/collections.html#Base.keytype","category":"function","text":"keytype(T::Type{<:AbstractArray})\nkeytype(A::AbstractArray)\n\nReturn the key type of an array. This is equal to the eltype of the result of keys(...), and is provided mainly for compatibility with the dictionary interface.\n\nExamples\n\njulia> keytype([1, 2, 3]) == Int\ntrue\n\njulia> keytype([1 2; 3 4])\nCartesianIndex{2}\n\ncompat: Julia 1.2\nFor arrays, this function requires at least Julia 1.2.\n\n\n\n\n\nkeytype(type)\n\nGet the key type of a dictionary type. Behaves similarly to eltype.\n\nExamples\n\njulia> keytype(Dict(Int32(1) => \"foo\"))\nInt32\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.valtype","location":"base/collections.html#Base.valtype","category":"function","text":"valtype(T::Type{<:AbstractArray})\nvaltype(A::AbstractArray)\n\nReturn the value type of an array. This is identical to eltype and is provided mainly for compatibility with the dictionary interface.\n\nExamples\n\njulia> valtype([\"one\", \"two\", \"three\"])\nString\n\ncompat: Julia 1.2\nFor arrays, this function requires at least Julia 1.2.\n\n\n\n\n\nvaltype(type)\n\nGet the value type of a dictionary type. Behaves similarly to eltype.\n\nExamples\n\njulia> valtype(Dict(Int32(1) => \"foo\"))\nString\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Dict\nIdDict\nWeakKeyDict","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Partially implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Set\nBitSet\nIdSet\nEnvDict\nArray\nBitArray\nImmutableDict\nPersistentDict\nIterators.Pairs","page":"Collections and Data Structures"},{"title":"Set-Like Collections","location":"base/collections.html#Set-Like-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.AbstractSet\nBase.Set\nBase.BitSet\nBase.IdSet\nBase.union\nBase.union!\nBase.intersect\nBase.setdiff\nBase.setdiff!\nBase.symdiff\nBase.symdiff!\nBase.intersect!\nBase.issubset\nBase.in!\nBase.:⊈\nBase.:⊊\nBase.issetequal\nBase.isdisjoint","page":"Collections and Data Structures"},{"title":"Base.AbstractSet","location":"base/collections.html#Base.AbstractSet","category":"type","text":"AbstractSet{T}\n\nSupertype for set-like types whose elements are of type T. Set, BitSet and other types are subtypes of this.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.Set","location":"base/collections.html#Base.Set","category":"type","text":"Set{T} <: AbstractSet{T}\n\nSets are mutable containers that provide fast membership testing.\n\nSets have efficient implementations of set operations such as in, union and intersect. Elements in a Set are unique, as determined by the elements' definition of isequal. The order of elements in a Set is an implementation detail and cannot be relied on.\n\nSee also: AbstractSet, BitSet, Dict, push!, empty!, union!, in, isequal\n\nExamples\n\njulia> s = Set(\"aaBca\")\nSet{Char} with 3 elements:\n  'a'\n  'c'\n  'B'\n\njulia> push!(s, 'b')\nSet{Char} with 4 elements:\n  'a'\n  'b'\n  'B'\n  'c'\n\njulia> s = Set([NaN, 0.0, 1.0, 2.0]);\n\njulia> -0.0 in s # isequal(0.0, -0.0) is false\nfalse\n\njulia> NaN in s # isequal(NaN, NaN) is true\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.BitSet","location":"base/collections.html#Base.BitSet","category":"type","text":"BitSet([itr])\n\nConstruct a sorted set of Ints generated by the given iterable object, or an empty set. Implemented as a bit string, and therefore designed for dense integer sets. If the set will be sparse (for example, holding a few very large integers), use Set instead.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.IdSet","location":"base/collections.html#Base.IdSet","category":"type","text":"IdSet{T}([itr])\nIdSet()\n\nIdSet{T}() constructs a set (see Set) using === as equality with values of type T.\n\nIn the example below, the values are all isequal so they get overwritten in the ordinary Set. The IdSet compares by === and so preserves the 3 different values.\n\nExamples\n\njulia> Set(Any[true, 1, 1.0])\nSet{Any} with 1 element:\n  1.0\n\njulia> IdSet{Any}(Any[true, 1, 1.0])\nIdSet{Any} with 3 elements:\n  1.0\n  1\n  true\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.union","location":"base/collections.html#Base.union","category":"function","text":"union(s, itrs...)\n∪(s, itrs...)\n\nConstruct an object containing all distinct elements from all of the arguments.\n\nThe first argument controls what kind of container is returned. If this is an array, it maintains the order in which elements first appear.\n\nUnicode ∪ can be typed by writing \\cup then pressing tab in the Julia REPL, and in many editors. This is an infix operator, allowing s ∪ itr.\n\nSee also unique, intersect, isdisjoint, vcat, Iterators.flatten.\n\nExamples\n\njulia> union([1, 2], [3])\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> union([4 2 3 4 4], 1:3, 3.0)\n4-element Vector{Float64}:\n 4.0\n 2.0\n 3.0\n 1.0\n\njulia> (0, 0.0) ∪ (-0.0, NaN)\n3-element Vector{Real}:\n   0\n  -0.0\n NaN\n\njulia> union(Set([1, 2]), 2:3)\nSet{Int64} with 3 elements:\n  2\n  3\n  1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.union!","location":"base/collections.html#Base.union!","category":"function","text":"union!(s::Union{AbstractSet,AbstractVector}, itrs...)\n\nConstruct the union of passed in sets and overwrite s with the result. Maintain order with arrays.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> a = Set([3, 4, 5]);\n\njulia> union!(a, 1:2:7);\n\njulia> a\nSet{Int64} with 5 elements:\n  5\n  4\n  7\n  3\n  1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.intersect","location":"base/collections.html#Base.intersect","category":"function","text":"intersect(s, itrs...)\n∩(s, itrs...)\n\nConstruct the set containing those elements which appear in all of the arguments.\n\nThe first argument controls what kind of container is returned. If this is an array, it maintains the order in which elements first appear.\n\nUnicode ∩ can be typed by writing \\cap then pressing tab in the Julia REPL, and in many editors. This is an infix operator, allowing s ∩ itr.\n\nSee also setdiff, isdisjoint, issubset, issetequal.\n\ncompat: Julia 1.8\nAs of Julia 1.8 intersect returns a result with the eltype of the type-promoted eltypes of the two inputs\n\nExamples\n\njulia> intersect([1, 2, 3], [3, 4, 5])\n1-element Vector{Int64}:\n 3\n\njulia> intersect([1, 4, 4, 5, 6], [6, 4, 6, 7, 8])\n2-element Vector{Int64}:\n 4\n 6\n\njulia> intersect(1:16, 7:99)\n7:16\n\njulia> (0, 0.0) ∩ (-0.0, 0)\n1-element Vector{Real}:\n 0\n\njulia> intersect(Set([1, 2]), BitSet([2, 3]), 1.0:10.0)\nSet{Float64} with 1 element:\n  2.0\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.setdiff","location":"base/collections.html#Base.setdiff","category":"function","text":"setdiff(s, itrs...)\n\nConstruct the set of elements in s but not in any of the iterables in itrs. Maintain order with arrays.\n\nSee also setdiff!, union and intersect.\n\nExamples\n\njulia> setdiff([1,2,3], [3,4,5])\n2-element Vector{Int64}:\n 1\n 2\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.setdiff!","location":"base/collections.html#Base.setdiff!","category":"function","text":"setdiff!(s, itrs...)\n\nRemove from set s (in-place) each element of each iterable from itrs. Maintain order with arrays.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> a = Set([1, 3, 4, 5]);\n\njulia> setdiff!(a, 1:2:6);\n\njulia> a\nSet{Int64} with 1 element:\n  4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.symdiff","location":"base/collections.html#Base.symdiff","category":"function","text":"symdiff(s, itrs...)\n\nConstruct the symmetric difference of elements in the passed in sets. When s is not an AbstractSet, the order is maintained.\n\nSee also symdiff!, setdiff, union and intersect.\n\nExamples\n\njulia> symdiff([1,2,3], [3,4,5], [4,5,6])\n3-element Vector{Int64}:\n 1\n 2\n 6\n\njulia> symdiff([1,2,1], [2, 1, 2])\nInt64[]\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.symdiff!","location":"base/collections.html#Base.symdiff!","category":"function","text":"symdiff!(s::Union{AbstractSet,AbstractVector}, itrs...)\n\nConstruct the symmetric difference of the passed in sets, and overwrite s with the result. When s is an array, the order is maintained. Note that in this case the multiplicity of elements matters.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.intersect!","location":"base/collections.html#Base.intersect!","category":"function","text":"intersect!(s::Union{AbstractSet,AbstractVector}, itrs...)\n\nIntersect all passed in sets and overwrite s with the result. Maintain order with arrays.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.issubset","location":"base/collections.html#Base.issubset","category":"function","text":"issubset(a, b) -> Bool\n⊆(a, b) -> Bool\n⊇(b, a) -> Bool\n\nDetermine whether every element of a is also in b, using in.\n\nSee also ⊊, ⊈, ∩, ∪, contains.\n\nExamples\n\njulia> issubset([1, 2], [1, 2, 3])\ntrue\n\njulia> [1, 2, 3] ⊆ [1, 2]\nfalse\n\njulia> [1, 2, 3] ⊇ [1, 2]\ntrue\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.in!","location":"base/collections.html#Base.in!","category":"function","text":"in!(x, s::AbstractSet) -> Bool\n\nIf x is in s, return true. If not, push x into s and return false. This is equivalent to in(x, s) ? true : (push!(s, x); false), but may have a more efficient implementation.\n\nSee also: in, push!, Set\n\ncompat: Julia 1.11\nThis function requires at least 1.11.\n\nExamples\n\njulia> s = Set{Any}([1, 2, 3]); in!(4, s)\nfalse\n\njulia> length(s)\n4\n\njulia> in!(0x04, s)\ntrue\n\njulia> s\nSet{Any} with 4 elements:\n  4\n  2\n  3\n  1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.:⊈","location":"base/collections.html#Base.:⊈","category":"function","text":"⊈(a, b) -> Bool\n⊉(b, a) -> Bool\n\nNegation of ⊆ and ⊇, i.e. checks that a is not a subset of b.\n\nSee also issubset (⊆), ⊊.\n\nExamples\n\njulia> (1, 2) ⊈ (2, 3)\ntrue\n\njulia> (1, 2) ⊈ (1, 2, 3)\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.:⊊","location":"base/collections.html#Base.:⊊","category":"function","text":"⊊(a, b) -> Bool\n⊋(b, a) -> Bool\n\nDetermines if a is a subset of, but not equal to, b.\n\nSee also issubset (⊆), ⊈.\n\nExamples\n\njulia> (1, 2) ⊊ (1, 2, 3)\ntrue\n\njulia> (1, 2) ⊊ (1, 2)\nfalse\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.issetequal","location":"base/collections.html#Base.issetequal","category":"function","text":"issetequal(a, b) -> Bool\n\nDetermine whether a and b have the same elements. Equivalent to a ⊆ b && b ⊆ a but more efficient when possible.\n\nSee also: isdisjoint, union.\n\nExamples\n\njulia> issetequal([1, 2], [1, 2, 3])\nfalse\n\njulia> issetequal([1, 2], [2, 1])\ntrue\n\n\n\n\n\nissetequal(x)\n\nCreate a function that compares its argument to x using issetequal, i.e. a function equivalent to y -> issetequal(y, x). The returned function is of type Base.Fix2{typeof(issetequal)}, which can be used to implement specialized methods.\n\ncompat: Julia 1.11\nThis functionality requires at least Julia 1.11.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.isdisjoint","location":"base/collections.html#Base.isdisjoint","category":"function","text":"isdisjoint(a, b) -> Bool\n\nDetermine whether the collections a and b are disjoint. Equivalent to isempty(a ∩ b) but more efficient when possible.\n\nSee also: intersect, isempty, issetequal.\n\ncompat: Julia 1.5\nThis function requires at least Julia 1.5.\n\nExamples\n\njulia> isdisjoint([1, 2], [2, 3, 4])\nfalse\n\njulia> isdisjoint([3, 1], [2, 4])\ntrue\n\n\n\n\n\nisdisjoint(x)\n\nCreate a function that compares its argument to x using isdisjoint, i.e. a function equivalent to y -> isdisjoint(y, x). The returned function is of type Base.Fix2{typeof(isdisjoint)}, which can be used to implement specialized methods.\n\ncompat: Julia 1.11\nThis functionality requires at least Julia 1.11.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Set\nBitSet\nIdSet","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Partially implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Array","page":"Collections and Data Structures"},{"title":"Dequeues","location":"base/collections.html#Dequeues","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.push!\nBase.pop!\nBase.popat!\nBase.pushfirst!\nBase.popfirst!\nBase.insert!\nBase.deleteat!\nBase.keepat!\nBase.splice!\nBase.resize!\nBase.append!\nBase.prepend!","page":"Collections and Data Structures"},{"title":"Base.push!","location":"base/collections.html#Base.push!","category":"function","text":"push!(collection, items...) -> collection\n\nInsert one or more items in collection. If collection is an ordered container, the items are inserted at the end (in the given order).\n\nExamples\n\njulia> push!([1, 2, 3], 4, 5, 6)\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\nIf collection is ordered, use append! to add all the elements of another collection to it. The result of the preceding example is equivalent to append!([1, 2, 3], [4, 5, 6]). For AbstractSet objects, union! can be used instead.\n\nSee sizehint! for notes about the performance model.\n\nSee also pushfirst!.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pop!","location":"base/collections.html#Base.pop!","category":"function","text":"pop!(collection) -> item\n\nRemove an item in collection and return it. If collection is an ordered container, the last item is returned; for unordered containers, an arbitrary element is returned.\n\nSee also: popfirst!, popat!, delete!, deleteat!, splice!, and push!.\n\nExamples\n\njulia> A=[1, 2, 3]\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> pop!(A)\n3\n\njulia> A\n2-element Vector{Int64}:\n 1\n 2\n\njulia> S = Set([1, 2])\nSet{Int64} with 2 elements:\n  2\n  1\n\njulia> pop!(S)\n2\n\njulia> S\nSet{Int64} with 1 element:\n  1\n\njulia> pop!(Dict(1=>2))\n1 => 2\n\n\n\n\n\npop!(collection, key[, default])\n\nDelete and return the mapping for key if it exists in collection, otherwise return default, or throw an error if default is not specified.\n\nExamples\n\njulia> d = Dict(\"a\"=>1, \"b\"=>2, \"c\"=>3);\n\njulia> pop!(d, \"a\")\n1\n\njulia> pop!(d, \"d\")\nERROR: KeyError: key \"d\" not found\nStacktrace:\n[...]\n\njulia> pop!(d, \"e\", 4)\n4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.popat!","location":"base/collections.html#Base.popat!","category":"function","text":"popat!(a::Vector, i::Integer, [default])\n\nRemove the item at the given i and return it. Subsequent items are shifted to fill the resulting gap. When i is not a valid index for a, return default, or throw an error if default is not specified.\n\nSee also: pop!, popfirst!, deleteat!, splice!.\n\ncompat: Julia 1.5\nThis function is available as of Julia 1.5.\n\nExamples\n\njulia> a = [4, 3, 2, 1]; popat!(a, 2)\n3\n\njulia> a\n3-element Vector{Int64}:\n 4\n 2\n 1\n\njulia> popat!(a, 4, missing)\nmissing\n\njulia> popat!(a, 4)\nERROR: BoundsError: attempt to access 3-element Vector{Int64} at index [4]\n[...]\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.pushfirst!","location":"base/collections.html#Base.pushfirst!","category":"function","text":"pushfirst!(collection, items...) -> collection\n\nInsert one or more items at the beginning of collection.\n\nThis function is called unshift in many other programming languages.\n\nExamples\n\njulia> pushfirst!([1, 2, 3, 4], 5, 6)\n6-element Vector{Int64}:\n 5\n 6\n 1\n 2\n 3\n 4\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.popfirst!","location":"base/collections.html#Base.popfirst!","category":"function","text":"popfirst!(collection) -> item\n\nRemove the first item from collection.\n\nThis function is called shift in many other programming languages.\n\nSee also: pop!, popat!, delete!.\n\nExamples\n\njulia> A = [1, 2, 3, 4, 5, 6]\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\njulia> popfirst!(A)\n1\n\njulia> A\n5-element Vector{Int64}:\n 2\n 3\n 4\n 5\n 6\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.insert!","location":"base/collections.html#Base.insert!","category":"function","text":"insert!(a::Vector, index::Integer, item)\n\nInsert an item into a at the given index. index is the index of item in the resulting a.\n\nSee also: push!, replace, popat!, splice!.\n\nExamples\n\njulia> insert!(Any[1:6;], 3, \"here\")\n7-element Vector{Any}:\n 1\n 2\n  \"here\"\n 3\n 4\n 5\n 6\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.deleteat!","location":"base/collections.html#Base.deleteat!","category":"function","text":"deleteat!(a::Vector, i::Integer)\n\nRemove the item at the given i and return the modified a. Subsequent items are shifted to fill the resulting gap.\n\nSee also: keepat!, delete!, popat!, splice!.\n\nExamples\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], 2)\n5-element Vector{Int64}:\n 6\n 4\n 3\n 2\n 1\n\n\n\n\n\ndeleteat!(a::Vector, inds)\n\nRemove the items at the indices given by inds, and return the modified a. Subsequent items are shifted to fill the resulting gap.\n\ninds can be either an iterator or a collection of sorted and unique integer indices, or a boolean vector of the same length as a with true indicating entries to delete.\n\nExamples\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], 1:2:5)\n3-element Vector{Int64}:\n 5\n 3\n 1\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], [true, false, true, false, true, false])\n3-element Vector{Int64}:\n 5\n 3\n 1\n\njulia> deleteat!([6, 5, 4, 3, 2, 1], (2, 2))\nERROR: ArgumentError: indices must be unique and sorted\nStacktrace:\n[...]\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.keepat!","location":"base/collections.html#Base.keepat!","category":"function","text":"keepat!(a::Vector, inds)\nkeepat!(a::BitVector, inds)\n\nRemove the items at all the indices which are not given by inds, and return the modified a. Items which are kept are shifted to fill the resulting gaps.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\ninds must be an iterator of sorted and unique integer indices. See also deleteat!.\n\ncompat: Julia 1.7\nThis function is available as of Julia 1.7.\n\nExamples\n\njulia> keepat!([6, 5, 4, 3, 2, 1], 1:2:5)\n3-element Vector{Int64}:\n 6\n 4\n 2\n\n\n\n\n\nkeepat!(a::Vector, m::AbstractVector{Bool})\nkeepat!(a::BitVector, m::AbstractVector{Bool})\n\nThe in-place version of logical indexing a = a[m]. That is, keepat!(a, m) on vectors of equal length a and m will remove all elements from a for which m at the corresponding index is false.\n\nExamples\n\njulia> a = [:a, :b, :c];\n\njulia> keepat!(a, [true, false, true])\n2-element Vector{Symbol}:\n :a\n :c\n\njulia> a\n2-element Vector{Symbol}:\n :a\n :c\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.splice!","location":"base/collections.html#Base.splice!","category":"function","text":"splice!(a::Vector, index::Integer, [replacement]) -> item\n\nRemove the item at the given index, and return the removed item. Subsequent items are shifted left to fill the resulting gap. If specified, replacement values from an ordered collection will be spliced in place of the removed item.\n\nSee also: replace, delete!, deleteat!, pop!, popat!.\n\nExamples\n\njulia> A = [6, 5, 4, 3, 2, 1]; splice!(A, 5)\n2\n\njulia> A\n5-element Vector{Int64}:\n 6\n 5\n 4\n 3\n 1\n\njulia> splice!(A, 5, -1)\n1\n\njulia> A\n5-element Vector{Int64}:\n  6\n  5\n  4\n  3\n -1\n\njulia> splice!(A, 1, [-1, -2, -3])\n6\n\njulia> A\n7-element Vector{Int64}:\n -1\n -2\n -3\n  5\n  4\n  3\n -1\n\nTo insert replacement before an index n without removing any items, use splice!(collection, n:n-1, replacement).\n\n\n\n\n\nsplice!(a::Vector, indices, [replacement]) -> items\n\nRemove items at specified indices, and return a collection containing the removed items. Subsequent items are shifted left to fill the resulting gaps. If specified, replacement values from an ordered collection will be spliced in place of the removed items; in this case, indices must be a AbstractUnitRange.\n\nTo insert replacement before an index n without removing any items, use splice!(collection, n:n-1, replacement).\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\ncompat: Julia 1.5\nPrior to Julia 1.5, indices must always be a UnitRange.\n\ncompat: Julia 1.8\nPrior to Julia 1.8, indices must be a UnitRange if splicing in replacement values.\n\nExamples\n\njulia> A = [-1, -2, -3, 5, 4, 3, -1]; splice!(A, 4:3, 2)\nInt64[]\n\njulia> A\n8-element Vector{Int64}:\n -1\n -2\n -3\n  2\n  5\n  4\n  3\n -1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.resize!","location":"base/collections.html#Base.resize!","category":"function","text":"resize!(a::Vector, n::Integer) -> Vector\n\nResize a to contain n elements. If n is smaller than the current collection length, the first n elements will be retained. If n is larger, the new elements are not guaranteed to be initialized.\n\nExamples\n\njulia> resize!([6, 5, 4, 3, 2, 1], 3)\n3-element Vector{Int64}:\n 6\n 5\n 4\n\njulia> a = resize!([6, 5, 4, 3, 2, 1], 8);\n\njulia> length(a)\n8\n\njulia> a[1:6]\n6-element Vector{Int64}:\n 6\n 5\n 4\n 3\n 2\n 1\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.append!","location":"base/collections.html#Base.append!","category":"function","text":"append!(collection, collections...) -> collection.\n\nFor an ordered container collection, add the elements of each collections to the end of it.\n\ncompat: Julia 1.6\nSpecifying multiple collections to be appended requires at least Julia 1.6.\n\nExamples\n\njulia> append!([1], [2, 3])\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> append!([1, 2, 3], [4, 5], [6])\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\nUse push! to add individual items to collection which are not already themselves in another collection. The result of the preceding example is equivalent to push!([1, 2, 3], 4, 5, 6).\n\nSee sizehint! for notes about the performance model.\n\nSee also vcat for vectors, union! for sets, and prepend! and pushfirst! for the opposite order.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.prepend!","location":"base/collections.html#Base.prepend!","category":"function","text":"prepend!(a::Vector, collections...) -> collection\n\nInsert the elements of each collections to the beginning of a.\n\nWhen collections specifies multiple collections, order is maintained: elements of collections[1] will appear leftmost in a, and so on.\n\ncompat: Julia 1.6\nSpecifying multiple collections to be prepended requires at least Julia 1.6.\n\nExamples\n\njulia> prepend!([3], [1, 2])\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> prepend!([6], [1, 2], [3, 4, 5])\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Fully implemented by:","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Vector (a.k.a. 1-dimensional Array)\nBitVector (a.k.a. 1-dimensional BitArray)","page":"Collections and Data Structures"},{"title":"Utility Collections","location":"base/collections.html#Utility-Collections","category":"section","text":"","page":"Collections and Data Structures"},{"title":"Collections and Data Structures","location":"base/collections.html","category":"page","text":"Base.Pair\nIterators.Pairs","page":"Collections and Data Structures"},{"title":"Core.Pair","location":"base/collections.html#Core.Pair","category":"type","text":"Pair(x, y)\nx => y\n\nConstruct a Pair object with type Pair{typeof(x), typeof(y)}. The elements are stored in the fields first and second. They can also be accessed via iteration (but a Pair is treated as a single \"scalar\" for broadcasting operations).\n\nSee also Dict.\n\nExamples\n\njulia> p = \"foo\" => 7\n\"foo\" => 7\n\njulia> typeof(p)\nPair{String, Int64}\n\njulia> p.first\n\"foo\"\n\njulia> for x in p\n           println(x)\n       end\nfoo\n7\n\njulia> replace.([\"xops\", \"oxps\"], \"x\" => \"o\")\n2-element Vector{String}:\n \"oops\"\n \"oops\"\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Base.Pairs","location":"base/collections.html#Base.Pairs","category":"type","text":"Base.Pairs(values, keys) <: AbstractDict{eltype(keys), eltype(values)}\n\nTransforms an indexable container into a Dictionary-view of the same data. Modifying the key-space of the underlying data may invalidate this object.\n\n\n\n\n\n","page":"Collections and Data Structures"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Random/docs/src/index.md\"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html#Random-Numbers","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"DocTestSetup = :(using Random)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random number generation in Julia uses the Xoshiro256++ algorithm by default, with per-Task state. Other RNG types can be plugged in by inheriting the AbstractRNG type; they can then be used to obtain multiple streams of random numbers.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The PRNGs (pseudorandom number generators) exported by the Random package are:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"TaskLocalRNG: a token that represents use of the currently active Task-local stream, deterministically seeded from the parent task, or by RandomDevice (with system randomness) at program start\nXoshiro: generates a high-quality stream of random numbers with a small state vector and high performance using the Xoshiro256++ algorithm\nRandomDevice: for OS-provided entropy. This may be used for cryptographically secure random numbers (CS(P)RNG).\nMersenneTwister: an alternate high-quality PRNG which was the default in older versions of Julia, and is also quite fast, but requires much more space to store the state vector and generate a random sequence.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Most functions related to random generation accept an optional AbstractRNG object as first argument. Some also accept dimension specifications dims... (which can also be given as a tuple) to generate arrays of random values. In a multi-threaded program, you should generally use different RNG objects from different threads or tasks in order to be thread-safe. However, the default RNG is thread-safe as of Julia 1.3 (using a per-thread RNG up to version 1.6, and per-task thereafter).","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The provided RNGs can generate uniform random numbers of the following types: Float16, Float32, Float64, BigFloat, Bool, Int8, UInt8, Int16, UInt16, Int32, UInt32, Int64, UInt64, Int128, UInt128, BigInt (or complex numbers of those types). Random floating point numbers are generated uniformly in 0 1). As BigInt represents unbounded integers, the interval must be specified (e.g. rand(big.(1:6))).","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Additionally, normal and exponential distributions are implemented for some AbstractFloat and Complex types, see randn and randexp for details.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"To generate random numbers from other distributions, see the Distributions.jl package.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"warning: Warning\nBecause the precise way in which random numbers are generated is considered an implementation detail, bug fixes and speed improvements may change the stream of numbers that are generated after a version change. Relying on a specific seed or generated stream of numbers during unit testing is thus discouraged - consider testing properties of the methods in question instead.","page":"Random Numbers"},{"title":"Random numbers module","location":"stdlib/Random.html#Random-numbers-module","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.Random","page":"Random Numbers"},{"title":"Random.Random","location":"stdlib/Random.html#Random.Random","category":"module","text":"Random\n\nSupport for generating random numbers. Provides rand, randn, AbstractRNG, MersenneTwister, and RandomDevice.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random generation functions","location":"stdlib/Random.html#Random-generation-functions","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.rand\nRandom.rand!\nRandom.bitrand\nRandom.randn\nRandom.randn!\nRandom.randexp\nRandom.randexp!\nRandom.randstring","page":"Random Numbers"},{"title":"Base.rand","location":"stdlib/Random.html#Base.rand","category":"function","text":"rand([rng=default_rng()], [S], [dims...])\n\nPick a random element or array of random elements from the set of values specified by S; S can be\n\nan indexable collection (for example 1:9 or ('x', \"y\", :z))\nan AbstractDict or AbstractSet object\na string (considered as a collection of characters), or\na type from the list below, corresponding to the specified set of values\nconcrete integer types sample from typemin(S):typemax(S) (excepting BigInt which is not supported)\nconcrete floating point types sample from [0, 1)\nconcrete complex types Complex{T} if T is a sampleable type take their real and imaginary components independently from the set of values corresponding to T, but are not supported if T is not sampleable.\nall <:AbstractChar types sample from the set of valid Unicode scalars\na user-defined type and set of values; for implementation guidance please see Hooking into the Random API\na tuple type of known size and where each parameter of S is itself a sampleable type; return a value of type S. Note that tuple types such as Tuple{Vararg{T}} (unknown size) and Tuple{1:2} (parameterized with a value) are not supported\na Pair type, e.g. Pair{X, Y} such that rand is defined for X and Y, in which case random pairs are produced.\n\nS defaults to Float64. When only one argument is passed besides the optional rng and is a Tuple, it is interpreted as a collection of values (S) and not as dims.\n\nSee also randn for normally distributed numbers, and rand! and randn! for the in-place equivalents.\n\ncompat: Julia 1.1\nSupport for S as a tuple requires at least Julia 1.1.\n\ncompat: Julia 1.11\nSupport for S as a Tuple type requires at least Julia 1.11.\n\nExamples\n\njulia> rand(Int, 2)\n2-element Array{Int64,1}:\n 1339893410598768192\n 1575814717733606317\n\njulia> using Random\n\njulia> rand(Xoshiro(0), Dict(1=>2, 3=>4))\n3 => 4\n\njulia> rand((2, 3))\n3\n\njulia> rand(Float64, (2, 3))\n2×3 Array{Float64,2}:\n 0.999717  0.0143835  0.540787\n 0.696556  0.783855   0.938235\n\nnote: Note\nThe complexity of rand(rng, s::Union{AbstractDict,AbstractSet}) is linear in the length of s, unless an optimized method with constant complexity is available, which is the case for Dict, Set and dense BitSets. For more than a few calls, use rand(rng, collect(s)) instead, or either rand(rng, Dict(s)) or rand(rng, Set(s)) as appropriate.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.rand!","location":"stdlib/Random.html#Random.rand!","category":"function","text":"rand!([rng=default_rng()], A, [S=eltype(A)])\n\nPopulate the array A with random values. If S is specified (S can be a type or a collection, cf. rand for details), the values are picked randomly from S. This is equivalent to copyto!(A, rand(rng, S, size(A))) but without allocating a new array.\n\nExamples\n\njulia> rand!(Xoshiro(123), zeros(5))\n5-element Vector{Float64}:\n 0.521213795535383\n 0.5868067574533484\n 0.8908786980927811\n 0.19090669902576285\n 0.5256623915420473\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.bitrand","location":"stdlib/Random.html#Random.bitrand","category":"function","text":"bitrand([rng=default_rng()], [dims...])\n\nGenerate a BitArray of random boolean values.\n\nExamples\n\njulia> bitrand(Xoshiro(123), 10)\n10-element BitVector:\n 0\n 1\n 0\n 1\n 0\n 1\n 0\n 0\n 1\n 1\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Base.randn","location":"stdlib/Random.html#Base.randn","category":"function","text":"randn([rng=default_rng()], [T=Float64], [dims...])\n\nGenerate a normally-distributed random number of type T with mean 0 and standard deviation 1. Given the optional dims argument(s), generate an array of size dims of such numbers. Julia's standard library supports randn for any floating-point type that implements rand, e.g. the Base types Float16, Float32, Float64 (the default), and BigFloat, along with their Complex counterparts.\n\n(When T is complex, the values are drawn from the circularly symmetric complex normal distribution of variance 1, corresponding to real and imaginary parts having independent normal distribution with mean zero and variance 1/2).\n\nSee also randn! to act in-place.\n\nExamples\n\nGenerating a single random number (with the default Float64 type):\n\njulia> randn()\n-0.942481877315864\n\nGenerating a matrix of normal random numbers (with the default Float64 type):\n\njulia> randn(2,3)\n2×3 Matrix{Float64}:\n  1.18786   -0.678616   1.49463\n -0.342792  -0.134299  -1.45005\n\nSetting up of the random number generator rng with a user-defined seed (for reproducible numbers) and using it to generate a random Float32 number or a matrix of ComplexF32 random numbers:\n\njulia> using Random\n\njulia> rng = Xoshiro(123);\n\njulia> randn(rng, Float32)\n-0.6457307f0\n\njulia> randn(rng, ComplexF32, (2, 3))\n2×3 Matrix{ComplexF32}:\n  -1.03467-1.14806im  0.693657+0.056538im   0.291442+0.419454im\n -0.153912+0.34807im    1.0954-0.948661im  -0.543347-0.0538589im\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randn!","location":"stdlib/Random.html#Random.randn!","category":"function","text":"randn!([rng=default_rng()], A::AbstractArray) -> A\n\nFill the array A with normally-distributed (mean 0, standard deviation 1) random numbers. Also see the rand function.\n\nExamples\n\njulia> randn!(Xoshiro(123), zeros(5))\n5-element Vector{Float64}:\n -0.6457306721039767\n -1.4632513788889214\n -1.6236037455860806\n -0.21766510678354617\n  0.4922456865251828\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randexp","location":"stdlib/Random.html#Random.randexp","category":"function","text":"randexp([rng=default_rng()], [T=Float64], [dims...])\n\nGenerate a random number of type T according to the exponential distribution with scale 1. Optionally generate an array of such random numbers. The Base module currently provides an implementation for the types Float16, Float32, and Float64 (the default).\n\nExamples\n\njulia> rng = Xoshiro(123);\n\njulia> randexp(rng, Float32)\n1.1757717f0\n\njulia> randexp(rng, 3, 3)\n3×3 Matrix{Float64}:\n 1.37766  0.456653  0.236418\n 3.40007  0.229917  0.0684921\n 0.48096  0.577481  0.71835\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randexp!","location":"stdlib/Random.html#Random.randexp!","category":"function","text":"randexp!([rng=default_rng()], A::AbstractArray) -> A\n\nFill the array A with random numbers following the exponential distribution (with scale 1).\n\nExamples\n\njulia> randexp!(Xoshiro(123), zeros(5))\n5-element Vector{Float64}:\n 1.1757716836348473\n 1.758884569451514\n 1.0083623637301151\n 0.3510644315565272\n 0.6348266443720407\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randstring","location":"stdlib/Random.html#Random.randstring","category":"function","text":"randstring([rng=default_rng()], [chars], [len=8])\n\nCreate a random string of length len, consisting of characters from chars, which defaults to the set of upper- and lower-case letters and the digits 0-9. The optional rng argument specifies a random number generator, see Random Numbers.\n\nExamples\n\njulia> Random.seed!(3); randstring()\n\"Lxz5hUwn\"\n\njulia> randstring(Xoshiro(3), 'a':'z', 6)\n\"iyzcsm\"\n\njulia> randstring(\"ACGT\")\n\"TGCTCCTC\"\n\nnote: Note\nchars can be any collection of characters, of type Char or UInt8 (more efficient), provided rand can randomly pick characters from it.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Subsequences, permutations and shuffling","location":"stdlib/Random.html#Subsequences,-permutations-and-shuffling","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.randsubseq\nRandom.randsubseq!\nRandom.randperm\nRandom.randperm!\nRandom.randcycle\nRandom.randcycle!\nRandom.shuffle\nRandom.shuffle!","page":"Random Numbers"},{"title":"Random.randsubseq","location":"stdlib/Random.html#Random.randsubseq","category":"function","text":"randsubseq([rng=default_rng(),] A, p) -> Vector\n\nReturn a vector consisting of a random subsequence of the given array A, where each element of A is included (in order) with independent probability p. (Complexity is linear in p*length(A), so this function is efficient even if p is small and A is large.) Technically, this process is known as \"Bernoulli sampling\" of A.\n\nExamples\n\njulia> randsubseq(Xoshiro(123), 1:8, 0.3)\n2-element Vector{Int64}:\n 4\n 7\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randsubseq!","location":"stdlib/Random.html#Random.randsubseq!","category":"function","text":"randsubseq!([rng=default_rng(),] S, A, p)\n\nLike randsubseq, but the results are stored in S (which is resized as needed).\n\nExamples\n\njulia> S = Int64[];\n\njulia> randsubseq!(Xoshiro(123), S, 1:8, 0.3)\n2-element Vector{Int64}:\n 4\n 7\n\njulia> S\n2-element Vector{Int64}:\n 4\n 7\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randperm","location":"stdlib/Random.html#Random.randperm","category":"function","text":"randperm([rng=default_rng(),] n::Integer)\n\nConstruct a random permutation of length n. The optional rng argument specifies a random number generator (see Random Numbers). The element type of the result is the same as the type of n.\n\nTo randomly permute an arbitrary vector, see shuffle or shuffle!.\n\ncompat: Julia 1.1\nIn Julia 1.1 randperm returns a vector v with eltype(v) == typeof(n) while in Julia 1.0 eltype(v) == Int.\n\nExamples\n\njulia> randperm(Xoshiro(123), 4)\n4-element Vector{Int64}:\n 1\n 4\n 2\n 3\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randperm!","location":"stdlib/Random.html#Random.randperm!","category":"function","text":"randperm!([rng=default_rng(),] A::Array{<:Integer})\n\nConstruct in A a random permutation of length length(A). The optional rng argument specifies a random number generator (see Random Numbers). To randomly permute an arbitrary vector, see shuffle or shuffle!.\n\nExamples\n\njulia> randperm!(Xoshiro(123), Vector{Int}(undef, 4))\n4-element Vector{Int64}:\n 1\n 4\n 2\n 3\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randcycle","location":"stdlib/Random.html#Random.randcycle","category":"function","text":"randcycle([rng=default_rng(),] n::Integer)\n\nConstruct a random cyclic permutation of length n. The optional rng argument specifies a random number generator, see Random Numbers. The element type of the result is the same as the type of n.\n\nHere, a \"cyclic permutation\" means that all of the elements lie within a single cycle.  If n > 0, there are (n-1) possible cyclic permutations, which are sampled uniformly.  If n == 0, randcycle returns an empty vector.\n\nrandcycle! is an in-place variant of this function.\n\ncompat: Julia 1.1\nIn Julia 1.1 and above, randcycle returns a vector v with eltype(v) == typeof(n) while in Julia 1.0 eltype(v) == Int.\n\nExamples\n\njulia> randcycle(Xoshiro(123), 6)\n6-element Vector{Int64}:\n 5\n 4\n 2\n 6\n 3\n 1\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.randcycle!","location":"stdlib/Random.html#Random.randcycle!","category":"function","text":"randcycle!([rng=default_rng(),] A::Array{<:Integer})\n\nConstruct in A a random cyclic permutation of length n = length(A). The optional rng argument specifies a random number generator, see Random Numbers.\n\nHere, a \"cyclic permutation\" means that all of the elements lie within a single cycle. If A is nonempty (n > 0), there are (n-1) possible cyclic permutations, which are sampled uniformly.  If A is empty, randcycle! leaves it unchanged.\n\nrandcycle is a variant of this function that allocates a new vector.\n\nExamples\n\njulia> randcycle!(Xoshiro(123), Vector{Int}(undef, 6))\n6-element Vector{Int64}:\n 5\n 4\n 2\n 6\n 3\n 1\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.shuffle","location":"stdlib/Random.html#Random.shuffle","category":"function","text":"shuffle([rng=default_rng(),] v::AbstractArray)\n\nReturn a randomly permuted copy of v. The optional rng argument specifies a random number generator (see Random Numbers). To permute v in-place, see shuffle!. To obtain randomly permuted indices, see randperm.\n\nExamples\n\njulia> shuffle(Xoshiro(123), Vector(1:10))\n10-element Vector{Int64}:\n  5\n  4\n  2\n  3\n  6\n 10\n  8\n  1\n  9\n  7\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.shuffle!","location":"stdlib/Random.html#Random.shuffle!","category":"function","text":"shuffle!([rng=default_rng(),] v::AbstractArray)\n\nIn-place version of shuffle: randomly permute v in-place, optionally supplying the random-number generator rng.\n\nExamples\n\njulia> shuffle!(Xoshiro(123), Vector(1:10))\n10-element Vector{Int64}:\n  5\n  4\n  2\n  3\n  6\n 10\n  8\n  1\n  9\n  7\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Generators (creation and seeding)","location":"stdlib/Random.html#Generators-(creation-and-seeding)","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.default_rng\nRandom.seed!\nRandom.AbstractRNG\nRandom.TaskLocalRNG\nRandom.Xoshiro\nRandom.MersenneTwister\nRandom.RandomDevice","page":"Random Numbers"},{"title":"Random.default_rng","location":"stdlib/Random.html#Random.default_rng","category":"function","text":"Random.default_rng() -> rng\n\nReturn the default global random number generator (RNG), which is used by rand-related functions when no explicit RNG is provided.\n\nWhen the Random module is loaded, the default RNG is randomly seeded, via Random.seed!(): this means that each time a new julia session is started, the first call to rand() produces a different result, unless seed!(seed) is called first.\n\nIt is thread-safe: distinct threads can safely call rand-related functions on default_rng() concurrently, e.g. rand(default_rng()).\n\nnote: Note\nThe type of the default RNG is an implementation detail. Across different versions of Julia, you should not expect the default RNG to always have the same type, nor that it will produce the same stream of random numbers for a given seed.\n\ncompat: Julia 1.3\nThis function was introduced in Julia 1.3.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.seed!","location":"stdlib/Random.html#Random.seed!","category":"function","text":"seed!([rng=default_rng()], seed) -> rng\nseed!([rng=default_rng()]) -> rng\n\nReseed the random number generator: rng will give a reproducible sequence of numbers if and only if a seed is provided. Some RNGs don't accept a seed, like RandomDevice. After the call to seed!, rng is equivalent to a newly created object initialized with the same seed. The types of accepted seeds depend on the type of rng, but in general, integer seeds should work.\n\nIf rng is not specified, it defaults to seeding the state of the shared task-local generator.\n\nExamples\n\njulia> Random.seed!(1234);\n\njulia> x1 = rand(2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> Random.seed!(1234);\n\njulia> x2 = rand(2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> x1 == x2\ntrue\n\njulia> rng = Xoshiro(1234); rand(rng, 2) == x1\ntrue\n\njulia> Xoshiro(1) == Random.seed!(rng, 1)\ntrue\n\njulia> rand(Random.seed!(rng), Bool) # not reproducible\ntrue\n\njulia> rand(Random.seed!(rng), Bool) # not reproducible either\nfalse\n\njulia> rand(Xoshiro(), Bool) # not reproducible either\ntrue\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.AbstractRNG","location":"stdlib/Random.html#Random.AbstractRNG","category":"type","text":"AbstractRNG\n\nSupertype for random number generators such as MersenneTwister and RandomDevice.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.TaskLocalRNG","location":"stdlib/Random.html#Random.TaskLocalRNG","category":"type","text":"TaskLocalRNG\n\nThe TaskLocalRNG has state that is local to its task, not its thread. It is seeded upon task creation, from the state of its parent task. Therefore, task creation is an event that changes the parent's RNG state.\n\nAs an upside, the TaskLocalRNG is pretty fast, and permits reproducible multithreaded simulations (barring race conditions), independent of scheduler decisions. As long as the number of threads is not used to make decisions on task creation, simulation results are also independent of the number of available threads / CPUs. The random stream should not depend on hardware specifics, up to endianness and possibly word size.\n\nUsing or seeding the RNG of any other task than the one returned by current_task() is undefined behavior: it will work most of the time, and may sometimes fail silently.\n\nWhen seeding TaskLocalRNG() with seed!, the passed seed, if any, may be any integer.\n\ncompat: Julia 1.11\nSeeding TaskLocalRNG() with a negative integer seed requires at least Julia 1.11.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.Xoshiro","location":"stdlib/Random.html#Random.Xoshiro","category":"type","text":"Xoshiro(seed::Union{Integer, AbstractString})\nXoshiro()\n\nXoshiro256++ is a fast pseudorandom number generator described by David Blackman and Sebastiano Vigna in \"Scrambled Linear Pseudorandom Number Generators\", ACM Trans. Math. Softw., 2021. Reference implementation is available at https://prng.di.unimi.it\n\nApart from the high speed, Xoshiro has a small memory footprint, making it suitable for applications where many different random states need to be held for long time.\n\nJulia's Xoshiro implementation has a bulk-generation mode; this seeds new virtual PRNGs from the parent, and uses SIMD to generate in parallel (i.e. the bulk stream consists of multiple interleaved xoshiro instances). The virtual PRNGs are discarded once the bulk request has been serviced (and should cause no heap allocations).\n\nIf no seed is provided, a randomly generated one is created (using entropy from the system). See the seed! function for reseeding an already existing Xoshiro object.\n\ncompat: Julia 1.11\nPassing a negative integer seed requires at least Julia 1.11.\n\nExamples\n\njulia> using Random\n\njulia> rng = Xoshiro(1234);\n\njulia> x1 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> rng = Xoshiro(1234);\n\njulia> x2 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.32597672886359486\n 0.5490511363155669\n\njulia> x1 == x2\ntrue\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.MersenneTwister","location":"stdlib/Random.html#Random.MersenneTwister","category":"type","text":"MersenneTwister(seed)\nMersenneTwister()\n\nCreate a MersenneTwister RNG object. Different RNG objects can have their own seeds, which may be useful for generating different streams of random numbers. The seed may be an integer, a string, or a vector of UInt32 integers. If no seed is provided, a randomly generated one is created (using entropy from the system). See the seed! function for reseeding an already existing MersenneTwister object.\n\ncompat: Julia 1.11\nPassing a negative integer seed requires at least Julia 1.11.\n\nExamples\n\njulia> rng = MersenneTwister(123);\n\njulia> x1 = rand(rng, 2)\n2-element Vector{Float64}:\n 0.37453777969575874\n 0.8735343642013971\n\njulia> x2 = rand(MersenneTwister(123), 2)\n2-element Vector{Float64}:\n 0.37453777969575874\n 0.8735343642013971\n\njulia> x1 == x2\ntrue\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.RandomDevice","location":"stdlib/Random.html#Random.RandomDevice","category":"type","text":"RandomDevice()\n\nCreate a RandomDevice RNG object. Two such objects will always generate different streams of random numbers. The entropy is obtained from the operating system.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Hooking into the Random API","location":"stdlib/Random.html#rand-api-hook","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"There are two mostly orthogonal ways to extend Random functionalities:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"generating random values of custom types\ncreating new generators","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The API for 1) is quite functional, but is relatively recent so it may still have to evolve in subsequent releases of the Random module. For example, it's typically sufficient to implement one rand method in order to have all other usual methods work automatically.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The API for 2) is still rudimentary, and may require more work than strictly necessary from the implementor, in order to support usual types of generated values.","page":"Random Numbers"},{"title":"Generating random values of custom types","location":"stdlib/Random.html#Generating-random-values-of-custom-types","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Generating random values for some distributions may involve various trade-offs. Pre-computed values, such as an alias table for discrete distributions, or “squeezing” functions for univariate distributions, can speed up sampling considerably. How much information should be pre-computed can depend on the number of values we plan to draw from a distribution. Also, some random number generators can have certain properties that various algorithms may want to exploit.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The Random module defines a customizable framework for obtaining random values that can address these issues. Each invocation of rand generates a sampler which can be customized with the above trade-offs in mind, by adding methods to Sampler, which in turn can dispatch on the random number generator, the object that characterizes the distribution, and a suggestion for the number of repetitions. Currently, for the latter, Val{1} (for a single sample) and Val{Inf} (for an arbitrary number) are used, with Random.Repetition an alias for both.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The object returned by Sampler is then used to generate the random values. When implementing the random generation interface for a value X that can be sampled from, the implementor should define the method","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"rand(rng, sampler)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"for the particular sampler returned by Sampler(rng, X, repetition).","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Samplers can be arbitrary values that implement rand(rng, sampler), but for most applications the following predefined samplers may be sufficient:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"SamplerType{T}() can be used for implementing samplers that draw from type T (e.g. rand(Int)). This is the default returned by Sampler for types.\nSamplerTrivial(self) is a simple wrapper for self, which can be accessed with []. This is the recommended sampler when no pre-computed information is needed (e.g. rand(1:3)), and is the default returned by Sampler for values.\nSamplerSimple(self, data) also contains the additional data field, which can be used to store arbitrary pre-computed values, which should be computed in a custom method of Sampler.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"We provide examples for each of these. We assume here that the choice of algorithm is independent of the RNG, so we use AbstractRNG in our signatures.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.Sampler\nRandom.SamplerType\nRandom.SamplerTrivial\nRandom.SamplerSimple","page":"Random Numbers"},{"title":"Random.Sampler","location":"stdlib/Random.html#Random.Sampler","category":"type","text":"Sampler(rng, x, repetition = Val(Inf))\n\nReturn a sampler object that can be used to generate random values from rng for x.\n\nWhen sp = Sampler(rng, x, repetition), rand(rng, sp) will be used to draw random values, and should be defined accordingly.\n\nrepetition can be Val(1) or Val(Inf), and should be used as a suggestion for deciding the amount of precomputation, if applicable.\n\nRandom.SamplerType and Random.SamplerTrivial are default fallbacks for types and values, respectively. Random.SamplerSimple can be used to store pre-computed values without defining extra types for only this purpose.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.SamplerType","location":"stdlib/Random.html#Random.SamplerType","category":"type","text":"SamplerType{T}()\n\nA sampler for types, containing no other information. The default fallback for Sampler when called with types.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.SamplerTrivial","location":"stdlib/Random.html#Random.SamplerTrivial","category":"type","text":"SamplerTrivial(x)\n\nCreate a sampler that just wraps the given value x. This is the default fall-back for values. The eltype of this sampler is equal to eltype(x).\n\nThe recommended use case is sampling from values without precomputed data.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random.SamplerSimple","location":"stdlib/Random.html#Random.SamplerSimple","category":"type","text":"SamplerSimple(x, data)\n\nCreate a sampler that wraps the given value x and the data. The eltype of this sampler is equal to eltype(x).\n\nThe recommended use case is sampling from values with precomputed data.\n\n\n\n\n\n","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Decoupling pre-computation from actually generating the values is part of the API, and is also available to the user. As an example, assume that rand(rng, 1:20) has to be called repeatedly in a loop: the way to take advantage of this decoupling is as follows:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"rng = Xoshiro()\nsp = Random.Sampler(rng, 1:20) # or Random.Sampler(Xoshiro, 1:20)\nfor x in X\n    n = rand(rng, sp) # similar to n = rand(rng, 1:20)\n    # use n\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"This is the mechanism that is also used in the standard library, e.g. by the default implementation of random array generation (like in rand(1:20, 10)).","page":"Random Numbers"},{"title":"Generating values from a type","location":"stdlib/Random.html#Generating-values-from-a-type","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Given a type T, it's currently assumed that if rand(T) is defined, an object of type T will be produced. SamplerType is the default sampler for types. In order to define random generation of values of type T, the rand(rng::AbstractRNG, ::Random.SamplerType{T}) method should be defined, and should return values what rand(rng, T) is expected to return.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Let's take the following example: we implement a Die type, with a variable number n of sides, numbered from 1 to n. We want rand(Die) to produce a Die with a random number of up to 20 sides (and at least 4):","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"struct Die\n    nsides::Int # number of sides\nend\n\nRandom.rand(rng::AbstractRNG, ::Random.SamplerType{Die}) = Die(rand(rng, 4:20))\n\n# output\n","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Scalar and array methods for Die now work as expected:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"julia> rand(Die)\nDie(5)\n\njulia> rand(Xoshiro(0), Die)\nDie(10)\n\njulia> rand(Die, 3)\n3-element Vector{Die}:\n Die(9)\n Die(15)\n Die(14)\n\njulia> a = Vector{Die}(undef, 3); rand!(a)\n3-element Vector{Die}:\n Die(19)\n Die(7)\n Die(17)","page":"Random Numbers"},{"title":"A simple sampler without pre-computed data","location":"stdlib/Random.html#A-simple-sampler-without-pre-computed-data","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Here we define a sampler for a collection. If no pre-computed data is required, it can be implemented with a SamplerTrivial sampler, which is in fact the default fallback for values.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"In order to define random generation out of objects of type S, the following method should be defined: rand(rng::AbstractRNG, sp::Random.SamplerTrivial{S}). Here, sp simply wraps an object of type S, which can be accessed via sp[]. Continuing the Die example, we want now to define rand(d::Die) to produce an Int corresponding to one of d's sides:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"julia> Random.rand(rng::AbstractRNG, d::Random.SamplerTrivial{Die}) = rand(rng, 1:d[].nsides);\n\njulia> rand(Die(4))\n1\n\njulia> rand(Die(4), 3)\n3-element Vector{Any}:\n 2\n 3\n 3","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Given a collection type S, it's currently assumed that if rand(::S) is defined, an object of type eltype(S) will be produced. In the last example, a Vector{Any} is produced; the reason is that eltype(Die) == Any. The remedy is to define Base.eltype(::Type{Die}) = Int.","page":"Random Numbers"},{"title":"Generating values for an AbstractFloat type","location":"stdlib/Random.html#Generating-values-for-an-AbstractFloat-type","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"AbstractFloat types are special-cased, because by default random values are not produced in the whole type domain, but rather in [0,1). The following method should be implemented for T <: AbstractFloat: Random.rand(::AbstractRNG, ::Random.SamplerTrivial{Random.CloseOpen01{T}})","page":"Random Numbers"},{"title":"An optimized sampler with pre-computed data","location":"stdlib/Random.html#An-optimized-sampler-with-pre-computed-data","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Consider a discrete distribution, where numbers 1:n are drawn with given probabilities that sum to one. When many values are needed from this distribution, the fastest method is using an alias table. We don't provide the algorithm for building such a table here, but suppose it is available in make_alias_table(probabilities) instead, and draw_number(rng, alias_table) can be used to draw a random number from it.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Suppose that the distribution is described by","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"struct DiscreteDistribution{V <: AbstractVector}\n    probabilities::V\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"and that we always want to build an alias table, regardless of the number of values needed (we learn how to customize this below). The methods","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Random.eltype(::Type{<:DiscreteDistribution}) = Int\n\nfunction Random.Sampler(::Type{<:AbstractRNG}, distribution::DiscreteDistribution, ::Repetition)\n    SamplerSimple(distribution, make_alias_table(distribution.probabilities))\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"should be defined to return a sampler with pre-computed data, then","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"function rand(rng::AbstractRNG, sp::SamplerSimple{<:DiscreteDistribution})\n    draw_number(rng, sp.data)\nend","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"will be used to draw the values.","page":"Random Numbers"},{"title":"Custom sampler types","location":"stdlib/Random.html#Custom-sampler-types","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The SamplerSimple type is sufficient for most use cases with precomputed data. However, in order to demonstrate how to use custom sampler types, here we implement something similar to SamplerSimple.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Going back to our Die example: rand(::Die) uses random generation from a range, so there is an opportunity for this optimization. We call our custom sampler SamplerDie.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"import Random: Sampler, rand\n\nstruct SamplerDie <: Sampler{Int} # generates values of type Int\n    die::Die\n    sp::Sampler{Int} # this is an abstract type, so this could be improved\nend\n\nSampler(RNG::Type{<:AbstractRNG}, die::Die, r::Random.Repetition) =\n    SamplerDie(die, Sampler(RNG, 1:die.nsides, r))\n# the `r` parameter will be explained later on\n\nrand(rng::AbstractRNG, sp::SamplerDie) = rand(rng, sp.sp)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"It's now possible to get a sampler with sp = Sampler(rng, die), and use sp instead of die in any rand call involving rng. In the simplistic example above, die doesn't need to be stored in SamplerDie but this is often the case in practice.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Of course, this pattern is so frequent that the helper type used above, namely Random.SamplerSimple, is available, saving us the definition of SamplerDie: we could have implemented our decoupling with:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Sampler(RNG::Type{<:AbstractRNG}, die::Die, r::Random.Repetition) =\n    SamplerSimple(die, Sampler(RNG, 1:die.nsides, r))\n\nrand(rng::AbstractRNG, sp::SamplerSimple{Die}) = rand(rng, sp.data)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Here, sp.data refers to the second parameter in the call to the SamplerSimple constructor (in this case equal to Sampler(rng, 1:die.nsides, r)), while the Die object can be accessed via sp[].","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Like SamplerDie, any custom sampler must be a subtype of Sampler{T} where T is the type of the generated values. Note that SamplerSimple(x, data) isa Sampler{eltype(x)}, so this constrains what the first argument to SamplerSimple can be (it's recommended to use SamplerSimple like in the Die example, where x is simply forwarded while defining a Sampler method). Similarly, SamplerTrivial(x) isa Sampler{eltype(x)}.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Another helper type is currently available for other cases, Random.SamplerTag, but is considered as internal API, and can break at any time without proper deprecations.","page":"Random Numbers"},{"title":"Using distinct algorithms for scalar or array generation","location":"stdlib/Random.html#Using-distinct-algorithms-for-scalar-or-array-generation","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"In some cases, whether one wants to generate only a handful of values or a large number of values will have an impact on the choice of algorithm. This is handled with the third parameter of the Sampler constructor. Let's assume we defined two helper types for Die, say SamplerDie1 which should be used to generate only few random values, and SamplerDieMany for many values. We can use those types as follows:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Sampler(RNG::Type{<:AbstractRNG}, die::Die, ::Val{1}) = SamplerDie1(...)\nSampler(RNG::Type{<:AbstractRNG}, die::Die, ::Val{Inf}) = SamplerDieMany(...)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Of course, rand must also be defined on those types (i.e. rand(::AbstractRNG, ::SamplerDie1) and rand(::AbstractRNG, ::SamplerDieMany)). Note that, as usual, SamplerTrivial and SamplerSimple can be used if custom types are not necessary.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Note: Sampler(rng, x) is simply a shorthand for Sampler(rng, x, Val(Inf)), and Random.Repetition is an alias for Union{Val{1}, Val{Inf}}.","page":"Random Numbers"},{"title":"Creating new generators","location":"stdlib/Random.html#Creating-new-generators","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The API is not clearly defined yet, but as a rule of thumb:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"any rand method producing \"basic\" types (isbitstype integer and floating types in Base) should be defined for this specific RNG, if they are needed;\nother documented rand methods accepting an AbstractRNG should work out of the box, (provided the methods from 1) what are relied on are implemented), but can of course be specialized for this RNG if there is room for optimization;\ncopy for pseudo-RNGs should return an independent copy that generates the exact same random sequence as the original from that point when called in the same way. When this is not feasible (e.g. hardware-based RNGs), copy must not be implemented.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Concerning 1), a rand method may happen to work automatically, but it's not officially supported and may break without warnings in a subsequent release.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"To define a new rand method for an hypothetical MyRNG generator, and a value specification s (e.g. s == Int, or s == 1:10) of type S==typeof(s) or S==Type{s} if s is a type, the same two methods as we saw before must be defined:","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Sampler(::Type{MyRNG}, ::S, ::Repetition), which returns an object of type say SamplerS\nrand(rng::MyRNG, sp::SamplerS)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"It can happen that Sampler(rng::AbstractRNG, ::S, ::Repetition) is already defined in the Random module. It would then be possible to skip step 1) in practice (if one wants to specialize generation for this particular RNG type), but the corresponding SamplerS type is considered as internal detail, and may be changed without warning.","page":"Random Numbers"},{"title":"Specializing array generation","location":"stdlib/Random.html#Specializing-array-generation","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"In some cases, for a given RNG type, generating an array of random values can be more efficient with a specialized method than by merely using the decoupling technique explained before. This is for example the case for MersenneTwister, which natively writes random values in an array.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"To implement this specialization for MyRNG and for a specification s, producing elements of type S, the following method can be defined: rand!(rng::MyRNG, a::AbstractArray{S}, ::SamplerS), where SamplerS is the type of the sampler returned by Sampler(MyRNG, s, Val(Inf)). Instead of AbstractArray, it's possible to implement the functionality only for a subtype, e.g. Array{S}. The non-mutating array method of rand will automatically call this specialization internally.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"DocTestSetup = nothing","page":"Random Numbers"},{"title":"Reproducibility","location":"stdlib/Random.html#Reproducibility","category":"section","text":"","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"By using an RNG parameter initialized with a given seed, you can reproduce the same pseudorandom number sequence when running your program multiple times. However, a minor release of Julia (e.g. 1.3 to 1.4) may change the sequence of pseudorandom numbers generated from a specific seed, in particular if MersenneTwister is used. (Even if the sequence produced by a low-level function like rand does not change, the output of higher-level functions like randsubseq may change due to algorithm updates.) Rationale: guaranteeing that pseudorandom streams never change prohibits many algorithmic improvements.","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"If you need to guarantee exact reproducibility of random data, it is advisable to simply save the data (e.g. as a supplementary attachment in a scientific publication). (You can also, of course, specify a particular Julia version and package manifest, especially if you require bit reproducibility.)","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"Software tests that rely on specific \"random\" data should also generally either save the data, embed it into the test code, or use third-party packages like StableRNGs.jl. On the other hand, tests that should pass for most random data (e.g. testing A \\ (A*x) ≈ x for a random matrix A = randn(n,n)) can use an RNG with a fixed seed to ensure that simply running the test many times does not encounter a failure due to very improbable data (e.g. an extremely ill-conditioned matrix).","page":"Random Numbers"},{"title":"Random Numbers","location":"stdlib/Random.html","category":"page","text":"The statistical distribution from which random samples are drawn is guaranteed to be the same across any minor Julia releases.","page":"Random Numbers"},{"title":"Arrays","location":"base/arrays.html#lib-arrays","category":"section","text":"","page":"Arrays"},{"title":"Constructors and Types","location":"base/arrays.html#Constructors-and-Types","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Core.AbstractArray\nBase.AbstractVector\nBase.AbstractMatrix\nBase.AbstractVecOrMat\nCore.Array\nCore.Array(::UndefInitializer, ::Any)\nCore.Array(::Nothing, ::Any)\nCore.Array(::Missing, ::Any)\nCore.UndefInitializer\nCore.undef\nBase.Vector\nBase.Vector(::UndefInitializer, ::Any)\nBase.Vector(::Nothing, ::Any)\nBase.Vector(::Missing, ::Any)\nBase.Matrix\nBase.Matrix(::UndefInitializer, ::Any, ::Any)\nBase.Matrix(::Nothing, ::Any, ::Any)\nBase.Matrix(::Missing, ::Any, ::Any)\nBase.VecOrMat\nCore.DenseArray\nBase.DenseVector\nBase.DenseMatrix\nBase.DenseVecOrMat\nBase.StridedArray\nBase.StridedVector\nBase.StridedMatrix\nBase.StridedVecOrMat\nBase.GenericMemory\nBase.Memory\nBase.memoryref\nBase.Slices\nBase.RowSlices\nBase.ColumnSlices\nBase.getindex(::Type, ::Any...)\nBase.zeros\nBase.ones\nBase.BitArray\nBase.BitArray(::UndefInitializer, ::Integer...)\nBase.BitArray(::Any)\nBase.trues\nBase.falses\nBase.fill\nBase.fill!\nBase.empty\nBase.similar","page":"Arrays"},{"title":"Core.AbstractArray","location":"base/arrays.html#Core.AbstractArray","category":"type","text":"AbstractArray{T,N}\n\nSupertype for N-dimensional arrays (or array-like types) with elements of type T. Array and other types are subtypes of this. See the manual section on the AbstractArray interface.\n\nSee also: AbstractVector, AbstractMatrix, eltype, ndims.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.AbstractVector","location":"base/arrays.html#Base.AbstractVector","category":"type","text":"AbstractVector{T}\n\nSupertype for one-dimensional arrays (or array-like types) with elements of type T. Alias for AbstractArray{T,1}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.AbstractMatrix","location":"base/arrays.html#Base.AbstractMatrix","category":"type","text":"AbstractMatrix{T}\n\nSupertype for two-dimensional arrays (or array-like types) with elements of type T. Alias for AbstractArray{T,2}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.AbstractVecOrMat","location":"base/arrays.html#Base.AbstractVecOrMat","category":"type","text":"AbstractVecOrMat{T}\n\nUnion type of AbstractVector{T} and AbstractMatrix{T}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array","category":"type","text":"Array{T,N} <: AbstractArray{T,N}\n\nN-dimensional dense array with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array-Tuple{UndefInitializer, Any}","category":"method","text":"Array{T}(undef, dims)\nArray{T,N}(undef, dims)\n\nConstruct an uninitialized N-dimensional Array containing elements of type T. N can either be supplied explicitly, as in Array{T,N}(undef, dims), or be determined by the length or number of dims. dims may be a tuple or a series of integer arguments corresponding to the lengths in each dimension. If the rank N is supplied explicitly, then it must match the length or number of dims. Here undef is the UndefInitializer.\n\nExamples\n\njulia> A = Array{Float64, 2}(undef, 2, 3) # N given explicitly\n2×3 Matrix{Float64}:\n 6.90198e-310  6.90198e-310  6.90198e-310\n 6.90198e-310  6.90198e-310  0.0\n\njulia> B = Array{Float64}(undef, 4) # N determined by the input\n4-element Vector{Float64}:\n   2.360075077e-314\n NaN\n   2.2671131793e-314\n   2.299821756e-314\n\njulia> similar(B, 2, 4, 1) # use typeof(B), and the given size\n2×4×1 Array{Float64, 3}:\n[:, :, 1] =\n 2.26703e-314  2.26708e-314  0.0           2.80997e-314\n 0.0           2.26703e-314  2.26708e-314  0.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array-Tuple{Nothing, Any}","category":"method","text":"Array{T}(nothing, dims)\nArray{T,N}(nothing, dims)\n\nConstruct an N-dimensional Array containing elements of type T, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Array{Union{Nothing, String}}(nothing, 2)\n2-element Vector{Union{Nothing, String}}:\n nothing\n nothing\n\njulia> Array{Union{Nothing, Int}}(nothing, 2, 3)\n2×3 Matrix{Union{Nothing, Int64}}:\n nothing  nothing  nothing\n nothing  nothing  nothing\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Array","location":"base/arrays.html#Core.Array-Tuple{Missing, Any}","category":"method","text":"Array{T}(missing, dims)\nArray{T,N}(missing, dims)\n\nConstruct an N-dimensional Array containing elements of type T, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Array{Union{Missing, String}}(missing, 2)\n2-element Vector{Union{Missing, String}}:\n missing\n missing\n\njulia> Array{Union{Missing, Int}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, Int64}}:\n missing  missing  missing\n missing  missing  missing\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.UndefInitializer","location":"base/arrays.html#Core.UndefInitializer","category":"type","text":"UndefInitializer\n\nSingleton type used in array initialization, indicating the array-constructor-caller would like an uninitialized array. See also undef, an alias for UndefInitializer().\n\nExamples\n\njulia> Array{Float64, 1}(UndefInitializer(), 3)\n3-element Array{Float64, 1}:\n 2.2752528595e-314\n 2.202942107e-314\n 2.275252907e-314\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.undef","location":"base/arrays.html#Core.undef","category":"constant","text":"undef\n\nAlias for UndefInitializer(), which constructs an instance of the singleton type UndefInitializer, used in array initialization to indicate the array-constructor-caller would like an uninitialized array.\n\nSee also: missing, similar.\n\nExamples\n\njulia> Array{Float64, 1}(undef, 3)\n3-element Vector{Float64}:\n 2.2752528595e-314\n 2.202942107e-314\n 2.275252907e-314\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector","category":"type","text":"Vector{T} <: AbstractVector{T}\n\nOne-dimensional dense array with elements of type T, often used to represent a mathematical vector. Alias for Array{T,1}.\n\nSee also empty, similar and zero for creating vectors.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector-Tuple{UndefInitializer, Any}","category":"method","text":"Vector{T}(undef, n)\n\nConstruct an uninitialized Vector{T} of length n.\n\nExamples\n\njulia> Vector{Float64}(undef, 3)\n3-element Array{Float64, 1}:\n 6.90966e-310\n 6.90966e-310\n 6.90966e-310\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector-Tuple{Nothing, Any}","category":"method","text":"Vector{T}(nothing, m)\n\nConstruct a Vector{T} of length m, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Vector{Union{Nothing, String}}(nothing, 2)\n2-element Vector{Union{Nothing, String}}:\n nothing\n nothing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Vector","location":"base/arrays.html#Base.Vector-Tuple{Missing, Any}","category":"method","text":"Vector{T}(missing, m)\n\nConstruct a Vector{T} of length m, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Vector{Union{Missing, String}}(missing, 2)\n2-element Vector{Union{Missing, String}}:\n missing\n missing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix","category":"type","text":"Matrix{T} <: AbstractMatrix{T}\n\nTwo-dimensional dense array with elements of type T, often used to represent a mathematical matrix. Alias for Array{T,2}.\n\nSee also fill, zeros, undef and similar for creating matrices.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix-Tuple{UndefInitializer, Any, Any}","category":"method","text":"Matrix{T}(undef, m, n)\n\nConstruct an uninitialized Matrix{T} of size m×n.\n\nExamples\n\njulia> Matrix{Float64}(undef, 2, 3)\n2×3 Array{Float64, 2}:\n 2.36365e-314  2.28473e-314    5.0e-324\n 2.26704e-314  2.26711e-314  NaN\n\njulia> similar(ans, Int32, 2, 2)\n2×2 Matrix{Int32}:\n 490537216  1277177453\n         1  1936748399\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix-Tuple{Nothing, Any, Any}","category":"method","text":"Matrix{T}(nothing, m, n)\n\nConstruct a Matrix{T} of size m×n, initialized with nothing entries. Element type T must be able to hold these values, i.e. Nothing <: T.\n\nExamples\n\njulia> Matrix{Union{Nothing, String}}(nothing, 2, 3)\n2×3 Matrix{Union{Nothing, String}}:\n nothing  nothing  nothing\n nothing  nothing  nothing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Matrix","location":"base/arrays.html#Base.Matrix-Tuple{Missing, Any, Any}","category":"method","text":"Matrix{T}(missing, m, n)\n\nConstruct a Matrix{T} of size m×n, initialized with missing entries. Element type T must be able to hold these values, i.e. Missing <: T.\n\nExamples\n\njulia> Matrix{Union{Missing, String}}(missing, 2, 3)\n2×3 Matrix{Union{Missing, String}}:\n missing  missing  missing\n missing  missing  missing\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.VecOrMat","location":"base/arrays.html#Base.VecOrMat","category":"type","text":"VecOrMat{T}\n\nUnion type of Vector{T} and Matrix{T} which allows functions to accept either a Matrix or a Vector.\n\nExamples\n\njulia> Vector{Float64} <: VecOrMat{Float64}\ntrue\n\njulia> Matrix{Float64} <: VecOrMat{Float64}\ntrue\n\njulia> Array{Float64, 3} <: VecOrMat{Float64}\nfalse\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.DenseArray","location":"base/arrays.html#Core.DenseArray","category":"type","text":"DenseArray{T, N} <: AbstractArray{T,N}\n\nN-dimensional dense array with elements of type T. The elements of a dense array are stored contiguously in memory.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.DenseVector","location":"base/arrays.html#Base.DenseVector","category":"type","text":"DenseVector{T}\n\nOne-dimensional DenseArray with elements of type T. Alias for DenseArray{T,1}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.DenseMatrix","location":"base/arrays.html#Base.DenseMatrix","category":"type","text":"DenseMatrix{T}\n\nTwo-dimensional DenseArray with elements of type T. Alias for DenseArray{T,2}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.DenseVecOrMat","location":"base/arrays.html#Base.DenseVecOrMat","category":"type","text":"DenseVecOrMat{T}\n\nUnion type of DenseVector{T} and DenseMatrix{T}.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedArray","location":"base/arrays.html#Base.StridedArray","category":"type","text":"StridedArray{T, N}\n\nA hard-coded Union of common array types that follow the strided array interface, with elements of type T and N dimensions.\n\nIf A is a StridedArray, then its elements are stored in memory with offsets, which may vary between dimensions but are constant within a dimension. For example, A could have stride 2 in dimension 1, and stride 3 in dimension 2. Incrementing A along dimension d jumps in memory by [stride(A, d)] slots. Strided arrays are particularly important and useful because they can sometimes be passed directly as pointers to foreign language libraries like BLAS.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedVector","location":"base/arrays.html#Base.StridedVector","category":"type","text":"StridedVector{T}\n\nOne dimensional StridedArray with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedMatrix","location":"base/arrays.html#Base.StridedMatrix","category":"type","text":"StridedMatrix{T}\n\nTwo dimensional StridedArray with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.StridedVecOrMat","location":"base/arrays.html#Base.StridedVecOrMat","category":"type","text":"StridedVecOrMat{T}\n\nUnion type of StridedVector and StridedMatrix with elements of type T.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.GenericMemory","location":"base/arrays.html#Core.GenericMemory","category":"type","text":"GenericMemory{kind::Symbol, T, addrspace=Core.CPU} <: DenseVector{T}\n\nFixed-size DenseVector{T}.\n\nkind can currently be either :not_atomic or :atomic. For details on what :atomic implies, see AtomicMemory\n\naddrspace can currently only be set to Core.CPU. It is designed to  to permit extension by other systems such as GPUs, which might define values such as:\n\nmodule CUDA\nconst Generic = bitcast(Core.AddrSpace{CUDA}, 0)\nconst Global = bitcast(Core.AddrSpace{CUDA}, 1)\nend\n\nThe exact semantics of these other addrspaces is defined by the specific backend, but will error if the user is attempting to access these on the CPU.\n\ncompat: Julia 1.11\nThis type requires Julia 1.11 or later.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.Memory","location":"base/arrays.html#Core.Memory","category":"type","text":"Memory{T} == GenericMemory{:not_atomic, T, Core.CPU}\n\nFixed-size DenseVector{T}.\n\ncompat: Julia 1.11\nThis type requires Julia 1.11 or later.\n\n\n\n\n\n","page":"Arrays"},{"title":"Core.memoryref","location":"base/arrays.html#Core.memoryref","category":"function","text":"`memoryref(::GenericMemory)`\n\nConstruct a GenericMemoryRef from a memory object. This does not fail, but the resulting memory will point out-of-bounds if and only if the memory is empty.\n\n\n\n\n\nmemoryref(::GenericMemory, index::Integer)\nmemoryref(::GenericMemoryRef, index::Integer)\n\nConstruct a GenericMemoryRef from a memory object and an offset index (1-based) which can also be negative. This always returns an inbounds object, and will throw an error if that is not possible (because the index would result in a shift out-of-bounds of the underlying memory).\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Slices","location":"base/arrays.html#Base.Slices","category":"type","text":"Slices{P,SM,AX,S,N} <: AbstractSlices{S,N}\n\nAn AbstractArray of slices into a parent array over specified dimension(s), returning views that select all the data from the other dimension(s).\n\nThese should typically be constructed by eachslice, eachcol or eachrow.\n\nparent(s::Slices) will return the parent array.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.RowSlices","location":"base/arrays.html#Base.RowSlices","category":"type","text":"RowSlices{M,AX,S}\n\nA special case of Slices that is a vector of row slices of a matrix, as constructed by eachrow.\n\nparent can be used to get the underlying matrix.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.ColumnSlices","location":"base/arrays.html#Base.ColumnSlices","category":"type","text":"ColumnSlices{M,AX,S}\n\nA special case of Slices that is a vector of column slices of a matrix, as constructed by eachcol.\n\nparent can be used to get the underlying matrix.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.getindex","location":"base/arrays.html#Base.getindex-Tuple{Type, Vararg{Any}}","category":"method","text":"getindex(type[, elements...])\n\nConstruct a 1-d array of the specified type. This is usually called with the syntax Type[]. Element values can be specified using Type[a,b,c,...].\n\nExamples\n\njulia> Int8[1, 2, 3]\n3-element Vector{Int8}:\n 1\n 2\n 3\n\njulia> getindex(Int8, 1, 2, 3)\n3-element Vector{Int8}:\n 1\n 2\n 3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.zeros","location":"base/arrays.html#Base.zeros","category":"function","text":"zeros([T=Float64,] dims::Tuple)\nzeros([T=Float64,] dims...)\n\nCreate an Array, with element type T, of all zeros with size specified by dims. See also fill, ones, zero.\n\nExamples\n\njulia> zeros(1)\n1-element Vector{Float64}:\n 0.0\n\njulia> zeros(Int8, 2, 3)\n2×3 Matrix{Int8}:\n 0  0  0\n 0  0  0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.ones","location":"base/arrays.html#Base.ones","category":"function","text":"ones([T=Float64,] dims::Tuple)\nones([T=Float64,] dims...)\n\nCreate an Array, with element type T, of all ones with size specified by dims. See also fill, zeros.\n\nExamples\n\njulia> ones(1,2)\n1×2 Matrix{Float64}:\n 1.0  1.0\n\njulia> ones(ComplexF64, 2, 3)\n2×3 Matrix{ComplexF64}:\n 1.0+0.0im  1.0+0.0im  1.0+0.0im\n 1.0+0.0im  1.0+0.0im  1.0+0.0im\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.BitArray","location":"base/arrays.html#Base.BitArray","category":"type","text":"BitArray{N} <: AbstractArray{Bool, N}\n\nSpace-efficient N-dimensional boolean array, using just one bit for each boolean value.\n\nBitArrays pack up to 64 values into every 8 bytes, resulting in an 8x space efficiency over Array{Bool, N} and allowing some operations to work on 64 values at once.\n\nBy default, Julia returns BitArrays from broadcasting operations that generate boolean elements (including dotted-comparisons like .==) as well as from the functions trues and falses.\n\nnote: Note\nDue to its packed storage format, concurrent access to the elements of a BitArray where at least one of them is a write is not thread-safe.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.BitArray","location":"base/arrays.html#Base.BitArray-Tuple{UndefInitializer, Vararg{Integer}}","category":"method","text":"BitArray(undef, dims::Integer...)\nBitArray{N}(undef, dims::NTuple{N,Int})\n\nConstruct an undef BitArray with the given dimensions. Behaves identically to the Array constructor. See undef.\n\nExamples\n\njulia> BitArray(undef, 2, 2)\n2×2 BitMatrix:\n 0  0\n 0  0\n\njulia> BitArray(undef, (3, 1))\n3×1 BitMatrix:\n 0\n 0\n 0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.BitArray","location":"base/arrays.html#Base.BitArray-Tuple{Any}","category":"method","text":"BitArray(itr)\n\nConstruct a BitArray generated by the given iterable object. The shape is inferred from the itr object.\n\nExamples\n\njulia> BitArray([1 0; 0 1])\n2×2 BitMatrix:\n 1  0\n 0  1\n\njulia> BitArray(x+y == 3 for x = 1:2, y = 1:3)\n2×3 BitMatrix:\n 0  1  0\n 1  0  0\n\njulia> BitArray(x+y == 3 for x = 1:2 for y = 1:3)\n6-element BitVector:\n 0\n 1\n 0\n 1\n 0\n 0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.trues","location":"base/arrays.html#Base.trues","category":"function","text":"trues(dims)\n\nCreate a BitArray with all values set to true.\n\nExamples\n\njulia> trues(2,3)\n2×3 BitMatrix:\n 1  1  1\n 1  1  1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.falses","location":"base/arrays.html#Base.falses","category":"function","text":"falses(dims)\n\nCreate a BitArray with all values set to false.\n\nExamples\n\njulia> falses(2,3)\n2×3 BitMatrix:\n 0  0  0\n 0  0  0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.fill","location":"base/arrays.html#Base.fill","category":"function","text":"fill(value, dims::Tuple)\nfill(value, dims...)\n\nCreate an array of size dims with every location set to value.\n\nFor example, fill(1.0, (5,5)) returns a 5×5 array of floats, with 1.0 in every location of the array.\n\nThe dimension lengths dims may be specified as either a tuple or a sequence of arguments. An N-length tuple or N arguments following the value specify an N-dimensional array. Thus, a common idiom for creating a zero-dimensional array with its only location set to x is fill(x).\n\nEvery location of the returned array is set to (and is thus === to) the value that was passed; this means that if the value is itself modified, all elements of the filled array will reflect that modification because they're still that very value. This is of no concern with fill(1.0, (5,5)) as the value 1.0 is immutable and cannot itself be modified, but can be unexpected with mutable values like — most commonly — arrays.  For example, fill([], 3) places the very same empty array in all three locations of the returned vector:\n\njulia> v = fill([], 3)\n3-element Vector{Vector{Any}}:\n []\n []\n []\n\njulia> v[1] === v[2] === v[3]\ntrue\n\njulia> value = v[1]\nAny[]\n\njulia> push!(value, 867_5309)\n1-element Vector{Any}:\n 8675309\n\njulia> v\n3-element Vector{Vector{Any}}:\n [8675309]\n [8675309]\n [8675309]\n\nTo create an array of many independent inner arrays, use a comprehension instead. This creates a new and distinct array on each iteration of the loop:\n\njulia> v2 = [[] for _ in 1:3]\n3-element Vector{Vector{Any}}:\n []\n []\n []\n\njulia> v2[1] === v2[2] === v2[3]\nfalse\n\njulia> push!(v2[1], 8675309)\n1-element Vector{Any}:\n 8675309\n\njulia> v2\n3-element Vector{Vector{Any}}:\n [8675309]\n []\n []\n\nSee also: fill!, zeros, ones, similar.\n\nExamples\n\njulia> fill(1.0, (2,3))\n2×3 Matrix{Float64}:\n 1.0  1.0  1.0\n 1.0  1.0  1.0\n\njulia> fill(42)\n0-dimensional Array{Int64, 0}:\n42\n\njulia> A = fill(zeros(2), 2) # sets both elements to the same [0.0, 0.0] vector\n2-element Vector{Vector{Float64}}:\n [0.0, 0.0]\n [0.0, 0.0]\n\njulia> A[1][1] = 42; # modifies the filled value to be [42.0, 0.0]\n\njulia> A # both A[1] and A[2] are the very same vector\n2-element Vector{Vector{Float64}}:\n [42.0, 0.0]\n [42.0, 0.0]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.fill!","location":"base/arrays.html#Base.fill!","category":"function","text":"fill!(A, x)\n\nFill array A with the value x. If x is an object reference, all elements will refer to the same object. fill!(A, Foo()) will return A filled with the result of evaluating Foo() once.\n\nExamples\n\njulia> A = zeros(2,3)\n2×3 Matrix{Float64}:\n 0.0  0.0  0.0\n 0.0  0.0  0.0\n\njulia> fill!(A, 2.)\n2×3 Matrix{Float64}:\n 2.0  2.0  2.0\n 2.0  2.0  2.0\n\njulia> a = [1, 1, 1]; A = fill!(Vector{Vector{Int}}(undef, 3), a); a[1] = 2; A\n3-element Vector{Vector{Int64}}:\n [2, 1, 1]\n [2, 1, 1]\n [2, 1, 1]\n\njulia> x = 0; f() = (global x += 1; x); fill!(Vector{Int}(undef, 3), f())\n3-element Vector{Int64}:\n 1\n 1\n 1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.empty","location":"base/arrays.html#Base.empty","category":"function","text":"empty(x::Tuple)\n\nReturn an empty tuple, ().\n\n\n\n\n\nempty(v::AbstractVector, [eltype])\n\nCreate an empty vector similar to v, optionally changing the eltype.\n\nSee also: empty!, isempty, isassigned.\n\nExamples\n\njulia> empty([1.0, 2.0, 3.0])\nFloat64[]\n\njulia> empty([1.0, 2.0, 3.0], String)\nString[]\n\n\n\n\n\nempty(a::AbstractDict, [index_type=keytype(a)], [value_type=valtype(a)])\n\nCreate an empty AbstractDict container which can accept indices of type index_type and values of type value_type. The second and third arguments are optional and default to the input's keytype and valtype, respectively. (If only one of the two types is specified, it is assumed to be the value_type, and the index_type we default to keytype(a)).\n\nCustom AbstractDict subtypes may choose which specific dictionary type is best suited to return for the given index and value types, by specializing on the three-argument signature. The default is to return an empty Dict.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.similar","location":"base/arrays.html#Base.similar","category":"function","text":"similar(array, [element_type=eltype(array)], [dims=size(array)])\n\nCreate an uninitialized mutable array with the given element type and size, based upon the given source array. The second and third arguments are both optional, defaulting to the given array's eltype and size. The dimensions may be specified either as a single tuple argument or as a series of integer arguments.\n\nCustom AbstractArray subtypes may choose which specific array type is best-suited to return for the given element type and dimensionality. If they do not specialize this method, the default is an Array{element_type}(undef, dims...).\n\nFor example, similar(1:10, 1, 4) returns an uninitialized Array{Int,2} since ranges are neither mutable nor support 2 dimensions:\n\njulia> similar(1:10, 1, 4)\n1×4 Matrix{Int64}:\n 4419743872  4374413872  4419743888  0\n\nConversely, similar(trues(10,10), 2) returns an uninitialized BitVector with two elements since BitArrays are both mutable and can support 1-dimensional arrays:\n\njulia> similar(trues(10,10), 2)\n2-element BitVector:\n 0\n 0\n\nSince BitArrays can only store elements of type Bool, however, if you request a different element type it will create a regular Array instead:\n\njulia> similar(falses(10), Float64, 2, 4)\n2×4 Matrix{Float64}:\n 2.18425e-314  2.18425e-314  2.18425e-314  2.18425e-314\n 2.18425e-314  2.18425e-314  2.18425e-314  2.18425e-314\n\nSee also: undef, isassigned.\n\n\n\n\n\nsimilar(storagetype, axes)\n\nCreate an uninitialized mutable array analogous to that specified by storagetype, but with axes specified by the last argument.\n\nExamples:\n\nsimilar(Array{Int}, axes(A))\n\ncreates an array that \"acts like\" an Array{Int} (and might indeed be backed by one), but which is indexed identically to A. If A has conventional indexing, this will be identical to Array{Int}(undef, size(A)), but if A has unconventional indexing then the indices of the result will match A.\n\nsimilar(BitArray, (axes(A, 2),))\n\nwould create a 1-dimensional logical array whose indices match those of the columns of A.\n\n\n\n\n\nsimilar(A::AbstractSparseMatrixCSC{Tv,Ti}, [::Type{TvNew}, ::Type{TiNew}, m::Integer, n::Integer]) where {Tv,Ti}\n\nCreate an uninitialized mutable array with the given element type, index type, and size, based upon the given source SparseMatrixCSC. The new sparse matrix maintains the structure of the original sparse matrix, except in the case where dimensions of the output matrix are different from the output.\n\nThe output matrix has zeros in the same locations as the input, but uninitialized values for the nonzero locations.\n\n\n\n\n\n","page":"Arrays"},{"title":"Basic functions","location":"base/arrays.html#Basic-functions","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.ndims\nBase.size\nBase.axes(::Any)\nBase.axes(::AbstractArray, ::Any)\nBase.length(::AbstractArray)\nBase.keys(::AbstractArray)\nBase.eachindex\nBase.IndexStyle\nBase.IndexLinear\nBase.IndexCartesian\nBase.conj!\nBase.stride\nBase.strides","page":"Arrays"},{"title":"Base.ndims","location":"base/arrays.html#Base.ndims","category":"function","text":"ndims(A::AbstractArray) -> Integer\n\nReturn the number of dimensions of A.\n\nSee also: size, axes.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> ndims(A)\n3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.size","location":"base/arrays.html#Base.size","category":"function","text":"size(A::AbstractArray, [dim])\n\nReturn a tuple containing the dimensions of A. Optionally you can specify a dimension to just get the length of that dimension.\n\nNote that size may not be defined for arrays with non-standard indices, in which case axes may be useful. See the manual chapter on arrays with custom indices.\n\nSee also: length, ndims, eachindex, sizeof.\n\nExamples\n\njulia> A = fill(1, (2,3,4));\n\njulia> size(A)\n(2, 3, 4)\n\njulia> size(A, 2)\n3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.axes","location":"base/arrays.html#Base.axes-Tuple{Any}","category":"method","text":"axes(A)\n\nReturn the tuple of valid indices for array A.\n\nSee also: size, keys, eachindex.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> axes(A)\n(Base.OneTo(5), Base.OneTo(6), Base.OneTo(7))\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.axes","location":"base/arrays.html#Base.axes-Tuple{AbstractArray, Any}","category":"method","text":"axes(A, d)\n\nReturn the valid range of indices for array A along dimension d.\n\nSee also size, and the manual chapter on arrays with custom indices.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> axes(A, 2)\nBase.OneTo(6)\n\njulia> axes(A, 4) == 1:1  # all dimensions d > ndims(A) have size 1\ntrue\n\nUsage note\n\nEach of the indices has to be an AbstractUnitRange{<:Integer}, but at the same time can be a type that uses custom indices. So, for example, if you need a subset, use generalized indexing constructs like begin/end or firstindex/lastindex:\n\nix = axes(v, 1)\nix[2:end]          # will work for eg Vector, but may fail in general\nix[(begin+1):end]  # works for generalized indexes\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.length","location":"base/arrays.html#Base.length-Tuple{AbstractArray}","category":"method","text":"length(A::AbstractArray)\n\nReturn the number of elements in the array, defaults to prod(size(A)).\n\nExamples\n\njulia> length([1, 2, 3, 4])\n4\n\njulia> length([1 2; 3 4])\n4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.keys","location":"base/arrays.html#Base.keys-Tuple{AbstractArray}","category":"method","text":"keys(a::AbstractArray)\n\nReturn an efficient array describing all valid indices for a arranged in the shape of a itself.\n\nThe keys of 1-dimensional arrays (vectors) are integers, whereas all other N-dimensional arrays use CartesianIndex to describe their locations.  Often the special array types LinearIndices and CartesianIndices are used to efficiently represent these arrays of integers and CartesianIndexes, respectively.\n\nNote that the keys of an array might not be the most efficient index type; for maximum performance use  eachindex instead.\n\nExamples\n\njulia> keys([4, 5, 6])\n3-element LinearIndices{1, Tuple{Base.OneTo{Int64}}}:\n 1\n 2\n 3\n\njulia> keys([4 5; 6 7])\nCartesianIndices((2, 2))\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachindex","location":"base/arrays.html#Base.eachindex","category":"function","text":"eachindex(A...)\neachindex(::IndexStyle, A::AbstractArray...)\n\nCreate an iterable object for visiting each index of an AbstractArray A in an efficient manner. For array types that have opted into fast linear indexing (like Array), this is simply the range 1:length(A) if they use 1-based indexing. For array types that have not opted into fast linear indexing, a specialized Cartesian range is typically returned to efficiently index into the array with indices specified for every dimension.\n\nIn general eachindex accepts arbitrary iterables, including strings and dictionaries, and returns an iterator object supporting arbitrary index types (e.g. unevenly spaced or non-integer indices).\n\nIf A is AbstractArray it is possible to explicitly specify the style of the indices that should be returned by eachindex by passing a value having IndexStyle type as its first argument (typically IndexLinear() if linear indices are required or IndexCartesian() if Cartesian range is wanted).\n\nIf you supply more than one AbstractArray argument, eachindex will create an iterable object that is fast for all arguments (typically a UnitRange if all inputs have fast linear indexing, a CartesianIndices otherwise). If the arrays have different sizes and/or dimensionalities, a DimensionMismatch exception will be thrown.\n\nSee also pairs(A) to iterate over indices and values together, and axes(A, 2) for valid indices along one dimension.\n\nExamples\n\njulia> A = [10 20; 30 40];\n\njulia> for i in eachindex(A) # linear indexing\n           println(\"A[\", i, \"] == \", A[i])\n       end\nA[1] == 10\nA[2] == 30\nA[3] == 20\nA[4] == 40\n\njulia> for i in eachindex(view(A, 1:2, 1:1)) # Cartesian indexing\n           println(i)\n       end\nCartesianIndex(1, 1)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IndexStyle","location":"base/arrays.html#Base.IndexStyle","category":"type","text":"IndexStyle(A)\nIndexStyle(typeof(A))\n\nIndexStyle specifies the \"native indexing style\" for array A. When you define a new AbstractArray type, you can choose to implement either linear indexing (with IndexLinear) or cartesian indexing. If you decide to only implement linear indexing, then you must set this trait for your array type:\n\nBase.IndexStyle(::Type{<:MyArray}) = IndexLinear()\n\nThe default is IndexCartesian().\n\nJulia's internal indexing machinery will automatically (and invisibly) recompute all indexing operations into the preferred style. This allows users to access elements of your array using any indexing style, even when explicit methods have not been provided.\n\nIf you define both styles of indexing for your AbstractArray, this trait can be used to select the most performant indexing style. Some methods check this trait on their inputs, and dispatch to different algorithms depending on the most efficient access pattern. In particular, eachindex creates an iterator whose type depends on the setting of this trait.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IndexLinear","location":"base/arrays.html#Base.IndexLinear","category":"type","text":"IndexLinear()\n\nSubtype of IndexStyle used to describe arrays which are optimally indexed by one linear index.\n\nA linear indexing style uses one integer index to describe the position in the array (even if it's a multidimensional array) and column-major ordering is used to efficiently access the elements. This means that requesting eachindex from an array that is IndexLinear will return a simple one-dimensional range, even if it is multidimensional.\n\nA custom array that reports its IndexStyle as IndexLinear only needs to implement indexing (and indexed assignment) with a single Int index; all other indexing expressions — including multidimensional accesses — will be recomputed to the linear index.  For example, if A were a 2×3 custom matrix with linear indexing, and we referenced A[1, 3], this would be recomputed to the equivalent linear index and call A[5] since 1 + 2*(3 - 1) = 5.\n\nSee also IndexCartesian.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IndexCartesian","location":"base/arrays.html#Base.IndexCartesian","category":"type","text":"IndexCartesian()\n\nSubtype of IndexStyle used to describe arrays which are optimally indexed by a Cartesian index. This is the default for new custom AbstractArray subtypes.\n\nA Cartesian indexing style uses multiple integer indices to describe the position in a multidimensional array, with exactly one index per dimension. This means that requesting eachindex from an array that is IndexCartesian will return a range of CartesianIndices.\n\nA N-dimensional custom array that reports its IndexStyle as IndexCartesian needs to implement indexing (and indexed assignment) with exactly N Int indices; all other indexing expressions — including linear indexing — will be recomputed to the equivalent Cartesian location.  For example, if A were a 2×3 custom matrix with cartesian indexing, and we referenced A[5], this would be recomputed to the equivalent Cartesian index and call A[1, 3] since 5 = 1 + 2*(3 - 1).\n\nIt is significantly more expensive to compute Cartesian indices from a linear index than it is to go the other way.  The former operation requires division — a very costly operation — whereas the latter only uses multiplication and addition and is essentially free. This asymmetry means it is far more costly to use linear indexing with an IndexCartesian array than it is to use Cartesian indexing with an IndexLinear array.\n\nSee also IndexLinear.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.conj!","location":"base/arrays.html#Base.conj!","category":"function","text":"conj!(A)\n\nTransform an array to its complex conjugate in-place.\n\nSee also conj.\n\nExamples\n\njulia> A = [1+im 2-im; 2+2im 3+im]\n2×2 Matrix{Complex{Int64}}:\n 1+1im  2-1im\n 2+2im  3+1im\n\njulia> conj!(A);\n\njulia> A\n2×2 Matrix{Complex{Int64}}:\n 1-1im  2+1im\n 2-2im  3-1im\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.stride","location":"base/arrays.html#Base.stride","category":"function","text":"stride(A, k::Integer)\n\nReturn the distance in memory (in number of elements) between adjacent elements in dimension k.\n\nSee also: strides.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> stride(A,2)\n3\n\njulia> stride(A,3)\n12\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.strides","location":"base/arrays.html#Base.strides","category":"function","text":"strides(A)\n\nReturn a tuple of the memory strides in each dimension.\n\nSee also: stride.\n\nExamples\n\njulia> A = fill(1, (3,4,5));\n\njulia> strides(A)\n(1, 3, 12)\n\n\n\n\n\n","page":"Arrays"},{"title":"Broadcast and vectorization","location":"base/arrays.html#Broadcast-and-vectorization","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"See also the dot syntax for vectorizing functions; for example, f.(args...) implicitly calls broadcast(f, args...). Rather than relying on \"vectorized\" methods of functions like sin to operate on arrays, you should use sin.(a) to vectorize via broadcast.","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.broadcast\nBase.Broadcast.broadcast!\nBase.@__dot__","page":"Arrays"},{"title":"Base.Broadcast.broadcast","location":"base/arrays.html#Base.Broadcast.broadcast","category":"function","text":"broadcast(f, As...)\n\nBroadcast the function f over the arrays, tuples, collections, Refs and/or scalars As.\n\nBroadcasting applies the function f over the elements of the container arguments and the scalars themselves in As. Singleton and missing dimensions are expanded to match the extents of the other arguments by virtually repeating the value. By default, only a limited number of types are considered scalars, including Numbers, Strings, Symbols, Types, Functions and some common singletons like missing and nothing. All other arguments are iterated over or indexed into elementwise.\n\nThe resulting container type is established by the following rules:\n\nIf all the arguments are scalars or zero-dimensional arrays, it returns an unwrapped scalar.\nIf at least one argument is a tuple and all others are scalars or zero-dimensional arrays, it returns a tuple.\nAll other combinations of arguments default to returning an Array, but custom container types can define their own implementation and promotion-like rules to customize the result when they appear as arguments.\n\nA special syntax exists for broadcasting: f.(args...) is equivalent to broadcast(f, args...), and nested f.(g.(args...)) calls are fused into a single broadcast loop.\n\nExamples\n\njulia> A = [1, 2, 3, 4, 5]\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> B = [1 2; 3 4; 5 6; 7 8; 9 10]\n5×2 Matrix{Int64}:\n 1   2\n 3   4\n 5   6\n 7   8\n 9  10\n\njulia> broadcast(+, A, B)\n5×2 Matrix{Int64}:\n  2   3\n  5   6\n  8   9\n 11  12\n 14  15\n\njulia> parse.(Int, [\"1\", \"2\"])\n2-element Vector{Int64}:\n 1\n 2\n\njulia> abs.((1, -2))\n(1, 2)\n\njulia> broadcast(+, 1.0, (0, -2.0))\n(1.0, -1.0)\n\njulia> (+).([[0,2], [1,3]], Ref{Vector{Int}}([1,-1]))\n2-element Vector{Vector{Int64}}:\n [1, 1]\n [2, 2]\n\njulia> string.((\"one\",\"two\",\"three\",\"four\"), \": \", 1:4)\n4-element Vector{String}:\n \"one: 1\"\n \"two: 2\"\n \"three: 3\"\n \"four: 4\"\n\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.broadcast!","location":"base/arrays.html#Base.Broadcast.broadcast!","category":"function","text":"broadcast!(f, dest, As...)\n\nLike broadcast, but store the result of broadcast(f, As...) in the dest array. Note that dest is only used to store the result, and does not supply arguments to f unless it is also listed in the As, as in broadcast!(f, A, A, B) to perform A[:] = broadcast(f, A, B).\n\nExamples\n\njulia> A = [1.0; 0.0]; B = [0.0; 0.0];\n\njulia> broadcast!(+, B, A, (0, -2.0));\n\njulia> B\n2-element Vector{Float64}:\n  1.0\n -2.0\n\njulia> A\n2-element Vector{Float64}:\n 1.0\n 0.0\n\njulia> broadcast!(+, A, A, (0, -2.0));\n\njulia> A\n2-element Vector{Float64}:\n  1.0\n -2.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.@__dot__","location":"base/arrays.html#Base.Broadcast.@__dot__","category":"macro","text":"@. expr\n\nConvert every function call or operator in expr into a \"dot call\" (e.g. convert f(x) to f.(x)), and convert every assignment in expr to a \"dot assignment\" (e.g. convert += to .+=).\n\nIf you want to avoid adding dots for selected function calls in expr, splice those function calls in with $.  For example, @. sqrt(abs($sort(x))) is equivalent to sqrt.(abs.(sort(x))) (no dot for sort).\n\n(@. is equivalent to a call to @__dot__.)\n\nExamples\n\njulia> x = 1.0:3.0; y = similar(x);\n\njulia> @. y = x + 3 * sin(x)\n3-element Vector{Float64}:\n 3.5244129544236893\n 4.727892280477045\n 3.4233600241796016\n\n\n\n\n\n","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"For specializing broadcast on custom types, see","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.BroadcastStyle\nBase.Broadcast.AbstractArrayStyle\nBase.Broadcast.ArrayStyle\nBase.Broadcast.DefaultArrayStyle\nBase.Broadcast.broadcastable\nBase.Broadcast.combine_axes\nBase.Broadcast.combine_styles\nBase.Broadcast.result_style","page":"Arrays"},{"title":"Base.Broadcast.BroadcastStyle","location":"base/arrays.html#Base.Broadcast.BroadcastStyle","category":"type","text":"BroadcastStyle is an abstract type and trait-function used to determine behavior of objects under broadcasting. BroadcastStyle(typeof(x)) returns the style associated with x. To customize the broadcasting behavior of a type, one can declare a style by defining a type/method pair\n\nstruct MyContainerStyle <: BroadcastStyle end\nBase.BroadcastStyle(::Type{<:MyContainer}) = MyContainerStyle()\n\nOne then writes method(s) (at least similar) operating on Broadcasted{MyContainerStyle}. There are also several pre-defined subtypes of BroadcastStyle that you may be able to leverage; see the Interfaces chapter for more information.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.AbstractArrayStyle","location":"base/arrays.html#Base.Broadcast.AbstractArrayStyle","category":"type","text":"Broadcast.AbstractArrayStyle{N} <: BroadcastStyle is the abstract supertype for any style associated with an AbstractArray type. The N parameter is the dimensionality, which can be handy for AbstractArray types that only support specific dimensionalities:\n\nstruct SparseMatrixStyle <: Broadcast.AbstractArrayStyle{2} end\nBase.BroadcastStyle(::Type{<:SparseMatrixCSC}) = SparseMatrixStyle()\n\nFor AbstractArray types that support arbitrary dimensionality, N can be set to Any:\n\nstruct MyArrayStyle <: Broadcast.AbstractArrayStyle{Any} end\nBase.BroadcastStyle(::Type{<:MyArray}) = MyArrayStyle()\n\nIn cases where you want to be able to mix multiple AbstractArrayStyles and keep track of dimensionality, your style needs to support a Val constructor:\n\nstruct MyArrayStyleDim{N} <: Broadcast.AbstractArrayStyle{N} end\n(::Type{<:MyArrayStyleDim})(::Val{N}) where N = MyArrayStyleDim{N}()\n\nNote that if two or more AbstractArrayStyle subtypes conflict, broadcasting machinery will fall back to producing Arrays. If this is undesirable, you may need to define binary BroadcastStyle rules to control the output type.\n\nSee also Broadcast.DefaultArrayStyle.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.ArrayStyle","location":"base/arrays.html#Base.Broadcast.ArrayStyle","category":"type","text":"Broadcast.ArrayStyle{MyArrayType}() is a BroadcastStyle indicating that an object behaves as an array for broadcasting. It presents a simple way to construct Broadcast.AbstractArrayStyles for specific AbstractArray container types. Broadcast styles created this way lose track of dimensionality; if keeping track is important for your type, you should create your own custom Broadcast.AbstractArrayStyle.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.DefaultArrayStyle","location":"base/arrays.html#Base.Broadcast.DefaultArrayStyle","category":"type","text":"Broadcast.DefaultArrayStyle{N}() is a BroadcastStyle indicating that an object behaves as an N-dimensional array for broadcasting. Specifically, DefaultArrayStyle is used for any AbstractArray type that hasn't defined a specialized style, and in the absence of overrides from other broadcast arguments the resulting output type is Array. When there are multiple inputs to broadcast, DefaultArrayStyle \"loses\" to any other Broadcast.ArrayStyle.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.broadcastable","location":"base/arrays.html#Base.Broadcast.broadcastable","category":"function","text":"Broadcast.broadcastable(x)\n\nReturn either x or an object like x such that it supports axes, indexing, and its type supports ndims.\n\nIf x supports iteration, the returned value should have the same axes and indexing behaviors as collect(x).\n\nIf x is not an AbstractArray but it supports axes, indexing, and its type supports ndims, then broadcastable(::typeof(x)) may be implemented to just return itself. Further, if x defines its own BroadcastStyle, then it must define its broadcastable method to return itself for the custom style to have any effect.\n\nExamples\n\njulia> Broadcast.broadcastable([1,2,3]) # like `identity` since arrays already support axes and indexing\n3-element Vector{Int64}:\n 1\n 2\n 3\n\njulia> Broadcast.broadcastable(Int) # Types don't support axes, indexing, or iteration but are commonly used as scalars\nBase.RefValue{Type{Int64}}(Int64)\n\njulia> Broadcast.broadcastable(\"hello\") # Strings break convention of matching iteration and act like a scalar instead\nBase.RefValue{String}(\"hello\")\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.combine_axes","location":"base/arrays.html#Base.Broadcast.combine_axes","category":"function","text":"combine_axes(As...) -> Tuple\n\nDetermine the result axes for broadcasting across all values in As.\n\njulia> Broadcast.combine_axes([1], [1 2; 3 4; 5 6])\n(Base.OneTo(3), Base.OneTo(2))\n\njulia> Broadcast.combine_axes(1, 1, 1)\n()\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.combine_styles","location":"base/arrays.html#Base.Broadcast.combine_styles","category":"function","text":"combine_styles(cs...) -> BroadcastStyle\n\nDecides which BroadcastStyle to use for any number of value arguments. Uses BroadcastStyle to get the style for each argument, and uses result_style to combine styles.\n\nExamples\n\njulia> Broadcast.combine_styles([1], [1 2; 3 4])\nBase.Broadcast.DefaultArrayStyle{2}()\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Broadcast.result_style","location":"base/arrays.html#Base.Broadcast.result_style","category":"function","text":"result_style(s1::BroadcastStyle[, s2::BroadcastStyle]) -> BroadcastStyle\n\nTakes one or two BroadcastStyles and combines them using BroadcastStyle to determine a common BroadcastStyle.\n\nExamples\n\njulia> Broadcast.result_style(Broadcast.DefaultArrayStyle{0}(), Broadcast.DefaultArrayStyle{3}())\nBase.Broadcast.DefaultArrayStyle{3}()\n\njulia> Broadcast.result_style(Broadcast.Unknown(), Broadcast.DefaultArrayStyle{1}())\nBase.Broadcast.DefaultArrayStyle{1}()\n\n\n\n\n\n","page":"Arrays"},{"title":"Indexing and assignment","location":"base/arrays.html#Indexing-and-assignment","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.getindex(::AbstractArray, ::Any...)\nBase.setindex!(::AbstractArray, ::Any, ::Any...)\nBase.nextind\nBase.prevind\nBase.copyto!(::AbstractArray, ::CartesianIndices, ::AbstractArray, ::CartesianIndices)\nBase.copy!\nBase.isassigned\nBase.Colon\nBase.CartesianIndex\nBase.CartesianIndices\nBase.Dims\nBase.LinearIndices\nBase.to_indices\nBase.checkbounds\nBase.checkindex\nBase.elsize","page":"Arrays"},{"title":"Base.getindex","location":"base/arrays.html#Base.getindex-Tuple{AbstractArray, Vararg{Any}}","category":"method","text":"getindex(A, inds...)\n\nReturn a subset of array A as selected by the indices inds.\n\nEach index may be any supported index type, such as an Integer, CartesianIndex, range, or array of supported indices. A : may be used to select all elements along a specific dimension, and a boolean array (e.g. an Array{Bool} or a BitArray) may be used to filter for elements where the corresponding index is true.\n\nWhen inds selects multiple elements, this function returns a newly allocated array. To index multiple elements without making a copy, use view instead.\n\nSee the manual section on array indexing for details.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> getindex(A, 1)\n1\n\njulia> getindex(A, [2, 1])\n2-element Vector{Int64}:\n 3\n 1\n\njulia> getindex(A, 2:4)\n3-element Vector{Int64}:\n 3\n 2\n 4\n\njulia> getindex(A, 2, 1)\n3\n\njulia> getindex(A, CartesianIndex(2, 1))\n3\n\njulia> getindex(A, :, 2)\n2-element Vector{Int64}:\n 2\n 4\n\njulia> getindex(A, 2, :)\n2-element Vector{Int64}:\n 3\n 4\n\njulia> getindex(A, A .> 2)\n2-element Vector{Int64}:\n 3\n 4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.setindex!","location":"base/arrays.html#Base.setindex!-Tuple{AbstractArray, Any, Vararg{Any}}","category":"method","text":"setindex!(A, X, inds...)\nA[inds...] = X\n\nStore values from array X within some subset of A as specified by inds. The syntax A[inds...] = X is equivalent to (setindex!(A, X, inds...); X).\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = zeros(2,2);\n\njulia> setindex!(A, [10, 20], [1, 2]);\n\njulia> A[[3, 4]] = [30, 40];\n\njulia> A\n2×2 Matrix{Float64}:\n 10.0  30.0\n 20.0  40.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.nextind","location":"base/arrays.html#Base.nextind","category":"function","text":"nextind(A, i)\n\nReturn the index after i in A. The returned index is often equivalent to i + 1 for an integer i. This function can be useful for generic code.\n\nwarning: Warning\nThe returned index might be out of bounds. Consider using checkbounds.\n\nSee also: prevind.\n\nExamples\n\njulia> x = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> nextind(x, 1) # valid result\n2\n\njulia> nextind(x, 4) # invalid result\n5\n\njulia> nextind(x, CartesianIndex(1, 1)) # valid result\nCartesianIndex(2, 1)\n\njulia> nextind(x, CartesianIndex(2, 2)) # invalid result\nCartesianIndex(1, 3)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.prevind","location":"base/arrays.html#Base.prevind","category":"function","text":"prevind(A, i)\n\nReturn the index before i in A. The returned index is often equivalent to i - 1 for an integer i. This function can be useful for generic code.\n\nwarning: Warning\nThe returned index might be out of bounds. Consider using checkbounds.\n\nSee also: nextind.\n\nExamples\n\njulia> x = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> prevind(x, 4) # valid result\n3\n\njulia> prevind(x, 1) # invalid result\n0\n\njulia> prevind(x, CartesianIndex(2, 2)) # valid result\nCartesianIndex(1, 2)\n\njulia> prevind(x, CartesianIndex(1, 1)) # invalid result\nCartesianIndex(2, 0)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.copyto!","location":"base/arrays.html#Base.copyto!-Tuple{AbstractArray, CartesianIndices, AbstractArray, CartesianIndices}","category":"method","text":"copyto!(dest, Rdest::CartesianIndices, src, Rsrc::CartesianIndices) -> dest\n\nCopy the block of src in the range of Rsrc to the block of dest in the range of Rdest. The sizes of the two regions must match.\n\nExamples\n\njulia> A = zeros(5, 5);\n\njulia> B = [1 2; 3 4];\n\njulia> Ainds = CartesianIndices((2:3, 2:3));\n\njulia> Binds = CartesianIndices(B);\n\njulia> copyto!(A, Ainds, B, Binds)\n5×5 Matrix{Float64}:\n 0.0  0.0  0.0  0.0  0.0\n 0.0  1.0  2.0  0.0  0.0\n 0.0  3.0  4.0  0.0  0.0\n 0.0  0.0  0.0  0.0  0.0\n 0.0  0.0  0.0  0.0  0.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.copy!","location":"base/arrays.html#Base.copy!","category":"function","text":"copy!(dst, src) -> dst\n\nIn-place copy of src into dst, discarding any pre-existing elements in dst. If dst and src are of the same type, dst == src should hold after the call. If dst and src are multidimensional arrays, they must have equal axes.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nSee also copyto!.\n\ncompat: Julia 1.1\nThis method requires at least Julia 1.1. In Julia 1.0 this method is available from the Future standard library as Future.copy!.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.isassigned","location":"base/arrays.html#Base.isassigned","category":"function","text":"isassigned(array, i) -> Bool\n\nTest whether the given array has a value associated with index i. Return false if the index is out of bounds, or has an undefined reference.\n\nExamples\n\njulia> isassigned(rand(3, 3), 5)\ntrue\n\njulia> isassigned(rand(3, 3), 3 * 3 + 1)\nfalse\n\njulia> mutable struct Foo end\n\njulia> v = similar(rand(3), Foo)\n3-element Vector{Foo}:\n #undef\n #undef\n #undef\n\njulia> isassigned(v, 1)\nfalse\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Colon","location":"base/arrays.html#Base.Colon","category":"type","text":"Colon()\n\nColons (:) are used to signify indexing entire objects or dimensions at once.\n\nVery few operations are defined on Colons directly; instead they are converted by to_indices to an internal vector type (Base.Slice) to represent the collection of indices they span before being used.\n\nThe singleton instance of Colon is also a function used to construct ranges; see :.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IteratorsMD.CartesianIndex","location":"base/arrays.html#Base.IteratorsMD.CartesianIndex","category":"type","text":"CartesianIndex(i, j, k...)   -> I\nCartesianIndex((i, j, k...)) -> I\n\nCreate a multidimensional index I, which can be used for indexing a multidimensional array A.  In particular, A[I] is equivalent to A[i,j,k...].  One can freely mix integer and CartesianIndex indices; for example, A[Ipre, i, Ipost] (where Ipre and Ipost are CartesianIndex indices and i is an Int) can be a useful expression when writing algorithms that work along a single dimension of an array of arbitrary dimensionality.\n\nA CartesianIndex is sometimes produced by eachindex, and always when iterating with an explicit CartesianIndices.\n\nAn I::CartesianIndex is treated as a \"scalar\" (not a container) for broadcast.   In order to iterate over the components of a CartesianIndex, convert it to a tuple with Tuple(I).\n\nExamples\n\njulia> A = reshape(Vector(1:16), (2, 2, 2, 2))\n2×2×2×2 Array{Int64, 4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\n[:, :, 2, 1] =\n 5  7\n 6  8\n\n[:, :, 1, 2] =\n  9  11\n 10  12\n\n[:, :, 2, 2] =\n 13  15\n 14  16\n\njulia> A[CartesianIndex((1, 1, 1, 1))]\n1\n\njulia> A[CartesianIndex((1, 1, 1, 2))]\n9\n\njulia> A[CartesianIndex((1, 1, 2, 1))]\n5\n\ncompat: Julia 1.10\nUsing a CartesianIndex as a \"scalar\" for broadcast requires Julia 1.10; in previous releases, use Ref(I).\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.IteratorsMD.CartesianIndices","location":"base/arrays.html#Base.IteratorsMD.CartesianIndices","category":"type","text":"CartesianIndices(sz::Dims) -> R\nCartesianIndices((istart:[istep:]istop, jstart:[jstep:]jstop, ...)) -> R\n\nDefine a region R spanning a multidimensional rectangular range of integer indices. These are most commonly encountered in the context of iteration, where for I in R ... end will return CartesianIndex indices I equivalent to the nested loops\n\nfor j = jstart:jstep:jstop\n    for i = istart:istep:istop\n        ...\n    end\nend\n\nConsequently these can be useful for writing algorithms that work in arbitrary dimensions.\n\nCartesianIndices(A::AbstractArray) -> R\n\nAs a convenience, constructing a CartesianIndices from an array makes a range of its indices.\n\ncompat: Julia 1.6\nThe step range method CartesianIndices((istart:istep:istop, jstart:[jstep:]jstop, ...)) requires at least Julia 1.6.\n\nExamples\n\njulia> foreach(println, CartesianIndices((2, 2, 2)))\nCartesianIndex(1, 1, 1)\nCartesianIndex(2, 1, 1)\nCartesianIndex(1, 2, 1)\nCartesianIndex(2, 2, 1)\nCartesianIndex(1, 1, 2)\nCartesianIndex(2, 1, 2)\nCartesianIndex(1, 2, 2)\nCartesianIndex(2, 2, 2)\n\njulia> CartesianIndices(fill(1, (2,3)))\nCartesianIndices((2, 3))\n\nConversion between linear and cartesian indices\n\nLinear index to cartesian index conversion exploits the fact that a CartesianIndices is an AbstractArray and can be indexed linearly:\n\njulia> cartesian = CartesianIndices((1:3, 1:2))\nCartesianIndices((1:3, 1:2))\n\njulia> cartesian[4]\nCartesianIndex(1, 2)\n\njulia> cartesian = CartesianIndices((1:2:5, 1:2))\nCartesianIndices((1:2:5, 1:2))\n\njulia> cartesian[2, 2]\nCartesianIndex(3, 2)\n\nBroadcasting\n\nCartesianIndices support broadcasting arithmetic (+ and -) with a CartesianIndex.\n\ncompat: Julia 1.1\nBroadcasting of CartesianIndices requires at least Julia 1.1.\n\njulia> CIs = CartesianIndices((2:3, 5:6))\nCartesianIndices((2:3, 5:6))\n\njulia> CI = CartesianIndex(3, 4)\nCartesianIndex(3, 4)\n\njulia> CIs .+ CI\nCartesianIndices((5:6, 9:10))\n\nFor cartesian to linear index conversion, see LinearIndices.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.Dims","location":"base/arrays.html#Base.Dims","category":"type","text":"Dims{N}\n\nAn NTuple of N Ints used to represent the dimensions of an AbstractArray.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.LinearIndices","location":"base/arrays.html#Base.LinearIndices","category":"type","text":"LinearIndices(A::AbstractArray)\n\nReturn a LinearIndices array with the same shape and axes as A, holding the linear index of each entry in A. Indexing this array with cartesian indices allows mapping them to linear indices.\n\nFor arrays with conventional indexing (indices start at 1), or any multidimensional array, linear indices range from 1 to length(A). However, for AbstractVectors linear indices are axes(A, 1), and therefore do not start at 1 for vectors with unconventional indexing.\n\nCalling this function is the \"safe\" way to write algorithms that exploit linear indexing.\n\nExamples\n\njulia> A = fill(1, (5,6,7));\n\njulia> b = LinearIndices(A);\n\njulia> extrema(b)\n(1, 210)\n\nLinearIndices(inds::CartesianIndices) -> R\nLinearIndices(sz::Dims) -> R\nLinearIndices((istart:istop, jstart:jstop, ...)) -> R\n\nReturn a LinearIndices array with the specified shape or axes.\n\nExamples\n\nThe main purpose of this constructor is intuitive conversion from cartesian to linear indexing:\n\njulia> linear = LinearIndices((1:3, 1:2))\n3×2 LinearIndices{2, Tuple{UnitRange{Int64}, UnitRange{Int64}}}:\n 1  4\n 2  5\n 3  6\n\njulia> linear[1,2]\n4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.to_indices","location":"base/arrays.html#Base.to_indices","category":"function","text":"to_indices(A, I::Tuple)\n\nConvert the tuple I to a tuple of indices for use in indexing into array A.\n\nThe returned tuple must only contain either Ints or AbstractArrays of scalar indices that are supported by array A. It will error upon encountering a novel index type that it does not know how to process.\n\nFor simple index types, it defers to the unexported Base.to_index(A, i) to process each index i. While this internal function is not intended to be called directly, Base.to_index may be extended by custom array or index types to provide custom indexing behaviors.\n\nMore complicated index types may require more context about the dimension into which they index. To support those cases, to_indices(A, I) calls to_indices(A, axes(A), I), which then recursively walks through both the given tuple of indices and the dimensional indices of A in tandem. As such, not all index types are guaranteed to propagate to Base.to_index.\n\nExamples\n\njulia> A = zeros(1,2,3,4);\n\njulia> to_indices(A, (1,1,2,2))\n(1, 1, 2, 2)\n\njulia> to_indices(A, (1,1,2,20)) # no bounds checking\n(1, 1, 2, 20)\n\njulia> to_indices(A, (CartesianIndex((1,)), 2, CartesianIndex((3,4)))) # exotic index\n(1, 2, 3, 4)\n\njulia> to_indices(A, ([1,1], 1:2, 3, 4))\n([1, 1], 1:2, 3, 4)\n\njulia> to_indices(A, (1,2)) # no shape checking\n(1, 2)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.checkbounds","location":"base/arrays.html#Base.checkbounds","category":"function","text":"checkbounds(Bool, A, I...)\n\nReturn true if the specified indices I are in bounds for the given array A. Subtypes of AbstractArray should specialize this method if they need to provide custom bounds checking behaviors; however, in many cases one can rely on A's indices and checkindex.\n\nSee also checkindex.\n\nExamples\n\njulia> A = rand(3, 3);\n\njulia> checkbounds(Bool, A, 2)\ntrue\n\njulia> checkbounds(Bool, A, 3, 4)\nfalse\n\njulia> checkbounds(Bool, A, 1:3)\ntrue\n\njulia> checkbounds(Bool, A, 1:3, 2:4)\nfalse\n\n\n\n\n\ncheckbounds(A, I...)\n\nThrow an error if the specified indices I are not in bounds for the given array A.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.checkindex","location":"base/arrays.html#Base.checkindex","category":"function","text":"checkindex(Bool, inds::AbstractUnitRange, index)\n\nReturn true if the given index is within the bounds of inds. Custom types that would like to behave as indices for all arrays can extend this method in order to provide a specialized bounds checking implementation.\n\nSee also checkbounds.\n\nExamples\n\njulia> checkindex(Bool, 1:20, 8)\ntrue\n\njulia> checkindex(Bool, 1:20, 21)\nfalse\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.elsize","location":"base/arrays.html#Base.elsize","category":"function","text":"elsize(type)\n\nCompute the memory stride in bytes between consecutive elements of eltype stored inside the given type, if the array elements are stored densely with a uniform linear stride.\n\nExamples\n\njulia> Base.elsize(rand(Float32, 10))\n4\n\n\n\n\n\n","page":"Arrays"},{"title":"Views (SubArrays and other view types)","location":"base/arrays.html#Views-(SubArrays-and-other-view-types)","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"A “view” is a data structure that acts like an array (it is a subtype of AbstractArray), but the underlying data is actually part of another array.","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"For example, if x is an array and v = @view x[1:10], then v acts like a 10-element array, but its data is actually accessing the first 10 elements of x. Writing to a view, e.g. v[3] = 2, writes directly to the underlying array x (in this case modifying x[3]).","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Slicing operations like x[1:10] create a copy by default in Julia. @view x[1:10] changes it to make a view. The @views macro can be used on a whole block of code (e.g. @views function foo() .... end or @views begin ... end) to change all the slicing operations in that block to use views.  Sometimes making a copy of the data is faster and sometimes using a view is faster, as described in the performance tips.","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.view\nBase.@view\nBase.@views\nBase.parent\nBase.parentindices\nBase.selectdim\nBase.reinterpret\nBase.reshape\nBase.dropdims\nBase.vec\nBase.SubArray","page":"Arrays"},{"title":"Base.view","location":"base/arrays.html#Base.view","category":"function","text":"view(A, inds...)\n\nLike getindex, but returns a lightweight array that lazily references (or is effectively a view into) the parent array A at the given index or indices inds instead of eagerly extracting elements or constructing a copied subset. Calling getindex or setindex! on the returned value (often a SubArray) computes the indices to access or modify the parent array on the fly.  The behavior is undefined if the shape of the parent array is changed after view is called because there is no bound check for the parent array; e.g., it may cause a segmentation fault.\n\nSome immutable parent arrays (like ranges) may choose to simply recompute a new array in some circumstances instead of returning a SubArray if doing so is efficient and provides compatible semantics.\n\ncompat: Julia 1.6\nIn Julia 1.6 or later, view can be called on an AbstractString, returning a SubString.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> b = view(A, :, 1)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\njulia> fill!(b, 0)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 0\n 0\n\njulia> A # Note A has changed even though we modified b\n2×2 Matrix{Int64}:\n 0  2\n 0  4\n\njulia> view(2:5, 2:3) # returns a range as type is immutable\n3:4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.@view","location":"base/arrays.html#Base.@view","category":"macro","text":"@view A[inds...]\n\nTransform the indexing expression A[inds...] into the equivalent view call.\n\nThis can only be applied directly to a single indexing expression and is particularly helpful for expressions that include the special begin or end indexing syntaxes like A[begin, 2:end-1] (as those are not supported by the normal view function).\n\nNote that @view cannot be used as the target of a regular assignment (e.g., @view(A[1, 2:end]) = ...), nor would the un-decorated indexed assignment (A[1, 2:end] = ...) or broadcasted indexed assignment (A[1, 2:end] .= ...) make a copy.  It can be useful, however, for updating broadcasted assignments like @view(A[1, 2:end]) .+= 1 because this is a simple syntax for @view(A[1, 2:end]) .= @view(A[1, 2:end]) + 1, and the indexing expression on the right-hand side would otherwise make a copy without the @view.\n\nSee also @views to switch an entire block of code to use views for non-scalar indexing.\n\ncompat: Julia 1.5\nUsing begin in an indexing expression to refer to the first index requires at least Julia 1.5.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> b = @view A[:, 1]\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\njulia> fill!(b, 0)\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 0\n 0\n\njulia> A\n2×2 Matrix{Int64}:\n 0  2\n 0  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.@views","location":"base/arrays.html#Base.@views","category":"macro","text":"@views expression\n\nConvert every array-slicing operation in the given expression (which may be a begin/end block, loop, function, etc.) to return a view. Scalar indices, non-array types, and explicit getindex calls (as opposed to array[...]) are unaffected.\n\nSimilarly, @views converts string slices into SubString views.\n\nnote: Note\nThe @views macro only affects array[...] expressions that appear explicitly in the given expression, not array slicing that occurs in functions called by that code.\n\ncompat: Julia 1.5\nUsing begin in an indexing expression to refer to the first index was implemented in Julia 1.4, but was only supported by @views starting in Julia 1.5.\n\nExamples\n\njulia> A = zeros(3, 3);\n\njulia> @views for row in 1:3\n           b = A[row, :] # b is a view, not a copy\n           b .= row      # assign every element to the row index\n       end\n\njulia> A\n3×3 Matrix{Float64}:\n 1.0  1.0  1.0\n 2.0  2.0  2.0\n 3.0  3.0  3.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.parent","location":"base/arrays.html#Base.parent","category":"function","text":"parent(A)\n\nReturn the underlying parent object of the view. This parent of objects of types SubArray, SubString, ReshapedArray or LinearAlgebra.Transpose is what was passed as an argument to view, reshape, transpose, etc. during object creation. If the input is not a wrapped object, return the input itself. If the input is wrapped multiple times, only the outermost wrapper will be removed.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> V = view(A, 1:2, :)\n2×2 view(::Matrix{Int64}, 1:2, :) with eltype Int64:\n 1  2\n 3  4\n\njulia> parent(V)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.parentindices","location":"base/arrays.html#Base.parentindices","category":"function","text":"parentindices(A)\n\nReturn the indices in the parent which correspond to the view A.\n\nExamples\n\njulia> A = [1 2; 3 4];\n\njulia> V = view(A, 1, :)\n2-element view(::Matrix{Int64}, 1, :) with eltype Int64:\n 1\n 2\n\njulia> parentindices(V)\n(1, Base.Slice(Base.OneTo(2)))\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.selectdim","location":"base/arrays.html#Base.selectdim","category":"function","text":"selectdim(A, d::Integer, i)\n\nReturn a view of all the data of A where the index for dimension d equals i.\n\nEquivalent to view(A,:,:,...,i,:,:,...) where i is in position d.\n\nSee also: eachslice.\n\nExamples\n\njulia> A = [1 2 3 4; 5 6 7 8]\n2×4 Matrix{Int64}:\n 1  2  3  4\n 5  6  7  8\n\njulia> selectdim(A, 2, 3)\n2-element view(::Matrix{Int64}, :, 3) with eltype Int64:\n 3\n 7\n\njulia> selectdim(A, 2, 3:4)\n2×2 view(::Matrix{Int64}, :, 3:4) with eltype Int64:\n 3  4\n 7  8\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reinterpret","location":"base/arrays.html#Base.reinterpret","category":"function","text":"reinterpret(::Type{Out}, x::In)\n\nChange the type-interpretation of the binary data in the isbits value x to that of the isbits type Out. The size (ignoring padding) of Out has to be the same as that of the type of x. For example, reinterpret(Float32, UInt32(7)) interprets the 4 bytes corresponding to UInt32(7) as a Float32. Note that reinterpret(In, reinterpret(Out, x)) === x\n\njulia> reinterpret(Float32, UInt32(7))\n1.0f-44\n\njulia> reinterpret(NTuple{2, UInt8}, 0x1234)\n(0x34, 0x12)\n\njulia> reinterpret(UInt16, (0x34, 0x12))\n0x1234\n\njulia> reinterpret(Tuple{UInt16, UInt8}, (0x01, 0x0203))\n(0x0301, 0x02)\n\nnote: Note\nThe treatment of padding differs from reinterpret(::DataType, ::AbstractArray).\n\nwarning: Warning\nUse caution if some combinations of bits in Out are not considered valid and would otherwise be prevented by the type's constructors and methods. Unexpected behavior may result without additional validation.\n\n\n\n\n\nreinterpret(T::DataType, A::AbstractArray)\n\nConstruct a view of the array with the same binary data as the given array, but with T as element type.\n\nThis function also works on \"lazy\" array whose elements are not computed until they are explicitly retrieved. For instance, reinterpret on the range 1:6 works similarly as on the dense vector collect(1:6):\n\njulia> reinterpret(Float32, UInt32[1 2 3 4 5])\n1×5 reinterpret(Float32, ::Matrix{UInt32}):\n 1.0f-45  3.0f-45  4.0f-45  6.0f-45  7.0f-45\n\njulia> reinterpret(Complex{Int}, 1:6)\n3-element reinterpret(Complex{Int32}, ::UnitRange{Int32}):\n 1 + 2im\n 3 + 4im\n 5 + 6im\n\nIf the location of padding bits does not line up between T and eltype(A), the resulting array will be read-only or write-only, to prevent invalid bits from being written to or read from, respectively.\n\njulia> a = reinterpret(Tuple{UInt8, UInt32}, UInt32[1, 2])\n1-element reinterpret(Tuple{UInt8, UInt32}, ::Vector{UInt32}):\n (0x01, 0x00000002)\n\njulia> a[1] = 3\nERROR: Padding of type Tuple{UInt8, UInt32} is not compatible with type UInt32.\n\njulia> b = reinterpret(UInt32, Tuple{UInt8, UInt32}[(0x01, 0x00000002)]); # showing will error\n\njulia> b[1]\nERROR: Padding of type UInt32 is not compatible with type Tuple{UInt8, UInt32}.\n\n\n\n\n\nreinterpret(reshape, T, A::AbstractArray{S}) -> B\n\nChange the type-interpretation of A while consuming or adding a \"channel dimension.\"\n\nIf sizeof(T) = n*sizeof(S) for n>1, A's first dimension must be of size n and B lacks A's first dimension. Conversely, if sizeof(S) = n*sizeof(T) for n>1, B gets a new first dimension of size n. The dimensionality is unchanged if sizeof(T) == sizeof(S).\n\ncompat: Julia 1.6\nThis method requires at least Julia 1.6.\n\nExamples\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int32}:\n 1  2\n 3  4\n\njulia> reinterpret(reshape, Complex{Int}, A)    # the result is a vector\n2-element reinterpret(reshape, Complex{Int32}, ::Matrix{Int32}) with eltype Complex{Int32}:\n 1 + 3im\n 2 + 4im\n\njulia> a = [(1,2,3), (4,5,6)]\n2-element Vector{Tuple{Int32, Int32, Int32}}:\n (1, 2, 3)\n (4, 5, 6)\n\njulia> reinterpret(reshape, Int, a)             # the result is a matrix\n3×2 reinterpret(reshape, Int32, ::Vector{Tuple{Int32, Int32, Int32}}) with eltype Int32:\n 1  4\n 2  5\n 3  6\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reshape","location":"base/arrays.html#Base.reshape","category":"function","text":"reshape(A, dims...) -> AbstractArray\nreshape(A, dims) -> AbstractArray\n\nReturn an array with the same data as A, but with different dimension sizes or number of dimensions. The two arrays share the same underlying data, so that the result is mutable if and only if A is mutable, and setting elements of one alters the values of the other.\n\nThe new dimensions may be specified either as a list of arguments or as a shape tuple. At most one dimension may be specified with a :, in which case its length is computed such that its product with all the specified dimensions is equal to the length of the original array A. The total number of elements must not change.\n\nExamples\n\njulia> A = Vector(1:16)\n16-element Vector{Int64}:\n  1\n  2\n  3\n  4\n  5\n  6\n  7\n  8\n  9\n 10\n 11\n 12\n 13\n 14\n 15\n 16\n\njulia> reshape(A, (4, 4))\n4×4 Matrix{Int64}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> reshape(A, 2, :)\n2×8 Matrix{Int64}:\n 1  3  5  7   9  11  13  15\n 2  4  6  8  10  12  14  16\n\njulia> reshape(1:6, 2, 3)\n2×3 reshape(::UnitRange{Int64}, 2, 3) with eltype Int64:\n 1  3  5\n 2  4  6\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.dropdims","location":"base/arrays.html#Base.dropdims","category":"function","text":"dropdims(A; dims)\n\nReturn an array with the same data as A, but with the dimensions specified by dims removed. size(A,d) must equal 1 for every d in dims, and repeated dimensions or numbers outside 1:ndims(A) are forbidden.\n\nThe result shares the same underlying data as A, such that the result is mutable if and only if A is mutable, and setting elements of one alters the values of the other.\n\nSee also: reshape, vec.\n\nExamples\n\njulia> a = reshape(Vector(1:4),(2,2,1,1))\n2×2×1×1 Array{Int64, 4}:\n[:, :, 1, 1] =\n 1  3\n 2  4\n\njulia> b = dropdims(a; dims=3)\n2×2×1 Array{Int64, 3}:\n[:, :, 1] =\n 1  3\n 2  4\n\njulia> b[1,1,1] = 5; a\n2×2×1×1 Array{Int64, 4}:\n[:, :, 1, 1] =\n 5  3\n 2  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.vec","location":"base/arrays.html#Base.vec","category":"function","text":"vec(a::AbstractArray) -> AbstractVector\n\nReshape the array a as a one-dimensional column vector. Return a if it is already an AbstractVector. The resulting array shares the same underlying data as a, so it will only be mutable if a is mutable, in which case modifying one will also modify the other.\n\nExamples\n\njulia> a = [1 2 3; 4 5 6]\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> vec(a)\n6-element Vector{Int64}:\n 1\n 4\n 2\n 5\n 3\n 6\n\njulia> vec(1:3)\n1:3\n\nSee also reshape, dropdims.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.SubArray","location":"base/arrays.html#Base.SubArray","category":"type","text":"SubArray{T,N,P,I,L} <: AbstractArray{T,N}\n\nN-dimensional view into a parent array (of type P) with an element type T, restricted by a tuple of indices (of type I). L is true for types that support fast linear indexing, and false otherwise.\n\nConstruct SubArrays using the view function.\n\n\n\n\n\n","page":"Arrays"},{"title":"Concatenation and permutation","location":"base/arrays.html#Concatenation-and-permutation","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.cat\nBase.vcat\nBase.hcat\nBase.hvcat\nBase.hvncat\nBase.stack\nBase.vect\nBase.circshift\nBase.circshift!\nBase.circcopy!\nBase.findall(::Any)\nBase.findall(::Function, ::Any)\nBase.findfirst(::Any)\nBase.findfirst(::Function, ::Any)\nBase.findlast(::Any)\nBase.findlast(::Function, ::Any)\nBase.findnext(::Any, ::Integer)\nBase.findnext(::Function, ::Any, ::Integer)\nBase.findprev(::Any, ::Integer)\nBase.findprev(::Function, ::Any, ::Integer)\nBase.permutedims\nBase.permutedims!\nBase.PermutedDimsArray\nBase.promote_shape","page":"Arrays"},{"title":"Base.cat","location":"base/arrays.html#Base.cat","category":"function","text":"cat(A...; dims)\n\nConcatenate the input arrays along the dimensions specified in dims.\n\nAlong a dimension d in dims, the size of the output array is sum(size(a,d) for a in A). Along other dimensions, all input arrays should have the same size, which will also be the size of the output array along those dimensions.\n\nIf dims is a single number, the different arrays are tightly packed along that dimension. If dims is an iterable containing several dimensions, the positions along these dimensions are increased simultaneously for each input array, filling with zero elsewhere. This allows one to construct block-diagonal matrices as cat(matrices...; dims=(1,2)), and their higher-dimensional analogues.\n\nThe special case dims=1 is vcat, and dims=2 is hcat. See also hvcat, hvncat, stack, repeat.\n\nThe keyword also accepts Val(dims).\n\ncompat: Julia 1.8\nFor multiple dimensions dims = Val(::Tuple) was added in Julia 1.8.\n\nExamples\n\nConcatenate two arrays in different dimensions:\n\njulia> a = [1 2 3]\n1×3 Matrix{Int64}:\n 1  2  3\n\njulia> b = [4 5 6]\n1×3 Matrix{Int64}:\n 4  5  6\n\njulia> cat(a, b; dims=1)\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> cat(a, b; dims=2)\n1×6 Matrix{Int64}:\n 1  2  3  4  5  6\n\njulia> cat(a, b; dims=(1, 2))\n2×6 Matrix{Int64}:\n 1  2  3  0  0  0\n 0  0  0  4  5  6\n\nExtended Help\n\nConcatenate 3D arrays:\n\njulia> a = ones(2, 2, 3);\n\njulia> b = ones(2, 2, 4);\n\njulia> c = cat(a, b; dims=3);\n\njulia> size(c) == (2, 2, 7)\ntrue\n\nConcatenate arrays of different sizes:\n\njulia> cat([1 2; 3 4], [pi, pi], fill(10, 2,3,1); dims=2)  # same as hcat\n2×6×1 Array{Float64, 3}:\n[:, :, 1] =\n 1.0  2.0  3.14159  10.0  10.0  10.0\n 3.0  4.0  3.14159  10.0  10.0  10.0\n\nConstruct a block diagonal matrix:\n\njulia> cat(true, trues(2,2), trues(4)', dims=(1,2))  # block-diagonal\n4×7 Matrix{Bool}:\n 1  0  0  0  0  0  0\n 0  1  1  0  0  0  0\n 0  1  1  0  0  0  0\n 0  0  0  1  1  1  1\n\njulia> cat(1, [2], [3;;]; dims=Val(2))\n1×3 Matrix{Int64}:\n 1  2  3\n\nnote: Note\ncat does not join two strings, you may want to use *.\n\njulia> a = \"aaa\";\n\njulia> b = \"bbb\";\n\njulia> cat(a, b; dims=1)\n2-element Vector{String}:\n \"aaa\"\n \"bbb\"\n\njulia> cat(a, b; dims=2)\n1×2 Matrix{String}:\n \"aaa\"  \"bbb\"\n\njulia> a * b\n\"aaabbb\"\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.vcat","location":"base/arrays.html#Base.vcat","category":"function","text":"vcat(A...)\n\nConcatenate arrays or numbers vertically. Equivalent to cat(A...; dims=1), and to the syntax [a; b; c].\n\nTo concatenate a large vector of arrays, reduce(vcat, A) calls an efficient method when A isa AbstractVector{<:AbstractVecOrMat}, rather than working pairwise.\n\nSee also hcat, Iterators.flatten, stack.\n\nExamples\n\njulia> v = vcat([1,2], [3,4])\n4-element Vector{Int64}:\n 1\n 2\n 3\n 4\n\njulia> v == vcat(1, 2, [3,4])  # accepts numbers\ntrue\n\njulia> v == [1; 2; [3,4]]  # syntax for the same operation\ntrue\n\njulia> summary(ComplexF64[1; 2; [3,4]])  # syntax for supplying the element type\n\"4-element Vector{ComplexF64}\"\n\njulia> vcat(range(1, 2, length=3))  # collects lazy ranges\n3-element Vector{Float64}:\n 1.0\n 1.5\n 2.0\n\njulia> two = ([10, 20, 30]', Float64[4 5 6; 7 8 9])  # row vector and a matrix\n([10 20 30], [4.0 5.0 6.0; 7.0 8.0 9.0])\n\njulia> vcat(two...)\n3×3 Matrix{Float64}:\n 10.0  20.0  30.0\n  4.0   5.0   6.0\n  7.0   8.0   9.0\n\njulia> vs = [[1, 2], [3, 4], [5, 6]];\n\njulia> reduce(vcat, vs)  # more efficient than vcat(vs...)\n6-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n 6\n\njulia> ans == collect(Iterators.flatten(vs))\ntrue\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.hcat","location":"base/arrays.html#Base.hcat","category":"function","text":"hcat(A...)\n\nConcatenate arrays or numbers horizontally. Equivalent to cat(A...; dims=2), and to the syntax [a b c] or [a;; b;; c].\n\nFor a large vector of arrays, reduce(hcat, A) calls an efficient method when A isa AbstractVector{<:AbstractVecOrMat}. For a vector of vectors, this can also be written stack(A).\n\nSee also vcat, hvcat.\n\nExamples\n\njulia> hcat([1,2], [3,4], [5,6])\n2×3 Matrix{Int64}:\n 1  3  5\n 2  4  6\n\njulia> hcat(1, 2, [30 40], [5, 6, 7]')  # accepts numbers\n1×7 Matrix{Int64}:\n 1  2  30  40  5  6  7\n\njulia> ans == [1 2 [30 40] [5, 6, 7]']  # syntax for the same operation\ntrue\n\njulia> Float32[1 2 [30 40] [5, 6, 7]']  # syntax for supplying the eltype\n1×7 Matrix{Float32}:\n 1.0  2.0  30.0  40.0  5.0  6.0  7.0\n\njulia> ms = [zeros(2,2), [1 2; 3 4], [50 60; 70 80]];\n\njulia> reduce(hcat, ms)  # more efficient than hcat(ms...)\n2×6 Matrix{Float64}:\n 0.0  0.0  1.0  2.0  50.0  60.0\n 0.0  0.0  3.0  4.0  70.0  80.0\n\njulia> stack(ms) |> summary  # disagrees on a vector of matrices\n\"2×2×3 Array{Float64, 3}\"\n\njulia> hcat(Int[], Int[], Int[])  # empty vectors, each of size (0,)\n0×3 Matrix{Int64}\n\njulia> hcat([1.1, 9.9], Matrix(undef, 2, 0))  # hcat with empty 2×0 Matrix\n2×1 Matrix{Any}:\n 1.1\n 9.9\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.hvcat","location":"base/arrays.html#Base.hvcat","category":"function","text":"hvcat(blocks_per_row::Union{Tuple{Vararg{Int}}, Int}, values...)\n\nHorizontal and vertical concatenation in one call. This function is called for block matrix syntax. The first argument specifies the number of arguments to concatenate in each block row. If the first argument is a single integer n, then all block rows are assumed to have n block columns.\n\nExamples\n\njulia> a, b, c, d, e, f = 1, 2, 3, 4, 5, 6\n(1, 2, 3, 4, 5, 6)\n\njulia> [a b c; d e f]\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> hvcat((3,3), a,b,c,d,e,f)\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> [a b; c d; e f]\n3×2 Matrix{Int64}:\n 1  2\n 3  4\n 5  6\n\njulia> hvcat((2,2,2), a,b,c,d,e,f)\n3×2 Matrix{Int64}:\n 1  2\n 3  4\n 5  6\njulia> hvcat((2,2,2), a,b,c,d,e,f) == hvcat(2, a,b,c,d,e,f)\ntrue\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.hvncat","location":"base/arrays.html#Base.hvncat","category":"function","text":"hvncat(dim::Int, row_first, values...)\nhvncat(dims::Tuple{Vararg{Int}}, row_first, values...)\nhvncat(shape::Tuple{Vararg{Tuple}}, row_first, values...)\n\nHorizontal, vertical, and n-dimensional concatenation of many values in one call.\n\nThis function is called for block matrix syntax. The first argument either specifies the shape of the concatenation, similar to hvcat, as a tuple of tuples, or the dimensions that specify the key number of elements along each axis, and is used to determine the output dimensions. The dims form is more performant, and is used by default when the concatenation operation has the same number of elements along each axis (e.g., [a b; c d;;; e f ; g h]). The shape form is used when the number of elements along each axis is unbalanced (e.g., [a b ; c]). Unbalanced syntax needs additional validation overhead. The dim form is an optimization for concatenation along just one dimension. row_first indicates how values are ordered. The meaning of the first and second elements of shape are also swapped based on row_first.\n\nExamples\n\njulia> a, b, c, d, e, f = 1, 2, 3, 4, 5, 6\n(1, 2, 3, 4, 5, 6)\n\njulia> [a b c;;; d e f]\n1×3×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  2  3\n\n[:, :, 2] =\n 4  5  6\n\njulia> hvncat((2,1,3), false, a,b,c,d,e,f)\n2×1×3 Array{Int64, 3}:\n[:, :, 1] =\n 1\n 2\n\n[:, :, 2] =\n 3\n 4\n\n[:, :, 3] =\n 5\n 6\n\njulia> [a b;;; c d;;; e f]\n1×2×3 Array{Int64, 3}:\n[:, :, 1] =\n 1  2\n\n[:, :, 2] =\n 3  4\n\n[:, :, 3] =\n 5  6\n\njulia> hvncat(((3, 3), (3, 3), (6,)), true, a, b, c, d, e, f)\n1×3×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  2  3\n\n[:, :, 2] =\n 4  5  6\n\nExamples for construction of the arguments\n\n[a b c ; d e f ;;;\n g h i ; j k l ;;;\n m n o ; p q r ;;;\n s t u ; v w x]\n⇒ dims = (2, 3, 4)\n\n[a b ; c ;;; d ;;;;]\n ___   _     _\n 2     1     1 = elements in each row (2, 1, 1)\n _______     _\n 3           1 = elements in each column (3, 1)\n _____________\n 4             = elements in each 3d slice (4,)\n _____________\n 4             = elements in each 4d slice (4,)\n⇒ shape = ((2, 1, 1), (3, 1), (4,), (4,)) with `row_first` = true\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.stack","location":"base/arrays.html#Base.stack","category":"function","text":"stack(iter; [dims])\n\nCombine a collection of arrays (or other iterable objects) of equal size into one larger array, by arranging them along one or more new dimensions.\n\nBy default the axes of the elements are placed first, giving size(result) = (size(first(iter))..., size(iter)...). This has the same order of elements as Iterators.flatten(iter).\n\nWith keyword dims::Integer, instead the ith element of iter becomes the slice selectdim(result, dims, i), so that size(result, dims) == length(iter). In this case stack reverses the action of eachslice with the same dims.\n\nThe various cat functions also combine arrays. However, these all extend the arrays' existing (possibly trivial) dimensions, rather than placing the arrays along new dimensions. They also accept arrays as separate arguments, rather than a single collection.\n\ncompat: Julia 1.9\nThis function requires at least Julia 1.9.\n\nExamples\n\njulia> vecs = (1:2, [30, 40], Float32[500, 600]);\n\njulia> mat = stack(vecs)\n2×3 Matrix{Float32}:\n 1.0  30.0  500.0\n 2.0  40.0  600.0\n\njulia> mat == hcat(vecs...) == reduce(hcat, collect(vecs))\ntrue\n\njulia> vec(mat) == vcat(vecs...) == reduce(vcat, collect(vecs))\ntrue\n\njulia> stack(zip(1:4, 10:99))  # accepts any iterators of iterators\n2×4 Matrix{Int64}:\n  1   2   3   4\n 10  11  12  13\n\njulia> vec(ans) == collect(Iterators.flatten(zip(1:4, 10:99)))\ntrue\n\njulia> stack(vecs; dims=1)  # unlike any cat function, 1st axis of vecs[1] is 2nd axis of result\n3×2 Matrix{Float32}:\n   1.0    2.0\n  30.0   40.0\n 500.0  600.0\n\njulia> x = rand(3,4);\n\njulia> x == stack(eachcol(x)) == stack(eachrow(x), dims=1)  # inverse of eachslice\ntrue\n\nHigher-dimensional examples:\n\njulia> A = rand(5, 7, 11);\n\njulia> E = eachslice(A, dims=2);  # a vector of matrices\n\njulia> (element = size(first(E)), container = size(E))\n(element = (5, 11), container = (7,))\n\njulia> stack(E) |> size\n(5, 11, 7)\n\njulia> stack(E) == stack(E; dims=3) == cat(E...; dims=3)\ntrue\n\njulia> A == stack(E; dims=2)\ntrue\n\njulia> M = (fill(10i+j, 2, 3) for i in 1:5, j in 1:7);\n\njulia> (element = size(first(M)), container = size(M))\n(element = (2, 3), container = (5, 7))\n\njulia> stack(M) |> size  # keeps all dimensions\n(2, 3, 5, 7)\n\njulia> stack(M; dims=1) |> size  # vec(container) along dims=1\n(35, 2, 3)\n\njulia> hvcat(5, M...) |> size  # hvcat puts matrices next to each other\n(14, 15)\n\n\n\n\n\nstack(f, args...; [dims])\n\nApply a function to each element of a collection, and stack the result. Or to several collections, zipped together.\n\nThe function should return arrays (or tuples, or other iterators) all of the same size. These become slices of the result, each separated along dims (if given) or by default along the last dimensions.\n\nSee also mapslices, eachcol.\n\nExamples\n\njulia> stack(c -> (c, c-32), \"julia\")\n2×5 Matrix{Char}:\n 'j'  'u'  'l'  'i'  'a'\n 'J'  'U'  'L'  'I'  'A'\n\njulia> stack(eachrow([1 2 3; 4 5 6]), (10, 100); dims=1) do row, n\n         vcat(row, row .* n, row ./ n)\n       end\n2×9 Matrix{Float64}:\n 1.0  2.0  3.0   10.0   20.0   30.0  0.1   0.2   0.3\n 4.0  5.0  6.0  400.0  500.0  600.0  0.04  0.05  0.06\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.vect","location":"base/arrays.html#Base.vect","category":"function","text":"vect(X...)\n\nCreate a Vector with element type computed from the promote_typeof of the argument, containing the argument list.\n\nExamples\n\njulia> a = Base.vect(UInt8(1), 2.5, 1//2)\n3-element Vector{Float64}:\n 1.0\n 2.5\n 0.5\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.circshift","location":"base/arrays.html#Base.circshift","category":"function","text":"circshift(A, shifts)\n\nCircularly shift, i.e. rotate, the data in an array. The second argument is a tuple or vector giving the amount to shift in each dimension, or an integer to shift only in the first dimension.\n\nSee also: circshift!, circcopy!, bitrotate, <<.\n\nExamples\n\njulia> b = reshape(Vector(1:16), (4,4))\n4×4 Matrix{Int64}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> circshift(b, (0,2))\n4×4 Matrix{Int64}:\n  9  13  1  5\n 10  14  2  6\n 11  15  3  7\n 12  16  4  8\n\njulia> circshift(b, (-1,0))\n4×4 Matrix{Int64}:\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n 1  5   9  13\n\njulia> a = BitArray([true, true, false, false, true])\n5-element BitVector:\n 1\n 1\n 0\n 0\n 1\n\njulia> circshift(a, 1)\n5-element BitVector:\n 1\n 1\n 1\n 0\n 0\n\njulia> circshift(a, -1)\n5-element BitVector:\n 1\n 0\n 0\n 1\n 1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.circshift!","location":"base/arrays.html#Base.circshift!","category":"function","text":"circshift!(dest, src, shifts)\n\nCircularly shift, i.e. rotate, the data in src, storing the result in dest. shifts specifies the amount to shift in each dimension.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nSee also circshift.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.circcopy!","location":"base/arrays.html#Base.circcopy!","category":"function","text":"circcopy!(dest, src)\n\nCopy src to dest, indexing each dimension modulo its length. src and dest must have the same size, but can be offset in their indices; any offset results in a (circular) wraparound. If the arrays have overlapping indices, then on the domain of the overlap dest agrees with src.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nSee also: circshift.\n\nExamples\n\njulia> src = reshape(Vector(1:16), (4,4))\n4×4 Array{Int64,2}:\n 1  5   9  13\n 2  6  10  14\n 3  7  11  15\n 4  8  12  16\n\njulia> dest = OffsetArray{Int}(undef, (0:3,2:5))\n\njulia> circcopy!(dest, src)\nOffsetArrays.OffsetArray{Int64,2,Array{Int64,2}} with indices 0:3×2:5:\n 8  12  16  4\n 5   9  13  1\n 6  10  14  2\n 7  11  15  3\n\njulia> dest[1:3,2:4] == src[1:3,2:4]\ntrue\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findall","location":"base/arrays.html#Base.findall-Tuple{Any}","category":"method","text":"findall(A)\n\nReturn a vector I of the true indices or keys of A. If there are no such elements of A, return an empty array. To search for other kinds of values, pass a predicate as the first argument.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nSee also: findfirst, searchsorted.\n\nExamples\n\njulia> A = [true, false, false, true]\n4-element Vector{Bool}:\n 1\n 0\n 0\n 1\n\njulia> findall(A)\n2-element Vector{Int64}:\n 1\n 4\n\njulia> A = [true false; false true]\n2×2 Matrix{Bool}:\n 1  0\n 0  1\n\njulia> findall(A)\n2-element Vector{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 2)\n\njulia> findall(falses(3))\nInt64[]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findall","location":"base/arrays.html#Base.findall-Tuple{Function, Any}","category":"method","text":"findall(f::Function, A)\n\nReturn a vector I of the indices or keys of A where f(A[I]) returns true. If there are no such elements of A, return an empty array.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> x = [1, 3, 4]\n3-element Vector{Int64}:\n 1\n 3\n 4\n\njulia> findall(isodd, x)\n2-element Vector{Int64}:\n 1\n 2\n\njulia> A = [1 2 0; 3 4 0]\n2×3 Matrix{Int64}:\n 1  2  0\n 3  4  0\njulia> findall(isodd, A)\n2-element Vector{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 1)\n\njulia> findall(!iszero, A)\n4-element Vector{CartesianIndex{2}}:\n CartesianIndex(1, 1)\n CartesianIndex(2, 1)\n CartesianIndex(1, 2)\n CartesianIndex(2, 2)\n\njulia> d = Dict(:A => 10, :B => -1, :C => 0)\nDict{Symbol, Int64} with 3 entries:\n  :A => 10\n  :B => -1\n  :C => 0\n\njulia> findall(x -> x >= 0, d)\n2-element Vector{Symbol}:\n :A\n :C\n\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findfirst","location":"base/arrays.html#Base.findfirst-Tuple{Any}","category":"method","text":"findfirst(A)\n\nReturn the index or key of the first true value in A. Return nothing if no such value is found. To search for other kinds of values, pass a predicate as the first argument.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nSee also: findall, findnext, findlast, searchsortedfirst.\n\nExamples\n\njulia> A = [false, false, true, false]\n4-element Vector{Bool}:\n 0\n 0\n 1\n 0\n\njulia> findfirst(A)\n3\n\njulia> findfirst(falses(3)) # returns nothing, but not printed in the REPL\n\njulia> A = [false false; true false]\n2×2 Matrix{Bool}:\n 0  0\n 1  0\n\njulia> findfirst(A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findfirst","location":"base/arrays.html#Base.findfirst-Tuple{Function, Any}","category":"method","text":"findfirst(predicate::Function, A)\n\nReturn the index or key of the first element of A for which predicate returns true. Return nothing if there is no such element.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [1, 4, 2, 2]\n4-element Vector{Int64}:\n 1\n 4\n 2\n 2\n\njulia> findfirst(iseven, A)\n2\n\njulia> findfirst(x -> x>10, A) # returns nothing, but not printed in the REPL\n\njulia> findfirst(isequal(4), A)\n2\n\njulia> A = [1 4; 2 2]\n2×2 Matrix{Int64}:\n 1  4\n 2  2\n\njulia> findfirst(iseven, A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findlast","location":"base/arrays.html#Base.findlast-Tuple{Any}","category":"method","text":"findlast(A)\n\nReturn the index or key of the last true value in A. Return nothing if there is no true value in A.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nSee also: findfirst, findprev, findall.\n\nExamples\n\njulia> A = [true, false, true, false]\n4-element Vector{Bool}:\n 1\n 0\n 1\n 0\n\njulia> findlast(A)\n3\n\njulia> A = falses(2,2);\n\njulia> findlast(A) # returns nothing, but not printed in the REPL\n\njulia> A = [true false; true false]\n2×2 Matrix{Bool}:\n 1  0\n 1  0\n\njulia> findlast(A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findlast","location":"base/arrays.html#Base.findlast-Tuple{Function, Any}","category":"method","text":"findlast(predicate::Function, A)\n\nReturn the index or key of the last element of A for which predicate returns true. Return nothing if there is no such element.\n\nIndices or keys are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [1, 2, 3, 4]\n4-element Vector{Int64}:\n 1\n 2\n 3\n 4\n\njulia> findlast(isodd, A)\n3\n\njulia> findlast(x -> x > 5, A) # returns nothing, but not printed in the REPL\n\njulia> A = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> findlast(isodd, A)\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findnext","location":"base/arrays.html#Base.findnext-Tuple{Any, Integer}","category":"method","text":"findnext(A, i)\n\nFind the next index after or including i of a true element of A, or nothing if not found.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [false, false, true, false]\n4-element Vector{Bool}:\n 0\n 0\n 1\n 0\n\njulia> findnext(A, 1)\n3\n\njulia> findnext(A, 4) # returns nothing, but not printed in the REPL\n\njulia> A = [false false; true false]\n2×2 Matrix{Bool}:\n 0  0\n 1  0\n\njulia> findnext(A, CartesianIndex(1, 1))\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findnext","location":"base/arrays.html#Base.findnext-Tuple{Function, Any, Integer}","category":"method","text":"findnext(predicate::Function, A, i)\n\nFind the next index after or including i of an element of A for which predicate returns true, or nothing if not found. This works for Arrays, Strings, and most other collections that support getindex, keys(A), and nextind.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [1, 4, 2, 2];\n\njulia> findnext(isodd, A, 1)\n1\n\njulia> findnext(isodd, A, 2) # returns nothing, but not printed in the REPL\n\njulia> A = [1 4; 2 2];\n\njulia> findnext(isodd, A, CartesianIndex(1, 1))\nCartesianIndex(1, 1)\n\njulia> findnext(isspace, \"a b c\", 3)\n4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findprev","location":"base/arrays.html#Base.findprev-Tuple{Any, Integer}","category":"method","text":"findprev(A, i)\n\nFind the previous index before or including i of a true element of A, or nothing if not found.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nSee also: findnext, findfirst, findall.\n\nExamples\n\njulia> A = [false, false, true, true]\n4-element Vector{Bool}:\n 0\n 0\n 1\n 1\n\njulia> findprev(A, 3)\n3\n\njulia> findprev(A, 1) # returns nothing, but not printed in the REPL\n\njulia> A = [false false; true true]\n2×2 Matrix{Bool}:\n 0  0\n 1  1\n\njulia> findprev(A, CartesianIndex(2, 1))\nCartesianIndex(2, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.findprev","location":"base/arrays.html#Base.findprev-Tuple{Function, Any, Integer}","category":"method","text":"findprev(predicate::Function, A, i)\n\nFind the previous index before or including i of an element of A for which predicate returns true, or nothing if not found. This works for Arrays, Strings, and most other collections that support getindex, keys(A), and nextind.\n\nIndices are of the same type as those returned by keys(A) and pairs(A).\n\nExamples\n\njulia> A = [4, 6, 1, 2]\n4-element Vector{Int64}:\n 4\n 6\n 1\n 2\n\njulia> findprev(isodd, A, 1) # returns nothing, but not printed in the REPL\n\njulia> findprev(isodd, A, 3)\n3\n\njulia> A = [4 6; 1 2]\n2×2 Matrix{Int64}:\n 4  6\n 1  2\n\njulia> findprev(isodd, A, CartesianIndex(1, 2))\nCartesianIndex(2, 1)\n\njulia> findprev(isspace, \"a b c\", 3)\n2\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.permutedims","location":"base/arrays.html#Base.permutedims","category":"function","text":"permutedims(A::AbstractArray, perm)\npermutedims(A::AbstractMatrix)\n\nPermute the dimensions (axes) of array A. perm is a tuple or vector of ndims(A) integers specifying the permutation.\n\nIf A is a 2d array (AbstractMatrix), then perm defaults to (2,1), swapping the two axes of A (the rows and columns of the matrix).   This differs from transpose in that the operation is not recursive, which is especially useful for arrays of non-numeric values (where the recursive transpose would throw an error) and/or 2d arrays that do not represent linear operators.\n\nFor 1d arrays, see permutedims(v::AbstractVector), which returns a 1-row “matrix”.\n\nSee also permutedims!, PermutedDimsArray, transpose, invperm.\n\nExamples\n\n2d arrays:\n\nUnlike transpose, permutedims can be used to swap rows and columns of 2d arrays of arbitrary non-numeric elements, such as strings:\n\njulia> A = [\"a\" \"b\" \"c\"\n            \"d\" \"e\" \"f\"]\n2×3 Matrix{String}:\n \"a\"  \"b\"  \"c\"\n \"d\"  \"e\"  \"f\"\n\njulia> permutedims(A)\n3×2 Matrix{String}:\n \"a\"  \"d\"\n \"b\"  \"e\"\n \"c\"  \"f\"\n\nAnd permutedims produces results that differ from transpose for matrices whose elements are themselves numeric matrices:\n\njulia> a = [1 2; 3 4];\n\njulia> b = [5 6; 7 8];\n\njulia> c = [9 10; 11 12];\n\njulia> d = [13 14; 15 16];\n\njulia> X = [[a] [b]; [c] [d]]\n2×2 Matrix{Matrix{Int64}}:\n [1 2; 3 4]     [5 6; 7 8]\n [9 10; 11 12]  [13 14; 15 16]\n\njulia> permutedims(X)\n2×2 Matrix{Matrix{Int64}}:\n [1 2; 3 4]  [9 10; 11 12]\n [5 6; 7 8]  [13 14; 15 16]\n\njulia> transpose(X)\n2×2 transpose(::Matrix{Matrix{Int64}}) with eltype Transpose{Int64, Matrix{Int64}}:\n [1 3; 2 4]  [9 11; 10 12]\n [5 7; 6 8]  [13 15; 14 16]\n\nMulti-dimensional arrays\n\njulia> A = reshape(Vector(1:8), (2,2,2))\n2×2×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  3\n 2  4\n\n[:, :, 2] =\n 5  7\n 6  8\n\njulia> perm = (3, 1, 2); # put the last dimension first\n\njulia> B = permutedims(A, perm)\n2×2×2 Array{Int64, 3}:\n[:, :, 1] =\n 1  2\n 5  6\n\n[:, :, 2] =\n 3  4\n 7  8\n\njulia> A == permutedims(B, invperm(perm)) # the inverse permutation\ntrue\n\nFor each dimension i of B = permutedims(A, perm), its corresponding dimension of A will be perm[i]. This means the equality size(B, i) == size(A, perm[i]) holds.\n\njulia> A = randn(5, 7, 11, 13);\n\njulia> perm = [4, 1, 3, 2];\n\njulia> B = permutedims(A, perm);\n\njulia> size(B)\n(13, 5, 11, 7)\n\njulia> size(A)[perm] == ans\ntrue\n\n\n\n\n\npermutedims(v::AbstractVector)\n\nReshape vector v into a 1 × length(v) row matrix. Differs from transpose in that the operation is not recursive, which is especially useful for arrays of non-numeric values (where the recursive transpose might throw an error).\n\nExamples\n\nUnlike transpose, permutedims can be used on vectors of arbitrary non-numeric elements, such as strings:\n\njulia> permutedims([\"a\", \"b\", \"c\"])\n1×3 Matrix{String}:\n \"a\"  \"b\"  \"c\"\n\nFor vectors of numbers, permutedims(v) works much like transpose(v) except that the return type differs (it uses reshape rather than a LinearAlgebra.Transpose view, though both share memory with the original array v):\n\njulia> v = [1, 2, 3, 4]\n4-element Vector{Int64}:\n 1\n 2\n 3\n 4\n\njulia> p = permutedims(v)\n1×4 Matrix{Int64}:\n 1  2  3  4\n\njulia> r = transpose(v)\n1×4 transpose(::Vector{Int64}) with eltype Int64:\n 1  2  3  4\n\njulia> p == r\ntrue\n\njulia> typeof(r)\nTranspose{Int64, Vector{Int64}}\n\njulia> p[1] = 5; r[2] = 6; # mutating p or r also changes v\n\njulia> v # shares memory with both p and r\n4-element Vector{Int64}:\n 5\n 6\n 3\n 4\n\nHowever, permutedims produces results that differ from transpose for vectors whose elements are themselves numeric matrices:\n\njulia> V = [[[1 2; 3 4]]; [[5 6; 7 8]]]\n2-element Vector{Matrix{Int64}}:\n [1 2; 3 4]\n [5 6; 7 8]\n\njulia> permutedims(V)\n1×2 Matrix{Matrix{Int64}}:\n [1 2; 3 4]  [5 6; 7 8]\n\njulia> transpose(V)\n1×2 transpose(::Vector{Matrix{Int64}}) with eltype Transpose{Int64, Matrix{Int64}}:\n [1 3; 2 4]  [5 7; 6 8]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.permutedims!","location":"base/arrays.html#Base.permutedims!","category":"function","text":"permutedims!(dest, src, perm)\n\nPermute the dimensions of array src and store the result in the array dest. perm is a vector specifying a permutation of length ndims(src). The preallocated array dest should have size(dest) == size(src)[perm] and is completely overwritten. No in-place permutation is supported and unexpected results will happen if src and dest have overlapping memory regions.\n\nSee also permutedims.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.PermutedDimsArrays.PermutedDimsArray","location":"base/arrays.html#Base.PermutedDimsArrays.PermutedDimsArray","category":"type","text":"PermutedDimsArray(A, perm) -> B\n\nGiven an AbstractArray A, create a view B such that the dimensions appear to be permuted. Similar to permutedims, except that no copying occurs (B shares storage with A).\n\nSee also permutedims, invperm.\n\nExamples\n\njulia> A = rand(3,5,4);\n\njulia> B = PermutedDimsArray(A, (3,1,2));\n\njulia> size(B)\n(4, 3, 5)\n\njulia> B[3,1,2] == A[1,2,3]\ntrue\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.promote_shape","location":"base/arrays.html#Base.promote_shape","category":"function","text":"promote_shape(s1, s2)\n\nCheck two array shapes for compatibility, allowing trailing singleton dimensions, and return whichever shape has more dimensions.\n\nExamples\n\njulia> a = fill(1, (3,4,1,1,1));\n\njulia> b = fill(1, (3,4));\n\njulia> promote_shape(a,b)\n(Base.OneTo(3), Base.OneTo(4), Base.OneTo(1), Base.OneTo(1), Base.OneTo(1))\n\njulia> promote_shape((2,3,1,4), (2, 3, 1, 4, 1))\n(2, 3, 1, 4, 1)\n\n\n\n\n\n","page":"Arrays"},{"title":"Array functions","location":"base/arrays.html#Array-functions","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.accumulate\nBase.accumulate!\nBase.cumprod\nBase.cumprod!\nBase.cumsum\nBase.cumsum!\nBase.diff\nBase.repeat\nBase.rot180\nBase.rotl90\nBase.rotr90\nBase.mapslices\nBase.eachrow\nBase.eachcol\nBase.eachslice","page":"Arrays"},{"title":"Base.accumulate","location":"base/arrays.html#Base.accumulate","category":"function","text":"accumulate(op, A; dims::Integer, [init])\n\nCumulative operation op along the dimension dims of A (providing dims is optional for vectors). An initial value init may optionally be provided by a keyword argument. See also accumulate! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow).\n\nFor common operations there are specialized variants of accumulate, see cumsum, cumprod. For a lazy version, see Iterators.accumulate.\n\ncompat: Julia 1.5\naccumulate on a non-array iterator requires at least Julia 1.5.\n\nExamples\n\njulia> accumulate(+, [1,2,3])\n3-element Vector{Int64}:\n 1\n 3\n 6\n\njulia> accumulate(min, (1, -2, 3, -4, 5), init=0)\n(0, -2, -2, -4, -4)\n\njulia> accumulate(/, (2, 4, Inf), init=100)\n(50.0, 12.5, 0.0)\n\njulia> accumulate(=>, i^2 for i in 1:3)\n3-element Vector{Any}:\n          1\n        1 => 4\n (1 => 4) => 9\n\njulia> accumulate(+, fill(1, 3, 4))\n3×4 Matrix{Int64}:\n 1  4  7  10\n 2  5  8  11\n 3  6  9  12\n\njulia> accumulate(+, fill(1, 2, 5), dims=2, init=100.0)\n2×5 Matrix{Float64}:\n 101.0  102.0  103.0  104.0  105.0\n 101.0  102.0  103.0  104.0  105.0\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.accumulate!","location":"base/arrays.html#Base.accumulate!","category":"function","text":"accumulate!(op, B, A; [dims], [init])\n\nCumulative operation op on A along the dimension dims, storing the result in B. Providing dims is optional for vectors.  If the keyword argument init is given, its value is used to instantiate the accumulation.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nSee also accumulate, cumsum!, cumprod!.\n\nExamples\n\njulia> x = [1, 0, 2, 0, 3];\n\njulia> y = rand(5);\n\njulia> accumulate!(+, y, x);\n\njulia> y\n5-element Vector{Float64}:\n 1.0\n 1.0\n 3.0\n 3.0\n 6.0\n\njulia> A = [1 2 3; 4 5 6];\n\njulia> B = similar(A);\n\njulia> accumulate!(-, B, A, dims=1)\n2×3 Matrix{Int64}:\n  1   2   3\n -3  -3  -3\n\njulia> accumulate!(*, B, A, dims=2, init=10)\n2×3 Matrix{Int64}:\n 10   20    60\n 40  200  1200\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumprod","location":"base/arrays.html#Base.cumprod","category":"function","text":"cumprod(A; dims::Integer)\n\nCumulative product along the dimension dim. See also cumprod! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow).\n\nExamples\n\njulia> a = Int8[1 2 3; 4 5 6];\n\njulia> cumprod(a, dims=1)\n2×3 Matrix{Int64}:\n 1   2   3\n 4  10  18\n\njulia> cumprod(a, dims=2)\n2×3 Matrix{Int64}:\n 1   2    6\n 4  20  120\n\n\n\n\n\ncumprod(itr)\n\nCumulative product of an iterator.\n\nSee also cumprod!, accumulate, cumsum.\n\ncompat: Julia 1.5\ncumprod on a non-array iterator requires at least Julia 1.5.\n\nExamples\n\njulia> cumprod(fill(1//2, 3))\n3-element Vector{Rational{Int64}}:\n 1//2\n 1//4\n 1//8\n\njulia> cumprod((1, 2, 1, 3, 1))\n(1, 2, 2, 6, 6)\n\njulia> cumprod(\"julia\")\n5-element Vector{String}:\n \"j\"\n \"ju\"\n \"jul\"\n \"juli\"\n \"julia\"\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumprod!","location":"base/arrays.html#Base.cumprod!","category":"function","text":"cumprod!(B, A; dims::Integer)\n\nCumulative product of A along the dimension dims, storing the result in B. See also cumprod.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\ncumprod!(y::AbstractVector, x::AbstractVector)\n\nCumulative product of a vector x, storing the result in y. See also cumprod.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumsum","location":"base/arrays.html#Base.cumsum","category":"function","text":"cumsum(A; dims::Integer)\n\nCumulative sum along the dimension dims. See also cumsum! to use a preallocated output array, both for performance and to control the precision of the output (e.g. to avoid overflow).\n\nExamples\n\njulia> a = [1 2 3; 4 5 6]\n2×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n\njulia> cumsum(a, dims=1)\n2×3 Matrix{Int64}:\n 1  2  3\n 5  7  9\n\njulia> cumsum(a, dims=2)\n2×3 Matrix{Int64}:\n 1  3   6\n 4  9  15\n\nnote: Note\nThe return array's eltype is Int for signed integers of less than system word size  and UInt for unsigned integers of less than system word size. To preserve eltype of arrays with small signed or unsigned integer accumulate(+, A) should be used.julia> cumsum(Int8[100, 28])\n2-element Vector{Int64}:\n 100\n 128\n\njulia> accumulate(+,Int8[100, 28])\n2-element Vector{Int8}:\n  100\n -128In the former case, the integers are widened to system word size and therefore the result is Int64[100, 128]. In the latter case, no such widening happens and integer overflow results in Int8[100, -128].\n\n\n\n\n\ncumsum(itr)\n\nCumulative sum of an iterator.\n\nSee also accumulate to apply functions other than +.\n\ncompat: Julia 1.5\ncumsum on a non-array iterator requires at least Julia 1.5.\n\nExamples\n\njulia> cumsum(1:3)\n3-element Vector{Int64}:\n 1\n 3\n 6\n\njulia> cumsum((true, false, true, false, true))\n(1, 1, 2, 2, 3)\n\njulia> cumsum(fill(1, 2) for i in 1:3)\n3-element Vector{Vector{Int64}}:\n [1, 1]\n [2, 2]\n [3, 3]\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.cumsum!","location":"base/arrays.html#Base.cumsum!","category":"function","text":"cumsum!(B, A; dims::Integer)\n\nCumulative sum of A along the dimension dims, storing the result in B. See also cumsum.\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.diff","location":"base/arrays.html#Base.diff","category":"function","text":"diff(A::AbstractVector)\ndiff(A::AbstractArray; dims::Integer)\n\nFinite difference operator on a vector or a multidimensional array A. In the latter case the dimension to operate on needs to be specified with the dims keyword argument.\n\ncompat: Julia 1.1\ndiff for arrays with dimension higher than 2 requires at least Julia 1.1.\n\nExamples\n\njulia> a = [2 4; 6 16]\n2×2 Matrix{Int64}:\n 2   4\n 6  16\n\njulia> diff(a, dims=2)\n2×1 Matrix{Int64}:\n  2\n 10\n\njulia> diff(vec(a))\n3-element Vector{Int64}:\n  4\n -2\n 12\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.repeat","location":"base/arrays.html#Base.repeat","category":"function","text":"repeat(A::AbstractArray, counts::Integer...)\n\nConstruct an array by repeating array A a given number of times in each dimension, specified by counts.\n\nSee also: fill, Iterators.repeated, Iterators.cycle.\n\nExamples\n\njulia> repeat([1, 2, 3], 2)\n6-element Vector{Int64}:\n 1\n 2\n 3\n 1\n 2\n 3\n\njulia> repeat([1, 2, 3], 2, 3)\n6×3 Matrix{Int64}:\n 1  1  1\n 2  2  2\n 3  3  3\n 1  1  1\n 2  2  2\n 3  3  3\n\n\n\n\n\nrepeat(A::AbstractArray; inner=ntuple(Returns(1), ndims(A)), outer=ntuple(Returns(1), ndims(A)))\n\nConstruct an array by repeating the entries of A. The i-th element of inner specifies the number of times that the individual entries of the i-th dimension of A should be repeated. The i-th element of outer specifies the number of times that a slice along the i-th dimension of A should be repeated. If inner or outer are omitted, no repetition is performed.\n\nExamples\n\njulia> repeat(1:2, inner=2)\n4-element Vector{Int64}:\n 1\n 1\n 2\n 2\n\njulia> repeat(1:2, outer=2)\n4-element Vector{Int64}:\n 1\n 2\n 1\n 2\n\njulia> repeat([1 2; 3 4], inner=(2, 1), outer=(1, 3))\n4×6 Matrix{Int64}:\n 1  2  1  2  1  2\n 1  2  1  2  1  2\n 3  4  3  4  3  4\n 3  4  3  4  3  4\n\n\n\n\n\nrepeat(s::AbstractString, r::Integer)\n\nRepeat a string r times. This can be written as s^r.\n\nSee also ^.\n\nExamples\n\njulia> repeat(\"ha\", 3)\n\"hahaha\"\n\n\n\n\n\nrepeat(c::AbstractChar, r::Integer) -> String\n\nRepeat a character r times. This can equivalently be accomplished by calling c^r.\n\nExamples\n\njulia> repeat('A', 3)\n\"AAA\"\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.rot180","location":"base/arrays.html#Base.rot180","category":"function","text":"rot180(A)\n\nRotate matrix A 180 degrees.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rot180(a)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\n\n\n\n\nrot180(A, k)\n\nRotate matrix A 180 degrees an integer k number of times. If k is even, this is equivalent to a copy.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rot180(a,1)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\njulia> rot180(a,2)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.rotl90","location":"base/arrays.html#Base.rotl90","category":"function","text":"rotl90(A)\n\nRotate matrix A left 90 degrees.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotl90(a)\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\n\n\n\n\nrotl90(A, k)\n\nLeft-rotate matrix A 90 degrees counterclockwise an integer k number of times. If k is a multiple of four (including zero), this is equivalent to a copy.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotl90(a,1)\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\njulia> rotl90(a,2)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\njulia> rotl90(a,3)\n2×2 Matrix{Int64}:\n 3  1\n 4  2\n\njulia> rotl90(a,4)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.rotr90","location":"base/arrays.html#Base.rotr90","category":"function","text":"rotr90(A)\n\nRotate matrix A right 90 degrees.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotr90(a)\n2×2 Matrix{Int64}:\n 3  1\n 4  2\n\n\n\n\n\nrotr90(A, k)\n\nRight-rotate matrix A 90 degrees clockwise an integer k number of times. If k is a multiple of four (including zero), this is equivalent to a copy.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> rotr90(a,1)\n2×2 Matrix{Int64}:\n 3  1\n 4  2\n\njulia> rotr90(a,2)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\njulia> rotr90(a,3)\n2×2 Matrix{Int64}:\n 2  4\n 1  3\n\njulia> rotr90(a,4)\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.mapslices","location":"base/arrays.html#Base.mapslices","category":"function","text":"mapslices(f, A; dims)\n\nTransform the given dimensions of array A by applying a function f on each slice of the form A[..., :, ..., :, ...], with a colon at each d in dims. The results are concatenated along the remaining dimensions.\n\nFor example, if dims = [1,2] and A is 4-dimensional, then f is called on x = A[:,:,i,j] for all i and j, and f(x) becomes R[:,:,i,j] in the result R.\n\nSee also eachcol or eachslice, used with map or stack.\n\nExamples\n\njulia> A = reshape(1:30,(2,5,3))\n2×5×3 reshape(::UnitRange{Int32}, 2, 5, 3) with eltype Int32:\n[:, :, 1] =\n 1  3  5  7   9\n 2  4  6  8  10\n\n[:, :, 2] =\n 11  13  15  17  19\n 12  14  16  18  20\n\n[:, :, 3] =\n 21  23  25  27  29\n 22  24  26  28  30\n\njulia> f(x::Matrix) = fill(x[1,1], 1,4);  # returns a 1×4 matrix\n\njulia> B = mapslices(f, A, dims=(1,2))\n1×4×3 Array{Int32, 3}:\n[:, :, 1] =\n 1  1  1  1\n\n[:, :, 2] =\n 11  11  11  11\n\n[:, :, 3] =\n 21  21  21  21\n\njulia> f2(x::AbstractMatrix) = fill(x[1,1], 1,4);\n\njulia> B == stack(f2, eachslice(A, dims=3))\ntrue\n\njulia> g(x) = x[begin] // x[end-1];  # returns a number\n\njulia> mapslices(g, A, dims=[1,3])\n1×5×1 Array{Rational{Int32}, 3}:\n[:, :, 1] =\n 1//21  3//23  1//5  7//27  9//29\n\njulia> map(g, eachslice(A, dims=2))\n5-element Vector{Rational{Int32}}:\n 1//21\n 3//23\n 1//5\n 7//27\n 9//29\n\njulia> mapslices(sum, A; dims=(1,3)) == sum(A; dims=(1,3))\ntrue\n\nNotice that in eachslice(A; dims=2), the specified dimension is the one without a colon in the slice. This is view(A,:,i,:), whereas mapslices(f, A; dims=(1,3)) uses A[:,i,:]. The function f may mutate values in the slice without affecting A.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachrow","location":"base/arrays.html#Base.eachrow","category":"function","text":"eachrow(A::AbstractVecOrMat) <: AbstractVector\n\nCreate a RowSlices object that is a vector of rows of matrix or vector A. Row slices are returned as AbstractVector views of A.\n\nFor the inverse, see stack(rows; dims=1).\n\nSee also eachcol, eachslice and mapslices.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\ncompat: Julia 1.9\nPrior to Julia 1.9, this returned an iterator.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> s = eachrow(a)\n2-element RowSlices{Matrix{Int64}, Tuple{Base.OneTo{Int64}}, SubArray{Int64, 1, Matrix{Int64}, Tuple{Int64, Base.Slice{Base.OneTo{Int64}}}, true}}:\n [1, 2]\n [3, 4]\n\njulia> s[1]\n2-element view(::Matrix{Int64}, 1, :) with eltype Int64:\n 1\n 2\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachcol","location":"base/arrays.html#Base.eachcol","category":"function","text":"eachcol(A::AbstractVecOrMat) <: AbstractVector\n\nCreate a ColumnSlices object that is a vector of columns of matrix or vector A. Column slices are returned as AbstractVector views of A.\n\nFor the inverse, see stack(cols) or reduce(hcat, cols).\n\nSee also eachrow, eachslice and mapslices.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\ncompat: Julia 1.9\nPrior to Julia 1.9, this returned an iterator.\n\nExamples\n\njulia> a = [1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> s = eachcol(a)\n2-element ColumnSlices{Matrix{Int64}, Tuple{Base.OneTo{Int64}}, SubArray{Int64, 1, Matrix{Int64}, Tuple{Base.Slice{Base.OneTo{Int64}}, Int64}, true}}:\n [1, 3]\n [2, 4]\n\njulia> s[1]\n2-element view(::Matrix{Int64}, :, 1) with eltype Int64:\n 1\n 3\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.eachslice","location":"base/arrays.html#Base.eachslice","category":"function","text":"eachslice(A::AbstractArray; dims, drop=true)\n\nCreate a Slices object that is an array of slices over dimensions dims of A, returning views that select all the data from the other dimensions in A. dims can either be an integer or a tuple of integers.\n\nIf drop = true (the default), the outer Slices will drop the inner dimensions, and the ordering of the dimensions will match those in dims. If drop = false, then the Slices will have the same dimensionality as the underlying array, with inner dimensions having size 1.\n\nSee stack(slices; dims) for the inverse of eachslice(A; dims::Integer).\n\nSee also eachrow, eachcol, mapslices and selectdim.\n\ncompat: Julia 1.1\nThis function requires at least Julia 1.1.\n\ncompat: Julia 1.9\nPrior to Julia 1.9, this returned an iterator, and only a single dimension dims was supported.\n\nExamples\n\njulia> m = [1 2 3; 4 5 6; 7 8 9]\n3×3 Matrix{Int64}:\n 1  2  3\n 4  5  6\n 7  8  9\n\njulia> s = eachslice(m, dims=1)\n3-element RowSlices{Matrix{Int64}, Tuple{Base.OneTo{Int64}}, SubArray{Int64, 1, Matrix{Int64}, Tuple{Int64, Base.Slice{Base.OneTo{Int64}}}, true}}:\n [1, 2, 3]\n [4, 5, 6]\n [7, 8, 9]\n\njulia> s[1]\n3-element view(::Matrix{Int64}, 1, :) with eltype Int64:\n 1\n 2\n 3\n\njulia> eachslice(m, dims=1, drop=false)\n3×1 Slices{Matrix{Int64}, Tuple{Int64, Colon}, Tuple{Base.OneTo{Int64}, Base.OneTo{Int64}}, SubArray{Int64, 1, Matrix{Int64}, Tuple{Int64, Base.Slice{Base.OneTo{Int64}}}, true}, 2}:\n [1, 2, 3]\n [4, 5, 6]\n [7, 8, 9]\n\n\n\n\n\n","page":"Arrays"},{"title":"Combinatorics","location":"base/arrays.html#Combinatorics","category":"section","text":"","page":"Arrays"},{"title":"Arrays","location":"base/arrays.html","category":"page","text":"Base.invperm\nBase.isperm\nBase.permute!(::Any, ::AbstractVector)\nBase.invpermute!\nBase.reverse(::AbstractVector; kwargs...)\nBase.reverseind\nBase.reverse!","page":"Arrays"},{"title":"Base.invperm","location":"base/arrays.html#Base.invperm","category":"function","text":"invperm(v)\n\nReturn the inverse permutation of v. If B = A[v], then A == B[invperm(v)].\n\nSee also sortperm, invpermute!, isperm, permutedims.\n\nExamples\n\njulia> p = (2, 3, 1);\n\njulia> invperm(p)\n(3, 1, 2)\n\njulia> v = [2; 4; 3; 1];\n\njulia> invperm(v)\n4-element Vector{Int64}:\n 4\n 1\n 3\n 2\n\njulia> A = ['a','b','c','d'];\n\njulia> B = A[v]\n4-element Vector{Char}:\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'd': ASCII/Unicode U+0064 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n 'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n\njulia> B[invperm(v)]\n4-element Vector{Char}:\n 'a': ASCII/Unicode U+0061 (category Ll: Letter, lowercase)\n 'b': ASCII/Unicode U+0062 (category Ll: Letter, lowercase)\n 'c': ASCII/Unicode U+0063 (category Ll: Letter, lowercase)\n 'd': ASCII/Unicode U+0064 (category Ll: Letter, lowercase)\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.isperm","location":"base/arrays.html#Base.isperm","category":"function","text":"isperm(v) -> Bool\n\nReturn true if v is a valid permutation.\n\nExamples\n\njulia> isperm([1; 2])\ntrue\n\njulia> isperm([1; 3])\nfalse\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.permute!","location":"base/arrays.html#Base.permute!-Tuple{Any, AbstractVector}","category":"method","text":"permute!(v, p)\n\nPermute vector v in-place, according to permutation p. No checking is done to verify that p is a permutation.\n\nTo return a new permutation, use v[p]. This is generally faster than permute!(v, p); it is even faster to write into a pre-allocated output array with u .= @view v[p]. (Even though permute! overwrites v in-place, it internally requires some allocation to keep track of which elements have been moved.)\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nSee also invpermute!.\n\nExamples\n\njulia> A = [1, 1, 3, 4];\n\njulia> perm = [2, 4, 3, 1];\n\njulia> permute!(A, perm);\n\njulia> A\n4-element Vector{Int64}:\n 1\n 4\n 3\n 1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.invpermute!","location":"base/arrays.html#Base.invpermute!","category":"function","text":"invpermute!(v, p)\n\nLike permute!, but the inverse of the given permutation is applied.\n\nNote that if you have a pre-allocated output array (e.g. u = similar(v)), it is quicker to instead employ u[p] = v.  (invpermute! internally allocates a copy of the data.)\n\nwarning: Warning\nBehavior can be unexpected when any mutated argument shares memory with any other argument.\n\nExamples\n\njulia> A = [1, 1, 3, 4];\n\njulia> perm = [2, 4, 3, 1];\n\njulia> invpermute!(A, perm);\n\njulia> A\n4-element Vector{Int64}:\n 4\n 1\n 3\n 1\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reverse","location":"base/arrays.html#Base.reverse-Tuple{AbstractVector}","category":"method","text":"reverse(A; dims=:)\n\nReverse A along dimension dims, which can be an integer (a single dimension), a tuple of integers (a tuple of dimensions) or : (reverse along all the dimensions, the default).  See also reverse! for in-place reversal.\n\nExamples\n\njulia> b = Int64[1 2; 3 4]\n2×2 Matrix{Int64}:\n 1  2\n 3  4\n\njulia> reverse(b, dims=2)\n2×2 Matrix{Int64}:\n 2  1\n 4  3\n\njulia> reverse(b)\n2×2 Matrix{Int64}:\n 4  3\n 2  1\n\ncompat: Julia 1.6\nPrior to Julia 1.6, only single-integer dims are supported in reverse.\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reverseind","location":"base/arrays.html#Base.reverseind","category":"function","text":"reverseind(v, i)\n\nGiven an index i in reverse(v), return the corresponding index in v so that v[reverseind(v,i)] == reverse(v)[i]. (This can be nontrivial in cases where v contains non-ASCII characters.)\n\nExamples\n\njulia> s = \"Julia🚀\"\n\"Julia🚀\"\n\njulia> r = reverse(s)\n\"🚀ailuJ\"\n\njulia> for i in eachindex(s)\n           print(r[reverseind(r, i)])\n       end\nJulia🚀\n\n\n\n\n\n","page":"Arrays"},{"title":"Base.reverse!","location":"base/arrays.html#Base.reverse!","category":"function","text":"reverse!(v [, start=firstindex(v) [, stop=lastindex(v) ]]) -> v\n\nIn-place version of reverse.\n\nExamples\n\njulia> A = Vector(1:5)\n5-element Vector{Int64}:\n 1\n 2\n 3\n 4\n 5\n\njulia> reverse!(A);\n\njulia> A\n5-element Vector{Int64}:\n 5\n 4\n 3\n 2\n 1\n\n\n\n\n\nreverse!(A; dims=:)\n\nLike reverse, but operates in-place in A.\n\ncompat: Julia 1.6\nMultidimensional reverse! requires Julia 1.6.\n\n\n\n\n\n","page":"Arrays"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html#Julia-SSA-form-IR","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Julia uses a static single assignment intermediate representation (SSA IR) to perform optimization. This IR is different from LLVM IR, and unique to Julia. It allows for Julia specific optimizations.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Basic blocks (regions with no control flow) are explicitly annotated.\nif/else and loops are turned into goto statements.\nlines with multiple operations are split into multiple lines by introducing variables.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"For example the following Julia code:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"function foo(x)\n    y = sin(x)\n    if x > 5.0\n        y = y + cos(x)\n    end\n    return exp(2) + y\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"when called with a Float64 argument is translated into:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"using InteractiveUtils\n@code_typed foo(1.0)","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"CodeInfo(\n1 ─ %1 = invoke Main.sin(x::Float64)::Float64\n│   %2 = Base.lt_float(x, 5.0)::Bool\n└──      goto #3 if not %2\n2 ─ %4 = invoke Main.cos(x::Float64)::Float64\n└── %5 = Base.add_float(%1, %4)::Float64\n3 ┄ %6 = φ (#2 => %5, #1 => %1)::Float64\n│   %7 = Base.add_float(7.38905609893065, %6)::Float64\n└──      return %7\n) => Float64","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"In this example, we can see all of these changes.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The first basic block is everything in","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"1 ─ %1 = invoke Main.sin(x::Float64)::Float64\n│   %2 = Base.lt_float(x, 5.0)::Bool\n└──      goto #3 if not %2","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The if statement is translated into goto #3 if not %2 which goes to the 3rd basic block if x>5 isn't met and otherwise goes to the second basic block.\n%2 is an SSA value introduced to represent x > 5.","page":"Julia SSA-form IR"},{"title":"Background","location":"devdocs/ssair.html#Background","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Beginning in Julia 0.7, parts of the compiler use a new SSA-form intermediate representation (IR). Historically, the compiler would directly generate LLVM IR from a lowered form of the Julia AST. This form had most syntactic abstractions removed, but still looked a lot like an abstract syntax tree. Over time, in order to facilitate optimizations, SSA values were introduced to this IR and the IR was linearized (i.e. turned into a form where function arguments could only be SSA values or constants). However, non-SSA values (slots) remained in the IR due to the lack of Phi nodes in the IR (necessary for back-edges and re-merging of conditional control flow). This negated much of the usefulness of SSA form representation when performing middle end optimizations. Some heroic effort was put into making these optimizations work without a complete SSA form representation, but the lack of such a representation ultimately proved prohibitive.","page":"Julia SSA-form IR"},{"title":"Categories of IR nodes","location":"devdocs/ssair.html#Categories-of-IR-nodes","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The SSA IR representation has four categories of IR nodes: Phi, Pi, PhiC, and Upsilon nodes (the latter two are only used for exception handling).","page":"Julia SSA-form IR"},{"title":"Phi nodes and Pi nodes","location":"devdocs/ssair.html#Phi-nodes-and-Pi-nodes","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Phi nodes are part of generic SSA abstraction (see the link above if you're not familiar with the concept). In the Julia IR, these nodes are represented as:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"struct PhiNode\n    edges::Vector{Int32}\n    values::Vector{Any}\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"where we ensure that both vectors always have the same length. In the canonical representation (the one handled by codegen and the interpreter), the edge values indicate come-from statement numbers (i.e. if edge has an entry of 15, there must be a goto, gotoifnot or implicit fall through from statement 15 that targets this phi node). Values are either SSA values or constants. It is also possible for a value to be unassigned if the variable was not defined on this path. However, undefinedness checks get explicitly inserted and represented as booleans after middle end optimizations, so code generators may assume that any use of a Phi node will have an assigned value in the corresponding slot. It is also legal for the mapping to be incomplete, i.e. for a Phi node to have missing incoming edges. In that case, it must be dynamically guaranteed that the corresponding value will not be used.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Note that SSA uses semantically occur after the terminator of the corresponding predecessor (\"on the edge\"). Consequently, if multiple Phi nodes appear at the start of a basic block, they are run simultaneously. This means that in the following IR snippet, if we came from block 23, %46 will take the value associated to %45 before we entered this block.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"%45 = φ (#18 => %23, #23 => %50)\n%46 = φ (#18 => 1.0, #23 => %45)","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"PiNodes encode statically proven information that may be implicitly assumed in basic blocks dominated by a given pi node. They are conceptually equivalent to the technique introduced in the paper ABCD: Eliminating Array Bounds Checks on Demand or the predicate info nodes in LLVM. To see how they work, consider, e.g.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"%x::Union{Int, Float64} # %x is some Union{Int, Float64} typed ssa value\nif isa(x, Int)\n    # use x\nelse\n    # use x\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"We can perform predicate insertion and turn this into:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"%x::Union{Int, Float64} # %x is some Union{Int, Float64} typed ssa value\nif isa(x, Int)\n    %x_int = PiNode(x, Int)\n    # use %x_int\nelse\n    %x_float = PiNode(x, Float64)\n    # use %x_float\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Pi nodes are generally ignored in the interpreter, since they don't have any effect on the values, but they may sometimes lead to code generation in the compiler (e.g. to change from an implicitly union split representation to a plain unboxed representation). The main usefulness of PiNodes stems from the fact that path conditions of the values can be accumulated simply by def-use chain walking that is generally done for most optimizations that care about these conditions anyway.","page":"Julia SSA-form IR"},{"title":"PhiC nodes and Upsilon nodes","location":"devdocs/ssair.html#PhiC-nodes-and-Upsilon-nodes","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Exception handling complicates the SSA story moderately, because exception handling introduces additional control flow edges into the IR across which values must be tracked. One approach to do so, which is followed by LLVM, is to make calls which may throw exceptions into basic block terminators and add an explicit control flow edge to the catch handler:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"invoke @function_that_may_throw() to label %regular unwind to %catch\n\nregular:\n# Control flow continues here\n\ncatch:\n# Exceptions go here","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"However, this is problematic in a language like Julia, where at the start of the optimization pipeline, we do not know which calls throw. We would have to conservatively assume that every call (which in Julia is every statement) throws. This would have several negative effects. On the one hand, it would essentially reduce the scope of every basic block to a single call, defeating the purpose of having operations be performed at the basic block level. On the other hand, every catch basic block would have n*m phi node arguments (n, the number of statements in the critical region, m the number of live values through the catch block).","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"To work around this, we use a combination of Upsilon and PhiC nodes (the C standing for catch, written φᶜ in the IR pretty printer, because unicode subscript c is not available). There are several ways to think of these nodes, but perhaps the easiest is to think of each PhiC as a load from a unique store-many, read-once slot, with Upsilon being the corresponding store operation. The PhiC has an operand list of all the upsilon nodes that store to its implicit slot. The Upsilon nodes however, do not record which PhiC node they store to. This is done for more natural integration with the rest of the SSA IR. E.g. if there are no more uses of a PhiC node, it is safe to delete it, and the same is true of an Upsilon node. In most IR passes, PhiC nodes can be treated like Phi nodes. One can follow use-def chains through them, and they can be lifted to new PhiC nodes and new Upsilon nodes (in the same places as the original Upsilon nodes). The result of this scheme is that the number of Upsilon nodes (and PhiC arguments) is proportional to the number of assigned values to a particular variable (before SSA conversion), rather than the number of statements in the critical region.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"To see this scheme in action, consider the function","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"@noinline opaque() = invokelatest(identity, nothing) # Something opaque\nfunction foo()\n    local y\n    x = 1\n    try\n        y = 2\n        opaque()\n        y = 3\n        error()\n    catch\n    end\n    (x, y)\nend","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The corresponding IR (with irrelevant types stripped) is:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"1 ─       nothing::Nothing\n2 ─ %2  = $(Expr(:enter, #4))\n3 ─ %3  = ϒ (false)\n│   %4  = ϒ (#undef)\n│   %5  = ϒ (1)\n│   %6  = ϒ (true)\n│   %7  = ϒ (2)\n│         invoke Main.opaque()::Any\n│   %9  = ϒ (true)\n│   %10 = ϒ (3)\n│         invoke Main.error()::Union{}\n└──       $(Expr(:unreachable))::Union{}\n4 ┄ %13 = φᶜ (%3, %6, %9)::Bool\n│   %14 = φᶜ (%4, %7, %10)::Core.Compiler.MaybeUndef(Int64)\n│   %15 = φᶜ (%5)::Core.Const(1)\n└──       $(Expr(:leave, Core.SSAValue(2)))\n5 ─       $(Expr(:pop_exception, :(%2)))::Any\n│         $(Expr(:throw_undef_if_not, :y, :(%13)))::Any\n│   %19 = Core.tuple(%15, %14)\n└──       return %19","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Note in particular that every value live into the critical region gets an upsilon node at the top of the critical region. This is because catch blocks are considered to have an invisible control flow edge from outside the function. As a result, no SSA value dominates the catch blocks, and all incoming values have to come through a φᶜ node.","page":"Julia SSA-form IR"},{"title":"Main SSA data structure","location":"devdocs/ssair.html#Main-SSA-data-structure","category":"section","text":"","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The main SSAIR data structure is worthy of discussion. It draws inspiration from LLVM and Webkit's B3 IR. The core of the data structure is a flat vector of statements. Each statement is implicitly assigned an SSA value based on its position in the vector (i.e. the result of the statement at idx 1 can be accessed using SSAValue(1) etc). For each SSA value, we additionally maintain its type. Since, SSA values are definitionally assigned only once, this type is also the result type of the expression at the corresponding index. However, while this representation is rather efficient (since the assignments don't need to be explicitly encoded), it of course carries the drawback that order is semantically significant, so reorderings and insertions change statement numbers. Additionally, we do not keep use lists (i.e. it is impossible to walk from a def to all its uses without explicitly computing this map–def lists however are trivial since you can look up the corresponding statement from the index), so the LLVM-style RAUW (replace-all-uses-with) operation is unavailable.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"Instead, we do the following:","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"We keep a separate buffer of nodes to insert (including the position to insert them at, the type of the corresponding value and the node itself). These nodes are numbered by their occurrence in the insertion buffer, allowing their values to be immediately used elsewhere in the IR (i.e. if there are 12 statements in the original statement list, the first new statement will be accessible as SSAValue(13)).\nRAUW style operations are performed by setting the corresponding statement index to the replacement value.\nStatements are erased by setting the corresponding statement to nothing (this is essentially just a special-case convention of the above).\nIf there are any uses of the statement being erased, they will be set to nothing.","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"There is a compact! function that compacts the above data structure by performing the insertion of nodes in the appropriate place, trivial copy propagation, and renaming of uses to any changed SSA values. However, the clever part of this scheme is that this compaction can be done lazily as part of the subsequent pass. Most optimization passes need to walk over the entire list of statements, performing analysis or modifications along the way. We provide an IncrementalCompact iterator that can be used to iterate over the statement list. It will perform any necessary compaction and return the new index of the node, as well as the node itself. It is legal at this point to walk def-use chains, as well as make any modifications or deletions to the IR (insertions are disallowed however).","page":"Julia SSA-form IR"},{"title":"Julia SSA-form IR","location":"devdocs/ssair.html","category":"page","text":"The idea behind this arrangement is that, since the optimization passes need to touch the corresponding memory anyway and incur the corresponding memory access penalty, performing the extra housekeeping should have comparatively little overhead (and save the overhead of maintaining these data structures during IR modification).","page":"Julia SSA-form IR"},{"title":"StackTraces","location":"base/stacktraces.html#StackTraces","category":"section","text":"","page":"StackTraces"},{"title":"StackTraces","location":"base/stacktraces.html","category":"page","text":"Base.StackTraces.StackFrame\nBase.StackTraces.StackTrace\nBase.StackTraces.stacktrace","page":"StackTraces"},{"title":"Base.StackTraces.StackFrame","location":"base/stacktraces.html#Base.StackTraces.StackFrame","category":"type","text":"StackFrame\n\nStack information representing execution context, with the following fields:\n\nfunc::Symbol\nThe name of the function containing the execution context.\nlinfo::Union{Core.MethodInstance, Method, Module, Core.CodeInfo, Nothing}\nThe MethodInstance or CodeInfo containing the execution context (if it could be found), or Module (for macro expansions)\"\nfile::Symbol\nThe path to the file containing the execution context.\nline::Int\nThe line number in the file containing the execution context.\nfrom_c::Bool\nTrue if the code is from C.\ninlined::Bool\nTrue if the code is from an inlined frame.\npointer::UInt64\nRepresentation of the pointer to the execution context as returned by backtrace.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Base.StackTraces.StackTrace","location":"base/stacktraces.html#Base.StackTraces.StackTrace","category":"type","text":"StackTrace\n\nAn alias for Vector{StackFrame} provided for convenience; returned by calls to stacktrace.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Base.StackTraces.stacktrace","location":"base/stacktraces.html#Base.StackTraces.stacktrace","category":"function","text":"stacktrace([trace::Vector{Ptr{Cvoid}},] [c_funcs::Bool=false]) -> StackTrace\n\nReturn a stack trace in the form of a vector of StackFrames. (By default stacktrace doesn't return C functions, but this can be enabled.) When called without specifying a trace, stacktrace first calls backtrace.\n\n\n\n\n\n","page":"StackTraces"},{"title":"StackTraces","location":"base/stacktraces.html","category":"page","text":"The following methods and types in Base.StackTraces are not exported and need to be called e.g. as StackTraces.lookup(ptr).","page":"StackTraces"},{"title":"StackTraces","location":"base/stacktraces.html","category":"page","text":"Base.StackTraces.lookup\nBase.StackTraces.remove_frames!","page":"StackTraces"},{"title":"Base.StackTraces.lookup","location":"base/stacktraces.html#Base.StackTraces.lookup","category":"function","text":"lookup(pointer::Ptr{Cvoid}) -> Vector{StackFrame}\n\nGiven a pointer to an execution context (usually generated by a call to backtrace), looks up stack frame context information. Returns an array of frame information for all functions inlined at that point, innermost function first.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Base.StackTraces.remove_frames!","location":"base/stacktraces.html#Base.StackTraces.remove_frames!","category":"function","text":"remove_frames!(stack::StackTrace, name::Symbol)\n\nTakes a StackTrace (a vector of StackFrames) and a function name (a Symbol) and removes the StackFrame specified by the function name from the StackTrace (also removing all frames above the specified function). Primarily used to remove StackTraces functions from the StackTrace prior to returning it.\n\n\n\n\n\nremove_frames!(stack::StackTrace, m::Module)\n\nReturn the StackTrace with all StackFrames from the provided Module removed.\n\n\n\n\n\n","page":"StackTraces"},{"title":"Julia Functions","location":"devdocs/functions.html#Julia-Functions","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This document will explain how functions, method definitions, and method tables work.","page":"Julia Functions"},{"title":"Method Tables","location":"devdocs/functions.html#Method-Tables","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Every function in Julia is a generic function. A generic function is conceptually a single function, but consists of many definitions, or methods. The methods of a generic function are stored in a method table. Method tables (type MethodTable) are associated with TypeNames. A TypeName describes a family of parameterized types. For example Complex{Float32} and Complex{Float64} share the same Complex type name object.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"All objects in Julia are potentially callable, because every object has a type, which in turn has a TypeName.","page":"Julia Functions"},{"title":"Function calls","location":"devdocs/functions.html#Function-calls","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Given the call f(x, y), the following steps are performed: first, the method table to use is accessed as typeof(f).name.mt. Second, an argument tuple type is formed, Tuple{typeof(f), typeof(x), typeof(y)}. Note that the type of the function itself is the first element. This is because the type might have parameters, and so needs to take part in dispatch. This tuple type is looked up in the method table.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This dispatch process is performed by jl_apply_generic, which takes two arguments: a pointer to an array of the values f, x, and y, and the number of values (in this case 3).","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Throughout the system, there are two kinds of APIs that handle functions and argument lists: those that accept the function and arguments separately, and those that accept a single argument structure. In the first kind of API, the \"arguments\" part does not contain information about the function, since that is passed separately. In the second kind of API, the function is the first element of the argument structure.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"For example, the following function for performing a call accepts just an args pointer, so the first element of the args array will be the function to call:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"jl_value_t *jl_apply(jl_value_t **args, uint32_t nargs)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This entry point for the same functionality accepts the function separately, so the args array does not contain the function:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"jl_value_t *jl_call(jl_function_t *f, jl_value_t **args, int32_t nargs);","page":"Julia Functions"},{"title":"Adding methods","location":"devdocs/functions.html#Adding-methods","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Given the above dispatch process, conceptually all that is needed to add a new method is (1) a tuple type, and (2) code for the body of the method. jl_method_def implements this operation. jl_method_table_for is called to extract the relevant method table from what would be the type of the first argument. This is much more complicated than the corresponding procedure during dispatch, since the argument tuple type might be abstract. For example, we can define:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"(::Union{Foo{Int},Foo{Int8}})(x) = 0","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"which works since all possible matching methods would belong to the same method table.","page":"Julia Functions"},{"title":"Creating generic functions","location":"devdocs/functions.html#Creating-generic-functions","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Since every object is callable, nothing special is needed to create a generic function. Therefore jl_new_generic_function simply creates a new singleton (0 size) subtype of Function and returns its instance. A function can have a mnemonic \"display name\" which is used in debug info and when printing objects. For example the name of Base.sin is sin. By convention, the name of the created type is the same as the function name, with a # prepended. So typeof(sin) is Base.#sin.","page":"Julia Functions"},{"title":"Closures","location":"devdocs/functions.html#Closures","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"A closure is simply a callable object with field names corresponding to captured variables. For example, the following code:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function adder(x)\n    return y->x+y\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"is lowered to (roughly):","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"struct ##1{T}\n    x::T\nend\n\n(_::##1)(y) = _.x + y\n\nfunction adder(x)\n    return ##1(x)\nend","page":"Julia Functions"},{"title":"Constructors","location":"devdocs/functions.html#Constructors","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"A constructor call is just a call to a type. The method table for Type contains all constructor definitions. All subtypes of Type (Type, UnionAll, Union, and DataType) currently share a method table via special arrangement.","page":"Julia Functions"},{"title":"Builtins","location":"devdocs/functions.html#Builtins","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The \"builtin\" functions, defined in the Core module, are:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function lines(words)\n    io = IOBuffer()\n    n = 0\n    for w in words\n        if n+length(w) > 80\n            print(io, '\\n', w)\n            n = length(w)\n        elseif n == 0\n            print(io, w);\n            n += length(w)\n        else\n            print(io, ' ', w);\n            n += length(w)+1\n        end\n    end\n    String(take!(io))\nend\nimport Markdown\n[string(n) for n in names(Core;all=true)\n    if getfield(Core,n) isa Core.Builtin && nameof(getfield(Core,n)) === n] |>\n    lines |>\n    s ->  \"```\\n$s\\n```\" |>\n    Markdown.parse","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"These are all singleton objects whose types are subtypes of Builtin, which is a subtype of Function. Their purpose is to expose entry points in the run time that use the \"jlcall\" calling convention:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"jl_value_t *(jl_value_t*, jl_value_t**, uint32_t)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The method tables of builtins are empty. Instead, they have a single catch-all method cache entry (Tuple{Vararg{Any}}) whose jlcall fptr points to the correct function. This is kind of a hack but works reasonably well.","page":"Julia Functions"},{"title":"Keyword arguments","location":"devdocs/functions.html#Keyword-arguments","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Keyword arguments work by adding methods to the kwcall function. This function is usually the \"keyword argument sorter\" or \"keyword sorter\", which then calls the inner body of the function (defined anonymously). Every definition in the kwsorter function has the same arguments as some definition in the normal method table, except with a single NamedTuple argument prepended, which gives the names and values of passed keyword arguments. The kwsorter's job is to move keyword arguments into their canonical positions based on name, plus evaluate and substitute any needed default value expressions. The result is a normal positional argument list, which is then passed to yet another compiler-generated function.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The easiest way to understand the process is to look at how a keyword argument method definition is lowered. The code:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function circle(center, radius; color = black, fill::Bool = true, options...)\n    # draw\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"actually produces three method definitions. The first is a function that accepts all arguments (including keyword arguments) as positional arguments, and includes the code for the method body. It has an auto-generated name:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function #circle#1(color, fill::Bool, options, circle, center, radius)\n    # draw\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The second method is an ordinary definition for the original circle function, which handles the case where no keyword arguments are passed:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function circle(center, radius)\n    #circle#1(black, true, pairs(NamedTuple()), circle, center, radius)\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This simply dispatches to the first method, passing along default values. pairs is applied to the named tuple of rest arguments to provide key-value pair iteration. Note that if the method doesn't accept rest keyword arguments then this argument is absent.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Finally there is the kwsorter definition:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"function (::Core.kwftype(typeof(circle)))(kws, circle, center, radius)\n    if haskey(kws, :color)\n        color = kws.color\n    else\n        color = black\n    end\n    # etc.\n\n    # put remaining kwargs in `options`\n    options = structdiff(kws, NamedTuple{(:color, :fill)})\n\n    # if the method doesn't accept rest keywords, throw an error\n    # unless `options` is empty\n\n    #circle#1(color, fill, pairs(options), circle, center, radius)\nend","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The function Core.kwftype(t) creates the field t.name.mt.kwsorter (if it hasn't been created yet), and returns the type of that function.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"This design has the feature that call sites that don't use keyword arguments require no special handling; everything works as if they were not part of the language at all. Call sites that do use keyword arguments are dispatched directly to the called function's kwsorter. For example the call:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"circle((0, 0), 1.0, color = red; other...)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"is lowered to:","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"kwcall(merge((color = red,), other), circle, (0, 0), 1.0)","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"kwcall (also inCore) denotes a kwcall signature and dispatch. The keyword splatting operation (written as other...) calls the named tuple merge function. This function further unpacks each element of other, expecting each one to contain two values (a symbol and a value). Naturally, a more efficient implementation is available if all splatted arguments are named tuples. Notice that the original circle function is passed through, to handle closures.","page":"Julia Functions"},{"title":"Compiler efficiency issues","location":"devdocs/functions.html#compiler-efficiency-issues","category":"section","text":"","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"Generating a new type for every function has potentially serious consequences for compiler resource use when combined with Julia's \"specialize on all arguments by default\" design. Indeed, the initial implementation of this design suffered from much longer build and test times, higher memory use, and a system image nearly 2x larger than the baseline. In a naive implementation, the problem is bad enough to make the system nearly unusable. Several significant optimizations were needed to make the design practical.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The first issue is excessive specialization of functions for different values of function-valued arguments. Many functions simply \"pass through\" an argument to somewhere else, e.g. to another function or to a storage location. Such functions do not need to be specialized for every closure that might be passed in. Fortunately this case is easy to distinguish by simply considering whether a function calls one of its arguments (i.e. the argument appears in \"head position\" somewhere). Performance-critical higher-order functions like map certainly call their argument function and so will still be specialized as expected. This optimization is implemented by recording which arguments are called during the analyze-variables pass in the front end. When cache_method sees an argument in the Function type hierarchy passed to a slot declared as Any or Function, it behaves as if the @nospecialize annotation were applied. This heuristic seems to be extremely effective in practice.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The next issue concerns the structure of method cache hash tables. Empirical studies show that the vast majority of dynamically-dispatched calls involve one or two arguments. In turn, many of these cases can be resolved by considering only the first argument. (Aside: proponents of single dispatch would not be surprised by this at all. However, this argument means \"multiple dispatch is easy to optimize in practice\", and that we should therefore use it, not \"we should use single dispatch\"!) So the method cache uses the type of the first argument as its primary key. Note, however, that this corresponds to the second element of the tuple type for a function call (the first element being the type of the function itself). Typically, type variation in head position is extremely low – indeed, the majority of functions belong to singleton types with no parameters. However, this is not the case for constructors, where a single method table holds constructors for every type. Therefore the Type method table is special-cased to use the first tuple type element instead of the second.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The front end generates type declarations for all closures. Initially, this was implemented by generating normal type declarations. However, this produced an extremely large number of constructors, all of which were trivial (simply passing all arguments through to new). Since methods are partially ordered, inserting all of these methods is O(n²), plus there are just too many of them to keep around. This was optimized by generating struct_type expressions directly (bypassing default constructor generation), and using new directly to create closure instances. Not the prettiest thing ever, but you do what you gotta do.","page":"Julia Functions"},{"title":"Julia Functions","location":"devdocs/functions.html","category":"page","text":"The next problem was the @test macro, which generated a 0-argument closure for each test case. This is not really necessary, since each test case is simply run once in place. Therefore, @test was modified to expand to a try-catch block that records the test result (true, false, or exception raised) and calls the test suite handler on it.","page":"Julia Functions"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html#External-Profiler-Support","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"Julia provides explicit support for some external tracing profilers, enabling you to obtain a high-level overview of the runtime's execution behavior.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"The currently supported profilers are:","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"Tracy\nIntel VTune (ITTAPI)","page":"External Profiler Support"},{"title":"Adding New Zones","location":"devdocs/external_profilers.html#Adding-New-Zones","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"To add new zones, use the JL_TIMING macro. You can find numerous examples throughout the codebase by searching for JL_TIMING. To add a new type of zone you add it to JL_TIMING_OWNERS (and possibly JL_TIMING_EVENTS).","page":"External Profiler Support"},{"title":"Dynamically Enabling and Disabling Zones","location":"devdocs/external_profilers.html#Dynamically-Enabling-and-Disabling-Zones","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"The JULIA_TIMING_SUBSYSTEMS environment variable allows you to enable or disable zones for a specific Julia run. For instance, setting the variable to +GC,-INFERENCE will enable the GC zones and disable the INFERENCE zones.","page":"External Profiler Support"},{"title":"Tracy Profiler","location":"devdocs/external_profilers.html#Tracy-Profiler","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"Tracy  is a flexible profiler that can be optionally integrated with Julia.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"A typical Tracy session might look like this:","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"(Image: Typical Tracy usage)","page":"External Profiler Support"},{"title":"Building Julia with Tracy","location":"devdocs/external_profilers.html#Building-Julia-with-Tracy","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"To enable Tracy integration, build Julia with the extra option WITH_TRACY=1 in the Make.user file.","page":"External Profiler Support"},{"title":"Installing the Tracy Profile Viewer","location":"devdocs/external_profilers.html#Installing-the-Tracy-Profile-Viewer","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"The easiest way to obtain the profile viewer is by adding the TracyProfiler_jll package and launching the profiler with:","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"run(TracyProfiler_jll.tracy())","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"note: Note\nOn macOS, you may want to set the TRACY_DPI_SCALE environment variable to 1.0 if the UI elements in the profiler appear excessively large.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"To run a \"headless\" instance that saves the trace to disk, use","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"run(`$(TracyProfiler_jll.capture()) -o mytracefile.tracy`)","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"instead.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"For information on using the Tracy UI, refer to the Tracy manual.","page":"External Profiler Support"},{"title":"Profiling Julia with Tracy","location":"devdocs/external_profilers.html#Profiling-Julia-with-Tracy","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"A typical workflow for profiling Julia with Tracy involves starting Julia using:","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"JULIA_WAIT_FOR_TRACY=1 ./julia -e '...'","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"The environment variable ensures that Julia waits until it has successfully connected to the Tracy profiler before continuing execution. Afterward, use the Tracy profiler UI, click Connect, and Julia execution should resume and profiling should start.","page":"External Profiler Support"},{"title":"Profiling package precompilation with Tracy","location":"devdocs/external_profilers.html#Profiling-package-precompilation-with-Tracy","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"To profile a package precompilation process it is easiest to explicitly call into Base.compilecache with the package you want to precompile:","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"pkg = Base.identify_package(\"SparseArrays\")\nwithenv(\"JULIA_WAIT_FOR_TRACY\" => 1, \"TRACY_PORT\" => 9001) do\n    Base.compilecache(pkg)\nend","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"Here, we use a custom port for tracy which makes it easier to find the correct client in the Tracy UI to connect to.","page":"External Profiler Support"},{"title":"Adding metadata to zones","location":"devdocs/external_profilers.html#Adding-metadata-to-zones","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"The various jl_timing_show_* and jl_timing_printf functions can be used to attach a string (or strings) to a zone. For example, the trace zone for inference shows the method instance that is being inferred.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"The TracyCZoneColor function can be used to set the color of a certain zone. Search through the codebase to see how it is used.","page":"External Profiler Support"},{"title":"Viewing Tracy files in your browser","location":"devdocs/external_profilers.html#Viewing-Tracy-files-in-your-browser","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"Visit https://topolarity.github.io/trace-viewer/ for an (experimental) web viewer for Tracy traces.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"You can open a local .tracy file or provide a URL from the web (e.g. a file in a Github repo). If you load a trace file from the web, you can also share the page URL directly with others, enabling them to view the same trace.","page":"External Profiler Support"},{"title":"Enabling stack trace samples","location":"devdocs/external_profilers.html#Enabling-stack-trace-samples","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"To enable call stack sampling in Tracy, build Julia with these options in your Make.user file:","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"WITH_TRACY := 1\nWITH_TRACY_CALLSTACKS := 1\nUSE_BINARYBUILDER_LIBTRACYCLIENT := 0","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"You may also need to run make -C deps clean-libtracyclient to force a re-build of Tracy.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"This feature has a significant impact on trace size and profiling overhead, so it is recommended to leave call stack sampling off when possible, especially if you intend to share your trace files online.","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"Note that the Julia JIT runtime does not yet have integration for Tracy's symbolification, so Julia functions will typically be unknown in these stack traces.","page":"External Profiler Support"},{"title":"Intel VTune (ITTAPI) Profiler","location":"devdocs/external_profilers.html#Intel-VTune-(ITTAPI)-Profiler","category":"section","text":"","page":"External Profiler Support"},{"title":"External Profiler Support","location":"devdocs/external_profilers.html","category":"page","text":"This section is yet to be written.","page":"External Profiler Support"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/NEWS.md\"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html#Julia-v1.11-Release-Notes","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"New language features","location":"NEWS.html#New-language-features","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"New Memory type that provides a lower-level container as an alternative to Array. Memory has less overhead and a faster constructor, making it a good choice for situations that do not need all the features of Array (e.g. multiple dimensions). Most of the Array type is now implemented in Julia on top of Memory, leading to significant speedups for several functions (e.g. push!) as well as more maintainable code (#51319).\npublic is a new keyword. Symbols marked with public are considered public API. Symbols marked with export are now also treated as public API. The difference between public and export is that public names do not become available when using a package/module (#50105).\nScopedValue implements dynamic scope with inheritance across tasks (#50958).\nManifest.toml files can now be renamed in the format Manifest-v{major}.{minor}.toml to be preferentially picked up by the given julia version. i.e. in the same folder, a Manifest-v1.11.toml would be used by v1.11 and Manifest.toml by every other julia version. This makes managing environments for multiple julia versions at the same time easier (#43845).\nSupport for Unicode 15.1 (#51799).","page":"Julia v1.11 Release Notes"},{"title":"Language changes","location":"NEWS.html#Language-changes","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"During precompilation, atexit hooks now run before saving the output file. This allows users to safely tear down background state (such as closing Timers and sending disconnect notifications to heartbeat tasks) and cleanup other resources when the program wants to begin exiting.\nCode coverage and malloc tracking is no longer generated during the package precompilation stage. Further, during these modes pkgimage caches are now used for packages that are not being tracked. This means that coverage testing (the default for julia-actions/julia-runtest) will by default use pkgimage caches for all other packages than the package being tested, likely meaning faster test execution (#52123).\nSpecifying a path in JULIA_DEPOT_PATH now results in the expansion of empty strings to omit the default user depot (#51448).\nPrecompilation cache files are now relocatable and their validity is now verified through a content hash of their source files instead of their mtime (#49866).","page":"Julia v1.11 Release Notes"},{"title":"Compiler/Runtime improvements","location":"NEWS.html#Compiler/Runtime-improvements","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"Updated GC heuristics to count allocated pages instead of individual objects (#50144).\nAdded support for annotating Base.@assume_effects on code blocks (#52400).","page":"Julia v1.11 Release Notes"},{"title":"Command-line option changes","location":"NEWS.html#Command-line-option-changes","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"The entry point for Julia has been standardized to Main.main(args). This must be explicitly opted into using the @main macro (see the docstring for further details). When opted-in, and julia is invoked to run a script or expression (i.e. using julia script.jl or julia -e expr), julia will subsequently run the Main.main function automatically. This is intended to unify script and compilation workflows, where code loading may happen in the compiler and execution of Main.main may happen in the resulting executable. For interactive use, there is no semantic difference between defining a main function and executing the code directly at the end of the script (#50974).\nThe --compiled-modules and --pkgimages flags can now be set to existing, which will cause Julia to consider loading existing cache files, but not to create new ones (#50586, #52573).\nThe --project argument now accepts @script to give a path to a directory with a Project.toml relative to the passed script file. --project=@script/foo for the foo subdirectory. If no path is given after (i.e. --project=@script) then (like --project=@.) the directory and its parents are searched for a Project.toml (#50864 and #53352)","page":"Julia v1.11 Release Notes"},{"title":"Multi-threading changes","location":"NEWS.html#Multi-threading-changes","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"Threads.@threads now supports the :greedy scheduler, intended for non-uniform workloads (#52096).\nA new public (but unexported) struct Base.Lockable{T, L<:AbstractLock} makes it easy to bundle a resource and its lock together (#52898).","page":"Julia v1.11 Release Notes"},{"title":"Build system changes","location":"NEWS.html#Build-system-changes","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"There is a new Makefile to build Julia and LLVM using the profile-guided and link-time optimizations (PGO and LTO) strategies, see contrib/pgo-lto/Makefile (#45641).","page":"Julia v1.11 Release Notes"},{"title":"New library functions","location":"NEWS.html#New-library-functions","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"Three new types around the idea of text with \"annotations\" (Pair{Symbol, Any} entries, e.g. :lang => \"en\" or :face => :magenta). These annotations are preserved across operations (e.g. string concatenation with *) when possible.\nAnnotatedString is a new AbstractString type. It wraps an underlying string and allows for annotations to be attached to regions of the string. This type is used extensively in the new StyledStrings standard library to hold styling information.\nAnnotatedChar is a new AbstractChar type. It wraps another char and holds a list of annotations that apply to it.\nAnnotatedIOBuffer is a new IO type that mimics an IOBuffer, but has specialised read/write methods for annotated content. This can be thought of both as a \"string builder\" of sorts and also as glue between annotated and unannotated content.\nin!(x, s::AbstractSet) will return whether x is in s, and insert x in s if not (#45156, #51636).\nThe new Libc.mkfifo function wraps the mkfifo C function on Unix platforms (#34587).\nlogrange(start, stop; length) makes a range of constant ratio, instead of constant step (#39071)\ncopyuntil(out, io, delim) and copyline(out, io) copy data into an out::IO stream (#48273).\neachrsplit(string, pattern) iterates split substrings right to left (#51646).\nSys.username() can be used to return the current user's username (#51897).\nSys.isreadable(), Sys.iswritable() can be used to check if the current user has access permissions that permit reading and writing, respectively. (#53320).\nGC.logging_enabled() can be used to test whether GC logging has been enabled via GC.enable_logging (#51647).\nIdSet is now exported from Base and considered public (#53262).\n@time now reports a count of any lock conflicts where a ReentrantLock had to wait, plus a new macro @lock_conflicts which returns that count (#52883).\nThe new macro Base.Cartesian.@ncallkw is analogous to Base.Cartesian.@ncall, but allows adding keyword arguments to the function call (#51501).\nNew function Docs.hasdoc(module, symbol) tells whether a name has a docstring (#52139).\nNew function Docs.undocumented_names(module) returns a module's undocumented public names (#52413).","page":"Julia v1.11 Release Notes"},{"title":"New library features","location":"NEWS.html#New-library-features","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"invmod(n, T) where T is a native integer type now computes the modular inverse of n in the modular integer ring that T defines (#52180).\ninvmod(n) is an abbreviation for invmod(n, typeof(n)) for native integer types (#52180).\nreplace(string, pattern...) now supports an optional IO argument to write the output to a stream rather than returning a string (#48625).\nNew methods allequal(f, itr) and allunique(f, itr) taking a predicate function (#47679).\nsizehint!(s, n) now supports an optional shrink argument to disable shrinking (#51929).\nPassing an IOBuffer as a stdout argument for Process spawn now works as expected, synchronized with wait or success, so a Base.BufferStream is no longer required there for correctness to avoid data races (#52461).\nAfter a process exits, closewrite will no longer be automatically called on the stream passed to it. Call wait on the process instead to ensure the content is fully written, then call closewrite manually to avoid data races, or use the callback form of open to have all that handled automatically (#52461).\n@timed now additionally returns the elapsed compilation and recompilation time (#52889).\nfilter can now act on a NamedTuple (#50795).\nIterators.cycle(iter, n) runs over iter a fixed number of times, instead of forever (#47354).\nzero(::AbstractArray) now applies recursively, so zero([[1,2],[3,4,5]]) now produces the additive identity [[0,0],[0,0,0]] rather than erroring (#38064).\ninclude_dependency(path; track_content=true) allows switching from using mtime to hashing of the precompilation dependency in order to restore relocatability of precompilation caches (#51798).","page":"Julia v1.11 Release Notes"},{"title":"Standard library changes","location":"NEWS.html#Standard-library-changes","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"The fallback method write(::IO, ::AbstractArray) used to recursively call write on each element, but now writes the in-memory representation of each value. For example, write(io, 'a':'b') now writes 4 bytes for each character, instead of writing the UTF-8 representation of each character. The new format is compatible with that used by Array, making it possible to use read! to get the data back (#42593).\nIt's not possible to define length for stateful iterators in a generally consistent manner. The potential for silently incorrect results for Stateful iterators is addressed by deleting the length(::Stateful) method. The last type parameter of Stateful is gone, too. Issue: (#47790), PR: (#51747).","page":"Julia v1.11 Release Notes"},{"title":"StyledStrings","location":"NEWS.html#StyledStrings","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"A new standard library for handling styling in a more comprehensive and structured way (#49586).\nThe new Faces struct serves as a container for text styling information (think typeface, as well as color and decoration), and comes with a framework to provide a convenient, extensible (via addface!), and customisable (with a user's Faces.toml and loadfaces!) approach to styled content (#49586).\nThe new @styled_str string macro provides a convenient way of creating a AnnotatedString with various faces or other attributes applied (#49586).","page":"Julia v1.11 Release Notes"},{"title":"Libdl","location":"NEWS.html#Libdl","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"A new LazyLibrary type is exported from Libdl for use in building chained lazy library loads, primarily to be used within JLLs (#50074).","page":"Julia v1.11 Release Notes"},{"title":"LinearAlgebra","location":"NEWS.html#LinearAlgebra","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"cbrt(::AbstractMatrix{<:Real}) is now defined and returns real-valued matrix cube roots of real-valued matrices (#50661).\neigvals/eigen(A, bunchkaufman(B)) and eigvals/eigen(A, lu(B)), which utilize the Bunchkaufman (LDL) and LU decomposition of B,  respectively, now efficiently compute the generalized eigenvalues (eigen: and eigenvectors) of A and B. Note: The second  argument is the output of bunchkaufman or lu (#50471).\nThere is now a specialized dispatch for eigvals/eigen(::Hermitian{<:Tridiagonal}) which performs a similarity transformation to create a real symmetric tridiagonal matrix, and solve that using the LAPACK routines (#49546).\nStructured matrices now retain either the axes of the parent (for Symmetric/Hermitian/AbstractTriangular/UpperHessenberg), or that of the principal diagonal (for banded matrices) (#52480).\nbunchkaufman and bunchkaufman! now work for any AbstractFloat, Rational and their complex variants. bunchkaufman now supports Integer types, by making an internal conversion to Rational{BigInt}. Added new function inertia that computes the inertia of the diagonal factor given by the BunchKaufman factorization object of a real symmetric or Hermitian matrix. For complex symmetric matrices, inertia only computes the number of zero eigenvalues of the diagonal factor (#51487).\nPackages that specialize matrix-matrix mul! with a method signature of the form mul!(::AbstractMatrix, ::MyMatrix, ::AbstractMatrix, ::Number, ::Number) no longer encounter method ambiguities when interacting with LinearAlgebra. Previously, ambiguities used to arise when multiplying a MyMatrix with a structured matrix type provided by LinearAlgebra, such as AbstractTriangular, which used to necessitate additional methods to resolve such ambiguities. Similar sources of ambiguities have also been removed for matrix-vector mul! operations (#52837).\nlu and issuccess(::LU) now accept an allowsingular keyword argument. When set to true, a valid factorization with rank-deficient U factor will be treated as success instead of throwing an error. Such factorizations are now shown by printing the factors together with a \"rank-deficient\" note rather than printing a \"Failed Factorization\" message (#52957).","page":"Julia v1.11 Release Notes"},{"title":"Random","location":"NEWS.html#Random","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"rand now supports sampling over Tuple types (#35856, #50251).\nrand now supports sampling over Pair types (#28705).\nWhen seeding RNGs provided by Random, negative integer seeds can now be used (#51416).\nSeedable random number generators from Random can now be seeded by a string, e.g. seed!(rng, \"a random seed\") (#51527).","page":"Julia v1.11 Release Notes"},{"title":"REPL","location":"NEWS.html#REPL","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"Tab complete hints now show in lighter text while typing in the repl. To disable set Base.active_repl.options.hint_tab_completes = false interactively, or in startup.jl:\nif VERSION >= v\"1.11.0-0\"\n  atreplinit() do repl\n      repl.options.hint_tab_completes = false\n  end\nend\n(#51229).\nMeta-M with an empty prompt now toggles the contextual module between the previous non-Main contextual module and Main so that switching back and forth is simple (#51616, #52670).","page":"Julia v1.11 Release Notes"},{"title":"Dates","location":"NEWS.html#Dates","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"The undocumented function adjust is no longer exported but is now documented (#53092).","page":"Julia v1.11 Release Notes"},{"title":"Statistics","location":"NEWS.html#Statistics","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"Statistics is now an upgradeable standard library (#46501).","page":"Julia v1.11 Release Notes"},{"title":"Distributed","location":"NEWS.html#Distributed","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"pmap now defaults to using a CachingPool (#33892).","page":"Julia v1.11 Release Notes"},{"title":"Deprecated or removed","location":"NEWS.html#Deprecated-or-removed","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"Base.map, Iterators.map, and foreach lost their single-argument methods (#52631).","page":"Julia v1.11 Release Notes"},{"title":"External dependencies","location":"NEWS.html#External-dependencies","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"The libuv library has been updated from a base of v1.44.2 to v1.48.0 (#49937).\ntput is no longer called to check terminal capabilities; it has been replaced with a pure-Julia terminfo parser (#50797).\nThe terminal info database, terminfo, is now vendored by default, providing a better REPL user experience when terminfo is not available on the system. Julia can be built without vendoring the database using the Makefile option WITH_TERMINFO=0. (#55411)","page":"Julia v1.11 Release Notes"},{"title":"Tooling Improvements","location":"NEWS.html#Tooling-Improvements","category":"section","text":"","page":"Julia v1.11 Release Notes"},{"title":"Julia v1.11 Release Notes","location":"NEWS.html","category":"page","text":"CI now performs limited automatic typo detection on all PRs. If you merge a PR with a failing typo CI check, then the reported typos will be automatically ignored in future CI runs on PRs that edit those same files (#51704).","page":"Julia v1.11 Release Notes"},{"title":"Environment Variables","location":"manual/environment-variables.html#Environment-Variables","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Julia can be configured with a number of environment variables, set either in the usual way for each operating system, or in a portable way from within Julia. Supposing that you want to set the environment variable JULIA_EDITOR to vim, you can type ENV[\"JULIA_EDITOR\"] = \"vim\" (for instance, in the REPL) to make this change on a case by case basis, or add the same to the user configuration file ~/.julia/config/startup.jl in the user's home directory to have a permanent effect. The current value of the same environment variable can be determined by evaluating ENV[\"JULIA_EDITOR\"].","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The environment variables that Julia uses generally start with JULIA. If InteractiveUtils.versioninfo is called with the keyword verbose=true, then the output will list any defined environment variables relevant for Julia, including those which include JULIA in their names.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nIt is recommended to avoid changing environment variables during runtime, such as within a ~/.julia/config/startup.jl.One reason is that some julia language variables, such as JULIA_NUM_THREADS and JULIA_PROJECT, need to be set before Julia starts.Similarly, __init__() functions of user modules in the sysimage (via PackageCompiler) are run before startup.jl, so setting environment variables in a startup.jl may be too late for user code.Further, changing environment variables during runtime can introduce data races into otherwise benign code.In Bash, environment variables can either be set manually by running, e.g., export JULIA_NUM_THREADS=4 before starting Julia, or by adding the same command to ~/.bashrc or ~/.bash_profile to set the variable each time Bash is started.","page":"Environment Variables"},{"title":"File locations","location":"manual/environment-variables.html#File-locations","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_BINDIR","location":"manual/environment-variables.html#JULIA_BINDIR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The absolute path of the directory containing the Julia executable, which sets the global variable Sys.BINDIR. If $JULIA_BINDIR is not set, then Julia determines the value Sys.BINDIR at run-time.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The executable itself is one of","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_BINDIR/julia\n$JULIA_BINDIR/julia-debug","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"by default.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The global variable Base.DATAROOTDIR determines a relative path from Sys.BINDIR to the data directory associated with Julia. Then the path","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_BINDIR/$DATAROOTDIR/julia/base","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"determines the directory in which Julia initially searches for source files (via Base.find_source_file()).","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Likewise, the global variable Base.SYSCONFDIR determines a relative path to the configuration file directory. Then Julia searches for a startup.jl file at","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_BINDIR/$SYSCONFDIR/julia/startup.jl\n$JULIA_BINDIR/../etc/julia/startup.jl","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"by default (via Base.load_julia_startup()).","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"For example, a Linux installation with a Julia executable located at /bin/julia, a DATAROOTDIR of ../share, and a SYSCONFDIR of ../etc will have JULIA_BINDIR set to /bin, a source-file search path of","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"/share/julia/base","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"and a global configuration search path of","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"/etc/julia/startup.jl","page":"Environment Variables"},{"title":"JULIA_PROJECT","location":"manual/environment-variables.html#JULIA_PROJECT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"A directory path that indicates which project should be the initial active project. Setting this environment variable has the same effect as specifying the --project start-up option, but --project has higher precedence. If the variable is set to @. (note the trailing dot) then Julia tries to find a project directory that contains Project.toml or JuliaProject.toml file from the current directory and its parents. See also the chapter on Code Loading.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nJULIA_PROJECT must be defined before starting julia; defining it in startup.jl is too late in the startup process.","page":"Environment Variables"},{"title":"JULIA_LOAD_PATH","location":"manual/environment-variables.html#JULIA_LOAD_PATH","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The JULIA_LOAD_PATH environment variable is used to populate the global Julia LOAD_PATH variable, which determines which packages can be loaded via import and using (see Code Loading).","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Unlike the shell PATH variable, empty entries in JULIA_LOAD_PATH are expanded to the default value of LOAD_PATH, [\"@\", \"@v#.#\", \"@stdlib\"] when populating LOAD_PATH. This allows easy appending, prepending, etc. of the load path value in shell scripts regardless of whether JULIA_LOAD_PATH is already set or not. For example, to prepend the directory /foo/bar to LOAD_PATH just do","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"export JULIA_LOAD_PATH=\"/foo/bar:$JULIA_LOAD_PATH\"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If the JULIA_LOAD_PATH environment variable is already set, its old value will be prepended with /foo/bar. On the other hand, if JULIA_LOAD_PATH is not set, then it will be set to /foo/bar: which will expand to a LOAD_PATH value of [\"/foo/bar\", \"@\", \"@v#.#\", \"@stdlib\"]. If JULIA_LOAD_PATH is set to the empty string, it expands to an empty LOAD_PATH array. In other words, the empty string is interpreted as a zero-element array, not a one-element array of the empty string. This behavior was chosen so that it would be possible to set an empty load path via the environment variable. If you want the default load path, either unset the environment variable or if it must have a value, set it to the string :.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nOn Windows, path elements are separated by the ; character, as is the case with most path lists on Windows. Replace : with ; in the above paragraph.","page":"Environment Variables"},{"title":"JULIA_DEPOT_PATH","location":"manual/environment-variables.html#JULIA_DEPOT_PATH","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The JULIA_DEPOT_PATH environment variable is used to populate the global Julia DEPOT_PATH variable, which controls where the package manager, as well as Julia's code loading mechanisms, look for package registries, installed packages, named environments, repo clones, cached compiled package images, configuration files, and the default location of the REPL's history file.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Unlike the shell PATH variable but similar to JULIA_LOAD_PATH, empty entries in JULIA_DEPOT_PATH are expanded to the default value of DEPOT_PATH, excluding the user depot. This allows easy overriding of the user depot, while still retaining access to resources that are bundled with Julia, like cache files, artifacts, etc. For example, to switch the user depot to /foo/bar just do","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"export JULIA_DEPOT_PATH=\"/foo/bar:\"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"All package operations, like cloning registrise or installing packages, will now write to /foo/bar, but since the empty entry is expanded to the default system depot, any bundled resources will still be available. If you really only want to use the depot at /foo/bar, and not load any bundled resources, simply set the environment variable to /foo/bar without the trailing colon.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"There are two exceptions to the above rule. First, if JULIA_DEPOT_PATH is set to the empty string, it expands to an empty DEPOT_PATH array. In other words, the empty string is interpreted as a zero-element array, not a one-element array of the empty string. This behavior was chosen so that it would be possible to set an empty depot path via the environment variable.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Second, if no user depot is specified in JULIA_DEPOT_PATH, then the empty entry is expanded to the default depot including the user depot. This makes it possible to use the default depot, as if the environment variable was unset, by setting it to the string :.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nOn Windows, path elements are separated by the ; character, as is the case with most path lists on Windows. Replace : with ; in the above paragraph.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nJULIA_DEPOT_PATH must be defined before starting julia; defining it in startup.jl is too late in the startup process; at that point you can instead directly modify the DEPOT_PATH array, which is populated from the environment variable.","page":"Environment Variables"},{"title":"JULIA_HISTORY","location":"manual/environment-variables.html#JULIA_HISTORY","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The absolute path REPL.find_hist_file() of the REPL's history file. If $JULIA_HISTORY is not set, then REPL.find_hist_file() defaults to","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$(DEPOT_PATH[1])/logs/repl_history.jl","page":"Environment Variables"},{"title":"JULIA_MAX_NUM_PRECOMPILE_FILES","location":"manual/environment-variables.html#JULIA_MAX_NUM_PRECOMPILE_FILES","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Sets the maximum number of different instances of a single package that are to be stored in the precompile cache (default = 10).","page":"Environment Variables"},{"title":"JULIA_VERBOSE_LINKING","location":"manual/environment-variables.html#JULIA_VERBOSE_LINKING","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to true, linker commands will be displayed during precompilation.","page":"Environment Variables"},{"title":"Pkg.jl","location":"manual/environment-variables.html#Pkg.jl","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_CI","location":"manual/environment-variables.html#JULIA_CI","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to true, this indicates to the package server that any package operations are part of a continuous integration (CI) system for the purposes of gathering package usage statistics.","page":"Environment Variables"},{"title":"JULIA_NUM_PRECOMPILE_TASKS","location":"manual/environment-variables.html#JULIA_NUM_PRECOMPILE_TASKS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The number of parallel tasks to use when precompiling packages. See Pkg.precompile.","page":"Environment Variables"},{"title":"JULIA_PKG_DEVDIR","location":"manual/environment-variables.html#JULIA_PKG_DEVDIR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The default directory used by Pkg.develop for downloading packages.","page":"Environment Variables"},{"title":"JULIA_PKG_IGNORE_HASHES","location":"manual/environment-variables.html#JULIA_PKG_IGNORE_HASHES","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to 1, this will ignore incorrect hashes in artifacts. This should be used carefully, as it disables verification of downloads, but can resolve issues when moving files across different types of file systems. See Pkg.jl issue #2317 for more details.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.6\nThis is only supported in Julia 1.6 and above.","page":"Environment Variables"},{"title":"JULIA_PKG_OFFLINE","location":"manual/environment-variables.html#JULIA_PKG_OFFLINE","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to true, this will enable offline mode: see Pkg.offline.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.5\nPkg's offline mode requires Julia 1.5 or later.","page":"Environment Variables"},{"title":"JULIA_PKG_PRECOMPILE_AUTO","location":"manual/environment-variables.html#JULIA_PKG_PRECOMPILE_AUTO","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to 0, this will disable automatic precompilation by package actions which change the manifest. See Pkg.precompile.","page":"Environment Variables"},{"title":"JULIA_PKG_SERVER","location":"manual/environment-variables.html#JULIA_PKG_SERVER","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Specifies the URL of the package registry to use. By default, Pkg uses https://pkg.julialang.org to fetch Julia packages. In addition, you can disable the use of the PkgServer protocol, and instead access the packages directly from their hosts (GitHub, GitLab, etc.) by setting: export JULIA_PKG_SERVER=\"\"","page":"Environment Variables"},{"title":"JULIA_PKG_SERVER_REGISTRY_PREFERENCE","location":"manual/environment-variables.html#JULIA_PKG_SERVER_REGISTRY_PREFERENCE","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Specifies the preferred registry flavor. Currently supported values are conservative (the default), which will only publish resources that have been processed by the storage server (and thereby have a higher probability of being available from the PkgServers), whereas eager will publish registries whose resources have not necessarily been processed by the storage servers.  Users behind restrictive firewalls that do not allow downloading from arbitrary servers should not use the eager flavor.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.7\nThis only affects Julia 1.7 and above.","page":"Environment Variables"},{"title":"JULIA_PKG_UNPACK_REGISTRY","location":"manual/environment-variables.html#JULIA_PKG_UNPACK_REGISTRY","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to true, this will unpack the registry instead of storing it as a compressed tarball.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.7\nThis only affects Julia 1.7 and above. Earlier versions will always unpack the registry.","page":"Environment Variables"},{"title":"JULIA_PKG_USE_CLI_GIT","location":"manual/environment-variables.html#JULIA_PKG_USE_CLI_GIT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to true, Pkg operations which use the git protocol will use an external git executable instead of the default libgit2 library.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.7\nUse of the git executable is only supported on Julia 1.7 and above.","page":"Environment Variables"},{"title":"JULIA_PKGRESOLVE_ACCURACY","location":"manual/environment-variables.html#JULIA_PKGRESOLVE_ACCURACY","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The accuracy of the package resolver. This should be a positive integer, the default is 1.","page":"Environment Variables"},{"title":"JULIA_PKG_PRESERVE_TIERED_INSTALLED","location":"manual/environment-variables.html#JULIA_PKG_PRESERVE_TIERED_INSTALLED","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Change the default package installation strategy to Pkg.PRESERVE_TIERED_INSTALLED to let the package manager try to install versions of packages while keeping as many versions of packages already installed as possible.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.9\nThis only affects Julia 1.9 and above.","page":"Environment Variables"},{"title":"Network transport","location":"manual/environment-variables.html#Network-transport","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_NO_VERIFY_HOSTS","location":"manual/environment-variables.html#JULIA_NO_VERIFY_HOSTS","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_SSL_NO_VERIFY_HOSTS","location":"manual/environment-variables.html#JULIA_SSL_NO_VERIFY_HOSTS","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_SSH_NO_VERIFY_HOSTS","location":"manual/environment-variables.html#JULIA_SSH_NO_VERIFY_HOSTS","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_ALWAYS_VERIFY_HOSTS","location":"manual/environment-variables.html#JULIA_ALWAYS_VERIFY_HOSTS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Specify hosts whose identity should or should not be verified for specific transport layers. See NetworkOptions.verify_host","page":"Environment Variables"},{"title":"JULIA_SSL_CA_ROOTS_PATH","location":"manual/environment-variables.html#JULIA_SSL_CA_ROOTS_PATH","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Specify the file or directory containing the certificate authority roots. See NetworkOptions.ca_roots","page":"Environment Variables"},{"title":"External applications","location":"manual/environment-variables.html#External-applications","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_SHELL","location":"manual/environment-variables.html#JULIA_SHELL","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The absolute path of the shell with which Julia should execute external commands (via Base.repl_cmd()). Defaults to the environment variable $SHELL, and falls back to /bin/sh if $SHELL is unset.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nOn Windows, this environment variable is ignored, and external commands are executed directly.","page":"Environment Variables"},{"title":"JULIA_EDITOR","location":"manual/environment-variables.html#JULIA_EDITOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The editor returned by InteractiveUtils.editor() and used in, e.g., InteractiveUtils.edit, referring to the command of the preferred editor, for instance vim.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"$JULIA_EDITOR takes precedence over $VISUAL, which in turn takes precedence over $EDITOR. If none of these environment variables is set, then the editor is taken to be open on Windows and OS X, or /etc/alternatives/editor if it exists, or emacs otherwise.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"To use Visual Studio Code on Windows, set $JULIA_EDITOR to code.cmd.","page":"Environment Variables"},{"title":"Parallelization","location":"manual/environment-variables.html#Parallelization","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_CPU_THREADS","location":"manual/environment-variables.html#JULIA_CPU_THREADS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Overrides the global variable Base.Sys.CPU_THREADS, the number of logical CPU cores available.","page":"Environment Variables"},{"title":"JULIA_WORKER_TIMEOUT","location":"manual/environment-variables.html#JULIA_WORKER_TIMEOUT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"A Float64 that sets the value of Distributed.worker_timeout() (default: 60.0). This function gives the number of seconds a worker process will wait for a master process to establish a connection before dying.","page":"Environment Variables"},{"title":"JULIA_NUM_THREADS","location":"manual/environment-variables.html#JULIA_NUM_THREADS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"An unsigned 64-bit integer (uint64_t) that sets the maximum number of threads available to Julia.  If $JULIA_NUM_THREADS is not positive or is not set, or if the number of CPU threads cannot be determined through system calls, then the number of threads is set to 1.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If $JULIA_NUM_THREADS is set to auto, then the number of threads will be set to the number of CPU threads.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nJULIA_NUM_THREADS must be defined before starting julia; defining it in startup.jl is too late in the startup process.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.5\nIn Julia 1.5 and above the number of threads can also be specified on startup using the -t/--threads command line argument.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.7\nThe auto value for $JULIA_NUM_THREADS requires Julia 1.7 or above.","page":"Environment Variables"},{"title":"JULIA_THREAD_SLEEP_THRESHOLD","location":"manual/environment-variables.html#JULIA_THREAD_SLEEP_THRESHOLD","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to a string that starts with the case-insensitive substring \"infinite\", then spinning threads never sleep. Otherwise, $JULIA_THREAD_SLEEP_THRESHOLD is interpreted as an unsigned 64-bit integer (uint64_t) and gives, in nanoseconds, the amount of time after which spinning threads should sleep.","page":"Environment Variables"},{"title":"JULIA_NUM_GC_THREADS","location":"manual/environment-variables.html#JULIA_NUM_GC_THREADS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Sets the number of threads used by Garbage Collection. If unspecified is set to half of the number of worker threads.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"compat: Julia 1.10\nThe environment variable was added in 1.10","page":"Environment Variables"},{"title":"JULIA_IMAGE_THREADS","location":"manual/environment-variables.html#JULIA_IMAGE_THREADS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"An unsigned 32-bit integer that sets the number of threads used by image compilation in this Julia process. The value of this variable may be ignored if the module is a small module. If left unspecified, the smaller of the value of JULIA_CPU_THREADS or half the number of logical CPU cores is used in its place.","page":"Environment Variables"},{"title":"JULIA_IMAGE_TIMINGS","location":"manual/environment-variables.html#JULIA_IMAGE_TIMINGS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"A boolean value that determines if detailed timing information is printed during during image compilation. Defaults to 0.","page":"Environment Variables"},{"title":"JULIA_EXCLUSIVE","location":"manual/environment-variables.html#JULIA_EXCLUSIVE","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then Julia's thread policy is consistent with running on a dedicated machine: the master thread is on proc 0, and threads are affinitized. Otherwise, Julia lets the operating system handle thread policy.","page":"Environment Variables"},{"title":"REPL formatting","location":"manual/environment-variables.html#REPL-formatting","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Environment variables that determine how REPL output should be formatted at the terminal. Generally, these variables should be set to ANSI terminal escape sequences. Julia provides a high-level interface with much of the same functionality; see the section on The Julia REPL.","page":"Environment Variables"},{"title":"JULIA_ERROR_COLOR","location":"manual/environment-variables.html#JULIA_ERROR_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.error_color() (default: light red, \"\\033[91m\") that errors should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_WARN_COLOR","location":"manual/environment-variables.html#JULIA_WARN_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.warn_color() (default: yellow, \"\\033[93m\") that warnings should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_INFO_COLOR","location":"manual/environment-variables.html#JULIA_INFO_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.info_color() (default: cyan, \"\\033[36m\") that info should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_INPUT_COLOR","location":"manual/environment-variables.html#JULIA_INPUT_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.input_color() (default: normal, \"\\033[0m\") that input should have at the terminal.","page":"Environment Variables"},{"title":"JULIA_ANSWER_COLOR","location":"manual/environment-variables.html#JULIA_ANSWER_COLOR","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The formatting Base.answer_color() (default: normal, \"\\033[0m\") that output should have at the terminal.","page":"Environment Variables"},{"title":"System and Package Image Building","location":"manual/environment-variables.html#System-and-Package-Image-Building","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_CPU_TARGET","location":"manual/environment-variables.html#JULIA_CPU_TARGET","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Modify the target machine architecture for (pre)compiling system and package images. JULIA_CPU_TARGET only affects machine code image generation being output to a disk cache. Unlike the --cpu-target, or -C, command line option, it does not influence just-in-time (JIT) code generation within a Julia session where machine code is only stored in memory.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Valid values for JULIA_CPU_TARGET can be obtained by executing julia -C help.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Setting JULIA_CPU_TARGET is important for heterogeneous compute systems where processors of distinct types or features may be present. This is commonly encountered in high performance computing (HPC) clusters since the component nodes may be using distinct processors.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"The CPU target string is a list of strings separated by ; each string starts with a CPU or architecture name and followed by an optional list of features separated by ,. A generic or empty CPU name means the basic required feature set of the target ISA which is at least the architecture the C/C++ runtime is compiled with. Each string is interpreted by LLVM.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"A few special features are supported:","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"clone_all\nThis forces the target to have all functions in sysimg cloned.   When used in negative form (i.e. -clone_all), this disables full clone that's   enabled by default for certain targets.\nbase([0-9]*)\nThis specifies the (0-based) base target index. The base target is the target   that the current target is based on, i.e. the functions that are not being cloned   will use the version in the base target. This option causes the base target to be   fully cloned (as if clone_all is specified for it) if it is not the default target (0).   The index can only be smaller than the current index.\nopt_size\nOptimize for size with minimum performance impact. Clang/GCC's -Os.\nmin_size\nOptimize only for size. Clang's -Oz.","page":"Environment Variables"},{"title":"Debugging and profiling","location":"manual/environment-variables.html#Debugging-and-profiling","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_DEBUG","location":"manual/environment-variables.html#JULIA_DEBUG","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Enable debug logging for a file or module, see Logging for more information.","page":"Environment Variables"},{"title":"JULIA_PROFILE_PEEK_HEAP_SNAPSHOT","location":"manual/environment-variables.html#JULIA_PROFILE_PEEK_HEAP_SNAPSHOT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Enable collecting of a heap snapshot during execution via the profiling peek mechanism. See Triggered During Execution.","page":"Environment Variables"},{"title":"JULIA_TIMING_SUBSYSTEMS","location":"manual/environment-variables.html#JULIA_TIMING_SUBSYSTEMS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Allows you to enable or disable zones for a specific Julia run. For instance, setting the variable to +GC,-INFERENCE will enable the GC zones and disable the INFERENCE zones. See Dynamically Enabling and Disabling Zones.","page":"Environment Variables"},{"title":"JULIA_GC_ALLOC_POOL","location":"manual/environment-variables.html#JULIA_GC_ALLOC_POOL","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_GC_ALLOC_OTHER","location":"manual/environment-variables.html#JULIA_GC_ALLOC_OTHER","category":"section","text":"","page":"Environment Variables"},{"title":"JULIA_GC_ALLOC_PRINT","location":"manual/environment-variables.html#JULIA_GC_ALLOC_PRINT","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set, these environment variables take strings that optionally start with the character 'r', followed by a string interpolation of a colon-separated list of three signed 64-bit integers (int64_t). This triple of integers a:b:c represents the arithmetic sequence a, a + b, a + 2*b, ... c.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If it's the nth time that jl_gc_pool_alloc() has been called, and n   belongs to the arithmetic sequence represented by $JULIA_GC_ALLOC_POOL,   then garbage collection is forced.\nIf it's the nth time that maybe_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_OTHER, then garbage   collection is forced.\nIf it's the nth time that jl_gc_collect() has been called, and n belongs   to the arithmetic sequence represented by $JULIA_GC_ALLOC_PRINT, then counts   for the number of calls to jl_gc_pool_alloc() and maybe_collect() are   printed.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If the value of the environment variable begins with the character 'r', then the interval between garbage collection events is randomized.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThese environment variables only have an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","page":"Environment Variables"},{"title":"JULIA_GC_NO_GENERATIONAL","location":"manual/environment-variables.html#JULIA_GC_NO_GENERATIONAL","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then the Julia garbage collector never performs \"quick sweeps\" of memory.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","page":"Environment Variables"},{"title":"JULIA_GC_WAIT_FOR_DEBUGGER","location":"manual/environment-variables.html#JULIA_GC_WAIT_FOR_DEBUGGER","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then the Julia garbage collector will wait for a debugger to attach instead of aborting whenever there's a critical error.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with garbage-collection debugging (that is, if WITH_GC_DEBUG_ENV is set to 1 in the build configuration).","page":"Environment Variables"},{"title":"ENABLE_JITPROFILING","location":"manual/environment-variables.html#ENABLE_JITPROFILING","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0, then the compiler will create and register an event listener for just-in-time (JIT) profiling.","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"note: Note\nThis environment variable only has an effect if Julia was compiled with JIT profiling support, using eitherIntel's VTune™ Amplifier (USE_INTEL_JITEVENTS set to 1 in the build configuration), or\nOProfile (USE_OPROFILE_JITEVENTS set to 1 in the build configuration).\nPerf (USE_PERF_JITEVENTS set to 1 in the build configuration). This integration is enabled by default.","page":"Environment Variables"},{"title":"ENABLE_GDBLISTENER","location":"manual/environment-variables.html#ENABLE_GDBLISTENER","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"If set to anything besides 0 enables GDB registration of Julia code on release builds. On debug builds of Julia this is always enabled. Recommended to use with -g 2.","page":"Environment Variables"},{"title":"JULIA_LLVM_ARGS","location":"manual/environment-variables.html#JULIA_LLVM_ARGS","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Arguments to be passed to the LLVM backend.","page":"Environment Variables"},{"title":"JULIA_FALLBACK_REPL","location":"manual/environment-variables.html#JULIA_FALLBACK_REPL","category":"section","text":"","page":"Environment Variables"},{"title":"Environment Variables","location":"manual/environment-variables.html","category":"page","text":"Forces the fallback repl instead of REPL.jl.","page":"Environment Variables"},{"title":"Core.Builtins","location":"devdocs/builtins.html#lib-builtins","category":"section","text":"","page":"Core.Builtins"},{"title":"Builtin Function APIs","location":"devdocs/builtins.html#Builtin-Function-APIs","category":"section","text":"","page":"Core.Builtins"},{"title":"Core.Builtins","location":"devdocs/builtins.html","category":"page","text":"The following Builtin function APIs are considered unstable, but provide the basic definitions for what defines the abilities and behaviors of a Julia program. They are typically accessed through a higher level generic API.","page":"Core.Builtins"},{"title":"Core.Builtins","location":"devdocs/builtins.html","category":"page","text":"Core.memoryrefnew\nCore.memoryrefoffset\nCore.memoryrefget\nCore.memoryrefset!\nCore.memoryref_isassigned\nCore.memoryrefswap!\nCore.memoryrefmodify!\nCore.memoryrefreplace!\nCore.memoryrefsetonce!\nCore.Intrinsics.atomic_pointerref\nCore.Intrinsics.atomic_pointerset\nCore.Intrinsics.atomic_pointerswap\nCore.Intrinsics.atomic_pointermodify\nCore.Intrinsics.atomic_pointerreplace\nCore.get_binding_type\nCore.set_binding_type!\nCore.IntrinsicFunction\nCore.Intrinsics\nCore.IR","page":"Core.Builtins"},{"title":"Core.memoryrefnew","location":"devdocs/builtins.html#Core.memoryrefnew","category":"function","text":"Core.memoryrefnew(::GenericMemory)\nCore.memoryrefnew(::GenericMemoryRef, index::Int, [boundscheck::Bool])\n\nReturn a GenericMemoryRef for a GenericMemory. See memoryref.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryrefoffset","location":"devdocs/builtins.html#Core.memoryrefoffset","category":"function","text":"Core..memoryrefoffset(::GenericMemoryRef)\n\nReturn the offset index that was used to construct the MemoryRef. See memoryref.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryrefget","location":"devdocs/builtins.html#Core.memoryrefget","category":"function","text":"Core.memoryrefget(::GenericMemoryRef, ordering::Symbol, boundscheck::Bool)\n\nReturn the value stored at the MemoryRef, throwing a BoundsError if the Memory is empty. See ref[]. The memory ordering specified must be compatible with the isatomic parameter.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryrefset!","location":"devdocs/builtins.html#Core.memoryrefset!","category":"function","text":"Core.memoryrefset!(::GenericMemoryRef, value, ordering::Symbol, boundscheck::Bool)\n\nStore the value to the MemoryRef, throwing a BoundsError if the Memory is empty. See ref[] = value. The memory ordering specified must be compatible with the isatomic parameter.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryref_isassigned","location":"devdocs/builtins.html#Core.memoryref_isassigned","category":"function","text":"Core.memoryref_isassigned(::GenericMemoryRef, ordering::Symbol, boundscheck::Bool)\n\nReturn whether there is a value stored at the MemoryRef, returning false if the Memory is empty. See isassigned(::Base.RefValue), Core.memoryrefget. The memory ordering specified must be compatible with the isatomic parameter.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryrefswap!","location":"devdocs/builtins.html#Core.memoryrefswap!","category":"function","text":"Core.memoryrefswap!(::GenericMemoryRef, value, ordering::Symbol, boundscheck::Bool)\n\nAtomically perform the operations to simultaneously get and set a MemoryRef value.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\nSee also swapproperty! and Core.memoryrefset!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryrefmodify!","location":"devdocs/builtins.html#Core.memoryrefmodify!","category":"function","text":"Core.memoryrefmodify!(::GenericMemoryRef, op, value, ordering::Symbol, boundscheck::Bool) -> Pair\n\nAtomically perform the operations to get and set a MemoryRef value after applying the function op.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\nSee also modifyproperty! and Core.memoryrefset!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryrefreplace!","location":"devdocs/builtins.html#Core.memoryrefreplace!","category":"function","text":"Core.memoryrefreplace!(::GenericMemoryRef, expected, desired,\n                       success_order::Symbol, fail_order::Symbol=success_order, boundscheck::Bool) -> (; old, success::Bool)\n\nAtomically perform the operations to get and conditionally set a MemoryRef value.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\nSee also replaceproperty! and Core.memoryrefset!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.memoryrefsetonce!","location":"devdocs/builtins.html#Core.memoryrefsetonce!","category":"function","text":"Core.memoryrefsetonce!(::GenericMemoryRef, value,\n                       success_order::Symbol, fail_order::Symbol=success_order, boundscheck::Bool) -> success::Bool\n\nAtomically perform the operations to set a MemoryRef to a given value, only if it was previously not set.\n\ncompat: Julia 1.11\nThis function requires Julia 1.11 or later.\n\nSee also setpropertyonce! and Core.memoryrefset!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.Intrinsics.atomic_pointerref","location":"devdocs/builtins.html#Core.Intrinsics.atomic_pointerref","category":"function","text":"Core.Intrinsics.atomic_pointerref(pointer::Ptr{T}, order::Symbol) --> T\n\ncompat: Julia 1.7\nThis function requires Julia 1.7 or later.\n\nSee unsafe_load.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.Intrinsics.atomic_pointerset","location":"devdocs/builtins.html#Core.Intrinsics.atomic_pointerset","category":"function","text":"Core.Intrinsics.atomic_pointerset(pointer::Ptr{T}, new::T, order::Symbol) --> pointer\n\ncompat: Julia 1.7\nThis function requires Julia 1.7 or later.\n\nSee unsafe_store!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.Intrinsics.atomic_pointerswap","location":"devdocs/builtins.html#Core.Intrinsics.atomic_pointerswap","category":"function","text":"Core.Intrinsics.atomic_pointerswap(pointer::Ptr{T}, new::T, order::Symbol) --> old\n\ncompat: Julia 1.7\nThis function requires Julia 1.7 or later.\n\nSee unsafe_swap!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.Intrinsics.atomic_pointermodify","location":"devdocs/builtins.html#Core.Intrinsics.atomic_pointermodify","category":"function","text":"Core.Intrinsics.atomic_pointermodify(pointer::Ptr{T}, function::(old::T,arg::S)->T, arg::S, order::Symbol) --> old\n\ncompat: Julia 1.7\nThis function requires Julia 1.7 or later.\n\nSee unsafe_modify!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.Intrinsics.atomic_pointerreplace","location":"devdocs/builtins.html#Core.Intrinsics.atomic_pointerreplace","category":"function","text":"Core.Intrinsics.atomic_pointerreplace(pointer::Ptr{T}, expected::Any, new::T, success_order::Symbol, failure_order::Symbol) --> (old, cmp)\n\ncompat: Julia 1.7\nThis function requires Julia 1.7 or later.\n\nSee unsafe_replace!.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.get_binding_type","location":"devdocs/builtins.html#Core.get_binding_type","category":"function","text":"Core.get_binding_type(module::Module, name::Symbol)\n\nRetrieve the declared type of the binding name from the module module.\n\ncompat: Julia 1.9\nThis function requires Julia 1.9 or later.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.set_binding_type!","location":"devdocs/builtins.html#Core.set_binding_type!","category":"function","text":"Core.set_binding_type!(module::Module, name::Symbol, [type::Type])\n\nSet the declared type of the binding name in the module module to type. Error if the binding already has a type that is not equivalent to type. If the type argument is absent, set the binding type to Any if unset, but do not error.\n\ncompat: Julia 1.9\nThis function requires Julia 1.9 or later.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.IntrinsicFunction","location":"devdocs/builtins.html#Core.IntrinsicFunction","category":"type","text":"Core.IntrinsicFunction <: Core.Builtin <: Function\n\nThe Core.IntrinsicFunction function define some basic primitives for what defines the abilities and behaviors of a Julia program\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.Intrinsics","location":"devdocs/builtins.html#Core.Intrinsics","category":"module","text":"Core.Intrinsics\n\nThe Core.Intrinsics module holds the Core.IntrinsicFunction objects.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Core.IR","location":"devdocs/builtins.html#Core.IR","category":"module","text":"Core.IR\n\nThe Core.IR module exports the IR object model.\n\n\n\n\n\n","page":"Core.Builtins"},{"title":"Future","location":"stdlib/Future.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/Future/docs/src/index.md\"","page":"Future"},{"title":"Future","location":"stdlib/Future.html#Future","category":"section","text":"","page":"Future"},{"title":"Future","location":"stdlib/Future.html","category":"page","text":"The Future module implements future behavior of already existing functions, which will replace the current version in a future release of Julia.","page":"Future"},{"title":"Future","location":"stdlib/Future.html","category":"page","text":"Future.copy!\nFuture.randjump","page":"Future"},{"title":"Future.copy!","location":"stdlib/Future.html#Future.copy!","category":"function","text":"Future.copy!(dst, src) -> dst\n\nCopy src into dst.\n\ncompat: Julia 1.1\nThis function has moved to Base with Julia 1.1, consider using copy!(dst, src) instead. Future.copy! will be deprecated in the future.\n\n\n\n\n\n","page":"Future"},{"title":"Future.randjump","location":"stdlib/Future.html#Future.randjump","category":"function","text":"randjump(r::MersenneTwister, steps::Integer) -> MersenneTwister\n\nCreate an initialized MersenneTwister object, whose state is moved forward (without generating numbers) from r by steps steps. One such step corresponds to the generation of two Float64 numbers. For each different value of steps, a large polynomial has to be generated internally. One is already pre-computed for steps=big(10)^20.\n\n\n\n\n\n","page":"Future"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html#Complex-and-Rational-Numbers","category":"section","text":"","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Julia includes predefined types for both complex and rational numbers, and supports all the standard Mathematical Operations and Elementary Functions on them. Conversion and Promotion are defined so that operations on any combination of predefined numeric types, whether primitive or composite, behave as expected.","page":"Complex and Rational Numbers"},{"title":"Complex Numbers","location":"manual/complex-and-rational-numbers.html#Complex-Numbers","category":"section","text":"","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"The global constant im is bound to the complex number i, representing the principal square root of -1. (Using mathematicians' i or engineers' j for this global constant was rejected since they are such popular index variable names.) Since Julia allows numeric literals to be juxtaposed with identifiers as coefficients, this binding suffices to provide convenient syntax for complex numbers, similar to the traditional mathematical notation:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 1+2im\n1 + 2im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"You can perform all the standard arithmetic operations with complex numbers:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> (1 + 2im)*(2 - 3im)\n8 + 1im\n\njulia> (1 + 2im)/(1 - 2im)\n-0.6 + 0.8im\n\njulia> (1 + 2im) + (1 - 2im)\n2 + 0im\n\njulia> (-3 + 2im) - (5 - 1im)\n-8 + 3im\n\njulia> (-1 + 2im)^2\n-3 - 4im\n\njulia> (-1 + 2im)^2.5\n2.729624464784009 - 6.9606644595719im\n\njulia> (-1 + 2im)^(1 + 1im)\n-0.27910381075826657 + 0.08708053414102428im\n\njulia> 3(2 - 5im)\n6 - 15im\n\njulia> 3(2 - 5im)^2\n-63 - 60im\n\njulia> 3(2 - 5im)^-1.0\n0.20689655172413793 + 0.5172413793103449im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"The promotion mechanism ensures that combinations of operands of different types just work:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 2(1 - 1im)\n2 - 2im\n\njulia> (2 + 3im) - 1\n1 + 3im\n\njulia> (1 + 2im) + 0.5\n1.5 + 2.0im\n\njulia> (2 + 3im) - 0.5im\n2.0 + 2.5im\n\njulia> 0.75(1 + 2im)\n0.75 + 1.5im\n\njulia> (2 + 3im) / 2\n1.0 + 1.5im\n\njulia> (1 - 3im) / (2 + 2im)\n-0.5 - 1.0im\n\njulia> 2im^2\n-2 + 0im\n\njulia> 1 + 3/4im\n1.0 - 0.75im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Note that 3/4im == 3/(4*im) == -(3/4*im), since a literal coefficient binds more tightly than division.","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Standard functions to manipulate complex values are provided:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> z = 1 + 2im\n1 + 2im\n\njulia> real(1 + 2im) # real part of z\n1\n\njulia> imag(1 + 2im) # imaginary part of z\n2\n\njulia> conj(1 + 2im) # complex conjugate of z\n1 - 2im\n\njulia> abs(1 + 2im) # absolute value of z\n2.23606797749979\n\njulia> abs2(1 + 2im) # squared absolute value\n5\n\njulia> angle(1 + 2im) # phase angle in radians\n1.1071487177940904","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"As usual, the absolute value (abs) of a complex number is its distance from zero. abs2 gives the square of the absolute value, and is of particular use for complex numbers since it avoids taking a square root. angle returns the phase angle in radians (also known as the argument or arg function). The full gamut of other Elementary Functions is also defined for complex numbers:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> sqrt(1im)\n0.7071067811865476 + 0.7071067811865475im\n\njulia> sqrt(1 + 2im)\n1.272019649514069 + 0.7861513777574233im\n\njulia> cos(1 + 2im)\n2.0327230070196656 - 3.0518977991517997im\n\njulia> exp(1 + 2im)\n-1.1312043837568135 + 2.4717266720048188im\n\njulia> sinh(1 + 2im)\n-0.4890562590412937 + 1.4031192506220405im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Note that mathematical functions typically return real values when applied to real numbers and complex values when applied to complex numbers. For example, sqrt behaves differently when applied to -1 versus -1 + 0im even though -1 == -1 + 0im:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> sqrt(-1)\nERROR: DomainError with -1.0:\nsqrt was called with a negative real argument but will only return a complex result if called with a complex argument. Try sqrt(Complex(x)).\nStacktrace:\n[...]\n\njulia> sqrt(-1 + 0im)\n0.0 + 1.0im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"The literal numeric coefficient notation does not work when constructing a complex number from variables. Instead, the multiplication must be explicitly written out:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> a = 1; b = 2; a + b*im\n1 + 2im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"However, this is not recommended. Instead, use the more efficient complex function to construct a complex value directly from its real and imaginary parts:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> a = 1; b = 2; complex(a, b)\n1 + 2im","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"This construction avoids the multiplication and addition operations.","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Inf and NaN propagate through complex numbers in the real and imaginary parts of a complex number as described in the Special floating-point values section:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 1 + Inf*im\n1.0 + Inf*im\n\njulia> 1 + NaN*im\n1.0 + NaN*im","page":"Complex and Rational Numbers"},{"title":"Rational Numbers","location":"manual/complex-and-rational-numbers.html#Rational-Numbers","category":"section","text":"","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Julia has a rational number type to represent exact ratios of integers. Rationals are constructed using the // operator:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 2//3\n2//3","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"If the numerator and denominator of a rational have common factors, they are reduced to lowest terms such that the denominator is non-negative:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 6//9\n2//3\n\njulia> -4//8\n-1//2\n\njulia> 5//-15\n-1//3\n\njulia> -4//-12\n1//3","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"This normalized form for a ratio of integers is unique, so equality of rational values can be tested by checking for equality of the numerator and denominator. The standardized numerator and denominator of a rational value can be extracted using the numerator and denominator functions:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> numerator(2//3)\n2\n\njulia> denominator(2//3)\n3","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Direct comparison of the numerator and denominator is generally not necessary, since the standard arithmetic and comparison operations are defined for rational values:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 2//3 == 6//9\ntrue\n\njulia> 2//3 == 9//27\nfalse\n\njulia> 3//7 < 1//2\ntrue\n\njulia> 3//4 > 2//3\ntrue\n\njulia> 2//4 + 1//6\n2//3\n\njulia> 5//12 - 1//4\n1//6\n\njulia> 5//8 * 3//12\n5//32\n\njulia> 6//5 / 10//7\n21//25","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Rationals can easily be converted to floating-point numbers:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> float(3//4)\n0.75","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Conversion from rational to floating-point respects the following identity for any integral values of a and b, with the exception of the two cases b == 0 and a == 0 && b < 0:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> a = 1; b = 2;\n\njulia> isequal(float(a//b), a/b)\ntrue","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Constructing infinite rational values is acceptable:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 5//0\n1//0\n\njulia> x = -3//0\n-1//0\n\njulia> typeof(x)\nRational{Int64}","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"Trying to construct a NaN rational value, however, is invalid:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 0//0\nERROR: ArgumentError: invalid rational: zero(Int64)//zero(Int64)\nStacktrace:\n[...]","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"As usual, the promotion system makes interactions with other numeric types effortless:","page":"Complex and Rational Numbers"},{"title":"Complex and Rational Numbers","location":"manual/complex-and-rational-numbers.html","category":"page","text":"julia> 3//5 + 1\n8//5\n\njulia> 3//5 - 0.5\n0.09999999999999998\n\njulia> 2//7 * (1 + 2im)\n2//7 + 4//7*im\n\njulia> 2//7 * (1.5 + 2im)\n0.42857142857142855 + 0.5714285714285714im\n\njulia> 3//2 / (1 + 2im)\n3//10 - 3//5*im\n\njulia> 1//2 + 2im\n1//2 + 2//1*im\n\njulia> 1 + 2//3im\n1//1 - 2//3*im\n\njulia> 0.5 == 1//2\ntrue\n\njulia> 0.33 == 1//3\nfalse\n\njulia> 0.33 < 1//3\ntrue\n\njulia> 1//3 - 0.33\n0.0033333333333332993","page":"Complex and Rational Numbers"},{"title":"More about types","location":"devdocs/types.html#More-about-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If you've used Julia for a while, you understand the fundamental role that types play.  Here we try to get under the hood, focusing particularly on Parametric Types.","page":"More about types"},{"title":"Types and sets (and Any and Union{}/Bottom)","location":"devdocs/types.html#Types-and-sets-(and-Any-and-Union{}/Bottom)","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"It's perhaps easiest to conceive of Julia's type system in terms of sets. While programs manipulate individual values, a type refers to a set of values. This is not the same thing as a collection; for example a Set of values is itself a single Set value. Rather, a type describes a set of possible values, expressing uncertainty about which value we have.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"A concrete type T describes the set of values whose direct tag, as returned by the typeof function, is T. An abstract type describes some possibly-larger set of values.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Any describes the entire universe of possible values. Integer is a subset of Any that includes Int, Int8, and other concrete types. Internally, Julia also makes heavy use of another type known as Bottom, which can also be written as Union{}. This corresponds to the empty set.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Julia's types support the standard operations of set theory: you can ask whether T1 is a \"subset\" (subtype) of T2 with T1 <: T2. Likewise, you intersect two types using typeintersect, take their union with Union, and compute a type that contains their union with typejoin:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> typeintersect(Int, Float64)\nUnion{}\n\njulia> Union{Int, Float64}\nUnion{Float64, Int64}\n\njulia> typejoin(Int, Float64)\nReal\n\njulia> typeintersect(Signed, Union{UInt8, Int8})\nInt8\n\njulia> Union{Signed, Union{UInt8, Int8}}\nUnion{UInt8, Signed}\n\njulia> typejoin(Signed, Union{UInt8, Int8})\nInteger\n\njulia> typeintersect(Tuple{Integer, Float64}, Tuple{Int, Real})\nTuple{Int64, Float64}\n\njulia> Union{Tuple{Integer, Float64}, Tuple{Int, Real}}\nUnion{Tuple{Int64, Real}, Tuple{Integer, Float64}}\n\njulia> typejoin(Tuple{Integer, Float64}, Tuple{Int, Real})\nTuple{Integer, Real}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"While these operations may seem abstract, they lie at the heart of Julia.  For example, method dispatch is implemented by stepping through the items in a method list until reaching one for which the type of the argument tuple is a subtype of the method signature. For this algorithm to work, it's important that methods be sorted by their specificity, and that the search begins with the most specific methods. Consequently, Julia also implements a partial order on types; this is achieved by functionality that is similar to <:, but with differences that will be discussed below.","page":"More about types"},{"title":"UnionAll types","location":"devdocs/types.html#UnionAll-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Julia's type system can also express an iterated union of types: a union of types over all values of some variable. This is needed to describe parametric types where the values of some parameters are not known.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"For example, Array has two parameters as in Array{Int,2}. If we did not know the element type, we could write Array{T,2} where T, which is the union of Array{T,2} for all values of T: Union{Array{Int8,2}, Array{Int16,2}, ...}.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Such a type is represented by a UnionAll object, which contains a variable (T in this example, of type TypeVar), and a wrapped type (Array{T,2} in this example).","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Consider the following methods:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f1(A::Array) = 1\nf2(A::Array{Int}) = 2\nf3(A::Array{T}) where {T<:Any} = 3\nf4(A::Array{Any}) = 4","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The signature - as described in Function calls - of f3 is a UnionAll type wrapping a tuple type: Tuple{typeof(f3), Array{T}} where T. All but f4 can be called with a = [1,2]; all but f2 can be called with b = Any[1,2].","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Let's look at these types a little more closely:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> dump(Array)\nUnionAll\n  var: TypeVar\n    name: Symbol T\n    lb: Union{}\n    ub: Any\n  body: UnionAll\n    var: TypeVar\n      name: Symbol N\n      lb: Union{}\n      ub: Any\n    body: Array{T, N} <: DenseArray{T, N}\n      ref::MemoryRef{T}\n      size::NTuple{N, Int64}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"This indicates that Array actually names a UnionAll type. There is one UnionAll type for each parameter, nested. The syntax Array{Int,2} is equivalent to Array{Int}{2}; internally each UnionAll is instantiated with a particular variable value, one at a time, outermost-first. This gives a natural meaning to the omission of trailing type parameters; Array{Int} gives a type equivalent to Array{Int,N} where N.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"A TypeVar is not itself a type, but rather should be considered part of the structure of a UnionAll type. Type variables have lower and upper bounds on their values (in the fields lb and ub). The symbol name is purely cosmetic. Internally, TypeVars are compared by address, so they are defined as mutable types to ensure that \"different\" type variables can be distinguished. However, by convention they should not be mutated.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"One can construct TypeVars manually:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> TypeVar(:V, Signed, Real)\nSigned<:V<:Real","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"There are convenience versions that allow you to omit any of these arguments except the name symbol.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The syntax Array{T} where T<:Integer is lowered to","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"let T = TypeVar(:T,Integer)\n    UnionAll(T, Array{T})\nend","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"so it is seldom necessary to construct a TypeVar manually (indeed, this is to be avoided).","page":"More about types"},{"title":"Free variables","location":"devdocs/types.html#Free-variables","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The concept of a free type variable is extremely important in the type system. We say that a variable V is free in type T if T does not contain the UnionAll that introduces variable V. For example, the type Array{Array{V} where V<:Integer} has no free variables, but the Array{V} part inside of it does have a free variable, V.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"A type with free variables is, in some sense, not really a type at all. Consider the type Array{Array{T}} where T, which refers to all homogeneous arrays of arrays. The inner type Array{T}, seen by itself, might seem to refer to any kind of array. However, every element of the outer array must have the same array type, so Array{T} cannot refer to just any old array. One could say that Array{T} effectively \"occurs\" multiple times, and T must have the same value each \"time\".","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"For this reason, the function jl_has_free_typevars in the C API is very important. Types for which it returns true will not give meaningful answers in subtyping and other type functions.","page":"More about types"},{"title":"TypeNames","location":"devdocs/types.html#TypeNames","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The following two Array types are functionally equivalent, yet print differently:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> TV, NV = TypeVar(:T), TypeVar(:N)\n(T, N)\n\njulia> Array\nArray\n\njulia> Array{TV, NV}\nArray{T, N}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"These can be distinguished by examining the name field of the type, which is an object of type TypeName:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> dump(Array{Int,1}.name)\nTypeName\n  name: Symbol Array\n  module: Module Core\n  names: empty SimpleVector\n  wrapper: UnionAll\n    var: TypeVar\n      name: Symbol T\n      lb: Union{}\n      ub: Any\n    body: UnionAll\n      var: TypeVar\n        name: Symbol N\n        lb: Union{}\n        ub: Any\n      body: Array{T, N} <: DenseArray{T, N}\n  cache: SimpleVector\n    ...\n\n  linearcache: SimpleVector\n    ...\n\n  hash: Int64 -7900426068641098781\n  mt: MethodTable\n    name: Symbol Array\n    defs: Nothing nothing\n    cache: Nothing nothing\n    max_args: Int64 0\n    module: Module Core\n    : Int64 0\n    : Int64 0","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"In this case, the relevant field is wrapper, which holds a reference to the top-level type used to make new Array types.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> pointer_from_objref(Array)\nPtr{Cvoid} @0x00007fcc7de64850\n\njulia> pointer_from_objref(Array.body.body.name.wrapper)\nPtr{Cvoid} @0x00007fcc7de64850\n\njulia> pointer_from_objref(Array{TV,NV})\nPtr{Cvoid} @0x00007fcc80c4d930\n\njulia> pointer_from_objref(Array{TV,NV}.name.wrapper)\nPtr{Cvoid} @0x00007fcc7de64850","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The wrapper field of Array points to itself, but for Array{TV,NV} it points back to the original definition of the type.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"What about the other fields? hash assigns an integer to each type.  To examine the cache field, it's helpful to pick a type that is less heavily used than Array. Let's first create our own type:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> struct MyType{T,N} end\n\njulia> MyType{Int,2}\nMyType{Int64, 2}\n\njulia> MyType{Float32, 5}\nMyType{Float32, 5}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"When you instantiate a parametric type, each concrete type gets saved in a type cache (MyType.body.body.name.cache). However, instances containing free type variables are not cached.","page":"More about types"},{"title":"Tuple types","location":"devdocs/types.html#Tuple-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Tuple types constitute an interesting special case.  For dispatch to work on declarations like x::Tuple, the type has to be able to accommodate any tuple.  Let's check the parameters:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> Tuple\nTuple\n\njulia> Tuple.parameters\nsvec(Vararg{Any})","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Unlike other types, tuple types are covariant in their parameters, so this definition permits Tuple to match any type of tuple:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> typeintersect(Tuple, Tuple{Int,Float64})\nTuple{Int64, Float64}\n\njulia> typeintersect(Tuple{Vararg{Any}}, Tuple{Int,Float64})\nTuple{Int64, Float64}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"However, if a variadic (Vararg) tuple type has free variables it can describe different kinds of tuples:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> typeintersect(Tuple{Vararg{T} where T}, Tuple{Int,Float64})\nTuple{Int64, Float64}\n\njulia> typeintersect(Tuple{Vararg{T}} where T, Tuple{Int,Float64})\nUnion{}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Notice that when T is free with respect to the Tuple type (i.e. its binding UnionAll type is outside the Tuple type), only one T value must work over the whole type. Therefore a heterogeneous tuple does not match.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Finally, it's worth noting that Tuple{} is distinct:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> Tuple{}\nTuple{}\n\njulia> Tuple{}.parameters\nsvec()\n\njulia> typeintersect(Tuple{}, Tuple{Int})\nUnion{}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"What is the \"primary\" tuple-type?","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> pointer_from_objref(Tuple)\nPtr{Cvoid} @0x00007f5998a04370\n\njulia> pointer_from_objref(Tuple{})\nPtr{Cvoid} @0x00007f5998a570d0\n\njulia> pointer_from_objref(Tuple.name.wrapper)\nPtr{Cvoid} @0x00007f5998a04370\n\njulia> pointer_from_objref(Tuple{}.name.wrapper)\nPtr{Cvoid} @0x00007f5998a04370","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"so Tuple == Tuple{Vararg{Any}} is indeed the primary type.","page":"More about types"},{"title":"Diagonal types","location":"devdocs/types.html#Diagonal-types","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Consider the type Tuple{T,T} where T. A method with this signature would look like:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(x::T, y::T) where {T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"According to the usual interpretation of a UnionAll type, this T ranges over all types, including Any, so this type should be equivalent to Tuple{Any,Any}. However, this interpretation causes some practical problems.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"First, a value of T needs to be available inside the method definition. For a call like f(1, 1.0), it's not clear what T should be. It could be Union{Int,Float64}, or perhaps Real. Intuitively, we expect the declaration x::T to mean T === typeof(x). To make sure that invariant holds, we need typeof(x) === typeof(y) === T in this method. That implies the method should only be called for arguments of the exact same type.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"It turns out that being able to dispatch on whether two values have the same type is very useful (this is used by the promotion system for example), so we have multiple reasons to want a different interpretation of Tuple{T,T} where T. To make this work we add the following rule to subtyping: if a variable occurs more than once in covariant position, it is restricted to ranging over only concrete types. (\"Covariant position\" means that only Tuple and Union types occur between an occurrence of a variable and the UnionAll type that introduces it.) Such variables are called \"diagonal variables\" or \"concrete variables\".","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"So for example, Tuple{T,T} where T can be seen as Union{Tuple{Int8,Int8}, Tuple{Int16,Int16}, ...}, where T ranges over all concrete types. This gives rise to some interesting subtyping results. For example Tuple{Real,Real} is not a subtype of Tuple{T,T} where T, because it includes some types like Tuple{Int8,Int16} where the two elements have different types. Tuple{Real,Real} and Tuple{T,T} where T have the non-trivial intersection Tuple{T,T} where T<:Real. However, Tuple{Real} is a subtype of Tuple{T} where T, because in that case T occurs only once and so is not diagonal.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Next consider a signature like the following:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(a::Array{T}, x::T, y::T) where {T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"In this case, T occurs in invariant position inside Array{T}. That means whatever type of array is passed unambiguously determines the value of T – we say T has an equality constraint on it. Therefore in this case the diagonal rule is not really necessary, since the array determines T and we can then allow x and y to be of any subtypes of T. So variables that occur in invariant position are never considered diagonal. This choice of behavior is slightly controversial – some feel this definition should be written as","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(a::Array{T}, x::S, y::S) where {T, S<:T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"to clarify whether x and y need to have the same type. In this version of the signature they would, or we could introduce a third variable for the type of y if x and y can have different types.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The next complication is the interaction of unions and diagonal variables, e.g.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(x::Union{Nothing,T}, y::T) where {T} = ...","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Consider what this declaration means. y has type T. x then can have either the same type T, or else be of type Nothing. So all of the following calls should match:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"f(1, 1)\nf(\"\", \"\")\nf(2.0, 2.0)\nf(nothing, 1)\nf(nothing, \"\")\nf(nothing, 2.0)","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"These examples are telling us something: when x is nothing::Nothing, there are no extra constraints on y. It is as if the method signature had y::Any. Indeed, we have the following type equivalence:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"(Tuple{Union{Nothing,T},T} where T) == Union{Tuple{Nothing,Any}, Tuple{T,T} where T}","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The general rule is: a concrete variable in covariant position acts like it's not concrete if the subtyping algorithm only uses it once. When x has type Nothing, we don't need to use the T in Union{Nothing,T}; we only use it in the second slot. This arises naturally from the observation that in Tuple{T} where T restricting T to concrete types makes no difference; the type is equal to Tuple{Any} either way.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"However, appearing in invariant position disqualifies a variable from being concrete whether that appearance of the variable is used or not. Otherwise types can behave differently depending on which other types they are compared to, making subtyping not transitive. For example, consider","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Tuple{Int,Int8,Vector{Integer}} <: Tuple{T,T,Vector{Union{Integer,T}}} where T","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If the T inside the Union is ignored, then T is concrete and the answer is \"false\" since the first two types aren't the same. But consider instead","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Tuple{Int,Int8,Vector{Any}} <: Tuple{T,T,Vector{Union{Integer,T}}} where T","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Now we cannot ignore the T in the Union (we must have T == Any), so T is not concrete and the answer is \"true\". That would make the concreteness of T depend on the other type, which is not acceptable since a type must have a clear meaning on its own. Therefore the appearance of T inside Vector is considered in both cases.","page":"More about types"},{"title":"Subtyping diagonal variables","location":"devdocs/types.html#Subtyping-diagonal-variables","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The subtyping algorithm for diagonal variables has two components: (1) identifying variable occurrences, and (2) ensuring that diagonal variables range over concrete types only.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The first task is accomplished by keeping counters occurs_inv and occurs_cov (in src/subtype.c) for each variable in the environment, tracking the number of invariant and covariant occurrences, respectively. A variable is diagonal when occurs_inv == 0 && occurs_cov > 1.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The second task is accomplished by imposing a condition on a variable's lower bound. As the subtyping algorithm runs, it narrows the bounds of each variable (raising lower bounds and lowering upper bounds) to keep track of the range of variable values for which the subtype relation would hold. When we are done evaluating the body of a UnionAll type whose variable is diagonal, we look at the final values of the bounds. Since the variable must be concrete, a contradiction occurs if its lower bound could not be a subtype of a concrete type. For example, an abstract type like AbstractArray cannot be a subtype of a concrete type, but a concrete type like Int can be, and the empty type Bottom can be as well. If a lower bound fails this test the algorithm stops with the answer false.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"For example, in the problem Tuple{Int,String} <: Tuple{T,T} where T, we derive that this would be true if T were a supertype of Union{Int,String}. However, Union{Int,String} is an abstract type, so the relation does not hold.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"This concreteness test is done by the function is_leaf_bound. Note that this test is slightly different from jl_is_leaf_type, since it also returns true for Bottom. Currently this function is heuristic, and does not catch all possible concrete types. The difficulty is that whether a lower bound is concrete might depend on the values of other type variable bounds. For example, Vector{T} is equivalent to the concrete type Vector{Int} only if both the upper and lower bounds of T equal Int. We have not yet worked out a complete algorithm for this.","page":"More about types"},{"title":"Introduction to the internal machinery","location":"devdocs/types.html#Introduction-to-the-internal-machinery","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Most operations for dealing with types are found in the files jltypes.c and subtype.c. A good way to start is to watch subtyping in action. Build Julia with make debug and fire up Julia within a debugger. gdb debugging tips has some tips which may be useful.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"Because the subtyping code is used heavily in the REPL itself – and hence breakpoints in this code get triggered often – it will be easiest if you make the following definition:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"julia> function mysubtype(a,b)\n           ccall(:jl_breakpoint, Cvoid, (Any,), nothing)\n           a <: b\n       end","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"and then set a breakpoint in jl_breakpoint.  Once this breakpoint gets triggered, you can set breakpoints in other functions.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"As a warm-up, try the following:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"mysubtype(Tuple{Int, Float64}, Tuple{Integer, Real})","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"We can make it more interesting by trying a more complex case:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"mysubtype(Tuple{Array{Int,2}, Int8}, Tuple{Array{T}, T} where T)","page":"More about types"},{"title":"Subtyping and method sorting","location":"devdocs/types.html#Subtyping-and-method-sorting","category":"section","text":"","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"The type_morespecific functions are used for imposing a partial order on functions in method tables (from most-to-least specific). Specificity is strict; if a is more specific than b, then a does not equal b and b is not more specific than a.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If a is a strict subtype of b, then it is automatically considered more specific. From there, type_morespecific employs some less formal rules. For example, subtype is sensitive to the number of arguments, but type_morespecific may not be. In particular, Tuple{Int,AbstractFloat} is more specific than Tuple{Integer}, even though it is not a subtype.  (Of Tuple{Int,AbstractFloat} and Tuple{Integer,Float64}, neither is more specific than the other.)  Likewise, Tuple{Int,Vararg{Int}} is not a subtype of Tuple{Integer}, but it is considered more specific. However, morespecific does get a bonus for length: in particular, Tuple{Int,Int} is more specific than Tuple{Int,Vararg{Int}}.","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"If you're debugging how methods get sorted, it can be convenient to define the function:","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"type_morespecific(a, b) = ccall(:jl_type_morespecific, Cint, (Any,Any), a, b)","page":"More about types"},{"title":"More about types","location":"devdocs/types.html","category":"page","text":"which allows you to test whether tuple type a is more specific than tuple type b.","page":"More about types"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html#Handling-Operating-System-Variation","category":"section","text":"","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"When writing cross-platform applications or libraries, it is often necessary to allow for differences between operating systems. The variable Sys.KERNEL can be used to handle such cases. There are several functions in the Sys module intended to make this easier, such as isunix, islinux, isapple, isbsd, isfreebsd, and iswindows. These may be used as follows:","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"if Sys.iswindows()\n    windows_specific_thing(a)\nend","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"Note that islinux, isapple, and isfreebsd are mutually exclusive subsets of isunix. Additionally, there is a macro @static which makes it possible to use these functions to conditionally hide invalid code, as demonstrated in the following examples.","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"Simple blocks:","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"ccall((@static Sys.iswindows() ? :_fopen : :fopen), ...)","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"Complex blocks:","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"@static if Sys.islinux()\n    linux_specific_thing(a)\nelseif Sys.isapple()\n    apple_specific_thing(a)\nelse\n    generic_thing(a)\nend","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"When nesting conditionals, the @static must be repeated for each level (parentheses optional, but recommended for readability):","page":"Handling Operating System Variation"},{"title":"Handling Operating System Variation","location":"manual/handling-operating-system-variation.html","category":"page","text":"@static Sys.iswindows() ? :a : (@static Sys.isapple() ? :b : :c)","page":"Handling Operating System Variation"},{"title":"SIMD Support","location":"base/simd-types.html#SIMD-Support","category":"section","text":"","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"Type VecElement{T} is intended for building libraries of SIMD operations. Practical use of it requires using llvmcall. The type is defined as:","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"struct VecElement{T}\n    value::T\nend","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"It has a special compilation rule: a homogeneous tuple of VecElement{T} maps to an LLVM vector type when T is a primitive bits type.","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"At -O3, the compiler might automatically vectorize operations on such tuples. For example, the following program, when compiled with julia -O3 generates two SIMD addition instructions (addps) on x86 systems:","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"const m128 = NTuple{4,VecElement{Float32}}\n\nfunction add(a::m128, b::m128)\n    (VecElement(a[1].value+b[1].value),\n     VecElement(a[2].value+b[2].value),\n     VecElement(a[3].value+b[3].value),\n     VecElement(a[4].value+b[4].value))\nend\n\ntriple(c::m128) = add(add(c,c),c)\n\ncode_native(triple,(m128,))","page":"SIMD Support"},{"title":"SIMD Support","location":"base/simd-types.html","category":"page","text":"However, since the automatic vectorization cannot be relied upon, future use will mostly be via libraries that use llvmcall.","page":"SIMD Support"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html#gdb-debugging-tips","category":"section","text":"","page":"gdb debugging tips"},{"title":"Displaying Julia variables","location":"devdocs/debuggingtips.html#Displaying-Julia-variables","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Within gdb, any jl_value_t* object obj can be displayed using","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) call jl_(obj)","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"The object will be displayed in the julia session, not in the gdb session. This is a useful way to discover the types and values of objects being manipulated by Julia's C code.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Similarly, if you're debugging some of Julia's internals (e.g., compiler.jl), you can print obj using","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"ccall(:jl_, Cvoid, (Any,), obj)","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"This is a good way to circumvent problems that arise from the order in which julia's output streams are initialized.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Julia's flisp interpreter uses value_t objects; these can be displayed with call fl_print(fl_ctx, ios_stdout, obj).","page":"gdb debugging tips"},{"title":"Useful Julia variables for Inspecting","location":"devdocs/debuggingtips.html#Useful-Julia-variables-for-Inspecting","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"While the addresses of many variables, like singletons, can be useful to print for many failures, there are a number of additional variables (see julia.h for a complete list) that are even more useful.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(when in jl_apply_generic) mfunc and jl_uncompress_ast(mfunc->def, mfunc->code) :: for figuring out a bit about the call-stack\njl_lineno and jl_filename :: for figuring out what line in a test to go start debugging from (or figure out how far into a file has been parsed)\n$1 :: not really a variable, but still a useful shorthand for referring to the result of the last gdb command (such as print)\njl_options :: sometimes useful, since it lists all of the command line options that were successfully parsed\njl_uv_stderr :: because who doesn't like to be able to interact with stdio","page":"gdb debugging tips"},{"title":"Useful Julia functions for Inspecting those variables","location":"devdocs/debuggingtips.html#Useful-Julia-functions-for-Inspecting-those-variables","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"jl_print_task_backtraces(0) :: Similar to gdb's thread apply all bt or lldb's thread backtrace all. Runs all threads while printing backtraces for all existing tasks.\njl_gdblookup($pc) :: For looking up the current function and line.\njl_gdblookupinfo($pc) :: For looking up the current method instance object.\njl_gdbdumpcode(mi) :: For dumping all of code_typed/code_llvm/code_asm when the REPL is not working right.\njlbacktrace() :: For dumping the current Julia backtrace stack to stderr. Only usable after record_backtrace() has been called.\njl_dump_llvm_value(Value*) :: For invoking Value->dump() in gdb, where it doesn't work natively. For example, f->linfo->functionObject, f->linfo->specFunctionObject, and to_function(f->linfo).\njl_dump_llvm_module(Module*) :: For invoking Module->dump() in gdb, where it doesn't work natively.\nType->dump() :: only works in lldb. Note: add something like ;1 to prevent lldb from printing its prompt over the output\njl_eval_string(\"expr\") :: for invoking side-effects to modify the current state or to lookup symbols\njl_typeof(jl_value_t*) :: for extracting the type tag of a Julia value (in gdb, call macro define jl_typeof jl_typeof first, or pick something short like ty for the first arg to define a shorthand)","page":"gdb debugging tips"},{"title":"Inserting breakpoints for inspection from gdb","location":"devdocs/debuggingtips.html#Inserting-breakpoints-for-inspection-from-gdb","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"In your gdb session, set a breakpoint in jl_breakpoint like so:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) break jl_breakpoint","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then within your Julia code, insert a call to jl_breakpoint by adding","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"ccall(:jl_breakpoint, Cvoid, (Any,), obj)","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"where obj can be any variable or tuple you want to be accessible in the breakpoint.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"It's particularly helpful to back up to the jl_apply frame, from which you can display the arguments to a function using, e.g.,","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) call jl_(args[0])","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Another useful frame is to_function(jl_method_instance_t *li, bool cstyle). The jl_method_instance_t* argument is a struct with a reference to the final AST sent into the compiler. However, the AST at this point will usually be compressed; to view the AST, call jl_uncompress_ast and then pass the result to jl_:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"#2  0x00007ffff7928bf7 in to_function (li=0x2812060, cstyle=false) at codegen.cpp:584\n584          abort();\n(gdb) p jl_(jl_uncompress_ast(li, li->ast))","page":"gdb debugging tips"},{"title":"Inserting breakpoints upon certain conditions","location":"devdocs/debuggingtips.html#Inserting-breakpoints-upon-certain-conditions","category":"section","text":"","page":"gdb debugging tips"},{"title":"Loading a particular file","location":"devdocs/debuggingtips.html#Loading-a-particular-file","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Let's say the file is sysimg.jl:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) break jl_load if strcmp(fname, \"sysimg.jl\")==0","page":"gdb debugging tips"},{"title":"Calling a particular method","location":"devdocs/debuggingtips.html#Calling-a-particular-method","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) break jl_apply_generic if strcmp((char*)(jl_symbol_name)(jl_gf_mtable(F)->name), \"method_to_break\")==0","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Since this function is used for every call, you will make everything 1000x slower if you do this.","page":"gdb debugging tips"},{"title":"Dealing with signals","location":"devdocs/debuggingtips.html#Dealing-with-signals","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Julia requires a few signals to function properly. The profiler uses SIGUSR2 for sampling and the garbage collector uses SIGSEGV for threads synchronization. If you are debugging some code that uses the profiler or multiple threads, you may want to let the debugger ignore these signals since they can be triggered very often during normal operations. The command to do this in GDB is (replace SIGSEGV with SIGUSR2 or other signals you want to ignore):","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) handle SIGSEGV noprint nostop pass","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"The corresponding LLDB command is (after the process is started):","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(lldb) pro hand -p true -s false -n false SIGSEGV","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"If you are debugging a segfault with threaded code, you can set a breakpoint on jl_critical_error (sigdie_handler should also work on Linux and BSD) in order to only catch the actual segfault rather than the GC synchronization points.","page":"gdb debugging tips"},{"title":"Debugging during Julia's build process (bootstrap)","location":"devdocs/debuggingtips.html#Debugging-during-Julia's-build-process-(bootstrap)","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Errors that occur during make need special handling. Julia is built in two stages, constructing sys0 and sys.ji. To see what commands are running at the time of failure, use make VERBOSE=1.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"At the time of this writing, you can debug build errors during the sys0 phase from the base directory using:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"julia/base$ gdb --args ../usr/bin/julia-debug -C native --build ../usr/lib/julia/sys0 sysimg.jl","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"You might need to delete all the files in usr/lib/julia/ to get this to work.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"You can debug the sys.ji phase using:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"julia/base$ gdb --args ../usr/bin/julia-debug -C native --build ../usr/lib/julia/sys -J ../usr/lib/julia/sys0.ji sysimg.jl","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"By default, any errors will cause Julia to exit, even under gdb. To catch an error \"in the act\", set a breakpoint in jl_error (there are several other useful spots, for specific kinds of failures, including: jl_too_few_args, jl_too_many_args, and jl_throw).","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Once an error is caught, a useful technique is to walk up the stack and examine the function by inspecting the related call to jl_apply. To take a real-world example:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Breakpoint 1, jl_throw (e=0x7ffdf42de400) at task.c:802\n802 {\n(gdb) p jl_(e)\nErrorException(\"auto_unbox: unable to determine argument type\")\n$2 = void\n(gdb) bt 10\n#0  jl_throw (e=0x7ffdf42de400) at task.c:802\n#1  0x00007ffff65412fe in jl_error (str=0x7ffde56be000 <_j_str267> \"auto_unbox:\n   unable to determine argument type\")\n   at builtins.c:39\n#2  0x00007ffde56bd01a in julia_convert_16886 ()\n#3  0x00007ffff6541154 in jl_apply (f=0x7ffdf367f630, args=0x7fffffffc2b0, nargs=2) at julia.h:1281\n...","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"The most recent jl_apply is at frame #3, so we can go back there and look at the AST for the function julia_convert_16886. This is the uniqued name for some method of convert. f in this frame is a jl_function_t*, so we can look at the type signature, if any, from the specTypes field:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) f 3\n#3  0x00007ffff6541154 in jl_apply (f=0x7ffdf367f630, args=0x7fffffffc2b0, nargs=2) at julia.h:1281\n1281            return f->fptr((jl_value_t*)f, args, nargs);\n(gdb) p f->linfo->specTypes\n$4 = (jl_tupletype_t *) 0x7ffdf39b1030\n(gdb) p jl_( f->linfo->specTypes )\nTuple{Type{Float32}, Float64}           # <-- type signature for julia_convert_16886","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then, we can look at the AST for this function:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) p jl_( jl_uncompress_ast(f->linfo, f->linfo->ast) )\nExpr(:lambda, Array{Any, 1}[:#s29, :x], Array{Any, 1}[Array{Any, 1}[], Array{Any, 1}[Array{Any, 1}[:#s29, :Any, 0], Array{Any, 1}[:x, :Any, 0]], Array{Any, 1}[], 0], Expr(:body,\nExpr(:line, 90, :float.jl)::Any,\nExpr(:return, Expr(:call, :box, :Float32, Expr(:call, :fptrunc, :Float32, :x)::Any)::Any)::Any)::Any)::Any","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Finally, and perhaps most usefully, we can force the function to be recompiled in order to step through the codegen process. To do this, clear the cached functionObject from the jl_lamdbda_info_t*:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) p f->linfo->functionObject\n$8 = (void *) 0x1289d070\n(gdb) set f->linfo->functionObject = NULL","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then, set a breakpoint somewhere useful (e.g. emit_function, emit_expr, emit_call, etc.), and run codegen:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) p jl_compile(f)\n... # your breakpoint here","page":"gdb debugging tips"},{"title":"Debugging precompilation errors","location":"devdocs/debuggingtips.html#Debugging-precompilation-errors","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Module precompilation spawns a separate Julia process to precompile each module. Setting a breakpoint or catching failures in a precompile worker requires attaching a debugger to the worker. The easiest approach is to set the debugger watch for new process launches matching a given name. For example:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(gdb) attach -w -n julia-debug","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"or:","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"(lldb) process attach -w -n julia-debug","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Then run a script/command to start precompilation. As described earlier, use conditional breakpoints in the parent process to catch specific file-loading events and narrow the debugging window. (some operating systems may require alternative approaches, such as following each fork from the parent process)","page":"gdb debugging tips"},{"title":"Mozilla's Record and Replay Framework (rr)","location":"devdocs/debuggingtips.html#Mozilla's-Record-and-Replay-Framework-(rr)","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"Julia now works out of the box with rr, the lightweight recording and deterministic debugging framework from Mozilla. This allows you to replay the trace of an execution deterministically.  The replayed execution's address spaces, register contents, syscall data etc are exactly the same in every run.","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"A recent version of rr (3.1.0 or higher) is required.","page":"gdb debugging tips"},{"title":"Reproducing concurrency bugs with rr","location":"devdocs/debuggingtips.html#Reproducing-concurrency-bugs-with-rr","category":"section","text":"","page":"gdb debugging tips"},{"title":"gdb debugging tips","location":"devdocs/debuggingtips.html","category":"page","text":"rr simulates a single-threaded machine by default. In order to debug concurrent code you can use rr record --chaos which will cause rr to simulate between one to eight cores, chosen randomly. You might therefore want to set JULIA_NUM_THREADS=8 and rerun your code under rr until you have caught your bug.","page":"gdb debugging tips"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html#stdlib-styledstrings","category":"section","text":"","page":"StyledStrings"},{"title":"Styling","location":"stdlib/StyledStrings.html#stdlib-styledstrings-styling","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"When working with strings, formatting and styling often appear as a secondary concern.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"For instance, when printing to a terminal you might want to sprinkle ANSI escape sequences in the output, when outputting HTML styling constructs (<span style=\"...\">, etc.) serve a similar purpose, and so on. It is possible to simply insert the raw styling constructs into the string next to the content itself, but it quickly becomes apparent that this is not well suited for anything but the most basic use cases. Not all terminals support the same ANSI codes, the styling constructs need to be painstakingly removed when calculating the width of already-styled content, and that's before you even get into handling multiple output formats.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Instead of leaving this headache to be widely experienced downstream, it is tackled head-on by the introduction of a special string type (AnnotatedString). This string type wraps any other AbstractString type and allows for formatting information to be applied to regions (e.g. characters 1 through to 7 are bold and red).","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Regions of a string are styled by applying Faces (think \"typeface\") to them — a structure that holds styling information. As a convenience, faces in the global faces dictionary (e.g. shadow) can just be named instead of giving the Face directly.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Along with these capabilities, we also provide a convenient way for constructing AnnotatedStrings, detailed in Styled String Literals.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"using StyledStrings\nstyled\"{yellow:hello} {blue:there}\"","page":"StyledStrings"},{"title":"Styling via AnnotatedStrings","location":"stdlib/StyledStrings.html#Styling-via-[AnnotatedString](@ref-Base.AnnotatedString)s","category":"section","text":"","page":"StyledStrings"},{"title":"Faces","location":"stdlib/StyledStrings.html#stdlib-styledstrings-faces","category":"section","text":"","page":"StyledStrings"},{"title":"The Face type","location":"stdlib/StyledStrings.html#The-Face-type","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"A Face specifies details of a typeface that text can be set in. It covers a set of basic attributes that generalize well across different formats, namely:","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"font\nheight\nweight\nslant\nforeground\nbackground\nunderline\nstrikethrough\ninverse\ninherit","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"For details on the particular forms these attributes take, see the Face docstring, but of particular interest is inherit as it allows you to inherit attributes from other Faces.","page":"StyledStrings"},{"title":"The global faces dictionary","location":"stdlib/StyledStrings.html#The-global-faces-dictionary","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"To make referring to particular styles more convenient, there is a global Dict{Symbol, Face} that allows for Faces to be referred to simply by name. Packages can add faces to this dictionary via the addface! function, and the loaded faces can be easily customized.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"warning: Appropriate face naming\nAny package registering new faces should ensure that they are prefixed by the package name, i.e. follow the format mypackage_myface. This is important for predictability, and to prevent name clashes.Furthermore, packages should take care to use (and introduce) semantic faces (like code) over direct colours and styles (like cyan). This is helpful in a number of ways, from making the intent in usage more obvious, aiding composability, and making user customisation more intuitive.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"There are two set of exemptions to the package-prefix rule:","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"the set of basic faces that are part of the default value of the faces dictionary\nfaces introduced by Julia's own standard library, namely JuliaSyntaxHighlighting","page":"StyledStrings"},{"title":"Basic faces","location":"stdlib/StyledStrings.html#stdlib-styledstrings-basic-faces","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Basic faces are intended to represent a general idea that is widely applicable.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"For setting some text with a certain attribute, we have the bold, light, italic, underline, strikethrough, and inverse faces.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"There are also named faces for the 16 terminal colors: black, red, green, yellow, blue, magenta, cyan, white, bright_black/grey/gray, bright_red, bright_green, bright_blue, bright_magenta, bright_cyan, and bright_white.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"For shadowed text (i.e. dim but there) there is the shadow face. To indicate a selected region, there is the region face. Similarly for emphasis and highlighting the emphasis and highlight faces are defined. There is also code for code-like text.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"For visually indicating the severity of messages, the error, warning, success, info, note, and tip faces are defined.","page":"StyledStrings"},{"title":"Customisation of faces (Faces.toml)","location":"stdlib/StyledStrings.html#stdlib-styledstrings-face-toml","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"It is good for the name faces in the global face dictionary to be customizable. Theming and aesthetics are nice, and it is important for accessibility reasons too. A TOML file can be parsed into a list of Face specifications that are merged with the pre-existing entry in the face dictionary.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"A Face is represented in TOML like so:","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"[facename]\nattribute = \"value\"\n...\n\n[package.facename]\nattribute = \"value\"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"For example, if the shadow face is too hard to read it can be made brighter like so:","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"[shadow]\nforeground = \"white\"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"On initialization, the config/faces.toml file under the first Julia depot (usually ~/.julia) is loaded.","page":"StyledStrings"},{"title":"Applying faces to a AnnotatedString","location":"stdlib/StyledStrings.html#Applying-faces-to-a-AnnotatedString","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"By convention, the :face attributes of a AnnotatedString hold information on the Faces that currently apply. This can be given in multiple forms, as a single Symbol naming a Faces in the global face dictionary, a Face itself, or a vector of either.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"The show(::IO, ::MIME\"text/plain\", ::AnnotatedString) and show(::IO, ::MIME\"text/html\", ::AnnotatedString) methods both look at the :face attributes and merge them all together when determining the overall styling.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"We can supply :face attributes to a AnnotatedString during construction, add them to the properties list afterwards, or use the convenient Styled String literals.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"str1 = Base.AnnotatedString(\"blue text\", [(1:9, :face => :blue)])\nstr2 = styled\"{blue:blue text}\"\nstr1 == str2\nsprint(print, str1, context = :color => true)\nsprint(show, MIME(\"text/html\"), str1, context = :color => true)","page":"StyledStrings"},{"title":"Styled String Literals","location":"stdlib/StyledStrings.html#stdlib-styledstring-literals","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"To ease construction of AnnotatedStrings with Faces applied, the styled\"...\" styled string literal allows for the content and attributes to be easily expressed together via a custom grammar.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Within a styled\"...\" literal, curly braces are considered special characters and must be escaped in normal usage (\\{, \\}). This allows them to be used to express annotations with (nestable) {annotations...:text} constructs.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"The annotations... component is a comma-separated list of three types of annotations.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Face names\nInline Face expressions (key=val,...)\nkey=value pairs","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Interpolation is possible everywhere except for inline face keys.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"For more information on the grammar, see the extended help of the styled\"...\" docstring.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"As an example, we can demonstrate the list of built-in faces mentioned above like so:","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"julia> println(styled\"\nThe basic font-style attributes are {bold:bold}, {light:light}, {italic:italic},\n{underline:underline}, and {strikethrough:strikethrough}.\n\nIn terms of color, we have named faces for the 16 standard terminal colors:\n {black:■} {red:■} {green:■} {yellow:■} {blue:■} {magenta:■} {cyan:■} {white:■}\n {bright_black:■} {bright_red:■} {bright_green:■} {bright_yellow:■} {bright_blue:■} {bright_magenta:■} {bright_cyan:■} {bright_white:■}\n\nSince {code:bright_black} is effectively grey, we define two aliases for it:\n{code:grey} and {code:gray} to allow for regional spelling differences.\n\nTo flip the foreground and background colors of some text, you can use the\n{code:inverse} face, for example: {magenta:some {inverse:inverse} text}.\n\nThe intent-based basic faces are {shadow:shadow} (for dim but visible text),\n{region:region} for selections, {emphasis:emphasis}, and {highlight:highlight}.\nAs above, {code:code} is used for code-like text.\n\nLastly, we have the 'message severity' faces: {error:error}, {warning:warning},\n{success:success}, {info:info}, {note:note}, and {tip:tip}.\n\nRemember that all these faces (and any user or package-defined ones) can\narbitrarily nest and overlap, {region,tip:like {bold,italic:so}}.\")","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"Documenter doesn't properly represent all the styling above, so I've converted it manually to HTML and LaTeX.","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"<pre>\n The basic font-style attributes are <span style=\"font-weight: 700;\">bold</span>, <span style=\"font-weight: 300;\">light</span>, <span style=\"font-style: italic;\">italic</span>,\n <span style=\"text-decoration: underline;\">underline</span>, and <span style=\"text-decoration: line-through\">strikethrough</span>.\n\n In terms of color, we have named faces for the 16 standard terminal colors:\n  <span style=\"color: #1c1a23;\">■</span> <span style=\"color: #a51c2c;\">■</span> <span style=\"color: #25a268;\">■</span> <span style=\"color: #e5a509;\">■</span> <span style=\"color: #195eb3;\">■</span> <span style=\"color: #803d9b;\">■</span> <span style=\"color: #0097a7;\">■</span> <span style=\"color: #dddcd9;\">■</span>\n  <span style=\"color: #76757a;\">■</span> <span style=\"color: #ed333b;\">■</span> <span style=\"color: #33d079;\">■</span> <span style=\"color: #f6d22c;\">■</span> <span style=\"color: #3583e4;\">■</span> <span style=\"color: #bf60ca;\">■</span> <span style=\"color: #26c6da;\">■</span> <span style=\"color: #f6f5f4;\">■</span>\n\n Since <span style=\"color: #0097a7;\">bright_black</span> is effectively grey, we define two aliases for it:\n <span style=\"color: #0097a7;\">grey</span> and <span style=\"color: #0097a7;\">gray</span> to allow for regional spelling differences.\n\n To flip the foreground and background colors of some text, you can use the\n <span style=\"color: #0097a7;\">inverse</span> face, for example: <span style=\"color: #803d9b;\">some </span><span style=\"background-color: #803d9b;\">inverse</span><span style=\"color: #803d9b;\"> text</span>.\n\n The intent-based basic faces are <span style=\"color: #76757a;\">shadow</span> (for dim but visible text),\n <span style=\"background-color: #3a3a3a;\">region</span> for selections, <span style=\"color: #195eb3;\">emphasis</span>, and <span style=\"background-color: #195eb3;\">highlight</span>.\n As above, <span style=\"color: #0097a7;\">code</span> is used for code-like text.\n\n Lastly, we have the 'message severity' faces: <span style=\"color: #ed333b;\">error</span>, <span style=\"color: #e5a509;\">warning</span>,\n <span style=\"color: #25a268;\">success</span>, <span style=\"color: #26c6da;\">info</span>, <span style=\"color: #76757a;\">note</span>, and <span style=\"color: #33d079;\">tip</span>.\n\n Remember that all these faces (and any user or package-defined ones) can\n arbitrarily nest and overlap, <span style=\"color: #33d079;background-color: #3a3a3a;\">like <span style=\"font-weight: 700;font-style: italic;\">so</span></span>.</pre>","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"\\begingroup\n\\ttfamily\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{\\baselineskip}\n\nThe basic font-style attributes are {\\fontseries{b}\\selectfont bold}, {\\fontseries{l}\\selectfont light}, {\\fontshape{it}\\selectfont italic},\\\\\n\\underline{underline}, and {strikethrough}.\n\nIn terms of color, we have named faces for the 16 standard terminal colors:\\\\\n{\\color[HTML]{1c1a23}\\(\\blacksquare\\)} {\\color[HTML]{a51c2c}\\(\\blacksquare\\)} {\\color[HTML]{25a268}\\(\\blacksquare\\)}\n{\\color[HTML]{e5a509}\\(\\blacksquare\\)} {\\color[HTML]{195eb3}\\(\\blacksquare\\)} {\\color[HTML]{803d9b}\\(\\blacksquare\\)}\n{\\color[HTML]{0097a7}\\(\\blacksquare\\)} {\\color[HTML]{dddcd9}\\(\\blacksquare\\)} \\\\\n{\\color[HTML]{76757a}\\(\\blacksquare\\)} {\\color[HTML]{ed333b}\\(\\blacksquare\\)} {\\color[HTML]{33d079}\\(\\blacksquare\\)} {\\color[HTML]{f6d22c}\\(\\blacksquare\\)} {\\color[HTML]{3583e4}\\(\\blacksquare\\)} {\\color[HTML]{bf60ca}\\(\\blacksquare\\)} {\\color[HTML]{26c6da}\\(\\blacksquare\\)} {\\color[HTML]{f6f5f4}\\(\\blacksquare\\)}\n\nSince {\\color[HTML]{0097a7}bright\\_black} is effectively grey, we define two aliases for it:\\\\\n{\\color[HTML]{0097a7}grey} and {\\color[HTML]{0097a7}gray} to allow for regional spelling differences.\n\nTo flip the foreground and background colors of some text, you can use the\\\\\n{\\color[HTML]{0097a7}inverse} face, for example: {\\color[HTML]{803d9b}some \\colorbox[HTML]{803d9b}{\\color[HTML]{000000}inverse} text}.\n\nThe intent-based basic faces are {\\color[HTML]{76757a}shadow} (for dim but visible text),\\\\\n\\colorbox[HTML]{3a3a3a}{region} for selections, {\\color[HTML]{195eb3}emphasis}, and \\colorbox[HTML]{195eb3}{highlight}.\\\\\nAs above, {\\color[HTML]{0097a7}code} is used for code-like text.\n\nLastly, we have the 'message severity' faces: {\\color[HTML]{ed333b}error}, {\\color[HTML]{e5a509}warning},\\\\\n{\\color[HTML]{25a268}success}, {\\color[HTML]{26c6da}info}, {\\color[HTML]{76757a}note}, and {\\color[HTML]{33d079}tip}.\n\nRemember that all these faces (and any user or package-defined ones) can\\\\\narbitrarily nest and overlap, \\colorbox[HTML]{3a3a3a}{\\color[HTML]{33d079}like\n  {\\fontseries{b}\\fontshape{it}\\selectfont so}}.\n\\endgroup","page":"StyledStrings"},{"title":"API reference","location":"stdlib/StyledStrings.html#stdlib-styledstrings-api","category":"section","text":"","page":"StyledStrings"},{"title":"StyledStrings","location":"stdlib/StyledStrings.html","category":"page","text":"StyledStrings.@styled_str\nStyledStrings.styled\nStyledStrings.Face\nStyledStrings.addface!\nStyledStrings.withfaces\nStyledStrings.SimpleColor\nBase.parse(::Type{StyledStrings.SimpleColor}, ::String)\nBase.tryparse(::Type{StyledStrings.SimpleColor}, ::String)\nBase.merge(::StyledStrings.Face, ::StyledStrings.Face)","page":"StyledStrings"},{"title":"StyledStrings.StyledMarkup.@styled_str","location":"stdlib/StyledStrings.html#StyledStrings.StyledMarkup.@styled_str","category":"macro","text":"@styled_str -> AnnotatedString\n\nConstruct a styled string. Within the string, {<specs>:<content>} structures apply the formatting to <content>, according to the list of comma-separated specifications <specs>. Each spec can either take the form of a face name, an inline face specification, or a key=value pair. The value must be wrapped by {...} should it contain any of the characters ,=:{}.\n\nString interpolation with $ functions in the same way as regular strings, except quotes need to be escaped. Faces, keys, and values can also be interpolated with $.\n\nExample\n\nstyled\"The {bold:{italic:quick} {(foreground=#cd853f):brown} fox} jumped over the {link={https://en.wikipedia.org/wiki/Laziness}:lazy} dog\"\n\nExtended help\n\nThis macro can be described by the following EBNF grammar:\n\nstyledstring = { styled | interpolated | escaped | plain } ;\n\nspecialchar = '{' | '}' | '$' | '\\\"' ;\nanychar = [\\u0-\\u1fffff] ;\nplain = { anychar - specialchar } ;\nescaped = '\\\\', specialchar ;\n\ninterpolated = '$', ? expr ? | '$(', ? expr ?, ')' ;\n\nstyled = '{', ws, annotations, ':', content, '}' ;\ncontent = { interpolated | plain | escaped | styled } ;\nannotations = annotation | annotations, ws, ',', ws, annotation ;\nannotation = face | inlineface | keyvalue ;\nws = { ' ' | '\\t' | '\\n' } ; (* whitespace *)\n\nface = facename | interpolated ;\nfacename = [A-Za-z0-9_]+ ;\n\ninlineface = '(', ws, [ faceprop ], { ws, ',', faceprop }, ws, ')' ;\nfaceprop = [a-z]+, ws, '=', ws, ( [^,)]+ | interpolated) ;\n\nkeyvalue = key, ws, '=', ws, value ;\nkey = ( [^\\0${}=,:], [^\\0=,:]* ) | interpolated ;\nvalue = simplevalue | curlybraced | interpolated ;\ncurlybraced = '{' { escaped | plain } '}' ;\nsimplevalue = [^${},:], [^,:]* ;\n\nAn extra stipulation not encoded in the above grammar is that plain should be a valid input to unescape_string, with specialchar kept.\n\nThe above grammar for inlineface is simplified, as the actual implementation is a bit more sophisticated. The full behaviour is given below.\n\nfaceprop = ( 'face', ws, '=', ws, ( ? string ? | interpolated ) ) |\n           ( 'height', ws, '=', ws, ( ? number ? | interpolated ) ) |\n           ( 'weight', ws, '=', ws, ( symbol | interpolated ) ) |\n           ( 'slant', ws, '=', ws, ( symbol | interpolated ) ) |\n           ( ( 'foreground' | 'fg' | 'background' | 'bg' ),\n               ws, '=', ws, ( simplecolor | interpolated ) ) |\n           ( 'underline', ws, '=', ws, ( underline | interpolated ) ) |\n           ( 'strikethrough', ws, '=', ws, ( bool | interpolated ) ) |\n           ( 'inverse', ws, '=', ws, ( bool | interpolated ) ) |\n           ( 'inherit', ws, '=', ws, ( inherit | interpolated ) ) ;\n\nnothing = 'nothing' ;\nbool = 'true' | 'false' ;\nsymbol = [^ ,)]+ ;\nhexcolor = ('#' | '0x'), [0-9a-f]{6} ;\nsimplecolor = hexcolor | symbol | nothing ;\n\nunderline = nothing | bool | simplecolor | underlinestyled;\nunderlinestyled = '(', ws, ('' | nothing | simplecolor | interpolated), ws,\n                  ',', ws, ( symbol | interpolated ), ws ')' ;\n\ninherit = ( '[', inheritval, { ',', inheritval }, ']' ) | inheritval;\ninheritval = ws, ':'?, symbol ;\n\n\n\n\n\n","page":"StyledStrings"},{"title":"StyledStrings.StyledMarkup.styled","location":"stdlib/StyledStrings.html#StyledStrings.StyledMarkup.styled","category":"function","text":"styled(content::AbstractString) -> AnnotatedString\n\nConstruct a styled string. Within the string, {<specs>:<content>} structures apply the formatting to <content>, according to the list of comma-separated specifications <specs>. Each spec can either take the form of a face name, an inline face specification, or a key=value pair. The value must be wrapped by {...} should it contain any of the characters ,=:{}.\n\nThis is a functional equivalent of the @styled_str macro, just without interpolation capabilities.\n\n\n\n\n\n","page":"StyledStrings"},{"title":"StyledStrings.Face","location":"stdlib/StyledStrings.html#StyledStrings.Face","category":"type","text":"A Face is a collection of graphical attributes for displaying text. Faces control how text is displayed in the terminal, and possibly other places too.\n\nMost of the time, a Face will be stored in the global faces dicts as a unique association with a face name Symbol, and will be most often referred to by this name instead of the Face object itself.\n\nAttributes\n\nAll attributes can be set via the keyword constructor, and default to nothing.\n\nheight (an Int or Float64): The height in either deci-pt (when an Int), or as a factor of the base size (when a Float64).\nweight (a Symbol): One of the symbols (from faintest to densest) :thin, :extralight, :light, :semilight, :normal, :medium, :semibold, :bold, :extrabold, or :black. In terminals any weight greater than :normal is displayed as bold, and in terminals that support variable-brightness text, any weight less than :normal is displayed as faint.\nslant (a Symbol): One of the symbols :italic, :oblique, or :normal.\nforeground (a SimpleColor): The text foreground color.\nbackground (a SimpleColor): The text background color.\nunderline, the text underline, which takes one of the following forms:\na Bool: Whether the text should be underlined or not.\n\na SimpleColor: The text should be underlined with this color.\n\na Tuple{Nothing, Symbol}: The text should be underlined using the style set by the Symbol, one of :straight, :double, :curly, :dotted, or :dashed.\n\na Tuple{SimpleColor, Symbol}: The text should be underlined in the specified SimpleColor, and using the style specified by the Symbol, as before.\nstrikethrough (a Bool): Whether the text should be struck through.\ninverse (a Bool): Whether the foreground and background colors should be inverted.\ninherit (a Vector{Symbol}): Names of faces to inherit from, with earlier faces taking priority. All faces inherit from the :default face.\n\n\n\n\n\n","page":"StyledStrings"},{"title":"StyledStrings.addface!","location":"stdlib/StyledStrings.html#StyledStrings.addface!","category":"function","text":"addface!(name::Symbol => default::Face)\n\nCreate a new face by the name name. So long as no face already exists by this name, default is added to both FACES.default and (a copy of) to FACES.current, with the current value returned.\n\nShould the face name already exist, nothing is returned.\n\nExamples\n\njulia> addface!(:mypkg_myface => Face(slant=:italic, underline=true))\nFace (sample)\n         slant: italic\n     underline: true\n\n\n\n\n\n","page":"StyledStrings"},{"title":"StyledStrings.withfaces","location":"stdlib/StyledStrings.html#StyledStrings.withfaces","category":"function","text":"withfaces(f, kv::Pair...)\nwithfaces(f, kvpair_itr)\n\nExecute f with FACES.current temporarily modified by zero or more :name => val arguments kv, or kvpair_itr which produces kv-form values.\n\nwithfaces is generally used via the withfaces(kv...) do ... end syntax. A value of nothing can be used to temporarily unset a face (if it has been set). When withfaces returns, the original FACES.current has been restored.\n\nExamples\n\njulia> withfaces(:yellow => Face(foreground=:red), :green => :blue) do\n           println(styled\"{yellow:red} and {green:blue} mixed make {magenta:purple}\")\n       end\nred and blue mixed make purple\n\n\n\n\n\n","page":"StyledStrings"},{"title":"StyledStrings.SimpleColor","location":"stdlib/StyledStrings.html#StyledStrings.SimpleColor","category":"type","text":"struct SimpleColor\n\nA basic representation of a color, intended for string styling purposes. It can either contain a named color (like :red), or an RGBTuple which is a NamedTuple specifying an r, g, b color with a bit-depth of 8.\n\nConstructors\n\nSimpleColor(name::Symbol)  # e.g. :red\nSimpleColor(rgb::RGBTuple) # e.g. (r=1, b=2, g=3)\nSimpleColor(r::Integer, b::Integer, b::Integer)\nSimpleColor(rgb::UInt32)   # e.g. 0x123456\n\nAlso see tryparse(SimpleColor, rgb::String).\n\n\n\n\n\n","page":"StyledStrings"},{"title":"Base.parse","location":"stdlib/StyledStrings.html#Base.parse-Tuple{Type{StyledStrings.SimpleColor}, String}","category":"method","text":"parse(::Type{SimpleColor}, rgb::String)\n\nAn analogue of tryparse(SimpleColor, rgb::String) (which see), that raises an error instead of returning nothing.\n\n\n\n\n\n","page":"StyledStrings"},{"title":"Base.tryparse","location":"stdlib/StyledStrings.html#Base.tryparse-Tuple{Type{StyledStrings.SimpleColor}, String}","category":"method","text":"tryparse(::Type{SimpleColor}, rgb::String)\n\nAttempt to parse rgb as a SimpleColor. If rgb starts with # and has a length of 7, it is converted into a RGBTuple-backed SimpleColor. If rgb starts with a-z, rgb is interpreted as a color name and converted to a Symbol-backed SimpleColor.\n\nOtherwise, nothing is returned.\n\nExamples\n\njulia> tryparse(SimpleColor, \"blue\")\nSimpleColor(blue)\n\njulia> tryparse(SimpleColor, \"#9558b2\")\nSimpleColor(#9558b2)\n\njulia> tryparse(SimpleColor, \"#nocolor\")\n\n\n\n\n\n","page":"StyledStrings"},{"title":"Base.merge","location":"stdlib/StyledStrings.html#Base.merge-Tuple{StyledStrings.Face, StyledStrings.Face}","category":"method","text":"merge(initial::Face, others::Face...)\n\nMerge the properties of the initial face and others, with later faces taking priority.\n\n\n\n\n\n","page":"StyledStrings"},{"title":"LibGit2","location":"stdlib/LibGit2.html","category":"page","text":"EditURL = \"https://github.com/JuliaLang/julia/blob/master/stdlib/LibGit2/docs/src/index.md\"","page":"LibGit2"},{"title":"LibGit2","location":"stdlib/LibGit2.html#LibGit2","category":"section","text":"","page":"LibGit2"},{"title":"LibGit2","location":"stdlib/LibGit2.html","category":"page","text":"The LibGit2 module provides bindings to libgit2, a portable C library that implements core functionality for the Git version control system. These bindings are currently used to power Julia's package manager. It is expected that this module will eventually be moved into a separate package.","page":"LibGit2"},{"title":"Functionality","location":"stdlib/LibGit2.html#Functionality","category":"section","text":"","page":"LibGit2"},{"title":"LibGit2","location":"stdlib/LibGit2.html","category":"page","text":"Some of this documentation assumes some prior knowledge of the libgit2 API. For more information on some of the objects and methods referenced here, consult the upstream libgit2 API reference.","page":"LibGit2"},{"title":"LibGit2","location":"stdlib/LibGit2.html","category":"page","text":"LibGit2.Buffer\nLibGit2.CheckoutOptions\nLibGit2.CloneOptions\nLibGit2.DescribeOptions\nLibGit2.DescribeFormatOptions\nLibGit2.DiffDelta\nLibGit2.DiffFile\nLibGit2.DiffOptionsStruct\nLibGit2.FetchHead\nLibGit2.FetchOptions\nLibGit2.GitAnnotated\nLibGit2.GitBlame\nLibGit2.GitBlob\nLibGit2.GitCommit\nLibGit2.GitConfig\nLibGit2.GitHash\nLibGit2.GitObject\nLibGit2.GitRemote\nLibGit2.GitRemoteAnon\nLibGit2.GitRepo\nLibGit2.GitRepoExt\nLibGit2.GitRevWalker\nLibGit2.GitShortHash\nLibGit2.GitSignature\nLibGit2.GitStatus\nLibGit2.GitTag\nLibGit2.GitTree\nLibGit2.IndexEntry\nLibGit2.IndexTime\nLibGit2.BlameOptions\nLibGit2.MergeOptions\nLibGit2.ProxyOptions\nLibGit2.PushOptions\nLibGit2.RebaseOperation\nLibGit2.RebaseOptions\nLibGit2.RemoteCallbacks\nLibGit2.SignatureStruct\nLibGit2.StatusEntry\nLibGit2.StatusOptions\nLibGit2.StrArrayStruct\nLibGit2.TimeStruct\nLibGit2.addfile\nLibGit2.add!\nLibGit2.add_fetch!\nLibGit2.add_push!\nLibGit2.addblob!\nLibGit2.author\nLibGit2.authors\nLibGit2.branch\nLibGit2.branch!\nLibGit2.checkout!\nLibGit2.clone\nLibGit2.commit\nLibGit2.committer\nLibGit2.count\nLibGit2.counthunks\nLibGit2.create_branch\nLibGit2.credentials_callback\nLibGit2.credentials_cb\nLibGit2.default_signature\nLibGit2.delete_branch\nLibGit2.diff_files\nLibGit2.entryid\nLibGit2.entrytype\nLibGit2.fetch\nLibGit2.fetchheads\nLibGit2.fetch_refspecs\nLibGit2.fetchhead_foreach_cb\nLibGit2.merge_base\nLibGit2.merge!(::LibGit2.GitRepo; ::Any...)\nLibGit2.merge!(::LibGit2.GitRepo, ::Vector{LibGit2.GitAnnotated}; ::LibGit2.MergeOptions, ::LibGit2.CheckoutOptions)\nLibGit2.merge!(::LibGit2.GitRepo, ::Vector{LibGit2.GitAnnotated}, ::Bool; ::LibGit2.MergeOptions, ::LibGit2.CheckoutOptions)\nLibGit2.ffmerge!\nLibGit2.fullname\nLibGit2.features\nLibGit2.filename\nLibGit2.filemode\nLibGit2.gitdir\nLibGit2.git_url\nLibGit2.@githash_str\nLibGit2.head\nLibGit2.head!\nLibGit2.head_oid\nLibGit2.headname\nLibGit2.init\nLibGit2.is_ancestor_of\nLibGit2.isbinary\nLibGit2.iscommit\nLibGit2.isdiff\nLibGit2.isdirty\nLibGit2.isorphan\nLibGit2.isset\nLibGit2.iszero\nLibGit2.lookup_branch\nLibGit2.map\nLibGit2.mirror_callback\nLibGit2.mirror_cb\nLibGit2.message\nLibGit2.merge_analysis\nLibGit2.name\nLibGit2.need_update\nLibGit2.objtype\nLibGit2.path\nLibGit2.peel\nLibGit2.posixpath\nLibGit2.push\nLibGit2.push!(::LibGit2.GitRevWalker, ::LibGit2.GitHash)\nLibGit2.push_head!\nLibGit2.push_refspecs\nLibGit2.raw\nLibGit2.read_tree!\nLibGit2.rebase!\nLibGit2.ref_list\nLibGit2.reftype\nLibGit2.remotes\nLibGit2.remove!\nLibGit2.reset\nLibGit2.reset!\nLibGit2.restore\nLibGit2.revcount\nLibGit2.set_remote_url\nLibGit2.shortname\nLibGit2.snapshot\nLibGit2.split_cfg_entry\nLibGit2.status\nLibGit2.stage\nLibGit2.tag_create\nLibGit2.tag_delete\nLibGit2.tag_list\nLibGit2.target\nLibGit2.toggle\nLibGit2.transact\nLibGit2.treewalk\nLibGit2.upstream\nLibGit2.update!\nLibGit2.url\nLibGit2.version\nLibGit2.with\nLibGit2.with_warn\nLibGit2.workdir\nLibGit2.GitObject(::LibGit2.GitTreeEntry)\nLibGit2.UserPasswordCredential\nLibGit2.SSHCredential\nLibGit2.isfilled\nLibGit2.CachedCredentials\nLibGit2.CredentialPayload\nLibGit2.approve\nLibGit2.reject\nLibGit2.Consts.GIT_CONFIG","page":"LibGit2"},{"title":"LibGit2.Buffer","location":"stdlib/LibGit2.html#LibGit2.Buffer","category":"type","text":"LibGit2.Buffer\n\nA data buffer for exporting data from libgit2. Matches the git_buf struct.\n\nWhen fetching data from LibGit2, a typical usage would look like:\n\nbuf_ref = Ref(Buffer())\n@check ccall(..., (Ptr{Buffer},), buf_ref)\n# operation on buf_ref\nfree(buf_ref)\n\nIn particular, note that LibGit2.free should be called afterward on the Ref object.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.CheckoutOptions","location":"stdlib/LibGit2.html#LibGit2.CheckoutOptions","category":"type","text":"LibGit2.CheckoutOptions\n\nMatches the git_checkout_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncheckout_strategy: determine how to handle conflicts and whether to force the  checkout/recreate missing files.\ndisable_filters: if nonzero, do not apply filters like CLRF (to convert file newlines between UNIX and DOS).\ndir_mode: read/write/access mode for any directories involved in the checkout. Default is 0755.\nfile_mode: read/write/access mode for any files involved in the checkout.  Default is 0755 or 0644, depending on the blob.\nfile_open_flags: bitflags used to open any files during the checkout.\nnotify_flags: Flags for what sort of conflicts the user should be notified about.\nnotify_cb: An optional callback function to notify the user if a checkout conflict occurs.  If this function returns a non-zero value, the checkout will be cancelled.\nnotify_payload: Payload for the notify callback function.\nprogress_cb: An optional callback function to display checkout progress.\nprogress_payload: Payload for the progress callback.\npaths: If not empty, describes which paths to search during the checkout.  If empty, the checkout will occur over all files in the repository.\nbaseline: Expected content of the workdir, captured in a (pointer to a)  GitTree. Defaults to the state of the tree at HEAD.\nbaseline_index: Expected content of the workdir, captured in a (pointer to a)  GitIndex. Defaults to the state of the index at HEAD.\ntarget_directory: If not empty, checkout to this directory instead of the workdir.\nancestor_label: In case of conflicts, the name of the common ancestor side.\nour_label: In case of conflicts, the name of \"our\" side.\ntheir_label: In case of conflicts, the name of \"their\" side.\nperfdata_cb: An optional callback function to display performance data.\nperfdata_payload: Payload for the performance callback.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.CloneOptions","location":"stdlib/LibGit2.html#LibGit2.CloneOptions","category":"type","text":"LibGit2.CloneOptions\n\nMatches the git_clone_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncheckout_opts: The options for performing the checkout of the remote as part of the clone.\nfetch_opts: The options for performing the pre-checkout fetch of the remote as part of the clone.\nbare: If 0, clone the full remote repository. If non-zero, perform a bare clone, in which  there is no local copy of the source files in the repository and the gitdir and workdir  are the same.\nlocalclone: Flag whether to clone a local object database or do a fetch. The default is to let git decide.  It will not use the git-aware transport for a local clone, but will use it for URLs which begin with file://.\ncheckout_branch: The name of the branch to checkout. If an empty string, the default branch of the  remote will be checked out.\nrepository_cb: An optional callback which will be used to create the new repository into which  the clone is made.\nrepository_cb_payload: The payload for the repository callback.\nremote_cb: An optional callback used to create the GitRemote before making the clone from it.\nremote_cb_payload: The payload for the remote callback.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DescribeOptions","location":"stdlib/LibGit2.html#LibGit2.DescribeOptions","category":"type","text":"LibGit2.DescribeOptions\n\nMatches the git_describe_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nmax_candidates_tags: consider this many most recent tags in refs/tags to describe a commit.  Defaults to 10 (so that the 10 most recent tags would be examined to see if they describe a commit).\ndescribe_strategy: whether to consider all entries in refs/tags (equivalent to git-describe --tags)  or all entries in refs/ (equivalent to git-describe --all). The default is to only show annotated tags.  If Consts.DESCRIBE_TAGS is passed, all tags, annotated or not, will be considered.  If Consts.DESCRIBE_ALL is passed, any ref in refs/ will be considered.\npattern: only consider tags which match pattern. Supports glob expansion.\nonly_follow_first_parent: when finding the distance from a matching reference to the described  object, only consider the distance from the first parent.\nshow_commit_oid_as_fallback: if no matching reference can be found which describes a commit, show the  commit's GitHash instead of throwing an error (the default behavior).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DescribeFormatOptions","location":"stdlib/LibGit2.html#LibGit2.DescribeFormatOptions","category":"type","text":"LibGit2.DescribeFormatOptions\n\nMatches the git_describe_format_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nabbreviated_size: lower bound on the size of the abbreviated GitHash to use, defaulting to 7.\nalways_use_long_format: set to 1 to use the long format for strings even if a short format can be used.\ndirty_suffix: if set, this will be appended to the end of the description string if the workdir is dirty.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DiffDelta","location":"stdlib/LibGit2.html#LibGit2.DiffDelta","category":"type","text":"LibGit2.DiffDelta\n\nDescription of changes to one entry. Matches the git_diff_delta struct.\n\nThe fields represent:\n\nstatus: One of Consts.DELTA_STATUS, indicating whether the file has been added/modified/deleted.\nflags: Flags for the delta and the objects on each side. Determines whether to treat the file(s)  as binary/text, whether they exist on each side of the diff, and whether the object ids are known  to be correct.\nsimilarity: Used to indicate if a file has been renamed or copied.\nnfiles: The number of files in the delta (for instance, if the delta  was run on a submodule commit id, it may contain more than one file).\nold_file: A DiffFile containing information about the file(s) before the changes.\nnew_file: A DiffFile containing information about the file(s) after the changes.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DiffFile","location":"stdlib/LibGit2.html#LibGit2.DiffFile","category":"type","text":"LibGit2.DiffFile\n\nDescription of one side of a delta. Matches the git_diff_file struct.\n\nThe fields represent:\n\nid: the GitHash of the item in the diff. If the item is empty on this  side of the diff (for instance, if the diff is of the removal of a file), this will  be GitHash(0).\npath: a NULL terminated path to the item relative to the working directory of the repository.\nsize: the size of the item in bytes.\nflags: a combination of the git_diff_flag_t  flags. The ith bit of this integer sets the ith flag.\nmode: the stat mode for the item.\nid_abbrev: only present in LibGit2 versions newer than or equal to 0.25.0.  The length of the id field when converted using string. Usually equal to OID_HEXSZ (40).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.DiffOptionsStruct","location":"stdlib/LibGit2.html#LibGit2.DiffOptionsStruct","category":"type","text":"LibGit2.DiffOptionsStruct\n\nMatches the git_diff_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: flags controlling which files will appear in the diff. Defaults to DIFF_NORMAL.\nignore_submodules: whether to look at files in submodules or not. Defaults to SUBMODULE_IGNORE_UNSPECIFIED, which means the submodule's configuration will control  whether it appears in the diff or not.\npathspec: path to files to include in the diff. Default is to use all files in the repository.\nnotify_cb: optional callback which will notify the user of changes to the diff as file deltas are  added to it.\nprogress_cb: optional callback which will display diff progress. Only relevant on libgit2 versions  at least as new as 0.24.0.\npayload: the payload to pass to notify_cb and progress_cb.\ncontext_lines: the number of unchanged lines used to define the edges of a hunk.  This is also the number of lines which will be shown before/after a hunk to provide  context. Default is 3.\ninterhunk_lines: the maximum number of unchanged lines between two separate  hunks allowed before the hunks will be combined. Default is 0.\nid_abbrev: sets the length of the abbreviated GitHash to print.  Default is 7.\nmax_size: the maximum file size of a blob. Above this size, it will be treated  as a binary blob. The default is 512 MB.\nold_prefix: the virtual file directory in which to place old files on one side  of the diff. Default is \"a\".\nnew_prefix: the virtual file directory in which to place new files on one side  of the diff. Default is \"b\".\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.FetchHead","location":"stdlib/LibGit2.html#LibGit2.FetchHead","category":"type","text":"LibGit2.FetchHead\n\nContains the information about HEAD during a fetch, including the name and URL of the branch fetched from, the oid of the HEAD, and whether the fetched HEAD has been merged locally.\n\nThe fields represent:\n\nname: The name in the local reference database of the fetch head, for example,  \"refs/heads/master\".\nurl: The URL of the fetch head.\noid: The GitHash of the tip of the fetch head.\nismerge: Boolean flag indicating whether the changes at the  remote have been merged into the local copy yet or not. If true, the local  copy is up to date with the remote fetch head.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.FetchOptions","location":"stdlib/LibGit2.html#LibGit2.FetchOptions","category":"type","text":"LibGit2.FetchOptions\n\nMatches the git_fetch_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\ncallbacks: remote callbacks to use during the fetch.\nprune: whether to perform a prune after the fetch or not. The default is to  use the setting from the GitConfig.\nupdate_fetchhead: whether to update the FetchHead after the fetch.  The default is to perform the update, which is the normal git behavior.\ndownload_tags: whether to download tags present at the remote or not. The default  is to request the tags for objects which are being downloaded anyway from the server.\nproxy_opts: options for connecting to the remote through a proxy. See ProxyOptions.  Only present on libgit2 versions newer than or equal to 0.25.0.\ncustom_headers: any extra headers needed for the fetch. Only present on libgit2 versions  newer than or equal to 0.24.0.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitAnnotated","location":"stdlib/LibGit2.html#LibGit2.GitAnnotated","category":"type","text":"GitAnnotated(repo::GitRepo, commit_id::GitHash)\nGitAnnotated(repo::GitRepo, ref::GitReference)\nGitAnnotated(repo::GitRepo, fh::FetchHead)\nGitAnnotated(repo::GitRepo, committish::AbstractString)\n\nAn annotated git commit carries with it information about how it was looked up and why, so that rebase or merge operations have more information about the context of the commit. Conflict files contain information about the source/target branches in the merge which are conflicting, for instance. An annotated commit can refer to the tip of a remote branch, for instance when a FetchHead is passed, or to a branch head described using GitReference.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitBlame","location":"stdlib/LibGit2.html#LibGit2.GitBlame","category":"type","text":"GitBlame(repo::GitRepo, path::AbstractString; options::BlameOptions=BlameOptions())\n\nConstruct a GitBlame object for the file at path, using change information gleaned from the history of repo. The GitBlame object records who changed which chunks of the file when, and how. options controls how to separate the contents of the file and which commits to probe - see BlameOptions for more information.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitBlob","location":"stdlib/LibGit2.html#LibGit2.GitBlob","category":"type","text":"GitBlob(repo::GitRepo, hash::AbstractGitHash)\nGitBlob(repo::GitRepo, spec::AbstractString)\n\nReturn a GitBlob object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitCommit","location":"stdlib/LibGit2.html#LibGit2.GitCommit","category":"type","text":"GitCommit(repo::GitRepo, hash::AbstractGitHash)\nGitCommit(repo::GitRepo, spec::AbstractString)\n\nReturn a GitCommit object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitConfig","location":"stdlib/LibGit2.html#LibGit2.GitConfig","category":"type","text":"GitConfig(path::AbstractString, level::Consts.GIT_CONFIG=Consts.CONFIG_LEVEL_APP, force::Bool=false)\n\nCreate a new GitConfig by loading configuration information from the file at path. See addfile for more information about the level, repo and force options.\n\n\n\n\n\nGitConfig(repo::GitRepo)\n\nGet the stored configuration for the git repository repo. If repo does not have a specific configuration file set, the default git configuration will be used.\n\n\n\n\n\nGitConfig(level::Consts.GIT_CONFIG=Consts.CONFIG_LEVEL_DEFAULT)\n\nGet the default git configuration by loading the global and system configuration files into a prioritized configuration. This can be used to access default configuration options outside a specific git repository.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitHash","location":"stdlib/LibGit2.html#LibGit2.GitHash","category":"type","text":"GitHash\n\nA git object identifier, based on the sha-1 hash. It is a 20 byte string (40 hex digits) used to identify a GitObject in a repository.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitObject","location":"stdlib/LibGit2.html#LibGit2.GitObject","category":"type","text":"GitObject(repo::GitRepo, hash::AbstractGitHash)\nGitObject(repo::GitRepo, spec::AbstractString)\n\nReturn the specified object (GitCommit, GitBlob, GitTree or GitTag) from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRemote","location":"stdlib/LibGit2.html#LibGit2.GitRemote","category":"type","text":"GitRemote(repo::GitRepo, rmt_name::AbstractString, rmt_url::AbstractString) -> GitRemote\n\nLook up a remote git repository using its name and URL. Uses the default fetch refspec.\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nremote = LibGit2.GitRemote(repo, \"upstream\", repo_url)\n\n\n\n\n\nGitRemote(repo::GitRepo, rmt_name::AbstractString, rmt_url::AbstractString, fetch_spec::AbstractString) -> GitRemote\n\nLook up a remote git repository using the repository's name and URL, as well as specifications for how to fetch from the remote (e.g. which remote branch to fetch from).\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nrefspec = \"+refs/heads/mybranch:refs/remotes/origin/mybranch\"\nremote = LibGit2.GitRemote(repo, \"upstream\", repo_url, refspec)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRemoteAnon","location":"stdlib/LibGit2.html#LibGit2.GitRemoteAnon","category":"function","text":"GitRemoteAnon(repo::GitRepo, url::AbstractString) -> GitRemote\n\nLook up a remote git repository using only its URL, not its name.\n\nExamples\n\nrepo = LibGit2.init(repo_path)\nremote = LibGit2.GitRemoteAnon(repo, repo_url)\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRepo","location":"stdlib/LibGit2.html#LibGit2.GitRepo","category":"type","text":"LibGit2.GitRepo(path::AbstractString)\n\nOpen a git repository at path.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRepoExt","location":"stdlib/LibGit2.html#LibGit2.GitRepoExt","category":"function","text":"LibGit2.GitRepoExt(path::AbstractString, flags::Cuint = Cuint(Consts.REPOSITORY_OPEN_DEFAULT))\n\nOpen a git repository at path with extended controls (for instance, if the current user must be a member of a special access group to read path).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitRevWalker","location":"stdlib/LibGit2.html#LibGit2.GitRevWalker","category":"type","text":"GitRevWalker(repo::GitRepo)\n\nA GitRevWalker walks through the revisions (i.e. commits) of a git repository repo. It is a collection of the commits in the repository, and supports iteration and calls to LibGit2.map and LibGit2.count (for instance, LibGit2.count could be used to determine what percentage of commits in a repository were made by a certain author).\n\ncnt = LibGit2.with(LibGit2.GitRevWalker(repo)) do walker\n    LibGit2.count((oid,repo)->(oid == commit_oid1), walker, oid=commit_oid1, by=LibGit2.Consts.SORT_TIME)\nend\n\nHere, LibGit2.count finds the number of commits along the walk with a certain GitHash. Since the GitHash is unique to a commit, cnt will be 1.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitShortHash","location":"stdlib/LibGit2.html#LibGit2.GitShortHash","category":"type","text":"GitShortHash(hash::GitHash, len::Integer)\n\nA shortened git object identifier, which can be used to identify a git object when it is unique, consisting of the initial len hexadecimal digits of hash (the remaining digits are ignored).\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitSignature","location":"stdlib/LibGit2.html#LibGit2.GitSignature","category":"type","text":"LibGit2.GitSignature\n\nThis is a Julia wrapper around a pointer to a git_signature object.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitStatus","location":"stdlib/LibGit2.html#LibGit2.GitStatus","category":"type","text":"LibGit2.GitStatus(repo::GitRepo; status_opts=StatusOptions())\n\nCollect information about the status of each file in the git repository repo (e.g. is the file modified, staged, etc.). status_opts can be used to set various options, for instance whether or not to look at untracked files or whether to include submodules or not. See StatusOptions for more information.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitTag","location":"stdlib/LibGit2.html#LibGit2.GitTag","category":"type","text":"GitTag(repo::GitRepo, hash::AbstractGitHash)\nGitTag(repo::GitRepo, spec::AbstractString)\n\nReturn a GitTag object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.GitTree","location":"stdlib/LibGit2.html#LibGit2.GitTree","category":"type","text":"GitTree(repo::GitRepo, hash::AbstractGitHash)\nGitTree(repo::GitRepo, spec::AbstractString)\n\nReturn a GitTree object from repo specified by hash/spec.\n\nhash is a full (GitHash) or partial (GitShortHash) hash.\nspec is a textual specification: see the git docs for a full list.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.IndexEntry","location":"stdlib/LibGit2.html#LibGit2.IndexEntry","category":"type","text":"LibGit2.IndexEntry\n\nIn-memory representation of a file entry in the index. Matches the git_index_entry struct.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.IndexTime","location":"stdlib/LibGit2.html#LibGit2.IndexTime","category":"type","text":"LibGit2.IndexTime\n\nMatches the git_index_time struct.\n\n\n\n\n\n","page":"LibGit2"},{"title":"LibGit2.BlameOptions","location":"stdlib/LibGit2.html#LibGit2.BlameOptions","category":"type","text":"LibGit2.BlameOptions\n\nMatches the git_blame_options struct.\n\nThe fields represent:\n\nversion: version of the struct in use, in case this changes later. For now, always 1.\nflags: one of Consts.BLAME_NORMAL or Consts.BLAME_FIRST_PARENT (the other blame flags  are not yet implemented by libgit2).\nmin_match_characters: the minimum number of alphanumeric characters which much change in a co