@rem
@rem ----------------------------------------------------------------------------
@rem  OHPM startup script for Windows, version 1.0.0
@rem
@rem  Required ENV vars:
@rem  ------------------
@rem    NODE_HOME - location of a Node home dir
@rem    or
@rem    Add %NODE_HOME%/bin to the PATH environment variable
@rem ----------------------------------------------------------------------------
@rem
@echo off

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal enabledelayedexpansion

set DIRNAME=%~dp0
set "BATCH_NAME=%0"
set RAW_PARAMS=%*

set NEED_REPLACE_CHAR="0"
set REGISTRY_SEPARATOR=","
echo %RAW_PARAMS% | findstr %REGISTRY_SEPARATOR% > NUL && (
  @rem Replace the separator of ',' to '#'
  set RAW_PARAMS=!RAW_PARAMS:,=#!
  set NEED_REPLACE_CHAR="1"
)

@rem Ignore the first param if it`s equal the batch name
for %%i in (%RAW_PARAMS%) do (
    if %%i neq %BATCH_NAME% (
      set "itemStr=%%i"
      if !PARAMS!=="" (
        set "PARAMS=!itemStr!"
      ) else (
        set "PARAMS=!PARAMS! !itemStr!"
      )
    )
)

@rem if params is empty then show: ohpm -h
if "%PARAMS%" == "" (
  set PARAMS="-h"
)

if %NEED_REPLACE_CHAR% == "1" (
  @rem Replace the separator of '#' to ','
  set PARAMS=!PARAMS:#=,!
)

if "%DIRNAME%" == "" set DIRNAME=.

set PM_CLI_PATH=%DIRNAME%\pm-cli.js
set NODE_EXE=node.exe


@rem Find node.exe
if defined NODE_HOME (
  set NODE_HOME=%NODE_HOME:"=%
  set "PATH=%PATH%;%NODE_HOME%"
  set NODE_EXE_PATH=%NODE_HOME%/%NODE_EXE%
)

%NODE_EXE% --version >NUL 2>&1

@rem Real execution
if "%ERRORLEVEL%" == "0" (
  "%NODE_EXE%" "%PM_CLI_PATH%" %PARAMS%
) else if exist "%NODE_EXE_PATH%" (
  "%NODE_EXE_PATH%" "%PM_CLI_PATH%" %PARAMS%
) else (
  echo.
  echo [31mERROR: NODE_HOME is not set and 'node' command not found in your PATH.[0m
  echo.
  echo [31mPlease set the NODE_HOME variable in your environment to match the location of your NodeJs installation.[0m
)

if "%ERRORLEVEL%" == "0" (
  if "%OS%" == "Windows_NT" endlocal
) else (
  exit /b %ERRORLEVEL%
)
