/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ohos;

import com.huawei.ohos.BundleException;
import com.huawei.ohos.Log;
import com.huawei.ohos.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Compressor {
    private static final String JSON_SUFFIX = ".json";
    private static final String HAP_SUFFIX = ".hap";
    private static final String CONFIG_JSON = "config.json";
    private static final String CODE = "code";
    private static final String NAME = "name";
    private static final String NULL_DIR_NAME = "";
    private static final String RES_DIR_NAME = "res/";
    private static final String RESOURCES_DIR_NAME = "resources/";
    private static final String LIBS_DIR_NAME = "libs/";
    private static final String ASSETS_DIR_NAME = "assets/";
    private static final String SO_DIR_NAME = "maple/";
    private static final String SO_ARM64_DIR_NAME = "maple/arm64/";
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String DISTRO = "distro";
    private static final String MODULE_NAME = "module-name";
    private static final String MODULE_NAME_NEW = "moduleName";
    private static final String JSON_END = "}";
    private static final String SEMICOLON = "\"";
    private static final String APPLICATION = "deviceConfig";
    private static final String COMPRESS_NATIVE_LIBS = "compressNativeLibs";
    private static final String SHARED_LIBS_DIR_NAME = "shared_libs/";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String DEVICE_TYPE_FITNESSWATCH = "fitnessWatch";
    private static final String DEVICE_TYPE_FITNESSWATCH_NEW = "liteWearable";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final long FILE_TIME = 1546272000000L;
    private static final int BUFFER_SIZE = 10240;
    private static final Log LOG = new Log(Compressor.class.toString());
    private static String versionCode = "";
    private static String versionName = "";
    private ZipOutputStream zipOut = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean compressProcess(Utility utility) {
        boolean compressResult = true;
        File destFile = new File(utility.getOutPath());
        File outParentFile = destFile.getParentFile();
        if (outParentFile != null && !outParentFile.exists() && !outParentFile.mkdirs()) {
            LOG.error("Compressor::compressProcess create out file parent directory failed!");
            return false;
        }
        FileOutputStream fileOut = null;
        CheckedOutputStream checkedOut = null;
        try {
            fileOut = new FileOutputStream(destFile);
            checkedOut = new CheckedOutputStream(fileOut, new CRC32());
            this.zipOut = new ZipOutputStream(checkedOut);
            if ("hap".equals(utility.getMode())) {
                this.compressHapMode(utility);
            } else if ("har".equals(utility.getMode())) {
                this.compressHarMode(utility);
            } else {
                this.compressAppMode(utility);
            }
            this.closeZipOutputStream();
        }
        catch (FileNotFoundException exception) {
            compressResult = false;
            LOG.error("Compressor::compressProcess file not found exception" + exception.getMessage());
            this.closeZipOutputStream();
            Utility.closeStream(this.zipOut);
            Utility.closeStream(checkedOut);
            Utility.closeStream(fileOut);
        }
        catch (BundleException ignored) {
            compressResult = false;
            LOG.error("Compressor::compressProcess Bundle exception");
            this.closeZipOutputStream();
            {
                catch (Throwable throwable) {
                    this.closeZipOutputStream();
                    Utility.closeStream(this.zipOut);
                    Utility.closeStream(checkedOut);
                    Utility.closeStream(fileOut);
                    throw throwable;
                }
            }
            Utility.closeStream(this.zipOut);
            Utility.closeStream(checkedOut);
            Utility.closeStream(fileOut);
        }
        Utility.closeStream(this.zipOut);
        Utility.closeStream(checkedOut);
        Utility.closeStream(fileOut);
        if (!compressResult) {
            LOG.error("Compressor::compressProcess compress failed!");
            if (!destFile.delete()) {
                LOG.error("Compressor::compressProcess delete dest file failed");
            }
        }
        return compressResult;
    }

    private void compressHapMode(Utility utility) throws BundleException {
        this.pathToFile(utility, utility.getJsonPath(), NULL_DIR_NAME, false);
        this.pathToFile(utility, utility.getProfilePath(), NULL_DIR_NAME, false);
        if (!utility.getIndexPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            String assetsPath = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR;
            this.pathToFile(utility, utility.getIndexPath(), assetsPath, false);
        }
        if (!utility.getLibPath().isEmpty()) {
            this.pathToFile(utility, utility.getLibPath(), LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
        if (!utility.getResPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            String resPath = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + RESOURCES_DIR_NAME;
            if (DEVICE_TYPE_FITNESSWATCH.equals(utility.getDeviceType().replace(SEMICOLON, NULL_DIR_NAME).trim()) || DEVICE_TYPE_FITNESSWATCH_NEW.equals(utility.getDeviceType().replace(SEMICOLON, NULL_DIR_NAME).trim())) {
                resPath = RES_DIR_NAME;
            }
            this.pathToFile(utility, utility.getResPath(), resPath, false);
        }
        if (!utility.getResourcesPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            String resourcesPath = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + RESOURCES_DIR_NAME;
            this.pathToFile(utility, utility.getResourcesPath(), resourcesPath, false);
        }
        if (!utility.getAssetsPath().isEmpty()) {
            this.pathToFile(utility, utility.getAssetsPath(), ASSETS_DIR_NAME, false);
        }
        if (!utility.getBinPath().isEmpty()) {
            this.pathToFile(utility, utility.getBinPath(), NULL_DIR_NAME, false);
        }
        for (String soPathItem : utility.getFormattedSoPathList()) {
            this.pathToFile(utility, soPathItem, SO_ARM64_DIR_NAME, false);
        }
        if (utility.getFormattedSoPathList().size() == 0 && !utility.getSoDir().isEmpty()) {
            this.pathToFile(utility, utility.getSoDir(), SO_DIR_NAME, false);
        }
        for (String soPathItem : utility.getFormattedAbilitySoPathList()) {
            this.pathToFile(utility, soPathItem, NULL_DIR_NAME, false);
        }
        for (String dexPathItem : utility.getFormattedDexPathList()) {
            this.pathToFile(utility, dexPathItem, NULL_DIR_NAME, false);
        }
        for (String apkPathItem : utility.getFormattedApkPathList()) {
            this.pathToFile(utility, apkPathItem, NULL_DIR_NAME, false);
        }
        if (!utility.getSharedLibsPath().isEmpty()) {
            this.pathToFile(utility, utility.getSharedLibsPath(), SHARED_LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
    }

    private void compressHarMode(Utility utility) throws BundleException {
        this.pathToFile(utility, utility.getJsonPath(), NULL_DIR_NAME, false);
        if (!utility.getLibPath().isEmpty()) {
            this.pathToFile(utility, utility.getLibPath(), LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
        if (!utility.getResPath().isEmpty()) {
            this.pathToFile(utility, utility.getResPath(), RESOURCES_DIR_NAME, false);
        }
        if (!utility.getResourcesPath().isEmpty()) {
            this.pathToFile(utility, utility.getResourcesPath(), RESOURCES_DIR_NAME, false);
        }
        if (!utility.getAssetsPath().isEmpty()) {
            this.pathToFile(utility, utility.getAssetsPath(), ASSETS_DIR_NAME, false);
        }
        for (String jarPathItem : utility.getFormattedJarPathList()) {
            this.pathToFile(utility, jarPathItem, NULL_DIR_NAME, false);
        }
        for (String txtPathItem : utility.getFormattedTxtPathList()) {
            this.pathToFile(utility, txtPathItem, NULL_DIR_NAME, false);
        }
    }

    private void compressAppMode(Utility utility) throws BundleException {
        if (!utility.getCertificatePath().isEmpty()) {
            this.pathToFile(utility, utility.getCertificatePath(), NULL_DIR_NAME, false);
        }
        if (!utility.getSignaturePath().isEmpty()) {
            this.pathToFile(utility, utility.getSignaturePath(), NULL_DIR_NAME, false);
        }
        for (String hapPathItem : utility.getFormattedHapPathList()) {
            this.pathToFile(utility, hapPathItem, NULL_DIR_NAME, false);
        }
        File file = new File(utility.getPackInfoPath());
        this.compressFile(utility, file, NULL_DIR_NAME, false);
    }

    private void pathToFile(Utility utility, String path, String baseDir, boolean isCompression) throws BundleException {
        if (path.isEmpty()) {
            return;
        }
        File fileItem = new File(path);
        if (fileItem.isDirectory()) {
            File[] files = fileItem.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    this.compressDirectory(utility, file, baseDir, isCompression);
                    continue;
                }
                this.compressFile(utility, file, baseDir, isCompression);
            }
        } else {
            this.compressFile(utility, fileItem, baseDir, isCompression);
        }
    }

    private void compressDirectory(Utility utility, File dir, String baseDir, boolean isCompression) throws BundleException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.compressDirectory(utility, file, baseDir + dir.getName() + File.separator, isCompression);
                continue;
            }
            this.compressFile(utility, file, baseDir + dir.getName() + File.separator, isCompression);
        }
    }

    private void compressFile(Utility utility, File srcFile, String baseDir, boolean isCompression) throws BundleException {
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            String entryName = (baseDir + srcFile.getName()).replace(File.separator, LINUX_FILE_SEPARATOR);
            ZipEntry zipEntry = new ZipEntry(entryName);
            if (!this.checkVersionInHaps(utility, srcFile, entryName)) {
                LOG.error("Compressor::compressFile file checkVersionCodeInHaps failed");
                throw new BundleException("Compressor::compressFile There are some haps with different version code!");
            }
            if (srcFile.getName().toLowerCase(Locale.ENGLISH).endsWith(JSON_SUFFIX)) {
                zipEntry.setMethod(0);
                this.jsonSpecialProcess(utility, srcFile, zipEntry);
                return;
            }
            if (isCompression) {
                zipEntry.setMethod(8);
            } else {
                zipEntry.setMethod(0);
                zipEntry.setCompressedSize(srcFile.length());
                zipEntry.setSize(srcFile.length());
                CRC32 crc = this.getCrcFromFile(utility, srcFile);
                zipEntry.setCrc(crc.getValue());
            }
            FileTime fileTime = FileTime.fromMillis(1546272000000L);
            zipEntry.setLastAccessTime(fileTime);
            zipEntry.setLastModifiedTime(fileTime);
            this.zipOut.putNextEntry(zipEntry);
            byte[] data = new byte[10240];
            fileInputStream = new FileInputStream(srcFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int count = bufferedInputStream.read(data);
            while (count > 0) {
                this.zipOut.write(data, 0, count);
                count = bufferedInputStream.read(data);
            }
            Utility.closeStream(bufferedInputStream);
        }
        catch (FileNotFoundException ignored) {
            LOG.error("Compressor::compressFile file not found exception");
            throw new BundleException("CoompressFile failed");
        }
        catch (IOException exception) {
            LOG.error("Compressor::compressFile io exception: " + exception.getMessage());
            throw new BundleException("CoompressFile failed");
        }
        finally {
            Utility.closeStream(bufferedInputStream);
            Utility.closeStream(fileInputStream);
        }
        Utility.closeStream(fileInputStream);
    }

    private boolean checkVersionInHaps(Utility utility, File srcFile, String baseDir) throws BundleException {
        try {
            String fileStr = srcFile.getName();
            if (fileStr == null || fileStr.isEmpty()) {
                throw new BundleException("Compressor::checkVersionInHaps get file name failed");
            }
            if (!fileStr.toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX)) {
                return true;
            }
            for (String hapPath : utility.getFormattedHapPathList()) {
                if (hapPath == null || hapPath.isEmpty() || !hapPath.contains(baseDir)) continue;
                String configJson = this.obtainVersion(srcFile, hapPath);
                String str = this.obtainInnerVersionCode(configJson);
                if (str == null || str.isEmpty()) {
                    LOG.error("Compressor::checkVersionInHaps version code is null or empty");
                    return false;
                }
                if (!versionCode.isEmpty() && !versionCode.equals(str)) {
                    LOG.error("Compressor::checkVersionInHaps some haps with different version code");
                    return false;
                }
                String nameStr = this.obtainInnerVersionName(configJson);
                if (nameStr == null || nameStr.isEmpty()) {
                    LOG.error("Compressor::checkVersionInHaps version name is null or empty");
                    return false;
                }
                if (!versionName.isEmpty() && !versionName.equals(nameStr)) {
                    LOG.error("Compressor::checkVersionInHaps some haps with different version name");
                    return false;
                }
                versionCode = str;
                versionName = nameStr;
            }
        }
        catch (BundleException exception) {
            LOG.error("Compressor::checkVersionInHaps io exception: " + exception.getMessage());
            throw new BundleException("Compressor::checkVersionInHaps failed");
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CRC32 getCrcFromFile(Utility utility, File file) throws BundleException {
        FileInputStream fileInputStream = null;
        CRC32 crc = new CRC32();
        try {
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[10240];
            int count = fileInputStream.read(buffer);
            while (count > 0) {
                crc.update(buffer, 0, count);
                count = fileInputStream.read(buffer);
            }
        }
        catch (FileNotFoundException ignored) {
            try {
                LOG.error("Compressor::getCrcFromFile file not found exception");
                throw new BundleException("Get Crc from file failed");
                catch (IOException exception) {
                    LOG.error("Compressor::getCrcFromFile io exception: " + exception.getMessage());
                    throw new BundleException("Get Crc from file failed");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(fileInputStream);
        return crc;
    }

    private void jsonSpecialProcess(Utility utility, File srcFile, ZipEntry entry) throws BundleException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(srcFile);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            bufferedReader.mark((int)srcFile.length() + 1);
            this.parseModuleName(bufferedReader, utility);
            bufferedReader.reset();
            this.parseCompressNativeLibs(bufferedReader, utility);
            bufferedReader.reset();
            this.parseDeviceType(bufferedReader, utility);
            bufferedReader.reset();
            Pattern pattern = Pattern.compile(System.lineSeparator());
            String str = bufferedReader.readLine();
            StringBuilder builder = new StringBuilder();
            while (str != null) {
                Matcher matcher = pattern.matcher(str.trim());
                String dest = matcher.replaceAll(NULL_DIR_NAME);
                builder.append(dest);
                str = bufferedReader.readLine();
            }
            byte[] trimJson = builder.toString().getBytes(StandardCharsets.UTF_8);
            CRC32 crc = new CRC32();
            crc.update(trimJson);
            entry.setCrc(crc.getValue());
            entry.setSize(trimJson.length);
            entry.setCompressedSize(trimJson.length);
            FileTime fileTime = FileTime.fromMillis(1546272000000L);
            entry.setLastAccessTime(fileTime);
            entry.setLastModifiedTime(fileTime);
            this.zipOut.putNextEntry(entry);
            this.zipOut.write(trimJson);
        }
        catch (IOException exception) {
            try {
                LOG.error("Compressor::jsonSpecialProcess io exception: " + exception.getMessage());
                throw new BundleException("Json special process failed");
            }
            catch (Throwable throwable) {
                Utility.closeStream(bufferedReader);
                Utility.closeStream(inputStreamReader);
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(bufferedReader);
        Utility.closeStream(inputStreamReader);
        Utility.closeStream(fileInputStream);
    }

    private String obtainVersion(File srcFile, String baseDir) throws BundleException {
        ZipFile zipFile = null;
        FileInputStream zipInput = null;
        BufferedInputStream in = null;
        ZipInputStream zin = null;
        InputStream inputStream = null;
        InputStreamReader reader = null;
        BufferedReader br = null;
        ZipEntry entry = null;
        String versionStr = NULL_DIR_NAME;
        try {
            zipFile = new ZipFile(srcFile);
            zipInput = new FileInputStream(baseDir);
            in = new BufferedInputStream(zipInput);
            zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().toLowerCase().equals(CONFIG_JSON) || (br = new BufferedReader(reader = new InputStreamReader(inputStream = zipFile.getInputStream(entry)))) == null) continue;
                versionStr = br.readLine();
            }
        }
        catch (IOException exception) {
            try {
                LOG.error("Compressor::ObtainVersionCode io exception: " + exception.getMessage());
                throw new BundleException("Compressor::ObtainVersionCode failed");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                Utility.closeStream(zipInput);
                Utility.closeStream(in);
                Utility.closeStream(zin);
                Utility.closeStream(inputStream);
                Utility.closeStream(reader);
                Utility.closeStream(br);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
        Utility.closeStream(zipInput);
        Utility.closeStream(in);
        Utility.closeStream(zin);
        Utility.closeStream(inputStream);
        Utility.closeStream(reader);
        Utility.closeStream(br);
        return versionStr;
    }

    private String obtainInnerVersionCode(String configJson) throws BundleException {
        try {
            if (configJson != null) {
                int indexOfCode = configJson.indexOf(CODE);
                if (indexOfCode <= 0) {
                    LOG.error("Compressor::ObtainInnerVersionCode obtain index failed");
                    throw new BundleException("Compressor::ObtainInnerVersionCode obtain index failed");
                }
                int index = configJson.indexOf(COLON, indexOfCode);
                if (index <= 0) {
                    LOG.error("Compressor::ObtainInnerVersionCode obtain index failed");
                    throw new BundleException("Compressor::ObtainInnerVersionCode obtain index failed");
                }
                int lastIndex = configJson.indexOf(COMMA, index);
                if (lastIndex <= 0) {
                    LOG.error("Compressor::ObtainInnerVersionCode obtain index failed");
                    throw new BundleException("Compressor::ObtainInnerVersionCode obtain index failed");
                }
                String code = configJson.substring(index + 1, lastIndex);
                if (code == null || code.isEmpty()) {
                    LOG.error("Compressor::ObtainInnerVersionCode code is null or empty");
                    throw new BundleException("Compressor::ObtainInnerVersionCode failed due to null or empty code!");
                }
                return code.trim();
            }
        }
        catch (BundleException exception) {
            LOG.error("Compressor::ObtainInnerVersionCode io exception: " + exception.getMessage());
            throw new BundleException("Compressor::ObtainInnerVersionCode failed");
        }
        return NULL_DIR_NAME;
    }

    private String obtainInnerVersionName(String configJson) throws BundleException {
        try {
            if (configJson != null) {
                int indexOfCode = configJson.indexOf(NAME);
                if (indexOfCode <= 0) {
                    LOG.error("Compressor::obtainInnerVersionName obtain index failed");
                    throw new BundleException("Compressor::obtainInnerVersionName obtain index failed");
                }
                int index = configJson.indexOf(COLON, indexOfCode);
                if (index <= 0) {
                    LOG.error("Compressor::obtainInnerVersionName obtain index failed");
                    throw new BundleException("Compressor::obtainInnerVersionName obtain index failed");
                }
                int lastIndex = configJson.indexOf(JSON_END, index);
                if (lastIndex <= 0) {
                    LOG.error("Compressor::obtainInnerVersionName obtain index failed");
                    throw new BundleException("Compressor::obtainInnerVersionName obtain index failed");
                }
                String name = configJson.substring(index + 1, lastIndex);
                if (name == null || name.isEmpty()) {
                    LOG.error("Compressor::obtainInnerVersionName name is null or empty");
                    throw new BundleException("Compressor::obtainInnerVersionName failed due to null or empty name!");
                }
                return name.trim();
            }
        }
        catch (BundleException exception) {
            LOG.error("Compressor::obtainInnerVersionName io exception: " + exception.getMessage());
            throw new BundleException("Compressor::obtainInnerVersionName failed");
        }
        return NULL_DIR_NAME;
    }

    private void parseModuleName(BufferedReader bufferedReader, Utility utility) throws BundleException {
        String lineStr = null;
        boolean isDistroStart = false;
        try {
            while ((lineStr = bufferedReader.readLine()) != null) {
                if (!isDistroStart) {
                    if (!lineStr.contains(DISTRO)) continue;
                    isDistroStart = true;
                    continue;
                }
                if (!lineStr.contains(JSON_END)) {
                    if (!lineStr.contains(MODULE_NAME) && !lineStr.contains(MODULE_NAME_NEW)) continue;
                    this.getModuleNameFromString(lineStr, utility);
                }
                break;
            }
        }
        catch (IOException exception) {
            LOG.error("Compressor::parseModuleName io exception: " + exception.getMessage());
            throw new BundleException("Parse module name failed");
        }
    }

    private void getModuleNameFromString(String lineStr, Utility utility) throws BundleException {
        try {
            int endIndex = lineStr.lastIndexOf(SEMICOLON);
            if (endIndex <= 0) {
                LOG.error("Compressor::getModuleNameFromString field the json is not standard.");
                throw new BundleException("Parse module name failed, module-name is invalid");
            }
            int startIndex = lineStr.lastIndexOf(SEMICOLON, endIndex - 1) + 1;
            String moduleName = lineStr.substring(startIndex, endIndex);
            if (moduleName == null || moduleName.isEmpty()) {
                LOG.error("Compressor::getModuleNameFromString field module-name is empty");
                throw new BundleException("Parse module name failed, module-name is empty");
            }
            utility.setModuleName(moduleName);
        }
        catch (StringIndexOutOfBoundsException exception) {
            LOG.error("Compressor::parseModuleName field module-name is fault: " + exception.getMessage());
            throw new BundleException("Parse module name failed, module-name is invalid");
        }
    }

    private void parseCompressNativeLibs(BufferedReader bufferedReader, Utility utility) throws BundleException {
        String lineStr = null;
        try {
            while ((lineStr = bufferedReader.readLine()) != null) {
                if (!lineStr.contains(COMPRESS_NATIVE_LIBS) || !lineStr.contains("false")) continue;
                utility.setIsCompressNativeLibs(false);
                break;
            }
        }
        catch (IOException exception) {
            LOG.error("Compressor::parseCompressNativeLibs io exception: " + exception.getMessage());
            throw new BundleException("Parse compress native libs failed");
        }
    }

    private void closeZipOutputStream() {
        try {
            if (this.zipOut != null) {
                this.zipOut.flush();
            }
        }
        catch (IOException exception) {
            LOG.error("Compressor::closeZipOutputStream flush exception " + exception.getMessage());
        }
        try {
            if (this.zipOut != null) {
                this.zipOut.closeEntry();
            }
        }
        catch (IOException exception) {
            LOG.error("Compressor::closeZipOutputStream close entry io exception " + exception.getMessage());
        }
        try {
            if (this.zipOut != null) {
                this.zipOut.finish();
            }
        }
        catch (IOException exception) {
            LOG.error("Compressor::closeZipOutputStream finish exception " + exception.getMessage());
        }
    }

    private void parseDeviceType(BufferedReader bufferedReader, Utility utility) throws BundleException {
        String lineStr = null;
        boolean isDeviceTypeStart = false;
        try {
            while ((lineStr = bufferedReader.readLine()) != null) {
                if (!isDeviceTypeStart) {
                    if (!lineStr.contains(DEVICE_TYPE)) continue;
                    isDeviceTypeStart = true;
                    continue;
                }
                if (!lineStr.contains(JSON_END)) {
                    utility.setDeviceType(lineStr);
                }
                break;
            }
        }
        catch (IOException exception) {
            LOG.error("Compressor::parseDeviceType io exception: " + exception.getMessage());
            throw new BundleException("Parse device type failed");
        }
    }
}

