/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ohos;

import com.huawei.ohos.Log;
import com.huawei.ohos.Utility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CompressVerify {
    private static final String COMMA_SPLIT = ",";
    private static final String JSON_PROFILE = "config.json";
    private static final String PROFILE_NAME = "CAPABILITY.profile";
    private static final String INDEX_PROFILE = "resources.index";
    private static final String PACK_INFO = "pack.info";
    private static final String HAP_SUFFIX = ".hap";
    private static final String HAR_SUFFIX = ".har";
    private static final String APP_SUFFIX = ".app";
    private static final String APK_SUFFIX = ".apk";
    private static final String DEX_SUFFIX = ".dex";
    private static final String SO_SUFFIX = ".so";
    private static final String JAR_SUFFIX = ".jar";
    private static final String TXT_SUFFIX = ".txt";
    private static final Log LOG = new Log(CompressVerify.class.toString());
    private static final boolean TYPE_FILE = true;
    private static final boolean TYPE_DIR = false;

    public static boolean commandVerify(Utility utility) {
        if (utility == null) {
            LOG.error("CompressVerify::commandVerify utility is null!");
            return false;
        }
        if (!(utility.getForceRewrite().isEmpty() || "true".equals(utility.getForceRewrite()) || "false".equals(utility.getForceRewrite()))) {
            LOG.error("CompressVerify::commandVerify forceRewrite is invalid!");
            return false;
        }
        if ("hap".equals(utility.getMode())) {
            File file;
            if (!(utility.getJsonPath().isEmpty() || (file = new File(utility.getJsonPath())).isFile() && file.getName().equals(JSON_PROFILE))) {
                LOG.error("CompressVerify::isArgsValidInHapMode json-path must be config.json file!");
                return false;
            }
            if (!utility.getApkPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getApkPath(), utility.getFormattedApkPathList(), APK_SUFFIX)) {
                LOG.error("CompressVerify::isArgsValidInHapMode shell-apk-path is invalid!");
                return false;
            }
            if (!(utility.getProfilePath().isEmpty() || (file = new File(utility.getProfilePath())).isFile() && file.getName().equals(PROFILE_NAME))) {
                LOG.error("CompressVerify::isArgsValidInHapMode profile-path must be CAPABILITY.profile file!");
                return false;
            }
            if (!utility.getDexPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getDexPath(), utility.getFormattedDexPathList(), DEX_SUFFIX)) {
                LOG.error("CompressVerify::isArgsValidInHapMode dex-path is invalid!");
                return false;
            }
            return CompressVerify.isVerifyValidInHapMode(utility);
        }
        if ("har".equals(utility.getMode())) {
            return CompressVerify.isVerifyValidInHarMode(utility);
        }
        if ("app".equals(utility.getMode())) {
            return CompressVerify.isVerifyValidInAppMode(utility);
        }
        LOG.error("CompressVerify::commandVerify mode is invalid!");
        return false;
    }

    private static boolean isVerifyValidInHapMode(Utility utility) {
        File file = new File(utility.getIndexPath());
        if (!utility.getIndexPath().isEmpty() && !file.isFile() && file.getName().equals(INDEX_PROFILE)) {
            LOG.error("CompressVerify::isArgsValidInHapMode index-path must be resources.index file!");
            return false;
        }
        if (!utility.getSoPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getSoPath(), utility.getFormattedSoPathList(), SO_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode maple-so-path is invalid!");
            return false;
        }
        if (!utility.getAbilitySoPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getAbilitySoPath(), utility.getFormattedAbilitySoPathList(), SO_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHapMode ability-so-path is invalid!");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getSoDir())) {
            LOG.error("CompressVerify::isArgsValidInHapMode maple-so-dir is invalid!");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getLibPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode lib-path is invalid!");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getResPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode res-path is invalid!");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getResourcesPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode resources-path is invalid!");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getAssetsPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode assets-path is invalid!");
            return false;
        }
        if (CompressVerify.isHapPathValid(utility.getSharedLibsPath())) {
            LOG.error("CompressVerify::isArgsValidInHapMode shared-libs-path is invalid!");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, HAP_SUFFIX);
    }

    private static boolean isHapPathValid(String path) {
        return !path.isEmpty() && !CompressVerify.isPathValid(path, false, null);
    }

    private static boolean isVerifyValidInHarMode(Utility utility) {
        if (utility.getJsonPath().isEmpty() || !CompressVerify.isPathValid(utility.getJsonPath(), true, JSON_PROFILE)) {
            LOG.error("CompressVerify::isArgsValidInHarMode json-path must be config.json file!");
            return false;
        }
        if (!utility.getJarPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getJarPath(), utility.getFormattedJarPathList(), JAR_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHarMode jar-path is invalid!");
            return false;
        }
        if (!utility.getTxtPath().isEmpty() && !CompressVerify.compatibleProcess(utility, utility.getTxtPath(), utility.getFormattedTxtPathList(), TXT_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInHarMode txt-path is invalid!");
            return false;
        }
        if (!utility.getLibPath().isEmpty() && !CompressVerify.isPathValid(utility.getLibPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode lib-path is invalid!");
            return false;
        }
        if (!utility.getResPath().isEmpty() && !CompressVerify.isPathValid(utility.getResPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode res-path is invalid!");
            return false;
        }
        if (utility.getResourcesPath().isEmpty() || !CompressVerify.isPathValid(utility.getResourcesPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode resources-path is invalid!");
            return false;
        }
        if (!utility.getAssetsPath().isEmpty() && !CompressVerify.isPathValid(utility.getAssetsPath(), false, null)) {
            LOG.error("CompressVerify::isArgsValidInHarMode assets-path is invalid!");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, HAR_SUFFIX);
    }

    private static boolean isVerifyValidInAppMode(Utility utility) {
        if (utility.getHapPath().isEmpty()) {
            LOG.error("CompressVerify::isArgsValidInAppMode hap-path is empty!");
            return false;
        }
        if (!CompressVerify.compatibleProcess(utility, utility.getHapPath(), utility.getFormattedHapPathList(), HAP_SUFFIX)) {
            LOG.error("CompressVerify::isArgsValidInAppMode hap-path is invalid!");
            return false;
        }
        if (utility.getPackInfoPath().isEmpty()) {
            LOG.error("CompressVerify::isArgsValidInAppMode pack-info-path is empty!");
            return false;
        }
        File file = new File(utility.getPackInfoPath());
        if (!file.isFile() || !file.getName().equals(PACK_INFO)) {
            LOG.error("CompressVerify::isArgsValidInAppMode pack-info-path is invalid!");
            return false;
        }
        if (!utility.getSignaturePath().isEmpty() && !new File(utility.getSignaturePath()).isFile()) {
            LOG.error("CompressVerify::isArgsValidInAppMode signature-path is invalid!");
            return false;
        }
        if (!utility.getCertificatePath().isEmpty() && !new File(utility.getCertificatePath()).isFile()) {
            LOG.error("CompressVerify::isArgsValidInAppMode certificate-path is invalid!");
            return false;
        }
        return CompressVerify.isOutPathValid(utility, APP_SUFFIX);
    }

    private static boolean compatibleProcess(Utility utility, String inputPath, List<String> fileList, String suffix) {
        if (CompressVerify.isPathValid(inputPath, false, null)) {
            File inputFile = new File(inputPath);
            File[] files = inputFile.listFiles();
            if (files == null) {
                return true;
            }
            for (File fileItem : files) {
                if (!fileItem.getName().toLowerCase(Locale.ENGLISH).endsWith(suffix)) continue;
                fileList.add(fileItem.toString());
            }
            return true;
        }
        String formattedPathItem = "";
        List<String> pathList = CompressVerify.removeDuplicatePath(inputPath);
        for (String pathItem : pathList) {
            formattedPathItem = utility.getFormattedPath(pathItem);
            if (!CompressVerify.isPathValid(formattedPathItem, true, suffix)) {
                return false;
            }
            fileList.add(formattedPathItem);
        }
        return true;
    }

    private static boolean isOutPathValid(Utility utility, String suffix) {
        File outFile = new File(utility.getOutPath());
        if ("false".equals(utility.getForceRewrite()) && outFile.exists()) {
            LOG.error("CompressVerify::isOutPathValid out file already existed!");
            return false;
        }
        if (HAP_SUFFIX.equals(suffix)) {
            if (!outFile.getName().toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .hap!");
                return false;
            }
            return true;
        }
        if (HAR_SUFFIX.equals(suffix)) {
            if (!outFile.getName().toLowerCase(Locale.ENGLISH).endsWith(HAR_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .har!");
                return false;
            }
            return true;
        }
        if (APP_SUFFIX.equals(suffix)) {
            if (!outFile.getName().toLowerCase(Locale.ENGLISH).endsWith(APP_SUFFIX)) {
                LOG.error("CompressVerify::isOutPathValid out-path must end with .app!");
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isPathValid(String path, boolean isFile, String flag) {
        File file = new File(path);
        if (isFile && file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(flag)) {
            return true;
        }
        return !isFile && file.isDirectory();
    }

    private static List<String> removeDuplicatePath(String path) {
        String[] array = path.split(COMMA_SPLIT);
        ArrayList<String> list = new ArrayList<String>();
        for (String item : array) {
            if (list.contains(item)) continue;
            list.add(item);
        }
        return list;
    }
}

