/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ohos;

import com.huawei.ohos.CommandParser;
import com.huawei.ohos.CompressVerify;
import com.huawei.ohos.Compressor;
import com.huawei.ohos.Log;
import com.huawei.ohos.ShowHelp;
import com.huawei.ohos.Utility;

public class CompressEntrance {
    private static final int EXIT_STATUS_NORMAL = 0;
    private static final int EXIT_STATUS_EXCEPTION = 1;
    private static final Log LOG = new Log(CompressEntrance.class.toString());

    public static boolean pack(String hapPath, String packInfoPath, String outPath) {
        if (hapPath == null || hapPath.isEmpty()) {
            LOG.error("CompressEntrance::pack hapPath is invalid!");
            return false;
        }
        if (packInfoPath == null || packInfoPath.isEmpty()) {
            LOG.error("CompressEntrance::pack packInfoPath is invalid!");
            return false;
        }
        if (outPath == null || outPath.isEmpty()) {
            LOG.error("CompressEntrance::pack outPath is invalid!");
            return false;
        }
        Utility utility = new Utility();
        utility.setMode("app");
        utility.setHapPath(hapPath);
        utility.setPackInfoPath(packInfoPath);
        utility.setOutPath(outPath);
        utility.setForceRewrite("true");
        if (!CompressVerify.commandVerify(utility)) {
            LOG.error("CompressEntrance::startCompress verity failed");
            return false;
        }
        Compressor compressor = new Compressor();
        if (!compressor.compressProcess(utility)) {
            LOG.error("CompressEntrance::startCompress compress failed");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Compressor compressor;
        Utility utility = new Utility();
        if (!CommandParser.commandParser(utility, args)) {
            LOG.error("CompressEntrance::main exit, parser failed");
            ShowHelp.compressHelp();
            System.exit(1);
        }
        if (!CompressVerify.commandVerify(utility)) {
            LOG.error("CompressEntrance::main exit, verity failed");
            ShowHelp.compressHelp();
            System.exit(1);
        }
        if (!(compressor = new Compressor()).compressProcess(utility)) {
            LOG.error("CompressEntrance::main exit, compress failed");
            ShowHelp.compressHelp();
            System.exit(1);
        }
        System.exit(0);
    }
}

