/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ohos;

import com.huawei.ohos.Log;
import com.huawei.ohos.Utility;

public class CommandParser {
    public static final String PARSE_MODE_HAPLIST = "hap-list";
    public static final String PARSE_MODE_HAPINFO = "hap-info";
    private static final String CMD_MODE = "--mode";
    private static final String CMD_JSON_PATH = "--json-path";
    private static final String CMD_PROFILE_PATH = "--profile-path";
    private static final String CMD_INDEX_PATH = "--index-path";
    private static final String CMD_SO_PATH = "--maple-so-path";
    private static final String CMD_SO_DIR = "--maple-so-dir";
    private static final String CMD_ABILITY_SO_PATH = "--ability-so-path";
    private static final String CMD_DEX_PATH = "--dex-path";
    private static final String CMD_LIB_PATH = "--lib-path";
    private static final String CMD_RES_PATH = "--res-path";
    private static final String CMD_RESOURCES_PATH = "--resources-path";
    private static final String CMD_ASSETS_PATH = "--assets-path";
    private static final String CMD_APK_PATH = "--shell-apk-path";
    private static final String CMD_HAP_PATH = "--hap-path";
    private static final String CMD_APP_PATH = "--app-path";
    private static final String CMD_SIGNATURE_PATH = "--signature-path";
    private static final String CMD_CERTIFICATE_PATH = "--certificate-path";
    private static final String CMD_FORCE = "--force";
    private static final String CMD_OUT_PATH = "--out-path";
    private static final String CMD_PACK_INFO_PATH = "--pack-info-path";
    private static final String CMD_BIN_PATH = "--bin-path";
    private static final String CMD_JAR_PATH = "--jar-path";
    private static final String CMD_TXT_PATH = "--txt-path";
    private static final String CMD_HAR_PATH = "--har-path";
    private static final String CMD_PARSE_MODE = "--p";
    private static final String CMD_UNPACKAPK = "--unpackapk";
    private static final String CMD_SHAREDLIBS_PATH = "--shared-libs-path";
    private static final Log LOG = new Log(CommandParser.class.toString());

    public static boolean commandParser(Utility utility, String[] args) {
        if (args == null) {
            LOG.error("CommandParser::commandParser args is null!");
            return false;
        }
        CommandParser.parser(utility, args);
        return true;
    }

    private static void parser(Utility utility, String[] args) {
        block22: for (int i = 0; i < args.length - 1; ++i) {
            if (CommandParser.parseAppCmd(utility, args[i], args[i + 1]) || CommandParser.parseHapCmd(utility, args[i], args[i + 1])) {
                ++i;
                continue;
            }
            switch (args[i]) {
                case "--mode": {
                    utility.setMode(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "--force": {
                    utility.setForceRewrite(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "--out-path": {
                    utility.setOutPath(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "--bin-path": {
                    utility.setBinPath(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "--jar-path": {
                    utility.setJarPath(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "--txt-path": {
                    utility.setTxtPath(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "--har-path": {
                    utility.setHarPath(args[i + 1]);
                    ++i;
                    continue block22;
                }
                case "--p": {
                    utility.setParseMode(args[i + 1]);
                    if (PARSE_MODE_HAPLIST.equals(utility.getParseMode())) {
                        utility.setDeviceType(args[i + 2]);
                    } else if (PARSE_MODE_HAPINFO.equals(utility.getParseMode())) {
                        utility.setHapName(args[i + 2]);
                    }
                    i += 2;
                    continue block22;
                }
                case "--unpackapk": {
                    utility.setUnpackApk(args[i + 1]);
                    ++i;
                    continue block22;
                }
            }
        }
    }

    private static boolean parseAppCmd(Utility utility, String cmd, String value) {
        switch (cmd) {
            case "--hap-path": {
                utility.setHapPath(value);
                return true;
            }
            case "--app-path": {
                utility.setAppPath(value);
                return true;
            }
            case "--certificate-path": {
                utility.setCertificatePath(value);
                return true;
            }
            case "--signature-path": {
                utility.setSignaturePath(value);
                return true;
            }
            case "--pack-info-path": {
                utility.setPackInfoPath(value);
                return true;
            }
        }
        return false;
    }

    private static boolean parseHapCmd(Utility utility, String cmd, String value) {
        switch (cmd) {
            case "--json-path": {
                utility.setJsonPath(value);
                return true;
            }
            case "--profile-path": {
                utility.setProfilePath(value);
                return true;
            }
            case "--index-path": {
                utility.setIndexPath(value);
                return true;
            }
            case "--maple-so-path": {
                utility.setSoPath(value);
                return true;
            }
            case "--ability-so-path": {
                utility.setAbilitySoPath(value);
                return true;
            }
            case "--maple-so-dir": {
                utility.setSoDir(value);
                return true;
            }
            case "--dex-path": {
                utility.setDexPath(value);
                return true;
            }
            case "--lib-path": {
                utility.setLibPath(value);
                return true;
            }
            case "--assets-path": {
                utility.setAssetsPath(value);
                return true;
            }
            case "--res-path": {
                utility.setResPath(value);
                return true;
            }
            case "--resources-path": {
                utility.setResourcesPath(value);
                return true;
            }
            case "--shared-libs-path": {
                utility.setSharedLibsPath(value);
                return true;
            }
            case "--shell-apk-path": {
                utility.setApkPath(value);
                return true;
            }
        }
        return false;
    }
}

