/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.verify;

import com.google.gson.Gson;
import com.huawei.signclient.hap.entity.Pair;
import com.huawei.signclient.hap.entity.SigningBlock;
import com.huawei.signclient.hap.exception.SignatureNotFoundException;
import com.huawei.signclient.hap.utils.HapUtils;
import com.huawei.signclient.hap.utils.ParamProcessUtil;
import com.huawei.signclient.hap.utils.ZipUtils;
import com.huawei.signclient.hap.verify.HapVerifyV2;
import com.huawei.signclient.hap.verify.VerifyResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;

public class VerifyHap {
    private static final Logger LOGGER = LogManager.getLogger(VerifyHap.class);
    private static final int ZIP_HEAD_OF_SIGNING_BLOCK_LENGTH = 32;
    private static final int ZIP_HEAD_OF_SIGNING_BLOCK_COUNT_OFFSET_REVERSE = 28;
    private static final int ZIP_HEAD_OF_SUBSIGNING_BLOCK_LENGTH = 12;

    public boolean checkParams(String[] params) {
        HashMap<String, String> verifyParams = new HashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            if (!params[i].startsWith("-")) {
                LOGGER.error("Invalid parameter format: " + params[i]);
                return false;
            }
            String paramName = params[i].substring(1);
            String paramValue = params[i + 1];
            verifyParams.put(paramName, paramValue);
        }
        return this.checkOutputFiles(verifyParams);
    }

    private boolean checkOutputFiles(Map<String, String> verifyParams) {
        if (!verifyParams.containsKey("outcertchain")) {
            LOGGER.error("Missing parameter: {}", (Object)"outcertchain");
            return false;
        }
        if (!verifyParams.containsKey("outprofile")) {
            LOGGER.error("Missing parameter: {}", (Object)"outprofile");
            return false;
        }
        if (!verifyParams.containsKey("outproof")) {
            LOGGER.warn("Missing parameter: {}", (Object)"outproof");
        }
        return true;
    }

    public boolean verify(String[] params) {
        if (!this.checkParams(params)) {
            LOGGER.error("Check params failed!");
            return false;
        }
        String filePath = ParamProcessUtil.getParamFromArgs(params, "inputFile");
        String outputCertPath = ParamProcessUtil.getParamFromArgs(params, "outcertchain");
        String outputProfileFile = ParamProcessUtil.getParamFromArgs(params, "outprofile");
        String outputProofFile = ParamProcessUtil.getParamFromArgs(params, "outproof");
        if (StringUtils.isEmpty(filePath)) {
            LOGGER.error("Not found verify file path!");
            return false;
        }
        File signedFile = new File(filePath);
        if (!this.checkSignFile(signedFile)) {
            LOGGER.error("Check input signature hap false!");
            return false;
        }
        VerifyResult verifyResult = this.verifyHap(signedFile, outputCertPath, outputProfileFile, outputProofFile);
        if (!verifyResult.getResult()) {
            LOGGER.error("verify: {}", (Object)verifyResult.getMessage());
            return false;
        }
        LOGGER.info("verify: {}", (Object)verifyResult.getMessage());
        return true;
    }

    private boolean checkSignFile(File signedFile) {
        try {
            if (!signedFile.canRead()) {
                LOGGER.error("{} does not exist or can not read!", (Object)signedFile.getCanonicalPath());
                return false;
            }
            if (!signedFile.isFile()) {
                LOGGER.error("{} is not a file!", (Object)signedFile.getCanonicalPath());
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error("getCanonicalPath failed!", (Throwable)e);
            return false;
        }
        return true;
    }

    public VerifyResult verifyHap(String hapFilePath, String outCertPath, String outProvisionFile) {
        File signedFile = new File(hapFilePath);
        if (!this.checkSignFile(signedFile)) {
            String errorMsg = "Check input signature hap false!";
            LOGGER.error(errorMsg);
            return new VerifyResult(false, 10002, errorMsg);
        }
        return this.verifyHap(signedFile, outCertPath, outProvisionFile, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VerifyResult verifyHap(File signedFile, String outCertPath, String outProvisionFile, String outputProofFile) {
        VerifyResult result = new VerifyResult(false, 10000, "");
        try (RandomAccessFile hapFile = new RandomAccessFile(signedFile, "r");){
            Pair<Long, ByteBuffer> eocdAndOffsetInFile = ZipUtils.findEocdInHap(hapFile);
            if (eocdAndOffsetInFile == null) {
                String errorMsg = "Not an HAP file: ZIP End of Central Directory record not found!";
                LOGGER.error(errorMsg);
                VerifyResult verifyResult = new VerifyResult(false, 10003, errorMsg);
                return verifyResult;
            }
            long eocdOffset = eocdAndOffsetInFile.getFirst();
            ByteBuffer eocdBlock = eocdAndOffsetInFile.getSecond();
            if (ZipUtils.checkZip64EoCDLocatorIsPresent(hapFile, eocdOffset)) {
                String errorMsg = "Not an HAP file: ZIP End of Central Directory record not found!";
                LOGGER.error(errorMsg);
                VerifyResult verifyResult = new VerifyResult(false, 10003, errorMsg);
                return verifyResult;
            }
            long centralDirOffset = this.getCentralDirOffset(eocdBlock, eocdOffset);
            Pair<Long, ByteBuffer> hapSigningBlockAndOffsetInFile = this.findHapSigningBlock(hapFile, centralDirOffset);
            long signingBlockOffset = hapSigningBlockAndOffsetInFile.getFirst();
            ByteBuffer signingBlock = hapSigningBlockAndOffsetInFile.getSecond();
            Pair<ByteBuffer, List<SigningBlock>> blockPair = this.getHapSignatureSchemeBlockAndOptionalBlocks(signingBlock);
            ByteBuffer signatureSchemeBlock = blockPair.getFirst();
            List<SigningBlock> optionalBlocks = blockPair.getSecond();
            Collections.reverse(optionalBlocks);
            ByteBuffer centralDirectoryBlock = ZipUtils.getCentralDirectoryRecord(hapFile, centralDirOffset, eocdOffset);
            ByteBuffer beforeHapSigningBlock = ZipUtils.getContentOfZip(hapFile, signingBlockOffset);
            ZipUtils.setCentralDirectoryOffset(eocdBlock, beforeHapSigningBlock.remaining());
            HapVerifyV2 verifyEngine = new HapVerifyV2(beforeHapSigningBlock, signatureSchemeBlock, centralDirectoryBlock, eocdBlock, optionalBlocks);
            this.verifyHap(result, verifyEngine, outCertPath, outProvisionFile, outputProofFile);
        }
        catch (FileNotFoundException e) {
            return new VerifyResult(false, 10004, "file not found!");
        }
        catch (IOException e) {
            return new VerifyResult(false, 10002, e.getMessage());
        }
        catch (CertificateEncodingException e) {
            return new VerifyResult(false, 10005, e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            return new VerifyResult(false, 10006, e.getMessage());
        }
        catch (SignatureException e) {
            return new VerifyResult(false, 10009, e.getMessage());
        }
        catch (DigestException e) {
            return new VerifyResult(false, 10007, e.getMessage());
        }
        catch (SignatureNotFoundException e) {
            return new VerifyResult(false, 10008, e.getMessage());
        }
        LOGGER.info(new Gson().toJson(result));
        return result;
    }

    private void verifyHap(VerifyResult result, HapVerifyV2 verifyEngine, String outCertPath, String outProvisionFile, String outputProofFile) throws CertificateEncodingException, DigestException, NoSuchAlgorithmException, SignatureException {
        boolean verified = verifyEngine.verify(outCertPath, outProvisionFile, outputProofFile);
        if (verified) {
            result.setCode(10000);
            result.setMessage("Verify hap success!");
        } else {
            result.setCode(10001);
            result.setMessage("Verify hap failed! message is unknown!");
        }
        result.setResult(verified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<ByteBuffer, List<SigningBlock>> getHapSignatureSchemeBlockAndOptionalBlocks(ByteBuffer hapSigningBlock) throws SignatureNotFoundException {
        try {
            ByteBuffer header = HapUtils.reverseSliceBuffer(hapSigningBlock, hapSigningBlock.capacity() - 32, hapSigningBlock.capacity());
            ByteBuffer value = HapUtils.reverseSliceBuffer(hapSigningBlock, 0, hapSigningBlock.capacity() - 32);
            byte[] signatureValueBytes = new byte[value.capacity()];
            value.get(signatureValueBytes, 0, signatureValueBytes.length);
            signatureValueBytes = Arrays.reverse(signatureValueBytes);
            header.position(28);
            int blockCount = header.getInt();
            int current = value.capacity() - 12 * blockCount;
            value.position(current);
            int blockType = -1;
            int blockLength = -1;
            int blockOffset = -1;
            ByteBuffer hapSigningPkcs7Block = null;
            ArrayList<SigningBlock> optionalBlocks = new ArrayList<SigningBlock>();
            for (int i = 0; i < blockCount; ++i) {
                blockOffset = value.getInt();
                blockLength = value.getInt();
                blockType = value.getInt();
                if (blockOffset + blockLength > signatureValueBytes.length) {
                    throw new SignatureNotFoundException("block end pos: " + (blockOffset + blockLength) + " is larger than block len: " + signatureValueBytes.length);
                }
                if (HapUtils.HAP_SIGNATURE_OPTIONAL_BLOCK_IDS.contains(blockType)) {
                    byte[] blockValue = Arrays.copyOfRange(signatureValueBytes, blockOffset, blockOffset + blockLength);
                    optionalBlocks.add(new SigningBlock(blockType, blockValue));
                }
                if (blockType != 0x20000000) continue;
                byte[] result = Arrays.copyOfRange(signatureValueBytes, blockOffset, blockOffset + blockLength);
                hapSigningPkcs7Block = ByteBuffer.wrap(result);
            }
            Pair pair = Pair.create(hapSigningPkcs7Block, optionalBlocks);
            return pair;
        }
        finally {
            if (hapSigningBlock != null) {
                hapSigningBlock.clear();
            }
        }
    }

    private long getCentralDirOffset(ByteBuffer eocd, long eocdOffset) throws SignatureNotFoundException {
        long centralDirOffset = ZipUtils.getCentralDirectoryOffset(eocd);
        if (centralDirOffset > eocdOffset) {
            throw new SignatureNotFoundException("centralDirOffset: " + centralDirOffset + " is larger than eocdOffset: " + eocdOffset);
        }
        long centralDirSize = ZipUtils.getCentralDirectorySize(eocd);
        if (centralDirOffset + centralDirSize != eocdOffset) {
            throw new SignatureNotFoundException("value error! centralDirOffset: " + centralDirOffset + ", centralDirSize: " + centralDirSize + ", eocdOffset: " + eocdOffset);
        }
        return centralDirOffset;
    }

    private Pair<Long, ByteBuffer> findHapSigningBlock(RandomAccessFile hap, long centralDirOffset) throws IOException, SignatureNotFoundException {
        if (centralDirOffset < 32L) {
            throw new SignatureNotFoundException("Hap too small for Hap Signing Block. ZIP Central Directory offset: " + centralDirOffset);
        }
        ByteBuffer hapBlockHead = ByteBuffer.allocate(32);
        hapBlockHead.order(ByteOrder.LITTLE_ENDIAN);
        hap.seek(centralDirOffset - (long)hapBlockHead.capacity());
        hap.readFully(hapBlockHead.array(), hapBlockHead.arrayOffset(), hapBlockHead.capacity());
        int blockCount = hapBlockHead.getInt();
        long hapSigBlockSize = hapBlockHead.getLong();
        long hapSignBlockMagicLo = hapBlockHead.getLong();
        long hapSignBlockMagicHi = hapBlockHead.getLong();
        int version = hapBlockHead.getInt();
        LOGGER.info("Hap signature version: {}", (Object)version);
        if (hapSignBlockMagicLo != 2334950737560224072L || hapSignBlockMagicHi != 3617552046287187010L) {
            throw new SignatureNotFoundException("No Hap Signing Block before ZIP Central Directory");
        }
        if (hapSigBlockSize < 32L || hapSigBlockSize > 0x7FFFFFF7L) {
            throw new SignatureNotFoundException("Hap Signing Block size out of range: " + hapSigBlockSize);
        }
        int totalSize = (int)hapSigBlockSize;
        long hapSigBlockOffset = centralDirOffset - (long)totalSize;
        if (hapSigBlockOffset < 0L) {
            throw new SignatureNotFoundException("Hap Signing Block offset out of range: " + hapSigBlockOffset);
        }
        ByteBuffer hapSigBlock = ByteBuffer.allocate(totalSize);
        hapSigBlock.order(ByteOrder.LITTLE_ENDIAN);
        hap.seek(hapSigBlockOffset);
        hap.readFully(hapSigBlock.array(), hapSigBlock.arrayOffset(), hapSigBlock.capacity());
        return Pair.create(hapSigBlockOffset, hapSigBlock);
    }
}

