/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.verify;

import com.huawei.signclient.hap.ext.PKCS7Ext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class VerifyAndParseProvision {
    private static final Logger LOGGER = LogManager.getLogger(VerifyAndParseProvision.class);

    public boolean verifyAndParseProvision(String signedProvisionPath, String unsignedProvisionPath) {
        File signedProvisionFile = new File(signedProvisionPath);
        if (!this.checkProvisionFile(signedProvisionFile)) {
            String errorMsg = "Check input provision file false!";
            LOGGER.error(errorMsg);
            return false;
        }
        byte[] signedProvisionData = this.getSignedProvisionData(signedProvisionFile);
        if (signedProvisionData.length == 0) {
            LOGGER.error("read provision file failed");
            return false;
        }
        byte[] unsignedProvisionData = this.getUnsignedProvisionData(signedProvisionData);
        if (unsignedProvisionData == null) {
            LOGGER.error("get unsigned provision failed");
            return false;
        }
        return this.outputUnsignedProvisionToFile(unsignedProvisionData, unsignedProvisionPath);
    }

    private boolean checkProvisionFile(File signedProvisionFile) {
        try {
            if (!signedProvisionFile.canRead()) {
                LOGGER.error(signedProvisionFile.getCanonicalPath() + " does not exist or can not read!");
                return false;
            }
            if (!signedProvisionFile.isFile()) {
                LOGGER.error(signedProvisionFile.getCanonicalPath() + " is not a file!");
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error("getCanonicalPath failed", (Throwable)e);
            return false;
        }
        return true;
    }

    private byte[] getSignedProvisionData(File signedProvisionFile) {
        byte[] signedProvisionData = new byte[]{};
        try {
            signedProvisionData = FileUtils.readFileToByteArray(signedProvisionFile);
        }
        catch (IOException e) {
            LOGGER.error("readFileToByteArray failed.", (Throwable)e);
        }
        return signedProvisionData;
    }

    private byte[] getUnsignedProvisionData(byte[] signedProvisionData) {
        byte[] unsignedProvisionData = null;
        try {
            PKCS7Ext pkcs7 = new PKCS7Ext(signedProvisionData);
            SignerInfo[] verify = ((PKCS7)pkcs7).verify();
            if (verify == null) {
                throw new SignatureException("PKCS7 cms data verify faild!");
            }
            unsignedProvisionData = pkcs7.getContentInfo().getData();
        }
        catch (IOException | NoSuchAlgorithmException | SignatureException e) {
            LOGGER.error("get unsigned provision data failed.", (Throwable)e);
        }
        return unsignedProvisionData;
    }

    private boolean outputUnsignedProvisionToFile(byte[] unsignedProvisionData, String unsignedProvisionPath) {
        boolean ret = false;
        try (FileOutputStream unsignedProvisionOutputStream = new FileOutputStream(new File(unsignedProvisionPath));){
            unsignedProvisionOutputStream.write(unsignedProvisionData);
            ret = true;
        }
        catch (IOException e) {
            LOGGER.error("output unsigned provision to file failed.", (Throwable)e);
        }
        return ret;
    }
}

