/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.verify;

import com.huawei.signclient.hap.entity.SigningBlock;
import com.huawei.signclient.hap.ext.PKCS7Ext;
import com.huawei.signclient.hap.sign.ContentDigestAlgorithm;
import com.huawei.signclient.hap.sign.SignatureAlgorithm;
import com.huawei.signclient.hap.utils.DigestUtils;
import com.huawei.signclient.hap.utils.HapUtils;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;

public class HapVerifyV2 {
    private static final Logger LOGGER = LogManager.getLogger(HapVerifyV2.class);
    private ByteBuffer beforeApkSigningBlock;
    private ByteBuffer signatureSchemeBlock;
    private ByteBuffer centralDirectoryBlock;
    private ByteBuffer eocd;
    private List<SigningBlock> optionalBlocks;
    private Map<ContentDigestAlgorithm, byte[]> digestMap = new HashMap<ContentDigestAlgorithm, byte[]>();

    public HapVerifyV2(ByteBuffer beforeApkSigningBlock, ByteBuffer signatureSchemeBlock, ByteBuffer centralDirectoryBlock, ByteBuffer eocd, List<SigningBlock> optionalBlocks) {
        this.beforeApkSigningBlock = beforeApkSigningBlock;
        this.signatureSchemeBlock = signatureSchemeBlock;
        this.centralDirectoryBlock = centralDirectoryBlock;
        this.eocd = eocd;
        this.optionalBlocks = optionalBlocks;
    }

    public boolean verify(String outputCertPath, String outputProfileFile, String outputProofFile) throws CertificateEncodingException, NoSuchAlgorithmException, SignatureException, DigestException {
        return this.parserSigner(this.signatureSchemeBlock, outputCertPath) && this.outputProofsAndProvision(outputProfileFile, outputProofFile);
    }

    private PKCS7 getPKCS7(ByteBuffer signer) throws SignatureException {
        byte[] array = new byte[signer.remaining()];
        signer.get(array);
        try {
            return new PKCS7Ext(array);
        }
        catch (ParsingException e) {
            throw new SignatureException("create PKCS7 failed.", e);
        }
    }

    private byte[] getContentBytesFromPKCS7(PKCS7 pkcs7) throws SignatureException {
        try {
            return pkcs7.getContentInfo().getContentBytes();
        }
        catch (IOException e) {
            throw new SignatureException("get Content Bytes from PKCS7 failed.", e);
        }
    }

    private boolean checkCRL(X509CRL crl, X509Certificate[] certificates) {
        boolean ret = false;
        for (X509Certificate cert : certificates) {
            if (!crl.getIssuerDN().getName().equals(cert.getIssuerDN().getName())) continue;
            X509CRLEntry entry = crl.getRevokedCertificate(cert);
            if (entry != null) {
                LOGGER.info("cert(subject DN = {}) is revoked by crl (IssuerDN = {})", (Object)cert.getSubjectDN().getName(), (Object)crl.getIssuerDN().getName());
                ret = false;
                break;
            }
            ret = true;
        }
        return ret;
    }

    private boolean verifyCRL(X509CRL crl, X509Certificate cert, X509Certificate[] certificates) throws SignatureException {
        try {
            crl.verify(cert.getPublicKey());
            return this.checkCRL(crl, certificates);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CRLException e) {
            throw new SignatureException("crl verify failed.", e);
        }
    }

    private boolean verifyCRLs(X509CRL[] crls, X509Certificate[] certificates) throws SignatureException {
        if (crls == null) {
            return true;
        }
        boolean revoked = true;
        for (X509CRL crl : crls) {
            for (X509Certificate cert : certificates) {
                if (!crl.getIssuerDN().getName().equals(cert.getSubjectDN().getName()) || this.verifyCRL(crl, cert, certificates)) continue;
                revoked = false;
            }
        }
        return revoked;
    }

    private boolean parserSigner(ByteBuffer signer, String outputCertPath) throws NoSuchAlgorithmException, SignatureException, DigestException, CertificateEncodingException {
        PKCS7 pkcs7 = this.getPKCS7(signer);
        SignerInfo[] signerInfos = pkcs7.getSignerInfos();
        for (int i = 0; i < signerInfos.length; ++i) {
            signerInfos[i] = HapUtils.tanslateSignerInfo(signerInfos[i]);
        }
        SignerInfo[] verify = pkcs7.verify();
        if (verify == null) {
            throw new SignatureException("PKCS7 cms data verify faild!");
        }
        LOGGER.info("hap PKCS cms data verify success!");
        X509CRL[] crls = pkcs7.getCRLs();
        byte[] contentBytes = this.getContentBytesFromPKCS7(pkcs7);
        AlgorithmId[] algIds = pkcs7.getDigestAlgorithmIds();
        X509Certificate[] certificates = pkcs7.getCertificates();
        if (certificates == null || certificates.length == 0) {
            throw new SignatureException("no certificate in PKCS7.");
        }
        for (int i = 0; i < certificates.length; ++i) {
            LOGGER.info("+++++++++++++++++++++++++++certificate #{} +++++++++++++++++++++++++++++++", (Object)i);
            this.printCert(certificates[i]);
        }
        boolean revoked = this.verifyCRLs(crls, certificates);
        if (!revoked) {
            LOGGER.error("Certificate is revoked!");
            return false;
        }
        return this.parserContentinfo(contentBytes) && this.writeCertificate(outputCertPath, Objects.requireNonNull(certificates));
    }

    private boolean outputProofsAndProvision(String outputProfileFile, String outputProofFile) {
        boolean outputProfile = false;
        for (SigningBlock optionalBlock : this.optionalBlocks) {
            if (optionalBlock.getType() == 0x20000001) {
                boolean outputProof = this.writeOptionalBlock(outputProofFile, optionalBlock);
                LOGGER.info("Write proof file ret = {}", (Object)outputProof);
            }
            if (optionalBlock.getType() != 0x20000002) continue;
            outputProfile = this.writeOptionalBlock(outputProfileFile, optionalBlock);
            LOGGER.info("Write provision file ret = {}", (Object)outputProfile);
        }
        return outputProfile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeOptionalBlock(String destFile, SigningBlock optionalBlock) {
        try (FileOutputStream fileStream = new FileOutputStream(destFile);){
            if (optionalBlock != null) {
                fileStream.write(optionalBlock.getValue());
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("write optional block failed", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeCertificate(String destFile, X509Certificate[] certificates) {
        try (JcaPEMWriter writer = new JcaPEMWriter(new FileWriter(destFile));){
            for (X509Certificate cert : certificates) {
                writer.write(cert.getSubjectDN().toString() + System.lineSeparator());
                writer.writeObject(cert);
            }
            LOGGER.info("Write certificate chain success!");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Write certificate chain failed!", (Throwable)e);
            return false;
        }
    }

    private boolean parserContentinfo(byte[] data) throws DigestException, SignatureException {
        boolean result = true;
        ByteBuffer digestDatas = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        while (digestDatas.remaining() > 4) {
            int signBlockVersion = digestDatas.getInt();
            int signBlockCount = digestDatas.getInt();
            LOGGER.info("version is: {}, number of block is: {}", (Object)signBlockVersion, (Object)signBlockCount);
            int digestBlockLen = digestDatas.getInt();
            int signatureAlgId = digestDatas.getInt();
            int digestDatalen = digestDatas.getInt();
            if (digestBlockLen != digestDatalen + 8) {
                throw new SignatureException("digestBlockLen: " + digestBlockLen + ", digestDatalen: " + digestDatalen);
            }
            ByteBuffer degestBuffer = HapUtils.sliceBuffer(digestDatas, digestDatalen);
            byte[] degisetData = new byte[degestBuffer.remaining()];
            degestBuffer.get(degisetData);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(signatureAlgId);
            if (signatureAlgorithm == null) {
                throw new SignatureException("Unsupported SignatureAlgorithm ID : " + signatureAlgId);
            }
            this.digestMap.put(signatureAlgorithm.getContentDigestAlgorithm(), degisetData);
        }
        Set<ContentDigestAlgorithm> keySet = this.digestMap.keySet();
        Map<ContentDigestAlgorithm, byte[]> actualDigestMap = HapUtils.computeDigests(keySet, new ByteBuffer[]{this.beforeApkSigningBlock, this.centralDirectoryBlock, this.eocd}, this.optionalBlocks);
        for (Map.Entry<ContentDigestAlgorithm, byte[]> entry : this.digestMap.entrySet()) {
            ContentDigestAlgorithm digestAlg = entry.getKey();
            byte[] exceptDigest = entry.getValue();
            byte[] actualDigest = actualDigestMap.get((Object)digestAlg);
            if (!Arrays.equals(actualDigest, exceptDigest)) {
                result = false;
                LOGGER.error("degist data do not match! DigestAlgorithm: {}, actualDigest: <{}> VS exceptDigest : <{}>", (Object)digestAlg.getDigestAlgorithm(), (Object)HapUtils.toHex(actualDigest, ""), (Object)HapUtils.toHex(exceptDigest, ""));
            }
            LOGGER.info("Digest verify result: {}, DigestAlgorithm: {}", (Object)result, (Object)digestAlg.getDigestAlgorithm());
        }
        return result;
    }

    private void printCert(X509Certificate cert) throws CertificateEncodingException {
        byte[] encodedCert = cert.getEncoded();
        LOGGER.info("Subject: {}", (Object)cert.getSubjectX500Principal());
        LOGGER.info("Issuer: {}", (Object)cert.getIssuerX500Principal());
        LOGGER.info("SerialNumber: {}", (Object)cert.getSerialNumber().toString(16));
        LOGGER.info("Validity: {} ~ {}", (Object)this.formatDateTime(cert.getNotBefore()), (Object)this.formatDateTime(cert.getNotAfter()));
        LOGGER.info("SHA256: {}", (Object)HapUtils.toHex(DigestUtils.sha256Digest(encodedCert), ":"));
        LOGGER.info("Signature Algorithm: {}", (Object)cert.getSigAlgName());
        PublicKey publicKey = cert.getPublicKey();
        LOGGER.info("Key: {}, key length: {} bits", (Object)publicKey.getAlgorithm(), (Object)this.getKeySize(publicKey));
        LOGGER.info("Cert Version: V{}", (Object)cert.getVersion());
    }

    private int getKeySize(PublicKey publicKey) {
        DSAParams dsaParams;
        if (publicKey instanceof RSAKey) {
            return ((RSAKey)((Object)publicKey)).getModulus().bitLength();
        }
        if (publicKey instanceof ECKey) {
            return ((ECKey)((Object)publicKey)).getParams().getOrder().bitLength();
        }
        if (publicKey instanceof DSAKey && (dsaParams = ((DSAKey)((Object)publicKey)).getParams()) != null) {
            return dsaParams.getP().bitLength();
        }
        return -1;
    }

    private String formatDateTime(Date date) {
        if (null != date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.format(date);
        }
        return "";
    }
}

