/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.utils;

import com.huawei.signclient.hap.entity.Pair;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ZipUtils {
    private static final int ZIP_EOCD_SEGMENT_MIN_SIZE = 22;
    private static final int ZIP_EOCD_SEGMENT_FLAG = 101010256;
    private static final int ZIP_CENTRAL_DIR_SIZE_OFFSET_IN_EOCD = 12;
    private static final int ZIP_CENTRAL_DIR_OFFSET_IN_EOCD = 16;
    private static final int ZIP_EOCD_COMMENT_LENGTH_OFFSET = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIG = 1347094023;
    private static final int UINT16_MAX_VALUE = 65535;
    private static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;

    public static Pair<Long, ByteBuffer> findEocdInHap(RandomAccessFile zip) throws IOException {
        Pair<Long, ByteBuffer> eocdPair = ZipUtils.findEocdInHap(zip, 0);
        if (eocdPair != null) {
            return eocdPair;
        }
        return ZipUtils.findEocdInHap(zip, 65535);
    }

    private static Pair<Long, ByteBuffer> findEocdInHap(RandomAccessFile zip, int maxCommentSize) throws IOException {
        if (maxCommentSize < 0 || maxCommentSize > 65535) {
            throw new IllegalArgumentException("maxCommentSize: " + maxCommentSize);
        }
        long fileLength = zip.length();
        if (fileLength < 22L) {
            throw new IllegalArgumentException("file length " + fileLength + " is too smaller");
        }
        int searchRange = (int)Math.min((long)maxCommentSize, fileLength - 22L) + 22;
        ByteBuffer searchEocdBuffer = ByteBuffer.allocate(searchRange);
        searchEocdBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long searchRangeOffset = fileLength - (long)searchEocdBuffer.capacity();
        zip.seek(searchRangeOffset);
        zip.readFully(searchEocdBuffer.array(), searchEocdBuffer.arrayOffset(), searchEocdBuffer.capacity());
        int eocdOffsetInSearchBuffer = ZipUtils.findEocdInSearchBuffer(searchEocdBuffer);
        Pair<Long, ByteBuffer> ret = null;
        if (eocdOffsetInSearchBuffer == -1) {
            return ret;
        }
        searchEocdBuffer.position(eocdOffsetInSearchBuffer);
        ret = Pair.create(searchRangeOffset + (long)eocdOffsetInSearchBuffer, searchEocdBuffer.slice());
        ret.getSecond().order(ByteOrder.LITTLE_ENDIAN);
        return ret;
    }

    public static int findEocdInSearchBuffer(ByteBuffer searchBuffer) {
        ZipUtils.checkBufferIsLittleEndian(searchBuffer);
        int searchBufferSize = searchBuffer.capacity();
        if (searchBufferSize < 22) {
            return -1;
        }
        for (int currentOffset = searchBufferSize - 22; currentOffset >= 0; --currentOffset) {
            int expectedCommentLength;
            int commentLength;
            if (searchBuffer.getInt(currentOffset) != 101010256 || (commentLength = ZipUtils.getUInt16FromBuffer(searchBuffer, currentOffset + 20)) != (expectedCommentLength = searchBufferSize - 22 - currentOffset)) continue;
            return currentOffset;
        }
        return -1;
    }

    public static boolean checkZip64EoCDLocatorIsPresent(ByteBuffer zipContents, int zipEocdOffset) {
        ZipUtils.checkBufferIsLittleEndian(zipContents);
        int locatorPos = zipEocdOffset - 20;
        if (locatorPos < 0) {
            return false;
        }
        return zipContents.getInt(locatorPos) == 1347094023;
    }

    public static boolean checkZip64EoCDLocatorIsPresent(RandomAccessFile zip, long zipEocdOffset) throws IOException {
        long locatorPos = zipEocdOffset - 20L;
        if (locatorPos < 0L) {
            return false;
        }
        zip.seek(locatorPos);
        return zip.readInt() == 1347094023;
    }

    public static long getCentralDirectoryOffset(ByteBuffer eocd) {
        ZipUtils.checkBufferIsLittleEndian(eocd);
        return ZipUtils.getUInt32FromBuffer(eocd, eocd.position() + 16);
    }

    public static void setCentralDirectoryOffset(ByteBuffer eocd, long offset) {
        ZipUtils.checkBufferIsLittleEndian(eocd);
        ZipUtils.setUInt32ToBuffer(eocd, eocd.position() + 16, offset);
    }

    public static long getCentralDirectorySize(ByteBuffer eocd) {
        ZipUtils.checkBufferIsLittleEndian(eocd);
        return ZipUtils.getUInt32FromBuffer(eocd, eocd.position() + 12);
    }

    private static void checkBufferIsLittleEndian(ByteBuffer buffer) {
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return;
        }
        throw new IllegalArgumentException("ByteBuffer is not little endian");
    }

    private static int getUInt16FromBuffer(ByteBuffer buffer, int offset) {
        return buffer.getShort(offset) & 0xFFFF;
    }

    private static long getUInt32FromBuffer(ByteBuffer buffer, int offset) {
        return (long)buffer.getInt(offset) & 0xFFFFFFFFL;
    }

    private static void setUInt32ToBuffer(ByteBuffer buffer, int offset, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("uint32 value of out range: " + value);
        }
        buffer.putInt(buffer.position() + offset, (int)value);
    }

    public static ByteBuffer getCentralDirectoryRecord(RandomAccessFile zip, long centralDirOffset, long eocdOffset) throws IOException {
        long size = eocdOffset - centralDirOffset;
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Central Directory size out of range, size : " + size);
        }
        ByteBuffer centralDir = ByteBuffer.allocate((int)size).order(ByteOrder.LITTLE_ENDIAN);
        zip.seek(centralDirOffset);
        zip.readFully(centralDir.array(), centralDir.arrayOffset(), centralDir.capacity());
        return centralDir;
    }

    public static ByteBuffer getContentOfZip(RandomAccessFile zip, long signingBlockOffset) throws IOException {
        if (signingBlockOffset < 0L || signingBlockOffset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("CentralDirectory size out of range, size : " + signingBlockOffset);
        }
        ByteBuffer content = ByteBuffer.allocate((int)signingBlockOffset).order(ByteOrder.LITTLE_ENDIAN);
        zip.seek(0L);
        zip.readFully(content.array(), content.arrayOffset(), content.capacity());
        return content;
    }
}

