/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.utils;

import com.huawei.signclient.hap.sign.SignatureAlgorithm;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class ParamProcessUtil {
    private static final Logger LOGGER = LogManager.getLogger(ParamProcessUtil.class);

    public static String getParamFromArgs(String[] args, String paramField) {
        for (int i = 0; i < args.length; i += 2) {
            if (!args[i].startsWith("-") || !args[i].substring(1).equals(paramField)) continue;
            return args[i + 1];
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey getPrivateKeyFromFile(String privateKeyPath) {
        RSAPrivateKey privateKey = null;
        if (privateKeyPath == null || "".equals(privateKeyPath)) {
            LOGGER.error("The private is null or blank");
            return privateKey;
        }
        try (FileInputStream privateKeyStream = new FileInputStream(privateKeyPath);){
            byte[] keyData = new byte[privateKeyStream.available()];
            if (privateKeyStream.read(keyData) == -1) {
                LOGGER.error("read key file failed.");
                RSAPrivateKey rSAPrivateKey = privateKey;
                return rSAPrivateKey;
            }
            byte[] buffer = Base64.decode(keyData);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey obj = keyFactory.generatePrivate(keySpec);
            if (!(obj instanceof RSAPrivateKey)) {
                LOGGER.error("obj is not RSAPrivateKey");
                RSAPrivateKey rSAPrivateKey = privateKey;
                return rSAPrivateKey;
            }
            privateKey = (RSAPrivateKey)obj;
            return privateKey;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("get private key from file failed.", (Throwable)e);
        }
        return privateKey;
    }

    public static Set<String> initParamField(String[] paramFileds) {
        return new HashSet<String>(Arrays.asList(paramFileds));
    }

    public static void delDir(File file) {
        File[] zFiles;
        if (file.isDirectory() && (zFiles = file.listFiles()) != null) {
            for (File file2 : zFiles) {
                ParamProcessUtil.delDir(file2);
            }
        }
        file.delete();
    }

    public static SignatureAlgorithm getSignatureAlgorithm(String signatureAlgorithm) {
        if (signatureAlgorithm.contains("SHA256withECDSA")) {
            return SignatureAlgorithm.ECDSA_WITH_SHA256;
        }
        if (signatureAlgorithm.contains("SHA384withECDSA")) {
            return SignatureAlgorithm.ECDSA_WITH_SHA384;
        }
        if (signatureAlgorithm.contains("SHA512withECDSA")) {
            return SignatureAlgorithm.ECDSA_WITH_SHA512;
        }
        if (signatureAlgorithm.contains("SHA256withRSA/PSS")) {
            return SignatureAlgorithm.RSA_PSS_WITH_SHA256;
        }
        if (signatureAlgorithm.contains("SHA384withRSA/PSS")) {
            return SignatureAlgorithm.RSA_PSS_WITH_SHA384;
        }
        if (signatureAlgorithm.contains("SHA512withRSA/PSS")) {
            return SignatureAlgorithm.RSA_PSS_WITH_SHA512;
        }
        if (signatureAlgorithm.contains("SHA512withRSA")) {
            return SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512;
        }
        throw new IllegalArgumentException("Unsupported signature algorithm: " + signatureAlgorithm);
    }
}

