/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.utils;

import com.google.gson.Gson;
import com.huawei.signclient.hap.exception.HttpException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtils {
    private static final Logger LOGGER = LogManager.getLogger(HttpUtils.class);
    private static Map<String, String> configMap = new HashMap<String, String>();
    private static final int MAX_TIMEOUT = 10000;
    private static final int HTTP_SUCCESS_CODE = 200;

    private static void init() {
        ClassLoader httpUtilsClass = HttpUtils.class.getClassLoader();
        if (httpUtilsClass == null) {
            LOGGER.error("get HttpUtils ClassLoader failed!");
            return;
        }
        try (InputStream inputStream = httpUtilsClass.getResourceAsStream("httpConf.properties");){
            Properties prop = new Properties();
            configMap = new HashMap<String, String>();
            if (inputStream == null) {
                LOGGER.error("Could not read config file!");
                return;
            }
            prop.load(inputStream);
            Enumeration<?> keyNames = prop.propertyNames();
            while (keyNames.hasMoreElements()) {
                Object obj = keyNames.nextElement();
                if (!(obj instanceof String)) {
                    LOGGER.error("keyName is not a string!");
                    return;
                }
                String key = (String)obj;
                String value = prop.getProperty(key);
                configMap.put(key, value);
            }
        }
        catch (IOException e) {
            LOGGER.error("Get Http Request config error:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String postData(Map<String, String> requestParams) throws HttpException {
        String response;
        block10: {
            String string;
            OutputStream outputStream = null;
            InputStream inputStream = null;
            response = null;
            try {
                String postUrl = configMap.get("signServer");
                if (requestParams.containsKey("signServer")) {
                    postUrl = requestParams.get("signServer");
                }
                URL url = new URL(postUrl);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("POST");
                urlConnection.setUseCaches(false);
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setConnectTimeout(10000);
                urlConnection.setReadTimeout(10000);
                urlConnection.setRequestProperty("Content-Type", "application/json");
                urlConnection.setRequestProperty("Charset", "utf8");
                String params = new Gson().toJson(requestParams);
                byte[] paramBytes = params.getBytes("utf8");
                urlConnection.connect();
                outputStream = urlConnection.getOutputStream();
                outputStream.write(paramBytes);
                outputStream.flush();
                int responseCode = urlConnection.getResponseCode();
                if (responseCode != 200) {
                    inputStream = urlConnection.getErrorStream();
                    if (inputStream == null) {
                        throw new HttpException("Http error and no error stream.", responseCode);
                    }
                    throw new HttpException(new String(HttpUtils.readFully(inputStream), "utf8"), responseCode);
                }
                inputStream = urlConnection.getInputStream();
                string = new String(HttpUtils.readFully(inputStream), "utf8");
                HttpUtils.closeQuietly(outputStream);
            }
            catch (MalformedURLException | ProtocolException e) {
                LOGGER.error("Failed to request: ", (Throwable)e);
                break block10;
            }
            catch (IOException e2) {
                LOGGER.error("Failed to handle request io: ", (Throwable)e2);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                HttpUtils.closeQuietly(outputStream);
                HttpUtils.closeQuietly(inputStream);
            }
            HttpUtils.closeQuietly(inputStream);
            return string;
        }
        return response;
    }

    /*
     * Loose catch block
     */
    private static byte[] readFully(InputStream input) throws IOException {
        try {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                byte[] byArray = output.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            HttpUtils.closeQuietly(input);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Close stream error!", (Throwable)e);
        }
    }

    static {
        HttpUtils.init();
    }
}

