/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashUtils {
    private static final Logger LOGGER = LogManager.getLogger(HashUtils.class);
    private static final int HASH_LEN = 4096;
    private MessageDigest md;

    public static int getHashAlgsId(String algMethod) {
        if ("SHA-224".equals(algMethod)) {
            return 5;
        }
        if ("SHA-256".equals(algMethod)) {
            return 6;
        }
        if ("SHA-384".equals(algMethod)) {
            return 7;
        }
        if ("SHA-512".equals(algMethod)) {
            return 8;
        }
        return 0;
    }

    private static MessageDigest getMessageDigest(String algMethod) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algMethod);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("no such algorithm", (Throwable)e);
        }
        return md;
    }

    private static byte[] getByteDigest(byte[] str, int count, String algMethod) {
        MessageDigest md = HashUtils.getMessageDigest(algMethod);
        md.update(str, 0, count);
        return md.digest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFileDigest(String filePath, String algName) {
        byte[] digest = null;
        MessageDigest md = HashUtils.getMessageDigest(algName);
        if (md == null) {
            return digest;
        }
        byte[] fileDate = new byte[4096];
        try (FileInputStream input = new FileInputStream(new File(filePath));){
            byte[] dig;
            int byteCount;
            int num = 0;
            HashMap<Integer, byte[]> hashList = new HashMap<Integer, byte[]>();
            while ((byteCount = ((InputStream)input).read(fileDate)) > 0) {
                dig = HashUtils.getByteDigest(fileDate, byteCount, algName);
                hashList.put(num, dig);
                ++num;
            }
            if (hashList.isEmpty()) {
                LOGGER.error("hashList is empty");
                dig = digest;
                return dig;
            }
            for (int i = 0; i < hashList.size(); ++i) {
                md.update((byte[])hashList.get(i));
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("getFileDigest File Not Found failed.");
            return digest;
        }
        catch (IOException e) {
            LOGGER.error("getFileDigest IOException failed.", (Throwable)e);
        }
        return digest;
    }
}

