/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.utils;

import com.huawei.signclient.hap.entity.Pair;
import com.huawei.signclient.hap.entity.SigningBlock;
import com.huawei.signclient.hap.ext.AlgorithmIdExt;
import com.huawei.signclient.hap.ext.SignerInfoExt;
import com.huawei.signclient.hap.sign.ContentDigestAlgorithm;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;
import sun.security.pkcs.SignerInfo;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class HapUtils {
    private static final Logger LOGGER = LogManager.getLogger(HapUtils.class);
    public static final int HAP_SIGNATURE_SCHEME_V1_BLOCK_ID = 0x20000000;
    public static final int HAP_PROOF_OF_ROTATION_BLOCK_ID = 0x20000001;
    public static final int HAP_PROFILE_BLOCK_ID = 0x20000002;
    public static final int HAP_PROPERTY_BLOCK_ID = 0x20000003;
    public static final int CONTENT_DIGESTED_CHUNK_MAX_SIZE_BYTES = 0x100000;
    public static final Set<Integer> HAP_SIGNATURE_OPTIONAL_BLOCK_IDS = new HashSet<Integer>(){
        private static final long SERIAL_VERSION_UID = -7972389022577288313L;
        {
            this.add(0x20000001);
            this.add(0x20000002);
            this.add(0x20000003);
        }
    };
    public static final byte[] HAP_SIGNING_BLOCK_MAGIC = new byte[]{72, 65, 80, 32, 83, 105, 103, 32, 66, 108, 111, 99, 107, 32, 52, 50};
    public static final long HAP_SIG_BLOCK_MAGIC_LO = 2334950737560224072L;
    public static final long HAP_SIG_BLOCK_MAGIC_HI = 3617552046287187010L;
    public static final int HAP_SIG_BLOCK_MIN_SIZE = 32;
    private static final byte ZIP_FIRST_LEVEL_CHUNK_PREFIX = 90;
    private static final byte ZIP_SECOND_LEVEL_CHUNK_PREFIX = -91;
    private static final int DIGEST_PRIFIX_LENGTH = 5;
    private static final char[] HEX_CHAR_ARRAY = "0123456789ABCDEF".toCharArray();

    /*
     * Exception decompiling
     */
    public static byte[] readFileToByte(String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int getChunkCount(ByteBuffer[] contents) {
        int chunkCount = 0;
        for (ByteBuffer input : contents) {
            chunkCount += (int)(((long)input.remaining() + 0x100000L - 1L) / 0x100000L);
        }
        return chunkCount;
    }

    private static void getDigest(ContentDigestAlgorithm digestAlgorithm, ByteBuffer chunk, byte[] chunkContentPrefix, Map<ContentDigestAlgorithm, byte[]> digestsOfChunks, int chunkIndex) throws DigestException {
        MessageDigest md;
        String jcaAlgorithmName = digestAlgorithm.getDigestAlgorithm();
        try {
            md = MessageDigest.getInstance(jcaAlgorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException(jcaAlgorithmName + " MessageDigest not supported", e);
        }
        chunk.clear();
        HapUtils.setUInt32ToByteArrayWithLittleEngian(chunk.remaining(), chunkContentPrefix, 1);
        md.update(chunkContentPrefix);
        md.update(chunk);
        byte[] concatenationOfChunkCountAndChunkDigests = digestsOfChunks.get((Object)digestAlgorithm);
        int expectedDigestSizeBytes = digestAlgorithm.getDigestOutputByteSize();
        int actualDigestSizeBytes = md.digest(concatenationOfChunkCountAndChunkDigests, 5 + chunkIndex * expectedDigestSizeBytes, expectedDigestSizeBytes);
        if (actualDigestSizeBytes != expectedDigestSizeBytes) {
            throw new DigestException("Unexpected output size of " + md.getAlgorithm() + " digest: " + actualDigestSizeBytes);
        }
    }

    private static Map<ContentDigestAlgorithm, byte[]> getFinalDigest(Set<ContentDigestAlgorithm> digestAlgorithms, Map<ContentDigestAlgorithm, byte[]> digestsOfChunks, List<SigningBlock> optionalBlocks) throws DigestException {
        HashMap<ContentDigestAlgorithm, byte[]> result = new HashMap<ContentDigestAlgorithm, byte[]>(digestAlgorithms.size());
        for (Map.Entry<ContentDigestAlgorithm, byte[]> entry : digestsOfChunks.entrySet()) {
            MessageDigest md;
            ContentDigestAlgorithm digestAlgorithm = entry.getKey();
            byte[] concatenationOfChunkCountAndChunkDigests = entry.getValue();
            String jcaAlgorithmName = digestAlgorithm.getDigestAlgorithm();
            try {
                md = MessageDigest.getInstance(jcaAlgorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new DigestException(jcaAlgorithmName + " MessageDigest not supported", e);
            }
            md.update(concatenationOfChunkCountAndChunkDigests);
            if (optionalBlocks != null && optionalBlocks.size() > 0) {
                for (int i = 0; i < optionalBlocks.size(); ++i) {
                    md.update(optionalBlocks.get(i).getValue());
                }
            }
            byte[] digest = md.digest();
            result.put(digestAlgorithm, digest);
        }
        return result;
    }

    private static void computeDigestsForEachAlgorithm(ByteBuffer input, Set<ContentDigestAlgorithm> digestAlgorithms, byte[] chunkContentPrefix, Map<ContentDigestAlgorithm, byte[]> digestsOfChunks, int chunkIndex) throws DigestException {
        int chunkSize = Math.min(input.remaining(), 0x100000);
        ByteBuffer chunk = HapUtils.sliceBuffer(input, chunkSize);
        for (ContentDigestAlgorithm digestAlgorithm : digestAlgorithms) {
            HapUtils.getDigest(digestAlgorithm, chunk, chunkContentPrefix, digestsOfChunks, chunkIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<ContentDigestAlgorithm, byte[]> computeDigests(Set<ContentDigestAlgorithm> digestAlgorithms, ByteBuffer[] contents, List<SigningBlock> optionalBlocks) throws DigestException {
        try {
            int chunkCount = HapUtils.getChunkCount(contents);
            HashMap<ContentDigestAlgorithm, byte[]> digestsOfChunks = new HashMap<ContentDigestAlgorithm, byte[]>(digestAlgorithms.size());
            for (ContentDigestAlgorithm digestAlgorithm : digestAlgorithms) {
                int n = digestAlgorithm.getDigestOutputByteSize();
                byte[] concatenationOfChunkCountAndChunkDigests = new byte[5 + chunkCount * n];
                concatenationOfChunkCountAndChunkDigests[0] = 90;
                HapUtils.setUInt32ToByteArrayWithLittleEngian(chunkCount, concatenationOfChunkCountAndChunkDigests, 1);
                digestsOfChunks.put(digestAlgorithm, concatenationOfChunkCountAndChunkDigests);
            }
            int chunkIndex = 0;
            byte[] chunkContentPrefix = new byte[5];
            chunkContentPrefix[0] = -91;
            for (ByteBuffer input : contents) {
                while (input.hasRemaining()) {
                    HapUtils.computeDigestsForEachAlgorithm(input, digestAlgorithms, chunkContentPrefix, digestsOfChunks, chunkIndex);
                    ++chunkIndex;
                }
            }
            Map<ContentDigestAlgorithm, byte[]> map = HapUtils.getFinalDigest(digestAlgorithms, digestsOfChunks, optionalBlocks);
            return map;
        }
        finally {
            for (ByteBuffer input : contents) {
                input.clear();
            }
        }
    }

    private static void setUInt32ToByteArrayWithLittleEngian(int value, byte[] result, int offset) {
        for (int i = 0; i < 4; ++i) {
            result[offset + i] = (byte)(value >> 8 * i & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer sliceBuffer(ByteBuffer source, int targetSize) {
        int limit = source.limit();
        int position = source.position();
        int targetLimit = position + targetSize;
        if (targetLimit < position || targetLimit > limit) {
            LOGGER.error("targetSize: " + targetSize);
            throw new BufferUnderflowException();
        }
        try {
            source.limit(targetLimit);
            ByteBuffer target = source.slice();
            target.order(source.order());
            ByteBuffer byteBuffer = target;
            return byteBuffer;
        }
        finally {
            source.position(targetLimit);
            source.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer sliceBuffer(ByteBuffer source, int startPos, int endPos) {
        int capacity = source.capacity();
        if (startPos < 0 || endPos < startPos || endPos > capacity) {
            throw new IllegalArgumentException("startPos: " + startPos + ", endPos: " + endPos + ", capacity: " + capacity);
        }
        int limit = source.limit();
        int position = source.position();
        try {
            source.position(0);
            source.limit(endPos);
            source.position(startPos);
            ByteBuffer target = source.slice();
            target.order(source.order());
            ByteBuffer byteBuffer = target;
            return byteBuffer;
        }
        finally {
            source.limit(limit);
            source.position(position);
        }
    }

    public static ByteBuffer reverseSliceBuffer(ByteBuffer hapSigningBlock, int startPos, int endPos) {
        ByteBuffer header = HapUtils.sliceBuffer(hapSigningBlock, startPos, endPos);
        byte[] signatureBlockBytes = new byte[header.capacity()];
        header.get(signatureBlockBytes, 0, signatureBlockBytes.length);
        header = ByteBuffer.wrap(Arrays.reverse(signatureBlockBytes));
        return header;
    }

    public static void checkBufferLittleEndian(ByteBuffer buffer) {
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return;
        }
        throw new IllegalArgumentException("ByteBuffer is not little endian");
    }

    public static byte[] encodeListOfPairsToByteArray(List<Pair<Integer, byte[]>> pairList) {
        int encodeSize = 0;
        encodeSize += 8;
        for (Pair<Integer, byte[]> pair : pairList) {
            encodeSize += 12 + pair.getSecond().length;
        }
        ByteBuffer encodeBytes = ByteBuffer.allocate(encodeSize);
        encodeBytes.order(ByteOrder.LITTLE_ENDIAN);
        encodeBytes.putInt(2);
        encodeBytes.putInt(1);
        for (Pair<Integer, byte[]> pair : pairList) {
            byte[] second = pair.getSecond();
            encodeBytes.putInt(8 + second.length);
            encodeBytes.putInt(pair.getFirst());
            encodeBytes.putInt(second.length);
            encodeBytes.put(second);
        }
        return encodeBytes.array();
    }

    public static String toHex(byte[] value, String separator) {
        StringBuilder sb = new StringBuilder(value.length * 2);
        String useSeparator = separator == null ? "" : separator;
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            int hi = (value[i] & 0xFF) >>> 4;
            int lo = value[i] & 0xF;
            sb.append(HEX_CHAR_ARRAY[hi]).append(HEX_CHAR_ARRAY[lo]);
            if (i == len - 1) continue;
            sb.append(useSeparator);
        }
        return sb.toString();
    }

    public static SignerInfo tanslateSignerInfo(SignerInfo signerInfo) {
        AlgorithmId algorithmId;
        if (null == signerInfo || (algorithmId = signerInfo.getDigestEncryptionAlgorithmId()) == null) {
            return signerInfo;
        }
        ObjectIdentifier oid = algorithmId.getOID();
        if (oid != null && AlgorithmIdExt.SHA_WITH_RSA_ENCRYPTION_PSS_OID.equals(oid)) {
            return new SignerInfoExt(signerInfo, new AlgorithmId(AlgorithmIdExt.SHA_WITH_RSA_ENCRYPTION_PSS_OID));
        }
        return signerInfo;
    }
}

