/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.utils;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger(FileUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFileToDos(String file, DataOutputStream dos) {
        if (dos == null) {
            return false;
        }
        File src = new File(file);
        try (FileInputStream fileStream = new FileInputStream(src);){
            int temp;
            byte[] buf = new byte[4096];
            while ((temp = fileStream.read(buf)) > 0) {
                dos.write(buf, 0, temp);
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to get input stream object.");
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read or write data.");
        }
        return false;
    }

    public static boolean writeByteToDos(byte[] data, DataOutputStream dos) {
        try {
            dos.write(data);
        }
        catch (IOException e) {
            LOGGER.error("Faile to write data to output stream.");
            return false;
        }
        return true;
    }

    public static long getFileLen(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeByteToOutFile(byte[] signHeadByte, String outFile) {
        try (FileOutputStream ops = new FileOutputStream(outFile, true);){
            ((OutputStream)ops).write(signHeadByte, 0, signHeadByte.length);
            ops.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to get output stream object, outfile: " + outFile);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Failed to write data to ops, outfile: " + outFile);
        }
        return false;
    }
}

