/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.utils;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DigestUtils {
    private static final Logger LOGGER = LogManager.getLogger(DigestUtils.class);

    public static byte[] sha256Digest(byte[] inputContentArray) {
        byte[] sha2Array = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(inputContentArray);
            sha2Array = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("don't has SHA-256 Algorithm");
        }
        return sha2Array;
    }

    public static byte[] sha384Digest(byte[] inputContentArray) {
        byte[] sha2Array = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-384");
            md.update(inputContentArray);
            sha2Array = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("don't has SHA-384 Algorithm");
        }
        return sha2Array;
    }

    public static byte[] sha512Digest(byte[] inputContentArray) {
        byte[] sha2Array = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(inputContentArray);
            sha2Array = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("don't has SHA-512 Algorithm");
        }
        return sha2Array;
    }

    public static X509Certificate decodeBase64ToX509Certifate(String encodeString) {
        String header = "-----BEGIN CERTIFICATE-----\n";
        String tail = "-----END CERTIFICATE-----\n";
        byte[] certificateDatas = null;
        X509Certificate x509Certificate = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certificateDatas = encodeString.startsWith(header) && encodeString.endsWith(tail) ? encodeString.getBytes("UTF-8") : Base64.getUrlDecoder().decode(encodeString);
            Certificate obj = cf.generateCertificate(new ByteArrayInputStream(certificateDatas));
            if (!(obj instanceof X509Certificate)) {
                LOGGER.error("generateCertificate is not x509");
                return x509Certificate;
            }
            x509Certificate = (X509Certificate)obj;
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            LOGGER.error("Decode Base64 certificate failed!", (Throwable)e);
        }
        return x509Certificate;
    }

    public static X509CRL decodeBase64ToX509CRL(String encodeString) {
        byte[] certificateDatas = Base64.getUrlDecoder().decode(encodeString);
        X509CRL x509CRL = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CRL obj = cf.generateCRL(new ByteArrayInputStream(certificateDatas));
            if (!(obj instanceof X509CRL)) {
                LOGGER.error("generateCRL is not x509");
                return x509CRL;
            }
            x509CRL = (X509CRL)obj;
        }
        catch (CRLException | CertificateException e) {
            LOGGER.error("Decode Base64 crl failed!");
        }
        return x509CRL;
    }
}

