/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.signtool;

import com.huawei.signclient.hap.exception.ReadHelpException;
import com.huawei.signclient.hap.factory.IProviderFactory;
import com.huawei.signclient.hap.factory.LocalJKSSignProviderFactory;
import com.huawei.signclient.hap.factory.RemoteSignProviderFactory;
import com.huawei.signclient.hap.provider.RemoteSignProvider;
import com.huawei.signclient.hap.provider.SignProvider;
import com.huawei.signclient.hap.utils.ParamProcessUtil;
import com.huawei.signclient.hap.verify.VerifyHap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HapSignTool {
    private static final Logger LOG = LogManager.getLogger(HapSignTool.class);
    private static final String HAP_SIGN_TOOL_VERSION = "V2.0-2020.09.10";
    private static final String REMOTE_RESIGN_MODE = "resign";
    private static final String REMOTE_SIGN_MODE = "remote";
    private static final String LOCAL_FILE_SIGN_MODE = "localfile";
    private static final String LOCAL_JKS_SIGN_MODE = "localjks";
    private static final String LOCAL_JKS_SIGN_BIN_MODE = "binlocaljks";
    private static final String REMOTE_SIGN_BIN_MODE = "binremote";

    public static void main(String[] args) throws ReadHelpException {
        boolean result;
        if (args.length == 0 || "--help".equals(args[0]) || "-h".equals(args[0])) {
            HapSignTool.help();
            System.exit(1);
        }
        if ("--version".equals(args[0])) {
            HapSignTool.version();
            System.exit(1);
        }
        if (!(result = HapSignTool.processCmd(args))) {
            System.exit(1);
        }
    }

    private static boolean processCmd(String[] args) throws ReadHelpException {
        String cmd = args[0];
        boolean result = true;
        switch (cmd) {
            case "sign": {
                String[] parameters = Arrays.copyOfRange(args, 1, args.length);
                result = HapSignTool.sign(parameters);
                break;
            }
            case "verify": {
                String[] parameters = Arrays.copyOfRange(args, 1, args.length);
                result = HapSignTool.verify(parameters);
                break;
            }
            case "help": {
                HapSignTool.help();
                break;
            }
            case "version": {
                HapSignTool.version();
                break;
            }
            default: {
                LOG.error("Unsupported command!");
            }
        }
        return result;
    }

    public static void help() throws ReadHelpException {
        String page = "help.txt";
        ClassLoader hapSignToolClass = HapSignTool.class.getClassLoader();
        if (hapSignToolClass == null) {
            throw new ReadHelpException("load hapSignToolClass failed!");
        }
        try (InputStream inputStream = hapSignToolClass.getResourceAsStream(page);){
            byte[] helpData = new byte[inputStream.available()];
            String helpStr = new String(helpData, "UTF-8");
            LOG.info(helpStr);
        }
        catch (IOException e) {
            throw new ReadHelpException("Failed to read " + page + " resource", e);
        }
    }

    public static void version() {
        LOG.info("version: {}", (Object)HAP_SIGN_TOOL_VERSION);
    }

    public static boolean sign(String[] params) {
        String mode = ParamProcessUtil.getParamFromArgs(params, "mode");
        if (StringUtils.isEmpty(mode)) {
            LOG.error("Not find signature mode arguement!");
            return false;
        }
        LOG.info("Sign mode: {}", (Object)mode);
        IProviderFactory factory = null;
        if (mode.equalsIgnoreCase(REMOTE_SIGN_MODE)) {
            factory = new RemoteSignProviderFactory();
        } else if (mode.equalsIgnoreCase(LOCAL_JKS_SIGN_MODE)) {
            factory = new LocalJKSSignProviderFactory();
        } else {
            if (mode.equalsIgnoreCase(LOCAL_JKS_SIGN_BIN_MODE)) {
                SignProvider signProvider = new LocalJKSSignProviderFactory().getSignProvider();
                return signProvider.signBin(params);
            }
            if (mode.equalsIgnoreCase(REMOTE_SIGN_BIN_MODE)) {
                RemoteSignProvider signProvider = new RemoteSignProviderFactory().getSignProvider();
                return signProvider.signBin(params);
            }
            LOG.info("Unsupported sign mode!");
            return false;
        }
        SignProvider signProvider = factory.getSignProvider();
        return signProvider.sign(params);
    }

    public static boolean verify(String[] params) {
        VerifyHap hapVerify = new VerifyHap();
        return hapVerify.verify(params);
    }
}

