/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.sign;

import com.huawei.signclient.hap.config.RemoteReSignerConfig;
import com.huawei.signclient.hap.config.RemoteSignerConfig;
import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.entity.Pair;
import com.huawei.signclient.hap.entity.SigningBlock;
import com.huawei.signclient.hap.exception.HapParseException;
import com.huawei.signclient.hap.exception.SignatureException;
import com.huawei.signclient.hap.ext.PKCS7Ext;
import com.huawei.signclient.hap.sign.ContentDigestAlgorithm;
import com.huawei.signclient.hap.sign.SignatureAlgorithm;
import com.huawei.signclient.hap.utils.HapUtils;
import com.huawei.signclient.hap.utils.ZipUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public abstract class SignHapV2 {
    private static final Logger LOGGER = LogManager.getLogger(SignHapV2.class);
    private static final int HAP_SIGN_SCHEME_VERSION = 2;
    private static final int STORED_ENTRY_SO_ALIGNMENT = 4096;

    private SignHapV2() {
    }

    public static List<String> getEntryNamesFromHap(JarFile hap) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> e = hap.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            result.add(entry.getName());
        }
        return result;
    }

    private static int getStoredEntryDataAlignment(String entryName, int defaultAlignment) {
        if (defaultAlignment <= 0) {
            return 0;
        }
        if (entryName.endsWith(".so")) {
            return 4096;
        }
        return defaultAlignment;
    }

    public static void copyFiles(List<String> entryNames, JarFile in, JarOutputStream out, long timestamp, int defaultAlignment) throws IOException {
        Collections.sort(entryNames);
        long offset = 4L;
        for (String name : entryNames) {
            JarEntry inEntry = in.getJarEntry(name);
            if (inEntry.getMethod() != 0) continue;
            offset += 30L;
            JarEntry outEntry = new JarEntry(inEntry);
            outEntry.setTime(timestamp);
            outEntry.setComment(null);
            outEntry.setExtra(null);
            int alignment = SignHapV2.getStoredEntryDataAlignment(name, defaultAlignment);
            if (alignment > 0 && (offset += (long)outEntry.getName().length()) % (long)alignment != 0L) {
                int needed = alignment - (int)(offset % (long)alignment);
                outEntry.setExtra(new byte[needed]);
                offset += (long)needed;
            }
            out.putNextEntry(outEntry);
            byte[] buffer = new byte[4096];
            InputStream data = in.getInputStream(inEntry);
            Throwable throwable = null;
            try {
                int num;
                while ((num = data.read(buffer)) > 0) {
                    out.write(buffer, 0, num);
                    offset += (long)num;
                }
                out.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (data == null) continue;
                if (throwable != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                data.close();
            }
        }
        SignHapV2.copyFilesExceptStoredFile(entryNames, in, out, timestamp);
    }

    private static void copyFilesExceptStoredFile(List<String> entryNames, JarFile in, JarOutputStream out, long timestamp) throws IOException {
        byte[] buffer = new byte[4096];
        for (String name : entryNames) {
            JarEntry inEntry = in.getJarEntry(name);
            if (inEntry.getMethod() == 0) continue;
            JarEntry outEntry = new JarEntry(name);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            InputStream data = in.getInputStream(inEntry);
            Throwable throwable = null;
            try {
                int num;
                while ((num = data.read(buffer)) > 0) {
                    out.write(buffer, 0, num);
                }
                out.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (data == null) continue;
                if (throwable != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                data.close();
            }
        }
    }

    public static ByteBuffer[] sign(ByteBuffer inputHap, SignerConfig signerConfig, List<SigningBlock> optionalBlocks) throws HapParseException, InvalidKeyException, SignatureException {
        inputHap.order(ByteOrder.LITTLE_ENDIAN);
        inputHap.clear();
        int eocdOffset = ZipUtils.findEocdInSearchBuffer(inputHap);
        if (eocdOffset == -1) {
            throw new HapParseException(20002, "Failed to locate EOCD in ZIP");
        }
        if (ZipUtils.checkZip64EoCDLocatorIsPresent(inputHap, eocdOffset)) {
            throw new HapParseException(20002, "ZIP64 format not supported");
        }
        inputHap.position(eocdOffset);
        long centralDirSizeLong = ZipUtils.getCentralDirectorySize(inputHap);
        if (centralDirSizeLong > Integer.MAX_VALUE) {
            throw new HapParseException(20002, "ZIP Central Directory size out of range: " + centralDirSizeLong);
        }
        int centralDirSize = (int)centralDirSizeLong;
        long centralDirOffsetLong = ZipUtils.getCentralDirectoryOffset(inputHap);
        if (centralDirOffsetLong > Integer.MAX_VALUE) {
            throw new HapParseException(20002, "ZIP Central Directory offset in file out of range: " + centralDirOffsetLong);
        }
        int centralDirOffset = (int)centralDirOffsetLong;
        SignHapV2.checkEocdOffsetIsRight(centralDirOffset, centralDirSize, eocdOffset);
        inputHap.clear();
        ByteBuffer beforeCentralDir = HapUtils.sliceBuffer(inputHap, centralDirOffset);
        ByteBuffer centralDir = HapUtils.sliceBuffer(inputHap, eocdOffset - centralDirOffset);
        byte[] eocdBytes = new byte[inputHap.remaining()];
        inputHap.get(eocdBytes);
        ByteBuffer eocd = ByteBuffer.wrap(eocdBytes);
        eocd.order(inputHap.order());
        HashSet<ContentDigestAlgorithm> contentDigestAlgorithms = new HashSet<ContentDigestAlgorithm>();
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            contentDigestAlgorithms.add(signatureAlgorithm.getContentDigestAlgorithm());
        }
        ByteBuffer[] hapData = new ByteBuffer[]{beforeCentralDir, centralDir, eocd};
        byte[] hapSignatureBytes = SignHapV2.getHapSigningBlock(contentDigestAlgorithms, optionalBlocks, signerConfig, hapData);
        ByteBuffer hapSigningBlock = ByteBuffer.wrap(hapSignatureBytes);
        eocd.clear();
        ZipUtils.setCentralDirectoryOffset(eocd, centralDirOffset += hapSigningBlock.remaining());
        beforeCentralDir.clear();
        centralDir.clear();
        eocd.clear();
        return new ByteBuffer[]{beforeCentralDir, hapSigningBlock, centralDir, eocd};
    }

    private static byte[] getHapSigningBlock(Set<ContentDigestAlgorithm> contentDigestAlgorithms, List<SigningBlock> optionalBlocks, SignerConfig signerConfig, ByteBuffer[] hapData) throws SignatureException {
        byte[] hapSignatureBytes = null;
        try {
            Map<ContentDigestAlgorithm, byte[]> contentDigests = HapUtils.computeDigests(contentDigestAlgorithms, hapData, optionalBlocks);
            hapSignatureBytes = SignHapV2.generateHapSigningBlock(signerConfig, contentDigests, optionalBlocks);
        }
        catch (DigestException e) {
            throw new SignatureException("Failed to compute digests of HAP", e);
        }
        return hapSignatureBytes;
    }

    private static void checkEocdOffsetIsRight(int centralDirOffset, int centralDirSize, int eocdOffset) throws HapParseException {
        int expectedEocdOffset = centralDirOffset + centralDirSize;
        if (expectedEocdOffset < centralDirOffset) {
            throw new HapParseException(20002, "ZIP Central Directory extent too large. Offset: " + centralDirOffset + ", size: " + centralDirSize);
        }
        if (eocdOffset != expectedEocdOffset) {
            throw new HapParseException(20002, "ZIP Central Directory not immeiately followed by ZIP End of Central Directory. CD end: " + expectedEocdOffset + ", EoCD start: " + eocdOffset);
        }
    }

    public static byte[] signBin(byte[] unsignedHapDigest, SignerConfig signerConfig) throws SignatureException {
        if (unsignedHapDigest == null) {
            throw new SignatureException("unsigned data is null");
        }
        ArrayList<SignerInfo> signerInfoLst = new ArrayList<SignerInfo>();
        ArrayList<AlgorithmId> algorithmIdLst = new ArrayList<AlgorithmId>();
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            try {
                SignerInfo signerInfo = SignHapV2.getSignerInfo(signatureAlgorithm, unsignedHapDigest, signerConfig);
                if (signerInfo != null) {
                    algorithmIdLst.add(signerInfo.getDigestAlgorithmId());
                    signerInfoLst.add(signerInfo);
                }
                LOGGER.info("Add sign data in sign info list success.");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SignatureException("Invalid algorithm: " + signatureAlgorithm.getContentDigestAlgorithm().name(), e);
            }
            catch (IllegalArgumentException e) {
                throw new SignatureException("sign IllegalArgumentException" + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new SignatureException("sign IOException" + e.getMessage(), e);
            }
        }
        return SignHapV2.packagePKCS7(signerConfig, signerInfoLst, algorithmIdLst, unsignedHapDigest);
    }

    private static SignerInfo getSignerInfo(SignatureAlgorithm signatureAlgorithm, byte[] unsignedHapDigest, SignerConfig signerConfig) throws SignatureException, IOException, NoSuchAlgorithmException {
        Pair<String, ? extends AlgorithmParameterSpec> signatureParams = signatureAlgorithm.getSignatureAlgAndParams();
        ContentDigestAlgorithm contentDigestAlg = signatureAlgorithm.getContentDigestAlgorithm();
        String jcaSignatureAlg = signatureParams.getFirst();
        byte[] signatureBytes = null;
        PKCS9Attributes authed = null;
        ContentInfo cInfo = new ContentInfo(ContentInfo.DATA_OID, new DerValue(4, unsignedHapDigest));
        MessageDigest md = MessageDigest.getInstance(contentDigestAlg.name());
        byte[] digest = md.digest(cInfo.getContentBytes());
        authed = new PKCS9Attributes(new PKCS9Attribute[]{new PKCS9Attribute(PKCS9Attribute.SIGNING_TIME_OID, new Date()), new PKCS9Attribute(PKCS9Attribute.CONTENT_TYPE_OID, ContentInfo.DATA_OID), new PKCS9Attribute(PKCS9Attribute.MESSAGE_DIGEST_OID, digest)});
        signatureBytes = signerConfig.getSignature(authed.getDerEncoding(), jcaSignatureAlg, signatureParams.getSecond());
        if (signatureBytes == null) {
            throw new SignatureException("Generate signature bytes error");
        }
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        if (!SignHapV2.verifySignatureFromServer(signerConfig, signatureBytes, signatureAlgorithm.getSignatureAlgAndParams(), authed)) {
            throw new SignatureException("Signature did not verify");
        }
        return SignHapV2.createSignerInfo(signerConfig, signatureAlgorithm, authed, signatureBytes);
    }

    private static byte[] generateHapSigningBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests, List<SigningBlock> optionalBlocks) throws SignatureException {
        byte[] hapSignatureSchemeV2Block = SignHapV2.generateHapSignatureSchemeV2Block(signerConfig, contentDigests);
        return SignHapV2.generateHapSigningBlock(hapSignatureSchemeV2Block, optionalBlocks);
    }

    private static byte[] generateHapSigningBlock(byte[] hapSignatureSchemeBlock, List<SigningBlock> optionalBlocks) {
        long optionalBlockSize = 0L;
        for (SigningBlock optionalBlock : optionalBlocks) {
            optionalBlockSize += (long)optionalBlock.getLength();
        }
        long resultSize = (long)(12 * (optionalBlocks.size() + 1)) + optionalBlockSize + (long)hapSignatureSchemeBlock.length + 4L + 8L + 16L + 4L;
        if (resultSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HapSigningBlock out of range : " + resultSize);
        }
        ByteBuffer result = ByteBuffer.allocate((int)resultSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        HashMap<Integer, Integer> typeAndOffsetMap = new HashMap<Integer, Integer>();
        int currentOffset = 12 * (optionalBlocks.size() + 1);
        int currentOffsetInBlockValue = 0;
        int blockValueSizes = (int)(optionalBlockSize + (long)hapSignatureSchemeBlock.length);
        byte[] blockValues = new byte[blockValueSizes];
        for (SigningBlock optionalBlock : optionalBlocks) {
            System.arraycopy(optionalBlock.getValue(), 0, blockValues, currentOffsetInBlockValue, optionalBlock.getLength());
            typeAndOffsetMap.put(optionalBlock.getType(), currentOffset);
            currentOffset += optionalBlock.getLength();
            currentOffsetInBlockValue += optionalBlock.getLength();
        }
        System.arraycopy(hapSignatureSchemeBlock, 0, blockValues, currentOffsetInBlockValue, hapSignatureSchemeBlock.length);
        typeAndOffsetMap.put(0x20000000, currentOffset);
        int offset = 0;
        for (SigningBlock optionalBlock : optionalBlocks) {
            result.putInt(optionalBlock.getType());
            result.putInt(optionalBlock.getLength());
            offset = (Integer)typeAndOffsetMap.get(optionalBlock.getType());
            result.putInt(offset);
        }
        result.putInt(0x20000000);
        result.putInt(hapSignatureSchemeBlock.length);
        offset = (Integer)typeAndOffsetMap.get(0x20000000);
        result.putInt(offset);
        result.put(blockValues);
        result.putInt(optionalBlocks.size() + 1);
        result.putLong(resultSize);
        result.put(HapUtils.HAP_SIGNING_BLOCK_MAGIC);
        result.putInt(2);
        return result.array();
    }

    private static byte[] generateHapSignatureSchemeV2Block(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws SignatureException {
        byte[] signerBlock = null;
        try {
            signerBlock = SignHapV2.generateSignerBlock(signerConfig, contentDigests);
        }
        catch (SignatureException e) {
            throw new SignatureException("generate SignerBlock failed", e);
        }
        return signerBlock;
    }

    private static byte[] generateSignerBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws SignatureException {
        if (!(signerConfig instanceof RemoteSignerConfig) && !(signerConfig instanceof RemoteReSignerConfig) && signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>(signerConfig.signatureAlgorithms.size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] contentDigest = contentDigests.get((Object)contentDigestAlgorithm);
            if (contentDigest == null) {
                throw new SignatureException(contentDigestAlgorithm.getDigestAlgorithm() + " content digest for " + signatureAlgorithm.getSignatureAlgAndParams().getFirst() + " not computed");
            }
            digests.add(Pair.create(signatureAlgorithm.getId(), contentDigest));
        }
        byte[] unsignedHapDigest = HapUtils.encodeListOfPairsToByteArray(digests);
        ArrayList<SignerInfo> signerInfoLst = new ArrayList<SignerInfo>();
        ArrayList<AlgorithmId> algorithmIdLst = new ArrayList<AlgorithmId>();
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            try {
                SignerInfo signerInfo = SignHapV2.getSignerInfo(signatureAlgorithm, unsignedHapDigest, signerConfig);
                if (signerInfo == null) continue;
                algorithmIdLst.add(signerInfo.getDigestAlgorithmId());
                signerInfoLst.add(signerInfo);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new SignatureException("getSignerInfo failed", e);
            }
        }
        return SignHapV2.packagePKCS7(signerConfig, signerInfoLst, algorithmIdLst, unsignedHapDigest);
    }

    private static SignerInfo createSignerInfo(SignerConfig signerConfig, SignatureAlgorithm signatureAlgorithm, PKCS9Attributes authed, byte[] signedHapDigest) throws SignatureException {
        String digestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm().getDigestAlgorithm();
        try {
            X500Name x500name = new X500Name(signerConfig.certificates.get(0).getIssuerX500Principal().getName());
            BigInteger serialNumber = signerConfig.certificates.get(0).getSerialNumber();
            AlgorithmId alg = signatureAlgorithm.getAlgorithmId();
            SignerInfo signerInfo = new SignerInfo(x500name, serialNumber, AlgorithmId.get(digestAlgorithm), authed, alg, signedHapDigest, null);
            signerInfo = HapUtils.tanslateSignerInfo(signerInfo);
            return signerInfo;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new SignatureException("Generate signer info error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] packagePKCS7(SignerConfig signerConfig, List<SignerInfo> signerInfoLst, List<AlgorithmId> algorithmIdLst, byte[] unsignedHapDigest) throws SignatureException {
        X509Certificate[] certs = null;
        if (SignHapV2.checkListNotNullOrEmty(signerConfig.certificates)) {
            certs = new X509Certificate[signerConfig.certificates.size()];
            signerConfig.certificates.toArray(certs);
        }
        X509CRL[] crls = null;
        if (SignHapV2.checkListNotNullOrEmty(signerConfig.x509CRLs)) {
            crls = new X509CRL[signerConfig.x509CRLs.size()];
            signerConfig.x509CRLs.toArray(crls);
        }
        SignerInfo[] signerInfos = null;
        if (SignHapV2.checkListNotNullOrEmty(signerInfoLst)) {
            signerInfos = new SignerInfo[signerInfoLst.size()];
            signerInfoLst.toArray(signerInfos);
        }
        AlgorithmId[] digestAlgorithmIds = null;
        if (SignHapV2.checkListNotNullOrEmty(algorithmIdLst)) {
            digestAlgorithmIds = new AlgorithmId[algorithmIdLst.size()];
            algorithmIdLst.toArray(digestAlgorithmIds);
        }
        try (ByteArrayOutputStream outSream = new ByteArrayOutputStream();){
            ContentInfo contentInfo = new ContentInfo(ContentInfo.DATA_OID, new DerValue(4, unsignedHapDigest));
            PKCS7Ext pkcs7 = new PKCS7Ext(digestAlgorithmIds, contentInfo, certs, crls, signerInfos);
            if (((PKCS7)pkcs7).verify(unsignedHapDigest) == null) {
                LOGGER.error("Not verified");
                throw new SignatureException("Signature did not verify");
            }
            LOGGER.info("PKCS7 cms result verify success!");
            pkcs7.encodeSignedData(outSream);
            byte[] byArray = outSream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new SignatureException("encode PKCS cms data failed!", e);
        }
        catch (NoSuchAlgorithmException | java.security.SignatureException e) {
            throw new SignatureException("Signature did not verify", e);
        }
    }

    private static boolean checkListNotNullOrEmty(List<?> lists) {
        return lists != null && lists.size() > 0;
    }

    private static boolean verifySignatureFromServer(SignerConfig signerConfig, byte[] signatureBytes, Pair<String, AlgorithmParameterSpec> signAlgPair, PKCS9Attributes authed) throws SignatureException {
        try {
            PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
            Signature signature = Signature.getInstance(signAlgPair.getFirst());
            signature.initVerify(publicKey);
            if (signAlgPair.getSecond() != null) {
                signature.setParameter(signAlgPair.getSecond());
            }
            signature.update(authed.getDerEncoding());
            if (signatureBytes == null) {
                LOGGER.error("signatureBytes is null");
                throw new SignatureException("Signature did not verify");
            }
            if (!signature.verify(signatureBytes)) {
                throw new SignatureException("Signature did not verify");
            }
            return true;
        }
        catch (InvalidKeyException | java.security.SignatureException e) {
            LOGGER.error("Failed to verify generated signature using public key from certificate", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to verify generated " + signAlgPair.getFirst() + " signature using public key from certificate", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error("Failed to verify generated " + signAlgPair.getSecond() + " signature using public key from certificate", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("PKCS9 Attributes encode failed.", (Throwable)e);
        }
        return false;
    }
}

