/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.sign;

import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.entity.HwBlockHead;
import com.huawei.signclient.hap.entity.HwSignHead;
import com.huawei.signclient.hap.entity.SignContentInfo;
import com.huawei.signclient.hap.entity.SignatureBlockTypes;
import com.huawei.signclient.hap.exception.SignatureException;
import com.huawei.signclient.hap.sign.SignHapV2;
import com.huawei.signclient.hap.utils.FileUtils;
import com.huawei.signclient.hap.utils.HashUtils;
import com.huawei.signclient.hap.utils.ParamProcessUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignBin {
    private static final Logger LOGGER = LogManager.getLogger(SignBin.class);

    public static boolean sign(SignerConfig signerConfig, Map<String, String> singParams) {
        String profileSigned;
        String profileFile;
        String outputFile;
        String inputFile = singParams.get("inputFile");
        if (!SignBin.writeBlockDataToFile(inputFile, outputFile = singParams.get("outputFile"), profileFile = singParams.get("profile"), profileSigned = singParams.get("profileSigned"))) {
            LOGGER.error("The block head data made failed.");
            ParamProcessUtil.delDir(new File(outputFile));
            return false;
        }
        LOGGER.info("The block head data made success.");
        String signAlg = singParams.get("signAlg");
        if (!SignBin.writeSignDataToOutputFile(signerConfig, outputFile, signAlg)) {
            LOGGER.error("The sign data made failed.");
            ParamProcessUtil.delDir(new File(outputFile));
            return false;
        }
        LOGGER.info("The data signed success.");
        if (!SignBin.writeSignHeadDataToOutputFile(inputFile, outputFile)) {
            LOGGER.error("The sign head data made failed.");
            ParamProcessUtil.delDir(new File(outputFile));
            return false;
        }
        return true;
    }

    private static boolean writeBlockDataToFile(String inputFile, String outputFile, String profileFile, String profileSigned) {
        long profileDataLen;
        long binFileLen = FileUtils.getFileLen(inputFile);
        if (!SignBin.checkBinAndProfileLengthIsValid(binFileLen, profileDataLen = FileUtils.getFileLen(profileFile))) {
            LOGGER.error("file length is invalid, binFileLen: " + binFileLen + " profileDataLen: " + profileDataLen);
            return false;
        }
        long offset = binFileLen + (long)HwBlockHead.getBlockLen() + (long)HwBlockHead.getBlockLen();
        if (SignBin.isLongOverflowInteger(offset)) {
            LOGGER.error("The profile block head offset is overflow interger range, offset: " + offset);
            return false;
        }
        char isSigned = SignatureBlockTypes.getProfileBlockTypes(profileSigned);
        byte[] proBlockByte = HwBlockHead.getBlockHead(isSigned, '\u0000', (short)profileDataLen, (int)offset);
        if (SignBin.isLongOverflowInteger(offset += profileDataLen)) {
            LOGGER.error("The sign block head offset is overflow integer range, offset: " + offset);
            return false;
        }
        byte[] signBlockByte = HwBlockHead.getBlockHead('\u0000', '\u0000', (short)0, (int)offset);
        return SignBin.writeSignedBin(inputFile, proBlockByte, signBlockByte, profileFile, outputFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean writeSignedBin(String inputFile, byte[] proBlockByte, byte[] signBlockByte, String profileFile, String outputFile) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            if (!FileUtils.writeFileToDos(inputFile, dataOutputStream)) {
                LOGGER.error("Failed to write infomation of input file: " + inputFile + " to outputFile: " + outputFile);
                boolean bl = false;
                return bl;
            }
            if (!FileUtils.writeByteToDos(proBlockByte, dataOutputStream)) {
                LOGGER.error("Failed to write proBlockByte to output file: " + outputFile);
                boolean bl = false;
                return bl;
            }
            if (!FileUtils.writeByteToDos(signBlockByte, dataOutputStream)) {
                LOGGER.error("Failed to write binBlockByte to output file: " + outputFile);
                boolean bl = false;
                return bl;
            }
            if (FileUtils.writeFileToDos(profileFile, dataOutputStream)) return true;
            LOGGER.error("Failed to write profile file: " + profileFile);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("writeSignedBin failed.", (Throwable)e);
            return false;
        }
    }

    private static boolean checkBinAndProfileLengthIsValid(long binFileLen, long profileDataLen) {
        return binFileLen != -1L && profileDataLen != -1L && !SignBin.isLongOverflowShort(profileDataLen);
    }

    private static boolean writeSignHeadDataToOutputFile(String inputFile, String outputFile) {
        long size = FileUtils.getFileLen(outputFile) - FileUtils.getFileLen(inputFile) + 32L;
        if (SignBin.isLongOverflowInteger(size)) {
            LOGGER.error("File size is Overflow integer range.");
            return false;
        }
        HwSignHead signHeadData = new HwSignHead();
        byte[] signHeadByte = signHeadData.getSignHead((int)size);
        if (signHeadByte == null) {
            LOGGER.error("Failed to get sign head data.");
            return false;
        }
        return FileUtils.writeByteToOutFile(signHeadByte, outputFile);
    }

    private static boolean writeSignDataToOutputFile(SignerConfig signerConfig, String outputFile, String signAlg) {
        String alg = ParamProcessUtil.getSignatureAlgorithm(signAlg).getContentDigestAlgorithm().getDigestAlgorithm();
        byte[] data = HashUtils.getFileDigest(outputFile, alg);
        if (data == null) {
            LOGGER.error("getFileDigest failed.");
            return false;
        }
        byte[] outputChunk = null;
        SignContentInfo contentInfo = null;
        try {
            contentInfo = new SignContentInfo();
            contentInfo.addContentHashData('\u0000', '\u0088', (short)HashUtils.getHashAlgsId(alg), data.length, data);
            byte[] dig = contentInfo.getByteContent();
            outputChunk = SignHapV2.signBin(dig, signerConfig);
            return FileUtils.writeByteToOutFile(outputChunk, outputFile);
        }
        catch (SignatureException e) {
            LOGGER.error("Sign hap Lite failed.", (Throwable)e);
            return false;
        }
    }

    private static boolean isLongOverflowInteger(long num) {
        return num - (num & 0xFFFFFFFFL) != 0L;
    }

    private static boolean isLongOverflowShort(long num) {
        return num - (num & 0xFFFFL) != 0L;
    }
}

