/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.huawei.signclient.hap.api.ResignServer;
import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.entity.SigningBlock;
import com.huawei.signclient.hap.sign.SignBin;
import com.huawei.signclient.hap.sign.SignHapV2;
import com.huawei.signclient.hap.sign.SignatureAlgorithm;
import com.huawei.signclient.hap.utils.DigestUtils;
import com.huawei.signclient.hap.utils.EscapeCharacter;
import com.huawei.signclient.hap.utils.HapUtils;
import com.huawei.signclient.hap.utils.ParamProcessUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.security.pkcs.PKCS7;

public abstract class SignProvider {
    private static final Logger LOGGER = LogManager.getLogger(SignProvider.class);
    private static final List<String> VALID_SIGN_ALG_NAME = new ArrayList<String>();
    private static final List<String> PARAMETERS_NEED_ESCAPE = new ArrayList<String>();
    protected List<SigningBlock> optionalBlocks = new ArrayList<SigningBlock>();
    protected Map<String, String> inputParams = new HashMap<String, String>();
    protected Map<String, String> signParams = new HashMap<String, String>();
    protected ResignServer server = null;

    public void setResignServer(ResignServer server) {
        this.server = server;
    }

    private boolean loadOptionalBlocks() {
        boolean loadResult = true;
        String property = this.signParams.get("property");
        loadResult = this.loadOptionalBlock(property, 0x20000003);
        if (!loadResult) {
            LOGGER.error("Load blcokId: 536870915failed!");
            return false;
        }
        String profile = this.signParams.get("profile");
        loadResult = this.loadOptionalBlock(profile, 0x20000002);
        if (!loadResult) {
            LOGGER.error("Load blcokId: 536870914failed!");
            return false;
        }
        String proofOfRotation = this.signParams.get("proof");
        loadResult = this.loadOptionalBlock(proofOfRotation, 0x20000001);
        if (!loadResult) {
            LOGGER.error("Load blcokId: 536870913failed!");
            return false;
        }
        return true;
    }

    private boolean loadOptionalBlock(String file, int type) {
        if (!this.checkStringIsNotNullAndEmity(file)) {
            return true;
        }
        if (!this.checkFile(file)) {
            LOGGER.error("check file failed");
            return false;
        }
        try {
            byte[] optionalBlockBytes = HapUtils.readFileToByte(file);
            if (optionalBlockBytes == null || optionalBlockBytes.length <= 0) {
                LOGGER.error("Optional block is null!");
                return true;
            }
            this.optionalBlocks.add(new SigningBlock(type, optionalBlockBytes));
        }
        catch (IOException e) {
            LOGGER.error("read file error", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean checkFile(String filePath) {
        if (!this.checkStringIsNotNullAndEmity(filePath)) {
            LOGGER.error("fileName is null");
            return false;
        }
        File file = new File(filePath);
        if (!file.canRead()) {
            LOGGER.error(filePath + " not exist or can not read!");
            return false;
        }
        if (!file.isFile()) {
            LOGGER.error(filePath + " is not a file!");
            return false;
        }
        return true;
    }

    private boolean checkStringIsNotNullAndEmity(String str) {
        return str != null && !"".equals(str);
    }

    public List<X509Certificate> getPublicCerts() {
        return Collections.emptyList();
    }

    public X509CRL getCrl() {
        X509CRL ret = null;
        return ret;
    }

    public SignerConfig createV2SignerConfigs(List<X509Certificate> certificates, X509CRL crl) throws InvalidKeyException {
        SignerConfig signerConfig = new SignerConfig();
        signerConfig.fillParameters(this.signParams);
        signerConfig.certificates = certificates;
        if (crl != null) {
            signerConfig.x509CRLs = Collections.singletonList(crl);
        }
        ArrayList<SignatureAlgorithm> signatureAlgorithms = new ArrayList<SignatureAlgorithm>();
        signatureAlgorithms.add(ParamProcessUtil.getSignatureAlgorithm(this.signParams.get("signAlg")));
        signerConfig.signatureAlgorithms = signatureAlgorithms;
        return signerConfig;
    }

    private boolean checkLiteParams(String[] params) {
        String[] paramFileds = new String[]{"profileSigned"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        boolean checkResult = true;
        for (String paramKey : this.inputParams.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            this.signParams.put(paramKey, this.inputParams.get(paramKey));
        }
        checkResult = checkResult && this.checkProfileSigned();
        return checkResult;
    }

    private boolean checkProfileSigned() {
        if (!this.signParams.containsKey("profileSigned")) {
            LOGGER.error("Missing parameter : profileSigned");
            return false;
        }
        return true;
    }

    public boolean signBin(String[] params) {
        SignerConfig signerConfig;
        Security.addProvider(new BouncyCastleProvider());
        if (!this.checkParams(params)) {
            LOGGER.error("Check parameters failed.");
            return false;
        }
        if (!this.checkLiteParams(params)) {
            LOGGER.error("Check profile signed failed.");
            return false;
        }
        if (!this.loadOptionalBlocks()) {
            LOGGER.error("Load optional blocks failed.");
            return false;
        }
        List<X509Certificate> publicCert = this.getPublicCerts();
        X509CRL crl = this.getCrl();
        try {
            signerConfig = this.createV2SignerConfigs(publicCert, crl);
        }
        catch (InvalidKeyException e) {
            LOGGER.error("create v2 signer configs failed.", (Throwable)e);
            return false;
        }
        if (!SignBin.sign(signerConfig, this.signParams)) {
            LOGGER.error("The sign head data made failed.");
            return false;
        }
        LOGGER.info("Sign success");
        return true;
    }

    public boolean sign(String[] params) {
        Security.addProvider(new BouncyCastleProvider());
        if (!this.checkParams(params)) {
            LOGGER.error("Check parameters failed!");
            return false;
        }
        List<X509Certificate> publicCerts = this.getPublicCerts();
        if (!this.loadOptionalBlocks()) {
            LOGGER.error("Load optional blocks failed!");
            return false;
        }
        String inputFilename = this.signParams.get("inputFile");
        String outputFilename = this.signParams.get("outputFile");
        boolean result = false;
        try (JarFile inputJar = new JarFile(new File(inputFilename), false);
             FileOutputStream outputFile = new FileOutputStream(outputFilename);
             ByteArrayOutputStream signedHapBuf = new ByteArrayOutputStream();
             JarOutputStream outputJar = new JarOutputStream(signedHapBuf);){
            ByteBuffer[] outputChunks;
            long timestamp = 1230768000000L;
            timestamp -= (long)TimeZone.getDefault().getOffset(timestamp);
            outputJar.setLevel(9);
            List<String> entryNames = SignHapV2.getEntryNamesFromHap(inputJar);
            int alignment = Integer.parseInt(this.signParams.get("a"));
            SignHapV2.copyFiles(entryNames, inputJar, outputJar, timestamp, alignment);
            outputJar.close();
            ByteBuffer hapContent = ByteBuffer.wrap(signedHapBuf.toByteArray());
            signedHapBuf.reset();
            X509CRL crl = this.getCrl();
            SignerConfig signerConfig = this.createV2SignerConfigs(publicCerts, crl);
            for (ByteBuffer outputChunk : outputChunks = SignHapV2.sign(hapContent, signerConfig, this.optionalBlocks)) {
                outputFile.write(outputChunk.array(), outputChunk.arrayOffset() + outputChunk.position(), outputChunk.remaining());
                outputChunk.position(outputChunk.limit());
            }
            result = true;
            LOGGER.info("sign success");
        }
        catch (com.huawei.signclient.hap.exception.SignatureException | IOException | GeneralSecurityException e) {
            LOGGER.error("sign failed.", (Throwable)e);
            ParamProcessUtil.delDir(new File(outputFilename));
            result = false;
        }
        return result;
    }

    public boolean checkPrivateKeyPath() {
        if (!this.signParams.containsKey("privatekey")) {
            LOGGER.error("Missing parameter : privatekey");
            return false;
        }
        return true;
    }

    public boolean checkInputFile() {
        if (!this.signParams.containsKey("inputFile")) {
            LOGGER.error("Missing parameter : inputFile");
            return false;
        }
        return true;
    }

    public boolean checkSignatureAlg() {
        if (!this.signParams.containsKey("signAlg")) {
            LOGGER.error("Missing parameter : signAlg");
            return false;
        }
        String signAlg = this.signParams.get("signAlg").trim();
        for (String validAlg : VALID_SIGN_ALG_NAME) {
            if (!validAlg.equals(signAlg)) continue;
            return true;
        }
        LOGGER.error("Unsupport signature algorithm :" + signAlg);
        return false;
    }

    public boolean checkOutputFile() {
        if (!this.signParams.containsKey("outputFile")) {
            LOGGER.error("Missing parameter : outputFile");
            return false;
        }
        return true;
    }

    public boolean checkProfile() {
        if (!this.signParams.containsKey("profile")) {
            LOGGER.error("Missing parameter : profile");
            return false;
        }
        return true;
    }

    public boolean checkSignAlignment() {
        if (!this.signParams.containsKey("a")) {
            this.signParams.put("a", "4");
        }
        return true;
    }

    protected String getDevelopmentCertificate(JsonObject buildInfoObject) {
        String developmentCertElememt = "development-certificate";
        return this.getCertificateCNFromProfile(buildInfoObject, developmentCertElememt);
    }

    protected String getReleaseCertificate(JsonObject buildInfoObject) {
        String distributeCertElememt = "distribution-certificate";
        return this.getCertificateCNFromProfile(buildInfoObject, distributeCertElememt);
    }

    private String getCertificateCNFromProfile(JsonObject buildInfoObject, String certificateType) {
        String[] arrayDN;
        String distributeCertificate = buildInfoObject.get(certificateType).getAsString();
        X509Certificate distributeX509Certificate = DigestUtils.decodeBase64ToX509Certifate(distributeCertificate);
        if (distributeX509Certificate == null) {
            return "";
        }
        String valueOfDN = distributeX509Certificate.getSubjectDN().toString();
        valueOfDN = valueOfDN.replaceAll("\"", "");
        for (String element : arrayDN = valueOfDN.split(",")) {
            if (!element.trim().startsWith("CN=")) continue;
            LOGGER.info(element);
            return element.split("=")[1];
        }
        return "";
    }

    public boolean checkKeyAndProfileValid() {
        String profileFilePath = this.inputParams.get("profile");
        try {
            byte[] profile = FileUtils.readFileToByteArray(new File(profileFilePath));
            PKCS7 pkcs7 = new PKCS7(profile);
            if (pkcs7.verify() == null) {
                LOGGER.error("Verify profile pkcs7 failed!");
                return false;
            }
            String content = new String(pkcs7.getContentInfo().getContentBytes(), "utf8");
            JsonElement parser = new JsonParser().parse(content);
            JsonObject profileJson = parser.getAsJsonObject();
            return this.checkProfileJson(profileJson);
        }
        catch (IOException e) {
            LOGGER.error("Read profile error!", (Throwable)e);
        }
        catch (NoSuchAlgorithmException | SignatureException e) {
            LOGGER.error("Verify pkcs7 error!", (Throwable)e);
        }
        return false;
    }

    private boolean checkProfileJson(JsonObject profileJson) {
        String profileTypeKey = "type";
        String profileType = profileJson.get(profileTypeKey).getAsString();
        if (profileType == null || profileType.length() == 0) {
            LOGGER.error("Get profile type error!");
            return false;
        }
        String buildInfoMember = "bundle-info";
        JsonObject buildInfoObject = profileJson.getAsJsonObject(buildInfoMember);
        String profileDN = "";
        if (profileType.equalsIgnoreCase("release")) {
            profileDN = this.getReleaseCertificate(buildInfoObject);
        } else if (profileType.equalsIgnoreCase("debug")) {
            profileDN = this.getDevelopmentCertificate(buildInfoObject);
        } else {
            LOGGER.error("Unsupported profile type!");
            return false;
        }
        return !profileDN.isEmpty();
    }

    public boolean checkParams(String[] params) {
        for (int i = 0; i < params.length; i += 2) {
            if (!params[i].startsWith("-")) {
                LOGGER.error("Invalid parameter format: " + params[i]);
                return false;
            }
            String paramName = params[i].substring(1);
            String paramValue = this.getParamValue(paramName, params[i + 1]);
            this.inputParams.put(paramName, paramValue);
        }
        String[] paramFileds = new String[]{"a", "signAlg", "inputFile", "outputFile", "privatekey", "profile", "proof", "property", "signServer"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        for (String paramKey : this.inputParams.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            this.signParams.put(paramKey, this.inputParams.get(paramKey));
        }
        boolean checkResult = this.checkPrivateKeyPath();
        checkResult = checkResult && this.checkSignatureAlg();
        checkResult = checkResult && this.checkInputFile();
        checkResult = checkResult && this.checkOutputFile();
        checkResult = checkResult && this.checkProfile();
        checkResult = checkResult && this.checkSignAlignment();
        checkResult = checkResult && this.checkKeyAndProfileValid();
        return checkResult;
    }

    private String getParamValue(String paramName, String paramValue) {
        for (String name : PARAMETERS_NEED_ESCAPE) {
            if (!name.equals(paramName)) continue;
            return EscapeCharacter.unescape(paramValue);
        }
        return paramValue;
    }

    public boolean checkResignParams(String[] params) {
        for (int i = 0; i < params.length; i += 2) {
            if (!params[i].startsWith("-")) {
                LOGGER.error("Invalid parameter format: " + params[i]);
                return false;
            }
            String paramName = params[i].substring(1);
            String paramValue = params[i + 1];
            this.inputParams.put(paramName, paramValue);
        }
        String[] paramFileds = new String[]{"profileSigned", "signAlg", "inputFile", "outputFile", "profile"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        for (String paramKey : this.inputParams.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            this.signParams.put(paramKey, this.inputParams.get(paramKey));
        }
        boolean checkResult = this.checkSignatureAlg();
        checkResult = checkResult && this.checkInputFile();
        checkResult = checkResult && this.checkOutputFile();
        checkResult = checkResult && this.checkProfile();
        checkResult = checkResult && this.checkProfileSigned();
        checkResult = checkResult && this.checkSignAlignment();
        return checkResult;
    }

    static {
        VALID_SIGN_ALG_NAME.add("SHA256withECDSA");
        VALID_SIGN_ALG_NAME.add("SHA384withECDSA");
        VALID_SIGN_ALG_NAME.add("SHA512withECDSA");
        VALID_SIGN_ALG_NAME.add("SHA256withRSA/PSS");
        VALID_SIGN_ALG_NAME.add("SHA384withRSA/PSS");
        VALID_SIGN_ALG_NAME.add("SHA512withRSA/PSS");
        VALID_SIGN_ALG_NAME.add("SHA512withRSA");
        PARAMETERS_NEED_ESCAPE.add("password");
        PARAMETERS_NEED_ESCAPE.add("keystorepasswd");
        PARAMETERS_NEED_ESCAPE.add("keyaliaspasswd");
    }
}

