/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.provider;

import com.huawei.signclient.hap.config.RemoteSignerConfig;
import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.provider.SignProvider;
import com.huawei.signclient.hap.sign.SignatureAlgorithm;
import com.huawei.signclient.hap.utils.ParamProcessUtil;
import java.security.InvalidKeyException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteSignProvider
extends SignProvider {
    private static final Logger LOGGER = LogManager.getLogger(RemoteSignProvider.class);

    @Override
    public SignerConfig createV2SignerConfigs(List<X509Certificate> certificates, X509CRL crl) throws InvalidKeyException {
        RemoteSignerConfig signerConfig = new RemoteSignerConfig();
        signerConfig.fillParameters(this.signParams);
        signerConfig.certificates = certificates;
        if (null != crl) {
            signerConfig.x509CRLs = Collections.singletonList(crl);
        }
        ArrayList<SignatureAlgorithm> signatureAlgorithms = new ArrayList<SignatureAlgorithm>();
        signatureAlgorithms.add(ParamProcessUtil.getSignatureAlgorithm((String)this.signParams.get("signAlg")));
        signerConfig.signatureAlgorithms = signatureAlgorithms;
        return signerConfig;
    }

    public boolean checkUsername() {
        String domainUser;
        if (!this.signParams.containsKey("username")) {
            LOGGER.error("Missing parameter : username");
            return false;
        }
        Pattern domainNumPatter = Pattern.compile("^[a-zA-Z]+[0-9]+$");
        if (!domainNumPatter.matcher(domainUser = (String)this.signParams.get("username")).matches()) {
            LOGGER.error("the domainUser is not correct");
            return false;
        }
        return true;
    }

    public boolean checkPassword() {
        if (!this.signParams.containsKey("password")) {
            LOGGER.error("Missing parameter : password");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkParams(String[] params) {
        boolean checkResult = super.checkParams(params);
        String[] paramFileds = new String[]{"username", "password", "privatekey"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        for (String paramKey : this.inputParams.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            this.signParams.put(paramKey, this.inputParams.get(paramKey));
        }
        checkResult = checkResult && this.checkUsername();
        checkResult = checkResult && this.checkPassword();
        return checkResult;
    }
}

