/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.provider;

import com.huawei.signclient.hap.config.LocalFileSignerConfig;
import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.provider.SignProvider;
import com.huawei.signclient.hap.utils.ParamProcessUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalFileSignProvider
extends SignProvider {
    private static final Logger LOGGER = LogManager.getLogger(LocalFileSignProvider.class);

    @Override
    public boolean checkParams(String[] params) {
        boolean checkResult = super.checkParams(params);
        String[] paramFileds = new String[]{"certpath"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        for (String paramKey : this.inputParams.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            this.signParams.put(paramKey, this.inputParams.get(paramKey));
        }
        checkResult = checkResult && this.checkPrivateKeyPath();
        checkResult = checkResult && this.checkPublicKeyPath();
        return checkResult;
    }

    @Override
    public SignerConfig createV2SignerConfigs(List<X509Certificate> certificates, X509CRL crl) throws InvalidKeyException {
        LocalFileSignerConfig signerConfig = new LocalFileSignerConfig(super.createV2SignerConfigs(certificates, crl));
        return signerConfig;
    }

    @Override
    public List<X509Certificate> getPublicCerts() {
        ArrayList<? extends Certificate> certs = null;
        String publicCertsFile = (String)this.signParams.get("certpath");
        try (FileInputStream fileInputStream = new FileInputStream(publicCertsFile);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = cf.generateCertificates(fileInputStream);
            if (certificates != null && certificates.size() > 0) {
                certs = new ArrayList<Certificate>(certificates);
            }
        }
        catch (CertificateException e) {
            LOGGER.error("Get public certs failed!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found");
        }
        catch (IOException e) {
            LOGGER.error("open file failed!", (Throwable)e);
        }
        return certs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X509CRL getCrl() {
        X509CRL crl = null;
        String crlPath = (String)this.signParams.get("crl");
        if (crlPath == null) return crl;
        if ("".equals(crlPath)) {
            return crl;
        }
        try (FileInputStream input = new FileInputStream(new File(crlPath));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CRL baseCrl = cf.generateCRL(input);
            if (!(baseCrl instanceof X509CRL)) {
                LOGGER.error("crl is not X509CRL");
                X509CRL x509CRL = crl;
                return x509CRL;
            }
            crl = (X509CRL)baseCrl;
            return crl;
        }
        catch (IOException e) {
            LOGGER.error("read CRL File has IOException!");
            return null;
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Generate x509 CRL failed!");
            return null;
        }
    }

    @Override
    public boolean checkPrivateKeyPath() {
        if (!this.signParams.containsKey("privatekey")) {
            LOGGER.error("Missing parameter : privatekey");
            return false;
        }
        String privateKeyPath = (String)this.signParams.get("privatekey");
        if (!this.checkFile(privateKeyPath)) {
            LOGGER.error("check file failed");
            return false;
        }
        return true;
    }

    private boolean checkPublicKeyPath() {
        if (!this.signParams.containsKey("certpath")) {
            LOGGER.error("Missing parameter : certpath");
            return false;
        }
        String publicCertFile = (String)this.signParams.get("certpath");
        if (!this.checkFile(publicCertFile)) {
            LOGGER.error("check file failed");
            return false;
        }
        return true;
    }
}

