/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.ext;

import com.huawei.signclient.hap.ext.AlgorithmIdExt;
import com.huawei.signclient.hap.sign.SignatureAlgorithm;
import java.io.IOException;
import java.security.CryptoPrimitive;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.ConstraintsParameters;
import sun.security.util.DerInputStream;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.KeyUsageExtension;

public class SignerInfoExt
extends SignerInfo {
    private static final Logger LOGGER = LogManager.getLogger(SignerInfoExt.class);
    private static final DisabledAlgorithmConstraints JAR_DISABLED_CHECK = new DisabledAlgorithmConstraints("jdk.jar.disabledAlgorithms");
    private static final Set<CryptoPrimitive> SIG_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final List<ObjectIdentifier> VALID_ALGORITHM_IDS = new ArrayList<ObjectIdentifier>();

    public SignerInfoExt(DerInputStream paramDerInputStream) throws IOException, ParsingException {
        super(paramDerInputStream);
    }

    public SignerInfoExt(SignerInfo signerInfo) {
        super(signerInfo.getIssuerName(), signerInfo.getCertificateSerialNumber(), signerInfo.getDigestAlgorithmId(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithmId(), signerInfo.getEncryptedDigest(), signerInfo.getUnauthenticatedAttributes());
    }

    public SignerInfoExt(SignerInfo signerInfo, AlgorithmId digestEncryptionAlgorithmId) {
        super(signerInfo.getIssuerName(), signerInfo.getCertificateSerialNumber(), signerInfo.getDigestAlgorithmId(), signerInfo.getAuthenticatedAttributes(), digestEncryptionAlgorithmId, signerInfo.getEncryptedDigest(), signerInfo.getUnauthenticatedAttributes());
    }

    public SignerInfoExt verifyPss(PKCS7 paramPKCS7, byte[] paramArrayOfByte, ObjectIdentifier contentType) throws NoSuchAlgorithmException, SignatureException {
        SignerInfoExt ret = null;
        try {
            ContentInfo localContentInfo = paramPKCS7.getContentInfo();
            byte[] contentByte = paramArrayOfByte;
            if (contentByte == null) {
                contentByte = localContentInfo.getContentBytes();
            }
            Timestamp localTimestamp = this.getSignerInfoTimestamp();
            ConstraintsParameters localConstraintsParameters = new ConstraintsParameters(localTimestamp);
            String digestAlgorithmName = this.getDigestAlgorithmId().getName();
            byte[] dataUseSign = contentByte;
            if (this.getAuthenticatedAttributes() != null) {
                if (!this.checkAuthenticatedAttributes(contentType, digestAlgorithmName, localConstraintsParameters, contentByte)) {
                    LOGGER.error("checkAuthenticatedAttributes failed");
                    return ret;
                }
                dataUseSign = this.getAuthenticatedAttributes().getDerEncoding();
            }
            String standardSignAlgorithmName = this.getPermitSignAlgorithmName(digestAlgorithmName, localConstraintsParameters);
            X509Certificate localX509Certificate = this.getCertificate(paramPKCS7);
            if (localX509Certificate == null) {
                LOGGER.error("getCertificate failed");
                return ret;
            }
            PublicKey localPublicKey = localX509Certificate.getPublicKey();
            this.checkCertAndPublickeyPermits(localPublicKey, localX509Certificate);
            this.checkKeyUsage(localX509Certificate);
            Signature signature = this.getSignatureProvider(standardSignAlgorithmName);
            if (signature == null) {
                LOGGER.error("getSignatureProvider failed");
                return ret;
            }
            signature.initVerify(localPublicKey);
            signature.update(dataUseSign);
            if (signature.verify(super.getEncryptedDigest())) {
                return this;
            }
        }
        catch (IOException e) {
            throw new SignatureException("IO error verifying signature:\n" + e.toString());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new SignatureException("InvalidKey: " + e.toString());
        }
        return ret;
    }

    private Timestamp getSignerInfoTimestamp() throws SignatureException {
        Timestamp localTimestamp = null;
        try {
            localTimestamp = this.getTimestamp();
        }
        catch (IOException | NoSuchAlgorithmException | SignatureException | CertificateException e) {
            throw new SignatureException("getTimestamp failed: " + e.toString());
        }
        return localTimestamp;
    }

    private boolean checkAuthenticatedAttributes(ObjectIdentifier contentType, String digestAlgorithmName, ConstraintsParameters localConstraintsParameters, byte[] paramArrayOfByte) throws SignatureException, NoSuchAlgorithmException {
        byte[] digest = null;
        try {
            Object contentTypeOId = this.getAuthenticatedAttributes().getAttributeValue(PKCS9Attribute.CONTENT_TYPE_OID);
            if (contentTypeOId == null || !contentTypeOId.equals(contentType)) {
                LOGGER.error("singerInfo has no CONTENT_TYPE_OID in AuthenticatedAttributes");
                return false;
            }
            Object objectDigest = this.getAuthenticatedAttributes().getAttributeValue(PKCS9Attribute.MESSAGE_DIGEST_OID);
            if (!(objectDigest instanceof byte[])) {
                LOGGER.error("objectDigest is not byte[]");
                return false;
            }
            digest = (byte[])objectDigest;
            JAR_DISABLED_CHECK.permits(digestAlgorithmName, localConstraintsParameters);
        }
        catch (IOException e) {
            throw new SignatureException("checkAuthenticatedAttributes failed: " + e.toString());
        }
        catch (CertPathValidatorException e) {
            throw new SignatureException("checkAuthenticatedAttributes JAR_DISABLED_CHECK failed: " + e.toString());
        }
        return this.checkContentInfoDigest(digestAlgorithmName, paramArrayOfByte, digest);
    }

    private boolean checkContentInfoDigest(String digestAlgorithmName, byte[] paramArrayOfByte, byte[] digest) throws NoSuchAlgorithmException {
        MessageDigest localObject3 = MessageDigest.getInstance(digestAlgorithmName);
        byte[] digestOfParamArrayOfByte = localObject3.digest(paramArrayOfByte);
        return Arrays.equals(digest, digestOfParamArrayOfByte);
    }

    private String getPermitSignAlgorithmName(String digestAlgorithmName, ConstraintsParameters localConstraintsParameters) throws SignatureException {
        String signAlgorithmName = this.getDigestEncryptionAlgorithmId().getName();
        String encryptionAlgorithmName = AlgorithmId.getEncAlgFromSigAlg((String)signAlgorithmName);
        if (encryptionAlgorithmName == null) {
            encryptionAlgorithmName = signAlgorithmName;
        }
        String standardSignAlgorithmName = AlgorithmId.makeSigAlg((String)digestAlgorithmName, (String)encryptionAlgorithmName);
        try {
            JAR_DISABLED_CHECK.permits(standardSignAlgorithmName, localConstraintsParameters);
        }
        catch (CertPathValidatorException e) {
            throw new SignatureException("getPermitSignAlgorithmName failed: " + e.toString());
        }
        return standardSignAlgorithmName;
    }

    private void checkCertAndPublickeyPermits(PublicKey publicKey, X509Certificate cert) throws SignatureException {
        if (!JAR_DISABLED_CHECK.permits(SIG_PRIMITIVE_SET, publicKey)) {
            throw new SignatureException("Public key check failed. Disabled key used: " + KeyUtil.getKeySize(publicKey) + " bit " + publicKey.getAlgorithm());
        }
        if (cert.hasUnsupportedCriticalExtension()) {
            throw new SignatureException("Certificate has unsupported critical extension(s)");
        }
    }

    private void checkKeyUsage(X509Certificate cert) throws SignatureException {
        boolean[] arrayOfBoolean = cert.getKeyUsage();
        if (arrayOfBoolean == null) {
            throw new SignatureException("has no keyUsage in certificate");
        }
        KeyUsageExtension keyUsageExtension = null;
        try {
            keyUsageExtension = new KeyUsageExtension(arrayOfBoolean);
        }
        catch (IOException e) {
            throw new SignatureException("Failed to parse keyUsage extension. " + e.toString());
        }
        try {
            boolean bool1 = keyUsageExtension.get("digital_signature");
            boolean bool2 = keyUsageExtension.get("non_repudiation");
            if (!bool1 && !bool2) {
                throw new SignatureException("Key usage restricted: cannot be used for digital signatures");
            }
        }
        catch (IOException e) {
            throw new SignatureException("Failed to get digital_signature or non_repudiation. " + e.toString());
        }
    }

    private Signature getSignatureProvider(String signAlgorithmName) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        ObjectIdentifier oid;
        Signature signature = null;
        AlgorithmId digestEncryptionAlgorithmId = this.getDigestEncryptionAlgorithmId();
        ObjectIdentifier objectIdentifier = oid = digestEncryptionAlgorithmId == null ? null : digestEncryptionAlgorithmId.getOID();
        if (!this.checkSignatureAlgorithmIsValid(oid)) {
            LOGGER.error("checkSignatureAlgorithmIsValid failed, signAlgorithmName: " + signAlgorithmName);
            return signature;
        }
        signature = Signature.getInstance(Objects.requireNonNull(digestEncryptionAlgorithmId).getName(), new BouncyCastleProvider());
        if (AlgorithmIdExt.SHA_WITH_RSA_ENCRYPTION_PSS_OID.equals(oid)) {
            String algName = this.getDigestAlgorithmId().getName();
            if (Objects.equals(algName, "SHA-256")) {
                signature.setParameter(SignatureAlgorithm.RSA_PSS_WITH_SHA256.getSignatureAlgAndParams().getSecond());
            }
            if (Objects.equals(algName, "SHA-384")) {
                signature.setParameter(SignatureAlgorithm.RSA_PSS_WITH_SHA384.getSignatureAlgAndParams().getSecond());
            }
            if (Objects.equals(algName, "SHA-512")) {
                signature.setParameter(SignatureAlgorithm.RSA_PSS_WITH_SHA512.getSignatureAlgAndParams().getSecond());
            }
        }
        return signature;
    }

    private boolean checkSignatureAlgorithmIsValid(ObjectIdentifier oid) {
        if (oid == null) {
            LOGGER.error("oid is not an Object.");
            return false;
        }
        for (ObjectIdentifier objectidentifier : VALID_ALGORITHM_IDS) {
            if (!objectidentifier.equals(oid)) continue;
            return true;
        }
        LOGGER.error("Unsupported signature algorithm.");
        return false;
    }

    static {
        VALID_ALGORITHM_IDS.add(AlgorithmId.sha256WithECDSA_oid);
        VALID_ALGORITHM_IDS.add(AlgorithmId.sha384WithECDSA_oid);
        VALID_ALGORITHM_IDS.add(AlgorithmId.sha512WithECDSA_oid);
        VALID_ALGORITHM_IDS.add(AlgorithmIdExt.SHA_WITH_RSA_ENCRYPTION_PSS_OID);
        VALID_ALGORITHM_IDS.add(AlgorithmId.sha512WithRSAEncryption_oid);
    }
}

