/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.entity;

import com.huawei.signclient.hap.entity.SignContentHash;
import com.huawei.signclient.hap.utils.ByteArrayUtils;
import java.util.ArrayList;

public class SignContentInfo {
    private char[] version = "1000".toCharArray();
    private short size = (short)8;
    private short numOfBlocks = 0;
    private ArrayList<SignContentHash> hashData = new ArrayList();

    public void addContentHashData(char type, char tag, short algId, int length, byte[] hash) {
        SignContentHash signInfo = new SignContentHash(type, tag, algId, length, hash);
        this.addHashData(signInfo);
    }

    private void addHashData(SignContentHash signInfo) {
        if (this.hashData != null) {
            this.hashData.add(signInfo);
            this.numOfBlocks = (short)(this.numOfBlocks + 1);
            this.size = (short)(this.size + signInfo.contentHashLen);
        }
    }

    public byte[] getByteContent() {
        byte[] ret = new byte[this.size];
        byte[] errorOutput = null;
        int index = 0;
        if ((index = ByteArrayUtils.insertCharToByteArray(ret, index, this.version)) < 0) {
            return errorOutput;
        }
        if ((index = ByteArrayUtils.insertShortToByteArray(ret, ret.length, index, this.size)) < 0) {
            return errorOutput;
        }
        if ((index = ByteArrayUtils.insertShortToByteArray(ret, ret.length, index, this.numOfBlocks)) < 0) {
            return errorOutput;
        }
        for (int i = 0; i < this.hashData.size(); ++i) {
            SignContentHash tmp = this.hashData.get(i);
            ret[index] = (byte)tmp.type;
            ret[++index] = (byte)tmp.tag;
            ++index;
            index = ByteArrayUtils.insertShortToByteArray(ret, ret.length, index, tmp.algId);
            index = ByteArrayUtils.insertIntToByteArray(ret, index, tmp.length);
            if ((index = ByteArrayUtils.insertByteToByteArray(ret, ret.length, index, tmp.hash, tmp.hash.length)) >= 0) continue;
            return errorOutput;
        }
        return ret;
    }
}

