/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.config;

import com.huawei.signclient.hap.api.ResignServer;
import com.huawei.signclient.hap.response.DataFromServer;
import com.huawei.signclient.hap.sign.SignatureAlgorithm;
import com.huawei.signclient.hap.utils.DigestUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignerConfig {
    private static final Logger LOGGER = LogManager.getLogger(SignerConfig.class);
    public List<X509Certificate> certificates;
    public List<X509CRL> x509CRLs;
    public List<SignatureAlgorithm> signatureAlgorithms;
    public Map<String, String> signParamMap = new HashMap<String, String>();
    public ResignServer server = null;

    public void fillParameters(Map<String, String> params) {
        this.signParamMap = params;
    }

    public byte[] getSignature(byte[] data, String signatureAlg) {
        byte[] signatureBytes = null;
        return signatureBytes;
    }

    public byte[] getSignature(byte[] data, String signatureAlg, AlgorithmParameterSpec second) {
        byte[] signatureBytes = null;
        return signatureBytes;
    }

    protected byte[] getSignature(byte[] data, String AlgName, PrivateKey privateKey, AlgorithmParameterSpec second) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, SignatureException {
        Signature signature = Signature.getInstance(AlgName, "BC");
        signature.initSign(privateKey);
        if (second != null) {
            signature.setParameter(second);
        }
        signature.update(data);
        return signature.sign();
    }

    protected void getCrlFromResponseData(DataFromServer data) {
        String encodeCRLData = data.crl;
        if (encodeCRLData == null || StringUtils.isEmpty(encodeCRLData)) {
            this.x509CRLs = null;
            LOGGER.warn("Get CRL data is null!");
        } else {
            this.x509CRLs = new ArrayList<X509CRL>();
            this.x509CRLs.add(DigestUtils.decodeBase64ToX509CRL(encodeCRLData));
        }
    }

    protected boolean getCertificatesFromResponseData(DataFromServer data) {
        if (data.certchain == null || data.certchain.length == 0) {
            LOGGER.error("certchain array is empty!");
            return false;
        }
        this.certificates = new ArrayList<X509Certificate>();
        for (String certificate : data.certchain) {
            this.certificates.add(DigestUtils.decodeBase64ToX509Certifate(certificate));
        }
        return true;
    }

    protected boolean checkEncodeSignedDataIsInvalid(String encodeSignedData) {
        return encodeSignedData == null || StringUtils.isEmpty(encodeSignedData);
    }
}

