/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.config;

import com.google.gson.Gson;
import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.exception.HttpException;
import com.huawei.signclient.hap.response.DataFromSignCenter;
import com.huawei.signclient.hap.utils.DigestUtils;
import com.huawei.signclient.hap.utils.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteSignerConfig
extends SignerConfig {
    private static final Logger LOGGER = LogManager.getLogger(RemoteSignerConfig.class);
    private static final String ENCRYPTION_ALGORITHM = RemoteSignerConfig.getEncryptionAlgorithmName();
    private static final int HTTP_NGINX_NETWORK_EXCEPTION = 504;
    private static final int MAX_HTTP_RETRY_TIMES = 3;
    private static final String ENCRYPY_PUBLIC_KEY = "MIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAmAo258NNEEiSiEdlcCN/7DANClxtNYzhi+EpW4qd90tD7IGCifdgxA48G0v1QUmbmCHqQWdq3q/2MRa1DzlgBIw9PQ8dWmcGx94Ba2nS+89XCVbWzdMT1OwZfGMVfBqC2lYDq6+EFuTydnT4v3e9wAJvwpNfHoZNbmH35NY5iqcZAze+xn64ilDbeyXhINDID2xHHrIBQu3W+nTaUtamWLO5lUf84E/hK9+V1niI4JGIqw66expZNRLGszG0qx6YpxrW81zpZzqhnUeBFaoKEGYwMXFol+xfGriPNwnhUE9Fp2GOn3ZfC1R5liXDjyOwLMXM6tO3bJLIXLnmUkEHnagDk6Lmpl5XGbX04njuc9v33ODQkGFZvjIck3ZUzHsMfMSvrmjhNP/NL/Qqn9uJtKlT1jbJuJkbnLZvSKZVdpG8fSyxTCDd60PVmi4gNsfZngB0cSQt8y77RgDdU2AnokYpDQMxH91K8F0TgbAQrL+xDEFJHDvXz7LEJSODwRdVAgMBAAE=";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getEncryptionAlgorithmName() {
        ClassLoader thisLoader = RemoteSignerConfig.class.getClassLoader();
        String ret = "";
        if (thisLoader == null) {
            LOGGER.error("get RemoteSignerConfig ClassLoader failed!");
            return ret;
        }
        try (InputStream inputStream = thisLoader.getResourceAsStream("encrypt.properties");){
            if (inputStream == null) {
                LOGGER.error("Could not read config file!");
                String string = ret;
                return string;
            }
            Properties prop = new Properties();
            prop.load(inputStream);
            Enumeration<?> keyNames = prop.propertyNames();
            while (keyNames.hasMoreElements()) {
                Object obj = keyNames.nextElement();
                if (!(obj instanceof String)) {
                    LOGGER.error("keyName is not a string!");
                    String string = ret;
                    return string;
                }
                String key = (String)obj;
                if (!Objects.equals(key, "AlgName")) {
                    LOGGER.error("no target key in config file!");
                    String string = ret;
                    return string;
                }
                ret = prop.getProperty(key);
            }
            return ret;
        }
        catch (IOException e) {
            LOGGER.error("Get encryption algorithm name error:", (Throwable)e);
        }
        return ret;
    }

    private static PublicKey getPublicKeyFromEncodeString(String KeyType) {
        PublicKey publicKey = null;
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(ENCRYPY_PUBLIC_KEY));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KeyType);
            publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Unsupport key algorithm : " + KeyType);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.error("Invalid key spec, transform failed!");
        }
        return publicKey;
    }

    private static byte[] encrypt(String text) {
        byte[] result = null;
        PublicKey publicKey = RemoteSignerConfig.getPublicKeyFromEncodeString("RSA");
        if (publicKey == null || !publicKey.getAlgorithm().equals("RSA")) {
            return result;
        }
        try {
            Cipher cipherEngine = Cipher.getInstance(ENCRYPTION_ALGORITHM, "BC");
            cipherEngine.init(1, publicKey);
            result = cipherEngine.doFinal(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            LOGGER.error("Unsupport cipher engine", (Throwable)e);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            LOGGER.error("encrypt failed.", (Throwable)e);
        }
        return result;
    }

    @Override
    public byte[] getSignature(byte[] data, String signatureAlg, AlgorithmParameterSpec second) {
        String responseData;
        byte[] signatureBytes;
        LOGGER.info("Compute signature by remote mode!");
        String username = (String)this.signParamMap.get("username");
        String password = (String)this.signParamMap.get("password");
        String priKeyPath = (String)this.signParamMap.get("privatekey");
        byte[] encryptPassword = RemoteSignerConfig.encrypt(password);
        HashMap<String, String> signParams = new HashMap<String, String>();
        String unsignedData = Base64.getUrlEncoder().encodeToString(data);
        signParams.put("domainUser", username);
        signParams.put("toolVersion", "HapSignatureTool-V2.0");
        signParams.put("passwordDigest", Base64.getEncoder().encodeToString(DigestUtils.sha256Digest(password.getBytes(Charset.forName("UTF-8")))));
        signParams.put("encryptedPassword", Base64.getEncoder().encodeToString(encryptPassword == null ? new byte[]{} : encryptPassword));
        signParams.put("subjectName", priKeyPath);
        signParams.put("signAlg", signatureAlg);
        signParams.put("unsignedData", unsignedData);
        if (this.signParamMap.containsKey("signServer")) {
            signParams.put("signServer", (String)this.signParamMap.get("signServer"));
        }
        if ((signatureBytes = this.getSignatureFromServer(responseData = this.getResponseData(signParams))) != null && signatureBytes.length > 0) {
            LOGGER.info("Get signature success!");
        } else {
            LOGGER.error("Get signature failed!");
        }
        return signatureBytes;
    }

    private String getResponseData(Map<String, String> signParams) {
        String responseData = null;
        for (int i = 0; i < 3; ++i) {
            try {
                responseData = HttpUtils.postData(signParams);
                if (responseData == null) continue;
                break;
            }
            catch (HttpException e) {
                if (e.getErrorCode() == 504 && i < 2) {
                    LOGGER.warn(e.getMessage() + ", retry again!");
                    continue;
                }
                LOGGER.error(e.getMessage());
                responseData = null;
                return responseData;
            }
        }
        return responseData;
    }

    public byte[] getSignatureFromServer(String responseData) {
        byte[] result = null;
        if (StringUtils.isEmpty(responseData)) {
            LOGGER.error("Get empty response from signature server!");
            return result;
        }
        DataFromSignCenter dataFromSignCenter = new Gson().fromJson(responseData, DataFromSignCenter.class);
        if (dataFromSignCenter == null || dataFromSignCenter.data == null) {
            LOGGER.error("Get response data error!");
            return result;
        }
        if (!this.getCertificatesFromResponseData(dataFromSignCenter.data)) {
            LOGGER.error("Get certificate list data error!");
            return result;
        }
        this.getCrlFromResponseData(dataFromSignCenter.data);
        String encodeSignedData = dataFromSignCenter.data.signedData;
        if (this.checkEncodeSignedDataIsInvalid(encodeSignedData)) {
            LOGGER.error("Get signedData data error!");
            return result;
        }
        result = Base64.getUrlDecoder().decode(encodeSignedData);
        return result;
    }
}

