/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.config;

import com.google.gson.Gson;
import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.response.DataFromAppGallary;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteReSignerBinConfig
extends SignerConfig {
    private static final Logger LOGGER = LogManager.getLogger(RemoteReSignerBinConfig.class);

    @Override
    public byte[] getSignature(byte[] data, String signatureAlg, AlgorithmParameterSpec second) {
        LOGGER.info("Compute signature by remote mode!");
        if (this.server == null) {
            LOGGER.error("server is null");
            return null;
        }
        String responseData = this.server.getSignature(data, signatureAlg);
        byte[] signatureBytes = this.getSignatureFromServer(responseData);
        if (signatureBytes == null || signatureBytes.length <= 0) {
            LOGGER.error("Get signature failed!");
            return null;
        }
        LOGGER.info("Get signature success!");
        return signatureBytes;
    }

    public byte[] getSignatureFromServer(String responseData) {
        byte[] result = null;
        if (StringUtils.isEmpty(responseData)) {
            LOGGER.error("Get empty response from signature server!");
            return result;
        }
        DataFromAppGallary dataFromAppGallary = new Gson().fromJson(responseData, DataFromAppGallary.class);
        if (dataFromAppGallary == null || !this.checkSignaturesIsSuc(dataFromAppGallary)) {
            LOGGER.error("responseJson is illegals!");
            return result;
        }
        if (dataFromAppGallary.data == null) {
            LOGGER.error("Get response data error!");
            return result;
        }
        if (!this.getCertificatesFromResponseData(dataFromAppGallary.data)) {
            LOGGER.error("Get certificate list data error!");
            return result;
        }
        this.getCrlFromResponseData(dataFromAppGallary.data);
        String encodeSignedData = dataFromAppGallary.data.signedData;
        if (this.checkEncodeSignedDataIsInvalid(encodeSignedData)) {
            LOGGER.error("Get signedData data error!");
            return result;
        }
        result = Base64.getUrlDecoder().decode(encodeSignedData);
        return result;
    }

    private boolean checkSignaturesIsSuc(DataFromAppGallary dataFromSignCenter) {
        if (dataFromSignCenter.code == null || !dataFromSignCenter.code.equals("success")) {
            if (dataFromSignCenter.message != null) {
                LOGGER.error("Get signedData failed: {}", (Object)dataFromSignCenter.message);
            }
            return false;
        }
        return true;
    }
}

