/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.config;

import com.huawei.signclient.hap.config.SignerConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalJKSSignerConfig
extends SignerConfig {
    private static final Logger LOG = LogManager.getLogger(LocalJKSSignerConfig.class);

    public LocalJKSSignerConfig(SignerConfig signerConfig) {
        this.certificates = signerConfig.certificates;
        this.signatureAlgorithms = signerConfig.signatureAlgorithms;
        this.signParamMap = signerConfig.signParamMap;
        this.x509CRLs = signerConfig.x509CRLs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getSignature(byte[] data, String signatureAlg, AlgorithmParameterSpec second) {
        LOG.info("Compute signature by local jks mode!");
        byte[] signatureBytes = null;
        String keystore = (String)this.signParamMap.get("keystore");
        String keystorePassword = (String)this.signParamMap.get("keystorepasswd");
        String keyAlias = (String)this.signParamMap.get("privatekey");
        String keyAliasPassword = (String)this.signParamMap.get("keyaliaspasswd");
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreStream, keystorePassword.toCharArray());
            Key obj = keyStore.getKey(keyAlias, keyAliasPassword.toCharArray());
            if (!(obj instanceof PrivateKey)) {
                LOG.error("key from keystore can not be converted to PrivateKey");
                byte[] byArray = signatureBytes;
                return byArray;
            }
            PrivateKey privateKey = (PrivateKey)obj;
            signatureBytes = this.getSignature(data, signatureAlg, privateKey, second);
            return signatureBytes;
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException e) {
            LOG.error("getSignature local JKS mod failed.", (Throwable)e);
        }
        return signatureBytes;
    }
}

