/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signclient.hap.config;

import com.huawei.signclient.hap.config.SignerConfig;
import com.huawei.signclient.hap.utils.ParamProcessUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalFileSignerConfig
extends SignerConfig {
    private static final Logger LOG = LogManager.getLogger(LocalFileSignerConfig.class);

    public LocalFileSignerConfig(SignerConfig signerConfig) {
        this.certificates = signerConfig.certificates;
        this.signatureAlgorithms = signerConfig.signatureAlgorithms;
        this.signParamMap = signerConfig.signParamMap;
        this.x509CRLs = signerConfig.x509CRLs;
    }

    @Override
    public byte[] getSignature(byte[] data, String signatureAlg, AlgorithmParameterSpec second) {
        LOG.info("Compute signature by local file mode!");
        byte[] signatureBytes = null;
        String privateKeyPath = (String)this.signParamMap.get("privatekey");
        try {
            PrivateKey privateKey = ParamProcessUtil.getPrivateKeyFromFile(privateKeyPath);
            if (privateKey == null) {
                LOG.error("privateKey is null!");
                return signatureBytes;
            }
            signatureBytes = this.getSignature(data, signatureAlg, privateKey, second);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            LOG.error("getSignature local file mod failed.", (Throwable)e);
        }
        return signatureBytes;
    }
}

