#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Copyright (c) 2021 Huawei Device Co., Ltd.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

"""
Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
Description: Generate interface to get java plugin's js code and binary
"""

import sys
import os


PLUGIN_PATH = sys.argv[5] # plugin js file path
PLUGIN_NAME = sys.argv[6]  # name of js file, ex: BatteryPlugin.js
GENERATED_FILE = sys.argv[7] # name of generated file
PACKAGE_NAME = sys.argv[8] # name of generated file's package

JAVA_FILE_SUFFIX = "JsCode"


def gen_java_method(file_name, file_path, out_file):
    file_name_pre = os.path.splitext(file_name)[0]
    js_src_file = file_path + file_name

    with open(out_file, "w") as output:
        output.write("/*%s * Copyright (c) Huawei Technologies Co., Ltd. " \
            "2021-2021. All rights reserved.%s */%s%s"
            % (os.linesep, os.linesep, os.linesep, os.linesep))

        output.write("package %s;%s" % (PACKAGE_NAME, os.linesep))
        output.write("%s" % os.linesep)
        output.write("public class %s%s {%s"
            % (file_name_pre, JAVA_FILE_SUFFIX, os.linesep))

        # write mehtod: getJsCode
        with open(js_src_file, "r") as input_src:
            output.write("    public static String getJsCode() {%s"
                % os.linesep)
            output.write("        return%s" % os.linesep)
            lines = input_src.readlines()
            for line in lines[:-1]:
                line = line.strip(os.linesep)
                line = line.replace("\"", "\\\"")
                output.write("        \"%s\\n\" +%s" % (line, os.linesep))
            last_line = lines[-1].replace("\"", "\\\"").strip(os.linesep)
            output.write("        \"%s\";%s" % (last_line, os.linesep))
            output.write("    }%s" % os.linesep)
        output.write("%s" % os.linesep)
        output.write("}")
    return


def operate_file(file_name, file_path):
    gen_java_method(file_name, file_path, GENERATED_FILE)


if __name__ == "__main__":
    operate_file(PLUGIN_NAME, PLUGIN_PATH)
