/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReaderASCII;
import com.alibaba.fastjson2.JSONReaderJSONB;
import com.alibaba.fastjson2.JSONReaderUTF16;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.JSONValidException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler;
import com.alibaba.fastjson2.filter.ExtraProcessor;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.Wrapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class JSONReader
implements Closeable {
    static final int MAX_EXP = 2047;
    static final byte JSON_TYPE_INT = 1;
    static final byte JSON_TYPE_DEC = 2;
    static final byte JSON_TYPE_STRING = 3;
    static final byte JSON_TYPE_BOOL = 4;
    static final byte JSON_TYPE_NULL = 5;
    static final byte JSON_TYPE_OBJECT = 6;
    static final byte JSON_TYPE_ARRAY = 7;
    static final byte JSON_TYPE_BIG_DEC = 8;
    static final byte JSON_TYPE_INT8 = 9;
    static final byte JSON_TYPE_INT16 = 10;
    static final byte JSON_TYPE_INT64 = 11;
    static final byte JSON_TYPE_FLOAT = 12;
    static final byte JSON_TYPE_DOUBLE = 13;
    static final byte JSON_TYPE_NaN = 14;
    static final char EOI = '\u001a';
    static final long SPACE = 4294981376L;
    static final boolean[] INT_VALUE_END;
    protected final Context context;
    public final boolean jsonb;
    public final boolean utf8;
    List<ResolveTask> resolveTasks;
    protected int offset;
    protected char ch;
    protected boolean comma;
    protected boolean nameEscape;
    protected boolean valueEscape;
    protected boolean wasNull;
    protected boolean boolValue;
    protected boolean negative;
    protected byte valueType;
    protected short exponent;
    protected short scale;
    protected int mag0;
    protected int mag1;
    protected int mag2;
    protected int mag3;
    protected int level;
    protected String stringValue;
    protected Object complex;
    protected boolean typeRedirect;
    protected byte[] doubleChars;
    protected static final long MASK_FIELD_BASED = 1L;
    protected static final long MASK_IGNORE_NONE_SERIALIZABLE = 2L;
    protected static final long MASK_ERROR_ON_NONE_SERIALIZABLE = 4L;
    protected static final long MASK_SUPPORT_ARRAY_TO_BEAN = 8L;
    protected static final long MASK_INIT_STRING_FIELD_AS_EMPTY = 16L;
    protected static final long MASK_SUPPORT_AUTO_TYPE = 32L;
    protected static final long MASK_SUPPORT_SMART_MATCH = 64L;
    protected static final long MASK_TRIM_STRING = 16384L;
    protected static final long MASK_ALLOW_UN_QUOTED_FIELD_NAMES = 131072L;
    protected static final long MASK_EMPTY_STRING_AS_NULL = 0x8000000L;
    protected static final long MASK_DISABLE_SINGLE_QUOTE = 0x80000000L;
    protected static final long MASK_DISABLE_REFERENCE_DETECT = 0x200000000L;

    public final char current() {
        return this.ch;
    }

    public boolean isEnd() {
        return this.ch == '\u001a';
    }

    public byte getType() {
        return -128;
    }

    public boolean isInt() {
        return this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9';
    }

    public abstract boolean isNull();

    public final boolean hasComma() {
        return this.comma;
    }

    public abstract Date readNullOrNewDate();

    public abstract boolean nextIfNull();

    public JSONReader(Context context, boolean jsonb, boolean utf8) {
        this.context = context;
        this.jsonb = jsonb;
        this.utf8 = utf8;
    }

    public final Context getContext() {
        return this.context;
    }

    public final void errorOnNoneSerializable(Class objectClass) {
        if ((this.context.features & 4L) != 0L && !Serializable.class.isAssignableFrom(objectClass)) {
            throw new JSONException("not support none-Serializable, class ".concat(objectClass.getName()));
        }
    }

    public final boolean isEnabled(Feature feature) {
        return (this.context.features & feature.mask) != 0L;
    }

    public final Locale getLocale() {
        return this.context.getLocale();
    }

    public final ZoneId getZoneId() {
        return this.context.getZoneId();
    }

    public final long features(long features) {
        return this.context.features | features;
    }

    public abstract int getRawInt();

    public abstract long getRawLong();

    public abstract boolean nextIfName4Match2();

    public boolean nextIfValue4Match2() {
        return false;
    }

    public abstract boolean nextIfName4Match3();

    public boolean nextIfValue4Match3() {
        return false;
    }

    public abstract boolean nextIfName4Match4(byte var1);

    public boolean nextIfValue4Match4(byte c4) {
        return false;
    }

    public abstract boolean nextIfName4Match5(int var1);

    public boolean nextIfValue4Match5(byte c4, byte c5) {
        return false;
    }

    public abstract boolean nextIfName4Match6(int var1);

    public boolean nextIfValue4Match6(int name1) {
        return false;
    }

    public abstract boolean nextIfName4Match7(int var1);

    public boolean nextIfValue4Match7(int name1) {
        return false;
    }

    public abstract boolean nextIfName4Match8(int var1, byte var2);

    public boolean nextIfValue4Match8(int name1, byte c8) {
        return false;
    }

    public abstract boolean nextIfName4Match9(long var1);

    public boolean nextIfValue4Match9(int name1, byte c8, byte c9) {
        return false;
    }

    public abstract boolean nextIfName4Match10(long var1);

    public boolean nextIfValue4Match10(long name1) {
        return false;
    }

    public abstract boolean nextIfName4Match11(long var1);

    public boolean nextIfValue4Match11(long name1) {
        return false;
    }

    public abstract boolean nextIfName4Match12(long var1, byte var3);

    public abstract boolean nextIfName4Match13(long var1, int var3);

    public boolean nextIfName4Match14(long name1, int name2) {
        return false;
    }

    public boolean nextIfName4Match15(long name1, int name2) {
        return false;
    }

    public abstract boolean nextIfName4Match16(long var1, int var3, byte var4);

    public abstract boolean nextIfName4Match17(long var1, long var3);

    public abstract boolean nextIfName4Match18(long var1, long var3);

    public boolean nextIfName4Match19(long name1, long name2) {
        return false;
    }

    public abstract boolean nextIfName4Match20(long var1, long var3, byte var5);

    public boolean nextIfName4Match21(long name1, long name2, int name3) {
        return false;
    }

    public abstract boolean nextIfName4Match22(long var1, long var3, int var5);

    public abstract boolean nextIfName4Match23(long var1, long var3, int var5);

    public abstract boolean nextIfName4Match24(long var1, long var3, int var5, byte var6);

    public abstract boolean nextIfName4Match25(long var1, long var3, long var5);

    public abstract boolean nextIfName4Match26(long var1, long var3, long var5);

    public abstract boolean nextIfName4Match27(long var1, long var3, long var5);

    public abstract boolean nextIfName4Match28(long var1, long var3, long var5, byte var7);

    public abstract boolean nextIfName4Match29(long var1, long var3, long var5, int var7);

    public abstract boolean nextIfName4Match30(long var1, long var3, long var5, int var7);

    public abstract boolean nextIfName4Match31(long var1, long var3, long var5, int var7);

    public abstract boolean nextIfName4Match32(long var1, long var3, long var5, int var7, byte var8);

    public abstract boolean nextIfName4Match33(long var1, long var3, long var5, long var7);

    public abstract boolean nextIfName4Match34(long var1, long var3, long var5, long var7);

    public abstract boolean nextIfName4Match35(long var1, long var3, long var5, long var7);

    public abstract boolean nextIfName4Match36(long var1, long var3, long var5, long var7, byte var9);

    public abstract boolean nextIfName4Match37(long var1, long var3, long var5, long var7, int var9);

    public abstract boolean nextIfName4Match38(long var1, long var3, long var5, long var7, int var9);

    public abstract boolean nextIfName4Match39(long var1, long var3, long var5, long var7, int var9);

    public abstract boolean nextIfName4Match40(long var1, long var3, long var5, long var7, int var9, byte var10);

    public abstract boolean nextIfName4Match41(long var1, long var3, long var5, long var7, long var9);

    public abstract boolean nextIfName4Match42(long var1, long var3, long var5, long var7, long var9);

    public abstract boolean nextIfName4Match43(long var1, long var3, long var5, long var7, long var9);

    public boolean nextIfName8Match0() {
        return false;
    }

    public boolean nextIfName8Match1() {
        return false;
    }

    public boolean nextIfName8Match2() {
        return false;
    }

    public final void handleResolveTasks(Object root) {
        if (this.resolveTasks == null) {
            return;
        }
        Object previous = null;
        for (ResolveTask resolveTask : this.resolveTasks) {
            Object fieldValue;
            JSONPath path = resolveTask.reference;
            FieldReader fieldReader = resolveTask.fieldReader;
            if (path.isPrevious()) {
                fieldValue = previous;
            } else {
                if (!path.isRef()) {
                    throw new JSONException("reference path invalid : " + path);
                }
                path.setReaderContext(this.context);
                if ((this.context.features & Feature.FieldBased.mask) != 0L) {
                    JSONWriter.Context writeContext = JSONFactory.createWriteContext();
                    writeContext.features |= JSONWriter.Feature.FieldBased.mask;
                    path.setWriterContext(writeContext);
                }
                previous = fieldValue = path.eval(root);
            }
            Object resolvedName = resolveTask.name;
            Object resolvedObject = resolveTask.object;
            if (resolvedName != null) {
                if (resolvedObject instanceof Map) {
                    Map map = (Map)resolvedObject;
                    if (resolvedName instanceof ReferenceKey) {
                        if (map instanceof LinkedHashMap) {
                            int size = map.size();
                            if (size == 0) continue;
                            Object[] keys = new Object[size];
                            Object[] values = new Object[size];
                            int index = 0;
                            for (Map.Entry o : map.entrySet()) {
                                Map.Entry entry = o;
                                Object entryKey = entry.getKey();
                                keys[index] = resolvedName == entryKey ? fieldValue : entryKey;
                                values[index++] = entry.getValue();
                            }
                            map.clear();
                            for (int j = 0; j < keys.length; ++j) {
                                map.put(keys[j], values[j]);
                            }
                            continue;
                        }
                        map.put(fieldValue, map.remove(resolvedName));
                        continue;
                    }
                    map.put(resolvedName, fieldValue);
                    continue;
                }
                if (resolvedName instanceof Integer) {
                    if (resolvedObject instanceof List) {
                        List list;
                        int index = (Integer)resolvedName;
                        if (index == (list = (List)resolvedObject).size()) {
                            list.add(fieldValue);
                            continue;
                        }
                        if (index < list.size() && list.get(index) == null) {
                            list.set(index, fieldValue);
                            continue;
                        }
                        list.add(index, fieldValue);
                        continue;
                    }
                    if (resolvedObject instanceof Object[]) {
                        int index = (Integer)resolvedName;
                        Object[] array = (Object[])resolvedObject;
                        array[index] = fieldValue;
                        continue;
                    }
                    if (resolvedObject instanceof Collection) {
                        Collection collection = (Collection)resolvedObject;
                        collection.add(fieldValue);
                        continue;
                    }
                }
            }
            fieldReader.accept(resolvedObject, fieldValue);
        }
    }

    public final ObjectReader getObjectReader(Type type) {
        return this.context.provider.getObjectReader(type, (this.context.features & 1L) != 0L);
    }

    public final boolean isSupportSmartMatch() {
        return (this.context.features & 0x40L) != 0L;
    }

    public final boolean isInitStringFieldAsEmpty() {
        return (this.context.features & 0x10L) != 0L;
    }

    public final boolean isSupportSmartMatch(long features) {
        return ((this.context.features | features) & 0x40L) != 0L;
    }

    public final boolean isSupportBeanArray() {
        return (this.context.features & 8L) != 0L;
    }

    public final boolean isSupportBeanArray(long features) {
        return ((this.context.features | features) & 8L) != 0L;
    }

    public final boolean isSupportAutoType(long features) {
        return ((this.context.features | features) & 0x20L) != 0L;
    }

    public final boolean isSupportAutoTypeOrHandler(long features) {
        return ((this.context.features | features) & 0x20L) != 0L || this.context.autoTypeBeforeHandler != null;
    }

    public final boolean isJSONB() {
        return this.jsonb;
    }

    public final boolean isIgnoreNoneSerializable() {
        return (this.context.features & 2L) != 0L;
    }

    public boolean hasAutoTypeBeforeHandler() {
        return this.context.autoTypeBeforeHandler != null;
    }

    public ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        return null;
    }

    final char char1(int c) {
        switch (c) {
            case 48: {
                return '\u0000';
            }
            case 49: {
                return '\u0001';
            }
            case 50: {
                return '\u0002';
            }
            case 51: {
                return '\u0003';
            }
            case 52: {
                return '\u0004';
            }
            case 53: {
                return '\u0005';
            }
            case 54: {
                return '\u0006';
            }
            case 55: {
                return '\u0007';
            }
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 118: {
                return '\u000b';
            }
            case 70: 
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 126: {
                return (char)c;
            }
        }
        throw new JSONException(this.info("unclosed.str '\\" + (char)c));
    }

    static char char2(int c1, int c2) {
        return (char)(JSONFactory.DIGITS2[c1] * 16 + JSONFactory.DIGITS2[c2]);
    }

    public abstract boolean nextIfObjectStart();

    public abstract boolean nextIfNullOrEmptyString();

    public abstract boolean nextIfObjectEnd();

    public int startArray() {
        if (!this.nextIfArrayStart()) {
            throw new JSONException(this.info("illegal input, expect '[', but " + this.ch));
        }
        return Integer.MAX_VALUE;
    }

    public abstract boolean isReference();

    public abstract String readReference();

    public final boolean readReference(List list, int i) {
        if (!this.isReference()) {
            return false;
        }
        return this.readReference0(list, i);
    }

    public boolean readReference(Collection list, int i) {
        if (!this.isReference()) {
            return false;
        }
        return this.readReference0(list, i);
    }

    private boolean readReference0(Collection list, int i) {
        String path = this.readReference();
        if ("..".equals(path)) {
            list.add(list);
        } else {
            this.addResolveTask(list, i, JSONPath.of(path));
        }
        return true;
    }

    public final void addResolveTask(FieldReader fieldReader, Object object, JSONPath path) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(fieldReader, object, fieldReader.fieldName, path));
    }

    public final void addResolveTask(Map object, Object key, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        if (object instanceof LinkedHashMap) {
            object.put(key, null);
        }
        this.resolveTasks.add(new ResolveTask(null, object, key, reference));
    }

    public final void addResolveTask(Collection object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public final void addResolveTask(Object[] object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public boolean isArray() {
        return this.ch == '[';
    }

    public boolean isObject() {
        return this.ch == '{';
    }

    public boolean isNumber() {
        switch (this.ch) {
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return this.ch == '\"' || this.ch == '\'';
    }

    public void endArray() {
        this.next();
    }

    public abstract boolean nextIfMatch(char var1);

    public abstract boolean nextIfComma();

    public abstract boolean nextIfArrayStart();

    public abstract boolean nextIfArrayEnd();

    public abstract boolean nextIfSet();

    public abstract boolean nextIfInfinity();

    public abstract String readPattern();

    public final int getOffset() {
        return this.offset;
    }

    public abstract void next();

    public void nextWithoutComment() {
        this.next();
    }

    public abstract long readValueHashCode();

    public long readTypeHashCode() {
        return this.readValueHashCode();
    }

    public abstract long readFieldNameHashCode();

    public abstract long getNameHashCodeLCase();

    public abstract String readFieldName();

    public abstract String getFieldName();

    public final void setTypeRedirect(boolean typeRedirect) {
        this.typeRedirect = typeRedirect;
    }

    public final boolean isTypeRedirect() {
        return this.typeRedirect;
    }

    public abstract long readFieldNameHashCodeUnquote();

    public final String readFieldNameUnquote() {
        if (this.ch == '/') {
            this.skipComment();
        }
        this.readFieldNameHashCodeUnquote();
        String name = this.getFieldName();
        if (name == null || name.isEmpty()) {
            throw new JSONException(this.info("illegal input"));
        }
        return name;
    }

    public abstract boolean skipName();

    public abstract void skipValue();

    public boolean isBinary() {
        return false;
    }

    public abstract byte[] readHex();

    public byte[] readBinary() {
        if (this.ch == 'x') {
            return this.readHex();
        }
        if (this.isString()) {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            if ((this.context.features & Feature.Base64StringAsByteArray.mask) != 0L) {
                return Base64.getDecoder().decode(str);
            }
            throw new JSONException(this.info("not support input " + str));
        }
        if (this.nextIfArrayStart()) {
            int index = 0;
            byte[] bytes = new byte[64];
            while (true) {
                if (this.ch == ']') break;
                if (index == bytes.length) {
                    int oldCapacity = bytes.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    bytes = Arrays.copyOf(bytes, newCapacity);
                }
                bytes[index++] = (byte)this.readInt32Value();
            }
            this.next();
            this.nextIfComma();
            return Arrays.copyOf(bytes, index);
        }
        throw new JSONException(this.info("not support read binary"));
    }

    public abstract int readInt32Value();

    public int[] readInt32ValueArray() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.nextIfArrayStart()) {
            int[] values = new int[8];
            int size = 0;
            while (!this.nextIfArrayEnd()) {
                if (this.isEnd()) {
                    throw new JSONException(this.info("input end"));
                }
                if (size == values.length) {
                    values = Arrays.copyOf(values, values.length << 1);
                }
                values[size++] = this.readInt32Value();
            }
            this.nextIfComma();
            int[] array = size == values.length ? values : Arrays.copyOf(values, size);
            return array;
        }
        if (this.isString()) {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw new JSONException(this.info("not support input " + str));
        }
        throw new JSONException(this.info("TODO"));
    }

    public boolean nextIfMatch(byte type) {
        throw new JSONException("UnsupportedOperation");
    }

    public boolean nextIfMatchTypedAny() {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract boolean nextIfMatchIdent(char var1, char var2);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4, char var5);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4, char var5, char var6);

    public final Byte readInt8() {
        Integer i = this.readInt32();
        if (i == null) {
            return null;
        }
        return i.byteValue();
    }

    public byte readInt8Value() {
        int i = this.readInt32Value();
        return (byte)i;
    }

    public final Short readInt16() {
        Integer i = this.readInt32();
        if (i == null) {
            return null;
        }
        return i.shortValue();
    }

    public short readInt16Value() {
        int i = this.readInt32Value();
        return (short)i;
    }

    public abstract Integer readInt32();

    protected final int readInt32ValueOverflow() {
        this.readNumber0();
        return this.getInt32Value();
    }

    protected final long readInt64ValueOverflow() {
        this.readNumber0();
        return this.getInt64Value();
    }

    public final int getInt32Value() {
        switch (this.valueType) {
            case 1: 
            case 9: 
            case 10: {
                Number number;
                if (this.mag1 == 0 && this.mag2 == 0) {
                    if (this.negative) {
                        if (this.mag3 == Integer.MIN_VALUE) {
                            return this.mag3;
                        }
                        if (this.mag3 >= 0) {
                            return -this.mag3;
                        }
                    } else if (this.mag3 >= 0) {
                        return this.mag3;
                    }
                }
                if ((number = this.getNumber()) instanceof Long) {
                    long longValue = number.longValue();
                    if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                        throw new JSONException(this.info("integer overflow " + longValue));
                    }
                    return (int)longValue;
                }
                if (number instanceof BigInteger) {
                    BigInteger bigInt = (BigInteger)number;
                    if ((this.context.features & Feature.NonErrorOnNumberOverflow.mask) != 0L) {
                        return bigInt.intValue();
                    }
                    try {
                        return bigInt.intValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw this.numberError();
                    }
                }
                return number.intValue();
            }
            case 2: {
                return this.getNumber().intValue();
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                if ((this.context.features & Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("int value not support input null"));
                }
                return 0;
            }
            case 3: {
                return this.toInt32(this.stringValue);
            }
            case 6: {
                Number num = this.toNumber((Map)this.complex);
                if (num != null) {
                    return num.intValue();
                }
                return 0;
            }
            case 11: 
            case 12: 
            case 13: {
                Number num = this.getNumber();
                long int64 = num.longValue();
                if ((int64 < Integer.MIN_VALUE || int64 > Integer.MAX_VALUE) && (this.context.features & Feature.NonErrorOnNumberOverflow.mask) == 0L) {
                    throw new JSONException(this.info("integer overflow " + int64));
                }
                return (int)int64;
            }
            case 8: {
                try {
                    return this.getBigDecimal().intValueExact();
                }
                catch (ArithmeticException e) {
                    throw this.numberError();
                }
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public final long getInt64Value() {
        switch (this.valueType) {
            case 1: 
            case 9: 
            case 10: {
                Number number;
                if (this.mag1 == 0 && this.mag2 == 0) {
                    if (this.negative) {
                        if (this.mag3 == Integer.MIN_VALUE) {
                            return this.mag3;
                        }
                        if (this.mag3 >= 0) {
                            return -this.mag3;
                        }
                    } else if (this.mag3 >= 0) {
                        return this.mag3;
                    }
                }
                if ((number = this.getNumber()) instanceof BigInteger) {
                    BigInteger bigInt = (BigInteger)number;
                    if ((this.context.features & Feature.NonErrorOnNumberOverflow.mask) != 0L) {
                        return bigInt.longValue();
                    }
                    try {
                        return bigInt.longValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw this.numberError();
                    }
                }
                return number.longValue();
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                return this.getNumber().longValue();
            }
            case 4: {
                return this.boolValue ? 1L : 0L;
            }
            case 5: {
                if ((this.context.features & Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                return 0L;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toLong((Map)this.complex);
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
            case 8: {
                try {
                    return this.getBigDecimal().longValueExact();
                }
                catch (ArithmeticException e) {
                    throw this.numberError();
                }
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public final double getDoubleValue() {
        switch (this.valueType) {
            case 14: {
                return Double.NaN;
            }
            case 1: 
            case 9: 
            case 10: {
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? (double)(-this.mag3) : (double)this.mag3;
                }
                Number number = this.getNumber();
                if (number instanceof BigInteger) {
                    BigInteger bigInt = (BigInteger)number;
                    if ((this.context.features & Feature.NonErrorOnNumberOverflow.mask) != 0L) {
                        return bigInt.longValue();
                    }
                    try {
                        return bigInt.longValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw this.numberError();
                    }
                }
                return number.doubleValue();
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                return this.getNumber().doubleValue();
            }
            case 4: {
                return this.boolValue ? 1.0 : 0.0;
            }
            case 5: {
                if ((this.context.features & Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                return 0.0;
            }
            case 3: {
                try {
                    return TypeUtils.toDoubleValue(this.stringValue);
                }
                catch (NumberFormatException e) {
                    throw new JSONException(this.info(e.getMessage()));
                }
            }
            case 6: {
                Map map = (Map)this.complex;
                if (map == null || map.isEmpty()) {
                    this.wasNull = true;
                    return 0.0;
                }
                return TypeUtils.toDoubleValue(map);
            }
            case 7: {
                Collection list = (Collection)this.complex;
                if (list == null || list.isEmpty()) {
                    this.wasNull = true;
                    return 0.0;
                }
                return TypeUtils.toDoubleValue(this.complex);
            }
            case 8: {
                try {
                    return this.getBigDecimal().doubleValue();
                }
                catch (ArithmeticException e) {
                    throw this.numberError();
                }
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public final float getFloatValue() {
        return (float)this.getDoubleValue();
    }

    public long[] readInt64ValueArray() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.nextIfArrayStart()) {
            long[] values = new long[8];
            int size = 0;
            while (!this.nextIfArrayEnd()) {
                if (this.isEnd()) {
                    throw new JSONException(this.info("input end"));
                }
                if (size == values.length) {
                    values = Arrays.copyOf(values, values.length << 1);
                }
                values[size++] = this.readInt64Value();
            }
            return size == values.length ? values : Arrays.copyOf(values, size);
        }
        if (this.isString()) {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw this.error("not support input ".concat(str));
        }
        throw new JSONException(this.info("TODO"));
    }

    public abstract long readInt64Value();

    public abstract Long readInt64();

    public abstract float readFloatValue();

    public Float readFloat() {
        if (this.nextIfNull()) {
            return null;
        }
        this.wasNull = false;
        float value = this.readFloatValue();
        if (this.wasNull) {
            return null;
        }
        return Float.valueOf(value);
    }

    public abstract double readDoubleValue();

    public final Double readDouble() {
        if (this.nextIfNull()) {
            return null;
        }
        this.wasNull = false;
        double value = this.readDoubleValue();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    public Number readNumber() {
        this.readNumber0();
        return this.getNumber();
    }

    public BigInteger readBigInteger() {
        this.readNumber0();
        return this.getBigInteger();
    }

    public abstract BigDecimal readBigDecimal();

    public abstract UUID readUUID();

    public LocalDate readLocalDate() {
        String str;
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDate();
        }
        if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            LocalDateTime ldt = null;
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 19: {
                    ldt = this.readLocalDateTime19();
                    break;
                }
                case 20: {
                    ldt = this.readLocalDateTime20();
                    break;
                }
                default: {
                    if (len <= 20) break;
                    ldt = this.readLocalDateTimeX(len);
                }
            }
            if (ldt != null) {
                return ldt.toLocalDate();
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            return null;
        }
        DateTimeFormatter formatter = this.context.getDateFormatter();
        if (formatter != null) {
            if (this.context.formatHasHour) {
                return LocalDateTime.parse(str, formatter).toLocalDate();
            }
            return LocalDate.parse(str, formatter);
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDate();
        }
        throw new JSONException("not support input : " + str);
    }

    public LocalDateTime readLocalDateTime() {
        String str;
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalDateTime();
        }
        if (this.isTypeRedirect() && this.nextIfMatchIdent('\"', 'v', 'a', 'l', '\"')) {
            this.nextIfMatch(':');
            LocalDateTime dateTime = this.readLocalDateTime();
            this.nextIfObjectEnd();
            this.setTypeRedirect(false);
            return dateTime;
        }
        if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 16: {
                    return this.readLocalDateTime16();
                }
                case 17: {
                    LocalDateTime ldt = this.readLocalDateTime17();
                    if (ldt == null) break;
                    return ldt;
                }
                case 18: {
                    LocalDateTime ldt = this.readLocalDateTime18();
                    if (ldt == null) break;
                    return ldt;
                }
                case 19: {
                    LocalDateTime ldt = this.readLocalDateTime19();
                    if (ldt == null) break;
                    return ldt;
                }
                case 20: {
                    LocalDateTime ldt = this.readLocalDateTime20();
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.toLocalDateTime();
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    LocalDateTime ldt = this.readLocalDateTimeX(len);
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    ZoneId contextZoneId = this.context.getZoneId();
                    ldt = !zdt.getZone().equals(contextZoneId) ? zdt.toInstant().atZone(contextZoneId).toLocalDateTime() : zdt.toLocalDateTime();
                    return ldt;
                }
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            this.wasNull = true;
            return null;
        }
        DateTimeFormatter formatter = this.context.getDateFormatter();
        if (formatter != null) {
            if (!this.context.formatHasHour) {
                return LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN);
            }
            return LocalDateTime.parse(str, formatter);
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, this.context.getZoneId());
        }
        if (str.startsWith("/Date(") && str.endsWith(")/")) {
            String dotnetDateStr = str.substring(6, str.length() - 2);
            int i = dotnetDateStr.indexOf(43);
            if (i == -1) {
                i = dotnetDateStr.indexOf(45);
            }
            if (i != -1) {
                dotnetDateStr = dotnetDateStr.substring(0, i);
            }
            long millis = Long.parseLong(dotnetDateStr);
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, this.context.getZoneId());
        }
        if ("0000-00-00 00:00:00".equals(str)) {
            this.wasNull = true;
            return null;
        }
        throw new JSONException(this.info("read LocalDateTime error " + str));
    }

    public abstract OffsetDateTime readOffsetDateTime();

    public ZonedDateTime readZonedDateTime() {
        if (this.isInt()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return instant.atZone(this.context.getZoneId());
        }
        if (this.isString()) {
            String str;
            LocalDate localDate;
            if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
                int len = this.getStringLength();
                LocalDateTime ldt = null;
                switch (len) {
                    case 8: {
                        localDate = this.readLocalDate8();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 9: {
                        localDate = this.readLocalDate9();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 10: {
                        localDate = this.readLocalDate10();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 11: {
                        localDate = this.readLocalDate11();
                        ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 16: {
                        ldt = this.readLocalDateTime16();
                        break;
                    }
                    case 17: {
                        ldt = this.readLocalDateTime17();
                        break;
                    }
                    case 18: {
                        ldt = this.readLocalDateTime18();
                        break;
                    }
                    case 19: {
                        ldt = this.readLocalDateTime19();
                        break;
                    }
                    case 20: {
                        ldt = this.readLocalDateTime20();
                        break;
                    }
                    default: {
                        ZonedDateTime zdt = this.readZonedDateTimeX(len);
                        if (zdt == null) break;
                        return zdt;
                    }
                }
                if (ldt != null) {
                    return ZonedDateTime.ofLocal(ldt, this.context.getZoneId(), null);
                }
            }
            if ((str = this.readString()).isEmpty() || "null".equals(str)) {
                return null;
            }
            DateTimeFormatter formatter = this.context.getDateFormatter();
            if (formatter != null) {
                if (!this.context.formatHasHour) {
                    localDate = LocalDate.parse(str, formatter);
                    return ZonedDateTime.of(localDate, LocalTime.MIN, this.context.getZoneId());
                }
                LocalDateTime localDateTime = LocalDateTime.parse(str, formatter);
                return ZonedDateTime.of(localDateTime, this.context.getZoneId());
            }
            if (IOUtils.isNumber(str)) {
                long millis = Long.parseLong(str);
                if (this.context.formatUnixTime) {
                    millis *= 1000L;
                }
                Instant instant = Instant.ofEpochMilli(millis);
                return instant.atZone(this.context.getZoneId());
            }
            return ZonedDateTime.parse(str);
        }
        if (this.nextIfNull()) {
            return null;
        }
        throw new JSONException("TODO : " + this.ch);
    }

    public abstract OffsetTime readOffsetTime();

    public Calendar readCalendar() {
        if (this.isString()) {
            long millis = this.readMillisFromString();
            if (millis == 0L && this.wasNull) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }
        if (this.readIfNull()) {
            return null;
        }
        long millis = this.readInt64Value();
        if (this.context.formatUnixTime) {
            millis *= 1000L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public Date readDate() {
        long millis;
        if (this.isInt()) {
            long millis2 = this.readInt64Value();
            return new Date(millis2);
        }
        if (this.readIfNull()) {
            return null;
        }
        if (this.nextIfNullOrEmptyString()) {
            return null;
        }
        if (this.current() == 'n') {
            return this.readNullOrNewDate();
        }
        if (this.isTypeRedirect() && this.nextIfMatchIdent('\"', 'v', 'a', 'l', '\"')) {
            this.nextIfMatch(':');
            millis = this.readInt64Value();
            this.nextIfObjectEnd();
            this.setTypeRedirect(false);
        } else {
            if (this.isObject()) {
                JSONObject object = this.readJSONObject();
                Object date = object.get("$date");
                if (date instanceof String) {
                    return DateUtils.parseDate((String)date, this.context.getZoneId());
                }
                return TypeUtils.toDate(object);
            }
            millis = this.readMillisFromString();
        }
        if (millis == 0L && this.wasNull) {
            return null;
        }
        return new Date(millis);
    }

    public LocalTime readLocalTime() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalTime();
        }
        int len = this.getStringLength();
        switch (len) {
            case 5: {
                return this.readLocalTime5();
            }
            case 6: {
                return this.readLocalTime6();
            }
            case 7: {
                return this.readLocalTime7();
            }
            case 8: {
                return this.readLocalTime8();
            }
            case 9: {
                return this.readLocalTime9();
            }
            case 10: {
                return this.readLocalTime10();
            }
            case 11: {
                return this.readLocalTime11();
            }
            case 12: {
                return this.readLocalTime12();
            }
            case 15: {
                return this.readLocalTime15();
            }
            case 18: {
                return this.readLocalTime18();
            }
            case 19: {
                return this.readLocalDateTime19().toLocalTime();
            }
            case 20: {
                return this.readLocalDateTime20().toLocalTime();
            }
        }
        String str = this.readString();
        if (str.isEmpty() || "null".equals(str)) {
            return null;
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = instant.atZone(this.context.getZoneId());
            return zdt.toLocalTime();
        }
        throw new JSONException("not support len : " + str);
    }

    protected abstract int getStringLength();

    public boolean isDate() {
        return false;
    }

    public Instant readInstant() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isNumber()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            return Instant.ofEpochMilli(millis);
        }
        if (this.isObject()) {
            return (Instant)this.getObjectReader((Type)((Object)Instant.class)).createInstance(this.readObject(), 0L);
        }
        ZonedDateTime zdt = this.readZonedDateTime();
        if (zdt == null) {
            return null;
        }
        return Instant.ofEpochSecond(zdt.toEpochSecond(), zdt.toLocalTime().getNano());
    }

    public final long readMillisFromString() {
        String str;
        this.wasNull = false;
        String format = this.context.dateFormat;
        if (format == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            LocalDateTime ldt = null;
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    if (localDate == null) {
                        throw new JSONException("TODO : " + this.readString());
                    }
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    if (localDate == null) break;
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    if (localDate == null) {
                        String str2 = this.readString();
                        if ("0000-00-00".equals(str2)) {
                            this.wasNull = true;
                            return 0L;
                        }
                        if (IOUtils.isNumber(str2)) {
                            return Long.parseLong(str2);
                        }
                        throw new JSONException("TODO : " + str2);
                    }
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    if (localDate == null) break;
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 12: {
                    ldt = this.readLocalDateTime12();
                    break;
                }
                case 14: {
                    ldt = this.readLocalDateTime14();
                    break;
                }
                case 16: {
                    ldt = this.readLocalDateTime16();
                    break;
                }
                case 17: {
                    ldt = this.readLocalDateTime17();
                    break;
                }
                case 18: {
                    ldt = this.readLocalDateTime18();
                    break;
                }
                case 19: {
                    long millis = this.readMillis19();
                    if (millis != 0L || !this.wasNull) {
                        return millis;
                    }
                    ldt = this.readLocalDateTime19();
                    break;
                }
                case 20: {
                    ldt = this.readLocalDateTime20();
                    break;
                }
            }
            ZonedDateTime zdt = null;
            if (ldt != null) {
                zdt = ZonedDateTime.ofLocal(ldt, this.context.getZoneId(), null);
            } else if (len >= 20 && (zdt = this.readZonedDateTimeX(len)) == null && len >= 32 && len <= 35) {
                String str3 = this.readString();
                zdt = DateUtils.parseZonedDateTime(str3, null);
            }
            if (zdt != null) {
                long seconds = zdt.toEpochSecond();
                int nanos = zdt.toLocalTime().getNano();
                if (seconds < 0L && nanos > 0) {
                    long millis = (seconds + 1L) * 1000L;
                    long adjustment = nanos / 1000000 - 1000;
                    return millis + adjustment;
                }
                long millis = seconds * 1000L;
                return millis + (long)(nanos / 1000000);
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            this.wasNull = true;
            return 0L;
        }
        if (this.context.formatMillis || this.context.formatUnixTime) {
            long millis = Long.parseLong(str);
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            return millis;
        }
        if (format != null && !format.isEmpty()) {
            if ("yyyy-MM-dd HH:mm:ss".equals(format)) {
                if ((str.length() < 4 || str.charAt(4) != '-') && IOUtils.isNumber(str)) {
                    return Long.parseLong(str);
                }
                return DateUtils.parseMillis19(str, this.context.getZoneId());
            }
            if ("yyyy-MM-dd HH:mm:ss.SSS".equals(format) && str.length() == 19 && str.charAt(4) == '-' && str.charAt(7) == '-' && str.charAt(10) == ' ' && str.charAt(13) == ':' && str.charAt(16) == ':') {
                return DateUtils.parseMillis19(str, this.context.getZoneId());
            }
            SimpleDateFormat utilFormat = new SimpleDateFormat(format);
            try {
                return utilFormat.parse(str).getTime();
            }
            catch (ParseException e) {
                throw new JSONException("parse date error, " + str + ", expect format " + utilFormat.toPattern());
            }
        }
        if ("0000-00-00T00:00:00".equals(str) || "0001-01-01T00:00:00+08:00".equals(str)) {
            return 0L;
        }
        if (str.startsWith("/Date(") && str.endsWith(")/")) {
            String dotnetDateStr = str.substring(6, str.length() - 2);
            int i = dotnetDateStr.indexOf(43);
            if (i == -1) {
                i = dotnetDateStr.indexOf(45);
            }
            if (i != -1) {
                dotnetDateStr = dotnetDateStr.substring(0, i);
            }
            return Long.parseLong(dotnetDateStr);
        }
        if (IOUtils.isNumber(str)) {
            return Long.parseLong(str);
        }
        throw new JSONException(this.info("format " + format + " not support, input " + str));
    }

    protected abstract LocalDateTime readLocalDateTime12();

    protected abstract LocalDateTime readLocalDateTime14();

    protected abstract LocalDateTime readLocalDateTime16();

    protected abstract LocalDateTime readLocalDateTime17();

    protected abstract LocalDateTime readLocalDateTime18();

    protected abstract LocalDateTime readLocalDateTime19();

    protected abstract LocalDateTime readLocalDateTime20();

    public abstract long readMillis19();

    protected abstract LocalDateTime readLocalDateTimeX(int var1);

    protected abstract LocalTime readLocalTime5();

    protected abstract LocalTime readLocalTime6();

    protected abstract LocalTime readLocalTime7();

    protected abstract LocalTime readLocalTime8();

    protected abstract LocalTime readLocalTime9();

    protected abstract LocalTime readLocalTime10();

    protected abstract LocalTime readLocalTime11();

    protected abstract LocalTime readLocalTime12();

    protected abstract LocalTime readLocalTime15();

    protected abstract LocalTime readLocalTime18();

    protected abstract LocalDate readLocalDate8();

    protected abstract LocalDate readLocalDate9();

    protected abstract LocalDate readLocalDate10();

    protected abstract LocalDate readLocalDate11();

    protected abstract ZonedDateTime readZonedDateTimeX(int var1);

    public void readNumber(ValueConsumer consumer, boolean quoted) {
        this.readNumber0();
        Number number = this.getNumber();
        consumer.accept(number);
    }

    public void readString(ValueConsumer consumer, boolean quoted) {
        String str = this.readString();
        if (quoted) {
            consumer.accept(JSON.toJSONString(str));
        } else {
            consumer.accept(str);
        }
    }

    protected abstract void readNumber0();

    public abstract String readString();

    public String[] readStringArray() {
        if (this.ch == 'n' && this.nextIfNull()) {
            return null;
        }
        if (this.nextIfArrayStart()) {
            String[] values = null;
            int size = 0;
            while (true) {
                if (this.nextIfArrayEnd()) {
                    if (values != null) break;
                    values = new String[]{};
                    break;
                }
                if (this.isEnd()) {
                    throw new JSONException(this.info("input end"));
                }
                if (values == null) {
                    values = new String[16];
                } else if (size == values.length) {
                    values = Arrays.copyOf(values, values.length << 1);
                }
                values[size++] = this.readString();
            }
            if (values.length == size) {
                return values;
            }
            return Arrays.copyOf(values, size);
        }
        if (this.ch == '\"' || this.ch == '\'') {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw new JSONException(this.info("not support input " + str));
        }
        throw new JSONException(this.info("not support input"));
    }

    public char readCharValue() {
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            this.wasNull = true;
            return '\u0000';
        }
        return str.charAt(0);
    }

    public Character readCharacter() {
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            this.wasNull = true;
            return Character.valueOf('\u0000');
        }
        return Character.valueOf(str.charAt(0));
    }

    public abstract void readNull();

    public abstract boolean readIfNull();

    public abstract String getString();

    public boolean wasNull() {
        return this.wasNull;
    }

    public <T> T read(Type type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, null, null, 0L);
    }

    public final void read(List list) {
        if (!this.nextIfArrayStart()) {
            throw new JSONException("illegal input, offset " + this.offset + ", char " + this.ch);
        }
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        while (true) {
            if (this.nextIfArrayEnd()) {
                --this.level;
                break;
            }
            Object item = ObjectReaderImplObject.INSTANCE.readObject(this, null, null, 0L);
            list.add(item);
            this.nextIfComma();
        }
        this.nextIfComma();
    }

    public final void read(Collection list) {
        if (!this.nextIfArrayStart()) {
            throw new JSONException("illegal input, offset " + this.offset + ", char " + this.ch);
        }
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        while (true) {
            if (this.nextIfArrayEnd()) {
                --this.level;
                break;
            }
            Object item = this.readAny();
            list.add(item);
            this.nextIfComma();
        }
        this.nextIfComma();
    }

    public final void readObject(Object object, Feature ... features) {
        long featuresLong = 0L;
        for (Feature feature : features) {
            featuresLong |= feature.mask;
        }
        this.readObject(object, featuresLong);
    }

    public final void readObject(Object object, long features) {
        boolean fieldBased;
        if (object == null) {
            throw new JSONException("object is null");
        }
        Class<?> objectClass = object.getClass();
        ObjectReader objectReader = this.context.provider.getObjectReader(objectClass, fieldBased = ((this.context.features | features) & Feature.FieldBased.mask) != 0L);
        if (objectReader instanceof ObjectReaderBean) {
            ObjectReaderBean objectReaderBean = (ObjectReaderBean)objectReader;
            objectReaderBean.readObject(this, object, features);
        } else if (object instanceof Map) {
            this.read((Map)object, features);
        } else {
            throw new JSONException("read object not support");
        }
    }

    public void read(Map object, ObjectReader itemReader, long features) {
        this.nextIfObjectStart();
        Map map = object instanceof Wrapper ? ((Wrapper)((Object)object)).unwrap(Map.class) : object;
        long contextFeatures = features | this.context.getFeatures();
        int i = 0;
        while (true) {
            Object origin;
            if (this.ch == '/') {
                this.skipComment();
            }
            if (this.nextIfObjectEnd()) break;
            if (i != 0 && !this.comma) {
                throw new JSONException(this.info());
            }
            String name = this.readFieldName();
            Object value = itemReader.readObject(this, itemReader.getObjectClass(), name, features);
            if ((value != null || (contextFeatures & Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = map.put(name, value)) != null && (contextFeatures & Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                if (origin instanceof Collection) {
                    ((Collection)origin).add(value);
                    map.put(name, origin);
                } else {
                    JSONArray array = JSONArray.of(origin, value);
                    map.put(name, array);
                }
            }
            ++i;
        }
        this.nextIfComma();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(Map object, long features) {
        if (this.ch == '\'' && (this.context.features & Feature.DisableSingleQuote.mask) != 0L) {
            throw this.notSupportName();
        }
        if (!(this.ch != '\"' && this.ch != '\'' || this.typeRedirect)) {
            String str = this.readString();
            if (str.isEmpty()) {
                return;
            }
            if (str.charAt(0) == '{') {
                try (JSONReader jsonReader = JSONReader.of(str, this.context);){
                    jsonReader.readObject((Object)object, features);
                    return;
                }
            }
        }
        boolean match = this.nextIfObjectStart();
        boolean typeRedirect = false;
        if (!match) {
            typeRedirect = this.isTypeRedirect();
            if (typeRedirect) {
                this.setTypeRedirect(false);
            } else {
                String str;
                if (!this.isString() || !(str = this.readString()).isEmpty()) throw new JSONException(this.info());
                return;
            }
        }
        Map map = object instanceof Wrapper ? ((Wrapper)((Object)object)).unwrap(Map.class) : object;
        long contextFeatures = features | this.context.getFeatures();
        int i = 0;
        while (true) {
            block44: {
                Object origin;
                Object value;
                Object name;
                block45: {
                    if (this.ch == '/') {
                        this.skipComment();
                    }
                    if (this.nextIfObjectEnd()) break;
                    if (i != 0 && !this.comma) {
                        throw new JSONException(this.info());
                    }
                    if (match || typeRedirect) {
                        name = this.ch >= '0' && this.ch <= '9' || this.ch == '-' ? null : this.readFieldName();
                    } else {
                        name = this.getFieldName();
                        match = true;
                    }
                    if (name == null) {
                        if (this.isNumber()) {
                            name = this.readNumber();
                            if ((this.context.features & Feature.NonStringKeyAsString.mask) != 0L) {
                                name = name.toString();
                            }
                            if (this.comma) {
                                throw new JSONException(this.info("syntax error, illegal key-value"));
                            }
                        } else {
                            if ((this.context.features & Feature.AllowUnQuotedFieldNames.mask) == 0L) throw new JSONException(this.info("not allow unquoted fieldName"));
                            name = this.readFieldNameUnquote();
                        }
                        if (this.ch == ':') {
                            this.next();
                        }
                    }
                    if (!this.isReference()) break block45;
                    String reference = this.readReference();
                    Map value2 = null;
                    if ("..".equals(reference)) {
                        value2 = map;
                    } else {
                        JSONPath jsonPath;
                        try {
                            jsonPath = JSONPath.of(reference);
                        }
                        catch (Exception ignored) {
                            map.put(name, JSONObject.of("$ref", (Object)reference));
                            break block44;
                        }
                        this.addResolveTask(map, name, jsonPath);
                    }
                    map.put(name, value2);
                    break block44;
                }
                this.comma = false;
                switch (this.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = this.readNumber();
                        break;
                    }
                    case '[': {
                        value = this.readArray();
                        break;
                    }
                    case '{': {
                        if (typeRedirect) {
                            value = ObjectReaderImplObject.INSTANCE.readObject(this, null, name, features);
                            break;
                        }
                        value = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        value = this.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        value = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        value = this.readNullOrNewDate();
                        break;
                    }
                    case '/': {
                        this.next();
                        if (this.ch != '/') throw new JSONException("FASTJSON2.0.57input not support " + this.ch + ", offset " + this.offset);
                        this.skipComment();
                        break block44;
                    }
                    case 'S': {
                        if (!this.nextIfSet()) throw new JSONException("FASTJSON2.0.57error, offset " + this.offset + ", char " + this.ch);
                        value = this.read(HashSet.class);
                        break;
                    }
                    case 'I': {
                        if (!this.nextIfInfinity()) throw new JSONException("FASTJSON2.0.57error, offset " + this.offset + ", char " + this.ch);
                        value = Double.POSITIVE_INFINITY;
                        break;
                    }
                    case 'x': {
                        value = this.readBinary();
                        break;
                    }
                    default: {
                        throw new JSONException("FASTJSON2.0.57error, offset " + this.offset + ", char " + this.ch);
                    }
                }
                if (!(value == null && (contextFeatures & Feature.IgnoreNullPropertyValue.mask) != 0L || (contextFeatures & Feature.SupportAutoType.mask) != 0L && name.equals("@type") && object.getClass().getName().equals(value) || (origin = map.put(name, value)) == null || (contextFeatures & Feature.DuplicateKeyValueAsArray.mask) == 0L)) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value);
                        map.put(name, origin);
                    } else {
                        JSONArray array = JSONArray.of(origin, value);
                        map.put(name, array);
                    }
                }
            }
            ++i;
        }
        this.nextIfComma();
    }

    public final void read(Map object, Type keyType, Type valueType, long features) {
        boolean match = this.nextIfObjectStart();
        if (!match) {
            throw new JSONException("illegal input\uff0c offset " + this.offset + ", char " + this.ch);
        }
        ObjectReader keyReader = this.context.getObjectReader(keyType);
        ObjectReader valueReader = this.context.getObjectReader(valueType);
        long contextFeatures = features | this.context.getFeatures();
        int i = 0;
        while (true) {
            Object origin;
            String name;
            if (this.ch == '/') {
                this.skipComment();
            }
            if (this.nextIfObjectEnd()) break;
            if (i != 0 && !this.comma) {
                throw new JSONException(this.info());
            }
            if (keyType == String.class) {
                name = this.readFieldName();
            } else {
                name = keyReader.readObject(this, null, null, 0L);
                this.nextIfMatch(':');
            }
            Object value = valueReader.readObject(this, null, null, 0L);
            if ((value != null || (contextFeatures & Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = object.put(name, value)) != null && (contextFeatures & Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                if (origin instanceof Collection) {
                    ((Collection)origin).add(value);
                    object.put(name, origin);
                } else {
                    JSONArray array = JSONArray.of(origin, value);
                    object.put(name, array);
                }
            }
            ++i;
        }
        this.nextIfComma();
    }

    public <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, null, null, 0L);
    }

    public Map<String, Object> readObject() {
        JSONObject object;
        this.nextIfObjectStart();
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        Map innerMap = null;
        if (this.context.objectSupplier == null) {
            object = (this.context.features & Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
        } else {
            object = this.context.objectSupplier.get();
            innerMap = TypeUtils.getInnerMap(object);
        }
        int i = 0;
        while (true) {
            block28: {
                Object origin;
                Object val;
                if (this.ch == '/') {
                    this.skipComment();
                }
                if (this.ch == '}') break;
                Object name = this.readFieldName();
                if (name == null) {
                    if (this.ch == '\u001a') {
                        throw new JSONException("input end");
                    }
                    if (this.ch == '-' || this.ch >= '0' && this.ch <= '9') {
                        this.readNumber0();
                        name = this.getNumber();
                    } else {
                        name = this.ch == '{' ? this.readObject() : (this.ch == '[' ? this.readArray() : this.readFieldNameUnquote());
                    }
                    this.nextIfMatch(':');
                }
                if (i == 0 && (this.context.features & Feature.ErrorOnNotSupportAutoType.mask) != 0L && "@type".equals(name)) {
                    String typeName = this.readString();
                    throw new JSONException("autoType not support : " + typeName);
                }
                switch (this.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.readNumber0();
                        val = this.getNumber();
                        break;
                    }
                    case '[': {
                        val = this.readArray();
                        break;
                    }
                    case '{': {
                        if (this.isReference()) {
                            this.addResolveTask(object, name, JSONPath.of(this.readReference()));
                            val = null;
                            break;
                        }
                        val = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = this.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        val = this.readNullOrNewDate();
                        break;
                    }
                    case '/': {
                        this.skipComment();
                        break block28;
                    }
                    case 'I': {
                        if (this.nextIfInfinity()) {
                            val = Double.POSITIVE_INFINITY;
                            break;
                        }
                        throw new JSONException(this.info("illegal input " + this.ch));
                    }
                    case 'S': {
                        if (this.nextIfSet()) {
                            val = this.read(Set.class);
                            break;
                        }
                        throw new JSONException(this.info("illegal input " + this.ch));
                    }
                    default: {
                        throw new JSONException(this.info("illegal input " + this.ch));
                    }
                }
                if ((val != null || (this.context.features & Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = innerMap != null ? innerMap.put(name, val) : object.put(name, val)) != null && (this.context.features & Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(val);
                        object.put(name, origin);
                    } else {
                        JSONArray array = JSONArray.of(origin, val);
                        object.put(name, array);
                    }
                }
            }
            ++i;
        }
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        --this.level;
        return object;
    }

    public abstract void skipComment();

    public Boolean readBool() {
        if (this.nextIfNull()) {
            return null;
        }
        boolean boolValue = this.readBoolValue();
        if (!boolValue && this.wasNull) {
            return null;
        }
        return boolValue;
    }

    public abstract boolean readBoolValue();

    public Object readAny() {
        return this.read(Object.class);
    }

    public List readArray(Type itemType) {
        if (this.nextIfNull()) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.ch == '[') {
            this.next();
            boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = this.context.provider.getObjectReader(itemType, fieldBased);
            while (!this.nextIfArrayEnd()) {
                int mark = this.offset;
                Object item = objectReader.readObject(this, null, null, 0L);
                if (mark == this.offset || this.ch == '}' || this.ch == '\u001a') {
                    throw new JSONException("illegal input : " + this.ch + ", offset " + this.getOffset());
                }
                list.add(item);
            }
        } else if (this.ch == '\"' || this.ch == '\'' || this.ch == '{') {
            String str = this.readString();
            if (str != null && !str.isEmpty()) {
                list.add(str);
            }
        } else {
            throw new JSONException(this.info("syntax error"));
        }
        if (this.comma = this.ch == ',') {
            this.next();
        }
        return list;
    }

    public List readList(Type[] types) {
        if (this.nextIfNull()) {
            return null;
        }
        if (!this.nextIfArrayStart()) {
            throw new JSONException("syntax error : " + this.ch);
        }
        int i = 0;
        int max = types.length;
        ArrayList list = new ArrayList(max);
        while (!this.nextIfArrayEnd() && i < max) {
            int mark = this.offset;
            Object item = this.read(types[i++]);
            if (mark == this.offset || this.ch == '}' || this.ch == '\u001a') {
                throw new JSONException("illegal input : " + this.ch + ", offset " + this.getOffset());
            }
            list.add(item);
        }
        if (i != max) {
            throw new JSONException(this.info("element length mismatch"));
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return list;
    }

    public final Object[] readArray(Type[] types) {
        if (this.nextIfNull()) {
            return null;
        }
        if (!this.nextIfArrayStart()) {
            throw new JSONException(this.info("syntax error"));
        }
        int i = 0;
        int max = types.length;
        Object[] list = new Object[max];
        while (!this.nextIfArrayEnd() && i < max) {
            int mark = this.offset;
            Object item = this.read(types[i]);
            if (mark == this.offset || this.ch == '}' || this.ch == '\u001a') {
                throw new JSONException("illegal input : " + this.ch + ", offset " + this.getOffset());
            }
            list[i++] = item;
        }
        if (i != max) {
            throw new JSONException(this.info("element length mismatch"));
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return list;
    }

    public final void readArray(List list, Type itemType) {
        this.readArray((Collection)list, itemType);
    }

    public void readArray(Collection list, Type itemType) {
        if (this.nextIfArrayStart()) {
            while (!this.nextIfArrayEnd()) {
                Object item = this.read(itemType);
                list.add(item);
            }
            return;
        }
        if (this.isString()) {
            String str = this.readString();
            if (itemType == String.class) {
                list.add(str);
            } else {
                Function typeConvert = this.context.getProvider().getTypeConvert((Type)((Object)String.class), itemType);
                if (typeConvert == null) {
                    throw new JSONException(this.info("not support input " + str));
                }
                if (str.indexOf(44) != -1) {
                    String[] items;
                    for (String strItem : items = str.split(",")) {
                        Object item = typeConvert.apply(strItem);
                        list.add(item);
                    }
                } else {
                    Object item = typeConvert.apply(str);
                    list.add(item);
                }
            }
        } else {
            Object item = this.read(itemType);
            list.add(item);
        }
        if (this.comma = this.ch == ',') {
            this.next();
        }
    }

    public final JSONArray readJSONArray() {
        JSONArray array = new JSONArray();
        this.read(array);
        return array;
    }

    public final JSONObject readJSONObject() {
        JSONObject object = new JSONObject();
        this.read(object, 0L);
        return object;
    }

    public List readArray() {
        this.next();
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        int i = 0;
        List<Object> list = null;
        Map<String, Object> first = null;
        Map<String, Object> second = null;
        block10: while (true) {
            block29: {
                Object val;
                switch (this.ch) {
                    case ']': {
                        this.next();
                        break block10;
                    }
                    case '[': {
                        val = this.readArray();
                        break;
                    }
                    case '{': {
                        if (this.context.autoTypeBeforeHandler != null || (this.context.features & Feature.SupportAutoType.mask) != 0L) {
                            val = ObjectReaderImplObject.INSTANCE.readObject(this, null, null, 0L);
                            break;
                        }
                        if (this.isReference()) {
                            val = JSONPath.of(this.readReference());
                            break;
                        }
                        val = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = this.readString();
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.readNumber0();
                        val = this.getNumber();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        this.readNull();
                        val = null;
                        break;
                    }
                    case '/': {
                        this.skipComment();
                        break block29;
                    }
                    default: {
                        throw new JSONException(this.info());
                    }
                }
                if (i == 0) {
                    first = val;
                } else if (i == 1) {
                    second = val;
                } else if (i == 2) {
                    list = this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray();
                    this.add(list, 0, first);
                    this.add(list, 1, second);
                    this.add(list, i, val);
                } else {
                    this.add(list, i, val);
                }
            }
            ++i;
        }
        if (list == null) {
            if (this.context.arraySupplier != null) {
                list = this.context.arraySupplier.get();
            } else if (this.context.isEnabled(Feature.UseNativeObject)) {
                list = i == 2 ? new ArrayList(2) : new ArrayList(1);
            } else {
                JSONArray jSONArray = list = i == 2 ? new JSONArray(2) : new JSONArray(1);
            }
            if (i == 1) {
                this.add(list, 0, first);
            } else if (i == 2) {
                this.add(list, 0, first);
                this.add(list, 1, second);
            }
        }
        if (this.comma = this.ch == ',') {
            this.next();
        }
        --this.level;
        return list;
    }

    private void add(List<Object> list, int i, Object val) {
        if (val instanceof JSONPath) {
            this.addResolveTask(list, i, (JSONPath)val);
            list.add(null);
        } else {
            list.add(val);
        }
    }

    public final BigInteger getBigInteger() {
        Number number = this.getNumber();
        if (number == null) {
            return null;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public final BigDecimal getBigDecimal() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    return BigDecimal.valueOf(this.negative ? (long)(-this.mag3) : (long)this.mag3);
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return BigDecimal.valueOf(this.negative ? -v23 : v23);
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                int signum = this.negative ? -1 : 1;
                BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                return new BigDecimal(bigInt);
            }
            case 2: {
                BigDecimal decimal = null;
                if (this.exponent == 0 && this.mag0 == 0 && this.mag1 == 0) {
                    if (this.mag2 == 0 && this.mag3 >= 0) {
                        int unscaledVal = this.negative ? -this.mag3 : this.mag3;
                        decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                    } else {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            long unscaledVal = this.negative ? -v23 : v23;
                            decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                        }
                    }
                }
                if (decimal == null) {
                    int[] nArray;
                    if (this.mag0 == 0) {
                        if (this.mag1 == 0) {
                            if (this.mag2 == 0) {
                                int[] nArray2 = new int[1];
                                nArray = nArray2;
                                nArray2[0] = this.mag3;
                            } else {
                                int[] nArray3 = new int[2];
                                nArray3[0] = this.mag2;
                                nArray = nArray3;
                                nArray3[1] = this.mag3;
                            }
                        } else {
                            int[] nArray4 = new int[3];
                            nArray4[0] = this.mag1;
                            nArray4[1] = this.mag2;
                            nArray = nArray4;
                            nArray4[2] = this.mag3;
                        }
                    } else {
                        int[] nArray5 = new int[4];
                        nArray5[0] = this.mag0;
                        nArray5[1] = this.mag1;
                        nArray5[2] = this.mag2;
                        nArray = nArray5;
                        nArray5[3] = this.mag3;
                    }
                    int[] mag = nArray;
                    int signum = this.negative ? -1 : 1;
                    BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                    decimal = new BigDecimal(bigInt, this.scale);
                }
                if (this.exponent != 0) {
                    String doubleStr = decimal.toPlainString() + "E" + this.exponent;
                    double doubleValue = Double.parseDouble(doubleStr);
                    return TypeUtils.toBigDecimal(doubleValue);
                }
                return decimal;
            }
            case 8: {
                return TypeUtils.toBigDecimal(this.stringValue);
            }
            case 4: {
                return this.boolValue ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case 3: {
                try {
                    return TypeUtils.toBigDecimal(this.stringValue);
                }
                catch (NumberFormatException ex) {
                    throw new JSONException(this.info("read decimal error, value " + this.stringValue), ex);
                }
            }
            case 6: {
                JSONObject object = (JSONObject)this.complex;
                BigDecimal decimal = object.getBigDecimal("value");
                if (decimal == null) {
                    decimal = object.getBigDecimal("$numberDecimal");
                }
                if (decimal != null) {
                    return decimal;
                }
                throw new JSONException("TODO : " + this.valueType);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public final Number getNumber() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: 
            case 11: {
                int[] mag;
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    int intValue;
                    if (this.negative) {
                        if (this.mag3 < 0) {
                            long longValue = -((long)this.mag3 & 0xFFFFFFFFL);
                            if ((this.context.features & Feature.UseBigIntegerForInts.mask) != 0L) {
                                return BigInteger.valueOf(longValue);
                            }
                            return longValue;
                        }
                        intValue = -this.mag3;
                    } else {
                        if (this.mag3 < 0) {
                            long longValue = (long)this.mag3 & 0xFFFFFFFFL;
                            if ((this.context.features & Feature.UseBigIntegerForInts.mask) != 0L) {
                                return BigInteger.valueOf(longValue);
                            }
                            return longValue;
                        }
                        intValue = this.mag3;
                    }
                    if ((this.context.features & Feature.UseBigIntegerForInts.mask) != 0L) {
                        return BigInteger.valueOf(intValue);
                    }
                    if ((this.context.features & Feature.UseLongForInts.mask) != 0L) {
                        return (long)intValue;
                    }
                    if (this.valueType == 11) {
                        return (long)intValue;
                    }
                    return intValue;
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long longValue;
                            long v23 = (v2 << 32) + v3;
                            long l = longValue = this.negative ? -v23 : v23;
                            if ((this.context.features & Feature.UseBigIntegerForInts.mask) != 0L) {
                                return BigInteger.valueOf(longValue);
                            }
                            return longValue;
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                int signum = this.negative ? -1 : 1;
                BigInteger integer = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                if ((this.context.features & Feature.UseLongForInts.mask) != 0L) {
                    return integer.longValue();
                }
                return integer;
            }
            case 10: {
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    int intValue = this.negative ? -this.mag3 : this.mag3;
                    return (short)intValue;
                }
                throw new JSONException(this.info("shortValue overflow"));
            }
            case 9: {
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    int intValue = this.negative ? -this.mag3 : this.mag3;
                    return (byte)intValue;
                }
                throw new JSONException(this.info("shortValue overflow"));
            }
            case 2: {
                BigDecimal decimal = null;
                if (this.mag0 == 0 && this.mag1 == 0) {
                    if (this.mag2 == 0 && this.mag3 >= 0) {
                        int unscaledVal = this.negative ? -this.mag3 : this.mag3;
                        decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                    } else {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long unscaledVal;
                            long v23 = (v2 << 32) + v3;
                            long l = unscaledVal = this.negative ? -v23 : v23;
                            if (this.exponent == 0) {
                                if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                                    long unsignedUnscaledVal;
                                    boolean isNegative;
                                    if (unscaledVal < 0L) {
                                        isNegative = true;
                                        unsignedUnscaledVal = -unscaledVal;
                                    } else {
                                        isNegative = false;
                                        unsignedUnscaledVal = unscaledVal;
                                    }
                                    int len = IOUtils.stringSize(unsignedUnscaledVal);
                                    if (this.doubleChars == null) {
                                        this.doubleChars = new byte[20];
                                    }
                                    IOUtils.getChars(unsignedUnscaledVal, len, this.doubleChars);
                                    return Float.valueOf(TypeUtils.floatValue(isNegative, len - this.scale, this.doubleChars, len));
                                }
                                if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                                    int len;
                                    long unsignedUnscaledVal;
                                    boolean isNegative;
                                    if (unscaledVal < 0L) {
                                        isNegative = true;
                                        unsignedUnscaledVal = -unscaledVal;
                                    } else {
                                        isNegative = false;
                                        unsignedUnscaledVal = unscaledVal;
                                    }
                                    if (unsignedUnscaledVal < 0x10000000000000L) {
                                        if (this.scale > 0 && this.scale < JSONFactory.DOUBLE_10_POW.length) {
                                            return (double)unscaledVal / JSONFactory.DOUBLE_10_POW[this.scale];
                                        }
                                        if (this.scale < 0 && this.scale > -JSONFactory.DOUBLE_10_POW.length) {
                                            return (double)unscaledVal * JSONFactory.DOUBLE_10_POW[-this.scale];
                                        }
                                    }
                                    int n = unsignedUnscaledVal < 10000000000000000L ? 16 : (unsignedUnscaledVal < 100000000000000000L ? 17 : (len = unsignedUnscaledVal < 1000000000000000000L ? 18 : 19));
                                    if (this.doubleChars == null) {
                                        this.doubleChars = new byte[20];
                                    }
                                    IOUtils.getChars(unsignedUnscaledVal, len, this.doubleChars);
                                    return TypeUtils.doubleValue(isNegative, len - this.scale, this.doubleChars, len);
                                }
                            }
                            decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                        }
                    }
                }
                if (decimal == null) {
                    int[] nArray;
                    if (this.mag0 == 0) {
                        if (this.mag1 == 0) {
                            int[] nArray2 = new int[2];
                            nArray2[0] = this.mag2;
                            nArray = nArray2;
                            nArray2[1] = this.mag3;
                        } else {
                            int[] nArray3 = new int[3];
                            nArray3[0] = this.mag1;
                            nArray3[1] = this.mag2;
                            nArray = nArray3;
                            nArray3[2] = this.mag3;
                        }
                    } else {
                        int[] nArray4 = new int[4];
                        nArray4[0] = this.mag0;
                        nArray4[1] = this.mag1;
                        nArray4[2] = this.mag2;
                        nArray = nArray4;
                        nArray4[3] = this.mag3;
                    }
                    int[] mag = nArray;
                    int signum = this.negative ? -1 : 1;
                    BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                    int adjustedScale = this.scale - this.exponent;
                    decimal = new BigDecimal(bigInt, adjustedScale);
                    if (this.exponent != 0 && (this.context.features & (Feature.UseBigDecimalForDoubles.mask | Feature.UseBigDecimalForFloats.mask)) == 0L) {
                        return decimal.doubleValue();
                    }
                }
                if (this.exponent != 0) {
                    String decimalStr = decimal.toPlainString();
                    if ((this.context.features & (Feature.UseBigDecimalForDoubles.mask | Feature.UseBigDecimalForFloats.mask)) == 0L) {
                        return Double.parseDouble(decimalStr + "E" + this.exponent);
                    }
                    return decimal.signum() == 0 ? BigDecimal.ZERO : new BigDecimal(decimalStr + "E" + this.exponent);
                }
                if ((this.context.features & Feature.UseDoubleForDecimals.mask) != 0L) {
                    return decimal.doubleValue();
                }
                return decimal;
            }
            case 8: {
                if (this.scale > 0) {
                    if (this.scale > JSONFactory.defaultDecimalMaxScale) {
                        throw new JSONException("scale overflow : " + this.scale);
                    }
                    return TypeUtils.toBigDecimal(this.stringValue);
                }
                return new BigInteger(this.stringValue);
            }
            case 12: 
            case 13: {
                int[] nArray;
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == 0) {
                            int[] nArray5 = new int[1];
                            nArray = nArray5;
                            nArray5[0] = this.mag3;
                        } else {
                            int[] nArray6 = new int[2];
                            nArray6[0] = this.mag2;
                            nArray = nArray6;
                            nArray6[1] = this.mag3;
                        }
                    } else {
                        int[] nArray7 = new int[3];
                        nArray7[0] = this.mag1;
                        nArray7[1] = this.mag2;
                        nArray = nArray7;
                        nArray7[2] = this.mag3;
                    }
                } else {
                    int[] nArray8 = new int[4];
                    nArray8[0] = this.mag0;
                    nArray8[1] = this.mag1;
                    nArray8[2] = this.mag2;
                    nArray = nArray8;
                    nArray8[3] = this.mag3;
                }
                int[] mag = nArray;
                int signum = this.negative ? -1 : 1;
                BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                BigDecimal decimal = new BigDecimal(bigInt, this.scale);
                if (this.valueType == 12) {
                    if (this.exponent != 0) {
                        return Float.valueOf(Float.parseFloat(decimal + "E" + this.exponent));
                    }
                    return Float.valueOf(decimal.floatValue());
                }
                if (this.exponent != 0) {
                    return Double.parseDouble(decimal + "E" + this.exponent);
                }
                return decimal.doubleValue();
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                return null;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toNumber((Map)this.complex);
            }
            case 7: {
                return this.toNumber((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    @Override
    public abstract void close();

    protected final int toInt32(String val) {
        if (IOUtils.isNumber(val) || val.lastIndexOf(44) == val.length() - 4) {
            return TypeUtils.toIntValue(val);
        }
        throw this.error("parseInt error, value : " + val);
    }

    protected final long toInt64(String val) {
        if (IOUtils.isNumber(val) || val.lastIndexOf(44) == val.length() - 4) {
            return TypeUtils.toLongValue(val);
        }
        if (val.length() > 10 && val.length() < 40) {
            try {
                return DateUtils.parseMillis(val, this.context.zoneId);
            }
            catch (JSONException | NullPointerException | DateTimeException runtimeException) {
                // empty catch block
            }
        }
        throw this.error("parseLong error, value : " + val);
    }

    protected final long toLong(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw this.error("parseLong error, value : " + map);
    }

    protected final int toInt(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
        }
        throw this.error("parseLong error, field : value " + list);
    }

    protected final Number toNumber(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return (Number)val;
        }
        return null;
    }

    protected final BigDecimal decimal(JSONObject object) {
        BigDecimal decimal = object.getBigDecimal("value");
        if (decimal == null) {
            decimal = object.getBigDecimal("$numberDecimal");
        }
        if (decimal != null) {
            return decimal;
        }
        throw this.error("can not cast to decimal " + object);
    }

    protected final Number toNumber(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return (Number)val;
            }
            if (val instanceof String) {
                return TypeUtils.toBigDecimal((String)val);
            }
        }
        return null;
    }

    protected final String toString(List array) {
        JSONWriter writer = JSONWriter.of();
        writer.setRootObject(array);
        writer.write(array);
        return writer.toString();
    }

    protected final String toString(Map object) {
        JSONWriter writer = JSONWriter.of();
        writer.setRootObject(object);
        writer.write(object);
        return writer.toString();
    }

    public static JSONReader of(byte[] utf8Bytes) {
        return JSONReader.of(utf8Bytes, 0, utf8Bytes.length, StandardCharsets.UTF_8, JSONFactory.createReadContext());
    }

    @Deprecated
    public static JSONReader of(Context context, byte[] utf8Bytes) {
        return JSONReaderUTF8.of(utf8Bytes, 0, utf8Bytes.length, context);
    }

    public static JSONReader of(byte[] utf8Bytes, Context context) {
        return JSONReaderUTF8.of(utf8Bytes, 0, utf8Bytes.length, context);
    }

    public static JSONReader of(char[] chars) {
        return JSONReader.ofUTF16(null, chars, 0, chars.length, JSONFactory.createReadContext());
    }

    @Deprecated
    public static JSONReader of(Context context, char[] chars) {
        return JSONReader.ofUTF16(null, chars, 0, chars.length, context);
    }

    public static JSONReader of(char[] chars, Context context) {
        return JSONReader.ofUTF16(null, chars, 0, chars.length, context);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), jsonbBytes, 0, jsonbBytes.length);
    }

    @Deprecated
    public static JSONReader ofJSONB(Context context, byte[] jsonbBytes) {
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes, Context context) {
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(InputStream in, Context context) {
        return new JSONReaderJSONB(context, in);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes, Feature ... features) {
        Context context = JSONFactory.createReadContext();
        context.config(features);
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), bytes, offset, length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length, Context context) {
        return new JSONReaderJSONB(context, bytes, offset, length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length, SymbolTable symbolTable) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(symbolTable), bytes, offset, length);
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Charset charset) {
        Context context = JSONFactory.createReadContext();
        if (charset == StandardCharsets.UTF_8) {
            return JSONReaderUTF8.of(bytes, offset, length, context);
        }
        if (charset == StandardCharsets.UTF_16) {
            return JSONReader.ofUTF16(bytes, offset, length, context);
        }
        if (charset == StandardCharsets.US_ASCII || charset == StandardCharsets.ISO_8859_1) {
            return JSONReaderASCII.of(context, null, bytes, offset, length);
        }
        throw new JSONException("not support charset " + charset);
    }

    private static JSONReader ofUTF16(byte[] bytes, int offset, int length, Context ctx) {
        return new JSONReaderUTF16(ctx, bytes, offset, length);
    }

    private static JSONReader ofUTF16(String str, char[] chars, int offset, int length, Context ctx) {
        return new JSONReaderUTF16(ctx, str, chars, offset, length);
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Charset charset, Context context) {
        if (charset == StandardCharsets.UTF_8) {
            return JSONReaderUTF8.of(bytes, offset, length, context);
        }
        if (charset == StandardCharsets.UTF_16) {
            return JSONReader.ofUTF16(bytes, offset, length, context);
        }
        if (charset == StandardCharsets.US_ASCII || charset == StandardCharsets.ISO_8859_1) {
            return JSONReaderASCII.of(context, null, bytes, offset, length);
        }
        throw new JSONException("not support charset " + charset);
    }

    public static JSONReader of(byte[] bytes, int offset, int length) {
        return JSONReader.of(bytes, offset, length, StandardCharsets.UTF_8, JSONFactory.createReadContext());
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Context context) {
        return new JSONReaderUTF8(context, bytes, offset, length);
    }

    public static JSONReader of(char[] chars, int offset, int length) {
        return JSONReader.ofUTF16(null, chars, offset, length, JSONFactory.createReadContext());
    }

    public static JSONReader of(char[] chars, int offset, int length, Context context) {
        return JSONReader.ofUTF16(null, chars, offset, length, context);
    }

    public static JSONReader of(URL url, Context context) throws IOException {
        try (InputStream is = url.openStream();){
            JSONReader jSONReader = JSONReader.of(is, StandardCharsets.UTF_8, context);
            return jSONReader;
        }
    }

    public static JSONReader of(InputStream is, Charset charset) {
        Context context = JSONFactory.createReadContext();
        return JSONReader.of(is, charset, context);
    }

    public static JSONReader of(InputStream is, Charset charset, Context context) {
        if (is == null) {
            throw new JSONException("inputStream is null");
        }
        if (charset == StandardCharsets.UTF_8 || charset == null) {
            return new JSONReaderUTF8(context, is);
        }
        if (charset == StandardCharsets.UTF_16) {
            return new JSONReaderUTF16(context, is);
        }
        if (charset == StandardCharsets.US_ASCII) {
            return JSONReaderASCII.of(context, is);
        }
        return JSONReader.of(new InputStreamReader(is, charset), context);
    }

    public static JSONReader of(Reader is) {
        return new JSONReaderUTF16(JSONFactory.createReadContext(), is);
    }

    public static JSONReader of(Reader is, Context context) {
        return new JSONReaderUTF16(context, is);
    }

    public static JSONReader of(ByteBuffer buffer, Charset charset) {
        Context context = JSONFactory.createReadContext();
        if (charset == StandardCharsets.UTF_8 || charset == null) {
            return new JSONReaderUTF8(context, buffer);
        }
        throw new JSONException("not support charset " + charset);
    }

    public static JSONReader of(ByteBuffer buffer, Charset charset, Context context) {
        if (charset == StandardCharsets.UTF_8 || charset == null) {
            return new JSONReaderUTF8(context, buffer);
        }
        throw new JSONException("not support charset " + charset);
    }

    @Deprecated
    public static JSONReader of(Context context, String str) {
        return JSONReader.of(str, context);
    }

    public static JSONReader of(String str) {
        return JSONReader.of(str, JSONFactory.createReadContext());
    }

    public static JSONReader of(String str, Context context) {
        if (str == null || context == null) {
            throw new NullPointerException();
        }
        if (JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER != null) {
            try {
                boolean LATIN12 = false;
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
                    return JSONReaderASCII.of(context, str, bytes, 0, bytes.length);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        int length = str.length();
        char[] chars = JDKUtils.JVM_VERSION == 8 ? JDKUtils.getCharArray(str) : str.toCharArray();
        return JSONReader.ofUTF16(str, chars, 0, length, context);
    }

    public static JSONReader of(String str, int offset, int length) {
        return JSONReader.of(str, offset, length, JSONFactory.createReadContext());
    }

    public static JSONReader of(String str, int offset, int length, Context context) {
        if (str == null || context == null) {
            throw new NullPointerException();
        }
        if (JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER != null) {
            try {
                boolean LATIN12 = false;
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
                    return JSONReaderASCII.of(context, str, bytes, offset, length);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        char[] chars = JDKUtils.JVM_VERSION == 8 ? JDKUtils.getCharArray(str) : str.toCharArray();
        return JSONReader.ofUTF16(str, chars, offset, length, context);
    }

    final void bigInt(char[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = chars[start++]) == '.') {
            c = chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = chars[index];
            if (c == '.') {
                c = chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = chars[start2++]) == '.') {
                c2 = chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = chars[index];
                if (c2 == '.') {
                    c2 = chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                long product;
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    final void bigInt(byte[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = (char)chars[start++]) == '.') {
            c = (char)chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = (char)chars[index];
            if (c == '.') {
                c = (char)chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = (char)chars[start2++]) == '.') {
                c2 = (char)chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = (char)chars[index];
                if (c2 == '.') {
                    c2 = (char)chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                long product;
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    public static AutoTypeBeforeHandler autoTypeFilter(String ... names) {
        return new ContextAutoTypeBeforeHandler(names);
    }

    public static AutoTypeBeforeHandler autoTypeFilter(boolean includeBasic, String ... names) {
        return new ContextAutoTypeBeforeHandler(includeBasic, names);
    }

    public static AutoTypeBeforeHandler autoTypeFilter(Class ... types) {
        return new ContextAutoTypeBeforeHandler(types);
    }

    public static AutoTypeBeforeHandler autoTypeFilter(boolean includeBasic, Class ... types) {
        return new ContextAutoTypeBeforeHandler(includeBasic, types);
    }

    public SavePoint mark() {
        return new SavePoint(this.offset, this.ch);
    }

    public void reset(SavePoint savePoint) {
        this.offset = savePoint.offset;
        this.ch = (char)savePoint.current;
    }

    final boolean checkNameBegin(int quote) {
        long features = this.context.features;
        if (quote == 39 && (features & 0x80000000L) != 0L) {
            throw this.notSupportName();
        }
        if (quote != 34 && quote != 39) {
            if ((features & 0x20000L) != 0L) {
                this.readFieldNameHashCodeUnquote();
                return true;
            }
            throw this.notSupportName();
        }
        return false;
    }

    final JSONException notSupportName() {
        return new JSONException(this.info("not support unquoted name"));
    }

    final JSONException valueError() {
        return new JSONException(this.info("illegal value"));
    }

    final JSONException error(String message) {
        return new JSONException(this.info(message));
    }

    final JSONException error(String message, Exception cause) {
        return new JSONException(this.info(message), cause);
    }

    final JSONException error() {
        throw new JSONValidException("error, offset " + this.offset + ", char " + this.ch);
    }

    final JSONException error(int offset, int ch) {
        throw new JSONValidException("error, offset " + offset + ", char " + (char)ch);
    }

    static JSONException syntaxError(int ch) {
        return new JSONException("syntax error, expect ',', but '" + (char)ch + "'");
    }

    static JSONException syntaxError(int offset, int ch) {
        return new JSONException("syntax error, offset " + offset + ", char " + (char)ch);
    }

    static JSONException numberError(int offset, int ch) {
        return new JSONException("illegal number, offset " + offset + ", char " + (char)ch);
    }

    JSONException numberError() {
        return new JSONException("illegal number, offset " + this.offset + ", char " + this.ch);
    }

    public final String info() {
        return this.info(null);
    }

    public String info(String message) {
        if (message == null || message.isEmpty()) {
            return "offset " + this.offset;
        }
        return message + ", offset " + this.offset;
    }

    static boolean isFirstIdentifier(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95 || ch == 36 || ch >= 48 && ch <= 57 || ch > 127;
    }

    public ObjectReader getObjectReaderAutoType(long typeHash, Class expectClass, long features) {
        Class<?> autoTypeClass;
        ObjectReader autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
        if (autoTypeObjectReader != null) {
            return autoTypeObjectReader;
        }
        String typeName = this.getString();
        if (this.context.autoTypeBeforeHandler != null && (autoTypeClass = this.context.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            boolean fieldBased = (features & Feature.FieldBased.mask) != 0L;
            return this.context.provider.getObjectReader(autoTypeClass, fieldBased);
        }
        return this.context.provider.getObjectReader(typeName, expectClass, this.context.features | features);
    }

    protected final String readStringNotMatch() {
        switch (this.ch) {
            case '[': {
                List array = this.readArray();
                if (array.size() == 1) {
                    Object item = array.get(0);
                    if (item == null) {
                        return null;
                    }
                    if (item instanceof String) {
                        return item.toString();
                    }
                }
                return this.toString(array);
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException(this.info("illegal input : " + this.ch));
    }

    protected static String stringValue(String str, long features) {
        if ((features & 0x4000L) != 0L) {
            str = str.trim();
        }
        if ((features & 0x8000000L) != 0L && str.isEmpty()) {
            return null;
        }
        return str;
    }

    static {
        char[] chars;
        INT_VALUE_END = new boolean[256];
        Arrays.fill(INT_VALUE_END, true);
        for (char ch : chars = new char[]{'.', 'e', 'E', 't', 'f', 'n', '{', '[', '0', '1', '2', '2', '3', '4', '5', '6', '7', '8', '9'}) {
            JSONReader.INT_VALUE_END[ch] = false;
        }
    }

    public static final class Context {
        String dateFormat;
        boolean formatComplex;
        boolean formatyyyyMMddhhmmss19;
        boolean formatyyyyMMddhhmmssT19;
        boolean yyyyMMddhhmm16;
        boolean formatyyyyMMdd8;
        boolean formatMillis;
        boolean formatUnixTime;
        boolean formatISO8601;
        boolean formatHasDay;
        boolean formatHasHour;
        boolean useSimpleFormatter;
        int maxLevel = 2048;
        int bufferSize = 524288;
        DateTimeFormatter dateFormatter;
        ZoneId zoneId;
        long features;
        Locale locale;
        TimeZone timeZone;
        Supplier<Map> objectSupplier;
        Supplier<List> arraySupplier;
        AutoTypeBeforeHandler autoTypeBeforeHandler;
        ExtraProcessor extraProcessor;
        final ObjectReaderProvider provider;
        final SymbolTable symbolTable;

        public Context(ObjectReaderProvider provider) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(ObjectReaderProvider provider, long features) {
            this.features = features;
            this.provider = provider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = JSONFactory.getDefaultObjectReaderProvider();
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public Context(String dateFormat, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = JSONFactory.getDefaultObjectReaderProvider();
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
            this.setDateFormat(dateFormat);
        }

        public Context(ObjectReaderProvider provider, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public Context(ObjectReaderProvider provider, Filter filter, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            this.config(filter);
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.symbolTable = symbolTable;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.symbolTable = symbolTable;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable, Filter[] filters, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.symbolTable = symbolTable;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            this.config(filters);
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public boolean isFormatUnixTime() {
            return this.formatUnixTime;
        }

        public boolean isFormatyyyyMMddhhmmss19() {
            return this.formatyyyyMMddhhmmss19;
        }

        public boolean isFormatyyyyMMddhhmmssT19() {
            return this.formatyyyyMMddhhmmssT19;
        }

        public boolean isFormatyyyyMMdd8() {
            return this.formatyyyyMMdd8;
        }

        public boolean isFormatMillis() {
            return this.formatMillis;
        }

        public boolean isFormatISO8601() {
            return this.formatISO8601;
        }

        public boolean isFormatHasHour() {
            return this.formatHasHour;
        }

        public ObjectReader getObjectReader(Type type) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectReader(type, fieldBased);
        }

        public ObjectReaderProvider getProvider() {
            return this.provider;
        }

        public ObjectReader getObjectReaderAutoType(long hashCode) {
            return this.provider.getObjectReader(hashCode);
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass) {
            Class<?> autoTypeClass;
            if (this.autoTypeBeforeHandler != null && (autoTypeClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, this.features)) != null) {
                boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
                return this.provider.getObjectReader(autoTypeClass, fieldBased);
            }
            return this.provider.getObjectReader(typeName, expectClass, this.features);
        }

        public AutoTypeBeforeHandler getContextAutoTypeBeforeHandler() {
            return this.autoTypeBeforeHandler;
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass, long features) {
            Class<?> autoTypeClass;
            if (this.autoTypeBeforeHandler != null && (autoTypeClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
                boolean fieldBased = (features & Feature.FieldBased.mask) != 0L;
                return this.provider.getObjectReader(autoTypeClass, fieldBased);
            }
            return this.provider.getObjectReader(typeName, expectClass, this.features | features);
        }

        public ExtraProcessor getExtraProcessor() {
            return this.extraProcessor;
        }

        public void setExtraProcessor(ExtraProcessor extraProcessor) {
            this.extraProcessor = extraProcessor;
        }

        public Supplier<Map> getObjectSupplier() {
            return this.objectSupplier;
        }

        public void setObjectSupplier(Supplier<Map> objectSupplier) {
            this.objectSupplier = objectSupplier;
        }

        public Supplier<List> getArraySupplier() {
            return this.arraySupplier;
        }

        public void setArraySupplier(Supplier<List> arraySupplier) {
            this.arraySupplier = arraySupplier;
        }

        public DateTimeFormatter getDateFormatter() {
            if (!(this.dateFormatter != null || this.dateFormat == null || this.formatMillis || this.formatISO8601 || this.formatUnixTime)) {
                this.dateFormatter = this.locale == null ? DateTimeFormatter.ofPattern(this.dateFormat) : DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
            }
            return this.dateFormatter;
        }

        public void setDateFormatter(DateTimeFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String format) {
            if (format != null && format.isEmpty()) {
                format = null;
            }
            boolean formatUnixTime = false;
            boolean formatISO8601 = false;
            boolean formatMillis = false;
            boolean hasDay = false;
            boolean hasHour = false;
            boolean useSimpleFormatter = false;
            if (format != null) {
                switch (format) {
                    case "unixtime": {
                        formatUnixTime = true;
                        break;
                    }
                    case "iso8601": {
                        formatISO8601 = true;
                        break;
                    }
                    case "millis": {
                        formatMillis = true;
                        break;
                    }
                    case "yyyyMMddHHmmssSSSZ": {
                        useSimpleFormatter = true;
                    }
                    case "yyyy-MM-dd HH:mm:ss": 
                    case "yyyy-MM-ddTHH:mm:ss": {
                        this.formatyyyyMMddhhmmss19 = true;
                        hasDay = true;
                        hasHour = true;
                        break;
                    }
                    case "yyyy-MM-dd'T'HH:mm:ss": {
                        this.formatyyyyMMddhhmmssT19 = true;
                        hasDay = true;
                        hasHour = true;
                        break;
                    }
                    case "yyyyMMdd": 
                    case "yyyy-MM-dd": {
                        this.formatyyyyMMdd8 = true;
                        hasDay = true;
                        hasHour = false;
                        break;
                    }
                    case "yyyy-MM-dd HH:mm": {
                        this.yyyyMMddhhmm16 = true;
                        break;
                    }
                    default: {
                        hasDay = format.indexOf(100) != -1;
                        hasHour = format.indexOf(72) != -1 || format.indexOf(104) != -1 || format.indexOf(75) != -1 || format.indexOf(107) != -1;
                    }
                }
                boolean bl = this.formatComplex = !(this.formatyyyyMMddhhmmss19 | this.formatyyyyMMddhhmmssT19 | this.formatyyyyMMdd8 | formatISO8601);
            }
            if (!Objects.equals(this.dateFormat, format)) {
                this.dateFormatter = null;
            }
            this.dateFormat = format;
            this.formatUnixTime = formatUnixTime;
            this.formatMillis = formatMillis;
            this.formatISO8601 = formatISO8601;
            this.formatHasDay = hasDay;
            this.formatHasHour = hasHour;
            this.useSimpleFormatter = useSimpleFormatter;
        }

        public ZoneId getZoneId() {
            if (this.zoneId == null) {
                this.zoneId = DateUtils.DEFAULT_ZONE_ID;
            }
            return this.zoneId;
        }

        public long getFeatures() {
            return this.features;
        }

        public void setFeatures(long features) {
            this.features = features;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public Context setBufferSize(int bufferSize) {
            if (bufferSize < 0) {
                throw new IllegalArgumentException("buffer size can not be less than zero");
            }
            this.bufferSize = bufferSize;
            return this;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public void config(Feature ... features) {
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public void config(Filter filter, Feature ... features) {
            if (filter instanceof AutoTypeBeforeHandler) {
                this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
            }
            if (filter instanceof ExtraProcessor) {
                this.extraProcessor = (ExtraProcessor)filter;
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public void config(Filter filter) {
            if (filter instanceof AutoTypeBeforeHandler) {
                this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
            }
            if (filter instanceof ExtraProcessor) {
                this.extraProcessor = (ExtraProcessor)filter;
            }
        }

        public void config(Filter[] filters, Feature ... features) {
            for (Filter filter : filters) {
                if (filter instanceof AutoTypeBeforeHandler) {
                    this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
                }
                if (!(filter instanceof ExtraProcessor)) continue;
                this.extraProcessor = (ExtraProcessor)filter;
            }
            for (Feature feature : features) {
                this.features |= feature.mask;
            }
        }

        public void config(Filter[] filters) {
            for (Filter filter : filters) {
                if (filter instanceof AutoTypeBeforeHandler) {
                    this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
                }
                if (!(filter instanceof ExtraProcessor)) continue;
                this.extraProcessor = (ExtraProcessor)filter;
            }
        }

        public boolean isEnabled(Feature feature) {
            return (this.features & feature.mask) != 0L;
        }

        public void config(Feature feature, boolean state) {
            this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static enum Feature {
        FieldBased(1L),
        IgnoreNoneSerializable(2L),
        ErrorOnNoneSerializable(4L),
        SupportArrayToBean(8L),
        InitStringFieldAsEmpty(16L),
        SupportAutoType(32L),
        SupportSmartMatch(64L),
        UseNativeObject(128L),
        SupportClassForName(256L),
        IgnoreSetNullValue(512L),
        UseDefaultConstructorAsPossible(1024L),
        UseBigDecimalForFloats(2048L),
        UseBigDecimalForDoubles(4096L),
        ErrorOnEnumNotMatch(8192L),
        TrimString(16384L),
        ErrorOnNotSupportAutoType(32768L),
        DuplicateKeyValueAsArray(65536L),
        AllowUnQuotedFieldNames(131072L),
        NonStringKeyAsString(262144L),
        Base64StringAsByteArray(524288L),
        IgnoreCheckClose(0x100000L),
        ErrorOnNullForPrimitives(0x200000L),
        NullOnError(0x400000L),
        IgnoreAutoTypeNotMatch(0x800000L),
        NonZeroNumberCastToBooleanAsTrue(0x1000000L),
        IgnoreNullPropertyValue(0x2000000L),
        ErrorOnUnknownProperties(0x4000000L),
        EmptyStringAsNull(0x8000000L),
        NonErrorOnNumberOverflow(0x10000000L),
        UseBigIntegerForInts(0x20000000L),
        UseLongForInts(0x40000000L),
        DisableSingleQuote(0x80000000L),
        UseDoubleForDecimals(0x100000000L),
        DisableReferenceDetect(0x200000000L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }

        public static long of(Feature[] features) {
            if (features == null) {
                return 0L;
            }
            long value = 0L;
            for (Feature feature : features) {
                value |= feature.mask;
            }
            return value;
        }

        public boolean isEnabled(long features) {
            return (features & this.mask) != 0L;
        }

        public static boolean isEnabled(long features, Feature feature) {
            return (features & feature.mask) != 0L;
        }
    }

    static final class ResolveTask {
        final FieldReader fieldReader;
        final Object object;
        final Object name;
        final JSONPath reference;

        ResolveTask(FieldReader fieldReader, Object object, Object name, JSONPath reference) {
            this.fieldReader = fieldReader;
            this.object = object;
            this.name = name;
            this.reference = reference;
        }

        public String toString() {
            return this.reference.toString();
        }
    }

    public static interface AutoTypeBeforeHandler
    extends Filter {
        default public Class<?> apply(long typeNameHash, Class<?> expectClass, long features) {
            return null;
        }

        public Class<?> apply(String var1, Class<?> var2, long var3);
    }

    static final class BigIntegerCreator
    implements BiFunction<Integer, int[], BigInteger> {
        static final BiFunction<Integer, int[], BigInteger> BIG_INTEGER_CREATOR;

        BigIntegerCreator() {
        }

        @Override
        public BigInteger apply(Integer integer, int[] mag) {
            int bitLength;
            int signum = integer;
            if (mag.length == 0) {
                bitLength = 0;
            } else {
                int bitLengthForInt = 32 - Integer.numberOfLeadingZeros(mag[0]);
                int magBitLength = (mag.length - 1 << 5) + bitLengthForInt;
                if (signum < 0) {
                    boolean pow2 = Integer.bitCount(mag[0]) == 1;
                    for (int i = 1; i < mag.length && pow2; ++i) {
                        pow2 = mag[i] == 0;
                    }
                    bitLength = pow2 ? magBitLength - 1 : magBitLength;
                } else {
                    bitLength = magBitLength;
                }
            }
            int byteLen = bitLength / 8 + 1;
            byte[] bytes = new byte[byteLen];
            int bytesCopied = 4;
            int nextInt = 0;
            int intIndex = 0;
            for (int i = byteLen - 1; i >= 0; --i) {
                if (bytesCopied == 4) {
                    int n;
                    if ((n = intIndex++) < 0) {
                        nextInt = 0;
                    } else if (n >= mag.length) {
                        nextInt = signum < 0 ? -1 : 0;
                    } else {
                        int magInt = mag[mag.length - n - 1];
                        if (signum >= 0) {
                            nextInt = magInt;
                        } else {
                            int j;
                            int mlen = mag.length;
                            for (j = mlen - 1; j >= 0 && mag[j] == 0; --j) {
                            }
                            int firstNonzeroIntNum = mlen - j - 1;
                            nextInt = n <= firstNonzeroIntNum ? -magInt : ~magInt;
                        }
                    }
                    bytesCopied = 1;
                } else {
                    nextInt >>>= 8;
                    ++bytesCopied;
                }
                bytes[i] = (byte)nextInt;
            }
            return new BigInteger(bytes);
        }

        static {
            BiFunction<Integer, int[], BigInteger> bigIntegerCreator = null;
            if (!JDKUtils.ANDROID && !JDKUtils.GRAAL) {
                try {
                    MethodHandles.Lookup caller = JDKUtils.trustedLookup(BigInteger.class);
                    MethodHandle handle = caller.findConstructor(BigInteger.class, MethodType.methodType(Void.TYPE, Integer.TYPE, int[].class));
                    CallSite callSite = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, MethodType.methodType(BigInteger.class, Integer.class, int[].class));
                    bigIntegerCreator = callSite.getTarget().invokeExact();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (bigIntegerCreator == null) {
                bigIntegerCreator = new BigIntegerCreator();
            }
            BIG_INTEGER_CREATOR = bigIntegerCreator;
        }
    }

    public static class SavePoint {
        protected final int offset;
        protected final int current;

        protected SavePoint(int offset, int current) {
            this.offset = offset;
            this.current = current;
        }
    }
}

