/*
 * Copyright (c) 2021 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict'

Object.defineProperty(exports, '__esModule', {
    value: true
})

var _createClass = (function () {
    function defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ('value' in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor)
        }
    }

    return function (Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor
    }
}())

var _service = require('./service')

var _event = require('./event')

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError('Cannot call a class as a function')
    }
}

var Core = (function () {
    _createClass(Core, null, [{
        key: 'getInstance',
        value: function getInstance() {
            if (!this.instance) {
                this.instance = new Core()
            }
            return this.instance
        }
    }])

    function Core() {
        _classCallCheck(this, Core)

        this.instance = null
        this.services = {
            suite: {},
            spec: {},
            config: {},
            expect: {},
            log: {},
            report: {}

        }
        this.events = {
            suite: {},
            spec: {},
            task: {}
        }
    }

    _createClass(Core, [{
        key: 'addService',
        value: function addService(name, service) {
            var serviceObj = {}
            if (!this.services[name]) {
                this.services[name] = serviceObj
            } else {
                serviceObj = this.services[name]
            }
            serviceObj[service.id] = service
        }
    }, {
        key: 'getDefaultService',
        value: function getDefaultService(name) {
            return this.services[name].default
        }
    }, {
        key: 'getServices',
        value: function getServices(name) {
            return this.services[name]
        }
    }, {
        key: 'registerEvent',
        value: function registerEvent(serviceName, event) {
            var eventObj = {}
            if (!this.events[serviceName]) {
                this.events[serviceName] = eventObj
            } else {
                eventObj = this.events[serviceName]
            }
            eventObj[event.id] = event
        }
    }, {
        key: 'unRegisterEvent',
        value: function unRegisterEvent(serviceName, eventID) {
            var eventObj = this.events[serviceName]
            if (eventObj) {
                delete eventObj[eventID]
            }
        }
    }, {
        key: 'subscribeEvent',
        value: function subscribeEvent(serviceName, serviceObj) {
            var eventObj = this.events[serviceName]
            if (eventObj) {
                for (var attr in eventObj) {
                    eventObj[attr]['subscribeEvent'](serviceObj)
                }
            }
        }
    }, {
        key: 'fireEvents',
        value: function fireEvents(serviceName, eventName) {
            var eventObj = this.events[serviceName]
            if (eventObj) {
                for (var attr in eventObj) {
                    eventObj[attr][eventName]()
                }
            }
        }
    }, {
        key: 'addToGlobal',
        value: function addToGlobal(apis) {
            if (typeof globalThis !== 'undefined') {
                for (var api in apis) {
                    globalThis[api] = apis[api]
                }
            }
            for (var _api in apis) {
                this[_api] = apis[_api]
            }
        }
    }, {
        key: 'init',
        value: function init() {
            this.addService('suite', new _service.SuiteService({id: 'default'}))
            this.addService('spec', new _service.SpecService({id: 'default'}))
            this.addService('expect', new _service.ExpectService({id: 'default'}))
            this.addService('report', new _service.ReportService({id: 'default'}))
            this.addService('config', new _service.ConfigService({id: 'default'}))
            this.registerEvent('task', new _event.TaskEvent({id: 'default', coreContext: this}))
            this.registerEvent('suite', new _event.SuiteEvent({id: 'default', coreContext: this}))
            this.registerEvent('spec', new _event.SpecEvent({id: 'default', coreContext: this}))
            this.subscribeEvent('spec', this.getDefaultService('report'))
            this.subscribeEvent('suite', this.getDefaultService('report'))
            this.subscribeEvent('task', this.getDefaultService('report'))
            var context = this
            for (var key in this.services) {
                var serviceObj = this.services[key]
                for (var serviceID in serviceObj) {
                    var service = serviceObj[serviceID]
                    service.init(context)

                    if (typeof service.apis === 'function') {
                        var apis = service.apis()
                        if (apis) {
                            this.addToGlobal(apis)
                        }
                    }
                }
            }
        }
    }, {
        key: 'execute',
        value: function execute() {
            var suiteService = this.getDefaultService('suite')
            suiteService.execute()
        }
    }])

    return Core
}())

exports.default = Core
