/*
 * Copyright (c) 2021 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict'

Object.defineProperty(exports, '__esModule', {
    value: true
})

var _createClass = (function () {
    function defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ('value' in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor)
        }
    }

    return function (Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor
    }
}())

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError('Cannot call a class as a function')
    }
}

function processFunc(coreContext, func) {
    if (func.length > 0 || Object.prototype.toString.call(func) === '[object AsyncFunction]') {
        coreContext.getDefaultService('config').setSupportAsync(true)
    }
    var processedFunc = void 0
    if (func.length > 0) {
        processedFunc = function processedFunc() {
            return new Promise(function (resolve) {
                function done() {
                    resolve()
                }

                func(done)
            })
        }
    } else {
        processedFunc = func
    }
    return processedFunc
}

function secureRandomNumber() { // Random numbers between 0 and 1, similar to math.random
    return crypto.randomBytes(8).readUInt32LE() / 0xffffffff
}

var SuiteService = (function () {
    function SuiteService(attr) {
        _classCallCheck(this, SuiteService)

        this.id = attr.id
        this.rootSuite = new SuiteService.Suite({})
        this.currentRunningSuite = this.rootSuite
    }

    _createClass(SuiteService, [{
        key: 'describe',
        value: function describe(desc, func) {
            var suite = new SuiteService.Suite({description: desc})
            var currentSuiteCache = this.currentRunningSuite
            this.currentRunningSuite.childSuites.push(suite)
            this.currentRunningSuite = suite
            func.call()
            this.currentRunningSuite = currentSuiteCache
        }
    }, {
        key: 'beforeAll',
        value: function beforeAll(func) {
            this.currentRunningSuite.beforeAll.push(processFunc(this.coreContext, func))
        }
    }, {
        key: 'beforeEach',
        value: function beforeEach(func) {
            this.currentRunningSuite.beforeEach.push(processFunc(this.coreContext, func))
        }
    }, {
        key: 'afterAll',
        value: function afterAll(func) {
            this.currentRunningSuite.afterAll.push(processFunc(this.coreContext, func))
        }
    }, {
        key: 'afterEach',
        value: function afterEach(func) {
            this.currentRunningSuite.afterEach.push(processFunc(this.coreContext, func))
        }
    }, {
        key: 'getCurrentRunningSuite',
        value: function getCurrentRunningSuite() {
            return this.currentRunningSuite
        }
    }, {
        key: 'setCurrentRunningSuite',
        value: function setCurrentRunningSuite(suite) {
            this.currentRunningSuite = suite
        }
    }, {
        key: 'getSummary',
        value: function getSummary() {
            var total = 0
            var error = 0
            var failure = 0
            var rootSuite = this.coreContext.getDefaultService('suite').rootSuite
            if (rootSuite && rootSuite.childSuites) {
                for (var i = 0; i < rootSuite.childSuites.length; i++) {
                    var testsuite = rootSuite.childSuites[i]
                    var specs = testsuite['specs']
                    for (var j = 0; j < specs.length; j++) {
                        total++
                        var testcase = specs[j]
                        if (testcase.error) {
                            error++
                        } else if (testcase.result.failExpects.length > 0) {
                            failure++
                        }
                    }
                }
            }
            return {total: total, failure: failure, error: error}
        }
    }, {
        key: 'init',
        value: function init(coreContext) {
            this.coreContext = coreContext
        }
    }, {
        key: 'execute',
        value: function execute() {
            var _this2 = this

            this.coreContext.fireEvents('task', 'taskStart')
            if (this.coreContext.getDefaultService('config').isSupportAsync()) {
                var asyncExecute = /* #__PURE__ */ (function () {
                    var _asyncExecute = _asyncToGenerator(
                        /* #__PURE__ */ regeneratorRuntime.mark(function _callee() {
                            return regeneratorRuntime.wrap(function _callee$(
                                _context
                                ) {
                                    while (1) {
                                        switch ((_context.prev = _context.next)) {
                                            case 0:
                                                _context.next = 2
                                                return _this2.rootSuite.asyncRun(
                                                    _this2.coreContext
                                                )

                                            case 2:
                                            case 'end':
                                                return _context.stop()
                                        }
                                    }
                                },
                                _callee)
                        })
                    )

                    function asyncExecute() {
                        return _asyncExecute.apply(this, arguments)
                    }

                    return asyncExecute
                })()
                asyncExecute().then(function () {
                    _this2.coreContext.fireEvents('task', 'taskDone')
                })
            } else {
                this.rootSuite.run(this.coreContext)
                this.coreContext.fireEvents('task', 'taskDone')
            }
        }
    }, {
        key: 'apis',
        value: function apis() {
            var _this = this
            return {
                describe: function describe(desc, func) {
                    return _this.describe(desc, func)
                },
                beforeAll: function beforeAll(func) {
                    return _this.beforeAll(func)
                },
                beforeEach: function beforeEach(func) {
                    return _this.beforeEach(func)
                },
                afterAll: function afterAll(func) {
                    return _this.afterAll(func)
                },
                afterEach: function afterEach(func) {
                    return _this.afterEach(func)
                }
            }
        }
    }])

    return SuiteService
}())

// 保存每个测试套的对象，感觉应该跟服务区分开来

SuiteService.Suite = (function () {
    function _class(attrs) {
        _classCallCheck(this, _class)

        this.description = attrs.description || ''
        this.childSuites = []
        this.specs = []
        this.beforeAll = []
        this.afterAll = []
        this.beforeEach = []
        this.afterEach = []
    }

    _createClass(_class, [{
        key: 'pushSpec',
        value: function pushSpec(spec) {
            this.specs.push(spec)
        }
    }, {
        key: 'removeSpec',
        value: function removeSpec(desc) {
            this.specs = this.specs.filter(function (item, index) {
                return item.description !== desc
            })
        }
    }, {
        key: 'getSpecsNum',
        value: function getSpecsNum() {
            return this.specs.length
        }
    }, {
        key: 'run',
        value: function run(coreContext) {
            var _this3 = this

            if (this.description != '') {
                coreContext.fireEvents('suite', 'suiteStart', this)
            }
            var suiteService = coreContext.getDefaultService('suite')
            this.runHookFunc('beforeAll')
            if (this.specs.length > 0) {
                var configService = coreContext.getDefaultService('config')
                suiteService.setCurrentRunningSuite(this)
                if (configService.isRandom()) {
                    this.specs.sort(function () {
                        return secureRandomNumber() > 0.5 ? -1 : 1
                    })
                }
                this.specs.forEach(function (spec) {
                    _this3.runHookFunc('beforeEach')
                    spec.run(coreContext)
                    _this3.runHookFunc('afterEach')
                })
            }

            if (this.childSuites.length > 0) {
                this.childSuites.forEach(function (childSuite) {
                    childSuite.run(coreContext)
                    suiteService.setCurrentRunningSuite(childSuite)
                })
            }

            this.runHookFunc('afterAll')
            if (this.description != '') {
                coreContext.fireEvents('suite', 'suiteDone')
            }
        }
    }, {
        key: 'asyncRun',
        value: function asyncRun(coreContext) {
            var _this4 = this

            return new Promise(
                /* #__PURE__ */ (function () {
                    var _ref = _asyncToGenerator(
                        /* #__PURE__ */ regeneratorRuntime.mark(function _callee2(
                            resolve
                        ) {
                            var suiteService, configService, i, _i

                            return regeneratorRuntime.wrap(function _callee2$(
                                _context2
                                ) {
                                    while (1) {
                                        switch ((_context2.prev = _context2.next)) {
                                            case 0:
                                                if (_this4.description != '') {
                                                    coreContext.fireEvents(
                                                        'suite',
                                                        'suiteStart',
                                                        _this4
                                                    )
                                                }

                                                suiteService = coreContext.getDefaultService(
                                                    'suite'
                                                )
                                                _context2.next = 4
                                                return _this4.runAsyncHookFunc('beforeAll')

                                            case 4:
                                                if (!(_this4.specs.length > 0)) {
                                                    _context2.next = 19
                                                    break
                                                } // 随便random一下

                                                configService = coreContext.getDefaultService(
                                                    'config'
                                                )
                                                suiteService.setCurrentRunningSuite(_this4)

                                                if (configService.isRandom()) {
                                                    _this4.specs.sort(function () {
                                                        return secureRandomNumber() > 0.5 ? -1 : 1
                                                    })
                                                }

                                                i = 0

                                            case 9:
                                                if (!(i < _this4.specs.length)) {
                                                    _context2.next = 19
                                                    break
                                                }

                                                _context2.next = 12
                                                return _this4.runAsyncHookFunc('beforeEach')

                                            case 12:
                                                _context2.next = 14
                                                return _this4.specs[i].asyncRun(coreContext)

                                            case 14:
                                                _context2.next = 16
                                                return _this4.runAsyncHookFunc('afterEach')

                                            case 16:
                                                i++
                                                _context2.next = 9
                                                break

                                            case 19:
                                                if (!(_this4.childSuites.length > 0)) {
                                                    _context2.next = 28
                                                    break
                                                }

                                                _i = 0

                                            case 21:
                                                if (!(_i < _this4.childSuites.length)) {
                                                    _context2.next = 28
                                                    break
                                                }

                                                suiteService.setCurrentRunningSuite(
                                                    _this4.childSuites[_i]
                                                )
                                                _context2.next = 25
                                                return _this4.childSuites[_i].asyncRun(
                                                    coreContext
                                                )

                                            case 25:
                                                _i++
                                                _context2.next = 21
                                                break

                                            case 28:
                                                _context2.next = 30
                                                return _this4.runAsyncHookFunc('afterAll')

                                            case 30:
                                                if (_this4.description != '') {
                                                    coreContext.fireEvents('suite', 'suiteDone')
                                                }

                                                resolve()

                                            case 32:
                                            case 'end':
                                                return _context2.stop()
                                        }
                                    }
                                },
                                _callee2)
                        })
                    )

                    return function (_x) {
                        return _ref.apply(this, arguments)
                    }
                })()
            )
        }
    }, {
        key: 'runHookFunc',
        value: function runHookFunc(hookName) {
            if (this[hookName] && this[hookName].length > 0) {
                this[hookName].forEach(function (func) {
                    try {
                        func()
                    } catch (e) {
                        console.error(e)
                    }
                })
            }
        }
    }, {
        key: 'runAsyncHookFunc',
        value: function runAsyncHookFunc(hookName) {
            var _this5 = this

            if (this[hookName] && this[hookName].length > 0) {
                return new Promise(
                    /* #__PURE__ */ (function () {
                        var _ref2 = _asyncToGenerator(
                            /* #__PURE__ */ regeneratorRuntime.mark(function _callee3(
                                resolve
                            ) {
                                var i
                                return regeneratorRuntime.wrap(
                                    function _callee3$(_context3) {
                                        while (1) {
                                            switch ((_context3.prev = _context3.next)) {
                                                case 0:
                                                    i = 0

                                                case 1:
                                                    if (!(i < _this5[hookName].length)) {
                                                        _context3.next = 13
                                                        break
                                                    }

                                                    _context3.prev = 2
                                                    _context3.next = 5
                                                    return _this5[hookName][i]()

                                                case 5:
                                                    _context3.next = 10
                                                    break

                                                case 7:
                                                    _context3.prev = 7
                                                    _context3.t0 = _context3['catch'](2)
                                                    console.error(_context3.t0)

                                                case 10:
                                                    i++
                                                    _context3.next = 1
                                                    break

                                                case 13:
                                                    resolve()

                                                case 14:
                                                case 'end':
                                                    return _context3.stop()
                                            }
                                        }
                                    },
                                    _callee3,
                                    null,
                                    [[2, 7]]
                                )
                            })
                        )

                        return function (_x2) {
                            return _ref2.apply(this, arguments)
                        }
                    })()
                )
            }
        }
    }])

    return _class
}())

var SpecService = (function () {
    function SpecService(attr) {
        _classCallCheck(this, SpecService)

        this.id = attr.id
    }

    _createClass(SpecService, [{
        key: 'init',
        value: function init(coreContext) {
            this.coreContext = coreContext
        }
    }, {
        key: 'setCurrentRunningSpec',
        value: function setCurrentRunningSpec(spec) {
            this.currentRunningSpec = spec
        }
    }, {
        key: 'getCurrentRunningSpec',
        value: function getCurrentRunningSpec() {
            return this.currentRunningSpec
        }
    }, {
        key: 'it',
        value: function it(desc, filter, func) {
            var processedFunc = processFunc(this.coreContext, func)
            var spec = new SpecService.Spec({description: desc, fi: filter, fn: processedFunc})
            var suiteService = this.coreContext.getDefaultService('suite')
            suiteService.getCurrentRunningSuite().pushSpec(spec)
        }
    }, {
        key: 'apis',
        value: function apis() {
            var _this = this
            return {
                it: function it(desc, filter, func) {
                    return _this.it(desc, filter, func)
                }
            }
        }
    }])

    return SpecService
}())

SpecService.Spec = (function () {
    function _class2(attrs) {
        _classCallCheck(this, _class2)

        this.description = attrs.description || ''
        this.fi = attrs.fi
        this.fn = attrs.fn || function () {
        }
        this.result = {
            failExpects: [],
            passExpects: []
        }
        this.error = undefined
    }

    _createClass(_class2, [{
        key: 'run',
        value: function run(coreContext) {
            if (!this.filterCheck(coreContext)) {
                var suiteService = coreContext.getDefaultService('suite')
                suiteService.getCurrentRunningSuite().removeSpec(this.description)
                return
            }
            coreContext.fireEvents('spec', 'specStart', this)
            try {
                this.fn()
            } catch (e) {
                this.error = e
            }
            coreContext.fireEvents('spec', 'specDone', this)
        }
    }, {
        key: 'asyncRun',
        value: function asyncRun(coreContext) {
            var _this6 = this

            if (!this.filterCheck(coreContext)) {
                var suiteService = coreContext.getDefaultService('suite')
                suiteService.getCurrentRunningSuite().removeSpec(this.description)
                return
            }
            return new Promise(
                /* #__PURE__ */ (function () {
                    var _ref3 = _asyncToGenerator(
                        /* #__PURE__ */ regeneratorRuntime.mark(function _callee4(
                            resolve
                        ) {
                            return regeneratorRuntime.wrap(
                                function _callee4$(_context4) {
                                    while (1) {
                                        switch ((_context4.prev = _context4.next)) {
                                            case 0:
                                                coreContext.fireEvents(
                                                    'spec',
                                                    'specStart',
                                                    _this6
                                                )
                                                _context4.prev = 1
                                                _context4.next = 4
                                                return _this6.fn()

                                            case 4:
                                                _context4.next = 9
                                                break

                                            case 6:
                                                _context4.prev = 6
                                                _context4.t0 = _context4['catch'](1)
                                                _this6.error = _context4.t0

                                            case 9:
                                                coreContext.fireEvents(
                                                    'spec',
                                                    'specDone',
                                                    _this6
                                                )
                                                resolve()

                                            case 11:
                                            case 'end':
                                                return _context4.stop()
                                        }
                                    }
                                },
                                _callee4,
                                null,
                                [[1, 6]]
                            )
                        })
                    )

                    return function (_x3) {
                        return _ref3.apply(this, arguments)
                    }
                })()
            )
        }
    }, {
        key: 'filterCheck',
        value: function filterCheck(coreContext) {
            var configService = coreContext.getDefaultService('config')
            var filter = configService.filterSpec(this, coreContext)
            if (filter) {
                console.info('[filter] case ' + this.description)
                return false
            }
            var specService = coreContext.getDefaultService('spec')
            specService.setCurrentRunningSpec(this)
            return true
        }
    }, {
        key: 'addExpectationResult',
        value: function addExpectationResult(expectResult) {
            if (expectResult.pass) {
                this.result.passExpects.push(expectResult)
            } else {
                this.result.failExpects.push(expectResult)
            }
        }
    }])

    return _class2
}())

var ExpectService = (function () {
    function ExpectService(attr) {
        _classCallCheck(this, ExpectService)

        this.id = attr.id
        this.matchers = {}
    }

    _createClass(ExpectService, [{
        key: 'expect',
        value: function expect(actualValue) {
            return this.wrapMatchers(actualValue)
        }
    }, {
        key: 'init',
        value: function init(coreContext) {
            this.coreContext = coreContext
            this.addMatchers(this.basicMatchers())
        }
    }, {
        key: 'addMatchers',
        value: function addMatchers(matchers) {
            // 方便扩展
            for (var matcherName in matchers) {
                this.matchers[matcherName] = matchers[matcherName]
            }
        }
    }, {
        key: 'basicMatchers',
        value: function basicMatchers() {
            return {
                assertTrue: function assertTrue(actualValue) {
                    return {
                        pass: actualValue === true
                    }
                },
                assertEqual: function assertEqual(actualValue, args) {
                    return {
                        pass: actualValue == args[0],
                        expectValue: args[0]
                    }
                },
                assertThrow: function assertThrow(actual, args) {
                    var result = {
                        pass: false
                    }
                    if (typeof actual !== 'function') {
                        result.message = 'toThrow\'s Actual should be a Function'
                    } else {
                        var hasThrow = false
                        var throwError = void 0
                        try {
                            actual()
                        } catch (e) {
                            hasThrow = true
                            throwError = e
                        }
                        if (!hasThrow) {
                            result.message = 'function did not throw an exception'
                        } else {
                            if (throwError && throwError.message === args[0]) {
                                result.pass = true
                            } else {
                                result.message = 'expect to throw ' + args[0] + ' , actual throw ' + throwError.message
                            }
                        }
                    }
                    return result
                }
            }
        }
    }, {
        key: 'wrapMatchers',
        value: function wrapMatchers(actualValue) {
            var _this = this
            var wrappedMatchers = {}
            var specService = _this.coreContext.getDefaultService('spec')
            var currentRunningSpec = specService.getCurrentRunningSpec()

            var _loop = function _loop(matcherName) {
                wrappedMatchers[matcherName] = function () {
                    var result = _this.matchers[matcherName](actualValue, arguments)
                    result.actualValue = actualValue
                    result.checkFunc = matcherName
                    currentRunningSpec.addExpectationResult(result)
                }
            }

            for (var matcherName in this.matchers) {
                _loop(matcherName)
            }
            return wrappedMatchers
        }
    }, {
        key: 'apis',
        value: function apis() {
            var _this = this
            return {
                expect: function expect(actualValue) {
                    return _this.expect(actualValue)
                }
            }
        }
    }])

    return ExpectService
}())

var ReportService = (function () {
    function ReportService(attr) {
        _classCallCheck(this, ReportService)

        this.id = attr.id
    }

    _createClass(ReportService, [{
        key: 'init',
        value: function init(coreContext) {
            this.coreContext = coreContext
            this.specService = this.coreContext.getDefaultService('spec')
            this.suiteService = this.coreContext.getDefaultService('suite')
        }
    }, {
        key: 'taskStart',
        value: function taskStart() {
            this.sleep(200)
            console.info('[start] start run suites')
        }
    }, {
        key: 'suiteStart',
        value: function suiteStart() {
            this.sleep(200)
            console.info('[suite start]' + this.suiteService.getCurrentRunningSuite().description)
        }
    }, {
        key: 'specStart',
        value: function specStart() {
            this.sleep(200)
            console.info('start running case \'' + this.specService.currentRunningSpec.description + '\'')
            this.index = this.index + 1
        }
    }, {
        key: 'specDone',
        value: function specDone() {
            var _this7 = this

            this.sleep(200)
            var msg = ''
            var spec = this.specService.currentRunningSpec
            if (spec.error) {
                this.formatPrint('fail', spec.description)
                this.formatPrint('failDetail', spec.error)
            } else if (spec.result) {
                if (spec.result.failExpects.length > 0) {
                    this.formatPrint('fail', spec.description)
                    spec.result.failExpects.forEach(function (failExpect) {
                        msg = failExpect.message || 'expect ' + failExpect.actualValue + ' ' + failExpect.checkFunc + ' ' + (failExpect.expectValue || '')
                        _this7.formatPrint('failDetail', msg)
                    })
                } else {
                    this.formatPrint('pass', spec.description)
                }
            }
            this.formatPrint(this.specService.currentRunningSpec.error, msg)
        }
    }, {
        key: 'suiteDone',
        value: function suiteDone() {
            this.sleep(200)
            console.info('[suite end]')
        }
    }, {
        key: 'taskDone',
        value: function taskDone() {
            this.sleep(200)
            var summary = this.suiteService.getSummary()
            console.info('total cases:' + summary.total + ';failure ' + summary.failure + ',' + 'error ' + summary.error + ',pass ' + (summary.total - summary.error - summary.failure))
            console.info('[end] run suites end')
        }
    }, {
        key: 'formatPrint',
        value: function formatPrint(type, msg) {
            switch (type) {
                case 'pass':
                    console.info('[pass]' + msg)
                    break
                case 'fail':
                    console.info('[fail] ' + msg)
                    break
                case 'failDetail':
                    console.info('[failDetail]' + msg)
                    break
            }
        }
    }, {
        key: 'sleep',
        value: function sleep(numberMillis) {
            var now = new Date()
            var exitTime = now.getTime() + numberMillis
            while (true) {
                now = new Date()
                if (now.getTime() > exitTime) return
            }
        }
    }])

    return ReportService
}())

var ConfigService = (function () {
    function ConfigService(attr) {
        _classCallCheck(this, ConfigService)

        this.id = attr.id
        this.supportAsync = false
        this.random = false
    }

    _createClass(ConfigService, [{
        key: 'init',
        value: function init() {
        }
    }, {
        key: 'setConfig',
        value: function setConfig(params) {
            try {
                this.filter = params.filter
                this.flag = params.flag || {flag: false}
                this.suite = params.suite
                this.itName = params.itName
            } catch (err) {
                this.filter = 0
                this.flag = false
                this.suite = null
                this.itName = null
            }
        }
    }, {
        key: 'filterSpec',
        value: function filterSpec(spec, coreContext) {
            if (this.flag == true) {
                console.info('dryrun,filter ' + spec.description)
                return true
            }
            if (this.itName != undefined && this.itName != '' && this.itName != null) {
                if (spec.description != this.itName) {
                    console.info('run it :' + this.itName + ',filter ' + spec.description)
                    return true
                }
            }
            if (this.suite != undefined && this.suite != '' && this.suite != null) {
                var suiteService = coreContext.getDefaultService('suite')
                var currentSuite = suiteService.getCurrentRunningSuite()
                if (this.suite != currentSuite.description) {
                    console.info('run suite:' + this.suite + ',filter ' + spec.description)
                    return true
                }
            }
            if (this.filter == undefined || this.filter === 0 || fi === 0) {
                return false
            }
            var typeFi = fi & 65535
            var type = this.filter & 65535
            if (type != typeFi && typeFi != 0 && type != 0) {
                console.info('type:' + type + ',typeFi:' + typeFi)
                return true
            }
            var sizeFi = fi & 255 << 16
            var size = this.filter & 255 << 16
            if (size != 0 && sizeFi != 0 && size != sizeFi) {
                return true
            }
            var levelFi = fi & 127 << 24
            var level = this.filter & 127 << 24
            if (level != 0 && levelFi != 0 && level != levelFi) {
                return true
            }
            return false
        }
    }, {
        key: 'isRandom',
        value: function isRandom() {
            return this.random || false
        }
    }, {
        key: 'setSupportAsync',
        value: function setSupportAsync(value) {
            this.supportAsync = value
        }
    }, {
        key: 'isSupportAsync',
        value: function isSupportAsync() {
            return this.supportAsync
        }
    }, {
        key: 'execute',
        value: function execute() {
        }
    }])

    return ConfigService
}())

exports.SuiteService = SuiteService
exports.SpecService = SpecService
exports.ExpectService = ExpectService
exports.ReportService = ReportService
exports.ConfigService = ConfigService
