/*
 * Copyright (c) 2021 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict'

Object.defineProperty(exports, '__esModule', {
    value: true
})

var _createClass = (function () {
    function defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ('value' in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor)
        }
    }

    return function (Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor
    }
}())

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError('Cannot call a class as a function')
    }
}

var SpecEvent = (function () {
    function SpecEvent(attr) {
        _classCallCheck(this, SpecEvent)

        this.id = attr.id
        this.coreContext = attr.context
        this.eventMonitors = []
    }

    _createClass(SpecEvent, [{
        key: 'subscribeEvent',
        value: function subscribeEvent(service) {
            this.eventMonitors.push(service)
        }
    }, {
        key: 'specStart',
        value: function specStart() {
            for (var monitor in this.eventMonitors) {
                this.eventMonitors[monitor]['specStart']()
            }
        }
    }, {
        key: 'specDone',
        value: function specDone() {
            for (var monitor in this.eventMonitors) {
                this.eventMonitors[monitor]['specDone']()
            }
        }
    }])

    return SpecEvent
}())

var SuiteEvent = (function () {
    function SuiteEvent(attr) {
        _classCallCheck(this, SuiteEvent)

        this.id = attr.id
        this.suiteContext = attr.coreContext
        this.eventMonitors = []
    }

    _createClass(SuiteEvent, [{
        key: 'subscribeEvent',
        value: function subscribeEvent(service) {
            this.eventMonitors.push(service)
        }
    }, {
        key: 'suiteStart',
        value: function suiteStart() {
            for (var monitor in this.eventMonitors) {
                this.eventMonitors[monitor]['suiteStart']()
            }
        }
    }, {
        key: 'suiteDone',
        value: function suiteDone() {
            for (var monitor in this.eventMonitors) {
                this.eventMonitors[monitor]['suiteDone']()
            }
        }
    }])

    return SuiteEvent
}())

var TaskEvent = (function () {
    function TaskEvent(attr) {
        _classCallCheck(this, TaskEvent)

        this.id = attr.id
        this.coreContext = attr.coreContext
        this.eventMonitors = []
    }

    _createClass(TaskEvent, [{
        key: 'subscribeEvent',
        value: function subscribeEvent(service) {
            this.eventMonitors.push(service)
        }
    }, {
        key: 'taskStart',
        value: function taskStart() {
            for (var monitor in this.eventMonitors) {
                this.eventMonitors[monitor]['taskStart']()
            }
        }
    }, {
        key: 'taskDone',
        value: function taskDone() {
            for (var monitor in this.eventMonitors) {
                this.eventMonitors[monitor]['taskDone']()
            }
        }
    }])

    return TaskEvent
}())

exports.SpecEvent = SpecEvent
exports.TaskEvent = TaskEvent
exports.SuiteEvent = SuiteEvent
