/*
 * Copyright (c) 2021 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict'

Object.defineProperty(exports, '__esModule', {
    value: true
})
exports.expect = exports.afterAll = exports.afterEach = exports.beforeEach = exports.beforeAll = exports.it = exports.describe = undefined

var _core = require('./core')

var _core2 = _interopRequireDefault(_core)

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj}
}

var core = _core2.default.getInstance()

var describe = function describe(desc, func) {
    return core.describe(desc, func)
}
var it = function it(desc, filter, func) {
    return core.it(desc, filter, func)
}
var beforeEach = function beforeEach(func) {
    return core.beforeEach(func)
}
var afterEach = function afterEach(func) {
    return core.afterEach(func)
}
var beforeAll = function beforeAll(func) {
    return core.beforeAll(func)
}
var afterAll = function afterAll(func) {
    return core.afterAll(func)
}
var expect = function expect(actualValue) {
    return core.expect(actualValue)
}

exports.describe = describe
exports.it = it
exports.beforeAll = beforeAll
exports.beforeEach = beforeEach
exports.afterEach = afterEach
exports.afterAll = afterAll
exports.expect = expect
