# std.unittest.common

## Functionality Overview

unittest.common provides types and common methods required for printing in the unit testing framework.

## API List

### Functions

|              Function Name          |            Functionality           |
| --------------------------- | ------------------------ |
| [func registerOptionValidator(String, (Any) -> OptionValidity)](./unittest_common_package_api/unittest_common_package_functions.md#func-registeroptionvalidatorstring-any---optionvalidity) | Registers a custom option validator. In most cases, users should use the [@UnittestOption](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#UnittestOption-macro) macro instead of calling this function directly. |
| [func setOptionInfo(String, Array\<String\>, ?String)](./unittest_common_package_api/unittest_common_package_functions.md#func-setoptioninfostring-arraystring-string) | Function for setting option descriptions. |
| [setOrUpdateOptionInfo(String, ?String, String, String)](./unittest_common_package_api/unittest_common_package_functions.md#func-setorupdateoptioninfostring-string-string-string) | Converts parameters implementing [ToString](../core/core_package_api/core_package_interfaces.md#interface-tostring) into string representations. |
| [toStringOrPlaceholder\<T>(T)](./unittest_common_package_api/unittest_common_package_functions.md#func-tostringorplaceholdertt) | Converts parameters implementing [ToString](../core/core_package_api/core_package_interfaces.md#interface-tostring) into string representations. |

### Interfaces

|              Interface Name          |            Functionality           |
| --------------------------- | ------------------------ |
| [DataProvider](./unittest_common_package_api/unittest_common_package_interfaces.md#interface-dataprovider) | A component of DataStrategy that provides test data, where T specifies the data type provided. |
| [DataShrinker](./unittest_common_package_api/unittest_common_package_interfaces.md#interface-datashrinkert) | A component of DataStrategy that reduces data during testing, where T specifies the data type processed by this shrinker. |
| [DataStrategy](./unittest_common_package_api/unittest_common_package_interfaces.md#interface-datastrategy) | Strategy for providing data to parameterized tests, where T specifies the data type operated by this strategy. |
| [PrettyPrintable](./unittest_common_package_api/unittest_common_package_interfaces.md#interface-prettyprintable) | Types implementing this interface indicate they can be printed with proper color and indentation formatting. |
| [KeyFor](./unittest_common_package_api/unittest_common_package_interfaces.md#interface-keyfor) | The type of key for configuration items in [Configuration](../unittest_common/unittest_common_package_api/unittest_common_package_classes.md#class-configuration). |

### Classes

|              Class Name          |            Functionality           |
| --------------------------- | ------------------------ |
| [Configuration](./unittest_common_package_api/unittest_common_package_classes.md#class-configuration) | An object storing `unittest` configuration data generated by the `@Configure` macro. `Configuration` is a `HashMap`-like class, but its keys are not key-value types; instead, they are of `String` type with values of any given type. |
| [ConfigurationKey](./unittest_common_package_api/unittest_common_package_classes.md#class-configurationkey) | A key-value object for configuration items. Provides equality comparison and hashCode methods. |
| [PrettyPrinter](./unittest_common_package_api/unittest_common_package_classes.md#class-prettyprinter) | A printer with color, alignment, and indentation control. |
| [PrettyText](./unittest_common_package_api/unittest_common_package_classes.md#class-prettytext) | A builder-like class for storing printed output. |

### Enums

|              Enum Name          |            Functionality           |
| --------------------------- | ------------------------ |
| [Color](./unittest_common_package_api/unittest_common_package_enums.md#enum-color) | Specifies colors. |
| [OptionValidity](./unittest_common_package_api/unittest_common_package_enums.md#enum-optionvalidity) | Enumeration representing the validation result of option values. |

### Structs

|              Struct Name          |            Functionality           |
| --------------------------- | ------------------------ |
| [OptionInfo](./unittest_common_package_api/unittest_common_package_structs.md#struct-optioninfo) | Information about options that can be used when printing help pages. |

### Exceptions

|              Exception Name          |            Functionality           |
| --------------------------- | ------------------------ |
| [UnittestOptionValidationException](./unittest_common_package_api/unittest_common_package_exceptions.md#class-unittestoptionvalidationexception) | Exception thrown during framework validation of option value legality. |