# std.unittest

## Functionality Overview

The unittest package is used for writing unit test code in the Cangjie project, providing basic functionalities including code writing, execution, and debugging, along with advanced features for experienced users.

Cangjie unit testing supports both the cjc compiler (single-package compilation mode) and the cjpm package manager (multi-package mode).

Users can write their first unit test program by following the [Quick Start Guide](./unittest_samples/unittest_getting_started.md#unittest-quick-start). The documentation also explains [Basic Concepts and Usage](./unittest_samples/unittest_basics.md#unittest-basic-concepts-and-usage) with sample code, and provides further details on advanced features such as [Parameterized Testing](./unittest_samples/unittest_parameterized_tests.md#parameterized-testing-introduction).

The following APIs are re-exported from other packages, allowing users to utilize them by importing only unittest.

### Re-exports from unittest.common package

#### Interfaces

| Interface Name | Functionality |
| ------------- | ------------- |
| [DataProvider](../unittest_common/unittest_common_package_api/unittest_common_package_interfaces.md#interface-dataprovider) | A component of DataStrategy for providing test data, where T specifies the data type provided. |
| [DataShrinker](../unittest_common/unittest_common_package_api/unittest_common_package_interfaces.md#interface-datashrinkert) | A component of DataStrategy for reducing data during testing, where T specifies the data type processed by the shrinker. |
| [DataStrategy](../unittest_common/unittest_common_package_api/unittest_common_package_interfaces.md#interface-datastrategy) | A strategy for providing data for parameterized tests, where T specifies the data type operated by the strategy. |

#### Classes

| Class Name | Functionality |
| ---------- | ------------- |
| [Configuration](../unittest_common/unittest_common_package_api/unittest_common_package_classes.md#class-configuration) | An object storing `unittest` configuration data generated by the `@Configure` macro. `Configuration` is a `HashMap`-like class, but its keys are of `String` type and can hold values of any given type. |
| [ConfigurationKey](../unittest_common/unittest_common_package_api/unittest_common_package_classes.md#class-configurationkey) | A key-value object for configuration items, providing equality and hashCode methods. |

### Re-exports from unittest.prop_test package

#### Functions

| Function Name | Functionality |
| ------------ | ------------- |
| [random\<T>()](../unittest_prop_test/unittest_prop_test_package_api/unittest_prop_test_package_functions.md#func-randomt-where-t--arbitraryt) | Generates random data of type T, where T must implement the Arbitrary\<T> interface. The return value serves as a parameter source for parameterized tests. |

#### Interfaces

| Interface Name | Functionality |
| ------------- | ------------- |
| [Arbitrary](../unittest_prop_test/unittest_prop_test_package_api/unittest_prop_test_package_interfaces.md#interface-arbitraryt) | Interface for generating random values of type T. |
| [Shrink](../unittest_prop_test/unittest_prop_test_package_api/unittest_prop_test_package_interfaces.md#interface-shrinkt) | Reduces values of type T to multiple "smaller" values. |

## API List

### Functions

| Function Name | Functionality |
| ------------ | ------------- |
| [assertCaughtUnexpectedE(String, String, String, Option\<AssertionCtx>)](./unittest_package_api/unittest_package_functions.md#func-assertcaughtunexpectedestring-string-string-optionassertionctx) | Records information and throws an exception when the caught exception does not match expectations. |
| [assertEqual\<T>(String, String, T, T, Option\<AssertionCtx>)](./unittest_package_api/unittest_package_functions.md#func-assertequaltstring-string-t-t-optionassertionctx-unit-where-t--equatablet) | Compares whether `expected` and `actual` values are equal. Throws an exception if they are not. |
| [defaultConfiguration()](./unittest_package_api/unittest_package_functions.md#func-defaultconfiguration) | Generates default configuration information. |
| [entryMain(TestPackage)](./unittest_package_api/unittest_package_functions.md#func-entrymaintestpackage) | Entry function provided for `cjc --test`, serving as the framework's entry point for executing test cases. |
| [expectCaughtUnexpectedE(String,String,String, Option\<AssertionCtx>)](./unittest_package_api/unittest_package_functions.md#func-expectcaughtunexpectedestring-string-string-optionassertionctx) | Records information when the caught exception does not match expectations, without throwing an exception. |
| [expectEqual(String, String, T, T, Option\<AssertionCtx>)](./unittest_package_api/unittest_package_functions.md#func-expectequaltstring-string-t-t-optionassertionctx-unit-where-t--equatablet) | Compares whether `expected` and `actual` values are equal. Records the comparison result without throwing an exception. |
| [fail(String)](./unittest_package_api/unittest_package_functions.md#func-failstring) | Fails the test case by directly throwing an exception. |
| [failExpect(String)](./unittest_package_api/unittest_package_functions.md#func-failexpectstring) | Fails the test case by recording information without throwing an exception. |
| [invokeCustomAssert\<T>(Array\<String>, String, (AssertionCtx) -> T, Option\<AssertionCtx>)](./unittest_package_api/unittest_package_functions.md#func-invokecustomasserttarraystring-string-assertionctx---t-optionassertionctx) | Executes user-defined assertion functions specified by [`@Assert[caller](passerArgs)`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#assert-macro) in [`@Test`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#test-macro), [`@TestCase`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#testcase-macro), or [`@CustomAssertion`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#customassertion-macro) macros. |
| [invokeCustomExpect\<T>(Array\<String>, String, (AssertionCtx) -> Any, Option\<AssertionCtx>)](./unittest_package_api/unittest_package_functions.md#func-invokecustomexpectarraystring-string-assertionctx---any-optionassertionctx) | Executes user-defined assertion functions specified by [`@Expect[caller](passerArgs)`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#expect-macro) in [`@Test`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#test-macro), [`@TestCase`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#testcase-macro), or [`@CustomAssertion`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#customassertion-macro) macros. |

### Type Aliases

| Type Alias | Functionality |
| --------- | ------------- |
| [MeasurementUnitTable](./unittest_package_api/unittest_package_types.md#type-measurementunittable) | Used to specify [Measurement](./unittest_package_api/unittest_package_interfaces.md#interface-measurement) instances for performance testing. |

### Interfaces

| Interface Name | Functionality |
| ------------- | ------------- |
| [BenchInputProvider](./unittest_package_api/unittest_package_interfaces.md#interface-benchinputprovider) | Interface for handling performance tests where code needs to be executed before each performance test call or where input changes and must be regenerated from scratch each time. |
| [BenchmarkConfig](./unittest_package_api/unittest_package_interfaces.md#interface-benchmarkconfig) | Empty interface distinguishing some [Configuration](../unittest_common/unittest_common_package_api/unittest_common_package_classes.md#class-configuration) functions as performance-related configurations. |
| [BenchmarkInputMarker](./unittest_package_api/unittest_package_interfaces.md#interface-benchmarkinputmarker) | Detects `BenchInputProvider<T>` when `T` is unknown. |
| [Generator](./unittest_package_api/unittest_package_interfaces.md#interface-generatort) | Generates values of type T. |
| [Measurement](./unittest_package_api/unittest_package_interfaces.md#interface-measurement) | Interface for collecting and analyzing various data during performance testing. Specific instances of `Measurement` used during performance testing are specified in the `@Measure` macro (e.g., in class declarations). |
| [TestClass](./unittest_package_api/unittest_package_interfaces.md#interface-testclass) | Provides methods for creating [TestSuite](./unittest_package_api/unittest_package_classes.md#class-testsuite). |

### Classes

| Class Name | Functionality |
| --------- | ------------- |
| [AssertionCtx](./unittest_package_api/unittest_package_classes.md#class-assertionctx) | Stores the state of user-defined assertions and provides methods for writing them. |
| [Benchmark](./unittest_package_api/unittest_package_classes.md#class-benchmark) | Provides methods for creating and running individual performance test cases. |
| [BenchReport](./unittest_package_api/unittest_package_classes.md#class-benchreport) | Handles reporting of performance test case execution results. |
| [CartesianProductProcessor\<T0,T1>](./unittest_package_api/unittest_package_classes.md#class-cartesianproductprocessort0t1) | Cartesian product processor. |
| [ConsoleReporter](./unittest_package_api/unittest_package_classes.md#class-consolereporter) | Prints unit test case results or performance test case results to the console. |
| [CsvReporter](./unittest_package_api/unittest_package_classes.md#class-csvreporter) | Prints performance test case result data to a CSV file. |
| [CsvRawReporter](./unittest_package_api/unittest_package_classes.md#class-csvrawreporter) | Prints performance test case result data containing only raw batch measurements to a CSV file. |
| [CsvStrategy\<T>](./unittest_package_api/unittest_package_classes.md#class-csvstrategyt) | Serialization implementation of `DataStrategy` for CSV data format. |
| [DataStrategyProcessor\<T>](./unittest_package_api/unittest_package_classes.md#class-datastrategyprocessort) | Base class for all [DataStrategy](../unittest_common/unittest_common_package_api/unittest_common_package_interfaces.md#interface-datastrategy) components. Instances are created by the [`@Strategy`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#strategy-macro) macro or member functions. |
| [FlatMapProcessor\<T,R>](./unittest_package_api/unittest_package_classes.md#class-flatmapprocessortr) | Processor for applying [FlatMap](../collection/collection_package_api/collection_package_function.md#func-flatmapt-r-t---iterabler) to parameter data. |
| [FlatMapStrategyProcessor\<T,R>](./unittest_package_api/unittest_package_classes.md#class-flatmapstrategyprocessortr) | Processor for applying [FlatMap](../collection/collection_package_api/collection_package_function.md#func-flatmapt-r-t---iterabler) to parameter data. |
| [InputParameter](./unittest_package_api/unittest_package_classes.md#class-inputparameter) | Input parameter object type. |
| [JsonStrategy\<T>](./unittest_package_api/unittest_package_classes.md#class-jsonstrategyt) | Serialization implementation of `DataStrategy` for JSON data format. |
| [LazyCyclicNode](./unittest_package_api/unittest_package_classes.md#class-lazycyclicnode) | Internal lazy iterator for advancing type-erased values sequentially in a loop. |
| [MapProcessor\<T,R>](./unittest_package_api/unittest_package_classes.md#class-mapprocessortr) | Processor for applying [Map](../collection/collection_package_api/collection_package_function.md#func-mapt-rt---r) to parameter data. |
| [PowerAssertDiagramBuilder](./unittest_package_api/unittest_package_classes.md#class-powerassertdiagrambuilder) | Output builder for [PowerAssert](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#powerassert-macro). |
| [RandomDataProvider\<T>](./unittest_package_api/unittest_package_classes.md#class-randomdataprovidert) | Implementation of the DataProvider interface using random data generation. |
| [RandomDataShrinker\<T>](./unittest_package_api/unittest_package_classes.md#class-randomdatashrinkert) | Implementation of the DataShrinker interface using random data generation. |
| [RandomDataStrategy\<T>](./unittest_package_api/unittest_package_classes.md#class-randomdatastrategyt) | Implementation of the DataStrategy interface using random data generation. |
| [RawStatsReporter](./unittest_package_api/unittest_package_classes.md#class-rawstatsreporter) | Unprocessed performance test data reporter. For internal framework use only. |
| [Report](./unittest_package_api/unittest_package_classes.md#class-report) | Base class for printing test case result reports. |
| [SerializableProvider\<T>](./unittest_package_api/unittest_package_classes.md#class-serializableprovidert) | Implementation of the [DataProvider](../unittest_common/unittest_common_package_api/unittest_common_package_interfaces.md#interface-dataprovider) interface for serialized data. |
| [SimpleProcessor\<T>](./unittest_package_api/unittest_package_classes.md#class-simpleprocessort) | Simple data strategy processor. An implementation of [DataStrategyProcessor](./unittest_package_api/unittest_package_classes.md#class-datastrategyprocessort). |
| [TestGroup](./unittest_package_api/unittest_package_classes.md#class-testgroup) | Provides methods for building and running test groups. |
| [TestGroupBuilder](./unittest_package_api/unittest_package_classes.md#class-testgroupbuilder) | Builder for configuring test group methods. |
| [TestPackage](./unittest_package_api/unittest_package_classes.md#class-testpackage) | Test package object. |
| [TestReport](./unittest_package_api/unittest_package_classes.md#class-testreport) | Unit test execution result report. |
| [TestSuite](./unittest_package_api/unittest_package_classes.md#class-testsuite) | Provides methods for building and executing test suites. |
| [TestSuiteBuilder](./unittest_package_api/unittest_package_classes.md#class-testsuitebuilder) | Builder for configuring test suite methods. |
| [UnitTestCase](./unittest_package_api/unittest_package_classes.md#class-unittestcase) | Provides methods for creating and executing unit test cases. |
| [XmlReporter](./unittest_package_api/unittest_package_classes.md#class-xmlreporter) | Prints unit test case result data to an XML file. |

### Enums

| Enum Name | Functionality |
| --------- | ------------- |
| [ExplicitGcType](./unittest_package_api/unittest_package_enums.md#enum-explicitgctype) | Specifies the `explicitGC` configuration parameter for the `@Configure` macro, representing three different GC execution methods. |
| [TimeUnit](./unittest_package_api/unittest_package_enums.md#enum-timeunit) | Time units usable in the `TimeNow` class constructor. |
| [PerfCounter](./unittest_package_api/unittest_package_enums.md#enum-perfcounter) | Enumerates CPU counters supported by the [Perf](./unittest_package_api/unittest_package_structs.md#struct-perf) constructor. |

### Structs

| Struct Name | Functionality |
| ----------- | ------------- |
| [BatchInputProvider\<T>](./unittest_package_api/unittest_package_structs.md#struct-batchinputprovidert) | Input provider that generates the entire benchmark batch input in a buffer before execution. |
| [BatchSizeOneInputProvider\<T>](./unittest_package_api/unittest_package_structs.md#struct-batchsizeoneinputprovidert) | Benchmark input provider that generates input before each benchmark execution. |
| [CpuCycles](./unittest_package_api/unittest_package_structs.md#struct-cpucycles) | Measures CPU cycle counts using the native `rdtscp` instruction. Only available on x86 platforms. |
| [GenerateEachInputProvider\<T>](./unittest_package_api/unittest_package_structs.md#struct-generateeachinputprovidert) | Benchmark input provider that generates input before each benchmark execution. |
| [ImmutableInputProvider\<T>](./unittest_package_api/unittest_package_structs.md#struct-immutableinputprovidert) | Simplest input provider that copies data for each benchmark call. Suitable when the benchmark does not modify input. Used by default within the framework. |
| [Perf](./unittest_package_api/unittest_package_structs.md#struct-perf) | Measures various hardware and software CPU counters using the Linux system call `perf_event_open`. Only available on Linux. |
| [TimeNow](./unittest_package_api/unittest_package_structs.md#struct-timenow) | Implementation of [Measurement](./unittest_package_api/unittest_package_interfaces.md#interface-measurement) for measuring the time taken to execute a function. |

### Exception Classes

| Exception Name | Functionality |
| -------------- | ------------- |
| [AssertException](./unittest_package_api/unittest_package_exceptions.md#class-assertexception) | Exception thrown when [`@Expect`](../unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md#expect-macro) / [`@