// Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
// This source file is part of the Cangjie project, licensed under Apache-2.0
// with Runtime Library Exception.
//
// See https://cangjie-lang.cn/pages/LICENSE for license information.

/**
 * @file
 *
 * This file provides unicode normalisation test data.
 */

// NOTE: The following code was generated by "NormalisationTests.py", do not edit directly

#include <string_view>

struct NormalisationTest {
    std::string_view source;
    std::string_view nfc;
};

const NormalisationTest NORMALISATION_TEST_DATA[] {
    {"\u1E0A", "\u1E0A"}, {"\u1E0C", "\u1E0C"}, {"\u1E0A\u0323", "\u1E0C\u0307"}, {"\u1E0C\u0307", "\u1E0C\u0307"},
    {"\u0044\u0307\u0323", "\u1E0C\u0307"}, {"\u0044\u0323\u0307", "\u1E0C\u0307"}, {"\u1E0A\u031B", "\u1E0A\u031B"},
    {"\u1E0C\u031B", "\u1E0C\u031B"}, {"\u1E0A\u031B\u0323", "\u1E0C\u031B\u0307"},
    {"\u1E0C\u031B\u0307", "\u1E0C\u031B\u0307"}, {"\u0044\u031B\u0307\u0323", "\u1E0C\u031B\u0307"},
    {"\u0044\u031B\u0323\u0307", "\u1E0C\u031B\u0307"}, {"\u00C8", "\u00C8"}, {"\u0112", "\u0112"},
    {"\u0045\u0300", "\u00C8"}, {"\u0045\u0304", "\u0112"}, {"\u1E14", "\u1E14"}, {"\u0112\u0300", "\u1E14"},
    {"\u1E14\u0304", "\u1E14\u0304"}, {"\u0045\u0304\u0300", "\u1E14"}, {"\u0045\u0300\u0304", "\u00C8\u0304"},
    {"\u05B8\u05B9\u05B1\u0591\u05C3\u05B0\u05AC\u059F", "\u05B1\u05B8\u05B9\u0591\u05C3\u05B0\u05AC\u059F"},
    {"\u0592\u05B7\u05BC\u05A5\u05B0\u05C0\u05C4\u05AD", "\u05B0\u05B7\u05BC\u05A5\u0592\u05C0\u05AD\u05C4"},
    {"\u1100\uAC00\u11A8", "\u1100\uAC01"}, {"\u1100\uAC00\u11A8\u11A8", "\u1100\uAC01\u11A8"}, {"\u00A0", "\u00A0"},
    {"\u00A8", "\u00A8"}, {"\u00AA", "\u00AA"}, {"\u00AF", "\u00AF"}, {"\u00B2", "\u00B2"}, {"\u00B3", "\u00B3"},
    {"\u00B4", "\u00B4"}, {"\u00B5", "\u00B5"}, {"\u00B8", "\u00B8"}, {"\u00B9", "\u00B9"}, {"\u00BA", "\u00BA"},
    {"\u00BC", "\u00BC"}, {"\u00BD", "\u00BD"}, {"\u00BE", "\u00BE"}, {"\u00C0", "\u00C0"}, {"\u00C1", "\u00C1"},
    {"\u00C2", "\u00C2"}, {"\u00C3", "\u00C3"}, {"\u00C4", "\u00C4"}, {"\u00C5", "\u00C5"}, {"\u00C7", "\u00C7"},
    {"\u00C8", "\u00C8"}, {"\u00C9", "\u00C9"}, {"\u00CA", "\u00CA"}, {"\u00CB", "\u00CB"}, {"\u00CC", "\u00CC"},
    {"\u00CD", "\u00CD"}, {"\u00CE", "\u00CE"}, {"\u00CF", "\u00CF"}, {"\u00D1", "\u00D1"}, {"\u00D2", "\u00D2"},
    {"\u00D3", "\u00D3"}, {"\u00D4", "\u00D4"}, {"\u00D5", "\u00D5"}, {"\u00D6", "\u00D6"}, {"\u00D9", "\u00D9"},
    {"\u00DA", "\u00DA"}, {"\u00DB", "\u00DB"}, {"\u00DC", "\u00DC"}, {"\u00DD", "\u00DD"}, {"\u00E0", "\u00E0"},
    {"\u00E1", "\u00E1"}, {"\u00E2", "\u00E2"}, {"\u00E3", "\u00E3"}, {"\u00E4", "\u00E4"}, {"\u00E5", "\u00E5"},
    {"\u00E7", "\u00E7"}, {"\u00E8", "\u00E8"}, {"\u00E9", "\u00E9"}, {"\u00EA", "\u00EA"}, {"\u00EB", "\u00EB"},
    {"\u00EC", "\u00EC"}, {"\u00ED", "\u00ED"}, {"\u00EE", "\u00EE"}, {"\u00EF", "\u00EF"}, {"\u00F1", "\u00F1"},
    {"\u00F2", "\u00F2"}, {"\u00F3", "\u00F3"}, {"\u00F4", "\u00F4"}, {"\u00F5", "\u00F5"}, {"\u00F6", "\u00F6"},
    {"\u00F9", "\u00F9"}, {"\u00FA", "\u00FA"}, {"\u00FB", "\u00FB"}, {"\u00FC", "\u00FC"}, {"\u00FD", "\u00FD"},
    {"\u00FF", "\u00FF"}, {"\u0100", "\u0100"}, {"\u0101", "\u0101"}, {"\u0102", "\u0102"}, {"\u0103", "\u0103"},
    {"\u0104", "\u0104"}, {"\u0105", "\u0105"}, {"\u0106", "\u0106"}, {"\u0107", "\u0107"}, {"\u0108", "\u0108"},
    {"\u0109", "\u0109"}, {"\u010A", "\u010A"}, {"\u010B", "\u010B"}, {"\u010C", "\u010C"}, {"\u010D", "\u010D"},
    {"\u010E", "\u010E"}, {"\u010F", "\u010F"}, {"\u0112", "\u0112"}, {"\u0113", "\u0113"}, {"\u0114", "\u0114"},
    {"\u0115", "\u0115"}, {"\u0116", "\u0116"}, {"\u0117", "\u0117"}, {"\u0118", "\u0118"}, {"\u0119", "\u0119"},
    {"\u011A", "\u011A"}, {"\u011B", "\u011B"}, {"\u011C", "\u011C"}, {"\u011D", "\u011D"}, {"\u011E", "\u011E"},
    {"\u011F", "\u011F"}, {"\u0120", "\u0120"}, {"\u0121", "\u0121"}, {"\u0122", "\u0122"}, {"\u0123", "\u0123"},
    {"\u0124", "\u0124"}, {"\u0125", "\u0125"}, {"\u0128", "\u0128"}, {"\u0129", "\u0129"}, {"\u012A", "\u012A"},
    {"\u012B", "\u012B"}, {"\u012C", "\u012C"}, {"\u012D", "\u012D"}, {"\u012E", "\u012E"}, {"\u012F", "\u012F"},
    {"\u0130", "\u0130"}, {"\u0132", "\u0132"}, {"\u0133", "\u0133"}, {"\u0134", "\u0134"}, {"\u0135", "\u0135"},
    {"\u0136", "\u0136"}, {"\u0137", "\u0137"}, {"\u0139", "\u0139"}, {"\u013A", "\u013A"}, {"\u013B", "\u013B"},
    {"\u013C", "\u013C"}, {"\u013D", "\u013D"}, {"\u013E", "\u013E"}, {"\u013F", "\u013F"}, {"\u0140", "\u0140"},
    {"\u0143", "\u0143"}, {"\u0144", "\u0144"}, {"\u0145", "\u0145"}, {"\u0146", "\u0146"}, {"\u0147", "\u0147"},
    {"\u0148", "\u0148"}, {"\u0149", "\u0149"}, {"\u014C", "\u014C"}, {"\u014D", "\u014D"}, {"\u014E", "\u014E"},
    {"\u014F", "\u014F"}, {"\u0150", "\u0150"}, {"\u0151", "\u0151"}, {"\u0154", "\u0154"}, {"\u0155", "\u0155"},
    {"\u0156", "\u0156"}, {"\u0157", "\u0157"}, {"\u0158", "\u0158"}, {"\u0159", "\u0159"}, {"\u015A", "\u015A"},
    {"\u015B", "\u015B"}, {"\u015C", "\u015C"}, {"\u015D", "\u015D"}, {"\u015E", "\u015E"}, {"\u015F", "\u015F"},
    {"\u0160", "\u0160"}, {"\u0161", "\u0161"}, {"\u0162", "\u0162"}, {"\u0163", "\u0163"}, {"\u0164", "\u0164"},
    {"\u0165", "\u0165"}, {"\u0168", "\u0168"}, {"\u0169", "\u0169"}, {"\u016A", "\u016A"}, {"\u016B", "\u016B"},
    {"\u016C", "\u016C"}, {"\u016D", "\u016D"}, {"\u016E", "\u016E"}, {"\u016F", "\u016F"}, {"\u0170", "\u0170"},
    {"\u0171", "\u0171"}, {"\u0172", "\u0172"}, {"\u0173", "\u0173"}, {"\u0174", "\u0174"}, {"\u0175", "\u0175"},
    {"\u0176", "\u0176"}, {"\u0177", "\u0177"}, {"\u0178", "\u0178"}, {"\u0179", "\u0179"}, {"\u017A", "\u017A"},
    {"\u017B", "\u017B"}, {"\u017C", "\u017C"}, {"\u017D", "\u017D"}, {"\u017E", "\u017E"}, {"\u017F", "\u017F"},
    {"\u01A0", "\u01A0"}, {"\u01A1", "\u01A1"}, {"\u01AF", "\u01AF"}, {"\u01B0", "\u01B0"}, {"\u01C4", "\u01C4"},
    {"\u01C5", "\u01C5"}, {"\u01C6", "\u01C6"}, {"\u01C7", "\u01C7"}, {"\u01C8", "\u01C8"}, {"\u01C9", "\u01C9"},
    {"\u01CA", "\u01CA"}, {"\u01CB", "\u01CB"}, {"\u01CC", "\u01CC"}, {"\u01CD", "\u01CD"}, {"\u01CE", "\u01CE"},
    {"\u01CF", "\u01CF"}, {"\u01D0", "\u01D0"}, {"\u01D1", "\u01D1"}, {"\u01D2", "\u01D2"}, {"\u01D3", "\u01D3"},
    {"\u01D4", "\u01D4"}, {"\u01D5", "\u01D5"}, {"\u01D6", "\u01D6"}, {"\u01D7", "\u01D7"}, {"\u01D8", "\u01D8"},
    {"\u01D9", "\u01D9"}, {"\u01DA", "\u01DA"}, {"\u01DB", "\u01DB"}, {"\u01DC", "\u01DC"}, {"\u01DE", "\u01DE"},
    {"\u01DF", "\u01DF"}, {"\u01E0", "\u01E0"}, {"\u01E1", "\u01E1"}, {"\u01E2", "\u01E2"}, {"\u01E3", "\u01E3"},
    {"\u01E6", "\u01E6"}, {"\u01E7", "\u01E7"}, {"\u01E8", "\u01E8"}, {"\u01E9", "\u01E9"}, {"\u01EA", "\u01EA"},
    {"\u01EB", "\u01EB"}, {"\u01EC", "\u01EC"}, {"\u01ED", "\u01ED"}, {"\u01EE", "\u01EE"}, {"\u01EF", "\u01EF"},
    {"\u01F0", "\u01F0"}, {"\u01F1", "\u01F1"}, {"\u01F2", "\u01F2"}, {"\u01F3", "\u01F3"}, {"\u01F4", "\u01F4"},
    {"\u01F5", "\u01F5"}, {"\u01F8", "\u01F8"}, {"\u01F9", "\u01F9"}, {"\u01FA", "\u01FA"}, {"\u01FB", "\u01FB"},
    {"\u01FC", "\u01FC"}, {"\u01FD", "\u01FD"}, {"\u01FE", "\u01FE"}, {"\u01FF", "\u01FF"}, {"\u0200", "\u0200"},
    {"\u0201", "\u0201"}, {"\u0202", "\u0202"}, {"\u0203", "\u0203"}, {"\u0204", "\u0204"}, {"\u0205", "\u0205"},
    {"\u0206", "\u0206"}, {"\u0207", "\u0207"}, {"\u0208", "\u0208"}, {"\u0209", "\u0209"}, {"\u020A", "\u020A"},
    {"\u020B", "\u020B"}, {"\u020C", "\u020C"}, {"\u020D", "\u020D"}, {"\u020E", "\u020E"}, {"\u020F", "\u020F"},
    {"\u0210", "\u0210"}, {"\u0211", "\u0211"}, {"\u0212", "\u0212"}, {"\u0213", "\u0213"}, {"\u0214", "\u0214"},
    {"\u0215", "\u0215"}, {"\u0216", "\u0216"}, {"\u0217", "\u0217"}, {"\u0218", "\u0218"}, {"\u0219", "\u0219"},
    {"\u021A", "\u021A"}, {"\u021B", "\u021B"}, {"\u021E", "\u021E"}, {"\u021F", "\u021F"}, {"\u0226", "\u0226"},
    {"\u0227", "\u0227"}, {"\u0228", "\u0228"}, {"\u0229", "\u0229"}, {"\u022A", "\u022A"}, {"\u022B", "\u022B"},
    {"\u022C", "\u022C"}, {"\u022D", "\u022D"}, {"\u022E", "\u022E"}, {"\u022F", "\u022F"}, {"\u0230", "\u0230"},
    {"\u0231", "\u0231"}, {"\u0232", "\u0232"}, {"\u0233", "\u0233"}, {"\u02B0", "\u02B0"}, {"\u02B1", "\u02B1"},
    {"\u02B2", "\u02B2"}, {"\u02B3", "\u02B3"}, {"\u02B4", "\u02B4"}, {"\u02B5", "\u02B5"}, {"\u02B6", "\u02B6"},
    {"\u02B7", "\u02B7"}, {"\u02B8", "\u02B8"}, {"\u02D8", "\u02D8"}, {"\u02D9", "\u02D9"}, {"\u02DA", "\u02DA"},
    {"\u02DB", "\u02DB"}, {"\u02DC", "\u02DC"}, {"\u02DD", "\u02DD"}, {"\u02E0", "\u02E0"}, {"\u02E1", "\u02E1"},
    {"\u02E2", "\u02E2"}, {"\u02E3", "\u02E3"}, {"\u02E4", "\u02E4"}, {"\u0340", "\u0300"}, {"\u0341", "\u0301"},
    {"\u0343", "\u0313"}, {"\u0344", "\u0308\u0301"}, {"\u0374", "\u02B9"}, {"\u037A", "\u037A"}, {"\u037E", "\u003B"},
    {"\u0384", "\u0384"}, {"\u0385", "\u0385"}, {"\u0386", "\u0386"}, {"\u0387", "\u00B7"}, {"\u0388", "\u0388"},
    {"\u0389", "\u0389"}, {"\u038A", "\u038A"}, {"\u038C", "\u038C"}, {"\u038E", "\u038E"}, {"\u038F", "\u038F"},
    {"\u0390", "\u0390"}, {"\u03AA", "\u03AA"}, {"\u03AB", "\u03AB"}, {"\u03AC", "\u03AC"}, {"\u03AD", "\u03AD"},
    {"\u03AE", "\u03AE"}, {"\u03AF", "\u03AF"}, {"\u03B0", "\u03B0"}, {"\u03CA", "\u03CA"}, {"\u03CB", "\u03CB"},
    {"\u03CC", "\u03CC"}, {"\u03CD", "\u03CD"}, {"\u03CE", "\u03CE"}, {"\u03D0", "\u03D0"}, {"\u03D1", "\u03D1"},
    {"\u03D2", "\u03D2"}, {"\u03D3", "\u03D3"}, {"\u03D4", "\u03D4"}, {"\u03D5", "\u03D5"}, {"\u03D6", "\u03D6"},
    {"\u03F0", "\u03F0"}, {"\u03F1", "\u03F1"}, {"\u03F2", "\u03F2"}, {"\u03F4", "\u03F4"}, {"\u03F5", "\u03F5"},
    {"\u03F9", "\u03F9"}, {"\u0400", "\u0400"}, {"\u0401", "\u0401"}, {"\u0403", "\u0403"}, {"\u0407", "\u0407"},
    {"\u040C", "\u040C"}, {"\u040D", "\u040D"}, {"\u040E", "\u040E"}, {"\u0419", "\u0419"}, {"\u0439", "\u0439"},
    {"\u0450", "\u0450"}, {"\u0451", "\u0451"}, {"\u0453", "\u0453"}, {"\u0457", "\u0457"}, {"\u045C", "\u045C"},
    {"\u045D", "\u045D"}, {"\u045E", "\u045E"}, {"\u0476", "\u0476"}, {"\u0477", "\u0477"}, {"\u04C1", "\u04C1"},
    {"\u04C2", "\u04C2"}, {"\u04D0", "\u04D0"}, {"\u04D1", "\u04D1"}, {"\u04D2", "\u04D2"}, {"\u04D3", "\u04D3"},
    {"\u04D6", "\u04D6"}, {"\u04D7", "\u04D7"}, {"\u04DA", "\u04DA"}, {"\u04DB", "\u04DB"}, {"\u04DC", "\u04DC"},
    {"\u04DD", "\u04DD"}, {"\u04DE", "\u04DE"}, {"\u04DF", "\u04DF"}, {"\u04E2", "\u04E2"}, {"\u04E3", "\u04E3"},
    {"\u04E4", "\u04E4"}, {"\u04E5", "\u04E5"}, {"\u04E6", "\u04E6"}, {"\u04E7", "\u04E7"}, {"\u04EA", "\u04EA"},
    {"\u04EB", "\u04EB"}, {"\u04EC", "\u04EC"}, {"\u04ED", "\u04ED"}, {"\u04EE", "\u04EE"}, {"\u04EF", "\u04EF"},
    {"\u04F0", "\u04F0"}, {"\u04F1", "\u04F1"}, {"\u04F2", "\u04F2"}, {"\u04F3", "\u04F3"}, {"\u04F4", "\u04F4"},
    {"\u04F5", "\u04F5"}, {"\u04F8", "\u04F8"}, {"\u04F9", "\u04F9"}, {"\u0587", "\u0587"}, {"\u0622", "\u0622"},
    {"\u0623", "\u0623"}, {"\u0624", "\u0624"}, {"\u0625", "\u0625"}, {"\u0626", "\u0626"}, {"\u0675", "\u0675"},
    {"\u0676", "\u0676"}, {"\u0677", "\u0677"}, {"\u0678", "\u0678"}, {"\u06C0", "\u06C0"}, {"\u06C2", "\u06C2"},
    {"\u06D3", "\u06D3"}, {"\u0929", "\u0929"}, {"\u0931", "\u0931"}, {"\u0934", "\u0934"}, {"\u0958", "\u0915\u093C"},
    {"\u0959", "\u0916\u093C"}, {"\u095A", "\u0917\u093C"}, {"\u095B", "\u091C\u093C"}, {"\u095C", "\u0921\u093C"},
    {"\u095D", "\u0922\u093C"}, {"\u095E", "\u092B\u093C"}, {"\u095F", "\u092F\u093C"}, {"\u09CB", "\u09CB"},
    {"\u09CC", "\u09CC"}, {"\u09DC", "\u09A1\u09BC"}, {"\u09DD", "\u09A2\u09BC"}, {"\u09DF", "\u09AF\u09BC"},
    {"\u0A33", "\u0A32\u0A3C"}, {"\u0A36", "\u0A38\u0A3C"}, {"\u0A59", "\u0A16\u0A3C"}, {"\u0A5A", "\u0A17\u0A3C"},
    {"\u0A5B", "\u0A1C\u0A3C"}, {"\u0A5E", "\u0A2B\u0A3C"}, {"\u0B48", "\u0B48"}, {"\u0B4B", "\u0B4B"},
    {"\u0B4C", "\u0B4C"}, {"\u0B5C", "\u0B21\u0B3C"}, {"\u0B5D", "\u0B22\u0B3C"}, {"\u0B94", "\u0B94"},
    {"\u0BCA", "\u0BCA"}, {"\u0BCB", "\u0BCB"}, {"\u0BCC", "\u0BCC"}, {"\u0C48", "\u0C48"}, {"\u0CC0", "\u0CC0"},
    {"\u0CC7", "\u0CC7"}, {"\u0CC8", "\u0CC8"}, {"\u0CCA", "\u0CCA"}, {"\u0CCB", "\u0CCB"}, {"\u0D4A", "\u0D4A"},
    {"\u0D4B", "\u0D4B"}, {"\u0D4C", "\u0D4C"}, {"\u0DDA", "\u0DDA"}, {"\u0DDC", "\u0DDC"}, {"\u0DDD", "\u0DDD"},
    {"\u0DDE", "\u0DDE"}, {"\u0E33", "\u0E33"}, {"\u0EB3", "\u0EB3"}, {"\u0EDC", "\u0EDC"}, {"\u0EDD", "\u0EDD"},
    {"\u0F0C", "\u0F0C"}, {"\u0F43", "\u0F42\u0FB7"}, {"\u0F4D", "\u0F4C\u0FB7"}, {"\u0F52", "\u0F51\u0FB7"},
    {"\u0F57", "\u0F56\u0FB7"}, {"\u0F5C", "\u0F5B\u0FB7"}, {"\u0F69", "\u0F40\u0FB5"}, {"\u0F73", "\u0F71\u0F72"},
    {"\u0F75", "\u0F71\u0F74"}, {"\u0F76", "\u0FB2\u0F80"}, {"\u0F77", "\u0F77"}, {"\u0F78", "\u0FB3\u0F80"},
    {"\u0F79", "\u0F79"}, {"\u0F81", "\u0F71\u0F80"}, {"\u0F93", "\u0F92\u0FB7"}, {"\u0F9D", "\u0F9C\u0FB7"},
    {"\u0FA2", "\u0FA1\u0FB7"}, {"\u0FA7", "\u0FA6\u0FB7"}, {"\u0FAC", "\u0FAB\u0FB7"}, {"\u0FB9", "\u0F90\u0FB5"},
    {"\u1026", "\u1026"}, {"\u10FC", "\u10FC"}, {"\u1B06", "\u1B06"}, {"\u1B08", "\u1B08"}, {"\u1B0A", "\u1B0A"},
    {"\u1B0C", "\u1B0C"}, {"\u1B0E", "\u1B0E"}, {"\u1B12", "\u1B12"}, {"\u1B3B", "\u1B3B"}, {"\u1B3D", "\u1B3D"},
    {"\u1B40", "\u1B40"}, {"\u1B41", "\u1B41"}, {"\u1B43", "\u1B43"}, {"\u1D2C", "\u1D2C"}, {"\u1D2D", "\u1D2D"},
    {"\u1D2E", "\u1D2E"}, {"\u1D30", "\u1D30"}, {"\u1D31", "\u1D31"}, {"\u1D32", "\u1D32"}, {"\u1D33", "\u1D33"},
    {"\u1D34", "\u1D34"}, {"\u1D35", "\u1D35"}, {"\u1D36", "\u1D36"}, {"\u1D37", "\u1D37"}, {"\u1D38", "\u1D38"},
    {"\u1D39", "\u1D39"}, {"\u1D3A", "\u1D3A"}, {"\u1D3C", "\u1D3C"}, {"\u1D3D", "\u1D3D"}, {"\u1D3E", "\u1D3E"},
    {"\u1D3F", "\u1D3F"}, {"\u1D40", "\u1D40"}, {"\u1D41", "\u1D41"}, {"\u1D42", "\u1D42"}, {"\u1D43", "\u1D43"},
    {"\u1D44", "\u1D44"}, {"\u1D45", "\u1D45"}, {"\u1D46", "\u1D46"}, {"\u1D47", "\u1D47"}, {"\u1D48", "\u1D48"},
    {"\u1D49", "\u1D49"}, {"\u1D4A", "\u1D4A"}, {"\u1D4B", "\u1D4B"}, {"\u1D4C", "\u1D4C"}, {"\u1D4D", "\u1D4D"},
    {"\u1D4F", "\u1D4F"}, {"\u1D50", "\u1D50"}, {"\u1D51", "\u1D51"}, {"\u1D52", "\u1D52"}, {"\u1D53", "\u1D53"},
    {"\u1D54", "\u1D54"}, {"\u1D55", "\u1D55"}, {"\u1D56", "\u1D56"}, {"\u1D57", "\u1D57"}, {"\u1D58", "\u1D58"},
    {"\u1D59", "\u1D59"}, {"\u1D5A", "\u1D5A"}, {"\u1D5B", "\u1D5B"}, {"\u1D5C", "\u1D5C"}, {"\u1D5D", "\u1D5D"},
    {"\u1D5E", "\u1D5E"}, {"\u1D5F", "\u1D5F"}, {"\u1D60", "\u1D60"}, {"\u1D61", "\u1D61"}, {"\u1D62", "\u1D62"},
    {"\u1D63", "\u1D63"}, {"\u1D64", "\u1D64"}, {"\u1D65", "\u1D65"}, {"\u1D66", "\u1D66"}, {"\u1D67", "\u1D67"},
    {"\u1D68", "\u1D68"}, {"\u1D69", "\u1D69"}, {"\u1D6A", "\u1D6A"}, {"\u1D78", "\u1D78"}, {"\u1D9B", "\u1D9B"},
    {"\u1D9C", "\u1D9C"}, {"\u1D9D", "\u1D9D"}, {"\u1D9E", "\u1D9E"}, {"\u1D9F", "\u1D9F"}, {"\u1DA0", "\u1DA0"},
    {"\u1DA1", "\u1DA1"}, {"\u1DA2", "\u1DA2"}, {"\u1DA3", "\u1DA3"}, {"\u1DA4", "\u1DA4"}, {"\u1DA5", "\u1DA5"},
    {"\u1DA6", "\u1DA6"}, {"\u1DA7", "\u1DA7"}, {"\u1DA8", "\u1DA8"}, {"\u1DA9", "\u1DA9"}, {"\u1DAA", "\u1DAA"},
    {"\u1DAB", "\u1DAB"}, {"\u1DAC", "\u1DAC"}, {"\u1DAD", "\u1DAD"}, {"\u1DAE", "\u1DAE"}, {"\u1DAF", "\u1DAF"},
    {"\u1DB0", "\u1DB0"}, {"\u1DB1", "\u1DB1"}, {"\u1DB2", "\u1DB2"}, {"\u1DB3", "\u1DB3"}, {"\u1DB4", "\u1DB4"},
    {"\u1DB5", "\u1DB5"}, {"\u1DB6", "\u1DB6"}, {"\u1DB7", "\u1DB7"}, {"\u1DB8", "\u1DB8"}, {"\u1DB9", "\u1DB9"},
    {"\u1DBA", "\u1DBA"}, {"\u1DBB", "\u1DBB"}, {"\u1DBC", "\u1DBC"}, {"\u1DBD", "\u1DBD"}, {"\u1DBE", "\u1DBE"},
    {"\u1DBF", "\u1DBF"}, {"\u1E00", "\u1E00"}, {"\u1E01", "\u1E01"}, {"\u1E02", "\u1E02"}, {"\u1E03", "\u1E03"},
    {"\u1E04", "\u1E04"}, {"\u1E05", "\u1E05"}, {"\u1E06", "\u1E06"}, {"\u1E07", "\u1E07"}, {"\u1E08", "\u1E08"},
    {"\u1E09", "\u1E09"}, {"\u1E0A", "\u1E0A"}, {"\u1E0B", "\u1E0B"}, {"\u1E0C", "\u1E0C"}, {"\u1E0D", "\u1E0D"},
    {"\u1E0E", "\u1E0E"}, {"\u1E0F", "\u1E0F"}, {"\u1E10", "\u1E10"}, {"\u1E11", "\u1E11"}, {"\u1E12", "\u1E12"},
    {"\u1E13", "\u1E13"}, {"\u1E14", "\u1E14"}, {"\u1E15", "\u1E15"}, {"\u1E16", "\u1E16"}, {"\u1E17", "\u1E17"},
    {"\u1E18", "\u1E18"}, {"\u1E19", "\u1E19"}, {"\u1E1A", "\u1E1A"}, {"\u1E1B", "\u1E1B"}, {"\u1E1C", "\u1E1C"},
    {"\u1E1D", "\u1E1D"}, {"\u1E1E", "\u1E1E"}, {"\u1E1F", "\u1E1F"}, {"\u1E20", "\u1E20"}, {"\u1E21", "\u1E21"},
    {"\u1E22", "\u1E22"}, {"\u1E23", "\u1E23"}, {"\u1E24", "\u1E24"}, {"\u1E25", "\u1E25"}, {"\u1E26", "\u1E26"},
    {"\u1E27", "\u1E27"}, {"\u1E28", "\u1E28"}, {"\u1E29", "\u1E29"}, {"\u1E2A", "\u1E2A"}, {"\u1E2B", "\u1E2B"},
    {"\u1E2C", "\u1E2C"}, {"\u1E2D", "\u1E2D"}, {"\u1E2E", "\u1E2E"}, {"\u1E2F", "\u1E2F"}, {"\u1E30", "\u1E30"},
    {"\u1E31", "\u1E31"}, {"\u1E32", "\u1E32"}, {"\u1E33", "\u1E33"}, {"\u1E34", "\u1E34"}, {"\u1E35", "\u1E35"},
    {"\u1E36", "\u1E36"}, {"\u1E37", "\u1E37"}, {"\u1E38", "\u1E38"}, {"\u1E39", "\u1E39"}, {"\u1E3A", "\u1E3A"},
    {"\u1E3B", "\u1E3B"}, {"\u1E3C", "\u1E3C"}, {"\u1E3D", "\u1E3D"}, {"\u1E3E", "\u1E3E"}, {"\u1E3F", "\u1E3F"},
    {"\u1E40", "\u1E40"}, {"\u1E41", "\u1E41"}, {"\u1E42", "\u1E42"}, {"\u1E43", "\u1E43"}, {"\u1E44", "\u1E44"},
    {"\u1E45", "\u1E45"}, {"\u1E46", "\u1E46"}, {"\u1E47", "\u1E47"}, {"\u1E48", "\u1E48"}, {"\u1E49", "\u1E49"},
    {"\u1E4A", "\u1E4A"}, {"\u1E4B", "\u1E4B"}, {"\u1E4C", "\u1E4C"}, {"\u1E4D", "\u1E4D"}, {"\u1E4E", "\u1E4E"},
    {"\u1E4F", "\u1E4F"}, {"\u1E50", "\u1E50"}, {"\u1E51", "\u1E51"}, {"\u1E52", "\u1E52"}, {"\u1E53", "\u1E53"},
    {"\u1E54", "\u1E54"}, {"\u1E55", "\u1E55"}, {"\u1E56", "\u1E56"}, {"\u1E57", "\u1E57"}, {"\u1E58", "\u1E58"},
    {"\u1E59", "\u1E59"}, {"\u1E5A", "\u1E5A"}, {"\u1E5B", "\u1E5B"}, {"\u1E5C", "\u1E5C"}, {"\u1E5D", "\u1E5D"},
    {"\u1E5E", "\u1E5E"}, {"\u1E5F", "\u1E5F"}, {"\u1E60", "\u1E60"}, {"\u1E61", "\u1E61"}, {"\u1E62", "\u1E62"},
    {"\u1E63", "\u1E63"}, {"\u1E64", "\u1E64"}, {"\u1E65", "\u1E65"}, {"\u1E66", "\u1E66"}, {"\u1E67", "\u1E67"},
    {"\u1E68", "\u1E68"}, {"\u1E69", "\u1E69"}, {"\u1E6A", "\u1E6A"}, {"\u1E6B", "\u1E6B"}, {"\u1E6C", "\u1E6C"},
    {"\u1E6D", "\u1E6D"}, {"\u1E6E", "\u1E6E"}, {"\u1E6F", "\u1E6F"}, {"\u1E70", "\u1E70"}, {"\u1E71", "\u1E71"},
    {"\u1E72", "\u1E72"}, {"\u1E73", "\u1E73"}, {"\u1E74", "\u1E74"}, {"\u1E75", "\u1E75"}, {"\u1E76", "\u1E76"},
    {"\u1E77", "\u1E77"}, {"\u1E78", "\u1E78"}, {"\u1E79", "\u1E79"}, {"\u1E7A", "\u1E7A"}, {"\u1E7B", "\u1E7B"},
    {"\u1E7C", "\u1E7C"}, {"\u1E7D", "\u1E7D"}, {"\u1E7E", "\u1E7E"}, {"\u1E7F", "\u1E7F"}, {"\u1E80", "\u1E80"},
    {"\u1E81", "\u1E81"}, {"\u1E82", "\u1E82"}, {"\u1E83", "\u1E83"}, {"\u1E84", "\u1E84"}, {"\u1E85", "\u1E85"},
    {"\u1E86", "\u1E86"}, {"\u1E87", "\u1E87"}, {"\u1E88", "\u1E88"}, {"\u1E89", "\u1E89"}, {"\u1E8A", "\u1E8A"},
    {"\u1E8B", "\u1E8B"}, {"\u1E8C", "\u1E8C"}, {"\u1E8D", "\u1E8D"}, {"\u1E8E", "\u1E8E"}, {"\u1E8F", "\u1E8F"},
    {"\u1E90", "\u1E90"}, {"\u1E91", "\u1E91"}, {"\u1E92", "\u1E92"}, {"\u1E93", "\u1E93"}, {"\u1E94", "\u1E94"},
    {"\u1E95", "\u1E95"}, {"\u1E96", "\u1E96"}, {"\u1E97", "\u1E97"}, {"\u1E98", "\u1E98"}, {"\u1E99", "\u1E99"},
    {"\u1E9A", "\u1E9A"}, {"\u1E9B", "\u1E9B"}, {"\u1EA0", "\u1EA0"}, {"\u1EA1", "\u1EA1"}, {"\u1EA2", "\u1EA2"},
    {"\u1EA3", "\u1EA3"}, {"\u1EA4", "\u1EA4"}, {"\u1EA5", "\u1EA5"}, {"\u1EA6", "\u1EA6"}, {"\u1EA7", "\u1EA7"},
    {"\u1EA8", "\u1EA8"}, {"\u1EA9", "\u1EA9"}, {"\u1EAA", "\u1EAA"}, {"\u1EAB", "\u1EAB"}, {"\u1EAC", "\u1EAC"},
    {"\u1EAD", "\u1EAD"}, {"\u1EAE", "\u1EAE"}, {"\u1EAF", "\u1EAF"}, {"\u1EB0", "\u1EB0"}, {"\u1EB1", "\u1EB1"},
    {"\u1EB2", "\u1EB2"}, {"\u1EB3", "\u1EB3"}, {"\u1EB4", "\u1EB4"}, {"\u1EB5", "\u1EB5"}, {"\u1EB6", "\u1EB6"},
    {"\u1EB7", "\u1EB7"}, {"\u1EB8", "\u1EB8"}, {"\u1EB9", "\u1EB9"}, {"\u1EBA", "\u1EBA"}, {"\u1EBB", "\u1EBB"},
    {"\u1EBC", "\u1EBC"}, {"\u1EBD", "\u1EBD"}, {"\u1EBE", "\u1EBE"}, {"\u1EBF", "\u1EBF"}, {"\u1EC0", "\u1EC0"},
    {"\u1EC1", "\u1EC1"}, {"\u1EC2", "\u1EC2"}, {"\u1EC3", "\u1EC3"}, {"\u1EC4", "\u1EC4"}, {"\u1EC5", "\u1EC5"},
    {"\u1EC6", "\u1EC6"}, {"\u1EC7", "\u1EC7"}, {"\u1EC8", "\u1EC8"}, {"\u1EC9", "\u1EC9"}, {"\u1ECA", "\u1ECA"},
    {"\u1ECB", "\u1ECB"}, {"\u1ECC", "\u1ECC"}, {"\u1ECD", "\u1ECD"}, {"\u1ECE", "\u1ECE"}, {"\u1ECF", "\u1ECF"},
    {"\u1ED0", "\u1ED0"}, {"\u1ED1", "\u1ED1"}, {"\u1ED2", "\u1ED2"}, {"\u1ED3", "\u1ED3"}, {"\u1ED4", "\u1ED4"},
    {"\u1ED5", "\u1ED5"}, {"\u1ED6", "\u1ED6"}, {"\u1ED7", "\u1ED7"}, {"\u1ED8", "\u1ED8"}, {"\u1ED9", "\u1ED9"},
    {"\u1EDA", "\u1EDA"}, {"\u1EDB", "\u1EDB"}, {"\u1EDC", "\u1EDC"}, {"\u1EDD", "\u1EDD"}, {"\u1EDE", "\u1EDE"},
    {"\u1EDF", "\u1EDF"}, {"\u1EE0", "\u1EE0"}, {"\u1EE1", "\u1EE1"}, {"\u1EE2", "\u1EE2"}, {"\u1EE3", "\u1EE3"},
    {"\u1EE4", "\u1EE4"}, {"\u1EE5", "\u1EE5"}, {"\u1EE6", "\u1EE6"}, {"\u1EE7", "\u1EE7"}, {"\u1EE8", "\u1EE8"},
    {"\u1EE9", "\u1EE9"}, {"\u1EEA", "\u1EEA"}, {"\u1EEB", "\u1EEB"}, {"\u1EEC", "\u1EEC"}, {"\u1EED", "\u1EED"},
    {"\u1EEE", "\u1EEE"}, {"\u1EEF", "\u1EEF"}, {"\u1EF0", "\u1EF0"}, {"\u1EF1", "\u1EF1"}, {"\u1EF2", "\u1EF2"},
    {"\u1EF3", "\u1EF3"}, {"\u1EF4", "\u1EF4"}, {"\u1EF5", "\u1EF5"}, {"\u1EF6", "\u1EF6"}, {"\u1EF7", "\u1EF7"},
    {"\u1EF8", "\u1EF8"}, {"\u1EF9", "\u1EF9"}, {"\u1F00", "\u1F00"}, {"\u1F01", "\u1F01"}, {"\u1F02", "\u1F02"},
    {"\u1F03", "\u1F03"}, {"\u1F04", "\u1F04"}, {"\u1F05", "\u1F05"}, {"\u1F06", "\u1F06"}, {"\u1F07", "\u1F07"},
    {"\u1F08", "\u1F08"}, {"\u1F09", "\u1F09"}, {"\u1F0A", "\u1F0A"}, {"\u1F0B", "\u1F0B"}, {"\u1F0C", "\u1F0C"},
    {"\u1F0D", "\u1F0D"}, {"\u1F0E", "\u1F0E"}, {"\u1F0F", "\u1F0F"}, {"\u1F10", "\u1F10"}, {"\u1F11", "\u1F11"},
    {"\u1F12", "\u1F12"}, {"\u1F13", "\u1F13"}, {"\u1F14", "\u1F14"}, {"\u1F15", "\u1F15"}, {"\u1F18", "\u1F18"},
    {"\u1F19", "\u1F19"}, {"\u1F1A", "\u1F1A"}, {"\u1F1B", "\u1F1B"}, {"\u1F1C", "\u1F1C"}, {"\u1F1D", "\u1F1D"},
    {"\u1F20", "\u1F20"}, {"\u1F21", "\u1F21"}, {"\u1F22", "\u1F22"}, {"\u1F23", "\u1F23"}, {"\u1F24", "\u1F24"},
    {"\u1F25", "\u1F25"}, {"\u1F26", "\u1F26"}, {"\u1F27", "\u1F27"}, {"\u1F28", "\u1F28"}, {"\u1F29", "\u1F29"},
    {"\u1F2A", "\u1F2A"}, {"\u1F2B", "\u1F2B"}, {"\u1F2C", "\u1F2C"}, {"\u1F2D", "\u1F2D"}, {"\u1F2E", "\u1F2E"},
    {"\u1F2F", "\u1F2F"}, {"\u1F30", "\u1F30"}, {"\u1F31", "\u1F31"}, {"\u1F32", "\u1F32"}, {"\u1F33", "\u1F33"},
    {"\u1F34", "\u1F34"}, {"\u1F35", "\u1F35"}, {"\u1F36", "\u1F36"}, {"\u1F37", "\u1F37"}, {"\u1F38", "\u1F38"},
    {"\u1F39", "\u1F39"}, {"\u1F3A", "\u1F3A"}, {"\u1F3B", "\u1F3B"}, {"\u1F3C", "\u1F3C"}, {"\u1F3D", "\u1F3D"},
    {"\u1F3E", "\u1F3E"}, {"\u1F3F", "\u1F3F"}, {"\u1F40", "\u1F40"}, {"\u1F41", "\u1F41"}, {"\u1F42", "\u1F42"},
    {"\u1F43", "\u1F43"}, {"\u1F44", "\u1F44"}, {"\u1F45", "\u1F45"}, {"\u1F48", "\u1F48"}, {"\u1F49", "\u1F49"},
    {"\u1F4A", "\u1F4A"}, {"\u1F4B", "\u1F4B"}, {"\u1F4C", "\u1F4C"}, {"\u1F4D", "\u1F4D"}, {"\u1F50", "\u1F50"},
    {"\u1F51", "\u1F51"}, {"\u1F52", "\u1F52"}, {"\u1F53", "\u1F53"}, {"\u1F54", "\u1F54"}, {"\u1F55", "\u1F55"},
    {"\u1F56", "\u1F56"}, {"\u1F57", "\u1F57"}, {"\u1F59", "\u1F59"}, {"\u1F5B", "\u1F5B"}, {"\u1F5D", "\u1F5D"},
    {"\u1F5F", "\u1F5F"}, {"\u1F60", "\u1F60"}, {"\u1F61", "\u1F61"}, {"\u1F62", "\u1F62"}, {"\u1F63", "\u1F63"},
    {"\u1F64", "\u1F64"}, {"\u1F65", "\u1F65"}, {"\u1F66", "\u1F66"}, {"\u1F67", "\u1F67"}, {"\u1F68", "\u1F68"},
    {"\u1F69", "\u1F69"}, {"\u1F6A", "\u1F6A"}, {"\u1F6B", "\u1F6B"}, {"\u1F6C", "\u1F6C"}, {"\u1F6D", "\u1F6D"},
    {"\u1F6E", "\u1F6E"}, {"\u1F6F", "\u1F6F"}, {"\u1F70", "\u1F70"}, {"\u1F71", "\u03AC"}, {"\u1F72", "\u1F72"},
    {"\u1F73", "\u03AD"}, {"\u1F74", "\u1F74"}, {"\u1F75", "\u03AE"}, {"\u1F76", "\u1F76"}, {"\u1F77", "\u03AF"},
    {"\u1F78", "\u1F78"}, {"\u1F79", "\u03CC"}, {"\u1F7A", "\u1F7A"}, {"\u1F7B", "\u03CD"}, {"\u1F7C", "\u1F7C"},
    {"\u1F7D", "\u03CE"}, {"\u1F80", "\u1F80"}, {"\u1F81", "\u1F81"}, {"\u1F82", "\u1F82"}, {"\u1F83", "\u1F83"},
    {"\u1F84", "\u1F84"}, {"\u1F85", "\u1F85"}, {"\u1F86", "\u1F86"}, {"\u1F87", "\u1F87"}, {"\u1F88", "\u1F88"},
    {"\u1F89", "\u1F89"}, {"\u1F8A", "\u1F8A"}, {"\u1F8B", "\u1F8B"}, {"\u1F8C", "\u1F8C"}, {"\u1F8D", "\u1F8D"},
    {"\u1F8E", "\u1F8E"}, {"\u1F8F", "\u1F8F"}, {"\u1F90", "\u1F90"}, {"\u1F91", "\u1F91"}, {"\u1F92", "\u1F92"},
    {"\u1F93", "\u1F93"}, {"\u1F94", "\u1F94"}, {"\u1F95", "\u1F95"}, {"\u1F96", "\u1F96"}, {"\u1F97", "\u1F97"},
    {"\u1F98", "\u1F98"}, {"\u1F99", "\u1F99"}, {"\u1F9A", "\u1F9A"}, {"\u1F9B", "\u1F9B"}, {"\u1F9C", "\u1F9C"},
    {"\u1F9D", "\u1F9D"}, {"\u1F9E", "\u1F9E"}, {"\u1F9F", "\u1F9F"}, {"\u1FA0", "\u1FA0"}, {"\u1FA1", "\u1FA1"},
    {"\u1FA2", "\u1FA2"}, {"\u1FA3", "\u1FA3"}, {"\u1FA4", "\u1FA4"}, {"\u1FA5", "\u1FA5"}, {"\u1FA6", "\u1FA6"},
    {"\u1FA7", "\u1FA7"}, {"\u1FA8", "\u1FA8"}, {"\u1FA9", "\u1FA9"}, {"\u1FAA", "\u1FAA"}, {"\u1FAB", "\u1FAB"},
    {"\u1FAC", "\u1FAC"}, {"\u1FAD", "\u1FAD"}, {"\u1FAE", "\u1FAE"}, {"\u1FAF", "\u1FAF"}, {"\u1FB0", "\u1FB0"},
    {"\u1FB1", "\u1FB1"}, {"\u1FB2", "\u1FB2"}, {"\u1FB3", "\u1FB3"}, {"\u1FB4", "\u1FB4"}, {"\u1FB6", "\u1FB6"},
    {"\u1FB7", "\u1FB7"}, {"\u1FB8", "\u1FB8"}, {"\u1FB9", "\u1FB9"}, {"\u1FBA", "\u1FBA"}, {"\u1FBB", "\u0386"},
    {"\u1FBC", "\u1FBC"}, {"\u1FBD", "\u1FBD"}, {"\u1FBE", "\u03B9"}, {"\u1FBF", "\u1FBF"}, {"\u1FC0", "\u1FC0"},
    {"\u1FC1", "\u1FC1"}, {"\u1FC2", "\u1FC2"}, {"\u1FC3", "\u1FC3"}, {"\u1FC4", "\u1FC4"}, {"\u1FC6", "\u1FC6"},
    {"\u1FC7", "\u1FC7"}, {"\u1FC8", "\u1FC8"}, {"\u1FC9", "\u0388"}, {"\u1FCA", "\u1FCA"}, {"\u1FCB", "\u0389"},
    {"\u1FCC", "\u1FCC"}, {"\u1FCD", "\u1FCD"}, {"\u1FCE", "\u1FCE"}, {"\u1FCF", "\u1FCF"}, {"\u1FD0", "\u1FD0"},
    {"\u1FD1", "\u1FD1"}, {"\u1FD2", "\u1FD2"}, {"\u1FD3", "\u0390"}, {"\u1FD6", "\u1FD6"}, {"\u1FD7", "\u1FD7"},
    {"\u1FD8", "\u1FD8"}, {"\u1FD9", "\u1FD9"}, {"\u1FDA", "\u1FDA"}, {"\u1FDB", "\u038A"}, {"\u1FDD", "\u1FDD"},
    {"\u1FDE", "\u1FDE"}, {"\u1FDF", "\u1FDF"}, {"\u1FE0", "\u1FE0"}, {"\u1FE1", "\u1FE1"}, {"\u1FE2", "\u1FE2"},
    {"\u1FE3", "\u03B0"}, {"\u1FE4", "\u1FE4"}, {"\u1FE5", "\u1FE5"}, {"\u1FE6", "\u1FE6"}, {"\u1FE7", "\u1FE7"},
    {"\u1FE8", "\u1FE8"}, {"\u1FE9", "\u1FE9"}, {"\u1FEA", "\u1FEA"}, {"\u1FEB", "\u038E"}, {"\u1FEC", "\u1FEC"},
    {"\u1FED", "\u1FED"}, {"\u1FEE", "\u0385"}, {"\u1FEF", "\u0060"}, {"\u1FF2", "\u1FF2"}, {"\u1FF3", "\u1FF3"},
    {"\u1FF4", "\u1FF4"}, {"\u1FF6", "\u1FF6"}, {"\u1FF7", "\u1FF7"}, {"\u1FF8", "\u1FF8"}, {"\u1FF9", "\u038C"},
    {"\u1FFA", "\u1FFA"}, {"\u1FFB", "\u038F"}, {"\u1FFC", "\u1FFC"}, {"\u1FFD", "\u00B4"}, {"\u1FFE", "\u1FFE"},
    {"\u2000", "\u2002"}, {"\u2001", "\u2003"}, {"\u2002", "\u2002"}, {"\u2003", "\u2003"}, {"\u2004", "\u2004"},
    {"\u2005", "\u2005"}, {"\u2006", "\u2006"}, {"\u2007", "\u2007"}, {"\u2008", "\u2008"}, {"\u2009", "\u2009"},
    {"\u200A", "\u200A"}, {"\u2011", "\u2011"}, {"\u2017", "\u2017"}, {"\u2024", "\u2024"}, {"\u2025", "\u2025"},
    {"\u2026", "\u2026"}, {"\u202F", "\u202F"}, {"\u2033", "\u2033"}, {"\u2034", "\u2034"}, {"\u2036", "\u2036"},
    {"\u2037", "\u2037"}, {"\u203C", "\u203C"}, {"\u203E", "\u203E"}, {"\u2047", "\u2047"}, {"\u2048", "\u2048"},
    {"\u2049", "\u2049"}, {"\u2057", "\u2057"}, {"\u205F", "\u205F"}, {"\u2070", "\u2070"}, {"\u2071", "\u2071"},
    {"\u2074", "\u2074"}, {"\u2075", "\u2075"}, {"\u2076", "\u2076"}, {"\u2077", "\u2077"}, {"\u2078", "\u2078"},
    {"\u2079", "\u2079"}, {"\u207A", "\u207A"}, {"\u207B", "\u207B"}, {"\u207C", "\u207C"}, {"\u207D", "\u207D"},
    {"\u207E", "\u207E"}, {"\u207F", "\u207F"}, {"\u2080", "\u2080"}, {"\u2081", "\u2081"}, {"\u2082", "\u2082"},
    {"\u2083", "\u2083"}, {"\u2084", "\u2084"}, {"\u2085", "\u2085"}, {"\u2086", "\u2086"}, {"\u2087", "\u2087"},
    {"\u2088", "\u2088"}, {"\u2089", "\u2089"}, {"\u208A", "\u208A"}, {"\u208B", "\u208B"}, {"\u208C", "\u208C"},
    {"\u208D", "\u208D"}, {"\u208E", "\u208E"}, {"\u2090", "\u2090"}, {"\u2091", "\u2091"}, {"\u2092", "\u2092"},
    {"\u2093", "\u2093"}, {"\u2094", "\u2094"}, {"\u2095", "\u2095"}, {"\u2096", "\u2096"}, {"\u2097", "\u2097"},
    {"\u2098", "\u2098"}, {"\u2099", "\u2099"}, {"\u209A", "\u209A"}, {"\u209B", "\u209B"}, {"\u209C", "\u209C"},
    {"\u20A8", "\u20A8"}, {"\u2100", "\u2100"}, {"\u2101", "\u2101"}, {"\u2102", "\u2102"}, {"\u2103", "\u2103"},
    {"\u2105", "\u2105"}, {"\u2106", "\u2106"}, {"\u2107", "\u2107"}, {"\u2109", "\u2109"}, {"\u210A", "\u210A"},
    {"\u210B", "\u210B"}, {"\u210C", "\u210C"}, {"\u210D", "\u210D"}, {"\u210E", "\u210E"}, {"\u210F", "\u210F"},
    {"\u2110", "\u2110"}, {"\u2111", "\u2111"}, {"\u2112", "\u2112"}, {"\u2113", "\u2113"}, {"\u2115", "\u2115"},
    {"\u2116", "\u2116"}, {"\u2119", "\u2119"}, {"\u211A", "\u211A"}, {"\u211B", "\u211B"}, {"\u211C", "\u211C"},
    {"\u211D", "\u211D"}, {"\u2120", "\u2120"}, {"\u2121", "\u2121"}, {"\u2122", "\u2122"}, {"\u2124", "\u2124"},
    {"\u2126", "\u03A9"}, {"\u2128", "\u2128"}, {"\u212A", "\u004B"}, {"\u212B", "\u00C5"}, {"\u212C", "\u212C"},
    {"\u212D", "\u212D"}, {"\u212F", "\u212F"}, {"\u2130", "\u2130"}, {"\u2131", "\u2131"}, {"\u2133", "\u2133"},
    {"\u2134", "\u2134"}, {"\u2135", "\u2135"}, {"\u2136", "\u2136"}, {"\u2137", "\u2137"}, {"\u2138", "\u2138"},
    {"\u2139", "\u2139"}, {"\u213B", "\u213B"}, {"\u213C", "\u213C"}, {"\u213D", "\u213D"}, {"\u213E", "\u213E"},
    {"\u213F", "\u213F"}, {"\u2140", "\u2140"}, {"\u2145", "\u2145"}, {"\u2146", "\u2146"}, {"\u2147", "\u2147"},
    {"\u2148", "\u2148"}, {"\u2149", "\u2149"}, {"\u2150", "\u2150"}, {"\u2151", "\u2151"}, {"\u2152", "\u2152"},
    {"\u2153", "\u2153"}, {"\u2154", "\u2154"}, {"\u2155", "\u2155"}, {"\u2156", "\u2156"}, {"\u2157", "\u2157"},
    {"\u2158", "\u2158"}, {"\u2159", "\u2159"}, {"\u215A", "\u215A"}, {"\u215B", "\u215B"}, {"\u215C", "\u215C"},
    {"\u215D", "\u215D"}, {"\u215E", "\u215E"}, {"\u215F", "\u215F"}, {"\u2160", "\u2160"}, {"\u2161", "\u2161"},
    {"\u2162", "\u2162"}, {"\u2163", "\u2163"}, {"\u2164", "\u2164"}, {"\u2165", "\u2165"}, {"\u2166", "\u2166"},
    {"\u2167", "\u2167"}, {"\u2168", "\u2168"}, {"\u2169", "\u2169"}, {"\u216A", "\u216A"}, {"\u216B", "\u216B"},
    {"\u216C", "\u216C"}, {"\u216D", "\u216D"}, {"\u216E", "\u216E"}, {"\u216F", "\u216F"}, {"\u2170", "\u2170"},
    {"\u2171", "\u2171"}, {"\u2172", "\u2172"}, {"\u2173", "\u2173"}, {"\u2174", "\u2174"}, {"\u2175", "\u2175"},
    {"\u2176", "\u2176"}, {"\u2177", "\u2177"}, {"\u2178", "\u2178"}, {"\u2179", "\u2179"}, {"\u217A", "\u217A"},
    {"\u217B", "\u217B"}, {"\u217C", "\u217C"}, {"\u217D", "\u217D"}, {"\u217E", "\u217E"}, {"\u217F", "\u217F"},
    {"\u2189", "\u2189"}, {"\u219A", "\u219A"}, {"\u219B", "\u219B"}, {"\u21AE", "\u21AE"}, {"\u21CD", "\u21CD"},
    {"\u21CE", "\u21CE"}, {"\u21CF", "\u21CF"}, {"\u2204", "\u2204"}, {"\u2209", "\u2209"}, {"\u220C", "\u220C"},
    {"\u2224", "\u2224"}, {"\u2226", "\u2226"}, {"\u222C", "\u222C"}, {"\u222D", "\u222D"}, {"\u222F", "\u222F"},
    {"\u2230", "\u2230"}, {"\u2241", "\u2241"}, {"\u2244", "\u2244"}, {"\u2247", "\u2247"}, {"\u2249", "\u2249"},
    {"\u2260", "\u2260"}, {"\u2262", "\u2262"}, {"\u226D", "\u226D"}, {"\u226E", "\u226E"}, {"\u226F", "\u226F"},
    {"\u2270", "\u2270"}, {"\u2271", "\u2271"}, {"\u2274", "\u2274"}, {"\u2275", "\u2275"}, {"\u2278", "\u2278"},
    {"\u2279", "\u2279"}, {"\u2280", "\u2280"}, {"\u2281", "\u2281"}, {"\u2284", "\u2284"}, {"\u2285", "\u2285"},
    {"\u2288", "\u2288"}, {"\u2289", "\u2289"}, {"\u22AC", "\u22AC"}, {"\u22AD", "\u22AD"}, {"\u22AE", "\u22AE"},
    {"\u22AF", "\u22AF"}, {"\u22E0", "\u22E0"}, {"\u22E1", "\u22E1"}, {"\u22E2", "\u22E2"}, {"\u22E3", "\u22E3"},
    {"\u22EA", "\u22EA"}, {"\u22EB", "\u22EB"}, {"\u22EC", "\u22EC"}, {"\u22ED", "\u22ED"}, {"\u2329", "\u3008"},
    {"\u232A", "\u3009"}, {"\u2460", "\u2460"}, {"\u2461", "\u2461"}, {"\u2462", "\u2462"}, {"\u2463", "\u2463"},
    {"\u2464", "\u2464"}, {"\u2465", "\u2465"}, {"\u2466", "\u2466"}, {"\u2467", "\u2467"}, {"\u2468", "\u2468"},
    {"\u2469", "\u2469"}, {"\u246A", "\u246A"}, {"\u246B", "\u246B"}, {"\u246C", "\u246C"}, {"\u246D", "\u246D"},
    {"\u246E", "\u246E"}, {"\u246F", "\u246F"}, {"\u2470", "\u2470"}, {"\u2471", "\u2471"}, {"\u2472", "\u2472"},
    {"\u2473", "\u2473"}, {"\u2474", "\u2474"}, {"\u2475", "\u2475"}, {"\u2476", "\u2476"}, {"\u2477", "\u2477"},
    {"\u2478", "\u2478"}, {"\u2479", "\u2479"}, {"\u247A", "\u247A"}, {"\u247B", "\u247B"}, {"\u247C", "\u247C"},
    {"\u247D", "\u247D"}, {"\u247E", "\u247E"}, {"\u247F", "\u247F"}, {"\u2480", "\u2480"}, {"\u2481", "\u2481"},
    {"\u2482", "\u2482"}, {"\u2483", "\u2483"}, {"\u2484", "\u2484"}, {"\u2485", "\u2485"}, {"\u2486", "\u2486"},
    {"\u2487", "\u2487"}, {"\u2488", "\u2488"}, {"\u2489", "\u2489"}, {"\u248A", "\u248A"}, {"\u248B", "\u248B"},
    {"\u248C", "\u248C"}, {"\u248D", "\u248D"}, {"\u248E", "\u248E"}, {"\u248F", "\u248F"}, {"\u2490", "\u2490"},
    {"\u2491", "\u2491"}, {"\u2492", "\u2492"}, {"\u2493", "\u2493"}, {"\u2494", "\u2494"}, {"\u2495", "\u2495"},
    {"\u2496", "\u2496"}, {"\u2497", "\u2497"}, {"\u2498", "\u2498"}, {"\u2499", "\u2499"}, {"\u249A", "\u249A"},
    {"\u249B", "\u249B"}, {"\u249C", "\u249C"}, {"\u249D", "\u249D"}, {"\u249E", "\u249E"}, {"\u249F", "\u249F"},
    {"\u24A0", "\u24A0"}, {"\u24A1", "\u24A1"}, {"\u24A2", "\u24A2"}, {"\u24A3", "\u24A3"}, {"\u24A4", "\u24A4"},
    {"\u24A5", "\u24A5"}, {"\u24A6", "\u24A6"}, {"\u24A7", "\u24A7"}, {"\u24A8", "\u24A8"}, {"\u24A9", "\u24A9"},
    {"\u24AA", "\u24AA"}, {"\u24AB", "\u24AB"}, {"\u24AC", "\u24AC"}, {"\u24AD", "\u24AD"}, {"\u24AE", "\u24AE"},
    {"\u24AF", "\u24AF"}, {"\u24B0", "\u24B0"}, {"\u24B1", "\u24B1"}, {"\u24B2", "\u24B2"}, {"\u24B3", "\u24B3"},
    {"\u24B4", "\u24B4"}, {"\u24B5", "\u24B5"}, {"\u24B6", "\u24B6"}, {"\u24B7", "\u24B7"}, {"\u24B8", "\u24B8"},
    {"\u24B9", "\u24B9"}, {"\u24BA", "\u24BA"}, {"\u24BB", "\u24BB"}, {"\u24BC", "\u24BC"}, {"\u24BD", "\u24BD"},
    {"\u24BE", "\u24BE"}, {"\u24BF", "\u24BF"}, {"\u24C0", "\u24C0"}, {"\u24C1", "\u24C1"}, {"\u24C2", "\u24C2"},
    {"\u24C3", "\u24C3"}, {"\u24C4", "\u24C4"}, {"\u24C5", "\u24C5"}, {"\u24C6", "\u24C6"}, {"\u24C7", "\u24C7"},
    {"\u24C8", "\u24C8"}, {"\u24C9", "\u24C9"}, {"\u24CA", "\u24CA"}, {"\u24CB", "\u24CB"}, {"\u24CC", "\u24CC"},
    {"\u24CD", "\u24CD"}, {"\u24CE", "\u24CE"}, {"\u24CF", "\u24CF"}, {"\u24D0", "\u24D0"}, {"\u24D1", "\u24D1"},
    {"\u24D2", "\u24D2"}, {"\u24D3", "\u24D3"}, {"\u24D4", "\u24D4"}, {"\u24D5", "\u24D5"}, {"\u24D6", "\u24D6"},
    {"\u24D7", "\u24D7"}, {"\u24D8", "\u24D8"}, {"\u24D9", "\u24D9"}, {"\u24DA", "\u24DA"}, {"\u24DB", "\u24DB"},
    {"\u24DC", "\u24DC"}, {"\u24DD", "\u24DD"}, {"\u24DE", "\u24DE"}, {"\u24DF", "\u24DF"}, {"\u24E0", "\u24E0"},
    {"\u24E1", "\u24E1"}, {"\u24E2", "\u24E2"}, {"\u24E3", "\u24E3"}, {"\u24E4", "\u24E4"}, {"\u24E5", "\u24E5"},
    {"\u24E6", "\u24E6"}, {"\u24E7", "\u24E7"}, {"\u24E8", "\u24E8"}, {"\u24E9", "\u24E9"}, {"\u24EA", "\u24EA"},
    {"\u2A0C", "\u2A0C"}, {"\u2A74", "\u2A74"}, {"\u2A75", "\u2A75"}, {"\u2A76", "\u2A76"}, {"\u2ADC", "\u2ADD\u0338"},
    {"\u2C7C", "\u2C7C"}, {"\u2C7D", "\u2C7D"}, {"\u2D6F", "\u2D6F"}, {"\u2E9F", "\u2E9F"}, {"\u2EF3", "\u2EF3"},
    {"\u2F00", "\u2F00"}, {"\u2F01", "\u2F01"}, {"\u2F02", "\u2F02"}, {"\u2F03", "\u2F03"}, {"\u2F04", "\u2F04"},
    {"\u2F05", "\u2F05"}, {"\u2F06", "\u2F06"}, {"\u2F07", "\u2F07"}, {"\u2F08", "\u2F08"}, {"\u2F09", "\u2F09"},
    {"\u2F0A", "\u2F0A"}, {"\u2F0B", "\u2F0B"}, {"\u2F0C", "\u2F0C"}, {"\u2F0D", "\u2F0D"}, {"\u2F0E", "\u2F0E"},
    {"\u2F0F", "\u2F0F"}, {"\u2F10", "\u2F10"}, {"\u2F11", "\u2F11"}, {"\u2F12", "\u2F12"}, {"\u2F13", "\u2F13"},
    {"\u2F14", "\u2F14"}, {"\u2F15", "\u2F15"}, {"\u2F16", "\u2F16"}, {"\u2F17", "\u2F17"}, {"\u2F18", "\u2F18"},
    {"\u2F19", "\u2F19"}, {"\u2F1A", "\u2F1A"}, {"\u2F1B", "\u2F1B"}, {"\u2F1C", "\u2F1C"}, {"\u2F1D", "\u2F1D"},
    {"\u2F1E", "\u2F1E"}, {"\u2F1F", "\u2F1F"}, {"\u2F20", "\u2F20"}, {"\u2F21", "\u2F21"}, {"\u2F22", "\u2F22"},
    {"\u2F23", "\u2F23"}, {"\u2F24", "\u2F24"}, {"\u2F25", "\u2F25"}, {"\u2F26", "\u2F26"}, {"\u2F27", "\u2F27"},
    {"\u2F28", "\u2F28"}, {"\u2F29", "\u2F29"}, {"\u2F2A", "\u2F2A"}, {"\u2F2B", "\u2F2B"}, {"\u2F2C", "\u2F2C"},
    {"\u2F2D", "\u2F2D"}, {"\u2F2E", "\u2F2E"}, {"\u2F2F", "\u2F2F"}, {"\u2F30", "\u2F30"}, {"\u2F31", "\u2F31"},
    {"\u2F32", "\u2F32"}, {"\u2F33", "\u2F33"}, {"\u2F34", "\u2F34"}, {"\u2F35", "\u2F35"}, {"\u2F36", "\u2F36"},
    {"\u2F37", "\u2F37"}, {"\u2F38", "\u2F38"}, {"\u2F39", "\u2F39"}, {"\u2F3A", "\u2F3A"}, {"\u2F3B", "\u2F3B"},
    {"\u2F3C", "\u2F3C"}, {"\u2F3D", "\u2F3D"}, {"\u2F3E", "\u2F3E"}, {"\u2F3F", "\u2F3F"}, {"\u2F40", "\u2F40"},
    {"\u2F41", "\u2F41"}, {"\u2F42", "\u2F42"}, {"\u2F43", "\u2F43"}, {"\u2F44", "\u2F44"}, {"\u2F45", "\u2F45"},
    {"\u2F46", "\u2F46"}, {"\u2F47", "\u2F47"}, {"\u2F48", "\u2F48"}, {"\u2F49", "\u2F49"}, {"\u2F4A", "\u2F4A"},
    {"\u2F4B", "\u2F4B"}, {"\u2F4C", "\u2F4C"}, {"\u2F4D", "\u2F4D"}, {"\u2F4E", "\u2F4E"}, {"\u2F4F", "\u2F4F"},
    {"\u2F50", "\u2F50"}, {"\u2F51", "\u2F51"}, {"\u2F52", "\u2F52"}, {"\u2F53", "\u2F53"}, {"\u2F54", "\u2F54"},
    {"\u2F55", "\u2F55"}, {"\u2F56", "\u2F56"}, {"\u2F57", "\u2F57"}, {"\u2F58", "\u2F58"}, {"\u2F59", "\u2F59"},
    {"\u2F5A", "\u2F5A"}, {"\u2F5B", "\u2F5B"}, {"\u2F5C", "\u2F5C"}, {"\u2F5D", "\u2F5D"}, {"\u2F5E", "\u2F5E"},
    {"\u2F5F", "\u2F5F"}, {"\u2F60", "\u2F60"}, {"\u2F61", "\u2F61"}, {"\u2F62", "\u2F62"}, {"\u2F63", "\u2F63"},
    {"\u2F64", "\u2F64"}, {"\u2F65", "\u2F65"}, {"\u2F66", "\u2F66"}, {"\u2F67", "\u2F67"}, {"\u2F68", "\u2F68"},
    {"\u2F69", "\u2F69"}, {"\u2F6A", "\u2F6A"}, {"\u2F6B", "\u2F6B"}, {"\u2F6C", "\u2F6C"}, {"\u2F6D", "\u2F6D"},
    {"\u2F6E", "\u2F6E"}, {"\u2F6F", "\u2F6F"}, {"\u2F70", "\u2F70"}, {"\u2F71", "\u2F71"}, {"\u2F72", "\u2F72"},
    {"\u2F73", "\u2F73"}, {"\u2F74", "\u2F74"}, {"\u2F75", "\u2F75"}, {"\u2F76", "\u2F76"}, {"\u2F77", "\u2F77"},
    {"\u2F78", "\u2F78"}, {"\u2F79", "\u2F79"}, {"\u2F7A", "\u2F7A"}, {"\u2F7B", "\u2F7B"}, {"\u2F7C", "\u2F7C"},
    {"\u2F7D", "\u2F7D"}, {"\u2F7E", "\u2F7E"}, {"\u2F7F", "\u2F7F"}, {"\u2F80", "\u2F80"}, {"\u2F81", "\u2F81"},
    {"\u2F82", "\u2F82"}, {"\u2F83", "\u2F83"}, {"\u2F84", "\u2F84"}, {"\u2F85", "\u2F85"}, {"\u2F86", "\u2F86"},
    {"\u2F87", "\u2F87"}, {"\u2F88", "\u2F88"}, {"\u2F89", "\u2F89"}, {"\u2F8A", "\u2F8A"}, {"\u2F8B", "\u2F8B"},
    {"\u2F8C", "\u2F8C"}, {"\u2F8D", "\u2F8D"}, {"\u2F8E", "\u2F8E"}, {"\u2F8F", "\u2F8F"}, {"\u2F90", "\u2F90"},
    {"\u2F91", "\u2F91"}, {"\u2F92", "\u2F92"}, {"\u2F93", "\u2F93"}, {"\u2F94", "\u2F94"}, {"\u2F95", "\u2F95"},
    {"\u2F96", "\u2F96"}, {"\u2F97", "\u2F97"}, {"\u2F98", "\u2F98"}, {"\u2F99", "\u2F99"}, {"\u2F9A", "\u2F9A"},
    {"\u2F9B", "\u2F9B"}, {"\u2F9C", "\u2F9C"}, {"\u2F9D", "\u2F9D"}, {"\u2F9E", "\u2F9E"}, {"\u2F9F", "\u2F9F"},
    {"\u2FA0", "\u2FA0"}, {"\u2FA1", "\u2FA1"}, {"\u2FA2", "\u2FA2"}, {"\u2FA3", "\u2FA3"}, {"\u2FA4", "\u2FA4"},
    {"\u2FA5", "\u2FA5"}, {"\u2FA6", "\u2FA6"}, {"\u2FA7", "\u2FA7"}, {"\u2FA8", "\u2FA8"}, {"\u2FA9", "\u2FA9"},
    {"\u2FAA", "\u2FAA"}, {"\u2FAB", "\u2FAB"}, {"\u2FAC", "\u2FAC"}, {"\u2FAD", "\u2FAD"}, {"\u2FAE", "\u2FAE"},
    {"\u2FAF", "\u2FAF"}, {"\u2FB0", "\u2FB0"}, {"\u2FB1", "\u2FB1"}, {"\u2FB2", "\u2FB2"}, {"\u2FB3", "\u2FB3"},
    {"\u2FB4", "\u2FB4"}, {"\u2FB5", "\u2FB5"}, {"\u2FB6", "\u2FB6"}, {"\u2FB7", "\u2FB7"}, {"\u2FB8", "\u2FB8"},
    {"\u2FB9", "\u2FB9"}, {"\u2FBA", "\u2FBA"}, {"\u2FBB", "\u2FBB"}, {"\u2FBC", "\u2FBC"}, {"\u2FBD", "\u2FBD"},
    {"\u2FBE", "\u2FBE"}, {"\u2FBF", "\u2FBF"}, {"\u2FC0", "\u2FC0"}, {"\u2FC1", "\u2FC1"}, {"\u2FC2", "\u2FC2"},
    {"\u2FC3", "\u2FC3"}, {"\u2FC4", "\u2FC4"}, {"\u2FC5", "\u2FC5"}, {"\u2FC6", "\u2FC6"}, {"\u2FC7", "\u2FC7"},
    {"\u2FC8", "\u2FC8"}, {"\u2FC9", "\u2FC9"}, {"\u2FCA", "\u2FCA"}, {"\u2FCB", "\u2FCB"}, {"\u2FCC", "\u2FCC"},
    {"\u2FCD", "\u2FCD"}, {"\u2FCE", "\u2FCE"}, {"\u2FCF", "\u2FCF"}, {"\u2FD0", "\u2FD0"}, {"\u2FD1", "\u2FD1"},
    {"\u2FD2", "\u2FD2"}, {"\u2FD3", "\u2FD3"}, {"\u2FD4", "\u2FD4"}, {"\u2FD5", "\u2FD5"}, {"\u3000", "\u3000"},
    {"\u3036", "\u3036"}, {"\u3038", "\u3038"}, {"\u3039", "\u3039"}, {"\u303A", "\u303A"}, {"\u304C", "\u304C"},
    {"\u304E", "\u304E"}, {"\u3050", "\u3050"}, {"\u3052", "\u3052"}, {"\u3054", "\u3054"}, {"\u3056", "\u3056"},
    {"\u3058", "\u3058"}, {"\u305A", "\u305A"}, {"\u305C", "\u305C"}, {"\u305E", "\u305E"}, {"\u3060", "\u3060"},
    {"\u3062", "\u3062"}, {"\u3065", "\u3065"}, {"\u3067", "\u3067"}, {"\u3069", "\u3069"}, {"\u3070", "\u3070"},
    {"\u3071", "\u3071"}, {"\u3073", "\u3073"}, {"\u3074", "\u3074"}, {"\u3076", "\u3076"}, {"\u3077", "\u3077"},
    {"\u3079", "\u3079"}, {"\u307A", "\u307A"}, {"\u307C", "\u307C"}, {"\u307D", "\u307D"}, {"\u3094", "\u3094"},
    {"\u309B", "\u309B"}, {"\u309C", "\u309C"}, {"\u309E", "\u309E"}, {"\u309F", "\u309F"}, {"\u30AC", "\u30AC"},
    {"\u30AE", "\u30AE"}, {"\u30B0", "\u30B0"}, {"\u30B2", "\u30B2"}, {"\u30B4", "\u30B4"}, {"\u30B6", "\u30B6"},
    {"\u30B8", "\u30B8"}, {"\u30BA", "\u30BA"}, {"\u30BC", "\u30BC"}, {"\u30BE", "\u30BE"}, {"\u30C0", "\u30C0"},
    {"\u30C2", "\u30C2"}, {"\u30C5", "\u30C5"}, {"\u30C7", "\u30C7"}, {"\u30C9", "\u30C9"}, {"\u30D0", "\u30D0"},
    {"\u30D1", "\u30D1"}, {"\u30D3", "\u30D3"}, {"\u30D4", "\u30D4"}, {"\u30D6", "\u30D6"}, {"\u30D7", "\u30D7"},
    {"\u30D9", "\u30D9"}, {"\u30DA", "\u30DA"}, {"\u30DC", "\u30DC"}, {"\u30DD", "\u30DD"}, {"\u30F4", "\u30F4"},
    {"\u30F7", "\u30F7"}, {"\u30F8", "\u30F8"}, {"\u30F9", "\u30F9"}, {"\u30FA", "\u30FA"}, {"\u30FE", "\u30FE"},
    {"\u30FF", "\u30FF"}, {"\u3131", "\u3131"}, {"\u3132", "\u3132"}, {"\u3133", "\u3133"}, {"\u3134", "\u3134"},
    {"\u3135", "\u3135"}, {"\u3136", "\u3136"}, {"\u3137", "\u3137"}, {"\u3138", "\u3138"}, {"\u3139", "\u3139"},
    {"\u313A", "\u313A"}, {"\u313B", "\u313B"}, {"\u313C", "\u313C"}, {"\u313D", "\u313D"}, {"\u313E", "\u313E"},
    {"\u313F", "\u313F"}, {"\u3140", "\u3140"}, {"\u3141", "\u3141"}, {"\u3142", "\u3142"}, {"\u3143", "\u3143"},
    {"\u3144", "\u3144"}, {"\u3145", "\u3145"}, {"\u3146", "\u3146"}, {"\u3147", "\u3147"}, {"\u3148", "\u3148"},
    {"\u3149", "\u3149"}, {"\u314A", "\u314A"}, {"\u314B", "\u314B"}, {"\u314C", "\u314C"}, {"\u314D", "\u314D"},
    {"\u314E", "\u314E"}, {"\u314F", "\u314F"}, {"\u3150", "\u3150"}, {"\u3151", "\u3151"}, {"\u3152", "\u3152"},
    {"\u3153", "\u3153"}, {"\u3154", "\u3154"}, {"\u3155", "\u3155"}, {"\u3156", "\u3156"}, {"\u3157", "\u3157"},
    {"\u3158", "\u3158"}, {"\u3159", "\u3159"}, {"\u315A", "\u315A"}, {"\u315B", "\u315B"}, {"\u315C", "\u315C"},
    {"\u315D", "\u315D"}, {"\u315E", "\u315E"}, {"\u315F", "\u315F"}, {"\u3160", "\u3160"}, {"\u3161", "\u3161"},
    {"\u3162", "\u3162"}, {"\u3163", "\u3163"}, {"\u3164", "\u3164"}, {"\u3165", "\u3165"}, {"\u3166", "\u3166"},
    {"\u3167", "\u3167"}, {"\u3168", "\u3168"}, {"\u3169", "\u3169"}, {"\u316A", "\u316A"}, {"\u316B", "\u316B"},
    {"\u316C", "\u316C"}, {"\u316D", "\u316D"}, {"\u316E", "\u316E"}, {"\u316F", "\u316F"}, {"\u3170", "\u3170"},
    {"\u3171", "\u3171"}, {"\u3172", "\u3172"}, {"\u3173", "\u3173"}, {"\u3174", "\u3174"}, {"\u3175", "\u3175"},
    {"\u3176", "\u3176"}, {"\u3177", "\u3177"}, {"\u3178", "\u3178"}, {"\u3179", "\u3179"}, {"\u317A", "\u317A"},
    {"\u317B", "\u317B"}, {"\u317C", "\u317C"}, {"\u317D", "\u317D"}, {"\u317E", "\u317E"}, {"\u317F", "\u317F"},
    {"\u3180", "\u3180"}, {"\u3181", "\u3181"}, {"\u3182", "\u3182"}, {"\u3183", "\u3183"}, {"\u3184", "\u3184"},
    {"\u3185", "\u3185"}, {"\u3186", "\u3186"}, {"\u3187", "\u3187"}, {"\u3188", "\u3188"}, {"\u3189", "\u3189"},
    {"\u318A", "\u318A"}, {"\u318B", "\u318B"}, {"\u318C", "\u318C"}, {"\u318D", "\u318D"}, {"\u318E", "\u318E"},
    {"\u3192", "\u3192"}, {"\u3193", "\u3193"}, {"\u3194", "\u3194"}, {"\u3195", "\u3195"}, {"\u3196", "\u3196"},
    {"\u3197", "\u3197"}, {"\u3198", "\u3198"}, {"\u3199", "\u3199"}, {"\u319A", "\u319A"}, {"\u319B", "\u319B"},
    {"\u319C", "\u319C"}, {"\u319D", "\u319D"}, {"\u319E", "\u319E"}, {"\u319F", "\u319F"}, {"\u3200", "\u3200"},
    {"\u3201", "\u3201"}, {"\u3202", "\u3202"}, {"\u3203", "\u3203"}, {"\u3204", "\u3204"}, {"\u3205", "\u3205"},
    {"\u3206", "\u3206"}, {"\u3207", "\u3207"}, {"\u3208", "\u3208"}, {"\u3209", "\u3209"}, {"\u320A", "\u320A"},
    {"\u320B", "\u320B"}, {"\u320C", "\u320C"}, {"\u320D", "\u320D"}, {"\u320E", "\u320E"}, {"\u320F", "\u320F"},
    {"\u3210", "\u3210"}, {"\u3211", "\u3211"}, {"\u3212", "\u3212"}, {"\u3213", "\u3213"}, {"\u3214", "\u3214"},
    {"\u3215", "\u3215"}, {"\u3216", "\u3216"}, {"\u3217", "\u3217"}, {"\u3218", "\u3218"}, {"\u3219", "\u3219"},
    {"\u321A", "\u321A"}, {"\u321B", "\u321B"}, {"\u321C", "\u321C"}, {"\u321D", "\u321D"}, {"\u321E", "\u321E"},
    {"\u3220", "\u3220"}, {"\u3221", "\u3221"}, {"\u3222", "\u3222"}, {"\u3223", "\u3223"}, {"\u3224", "\u3224"},
    {"\u3225", "\u3225"}, {"\u3226", "\u3226"}, {"\u3227", "\u3227"}, {"\u3228", "\u3228"}, {"\u3229", "\u3229"},
    {"\u322A", "\u322A"}, {"\u322B", "\u322B"}, {"\u322C", "\u322C"}, {"\u322D", "\u322D"}, {"\u322E", "\u322E"},
    {"\u322F", "\u322F"}, {"\u3230", "\u3230"}, {"\u3231", "\u3231"}, {"\u3232", "\u3232"}, {"\u3233", "\u3233"},
    {"\u3234", "\u3234"}, {"\u3235", "\u3235"}, {"\u3236", "\u3236"}, {"\u3237", "\u3237"}, {"\u3238", "\u3238"},
    {"\u3239", "\u3239"}, {"\u323A", "\u323A"}, {"\u323B", "\u323B"}, {"\u323C", "\u323C"}, {"\u323D", "\u323D"},
    {"\u323E", "\u323E"}, {"\u323F", "\u323F"}, {"\u3240", "\u3240"}, {"\u3241", "\u3241"}, {"\u3242", "\u3242"},
    {"\u3243", "\u3243"}, {"\u3244", "\u3244"}, {"\u3245", "\u3245"}, {"\u3246", "\u3246"}, {"\u3247", "\u3247"},
    {"\u3250", "\u3250"}, {"\u3251", "\u3251"}, {"\u3252", "\u3252"}, {"\u3253", "\u3253"}, {"\u3254", "\u3254"},
    {"\u3255", "\u3255"}, {"\u3256", "\u3256"}, {"\u3257", "\u3257"}, {"\u3258", "\u3258"}, {"\u3259", "\u3259"},
    {"\u325A", "\u325A"}, {"\u325B", "\u325B"}, {"\u325C", "\u325C"}, {"\u325D", "\u325D"}, {"\u325E", "\u325E"},
    {"\u325F", "\u325F"}, {"\u3260", "\u3260"}, {"\u3261", "\u3261"}, {"\u3262", "\u3262"}, {"\u3263", "\u3263"},
    {"\u3264", "\u3264"}, {"\u3265", "\u3265"}, {"\u3266", "\u3266"}, {"\u3267", "\u3267"}, {"\u3268", "\u3268"},
    {"\u3269", "\u3269"}, {"\u326A", "\u326A"}, {"\u326B", "\u326B"}, {"\u326C", "\u326C"}, {"\u326D", "\u326D"},
    {"\u326E", "\u326E"}, {"\u326F", "\u326F"}, {"\u3270", "\u3270"}, {"\u3271", "\u3271"}, {"\u3272", "\u3272"},
    {"\u3273", "\u3273"}, {"\u3274", "\u3274"}, {"\u3275", "\u3275"}, {"\u3276", "\u3276"}, {"\u3277", "\u3277"},
    {"\u3278", "\u3278"}, {"\u3279", "\u3279"}, {"\u327A", "\u327A"}, {"\u327B", "\u327B"}, {"\u327C", "\u327C"},
    {"\u327D", "\u327D"}, {"\u327E", "\u327E"}, {"\u3280", "\u3280"}, {"\u3281", "\u3281"}, {"\u3282", "\u3282"},
    {"\u3283", "\u3283"}, {"\u3284", "\u3284"}, {"\u3285", "\u3285"}, {"\u3286", "\u3286"}, {"\u3287", "\u3287"},
    {"\u3288", "\u3288"}, {"\u3289", "\u3289"}, {"\u328A", "\u328A"}, {"\u328B", "\u328B"}, {"\u328C", "\u328C"},
    {"\u328D", "\u328D"}, {"\u328E", "\u328E"}, {"\u328F", "\u328F"}, {"\u3290", "\u3290"}, {"\u3291", "\u3291"},
    {"\u3292", "\u3292"}, {"\u3293", "\u3293"}, {"\u3294", "\u3294"}, {"\u3295", "\u3295"}, {"\u3296", "\u3296"},
    {"\u3297", "\u3297"}, {"\u3298", "\u3298"}, {"\u3299", "\u3299"}, {"\u329A", "\u329A"}, {"\u329B", "\u329B"},
    {"\u329C", "\u329C"}, {"\u329D", "\u329D"}, {"\u329E", "\u329E"}, {"\u329F", "\u329F"}, {"\u32A0", "\u32A0"},
    {"\u32A1", "\u32A1"}, {"\u32A2", "\u32A2"}, {"\u32A3", "\u32A3"}, {"\u32A4", "\u32A4"}, {"\u32A5", "\u32A5"},
    {"\u32A6", "\u32A6"}, {"\u32A7", "\u32A7"}, {"\u32A8", "\u32A8"}, {"\u32A9", "\u32A9"}, {"\u32AA", "\u32AA"},
    {"\u32AB", "\u32AB"}, {"\u32AC", "\u32AC"}, {"\u32AD", "\u32AD"}, {"\u32AE", "\u32AE"}, {"\u32AF", "\u32AF"},
    {"\u32B0", "\u32B0"}, {"\u32B1", "\u32B1"}, {"\u32B2", "\u32B2"}, {"\u32B3", "\u32B3"}, {"\u32B4", "\u32B4"},
    {"\u32B5", "\u32B5"}, {"\u32B6", "\u32B6"}, {"\u32B7", "\u32B7"}, {"\u32B8", "\u32B8"}, {"\u32B9", "\u32B9"},
    {"\u32BA", "\u32BA"}, {"\u32BB", "\u32BB"}, {"\u32BC", "\u32BC"}, {"\u32BD", "\u32BD"}, {"\u32BE", "\u32BE"},
    {"\u32BF", "\u32BF"}, {"\u32C0", "\u32C0"}, {"\u32C1", "\u32C1"}, {"\u32C2", "\u32C2"}, {"\u32C3", "\u32C3"},
    {"\u32C4", "\u32C4"}, {"\u32C5", "\u32C5"}, {"\u32C6", "\u32C6"}, {"\u32C7", "\u32C7"}, {"\u32C8", "\u32C8"},
    {"\u32C9", "\u32C9"}, {"\u32CA", "\u32CA"}, {"\u32CB", "\u32CB"}, {"\u32CC", "\u32CC"}, {"\u32CD", "\u32CD"},
    {"\u32CE", "\u32CE"}, {"\u32CF", "\u32CF"}, {"\u32D0", "\u32D0"}, {"\u32D1", "\u32D1"}, {"\u32D2", "\u32D2"},
    {"\u32D3", "\u32D3"}, {"\u32D4", "\u32D4"}, {"\u32D5", "\u32D5"}, {"\u32D6", "\u32D6"}, {"\u32D7", "\u32D7"},
    {"\u32D8", "\u32D8"}, {"\u32D9", "\u32D9"}, {"\u32DA", "\u32DA"}, {"\u32DB", "\u32DB"}, {"\u32DC", "\u32DC"},
    {"\u32DD", "\u32DD"}, {"\u32DE", "\u32DE"}, {"\u32DF", "\u32DF"}, {"\u32E0", "\u32E0"}, {"\u32E1", "\u32E1"},
    {"\u32E2", "\u32E2"}, {"\u32E3", "\u32E3"}, {"\u32E4", "\u32E4"}, {"\u32E5", "\u32E5"}, {"\u32E6", "\u32E6"},
    {"\u32E7", "\u32E7"}, {"\u32E8", "\u32E8"}, {"\u32E9", "\u32E9"}, {"\u32EA", "\u32EA"}, {"\u32EB", "\u32EB"},
    {"\u32EC", "\u32EC"}, {"\u32ED", "\u32ED"}, {"\u32EE", "\u32EE"}, {"\u32EF", "\u32EF"}, {"\u32F0", "\u32F0"},
    {"\u32F1", "\u32F1"}, {"\u32F2", "\u32F2"}, {"\u32F3", "\u32F3"}, {"\u32F4", "\u32F4"}, {"\u32F5", "\u32F5"},
    {"\u32F6", "\u32F6"}, {"\u32F7", "\u32F7"}, {"\u32F8", "\u32F8"}, {"\u32F9", "\u32F9"}, {"\u32FA", "\u32FA"},
    {"\u32FB", "\u32FB"}, {"\u32FC", "\u32FC"}, {"\u32FD", "\u32FD"}, {"\u32FE", "\u32FE"}, {"\u32FF", "\u32FF"},
    {"\u3300", "\u3300"}, {"\u3301", "\u3301"}, {"\u3302", "\u3302"}, {"\u3303", "\u3303"}, {"\u3304", "\u3304"},
    {"\u3305", "\u3305"}, {"\u3306", "\u3306"}, {"\u3307", "\u3307"}, {"\u3308", "\u3308"}, {"\u3309", "\u3309"},
    {"\u330A", "\u330A"}, {"\u330B", "\u330B"}, {"\u330C", "\u330C"}, {"\u330D", "\u330D"}, {"\u330E", "\u330E"},
    {"\u330F", "\u330F"}, {"\u3310", "\u3310"}, {"\u3311", "\u3311"}, {"\u3312", "\u3312"}, {"\u3313", "\u3313"},
    {"\u3314", "\u3314"}, {"\u3315", "\u3315"}, {"\u3316", "\u3316"}, {"\u3317", "\u3317"}, {"\u3318", "\u3318"},
    {"\u3319", "\u3319"}, {"\u331A", "\u331A"}, {"\u331B", "\u331B"}, {"\u331C", "\u331C"}, {"\u331D", "\u331D"},
    {"\u331E", "\u331E"}, {"\u331F", "\u331F"}, {"\u3320", "\u3320"}, {"\u3321", "\u3321"}, {"\u3322", "\u3322"},
    {"\u3323", "\u3323"}, {"\u3324", "\u3324"}, {"\u3325", "\u3325"}, {"\u3326", "\u3326"}, {"\u3327", "\u3327"},
    {"\u3328", "\u3328"}, {"\u3329", "\u3329"}, {"\u332A", "\u332A"}, {"\u332B", "\u332B"}, {"\u332C", "\u332C"},
    {"\u332D", "\u332D"}, {"\u332E", "\u332E"}, {"\u332F", "\u332F"}, {"\u3330", "\u3330"}, {"\u3331", "\u3331"},
    {"\u3332", "\u3332"}, {"\u3333", "\u3333"}, {"\u3334", "\u3334"}, {"\u3335", "\u3335"}, {"\u3336", "\u3336"},
    {"\u3337", "\u3337"}, {"\u3338", "\u3338"}, {"\u3339", "\u3339"}, {"\u333A", "\u333A"}, {"\u333B", "\u333B"},
    {"\u333C", "\u333C"}, {"\u333D", "\u333D"}, {"\u333E", "\u333E"}, {"\u333F", "\u333F"}, {"\u3340", "\u3340"},
    {"\u3341", "\u3341"}, {"\u3342", "\u3342"}, {"\u3343", "\u3343"}, {"\u3344", "\u3344"}, {"\u3345", "\u3345"},
    {"\u3346", "\u3346"}, {"\u3347", "\u3347"}, {"\u3348", "\u3348"}, {"\u3349", "\u3349"}, {"\u334A", "\u334A"},
    {"\u334B", "\u334B"}, {"\u334C", "\u334C"}, {"\u334D", "\u334D"}, {"\u334E", "\u334E"}, {"\u334F", "\u334F"},
    {"\u3350", "\u3350"}, {"\u3351", "\u3351"}, {"\u3352", "\u3352"}, {"\u3353", "\u3353"}, {"\u3354", "\u3354"},
    {"\u3355", "\u3355"}, {"\u3356", "\u3356"}, {"\u3357", "\u3357"}, {"\u3358", "\u3358"}, {"\u3359", "\u3359"},
    {"\u335A", "\u335A"}, {"\u335B", "\u335B"}, {"\u335C", "\u335C"}, {"\u335D", "\u335D"}, {"\u335E", "\u335E"},
    {"\u335F", "\u335F"}, {"\u3360", "\u3360"}, {"\u3361", "\u3361"}, {"\u3362", "\u3362"}, {"\u3363", "\u3363"},
    {"\u3364", "\u3364"}, {"\u3365", "\u3365"}, {"\u3366", "\u3366"}, {"\u3367", "\u3367"}, {"\u3368", "\u3368"},
    {"\u3369", "\u3369"}, {"\u336A", "\u336A"}, {"\u336B", "\u336B"}, {"\u336C", "\u336C"}, {"\u336D", "\u336D"},
    {"\u336E", "\u336E"}, {"\u336F", "\u336F"}, {"\u3370", "\u3370"}, {"\u3371", "\u3371"}, {"\u3372", "\u3372"},
    {"\u3373", "\u3373"}, {"\u3374", "\u3374"}, {"\u3375", "\u3375"}, {"\u3376", "\u3376"}, {"\u3377", "\u3377"},
    {"\u3378", "\u3378"}, {"\u3379", "\u3379"}, {"\u337A", "\u337A"}, {"\u337B", "\u337B"}, {"\u337C", "\u337C"},
    {"\u337D", "\u337D"}, {"\u337E", "\u337E"}, {"\u337F", "\u337F"}, {"\u3380", "\u3380"}, {"\u3381", "\u3381"},
    {"\u3382", "\u3382"}, {"\u3383", "\u3383"}, {"\u3384", "\u3384"}, {"\u3385", "\u3385"}, {"\u3386", "\u3386"},
    {"\u3387", "\u3387"}, {"\u3388", "\u3388"}, {"\u3389", "\u3389"}, {"\u338A", "\u338A"}, {"\u338B", "\u338B"},
    {"\u338C", "\u338C"}, {"\u338D", "\u338D"}, {"\u338E", "\u338E"}, {"\u338F", "\u338F"}, {"\u3390", "\u3390"},
    {"\u3391", "\u3391"}, {"\u3392", "\u3392"}, {"\u3393", "\u3393"}, {"\u3394", "\u3394"}, {"\u3395", "\u3395"},
    {"\u3396", "\u3396"}, {"\u3397", "\u3397"}, {"\u3398", "\u3398"}, {"\u3399", "\u3399"}, {"\u339A", "\u339A"},
    {"\u339B", "\u339B"}, {"\u339C", "\u339C"}, {"\u339D", "\u339D"}, {"\u339E", "\u339E"}, {"\u339F", "\u339F"},
    {"\u33A0", "\u33A0"}, {"\u33A1", "\u33A1"}, {"\u33A2", "\u33A2"}, {"\u33A3", "\u33A3"}, {"\u33A4", "\u33A4"},
    {"\u33A5", "\u33A5"}, {"\u33A6", "\u33A6"}, {"\u33A7", "\u33A7"}, {"\u33A8", "\u33A8"}, {"\u33A9", "\u33A9"},
    {"\u33AA", "\u33AA"}, {"\u33AB", "\u33AB"}, {"\u33AC", "\u33AC"}, {"\u33AD", "\u33AD"}, {"\u33AE", "\u33AE"},
    {"\u33AF", "\u33AF"}, {"\u33B0", "\u33B0"}, {"\u33B1", "\u33B1"}, {"\u33B2", "\u33B2"}, {"\u33B3", "\u33B3"},
    {"\u33B4", "\u33B4"}, {"\u33B5", "\u33B5"}, {"\u33B6", "\u33B6"}, {"\u33B7", "\u33B7"}, {"\u33B8", "\u33B8"},
    {"\u33B9", "\u33B9"}, {"\u33BA", "\u33BA"}, {"\u33BB", "\u33BB"}, {"\u33BC", "\u33BC"}, {"\u33BD", "\u33BD"},
    {"\u33BE", "\u33BE"}, {"\u33BF", "\u33BF"}, {"\u33C0", "\u33C0"}, {"\u33C1", "\u33C1"}, {"\u33C2", "\u33C2"},
    {"\u33C3", "\u33C3"}, {"\u33C4", "\u33C4"}, {"\u33C5", "\u33C5"}, {"\u33C6", "\u33C6"}, {"\u33C7", "\u33C7"},
    {"\u33C8", "\u33C8"}, {"\u33C9", "\u33C9"}, {"\u33CA", "\u33CA"}, {"\u33CB", "\u33CB"}, {"\u33CC", "\u33CC"},
    {"\u33CD", "\u33CD"}, {"\u33CE", "\u33CE"}, {"\u33CF", "\u33CF"}, {"\u33D0", "\u33D0"}, {"\u33D1", "\u33D1"},
    {"\u33D2", "\u33D2"}, {"\u33D3", "\u33D3"}, {"\u33D4", "\u33D4"}, {"\u33D5", "\u33D5"}, {"\u33D6", "\u33D6"},
    {"\u33D7", "\u33D7"}, {"\u33D8", "\u33D8"}, {"\u33D9", "\u33D9"}, {"\u33DA", "\u33DA"}, {"\u33DB", "\u33DB"},
    {"\u33DC", "\u33DC"}, {"\u33DD", "\u33DD"}, {"\u33DE", "\u33DE"}, {"\u33DF", "\u33DF"}, {"\u33E0", "\u33E0"},
    {"\u33E1", "\u33E1"}, {"\u33E2", "\u33E2"}, {"\u33E3", "\u33E3"}, {"\u33E4", "\u33E4"}, {"\u33E5", "\u33E5"},
    {"\u33E6", "\u33E6"}, {"\u33E7", "\u33E7"}, {"\u33E8", "\u33E8"}, {"\u33E9", "\u33E9"}, {"\u33EA", "\u33EA"},
    {"\u33EB", "\u33EB"}, {"\u33EC", "\u33EC"}, {"\u33ED", "\u33ED"}, {"\u33EE", "\u33EE"}, {"\u33EF", "\u33EF"},
    {"\u33F0", "\u33F0"}, {"\u33F1", "\u33F1"}, {"\u33F2", "\u33F2"}, {"\u33F3", "\u33F3"}, {"\u33F4", "\u33F4"},
    {"\u33F5", "\u33F5"}, {"\u33F6", "\u33F6"}, {"\u33F7", "\u33F7"}, {"\u33F8", "\u33F8"}, {"\u33F9", "\u33F9"},
    {"\u33FA", "\u33FA"}, {"\u33FB", "\u33FB"}, {"\u33FC", "\u33FC"}, {"\u33FD", "\u33FD"}, {"\u33FE", "\u33FE"},
    {"\u33FF", "\u33FF"}, {"\uA69C", "\uA69C"}, {"\uA69D", "\uA69D"}, {"\uA770", "\uA770"}, {"\uA7F2", "\uA7F2"},
    {"\uA7F3", "\uA7F3"}, {"\uA7F4", "\uA7F4"}, {"\uA7F8", "\uA7F8"}, {"\uA7F9", "\uA7F9"}, {"\uAB5C", "\uAB5C"},
    {"\uAB5D", "\uAB5D"}, {"\uAB5E", "\uAB5E"}, {"\uAB5F", "\uAB5F"}, {"\uAB69", "\uAB69"}, {"\uAC00", "\uAC00"},
    {"\uAC01", "\uAC01"}, {"\uAC02", "\uAC02"}, {"\uAC03", "\uAC03"}, {"\uAC04", "\uAC04"}, {"\uAC05", "\uAC05"},
    {"\uAC06", "\uAC06"}, {"\uAC07", "\uAC07"}, {"\uAC08", "\uAC08"}, {"\uAC09", "\uAC09"}, {"\uAC0A", "\uAC0A"},
    {"\uAC0B", "\uAC0B"}, {"\uAC0C", "\uAC0C"}, {"\uAC0D", "\uAC0D"}, {"\uAC0E", "\uAC0E"}, {"\uAC0F", "\uAC0F"},
    {"\uAC10", "\uAC10"}, {"\uAC11", "\uAC11"}, {"\uAC12", "\uAC12"}, {"\uAC13", "\uAC13"}, {"\uAC14", "\uAC14"},
    {"\uAC15", "\uAC15"}, {"\uAC16", "\uAC16"}, {"\uAC17", "\uAC17"}, {"\uAC18", "\uAC18"}, {"\uAC19", "\uAC19"},
    {"\uAC1A", "\uAC1A"}, {"\uAC1B", "\uAC1B"}, {"\uAC1C", "\uAC1C"}, {"\uAC1D", "\uAC1D"}, {"\uAC1E", "\uAC1E"},
    {"\uAC1F", "\uAC1F"}, {"\uAC20", "\uAC20"}, {"\uAC21", "\uAC21"}, {"\uAC22", "\uAC22"}, {"\uAC23", "\uAC23"},
    {"\uAC24", "\uAC24"}, {"\uAC25", "\uAC25"}, {"\uAC26", "\uAC26"}, {"\uAC27", "\uAC27"}, {"\uAC28", "\uAC28"},
    {"\uAC29", "\uAC29"}, {"\uAC2A", "\uAC2A"}, {"\uAC2B", "\uAC2B"}, {"\uAC2C", "\uAC2C"}, {"\uAC2D", "\uAC2D"},
    {"\uAC2E", "\uAC2E"}, {"\uAC2F", "\uAC2F"}, {"\uAC30", "\uAC30"}, {"\uAC31", "\uAC31"}, {"\uAC32", "\uAC32"},
    {"\uAC33", "\uAC33"}, {"\uAC34", "\uAC34"}, {"\uAC35", "\uAC35"}, {"\uAC36", "\uAC36"}, {"\uAC37", "\uAC37"},
    {"\uAC38", "\uAC38"}, {"\uAC39", "\uAC39"}, {"\uAC3A", "\uAC3A"}, {"\uAC3B", "\uAC3B"}, {"\uAC3C", "\uAC3C"},
    {"\uAC3D", "\uAC3D"}, {"\uAC3E", "\uAC3E"}, {"\uAC3F", "\uAC3F"}, {"\uAC40", "\uAC40"}, {"\uAC41", "\uAC41"},
    {"\uAC42", "\uAC42"}, {"\uAC43", "\uAC43"}, {"\uAC44", "\uAC44"}, {"\uAC45", "\uAC45"}, {"\uAC46", "\uAC46"},
    {"\uAC47", "\uAC47"}, {"\uAC48", "\uAC48"}, {"\uAC49", "\uAC49"}, {"\uAC4A", "\uAC4A"}, {"\uAC4B", "\uAC4B"},
    {"\uAC4C", "\uAC4C"}, {"\uAC4D", "\uAC4D"}, {"\uAC4E", "\uAC4E"}, {"\uAC4F", "\uAC4F"}, {"\uAC50", "\uAC50"},
    {"\uAC51", "\uAC51"}, {"\uAC52", "\uAC52"}, {"\uAC53", "\uAC53"}, {"\uAC54", "\uAC54"}, {"\uAC55", "\uAC55"},
    {"\uAC56", "\uAC56"}, {"\uAC57", "\uAC57"}, {"\uAC58", "\uAC58"}, {"\uAC59", "\uAC59"}, {"\uAC5A", "\uAC5A"},
    {"\uAC5B", "\uAC5B"}, {"\uAC5C", "\uAC5C"}, {"\uAC5D", "\uAC5D"}, {"\uAC5E", "\uAC5E"}, {"\uAC5F", "\uAC5F"},
    {"\uAC60", "\uAC60"}, {"\uAC61", "\uAC61"}, {"\uAC62", "\uAC62"}, {"\uAC63", "\uAC63"}, {"\uAC64", "\uAC64"},
    {"\uAC65", "\uAC65"}, {"\uAC66", "\uAC66"}, {"\uAC67", "\uAC67"}, {"\uAC68", "\uAC68"}, {"\uAC69", "\uAC69"},
    {"\uAC6A", "\uAC6A"}, {"\uAC6B", "\uAC6B"}, {"\uAC6C", "\uAC6C"}, {"\uAC6D", "\uAC6D"}, {"\uAC6E", "\uAC6E"},
    {"\uAC6F", "\uAC6F"}, {"\uAC70", "\uAC70"}, {"\uAC71", "\uAC71"}, {"\uAC72", "\uAC72"}, {"\uAC73", "\uAC73"},
    {"\uAC74", "\uAC74"}, {"\uAC75", "\uAC75"}, {"\uAC76", "\uAC76"}, {"\uAC77", "\uAC77"}, {"\uAC78", "\uAC78"},
    {"\uAC79", "\uAC79"}, {"\uAC7A", "\uAC7A"}, {"\uAC7B", "\uAC7B"}, {"\uAC7C", "\uAC7C"}, {"\uAC7D", "\uAC7D"},
    {"\uAC7E", "\uAC7E"}, {"\uAC7F", "\uAC7F"}, {"\uAC80", "\uAC80"}, {"\uAC81", "\uAC81"}, {"\uAC82", "\uAC82"},
    {"\uAC83", "\uAC83"}, {"\uAC84", "\uAC84"}, {"\uAC85", "\uAC85"}, {"\uAC86", "\uAC86"}, {"\uAC87", "\uAC87"},
    {"\uAC88", "\uAC88"}, {"\uAC89", "\uAC89"}, {"\uAC8A", "\uAC8A"}, {"\uAC8B", "\uAC8B"}, {"\uAC8C", "\uAC8C"},
    {"\uAC8D", "\uAC8D"}, {"\uAC8E", "\uAC8E"}, {"\uAC8F", "\uAC8F"}, {"\uAC90", "\uAC90"}, {"\uAC91", "\uAC91"},
    {"\uAC92", "\uAC92"}, {"\uAC93", "\uAC93"}, {"\uAC94", "\uAC94"}, {"\uAC95", "\uAC95"}, {"\uAC96", "\uAC96"},
    {"\uAC97", "\uAC97"}, {"\uAC98", "\uAC98"}, {"\uAC99", "\uAC99"}, {"\uAC9A", "\uAC9A"}, {"\uAC9B", "\uAC9B"},
    {"\uAC9C", "\uAC9C"}, {"\uAC9D", "\uAC9D"}, {"\uAC9E", "\uAC9E"}, {"\uAC9F", "\uAC9F"}, {"\uACA0", "\uACA0"},
    {"\uACA1", "\uACA1"}, {"\uACA2", "\uACA2"}, {"\uACA3", "\uACA3"}, {"\uACA4", "\uACA4"}, {"\uACA5", "\uACA5"},
    {"\uACA6", "\uACA6"}, {"\uACA7", "\uACA7"}, {"\uACA8", "\uACA8"}, {"\uACA9", "\uACA9"}, {"\uACAA", "\uACAA"},
    {"\uACAB", "\uACAB"}, {"\uACAC", "\uACAC"}, {"\uACAD", "\uACAD"}, {"\uACAE", "\uACAE"}, {"\uACAF", "\uACAF"},
    {"\uACB0", "\uACB0"}, {"\uACB1", "\uACB1"}, {"\uACB2", "\uACB2"}, {"\uACB3", "\uACB3"}, {"\uACB4", "\uACB4"},
    {"\uACB5", "\uACB5"}, {"\uACB6", "\uACB6"}, {"\uACB7", "\uACB7"}, {"\uACB8", "\uACB8"}, {"\uACB9", "\uACB9"},
    {"\uACBA", "\uACBA"}, {"\uACBB", "\uACBB"}, {"\uACBC", "\uACBC"}, {"\uACBD", "\uACBD"}, {"\uACBE", "\uACBE"},
    {"\uACBF", "\uACBF"}, {"\uACC0", "\uACC0"}, {"\uACC1", "\uACC1"}, {"\uACC2", "\uACC2"}, {"\uACC3", "\uACC3"},
    {"\uACC4", "\uACC4"}, {"\uACC5", "\uACC5"}, {"\uACC6", "\uACC6"}, {"\uACC7", "\uACC7"}, {"\uACC8", "\uACC8"},
    {"\uACC9", "\uACC9"}, {"\uACCA", "\uACCA"}, {"\uACCB", "\uACCB"}, {"\uACCC", "\uACCC"}, {"\uACCD", "\uACCD"},
    {"\uACCE", "\uACCE"}, {"\uACCF", "\uACCF"}, {"\uACD0", "\uACD0"}, {"\uACD1", "\uACD1"}, {"\uACD2", "\uACD2"},
    {"\uACD3", "\uACD3"}, {"\uACD4", "\uACD4"}, {"\uACD5", "\uACD5"}, {"\uACD6", "\uACD6"}, {"\uACD7", "\uACD7"},
    {"\uACD8", "\uACD8"}, {"\uACD9", "\uACD9"}, {"\uACDA", "\uACDA"}, {"\uACDB", "\uACDB"}, {"\uACDC", "\uACDC"},
    {"\uACDD", "\uACDD"}, {"\uACDE", "\uACDE"}, {"\uACDF", "\uACDF"}, {"\uACE0", "\uACE0"}, {"\uACE1", "\uACE1"},
    {"\uACE2", "\uACE2"}, {"\uACE3", "\uACE3"}, {"\uACE4", "\uACE4"}, {"\uACE5", "\uACE5"}, {"\uACE6", "\uACE6"},
    {"\uACE7", "\uACE7"}, {"\uACE8", "\uACE8"}, {"\uACE9", "\uACE9"}, {"\uACEA", "\uACEA"}, {"\uACEB", "\uACEB"},
    {"\uACEC", "\uACEC"}, {"\uACED", "\uACED"}, {"\uACEE", "\uACEE"}, {"\uACEF", "\uACEF"}, {"\uACF0", "\uACF0"},
    {"\uACF1", "\uACF1"}, {"\uACF2", "\uACF2"}, {"\uACF3", "\uACF3"}, {"\uACF4", "\uACF4"}, {"\uACF5", "\uACF5"},
    {"\uACF6", "\uACF6"}, {"\uACF7", "\uACF7"}, {"\uACF8", "\uACF8"}, {"\uACF9", "\uACF9"}, {"\uACFA", "\uACFA"},
    {"\uACFB", "\uACFB"}, {"\uACFC", "\uACFC"}, {"\uACFD", "\uACFD"}, {"\uACFE", "\uACFE"}, {"\uACFF", "\uACFF"},
    {"\uAD00", "\uAD00"}, {"\uAD01", "\uAD01"}, {"\uAD02", "\uAD02"}, {"\uAD03", "\uAD03"}, {"\uAD04", "\uAD04"},
    {"\uAD05", "\uAD05"}, {"\uAD06", "\uAD06"}, {"\uAD07", "\uAD07"}, {"\uAD08", "\uAD08"}, {"\uAD09", "\uAD09"},
    {"\uAD0A", "\uAD0A"}, {"\uAD0B", "\uAD0B"}, {"\uAD0C", "\uAD0C"}, {"\uAD0D", "\uAD0D"}, {"\uAD0E", "\uAD0E"},
    {"\uAD0F", "\uAD0F"}, {"\uAD10", "\uAD10"}, {"\uAD11", "\uAD11"}, {"\uAD12", "\uAD12"}, {"\uAD13", "\uAD13"},
    {"\uAD14", "\uAD14"}, {"\uAD15", "\uAD15"}, {"\uAD16", "\uAD16"}, {"\uAD17", "\uAD17"}, {"\uAD18", "\uAD18"},
    {"\uAD19", "\uAD19"}, {"\uAD1A", "\uAD1A"}, {"\uAD1B", "\uAD1B"}, {"\uAD1C", "\uAD1C"}, {"\uAD1D", "\uAD1D"},
    {"\uAD1E", "\uAD1E"}, {"\uAD1F", "\uAD1F"}, {"\uAD20", "\uAD20"}, {"\uAD21", "\uAD21"}, {"\uAD22", "\uAD22"},
    {"\uAD23", "\uAD23"}, {"\uAD24", "\uAD24"}, {"\uAD25", "\uAD25"}, {"\uAD26", "\uAD26"}, {"\uAD27", "\uAD27"},
    {"\uAD28", "\uAD28"}, {"\uAD29", "\uAD29"}, {"\uAD2A", "\uAD2A"}, {"\uAD2B", "\uAD2B"}, {"\uAD2C", "\uAD2C"},
    {"\uAD2D", "\uAD2D"}, {"\uAD2E", "\uAD2E"}, {"\uAD2F", "\uAD2F"}, {"\uAD30", "\uAD30"}, {"\uAD31", "\uAD31"},
    {"\uAD32", "\uAD32"}, {"\uAD33", "\uAD33"}, {"\uAD34", "\uAD34"}, {"\uAD35", "\uAD35"}, {"\uAD36", "\uAD36"},
    {"\uAD37", "\uAD37"}, {"\uAD38", "\uAD38"}, {"\uAD39", "\uAD39"}, {"\uAD3A", "\uAD3A"}, {"\uAD3B", "\uAD3B"},
    {"\uAD3C", "\uAD3C"}, {"\uAD3D", "\uAD3D"}, {"\uAD3E", "\uAD3E"}, {"\uAD3F", "\uAD3F"}, {"\uAD40", "\uAD40"},
    {"\uAD41", "\uAD41"}, {"\uAD42", "\uAD42"}, {"\uAD43", "\uAD43"}, {"\uAD44", "\uAD44"}, {"\uAD45", "\uAD45"},
    {"\uAD46", "\uAD46"}, {"\uAD47", "\uAD47"}, {"\uAD48", "\uAD48"}, {"\uAD49", "\uAD49"}, {"\uAD4A", "\uAD4A"},
    {"\uAD4B", "\uAD4B"}, {"\uAD4C", "\uAD4C"}, {"\uAD4D", "\uAD4D"}, {"\uAD4E", "\uAD4E"}, {"\uAD4F", "\uAD4F"},
    {"\uAD50", "\uAD50"}, {"\uAD51", "\uAD51"}, {"\uAD52", "\uAD52"}, {"\uAD53", "\uAD53"}, {"\uAD54", "\uAD54"},
    {"\uAD55", "\uAD55"}, {"\uAD56", "\uAD56"}, {"\uAD57", "\uAD57"}, {"\uAD58", "\uAD58"}, {"\uAD59", "\uAD59"},
    {"\uAD5A", "\uAD5A"}, {"\uAD5B", "\uAD5B"}, {"\uAD5C", "\uAD5C"}, {"\uAD5D", "\uAD5D"}, {"\uAD5E", "\uAD5E"},
    {"\uAD5F", "\uAD5F"}, {"\uAD60", "\uAD60"}, {"\uAD61", "\uAD61"}, {"\uAD62", "\uAD62"}, {"\uAD63", "\uAD63"},
    {"\uAD64", "\uAD64"}, {"\uAD65", "\uAD65"}, {"\uAD66", "\uAD66"}, {"\uAD67", "\uAD67"}, {"\uAD68", "\uAD68"},
    {"\uAD69", "\uAD69"}, {"\uAD6A", "\uAD6A"}, {"\uAD6B", "\uAD6B"}, {"\uAD6C", "\uAD6C"}, {"\uAD6D", "\uAD6D"},
    {"\uAD6E", "\uAD6E"}, {"\uAD6F", "\uAD6F"}, {"\uAD70", "\uAD70"}, {"\uAD71", "\uAD71"}, {"\uAD72", "\uAD72"},
    {"\uAD73", "\uAD73"}, {"\uAD74", "\uAD74"}, {"\uAD75", "\uAD75"}, {"\uAD76", "\uAD76"}, {"\uAD77", "\uAD77"},
    {"\uAD78", "\uAD78"}, {"\uAD79", "\uAD79"}, {"\uAD7A", "\uAD7A"}, {"\uAD7B", "\uAD7B"}, {"\uAD7C", "\uAD7C"},
    {"\uAD7D", "\uAD7D"}, {"\uAD7E", "\uAD7E"}, {"\uAD7F", "\uAD7F"}, {"\uAD80", "\uAD80"}, {"\uAD81", "\uAD81"},
    {"\uAD82", "\uAD82"}, {"\uAD83", "\uAD83"}, {"\uAD84", "\uAD84"}, {"\uAD85", "\uAD85"}, {"\uAD86", "\uAD86"},
    {"\uAD87", "\uAD87"}, {"\uAD88", "\uAD88"}, {"\uAD89", "\uAD89"}, {"\uAD8A", "\uAD8A"}, {"\uAD8B", "\uAD8B"},
    {"\uAD8C", "\uAD8C"}, {"\uAD8D", "\uAD8D"}, {"\uAD8E", "\uAD8E"}, {"\uAD8F", "\uAD8F"}, {"\uAD90", "\uAD90"},
    {"\uAD91", "\uAD91"}, {"\uAD92", "\uAD92"}, {"\uAD93", "\uAD93"}, {"\uAD94", "\uAD94"}, {"\uAD95", "\uAD95"},
    {"\uAD96", "\uAD96"}, {"\uAD97", "\uAD97"}, {"\uAD98", "\uAD98"}, {"\uAD99", "\uAD99"}, {"\uAD9A", "\uAD9A"},
    {"\uAD9B", "\uAD9B"}, {"\uAD9C", "\uAD9C"}, {"\uAD9D", "\uAD9D"}, {"\uAD9E", "\uAD9E"}, {"\uAD9F", "\uAD9F"},
    {"\uADA0", "\uADA0"}, {"\uADA1", "\uADA1"}, {"\uADA2", "\uADA2"}, {"\uADA3", "\uADA3"}, {"\uADA4", "\uADA4"},
    {"\uADA5", "\uADA5"}, {"\uADA6", "\uADA6"}, {"\uADA7", "\uADA7"}, {"\uADA8", "\uADA8"}, {"\uADA9", "\uADA9"},
    {"\uADAA", "\uADAA"}, {"\uADAB", "\uADAB"}, {"\uADAC", "\uADAC"}, {"\uADAD", "\uADAD"}, {"\uADAE", "\uADAE"},
    {"\uADAF", "\uADAF"}, {"\uADB0", "\uADB0"}, {"\uADB1", "\uADB1"}, {"\uADB2", "\uADB2"}, {"\uADB3", "\uADB3"},
    {"\uADB4", "\uADB4"}, {"\uADB5", "\uADB5"}, {"\uADB6", "\uADB6"}, {"\uADB7", "\uADB7"}, {"\uADB8", "\uADB8"},
    {"\uADB9", "\uADB9"}, {"\uADBA", "\uADBA"}, {"\uADBB", "\uADBB"}, {"\uADBC", "\uADBC"}, {"\uADBD", "\uADBD"},
    {"\uADBE", "\uADBE"}, {"\uADBF", "\uADBF"}, {"\uADC0", "\uADC0"}, {"\uADC1", "\uADC1"}, {"\uADC2", "\uADC2"},
    {"\uADC3", "\uADC3"}, {"\uADC4", "\uADC4"}, {"\uADC5", "\uADC5"}, {"\uADC6", "\uADC6"}, {"\uADC7", "\uADC7"},
    {"\uADC8", "\uADC8"}, {"\uADC9", "\uADC9"}, {"\uADCA", "\uADCA"}, {"\uADCB", "\uADCB"}, {"\uADCC", "\uADCC"},
    {"\uADCD", "\uADCD"}, {"\uADCE", "\uADCE"}, {"\uADCF", "\uADCF"}, {"\uADD0", "\uADD0"}, {"\uADD1", "\uADD1"},
    {"\uADD2", "\uADD2"}, {"\uADD3", "\uADD3"}, {"\uADD4", "\uADD4"}, {"\uADD5", "\uADD5"}, {"\uADD6", "\uADD6"},
    {"\uADD7", "\uADD7"}, {"\uADD8", "\uADD8"}, {"\uADD9", "\uADD9"}, {"\uADDA", "\uADDA"}, {"\uADDB", "\uADDB"},
    {"\uADDC", "\uADDC"}, {"\uADDD", "\uADDD"}, {"\uADDE", "\uADDE"}, {"\uADDF", "\uADDF"}, {"\uADE0", "\uADE0"},
    {"\uADE1", "\uADE1"}, {"\uADE2", "\uADE2"}, {"\uADE3", "\uADE3"}, {"\uADE4", "\uADE4"}, {"\uADE5", "\uADE5"},
    {"\uADE6", "\uADE6"}, {"\uADE7", "\uADE7"}, {"\uADE8", "\uADE8"}, {"\uADE9", "\uADE9"}, {"\uADEA", "\uADEA"},
    {"\uADEB", "\uADEB"}, {"\uADEC", "\uADEC"}, {"\uADED", "\uADED"}, {"\uADEE", "\uADEE"}, {"\uADEF", "\uADEF"},
    {"\uADF0", "\uADF0"}, {"\uADF1", "\uADF1"}, {"\uADF2", "\uADF2"}, {"\uADF3", "\uADF3"}, {"\uADF4", "\uADF4"},
    {"\uADF5", "\uADF5"}, {"\uADF6", "\uADF6"}, {"\uADF7", "\uADF7"}, {"\uADF8", "\uADF8"}, {"\uADF9", "\uADF9"},
    {"\uADFA", "\uADFA"}, {"\uADFB", "\uADFB"}, {"\uADFC", "\uADFC"}, {"\uADFD", "\uADFD"}, {"\uADFE", "\uADFE"},
    {"\uADFF", "\uADFF"}, {"\uAE00", "\uAE00"}, {"\uAE01", "\uAE01"}, {"\uAE02", "\uAE02"}, {"\uAE03", "\uAE03"},
    {"\uAE04", "\uAE04"}, {"\uAE05", "\uAE05"}, {"\uAE06", "\uAE06"}, {"\uAE07", "\uAE07"}, {"\uAE08", "\uAE08"},
    {"\uAE09", "\uAE09"}, {"\uAE0A", "\uAE0A"}, {"\uAE0B", "\uAE0B"}, {"\uAE0C", "\uAE0C"}, {"\uAE0D", "\uAE0D"},
    {"\uAE0E", "\uAE0E"}, {"\uAE0F", "\uAE0F"}, {"\uAE10", "\uAE10"}, {"\uAE11", "\uAE11"}, {"\uAE12", "\uAE12"},
    {"\uAE13", "\uAE13"}, {"\uAE14", "\uAE14"}, {"\uAE15", "\uAE15"}, {"\uAE16", "\uAE16"}, {"\uAE17", "\uAE17"},
    {"\uAE18", "\uAE18"}, {"\uAE19", "\uAE19"}, {"\uAE1A", "\uAE1A"}, {"\uAE1B", "\uAE1B"}, {"\uAE1C", "\uAE1C"},
    {"\uAE1D", "\uAE1D"}, {"\uAE1E", "\uAE1E"}, {"\uAE1F", "\uAE1F"}, {"\uAE20", "\uAE20"}, {"\uAE21", "\uAE21"},
    {"\uAE22", "\uAE22"}, {"\uAE23", "\uAE23"}, {"\uAE24", "\uAE24"}, {"\uAE25", "\uAE25"}, {"\uAE26", "\uAE26"},
    {"\uAE27", "\uAE27"}, {"\uAE28", "\uAE28"}, {"\uAE29", "\uAE29"}, {"\uAE2A", "\uAE2A"}, {"\uAE2B", "\uAE2B"},
    {"\uAE2C", "\uAE2C"}, {"\uAE2D", "\uAE2D"}, {"\uAE2E", "\uAE2E"}, {"\uAE2F", "\uAE2F"}, {"\uAE30", "\uAE30"},
    {"\uAE31", "\uAE31"}, {"\uAE32", "\uAE32"}, {"\uAE33", "\uAE33"}, {"\uAE34", "\uAE34"}, {"\uAE35", "\uAE35"},
    {"\uAE36", "\uAE36"}, {"\uAE37", "\uAE37"}, {"\uAE38", "\uAE38"}, {"\uAE39", "\uAE39"}, {"\uAE3A", "\uAE3A"},
    {"\uAE3B", "\uAE3B"}, {"\uAE3C", "\uAE3C"}, {"\uAE3D", "\uAE3D"}, {"\uAE3E", "\uAE3E"}, {"\uAE3F", "\uAE3F"},
    {"\uAE40", "\uAE40"}, {"\uAE41", "\uAE41"}, {"\uAE42", "\uAE42"}, {"\uAE43", "\uAE43"}, {"\uAE44", "\uAE44"},
    {"\uAE45", "\uAE45"}, {"\uAE46", "\uAE46"}, {"\uAE47", "\uAE47"}, {"\uAE48", "\uAE48"}, {"\uAE49", "\uAE49"},
    {"\uAE4A", "\uAE4A"}, {"\uAE4B", "\uAE4B"}, {"\uAE4C", "\uAE4C"}, {"\uAE4D", "\uAE4D"}, {"\uAE4E", "\uAE4E"},
    {"\uAE4F", "\uAE4F"}, {"\uAE50", "\uAE50"}, {"\uAE51", "\uAE51"}, {"\uAE52", "\uAE52"}, {"\uAE53", "\uAE53"},
    {"\uAE54", "\uAE54"}, {"\uAE55", "\uAE55"}, {"\uAE56", "\uAE56"}, {"\uAE57", "\uAE57"}, {"\uAE58", "\uAE58"},
    {"\uAE59", "\uAE59"}, {"\uAE5A", "\uAE5A"}, {"\uAE5B", "\uAE5B"}, {"\uAE5C", "\uAE5C"}, {"\uAE5D", "\uAE5D"},
    {"\uAE5E", "\uAE5E"}, {"\uAE5F", "\uAE5F"}, {"\uAE60", "\uAE60"}, {"\uAE61", "\uAE61"}, {"\uAE62", "\uAE62"},
    {"\uAE63", "\uAE63"}, {"\uAE64", "\uAE64"}, {"\uAE65", "\uAE65"}, {"\uAE66", "\uAE66"}, {"\uAE67", "\uAE67"},
    {"\uAE68", "\uAE68"}, {"\uAE69", "\uAE69"}, {"\uAE6A", "\uAE6A"}, {"\uAE6B", "\uAE6B"}, {"\uAE6C", "\uAE6C"},
    {"\uAE6D", "\uAE6D"}, {"\uAE6E", "\uAE6E"}, {"\uAE6F", "\uAE6F"}, {"\uAE70", "\uAE70"}, {"\uAE71", "\uAE71"},
    {"\uAE72", "\uAE72"}, {"\uAE73", "\uAE73"}, {"\uAE74", "\uAE74"}, {"\uAE75", "\uAE75"}, {"\uAE76", "\uAE76"},
    {"\uAE77", "\uAE77"}, {"\uAE78", "\uAE78"}, {"\uAE79", "\uAE79"}, {"\uAE7A", "\uAE7A"}, {"\uAE7B", "\uAE7B"},
    {"\uAE7C", "\uAE7C"}, {"\uAE7D", "\uAE7D"}, {"\uAE7E", "\uAE7E"}, {"\uAE7F", "\uAE7F"}, {"\uAE80", "\uAE80"},
    {"\uAE81", "\uAE81"}, {"\uAE82", "\uAE82"}, {"\uAE83", "\uAE83"}, {"\uAE84", "\uAE84"}, {"\uAE85", "\uAE85"},
    {"\uAE86", "\uAE86"}, {"\uAE87", "\uAE87"}, {"\uAE88", "\uAE88"}, {"\uAE89", "\uAE89"}, {"\uAE8A", "\uAE8A"},
    {"\uAE8B", "\uAE8B"}, {"\uAE8C", "\uAE8C"}, {"\uAE8D", "\uAE8D"}, {"\uAE8E", "\uAE8E"}, {"\uAE8F", "\uAE8F"},
    {"\uAE90", "\uAE90"}, {"\uAE91", "\uAE91"}, {"\uAE92", "\uAE92"}, {"\uAE93", "\uAE93"}, {"\uAE94", "\uAE94"},
    {"\uAE95", "\uAE95"}, {"\uAE96", "\uAE96"}, {"\uAE97", "\uAE97"}, {"\uAE98", "\uAE98"}, {"\uAE99", "\uAE99"},
    {"\uAE9A", "\uAE9A"}, {"\uAE9B", "\uAE9B"}, {"\uAE9C", "\uAE9C"}, {"\uAE9D", "\uAE9D"}, {"\uAE9E", "\uAE9E"},
    {"\uAE9F", "\uAE9F"}, {"\uAEA0", "\uAEA0"}, {"\uAEA1", "\uAEA1"}, {"\uAEA2", "\uAEA2"}, {"\uAEA3", "\uAEA3"},
    {"\uAEA4", "\uAEA4"}, {"\uAEA5", "\uAEA5"}, {"\uAEA6", "\uAEA6"}, {"\uAEA7", "\uAEA7"}, {"\uAEA8", "\uAEA8"},
    {"\uAEA9", "\uAEA9"}, {"\uAEAA", "\uAEAA"}, {"\uAEAB", "\uAEAB"}, {"\uAEAC", "\uAEAC"}, {"\uAEAD", "\uAEAD"},
    {"\uAEAE", "\uAEAE"}, {"\uAEAF", "\uAEAF"}, {"\uAEB0", "\uAEB0"}, {"\uAEB1", "\uAEB1"}, {"\uAEB2", "\uAEB2"},
    {"\uAEB3", "\uAEB3"}, {"\uAEB4", "\uAEB4"}, {"\uAEB5", "\uAEB5"}, {"\uAEB6", "\uAEB6"}, {"\uAEB7", "\uAEB7"},
    {"\uAEB8", "\uAEB8"}, {"\uAEB9", "\uAEB9"}, {"\uAEBA", "\uAEBA"}, {"\uAEBB", "\uAEBB"}, {"\uAEBC", "\uAEBC"},
    {"\uAEBD", "\uAEBD"}, {"\uAEBE", "\uAEBE"}, {"\uAEBF", "\uAEBF"}, {"\uAEC0", "\uAEC0"}, {"\uAEC1", "\uAEC1"},
    {"\uAEC2", "\uAEC2"}, {"\uAEC3", "\uAEC3"}, {"\uAEC4", "\uAEC4"}, {"\uAEC5", "\uAEC5"}, {"\uAEC6", "\uAEC6"},
    {"\uAEC7", "\uAEC7"}, {"\uAEC8", "\uAEC8"}, {"\uAEC9", "\uAEC9"}, {"\uAECA", "\uAECA"}, {"\uAECB", "\uAECB"},
    {"\uAECC", "\uAECC"}, {"\uAECD", "\uAECD"}, {"\uAECE", "\uAECE"}, {"\uAECF", "\uAECF"}, {"\uAED0", "\uAED0"},
    {"\uAED1", "\uAED1"}, {"\uAED2", "\uAED2"}, {"\uAED3", "\uAED3"}, {"\uAED4", "\uAED4"}, {"\uAED5", "\uAED5"},
    {"\uAED6", "\uAED6"}, {"\uAED7", "\uAED7"}, {"\uAED8", "\uAED8"}, {"\uAED9", "\uAED9"}, {"\uAEDA", "\uAEDA"},
    {"\uAEDB", "\uAEDB"}, {"\uAEDC", "\uAEDC"}, {"\uAEDD", "\uAEDD"}, {"\uAEDE", "\uAEDE"}, {"\uAEDF", "\uAEDF"},
    {"\uAEE0", "\uAEE0"}, {"\uAEE1", "\uAEE1"}, {"\uAEE2", "\uAEE2"}, {"\uAEE3", "\uAEE3"}, {"\uAEE4", "\uAEE4"},
    {"\uAEE5", "\uAEE5"}, {"\uAEE6", "\uAEE6"}, {"\uAEE7", "\uAEE7"}, {"\uAEE8", "\uAEE8"}, {"\uAEE9", "\uAEE9"},
    {"\uAEEA", "\uAEEA"}, {"\uAEEB", "\uAEEB"}, {"\uAEEC", "\uAEEC"}, {"\uAEED", "\uAEED"}, {"\uAEEE", "\uAEEE"},
    {"\uAEEF", "\uAEEF"}, {"\uAEF0", "\uAEF0"}, {"\uAEF1", "\uAEF1"}, {"\uAEF2", "\uAEF2"}, {"\uAEF3", "\uAEF3"},
    {"\uAEF4", "\uAEF4"}, {"\uAEF5", "\uAEF5"}, {"\uAEF6", "\uAEF6"}, {"\uAEF7", "\uAEF7"}, {"\uAEF8", "\uAEF8"},
    {"\uAEF9", "\uAEF9"}, {"\uAEFA", "\uAEFA"}, {"\uAEFB", "\uAEFB"}, {"\uAEFC", "\uAEFC"}, {"\uAEFD", "\uAEFD"},
    {"\uAEFE", "\uAEFE"}, {"\uAEFF", "\uAEFF"}, {"\uAF00", "\uAF00"}, {"\uAF01", "\uAF01"}, {"\uAF02", "\uAF02"},
    {"\uAF03", "\uAF03"}, {"\uAF04", "\uAF04"}, {"\uAF05", "\uAF05"}, {"\uAF06", "\uAF06"}, {"\uAF07", "\uAF07"},
    {"\uAF08", "\uAF08"}, {"\uAF09", "\uAF09"}, {"\uAF0A", "\uAF0A"}, {"\uAF0B", "\uAF0B"}, {"\uAF0C", "\uAF0C"},
    {"\uAF0D", "\uAF0D"}, {"\uAF0E", "\uAF0E"}, {"\uAF0F", "\uAF0F"}, {"\uAF10", "\uAF10"}, {"\uAF11", "\uAF11"},
    {"\uAF12", "\uAF12"}, {"\uAF13", "\uAF13"}, {"\uAF14", "\uAF14"}, {"\uAF15", "\uAF15"}, {"\uAF16", "\uAF16"},
    {"\uAF17", "\uAF17"}, {"\uAF18", "\uAF18"}, {"\uAF19", "\uAF19"}, {"\uAF1A", "\uAF1A"}, {"\uAF1B", "\uAF1B"},
    {"\uAF1C", "\uAF1C"}, {"\uAF1D", "\uAF1D"}, {"\uAF1E", "\uAF1E"}, {"\uAF1F", "\uAF1F"}, {"\uAF20", "\uAF20"},
    {"\uAF21", "\uAF21"}, {"\uAF22", "\uAF22"}, {"\uAF23", "\uAF23"}, {"\uAF24", "\uAF24"}, {"\uAF25", "\uAF25"},
    {"\uAF26", "\uAF26"}, {"\uAF27", "\uAF27"}, {"\uAF28", "\uAF28"}, {"\uAF29", "\uAF29"}, {"\uAF2A", "\uAF2A"},
    {"\uAF2B", "\uAF2B"}, {"\uAF2C", "\uAF2C"}, {"\uAF2D", "\uAF2D"}, {"\uAF2E", "\uAF2E"}, {"\uAF2F", "\uAF2F"},
    {"\uAF30", "\uAF30"}, {"\uAF31", "\uAF31"}, {"\uAF32", "\uAF32"}, {"\uAF33", "\uAF33"}, {"\uAF34", "\uAF34"},
    {"\uAF35", "\uAF35"}, {"\uAF36", "\uAF36"}, {"\uAF37", "\uAF37"}, {"\uAF38", "\uAF38"}, {"\uAF39", "\uAF39"},
    {"\uAF3A", "\uAF3A"}, {"\uAF3B", "\uAF3B"}, {"\uAF3C", "\uAF3C"}, {"\uAF3D", "\uAF3D"}, {"\uAF3E", "\uAF3E"},
    {"\uAF3F", "\uAF3F"}, {"\uAF40", "\uAF40"}, {"\uAF41", "\uAF41"}, {"\uAF42", "\uAF42"}, {"\uAF43", "\uAF43"},
    {"\uAF44", "\uAF44"}, {"\uAF45", "\uAF45"}, {"\uAF46", "\uAF46"}, {"\uAF47", "\uAF47"}, {"\uAF48", "\uAF48"},
    {"\uAF49", "\uAF49"}, {"\uAF4A", "\uAF4A"}, {"\uAF4B", "\uAF4B"}, {"\uAF4C", "\uAF4C"}, {"\uAF4D", "\uAF4D"},
    {"\uAF4E", "\uAF4E"}, {"\uAF4F", "\uAF4F"}, {"\uAF50", "\uAF50"}, {"\uAF51", "\uAF51"}, {"\uAF52", "\uAF52"},
    {"\uAF53", "\uAF53"}, {"\uAF54", "\uAF54"}, {"\uAF55", "\uAF55"}, {"\uAF56", "\uAF56"}, {"\uAF57", "\uAF57"},
    {"\uAF58", "\uAF58"}, {"\uAF59", "\uAF59"}, {"\uAF5A", "\uAF5A"}, {"\uAF5B", "\uAF5B"}, {"\uAF5C", "\uAF5C"},
    {"\uAF5D", "\uAF5D"}, {"\uAF5E", "\uAF5E"}, {"\uAF5F", "\uAF5F"}, {"\uAF60", "\uAF60"}, {"\uAF61", "\uAF61"},
    {"\uAF62", "\uAF62"}, {"\uAF63", "\uAF63"}, {"\uAF64", "\uAF64"}, {"\uAF65", "\uAF65"}, {"\uAF66", "\uAF66"},
    {"\uAF67", "\uAF67"}, {"\uAF68", "\uAF68"}, {"\uAF69", "\uAF69"}, {"\uAF6A", "\uAF6A"}, {"\uAF6B", "\uAF6B"},
    {"\uAF6C", "\uAF6C"}, {"\uAF6D", "\uAF6D"}, {"\uAF6E", "\uAF6E"}, {"\uAF6F", "\uAF6F"}, {"\uAF70", "\uAF70"},
    {"\uAF71", "\uAF71"}, {"\uAF72", "\uAF72"}, {"\uAF73", "\uAF73"}, {"\uAF74", "\uAF74"}, {"\uAF75", "\uAF75"},
    {"\uAF76", "\uAF76"}, {"\uAF77", "\uAF77"}, {"\uAF78", "\uAF78"}, {"\uAF79", "\uAF79"}, {"\uAF7A", "\uAF7A"},
    {"\uAF7B", "\uAF7B"}, {"\uAF7C", "\uAF7C"}, {"\uAF7D", "\uAF7D"}, {"\uAF7E", "\uAF7E"}, {"\uAF7F", "\uAF7F"},
    {"\uAF80", "\uAF80"}, {"\uAF81", "\uAF81"}, {"\uAF82", "\uAF82"}, {"\uAF83", "\uAF83"}, {"\uAF84", "\uAF84"},
    {"\uAF85", "\uAF85"}, {"\uAF86", "\uAF86"}, {"\uAF87", "\uAF87"}, {"\uAF88", "\uAF88"}, {"\uAF89", "\uAF89"},
    {"\uAF8A", "\uAF8A"}, {"\uAF8B", "\uAF8B"}, {"\uAF8C", "\uAF8C"}, {"\uAF8D", "\uAF8D"}, {"\uAF8E", "\uAF8E"},
    {"\uAF8F", "\uAF8F"}, {"\uAF90", "\uAF90"}, {"\uAF91", "\uAF91"}, {"\uAF92", "\uAF92"}, {"\uAF93", "\uAF93"},
    {"\uAF94", "\uAF94"}, {"\uAF95", "\uAF95"}, {"\uAF96", "\uAF96"}, {"\uAF97", "\uAF97"}, {"\uAF98", "\uAF98"},
    {"\uAF99", "\uAF99"}, {"\uAF9A", "\uAF9A"}, {"\uAF9B", "\uAF9B"}, {"\uAF9C", "\uAF9C"}, {"\uAF9D", "\uAF9D"},
    {"\uAF9E", "\uAF9E"}, {"\uAF9F", "\uAF9F"}, {"\uAFA0", "\uAFA0"}, {"\uAFA1", "\uAFA1"}, {"\uAFA2", "\uAFA2"},
    {"\uAFA3", "\uAFA3"}, {"\uAFA4", "\uAFA4"}, {"\uAFA5", "\uAFA5"}, {"\uAFA6", "\uAFA6"}, {"\uAFA7", "\uAFA7"},
    {"\uAFA8", "\uAFA8"}, {"\uAFA9", "\uAFA9"}, {"\uAFAA", "\uAFAA"}, {"\uAFAB", "\uAFAB"}, {"\uAFAC", "\uAFAC"},
    {"\uAFAD", "\uAFAD"}, {"\uAFAE", "\uAFAE"}, {"\uAFAF", "\uAFAF"}, {"\uAFB0", "\uAFB0"}, {"\uAFB1", "\uAFB1"},
    {"\uAFB2", "\uAFB2"}, {"\uAFB3", "\uAFB3"}, {"\uAFB4", "\uAFB4"}, {"\uAFB5", "\uAFB5"}, {"\uAFB6", "\uAFB6"},
    {"\uAFB7", "\uAFB7"}, {"\uAFB8", "\uAFB8"}, {"\uAFB9", "\uAFB9"}, {"\uAFBA", "\uAFBA"}, {"\uAFBB", "\uAFBB"},
    {"\uAFBC", "\uAFBC"}, {"\uAFBD", "\uAFBD"}, {"\uAFBE", "\uAFBE"}, {"\uAFBF", "\uAFBF"}, {"\uAFC0", "\uAFC0"},
    {"\uAFC1", "\uAFC1"}, {"\uAFC2", "\uAFC2"}, {"\uAFC3", "\uAFC3"}, {"\uAFC4", "\uAFC4"}, {"\uAFC5", "\uAFC5"},
    {"\uAFC6", "\uAFC6"}, {"\uAFC7", "\uAFC7"}, {"\uAFC8", "\uAFC8"}, {"\uAFC9", "\uAFC9"}, {"\uAFCA", "\uAFCA"},
    {"\uAFCB", "\uAFCB"}, {"\uAFCC", "\uAFCC"}, {"\uAFCD", "\uAFCD"}, {"\uAFCE", "\uAFCE"}, {"\uAFCF", "\uAFCF"},
    {"\uAFD0", "\uAFD0"}, {"\uAFD1", "\uAFD1"}, {"\uAFD2", "\uAFD2"}, {"\uAFD3", "\uAFD3"}, {"\uAFD4", "\uAFD4"},
    {"\uAFD5", "\uAFD5"}, {"\uAFD6", "\uAFD6"}, {"\uAFD7", "\uAFD7"}, {"\uAFD8", "\uAFD8"}, {"\uAFD9", "\uAFD9"},
    {"\uAFDA", "\uAFDA"}, {"\uAFDB", "\uAFDB"}, {"\uAFDC", "\uAFDC"}, {"\uAFDD", "\uAFDD"}, {"\uAFDE", "\uAFDE"},
    {"\uAFDF", "\uAFDF"}, {"\uAFE0", "\uAFE0"}, {"\uAFE1", "\uAFE1"}, {"\uAFE2", "\uAFE2"}, {"\uAFE3", "\uAFE3"},
    {"\uAFE4", "\uAFE4"}, {"\uAFE5", "\uAFE5"}, {"\uAFE6", "\uAFE6"}, {"\uAFE7", "\uAFE7"}, {"\uAFE8", "\uAFE8"},
    {"\uAFE9", "\uAFE9"}, {"\uAFEA", "\uAFEA"}, {"\uAFEB", "\uAFEB"}, {"\uAFEC", "\uAFEC"}, {"\uAFED", "\uAFED"},
    {"\uAFEE", "\uAFEE"}, {"\uAFEF", "\uAFEF"}, {"\uAFF0", "\uAFF0"}, {"\uAFF1", "\uAFF1"}, {"\uAFF2", "\uAFF2"},
    {"\uAFF3", "\uAFF3"}, {"\uAFF4", "\uAFF4"}, {"\uAFF5", "\uAFF5"}, {"\uAFF6", "\uAFF6"}, {"\uAFF7", "\uAFF7"},
    {"\uAFF8", "\uAFF8"}, {"\uAFF9", "\uAFF9"}, {"\uAFFA", "\uAFFA"}, {"\uAFFB", "\uAFFB"}, {"\uAFFC", "\uAFFC"},
    {"\uAFFD", "\uAFFD"}, {"\uAFFE", "\uAFFE"}, {"\uAFFF", "\uAFFF"}, {"\uB000", "\uB000"}, {"\uB001", "\uB001"},
    {"\uB002", "\uB002"}, {"\uB003", "\uB003"}, {"\uB004", "\uB004"}, {"\uB005", "\uB005"}, {"\uB006", "\uB006"},
    {"\uB007", "\uB007"}, {"\uB008", "\uB008"}, {"\uB009", "\uB009"}, {"\uB00A", "\uB00A"}, {"\uB00B", "\uB00B"},
    {"\uB00C", "\uB00C"}, {"\uB00D", "\uB00D"}, {"\uB00E", "\uB00E"}, {"\uB00F", "\uB00F"}, {"\uB010", "\uB010"},
    {"\uB011", "\uB011"}, {"\uB012", "\uB012"}, {"\uB013", "\uB013"}, {"\uB014", "\uB014"}, {"\uB015", "\uB015"},
    {"\uB016", "\uB016"}, {"\uB017", "\uB017"}, {"\uB018", "\uB018"}, {"\uB019", "\uB019"}, {"\uB01A", "\uB01A"},
    {"\uB01B", "\uB01B"}, {"\uB01C", "\uB01C"}, {"\uB01D", "\uB01D"}, {"\uB01E", "\uB01E"}, {"\uB01F", "\uB01F"},
    {"\uB020", "\uB020"}, {"\uB021", "\uB021"}, {"\uB022", "\uB022"}, {"\uB023", "\uB023"}, {"\uB024", "\uB024"},
    {"\uB025", "\uB025"}, {"\uB026", "\uB026"}, {"\uB027", "\uB027"}, {"\uB028", "\uB028"}, {"\uB029", "\uB029"},
    {"\uB02A", "\uB02A"}, {"\uB02B", "\uB02B"}, {"\uB02C", "\uB02C"}, {"\uB02D", "\uB02D"}, {"\uB02E", "\uB02E"},
    {"\uB02F", "\uB02F"}, {"\uB030", "\uB030"}, {"\uB031", "\uB031"}, {"\uB032", "\uB032"}, {"\uB033", "\uB033"},
    {"\uB034", "\uB034"}, {"\uB035", "\uB035"}, {"\uB036", "\uB036"}, {"\uB037", "\uB037"}, {"\uB038", "\uB038"},
    {"\uB039", "\uB039"}, {"\uB03A", "\uB03A"}, {"\uB03B", "\uB03B"}, {"\uB03C", "\uB03C"}, {"\uB03D", "\uB03D"},
    {"\uB03E", "\uB03E"}, {"\uB03F", "\uB03F"}, {"\uB040", "\uB040"}, {"\uB041", "\uB041"}, {"\uB042", "\uB042"},
    {"\uB043", "\uB043"}, {"\uB044", "\uB044"}, {"\uB045", "\uB045"}, {"\uB046", "\uB046"}, {"\uB047", "\uB047"},
    {"\uB048", "\uB048"}, {"\uB049", "\uB049"}, {"\uB04A", "\uB04A"}, {"\uB04B", "\uB04B"}, {"\uB04C", "\uB04C"},
    {"\uB04D", "\uB04D"}, {"\uB04E", "\uB04E"}, {"\uB04F", "\uB04F"}, {"\uB050", "\uB050"}, {"\uB051", "\uB051"},
    {"\uB052", "\uB052"}, {"\uB053", "\uB053"}, {"\uB054", "\uB054"}, {"\uB055", "\uB055"}, {"\uB056", "\uB056"},
    {"\uB057", "\uB057"}, {"\uB058", "\uB058"}, {"\uB059", "\uB059"}, {"\uB05A", "\uB05A"}, {"\uB05B", "\uB05B"},
    {"\uB05C", "\uB05C"}, {"\uB05D", "\uB05D"}, {"\uB05E", "\uB05E"}, {"\uB05F", "\uB05F"}, {"\uB060", "\uB060"},
    {"\uB061", "\uB061"}, {"\uB062", "\uB062"}, {"\uB063", "\uB063"}, {"\uB064", "\uB064"}, {"\uB065", "\uB065"},
    {"\uB066", "\uB066"}, {"\uB067", "\uB067"}, {"\uB068", "\uB068"}, {"\uB069", "\uB069"}, {"\uB06A", "\uB06A"},
    {"\uB06B", "\uB06B"}, {"\uB06C", "\uB06C"}, {"\uB06D", "\uB06D"}, {"\uB06E", "\uB06E"}, {"\uB06F", "\uB06F"},
    {"\uB070", "\uB070"}, {"\uB071", "\uB071"}, {"\uB072", "\uB072"}, {"\uB073", "\uB073"}, {"\uB074", "\uB074"},
    {"\uB075", "\uB075"}, {"\uB076", "\uB076"}, {"\uB077", "\uB077"}, {"\uB078", "\uB078"}, {"\uB079", "\uB079"},
    {"\uB07A", "\uB07A"}, {"\uB07B", "\uB07B"}, {"\uB07C", "\uB07C"}, {"\uB07D", "\uB07D"}, {"\uB07E", "\uB07E"},
    {"\uB07F", "\uB07F"}, {"\uB080", "\uB080"}, {"\uB081", "\uB081"}, {"\uB082", "\uB082"}, {"\uB083", "\uB083"},
    {"\uB084", "\uB084"}, {"\uB085", "\uB085"}, {"\uB086", "\uB086"}, {"\uB087", "\uB087"}, {"\uB088", "\uB088"},
    {"\uB089", "\uB089"}, {"\uB08A", "\uB08A"}, {"\uB08B", "\uB08B"}, {"\uB08C", "\uB08C"}, {"\uB08D", "\uB08D"},
    {"\uB08E", "\uB08E"}, {"\uB08F", "\uB08F"}, {"\uB090", "\uB090"}, {"\uB091", "\uB091"}, {"\uB092", "\uB092"},
    {"\uB093", "\uB093"}, {"\uB094", "\uB094"}, {"\uB095", "\uB095"}, {"\uB096", "\uB096"}, {"\uB097", "\uB097"},
    {"\uB098", "\uB098"}, {"\uB099", "\uB099"}, {"\uB09A", "\uB09A"}, {"\uB09B", "\uB09B"}, {"\uB09C", "\uB09C"},
    {"\uB09D", "\uB09D"}, {"\uB09E", "\uB09E"}, {"\uB09F", "\uB09F"}, {"\uB0A0", "\uB0A0"}, {"\uB0A1", "\uB0A1"},
    {"\uB0A2", "\uB0A2"}, {"\uB0A3", "\uB0A3"}, {"\uB0A4", "\uB0A4"}, {"\uB0A5", "\uB0A5"}, {"\uB0A6", "\uB0A6"},
    {"\uB0A7", "\uB0A7"}, {"\uB0A8", "\uB0A8"}, {"\uB0A9", "\uB0A9"}, {"\uB0AA", "\uB0AA"}, {"\uB0AB", "\uB0AB"},
    {"\uB0AC", "\uB0AC"}, {"\uB0AD", "\uB0AD"}, {"\uB0AE", "\uB0AE"}, {"\uB0AF", "\uB0AF"}, {"\uB0B0", "\uB0B0"},
    {"\uB0B1", "\uB0B1"}, {"\uB0B2", "\uB0B2"}, {"\uB0B3", "\uB0B3"}, {"\uB0B4", "\uB0B4"}, {"\uB0B5", "\uB0B5"},
    {"\uB0B6", "\uB0B6"}, {"\uB0B7", "\uB0B7"}, {"\uB0B8", "\uB0B8"}, {"\uB0B9", "\uB0B9"}, {"\uB0BA", "\uB0BA"},
    {"\uB0BB", "\uB0BB"}, {"\uB0BC", "\uB0BC"}, {"\uB0BD", "\uB0BD"}, {"\uB0BE", "\uB0BE"}, {"\uB0BF", "\uB0BF"},
    {"\uB0C0", "\uB0C0"}, {"\uB0C1", "\uB0C1"}, {"\uB0C2", "\uB0C2"}, {"\uB0C3", "\uB0C3"}, {"\uB0C4", "\uB0C4"},
    {"\uB0C5", "\uB0C5"}, {"\uB0C6", "\uB0C6"}, {"\uB0C7", "\uB0C7"}, {"\uB0C8", "\uB0C8"}, {"\uB0C9", "\uB0C9"},
    {"\uB0CA", "\uB0CA"}, {"\uB0CB", "\uB0CB"}, {"\uB0CC", "\uB0CC"}, {"\uB0CD", "\uB0CD"}, {"\uB0CE", "\uB0CE"},
    {"\uB0CF", "\uB0CF"}, {"\uB0D0", "\uB0D0"}, {"\uB0D1", "\uB0D1"}, {"\uB0D2", "\uB0D2"}, {"\uB0D3", "\uB0D3"},
    {"\uB0D4", "\uB0D4"}, {"\uB0D5", "\uB0D5"}, {"\uB0D6", "\uB0D6"}, {"\uB0D7", "\uB0D7"}, {"\uB0D8", "\uB0D8"},
    {"\uB0D9", "\uB0D9"}, {"\uB0DA", "\uB0DA"}, {"\uB0DB", "\uB0DB"}, {"\uB0DC", "\uB0DC"}, {"\uB0DD", "\uB0DD"},
    {"\uB0DE", "\uB0DE"}, {"\uB0DF", "\uB0DF"}, {"\uB0E0", "\uB0E0"}, {"\uB0E1", "\uB0E1"}, {"\uB0E2", "\uB0E2"},
    {"\uB0E3", "\uB0E3"}, {"\uB0E4", "\uB0E4"}, {"\uB0E5", "\uB0E5"}, {"\uB0E6", "\uB0E6"}, {"\uB0E7", "\uB0E7"},
    {"\uB0E8", "\uB0E8"}, {"\uB0E9", "\uB0E9"}, {"\uB0EA", "\uB0EA"}, {"\uB0EB", "\uB0EB"}, {"\uB0EC", "\uB0EC"},
    {"\uB0ED", "\uB0ED"}, {"\uB0EE", "\uB0EE"}, {"\uB0EF", "\uB0EF"}, {"\uB0F0", "\uB0F0"}, {"\uB0F1", "\uB0F1"},
    {"\uB0F2", "\uB0F2"}, {"\uB0F3", "\uB0F3"}, {"\uB0F4", "\uB0F4"}, {"\uB0F5", "\uB0F5"}, {"\uB0F6", "\uB0F6"},
    {"\uB0F7", "\uB0F7"}, {"\uB0F8", "\uB0F8"}, {"\uB0F9", "\uB0F9"}, {"\uB0FA", "\uB0FA"}, {"\uB0FB", "\uB0FB"},
    {"\uB0FC", "\uB0FC"}, {"\uB0FD", "\uB0FD"}, {"\uB0FE", "\uB0FE"}, {"\uB0FF", "\uB0FF"}, {"\uB100", "\uB100"},
    {"\uB101", "\uB101"}, {"\uB102", "\uB102"}, {"\uB103", "\uB103"}, {"\uB104", "\uB104"}, {"\uB105", "\uB105"},
    {"\uB106", "\uB106"}, {"\uB107", "\uB107"}, {"\uB108", "\uB108"}, {"\uB109", "\uB109"}, {"\uB10A", "\uB10A"},
    {"\uB10B", "\uB10B"}, {"\uB10C", "\uB10C"}, {"\uB10D", "\uB10D"}, {"\uB10E", "\uB10E"}, {"\uB10F", "\uB10F"},
    {"\uB110", "\uB110"}, {"\uB111", "\uB111"}, {"\uB112", "\uB112"}, {"\uB113", "\uB113"}, {"\uB114", "\uB114"},
    {"\uB115", "\uB115"}, {"\uB116", "\uB116"}, {"\uB117", "\uB117"}, {"\uB118", "\uB118"}, {"\uB119", "\uB119"},
    {"\uB11A", "\uB11A"}, {"\uB11B", "\uB11B"}, {"\uB11C", "\uB11C"}, {"\uB11D", "\uB11D"}, {"\uB11E", "\uB11E"},
    {"\uB11F", "\uB11F"}, {"\uB120", "\uB120"}, {"\uB121", "\uB121"}, {"\uB122", "\uB122"}, {"\uB123", "\uB123"},
    {"\uB124", "\uB124"}, {"\uB125", "\uB125"}, {"\uB126", "\uB126"}, {"\uB127", "\uB127"}, {"\uB128", "\uB128"},
    {"\uB129", "\uB129"}, {"\uB12A", "\uB12A"}, {"\uB12B", "\uB12B"}, {"\uB12C", "\uB12C"}, {"\uB12D", "\uB12D"},
    {"\uB12E", "\uB12E"}, {"\uB12F", "\uB12F"}, {"\uB130", "\uB130"}, {"\uB131", "\uB131"}, {"\uB132", "\uB132"},
    {"\uB133", "\uB133"}, {"\uB134", "\uB134"}, {"\uB135", "\uB135"}, {"\uB136", "\uB136"}, {"\uB137", "\uB137"},
    {"\uB138", "\uB138"}, {"\uB139", "\uB139"}, {"\uB13A", "\uB13A"}, {"\uB13B", "\uB13B"}, {"\uB13C", "\uB13C"},
    {"\uB13D", "\uB13D"}, {"\uB13E", "\uB13E"}, {"\uB13F", "\uB13F"}, {"\uB140", "\uB140"}, {"\uB141", "\uB141"},
    {"\uB142", "\uB142"}, {"\uB143", "\uB143"}, {"\uB144", "\uB144"}, {"\uB145", "\uB145"}, {"\uB146", "\uB146"},
    {"\uB147", "\uB147"}, {"\uB148", "\uB148"}, {"\uB149", "\uB149"}, {"\uB14A", "\uB14A"}, {"\uB14B", "\uB14B"},
    {"\uB14C", "\uB14C"}, {"\uB14D", "\uB14D"}, {"\uB14E", "\uB14E"}, {"\uB14F", "\uB14F"}, {"\uB150", "\uB150"},
    {"\uB151", "\uB151"}, {"\uB152", "\uB152"}, {"\uB153", "\uB153"}, {"\uB154", "\uB154"}, {"\uB155", "\uB155"},
    {"\uB156", "\uB156"}, {"\uB157", "\uB157"}, {"\uB158", "\uB158"}, {"\uB159", "\uB159"}, {"\uB15A", "\uB15A"},
    {"\uB15B", "\uB15B"}, {"\uB15C", "\uB15C"}, {"\uB15D", "\uB15D"}, {"\uB15E", "\uB15E"}, {"\uB15F", "\uB15F"},
    {"\uB160", "\uB160"}, {"\uB161", "\uB161"}, {"\uB162", "\uB162"}, {"\uB163", "\uB163"}, {"\uB164", "\uB164"},
    {"\uB165", "\uB165"}, {"\uB166", "\uB166"}, {"\uB167", "\uB167"}, {"\uB168", "\uB168"}, {"\uB169", "\uB169"},
    {"\uB16A", "\uB16A"}, {"\uB16B", "\uB16B"}, {"\uB16C", "\uB16C"}, {"\uB16D", "\uB16D"}, {"\uB16E", "\uB16E"},
    {"\uB16F", "\uB16F"}, {"\uB170", "\uB170"}, {"\uB171", "\uB171"}, {"\uB172", "\uB172"}, {"\uB173", "\uB173"},
    {"\uB174", "\uB174"}, {"\uB175", "\uB175"}, {"\uB176", "\uB176"}, {"\uB177", "\uB177"}, {"\uB178", "\uB178"},
    {"\uB179", "\uB179"}, {"\uB17A", "\uB17A"}, {"\uB17B", "\uB17B"}, {"\uB17C", "\uB17C"}, {"\uB17D", "\uB17D"},
    {"\uB17E", "\uB17E"}, {"\uB17F", "\uB17F"}, {"\uB180", "\uB180"}, {"\uB181", "\uB181"}, {"\uB182", "\uB182"},
    {"\uB183", "\uB183"}, {"\uB184", "\uB184"}, {"\uB185", "\uB185"}, {"\uB186", "\uB186"}, {"\uB187", "\uB187"},
    {"\uB188", "\uB188"}, {"\uB189", "\uB189"}, {"\uB18A", "\uB18A"}, {"\uB18B", "\uB18B"}, {"\uB18C", "\uB18C"},
    {"\uB18D", "\uB18D"}, {"\uB18E", "\uB18E"}, {"\uB18F", "\uB18F"}, {"\uB190", "\uB190"}, {"\uB191", "\uB191"},
    {"\uB192", "\uB192"}, {"\uB193", "\uB193"}, {"\uB194", "\uB194"}, {"\uB195", "\uB195"}, {"\uB196", "\uB196"},
    {"\uB197", "\uB197"}, {"\uB198", "\uB198"}, {"\uB199", "\uB199"}, {"\uB19A", "\uB19A"}, {"\uB19B", "\uB19B"},
    {"\uB19C", "\uB19C"}, {"\uB19D", "\uB19D"}, {"\uB19E", "\uB19E"}, {"\uB19F", "\uB19F"}, {"\uB1A0", "\uB1A0"},
    {"\uB1A1", "\uB1A1"}, {"\uB1A2", "\uB1A2"}, {"\uB1A3", "\uB1A3"}, {"\uB1A4", "\uB1A4"}, {"\uB1A5", "\uB1A5"},
    {"\uB1A6", "\uB1A6"}, {"\uB1A7", "\uB1A7"}, {"\uB1A8", "\uB1A8"}, {"\uB1A9", "\uB1A9"}, {"\uB1AA", "\uB1AA"},
    {"\uB1AB", "\uB1AB"}, {"\uB1AC", "\uB1AC"}, {"\uB1AD", "\uB1AD"}, {"\uB1AE", "\uB1AE"}, {"\uB1AF", "\uB1AF"},
    {"\uB1B0", "\uB1B0"}, {"\uB1B1", "\uB1B1"}, {"\uB1B2", "\uB1B2"}, {"\uB1B3", "\uB1B3"}, {"\uB1B4", "\uB1B4"},
    {"\uB1B5", "\uB1B5"}, {"\uB1B6", "\uB1B6"}, {"\uB1B7", "\uB1B7"}, {"\uB1B8", "\uB1B8"}, {"\uB1B9", "\uB1B9"},
    {"\uB1BA", "\uB1BA"}, {"\uB1BB", "\uB1BB"}, {"\uB1BC", "\uB1BC"}, {"\uB1BD", "\uB1BD"}, {"\uB1BE", "\uB1BE"},
    {"\uB1BF", "\uB1BF"}, {"\uB1C0", "\uB1C0"}, {"\uB1C1", "\uB1C1"}, {"\uB1C2", "\uB1C2"}, {"\uB1C3", "\uB1C3"},
    {"\uB1C4", "\uB1C4"}, {"\uB1C5", "\uB1C5"}, {"\uB1C6", "\uB1C6"}, {"\uB1C7", "\uB1C7"}, {"\uB1C8", "\uB1C8"},
    {"\uB1C9", "\uB1C9"}, {"\uB1CA", "\uB1CA"}, {"\uB1CB", "\uB1CB"}, {"\uB1CC", "\uB1CC"}, {"\uB1CD", "\uB1CD"},
    {"\uB1CE", "\uB1CE"}, {"\uB1CF", "\uB1CF"}, {"\uB1D0", "\uB1D0"}, {"\uB1D1", "\uB1D1"}, {"\uB1D2", "\uB1D2"},
    {"\uB1D3", "\uB1D3"}, {"\uB1D4", "\uB1D4"}, {"\uB1D5", "\uB1D5"}, {"\uB1D6", "\uB1D6"}, {"\uB1D7", "\uB1D7"},
    {"\uB1D8", "\uB1D8"}, {"\uB1D9", "\uB1D9"}, {"\uB1DA", "\uB1DA"}, {"\uB1DB", "\uB1DB"}, {"\uB1DC", "\uB1DC"},
    {"\uB1DD", "\uB1DD"}, {"\uB1DE", "\uB1DE"}, {"\uB1DF", "\uB1DF"}, {"\uB1E0", "\uB1E0"}, {"\uB1E1", "\uB1E1"},
    {"\uB1E2", "\uB1E2"}, {"\uB1E3", "\uB1E3"}, {"\uB1E4", "\uB1E4"}, {"\uB1E5", "\uB1E5"}, {"\uB1E6", "\uB1E6"},
    {"\uB1E7", "\uB1E7"}, {"\uB1E8", "\uB1E8"}, {"\uB1E9", "\uB1E9"}, {"\uB1EA", "\uB1EA"}, {"\uB1EB", "\uB1EB"},
    {"\uB1EC", "\uB1EC"}, {"\uB1ED", "\uB1ED"}, {"\uB1EE", "\uB1EE"}, {"\uB1EF", "\uB1EF"}, {"\uB1F0", "\uB1F0"},
    {"\uB1F1", "\uB1F1"}, {"\uB1F2", "\uB1F2"}, {"\uB1F3", "\uB1F3"}, {"\uB1F4", "\uB1F4"}, {"\uB1F5", "\uB1F5"},
    {"\uB1F6", "\uB1F6"}, {"\uB1F7", "\uB1F7"}, {"\uB1F8", "\uB1F8"}, {"\uB1F9", "\uB1F9"}, {"\uB1FA", "\uB1FA"},
    {"\uB1FB", "\uB1FB"}, {"\uB1FC", "\uB1FC"}, {"\uB1FD", "\uB1FD"}, {"\uB1FE", "\uB1FE"}, {"\uB1FF", "\uB1FF"},
    {"\uB200", "\uB200"}, {"\uB201", "\uB201"}, {"\uB202", "\uB202"}, {"\uB203", "\uB203"}, {"\uB204", "\uB204"},
    {"\uB205", "\uB205"}, {"\uB206", "\uB206"}, {"\uB207", "\uB207"}, {"\uB208", "\uB208"}, {"\uB209", "\uB209"},
    {"\uB20A", "\uB20A"}, {"\uB20B", "\uB20B"}, {"\uB20C", "\uB20C"}, {"\uB20D", "\uB20D"}, {"\uB20E", "\uB20E"},
    {"\uB20F", "\uB20F"}, {"\uB210", "\uB210"}, {"\uB211", "\uB211"}, {"\uB212", "\uB212"}, {"\uB213", "\uB213"},
    {"\uB214", "\uB214"}, {"\uB215", "\uB215"}, {"\uB216", "\uB216"}, {"\uB217", "\uB217"}, {"\uB218", "\uB218"},
    {"\uB219", "\uB219"}, {"\uB21A", "\uB21A"}, {"\uB21B", "\uB21B"}, {"\uB21C", "\uB21C"}, {"\uB21D", "\uB21D"},
    {"\uB21E", "\uB21E"}, {"\uB21F", "\uB21F"}, {"\uB220", "\uB220"}, {"\uB221", "\uB221"}, {"\uB222", "\uB222"},
    {"\uB223", "\uB223"}, {"\uB224", "\uB224"}, {"\uB225", "\uB225"}, {"\uB226", "\uB226"}, {"\uB227", "\uB227"},
    {"\uB228", "\uB228"}, {"\uB229", "\uB229"}, {"\uB22A", "\uB22A"}, {"\uB22B", "\uB22B"}, {"\uB22C", "\uB22C"},
    {"\uB22D", "\uB22D"}, {"\uB22E", "\uB22E"}, {"\uB22F", "\uB22F"}, {"\uB230", "\uB230"}, {"\uB231", "\uB231"},
    {"\uB232", "\uB232"}, {"\uB233", "\uB233"}, {"\uB234", "\uB234"}, {"\uB235", "\uB235"}, {"\uB236", "\uB236"},
    {"\uB237", "\uB237"}, {"\uB238", "\uB238"}, {"\uB239", "\uB239"}, {"\uB23A", "\uB23A"}, {"\uB23B", "\uB23B"},
    {"\uB23C", "\uB23C"}, {"\uB23D", "\uB23D"}, {"\uB23E", "\uB23E"}, {"\uB23F", "\uB23F"}, {"\uB240", "\uB240"},
    {"\uB241", "\uB241"}, {"\uB242", "\uB242"}, {"\uB243", "\uB243"}, {"\uB244", "\uB244"}, {"\uB245", "\uB245"},
    {"\uB246", "\uB246"}, {"\uB247", "\uB247"}, {"\uB248", "\uB248"}, {"\uB249", "\uB249"}, {"\uB24A", "\uB24A"},
    {"\uB24B", "\uB24B"}, {"\uB24C", "\uB24C"}, {"\uB24D", "\uB24D"}, {"\uB24E", "\uB24E"}, {"\uB24F", "\uB24F"},
    {"\uB250", "\uB250"}, {"\uB251", "\uB251"}, {"\uB252", "\uB252"}, {"\uB253", "\uB253"}, {"\uB254", "\uB254"},
    {"\uB255", "\uB255"}, {"\uB256", "\uB256"}, {"\uB257", "\uB257"}, {"\uB258", "\uB258"}, {"\uB259", "\uB259"},
    {"\uB25A", "\uB25A"}, {"\uB25B", "\uB25B"}, {"\uB25C", "\uB25C"}, {"\uB25D", "\uB25D"}, {"\uB25E", "\uB25E"},
    {"\uB25F", "\uB25F"}, {"\uB260", "\uB260"}, {"\uB261", "\uB261"}, {"\uB262", "\uB262"}, {"\uB263", "\uB263"},
    {"\uB264", "\uB264"}, {"\uB265", "\uB265"}, {"\uB266", "\uB266"}, {"\uB267", "\uB267"}, {"\uB268", "\uB268"},
    {"\uB269", "\uB269"}, {"\uB26A", "\uB26A"}, {"\uB26B", "\uB26B"}, {"\uB26C", "\uB26C"}, {"\uB26D", "\uB26D"},
    {"\uB26E", "\uB26E"}, {"\uB26F", "\uB26F"}, {"\uB270", "\uB270"}, {"\uB271", "\uB271"}, {"\uB272", "\uB272"},
    {"\uB273", "\uB273"}, {"\uB274", "\uB274"}, {"\uB275", "\uB275"}, {"\uB276", "\uB276"}, {"\uB277", "\uB277"},
    {"\uB278", "\uB278"}, {"\uB279", "\uB279"}, {"\uB27A", "\uB27A"}, {"\uB27B", "\uB27B"}, {"\uB27C", "\uB27C"},
    {"\uB27D", "\uB27D"}, {"\uB27E", "\uB27E"}, {"\uB27F", "\uB27F"}, {"\uB280", "\uB280"}, {"\uB281", "\uB281"},
    {"\uB282", "\uB282"}, {"\uB283", "\uB283"}, {"\uB284", "\uB284"}, {"\uB285", "\uB285"}, {"\uB286", "\uB286"},
    {"\uB287", "\uB287"}, {"\uB288", "\uB288"}, {"\uB289", "\uB289"}, {"\uB28A", "\uB28A"}, {"\uB28B", "\uB28B"},
    {"\uB28C", "\uB28C"}, {"\uB28D", "\uB28D"}, {"\uB28E", "\uB28E"}, {"\uB28F", "\uB28F"}, {"\uB290", "\uB290"},
    {"\uB291", "\uB291"}, {"\uB292", "\uB292"}, {"\uB293", "\uB293"}, {"\uB294", "\uB294"}, {"\uB295", "\uB295"},
    {"\uB296", "\uB296"}, {"\uB297", "\uB297"}, {"\uB298", "\uB298"}, {"\uB299", "\uB299"}, {"\uB29A", "\uB29A"},
    {"\uB29B", "\uB29B"}, {"\uB29C", "\uB29C"}, {"\uB29D", "\uB29D"}, {"\uB29E", "\uB29E"}, {"\uB29F", "\uB29F"},
    {"\uB2A0", "\uB2A0"}, {"\uB2A1", "\uB2A1"}, {"\uB2A2", "\uB2A2"}, {"\uB2A3", "\uB2A3"}, {"\uB2A4", "\uB2A4"},
    {"\uB2A5", "\uB2A5"}, {"\uB2A6", "\uB2A6"}, {"\uB2A7", "\uB2A7"}, {"\uB2A8", "\uB2A8"}, {"\uB2A9", "\uB2A9"},
    {"\uB2AA", "\uB2AA"}, {"\uB2AB", "\uB2AB"}, {"\uB2AC", "\uB2AC"}, {"\uB2AD", "\uB2AD"}, {"\uB2AE", "\uB2AE"},
    {"\uB2AF", "\uB2AF"}, {"\uB2B0", "\uB2B0"}, {"\uB2B1", "\uB2B1"}, {"\uB2B2", "\uB2B2"}, {"\uB2B3", "\uB2B3"},
    {"\uB2B4", "\uB2B4"}, {"\uB2B5", "\uB2B5"}, {"\uB2B6", "\uB2B6"}, {"\uB2B7", "\uB2B7"}, {"\uB2B8", "\uB2B8"},
    {"\uB2B9", "\uB2B9"}, {"\uB2BA", "\uB2BA"}, {"\uB2BB", "\uB2BB"}, {"\uB2BC", "\uB2BC"}, {"\uB2BD", "\uB2BD"},
    {"\uB2BE", "\uB2BE"}, {"\uB2BF", "\uB2BF"}, {"\uB2C0", "\uB2C0"}, {"\uB2C1", "\uB2C1"}, {"\uB2C2", "\uB2C2"},
    {"\uB2C3", "\uB2C3"}, {"\uB2C4", "\uB2C4"}, {"\uB2C5", "\uB2C5"}, {"\uB2C6", "\uB2C6"}, {"\uB2C7", "\uB2C7"},
    {"\uB2C8", "\uB2C8"}, {"\uB2C9", "\uB2C9"}, {"\uB2CA", "\uB2CA"}, {"\uB2CB", "\uB2CB"}, {"\uB2CC", "\uB2CC"},
    {"\uB2CD", "\uB2CD"}, {"\uB2CE", "\uB2CE"}, {"\uB2CF", "\uB2CF"}, {"\uB2D0", "\uB2D0"}, {"\uB2D1", "\uB2D1"},
    {"\uB2D2", "\uB2D2"}, {"\uB2D3", "\uB2D3"}, {"\uB2D4", "\uB2D4"}, {"\uB2D5", "\uB2D5"}, {"\uB2D6", "\uB2D6"},
    {"\uB2D7", "\uB2D7"}, {"\uB2D8", "\uB2D8"}, {"\uB2D9", "\uB2D9"}, {"\uB2DA", "\uB2DA"}, {"\uB2DB", "\uB2DB"},
    {"\uB2DC", "\uB2DC"}, {"\uB2DD", "\uB2DD"}, {"\uB2DE", "\uB2DE"}, {"\uB2DF", "\uB2DF"}, {"\uB2E0", "\uB2E0"},
    {"\uB2E1", "\uB2E1"}, {"\uB2E2", "\uB2E2"}, {"\uB2E3", "\uB2E3"}, {"\uB2E4", "\uB2E4"}, {"\uB2E5", "\uB2E5"},
    {"\uB2E6", "\uB2E6"}, {"\uB2E7", "\uB2E7"}, {"\uB2E8", "\uB2E8"}, {"\uB2E9", "\uB2E9"}, {"\uB2EA", "\uB2EA"},
    {"\uB2EB", "\uB2EB"}, {"\uB2EC", "\uB2EC"}, {"\uB2ED", "\uB2ED"}, {"\uB2EE", "\uB2EE"}, {"\uB2EF", "\uB2EF"},
    {"\uB2F0", "\uB2F0"}, {"\uB2F1", "\uB2F1"}, {"\uB2F2", "\uB2F2"}, {"\uB2F3", "\uB2F3"}, {"\uB2F4", "\uB2F4"},
    {"\uB2F5", "\uB2F5"}, {"\uB2F6", "\uB2F6"}, {"\uB2F7", "\uB2F7"}, {"\uB2F8", "\uB2F8"}, {"\uB2F9", "\uB2F9"},
    {"\uB2FA", "\uB2FA"}, {"\uB2FB", "\uB2FB"}, {"\uB2FC", "\uB2FC"}, {"\uB2FD", "\uB2FD"}, {"\uB2FE", "\uB2FE"},
    {"\uB2FF", "\uB2FF"}, {"\uB300", "\uB300"}, {"\uB301", "\uB301"}, {"\uB302", "\uB302"}, {"\uB303", "\uB303"},
    {"\uB304", "\uB304"}, {"\uB305", "\uB305"}, {"\uB306", "\uB306"}, {"\uB307", "\uB307"}, {"\uB308", "\uB308"},
    {"\uB309", "\uB309"}, {"\uB30A", "\uB30A"}, {"\uB30B", "\uB30B"}, {"\uB30C", "\uB30C"}, {"\uB30D", "\uB30D"},
    {"\uB30E", "\uB30E"}, {"\uB30F", "\uB30F"}, {"\uB310", "\uB310"}, {"\uB311", "\uB311"}, {"\uB312", "\uB312"},
    {"\uB313", "\uB313"}, {"\uB314", "\uB314"}, {"\uB315", "\uB315"}, {"\uB316", "\uB316"}, {"\uB317", "\uB317"},
    {"\uB318", "\uB318"}, {"\uB319", "\uB319"}, {"\uB31A", "\uB31A"}, {"\uB31B", "\uB31B"}, {"\uB31C", "\uB31C"},
    {"\uB31D", "\uB31D"}, {"\uB31E", "\uB31E"}, {"\uB31F", "\uB31F"}, {"\uB320", "\uB320"}, {"\uB321", "\uB321"},
    {"\uB322", "\uB322"}, {"\uB323", "\uB323"}, {"\uB324", "\uB324"}, {"\uB325", "\uB325"}, {"\uB326", "\uB326"},
    {"\uB327", "\uB327"}, {"\uB328", "\uB328"}, {"\uB329", "\uB329"}, {"\uB32A", "\uB32A"}, {"\uB32B", "\uB32B"},
    {"\uB32C", "\uB32C"}, {"\uB32D", "\uB32D"}, {"\uB32E", "\uB32E"}, {"\uB32F", "\uB32F"}, {"\uB330", "\uB330"},
    {"\uB331", "\uB331"}, {"\uB332", "\uB332"}, {"\uB333", "\uB333"}, {"\uB334", "\uB334"}, {"\uB335", "\uB335"},
    {"\uB336", "\uB336"}, {"\uB337", "\uB337"}, {"\uB338", "\uB338"}, {"\uB339", "\uB339"}, {"\uB33A", "\uB33A"},
    {"\uB33B", "\uB33B"}, {"\uB33C", "\uB33C"}, {"\uB33D", "\uB33D"}, {"\uB33E", "\uB33E"}, {"\uB33F", "\uB33F"},
    {"\uB340", "\uB340"}, {"\uB341", "\uB341"}, {"\uB342", "\uB342"}, {"\uB343", "\uB343"}, {"\uB344", "\uB344"},
    {"\uB345", "\uB345"}, {"\uB346", "\uB346"}, {"\uB347", "\uB347"}, {"\uB348", "\uB348"}, {"\uB349", "\uB349"},
    {"\uB34A", "\uB34A"}, {"\uB34B", "\uB34B"}, {"\uB34C", "\uB34C"}, {"\uB34D", "\uB34D"}, {"\uB34E", "\uB34E"},
    {"\uB34F", "\uB34F"}, {"\uB350", "\uB350"}, {"\uB351", "\uB351"}, {"\uB352", "\uB352"}, {"\uB353", "\uB353"},
    {"\uB354", "\uB354"}, {"\uB355", "\uB355"}, {"\uB356", "\uB356"}, {"\uB357", "\uB357"}, {"\uB358", "\uB358"},
    {"\uB359", "\uB359"}, {"\uB35A", "\uB35A"}, {"\uB35B", "\uB35B"}, {"\uB35C", "\uB35C"}, {"\uB35D", "\uB35D"},
    {"\uB35E", "\uB35E"}, {"\uB35F", "\uB35F"}, {"\uB360", "\uB360"}, {"\uB361", "\uB361"}, {"\uB362", "\uB362"},
    {"\uB363", "\uB363"}, {"\uB364", "\uB364"}, {"\uB365", "\uB365"}, {"\uB366", "\uB366"}, {"\uB367", "\uB367"},
    {"\uB368", "\uB368"}, {"\uB369", "\uB369"}, {"\uB36A", "\uB36A"}, {"\uB36B", "\uB36B"}, {"\uB36C", "\uB36C"},
    {"\uB36D", "\uB36D"}, {"\uB36E", "\uB36E"}, {"\uB36F", "\uB36F"}, {"\uB370", "\uB370"}, {"\uB371", "\uB371"},
    {"\uB372", "\uB372"}, {"\uB373", "\uB373"}, {"\uB374", "\uB374"}, {"\uB375", "\uB375"}, {"\uB376", "\uB376"},
    {"\uB377", "\uB377"}, {"\uB378", "\uB378"}, {"\uB379", "\uB379"}, {"\uB37A", "\uB37A"}, {"\uB37B", "\uB37B"},
    {"\uB37C", "\uB37C"}, {"\uB37D", "\uB37D"}, {"\uB37E", "\uB37E"}, {"\uB37F", "\uB37F"}, {"\uB380", "\uB380"},
    {"\uB381", "\uB381"}, {"\uB382", "\uB382"}, {"\uB383", "\uB383"}, {"\uB384", "\uB384"}, {"\uB385", "\uB385"},
    {"\uB386", "\uB386"}, {"\uB387", "\uB387"}, {"\uB388", "\uB388"}, {"\uB389", "\uB389"}, {"\uB38A", "\uB38A"},
    {"\uB38B", "\uB38B"}, {"\uB38C", "\uB38C"}, {"\uB38D", "\uB38D"}, {"\uB38E", "\uB38E"}, {"\uB38F", "\uB38F"},
    {"\uB390", "\uB390"}, {"\uB391", "\uB391"}, {"\uB392", "\uB392"}, {"\uB393", "\uB393"}, {"\uB394", "\uB394"},
    {"\uB395", "\uB395"}, {"\uB396", "\uB396"}, {"\uB397", "\uB397"}, {"\uB398", "\uB398"}, {"\uB399", "\uB399"},
    {"\uB39A", "\uB39A"}, {"\uB39B", "\uB39B"}, {"\uB39C", "\uB39C"}, {"\uB39D", "\uB39D"}, {"\uB39E", "\uB39E"},
    {"\uB39F", "\uB39F"}, {"\uB3A0", "\uB3A0"}, {"\uB3A1", "\uB3A1"}, {"\uB3A2", "\uB3A2"}, {"\uB3A3", "\uB3A3"},
    {"\uB3A4", "\uB3A4"}, {"\uB3A5", "\uB3A5"}, {"\uB3A6", "\uB3A6"}, {"\uB3A7", "\uB3A7"}, {"\uB3A8", "\uB3A8"},
    {"\uB3A9", "\uB3A9"}, {"\uB3AA", "\uB3AA"}, {"\uB3AB", "\uB3AB"}, {"\uB3AC", "\uB3AC"}, {"\uB3AD", "\uB3AD"},
    {"\uB3AE", "\uB3AE"}, {"\uB3AF", "\uB3AF"}, {"\uB3B0", "\uB3B0"}, {"\uB3B1", "\uB3B1"}, {"\uB3B2", "\uB3B2"},
    {"\uB3B3", "\uB3B3"}, {"\uB3B4", "\uB3B4"}, {"\uB3B5", "\uB3B5"}, {"\uB3B6", "\uB3B6"}, {"\uB3B7", "\uB3B7"},
    {"\uB3B8", "\uB3B8"}, {"\uB3B9", "\uB3B9"}, {"\uB3BA", "\uB3BA"}, {"\uB3BB", "\uB3BB"}, {"\uB3BC", "\uB3BC"},
    {"\uB3BD", "\uB3BD"}, {"\uB3BE", "\uB3BE"}, {"\uB3BF", "\uB3BF"}, {"\uB3C0", "\uB3C0"}, {"\uB3C1", "\uB3C1"},
    {"\uB3C2", "\uB3C2"}, {"\uB3C3", "\uB3C3"}, {"\uB3C4", "\uB3C4"}, {"\uB3C5", "\uB3C5"}, {"\uB3C6", "\uB3C6"},
    {"\uB3C7", "\uB3C7"}, {"\uB3C8", "\uB3C8"}, {"\uB3C9", "\uB3C9"}, {"\uB3CA", "\uB3CA"}, {"\uB3CB", "\uB3CB"},
    {"\uB3CC", "\uB3CC"}, {"\uB3CD", "\uB3CD"}, {"\uB3CE", "\uB3CE"}, {"\uB3CF", "\uB3CF"}, {"\uB3D0", "\uB3D0"},
    {"\uB3D1", "\uB3D1"}, {"\uB3D2", "\uB3D2"}, {"\uB3D3", "\uB3D3"}, {"\uB3D4", "\uB3D4"}, {"\uB3D5", "\uB3D5"},
    {"\uB3D6", "\uB3D6"}, {"\uB3D7", "\uB3D7"}, {"\uB3D8", "\uB3D8"}, {"\uB3D9", "\uB3D9"}, {"\uB3DA", "\uB3DA"},
    {"\uB3DB", "\uB3DB"}, {"\uB3DC", "\uB3DC"}, {"\uB3DD", "\uB3DD"}, {"\uB3DE", "\uB3DE"}, {"\uB3DF", "\uB3DF"},
    {"\uB3E0", "\uB3E0"}, {"\uB3E1", "\uB3E1"}, {"\uB3E2", "\uB3E2"}, {"\uB3E3", "\uB3E3"}, {"\uB3E4", "\uB3E4"},
    {"\uB3E5", "\uB3E5"}, {"\uB3E6", "\uB3E6"}, {"\uB3E7", "\uB3E7"}, {"\uB3E8", "\uB3E8"}, {"\uB3E9", "\uB3E9"},
    {"\uB3EA", "\uB3EA"}, {"\uB3EB", "\uB3EB"}, {"\uB3EC", "\uB3EC"}, {"\uB3ED", "\uB3ED"}, {"\uB3EE", "\uB3EE"},
    {"\uB3EF", "\uB3EF"}, {"\uB3F0", "\uB3F0"}, {"\uB3F1", "\uB3F1"}, {"\uB3F2", "\uB3F2"}, {"\uB3F3", "\uB3F3"},
    {"\uB3F4", "\uB3F4"}, {"\uB3F5", "\uB3F5"}, {"\uB3F6", "\uB3F6"}, {"\uB3F7", "\uB3F7"}, {"\uB3F8", "\uB3F8"},
    {"\uB3F9", "\uB3F9"}, {"\uB3FA", "\uB3FA"}, {"\uB3FB", "\uB3FB"}, {"\uB3FC", "\uB3FC"}, {"\uB3FD", "\uB3FD"},
    {"\uB3FE", "\uB3FE"}, {"\uB3FF", "\uB3FF"}, {"\uB400", "\uB400"}, {"\uB401", "\uB401"}, {"\uB402", "\uB402"},
    {"\uB403", "\uB403"}, {"\uB404", "\uB404"}, {"\uB405", "\uB405"}, {"\uB406", "\uB406"}, {"\uB407", "\uB407"},
    {"\uB408", "\uB408"}, {"\uB409", "\uB409"}, {"\uB40A", "\uB40A"}, {"\uB40B", "\uB40B"}, {"\uB40C", "\uB40C"},
    {"\uB40D", "\uB40D"}, {"\uB40E", "\uB40E"}, {"\uB40F", "\uB40F"}, {"\uB410", "\uB410"}, {"\uB411", "\uB411"},
    {"\uB412", "\uB412"}, {"\uB413", "\uB413"}, {"\uB414", "\uB414"}, {"\uB415", "\uB415"}, {"\uB416", "\uB416"},
    {"\uB417", "\uB417"}, {"\uB418", "\uB418"}, {"\uB419", "\uB419"}, {"\uB41A", "\uB41A"}, {"\uB41B", "\uB41B"},
    {"\uB41C", "\uB41C"}, {"\uB41D", "\uB41D"}, {"\uB41E", "\uB41E"}, {"\uB41F", "\uB41F"}, {"\uB420", "\uB420"},
    {"\uB421", "\uB421"}, {"\uB422", "\uB422"}, {"\uB423", "\uB423"}, {"\uB424", "\uB424"}, {"\uB425", "\uB425"},
    {"\uB426", "\uB426"}, {"\uB427", "\uB427"}, {"\uB428", "\uB428"}, {"\uB429", "\uB429"}, {"\uB42A", "\uB42A"},
    {"\uB42B", "\uB42B"}, {"\uB42C", "\uB42C"}, {"\uB42D", "\uB42D"}, {"\uB42E", "\uB42E"}, {"\uB42F", "\uB42F"},
    {"\uB430", "\uB430"}, {"\uB431", "\uB431"}, {"\uB432", "\uB432"}, {"\uB433", "\uB433"}, {"\uB434", "\uB434"},
    {"\uB435", "\uB435"}, {"\uB436", "\uB436"}, {"\uB437", "\uB437"}, {"\uB438", "\uB438"}, {"\uB439", "\uB439"},
    {"\uB43A", "\uB43A"}, {"\uB43B", "\uB43B"}, {"\uB43C", "\uB43C"}, {"\uB43D", "\uB43D"}, {"\uB43E", "\uB43E"},
    {"\uB43F", "\uB43F"}, {"\uB440", "\uB440"}, {"\uB441", "\uB441"}, {"\uB442", "\uB442"}, {"\uB443", "\uB443"},
    {"\uB444", "\uB444"}, {"\uB445", "\uB445"}, {"\uB446", "\uB446"}, {"\uB447", "\uB447"}, {"\uB448", "\uB448"},
    {"\uB449", "\uB449"}, {"\uB44A", "\uB44A"}, {"\uB44B", "\uB44B"}, {"\uB44C", "\uB44C"}, {"\uB44D", "\uB44D"},
    {"\uB44E", "\uB44E"}, {"\uB44F", "\uB44F"}, {"\uB450", "\uB450"}, {"\uB451", "\uB451"}, {"\uB452", "\uB452"},
    {"\uB453", "\uB453"}, {"\uB454", "\uB454"}, {"\uB455", "\uB455"}, {"\uB456", "\uB456"}, {"\uB457", "\uB457"},
    {"\uB458", "\uB458"}, {"\uB459", "\uB459"}, {"\uB45A", "\uB45A"}, {"\uB45B", "\uB45B"}, {"\uB45C", "\uB45C"},
    {"\uB45D", "\uB45D"}, {"\uB45E", "\uB45E"}, {"\uB45F", "\uB45F"}, {"\uB460", "\uB460"}, {"\uB461", "\uB461"},
    {"\uB462", "\uB462"}, {"\uB463", "\uB463"}, {"\uB464", "\uB464"}, {"\uB465", "\uB465"}, {"\uB466", "\uB466"},
    {"\uB467", "\uB467"}, {"\uB468", "\uB468"}, {"\uB469", "\uB469"}, {"\uB46A", "\uB46A"}, {"\uB46B", "\uB46B"},
    {"\uB46C", "\uB46C"}, {"\uB46D", "\uB46D"}, {"\uB46E", "\uB46E"}, {"\uB46F", "\uB46F"}, {"\uB470", "\uB470"},
    {"\uB471", "\uB471"}, {"\uB472", "\uB472"}, {"\uB473", "\uB473"}, {"\uB474", "\uB474"}, {"\uB475", "\uB475"},
    {"\uB476", "\uB476"}, {"\uB477", "\uB477"}, {"\uB478", "\uB478"}, {"\uB479", "\uB479"}, {"\uB47A", "\uB47A"},
    {"\uB47B", "\uB47B"}, {"\uB47C", "\uB47C"}, {"\uB47D", "\uB47D"}, {"\uB47E", "\uB47E"}, {"\uB47F", "\uB47F"},
    {"\uB480", "\uB480"}, {"\uB481", "\uB481"}, {"\uB482", "\uB482"}, {"\uB483", "\uB483"}, {"\uB484", "\uB484"},
    {"\uB485", "\uB485"}, {"\uB486", "\uB486"}, {"\uB487", "\uB487"}, {"\uB488", "\uB488"}, {"\uB489", "\uB489"},
    {"\uB48A", "\uB48A"}, {"\uB48B", "\uB48B"}, {"\uB48C", "\uB48C"}, {"\uB48D", "\uB48D"}, {"\uB48E", "\uB48E"},
    {"\uB48F", "\uB48F"}, {"\uB490", "\uB490"}, {"\uB491", "\uB491"}, {"\uB492", "\uB492"}, {"\uB493", "\uB493"},
    {"\uB494", "\uB494"}, {"\uB495", "\uB495"}, {"\uB496", "\uB496"}, {"\uB497", "\uB497"}, {"\uB498", "\uB498"},
    {"\uB499", "\uB499"}, {"\uB49A", "\uB49A"}, {"\uB49B", "\uB49B"}, {"\uB49C", "\uB49C"}, {"\uB49D", "\uB49D"},
    {"\uB49E", "\uB49E"}, {"\uB49F", "\uB49F"}, {"\uB4A0", "\uB4A0"}, {"\uB4A1", "\uB4A1"}, {"\uB4A2", "\uB4A2"},
    {"\uB4A3", "\uB4A3"}, {"\uB4A4", "\uB4A4"}, {"\uB4A5", "\uB4A5"}, {"\uB4A6", "\uB4A6"}, {"\uB4A7", "\uB4A7"},
    {"\uB4A8", "\uB4A8"}, {"\uB4A9", "\uB4A9"}, {"\uB4AA", "\uB4AA"}, {"\uB4AB", "\uB4AB"}, {"\uB4AC", "\uB4AC"},
    {"\uB4AD", "\uB4AD"}, {"\uB4AE", "\uB4AE"}, {"\uB4AF", "\uB4AF"}, {"\uB4B0", "\uB4B0"}, {"\uB4B1", "\uB4B1"},
    {"\uB4B2", "\uB4B2"}, {"\uB4B3", "\uB4B3"}, {"\uB4B4", "\uB4B4"}, {"\uB4B5", "\uB4B5"}, {"\uB4B6", "\uB4B6"},
    {"\uB4B7", "\uB4B7"}, {"\uB4B8", "\uB4B8"}, {"\uB4B9", "\uB4B9"}, {"\uB4BA", "\uB4BA"}, {"\uB4BB", "\uB4BB"},
    {"\uB4BC", "\uB4BC"}, {"\uB4BD", "\uB4BD"}, {"\uB4BE", "\uB4BE"}, {"\uB4BF", "\uB4BF"}, {"\uB4C0", "\uB4C0"},
    {"\uB4C1", "\uB4C1"}, {"\uB4C2", "\uB4C2"}, {"\uB4C3", "\uB4C3"}, {"\uB4C4", "\uB4C4"}, {"\uB4C5", "\uB4C5"},
    {"\uB4C6", "\uB4C6"}, {"\uB4C7", "\uB4C7"}, {"\uB4C8", "\uB4C8"}, {"\uB4C9", "\uB4C9"}, {"\uB4CA", "\uB4CA"},
    {"\uB4CB", "\uB4CB"}, {"\uB4CC", "\uB4CC"}, {"\uB4CD", "\uB4CD"}, {"\uB4CE", "\uB4CE"}, {"\uB4CF", "\uB4CF"},
    {"\uB4D0", "\uB4D0"}, {"\uB4D1", "\uB4D1"}, {"\uB4D2", "\uB4D2"}, {"\uB4D3", "\uB4D3"}, {"\uB4D4", "\uB4D4"},
    {"\uB4D5", "\uB4D5"}, {"\uB4D6", "\uB4D6"}, {"\uB4D7", "\uB4D7"}, {"\uB4D8", "\uB4D8"}, {"\uB4D9", "\uB4D9"},
    {"\uB4DA", "\uB4DA"}, {"\uB4DB", "\uB4DB"}, {"\uB4DC", "\uB4DC"}, {"\uB4DD", "\uB4DD"}, {"\uB4DE", "\uB4DE"},
    {"\uB4DF", "\uB4DF"}, {"\uB4E0", "\uB4E0"}, {"\uB4E1", "\uB4E1"}, {"\uB4E2", "\uB4E2"}, {"\uB4E3", "\uB4E3"},
    {"\uB4E4", "\uB4E4"}, {"\uB4E5", "\uB4E5"}, {"\uB4E6", "\uB4E6"}, {"\uB4E7", "\uB4E7"}, {"\uB4E8", "\uB4E8"},
    {"\uB4E9", "\uB4E9"}, {"\uB4EA", "\uB4EA"}, {"\uB4EB", "\uB4EB"}, {"\uB4EC", "\uB4EC"}, {"\uB4ED", "\uB4ED"},
    {"\uB4EE", "\uB4EE"}, {"\uB4EF", "\uB4EF"}, {"\uB4F0", "\uB4F0"}, {"\uB4F1", "\uB4F1"}, {"\uB4F2", "\uB4F2"},
    {"\uB4F3", "\uB4F3"}, {"\uB4F4", "\uB4F4"}, {"\uB4F5", "\uB4F5"}, {"\uB4F6", "\uB4F6"}, {"\uB4F7", "\uB4F7"},
    {"\uB4F8", "\uB4F8"}, {"\uB4F9", "\uB4F9"}, {"\uB4FA", "\uB4FA"}, {"\uB4FB", "\uB4FB"}, {"\uB4FC", "\uB4FC"},
    {"\uB4FD", "\uB4FD"}, {"\uB4FE", "\uB4FE"}, {"\uB4FF", "\uB4FF"}, {"\uB500", "\uB500"}, {"\uB501", "\uB501"},
    {"\uB502", "\uB502"}, {"\uB503", "\uB503"}, {"\uB504", "\uB504"}, {"\uB505", "\uB505"}, {"\uB506", "\uB506"},
    {"\uB507", "\uB507"}, {"\uB508", "\uB508"}, {"\uB509", "\uB509"}, {"\uB50A", "\uB50A"}, {"\uB50B", "\uB50B"},
    {"\uB50C", "\uB50C"}, {"\uB50D", "\uB50D"}, {"\uB50E", "\uB50E"}, {"\uB50F", "\uB50F"}, {"\uB510", "\uB510"},
    {"\uB511", "\uB511"}, {"\uB512", "\uB512"}, {"\uB513", "\uB513"}, {"\uB514", "\uB514"}, {"\uB515", "\uB515"},
    {"\uB516", "\uB516"}, {"\uB517", "\uB517"}, {"\uB518", "\uB518"}, {"\uB519", "\uB519"}, {"\uB51A", "\uB51A"},
    {"\uB51B", "\uB51B"}, {"\uB51C", "\uB51C"}, {"\uB51D", "\uB51D"}, {"\uB51E", "\uB51E"}, {"\uB51F", "\uB51F"},
    {"\uB520", "\uB520"}, {"\uB521", "\uB521"}, {"\uB522", "\uB522"}, {"\uB523", "\uB523"}, {"\uB524", "\uB524"},
    {"\uB525", "\uB525"}, {"\uB526", "\uB526"}, {"\uB527", "\uB527"}, {"\uB528", "\uB528"}, {"\uB529", "\uB529"},
    {"\uB52A", "\uB52A"}, {"\uB52B", "\uB52B"}, {"\uB52C", "\uB52C"}, {"\uB52D", "\uB52D"}, {"\uB52E", "\uB52E"},
    {"\uB52F", "\uB52F"}, {"\uB530", "\uB530"}, {"\uB531", "\uB531"}, {"\uB532", "\uB532"}, {"\uB533", "\uB533"},
    {"\uB534", "\uB534"}, {"\uB535", "\uB535"}, {"\uB536", "\uB536"}, {"\uB537", "\uB537"}, {"\uB538", "\uB538"},
    {"\uB539", "\uB539"}, {"\uB53A", "\uB53A"}, {"\uB53B", "\uB53B"}, {"\uB53C", "\uB53C"}, {"\uB53D", "\uB53D"},
    {"\uB53E", "\uB53E"}, {"\uB53F", "\uB53F"}, {"\uB540", "\uB540"}, {"\uB541", "\uB541"}, {"\uB542", "\uB542"},
    {"\uB543", "\uB543"}, {"\uB544", "\uB544"}, {"\uB545", "\uB545"}, {"\uB546", "\uB546"}, {"\uB547", "\uB547"},
    {"\uB548", "\uB548"}, {"\uB549", "\uB549"}, {"\uB54A", "\uB54A"}, {"\uB54B", "\uB54B"}, {"\uB54C", "\uB54C"},
    {"\uB54D", "\uB54D"}, {"\uB54E", "\uB54E"}, {"\uB54F", "\uB54F"}, {"\uB550", "\uB550"}, {"\uB551", "\uB551"},
    {"\uB552", "\uB552"}, {"\uB553", "\uB553"}, {"\uB554", "\uB554"}, {"\uB555", "\uB555"}, {"\uB556", "\uB556"},
    {"\uB557", "\uB557"}, {"\uB558", "\uB558"}, {"\uB559", "\uB559"}, {"\uB55A", "\uB55A"}, {"\uB55B", "\uB55B"},
    {"\uB55C", "\uB55C"}, {"\uB55D", "\uB55D"}, {"\uB55E", "\uB55E"}, {"\uB55F", "\uB55F"}, {"\uB560", "\uB560"},
    {"\uB561", "\uB561"}, {"\uB562", "\uB562"}, {"\uB563", "\uB563"}, {"\uB564", "\uB564"}, {"\uB565", "\uB565"},
    {"\uB566", "\uB566"}, {"\uB567", "\uB567"}, {"\uB568", "\uB568"}, {"\uB569", "\uB569"}, {"\uB56A", "\uB56A"},
    {"\uB56B", "\uB56B"}, {"\uB56C", "\uB56C"}, {"\uB56D", "\uB56D"}, {"\uB56E", "\uB56E"}, {"\uB56F", "\uB56F"},
    {"\uB570", "\uB570"}, {"\uB571", "\uB571"}, {"\uB572", "\uB572"}, {"\uB573", "\uB573"}, {"\uB574", "\uB574"},
    {"\uB575", "\uB575"}, {"\uB576", "\uB576"}, {"\uB577", "\uB577"}, {"\uB578", "\uB578"}, {"\uB579", "\uB579"},
    {"\uB57A", "\uB57A"}, {"\uB57B", "\uB57B"}, {"\uB57C", "\uB57C"}, {"\uB57D", "\uB57D"}, {"\uB57E", "\uB57E"},
    {"\uB57F", "\uB57F"}, {"\uB580", "\uB580"}, {"\uB581", "\uB581"}, {"\uB582", "\uB582"}, {"\uB583", "\uB583"},
    {"\uB584", "\uB584"}, {"\uB585", "\uB585"}, {"\uB586", "\uB586"}, {"\uB587", "\uB587"}, {"\uB588", "\uB588"},
    {"\uB589", "\uB589"}, {"\uB58A", "\uB58A"}, {"\uB58B", "\uB58B"}, {"\uB58C", "\uB58C"}, {"\uB58D", "\uB58D"},
    {"\uB58E", "\uB58E"}, {"\uB58F", "\uB58F"}, {"\uB590", "\uB590"}, {"\uB591", "\uB591"}, {"\uB592", "\uB592"},
    {"\uB593", "\uB593"}, {"\uB594", "\uB594"}, {"\uB595", "\uB595"}, {"\uB596", "\uB596"}, {"\uB597", "\uB597"},
    {"\uB598", "\uB598"}, {"\uB599", "\uB599"}, {"\uB59A", "\uB59A"}, {"\uB59B", "\uB59B"}, {"\uB59C", "\uB59C"},
    {"\uB59D", "\uB59D"}, {"\uB59E", "\uB59E"}, {"\uB59F", "\uB59F"}, {"\uB5A0", "\uB5A0"}, {"\uB5A1", "\uB5A1"},
    {"\uB5A2", "\uB5A2"}, {"\uB5A3", "\uB5A3"}, {"\uB5A4", "\uB5A4"}, {"\uB5A5", "\uB5A5"}, {"\uB5A6", "\uB5A6"},
    {"\uB5A7", "\uB5A7"}, {"\uB5A8", "\uB5A8"}, {"\uB5A9", "\uB5A9"}, {"\uB5AA", "\uB5AA"}, {"\uB5AB", "\uB5AB"},
    {"\uB5AC", "\uB5AC"}, {"\uB5AD", "\uB5AD"}, {"\uB5AE", "\uB5AE"}, {"\uB5AF", "\uB5AF"}, {"\uB5B0", "\uB5B0"},
    {"\uB5B1", "\uB5B1"}, {"\uB5B2", "\uB5B2"}, {"\uB5B3", "\uB5B3"}, {"\uB5B4", "\uB5B4"}, {"\uB5B5", "\uB5B5"},
    {"\uB5B6", "\uB5B6"}, {"\uB5B7", "\uB5B7"}, {"\uB5B8", "\uB5B8"}, {"\uB5B9", "\uB5B9"}, {"\uB5BA", "\uB5BA"},
    {"\uB5BB", "\uB5BB"}, {"\uB5BC", "\uB5BC"}, {"\uB5BD", "\uB5BD"}, {"\uB5BE", "\uB5BE"}, {"\uB5BF", "\uB5BF"},
    {"\uB5C0", "\uB5C0"}, {"\uB5C1", "\uB5C1"}, {"\uB5C2", "\uB5C2"}, {"\uB5C3", "\uB5C3"}, {"\uB5C4", "\uB5C4"},
    {"\uB5C5", "\uB5C5"}, {"\uB5C6", "\uB5C6"}, {"\uB5C7", "\uB5C7"}, {"\uB5C8", "\uB5C8"}, {"\uB5C9", "\uB5C9"},
    {"\uB5CA", "\uB5CA"}, {"\uB5CB", "\uB5CB"}, {"\uB5CC", "\uB5CC"}, {"\uB5CD", "\uB5CD"}, {"\uB5CE", "\uB5CE"},
    {"\uB5CF", "\uB5CF"}, {"\uB5D0", "\uB5D0"}, {"\uB5D1", "\uB5D1"}, {"\uB5D2", "\uB5D2"}, {"\uB5D3", "\uB5D3"},
    {"\uB5D4", "\uB5D4"}, {"\uB5D5", "\uB5D5"}, {"\uB5D6", "\uB5D6"}, {"\uB5D7", "\uB5D7"}, {"\uB5D8", "\uB5D8"},
    {"\uB5D9", "\uB5D9"}, {"\uB5DA", "\uB5DA"}, {"\uB5DB", "\uB5DB"}, {"\uB5DC", "\uB5DC"}, {"\uB5DD", "\uB5DD"},
    {"\uB5DE", "\uB5DE"}, {"\uB5DF", "\uB5DF"}, {"\uB5E0", "\uB5E0"}, {"\uB5E1", "\uB5E1"}, {"\uB5E2", "\uB5E2"},
    {"\uB5E3", "\uB5E3"}, {"\uB5E4", "\uB5E4"}, {"\uB5E5", "\uB5E5"}, {"\uB5E6", "\uB5E6"}, {"\uB5E7", "\uB5E7"},
    {"\uB5E8", "\uB5E8"}, {"\uB5E9", "\uB5E9"}, {"\uB5EA", "\uB5EA"}, {"\uB5EB", "\uB5EB"}, {"\uB5EC", "\uB5EC"},
    {"\uB5ED", "\uB5ED"}, {"\uB5EE", "\uB5EE"}, {"\uB5EF", "\uB5EF"}, {"\uB5F0", "\uB5F0"}, {"\uB5F1", "\uB5F1"},
    {"\uB5F2", "\uB5F2"}, {"\uB5F3", "\uB5F3"}, {"\uB5F4", "\uB5F4"}, {"\uB5F5", "\uB5F5"}, {"\uB5F6", "\uB5F6"},
    {"\uB5F7", "\uB5F7"}, {"\uB5F8", "\uB5F8"}, {"\uB5F9", "\uB5F9"}, {"\uB5FA", "\uB5FA"}, {"\uB5FB", "\uB5FB"},
    {"\uB5FC", "\uB5FC"}, {"\uB5FD", "\uB5FD"}, {"\uB5FE", "\uB5FE"}, {"\uB5FF", "\uB5FF"}, {"\uB600", "\uB600"},
    {"\uB601", "\uB601"}, {"\uB602", "\uB602"}, {"\uB603", "\uB603"}, {"\uB604", "\uB604"}, {"\uB605", "\uB605"},
    {"\uB606", "\uB606"}, {"\uB607", "\uB607"}, {"\uB608", "\uB608"}, {"\uB609", "\uB609"}, {"\uB60A", "\uB60A"},
    {"\uB60B", "\uB60B"}, {"\uB60C", "\uB60C"}, {"\uB60D", "\uB60D"}, {"\uB60E", "\uB60E"}, {"\uB60F", "\uB60F"},
    {"\uB610", "\uB610"}, {"\uB611", "\uB611"}, {"\uB612", "\uB612"}, {"\uB613", "\uB613"}, {"\uB614", "\uB614"},
    {"\uB615", "\uB615"}, {"\uB616", "\uB616"}, {"\uB617", "\uB617"}, {"\uB618", "\uB618"}, {"\uB619", "\uB619"},
    {"\uB61A", "\uB61A"}, {"\uB61B", "\uB61B"}, {"\uB61C", "\uB61C"}, {"\uB61D", "\uB61D"}, {"\uB61E", "\uB61E"},
    {"\uB61F", "\uB61F"}, {"\uB620", "\uB620"}, {"\uB621", "\uB621"}, {"\uB622", "\uB622"}, {"\uB623", "\uB623"},
    {"\uB624", "\uB624"}, {"\uB625", "\uB625"}, {"\uB626", "\uB626"}, {"\uB627", "\uB627"}, {"\uB628", "\uB628"},
    {"\uB629", "\uB629"}, {"\uB62A", "\uB62A"}, {"\uB62B", "\uB62B"}, {"\uB62C", "\uB62C"}, {"\uB62D", "\uB62D"},
    {"\uB62E", "\uB62E"}, {"\uB62F", "\uB62F"}, {"\uB630", "\uB630"}, {"\uB631", "\uB631"}, {"\uB632", "\uB632"},
    {"\uB633", "\uB633"}, {"\uB634", "\uB634"}, {"\uB635", "\uB635"}, {"\uB636", "\uB636"}, {"\uB637", "\uB637"},
    {"\uB638", "\uB638"}, {"\uB639", "\uB639"}, {"\uB63A", "\uB63A"}, {"\uB63B", "\uB63B"}, {"\uB63C", "\uB63C"},
    {"\uB63D", "\uB63D"}, {"\uB63E", "\uB63E"}, {"\uB63F", "\uB63F"}, {"\uB640", "\uB640"}, {"\uB641", "\uB641"},
    {"\uB642", "\uB642"}, {"\uB643", "\uB643"}, {"\uB644", "\uB644"}, {"\uB645", "\uB645"}, {"\uB646", "\uB646"},
    {"\uB647", "\uB647"}, {"\uB648", "\uB648"}, {"\uB649", "\uB649"}, {"\uB64A", "\uB64A"}, {"\uB64B", "\uB64B"},
    {"\uB64C", "\uB64C"}, {"\uB64D", "\uB64D"}, {"\uB64E", "\uB64E"}, {"\uB64F", "\uB64F"}, {"\uB650", "\uB650"},
    {"\uB651", "\uB651"}, {"\uB652", "\uB652"}, {"\uB653", "\uB653"}, {"\uB654", "\uB654"}, {"\uB655", "\uB655"},
    {"\uB656", "\uB656"}, {"\uB657", "\uB657"}, {"\uB658", "\uB658"}, {"\uB659", "\uB659"}, {"\uB65A", "\uB65A"},
    {"\uB65B", "\uB65B"}, {"\uB65C", "\uB65C"}, {"\uB65D", "\uB65D"}, {"\uB65E", "\uB65E"}, {"\uB65F", "\uB65F"},
    {"\uB660", "\uB660"}, {"\uB661", "\uB661"}, {"\uB662", "\uB662"}, {"\uB663", "\uB663"}, {"\uB664", "\uB664"},
    {"\uB665", "\uB665"}, {"\uB666", "\uB666"}, {"\uB667", "\uB667"}, {"\uB668", "\uB668"}, {"\uB669", "\uB669"},
    {"\uB66A", "\uB66A"}, {"\uB66B", "\uB66B"}, {"\uB66C", "\uB66C"}, {"\uB66D", "\uB66D"}, {"\uB66E", "\uB66E"},
    {"\uB66F", "\uB66F"}, {"\uB670", "\uB670"}, {"\uB671", "\uB671"}, {"\uB672", "\uB672"}, {"\uB673", "\uB673"},
    {"\uB674", "\uB674"}, {"\uB675", "\uB675"}, {"\uB676", "\uB676"}, {"\uB677", "\uB677"}, {"\uB678", "\uB678"},
    {"\uB679", "\uB679"}, {"\uB67A", "\uB67A"}, {"\uB67B", "\uB67B"}, {"\uB67C", "\uB67C"}, {"\uB67D", "\uB67D"},
    {"\uB67E", "\uB67E"}, {"\uB67F", "\uB67F"}, {"\uB680", "\uB680"}, {"\uB681", "\uB681"}, {"\uB682", "\uB682"},
    {"\uB683", "\uB683"}, {"\uB684", "\uB684"}, {"\uB685", "\uB685"}, {"\uB686", "\uB686"}, {"\uB687", "\uB687"},
    {"\uB688", "\uB688"}, {"\uB689", "\uB689"}, {"\uB68A", "\uB68A"}, {"\uB68B", "\uB68B"}, {"\uB68C", "\uB68C"},
    {"\uB68D", "\uB68D"}, {"\uB68E", "\uB68E"}, {"\uB68F", "\uB68F"}, {"\uB690", "\uB690"}, {"\uB691", "\uB691"},
    {"\uB692", "\uB692"}, {"\uB693", "\uB693"}, {"\uB694", "\uB694"}, {"\uB695", "\uB695"}, {"\uB696", "\uB696"},
    {"\uB697", "\uB697"}, {"\uB698", "\uB698"}, {"\uB699", "\uB699"}, {"\uB69A", "\uB69A"}, {"\uB69B", "\uB69B"},
    {"\uB69C", "\uB69C"}, {"\uB69D", "\uB69D"}, {"\uB69E", "\uB69E"}, {"\uB69F", "\uB69F"}, {"\uB6A0", "\uB6A0"},
    {"\uB6A1", "\uB6A1"}, {"\uB6A2", "\uB6A2"}, {"\uB6A3", "\uB6A3"}, {"\uB6A4", "\uB6A4"}, {"\uB6A5", "\uB6A5"},
    {"\uB6A6", "\uB6A6"}, {"\uB6A7", "\uB6A7"}, {"\uB6A8", "\uB6A8"}, {"\uB6A9", "\uB6A9"}, {"\uB6AA", "\uB6AA"},
    {"\uB6AB", "\uB6AB"}, {"\uB6AC", "\uB6AC"}, {"\uB6AD", "\uB6AD"}, {"\uB6AE", "\uB6AE"}, {"\uB6AF", "\uB6AF"},
    {"\uB6B0", "\uB6B0"}, {"\uB6B1", "\uB6B1"}, {"\uB6B2", "\uB6B2"}, {"\uB6B3", "\uB6B3"}, {"\uB6B4", "\uB6B4"},
    {"\uB6B5", "\uB6B5"}, {"\uB6B6", "\uB6B6"}, {"\uB6B7", "\uB6B7"}, {"\uB6B8", "\uB6B8"}, {"\uB6B9", "\uB6B9"},
    {"\uB6BA", "\uB6BA"}, {"\uB6BB", "\uB6BB"}, {"\uB6BC", "\uB6BC"}, {"\uB6BD", "\uB6BD"}, {"\uB6BE", "\uB6BE"},
    {"\uB6BF", "\uB6BF"}, {"\uB6C0", "\uB6C0"}, {"\uB6C1", "\uB6C1"}, {"\uB6C2", "\uB6C2"}, {"\uB6C3", "\uB6C3"},
    {"\uB6C4", "\uB6C4"}, {"\uB6C5", "\uB6C5"}, {"\uB6C6", "\uB6C6"}, {"\uB6C7", "\uB6C7"}, {"\uB6C8", "\uB6C8"},
    {"\uB6C9", "\uB6C9"}, {"\uB6CA", "\uB6CA"}, {"\uB6CB", "\uB6CB"}, {"\uB6CC", "\uB6CC"}, {"\uB6CD", "\uB6CD"},
    {"\uB6CE", "\uB6CE"}, {"\uB6CF", "\uB6CF"}, {"\uB6D0", "\uB6D0"}, {"\uB6D1", "\uB6D1"}, {"\uB6D2", "\uB6D2"},
    {"\uB6D3", "\uB6D3"}, {"\uB6D4", "\uB6D4"}, {"\uB6D5", "\uB6D5"}, {"\uB6D6", "\uB6D6"}, {"\uB6D7", "\uB6D7"},
    {"\uB6D8", "\uB6D8"}, {"\uB6D9", "\uB6D9"}, {"\uB6DA", "\uB6DA"}, {"\uB6DB", "\uB6DB"}, {"\uB6DC", "\uB6DC"},
    {"\uB6DD", "\uB6DD"}, {"\uB6DE", "\uB6DE"}, {"\uB6DF", "\uB6DF"}, {"\uB6E0", "\uB6E0"}, {"\uB6E1", "\uB6E1"},
    {"\uB6E2", "\uB6E2"}, {"\uB6E3", "\uB6E3"}, {"\uB6E4", "\uB6E4"}, {"\uB6E5", "\uB6E5"}, {"\uB6E6", "\uB6E6"},
    {"\uB6E7", "\uB6E7"}, {"\uB6E8", "\uB6E8"}, {"\uB6E9", "\uB6E9"}, {"\uB6EA", "\uB6EA"}, {"\uB6EB", "\uB6EB"},
    {"\uB6EC", "\uB6EC"}, {"\uB6ED", "\uB6ED"}, {"\uB6EE", "\uB6EE"}, {"\uB6EF", "\uB6EF"}, {"\uB6F0", "\uB6F0"},
    {"\uB6F1", "\uB6F1"}, {"\uB6F2", "\uB6F2"}, {"\uB6F3", "\uB6F3"}, {"\uB6F4", "\uB6F4"}, {"\uB6F5", "\uB6F5"},
    {"\uB6F6", "\uB6F6"}, {"\uB6F7", "\uB6F7"}, {"\uB6F8", "\uB6F8"}, {"\uB6F9", "\uB6F9"}, {"\uB6FA", "\uB6FA"},
    {"\uB6FB", "\uB6FB"}, {"\uB6FC", "\uB6FC"}, {"\uB6FD", "\uB6FD"}, {"\uB6FE", "\uB6FE"}, {"\uB6FF", "\uB6FF"},
    {"\uB700", "\uB700"}, {"\uB701", "\uB701"}, {"\uB702", "\uB702"}, {"\uB703", "\uB703"}, {"\uB704", "\uB704"},
    {"\uB705", "\uB705"}, {"\uB706", "\uB706"}, {"\uB707", "\uB707"}, {"\uB708", "\uB708"}, {"\uB709", "\uB709"},
    {"\uB70A", "\uB70A"}, {"\uB70B", "\uB70B"}, {"\uB70C", "\uB70C"}, {"\uB70D", "\uB70D"}, {"\uB70E", "\uB70E"},
    {"\uB70F", "\uB70F"}, {"\uB710", "\uB710"}, {"\uB711", "\uB711"}, {"\uB712", "\uB712"}, {"\uB713", "\uB713"},
    {"\uB714", "\uB714"}, {"\uB715", "\uB715"}, {"\uB716", "\uB716"}, {"\uB717", "\uB717"}, {"\uB718", "\uB718"},
    {"\uB719", "\uB719"}, {"\uB71A", "\uB71A"}, {"\uB71B", "\uB71B"}, {"\uB71C", "\uB71C"}, {"\uB71D", "\uB71D"},
    {"\uB71E", "\uB71E"}, {"\uB71F", "\uB71F"}, {"\uB720", "\uB720"}, {"\uB721", "\uB721"}, {"\uB722", "\uB722"},
    {"\uB723", "\uB723"}, {"\uB724", "\uB724"}, {"\uB725", "\uB725"}, {"\uB726", "\uB726"}, {"\uB727", "\uB727"},
    {"\uB728", "\uB728"}, {"\uB729", "\uB729"}, {"\uB72A", "\uB72A"}, {"\uB72B", "\uB72B"}, {"\uB72C", "\uB72C"},
    {"\uB72D", "\uB72D"}, {"\uB72E", "\uB72E"}, {"\uB72F", "\uB72F"}, {"\uB730", "\uB730"}, {"\uB731", "\uB731"},
    {"\uB732", "\uB732"}, {"\uB733", "\uB733"}, {"\uB734", "\uB734"}, {"\uB735", "\uB735"}, {"\uB736", "\uB736"},
    {"\uB737", "\uB737"}, {"\uB738", "\uB738"}, {"\uB739", "\uB739"}, {"\uB73A", "\uB73A"}, {"\uB73B", "\uB73B"},
    {"\uB73C", "\uB73C"}, {"\uB73D", "\uB73D"}, {"\uB73E", "\uB73E"}, {"\uB73F", "\uB73F"}, {"\uB740", "\uB740"},
    {"\uB741", "\uB741"}, {"\uB742", "\uB742"}, {"\uB743", "\uB743"}, {"\uB744", "\uB744"}, {"\uB745", "\uB745"},
    {"\uB746", "\uB746"}, {"\uB747", "\uB747"}, {"\uB748", "\uB748"}, {"\uB749", "\uB749"}, {"\uB74A", "\uB74A"},
    {"\uB74B", "\uB74B"}, {"\uB74C", "\uB74C"}, {"\uB74D", "\uB74D"}, {"\uB74E", "\uB74E"}, {"\uB74F", "\uB74F"},
    {"\uB750", "\uB750"}, {"\uB751", "\uB751"}, {"\uB752", "\uB752"}, {"\uB753", "\uB753"}, {"\uB754", "\uB754"},
    {"\uB755", "\uB755"}, {"\uB756", "\uB756"}, {"\uB757", "\uB757"}, {"\uB758", "\uB758"}, {"\uB759", "\uB759"},
    {"\uB75A", "\uB75A"}, {"\uB75B", "\uB75B"}, {"\uB75C", "\uB75C"}, {"\uB75D", "\uB75D"}, {"\uB75E", "\uB75E"},
    {"\uB75F", "\uB75F"}, {"\uB760", "\uB760"}, {"\uB761", "\uB761"}, {"\uB762", "\uB762"}, {"\uB763", "\uB763"},
    {"\uB764", "\uB764"}, {"\uB765", "\uB765"}, {"\uB766", "\uB766"}, {"\uB767", "\uB767"}, {"\uB768", "\uB768"},
    {"\uB769", "\uB769"}, {"\uB76A", "\uB76A"}, {"\uB76B", "\uB76B"}, {"\uB76C", "\uB76C"}, {"\uB76D", "\uB76D"},
    {"\uB76E", "\uB76E"}, {"\uB76F", "\uB76F"}, {"\uB770", "\uB770"}, {"\uB771", "\uB771"}, {"\uB772", "\uB772"},
    {"\uB773", "\uB773"}, {"\uB774", "\uB774"}, {"\uB775", "\uB775"}, {"\uB776", "\uB776"}, {"\uB777", "\uB777"},
    {"\uB778", "\uB778"}, {"\uB779", "\uB779"}, {"\uB77A", "\uB77A"}, {"\uB77B", "\uB77B"}, {"\uB77C", "\uB77C"},
    {"\uB77D", "\uB77D"}, {"\uB77E", "\uB77E"}, {"\uB77F", "\uB77F"}, {"\uB780", "\uB780"}, {"\uB781", "\uB781"},
    {"\uB782", "\uB782"}, {"\uB783", "\uB783"}, {"\uB784", "\uB784"}, {"\uB785", "\uB785"}, {"\uB786", "\uB786"},
    {"\uB787", "\uB787"}, {"\uB788", "\uB788"}, {"\uB789", "\uB789"}, {"\uB78A", "\uB78A"}, {"\uB78B", "\uB78B"},
    {"\uB78C", "\uB78C"}, {"\uB78D", "\uB78D"}, {"\uB78E", "\uB78E"}, {"\uB78F", "\uB78F"}, {"\uB790", "\uB790"},
    {"\uB791", "\uB791"}, {"\uB792", "\uB792"}, {"\uB793", "\uB793"}, {"\uB794", "\uB794"}, {"\uB795", "\uB795"},
    {"\uB796", "\uB796"}, {"\uB797", "\uB797"}, {"\uB798", "\uB798"}, {"\uB799", "\uB799"}, {"\uB79A", "\uB79A"},
    {"\uB79B", "\uB79B"}, {"\uB79C", "\uB79C"}, {"\uB79D", "\uB79D"}, {"\uB79E", "\uB79E"}, {"\uB79F", "\uB79F"},
    {"\uB7A0", "\uB7A0"}, {"\uB7A1", "\uB7A1"}, {"\uB7A2", "\uB7A2"}, {"\uB7A3", "\uB7A3"}, {"\uB7A4", "\uB7A4"},
    {"\uB7A5", "\uB7A5"}, {"\uB7A6", "\uB7A6"}, {"\uB7A7", "\uB7A7"}, {"\uB7A8", "\uB7A8"}, {"\uB7A9", "\uB7A9"},
    {"\uB7AA", "\uB7AA"}, {"\uB7AB", "\uB7AB"}, {"\uB7AC", "\uB7AC"}, {"\uB7AD", "\uB7AD"}, {"\uB7AE", "\uB7AE"},
    {"\uB7AF", "\uB7AF"}, {"\uB7B0", "\uB7B0"}, {"\uB7B1", "\uB7B1"}, {"\uB7B2", "\uB7B2"}, {"\uB7B3", "\uB7B3"},
    {"\uB7B4", "\uB7B4"}, {"\uB7B5", "\uB7B5"}, {"\uB7B6", "\uB7B6"}, {"\uB7B7", "\uB7B7"}, {"\uB7B8", "\uB7B8"},
    {"\uB7B9", "\uB7B9"}, {"\uB7BA", "\uB7BA"}, {"\uB7BB", "\uB7BB"}, {"\uB7BC", "\uB7BC"}, {"\uB7BD", "\uB7BD"},
    {"\uB7BE", "\uB7BE"}, {"\uB7BF", "\uB7BF"}, {"\uB7C0", "\uB7C0"}, {"\uB7C1", "\uB7C1"}, {"\uB7C2", "\uB7C2"},
    {"\uB7C3", "\uB7C3"}, {"\uB7C4", "\uB7C4"}, {"\uB7C5", "\uB7C5"}, {"\uB7C6", "\uB7C6"}, {"\uB7C7", "\uB7C7"},
    {"\uB7C8", "\uB7C8"}, {"\uB7C9", "\uB7C9"}, {"\uB7CA", "\uB7CA"}, {"\uB7CB", "\uB7CB"}, {"\uB7CC", "\uB7CC"},
    {"\uB7CD", "\uB7CD"}, {"\uB7CE", "\uB7CE"}, {"\uB7CF", "\uB7CF"}, {"\uB7D0", "\uB7D0"}, {"\uB7D1", "\uB7D1"},
    {"\uB7D2", "\uB7D2"}, {"\uB7D3", "\uB7D3"}, {"\uB7D4", "\uB7D4"}, {"\uB7D5", "\uB7D5"}, {"\uB7D6", "\uB7D6"},
    {"\uB7D7", "\uB7D7"}, {"\uB7D8", "\uB7D8"}, {"\uB7D9", "\uB7D9"}, {"\uB7DA", "\uB7DA"}, {"\uB7DB", "\uB7DB"},
    {"\uB7DC", "\uB7DC"}, {"\uB7DD", "\uB7DD"}, {"\uB7DE", "\uB7DE"}, {"\uB7DF", "\uB7DF"}, {"\uB7E0", "\uB7E0"},
    {"\uB7E1", "\uB7E1"}, {"\uB7E2", "\uB7E2"}, {"\uB7E3", "\uB7E3"}, {"\uB7E4", "\uB7E4"}, {"\uB7E5", "\uB7E5"},
    {"\uB7E6", "\uB7E6"}, {"\uB7E7", "\uB7E7"}, {"\uB7E8", "\uB7E8"}, {"\uB7E9", "\uB7E9"}, {"\uB7EA", "\uB7EA"},
    {"\uB7EB", "\uB7EB"}, {"\uB7EC", "\uB7EC"}, {"\uB7ED", "\uB7ED"}, {"\uB7EE", "\uB7EE"}, {"\uB7EF", "\uB7EF"},
    {"\uB7F0", "\uB7F0"}, {"\uB7F1", "\uB7F1"}, {"\uB7F2", "\uB7F2"}, {"\uB7F3", "\uB7F3"}, {"\uB7F4", "\uB7F4"},
    {"\uB7F5", "\uB7F5"}, {"\uB7F6", "\uB7F6"}, {"\uB7F7", "\uB7F7"}, {"\uB7F8", "\uB7F8"}, {"\uB7F9", "\uB7F9"},
    {"\uB7FA", "\uB7FA"}, {"\uB7FB", "\uB7FB"}, {"\uB7FC", "\uB7FC"}, {"\uB7FD", "\uB7FD"}, {"\uB7FE", "\uB7FE"},
    {"\uB7FF", "\uB7FF"}, {"\uB800", "\uB800"}, {"\uB801", "\uB801"}, {"\uB802", "\uB802"}, {"\uB803", "\uB803"},
    {"\uB804", "\uB804"}, {"\uB805", "\uB805"}, {"\uB806", "\uB806"}, {"\uB807", "\uB807"}, {"\uB808", "\uB808"},
    {"\uB809", "\uB809"}, {"\uB80A", "\uB80A"}, {"\uB80B", "\uB80B"}, {"\uB80C", "\uB80C"}, {"\uB80D", "\uB80D"},
    {"\uB80E", "\uB80E"}, {"\uB80F", "\uB80F"}, {"\uB810", "\uB810"}, {"\uB811", "\uB811"}, {"\uB812", "\uB812"},
    {"\uB813", "\uB813"}, {"\uB814", "\uB814"}, {"\uB815", "\uB815"}, {"\uB816", "\uB816"}, {"\uB817", "\uB817"},
    {"\uB818", "\uB818"}, {"\uB819", "\uB819"}, {"\uB81A", "\uB81A"}, {"\uB81B", "\uB81B"}, {"\uB81C", "\uB81C"},
    {"\uB81D", "\uB81D"}, {"\uB81E", "\uB81E"}, {"\uB81F", "\uB81F"}, {"\uB820", "\uB820"}, {"\uB821", "\uB821"},
    {"\uB822", "\uB822"}, {"\uB823", "\uB823"}, {"\uB824", "\uB824"}, {"\uB825", "\uB825"}, {"\uB826", "\uB826"},
    {"\uB827", "\uB827"}, {"\uB828", "\uB828"}, {"\uB829", "\uB829"}, {"\uB82A", "\uB82A"}, {"\uB82B", "\uB82B"},
    {"\uB82C", "\uB82C"}, {"\uB82D", "\uB82D"}, {"\uB82E", "\uB82E"}, {"\uB82F", "\uB82F"}, {"\uB830", "\uB830"},
    {"\uB831", "\uB831"}, {"\uB832", "\uB832"}, {"\uB833", "\uB833"}, {"\uB834", "\uB834"}, {"\uB835", "\uB835"},
    {"\uB836", "\uB836"}, {"\uB837", "\uB837"}, {"\uB838", "\uB838"}, {"\uB839", "\uB839"}, {"\uB83A", "\uB83A"},
    {"\uB83B", "\uB83B"}, {"\uB83C", "\uB83C"}, {"\uB83D", "\uB83D"}, {"\uB83E", "\uB83E"}, {"\uB83F", "\uB83F"},
    {"\uB840", "\uB840"}, {"\uB841", "\uB841"}, {"\uB842", "\uB842"}, {"\uB843", "\uB843"}, {"\uB844", "\uB844"},
    {"\uB845", "\uB845"}, {"\uB846", "\uB846"}, {"\uB847", "\uB847"}, {"\uB848", "\uB848"}, {"\uB849", "\uB849"},
    {"\uB84A", "\uB84A"}, {"\uB84B", "\uB84B"}, {"\uB84C", "\uB84C"}, {"\uB84D", "\uB84D"}, {"\uB84E", "\uB84E"},
    {"\uB84F", "\uB84F"}, {"\uB850", "\uB850"}, {"\uB851", "\uB851"}, {"\uB852", "\uB852"}, {"\uB853", "\uB853"},
    {"\uB854", "\uB854"}, {"\uB855", "\uB855"}, {"\uB856", "\uB856"}, {"\uB857", "\uB857"}, {"\uB858", "\uB858"},
    {"\uB859", "\uB859"}, {"\uB85A", "\uB85A"}, {"\uB85B", "\uB85B"}, {"\uB85C", "\uB85C"}, {"\uB85D", "\uB85D"},
    {"\uB85E", "\uB85E"}, {"\uB85F", "\uB85F"}, {"\uB860", "\uB860"}, {"\uB861", "\uB861"}, {"\uB862", "\uB862"},
    {"\uB863", "\uB863"}, {"\uB864", "\uB864"}, {"\uB865", "\uB865"}, {"\uB866", "\uB866"}, {"\uB867", "\uB867"},
    {"\uB868", "\uB868"}, {"\uB869", "\uB869"}, {"\uB86A", "\uB86A"}, {"\uB86B", "\uB86B"}, {"\uB86C", "\uB86C"},
    {"\uB86D", "\uB86D"}, {"\uB86E", "\uB86E"}, {"\uB86F", "\uB86F"}, {"\uB870", "\uB870"}, {"\uB871", "\uB871"},
    {"\uB872", "\uB872"}, {"\uB873", "\uB873"}, {"\uB874", "\uB874"}, {"\uB875", "\uB875"}, {"\uB876", "\uB876"},
    {"\uB877", "\uB877"}, {"\uB878", "\uB878"}, {"\uB879", "\uB879"}, {"\uB87A", "\uB87A"}, {"\uB87B", "\uB87B"},
    {"\uB87C", "\uB87C"}, {"\uB87D", "\uB87D"}, {"\uB87E", "\uB87E"}, {"\uB87F", "\uB87F"}, {"\uB880", "\uB880"},
    {"\uB881", "\uB881"}, {"\uB882", "\uB882"}, {"\uB883", "\uB883"}, {"\uB884", "\uB884"}, {"\uB885", "\uB885"},
    {"\uB886", "\uB886"}, {"\uB887", "\uB887"}, {"\uB888", "\uB888"}, {"\uB889", "\uB889"}, {"\uB88A", "\uB88A"},
    {"\uB88B", "\uB88B"}, {"\uB88C", "\uB88C"}, {"\uB88D", "\uB88D"}, {"\uB88E", "\uB88E"}, {"\uB88F", "\uB88F"},
    {"\uB890", "\uB890"}, {"\uB891", "\uB891"}, {"\uB892", "\uB892"}, {"\uB893", "\uB893"}, {"\uB894", "\uB894"},
    {"\uB895", "\uB895"}, {"\uB896", "\uB896"}, {"\uB897", "\uB897"}, {"\uB898", "\uB898"}, {"\uB899", "\uB899"},
    {"\uB89A", "\uB89A"}, {"\uB89B", "\uB89B"}, {"\uB89C", "\uB89C"}, {"\uB89D", "\uB89D"}, {"\uB89E", "\uB89E"},
    {"\uB89F", "\uB89F"}, {"\uB8A0", "\uB8A0"}, {"\uB8A1", "\uB8A1"}, {"\uB8A2", "\uB8A2"}, {"\uB8A3", "\uB8A3"},
    {"\uB8A4", "\uB8A4"}, {"\uB8A5", "\uB8A5"}, {"\uB8A6", "\uB8A6"}, {"\uB8A7", "\uB8A7"}, {"\uB8A8", "\uB8A8"},
    {"\uB8A9", "\uB8A9"}, {"\uB8AA", "\uB8AA"}, {"\uB8AB", "\uB8AB"}, {"\uB8AC", "\uB8AC"}, {"\uB8AD", "\uB8AD"},
    {"\uB8AE", "\uB8AE"}, {"\uB8AF", "\uB8AF"}, {"\uB8B0", "\uB8B0"}, {"\uB8B1", "\uB8B1"}, {"\uB8B2", "\uB8B2"},
    {"\uB8B3", "\uB8B3"}, {"\uB8B4", "\uB8B4"}, {"\uB8B5", "\uB8B5"}, {"\uB8B6", "\uB8B6"}, {"\uB8B7", "\uB8B7"},
    {"\uB8B8", "\uB8B8"}, {"\uB8B9", "\uB8B9"}, {"\uB8BA", "\uB8BA"}, {"\uB8BB", "\uB8BB"}, {"\uB8BC", "\uB8BC"},
    {"\uB8BD", "\uB8BD"}, {"\uB8BE", "\uB8BE"}, {"\uB8BF", "\uB8BF"}, {"\uB8C0", "\uB8C0"}, {"\uB8C1", "\uB8C1"},
    {"\uB8C2", "\uB8C2"}, {"\uB8C3", "\uB8C3"}, {"\uB8C4", "\uB8C4"}, {"\uB8C5", "\uB8C5"}, {"\uB8C6", "\uB8C6"},
    {"\uB8C7", "\uB8C7"}, {"\uB8C8", "\uB8C8"}, {"\uB8C9", "\uB8C9"}, {"\uB8CA", "\uB8CA"}, {"\uB8CB", "\uB8CB"},
    {"\uB8CC", "\uB8CC"}, {"\uB8CD", "\uB8CD"}, {"\uB8CE", "\uB8CE"}, {"\uB8CF", "\uB8CF"}, {"\uB8D0", "\uB8D0"},
    {"\uB8D1", "\uB8D1"}, {"\uB8D2", "\uB8D2"}, {"\uB8D3", "\uB8D3"}, {"\uB8D4", "\uB8D4"}, {"\uB8D5", "\uB8D5"},
    {"\uB8D6", "\uB8D6"}, {"\uB8D7", "\uB8D7"}, {"\uB8D8", "\uB8D8"}, {"\uB8D9", "\uB8D9"}, {"\uB8DA", "\uB8DA"},
    {"\uB8DB", "\uB8DB"}, {"\uB8DC", "\uB8DC"}, {"\uB8DD", "\uB8DD"}, {"\uB8DE", "\uB8DE"}, {"\uB8DF", "\uB8DF"},
    {"\uB8E0", "\uB8E0"}, {"\uB8E1", "\uB8E1"}, {"\uB8E2", "\uB8E2"}, {"\uB8E3", "\uB8E3"}, {"\uB8E4", "\uB8E4"},
    {"\uB8E5", "\uB8E5"}, {"\uB8E6", "\uB8E6"}, {"\uB8E7", "\uB8E7"}, {"\uB8E8", "\uB8E8"}, {"\uB8E9", "\uB8E9"},
    {"\uB8EA", "\uB8EA"}, {"\uB8EB", "\uB8EB"}, {"\uB8EC", "\uB8EC"}, {"\uB8ED", "\uB8ED"}, {"\uB8EE", "\uB8EE"},
    {"\uB8EF", "\uB8EF"}, {"\uB8F0", "\uB8F0"}, {"\uB8F1", "\uB8F1"}, {"\uB8F2", "\uB8F2"}, {"\uB8F3", "\uB8F3"},
    {"\uB8F4", "\uB8F4"}, {"\uB8F5", "\uB8F5"}, {"\uB8F6", "\uB8F6"}, {"\uB8F7", "\uB8F7"}, {"\uB8F8", "\uB8F8"},
    {"\uB8F9", "\uB8F9"}, {"\uB8FA", "\uB8FA"}, {"\uB8FB", "\uB8FB"}, {"\uB8FC", "\uB8FC"}, {"\uB8FD", "\uB8FD"},
    {"\uB8FE", "\uB8FE"}, {"\uB8FF", "\uB8FF"}, {"\uB900", "\uB900"}, {"\uB901", "\uB901"}, {"\uB902", "\uB902"},
    {"\uB903", "\uB903"}, {"\uB904", "\uB904"}, {"\uB905", "\uB905"}, {"\uB906", "\uB906"}, {"\uB907", "\uB907"},
    {"\uB908", "\uB908"}, {"\uB909", "\uB909"}, {"\uB90A", "\uB90A"}, {"\uB90B", "\uB90B"}, {"\uB90C", "\uB90C"},
    {"\uB90D", "\uB90D"}, {"\uB90E", "\uB90E"}, {"\uB90F", "\uB90F"}, {"\uB910", "\uB910"}, {"\uB911", "\uB911"},
    {"\uB912", "\uB912"}, {"\uB913", "\uB913"}, {"\uB914", "\uB914"}, {"\uB915", "\uB915"}, {"\uB916", "\uB916"},
    {"\uB917", "\uB917"}, {"\uB918", "\uB918"}, {"\uB919", "\uB919"}, {"\uB91A", "\uB91A"}, {"\uB91B", "\uB91B"},
    {"\uB91C", "\uB91C"}, {"\uB91D", "\uB91D"}, {"\uB91E", "\uB91E"}, {"\uB91F", "\uB91F"}, {"\uB920", "\uB920"},
    {"\uB921", "\uB921"}, {"\uB922", "\uB922"}, {"\uB923", "\uB923"}, {"\uB924", "\uB924"}, {"\uB925", "\uB925"},
    {"\uB926", "\uB926"}, {"\uB927", "\uB927"}, {"\uB928", "\uB928"}, {"\uB929", "\uB929"}, {"\uB92A", "\uB92A"},
    {"\uB92B", "\uB92B"}, {"\uB92C", "\uB92C"}, {"\uB92D", "\uB92D"}, {"\uB92E", "\uB92E"}, {"\uB92F", "\uB92F"},
    {"\uB930", "\uB930"}, {"\uB931", "\uB931"}, {"\uB932", "\uB932"}, {"\uB933", "\uB933"}, {"\uB934", "\uB934"},
    {"\uB935", "\uB935"}, {"\uB936", "\uB936"}, {"\uB937", "\uB937"}, {"\uB938", "\uB938"}, {"\uB939", "\uB939"},
    {"\uB93A", "\uB93A"}, {"\uB93B", "\uB93B"}, {"\uB93C", "\uB93C"}, {"\uB93D", "\uB93D"}, {"\uB93E", "\uB93E"},
    {"\uB93F", "\uB93F"}, {"\uB940", "\uB940"}, {"\uB941", "\uB941"}, {"\uB942", "\uB942"}, {"\uB943", "\uB943"},
    {"\uB944", "\uB944"}, {"\uB945", "\uB945"}, {"\uB946", "\uB946"}, {"\uB947", "\uB947"}, {"\uB948", "\uB948"},
    {"\uB949", "\uB949"}, {"\uB94A", "\uB94A"}, {"\uB94B", "\uB94B"}, {"\uB94C", "\uB94C"}, {"\uB94D", "\uB94D"},
    {"\uB94E", "\uB94E"}, {"\uB94F", "\uB94F"}, {"\uB950", "\uB950"}, {"\uB951", "\uB951"}, {"\uB952", "\uB952"},
    {"\uB953", "\uB953"}, {"\uB954", "\uB954"}, {"\uB955", "\uB955"}, {"\uB956", "\uB956"}, {"\uB957", "\uB957"},
    {"\uB958", "\uB958"}, {"\uB959", "\uB959"}, {"\uB95A", "\uB95A"}, {"\uB95B", "\uB95B"}, {"\uB95C", "\uB95C"},
    {"\uB95D", "\uB95D"}, {"\uB95E", "\uB95E"}, {"\uB95F", "\uB95F"}, {"\uB960", "\uB960"}, {"\uB961", "\uB961"},
    {"\uB962", "\uB962"}, {"\uB963", "\uB963"}, {"\uB964", "\uB964"}, {"\uB965", "\uB965"}, {"\uB966", "\uB966"},
    {"\uB967", "\uB967"}, {"\uB968", "\uB968"}, {"\uB969", "\uB969"}, {"\uB96A", "\uB96A"}, {"\uB96B", "\uB96B"},
    {"\uB96C", "\uB96C"}, {"\uB96D", "\uB96D"}, {"\uB96E", "\uB96E"}, {"\uB96F", "\uB96F"}, {"\uB970", "\uB970"},
    {"\uB971", "\uB971"}, {"\uB972", "\uB972"}, {"\uB973", "\uB973"}, {"\uB974", "\uB974"}, {"\uB975", "\uB975"},
    {"\uB976", "\uB976"}, {"\uB977", "\uB977"}, {"\uB978", "\uB978"}, {"\uB979", "\uB979"}, {"\uB97A", "\uB97A"},
    {"\uB97B", "\uB97B"}, {"\uB97C", "\uB97C"}, {"\uB97D", "\uB97D"}, {"\uB97E", "\uB97E"}, {"\uB97F", "\uB97F"},
    {"\uB980", "\uB980"}, {"\uB981", "\uB981"}, {"\uB982", "\uB982"}, {"\uB983", "\uB983"}, {"\uB984", "\uB984"},
    {"\uB985", "\uB985"}, {"\uB986", "\uB986"}, {"\uB987", "\uB987"}, {"\uB988", "\uB988"}, {"\uB989", "\uB989"},
    {"\uB98A", "\uB98A"}, {"\uB98B", "\uB98B"}, {"\uB98C", "\uB98C"}, {"\uB98D", "\uB98D"}, {"\uB98E", "\uB98E"},
    {"\uB98F", "\uB98F"}, {"\uB990", "\uB990"}, {"\uB991", "\uB991"}, {"\uB992", "\uB992"}, {"\uB993", "\uB993"},
    {"\uB994", "\uB994"}, {"\uB995", "\uB995"}, {"\uB996", "\uB996"}, {"\uB997", "\uB997"}, {"\uB998", "\uB998"},
    {"\uB999", "\uB999"}, {"\uB99A", "\uB99A"}, {"\uB99B", "\uB99B"}, {"\uB99C", "\uB99C"}, {"\uB99D", "\uB99D"},
    {"\uB99E", "\uB99E"}, {"\uB99F", "\uB99F"}, {"\uB9A0", "\uB9A0"}, {"\uB9A1", "\uB9A1"}, {"\uB9A2", "\uB9A2"},
    {"\uB9A3", "\uB9A3"}, {"\uB9A4", "\uB9A4"}, {"\uB9A5", "\uB9A5"}, {"\uB9A6", "\uB9A6"}, {"\uB9A7", "\uB9A7"},
    {"\uB9A8", "\uB9A8"}, {"\uB9A9", "\uB9A9"}, {"\uB9AA", "\uB9AA"}, {"\uB9AB", "\uB9AB"}, {"\uB9AC", "\uB9AC"},
    {"\uB9AD", "\uB9AD"}, {"\uB9AE", "\uB9AE"}, {"\uB9AF", "\uB9AF"}, {"\uB9B0", "\uB9B0"}, {"\uB9B1", "\uB9B1"},
    {"\uB9B2", "\uB9B2"}, {"\uB9B3", "\uB9B3"}, {"\uB9B4", "\uB9B4"}, {"\uB9B5", "\uB9B5"}, {"\uB9B6", "\uB9B6"},
    {"\uB9B7", "\uB9B7"}, {"\uB9B8", "\uB9B8"}, {"\uB9B9", "\uB9B9"}, {"\uB9BA", "\uB9BA"}, {"\uB9BB", "\uB9BB"},
    {"\uB9BC", "\uB9BC"}, {"\uB9BD", "\uB9BD"}, {"\uB9BE", "\uB9BE"}, {"\uB9BF", "\uB9BF"}, {"\uB9C0", "\uB9C0"},
    {"\uB9C1", "\uB9C1"}, {"\uB9C2", "\uB9C2"}, {"\uB9C3", "\uB9C3"}, {"\uB9C4", "\uB9C4"}, {"\uB9C5", "\uB9C5"},
    {"\uB9C6", "\uB9C6"}, {"\uB9C7", "\uB9C7"}, {"\uB9C8", "\uB9C8"}, {"\uB9C9", "\uB9C9"}, {"\uB9CA", "\uB9CA"},
    {"\uB9CB", "\uB9CB"}, {"\uB9CC", "\uB9CC"}, {"\uB9CD", "\uB9CD"}, {"\uB9CE", "\uB9CE"}, {"\uB9CF", "\uB9CF"},
    {"\uB9D0", "\uB9D0"}, {"\uB9D1", "\uB9D1"}, {"\uB9D2", "\uB9D2"}, {"\uB9D3", "\uB9D3"}, {"\uB9D4", "\uB9D4"},
    {"\uB9D5", "\uB9D5"}, {"\uB9D6", "\uB9D6"}, {"\uB9D7", "\uB9D7"}, {"\uB9D8", "\uB9D8"}, {"\uB9D9", "\uB9D9"},
    {"\uB9DA", "\uB9DA"}, {"\uB9DB", "\uB9DB"}, {"\uB9DC", "\uB9DC"}, {"\uB9DD", "\uB9DD"}, {"\uB9DE", "\uB9DE"},
    {"\uB9DF", "\uB9DF"}, {"\uB9E0", "\uB9E0"}, {"\uB9E1", "\uB9E1"}, {"\uB9E2", "\uB9E2"}, {"\uB9E3", "\uB9E3"},
    {"\uB9E4", "\uB9E4"}, {"\uB9E5", "\uB9E5"}, {"\uB9E6", "\uB9E6"}, {"\uB9E7", "\uB9E7"}, {"\uB9E8", "\uB9E8"},
    {"\uB9E9", "\uB9E9"}, {"\uB9EA", "\uB9EA"}, {"\uB9EB", "\uB9EB"}, {"\uB9EC", "\uB9EC"}, {"\uB9ED", "\uB9ED"},
    {"\uB9EE", "\uB9EE"}, {"\uB9EF", "\uB9EF"}, {"\uB9F0", "\uB9F0"}, {"\uB9F1", "\uB9F1"}, {"\uB9F2", "\uB9F2"},
    {"\uB9F3", "\uB9F3"}, {"\uB9F4", "\uB9F4"}, {"\uB9F5", "\uB9F5"}, {"\uB9F6", "\uB9F6"}, {"\uB9F7", "\uB9F7"},
    {"\uB9F8", "\uB9F8"}, {"\uB9F9", "\uB9F9"}, {"\uB9FA", "\uB9FA"}, {"\uB9FB", "\uB9FB"}, {"\uB9FC", "\uB9FC"},
    {"\uB9FD", "\uB9FD"}, {"\uB9FE", "\uB9FE"}, {"\uB9FF", "\uB9FF"}, {"\uBA00", "\uBA00"}, {"\uBA01", "\uBA01"},
    {"\uBA02", "\uBA02"}, {"\uBA03", "\uBA03"}, {"\uBA04", "\uBA04"}, {"\uBA05", "\uBA05"}, {"\uBA06", "\uBA06"},
    {"\uBA07", "\uBA07"}, {"\uBA08", "\uBA08"}, {"\uBA09", "\uBA09"}, {"\uBA0A", "\uBA0A"}, {"\uBA0B", "\uBA0B"},
    {"\uBA0C", "\uBA0C"}, {"\uBA0D", "\uBA0D"}, {"\uBA0E", "\uBA0E"}, {"\uBA0F", "\uBA0F"}, {"\uBA10", "\uBA10"},
    {"\uBA11", "\uBA11"}, {"\uBA12", "\uBA12"}, {"\uBA13", "\uBA13"}, {"\uBA14", "\uBA14"}, {"\uBA15", "\uBA15"},
    {"\uBA16", "\uBA16"}, {"\uBA17", "\uBA17"}, {"\uBA18", "\uBA18"}, {"\uBA19", "\uBA19"}, {"\uBA1A", "\uBA1A"},
    {"\uBA1B", "\uBA1B"}, {"\uBA1C", "\uBA1C"}, {"\uBA1D", "\uBA1D"}, {"\uBA1E", "\uBA1E"}, {"\uBA1F", "\uBA1F"},
    {"\uBA20", "\uBA20"}, {"\uBA21", "\uBA21"}, {"\uBA22", "\uBA22"}, {"\uBA23", "\uBA23"}, {"\uBA24", "\uBA24"},
    {"\uBA25", "\uBA25"}, {"\uBA26", "\uBA26"}, {"\uBA27", "\uBA27"}, {"\uBA28", "\uBA28"}, {"\uBA29", "\uBA29"},
    {"\uBA2A", "\uBA2A"}, {"\uBA2B", "\uBA2B"}, {"\uBA2C", "\uBA2C"}, {"\uBA2D", "\uBA2D"}, {"\uBA2E", "\uBA2E"},
    {"\uBA2F", "\uBA2F"}, {"\uBA30", "\uBA30"}, {"\uBA31", "\uBA31"}, {"\uBA32", "\uBA32"}, {"\uBA33", "\uBA33"},
    {"\uBA34", "\uBA34"}, {"\uBA35", "\uBA35"}, {"\uBA36", "\uBA36"}, {"\uBA37", "\uBA37"}, {"\uBA38", "\uBA38"},
    {"\uBA39", "\uBA39"}, {"\uBA3A", "\uBA3A"}, {"\uBA3B", "\uBA3B"}, {"\uBA3C", "\uBA3C"}, {"\uBA3D", "\uBA3D"},
    {"\uBA3E", "\uBA3E"}, {"\uBA3F", "\uBA3F"}, {"\uBA40", "\uBA40"}, {"\uBA41", "\uBA41"}, {"\uBA42", "\uBA42"},
    {"\uBA43", "\uBA43"}, {"\uBA44", "\uBA44"}, {"\uBA45", "\uBA45"}, {"\uBA46", "\uBA46"}, {"\uBA47", "\uBA47"},
    {"\uBA48", "\uBA48"}, {"\uBA49", "\uBA49"}, {"\uBA4A", "\uBA4A"}, {"\uBA4B", "\uBA4B"}, {"\uBA4C", "\uBA4C"},
    {"\uBA4D", "\uBA4D"}, {"\uBA4E", "\uBA4E"}, {"\uBA4F", "\uBA4F"}, {"\uBA50", "\uBA50"}, {"\uBA51", "\uBA51"},
    {"\uBA52", "\uBA52"}, {"\uBA53", "\uBA53"}, {"\uBA54", "\uBA54"}, {"\uBA55", "\uBA55"}, {"\uBA56", "\uBA56"},
    {"\uBA57", "\uBA57"}, {"\uBA58", "\uBA58"}, {"\uBA59", "\uBA59"}, {"\uBA5A", "\uBA5A"}, {"\uBA5B", "\uBA5B"},
    {"\uBA5C", "\uBA5C"}, {"\uBA5D", "\uBA5D"}, {"\uBA5E", "\uBA5E"}, {"\uBA5F", "\uBA5F"}, {"\uBA60", "\uBA60"},
    {"\uBA61", "\uBA61"}, {"\uBA62", "\uBA62"}, {"\uBA63", "\uBA63"}, {"\uBA64", "\uBA64"}, {"\uBA65", "\uBA65"},
    {"\uBA66", "\uBA66"}, {"\uBA67", "\uBA67"}, {"\uBA68", "\uBA68"}, {"\uBA69", "\uBA69"}, {"\uBA6A", "\uBA6A"},
    {"\uBA6B", "\uBA6B"}, {"\uBA6C", "\uBA6C"}, {"\uBA6D", "\uBA6D"}, {"\uBA6E", "\uBA6E"}, {"\uBA6F", "\uBA6F"},
    {"\uBA70", "\uBA70"}, {"\uBA71", "\uBA71"}, {"\uBA72", "\uBA72"}, {"\uBA73", "\uBA73"}, {"\uBA74", "\uBA74"},
    {"\uBA75", "\uBA75"}, {"\uBA76", "\uBA76"}, {"\uBA77", "\uBA77"}, {"\uBA78", "\uBA78"}, {"\uBA79", "\uBA79"},
    {"\uBA7A", "\uBA7A"}, {"\uBA7B", "\uBA7B"}, {"\uBA7C", "\uBA7C"}, {"\uBA7D", "\uBA7D"}, {"\uBA7E", "\uBA7E"},
    {"\uBA7F", "\uBA7F"}, {"\uBA80", "\uBA80"}, {"\uBA81", "\uBA81"}, {"\uBA82", "\uBA82"}, {"\uBA83", "\uBA83"},
    {"\uBA84", "\uBA84"}, {"\uBA85", "\uBA85"}, {"\uBA86", "\uBA86"}, {"\uBA87", "\uBA87"}, {"\uBA88", "\uBA88"},
    {"\uBA89", "\uBA89"}, {"\uBA8A", "\uBA8A"}, {"\uBA8B", "\uBA8B"}, {"\uBA8C", "\uBA8C"}, {"\uBA8D", "\uBA8D"},
    {"\uBA8E", "\uBA8E"}, {"\uBA8F", "\uBA8F"}, {"\uBA90", "\uBA90"}, {"\uBA91", "\uBA91"}, {"\uBA92", "\uBA92"},
    {"\uBA93", "\uBA93"}, {"\uBA94", "\uBA94"}, {"\uBA95", "\uBA95"}, {"\uBA96", "\uBA96"}, {"\uBA97", "\uBA97"},
    {"\uBA98", "\uBA98"}, {"\uBA99", "\uBA99"}, {"\uBA9A", "\uBA9A"}, {"\uBA9B", "\uBA9B"}, {"\uBA9C", "\uBA9C"},
    {"\uBA9D", "\uBA9D"}, {"\uBA9E", "\uBA9E"}, {"\uBA9F", "\uBA9F"}, {"\uBAA0", "\uBAA0"}, {"\uBAA1", "\uBAA1"},
    {"\uBAA2", "\uBAA2"}, {"\uBAA3", "\uBAA3"}, {"\uBAA4", "\uBAA4"}, {"\uBAA5", "\uBAA5"}, {"\uBAA6", "\uBAA6"},
    {"\uBAA7", "\uBAA7"}, {"\uBAA8", "\uBAA8"}, {"\uBAA9", "\uBAA9"}, {"\uBAAA", "\uBAAA"}, {"\uBAAB", "\uBAAB"},
    {"\uBAAC", "\uBAAC"}, {"\uBAAD", "\uBAAD"}, {"\uBAAE", "\uBAAE"}, {"\uBAAF", "\uBAAF"}, {"\uBAB0", "\uBAB0"},
    {"\uBAB1", "\uBAB1"}, {"\uBAB2", "\uBAB2"}, {"\uBAB3", "\uBAB3"}, {"\uBAB4", "\uBAB4"}, {"\uBAB5", "\uBAB5"},
    {"\uBAB6", "\uBAB6"}, {"\uBAB7", "\uBAB7"}, {"\uBAB8", "\uBAB8"}, {"\uBAB9", "\uBAB9"}, {"\uBABA", "\uBABA"},
    {"\uBABB", "\uBABB"}, {"\uBABC", "\uBABC"}, {"\uBABD", "\uBABD"}, {"\uBABE", "\uBABE"}, {"\uBABF", "\uBABF"},
    {"\uBAC0", "\uBAC0"}, {"\uBAC1", "\uBAC1"}, {"\uBAC2", "\uBAC2"}, {"\uBAC3", "\uBAC3"}, {"\uBAC4", "\uBAC4"},
    {"\uBAC5", "\uBAC5"}, {"\uBAC6", "\uBAC6"}, {"\uBAC7", "\uBAC7"}, {"\uBAC8", "\uBAC8"}, {"\uBAC9", "\uBAC9"},
    {"\uBACA", "\uBACA"}, {"\uBACB", "\uBACB"}, {"\uBACC", "\uBACC"}, {"\uBACD", "\uBACD"}, {"\uBACE", "\uBACE"},
    {"\uBACF", "\uBACF"}, {"\uBAD0", "\uBAD0"}, {"\uBAD1", "\uBAD1"}, {"\uBAD2", "\uBAD2"}, {"\uBAD3", "\uBAD3"},
    {"\uBAD4", "\uBAD4"}, {"\uBAD5", "\uBAD5"}, {"\uBAD6", "\uBAD6"}, {"\uBAD7", "\uBAD7"}, {"\uBAD8", "\uBAD8"},
    {"\uBAD9", "\uBAD9"}, {"\uBADA", "\uBADA"}, {"\uBADB", "\uBADB"}, {"\uBADC", "\uBADC"}, {"\uBADD", "\uBADD"},
    {"\uBADE", "\uBADE"}, {"\uBADF", "\uBADF"}, {"\uBAE0", "\uBAE0"}, {"\uBAE1", "\uBAE1"}, {"\uBAE2", "\uBAE2"},
    {"\uBAE3", "\uBAE3"}, {"\uBAE4", "\uBAE4"}, {"\uBAE5", "\uBAE5"}, {"\uBAE6", "\uBAE6"}, {"\uBAE7", "\uBAE7"},
    {"\uBAE8", "\uBAE8"}, {"\uBAE9", "\uBAE9"}, {"\uBAEA", "\uBAEA"}, {"\uBAEB", "\uBAEB"}, {"\uBAEC", "\uBAEC"},
    {"\uBAED", "\uBAED"}, {"\uBAEE", "\uBAEE"}, {"\uBAEF", "\uBAEF"}, {"\uBAF0", "\uBAF0"}, {"\uBAF1", "\uBAF1"},
    {"\uBAF2", "\uBAF2"}, {"\uBAF3", "\uBAF3"}, {"\uBAF4", "\uBAF4"}, {"\uBAF5", "\uBAF5"}, {"\uBAF6", "\uBAF6"},
    {"\uBAF7", "\uBAF7"}, {"\uBAF8", "\uBAF8"}, {"\uBAF9", "\uBAF9"}, {"\uBAFA", "\uBAFA"}, {"\uBAFB", "\uBAFB"},
    {"\uBAFC", "\uBAFC"}, {"\uBAFD", "\uBAFD"}, {"\uBAFE", "\uBAFE"}, {"\uBAFF", "\uBAFF"}, {"\uBB00", "\uBB00"},
    {"\uBB01", "\uBB01"}, {"\uBB02", "\uBB02"}, {"\uBB03", "\uBB03"}, {"\uBB04", "\uBB04"}, {"\uBB05", "\uBB05"},
    {"\uBB06", "\uBB06"}, {"\uBB07", "\uBB07"}, {"\uBB08", "\uBB08"}, {"\uBB09", "\uBB09"}, {"\uBB0A", "\uBB0A"},
    {"\uBB0B", "\uBB0B"}, {"\uBB0C", "\uBB0C"}, {"\uBB0D", "\uBB0D"}, {"\uBB0E", "\uBB0E"}, {"\uBB0F", "\uBB0F"},
    {"\uBB10", "\uBB10"}, {"\uBB11", "\uBB11"}, {"\uBB12", "\uBB12"}, {"\uBB13", "\uBB13"}, {"\uBB14", "\uBB14"},
    {"\uBB15", "\uBB15"}, {"\uBB16", "\uBB16"}, {"\uBB17", "\uBB17"}, {"\uBB18", "\uBB18"}, {"\uBB19", "\uBB19"},
    {"\uBB1A", "\uBB1A"}, {"\uBB1B", "\uBB1B"}, {"\uBB1C", "\uBB1C"}, {"\uBB1D", "\uBB1D"}, {"\uBB1E", "\uBB1E"},
    {"\uBB1F", "\uBB1F"}, {"\uBB20", "\uBB20"}, {"\uBB21", "\uBB21"}, {"\uBB22", "\uBB22"}, {"\uBB23", "\uBB23"},
    {"\uBB24", "\uBB24"}, {"\uBB25", "\uBB25"}, {"\uBB26", "\uBB26"}, {"\uBB27", "\uBB27"}, {"\uBB28", "\uBB28"},
    {"\uBB29", "\uBB29"}, {"\uBB2A", "\uBB2A"}, {"\uBB2B", "\uBB2B"}, {"\uBB2C", "\uBB2C"}, {"\uBB2D", "\uBB2D"},
    {"\uBB2E", "\uBB2E"}, {"\uBB2F", "\uBB2F"}, {"\uBB30", "\uBB30"}, {"\uBB31", "\uBB31"}, {"\uBB32", "\uBB32"},
    {"\uBB33", "\uBB33"}, {"\uBB34", "\uBB34"}, {"\uBB35", "\uBB35"}, {"\uBB36", "\uBB36"}, {"\uBB37", "\uBB37"},
    {"\uBB38", "\uBB38"}, {"\uBB39", "\uBB39"}, {"\uBB3A", "\uBB3A"}, {"\uBB3B", "\uBB3B"}, {"\uBB3C", "\uBB3C"},
    {"\uBB3D", "\uBB3D"}, {"\uBB3E", "\uBB3E"}, {"\uBB3F", "\uBB3F"}, {"\uBB40", "\uBB40"}, {"\uBB41", "\uBB41"},
    {"\uBB42", "\uBB42"}, {"\uBB43", "\uBB43"}, {"\uBB44", "\uBB44"}, {"\uBB45", "\uBB45"}, {"\uBB46", "\uBB46"},
    {"\uBB47", "\uBB47"}, {"\uBB48", "\uBB48"}, {"\uBB49", "\uBB49"}, {"\uBB4A", "\uBB4A"}, {"\uBB4B", "\uBB4B"},
    {"\uBB4C", "\uBB4C"}, {"\uBB4D", "\uBB4D"}, {"\uBB4E", "\uBB4E"}, {"\uBB4F", "\uBB4F"}, {"\uBB50", "\uBB50"},
    {"\uBB51", "\uBB51"}, {"\uBB52", "\uBB52"}, {"\uBB53", "\uBB53"}, {"\uBB54", "\uBB54"}, {"\uBB55", "\uBB55"},
    {"\uBB56", "\uBB56"}, {"\uBB57", "\uBB57"}, {"\uBB58", "\uBB58"}, {"\uBB59", "\uBB59"}, {"\uBB5A", "\uBB5A"},
    {"\uBB5B", "\uBB5B"}, {"\uBB5C", "\uBB5C"}, {"\uBB5D", "\uBB5D"}, {"\uBB5E", "\uBB5E"}, {"\uBB5F", "\uBB5F"},
    {"\uBB60", "\uBB60"}, {"\uBB61", "\uBB61"}, {"\uBB62", "\uBB62"}, {"\uBB63", "\uBB63"}, {"\uBB64", "\uBB64"},
    {"\uBB65", "\uBB65"}, {"\uBB66", "\uBB66"}, {"\uBB67", "\uBB67"}, {"\uBB68", "\uBB68"}, {"\uBB69", "\uBB69"},
    {"\uBB6A", "\uBB6A"}, {"\uBB6B", "\uBB6B"}, {"\uBB6C", "\uBB6C"}, {"\uBB6D", "\uBB6D"}, {"\uBB6E", "\uBB6E"},
    {"\uBB6F", "\uBB6F"}, {"\uBB70", "\uBB70"}, {"\uBB71", "\uBB71"}, {"\uBB72", "\uBB72"}, {"\uBB73", "\uBB73"},
    {"\uBB74", "\uBB74"}, {"\uBB75", "\uBB75"}, {"\uBB76", "\uBB76"}, {"\uBB77", "\uBB77"}, {"\uBB78", "\uBB78"},
    {"\uBB79", "\uBB79"}, {"\uBB7A", "\uBB7A"}, {"\uBB7B", "\uBB7B"}, {"\uBB7C", "\uBB7C"}, {"\uBB7D", "\uBB7D"},
    {"\uBB7E", "\uBB7E"}, {"\uBB7F", "\uBB7F"}, {"\uBB80", "\uBB80"}, {"\uBB81", "\uBB81"}, {"\uBB82", "\uBB82"},
    {"\uBB83", "\uBB83"}, {"\uBB84", "\uBB84"}, {"\uBB85", "\uBB85"}, {"\uBB86", "\uBB86"}, {"\uBB87", "\uBB87"},
    {"\uBB88", "\uBB88"}, {"\uBB89", "\uBB89"}, {"\uBB8A", "\uBB8A"}, {"\uBB8B", "\uBB8B"}, {"\uBB8C", "\uBB8C"},
    {"\uBB8D", "\uBB8D"}, {"\uBB8E", "\uBB8E"}, {"\uBB8F", "\uBB8F"}, {"\uBB90", "\uBB90"}, {"\uBB91", "\uBB91"},
    {"\uBB92", "\uBB92"}, {"\uBB93", "\uBB93"}, {"\uBB94", "\uBB94"}, {"\uBB95", "\uBB95"}, {"\uBB96", "\uBB96"},
    {"\uBB97", "\uBB97"}, {"\uBB98", "\uBB98"}, {"\uBB99", "\uBB99"}, {"\uBB9A", "\uBB9A"}, {"\uBB9B", "\uBB9B"},
    {"\uBB9C", "\uBB9C"}, {"\uBB9D", "\uBB9D"}, {"\uBB9E", "\uBB9E"}, {"\uBB9F", "\uBB9F"}, {"\uBBA0", "\uBBA0"},
    {"\uBBA1", "\uBBA1"}, {"\uBBA2", "\uBBA2"}, {"\uBBA3", "\uBBA3"}, {"\uBBA4", "\uBBA4"}, {"\uBBA5", "\uBBA5"},
    {"\uBBA6", "\uBBA6"}, {"\uBBA7", "\uBBA7"}, {"\uBBA8", "\uBBA8"}, {"\uBBA9", "\uBBA9"}, {"\uBBAA", "\uBBAA"},
    {"\uBBAB", "\uBBAB"}, {"\uBBAC", "\uBBAC"}, {"\uBBAD", "\uBBAD"}, {"\uBBAE", "\uBBAE"}, {"\uBBAF", "\uBBAF"},
    {"\uBBB0", "\uBBB0"}, {"\uBBB1", "\uBBB1"}, {"\uBBB2", "\uBBB2"}, {"\uBBB3", "\uBBB3"}, {"\uBBB4", "\uBBB4"},
    {"\uBBB5", "\uBBB5"}, {"\uBBB6", "\uBBB6"}, {"\uBBB7", "\uBBB7"}, {"\uBBB8", "\uBBB8"}, {"\uBBB9", "\uBBB9"},
    {"\uBBBA", "\uBBBA"}, {"\uBBBB", "\uBBBB"}, {"\uBBBC", "\uBBBC"}, {"\uBBBD", "\uBBBD"}, {"\uBBBE", "\uBBBE"},
    {"\uBBBF", "\uBBBF"}, {"\uBBC0", "\uBBC0"}, {"\uBBC1", "\uBBC1"}, {"\uBBC2", "\uBBC2"}, {"\uBBC3", "\uBBC3"},
    {"\uBBC4", "\uBBC4"}, {"\uBBC5", "\uBBC5"}, {"\uBBC6", "\uBBC6"}, {"\uBBC7", "\uBBC7"}, {"\uBBC8", "\uBBC8"},
    {"\uBBC9", "\uBBC9"}, {"\uBBCA", "\uBBCA"}, {"\uBBCB", "\uBBCB"}, {"\uBBCC", "\uBBCC"}, {"\uBBCD", "\uBBCD"},
    {"\uBBCE", "\uBBCE"}, {"\uBBCF", "\uBBCF"}, {"\uBBD0", "\uBBD0"}, {"\uBBD1", "\uBBD1"}, {"\uBBD2", "\uBBD2"},
    {"\uBBD3", "\uBBD3"}, {"\uBBD4", "\uBBD4"}, {"\uBBD5", "\uBBD5"}, {"\uBBD6", "\uBBD6"}, {"\uBBD7", "\uBBD7"},
    {"\uBBD8", "\uBBD8"}, {"\uBBD9", "\uBBD9"}, {"\uBBDA", "\uBBDA"}, {"\uBBDB", "\uBBDB"}, {"\uBBDC", "\uBBDC"},
    {"\uBBDD", "\uBBDD"}, {"\uBBDE", "\uBBDE"}, {"\uBBDF", "\uBBDF"}, {"\uBBE0", "\uBBE0"}, {"\uBBE1", "\uBBE1"},
    {"\uBBE2", "\uBBE2"}, {"\uBBE3", "\uBBE3"}, {"\uBBE4", "\uBBE4"}, {"\uBBE5", "\uBBE5"}, {"\uBBE6", "\uBBE6"},
    {"\uBBE7", "\uBBE7"}, {"\uBBE8", "\uBBE8"}, {"\uBBE9", "\uBBE9"}, {"\uBBEA", "\uBBEA"}, {"\uBBEB", "\uBBEB"},
    {"\uBBEC", "\uBBEC"}, {"\uBBED", "\uBBED"}, {"\uBBEE", "\uBBEE"}, {"\uBBEF", "\uBBEF"}, {"\uBBF0", "\uBBF0"},
    {"\uBBF1", "\uBBF1"}, {"\uBBF2", "\uBBF2"}, {"\uBBF3", "\uBBF3"}, {"\uBBF4", "\uBBF4"}, {"\uBBF5", "\uBBF5"},
    {"\uBBF6", "\uBBF6"}, {"\uBBF7", "\uBBF7"}, {"\uBBF8", "\uBBF8"}, {"\uBBF9", "\uBBF9"}, {"\uBBFA", "\uBBFA"},
    {"\uBBFB", "\uBBFB"}, {"\uBBFC", "\uBBFC"}, {"\uBBFD", "\uBBFD"}, {"\uBBFE", "\uBBFE"}, {"\uBBFF", "\uBBFF"},
    {"\uBC00", "\uBC00"}, {"\uBC01", "\uBC01"}, {"\uBC02", "\uBC02"}, {"\uBC03", "\uBC03"}, {"\uBC04", "\uBC04"},
    {"\uBC05", "\uBC05"}, {"\uBC06", "\uBC06"}, {"\uBC07", "\uBC07"}, {"\uBC08", "\uBC08"}, {"\uBC09", "\uBC09"},
    {"\uBC0A", "\uBC0A"}, {"\uBC0B", "\uBC0B"}, {"\uBC0C", "\uBC0C"}, {"\uBC0D", "\uBC0D"}, {"\uBC0E", "\uBC0E"},
    {"\uBC0F", "\uBC0F"}, {"\uBC10", "\uBC10"}, {"\uBC11", "\uBC11"}, {"\uBC12", "\uBC12"}, {"\uBC13", "\uBC13"},
    {"\uBC14", "\uBC14"}, {"\uBC15", "\uBC15"}, {"\uBC16", "\uBC16"}, {"\uBC17", "\uBC17"}, {"\uBC18", "\uBC18"},
    {"\uBC19", "\uBC19"}, {"\uBC1A", "\uBC1A"}, {"\uBC1B", "\uBC1B"}, {"\uBC1C", "\uBC1C"}, {"\uBC1D", "\uBC1D"},
    {"\uBC1E", "\uBC1E"}, {"\uBC1F", "\uBC1F"}, {"\uBC20", "\uBC20"}, {"\uBC21", "\uBC21"}, {"\uBC22", "\uBC22"},
    {"\uBC23", "\uBC23"}, {"\uBC24", "\uBC24"}, {"\uBC25", "\uBC25"}, {"\uBC26", "\uBC26"}, {"\uBC27", "\uBC27"},
    {"\uBC28", "\uBC28"}, {"\uBC29", "\uBC29"}, {"\uBC2A", "\uBC2A"}, {"\uBC2B", "\uBC2B"}, {"\uBC2C", "\uBC2C"},
    {"\uBC2D", "\uBC2D"}, {"\uBC2E", "\uBC2E"}, {"\uBC2F", "\uBC2F"}, {"\uBC30", "\uBC30"}, {"\uBC31", "\uBC31"},
    {"\uBC32", "\uBC32"}, {"\uBC33", "\uBC33"}, {"\uBC34", "\uBC34"}, {"\uBC35", "\uBC35"}, {"\uBC36", "\uBC36"},
    {"\uBC37", "\uBC37"}, {"\uBC38", "\uBC38"}, {"\uBC39", "\uBC39"}, {"\uBC3A", "\uBC3A"}, {"\uBC3B", "\uBC3B"},
    {"\uBC3C", "\uBC3C"}, {"\uBC3D", "\uBC3D"}, {"\uBC3E", "\uBC3E"}, {"\uBC3F", "\uBC3F"}, {"\uBC40", "\uBC40"},
    {"\uBC41", "\uBC41"}, {"\uBC42", "\uBC42"}, {"\uBC43", "\uBC43"}, {"\uBC44", "\uBC44"}, {"\uBC45", "\uBC45"},
    {"\uBC46", "\uBC46"}, {"\uBC47", "\uBC47"}, {"\uBC48", "\uBC48"}, {"\uBC49", "\uBC49"}, {"\uBC4A", "\uBC4A"},
    {"\uBC4B", "\uBC4B"}, {"\uBC4C", "\uBC4C"}, {"\uBC4D", "\uBC4D"}, {"\uBC4E", "\uBC4E"}, {"\uBC4F", "\uBC4F"},
    {"\uBC50", "\uBC50"}, {"\uBC51", "\uBC51"}, {"\uBC52", "\uBC52"}, {"\uBC53", "\uBC53"}, {"\uBC54", "\uBC54"},
    {"\uBC55", "\uBC55"}, {"\uBC56", "\uBC56"}, {"\uBC57", "\uBC57"}, {"\uBC58", "\uBC58"}, {"\uBC59", "\uBC59"},
    {"\uBC5A", "\uBC5A"}, {"\uBC5B", "\uBC5B"}, {"\uBC5C", "\uBC5C"}, {"\uBC5D", "\uBC5D"}, {"\uBC5E", "\uBC5E"},
    {"\uBC5F", "\uBC5F"}, {"\uBC60", "\uBC60"}, {"\uBC61", "\uBC61"}, {"\uBC62", "\uBC62"}, {"\uBC63", "\uBC63"},
    {"\uBC64", "\uBC64"}, {"\uBC65", "\uBC65"}, {"\uBC66", "\uBC66"}, {"\uBC67", "\uBC67"}, {"\uBC68", "\uBC68"},
    {"\uBC69", "\uBC69"}, {"\uBC6A", "\uBC6A"}, {"\uBC6B", "\uBC6B"}, {"\uBC6C", "\uBC6C"}, {"\uBC6D", "\uBC6D"},
    {"\uBC6E", "\uBC6E"}, {"\uBC6F", "\uBC6F"}, {"\uBC70", "\uBC70"}, {"\uBC71", "\uBC71"}, {"\uBC72", "\uBC72"},
    {"\uBC73", "\uBC73"}, {"\uBC74", "\uBC74"}, {"\uBC75", "\uBC75"}, {"\uBC76", "\uBC76"}, {"\uBC77", "\uBC77"},
    {"\uBC78", "\uBC78"}, {"\uBC79", "\uBC79"}, {"\uBC7A", "\uBC7A"}, {"\uBC7B", "\uBC7B"}, {"\uBC7C", "\uBC7C"},
    {"\uBC7D", "\uBC7D"}, {"\uBC7E", "\uBC7E"}, {"\uBC7F", "\uBC7F"}, {"\uBC80", "\uBC80"}, {"\uBC81", "\uBC81"},
    {"\uBC82", "\uBC82"}, {"\uBC83", "\uBC83"}, {"\uBC84", "\uBC84"}, {"\uBC85", "\uBC85"}, {"\uBC86", "\uBC86"},
    {"\uBC87", "\uBC87"}, {"\uBC88", "\uBC88"}, {"\uBC89", "\uBC89"}, {"\uBC8A", "\uBC8A"}, {"\uBC8B", "\uBC8B"},
    {"\uBC8C", "\uBC8C"}, {"\uBC8D", "\uBC8D"}, {"\uBC8E", "\uBC8E"}, {"\uBC8F", "\uBC8F"}, {"\uBC90", "\uBC90"},
    {"\uBC91", "\uBC91"}, {"\uBC92", "\uBC92"}, {"\uBC93", "\uBC93"}, {"\uBC94", "\uBC94"}, {"\uBC95", "\uBC95"},
    {"\uBC96", "\uBC96"}, {"\uBC97", "\uBC97"}, {"\uBC98", "\uBC98"}, {"\uBC99", "\uBC99"}, {"\uBC9A", "\uBC9A"},
    {"\uBC9B", "\uBC9B"}, {"\uBC9C", "\uBC9C"}, {"\uBC9D", "\uBC9D"}, {"\uBC9E", "\uBC9E"}, {"\uBC9F", "\uBC9F"},
    {"\uBCA0", "\uBCA0"}, {"\uBCA1", "\uBCA1"}, {"\uBCA2", "\uBCA2"}, {"\uBCA3", "\uBCA3"}, {"\uBCA4", "\uBCA4"},
    {"\uBCA5", "\uBCA5"}, {"\uBCA6", "\uBCA6"}, {"\uBCA7", "\uBCA7"}, {"\uBCA8", "\uBCA8"}, {"\uBCA9", "\uBCA9"},
    {"\uBCAA", "\uBCAA"}, {"\uBCAB", "\uBCAB"}, {"\uBCAC", "\uBCAC"}, {"\uBCAD", "\uBCAD"}, {"\uBCAE", "\uBCAE"},
    {"\uBCAF", "\uBCAF"}, {"\uBCB0", "\uBCB0"}, {"\uBCB1", "\uBCB1"}, {"\uBCB2", "\uBCB2"}, {"\uBCB3", "\uBCB3"},
    {"\uBCB4", "\uBCB4"}, {"\uBCB5", "\uBCB5"}, {"\uBCB6", "\uBCB6"}, {"\uBCB7", "\uBCB7"}, {"\uBCB8", "\uBCB8"},
    {"\uBCB9", "\uBCB9"}, {"\uBCBA", "\uBCBA"}, {"\uBCBB", "\uBCBB"}, {"\uBCBC", "\uBCBC"}, {"\uBCBD", "\uBCBD"},
    {"\uBCBE", "\uBCBE"}, {"\uBCBF", "\uBCBF"}, {"\uBCC0", "\uBCC0"}, {"\uBCC1", "\uBCC1"}, {"\uBCC2", "\uBCC2"},
    {"\uBCC3", "\uBCC3"}, {"\uBCC4", "\uBCC4"}, {"\uBCC5", "\uBCC5"}, {"\uBCC6", "\uBCC6"}, {"\uBCC7", "\uBCC7"},
    {"\uBCC8", "\uBCC8"}, {"\uBCC9", "\uBCC9"}, {"\uBCCA", "\uBCCA"}, {"\uBCCB", "\uBCCB"}, {"\uBCCC", "\uBCCC"},
    {"\uBCCD", "\uBCCD"}, {"\uBCCE", "\uBCCE"}, {"\uBCCF", "\uBCCF"}, {"\uBCD0", "\uBCD0"}, {"\uBCD1", "\uBCD1"},
    {"\uBCD2", "\uBCD2"}, {"\uBCD3", "\uBCD3"}, {"\uBCD4", "\uBCD4"}, {"\uBCD5", "\uBCD5"}, {"\uBCD6", "\uBCD6"},
    {"\uBCD7", "\uBCD7"}, {"\uBCD8", "\uBCD8"}, {"\uBCD9", "\uBCD9"}, {"\uBCDA", "\uBCDA"}, {"\uBCDB", "\uBCDB"},
    {"\uBCDC", "\uBCDC"}, {"\uBCDD", "\uBCDD"}, {"\uBCDE", "\uBCDE"}, {"\uBCDF", "\uBCDF"}, {"\uBCE0", "\uBCE0"},
    {"\uBCE1", "\uBCE1"}, {"\uBCE2", "\uBCE2"}, {"\uBCE3", "\uBCE3"}, {"\uBCE4", "\uBCE4"}, {"\uBCE5", "\uBCE5"},
    {"\uBCE6", "\uBCE6"}, {"\uBCE7", "\uBCE7"}, {"\uBCE8", "\uBCE8"}, {"\uBCE9", "\uBCE9"}, {"\uBCEA", "\uBCEA"},
    {"\uBCEB", "\uBCEB"}, {"\uBCEC", "\uBCEC"}, {"\uBCED", "\uBCED"}, {"\uBCEE", "\uBCEE"}, {"\uBCEF", "\uBCEF"},
    {"\uBCF0", "\uBCF0"}, {"\uBCF1", "\uBCF1"}, {"\uBCF2", "\uBCF2"}, {"\uBCF3", "\uBCF3"}, {"\uBCF4", "\uBCF4"},
    {"\uBCF5", "\uBCF5"}, {"\uBCF6", "\uBCF6"}, {"\uBCF7", "\uBCF7"}, {"\uBCF8", "\uBCF8"}, {"\uBCF9", "\uBCF9"},
    {"\uBCFA", "\uBCFA"}, {"\uBCFB", "\uBCFB"}, {"\uBCFC", "\uBCFC"}, {"\uBCFD", "\uBCFD"}, {"\uBCFE", "\uBCFE"},
    {"\uBCFF", "\uBCFF"}, {"\uBD00", "\uBD00"}, {"\uBD01", "\uBD01"}, {"\uBD02", "\uBD02"}, {"\uBD03", "\uBD03"},
    {"\uBD04", "\uBD04"}, {"\uBD05", "\uBD05"}, {"\uBD06", "\uBD06"}, {"\uBD07", "\uBD07"}, {"\uBD08", "\uBD08"},
    {"\uBD09", "\uBD09"}, {"\uBD0A", "\uBD0A"}, {"\uBD0B", "\uBD0B"}, {"\uBD0C", "\uBD0C"}, {"\uBD0D", "\uBD0D"},
    {"\uBD0E", "\uBD0E"}, {"\uBD0F", "\uBD0F"}, {"\uBD10", "\uBD10"}, {"\uBD11", "\uBD11"}, {"\uBD12", "\uBD12"},
    {"\uBD13", "\uBD13"}, {"\uBD14", "\uBD14"}, {"\uBD15", "\uBD15"}, {"\uBD16", "\uBD16"}, {"\uBD17", "\uBD17"},
    {"\uBD18", "\uBD18"}, {"\uBD19", "\uBD19"}, {"\uBD1A", "\uBD1A"}, {"\uBD1B", "\uBD1B"}, {"\uBD1C", "\uBD1C"},
    {"\uBD1D", "\uBD1D"}, {"\uBD1E", "\uBD1E"}, {"\uBD1F", "\uBD1F"}, {"\uBD20", "\uBD20"}, {"\uBD21", "\uBD21"},
    {"\uBD22", "\uBD22"}, {"\uBD23", "\uBD23"}, {"\uBD24", "\uBD24"}, {"\uBD25", "\uBD25"}, {"\uBD26", "\uBD26"},
    {"\uBD27", "\uBD27"}, {"\uBD28", "\uBD28"}, {"\uBD29", "\uBD29"}, {"\uBD2A", "\uBD2A"}, {"\uBD2B", "\uBD2B"},
    {"\uBD2C", "\uBD2C"}, {"\uBD2D", "\uBD2D"}, {"\uBD2E", "\uBD2E"}, {"\uBD2F", "\uBD2F"}, {"\uBD30", "\uBD30"},
    {"\uBD31", "\uBD31"}, {"\uBD32", "\uBD32"}, {"\uBD33", "\uBD33"}, {"\uBD34", "\uBD34"}, {"\uBD35", "\uBD35"},
    {"\uBD36", "\uBD36"}, {"\uBD37", "\uBD37"}, {"\uBD38", "\uBD38"}, {"\uBD39", "\uBD39"}, {"\uBD3A", "\uBD3A"},
    {"\uBD3B", "\uBD3B"}, {"\uBD3C", "\uBD3C"}, {"\uBD3D", "\uBD3D"}, {"\uBD3E", "\uBD3E"}, {"\uBD3F", "\uBD3F"},
    {"\uBD40", "\uBD40"}, {"\uBD41", "\uBD41"}, {"\uBD42", "\uBD42"}, {"\uBD43", "\uBD43"}, {"\uBD44", "\uBD44"},
    {"\uBD45", "\uBD45"}, {"\uBD46", "\uBD46"}, {"\uBD47", "\uBD47"}, {"\uBD48", "\uBD48"}, {"\uBD49", "\uBD49"},
    {"\uBD4A", "\uBD4A"}, {"\uBD4B", "\uBD4B"}, {"\uBD4C", "\uBD4C"}, {"\uBD4D", "\uBD4D"}, {"\uBD4E", "\uBD4E"},
    {"\uBD4F", "\uBD4F"}, {"\uBD50", "\uBD50"}, {"\uBD51", "\uBD51"}, {"\uBD52", "\uBD52"}, {"\uBD53", "\uBD53"},
    {"\uBD54", "\uBD54"}, {"\uBD55", "\uBD55"}, {"\uBD56", "\uBD56"}, {"\uBD57", "\uBD57"}, {"\uBD58", "\uBD58"},
    {"\uBD59", "\uBD59"}, {"\uBD5A", "\uBD5A"}, {"\uBD5B", "\uBD5B"}, {"\uBD5C", "\uBD5C"}, {"\uBD5D", "\uBD5D"},
    {"\uBD5E", "\uBD5E"}, {"\uBD5F", "\uBD5F"}, {"\uBD60", "\uBD60"}, {"\uBD61", "\uBD61"}, {"\uBD62", "\uBD62"},
    {"\uBD63", "\uBD63"}, {"\uBD64", "\uBD64"}, {"\uBD65", "\uBD65"}, {"\uBD66", "\uBD66"}, {"\uBD67", "\uBD67"},
    {"\uBD68", "\uBD68"}, {"\uBD69", "\uBD69"}, {"\uBD6A", "\uBD6A"}, {"\uBD6B", "\uBD6B"}, {"\uBD6C", "\uBD6C"},
    {"\uBD6D", "\uBD6D"}, {"\uBD6E", "\uBD6E"}, {"\uBD6F", "\uBD6F"}, {"\uBD70", "\uBD70"}, {"\uBD71", "\uBD71"},
    {"\uBD72", "\uBD72"}, {"\uBD73", "\uBD73"}, {"\uBD74", "\uBD74"}, {"\uBD75", "\uBD75"}, {"\uBD76", "\uBD76"},
    {"\uBD77", "\uBD77"}, {"\uBD78", "\uBD78"}, {"\uBD79", "\uBD79"}, {"\uBD7A", "\uBD7A"}, {"\uBD7B", "\uBD7B"},
    {"\uBD7C", "\uBD7C"}, {"\uBD7D", "\uBD7D"}, {"\uBD7E", "\uBD7E"}, {"\uBD7F", "\uBD7F"}, {"\uBD80", "\uBD80"},
    {"\uBD81", "\uBD81"}, {"\uBD82", "\uBD82"}, {"\uBD83", "\uBD83"}, {"\uBD84", "\uBD84"}, {"\uBD85", "\uBD85"},
    {"\uBD86", "\uBD86"}, {"\uBD87", "\uBD87"}, {"\uBD88", "\uBD88"}, {"\uBD89", "\uBD89"}, {"\uBD8A", "\uBD8A"},
    {"\uBD8B", "\uBD8B"}, {"\uBD8C", "\uBD8C"}, {"\uBD8D", "\uBD8D"}, {"\uBD8E", "\uBD8E"}, {"\uBD8F", "\uBD8F"},
    {"\uBD90", "\uBD90"}, {"\uBD91", "\uBD91"}, {"\uBD92", "\uBD92"}, {"\uBD93", "\uBD93"}, {"\uBD94", "\uBD94"},
    {"\uBD95", "\uBD95"}, {"\uBD96", "\uBD96"}, {"\uBD97", "\uBD97"}, {"\uBD98", "\uBD98"}, {"\uBD99", "\uBD99"},
    {"\uBD9A", "\uBD9A"}, {"\uBD9B", "\uBD9B"}, {"\uBD9C", "\uBD9C"}, {"\uBD9D", "\uBD9D"}, {"\uBD9E", "\uBD9E"},
    {"\uBD9F", "\uBD9F"}, {"\uBDA0", "\uBDA0"}, {"\uBDA1", "\uBDA1"}, {"\uBDA2", "\uBDA2"}, {"\uBDA3", "\uBDA3"},
    {"\uBDA4", "\uBDA4"}, {"\uBDA5", "\uBDA5"}, {"\uBDA6", "\uBDA6"}, {"\uBDA7", "\uBDA7"}, {"\uBDA8", "\uBDA8"},
    {"\uBDA9", "\uBDA9"}, {"\uBDAA", "\uBDAA"}, {"\uBDAB", "\uBDAB"}, {"\uBDAC", "\uBDAC"}, {"\uBDAD", "\uBDAD"},
    {"\uBDAE", "\uBDAE"}, {"\uBDAF", "\uBDAF"}, {"\uBDB0", "\uBDB0"}, {"\uBDB1", "\uBDB1"}, {"\uBDB2", "\uBDB2"},
    {"\uBDB3", "\uBDB3"}, {"\uBDB4", "\uBDB4"}, {"\uBDB5", "\uBDB5"}, {"\uBDB6", "\uBDB6"}, {"\uBDB7", "\uBDB7"},
    {"\uBDB8", "\uBDB8"}, {"\uBDB9", "\uBDB9"}, {"\uBDBA", "\uBDBA"}, {"\uBDBB", "\uBDBB"}, {"\uBDBC", "\uBDBC"},
    {"\uBDBD", "\uBDBD"}, {"\uBDBE", "\uBDBE"}, {"\uBDBF", "\uBDBF"}, {"\uBDC0", "\uBDC0"}, {"\uBDC1", "\uBDC1"},
    {"\uBDC2", "\uBDC2"}, {"\uBDC3", "\uBDC3"}, {"\uBDC4", "\uBDC4"}, {"\uBDC5", "\uBDC5"}, {"\uBDC6", "\uBDC6"},
    {"\uBDC7", "\uBDC7"}, {"\uBDC8", "\uBDC8"}, {"\uBDC9", "\uBDC9"}, {"\uBDCA", "\uBDCA"}, {"\uBDCB", "\uBDCB"},
    {"\uBDCC", "\uBDCC"}, {"\uBDCD", "\uBDCD"}, {"\uBDCE", "\uBDCE"}, {"\uBDCF", "\uBDCF"}, {"\uBDD0", "\uBDD0"},
    {"\uBDD1", "\uBDD1"}, {"\uBDD2", "\uBDD2"}, {"\uBDD3", "\uBDD3"}, {"\uBDD4", "\uBDD4"}, {"\uBDD5", "\uBDD5"},
    {"\uBDD6", "\uBDD6"}, {"\uBDD7", "\uBDD7"}, {"\uBDD8", "\uBDD8"}, {"\uBDD9", "\uBDD9"}, {"\uBDDA", "\uBDDA"},
    {"\uBDDB", "\uBDDB"}, {"\uBDDC", "\uBDDC"}, {"\uBDDD", "\uBDDD"}, {"\uBDDE", "\uBDDE"}, {"\uBDDF", "\uBDDF"},
    {"\uBDE0", "\uBDE0"}, {"\uBDE1", "\uBDE1"}, {"\uBDE2", "\uBDE2"}, {"\uBDE3", "\uBDE3"}, {"\uBDE4", "\uBDE4"},
    {"\uBDE5", "\uBDE5"}, {"\uBDE6", "\uBDE6"}, {"\uBDE7", "\uBDE7"}, {"\uBDE8", "\uBDE8"}, {"\uBDE9", "\uBDE9"},
    {"\uBDEA", "\uBDEA"}, {"\uBDEB", "\uBDEB"}, {"\uBDEC", "\uBDEC"}, {"\uBDED", "\uBDED"}, {"\uBDEE", "\uBDEE"},
    {"\uBDEF", "\uBDEF"}, {"\uBDF0", "\uBDF0"}, {"\uBDF1", "\uBDF1"}, {"\uBDF2", "\uBDF2"}, {"\uBDF3", "\uBDF3"},
    {"\uBDF4", "\uBDF4"}, {"\uBDF5", "\uBDF5"}, {"\uBDF6", "\uBDF6"}, {"\uBDF7", "\uBDF7"}, {"\uBDF8", "\uBDF8"},
    {"\uBDF9", "\uBDF9"}, {"\uBDFA", "\uBDFA"}, {"\uBDFB", "\uBDFB"}, {"\uBDFC", "\uBDFC"}, {"\uBDFD", "\uBDFD"},
    {"\uBDFE", "\uBDFE"}, {"\uBDFF", "\uBDFF"}, {"\uBE00", "\uBE00"}, {"\uBE01", "\uBE01"}, {"\uBE02", "\uBE02"},
    {"\uBE03", "\uBE03"}, {"\uBE04", "\uBE04"}, {"\uBE05", "\uBE05"}, {"\uBE06", "\uBE06"}, {"\uBE07", "\uBE07"},
    {"\uBE08", "\uBE08"}, {"\uBE09", "\uBE09"}, {"\uBE0A", "\uBE0A"}, {"\uBE0B", "\uBE0B"}, {"\uBE0C", "\uBE0C"},
    {"\uBE0D", "\uBE0D"}, {"\uBE0E", "\uBE0E"}, {"\uBE0F", "\uBE0F"}, {"\uBE10", "\uBE10"}, {"\uBE11", "\uBE11"},
    {"\uBE12", "\uBE12"}, {"\uBE13", "\uBE13"}, {"\uBE14", "\uBE14"}, {"\uBE15", "\uBE15"}, {"\uBE16", "\uBE16"},
    {"\uBE17", "\uBE17"}, {"\uBE18", "\uBE18"}, {"\uBE19", "\uBE19"}, {"\uBE1A", "\uBE1A"}, {"\uBE1B", "\uBE1B"},
    {"\uBE1C", "\uBE1C"}, {"\uBE1D", "\uBE1D"}, {"\uBE1E", "\uBE1E"}, {"\uBE1F", "\uBE1F"}, {"\uBE20", "\uBE20"},
    {"\uBE21", "\uBE21"}, {"\uBE22", "\uBE22"}, {"\uBE23", "\uBE23"}, {"\uBE24", "\uBE24"}, {"\uBE25", "\uBE25"},
    {"\uBE26", "\uBE26"}, {"\uBE27", "\uBE27"}, {"\uBE28", "\uBE28"}, {"\uBE29", "\uBE29"}, {"\uBE2A", "\uBE2A"},
    {"\uBE2B", "\uBE2B"}, {"\uBE2C", "\uBE2C"}, {"\uBE2D", "\uBE2D"}, {"\uBE2E", "\uBE2E"}, {"\uBE2F", "\uBE2F"},
    {"\uBE30", "\uBE30"}, {"\uBE31", "\uBE31"}, {"\uBE32", "\uBE32"}, {"\uBE33", "\uBE33"}, {"\uBE34", "\uBE34"},
    {"\uBE35", "\uBE35"}, {"\uBE36", "\uBE36"}, {"\uBE37", "\uBE37"}, {"\uBE38", "\uBE38"}, {"\uBE39", "\uBE39"},
    {"\uBE3A", "\uBE3A"}, {"\uBE3B", "\uBE3B"}, {"\uBE3C", "\uBE3C"}, {"\uBE3D", "\uBE3D"}, {"\uBE3E", "\uBE3E"},
    {"\uBE3F", "\uBE3F"}, {"\uBE40", "\uBE40"}, {"\uBE41", "\uBE41"}, {"\uBE42", "\uBE42"}, {"\uBE43", "\uBE43"},
    {"\uBE44", "\uBE44"}, {"\uBE45", "\uBE45"}, {"\uBE46", "\uBE46"}, {"\uBE47", "\uBE47"}, {"\uBE48", "\uBE48"},
    {"\uBE49", "\uBE49"}, {"\uBE4A", "\uBE4A"}, {"\uBE4B", "\uBE4B"}, {"\uBE4C", "\uBE4C"}, {"\uBE4D", "\uBE4D"},
    {"\uBE4E", "\uBE4E"}, {"\uBE4F", "\uBE4F"}, {"\uBE50", "\uBE50"}, {"\uBE51", "\uBE51"}, {"\uBE52", "\uBE52"},
    {"\uBE53", "\uBE53"}, {"\uBE54", "\uBE54"}, {"\uBE55", "\uBE55"}, {"\uBE56", "\uBE56"}, {"\uBE57", "\uBE57"},
    {"\uBE58", "\uBE58"}, {"\uBE59", "\uBE59"}, {"\uBE5A", "\uBE5A"}, {"\uBE5B", "\uBE5B"}, {"\uBE5C", "\uBE5C"},
    {"\uBE5D", "\uBE5D"}, {"\uBE5E", "\uBE5E"}, {"\uBE5F", "\uBE5F"}, {"\uBE60", "\uBE60"}, {"\uBE61", "\uBE61"},
    {"\uBE62", "\uBE62"}, {"\uBE63", "\uBE63"}, {"\uBE64", "\uBE64"}, {"\uBE65", "\uBE65"}, {"\uBE66", "\uBE66"},
    {"\uBE67", "\uBE67"}, {"\uBE68", "\uBE68"}, {"\uBE69", "\uBE69"}, {"\uBE6A", "\uBE6A"}, {"\uBE6B", "\uBE6B"},
    {"\uBE6C", "\uBE6C"}, {"\uBE6D", "\uBE6D"}, {"\uBE6E", "\uBE6E"}, {"\uBE6F", "\uBE6F"}, {"\uBE70", "\uBE70"},
    {"\uBE71", "\uBE71"}, {"\uBE72", "\uBE72"}, {"\uBE73", "\uBE73"}, {"\uBE74", "\uBE74"}, {"\uBE75", "\uBE75"},
    {"\uBE76", "\uBE76"}, {"\uBE77", "\uBE77"}, {"\uBE78", "\uBE78"}, {"\uBE79", "\uBE79"}, {"\uBE7A", "\uBE7A"},
    {"\uBE7B", "\uBE7B"}, {"\uBE7C", "\uBE7C"}, {"\uBE7D", "\uBE7D"}, {"\uBE7E", "\uBE7E"}, {"\uBE7F", "\uBE7F"},
    {"\uBE80", "\uBE80"}, {"\uBE81", "\uBE81"}, {"\uBE82", "\uBE82"}, {"\uBE83", "\uBE83"}, {"\uBE84", "\uBE84"},
    {"\uBE85", "\uBE85"}, {"\uBE86", "\uBE86"}, {"\uBE87", "\uBE87"}, {"\uBE88", "\uBE88"}, {"\uBE89", "\uBE89"},
    {"\uBE8A", "\uBE8A"}, {"\uBE8B", "\uBE8B"}, {"\uBE8C", "\uBE8C"}, {"\uBE8D", "\uBE8D"}, {"\uBE8E", "\uBE8E"},
    {"\uBE8F", "\uBE8F"}, {"\uBE90", "\uBE90"}, {"\uBE91", "\uBE91"}, {"\uBE92", "\uBE92"}, {"\uBE93", "\uBE93"},
    {"\uBE94", "\uBE94"}, {"\uBE95", "\uBE95"}, {"\uBE96", "\uBE96"}, {"\uBE97", "\uBE97"}, {"\uBE98", "\uBE98"},
    {"\uBE99", "\uBE99"}, {"\uBE9A", "\uBE9A"}, {"\uBE9B", "\uBE9B"}, {"\uBE9C", "\uBE9C"}, {"\uBE9D", "\uBE9D"},
    {"\uBE9E", "\uBE9E"}, {"\uBE9F", "\uBE9F"}, {"\uBEA0", "\uBEA0"}, {"\uBEA1", "\uBEA1"}, {"\uBEA2", "\uBEA2"},
    {"\uBEA3", "\uBEA3"}, {"\uBEA4", "\uBEA4"}, {"\uBEA5", "\uBEA5"}, {"\uBEA6", "\uBEA6"}, {"\uBEA7", "\uBEA7"},
    {"\uBEA8", "\uBEA8"}, {"\uBEA9", "\uBEA9"}, {"\uBEAA", "\uBEAA"}, {"\uBEAB", "\uBEAB"}, {"\uBEAC", "\uBEAC"},
    {"\uBEAD", "\uBEAD"}, {"\uBEAE", "\uBEAE"}, {"\uBEAF", "\uBEAF"}, {"\uBEB0", "\uBEB0"}, {"\uBEB1", "\uBEB1"},
    {"\uBEB2", "\uBEB2"}, {"\uBEB3", "\uBEB3"}, {"\uBEB4", "\uBEB4"}, {"\uBEB5", "\uBEB5"}, {"\uBEB6", "\uBEB6"},
    {"\uBEB7", "\uBEB7"}, {"\uBEB8", "\uBEB8"}, {"\uBEB9", "\uBEB9"}, {"\uBEBA", "\uBEBA"}, {"\uBEBB", "\uBEBB"},
    {"\uBEBC", "\uBEBC"}, {"\uBEBD", "\uBEBD"}, {"\uBEBE", "\uBEBE"}, {"\uBEBF", "\uBEBF"}, {"\uBEC0", "\uBEC0"},
    {"\uBEC1", "\uBEC1"}, {"\uBEC2", "\uBEC2"}, {"\uBEC3", "\uBEC3"}, {"\uBEC4", "\uBEC4"}, {"\uBEC5", "\uBEC5"},
    {"\uBEC6", "\uBEC6"}, {"\uBEC7", "\uBEC7"}, {"\uBEC8", "\uBEC8"}, {"\uBEC9", "\uBEC9"}, {"\uBECA", "\uBECA"},
    {"\uBECB", "\uBECB"}, {"\uBECC", "\uBECC"}, {"\uBECD", "\uBECD"}, {"\uBECE", "\uBECE"}, {"\uBECF", "\uBECF"},
    {"\uBED0", "\uBED0"}, {"\uBED1", "\uBED1"}, {"\uBED2", "\uBED2"}, {"\uBED3", "\uBED3"}, {"\uBED4", "\uBED4"},
    {"\uBED5", "\uBED5"}, {"\uBED6", "\uBED6"}, {"\uBED7", "\uBED7"}, {"\uBED8", "\uBED8"}, {"\uBED9", "\uBED9"},
    {"\uBEDA", "\uBEDA"}, {"\uBEDB", "\uBEDB"}, {"\uBEDC", "\uBEDC"}, {"\uBEDD", "\uBEDD"}, {"\uBEDE", "\uBEDE"},
    {"\uBEDF", "\uBEDF"}, {"\uBEE0", "\uBEE0"}, {"\uBEE1", "\uBEE1"}, {"\uBEE2", "\uBEE2"}, {"\uBEE3", "\uBEE3"},
    {"\uBEE4", "\uBEE4"}, {"\uBEE5", "\uBEE5"}, {"\uBEE6", "\uBEE6"}, {"\uBEE7", "\uBEE7"}, {"\uBEE8", "\uBEE8"},
    {"\uBEE9", "\uBEE9"}, {"\uBEEA", "\uBEEA"}, {"\uBEEB", "\uBEEB"}, {"\uBEEC", "\uBEEC"}, {"\uBEED", "\uBEED"},
    {"\uBEEE", "\uBEEE"}, {"\uBEEF", "\uBEEF"}, {"\uBEF0", "\uBEF0"}, {"\uBEF1", "\uBEF1"}, {"\uBEF2", "\uBEF2"},
    {"\uBEF3", "\uBEF3"}, {"\uBEF4", "\uBEF4"}, {"\uBEF5", "\uBEF5"}, {"\uBEF6", "\uBEF6"}, {"\uBEF7", "\uBEF7"},
    {"\uBEF8", "\uBEF8"}, {"\uBEF9", "\uBEF9"}, {"\uBEFA", "\uBEFA"}, {"\uBEFB", "\uBEFB"}, {"\uBEFC", "\uBEFC"},
    {"\uBEFD", "\uBEFD"}, {"\uBEFE", "\uBEFE"}, {"\uBEFF", "\uBEFF"}, {"\uBF00", "\uBF00"}, {"\uBF01", "\uBF01"},
    {"\uBF02", "\uBF02"}, {"\uBF03", "\uBF03"}, {"\uBF04", "\uBF04"}, {"\uBF05", "\uBF05"}, {"\uBF06", "\uBF06"},
    {"\uBF07", "\uBF07"}, {"\uBF08", "\uBF08"}, {"\uBF09", "\uBF09"}, {"\uBF0A", "\uBF0A"}, {"\uBF0B", "\uBF0B"},
    {"\uBF0C", "\uBF0C"}, {"\uBF0D", "\uBF0D"}, {"\uBF0E", "\uBF0E"}, {"\uBF0F", "\uBF0F"}, {"\uBF10", "\uBF10"},
    {"\uBF11", "\uBF11"}, {"\uBF12", "\uBF12"}, {"\uBF13", "\uBF13"}, {"\uBF14", "\uBF14"}, {"\uBF15", "\uBF15"},
    {"\uBF16", "\uBF16"}, {"\uBF17", "\uBF17"}, {"\uBF18", "\uBF18"}, {"\uBF19", "\uBF19"}, {"\uBF1A", "\uBF1A"},
    {"\uBF1B", "\uBF1B"}, {"\uBF1C", "\uBF1C"}, {"\uBF1D", "\uBF1D"}, {"\uBF1E", "\uBF1E"}, {"\uBF1F", "\uBF1F"},
    {"\uBF20", "\uBF20"}, {"\uBF21", "\uBF21"}, {"\uBF22", "\uBF22"}, {"\uBF23", "\uBF23"}, {"\uBF24", "\uBF24"},
    {"\uBF25", "\uBF25"}, {"\uBF26", "\uBF26"}, {"\uBF27", "\uBF27"}, {"\uBF28", "\uBF28"}, {"\uBF29", "\uBF29"},
    {"\uBF2A", "\uBF2A"}, {"\uBF2B", "\uBF2B"}, {"\uBF2C", "\uBF2C"}, {"\uBF2D", "\uBF2D"}, {"\uBF2E", "\uBF2E"},
    {"\uBF2F", "\uBF2F"}, {"\uBF30", "\uBF30"}, {"\uBF31", "\uBF31"}, {"\uBF32", "\uBF32"}, {"\uBF33", "\uBF33"},
    {"\uBF34", "\uBF34"}, {"\uBF35", "\uBF35"}, {"\uBF36", "\uBF36"}, {"\uBF37", "\uBF37"}, {"\uBF38", "\uBF38"},
    {"\uBF39", "\uBF39"}, {"\uBF3A", "\uBF3A"}, {"\uBF3B", "\uBF3B"}, {"\uBF3C", "\uBF3C"}, {"\uBF3D", "\uBF3D"},
    {"\uBF3E", "\uBF3E"}, {"\uBF3F", "\uBF3F"}, {"\uBF40", "\uBF40"}, {"\uBF41", "\uBF41"}, {"\uBF42", "\uBF42"},
    {"\uBF43", "\uBF43"}, {"\uBF44", "\uBF44"}, {"\uBF45", "\uBF45"}, {"\uBF46", "\uBF46"}, {"\uBF47", "\uBF47"},
    {"\uBF48", "\uBF48"}, {"\uBF49", "\uBF49"}, {"\uBF4A", "\uBF4A"}, {"\uBF4B", "\uBF4B"}, {"\uBF4C", "\uBF4C"},
    {"\uBF4D", "\uBF4D"}, {"\uBF4E", "\uBF4E"}, {"\uBF4F", "\uBF4F"}, {"\uBF50", "\uBF50"}, {"\uBF51", "\uBF51"},
    {"\uBF52", "\uBF52"}, {"\uBF53", "\uBF53"}, {"\uBF54", "\uBF54"}, {"\uBF55", "\uBF55"}, {"\uBF56", "\uBF56"},
    {"\uBF57", "\uBF57"}, {"\uBF58", "\uBF58"}, {"\uBF59", "\uBF59"}, {"\uBF5A", "\uBF5A"}, {"\uBF5B", "\uBF5B"},
    {"\uBF5C", "\uBF5C"}, {"\uBF5D", "\uBF5D"}, {"\uBF5E", "\uBF5E"}, {"\uBF5F", "\uBF5F"}, {"\uBF60", "\uBF60"},
    {"\uBF61", "\uBF61"}, {"\uBF62", "\uBF62"}, {"\uBF63", "\uBF63"}, {"\uBF64", "\uBF64"}, {"\uBF65", "\uBF65"},
    {"\uBF66", "\uBF66"}, {"\uBF67", "\uBF67"}, {"\uBF68", "\uBF68"}, {"\uBF69", "\uBF69"}, {"\uBF6A", "\uBF6A"},
    {"\uBF6B", "\uBF6B"}, {"\uBF6C", "\uBF6C"}, {"\uBF6D", "\uBF6D"}, {"\uBF6E", "\uBF6E"}, {"\uBF6F", "\uBF6F"},
    {"\uBF70", "\uBF70"}, {"\uBF71", "\uBF71"}, {"\uBF72", "\uBF72"}, {"\uBF73", "\uBF73"}, {"\uBF74", "\uBF74"},
    {"\uBF75", "\uBF75"}, {"\uBF76", "\uBF76"}, {"\uBF77", "\uBF77"}, {"\uBF78", "\uBF78"}, {"\uBF79", "\uBF79"},
    {"\uBF7A", "\uBF7A"}, {"\uBF7B", "\uBF7B"}, {"\uBF7C", "\uBF7C"}, {"\uBF7D", "\uBF7D"}, {"\uBF7E", "\uBF7E"},
    {"\uBF7F", "\uBF7F"}, {"\uBF80", "\uBF80"}, {"\uBF81", "\uBF81"}, {"\uBF82", "\uBF82"}, {"\uBF83", "\uBF83"},
    {"\uBF84", "\uBF84"}, {"\uBF85", "\uBF85"}, {"\uBF86", "\uBF86"}, {"\uBF87", "\uBF87"}, {"\uBF88", "\uBF88"},
    {"\uBF89", "\uBF89"}, {"\uBF8A", "\uBF8A"}, {"\uBF8B", "\uBF8B"}, {"\uBF8C", "\uBF8C"}, {"\uBF8D", "\uBF8D"},
    {"\uBF8E", "\uBF8E"}, {"\uBF8F", "\uBF8F"}, {"\uBF90", "\uBF90"}, {"\uBF91", "\uBF91"}, {"\uBF92", "\uBF92"},
    {"\uBF93", "\uBF93"}, {"\uBF94", "\uBF94"}, {"\uBF95", "\uBF95"}, {"\uBF96", "\uBF96"}, {"\uBF97", "\uBF97"},
    {"\uBF98", "\uBF98"}, {"\uBF99", "\uBF99"}, {"\uBF9A", "\uBF9A"}, {"\uBF9B", "\uBF9B"}, {"\uBF9C", "\uBF9C"},
    {"\uBF9D", "\uBF9D"}, {"\uBF9E", "\uBF9E"}, {"\uBF9F", "\uBF9F"}, {"\uBFA0", "\uBFA0"}, {"\uBFA1", "\uBFA1"},
    {"\uBFA2", "\uBFA2"}, {"\uBFA3", "\uBFA3"}, {"\uBFA4", "\uBFA4"}, {"\uBFA5", "\uBFA5"}, {"\uBFA6", "\uBFA6"},
    {"\uBFA7", "\uBFA7"}, {"\uBFA8", "\uBFA8"}, {"\uBFA9", "\uBFA9"}, {"\uBFAA", "\uBFAA"}, {"\uBFAB", "\uBFAB"},
    {"\uBFAC", "\uBFAC"}, {"\uBFAD", "\uBFAD"}, {"\uBFAE", "\uBFAE"}, {"\uBFAF", "\uBFAF"}, {"\uBFB0", "\uBFB0"},
    {"\uBFB1", "\uBFB1"}, {"\uBFB2", "\uBFB2"}, {"\uBFB3", "\uBFB3"}, {"\uBFB4", "\uBFB4"}, {"\uBFB5", "\uBFB5"},
    {"\uBFB6", "\uBFB6"}, {"\uBFB7", "\uBFB7"}, {"\uBFB8", "\uBFB8"}, {"\uBFB9", "\uBFB9"}, {"\uBFBA", "\uBFBA"},
    {"\uBFBB", "\uBFBB"}, {"\uBFBC", "\uBFBC"}, {"\uBFBD", "\uBFBD"}, {"\uBFBE", "\uBFBE"}, {"\uBFBF", "\uBFBF"},
    {"\uBFC0", "\uBFC0"}, {"\uBFC1", "\uBFC1"}, {"\uBFC2", "\uBFC2"}, {"\uBFC3", "\uBFC3"}, {"\uBFC4", "\uBFC4"},
    {"\uBFC5", "\uBFC5"}, {"\uBFC6", "\uBFC6"}, {"\uBFC7", "\uBFC7"}, {"\uBFC8", "\uBFC8"}, {"\uBFC9", "\uBFC9"},
    {"\uBFCA", "\uBFCA"}, {"\uBFCB", "\uBFCB"}, {"\uBFCC", "\uBFCC"}, {"\uBFCD", "\uBFCD"}, {"\uBFCE", "\uBFCE"},
    {"\uBFCF", "\uBFCF"}, {"\uBFD0", "\uBFD0"}, {"\uBFD1", "\uBFD1"}, {"\uBFD2", "\uBFD2"}, {"\uBFD3", "\uBFD3"},
    {"\uBFD4", "\uBFD4"}, {"\uBFD5", "\uBFD5"}, {"\uBFD6", "\uBFD6"}, {"\uBFD7", "\uBFD7"}, {"\uBFD8", "\uBFD8"},
    {"\uBFD9", "\uBFD9"}, {"\uBFDA", "\uBFDA"}, {"\uBFDB", "\uBFDB"}, {"\uBFDC", "\uBFDC"}, {"\uBFDD", "\uBFDD"},
    {"\uBFDE", "\uBFDE"}, {"\uBFDF", "\uBFDF"}, {"\uBFE0", "\uBFE0"}, {"\uBFE1", "\uBFE1"}, {"\uBFE2", "\uBFE2"},
    {"\uBFE3", "\uBFE3"}, {"\uBFE4", "\uBFE4"}, {"\uBFE5", "\uBFE5"}, {"\uBFE6", "\uBFE6"}, {"\uBFE7", "\uBFE7"},
    {"\uBFE8", "\uBFE8"}, {"\uBFE9", "\uBFE9"}, {"\uBFEA", "\uBFEA"}, {"\uBFEB", "\uBFEB"}, {"\uBFEC", "\uBFEC"},
    {"\uBFED", "\uBFED"}, {"\uBFEE", "\uBFEE"}, {"\uBFEF", "\uBFEF"}, {"\uBFF0", "\uBFF0"}, {"\uBFF1", "\uBFF1"},
    {"\uBFF2", "\uBFF2"}, {"\uBFF3", "\uBFF3"}, {"\uBFF4", "\uBFF4"}, {"\uBFF5", "\uBFF5"}, {"\uBFF6", "\uBFF6"},
    {"\uBFF7", "\uBFF7"}, {"\uBFF8", "\uBFF8"}, {"\uBFF9", "\uBFF9"}, {"\uBFFA", "\uBFFA"}, {"\uBFFB", "\uBFFB"},
    {"\uBFFC", "\uBFFC"}, {"\uBFFD", "\uBFFD"}, {"\uBFFE", "\uBFFE"}, {"\uBFFF", "\uBFFF"}, {"\uC000", "\uC000"},
    {"\uC001", "\uC001"}, {"\uC002", "\uC002"}, {"\uC003", "\uC003"}, {"\uC004", "\uC004"}, {"\uC005", "\uC005"},
    {"\uC006", "\uC006"}, {"\uC007", "\uC007"}, {"\uC008", "\uC008"}, {"\uC009", "\uC009"}, {"\uC00A", "\uC00A"},
    {"\uC00B", "\uC00B"}, {"\uC00C", "\uC00C"}, {"\uC00D", "\uC00D"}, {"\uC00E", "\uC00E"}, {"\uC00F", "\uC00F"},
    {"\uC010", "\uC010"}, {"\uC011", "\uC011"}, {"\uC012", "\uC012"}, {"\uC013", "\uC013"}, {"\uC014", "\uC014"},
    {"\uC015", "\uC015"}, {"\uC016", "\uC016"}, {"\uC017", "\uC017"}, {"\uC018", "\uC018"}, {"\uC019", "\uC019"},
    {"\uC01A", "\uC01A"}, {"\uC01B", "\uC01B"}, {"\uC01C", "\uC01C"}, {"\uC01D", "\uC01D"}, {"\uC01E", "\uC01E"},
    {"\uC01F", "\uC01F"}, {"\uC020", "\uC020"}, {"\uC021", "\uC021"}, {"\uC022", "\uC022"}, {"\uC023", "\uC023"},
    {"\uC024", "\uC024"}, {"\uC025", "\uC025"}, {"\uC026", "\uC026"}, {"\uC027", "\uC027"}, {"\uC028", "\uC028"},
    {"\uC029", "\uC029"}, {"\uC02A", "\uC02A"}, {"\uC02B", "\uC02B"}, {"\uC02C", "\uC02C"}, {"\uC02D", "\uC02D"},
    {"\uC02E", "\uC02E"}, {"\uC02F", "\uC02F"}, {"\uC030", "\uC030"}, {"\uC031", "\uC031"}, {"\uC032", "\uC032"},
    {"\uC033", "\uC033"}, {"\uC034", "\uC034"}, {"\uC035", "\uC035"}, {"\uC036", "\uC036"}, {"\uC037", "\uC037"},
    {"\uC038", "\uC038"}, {"\uC039", "\uC039"}, {"\uC03A", "\uC03A"}, {"\uC03B", "\uC03B"}, {"\uC03C", "\uC03C"},
    {"\uC03D", "\uC03D"}, {"\uC03E", "\uC03E"}, {"\uC03F", "\uC03F"}, {"\uC040", "\uC040"}, {"\uC041", "\uC041"},
    {"\uC042", "\uC042"}, {"\uC043", "\uC043"}, {"\uC044", "\uC044"}, {"\uC045", "\uC045"}, {"\uC046", "\uC046"},
    {"\uC047", "\uC047"}, {"\uC048", "\uC048"}, {"\uC049", "\uC049"}, {"\uC04A", "\uC04A"}, {"\uC04B", "\uC04B"},
    {"\uC04C", "\uC04C"}, {"\uC04D", "\uC04D"}, {"\uC04E", "\uC04E"}, {"\uC04F", "\uC04F"}, {"\uC050", "\uC050"},
    {"\uC051", "\uC051"}, {"\uC052", "\uC052"}, {"\uC053", "\uC053"}, {"\uC054", "\uC054"}, {"\uC055", "\uC055"},
    {"\uC056", "\uC056"}, {"\uC057", "\uC057"}, {"\uC058", "\uC058"}, {"\uC059", "\uC059"}, {"\uC05A", "\uC05A"},
    {"\uC05B", "\uC05B"}, {"\uC05C", "\uC05C"}, {"\uC05D", "\uC05D"}, {"\uC05E", "\uC05E"}, {"\uC05F", "\uC05F"},
    {"\uC060", "\uC060"}, {"\uC061", "\uC061"}, {"\uC062", "\uC062"}, {"\uC063", "\uC063"}, {"\uC064", "\uC064"},
    {"\uC065", "\uC065"}, {"\uC066", "\uC066"}, {"\uC067", "\uC067"}, {"\uC068", "\uC068"}, {"\uC069", "\uC069"},
    {"\uC06A", "\uC06A"}, {"\uC06B", "\uC06B"}, {"\uC06C", "\uC06C"}, {"\uC06D", "\uC06D"}, {"\uC06E", "\uC06E"},
    {"\uC06F", "\uC06F"}, {"\uC070", "\uC070"}, {"\uC071", "\uC071"}, {"\uC072", "\uC072"}, {"\uC073", "\uC073"},
    {"\uC074", "\uC074"}, {"\uC075", "\uC075"}, {"\uC076", "\uC076"}, {"\uC077", "\uC077"}, {"\uC078", "\uC078"},
    {"\uC079", "\uC079"}, {"\uC07A", "\uC07A"}, {"\uC07B", "\uC07B"}, {"\uC07C", "\uC07C"}, {"\uC07D", "\uC07D"},
    {"\uC07E", "\uC07E"}, {"\uC07F", "\uC07F"}, {"\uC080", "\uC080"}, {"\uC081", "\uC081"}, {"\uC082", "\uC082"},
    {"\uC083", "\uC083"}, {"\uC084", "\uC084"}, {"\uC085", "\uC085"}, {"\uC086", "\uC086"}, {"\uC087", "\uC087"},
    {"\uC088", "\uC088"}, {"\uC089", "\uC089"}, {"\uC08A", "\uC08A"}, {"\uC08B", "\uC08B"}, {"\uC08C", "\uC08C"},
    {"\uC08D", "\uC08D"}, {"\uC08E", "\uC08E"}, {"\uC08F", "\uC08F"}, {"\uC090", "\uC090"}, {"\uC091", "\uC091"},
    {"\uC092", "\uC092"}, {"\uC093", "\uC093"}, {"\uC094", "\uC094"}, {"\uC095", "\uC095"}, {"\uC096", "\uC096"},
    {"\uC097", "\uC097"}, {"\uC098", "\uC098"}, {"\uC099", "\uC099"}, {"\uC09A", "\uC09A"}, {"\uC09B", "\uC09B"},
    {"\uC09C", "\uC09C"}, {"\uC09D", "\uC09D"}, {"\uC09E", "\uC09E"}, {"\uC09F", "\uC09F"}, {"\uC0A0", "\uC0A0"},
    {"\uC0A1", "\uC0A1"}, {"\uC0A2", "\uC0A2"}, {"\uC0A3", "\uC0A3"}, {"\uC0A4", "\uC0A4"}, {"\uC0A5", "\uC0A5"},
    {"\uC0A6", "\uC0A6"}, {"\uC0A7", "\uC0A7"}, {"\uC0A8", "\uC0A8"}, {"\uC0A9", "\uC0A9"}, {"\uC0AA", "\uC0AA"},
    {"\uC0AB", "\uC0AB"}, {"\uC0AC", "\uC0AC"}, {"\uC0AD", "\uC0AD"}, {"\uC0AE", "\uC0AE"}, {"\uC0AF", "\uC0AF"},
    {"\uC0B0", "\uC0B0"}, {"\uC0B1", "\uC0B1"}, {"\uC0B2", "\uC0B2"}, {"\uC0B3", "\uC0B3"}, {"\uC0B4", "\uC0B4"},
    {"\uC0B5", "\uC0B5"}, {"\uC0B6", "\uC0B6"}, {"\uC0B7", "\uC0B7"}, {"\uC0B8", "\uC0B8"}, {"\uC0B9", "\uC0B9"},
    {"\uC0BA", "\uC0BA"}, {"\uC0BB", "\uC0BB"}, {"\uC0BC", "\uC0BC"}, {"\uC0BD", "\uC0BD"}, {"\uC0BE", "\uC0BE"},
    {"\uC0BF", "\uC0BF"}, {"\uC0C0", "\uC0C0"}, {"\uC0C1", "\uC0C1"}, {"\uC0C2", "\uC0C2"}, {"\uC0C3", "\uC0C3"},
    {"\uC0C4", "\uC0C4"}, {"\uC0C5", "\uC0C5"}, {"\uC0C6", "\uC0C6"}, {"\uC0C7", "\uC0C7"}, {"\uC0C8", "\uC0C8"},
    {"\uC0C9", "\uC0C9"}, {"\uC0CA", "\uC0CA"}, {"\uC0CB", "\uC0CB"}, {"\uC0CC", "\uC0CC"}, {"\uC0CD", "\uC0CD"},
    {"\uC0CE", "\uC0CE"}, {"\uC0CF", "\uC0CF"}, {"\uC0D0", "\uC0D0"}, {"\uC0D1", "\uC0D1"}, {"\uC0D2", "\uC0D2"},
    {"\uC0D3", "\uC0D3"}, {"\uC0D4", "\uC0D4"}, {"\uC0D5", "\uC0D5"}, {"\uC0D6", "\uC0D6"}, {"\uC0D7", "\uC0D7"},
    {"\uC0D8", "\uC0D8"}, {"\uC0D9", "\uC0D9"}, {"\uC0DA", "\uC0DA"}, {"\uC0DB", "\uC0DB"}, {"\uC0DC", "\uC0DC"},
    {"\uC0DD", "\uC0DD"}, {"\uC0DE", "\uC0DE"}, {"\uC0DF", "\uC0DF"}, {"\uC0E0", "\uC0E0"}, {"\uC0E1", "\uC0E1"},
    {"\uC0E2", "\uC0E2"}, {"\uC0E3", "\uC0E3"}, {"\uC0E4", "\uC0E4"}, {"\uC0E5", "\uC0E5"}, {"\uC0E6", "\uC0E6"},
    {"\uC0E7", "\uC0E7"}, {"\uC0E8", "\uC0E8"}, {"\uC0E9", "\uC0E9"}, {"\uC0EA", "\uC0EA"}, {"\uC0EB", "\uC0EB"},
    {"\uC0EC", "\uC0EC"}, {"\uC0ED", "\uC0ED"}, {"\uC0EE", "\uC0EE"}, {"\uC0EF", "\uC0EF"}, {"\uC0F0", "\uC0F0"},
    {"\uC0F1", "\uC0F1"}, {"\uC0F2", "\uC0F2"}, {"\uC0F3", "\uC0F3"}, {"\uC0F4", "\uC0F4"}, {"\uC0F5", "\uC0F5"},
    {"\uC0F6", "\uC0F6"}, {"\uC0F7", "\uC0F7"}, {"\uC0F8", "\uC0F8"}, {"\uC0F9", "\uC0F9"}, {"\uC0FA", "\uC0FA"},
    {"\uC0FB", "\uC0FB"}, {"\uC0FC", "\uC0FC"}, {"\uC0FD", "\uC0FD"}, {"\uC0FE", "\uC0FE"}, {"\uC0FF", "\uC0FF"},
    {"\uC100", "\uC100"}, {"\uC101", "\uC101"}, {"\uC102", "\uC102"}, {"\uC103", "\uC103"}, {"\uC104", "\uC104"},
    {"\uC105", "\uC105"}, {"\uC106", "\uC106"}, {"\uC107", "\uC107"}, {"\uC108", "\uC108"}, {"\uC109", "\uC109"},
    {"\uC10A", "\uC10A"}, {"\uC10B", "\uC10B"}, {"\uC10C", "\uC10C"}, {"\uC10D", "\uC10D"}, {"\uC10E", "\uC10E"},
    {"\uC10F", "\uC10F"}, {"\uC110", "\uC110"}, {"\uC111", "\uC111"}, {"\uC112", "\uC112"}, {"\uC113", "\uC113"},
    {"\uC114", "\uC114"}, {"\uC115", "\uC115"}, {"\uC116", "\uC116"}, {"\uC117", "\uC117"}, {"\uC118", "\uC118"},
    {"\uC119", "\uC119"}, {"\uC11A", "\uC11A"}, {"\uC11B", "\uC11B"}, {"\uC11C", "\uC11C"}, {"\uC11D", "\uC11D"},
    {"\uC11E", "\uC11E"}, {"\uC11F", "\uC11F"}, {"\uC120", "\uC120"}, {"\uC121", "\uC121"}, {"\uC122", "\uC122"},
    {"\uC123", "\uC123"}, {"\uC124", "\uC124"}, {"\uC125", "\uC125"}, {"\uC126", "\uC126"}, {"\uC127", "\uC127"},
    {"\uC128", "\uC128"}, {"\uC129", "\uC129"}, {"\uC12A", "\uC12A"}, {"\uC12B", "\uC12B"}, {"\uC12C", "\uC12C"},
    {"\uC12D", "\uC12D"}, {"\uC12E", "\uC12E"}, {"\uC12F", "\uC12F"}, {"\uC130", "\uC130"}, {"\uC131", "\uC131"},
    {"\uC132", "\uC132"}, {"\uC133", "\uC133"}, {"\uC134", "\uC134"}, {"\uC135", "\uC135"}, {"\uC136", "\uC136"},
    {"\uC137", "\uC137"}, {"\uC138", "\uC138"}, {"\uC139", "\uC139"}, {"\uC13A", "\uC13A"}, {"\uC13B", "\uC13B"},
    {"\uC13C", "\uC13C"}, {"\uC13D", "\uC13D"}, {"\uC13E", "\uC13E"}, {"\uC13F", "\uC13F"}, {"\uC140", "\uC140"},
    {"\uC141", "\uC141"}, {"\uC142", "\uC142"}, {"\uC143", "\uC143"}, {"\uC144", "\uC144"}, {"\uC145", "\uC145"},
    {"\uC146", "\uC146"}, {"\uC147", "\uC147"}, {"\uC148", "\uC148"}, {"\uC149", "\uC149"}, {"\uC14A", "\uC14A"},
    {"\uC14B", "\uC14B"}, {"\uC14C", "\uC14C"}, {"\uC14D", "\uC14D"}, {"\uC14E", "\uC14E"}, {"\uC14F", "\uC14F"},
    {"\uC150", "\uC150"}, {"\uC151", "\uC151"}, {"\uC152", "\uC152"}, {"\uC153", "\uC153"}, {"\uC154", "\uC154"},
    {"\uC155", "\uC155"}, {"\uC156", "\uC156"}, {"\uC157", "\uC157"}, {"\uC158", "\uC158"}, {"\uC159", "\uC159"},
    {"\uC15A", "\uC15A"}, {"\uC15B", "\uC15B"}, {"\uC15C", "\uC15C"}, {"\uC15D", "\uC15D"}, {"\uC15E", "\uC15E"},
    {"\uC15F", "\uC15F"}, {"\uC160", "\uC160"}, {"\uC161", "\uC161"}, {"\uC162", "\uC162"}, {"\uC163", "\uC163"},
    {"\uC164", "\uC164"}, {"\uC165", "\uC165"}, {"\uC166", "\uC166"}, {"\uC167", "\uC167"}, {"\uC168", "\uC168"},
    {"\uC169", "\uC169"}, {"\uC16A", "\uC16A"}, {"\uC16B", "\uC16B"}, {"\uC16C", "\uC16C"}, {"\uC16D", "\uC16D"},
    {"\uC16E", "\uC16E"}, {"\uC16F", "\uC16F"}, {"\uC170", "\uC170"}, {"\uC171", "\uC171"}, {"\uC172", "\uC172"},
    {"\uC173", "\uC173"}, {"\uC174", "\uC174"}, {"\uC175", "\uC175"}, {"\uC176", "\uC176"}, {"\uC177", "\uC177"},
    {"\uC178", "\uC178"}, {"\uC179", "\uC179"}, {"\uC17A", "\uC17A"}, {"\uC17B", "\uC17B"}, {"\uC17C", "\uC17C"},
    {"\uC17D", "\uC17D"}, {"\uC17E", "\uC17E"}, {"\uC17F", "\uC17F"}, {"\uC180", "\uC180"}, {"\uC181", "\uC181"},
    {"\uC182", "\uC182"}, {"\uC183", "\uC183"}, {"\uC184", "\uC184"}, {"\uC185", "\uC185"}, {"\uC186", "\uC186"},
    {"\uC187", "\uC187"}, {"\uC188", "\uC188"}, {"\uC189", "\uC189"}, {"\uC18A", "\uC18A"}, {"\uC18B", "\uC18B"},
    {"\uC18C", "\uC18C"}, {"\uC18D", "\uC18D"}, {"\uC18E", "\uC18E"}, {"\uC18F", "\uC18F"}, {"\uC190", "\uC190"},
    {"\uC191", "\uC191"}, {"\uC192", "\uC192"}, {"\uC193", "\uC193"}, {"\uC194", "\uC194"}, {"\uC195", "\uC195"},
    {"\uC196", "\uC196"}, {"\uC197", "\uC197"}, {"\uC198", "\uC198"}, {"\uC199", "\uC199"}, {"\uC19A", "\uC19A"},
    {"\uC19B", "\uC19B"}, {"\uC19C", "\uC19C"}, {"\uC19D", "\uC19D"}, {"\uC19E", "\uC19E"}, {"\uC19F", "\uC19F"},
    {"\uC1A0", "\uC1A0"}, {"\uC1A1", "\uC1A1"}, {"\uC1A2", "\uC1A2"}, {"\uC1A3", "\uC1A3"}, {"\uC1A4", "\uC1A4"},
    {"\uC1A5", "\uC1A5"}, {"\uC1A6", "\uC1A6"}, {"\uC1A7", "\uC1A7"}, {"\uC1A8", "\uC1A8"}, {"\uC1A9", "\uC1A9"},
    {"\uC1AA", "\uC1AA"}, {"\uC1AB", "\uC1AB"}, {"\uC1AC", "\uC1AC"}, {"\uC1AD", "\uC1AD"}, {"\uC1AE", "\uC1AE"},
    {"\uC1AF", "\uC1AF"}, {"\uC1B0", "\uC1B0"}, {"\uC1B1", "\uC1B1"}, {"\uC1B2", "\uC1B2"}, {"\uC1B3", "\uC1B3"},
    {"\uC1B4", "\uC1B4"}, {"\uC1B5", "\uC1B5"}, {"\uC1B6", "\uC1B6"}, {"\uC1B7", "\uC1B7"}, {"\uC1B8", "\uC1B8"},
    {"\uC1B9", "\uC1B9"}, {"\uC1BA", "\uC1BA"}, {"\uC1BB", "\uC1BB"}, {"\uC1BC", "\uC1BC"}, {"\uC1BD", "\uC1BD"},
    {"\uC1BE", "\uC1BE"}, {"\uC1BF", "\uC1BF"}, {"\uC1C0", "\uC1C0"}, {"\uC1C1", "\uC1C1"}, {"\uC1C2", "\uC1C2"},
    {"\uC1C3", "\uC1C3"}, {"\uC1C4", "\uC1C4"}, {"\uC1C5", "\uC1C5"}, {"\uC1C6", "\uC1C6"}, {"\uC1C7", "\uC1C7"},
    {"\uC1C8", "\uC1C8"}, {"\uC1C9", "\uC1C9"}, {"\uC1CA", "\uC1CA"}, {"\uC1CB", "\uC1CB"}, {"\uC1CC", "\uC1CC"},
    {"\uC1CD", "\uC1CD"}, {"\uC1CE", "\uC1CE"}, {"\uC1CF", "\uC1CF"}, {"\uC1D0", "\uC1D0"}, {"\uC1D1", "\uC1D1"},
    {"\uC1D2", "\uC1D2"}, {"\uC1D3", "\uC1D3"}, {"\uC1D4", "\uC1D4"}, {"\uC1D5", "\uC1D5"}, {"\uC1D6", "\uC1D6"},
    {"\uC1D7", "\uC1D7"}, {"\uC1D8", "\uC1D8"}, {"\uC1D9", "\uC1D9"}, {"\uC1DA", "\uC1DA"}, {"\uC1DB", "\uC1DB"},
    {"\uC1DC", "\uC1DC"}, {"\uC1DD", "\uC1DD"}, {"\uC1DE", "\uC1DE"}, {"\uC1DF", "\uC1DF"}, {"\uC1E0", "\uC1E0"},
    {"\uC1E1", "\uC1E1"}, {"\uC1E2", "\uC1E2"}, {"\uC1E3", "\uC1E3"}, {"\uC1E4", "\uC1E4"}, {"\uC1E5", "\uC1E5"},
    {"\uC1E6", "\uC1E6"}, {"\uC1E7", "\uC1E7"}, {"\uC1E8", "\uC1E8"}, {"\uC1E9", "\uC1E9"}, {"\uC1EA", "\uC1EA"},
    {"\uC1EB", "\uC1EB"}, {"\uC1EC", "\uC1EC"}, {"\uC1ED", "\uC1ED"}, {"\uC1EE", "\uC1EE"}, {"\uC1EF", "\uC1EF"},
    {"\uC1F0", "\uC1F0"}, {"\uC1F1", "\uC1F1"}, {"\uC1F2", "\uC1F2"}, {"\uC1F3", "\uC1F3"}, {"\uC1F4", "\uC1F4"},
    {"\uC1F5", "\uC1F5"}, {"\uC1F6", "\uC1F6"}, {"\uC1F7", "\uC1F7"}, {"\uC1F8", "\uC1F8"}, {"\uC1F9", "\uC1F9"},
    {"\uC1FA", "\uC1FA"}, {"\uC1FB", "\uC1FB"}, {"\uC1FC", "\uC1FC"}, {"\uC1FD", "\uC1FD"}, {"\uC1FE", "\uC1FE"},
    {"\uC1FF", "\uC1FF"}, {"\uC200", "\uC200"}, {"\uC201", "\uC201"}, {"\uC202", "\uC202"}, {"\uC203", "\uC203"},
    {"\uC204", "\uC204"}, {"\uC205", "\uC205"}, {"\uC206", "\uC206"}, {"\uC207", "\uC207"}, {"\uC208", "\uC208"},
    {"\uC209", "\uC209"}, {"\uC20A", "\uC20A"}, {"\uC20B", "\uC20B"}, {"\uC20C", "\uC20C"}, {"\uC20D", "\uC20D"},
    {"\uC20E", "\uC20E"}, {"\uC20F", "\uC20F"}, {"\uC210", "\uC210"}, {"\uC211", "\uC211"}, {"\uC212", "\uC212"},
    {"\uC213", "\uC213"}, {"\uC214", "\uC214"}, {"\uC215", "\uC215"}, {"\uC216", "\uC216"}, {"\uC217", "\uC217"},
    {"\uC218", "\uC218"}, {"\uC219", "\uC219"}, {"\uC21A", "\uC21A"}, {"\uC21B", "\uC21B"}, {"\uC21C", "\uC21C"},
    {"\uC21D", "\uC21D"}, {"\uC21E", "\uC21E"}, {"\uC21F", "\uC21F"}, {"\uC220", "\uC220"}, {"\uC221", "\uC221"},
    {"\uC222", "\uC222"}, {"\uC223", "\uC223"}, {"\uC224", "\uC224"}, {"\uC225", "\uC225"}, {"\uC226", "\uC226"},
    {"\uC227", "\uC227"}, {"\uC228", "\uC228"}, {"\uC229", "\uC229"}, {"\uC22A", "\uC22A"}, {"\uC22B", "\uC22B"},
    {"\uC22C", "\uC22C"}, {"\uC22D", "\uC22D"}, {"\uC22E", "\uC22E"}, {"\uC22F", "\uC22F"}, {"\uC230", "\uC230"},
    {"\uC231", "\uC231"}, {"\uC232", "\uC232"}, {"\uC233", "\uC233"}, {"\uC234", "\uC234"}, {"\uC235", "\uC235"},
    {"\uC236", "\uC236"}, {"\uC237", "\uC237"}, {"\uC238", "\uC238"}, {"\uC239", "\uC239"}, {"\uC23A", "\uC23A"},
    {"\uC23B", "\uC23B"}, {"\uC23C", "\uC23C"}, {"\uC23D", "\uC23D"}, {"\uC23E", "\uC23E"}, {"\uC23F", "\uC23F"},
    {"\uC240", "\uC240"}, {"\uC241", "\uC241"}, {"\uC242", "\uC242"}, {"\uC243", "\uC243"}, {"\uC244", "\uC244"},
    {"\uC245", "\uC245"}, {"\uC246", "\uC246"}, {"\uC247", "\uC247"}, {"\uC248", "\uC248"}, {"\uC249", "\uC249"},
    {"\uC24A", "\uC24A"}, {"\uC24B", "\uC24B"}, {"\uC24C", "\uC24C"}, {"\uC24D", "\uC24D"}, {"\uC24E", "\uC24E"},
    {"\uC24F", "\uC24F"}, {"\uC250", "\uC250"}, {"\uC251", "\uC251"}, {"\uC252", "\uC252"}, {"\uC253", "\uC253"},
    {"\uC254", "\uC254"}, {"\uC255", "\uC255"}, {"\uC256", "\uC256"}, {"\uC257", "\uC257"}, {"\uC258", "\uC258"},
    {"\uC259", "\uC259"}, {"\uC25A", "\uC25A"}, {"\uC25B", "\uC25B"}, {"\uC25C", "\uC25C"}, {"\uC25D", "\uC25D"},
    {"\uC25E", "\uC25E"}, {"\uC25F", "\uC25F"}, {"\uC260", "\uC260"}, {"\uC261", "\uC261"}, {"\uC262", "\uC262"},
    {"\uC263", "\uC263"}, {"\uC264", "\uC264"}, {"\uC265", "\uC265"}, {"\uC266", "\uC266"}, {"\uC267", "\uC267"},
    {"\uC268", "\uC268"}, {"\uC269", "\uC269"}, {"\uC26A", "\uC26A"}, {"\uC26B", "\uC26B"}, {"\uC26C", "\uC26C"},
    {"\uC26D", "\uC26D"}, {"\uC26E", "\uC26E"}, {"\uC26F", "\uC26F"}, {"\uC270", "\uC270"}, {"\uC271", "\uC271"},
    {"\uC272", "\uC272"}, {"\uC273", "\uC273"}, {"\uC274", "\uC274"}, {"\uC275", "\uC275"}, {"\uC276", "\uC276"},
    {"\uC277", "\uC277"}, {"\uC278", "\uC278"}, {"\uC279", "\uC279"}, {"\uC27A", "\uC27A"}, {"\uC27B", "\uC27B"},
    {"\uC27C", "\uC27C"}, {"\uC27D", "\uC27D"}, {"\uC27E", "\uC27E"}, {"\uC27F", "\uC27F"}, {"\uC280", "\uC280"},
    {"\uC281", "\uC281"}, {"\uC282", "\uC282"}, {"\uC283", "\uC283"}, {"\uC284", "\uC284"}, {"\uC285", "\uC285"},
    {"\uC286", "\uC286"}, {"\uC287", "\uC287"}, {"\uC288", "\uC288"}, {"\uC289", "\uC289"}, {"\uC28A", "\uC28A"},
    {"\uC28B", "\uC28B"}, {"\uC28C", "\uC28C"}, {"\uC28D", "\uC28D"}, {"\uC28E", "\uC28E"}, {"\uC28F", "\uC28F"},
    {"\uC290", "\uC290"}, {"\uC291", "\uC291"}, {"\uC292", "\uC292"}, {"\uC293", "\uC293"}, {"\uC294", "\uC294"},
    {"\uC295", "\uC295"}, {"\uC296", "\uC296"}, {"\uC297", "\uC297"}, {"\uC298", "\uC298"}, {"\uC299", "\uC299"},
    {"\uC29A", "\uC29A"}, {"\uC29B", "\uC29B"}, {"\uC29C", "\uC29C"}, {"\uC29D", "\uC29D"}, {"\uC29E", "\uC29E"},
    {"\uC29F", "\uC29F"}, {"\uC2A0", "\uC2A0"}, {"\uC2A1", "\uC2A1"}, {"\uC2A2", "\uC2A2"}, {"\uC2A3", "\uC2A3"},
    {"\uC2A4", "\uC2A4"}, {"\uC2A5", "\uC2A5"}, {"\uC2A6", "\uC2A6"}, {"\uC2A7", "\uC2A7"}, {"\uC2A8", "\uC2A8"},
    {"\uC2A9", "\uC2A9"}, {"\uC2AA", "\uC2AA"}, {"\uC2AB", "\uC2AB"}, {"\uC2AC", "\uC2AC"}, {"\uC2AD", "\uC2AD"},
    {"\uC2AE", "\uC2AE"}, {"\uC2AF", "\uC2AF"}, {"\uC2B0", "\uC2B0"}, {"\uC2B1", "\uC2B1"}, {"\uC2B2", "\uC2B2"},
    {"\uC2B3", "\uC2B3"}, {"\uC2B4", "\uC2B4"}, {"\uC2B5", "\uC2B5"}, {"\uC2B6", "\uC2B6"}, {"\uC2B7", "\uC2B7"},
    {"\uC2B8", "\uC2B8"}, {"\uC2B9", "\uC2B9"}, {"\uC2BA", "\uC2BA"}, {"\uC2BB", "\uC2BB"}, {"\uC2BC", "\uC2BC"},
    {"\uC2BD", "\uC2BD"}, {"\uC2BE", "\uC2BE"}, {"\uC2BF", "\uC2BF"}, {"\uC2C0", "\uC2C0"}, {"\uC2C1", "\uC2C1"},
    {"\uC2C2", "\uC2C2"}, {"\uC2C3", "\uC2C3"}, {"\uC2C4", "\uC2C4"}, {"\uC2C5", "\uC2C5"}, {"\uC2C6", "\uC2C6"},
    {"\uC2C7", "\uC2C7"}, {"\uC2C8", "\uC2C8"}, {"\uC2C9", "\uC2C9"}, {"\uC2CA", "\uC2CA"}, {"\uC2CB", "\uC2CB"},
    {"\uC2CC", "\uC2CC"}, {"\uC2CD", "\uC2CD"}, {"\uC2CE", "\uC2CE"}, {"\uC2CF", "\uC2CF"}, {"\uC2D0", "\uC2D0"},
    {"\uC2D1", "\uC2D1"}, {"\uC2D2", "\uC2D2"}, {"\uC2D3", "\uC2D3"}, {"\uC2D4", "\uC2D4"}, {"\uC2D5", "\uC2D5"},
    {"\uC2D6", "\uC2D6"}, {"\uC2D7", "\uC2D7"}, {"\uC2D8", "\uC2D8"}, {"\uC2D9", "\uC2D9"}, {"\uC2DA", "\uC2DA"},
    {"\uC2DB", "\uC2DB"}, {"\uC2DC", "\uC2DC"}, {"\uC2DD", "\uC2DD"}, {"\uC2DE", "\uC2DE"}, {"\uC2DF", "\uC2DF"},
    {"\uC2E0", "\uC2E0"}, {"\uC2E1", "\uC2E1"}, {"\uC2E2", "\uC2E2"}, {"\uC2E3", "\uC2E3"}, {"\uC2E4", "\uC2E4"},
    {"\uC2E5", "\uC2E5"}, {"\uC2E6", "\uC2E6"}, {"\uC2E7", "\uC2E7"}, {"\uC2E8", "\uC2E8"}, {"\uC2E9", "\uC2E9"},
    {"\uC2EA", "\uC2EA"}, {"\uC2EB", "\uC2EB"}, {"\uC2EC", "\uC2EC"}, {"\uC2ED", "\uC2ED"}, {"\uC2EE", "\uC2EE"},
    {"\uC2EF", "\uC2EF"}, {"\uC2F0", "\uC2F0"}, {"\uC2F1", "\uC2F1"}, {"\uC2F2", "\uC2F2"}, {"\uC2F3", "\uC2F3"},
    {"\uC2F4", "\uC2F4"}, {"\uC2F5", "\uC2F5"}, {"\uC2F6", "\uC2F6"}, {"\uC2F7", "\uC2F7"}, {"\uC2F8", "\uC2F8"},
    {"\uC2F9", "\uC2F9"}, {"\uC2FA", "\uC2FA"}, {"\uC2FB", "\uC2FB"}, {"\uC2FC", "\uC2FC"}, {"\uC2FD", "\uC2FD"},
    {"\uC2FE", "\uC2FE"}, {"\uC2FF", "\uC2FF"}, {"\uC300", "\uC300"}, {"\uC301", "\uC301"}, {"\uC302", "\uC302"},
    {"\uC303", "\uC303"}, {"\uC304", "\uC304"}, {"\uC305", "\uC305"}, {"\uC306", "\uC306"}, {"\uC307", "\uC307"},
    {"\uC308", "\uC308"}, {"\uC309", "\uC309"}, {"\uC30A", "\uC30A"}, {"\uC30B", "\uC30B"}, {"\uC30C", "\uC30C"},
    {"\uC30D", "\uC30D"}, {"\uC30E", "\uC30E"}, {"\uC30F", "\uC30F"}, {"\uC310", "\uC310"}, {"\uC311", "\uC311"},
    {"\uC312", "\uC312"}, {"\uC313", "\uC313"}, {"\uC314", "\uC314"}, {"\uC315", "\uC315"}, {"\uC316", "\uC316"},
    {"\uC317", "\uC317"}, {"\uC318", "\uC318"}, {"\uC319", "\uC319"}, {"\uC31A", "\uC31A"}, {"\uC31B", "\uC31B"},
    {"\uC31C", "\uC31C"}, {"\uC31D", "\uC31D"}, {"\uC31E", "\uC31E"}, {"\uC31F", "\uC31F"}, {"\uC320", "\uC320"},
    {"\uC321", "\uC321"}, {"\uC322", "\uC322"}, {"\uC323", "\uC323"}, {"\uC324", "\uC324"}, {"\uC325", "\uC325"},
    {"\uC326", "\uC326"}, {"\uC327", "\uC327"}, {"\uC328", "\uC328"}, {"\uC329", "\uC329"}, {"\uC32A", "\uC32A"},
    {"\uC32B", "\uC32B"}, {"\uC32C", "\uC32C"}, {"\uC32D", "\uC32D"}, {"\uC32E", "\uC32E"}, {"\uC32F", "\uC32F"},
    {"\uC330", "\uC330"}, {"\uC331", "\uC331"}, {"\uC332", "\uC332"}, {"\uC333", "\uC333"}, {"\uC334", "\uC334"},
    {"\uC335", "\uC335"}, {"\uC336", "\uC336"}, {"\uC337", "\uC337"}, {"\uC338", "\uC338"}, {"\uC339", "\uC339"},
    {"\uC33A", "\uC33A"}, {"\uC33B", "\uC33B"}, {"\uC33C", "\uC33C"}, {"\uC33D", "\uC33D"}, {"\uC33E", "\uC33E"},
    {"\uC33F", "\uC33F"}, {"\uC340", "\uC340"}, {"\uC341", "\uC341"}, {"\uC342", "\uC342"}, {"\uC343", "\uC343"},
    {"\uC344", "\uC344"}, {"\uC345", "\uC345"}, {"\uC346", "\uC346"}, {"\uC347", "\uC347"}, {"\uC348", "\uC348"},
    {"\uC349", "\uC349"}, {"\uC34A", "\uC34A"}, {"\uC34B", "\uC34B"}, {"\uC34C", "\uC34C"}, {"\uC34D", "\uC34D"},
    {"\uC34E", "\uC34E"}, {"\uC34F", "\uC34F"}, {"\uC350", "\uC350"}, {"\uC351", "\uC351"}, {"\uC352", "\uC352"},
    {"\uC353", "\uC353"}, {"\uC354", "\uC354"}, {"\uC355", "\uC355"}, {"\uC356", "\uC356"}, {"\uC357", "\uC357"},
    {"\uC358", "\uC358"}, {"\uC359", "\uC359"}, {"\uC35A", "\uC35A"}, {"\uC35B", "\uC35B"}, {"\uC35C", "\uC35C"},
    {"\uC35D", "\uC35D"}, {"\uC35E", "\uC35E"}, {"\uC35F", "\uC35F"}, {"\uC360", "\uC360"}, {"\uC361", "\uC361"},
    {"\uC362", "\uC362"}, {"\uC363", "\uC363"}, {"\uC364", "\uC364"}, {"\uC365", "\uC365"}, {"\uC366", "\uC366"},
    {"\uC367", "\uC367"}, {"\uC368", "\uC368"}, {"\uC369", "\uC369"}, {"\uC36A", "\uC36A"}, {"\uC36B", "\uC36B"},
    {"\uC36C", "\uC36C"}, {"\uC36D", "\uC36D"}, {"\uC36E", "\uC36E"}, {"\uC36F", "\uC36F"}, {"\uC370", "\uC370"},
    {"\uC371", "\uC371"}, {"\uC372", "\uC372"}, {"\uC373", "\uC373"}, {"\uC374", "\uC374"}, {"\uC375", "\uC375"},
    {"\uC376", "\uC376"}, {"\uC377", "\uC377"}, {"\uC378", "\uC378"}, {"\uC379", "\uC379"}, {"\uC37A", "\uC37A"},
    {"\uC37B", "\uC37B"}, {"\uC37C", "\uC37C"}, {"\uC37D", "\uC37D"}, {"\uC37E", "\uC37E"}, {"\uC37F", "\uC37F"},
    {"\uC380", "\uC380"}, {"\uC381", "\uC381"}, {"\uC382", "\uC382"}, {"\uC383", "\uC383"}, {"\uC384", "\uC384"},
    {"\uC385", "\uC385"}, {"\uC386", "\uC386"}, {"\uC387", "\uC387"}, {"\uC388", "\uC388"}, {"\uC389", "\uC389"},
    {"\uC38A", "\uC38A"}, {"\uC38B", "\uC38B"}, {"\uC38C", "\uC38C"}, {"\uC38D", "\uC38D"}, {"\uC38E", "\uC38E"},
    {"\uC38F", "\uC38F"}, {"\uC390", "\uC390"}, {"\uC391", "\uC391"}, {"\uC392", "\uC392"}, {"\uC393", "\uC393"},
    {"\uC394", "\uC394"}, {"\uC395", "\uC395"}, {"\uC396", "\uC396"}, {"\uC397", "\uC397"}, {"\uC398", "\uC398"},
    {"\uC399", "\uC399"}, {"\uC39A", "\uC39A"}, {"\uC39B", "\uC39B"}, {"\uC39C", "\uC39C"}, {"\uC39D", "\uC39D"},
    {"\uC39E", "\uC39E"}, {"\uC39F", "\uC39F"}, {"\uC3A0", "\uC3A0"}, {"\uC3A1", "\uC3A1"}, {"\uC3A2", "\uC3A2"},
    {"\uC3A3", "\uC3A3"}, {"\uC3A4", "\uC3A4"}, {"\uC3A5", "\uC3A5"}, {"\uC3A6", "\uC3A6"}, {"\uC3A7", "\uC3A7"},
    {"\uC3A8", "\uC3A8"}, {"\uC3A9", "\uC3A9"}, {"\uC3AA", "\uC3AA"}, {"\uC3AB", "\uC3AB"}, {"\uC3AC", "\uC3AC"},
    {"\uC3AD", "\uC3AD"}, {"\uC3AE", "\uC3AE"}, {"\uC3AF", "\uC3AF"}, {"\uC3B0", "\uC3B0"}, {"\uC3B1", "\uC3B1"},
    {"\uC3B2", "\uC3B2"}, {"\uC3B3", "\uC3B3"}, {"\uC3B4", "\uC3B4"}, {"\uC3B5", "\uC3B5"}, {"\uC3B6", "\uC3B6"},
    {"\uC3B7", "\uC3B7"}, {"\uC3B8", "\uC3B8"}, {"\uC3B9", "\uC3B9"}, {"\uC3BA", "\uC3BA"}, {"\uC3BB", "\uC3BB"},
    {"\uC3BC", "\uC3BC"}, {"\uC3BD", "\uC3BD"}, {"\uC3BE", "\uC3BE"}, {"\uC3BF", "\uC3BF"}, {"\uC3C0", "\uC3C0"},
    {"\uC3C1", "\uC3C1"}, {"\uC3C2", "\uC3C2"}, {"\uC3C3", "\uC3C3"}, {"\uC3C4", "\uC3C4"}, {"\uC3C5", "\uC3C5"},
    {"\uC3C6", "\uC3C6"}, {"\uC3C7", "\uC3C7"}, {"\uC3C8", "\uC3C8"}, {"\uC3C9", "\uC3C9"}, {"\uC3CA", "\uC3CA"},
    {"\uC3CB", "\uC3CB"}, {"\uC3CC", "\uC3CC"}, {"\uC3CD", "\uC3CD"}, {"\uC3CE", "\uC3CE"}, {"\uC3CF", "\uC3CF"},
    {"\uC3D0", "\uC3D0"}, {"\uC3D1", "\uC3D1"}, {"\uC3D2", "\uC3D2"}, {"\uC3D3", "\uC3D3"}, {"\uC3D4", "\uC3D4"},
    {"\uC3D5", "\uC3D5"}, {"\uC3D6", "\uC3D6"}, {"\uC3D7", "\uC3D7"}, {"\uC3D8", "\uC3D8"}, {"\uC3D9", "\uC3D9"},
    {"\uC3DA", "\uC3DA"}, {"\uC3DB", "\uC3DB"}, {"\uC3DC", "\uC3DC"}, {"\uC3DD", "\uC3DD"}, {"\uC3DE", "\uC3DE"},
    {"\uC3DF", "\uC3DF"}, {"\uC3E0", "\uC3E0"}, {"\uC3E1", "\uC3E1"}, {"\uC3E2", "\uC3E2"}, {"\uC3E3", "\uC3E3"},
    {"\uC3E4", "\uC3E4"}, {"\uC3E5", "\uC3E5"}, {"\uC3E6", "\uC3E6"}, {"\uC3E7", "\uC3E7"}, {"\uC3E8", "\uC3E8"},
    {"\uC3E9", "\uC3E9"}, {"\uC3EA", "\uC3EA"}, {"\uC3EB", "\uC3EB"}, {"\uC3EC", "\uC3EC"}, {"\uC3ED", "\uC3ED"},
    {"\uC3EE", "\uC3EE"}, {"\uC3EF", "\uC3EF"}, {"\uC3F0", "\uC3F0"}, {"\uC3F1", "\uC3F1"}, {"\uC3F2", "\uC3F2"},
    {"\uC3F3", "\uC3F3"}, {"\uC3F4", "\uC3F4"}, {"\uC3F5", "\uC3F5"}, {"\uC3F6", "\uC3F6"}, {"\uC3F7", "\uC3F7"},
    {"\uC3F8", "\uC3F8"}, {"\uC3F9", "\uC3F9"}, {"\uC3FA", "\uC3FA"}, {"\uC3FB", "\uC3FB"}, {"\uC3FC", "\uC3FC"},
    {"\uC3FD", "\uC3FD"}, {"\uC3FE", "\uC3FE"}, {"\uC3FF", "\uC3FF"}, {"\uC400", "\uC400"}, {"\uC401", "\uC401"},
    {"\uC402", "\uC402"}, {"\uC403", "\uC403"}, {"\uC404", "\uC404"}, {"\uC405", "\uC405"}, {"\uC406", "\uC406"},
    {"\uC407", "\uC407"}, {"\uC408", "\uC408"}, {"\uC409", "\uC409"}, {"\uC40A", "\uC40A"}, {"\uC40B", "\uC40B"},
    {"\uC40C", "\uC40C"}, {"\uC40D", "\uC40D"}, {"\uC40E", "\uC40E"}, {"\uC40F", "\uC40F"}, {"\uC410", "\uC410"},
    {"\uC411", "\uC411"}, {"\uC412", "\uC412"}, {"\uC413", "\uC413"}, {"\uC414", "\uC414"}, {"\uC415", "\uC415"},
    {"\uC416", "\uC416"}, {"\uC417", "\uC417"}, {"\uC418", "\uC418"}, {"\uC419", "\uC419"}, {"\uC41A", "\uC41A"},
    {"\uC41B", "\uC41B"}, {"\uC41C", "\uC41C"}, {"\uC41D", "\uC41D"}, {"\uC41E", "\uC41E"}, {"\uC41F", "\uC41F"},
    {"\uC420", "\uC420"}, {"\uC421", "\uC421"}, {"\uC422", "\uC422"}, {"\uC423", "\uC423"}, {"\uC424", "\uC424"},
    {"\uC425", "\uC425"}, {"\uC426", "\uC426"}, {"\uC427", "\uC427"}, {"\uC428", "\uC428"}, {"\uC429", "\uC429"},
    {"\uC42A", "\uC42A"}, {"\uC42B", "\uC42B"}, {"\uC42C", "\uC42C"}, {"\uC42D", "\uC42D"}, {"\uC42E", "\uC42E"},
    {"\uC42F", "\uC42F"}, {"\uC430", "\uC430"}, {"\uC431", "\uC431"}, {"\uC432", "\uC432"}, {"\uC433", "\uC433"},
    {"\uC434", "\uC434"}, {"\uC435", "\uC435"}, {"\uC436", "\uC436"}, {"\uC437", "\uC437"}, {"\uC438", "\uC438"},
    {"\uC439", "\uC439"}, {"\uC43A", "\uC43A"}, {"\uC43B", "\uC43B"}, {"\uC43C", "\uC43C"}, {"\uC43D", "\uC43D"},
    {"\uC43E", "\uC43E"}, {"\uC43F", "\uC43F"}, {"\uC440", "\uC440"}, {"\uC441", "\uC441"}, {"\uC442", "\uC442"},
    {"\uC443", "\uC443"}, {"\uC444", "\uC444"}, {"\uC445", "\uC445"}, {"\uC446", "\uC446"}, {"\uC447", "\uC447"},
    {"\uC448", "\uC448"}, {"\uC449", "\uC449"}, {"\uC44A", "\uC44A"}, {"\uC44B", "\uC44B"}, {"\uC44C", "\uC44C"},
    {"\uC44D", "\uC44D"}, {"\uC44E", "\uC44E"}, {"\uC44F", "\uC44F"}, {"\uC450", "\uC450"}, {"\uC451", "\uC451"},
    {"\uC452", "\uC452"}, {"\uC453", "\uC453"}, {"\uC454", "\uC454"}, {"\uC455", "\uC455"}, {"\uC456", "\uC456"},
    {"\uC457", "\uC457"}, {"\uC458", "\uC458"}, {"\uC459", "\uC459"}, {"\uC45A", "\uC45A"}, {"\uC45B", "\uC45B"},
    {"\uC45C", "\uC45C"}, {"\uC45D", "\uC45D"}, {"\uC45E", "\uC45E"}, {"\uC45F", "\uC45F"}, {"\uC460", "\uC460"},
    {"\uC461", "\uC461"}, {"\uC462", "\uC462"}, {"\uC463", "\uC463"}, {"\uC464", "\uC464"}, {"\uC465", "\uC465"},
    {"\uC466", "\uC466"}, {"\uC467", "\uC467"}, {"\uC468", "\uC468"}, {"\uC469", "\uC469"}, {"\uC46A", "\uC46A"},
    {"\uC46B", "\uC46B"}, {"\uC46C", "\uC46C"}, {"\uC46D", "\uC46D"}, {"\uC46E", "\uC46E"}, {"\uC46F", "\uC46F"},
    {"\uC470", "\uC470"}, {"\uC471", "\uC471"}, {"\uC472", "\uC472"}, {"\uC473", "\uC473"}, {"\uC474", "\uC474"},
    {"\uC475", "\uC475"}, {"\uC476", "\uC476"}, {"\uC477", "\uC477"}, {"\uC478", "\uC478"}, {"\uC479", "\uC479"},
    {"\uC47A", "\uC47A"}, {"\uC47B", "\uC47B"}, {"\uC47C", "\uC47C"}, {"\uC47D", "\uC47D"}, {"\uC47E", "\uC47E"},
    {"\uC47F", "\uC47F"}, {"\uC480", "\uC480"}, {"\uC481", "\uC481"}, {"\uC482", "\uC482"}, {"\uC483", "\uC483"},
    {"\uC484", "\uC484"}, {"\uC485", "\uC485"}, {"\uC486", "\uC486"}, {"\uC487", "\uC487"}, {"\uC488", "\uC488"},
    {"\uC489", "\uC489"}, {"\uC48A", "\uC48A"}, {"\uC48B", "\uC48B"}, {"\uC48C", "\uC48C"}, {"\uC48D", "\uC48D"},
    {"\uC48E", "\uC48E"}, {"\uC48F", "\uC48F"}, {"\uC490", "\uC490"}, {"\uC491", "\uC491"}, {"\uC492", "\uC492"},
    {"\uC493", "\uC493"}, {"\uC494", "\uC494"}, {"\uC495", "\uC495"}, {"\uC496", "\uC496"}, {"\uC497", "\uC497"},
    {"\uC498", "\uC498"}, {"\uC499", "\uC499"}, {"\uC49A", "\uC49A"}, {"\uC49B", "\uC49B"}, {"\uC49C", "\uC49C"},
    {"\uC49D", "\uC49D"}, {"\uC49E", "\uC49E"}, {"\uC49F", "\uC49F"}, {"\uC4A0", "\uC4A0"}, {"\uC4A1", "\uC4A1"},
    {"\uC4A2", "\uC4A2"}, {"\uC4A3", "\uC4A3"}, {"\uC4A4", "\uC4A4"}, {"\uC4A5", "\uC4A5"}, {"\uC4A6", "\uC4A6"},
    {"\uC4A7", "\uC4A7"}, {"\uC4A8", "\uC4A8"}, {"\uC4A9", "\uC4A9"}, {"\uC4AA", "\uC4AA"}, {"\uC4AB", "\uC4AB"},
    {"\uC4AC", "\uC4AC"}, {"\uC4AD", "\uC4AD"}, {"\uC4AE", "\uC4AE"}, {"\uC4AF", "\uC4AF"}, {"\uC4B0", "\uC4B0"},
    {"\uC4B1", "\uC4B1"}, {"\uC4B2", "\uC4B2"}, {"\uC4B3", "\uC4B3"}, {"\uC4B4", "\uC4B4"}, {"\uC4B5", "\uC4B5"},
    {"\uC4B6", "\uC4B6"}, {"\uC4B7", "\uC4B7"}, {"\uC4B8", "\uC4B8"}, {"\uC4B9", "\uC4B9"}, {"\uC4BA", "\uC4BA"},
    {"\uC4BB", "\uC4BB"}, {"\uC4BC", "\uC4BC"}, {"\uC4BD", "\uC4BD"}, {"\uC4BE", "\uC4BE"}, {"\uC4BF", "\uC4BF"},
    {"\uC4C0", "\uC4C0"}, {"\uC4C1", "\uC4C1"}, {"\uC4C2", "\uC4C2"}, {"\uC4C3", "\uC4C3"}, {"\uC4C4", "\uC4C4"},
    {"\uC4C5", "\uC4C5"}, {"\uC4C6", "\uC4C6"}, {"\uC4C7", "\uC4C7"}, {"\uC4C8", "\uC4C8"}, {"\uC4C9", "\uC4C9"},
    {"\uC4CA", "\uC4CA"}, {"\uC4CB", "\uC4CB"}, {"\uC4CC", "\uC4CC"}, {"\uC4CD", "\uC4CD"}, {"\uC4CE", "\uC4CE"},
    {"\uC4CF", "\uC4CF"}, {"\uC4D0", "\uC4D0"}, {"\uC4D1", "\uC4D1"}, {"\uC4D2", "\uC4D2"}, {"\uC4D3", "\uC4D3"},
    {"\uC4D4", "\uC4D4"}, {"\uC4D5", "\uC4D5"}, {"\uC4D6", "\uC4D6"}, {"\uC4D7", "\uC4D7"}, {"\uC4D8", "\uC4D8"},
    {"\uC4D9", "\uC4D9"}, {"\uC4DA", "\uC4DA"}, {"\uC4DB", "\uC4DB"}, {"\uC4DC", "\uC4DC"}, {"\uC4DD", "\uC4DD"},
    {"\uC4DE", "\uC4DE"}, {"\uC4DF", "\uC4DF"}, {"\uC4E0", "\uC4E0"}, {"\uC4E1", "\uC4E1"}, {"\uC4E2", "\uC4E2"},
    {"\uC4E3", "\uC4E3"}, {"\uC4E4", "\uC4E4"}, {"\uC4E5", "\uC4E5"}, {"\uC4E6", "\uC4E6"}, {"\uC4E7", "\uC4E7"},
    {"\uC4E8", "\uC4E8"}, {"\uC4E9", "\uC4E9"}, {"\uC4EA", "\uC4EA"}, {"\uC4EB", "\uC4EB"}, {"\uC4EC", "\uC4EC"},
    {"\uC4ED", "\uC4ED"}, {"\uC4EE", "\uC4EE"}, {"\uC4EF", "\uC4EF"}, {"\uC4F0", "\uC4F0"}, {"\uC4F1", "\uC4F1"},
    {"\uC4F2", "\uC4F2"}, {"\uC4F3", "\uC4F3"}, {"\uC4F4", "\uC4F4"}, {"\uC4F5", "\uC4F5"}, {"\uC4F6", "\uC4F6"},
    {"\uC4F7", "\uC4F7"}, {"\uC4F8", "\uC4F8"}, {"\uC4F9", "\uC4F9"}, {"\uC4FA", "\uC4FA"}, {"\uC4FB", "\uC4FB"},
    {"\uC4FC", "\uC4FC"}, {"\uC4FD", "\uC4FD"}, {"\uC4FE", "\uC4FE"}, {"\uC4FF", "\uC4FF"}, {"\uC500", "\uC500"},
    {"\uC501", "\uC501"}, {"\uC502", "\uC502"}, {"\uC503", "\uC503"}, {"\uC504", "\uC504"}, {"\uC505", "\uC505"},
    {"\uC506", "\uC506"}, {"\uC507", "\uC507"}, {"\uC508", "\uC508"}, {"\uC509", "\uC509"}, {"\uC50A", "\uC50A"},
    {"\uC50B", "\uC50B"}, {"\uC50C", "\uC50C"}, {"\uC50D", "\uC50D"}, {"\uC50E", "\uC50E"}, {"\uC50F", "\uC50F"},
    {"\uC510", "\uC510"}, {"\uC511", "\uC511"}, {"\uC512", "\uC512"}, {"\uC513", "\uC513"}, {"\uC514", "\uC514"},
    {"\uC515", "\uC515"}, {"\uC516", "\uC516"}, {"\uC517", "\uC517"}, {"\uC518", "\uC518"}, {"\uC519", "\uC519"},
    {"\uC51A", "\uC51A"}, {"\uC51B", "\uC51B"}, {"\uC51C", "\uC51C"}, {"\uC51D", "\uC51D"}, {"\uC51E", "\uC51E"},
    {"\uC51F", "\uC51F"}, {"\uC520", "\uC520"}, {"\uC521", "\uC521"}, {"\uC522", "\uC522"}, {"\uC523", "\uC523"},
    {"\uC524", "\uC524"}, {"\uC525", "\uC525"}, {"\uC526", "\uC526"}, {"\uC527", "\uC527"}, {"\uC528", "\uC528"},
    {"\uC529", "\uC529"}, {"\uC52A", "\uC52A"}, {"\uC52B", "\uC52B"}, {"\uC52C", "\uC52C"}, {"\uC52D", "\uC52D"},
    {"\uC52E", "\uC52E"}, {"\uC52F", "\uC52F"}, {"\uC530", "\uC530"}, {"\uC531", "\uC531"}, {"\uC532", "\uC532"},
    {"\uC533", "\uC533"}, {"\uC534", "\uC534"}, {"\uC535", "\uC535"}, {"\uC536", "\uC536"}, {"\uC537", "\uC537"},
    {"\uC538", "\uC538"}, {"\uC539", "\uC539"}, {"\uC53A", "\uC53A"}, {"\uC53B", "\uC53B"}, {"\uC53C", "\uC53C"},
    {"\uC53D", "\uC53D"}, {"\uC53E", "\uC53E"}, {"\uC53F", "\uC53F"}, {"\uC540", "\uC540"}, {"\uC541", "\uC541"},
    {"\uC542", "\uC542"}, {"\uC543", "\uC543"}, {"\uC544", "\uC544"}, {"\uC545", "\uC545"}, {"\uC546", "\uC546"},
    {"\uC547", "\uC547"}, {"\uC548", "\uC548"}, {"\uC549", "\uC549"}, {"\uC54A", "\uC54A"}, {"\uC54B", "\uC54B"},
    {"\uC54C", "\uC54C"}, {"\uC54D", "\uC54D"}, {"\uC54E", "\uC54E"}, {"\uC54F", "\uC54F"}, {"\uC550", "\uC550"},
    {"\uC551", "\uC551"}, {"\uC552", "\uC552"}, {"\uC553", "\uC553"}, {"\uC554", "\uC554"}, {"\uC555", "\uC555"},
    {"\uC556", "\uC556"}, {"\uC557", "\uC557"}, {"\uC558", "\uC558"}, {"\uC559", "\uC559"}, {"\uC55A", "\uC55A"},
    {"\uC55B", "\uC55B"}, {"\uC55C", "\uC55C"}, {"\uC55D", "\uC55D"}, {"\uC55E", "\uC55E"}, {"\uC55F", "\uC55F"},
    {"\uC560", "\uC560"}, {"\uC561", "\uC561"}, {"\uC562", "\uC562"}, {"\uC563", "\uC563"}, {"\uC564", "\uC564"},
    {"\uC565", "\uC565"}, {"\uC566", "\uC566"}, {"\uC567", "\uC567"}, {"\uC568", "\uC568"}, {"\uC569", "\uC569"},
    {"\uC56A", "\uC56A"}, {"\uC56B", "\uC56B"}, {"\uC56C", "\uC56C"}, {"\uC56D", "\uC56D"}, {"\uC56E", "\uC56E"},
    {"\uC56F", "\uC56F"}, {"\uC570", "\uC570"}, {"\uC571", "\uC571"}, {"\uC572", "\uC572"}, {"\uC573", "\uC573"},
    {"\uC574", "\uC574"}, {"\uC575", "\uC575"}, {"\uC576", "\uC576"}, {"\uC577", "\uC577"}, {"\uC578", "\uC578"},
    {"\uC579", "\uC579"}, {"\uC57A", "\uC57A"}, {"\uC57B", "\uC57B"}, {"\uC57C", "\uC57C"}, {"\uC57D", "\uC57D"},
    {"\uC57E", "\uC57E"}, {"\uC57F", "\uC57F"}, {"\uC580", "\uC580"}, {"\uC581", "\uC581"}, {"\uC582", "\uC582"},
    {"\uC583", "\uC583"}, {"\uC584", "\uC584"}, {"\uC585", "\uC585"}, {"\uC586", "\uC586"}, {"\uC587", "\uC587"},
    {"\uC588", "\uC588"}, {"\uC589", "\uC589"}, {"\uC58A", "\uC58A"}, {"\uC58B", "\uC58B"}, {"\uC58C", "\uC58C"},
    {"\uC58D", "\uC58D"}, {"\uC58E", "\uC58E"}, {"\uC58F", "\uC58F"}, {"\uC590", "\uC590"}, {"\uC591", "\uC591"},
    {"\uC592", "\uC592"}, {"\uC593", "\uC593"}, {"\uC594", "\uC594"}, {"\uC595", "\uC595"}, {"\uC596", "\uC596"},
    {"\uC597", "\uC597"}, {"\uC598", "\uC598"}, {"\uC599", "\uC599"}, {"\uC59A", "\uC59A"}, {"\uC59B", "\uC59B"},
    {"\uC59C", "\uC59C"}, {"\uC59D", "\uC59D"}, {"\uC59E", "\uC59E"}, {"\uC59F", "\uC59F"}, {"\uC5A0", "\uC5A0"},
    {"\uC5A1", "\uC5A1"}, {"\uC5A2", "\uC5A2"}, {"\uC5A3", "\uC5A3"}, {"\uC5A4", "\uC5A4"}, {"\uC5A5", "\uC5A5"},
    {"\uC5A6", "\uC5A6"}, {"\uC5A7", "\uC5A7"}, {"\uC5A8", "\uC5A8"}, {"\uC5A9", "\uC5A9"}, {"\uC5AA", "\uC5AA"},
    {"\uC5AB", "\uC5AB"}, {"\uC5AC", "\uC5AC"}, {"\uC5AD", "\uC5AD"}, {"\uC5AE", "\uC5AE"}, {"\uC5AF", "\uC5AF"},
    {"\uC5B0", "\uC5B0"}, {"\uC5B1", "\uC5B1"}, {"\uC5B2", "\uC5B2"}, {"\uC5B3", "\uC5B3"}, {"\uC5B4", "\uC5B4"},
    {"\uC5B5", "\uC5B5"}, {"\uC5B6", "\uC5B6"}, {"\uC5B7", "\uC5B7"}, {"\uC5B8", "\uC5B8"}, {"\uC5B9", "\uC5B9"},
    {"\uC5BA", "\uC5BA"}, {"\uC5BB", "\uC5BB"}, {"\uC5BC", "\uC5BC"}, {"\uC5BD", "\uC5BD"}, {"\uC5BE", "\uC5BE"},
    {"\uC5BF", "\uC5BF"}, {"\uC5C0", "\uC5C0"}, {"\uC5C1", "\uC5C1"}, {"\uC5C2", "\uC5C2"}, {"\uC5C3", "\uC5C3"},
    {"\uC5C4", "\uC5C4"}, {"\uC5C5", "\uC5C5"}, {"\uC5C6", "\uC5C6"}, {"\uC5C7", "\uC5C7"}, {"\uC5C8", "\uC5C8"},
    {"\uC5C9", "\uC5C9"}, {"\uC5CA", "\uC5CA"}, {"\uC5CB", "\uC5CB"}, {"\uC5CC", "\uC5CC"}, {"\uC5CD", "\uC5CD"},
    {"\uC5CE", "\uC5CE"}, {"\uC5CF", "\uC5CF"}, {"\uC5D0", "\uC5D0"}, {"\uC5D1", "\uC5D1"}, {"\uC5D2", "\uC5D2"},
    {"\uC5D3", "\uC5D3"}, {"\uC5D4", "\uC5D4"}, {"\uC5D5", "\uC5D5"}, {"\uC5D6", "\uC5D6"}, {"\uC5D7", "\uC5D7"},
    {"\uC5D8", "\uC5D8"}, {"\uC5D9", "\uC5D9"}, {"\uC5DA", "\uC5DA"}, {"\uC5DB", "\uC5DB"}, {"\uC5DC", "\uC5DC"},
    {"\uC5DD", "\uC5DD"}, {"\uC5DE", "\uC5DE"}, {"\uC5DF", "\uC5DF"}, {"\uC5E0", "\uC5E0"}, {"\uC5E1", "\uC5E1"},
    {"\uC5E2", "\uC5E2"}, {"\uC5E3", "\uC5E3"}, {"\uC5E4", "\uC5E4"}, {"\uC5E5", "\uC5E5"}, {"\uC5E6", "\uC5E6"},
    {"\uC5E7", "\uC5E7"}, {"\uC5E8", "\uC5E8"}, {"\uC5E9", "\uC5E9"}, {"\uC5EA", "\uC5EA"}, {"\uC5EB", "\uC5EB"},
    {"\uC5EC", "\uC5EC"}, {"\uC5ED", "\uC5ED"}, {"\uC5EE", "\uC5EE"}, {"\uC5EF", "\uC5EF"}, {"\uC5F0", "\uC5F0"},
    {"\uC5F1", "\uC5F1"}, {"\uC5F2", "\uC5F2"}, {"\uC5F3", "\uC5F3"}, {"\uC5F4", "\uC5F4"}, {"\uC5F5", "\uC5F5"},
    {"\uC5F6", "\uC5F6"}, {"\uC5F7", "\uC5F7"}, {"\uC5F8", "\uC5F8"}, {"\uC5F9", "\uC5F9"}, {"\uC5FA", "\uC5FA"},
    {"\uC5FB", "\uC5FB"}, {"\uC5FC", "\uC5FC"}, {"\uC5FD", "\uC5FD"}, {"\uC5FE", "\uC5FE"}, {"\uC5FF", "\uC5FF"},
    {"\uC600", "\uC600"}, {"\uC601", "\uC601"}, {"\uC602", "\uC602"}, {"\uC603", "\uC603"}, {"\uC604", "\uC604"},
    {"\uC605", "\uC605"}, {"\uC606", "\uC606"}, {"\uC607", "\uC607"}, {"\uC608", "\uC608"}, {"\uC609", "\uC609"},
    {"\uC60A", "\uC60A"}, {"\uC60B", "\uC60B"}, {"\uC60C", "\uC60C"}, {"\uC60D", "\uC60D"}, {"\uC60E", "\uC60E"},
    {"\uC60F", "\uC60F"}, {"\uC610", "\uC610"}, {"\uC611", "\uC611"}, {"\uC612", "\uC612"}, {"\uC613", "\uC613"},
    {"\uC614", "\uC614"}, {"\uC615", "\uC615"}, {"\uC616", "\uC616"}, {"\uC617", "\uC617"}, {"\uC618", "\uC618"},
    {"\uC619", "\uC619"}, {"\uC61A", "\uC61A"}, {"\uC61B", "\uC61B"}, {"\uC61C", "\uC61C"}, {"\uC61D", "\uC61D"},
    {"\uC61E", "\uC61E"}, {"\uC61F", "\uC61F"}, {"\uC620", "\uC620"}, {"\uC621", "\uC621"}, {"\uC622", "\uC622"},
    {"\uC623", "\uC623"}, {"\uC624", "\uC624"}, {"\uC625", "\uC625"}, {"\uC626", "\uC626"}, {"\uC627", "\uC627"},
    {"\uC628", "\uC628"}, {"\uC629", "\uC629"}, {"\uC62A", "\uC62A"}, {"\uC62B", "\uC62B"}, {"\uC62C", "\uC62C"},
    {"\uC62D", "\uC62D"}, {"\uC62E", "\uC62E"}, {"\uC62F", "\uC62F"}, {"\uC630", "\uC630"}, {"\uC631", "\uC631"},
    {"\uC632", "\uC632"}, {"\uC633", "\uC633"}, {"\uC634", "\uC634"}, {"\uC635", "\uC635"}, {"\uC636", "\uC636"},
    {"\uC637", "\uC637"}, {"\uC638", "\uC638"}, {"\uC639", "\uC639"}, {"\uC63A", "\uC63A"}, {"\uC63B", "\uC63B"},
    {"\uC63C", "\uC63C"}, {"\uC63D", "\uC63D"}, {"\uC63E", "\uC63E"}, {"\uC63F", "\uC63F"}, {"\uC640", "\uC640"},
    {"\uC641", "\uC641"}, {"\uC642", "\uC642"}, {"\uC643", "\uC643"}, {"\uC644", "\uC644"}, {"\uC645", "\uC645"},
    {"\uC646", "\uC646"}, {"\uC647", "\uC647"}, {"\uC648", "\uC648"}, {"\uC649", "\uC649"}, {"\uC64A", "\uC64A"},
    {"\uC64B", "\uC64B"}, {"\uC64C", "\uC64C"}, {"\uC64D", "\uC64D"}, {"\uC64E", "\uC64E"}, {"\uC64F", "\uC64F"},
    {"\uC650", "\uC650"}, {"\uC651", "\uC651"}, {"\uC652", "\uC652"}, {"\uC653", "\uC653"}, {"\uC654", "\uC654"},
    {"\uC655", "\uC655"}, {"\uC656", "\uC656"}, {"\uC657", "\uC657"}, {"\uC658", "\uC658"}, {"\uC659", "\uC659"},
    {"\uC65A", "\uC65A"}, {"\uC65B", "\uC65B"}, {"\uC65C", "\uC65C"}, {"\uC65D", "\uC65D"}, {"\uC65E", "\uC65E"},
    {"\uC65F", "\uC65F"}, {"\uC660", "\uC660"}, {"\uC661", "\uC661"}, {"\uC662", "\uC662"}, {"\uC663", "\uC663"},
    {"\uC664", "\uC664"}, {"\uC665", "\uC665"}, {"\uC666", "\uC666"}, {"\uC667", "\uC667"}, {"\uC668", "\uC668"},
    {"\uC669", "\uC669"}, {"\uC66A", "\uC66A"}, {"\uC66B", "\uC66B"}, {"\uC66C", "\uC66C"}, {"\uC66D", "\uC66D"},
    {"\uC66E", "\uC66E"}, {"\uC66F", "\uC66F"}, {"\uC670", "\uC670"}, {"\uC671", "\uC671"}, {"\uC672", "\uC672"},
    {"\uC673", "\uC673"}, {"\uC674", "\uC674"}, {"\uC675", "\uC675"}, {"\uC676", "\uC676"}, {"\uC677", "\uC677"},
    {"\uC678", "\uC678"}, {"\uC679", "\uC679"}, {"\uC67A", "\uC67A"}, {"\uC67B", "\uC67B"}, {"\uC67C", "\uC67C"},
    {"\uC67D", "\uC67D"}, {"\uC67E", "\uC67E"}, {"\uC67F", "\uC67F"}, {"\uC680", "\uC680"}, {"\uC681", "\uC681"},
    {"\uC682", "\uC682"}, {"\uC683", "\uC683"}, {"\uC684", "\uC684"}, {"\uC685", "\uC685"}, {"\uC686", "\uC686"},
    {"\uC687", "\uC687"}, {"\uC688", "\uC688"}, {"\uC689", "\uC689"}, {"\uC68A", "\uC68A"}, {"\uC68B", "\uC68B"},
    {"\uC68C", "\uC68C"}, {"\uC68D", "\uC68D"}, {"\uC68E", "\uC68E"}, {"\uC68F", "\uC68F"}, {"\uC690", "\uC690"},
    {"\uC691", "\uC691"}, {"\uC692", "\uC692"}, {"\uC693", "\uC693"}, {"\uC694", "\uC694"}, {"\uC695", "\uC695"},
    {"\uC696", "\uC696"}, {"\uC697", "\uC697"}, {"\uC698", "\uC698"}, {"\uC699", "\uC699"}, {"\uC69A", "\uC69A"},
    {"\uC69B", "\uC69B"}, {"\uC69C", "\uC69C"}, {"\uC69D", "\uC69D"}, {"\uC69E", "\uC69E"}, {"\uC69F", "\uC69F"},
    {"\uC6A0", "\uC6A0"}, {"\uC6A1", "\uC6A1"}, {"\uC6A2", "\uC6A2"}, {"\uC6A3", "\uC6A3"}, {"\uC6A4", "\uC6A4"},
    {"\uC6A5", "\uC6A5"}, {"\uC6A6", "\uC6A6"}, {"\uC6A7", "\uC6A7"}, {"\uC6A8", "\uC6A8"}, {"\uC6A9", "\uC6A9"},
    {"\uC6AA", "\uC6AA"}, {"\uC6AB", "\uC6AB"}, {"\uC6AC", "\uC6AC"}, {"\uC6AD", "\uC6AD"}, {"\uC6AE", "\uC6AE"},
    {"\uC6AF", "\uC6AF"}, {"\uC6B0", "\uC6B0"}, {"\uC6B1", "\uC6B1"}, {"\uC6B2", "\uC6B2"}, {"\uC6B3", "\uC6B3"},
    {"\uC6B4", "\uC6B4"}, {"\uC6B5", "\uC6B5"}, {"\uC6B6", "\uC6B6"}, {"\uC6B7", "\uC6B7"}, {"\uC6B8", "\uC6B8"},
    {"\uC6B9", "\uC6B9"}, {"\uC6BA", "\uC6BA"}, {"\uC6BB", "\uC6BB"}, {"\uC6BC", "\uC6BC"}, {"\uC6BD", "\uC6BD"},
    {"\uC6BE", "\uC6BE"}, {"\uC6BF", "\uC6BF"}, {"\uC6C0", "\uC6C0"}, {"\uC6C1", "\uC6C1"}, {"\uC6C2", "\uC6C2"},
    {"\uC6C3", "\uC6C3"}, {"\uC6C4", "\uC6C4"}, {"\uC6C5", "\uC6C5"}, {"\uC6C6", "\uC6C6"}, {"\uC6C7", "\uC6C7"},
    {"\uC6C8", "\uC6C8"}, {"\uC6C9", "\uC6C9"}, {"\uC6CA", "\uC6CA"}, {"\uC6CB", "\uC6CB"}, {"\uC6CC", "\uC6CC"},
    {"\uC6CD", "\uC6CD"}, {"\uC6CE", "\uC6CE"}, {"\uC6CF", "\uC6CF"}, {"\uC6D0", "\uC6D0"}, {"\uC6D1", "\uC6D1"},
    {"\uC6D2", "\uC6D2"}, {"\uC6D3", "\uC6D3"}, {"\uC6D4", "\uC6D4"}, {"\uC6D5", "\uC6D5"}, {"\uC6D6", "\uC6D6"},
    {"\uC6D7", "\uC6D7"}, {"\uC6D8", "\uC6D8"}, {"\uC6D9", "\uC6D9"}, {"\uC6DA", "\uC6DA"}, {"\uC6DB", "\uC6DB"},
    {"\uC6DC", "\uC6DC"}, {"\uC6DD", "\uC6DD"}, {"\uC6DE", "\uC6DE"}, {"\uC6DF", "\uC6DF"}, {"\uC6E0", "\uC6E0"},
    {"\uC6E1", "\uC6E1"}, {"\uC6E2", "\uC6E2"}, {"\uC6E3", "\uC6E3"}, {"\uC6E4", "\uC6E4"}, {"\uC6E5", "\uC6E5"},
    {"\uC6E6", "\uC6E6"}, {"\uC6E7", "\uC6E7"}, {"\uC6E8", "\uC6E8"}, {"\uC6E9", "\uC6E9"}, {"\uC6EA", "\uC6EA"},
    {"\uC6EB", "\uC6EB"}, {"\uC6EC", "\uC6EC"}, {"\uC6ED", "\uC6ED"}, {"\uC6EE", "\uC6EE"}, {"\uC6EF", "\uC6EF"},
    {"\uC6F0", "\uC6F0"}, {"\uC6F1", "\uC6F1"}, {"\uC6F2", "\uC6F2"}, {"\uC6F3", "\uC6F3"}, {"\uC6F4", "\uC6F4"},
    {"\uC6F5", "\uC6F5"}, {"\uC6F6", "\uC6F6"}, {"\uC6F7", "\uC6F7"}, {"\uC6F8", "\uC6F8"}, {"\uC6F9", "\uC6F9"},
    {"\uC6FA", "\uC6FA"}, {"\uC6FB", "\uC6FB"}, {"\uC6FC", "\uC6FC"}, {"\uC6FD", "\uC6FD"}, {"\uC6FE", "\uC6FE"},
    {"\uC6FF", "\uC6FF"}, {"\uC700", "\uC700"}, {"\uC701", "\uC701"}, {"\uC702", "\uC702"}, {"\uC703", "\uC703"},
    {"\uC704", "\uC704"}, {"\uC705", "\uC705"}, {"\uC706", "\uC706"}, {"\uC707", "\uC707"}, {"\uC708", "\uC708"},
    {"\uC709", "\uC709"}, {"\uC70A", "\uC70A"}, {"\uC70B", "\uC70B"}, {"\uC70C", "\uC70C"}, {"\uC70D", "\uC70D"},
    {"\uC70E", "\uC70E"}, {"\uC70F", "\uC70F"}, {"\uC710", "\uC710"}, {"\uC711", "\uC711"}, {"\uC712", "\uC712"},
    {"\uC713", "\uC713"}, {"\uC714", "\uC714"}, {"\uC715", "\uC715"}, {"\uC716", "\uC716"}, {"\uC717", "\uC717"},
    {"\uC718", "\uC718"}, {"\uC719", "\uC719"}, {"\uC71A", "\uC71A"}, {"\uC71B", "\uC71B"}, {"\uC71C", "\uC71C"},
    {"\uC71D", "\uC71D"}, {"\uC71E", "\uC71E"}, {"\uC71F", "\uC71F"}, {"\uC720", "\uC720"}, {"\uC721", "\uC721"},
    {"\uC722", "\uC722"}, {"\uC723", "\uC723"}, {"\uC724", "\uC724"}, {"\uC725", "\uC725"}, {"\uC726", "\uC726"},
    {"\uC727", "\uC727"}, {"\uC728", "\uC728"}, {"\uC729", "\uC729"}, {"\uC72A", "\uC72A"}, {"\uC72B", "\uC72B"},
    {"\uC72C", "\uC72C"}, {"\uC72D", "\uC72D"}, {"\uC72E", "\uC72E"}, {"\uC72F", "\uC72F"}, {"\uC730", "\uC730"},
    {"\uC731", "\uC731"}, {"\uC732", "\uC732"}, {"\uC733", "\uC733"}, {"\uC734", "\uC734"}, {"\uC735", "\uC735"},
    {"\uC736", "\uC736"}, {"\uC737", "\uC737"}, {"\uC738", "\uC738"}, {"\uC739", "\uC739"}, {"\uC73A", "\uC73A"},
    {"\uC73B", "\uC73B"}, {"\uC73C", "\uC73C"}, {"\uC73D", "\uC73D"}, {"\uC73E", "\uC73E"}, {"\uC73F", "\uC73F"},
    {"\uC740", "\uC740"}, {"\uC741", "\uC741"}, {"\uC742", "\uC742"}, {"\uC743", "\uC743"}, {"\uC744", "\uC744"},
    {"\uC745", "\uC745"}, {"\uC746", "\uC746"}, {"\uC747", "\uC747"}, {"\uC748", "\uC748"}, {"\uC749", "\uC749"},
    {"\uC74A", "\uC74A"}, {"\uC74B", "\uC74B"}, {"\uC74C", "\uC74C"}, {"\uC74D", "\uC74D"}, {"\uC74E", "\uC74E"},
    {"\uC74F", "\uC74F"}, {"\uC750", "\uC750"}, {"\uC751", "\uC751"}, {"\uC752", "\uC752"}, {"\uC753", "\uC753"},
    {"\uC754", "\uC754"}, {"\uC755", "\uC755"}, {"\uC756", "\uC756"}, {"\uC757", "\uC757"}, {"\uC758", "\uC758"},
    {"\uC759", "\uC759"}, {"\uC75A", "\uC75A"}, {"\uC75B", "\uC75B"}, {"\uC75C", "\uC75C"}, {"\uC75D", "\uC75D"},
    {"\uC75E", "\uC75E"}, {"\uC75F", "\uC75F"}, {"\uC760", "\uC760"}, {"\uC761", "\uC761"}, {"\uC762", "\uC762"},
    {"\uC763", "\uC763"}, {"\uC764", "\uC764"}, {"\uC765", "\uC765"}, {"\uC766", "\uC766"}, {"\uC767", "\uC767"},
    {"\uC768", "\uC768"}, {"\uC769", "\uC769"}, {"\uC76A", "\uC76A"}, {"\uC76B", "\uC76B"}, {"\uC76C", "\uC76C"},
    {"\uC76D", "\uC76D"}, {"\uC76E", "\uC76E"}, {"\uC76F", "\uC76F"}, {"\uC770", "\uC770"}, {"\uC771", "\uC771"},
    {"\uC772", "\uC772"}, {"\uC773", "\uC773"}, {"\uC774", "\uC774"}, {"\uC775", "\uC775"}, {"\uC776", "\uC776"},
    {"\uC777", "\uC777"}, {"\uC778", "\uC778"}, {"\uC779", "\uC779"}, {"\uC77A", "\uC77A"}, {"\uC77B", "\uC77B"},
    {"\uC77C", "\uC77C"}, {"\uC77D", "\uC77D"}, {"\uC77E", "\uC77E"}, {"\uC77F", "\uC77F"}, {"\uC780", "\uC780"},
    {"\uC781", "\uC781"}, {"\uC782", "\uC782"}, {"\uC783", "\uC783"}, {"\uC784", "\uC784"}, {"\uC785", "\uC785"},
    {"\uC786", "\uC786"}, {"\uC787", "\uC787"}, {"\uC788", "\uC788"}, {"\uC789", "\uC789"}, {"\uC78A", "\uC78A"},
    {"\uC78B", "\uC78B"}, {"\uC78C", "\uC78C"}, {"\uC78D", "\uC78D"}, {"\uC78E", "\uC78E"}, {"\uC78F", "\uC78F"},
    {"\uC790", "\uC790"}, {"\uC791", "\uC791"}, {"\uC792", "\uC792"}, {"\uC793", "\uC793"}, {"\uC794", "\uC794"},
    {"\uC795", "\uC795"}, {"\uC796", "\uC796"}, {"\uC797", "\uC797"}, {"\uC798", "\uC798"}, {"\uC799", "\uC799"},
    {"\uC79A", "\uC79A"}, {"\uC79B", "\uC79B"}, {"\uC79C", "\uC79C"}, {"\uC79D", "\uC79D"}, {"\uC79E", "\uC79E"},
    {"\uC79F", "\uC79F"}, {"\uC7A0", "\uC7A0"}, {"\uC7A1", "\uC7A1"}, {"\uC7A2", "\uC7A2"}, {"\uC7A3", "\uC7A3"},
    {"\uC7A4", "\uC7A4"}, {"\uC7A5", "\uC7A5"}, {"\uC7A6", "\uC7A6"}, {"\uC7A7", "\uC7A7"}, {"\uC7A8", "\uC7A8"},
    {"\uC7A9", "\uC7A9"}, {"\uC7AA", "\uC7AA"}, {"\uC7AB", "\uC7AB"}, {"\uC7AC", "\uC7AC"}, {"\uC7AD", "\uC7AD"},
    {"\uC7AE", "\uC7AE"}, {"\uC7AF", "\uC7AF"}, {"\uC7B0", "\uC7B0"}, {"\uC7B1", "\uC7B1"}, {"\uC7B2", "\uC7B2"},
    {"\uC7B3", "\uC7B3"}, {"\uC7B4", "\uC7B4"}, {"\uC7B5", "\uC7B5"}, {"\uC7B6", "\uC7B6"}, {"\uC7B7", "\uC7B7"},
    {"\uC7B8", "\uC7B8"}, {"\uC7B9", "\uC7B9"}, {"\uC7BA", "\uC7BA"}, {"\uC7BB", "\uC7BB"}, {"\uC7BC", "\uC7BC"},
    {"\uC7BD", "\uC7BD"}, {"\uC7BE", "\uC7BE"}, {"\uC7BF", "\uC7BF"}, {"\uC7C0", "\uC7C0"}, {"\uC7C1", "\uC7C1"},
    {"\uC7C2", "\uC7C2"}, {"\uC7C3", "\uC7C3"}, {"\uC7C4", "\uC7C4"}, {"\uC7C5", "\uC7C5"}, {"\uC7C6", "\uC7C6"},
    {"\uC7C7", "\uC7C7"}, {"\uC7C8", "\uC7C8"}, {"\uC7C9", "\uC7C9"}, {"\uC7CA", "\uC7CA"}, {"\uC7CB", "\uC7CB"},
    {"\uC7CC", "\uC7CC"}, {"\uC7CD", "\uC7CD"}, {"\uC7CE", "\uC7CE"}, {"\uC7CF", "\uC7CF"}, {"\uC7D0", "\uC7D0"},
    {"\uC7D1", "\uC7D1"}, {"\uC7D2", "\uC7D2"}, {"\uC7D3", "\uC7D3"}, {"\uC7D4", "\uC7D4"}, {"\uC7D5", "\uC7D5"},
    {"\uC7D6", "\uC7D6"}, {"\uC7D7", "\uC7D7"}, {"\uC7D8", "\uC7D8"}, {"\uC7D9", "\uC7D9"}, {"\uC7DA", "\uC7DA"},
    {"\uC7DB", "\uC7DB"}, {"\uC7DC", "\uC7DC"}, {"\uC7DD", "\uC7DD"}, {"\uC7DE", "\uC7DE"}, {"\uC7DF", "\uC7DF"},
    {"\uC7E0", "\uC7E0"}, {"\uC7E1", "\uC7E1"}, {"\uC7E2", "\uC7E2"}, {"\uC7E3", "\uC7E3"}, {"\uC7E4", "\uC7E4"},
    {"\uC7E5", "\uC7E5"}, {"\uC7E6", "\uC7E6"}, {"\uC7E7", "\uC7E7"}, {"\uC7E8", "\uC7E8"}, {"\uC7E9", "\uC7E9"},
    {"\uC7EA", "\uC7EA"}, {"\uC7EB", "\uC7EB"}, {"\uC7EC", "\uC7EC"}, {"\uC7ED", "\uC7ED"}, {"\uC7EE", "\uC7EE"},
    {"\uC7EF", "\uC7EF"}, {"\uC7F0", "\uC7F0"}, {"\uC7F1", "\uC7F1"}, {"\uC7F2", "\uC7F2"}, {"\uC7F3", "\uC7F3"},
    {"\uC7F4", "\uC7F4"}, {"\uC7F5", "\uC7F5"}, {"\uC7F6", "\uC7F6"}, {"\uC7F7", "\uC7F7"}, {"\uC7F8", "\uC7F8"},
    {"\uC7F9", "\uC7F9"}, {"\uC7FA", "\uC7FA"}, {"\uC7FB", "\uC7FB"}, {"\uC7FC", "\uC7FC"}, {"\uC7FD", "\uC7FD"},
    {"\uC7FE", "\uC7FE"}, {"\uC7FF", "\uC7FF"}, {"\uC800", "\uC800"}, {"\uC801", "\uC801"}, {"\uC802", "\uC802"},
    {"\uC803", "\uC803"}, {"\uC804", "\uC804"}, {"\uC805", "\uC805"}, {"\uC806", "\uC806"}, {"\uC807", "\uC807"},
    {"\uC808", "\uC808"}, {"\uC809", "\uC809"}, {"\uC80A", "\uC80A"}, {"\uC80B", "\uC80B"}, {"\uC80C", "\uC80C"},
    {"\uC80D", "\uC80D"}, {"\uC80E", "\uC80E"}, {"\uC80F", "\uC80F"}, {"\uC810", "\uC810"}, {"\uC811", "\uC811"},
    {"\uC812", "\uC812"}, {"\uC813", "\uC813"}, {"\uC814", "\uC814"}, {"\uC815", "\uC815"}, {"\uC816", "\uC816"},
    {"\uC817", "\uC817"}, {"\uC818", "\uC818"}, {"\uC819", "\uC819"}, {"\uC81A", "\uC81A"}, {"\uC81B", "\uC81B"},
    {"\uC81C", "\uC81C"}, {"\uC81D", "\uC81D"}, {"\uC81E", "\uC81E"}, {"\uC81F", "\uC81F"}, {"\uC820", "\uC820"},
    {"\uC821", "\uC821"}, {"\uC822", "\uC822"}, {"\uC823", "\uC823"}, {"\uC824", "\uC824"}, {"\uC825", "\uC825"},
    {"\uC826", "\uC826"}, {"\uC827", "\uC827"}, {"\uC828", "\uC828"}, {"\uC829", "\uC829"}, {"\uC82A", "\uC82A"},
    {"\uC82B", "\uC82B"}, {"\uC82C", "\uC82C"}, {"\uC82D", "\uC82D"}, {"\uC82E", "\uC82E"}, {"\uC82F", "\uC82F"},
    {"\uC830", "\uC830"}, {"\uC831", "\uC831"}, {"\uC832", "\uC832"}, {"\uC833", "\uC833"}, {"\uC834", "\uC834"},
    {"\uC835", "\uC835"}, {"\uC836", "\uC836"}, {"\uC837", "\uC837"}, {"\uC838", "\uC838"}, {"\uC839", "\uC839"},
    {"\uC83A", "\uC83A"}, {"\uC83B", "\uC83B"}, {"\uC83C", "\uC83C"}, {"\uC83D", "\uC83D"}, {"\uC83E", "\uC83E"},
    {"\uC83F", "\uC83F"}, {"\uC840", "\uC840"}, {"\uC841", "\uC841"}, {"\uC842", "\uC842"}, {"\uC843", "\uC843"},
    {"\uC844", "\uC844"}, {"\uC845", "\uC845"}, {"\uC846", "\uC846"}, {"\uC847", "\uC847"}, {"\uC848", "\uC848"},
    {"\uC849", "\uC849"}, {"\uC84A", "\uC84A"}, {"\uC84B", "\uC84B"}, {"\uC84C", "\uC84C"}, {"\uC84D", "\uC84D"},
    {"\uC84E", "\uC84E"}, {"\uC84F", "\uC84F"}, {"\uC850", "\uC850"}, {"\uC851", "\uC851"}, {"\uC852", "\uC852"},
    {"\uC853", "\uC853"}, {"\uC854", "\uC854"}, {"\uC855", "\uC855"}, {"\uC856", "\uC856"}, {"\uC857", "\uC857"},
    {"\uC858", "\uC858"}, {"\uC859", "\uC859"}, {"\uC85A", "\uC85A"}, {"\uC85B", "\uC85B"}, {"\uC85C", "\uC85C"},
    {"\uC85D", "\uC85D"}, {"\uC85E", "\uC85E"}, {"\uC85F", "\uC85F"}, {"\uC860", "\uC860"}, {"\uC861", "\uC861"},
    {"\uC862", "\uC862"}, {"\uC863", "\uC863"}, {"\uC864", "\uC864"}, {"\uC865", "\uC865"}, {"\uC866", "\uC866"},
    {"\uC867", "\uC867"}, {"\uC868", "\uC868"}, {"\uC869", "\uC869"}, {"\uC86A", "\uC86A"}, {"\uC86B", "\uC86B"},
    {"\uC86C", "\uC86C"}, {"\uC86D", "\uC86D"}, {"\uC86E", "\uC86E"}, {"\uC86F", "\uC86F"}, {"\uC870", "\uC870"},
    {"\uC871", "\uC871"}, {"\uC872", "\uC872"}, {"\uC873", "\uC873"}, {"\uC874", "\uC874"}, {"\uC875", "\uC875"},
    {"\uC876", "\uC876"}, {"\uC877", "\uC877"}, {"\uC878", "\uC878"}, {"\uC879", "\uC879"}, {"\uC87A", "\uC87A"},
    {"\uC87B", "\uC87B"}, {"\uC87C", "\uC87C"}, {"\uC87D", "\uC87D"}, {"\uC87E", "\uC87E"}, {"\uC87F", "\uC87F"},
    {"\uC880", "\uC880"}, {"\uC881", "\uC881"}, {"\uC882", "\uC882"}, {"\uC883", "\uC883"}, {"\uC884", "\uC884"},
    {"\uC885", "\uC885"}, {"\uC886", "\uC886"}, {"\uC887", "\uC887"}, {"\uC888", "\uC888"}, {"\uC889", "\uC889"},
    {"\uC88A", "\uC88A"}, {"\uC88B", "\uC88B"}, {"\uC88C", "\uC88C"}, {"\uC88D", "\uC88D"}, {"\uC88E", "\uC88E"},
    {"\uC88F", "\uC88F"}, {"\uC890", "\uC890"}, {"\uC891", "\uC891"}, {"\uC892", "\uC892"}, {"\uC893", "\uC893"},
    {"\uC894", "\uC894"}, {"\uC895", "\uC895"}, {"\uC896", "\uC896"}, {"\uC897", "\uC897"}, {"\uC898", "\uC898"},
    {"\uC899", "\uC899"}, {"\uC89A", "\uC89A"}, {"\uC89B", "\uC89B"}, {"\uC89C", "\uC89C"}, {"\uC89D", "\uC89D"},
    {"\uC89E", "\uC89E"}, {"\uC89F", "\uC89F"}, {"\uC8A0", "\uC8A0"}, {"\uC8A1", "\uC8A1"}, {"\uC8A2", "\uC8A2"},
    {"\uC8A3", "\uC8A3"}, {"\uC8A4", "\uC8A4"}, {"\uC8A5", "\uC8A5"}, {"\uC8A6", "\uC8A6"}, {"\uC8A7", "\uC8A7"},
    {"\uC8A8", "\uC8A8"}, {"\uC8A9", "\uC8A9"}, {"\uC8AA", "\uC8AA"}, {"\uC8AB", "\uC8AB"}, {"\uC8AC", "\uC8AC"},
    {"\uC8AD", "\uC8AD"}, {"\uC8AE", "\uC8AE"}, {"\uC8AF", "\uC8AF"}, {"\uC8B0", "\uC8B0"}, {"\uC8B1", "\uC8B1"},
    {"\uC8B2", "\uC8B2"}, {"\uC8B3", "\uC8B3"}, {"\uC8B4", "\uC8B4"}, {"\uC8B5", "\uC8B5"}, {"\uC8B6", "\uC8B6"},
    {"\uC8B7", "\uC8B7"}, {"\uC8B8", "\uC8B8"}, {"\uC8B9", "\uC8B9"}, {"\uC8BA", "\uC8BA"}, {"\uC8BB", "\uC8BB"},
    {"\uC8BC", "\uC8BC"}, {"\uC8BD", "\uC8BD"}, {"\uC8BE", "\uC8BE"}, {"\uC8BF", "\uC8BF"}, {"\uC8C0", "\uC8C0"},
    {"\uC8C1", "\uC8C1"}, {"\uC8C2", "\uC8C2"}, {"\uC8C3", "\uC8C3"}, {"\uC8C4", "\uC8C4"}, {"\uC8C5", "\uC8C5"},
    {"\uC8C6", "\uC8C6"}, {"\uC8C7", "\uC8C7"}, {"\uC8C8", "\uC8C8"}, {"\uC8C9", "\uC8C9"}, {"\uC8CA", "\uC8CA"},
    {"\uC8CB", "\uC8CB"}, {"\uC8CC", "\uC8CC"}, {"\uC8CD", "\uC8CD"}, {"\uC8CE", "\uC8CE"}, {"\uC8CF", "\uC8CF"},
    {"\uC8D0", "\uC8D0"}, {"\uC8D1", "\uC8D1"}, {"\uC8D2", "\uC8D2"}, {"\uC8D3", "\uC8D3"}, {"\uC8D4", "\uC8D4"},
    {"\uC8D5", "\uC8D5"}, {"\uC8D6", "\uC8D6"}, {"\uC8D7", "\uC8D7"}, {"\uC8D8", "\uC8D8"}, {"\uC8D9", "\uC8D9"},
    {"\uC8DA", "\uC8DA"}, {"\uC8DB", "\uC8DB"}, {"\uC8DC", "\uC8DC"}, {"\uC8DD", "\uC8DD"}, {"\uC8DE", "\uC8DE"},
    {"\uC8DF", "\uC8DF"}, {"\uC8E0", "\uC8E0"}, {"\uC8E1", "\uC8E1"}, {"\uC8E2", "\uC8E2"}, {"\uC8E3", "\uC8E3"},
    {"\uC8E4", "\uC8E4"}, {"\uC8E5", "\uC8E5"}, {"\uC8E6", "\uC8E6"}, {"\uC8E7", "\uC8E7"}, {"\uC8E8", "\uC8E8"},
    {"\uC8E9", "\uC8E9"}, {"\uC8EA", "\uC8EA"}, {"\uC8EB", "\uC8EB"}, {"\uC8EC", "\uC8EC"}, {"\uC8ED", "\uC8ED"},
    {"\uC8EE", "\uC8EE"}, {"\uC8EF", "\uC8EF"}, {"\uC8F0", "\uC8F0"}, {"\uC8F1", "\uC8F1"}, {"\uC8F2", "\uC8F2"},
    {"\uC8F3", "\uC8F3"}, {"\uC8F4", "\uC8F4"}, {"\uC8F5", "\uC8F5"}, {"\uC8F6", "\uC8F6"}, {"\uC8F7", "\uC8F7"},
    {"\uC8F8", "\uC8F8"}, {"\uC8F9", "\uC8F9"}, {"\uC8FA", "\uC8FA"}, {"\uC8FB", "\uC8FB"}, {"\uC8FC", "\uC8FC"},
    {"\uC8FD", "\uC8FD"}, {"\uC8FE", "\uC8FE"}, {"\uC8FF", "\uC8FF"}, {"\uC900", "\uC900"}, {"\uC901", "\uC901"},
    {"\uC902", "\uC902"}, {"\uC903", "\uC903"}, {"\uC904", "\uC904"}, {"\uC905", "\uC905"}, {"\uC906", "\uC906"},
    {"\uC907", "\uC907"}, {"\uC908", "\uC908"}, {"\uC909", "\uC909"}, {"\uC90A", "\uC90A"}, {"\uC90B", "\uC90B"},
    {"\uC90C", "\uC90C"}, {"\uC90D", "\uC90D"}, {"\uC90E", "\uC90E"}, {"\uC90F", "\uC90F"}, {"\uC910", "\uC910"},
    {"\uC911", "\uC911"}, {"\uC912", "\uC912"}, {"\uC913", "\uC913"}, {"\uC914", "\uC914"}, {"\uC915", "\uC915"},
    {"\uC916", "\uC916"}, {"\uC917", "\uC917"}, {"\uC918", "\uC918"}, {"\uC919", "\uC919"}, {"\uC91A", "\uC91A"},
    {"\uC91B", "\uC91B"}, {"\uC91C", "\uC91C"}, {"\uC91D", "\uC91D"}, {"\uC91E", "\uC91E"}, {"\uC91F", "\uC91F"},
    {"\uC920", "\uC920"}, {"\uC921", "\uC921"}, {"\uC922", "\uC922"}, {"\uC923", "\uC923"}, {"\uC924", "\uC924"},
    {"\uC925", "\uC925"}, {"\uC926", "\uC926"}, {"\uC927", "\uC927"}, {"\uC928", "\uC928"}, {"\uC929", "\uC929"},
    {"\uC92A", "\uC92A"}, {"\uC92B", "\uC92B"}, {"\uC92C", "\uC92C"}, {"\uC92D", "\uC92D"}, {"\uC92E", "\uC92E"},
    {"\uC92F", "\uC92F"}, {"\uC930", "\uC930"}, {"\uC931", "\uC931"}, {"\uC932", "\uC932"}, {"\uC933", "\uC933"},
    {"\uC934", "\uC934"}, {"\uC935", "\uC935"}, {"\uC936", "\uC936"}, {"\uC937", "\uC937"}, {"\uC938", "\uC938"},
    {"\uC939", "\uC939"}, {"\uC93A", "\uC93A"}, {"\uC93B", "\uC93B"}, {"\uC93C", "\uC93C"}, {"\uC93D", "\uC93D"},
    {"\uC93E", "\uC93E"}, {"\uC93F", "\uC93F"}, {"\uC940", "\uC940"}, {"\uC941", "\uC941"}, {"\uC942", "\uC942"},
    {"\uC943", "\uC943"}, {"\uC944", "\uC944"}, {"\uC945", "\uC945"}, {"\uC946", "\uC946"}, {"\uC947", "\uC947"},
    {"\uC948", "\uC948"}, {"\uC949", "\uC949"}, {"\uC94A", "\uC94A"}, {"\uC94B", "\uC94B"}, {"\uC94C", "\uC94C"},
    {"\uC94D", "\uC94D"}, {"\uC94E", "\uC94E"}, {"\uC94F", "\uC94F"}, {"\uC950", "\uC950"}, {"\uC951", "\uC951"},
    {"\uC952", "\uC952"}, {"\uC953", "\uC953"}, {"\uC954", "\uC954"}, {"\uC955", "\uC955"}, {"\uC956", "\uC956"},
    {"\uC957", "\uC957"}, {"\uC958", "\uC958"}, {"\uC959", "\uC959"}, {"\uC95A", "\uC95A"}, {"\uC95B", "\uC95B"},
    {"\uC95C", "\uC95C"}, {"\uC95D", "\uC95D"}, {"\uC95E", "\uC95E"}, {"\uC95F", "\uC95F"}, {"\uC960", "\uC960"},
    {"\uC961", "\uC961"}, {"\uC962", "\uC962"}, {"\uC963", "\uC963"}, {"\uC964", "\uC964"}, {"\uC965", "\uC965"},
    {"\uC966", "\uC966"}, {"\uC967", "\uC967"}, {"\uC968", "\uC968"}, {"\uC969", "\uC969"}, {"\uC96A", "\uC96A"},
    {"\uC96B", "\uC96B"}, {"\uC96C", "\uC96C"}, {"\uC96D", "\uC96D"}, {"\uC96E", "\uC96E"}, {"\uC96F", "\uC96F"},
    {"\uC970", "\uC970"}, {"\uC971", "\uC971"}, {"\uC972", "\uC972"}, {"\uC973", "\uC973"}, {"\uC974", "\uC974"},
    {"\uC975", "\uC975"}, {"\uC976", "\uC976"}, {"\uC977", "\uC977"}, {"\uC978", "\uC978"}, {"\uC979", "\uC979"},
    {"\uC97A", "\uC97A"}, {"\uC97B", "\uC97B"}, {"\uC97C", "\uC97C"}, {"\uC97D", "\uC97D"}, {"\uC97E", "\uC97E"},
    {"\uC97F", "\uC97F"}, {"\uC980", "\uC980"}, {"\uC981", "\uC981"}, {"\uC982", "\uC982"}, {"\uC983", "\uC983"},
    {"\uC984", "\uC984"}, {"\uC985", "\uC985"}, {"\uC986", "\uC986"}, {"\uC987", "\uC987"}, {"\uC988", "\uC988"},
    {"\uC989", "\uC989"}, {"\uC98A", "\uC98A"}, {"\uC98B", "\uC98B"}, {"\uC98C", "\uC98C"}, {"\uC98D", "\uC98D"},
    {"\uC98E", "\uC98E"}, {"\uC98F", "\uC98F"}, {"\uC990", "\uC990"}, {"\uC991", "\uC991"}, {"\uC992", "\uC992"},
    {"\uC993", "\uC993"}, {"\uC994", "\uC994"}, {"\uC995", "\uC995"}, {"\uC996", "\uC996"}, {"\uC997", "\uC997"},
    {"\uC998", "\uC998"}, {"\uC999", "\uC999"}, {"\uC99A", "\uC99A"}, {"\uC99B", "\uC99B"}, {"\uC99C", "\uC99C"},
    {"\uC99D", "\uC99D"}, {"\uC99E", "\uC99E"}, {"\uC99F", "\uC99F"}, {"\uC9A0", "\uC9A0"}, {"\uC9A1", "\uC9A1"},
    {"\uC9A2", "\uC9A2"}, {"\uC9A3", "\uC9A3"}, {"\uC9A4", "\uC9A4"}, {"\uC9A5", "\uC9A5"}, {"\uC9A6", "\uC9A6"},
    {"\uC9A7", "\uC9A7"}, {"\uC9A8", "\uC9A8"}, {"\uC9A9", "\uC9A9"}, {"\uC9AA", "\uC9AA"}, {"\uC9AB", "\uC9AB"},
    {"\uC9AC", "\uC9AC"}, {"\uC9AD", "\uC9AD"}, {"\uC9AE", "\uC9AE"}, {"\uC9AF", "\uC9AF"}, {"\uC9B0", "\uC9B0"},
    {"\uC9B1", "\uC9B1"}, {"\uC9B2", "\uC9B2"}, {"\uC9B3", "\uC9B3"}, {"\uC9B4", "\uC9B4"}, {"\uC9B5", "\uC9B5"},
    {"\uC9B6", "\uC9B6"}, {"\uC9B7", "\uC9B7"}, {"\uC9B8", "\uC9B8"}, {"\uC9B9", "\uC9B9"}, {"\uC9BA", "\uC9BA"},
    {"\uC9BB", "\uC9BB"}, {"\uC9BC", "\uC9BC"}, {"\uC9BD", "\uC9BD"}, {"\uC9BE", "\uC9BE"}, {"\uC9BF", "\uC9BF"},
    {"\uC9C0", "\uC9C0"}, {"\uC9C1", "\uC9C1"}, {"\uC9C2", "\uC9C2"}, {"\uC9C3", "\uC9C3"}, {"\uC9C4", "\uC9C4"},
    {"\uC9C5", "\uC9C5"}, {"\uC9C6", "\uC9C6"}, {"\uC9C7", "\uC9C7"}, {"\uC9C8", "\uC9C8"}, {"\uC9C9", "\uC9C9"},
    {"\uC9CA", "\uC9CA"}, {"\uC9CB", "\uC9CB"}, {"\uC9CC", "\uC9CC"}, {"\uC9CD", "\uC9CD"}, {"\uC9CE", "\uC9CE"},
    {"\uC9CF", "\uC9CF"}, {"\uC9D0", "\uC9D0"}, {"\uC9D1", "\uC9D1"}, {"\uC9D2", "\uC9D2"}, {"\uC9D3", "\uC9D3"},
    {"\uC9D4", "\uC9D4"}, {"\uC9D5", "\uC9D5"}, {"\uC9D6", "\uC9D6"}, {"\uC9D7", "\uC9D7"}, {"\uC9D8", "\uC9D8"},
    {"\uC9D9", "\uC9D9"}, {"\uC9DA", "\uC9DA"}, {"\uC9DB", "\uC9DB"}, {"\uC9DC", "\uC9DC"}, {"\uC9DD", "\uC9DD"},
    {"\uC9DE", "\uC9DE"}, {"\uC9DF", "\uC9DF"}, {"\uC9E0", "\uC9E0"}, {"\uC9E1", "\uC9E1"}, {"\uC9E2", "\uC9E2"},
    {"\uC9E3", "\uC9E3"}, {"\uC9E4", "\uC9E4"}, {"\uC9E5", "\uC9E5"}, {"\uC9E6", "\uC9E6"}, {"\uC9E7", "\uC9E7"},
    {"\uC9E8", "\uC9E8"}, {"\uC9E9", "\uC9E9"}, {"\uC9EA", "\uC9EA"}, {"\uC9EB", "\uC9EB"}, {"\uC9EC", "\uC9EC"},
    {"\uC9ED", "\uC9ED"}, {"\uC9EE", "\uC9EE"}, {"\uC9EF", "\uC9EF"}, {"\uC9F0", "\uC9F0"}, {"\uC9F1", "\uC9F1"},
    {"\uC9F2", "\uC9F2"}, {"\uC9F3", "\uC9F3"}, {"\uC9F4", "\uC9F4"}, {"\uC9F5", "\uC9F5"}, {"\uC9F6", "\uC9F6"},
    {"\uC9F7", "\uC9F7"}, {"\uC9F8", "\uC9F8"}, {"\uC9F9", "\uC9F9"}, {"\uC9FA", "\uC9FA"}, {"\uC9FB", "\uC9FB"},
    {"\uC9FC", "\uC9FC"}, {"\uC9FD", "\uC9FD"}, {"\uC9FE", "\uC9FE"}, {"\uC9FF", "\uC9FF"}, {"\uCA00", "\uCA00"},
    {"\uCA01", "\uCA01"}, {"\uCA02", "\uCA02"}, {"\uCA03", "\uCA03"}, {"\uCA04", "\uCA04"}, {"\uCA05", "\uCA05"},
    {"\uCA06", "\uCA06"}, {"\uCA07", "\uCA07"}, {"\uCA08", "\uCA08"}, {"\uCA09", "\uCA09"}, {"\uCA0A", "\uCA0A"},
    {"\uCA0B", "\uCA0B"}, {"\uCA0C", "\uCA0C"}, {"\uCA0D", "\uCA0D"}, {"\uCA0E", "\uCA0E"}, {"\uCA0F", "\uCA0F"},
    {"\uCA10", "\uCA10"}, {"\uCA11", "\uCA11"}, {"\uCA12", "\uCA12"}, {"\uCA13", "\uCA13"}, {"\uCA14", "\uCA14"},
    {"\uCA15", "\uCA15"}, {"\uCA16", "\uCA16"}, {"\uCA17", "\uCA17"}, {"\uCA18", "\uCA18"}, {"\uCA19", "\uCA19"},
    {"\uCA1A", "\uCA1A"}, {"\uCA1B", "\uCA1B"}, {"\uCA1C", "\uCA1C"}, {"\uCA1D", "\uCA1D"}, {"\uCA1E", "\uCA1E"},
    {"\uCA1F", "\uCA1F"}, {"\uCA20", "\uCA20"}, {"\uCA21", "\uCA21"}, {"\uCA22", "\uCA22"}, {"\uCA23", "\uCA23"},
    {"\uCA24", "\uCA24"}, {"\uCA25", "\uCA25"}, {"\uCA26", "\uCA26"}, {"\uCA27", "\uCA27"}, {"\uCA28", "\uCA28"},
    {"\uCA29", "\uCA29"}, {"\uCA2A", "\uCA2A"}, {"\uCA2B", "\uCA2B"}, {"\uCA2C", "\uCA2C"}, {"\uCA2D", "\uCA2D"},
    {"\uCA2E", "\uCA2E"}, {"\uCA2F", "\uCA2F"}, {"\uCA30", "\uCA30"}, {"\uCA31", "\uCA31"}, {"\uCA32", "\uCA32"},
    {"\uCA33", "\uCA33"}, {"\uCA34", "\uCA34"}, {"\uCA35", "\uCA35"}, {"\uCA36", "\uCA36"}, {"\uCA37", "\uCA37"},
    {"\uCA38", "\uCA38"}, {"\uCA39", "\uCA39"}, {"\uCA3A", "\uCA3A"}, {"\uCA3B", "\uCA3B"}, {"\uCA3C", "\uCA3C"},
    {"\uCA3D", "\uCA3D"}, {"\uCA3E", "\uCA3E"}, {"\uCA3F", "\uCA3F"}, {"\uCA40", "\uCA40"}, {"\uCA41", "\uCA41"},
    {"\uCA42", "\uCA42"}, {"\uCA43", "\uCA43"}, {"\uCA44", "\uCA44"}, {"\uCA45", "\uCA45"}, {"\uCA46", "\uCA46"},
    {"\uCA47", "\uCA47"}, {"\uCA48", "\uCA48"}, {"\uCA49", "\uCA49"}, {"\uCA4A", "\uCA4A"}, {"\uCA4B", "\uCA4B"},
    {"\uCA4C", "\uCA4C"}, {"\uCA4D", "\uCA4D"}, {"\uCA4E", "\uCA4E"}, {"\uCA4F", "\uCA4F"}, {"\uCA50", "\uCA50"},
    {"\uCA51", "\uCA51"}, {"\uCA52", "\uCA52"}, {"\uCA53", "\uCA53"}, {"\uCA54", "\uCA54"}, {"\uCA55", "\uCA55"},
    {"\uCA56", "\uCA56"}, {"\uCA57", "\uCA57"}, {"\uCA58", "\uCA58"}, {"\uCA59", "\uCA59"}, {"\uCA5A", "\uCA5A"},
    {"\uCA5B", "\uCA5B"}, {"\uCA5C", "\uCA5C"}, {"\uCA5D", "\uCA5D"}, {"\uCA5E", "\uCA5E"}, {"\uCA5F", "\uCA5F"},
    {"\uCA60", "\uCA60"}, {"\uCA61", "\uCA61"}, {"\uCA62", "\uCA62"}, {"\uCA63", "\uCA63"}, {"\uCA64", "\uCA64"},
    {"\uCA65", "\uCA65"}, {"\uCA66", "\uCA66"}, {"\uCA67", "\uCA67"}, {"\uCA68", "\uCA68"}, {"\uCA69", "\uCA69"},
    {"\uCA6A", "\uCA6A"}, {"\uCA6B", "\uCA6B"}, {"\uCA6C", "\uCA6C"}, {"\uCA6D", "\uCA6D"}, {"\uCA6E", "\uCA6E"},
    {"\uCA6F", "\uCA6F"}, {"\uCA70", "\uCA70"}, {"\uCA71", "\uCA71"}, {"\uCA72", "\uCA72"}, {"\uCA73", "\uCA73"},
    {"\uCA74", "\uCA74"}, {"\uCA75", "\uCA75"}, {"\uCA76", "\uCA76"}, {"\uCA77", "\uCA77"}, {"\uCA78", "\uCA78"},
    {"\uCA79", "\uCA79"}, {"\uCA7A", "\uCA7A"}, {"\uCA7B", "\uCA7B"}, {"\uCA7C", "\uCA7C"}, {"\uCA7D", "\uCA7D"},
    {"\uCA7E", "\uCA7E"}, {"\uCA7F", "\uCA7F"}, {"\uCA80", "\uCA80"}, {"\uCA81", "\uCA81"}, {"\uCA82", "\uCA82"},
    {"\uCA83", "\uCA83"}, {"\uCA84", "\uCA84"}, {"\uCA85", "\uCA85"}, {"\uCA86", "\uCA86"}, {"\uCA87", "\uCA87"},
    {"\uCA88", "\uCA88"}, {"\uCA89", "\uCA89"}, {"\uCA8A", "\uCA8A"}, {"\uCA8B", "\uCA8B"}, {"\uCA8C", "\uCA8C"},
    {"\uCA8D", "\uCA8D"}, {"\uCA8E", "\uCA8E"}, {"\uCA8F", "\uCA8F"}, {"\uCA90", "\uCA90"}, {"\uCA91", "\uCA91"},
    {"\uCA92", "\uCA92"}, {"\uCA93", "\uCA93"}, {"\uCA94", "\uCA94"}, {"\uCA95", "\uCA95"}, {"\uCA96", "\uCA96"},
    {"\uCA97", "\uCA97"}, {"\uCA98", "\uCA98"}, {"\uCA99", "\uCA99"}, {"\uCA9A", "\uCA9A"}, {"\uCA9B", "\uCA9B"},
    {"\uCA9C", "\uCA9C"}, {"\uCA9D", "\uCA9D"}, {"\uCA9E", "\uCA9E"}, {"\uCA9F", "\uCA9F"}, {"\uCAA0", "\uCAA0"},
    {"\uCAA1", "\uCAA1"}, {"\uCAA2", "\uCAA2"}, {"\uCAA3", "\uCAA3"}, {"\uCAA4", "\uCAA4"}, {"\uCAA5", "\uCAA5"},
    {"\uCAA6", "\uCAA6"}, {"\uCAA7", "\uCAA7"}, {"\uCAA8", "\uCAA8"}, {"\uCAA9", "\uCAA9"}, {"\uCAAA", "\uCAAA"},
    {"\uCAAB", "\uCAAB"}, {"\uCAAC", "\uCAAC"}, {"\uCAAD", "\uCAAD"}, {"\uCAAE", "\uCAAE"}, {"\uCAAF", "\uCAAF"},
    {"\uCAB0", "\uCAB0"}, {"\uCAB1", "\uCAB1"}, {"\uCAB2", "\uCAB2"}, {"\uCAB3", "\uCAB3"}, {"\uCAB4", "\uCAB4"},
    {"\uCAB5", "\uCAB5"}, {"\uCAB6", "\uCAB6"}, {"\uCAB7", "\uCAB7"}, {"\uCAB8", "\uCAB8"}, {"\uCAB9", "\uCAB9"},
    {"\uCABA", "\uCABA"}, {"\uCABB", "\uCABB"}, {"\uCABC", "\uCABC"}, {"\uCABD", "\uCABD"}, {"\uCABE", "\uCABE"},
    {"\uCABF", "\uCABF"}, {"\uCAC0", "\uCAC0"}, {"\uCAC1", "\uCAC1"}, {"\uCAC2", "\uCAC2"}, {"\uCAC3", "\uCAC3"},
    {"\uCAC4", "\uCAC4"}, {"\uCAC5", "\uCAC5"}, {"\uCAC6", "\uCAC6"}, {"\uCAC7", "\uCAC7"}, {"\uCAC8", "\uCAC8"},
    {"\uCAC9", "\uCAC9"}, {"\uCACA", "\uCACA"}, {"\uCACB", "\uCACB"}, {"\uCACC", "\uCACC"}, {"\uCACD", "\uCACD"},
    {"\uCACE", "\uCACE"}, {"\uCACF", "\uCACF"}, {"\uCAD0", "\uCAD0"}, {"\uCAD1", "\uCAD1"}, {"\uCAD2", "\uCAD2"},
    {"\uCAD3", "\uCAD3"}, {"\uCAD4", "\uCAD4"}, {"\uCAD5", "\uCAD5"}, {"\uCAD6", "\uCAD6"}, {"\uCAD7", "\uCAD7"},
    {"\uCAD8", "\uCAD8"}, {"\uCAD9", "\uCAD9"}, {"\uCADA", "\uCADA"}, {"\uCADB", "\uCADB"}, {"\uCADC", "\uCADC"},
    {"\uCADD", "\uCADD"}, {"\uCADE", "\uCADE"}, {"\uCADF", "\uCADF"}, {"\uCAE0", "\uCAE0"}, {"\uCAE1", "\uCAE1"},
    {"\uCAE2", "\uCAE2"}, {"\uCAE3", "\uCAE3"}, {"\uCAE4", "\uCAE4"}, {"\uCAE5", "\uCAE5"}, {"\uCAE6", "\uCAE6"},
    {"\uCAE7", "\uCAE7"}, {"\uCAE8", "\uCAE8"}, {"\uCAE9", "\uCAE9"}, {"\uCAEA", "\uCAEA"}, {"\uCAEB", "\uCAEB"},
    {"\uCAEC", "\uCAEC"}, {"\uCAED", "\uCAED"}, {"\uCAEE", "\uCAEE"}, {"\uCAEF", "\uCAEF"}, {"\uCAF0", "\uCAF0"},
    {"\uCAF1", "\uCAF1"}, {"\uCAF2", "\uCAF2"}, {"\uCAF3", "\uCAF3"}, {"\uCAF4", "\uCAF4"}, {"\uCAF5", "\uCAF5"},
    {"\uCAF6", "\uCAF6"}, {"\uCAF7", "\uCAF7"}, {"\uCAF8", "\uCAF8"}, {"\uCAF9", "\uCAF9"}, {"\uCAFA", "\uCAFA"},
    {"\uCAFB", "\uCAFB"}, {"\uCAFC", "\uCAFC"}, {"\uCAFD", "\uCAFD"}, {"\uCAFE", "\uCAFE"}, {"\uCAFF", "\uCAFF"},
    {"\uCB00", "\uCB00"}, {"\uCB01", "\uCB01"}, {"\uCB02", "\uCB02"}, {"\uCB03", "\uCB03"}, {"\uCB04", "\uCB04"},
    {"\uCB05", "\uCB05"}, {"\uCB06", "\uCB06"}, {"\uCB07", "\uCB07"}, {"\uCB08", "\uCB08"}, {"\uCB09", "\uCB09"},
    {"\uCB0A", "\uCB0A"}, {"\uCB0B", "\uCB0B"}, {"\uCB0C", "\uCB0C"}, {"\uCB0D", "\uCB0D"}, {"\uCB0E", "\uCB0E"},
    {"\uCB0F", "\uCB0F"}, {"\uCB10", "\uCB10"}, {"\uCB11", "\uCB11"}, {"\uCB12", "\uCB12"}, {"\uCB13", "\uCB13"},
    {"\uCB14", "\uCB14"}, {"\uCB15", "\uCB15"}, {"\uCB16", "\uCB16"}, {"\uCB17", "\uCB17"}, {"\uCB18", "\uCB18"},
    {"\uCB19", "\uCB19"}, {"\uCB1A", "\uCB1A"}, {"\uCB1B", "\uCB1B"}, {"\uCB1C", "\uCB1C"}, {"\uCB1D", "\uCB1D"},
    {"\uCB1E", "\uCB1E"}, {"\uCB1F", "\uCB1F"}, {"\uCB20", "\uCB20"}, {"\uCB21", "\uCB21"}, {"\uCB22", "\uCB22"},
    {"\uCB23", "\uCB23"}, {"\uCB24", "\uCB24"}, {"\uCB25", "\uCB25"}, {"\uCB26", "\uCB26"}, {"\uCB27", "\uCB27"},
    {"\uCB28", "\uCB28"}, {"\uCB29", "\uCB29"}, {"\uCB2A", "\uCB2A"}, {"\uCB2B", "\uCB2B"}, {"\uCB2C", "\uCB2C"},
    {"\uCB2D", "\uCB2D"}, {"\uCB2E", "\uCB2E"}, {"\uCB2F", "\uCB2F"}, {"\uCB30", "\uCB30"}, {"\uCB31", "\uCB31"},
    {"\uCB32", "\uCB32"}, {"\uCB33", "\uCB33"}, {"\uCB34", "\uCB34"}, {"\uCB35", "\uCB35"}, {"\uCB36", "\uCB36"},
    {"\uCB37", "\uCB37"}, {"\uCB38", "\uCB38"}, {"\uCB39", "\uCB39"}, {"\uCB3A", "\uCB3A"}, {"\uCB3B", "\uCB3B"},
    {"\uCB3C", "\uCB3C"}, {"\uCB3D", "\uCB3D"}, {"\uCB3E", "\uCB3E"}, {"\uCB3F", "\uCB3F"}, {"\uCB40", "\uCB40"},
    {"\uCB41", "\uCB41"}, {"\uCB42", "\uCB42"}, {"\uCB43", "\uCB43"}, {"\uCB44", "\uCB44"}, {"\uCB45", "\uCB45"},
    {"\uCB46", "\uCB46"}, {"\uCB47", "\uCB47"}, {"\uCB48", "\uCB48"}, {"\uCB49", "\uCB49"}, {"\uCB4A", "\uCB4A"},
    {"\uCB4B", "\uCB4B"}, {"\uCB4C", "\uCB4C"}, {"\uCB4D", "\uCB4D"}, {"\uCB4E", "\uCB4E"}, {"\uCB4F", "\uCB4F"},
    {"\uCB50", "\uCB50"}, {"\uCB51", "\uCB51"}, {"\uCB52", "\uCB52"}, {"\uCB53", "\uCB53"}, {"\uCB54", "\uCB54"},
    {"\uCB55", "\uCB55"}, {"\uCB56", "\uCB56"}, {"\uCB57", "\uCB57"}, {"\uCB58", "\uCB58"}, {"\uCB59", "\uCB59"},
    {"\uCB5A", "\uCB5A"}, {"\uCB5B", "\uCB5B"}, {"\uCB5C", "\uCB5C"}, {"\uCB5D", "\uCB5D"}, {"\uCB5E", "\uCB5E"},
    {"\uCB5F", "\uCB5F"}, {"\uCB60", "\uCB60"}, {"\uCB61", "\uCB61"}, {"\uCB62", "\uCB62"}, {"\uCB63", "\uCB63"},
    {"\uCB64", "\uCB64"}, {"\uCB65", "\uCB65"}, {"\uCB66", "\uCB66"}, {"\uCB67", "\uCB67"}, {"\uCB68", "\uCB68"},
    {"\uCB69", "\uCB69"}, {"\uCB6A", "\uCB6A"}, {"\uCB6B", "\uCB6B"}, {"\uCB6C", "\uCB6C"}, {"\uCB6D", "\uCB6D"},
    {"\uCB6E", "\uCB6E"}, {"\uCB6F", "\uCB6F"}, {"\uCB70", "\uCB70"}, {"\uCB71", "\uCB71"}, {"\uCB72", "\uCB72"},
    {"\uCB73", "\uCB73"}, {"\uCB74", "\uCB74"}, {"\uCB75", "\uCB75"}, {"\uCB76", "\uCB76"}, {"\uCB77", "\uCB77"},
    {"\uCB78", "\uCB78"}, {"\uCB79", "\uCB79"}, {"\uCB7A", "\uCB7A"}, {"\uCB7B", "\uCB7B"}, {"\uCB7C", "\uCB7C"},
    {"\uCB7D", "\uCB7D"}, {"\uCB7E", "\uCB7E"}, {"\uCB7F", "\uCB7F"}, {"\uCB80", "\uCB80"}, {"\uCB81", "\uCB81"},
    {"\uCB82", "\uCB82"}, {"\uCB83", "\uCB83"}, {"\uCB84", "\uCB84"}, {"\uCB85", "\uCB85"}, {"\uCB86", "\uCB86"},
    {"\uCB87", "\uCB87"}, {"\uCB88", "\uCB88"}, {"\uCB89", "\uCB89"}, {"\uCB8A", "\uCB8A"}, {"\uCB8B", "\uCB8B"},
    {"\uCB8C", "\uCB8C"}, {"\uCB8D", "\uCB8D"}, {"\uCB8E", "\uCB8E"}, {"\uCB8F", "\uCB8F"}, {"\uCB90", "\uCB90"},
    {"\uCB91", "\uCB91"}, {"\uCB92", "\uCB92"}, {"\uCB93", "\uCB93"}, {"\uCB94", "\uCB94"}, {"\uCB95", "\uCB95"},
    {"\uCB96", "\uCB96"}, {"\uCB97", "\uCB97"}, {"\uCB98", "\uCB98"}, {"\uCB99", "\uCB99"}, {"\uCB9A", "\uCB9A"},
    {"\uCB9B", "\uCB9B"}, {"\uCB9C", "\uCB9C"}, {"\uCB9D", "\uCB9D"}, {"\uCB9E", "\uCB9E"}, {"\uCB9F", "\uCB9F"},
    {"\uCBA0", "\uCBA0"}, {"\uCBA1", "\uCBA1"}, {"\uCBA2", "\uCBA2"}, {"\uCBA3", "\uCBA3"}, {"\uCBA4", "\uCBA4"},
    {"\uCBA5", "\uCBA5"}, {"\uCBA6", "\uCBA6"}, {"\uCBA7", "\uCBA7"}, {"\uCBA8", "\uCBA8"}, {"\uCBA9", "\uCBA9"},
    {"\uCBAA", "\uCBAA"}, {"\uCBAB", "\uCBAB"}, {"\uCBAC", "\uCBAC"}, {"\uCBAD", "\uCBAD"}, {"\uCBAE", "\uCBAE"},
    {"\uCBAF", "\uCBAF"}, {"\uCBB0", "\uCBB0"}, {"\uCBB1", "\uCBB1"}, {"\uCBB2", "\uCBB2"}, {"\uCBB3", "\uCBB3"},
    {"\uCBB4", "\uCBB4"}, {"\uCBB5", "\uCBB5"}, {"\uCBB6", "\uCBB6"}, {"\uCBB7", "\uCBB7"}, {"\uCBB8", "\uCBB8"},
    {"\uCBB9", "\uCBB9"}, {"\uCBBA", "\uCBBA"}, {"\uCBBB", "\uCBBB"}, {"\uCBBC", "\uCBBC"}, {"\uCBBD", "\uCBBD"},
    {"\uCBBE", "\uCBBE"}, {"\uCBBF", "\uCBBF"}, {"\uCBC0", "\uCBC0"}, {"\uCBC1", "\uCBC1"}, {"\uCBC2", "\uCBC2"},
    {"\uCBC3", "\uCBC3"}, {"\uCBC4", "\uCBC4"}, {"\uCBC5", "\uCBC5"}, {"\uCBC6", "\uCBC6"}, {"\uCBC7", "\uCBC7"},
    {"\uCBC8", "\uCBC8"}, {"\uCBC9", "\uCBC9"}, {"\uCBCA", "\uCBCA"}, {"\uCBCB", "\uCBCB"}, {"\uCBCC", "\uCBCC"},
    {"\uCBCD", "\uCBCD"}, {"\uCBCE", "\uCBCE"}, {"\uCBCF", "\uCBCF"}, {"\uCBD0", "\uCBD0"}, {"\uCBD1", "\uCBD1"},
    {"\uCBD2", "\uCBD2"}, {"\uCBD3", "\uCBD3"}, {"\uCBD4", "\uCBD4"}, {"\uCBD5", "\uCBD5"}, {"\uCBD6", "\uCBD6"},
    {"\uCBD7", "\uCBD7"}, {"\uCBD8", "\uCBD8"}, {"\uCBD9", "\uCBD9"}, {"\uCBDA", "\uCBDA"}, {"\uCBDB", "\uCBDB"},
    {"\uCBDC", "\uCBDC"}, {"\uCBDD", "\uCBDD"}, {"\uCBDE", "\uCBDE"}, {"\uCBDF", "\uCBDF"}, {"\uCBE0", "\uCBE0"},
    {"\uCBE1", "\uCBE1"}, {"\uCBE2", "\uCBE2"}, {"\uCBE3", "\uCBE3"}, {"\uCBE4", "\uCBE4"}, {"\uCBE5", "\uCBE5"},
    {"\uCBE6", "\uCBE6"}, {"\uCBE7", "\uCBE7"}, {"\uCBE8", "\uCBE8"}, {"\uCBE9", "\uCBE9"}, {"\uCBEA", "\uCBEA"},
    {"\uCBEB", "\uCBEB"}, {"\uCBEC", "\uCBEC"}, {"\uCBED", "\uCBED"}, {"\uCBEE", "\uCBEE"}, {"\uCBEF", "\uCBEF"},
    {"\uCBF0", "\uCBF0"}, {"\uCBF1", "\uCBF1"}, {"\uCBF2", "\uCBF2"}, {"\uCBF3", "\uCBF3"}, {"\uCBF4", "\uCBF4"},
    {"\uCBF5", "\uCBF5"}, {"\uCBF6", "\uCBF6"}, {"\uCBF7", "\uCBF7"}, {"\uCBF8", "\uCBF8"}, {"\uCBF9", "\uCBF9"},
    {"\uCBFA", "\uCBFA"}, {"\uCBFB", "\uCBFB"}, {"\uCBFC", "\uCBFC"}, {"\uCBFD", "\uCBFD"}, {"\uCBFE", "\uCBFE"},
    {"\uCBFF", "\uCBFF"}, {"\uCC00", "\uCC00"}, {"\uCC01", "\uCC01"}, {"\uCC02", "\uCC02"}, {"\uCC03", "\uCC03"},
    {"\uCC04", "\uCC04"}, {"\uCC05", "\uCC05"}, {"\uCC06", "\uCC06"}, {"\uCC07", "\uCC07"}, {"\uCC08", "\uCC08"},
    {"\uCC09", "\uCC09"}, {"\uCC0A", "\uCC0A"}, {"\uCC0B", "\uCC0B"}, {"\uCC0C", "\uCC0C"}, {"\uCC0D", "\uCC0D"},
    {"\uCC0E", "\uCC0E"}, {"\uCC0F", "\uCC0F"}, {"\uCC10", "\uCC10"}, {"\uCC11", "\uCC11"}, {"\uCC12", "\uCC12"},
    {"\uCC13", "\uCC13"}, {"\uCC14", "\uCC14"}, {"\uCC15", "\uCC15"}, {"\uCC16", "\uCC16"}, {"\uCC17", "\uCC17"},
    {"\uCC18", "\uCC18"}, {"\uCC19", "\uCC19"}, {"\uCC1A", "\uCC1A"}, {"\uCC1B", "\uCC1B"}, {"\uCC1C", "\uCC1C"},
    {"\uCC1D", "\uCC1D"}, {"\uCC1E", "\uCC1E"}, {"\uCC1F", "\uCC1F"}, {"\uCC20", "\uCC20"}, {"\uCC21", "\uCC21"},
    {"\uCC22", "\uCC22"}, {"\uCC23", "\uCC23"}, {"\uCC24", "\uCC24"}, {"\uCC25", "\uCC25"}, {"\uCC26", "\uCC26"},
    {"\uCC27", "\uCC27"}, {"\uCC28", "\uCC28"}, {"\uCC29", "\uCC29"}, {"\uCC2A", "\uCC2A"}, {"\uCC2B", "\uCC2B"},
    {"\uCC2C", "\uCC2C"}, {"\uCC2D", "\uCC2D"}, {"\uCC2E", "\uCC2E"}, {"\uCC2F", "\uCC2F"}, {"\uCC30", "\uCC30"},
    {"\uCC31", "\uCC31"}, {"\uCC32", "\uCC32"}, {"\uCC33", "\uCC33"}, {"\uCC34", "\uCC34"}, {"\uCC35", "\uCC35"},
    {"\uCC36", "\uCC36"}, {"\uCC37", "\uCC37"}, {"\uCC38", "\uCC38"}, {"\uCC39", "\uCC39"}, {"\uCC3A", "\uCC3A"},
    {"\uCC3B", "\uCC3B"}, {"\uCC3C", "\uCC3C"}, {"\uCC3D", "\uCC3D"}, {"\uCC3E", "\uCC3E"}, {"\uCC3F", "\uCC3F"},
    {"\uCC40", "\uCC40"}, {"\uCC41", "\uCC41"}, {"\uCC42", "\uCC42"}, {"\uCC43", "\uCC43"}, {"\uCC44", "\uCC44"},
    {"\uCC45", "\uCC45"}, {"\uCC46", "\uCC46"}, {"\uCC47", "\uCC47"}, {"\uCC48", "\uCC48"}, {"\uCC49", "\uCC49"},
    {"\uCC4A", "\uCC4A"}, {"\uCC4B", "\uCC4B"}, {"\uCC4C", "\uCC4C"}, {"\uCC4D", "\uCC4D"}, {"\uCC4E", "\uCC4E"},
    {"\uCC4F", "\uCC4F"}, {"\uCC50", "\uCC50"}, {"\uCC51", "\uCC51"}, {"\uCC52", "\uCC52"}, {"\uCC53", "\uCC53"},
    {"\uCC54", "\uCC54"}, {"\uCC55", "\uCC55"}, {"\uCC56", "\uCC56"}, {"\uCC57", "\uCC57"}, {"\uCC58", "\uCC58"},
    {"\uCC59", "\uCC59"}, {"\uCC5A", "\uCC5A"}, {"\uCC5B", "\uCC5B"}, {"\uCC5C", "\uCC5C"}, {"\uCC5D", "\uCC5D"},
    {"\uCC5E", "\uCC5E"}, {"\uCC5F", "\uCC5F"}, {"\uCC60", "\uCC60"}, {"\uCC61", "\uCC61"}, {"\uCC62", "\uCC62"},
    {"\uCC63", "\uCC63"}, {"\uCC64", "\uCC64"}, {"\uCC65", "\uCC65"}, {"\uCC66", "\uCC66"}, {"\uCC67", "\uCC67"},
    {"\uCC68", "\uCC68"}, {"\uCC69", "\uCC69"}, {"\uCC6A", "\uCC6A"}, {"\uCC6B", "\uCC6B"}, {"\uCC6C", "\uCC6C"},
    {"\uCC6D", "\uCC6D"}, {"\uCC6E", "\uCC6E"}, {"\uCC6F", "\uCC6F"}, {"\uCC70", "\uCC70"}, {"\uCC71", "\uCC71"},
    {"\uCC72", "\uCC72"}, {"\uCC73", "\uCC73"}, {"\uCC74", "\uCC74"}, {"\uCC75", "\uCC75"}, {"\uCC76", "\uCC76"},
    {"\uCC77", "\uCC77"}, {"\uCC78", "\uCC78"}, {"\uCC79", "\uCC79"}, {"\uCC7A", "\uCC7A"}, {"\uCC7B", "\uCC7B"},
    {"\uCC7C", "\uCC7C"}, {"\uCC7D", "\uCC7D"}, {"\uCC7E", "\uCC7E"}, {"\uCC7F", "\uCC7F"}, {"\uCC80", "\uCC80"},
    {"\uCC81", "\uCC81"}, {"\uCC82", "\uCC82"}, {"\uCC83", "\uCC83"}, {"\uCC84", "\uCC84"}, {"\uCC85", "\uCC85"},
    {"\uCC86", "\uCC86"}, {"\uCC87", "\uCC87"}, {"\uCC88", "\uCC88"}, {"\uCC89", "\uCC89"}, {"\uCC8A", "\uCC8A"},
    {"\uCC8B", "\uCC8B"}, {"\uCC8C", "\uCC8C"}, {"\uCC8D", "\uCC8D"}, {"\uCC8E", "\uCC8E"}, {"\uCC8F", "\uCC8F"},
    {"\uCC90", "\uCC90"}, {"\uCC91", "\uCC91"}, {"\uCC92", "\uCC92"}, {"\uCC93", "\uCC93"}, {"\uCC94", "\uCC94"},
    {"\uCC95", "\uCC95"}, {"\uCC96", "\uCC96"}, {"\uCC97", "\uCC97"}, {"\uCC98", "\uCC98"}, {"\uCC99", "\uCC99"},
    {"\uCC9A", "\uCC9A"}, {"\uCC9B", "\uCC9B"}, {"\uCC9C", "\uCC9C"}, {"\uCC9D", "\uCC9D"}, {"\uCC9E", "\uCC9E"},
    {"\uCC9F", "\uCC9F"}, {"\uCCA0", "\uCCA0"}, {"\uCCA1", "\uCCA1"}, {"\uCCA2", "\uCCA2"}, {"\uCCA3", "\uCCA3"},
    {"\uCCA4", "\uCCA4"}, {"\uCCA5", "\uCCA5"}, {"\uCCA6", "\uCCA6"}, {"\uCCA7", "\uCCA7"}, {"\uCCA8", "\uCCA8"},
    {"\uCCA9", "\uCCA9"}, {"\uCCAA", "\uCCAA"}, {"\uCCAB", "\uCCAB"}, {"\uCCAC", "\uCCAC"}, {"\uCCAD", "\uCCAD"},
    {"\uCCAE", "\uCCAE"}, {"\uCCAF", "\uCCAF"}, {"\uCCB0", "\uCCB0"}, {"\uCCB1", "\uCCB1"}, {"\uCCB2", "\uCCB2"},
    {"\uCCB3", "\uCCB3"}, {"\uCCB4", "\uCCB4"}, {"\uCCB5", "\uCCB5"}, {"\uCCB6", "\uCCB6"}, {"\uCCB7", "\uCCB7"},
    {"\uCCB8", "\uCCB8"}, {"\uCCB9", "\uCCB9"}, {"\uCCBA", "\uCCBA"}, {"\uCCBB", "\uCCBB"}, {"\uCCBC", "\uCCBC"},
    {"\uCCBD", "\uCCBD"}, {"\uCCBE", "\uCCBE"}, {"\uCCBF", "\uCCBF"}, {"\uCCC0", "\uCCC0"}, {"\uCCC1", "\uCCC1"},
    {"\uCCC2", "\uCCC2"}, {"\uCCC3", "\uCCC3"}, {"\uCCC4", "\uCCC4"}, {"\uCCC5", "\uCCC5"}, {"\uCCC6", "\uCCC6"},
    {"\uCCC7", "\uCCC7"}, {"\uCCC8", "\uCCC8"}, {"\uCCC9", "\uCCC9"}, {"\uCCCA", "\uCCCA"}, {"\uCCCB", "\uCCCB"},
    {"\uCCCC", "\uCCCC"}, {"\uCCCD", "\uCCCD"}, {"\uCCCE", "\uCCCE"}, {"\uCCCF", "\uCCCF"}, {"\uCCD0", "\uCCD0"},
    {"\uCCD1", "\uCCD1"}, {"\uCCD2", "\uCCD2"}, {"\uCCD3", "\uCCD3"}, {"\uCCD4", "\uCCD4"}, {"\uCCD5", "\uCCD5"},
    {"\uCCD6", "\uCCD6"}, {"\uCCD7", "\uCCD7"}, {"\uCCD8", "\uCCD8"}, {"\uCCD9", "\uCCD9"}, {"\uCCDA", "\uCCDA"},
    {"\uCCDB", "\uCCDB"}, {"\uCCDC", "\uCCDC"}, {"\uCCDD", "\uCCDD"}, {"\uCCDE", "\uCCDE"}, {"\uCCDF", "\uCCDF"},
    {"\uCCE0", "\uCCE0"}, {"\uCCE1", "\uCCE1"}, {"\uCCE2", "\uCCE2"}, {"\uCCE3", "\uCCE3"}, {"\uCCE4", "\uCCE4"},
    {"\uCCE5", "\uCCE5"}, {"\uCCE6", "\uCCE6"}, {"\uCCE7", "\uCCE7"}, {"\uCCE8", "\uCCE8"}, {"\uCCE9", "\uCCE9"},
    {"\uCCEA", "\uCCEA"}, {"\uCCEB", "\uCCEB"}, {"\uCCEC", "\uCCEC"}, {"\uCCED", "\uCCED"}, {"\uCCEE", "\uCCEE"},
    {"\uCCEF", "\uCCEF"}, {"\uCCF0", "\uCCF0"}, {"\uCCF1", "\uCCF1"}, {"\uCCF2", "\uCCF2"}, {"\uCCF3", "\uCCF3"},
    {"\uCCF4", "\uCCF4"}, {"\uCCF5", "\uCCF5"}, {"\uCCF6", "\uCCF6"}, {"\uCCF7", "\uCCF7"}, {"\uCCF8", "\uCCF8"},
    {"\uCCF9", "\uCCF9"}, {"\uCCFA", "\uCCFA"}, {"\uCCFB", "\uCCFB"}, {"\uCCFC", "\uCCFC"}, {"\uCCFD", "\uCCFD"},
    {"\uCCFE", "\uCCFE"}, {"\uCCFF", "\uCCFF"}, {"\uCD00", "\uCD00"}, {"\uCD01", "\uCD01"}, {"\uCD02", "\uCD02"},
    {"\uCD03", "\uCD03"}, {"\uCD04", "\uCD04"}, {"\uCD05", "\uCD05"}, {"\uCD06", "\uCD06"}, {"\uCD07", "\uCD07"},
    {"\uCD08", "\uCD08"}, {"\uCD09", "\uCD09"}, {"\uCD0A", "\uCD0A"}, {"\uCD0B", "\uCD0B"}, {"\uCD0C", "\uCD0C"},
    {"\uCD0D", "\uCD0D"}, {"\uCD0E", "\uCD0E"}, {"\uCD0F", "\uCD0F"}, {"\uCD10", "\uCD10"}, {"\uCD11", "\uCD11"},
    {"\uCD12", "\uCD12"}, {"\uCD13", "\uCD13"}, {"\uCD14", "\uCD14"}, {"\uCD15", "\uCD15"}, {"\uCD16", "\uCD16"},
    {"\uCD17", "\uCD17"}, {"\uCD18", "\uCD18"}, {"\uCD19", "\uCD19"}, {"\uCD1A", "\uCD1A"}, {"\uCD1B", "\uCD1B"},
    {"\uCD1C", "\uCD1C"}, {"\uCD1D", "\uCD1D"}, {"\uCD1E", "\uCD1E"}, {"\uCD1F", "\uCD1F"}, {"\uCD20", "\uCD20"},
    {"\uCD21", "\uCD21"}, {"\uCD22", "\uCD22"}, {"\uCD23", "\uCD23"}, {"\uCD24", "\uCD24"}, {"\uCD25", "\uCD25"},
    {"\uCD26", "\uCD26"}, {"\uCD27", "\uCD27"}, {"\uCD28", "\uCD28"}, {"\uCD29", "\uCD29"}, {"\uCD2A", "\uCD2A"},
    {"\uCD2B", "\uCD2B"}, {"\uCD2C", "\uCD2C"}, {"\uCD2D", "\uCD2D"}, {"\uCD2E", "\uCD2E"}, {"\uCD2F", "\uCD2F"},
    {"\uCD30", "\uCD30"}, {"\uCD31", "\uCD31"}, {"\uCD32", "\uCD32"}, {"\uCD33", "\uCD33"}, {"\uCD34", "\uCD34"},
    {"\uCD35", "\uCD35"}, {"\uCD36", "\uCD36"}, {"\uCD37", "\uCD37"}, {"\uCD38", "\uCD38"}, {"\uCD39", "\uCD39"},
    {"\uCD3A", "\uCD3A"}, {"\uCD3B", "\uCD3B"}, {"\uCD3C", "\uCD3C"}, {"\uCD3D", "\uCD3D"}, {"\uCD3E", "\uCD3E"},
    {"\uCD3F", "\uCD3F"}, {"\uCD40", "\uCD40"}, {"\uCD41", "\uCD41"}, {"\uCD42", "\uCD42"}, {"\uCD43", "\uCD43"},
    {"\uCD44", "\uCD44"}, {"\uCD45", "\uCD45"}, {"\uCD46", "\uCD46"}, {"\uCD47", "\uCD47"}, {"\uCD48", "\uCD48"},
    {"\uCD49", "\uCD49"}, {"\uCD4A", "\uCD4A"}, {"\uCD4B", "\uCD4B"}, {"\uCD4C", "\uCD4C"}, {"\uCD4D", "\uCD4D"},
    {"\uCD4E", "\uCD4E"}, {"\uCD4F", "\uCD4F"}, {"\uCD50", "\uCD50"}, {"\uCD51", "\uCD51"}, {"\uCD52", "\uCD52"},
    {"\uCD53", "\uCD53"}, {"\uCD54", "\uCD54"}, {"\uCD55", "\uCD55"}, {"\uCD56", "\uCD56"}, {"\uCD57", "\uCD57"},
    {"\uCD58", "\uCD58"}, {"\uCD59", "\uCD59"}, {"\uCD5A", "\uCD5A"}, {"\uCD5B", "\uCD5B"}, {"\uCD5C", "\uCD5C"},
    {"\uCD5D", "\uCD5D"}, {"\uCD5E", "\uCD5E"}, {"\uCD5F", "\uCD5F"}, {"\uCD60", "\uCD60"}, {"\uCD61", "\uCD61"},
    {"\uCD62", "\uCD62"}, {"\uCD63", "\uCD63"}, {"\uCD64", "\uCD64"}, {"\uCD65", "\uCD65"}, {"\uCD66", "\uCD66"},
    {"\uCD67", "\uCD67"}, {"\uCD68", "\uCD68"}, {"\uCD69", "\uCD69"}, {"\uCD6A", "\uCD6A"}, {"\uCD6B", "\uCD6B"},
    {"\uCD6C", "\uCD6C"}, {"\uCD6D", "\uCD6D"}, {"\uCD6E", "\uCD6E"}, {"\uCD6F", "\uCD6F"}, {"\uCD70", "\uCD70"},
    {"\uCD71", "\uCD71"}, {"\uCD72", "\uCD72"}, {"\uCD73", "\uCD73"}, {"\uCD74", "\uCD74"}, {"\uCD75", "\uCD75"},
    {"\uCD76", "\uCD76"}, {"\uCD77", "\uCD77"}, {"\uCD78", "\uCD78"}, {"\uCD79", "\uCD79"}, {"\uCD7A", "\uCD7A"},
    {"\uCD7B", "\uCD7B"}, {"\uCD7C", "\uCD7C"}, {"\uCD7D", "\uCD7D"}, {"\uCD7E", "\uCD7E"}, {"\uCD7F", "\uCD7F"},
    {"\uCD80", "\uCD80"}, {"\uCD81", "\uCD81"}, {"\uCD82", "\uCD82"}, {"\uCD83", "\uCD83"}, {"\uCD84", "\uCD84"},
    {"\uCD85", "\uCD85"}, {"\uCD86", "\uCD86"}, {"\uCD87", "\uCD87"}, {"\uCD88", "\uCD88"}, {"\uCD89", "\uCD89"},
    {"\uCD8A", "\uCD8A"}, {"\uCD8B", "\uCD8B"}, {"\uCD8C", "\uCD8C"}, {"\uCD8D", "\uCD8D"}, {"\uCD8E", "\uCD8E"},
    {"\uCD8F", "\uCD8F"}, {"\uCD90", "\uCD90"}, {"\uCD91", "\uCD91"}, {"\uCD92", "\uCD92"}, {"\uCD93", "\uCD93"},
    {"\uCD94", "\uCD94"}, {"\uCD95", "\uCD95"}, {"\uCD96", "\uCD96"}, {"\uCD97", "\uCD97"}, {"\uCD98", "\uCD98"},
    {"\uCD99", "\uCD99"}, {"\uCD9A", "\uCD9A"}, {"\uCD9B", "\uCD9B"}, {"\uCD9C", "\uCD9C"}, {"\uCD9D", "\uCD9D"},
    {"\uCD9E", "\uCD9E"}, {"\uCD9F", "\uCD9F"}, {"\uCDA0", "\uCDA0"}, {"\uCDA1", "\uCDA1"}, {"\uCDA2", "\uCDA2"},
    {"\uCDA3", "\uCDA3"}, {"\uCDA4", "\uCDA4"}, {"\uCDA5", "\uCDA5"}, {"\uCDA6", "\uCDA6"}, {"\uCDA7", "\uCDA7"},
    {"\uCDA8", "\uCDA8"}, {"\uCDA9", "\uCDA9"}, {"\uCDAA", "\uCDAA"}, {"\uCDAB", "\uCDAB"}, {"\uCDAC", "\uCDAC"},
    {"\uCDAD", "\uCDAD"}, {"\uCDAE", "\uCDAE"}, {"\uCDAF", "\uCDAF"}, {"\uCDB0", "\uCDB0"}, {"\uCDB1", "\uCDB1"},
    {"\uCDB2", "\uCDB2"}, {"\uCDB3", "\uCDB3"}, {"\uCDB4", "\uCDB4"}, {"\uCDB5", "\uCDB5"}, {"\uCDB6", "\uCDB6"},
    {"\uCDB7", "\uCDB7"}, {"\uCDB8", "\uCDB8"}, {"\uCDB9", "\uCDB9"}, {"\uCDBA", "\uCDBA"}, {"\uCDBB", "\uCDBB"},
    {"\uCDBC", "\uCDBC"}, {"\uCDBD", "\uCDBD"}, {"\uCDBE", "\uCDBE"}, {"\uCDBF", "\uCDBF"}, {"\uCDC0", "\uCDC0"},
    {"\uCDC1", "\uCDC1"}, {"\uCDC2", "\uCDC2"}, {"\uCDC3", "\uCDC3"}, {"\uCDC4", "\uCDC4"}, {"\uCDC5", "\uCDC5"},
    {"\uCDC6", "\uCDC6"}, {"\uCDC7", "\uCDC7"}, {"\uCDC8", "\uCDC8"}, {"\uCDC9", "\uCDC9"}, {"\uCDCA", "\uCDCA"},
    {"\uCDCB", "\uCDCB"}, {"\uCDCC", "\uCDCC"}, {"\uCDCD", "\uCDCD"}, {"\uCDCE", "\uCDCE"}, {"\uCDCF", "\uCDCF"},
    {"\uCDD0", "\uCDD0"}, {"\uCDD1", "\uCDD1"}, {"\uCDD2", "\uCDD2"}, {"\uCDD3", "\uCDD3"}, {"\uCDD4", "\uCDD4"},
    {"\uCDD5", "\uCDD5"}, {"\uCDD6", "\uCDD6"}, {"\uCDD7", "\uCDD7"}, {"\uCDD8", "\uCDD8"}, {"\uCDD9", "\uCDD9"},
    {"\uCDDA", "\uCDDA"}, {"\uCDDB", "\uCDDB"}, {"\uCDDC", "\uCDDC"}, {"\uCDDD", "\uCDDD"}, {"\uCDDE", "\uCDDE"},
    {"\uCDDF", "\uCDDF"}, {"\uCDE0", "\uCDE0"}, {"\uCDE1", "\uCDE1"}, {"\uCDE2", "\uCDE2"}, {"\uCDE3", "\uCDE3"},
    {"\uCDE4", "\uCDE4"}, {"\uCDE5", "\uCDE5"}, {"\uCDE6", "\uCDE6"}, {"\uCDE7", "\uCDE7"}, {"\uCDE8", "\uCDE8"},
    {"\uCDE9", "\uCDE9"}, {"\uCDEA", "\uCDEA"}, {"\uCDEB", "\uCDEB"}, {"\uCDEC", "\uCDEC"}, {"\uCDED", "\uCDED"},
    {"\uCDEE", "\uCDEE"}, {"\uCDEF", "\uCDEF"}, {"\uCDF0", "\uCDF0"}, {"\uCDF1", "\uCDF1"}, {"\uCDF2", "\uCDF2"},
    {"\uCDF3", "\uCDF3"}, {"\uCDF4", "\uCDF4"}, {"\uCDF5", "\uCDF5"}, {"\uCDF6", "\uCDF6"}, {"\uCDF7", "\uCDF7"},
    {"\uCDF8", "\uCDF8"}, {"\uCDF9", "\uCDF9"}, {"\uCDFA", "\uCDFA"}, {"\uCDFB", "\uCDFB"}, {"\uCDFC", "\uCDFC"},
    {"\uCDFD", "\uCDFD"}, {"\uCDFE", "\uCDFE"}, {"\uCDFF", "\uCDFF"}, {"\uCE00", "\uCE00"}, {"\uCE01", "\uCE01"},
    {"\uCE02", "\uCE02"}, {"\uCE03", "\uCE03"}, {"\uCE04", "\uCE04"}, {"\uCE05", "\uCE05"}, {"\uCE06", "\uCE06"},
    {"\uCE07", "\uCE07"}, {"\uCE08", "\uCE08"}, {"\uCE09", "\uCE09"}, {"\uCE0A", "\uCE0A"}, {"\uCE0B", "\uCE0B"},
    {"\uCE0C", "\uCE0C"}, {"\uCE0D", "\uCE0D"}, {"\uCE0E", "\uCE0E"}, {"\uCE0F", "\uCE0F"}, {"\uCE10", "\uCE10"},
    {"\uCE11", "\uCE11"}, {"\uCE12", "\uCE12"}, {"\uCE13", "\uCE13"}, {"\uCE14", "\uCE14"}, {"\uCE15", "\uCE15"},
    {"\uCE16", "\uCE16"}, {"\uCE17", "\uCE17"}, {"\uCE18", "\uCE18"}, {"\uCE19", "\uCE19"}, {"\uCE1A", "\uCE1A"},
    {"\uCE1B", "\uCE1B"}, {"\uCE1C", "\uCE1C"}, {"\uCE1D", "\uCE1D"}, {"\uCE1E", "\uCE1E"}, {"\uCE1F", "\uCE1F"},
    {"\uCE20", "\uCE20"}, {"\uCE21", "\uCE21"}, {"\uCE22", "\uCE22"}, {"\uCE23", "\uCE23"}, {"\uCE24", "\uCE24"},
    {"\uCE25", "\uCE25"}, {"\uCE26", "\uCE26"}, {"\uCE27", "\uCE27"}, {"\uCE28", "\uCE28"}, {"\uCE29", "\uCE29"},
    {"\uCE2A", "\uCE2A"}, {"\uCE2B", "\uCE2B"}, {"\uCE2C", "\uCE2C"}, {"\uCE2D", "\uCE2D"}, {"\uCE2E", "\uCE2E"},
    {"\uCE2F", "\uCE2F"}, {"\uCE30", "\uCE30"}, {"\uCE31", "\uCE31"}, {"\uCE32", "\uCE32"}, {"\uCE33", "\uCE33"},
    {"\uCE34", "\uCE34"}, {"\uCE35", "\uCE35"}, {"\uCE36", "\uCE36"}, {"\uCE37", "\uCE37"}, {"\uCE38", "\uCE38"},
    {"\uCE39", "\uCE39"}, {"\uCE3A", "\uCE3A"}, {"\uCE3B", "\uCE3B"}, {"\uCE3C", "\uCE3C"}, {"\uCE3D", "\uCE3D"},
    {"\uCE3E", "\uCE3E"}, {"\uCE3F", "\uCE3F"}, {"\uCE40", "\uCE40"}, {"\uCE41", "\uCE41"}, {"\uCE42", "\uCE42"},
    {"\uCE43", "\uCE43"}, {"\uCE44", "\uCE44"}, {"\uCE45", "\uCE45"}, {"\uCE46", "\uCE46"}, {"\uCE47", "\uCE47"},
    {"\uCE48", "\uCE48"}, {"\uCE49", "\uCE49"}, {"\uCE4A", "\uCE4A"}, {"\uCE4B", "\uCE4B"}, {"\uCE4C", "\uCE4C"},
    {"\uCE4D", "\uCE4D"}, {"\uCE4E", "\uCE4E"}, {"\uCE4F", "\uCE4F"}, {"\uCE50", "\uCE50"}, {"\uCE51", "\uCE51"},
    {"\uCE52", "\uCE52"}, {"\uCE53", "\uCE53"}, {"\uCE54", "\uCE54"}, {"\uCE55", "\uCE55"}, {"\uCE56", "\uCE56"},
    {"\uCE57", "\uCE57"}, {"\uCE58", "\uCE58"}, {"\uCE59", "\uCE59"}, {"\uCE5A", "\uCE5A"}, {"\uCE5B", "\uCE5B"},
    {"\uCE5C", "\uCE5C"}, {"\uCE5D", "\uCE5D"}, {"\uCE5E", "\uCE5E"}, {"\uCE5F", "\uCE5F"}, {"\uCE60", "\uCE60"},
    {"\uCE61", "\uCE61"}, {"\uCE62", "\uCE62"}, {"\uCE63", "\uCE63"}, {"\uCE64", "\uCE64"}, {"\uCE65", "\uCE65"},
    {"\uCE66", "\uCE66"}, {"\uCE67", "\uCE67"}, {"\uCE68", "\uCE68"}, {"\uCE69", "\uCE69"}, {"\uCE6A", "\uCE6A"},
    {"\uCE6B", "\uCE6B"}, {"\uCE6C", "\uCE6C"}, {"\uCE6D", "\uCE6D"}, {"\uCE6E", "\uCE6E"}, {"\uCE6F", "\uCE6F"},
    {"\uCE70", "\uCE70"}, {"\uCE71", "\uCE71"}, {"\uCE72", "\uCE72"}, {"\uCE73", "\uCE73"}, {"\uCE74", "\uCE74"},
    {"\uCE75", "\uCE75"}, {"\uCE76", "\uCE76"}, {"\uCE77", "\uCE77"}, {"\uCE78", "\uCE78"}, {"\uCE79", "\uCE79"},
    {"\uCE7A", "\uCE7A"}, {"\uCE7B", "\uCE7B"}, {"\uCE7C", "\uCE7C"}, {"\uCE7D", "\uCE7D"}, {"\uCE7E", "\uCE7E"},
    {"\uCE7F", "\uCE7F"}, {"\uCE80", "\uCE80"}, {"\uCE81", "\uCE81"}, {"\uCE82", "\uCE82"}, {"\uCE83", "\uCE83"},
    {"\uCE84", "\uCE84"}, {"\uCE85", "\uCE85"}, {"\uCE86", "\uCE86"}, {"\uCE87", "\uCE87"}, {"\uCE88", "\uCE88"},
    {"\uCE89", "\uCE89"}, {"\uCE8A", "\uCE8A"}, {"\uCE8B", "\uCE8B"}, {"\uCE8C", "\uCE8C"}, {"\uCE8D", "\uCE8D"},
    {"\uCE8E", "\uCE8E"}, {"\uCE8F", "\uCE8F"}, {"\uCE90", "\uCE90"}, {"\uCE91", "\uCE91"}, {"\uCE92", "\uCE92"},
    {"\uCE93", "\uCE93"}, {"\uCE94", "\uCE94"}, {"\uCE95", "\uCE95"}, {"\uCE96", "\uCE96"}, {"\uCE97", "\uCE97"},
    {"\uCE98", "\uCE98"}, {"\uCE99", "\uCE99"}, {"\uCE9A", "\uCE9A"}, {"\uCE9B", "\uCE9B"}, {"\uCE9C", "\uCE9C"},
    {"\uCE9D", "\uCE9D"}, {"\uCE9E", "\uCE9E"}, {"\uCE9F", "\uCE9F"}, {"\uCEA0", "\uCEA0"}, {"\uCEA1", "\uCEA1"},
    {"\uCEA2", "\uCEA2"}, {"\uCEA3", "\uCEA3"}, {"\uCEA4", "\uCEA4"}, {"\uCEA5", "\uCEA5"}, {"\uCEA6", "\uCEA6"},
    {"\uCEA7", "\uCEA7"}, {"\uCEA8", "\uCEA8"}, {"\uCEA9", "\uCEA9"}, {"\uCEAA", "\uCEAA"}, {"\uCEAB", "\uCEAB"},
    {"\uCEAC", "\uCEAC"}, {"\uCEAD", "\uCEAD"}, {"\uCEAE", "\uCEAE"}, {"\uCEAF", "\uCEAF"}, {"\uCEB0", "\uCEB0"},
    {"\uCEB1", "\uCEB1"}, {"\uCEB2", "\uCEB2"}, {"\uCEB3", "\uCEB3"}, {"\uCEB4", "\uCEB4"}, {"\uCEB5", "\uCEB5"},
    {"\uCEB6", "\uCEB6"}, {"\uCEB7", "\uCEB7"}, {"\uCEB8", "\uCEB8"}, {"\uCEB9", "\uCEB9"}, {"\uCEBA", "\uCEBA"},
    {"\uCEBB", "\uCEBB"}, {"\uCEBC", "\uCEBC"}, {"\uCEBD", "\uCEBD"}, {"\uCEBE", "\uCEBE"}, {"\uCEBF", "\uCEBF"},
    {"\uCEC0", "\uCEC0"}, {"\uCEC1", "\uCEC1"}, {"\uCEC2", "\uCEC2"}, {"\uCEC3", "\uCEC3"}, {"\uCEC4", "\uCEC4"},
    {"\uCEC5", "\uCEC5"}, {"\uCEC6", "\uCEC6"}, {"\uCEC7", "\uCEC7"}, {"\uCEC8", "\uCEC8"}, {"\uCEC9", "\uCEC9"},
    {"\uCECA", "\uCECA"}, {"\uCECB", "\uCECB"}, {"\uCECC", "\uCECC"}, {"\uCECD", "\uCECD"}, {"\uCECE", "\uCECE"},
    {"\uCECF", "\uCECF"}, {"\uCED0", "\uCED0"}, {"\uCED1", "\uCED1"}, {"\uCED2", "\uCED2"}, {"\uCED3", "\uCED3"},
    {"\uCED4", "\uCED4"}, {"\uCED5", "\uCED5"}, {"\uCED6", "\uCED6"}, {"\uCED7", "\uCED7"}, {"\uCED8", "\uCED8"},
    {"\uCED9", "\uCED9"}, {"\uCEDA", "\uCEDA"}, {"\uCEDB", "\uCEDB"}, {"\uCEDC", "\uCEDC"}, {"\uCEDD", "\uCEDD"},
    {"\uCEDE", "\uCEDE"}, {"\uCEDF", "\uCEDF"}, {"\uCEE0", "\uCEE0"}, {"\uCEE1", "\uCEE1"}, {"\uCEE2", "\uCEE2"},
    {"\uCEE3", "\uCEE3"}, {"\uCEE4", "\uCEE4"}, {"\uCEE5", "\uCEE5"}, {"\uCEE6", "\uCEE6"}, {"\uCEE7", "\uCEE7"},
    {"\uCEE8", "\uCEE8"}, {"\uCEE9", "\uCEE9"}, {"\uCEEA", "\uCEEA"}, {"\uCEEB", "\uCEEB"}, {"\uCEEC", "\uCEEC"},
    {"\uCEED", "\uCEED"}, {"\uCEEE", "\uCEEE"}, {"\uCEEF", "\uCEEF"}, {"\uCEF0", "\uCEF0"}, {"\uCEF1", "\uCEF1"},
    {"\uCEF2", "\uCEF2"}, {"\uCEF3", "\uCEF3"}, {"\uCEF4", "\uCEF4"}, {"\uCEF5", "\uCEF5"}, {"\uCEF6", "\uCEF6"},
    {"\uCEF7", "\uCEF7"}, {"\uCEF8", "\uCEF8"}, {"\uCEF9", "\uCEF9"}, {"\uCEFA", "\uCEFA"}, {"\uCEFB", "\uCEFB"},
    {"\uCEFC", "\uCEFC"}, {"\uCEFD", "\uCEFD"}, {"\uCEFE", "\uCEFE"}, {"\uCEFF", "\uCEFF"}, {"\uCF00", "\uCF00"},
    {"\uCF01", "\uCF01"}, {"\uCF02", "\uCF02"}, {"\uCF03", "\uCF03"}, {"\uCF04", "\uCF04"}, {"\uCF05", "\uCF05"},
    {"\uCF06", "\uCF06"}, {"\uCF07", "\uCF07"}, {"\uCF08", "\uCF08"}, {"\uCF09", "\uCF09"}, {"\uCF0A", "\uCF0A"},
    {"\uCF0B", "\uCF0B"}, {"\uCF0C", "\uCF0C"}, {"\uCF0D", "\uCF0D"}, {"\uCF0E", "\uCF0E"}, {"\uCF0F", "\uCF0F"},
    {"\uCF10", "\uCF10"}, {"\uCF11", "\uCF11"}, {"\uCF12", "\uCF12"}, {"\uCF13", "\uCF13"}, {"\uCF14", "\uCF14"},
    {"\uCF15", "\uCF15"}, {"\uCF16", "\uCF16"}, {"\uCF17", "\uCF17"}, {"\uCF18", "\uCF18"}, {"\uCF19", "\uCF19"},
    {"\uCF1A", "\uCF1A"}, {"\uCF1B", "\uCF1B"}, {"\uCF1C", "\uCF1C"}, {"\uCF1D", "\uCF1D"}, {"\uCF1E", "\uCF1E"},
    {"\uCF1F", "\uCF1F"}, {"\uCF20", "\uCF20"}, {"\uCF21", "\uCF21"}, {"\uCF22", "\uCF22"}, {"\uCF23", "\uCF23"},
    {"\uCF24", "\uCF24"}, {"\uCF25", "\uCF25"}, {"\uCF26", "\uCF26"}, {"\uCF27", "\uCF27"}, {"\uCF28", "\uCF28"},
    {"\uCF29", "\uCF29"}, {"\uCF2A", "\uCF2A"}, {"\uCF2B", "\uCF2B"}, {"\uCF2C", "\uCF2C"}, {"\uCF2D", "\uCF2D"},
    {"\uCF2E", "\uCF2E"}, {"\uCF2F", "\uCF2F"}, {"\uCF30", "\uCF30"}, {"\uCF31", "\uCF31"}, {"\uCF32", "\uCF32"},
    {"\uCF33", "\uCF33"}, {"\uCF34", "\uCF34"}, {"\uCF35", "\uCF35"}, {"\uCF36", "\uCF36"}, {"\uCF37", "\uCF37"},
    {"\uCF38", "\uCF38"}, {"\uCF39", "\uCF39"}, {"\uCF3A", "\uCF3A"}, {"\uCF3B", "\uCF3B"}, {"\uCF3C", "\uCF3C"},
    {"\uCF3D", "\uCF3D"}, {"\uCF3E", "\uCF3E"}, {"\uCF3F", "\uCF3F"}, {"\uCF40", "\uCF40"}, {"\uCF41", "\uCF41"},
    {"\uCF42", "\uCF42"}, {"\uCF43", "\uCF43"}, {"\uCF44", "\uCF44"}, {"\uCF45", "\uCF45"}, {"\uCF46", "\uCF46"},
    {"\uCF47", "\uCF47"}, {"\uCF48", "\uCF48"}, {"\uCF49", "\uCF49"}, {"\uCF4A", "\uCF4A"}, {"\uCF4B", "\uCF4B"},
    {"\uCF4C", "\uCF4C"}, {"\uCF4D", "\uCF4D"}, {"\uCF4E", "\uCF4E"}, {"\uCF4F", "\uCF4F"}, {"\uCF50", "\uCF50"},
    {"\uCF51", "\uCF51"}, {"\uCF52", "\uCF52"}, {"\uCF53", "\uCF53"}, {"\uCF54", "\uCF54"}, {"\uCF55", "\uCF55"},
    {"\uCF56", "\uCF56"}, {"\uCF57", "\uCF57"}, {"\uCF58", "\uCF58"}, {"\uCF59", "\uCF59"}, {"\uCF5A", "\uCF5A"},
    {"\uCF5B", "\uCF5B"}, {"\uCF5C", "\uCF5C"}, {"\uCF5D", "\uCF5D"}, {"\uCF5E", "\uCF5E"}, {"\uCF5F", "\uCF5F"},
    {"\uCF60", "\uCF60"}, {"\uCF61", "\uCF61"}, {"\uCF62", "\uCF62"}, {"\uCF63", "\uCF63"}, {"\uCF64", "\uCF64"},
    {"\uCF65", "\uCF65"}, {"\uCF66", "\uCF66"}, {"\uCF67", "\uCF67"}, {"\uCF68", "\uCF68"}, {"\uCF69", "\uCF69"},
    {"\uCF6A", "\uCF6A"}, {"\uCF6B", "\uCF6B"}, {"\uCF6C", "\uCF6C"}, {"\uCF6D", "\uCF6D"}, {"\uCF6E", "\uCF6E"},
    {"\uCF6F", "\uCF6F"}, {"\uCF70", "\uCF70"}, {"\uCF71", "\uCF71"}, {"\uCF72", "\uCF72"}, {"\uCF73", "\uCF73"},
    {"\uCF74", "\uCF74"}, {"\uCF75", "\uCF75"}, {"\uCF76", "\uCF76"}, {"\uCF77", "\uCF77"}, {"\uCF78", "\uCF78"},
    {"\uCF79", "\uCF79"}, {"\uCF7A", "\uCF7A"}, {"\uCF7B", "\uCF7B"}, {"\uCF7C", "\uCF7C"}, {"\uCF7D", "\uCF7D"},
    {"\uCF7E", "\uCF7E"}, {"\uCF7F", "\uCF7F"}, {"\uCF80", "\uCF80"}, {"\uCF81", "\uCF81"}, {"\uCF82", "\uCF82"},
    {"\uCF83", "\uCF83"}, {"\uCF84", "\uCF84"}, {"\uCF85", "\uCF85"}, {"\uCF86", "\uCF86"}, {"\uCF87", "\uCF87"},
    {"\uCF88", "\uCF88"}, {"\uCF89", "\uCF89"}, {"\uCF8A", "\uCF8A"}, {"\uCF8B", "\uCF8B"}, {"\uCF8C", "\uCF8C"},
    {"\uCF8D", "\uCF8D"}, {"\uCF8E", "\uCF8E"}, {"\uCF8F", "\uCF8F"}, {"\uCF90", "\uCF90"}, {"\uCF91", "\uCF91"},
    {"\uCF92", "\uCF92"}, {"\uCF93", "\uCF93"}, {"\uCF94", "\uCF94"}, {"\uCF95", "\uCF95"}, {"\uCF96", "\uCF96"},
    {"\uCF97", "\uCF97"}, {"\uCF98", "\uCF98"}, {"\uCF99", "\uCF99"}, {"\uCF9A", "\uCF9A"}, {"\uCF9B", "\uCF9B"},
    {"\uCF9C", "\uCF9C"}, {"\uCF9D", "\uCF9D"}, {"\uCF9E", "\uCF9E"}, {"\uCF9F", "\uCF9F"}, {"\uCFA0", "\uCFA0"},
    {"\uCFA1", "\uCFA1"}, {"\uCFA2", "\uCFA2"}, {"\uCFA3", "\uCFA3"}, {"\uCFA4", "\uCFA4"}, {"\uCFA5", "\uCFA5"},
    {"\uCFA6", "\uCFA6"}, {"\uCFA7", "\uCFA7"}, {"\uCFA8", "\uCFA8"}, {"\uCFA9", "\uCFA9"}, {"\uCFAA", "\uCFAA"},
    {"\uCFAB", "\uCFAB"}, {"\uCFAC", "\uCFAC"}, {"\uCFAD", "\uCFAD"}, {"\uCFAE", "\uCFAE"}, {"\uCFAF", "\uCFAF"},
    {"\uCFB0", "\uCFB0"}, {"\uCFB1", "\uCFB1"}, {"\uCFB2", "\uCFB2"}, {"\uCFB3", "\uCFB3"}, {"\uCFB4", "\uCFB4"},
    {"\uCFB5", "\uCFB5"}, {"\uCFB6", "\uCFB6"}, {"\uCFB7", "\uCFB7"}, {"\uCFB8", "\uCFB8"}, {"\uCFB9", "\uCFB9"},
    {"\uCFBA", "\uCFBA"}, {"\uCFBB", "\uCFBB"}, {"\uCFBC", "\uCFBC"}, {"\uCFBD", "\uCFBD"}, {"\uCFBE", "\uCFBE"},
    {"\uCFBF", "\uCFBF"}, {"\uCFC0", "\uCFC0"}, {"\uCFC1", "\uCFC1"}, {"\uCFC2", "\uCFC2"}, {"\uCFC3", "\uCFC3"},
    {"\uCFC4", "\uCFC4"}, {"\uCFC5", "\uCFC5"}, {"\uCFC6", "\uCFC6"}, {"\uCFC7", "\uCFC7"}, {"\uCFC8", "\uCFC8"},
    {"\uCFC9", "\uCFC9"}, {"\uCFCA", "\uCFCA"}, {"\uCFCB", "\uCFCB"}, {"\uCFCC", "\uCFCC"}, {"\uCFCD", "\uCFCD"},
    {"\uCFCE", "\uCFCE"}, {"\uCFCF", "\uCFCF"}, {"\uCFD0", "\uCFD0"}, {"\uCFD1", "\uCFD1"}, {"\uCFD2", "\uCFD2"},
    {"\uCFD3", "\uCFD3"}, {"\uCFD4", "\uCFD4"}, {"\uCFD5", "\uCFD5"}, {"\uCFD6", "\uCFD6"}, {"\uCFD7", "\uCFD7"},
    {"\uCFD8", "\uCFD8"}, {"\uCFD9", "\uCFD9"}, {"\uCFDA", "\uCFDA"}, {"\uCFDB", "\uCFDB"}, {"\uCFDC", "\uCFDC"},
    {"\uCFDD", "\uCFDD"}, {"\uCFDE", "\uCFDE"}, {"\uCFDF", "\uCFDF"}, {"\uCFE0", "\uCFE0"}, {"\uCFE1", "\uCFE1"},
    {"\uCFE2", "\uCFE2"}, {"\uCFE3", "\uCFE3"}, {"\uCFE4", "\uCFE4"}, {"\uCFE5", "\uCFE5"}, {"\uCFE6", "\uCFE6"},
    {"\uCFE7", "\uCFE7"}, {"\uCFE8", "\uCFE8"}, {"\uCFE9", "\uCFE9"}, {"\uCFEA", "\uCFEA"}, {"\uCFEB", "\uCFEB"},
    {"\uCFEC", "\uCFEC"}, {"\uCFED", "\uCFED"}, {"\uCFEE", "\uCFEE"}, {"\uCFEF", "\uCFEF"}, {"\uCFF0", "\uCFF0"},
    {"\uCFF1", "\uCFF1"}, {"\uCFF2", "\uCFF2"}, {"\uCFF3", "\uCFF3"}, {"\uCFF4", "\uCFF4"}, {"\uCFF5", "\uCFF5"},
    {"\uCFF6", "\uCFF6"}, {"\uCFF7", "\uCFF7"}, {"\uCFF8", "\uCFF8"}, {"\uCFF9", "\uCFF9"}, {"\uCFFA", "\uCFFA"},
    {"\uCFFB", "\uCFFB"}, {"\uCFFC", "\uCFFC"}, {"\uCFFD", "\uCFFD"}, {"\uCFFE", "\uCFFE"}, {"\uCFFF", "\uCFFF"},
    {"\uD000", "\uD000"}, {"\uD001", "\uD001"}, {"\uD002", "\uD002"}, {"\uD003", "\uD003"}, {"\uD004", "\uD004"},
    {"\uD005", "\uD005"}, {"\uD006", "\uD006"}, {"\uD007", "\uD007"}, {"\uD008", "\uD008"}, {"\uD009", "\uD009"},
    {"\uD00A", "\uD00A"}, {"\uD00B", "\uD00B"}, {"\uD00C", "\uD00C"}, {"\uD00D", "\uD00D"}, {"\uD00E", "\uD00E"},
    {"\uD00F", "\uD00F"}, {"\uD010", "\uD010"}, {"\uD011", "\uD011"}, {"\uD012", "\uD012"}, {"\uD013", "\uD013"},
    {"\uD014", "\uD014"}, {"\uD015", "\uD015"}, {"\uD016", "\uD016"}, {"\uD017", "\uD017"}, {"\uD018", "\uD018"},
    {"\uD019", "\uD019"}, {"\uD01A", "\uD01A"}, {"\uD01B", "\uD01B"}, {"\uD01C", "\uD01C"}, {"\uD01D", "\uD01D"},
    {"\uD01E", "\uD01E"}, {"\uD01F", "\uD01F"}, {"\uD020", "\uD020"}, {"\uD021", "\uD021"}, {"\uD022", "\uD022"},
    {"\uD023", "\uD023"}, {"\uD024", "\uD024"}, {"\uD025", "\uD025"}, {"\uD026", "\uD026"}, {"\uD027", "\uD027"},
    {"\uD028", "\uD028"}, {"\uD029", "\uD029"}, {"\uD02A", "\uD02A"}, {"\uD02B", "\uD02B"}, {"\uD02C", "\uD02C"},
    {"\uD02D", "\uD02D"}, {"\uD02E", "\uD02E"}, {"\uD02F", "\uD02F"}, {"\uD030", "\uD030"}, {"\uD031", "\uD031"},
    {"\uD032", "\uD032"}, {"\uD033", "\uD033"}, {"\uD034", "\uD034"}, {"\uD035", "\uD035"}, {"\uD036", "\uD036"},
    {"\uD037", "\uD037"}, {"\uD038", "\uD038"}, {"\uD039", "\uD039"}, {"\uD03A", "\uD03A"}, {"\uD03B", "\uD03B"},
    {"\uD03C", "\uD03C"}, {"\uD03D", "\uD03D"}, {"\uD03E", "\uD03E"}, {"\uD03F", "\uD03F"}, {"\uD040", "\uD040"},
    {"\uD041", "\uD041"}, {"\uD042", "\uD042"}, {"\uD043", "\uD043"}, {"\uD044", "\uD044"}, {"\uD045", "\uD045"},
    {"\uD046", "\uD046"}, {"\uD047", "\uD047"}, {"\uD048", "\uD048"}, {"\uD049", "\uD049"}, {"\uD04A", "\uD04A"},
    {"\uD04B", "\uD04B"}, {"\uD04C", "\uD04C"}, {"\uD04D", "\uD04D"}, {"\uD04E", "\uD04E"}, {"\uD04F", "\uD04F"},
    {"\uD050", "\uD050"}, {"\uD051", "\uD051"}, {"\uD052", "\uD052"}, {"\uD053", "\uD053"}, {"\uD054", "\uD054"},
    {"\uD055", "\uD055"}, {"\uD056", "\uD056"}, {"\uD057", "\uD057"}, {"\uD058", "\uD058"}, {"\uD059", "\uD059"},
    {"\uD05A", "\uD05A"}, {"\uD05B", "\uD05B"}, {"\uD05C", "\uD05C"}, {"\uD05D", "\uD05D"}, {"\uD05E", "\uD05E"},
    {"\uD05F", "\uD05F"}, {"\uD060", "\uD060"}, {"\uD061", "\uD061"}, {"\uD062", "\uD062"}, {"\uD063", "\uD063"},
    {"\uD064", "\uD064"}, {"\uD065", "\uD065"}, {"\uD066", "\uD066"}, {"\uD067", "\uD067"}, {"\uD068", "\uD068"},
    {"\uD069", "\uD069"}, {"\uD06A", "\uD06A"}, {"\uD06B", "\uD06B"}, {"\uD06C", "\uD06C"}, {"\uD06D", "\uD06D"},
    {"\uD06E", "\uD06E"}, {"\uD06F", "\uD06F"}, {"\uD070", "\uD070"}, {"\uD071", "\uD071"}, {"\uD072", "\uD072"},
    {"\uD073", "\uD073"}, {"\uD074", "\uD074"}, {"\uD075", "\uD075"}, {"\uD076", "\uD076"}, {"\uD077", "\uD077"},
    {"\uD078", "\uD078"}, {"\uD079", "\uD079"}, {"\uD07A", "\uD07A"}, {"\uD07B", "\uD07B"}, {"\uD07C", "\uD07C"},
    {"\uD07D", "\uD07D"}, {"\uD07E", "\uD07E"}, {"\uD07F", "\uD07F"}, {"\uD080", "\uD080"}, {"\uD081", "\uD081"},
    {"\uD082", "\uD082"}, {"\uD083", "\uD083"}, {"\uD084", "\uD084"}, {"\uD085", "\uD085"}, {"\uD086", "\uD086"},
    {"\uD087", "\uD087"}, {"\uD088", "\uD088"}, {"\uD089", "\uD089"}, {"\uD08A", "\uD08A"}, {"\uD08B", "\uD08B"},
    {"\uD08C", "\uD08C"}, {"\uD08D", "\uD08D"}, {"\uD08E", "\uD08E"}, {"\uD08F", "\uD08F"}, {"\uD090", "\uD090"},
    {"\uD091", "\uD091"}, {"\uD092", "\uD092"}, {"\uD093", "\uD093"}, {"\uD094", "\uD094"}, {"\uD095", "\uD095"},
    {"\uD096", "\uD096"}, {"\uD097", "\uD097"}, {"\uD098", "\uD098"}, {"\uD099", "\uD099"}, {"\uD09A", "\uD09A"},
    {"\uD09B", "\uD09B"}, {"\uD09C", "\uD09C"}, {"\uD09D", "\uD09D"}, {"\uD09E", "\uD09E"}, {"\uD09F", "\uD09F"},
    {"\uD0A0", "\uD0A0"}, {"\uD0A1", "\uD0A1"}, {"\uD0A2", "\uD0A2"}, {"\uD0A3", "\uD0A3"}, {"\uD0A4", "\uD0A4"},
    {"\uD0A5", "\uD0A5"}, {"\uD0A6", "\uD0A6"}, {"\uD0A7", "\uD0A7"}, {"\uD0A8", "\uD0A8"}, {"\uD0A9", "\uD0A9"},
    {"\uD0AA", "\uD0AA"}, {"\uD0AB", "\uD0AB"}, {"\uD0AC", "\uD0AC"}, {"\uD0AD", "\uD0AD"}, {"\uD0AE", "\uD0AE"},
    {"\uD0AF", "\uD0AF"}, {"\uD0B0", "\uD0B0"}, {"\uD0B1", "\uD0B1"}, {"\uD0B2", "\uD0B2"}, {"\uD0B3", "\uD0B3"},
    {"\uD0B4", "\uD0B4"}, {"\uD0B5", "\uD0B5"}, {"\uD0B6", "\uD0B6"}, {"\uD0B7", "\uD0B7"}, {"\uD0B8", "\uD0B8"},
    {"\uD0B9", "\uD0B9"}, {"\uD0BA", "\uD0BA"}, {"\uD0BB", "\uD0BB"}, {"\uD0BC", "\uD0BC"}, {"\uD0BD", "\uD0BD"},
    {"\uD0BE", "\uD0BE"}, {"\uD0BF", "\uD0BF"}, {"\uD0C0", "\uD0C0"}, {"\uD0C1", "\uD0C1"}, {"\uD0C2", "\uD0C2"},
    {"\uD0C3", "\uD0C3"}, {"\uD0C4", "\uD0C4"}, {"\uD0C5", "\uD0C5"}, {"\uD0C6", "\uD0C6"}, {"\uD0C7", "\uD0C7"},
    {"\uD0C8", "\uD0C8"}, {"\uD0C9", "\uD0C9"}, {"\uD0CA", "\uD0CA"}, {"\uD0CB", "\uD0CB"}, {"\uD0CC", "\uD0CC"},
    {"\uD0CD", "\uD0CD"}, {"\uD0CE", "\uD0CE"}, {"\uD0CF", "\uD0CF"}, {"\uD0D0", "\uD0D0"}, {"\uD0D1", "\uD0D1"},
    {"\uD0D2", "\uD0D2"}, {"\uD0D3", "\uD0D3"}, {"\uD0D4", "\uD0D4"}, {"\uD0D5", "\uD0D5"}, {"\uD0D6", "\uD0D6"},
    {"\uD0D7", "\uD0D7"}, {"\uD0D8", "\uD0D8"}, {"\uD0D9", "\uD0D9"}, {"\uD0DA", "\uD0DA"}, {"\uD0DB", "\uD0DB"},
    {"\uD0DC", "\uD0DC"}, {"\uD0DD", "\uD0DD"}, {"\uD0DE", "\uD0DE"}, {"\uD0DF", "\uD0DF"}, {"\uD0E0", "\uD0E0"},
    {"\uD0E1", "\uD0E1"}, {"\uD0E2", "\uD0E2"}, {"\uD0E3", "\uD0E3"}, {"\uD0E4", "\uD0E4"}, {"\uD0E5", "\uD0E5"},
    {"\uD0E6", "\uD0E6"}, {"\uD0E7", "\uD0E7"}, {"\uD0E8", "\uD0E8"}, {"\uD0E9", "\uD0E9"}, {"\uD0EA", "\uD0EA"},
    {"\uD0EB", "\uD0EB"}, {"\uD0EC", "\uD0EC"}, {"\uD0ED", "\uD0ED"}, {"\uD0EE", "\uD0EE"}, {"\uD0EF", "\uD0EF"},
    {"\uD0F0", "\uD0F0"}, {"\uD0F1", "\uD0F1"}, {"\uD0F2", "\uD0F2"}, {"\uD0F3", "\uD0F3"}, {"\uD0F4", "\uD0F4"},
    {"\uD0F5", "\uD0F5"}, {"\uD0F6", "\uD0F6"}, {"\uD0F7", "\uD0F7"}, {"\uD0F8", "\uD0F8"}, {"\uD0F9", "\uD0F9"},
    {"\uD0FA", "\uD0FA"}, {"\uD0FB", "\uD0FB"}, {"\uD0FC", "\uD0FC"}, {"\uD0FD", "\uD0FD"}, {"\uD0FE", "\uD0FE"},
    {"\uD0FF", "\uD0FF"}, {"\uD100", "\uD100"}, {"\uD101", "\uD101"}, {"\uD102", "\uD102"}, {"\uD103", "\uD103"},
    {"\uD104", "\uD104"}, {"\uD105", "\uD105"}, {"\uD106", "\uD106"}, {"\uD107", "\uD107"}, {"\uD108", "\uD108"},
    {"\uD109", "\uD109"}, {"\uD10A", "\uD10A"}, {"\uD10B", "\uD10B"}, {"\uD10C", "\uD10C"}, {"\uD10D", "\uD10D"},
    {"\uD10E", "\uD10E"}, {"\uD10F", "\uD10F"}, {"\uD110", "\uD110"}, {"\uD111", "\uD111"}, {"\uD112", "\uD112"},
    {"\uD113", "\uD113"}, {"\uD114", "\uD114"}, {"\uD115", "\uD115"}, {"\uD116", "\uD116"}, {"\uD117", "\uD117"},
    {"\uD118", "\uD118"}, {"\uD119", "\uD119"}, {"\uD11A", "\uD11A"}, {"\uD11B", "\uD11B"}, {"\uD11C", "\uD11C"},
    {"\uD11D", "\uD11D"}, {"\uD11E", "\uD11E"}, {"\uD11F", "\uD11F"}, {"\uD120", "\uD120"}, {"\uD121", "\uD121"},
    {"\uD122", "\uD122"}, {"\uD123", "\uD123"}, {"\uD124", "\uD124"}, {"\uD125", "\uD125"}, {"\uD126", "\uD126"},
    {"\uD127", "\uD127"}, {"\uD128", "\uD128"}, {"\uD129", "\uD129"}, {"\uD12A", "\uD12A"}, {"\uD12B", "\uD12B"},
    {"\uD12C", "\uD12C"}, {"\uD12D", "\uD12D"}, {"\uD12E", "\uD12E"}, {"\uD12F", "\uD12F"}, {"\uD130", "\uD130"},
    {"\uD131", "\uD131"}, {"\uD132", "\uD132"}, {"\uD133", "\uD133"}, {"\uD134", "\uD134"}, {"\uD135", "\uD135"},
    {"\uD136", "\uD136"}, {"\uD137", "\uD137"}, {"\uD138", "\uD138"}, {"\uD139", "\uD139"}, {"\uD13A", "\uD13A"},
    {"\uD13B", "\uD13B"}, {"\uD13C", "\uD13C"}, {"\uD13D", "\uD13D"}, {"\uD13E", "\uD13E"}, {"\uD13F", "\uD13F"},
    {"\uD140", "\uD140"}, {"\uD141", "\uD141"}, {"\uD142", "\uD142"}, {"\uD143", "\uD143"}, {"\uD144", "\uD144"},
    {"\uD145", "\uD145"}, {"\uD146", "\uD146"}, {"\uD147", "\uD147"}, {"\uD148", "\uD148"}, {"\uD149", "\uD149"},
    {"\uD14A", "\uD14A"}, {"\uD14B", "\uD14B"}, {"\uD14C", "\uD14C"}, {"\uD14D", "\uD14D"}, {"\uD14E", "\uD14E"},
    {"\uD14F", "\uD14F"}, {"\uD150", "\uD150"}, {"\uD151", "\uD151"}, {"\uD152", "\uD152"}, {"\uD153", "\uD153"},
    {"\uD154", "\uD154"}, {"\uD155", "\uD155"}, {"\uD156", "\uD156"}, {"\uD157", "\uD157"}, {"\uD158", "\uD158"},
    {"\uD159", "\uD159"}, {"\uD15A", "\uD15A"}, {"\uD15B", "\uD15B"}, {"\uD15C", "\uD15C"}, {"\uD15D", "\uD15D"},
    {"\uD15E", "\uD15E"}, {"\uD15F", "\uD15F"}, {"\uD160", "\uD160"}, {"\uD161", "\uD161"}, {"\uD162", "\uD162"},
    {"\uD163", "\uD163"}, {"\uD164", "\uD164"}, {"\uD165", "\uD165"}, {"\uD166", "\uD166"}, {"\uD167", "\uD167"},
    {"\uD168", "\uD168"}, {"\uD169", "\uD169"}, {"\uD16A", "\uD16A"}, {"\uD16B", "\uD16B"}, {"\uD16C", "\uD16C"},
    {"\uD16D", "\uD16D"}, {"\uD16E", "\uD16E"}, {"\uD16F", "\uD16F"}, {"\uD170", "\uD170"}, {"\uD171", "\uD171"},
    {"\uD172", "\uD172"}, {"\uD173", "\uD173"}, {"\uD174", "\uD174"}, {"\uD175", "\uD175"}, {"\uD176", "\uD176"},
    {"\uD177", "\uD177"}, {"\uD178", "\uD178"}, {"\uD179", "\uD179"}, {"\uD17A", "\uD17A"}, {"\uD17B", "\uD17B"},
    {"\uD17C", "\uD17C"}, {"\uD17D", "\uD17D"}, {"\uD17E", "\uD17E"}, {"\uD17F", "\uD17F"}, {"\uD180", "\uD180"},
    {"\uD181", "\uD181"}, {"\uD182", "\uD182"}, {"\uD183", "\uD183"}, {"\uD184", "\uD184"}, {"\uD185", "\uD185"},
    {"\uD186", "\uD186"}, {"\uD187", "\uD187"}, {"\uD188", "\uD188"}, {"\uD189", "\uD189"}, {"\uD18A", "\uD18A"},
    {"\uD18B", "\uD18B"}, {"\uD18C", "\uD18C"}, {"\uD18D", "\uD18D"}, {"\uD18E", "\uD18E"}, {"\uD18F", "\uD18F"},
    {"\uD190", "\uD190"}, {"\uD191", "\uD191"}, {"\uD192", "\uD192"}, {"\uD193", "\uD193"}, {"\uD194", "\uD194"},
    {"\uD195", "\uD195"}, {"\uD196", "\uD196"}, {"\uD197", "\uD197"}, {"\uD198", "\uD198"}, {"\uD199", "\uD199"},
    {"\uD19A", "\uD19A"}, {"\uD19B", "\uD19B"}, {"\uD19C", "\uD19C"}, {"\uD19D", "\uD19D"}, {"\uD19E", "\uD19E"},
    {"\uD19F", "\uD19F"}, {"\uD1A0", "\uD1A0"}, {"\uD1A1", "\uD1A1"}, {"\uD1A2", "\uD1A2"}, {"\uD1A3", "\uD1A3"},
    {"\uD1A4", "\uD1A4"}, {"\uD1A5", "\uD1A5"}, {"\uD1A6", "\uD1A6"}, {"\uD1A7", "\uD1A7"}, {"\uD1A8", "\uD1A8"},
    {"\uD1A9", "\uD1A9"}, {"\uD1AA", "\uD1AA"}, {"\uD1AB", "\uD1AB"}, {"\uD1AC", "\uD1AC"}, {"\uD1AD", "\uD1AD"},
    {"\uD1AE", "\uD1AE"}, {"\uD1AF", "\uD1AF"}, {"\uD1B0", "\uD1B0"}, {"\uD1B1", "\uD1B1"}, {"\uD1B2", "\uD1B2"},
    {"\uD1B3", "\uD1B3"}, {"\uD1B4", "\uD1B4"}, {"\uD1B5", "\uD1B5"}, {"\uD1B6", "\uD1B6"}, {"\uD1B7", "\uD1B7"},
    {"\uD1B8", "\uD1B8"}, {"\uD1B9", "\uD1B9"}, {"\uD1BA", "\uD1BA"}, {"\uD1BB", "\uD1BB"}, {"\uD1BC", "\uD1BC"},
    {"\uD1BD", "\uD1BD"}, {"\uD1BE", "\uD1BE"}, {"\uD1BF", "\uD1BF"}, {"\uD1C0", "\uD1C0"}, {"\uD1C1", "\uD1C1"},
    {"\uD1C2", "\uD1C2"}, {"\uD1C3", "\uD1C3"}, {"\uD1C4", "\uD1C4"}, {"\uD1C5", "\uD1C5"}, {"\uD1C6", "\uD1C6"},
    {"\uD1C7", "\uD1C7"}, {"\uD1C8", "\uD1C8"}, {"\uD1C9", "\uD1C9"}, {"\uD1CA", "\uD1CA"}, {"\uD1CB", "\uD1CB"},
    {"\uD1CC", "\uD1CC"}, {"\uD1CD", "\uD1CD"}, {"\uD1CE", "\uD1CE"}, {"\uD1CF", "\uD1CF"}, {"\uD1D0", "\uD1D0"},
    {"\uD1D1", "\uD1D1"}, {"\uD1D2", "\uD1D2"}, {"\uD1D3", "\uD1D3"}, {"\uD1D4", "\uD1D4"}, {"\uD1D5", "\uD1D5"},
    {"\uD1D6", "\uD1D6"}, {"\uD1D7", "\uD1D7"}, {"\uD1D8", "\uD1D8"}, {"\uD1D9", "\uD1D9"}, {"\uD1DA", "\uD1DA"},
    {"\uD1DB", "\uD1DB"}, {"\uD1DC", "\uD1DC"}, {"\uD1DD", "\uD1DD"}, {"\uD1DE", "\uD1DE"}, {"\uD1DF", "\uD1DF"},
    {"\uD1E0", "\uD1E0"}, {"\uD1E1", "\uD1E1"}, {"\uD1E2", "\uD1E2"}, {"\uD1E3", "\uD1E3"}, {"\uD1E4", "\uD1E4"},
    {"\uD1E5", "\uD1E5"}, {"\uD1E6", "\uD1E6"}, {"\uD1E7", "\uD1E7"}, {"\uD1E8", "\uD1E8"}, {"\uD1E9", "\uD1E9"},
    {"\uD1EA", "\uD1EA"}, {"\uD1EB", "\uD1EB"}, {"\uD1EC", "\uD1EC"}, {"\uD1ED", "\uD1ED"}, {"\uD1EE", "\uD1EE"},
    {"\uD1EF", "\uD1EF"}, {"\uD1F0", "\uD1F0"}, {"\uD1F1", "\uD1F1"}, {"\uD1F2", "\uD1F2"}, {"\uD1F3", "\uD1F3"},
    {"\uD1F4", "\uD1F4"}, {"\uD1F5", "\uD1F5"}, {"\uD1F6", "\uD1F6"}, {"\uD1F7", "\uD1F7"}, {"\uD1F8", "\uD1F8"},
    {"\uD1F9", "\uD1F9"}, {"\uD1FA", "\uD1FA"}, {"\uD1FB", "\uD1FB"}, {"\uD1FC", "\uD1FC"}, {"\uD1FD", "\uD1FD"},
    {"\uD1FE", "\uD1FE"}, {"\uD1FF", "\uD1FF"}, {"\uD200", "\uD200"}, {"\uD201", "\uD201"}, {"\uD202", "\uD202"},
    {"\uD203", "\uD203"}, {"\uD204", "\uD204"}, {"\uD205", "\uD205"}, {"\uD206", "\uD206"}, {"\uD207", "\uD207"},
    {"\uD208", "\uD208"}, {"\uD209", "\uD209"}, {"\uD20A", "\uD20A"}, {"\uD20B", "\uD20B"}, {"\uD20C", "\uD20C"},
    {"\uD20D", "\uD20D"}, {"\uD20E", "\uD20E"}, {"\uD20F", "\uD20F"}, {"\uD210", "\uD210"}, {"\uD211", "\uD211"},
    {"\uD212", "\uD212"}, {"\uD213", "\uD213"}, {"\uD214", "\uD214"}, {"\uD215", "\uD215"}, {"\uD216", "\uD216"},
    {"\uD217", "\uD217"}, {"\uD218", "\uD218"}, {"\uD219", "\uD219"}, {"\uD21A", "\uD21A"}, {"\uD21B", "\uD21B"},
    {"\uD21C", "\uD21C"}, {"\uD21D", "\uD21D"}, {"\uD21E", "\uD21E"}, {"\uD21F", "\uD21F"}, {"\uD220", "\uD220"},
    {"\uD221", "\uD221"}, {"\uD222", "\uD222"}, {"\uD223", "\uD223"}, {"\uD224", "\uD224"}, {"\uD225", "\uD225"},
    {"\uD226", "\uD226"}, {"\uD227", "\uD227"}, {"\uD228", "\uD228"}, {"\uD229", "\uD229"}, {"\uD22A", "\uD22A"},
    {"\uD22B", "\uD22B"}, {"\uD22C", "\uD22C"}, {"\uD22D", "\uD22D"}, {"\uD22E", "\uD22E"}, {"\uD22F", "\uD22F"},
    {"\uD230", "\uD230"}, {"\uD231", "\uD231"}, {"\uD232", "\uD232"}, {"\uD233", "\uD233"}, {"\uD234", "\uD234"},
    {"\uD235", "\uD235"}, {"\uD236", "\uD236"}, {"\uD237", "\uD237"}, {"\uD238", "\uD238"}, {"\uD239", "\uD239"},
    {"\uD23A", "\uD23A"}, {"\uD23B", "\uD23B"}, {"\uD23C", "\uD23C"}, {"\uD23D", "\uD23D"}, {"\uD23E", "\uD23E"},
    {"\uD23F", "\uD23F"}, {"\uD240", "\uD240"}, {"\uD241", "\uD241"}, {"\uD242", "\uD242"}, {"\uD243", "\uD243"},
    {"\uD244", "\uD244"}, {"\uD245", "\uD245"}, {"\uD246", "\uD246"}, {"\uD247", "\uD247"}, {"\uD248", "\uD248"},
    {"\uD249", "\uD249"}, {"\uD24A", "\uD24A"}, {"\uD24B", "\uD24B"}, {"\uD24C", "\uD24C"}, {"\uD24D", "\uD24D"},
    {"\uD24E", "\uD24E"}, {"\uD24F", "\uD24F"}, {"\uD250", "\uD250"}, {"\uD251", "\uD251"}, {"\uD252", "\uD252"},
    {"\uD253", "\uD253"}, {"\uD254", "\uD254"}, {"\uD255", "\uD255"}, {"\uD256", "\uD256"}, {"\uD257", "\uD257"},
    {"\uD258", "\uD258"}, {"\uD259", "\uD259"}, {"\uD25A", "\uD25A"}, {"\uD25B", "\uD25B"}, {"\uD25C", "\uD25C"},
    {"\uD25D", "\uD25D"}, {"\uD25E", "\uD25E"}, {"\uD25F", "\uD25F"}, {"\uD260", "\uD260"}, {"\uD261", "\uD261"},
    {"\uD262", "\uD262"}, {"\uD263", "\uD263"}, {"\uD264", "\uD264"}, {"\uD265", "\uD265"}, {"\uD266", "\uD266"},
    {"\uD267", "\uD267"}, {"\uD268", "\uD268"}, {"\uD269", "\uD269"}, {"\uD26A", "\uD26A"}, {"\uD26B", "\uD26B"},
    {"\uD26C", "\uD26C"}, {"\uD26D", "\uD26D"}, {"\uD26E", "\uD26E"}, {"\uD26F", "\uD26F"}, {"\uD270", "\uD270"},
    {"\uD271", "\uD271"}, {"\uD272", "\uD272"}, {"\uD273", "\uD273"}, {"\uD274", "\uD274"}, {"\uD275", "\uD275"},
    {"\uD276", "\uD276"}, {"\uD277", "\uD277"}, {"\uD278", "\uD278"}, {"\uD279", "\uD279"}, {"\uD27A", "\uD27A"},
    {"\uD27B", "\uD27B"}, {"\uD27C", "\uD27C"}, {"\uD27D", "\uD27D"}, {"\uD27E", "\uD27E"}, {"\uD27F", "\uD27F"},
    {"\uD280", "\uD280"}, {"\uD281", "\uD281"}, {"\uD282", "\uD282"}, {"\uD283", "\uD283"}, {"\uD284", "\uD284"},
    {"\uD285", "\uD285"}, {"\uD286", "\uD286"}, {"\uD287", "\uD287"}, {"\uD288", "\uD288"}, {"\uD289", "\uD289"},
    {"\uD28A", "\uD28A"}, {"\uD28B", "\uD28B"}, {"\uD28C", "\uD28C"}, {"\uD28D", "\uD28D"}, {"\uD28E", "\uD28E"},
    {"\uD28F", "\uD28F"}, {"\uD290", "\uD290"}, {"\uD291", "\uD291"}, {"\uD292", "\uD292"}, {"\uD293", "\uD293"},
    {"\uD294", "\uD294"}, {"\uD295", "\uD295"}, {"\uD296", "\uD296"}, {"\uD297", "\uD297"}, {"\uD298", "\uD298"},
    {"\uD299", "\uD299"}, {"\uD29A", "\uD29A"}, {"\uD29B", "\uD29B"}, {"\uD29C", "\uD29C"}, {"\uD29D", "\uD29D"},
    {"\uD29E", "\uD29E"}, {"\uD29F", "\uD29F"}, {"\uD2A0", "\uD2A0"}, {"\uD2A1", "\uD2A1"}, {"\uD2A2", "\uD2A2"},
    {"\uD2A3", "\uD2A3"}, {"\uD2A4", "\uD2A4"}, {"\uD2A5", "\uD2A5"}, {"\uD2A6", "\uD2A6"}, {"\uD2A7", "\uD2A7"},
    {"\uD2A8", "\uD2A8"}, {"\uD2A9", "\uD2A9"}, {"\uD2AA", "\uD2AA"}, {"\uD2AB", "\uD2AB"}, {"\uD2AC", "\uD2AC"},
    {"\uD2AD", "\uD2AD"}, {"\uD2AE", "\uD2AE"}, {"\uD2AF", "\uD2AF"}, {"\uD2B0", "\uD2B0"}, {"\uD2B1", "\uD2B1"},
    {"\uD2B2", "\uD2B2"}, {"\uD2B3", "\uD2B3"}, {"\uD2B4", "\uD2B4"}, {"\uD2B5", "\uD2B5"}, {"\uD2B6", "\uD2B6"},
    {"\uD2B7", "\uD2B7"}, {"\uD2B8", "\uD2B8"}, {"\uD2B9", "\uD2B9"}, {"\uD2BA", "\uD2BA"}, {"\uD2BB", "\uD2BB"},
    {"\uD2BC", "\uD2BC"}, {"\uD2BD", "\uD2BD"}, {"\uD2BE", "\uD2BE"}, {"\uD2BF", "\uD2BF"}, {"\uD2C0", "\uD2C0"},
    {"\uD2C1", "\uD2C1"}, {"\uD2C2", "\uD2C2"}, {"\uD2C3", "\uD2C3"}, {"\uD2C4", "\uD2C4"}, {"\uD2C5", "\uD2C5"},
    {"\uD2C6", "\uD2C6"}, {"\uD2C7", "\uD2C7"}, {"\uD2C8", "\uD2C8"}, {"\uD2C9", "\uD2C9"}, {"\uD2CA", "\uD2CA"},
    {"\uD2CB", "\uD2CB"}, {"\uD2CC", "\uD2CC"}, {"\uD2CD", "\uD2CD"}, {"\uD2CE", "\uD2CE"}, {"\uD2CF", "\uD2CF"},
    {"\uD2D0", "\uD2D0"}, {"\uD2D1", "\uD2D1"}, {"\uD2D2", "\uD2D2"}, {"\uD2D3", "\uD2D3"}, {"\uD2D4", "\uD2D4"},
    {"\uD2D5", "\uD2D5"}, {"\uD2D6", "\uD2D6"}, {"\uD2D7", "\uD2D7"}, {"\uD2D8", "\uD2D8"}, {"\uD2D9", "\uD2D9"},
    {"\uD2DA", "\uD2DA"}, {"\uD2DB", "\uD2DB"}, {"\uD2DC", "\uD2DC"}, {"\uD2DD", "\uD2DD"}, {"\uD2DE", "\uD2DE"},
    {"\uD2DF", "\uD2DF"}, {"\uD2E0", "\uD2E0"}, {"\uD2E1", "\uD2E1"}, {"\uD2E2", "\uD2E2"}, {"\uD2E3", "\uD2E3"},
    {"\uD2E4", "\uD2E4"}, {"\uD2E5", "\uD2E5"}, {"\uD2E6", "\uD2E6"}, {"\uD2E7", "\uD2E7"}, {"\uD2E8", "\uD2E8"},
    {"\uD2E9", "\uD2E9"}, {"\uD2EA", "\uD2EA"}, {"\uD2EB", "\uD2EB"}, {"\uD2EC", "\uD2EC"}, {"\uD2ED", "\uD2ED"},
    {"\uD2EE", "\uD2EE"}, {"\uD2EF", "\uD2EF"}, {"\uD2F0", "\uD2F0"}, {"\uD2F1", "\uD2F1"}, {"\uD2F2", "\uD2F2"},
    {"\uD2F3", "\uD2F3"}, {"\uD2F4", "\uD2F4"}, {"\uD2F5", "\uD2F5"}, {"\uD2F6", "\uD2F6"}, {"\uD2F7", "\uD2F7"},
    {"\uD2F8", "\uD2F8"}, {"\uD2F9", "\uD2F9"}, {"\uD2FA", "\uD2FA"}, {"\uD2FB", "\uD2FB"}, {"\uD2FC", "\uD2FC"},
    {"\uD2FD", "\uD2FD"}, {"\uD2FE", "\uD2FE"}, {"\uD2FF", "\uD2FF"}, {"\uD300", "\uD300"}, {"\uD301", "\uD301"},
    {"\uD302", "\uD302"}, {"\uD303", "\uD303"}, {"\uD304", "\uD304"}, {"\uD305", "\uD305"}, {"\uD306", "\uD306"},
    {"\uD307", "\uD307"}, {"\uD308", "\uD308"}, {"\uD309", "\uD309"}, {"\uD30A", "\uD30A"}, {"\uD30B", "\uD30B"},
    {"\uD30C", "\uD30C"}, {"\uD30D", "\uD30D"}, {"\uD30E", "\uD30E"}, {"\uD30F", "\uD30F"}, {"\uD310", "\uD310"},
    {"\uD311", "\uD311"}, {"\uD312", "\uD312"}, {"\uD313", "\uD313"}, {"\uD314", "\uD314"}, {"\uD315", "\uD315"},
    {"\uD316", "\uD316"}, {"\uD317", "\uD317"}, {"\uD318", "\uD318"}, {"\uD319", "\uD319"}, {"\uD31A", "\uD31A"},
    {"\uD31B", "\uD31B"}, {"\uD31C", "\uD31C"}, {"\uD31D", "\uD31D"}, {"\uD31E", "\uD31E"}, {"\uD31F", "\uD31F"},
    {"\uD320", "\uD320"}, {"\uD321", "\uD321"}, {"\uD322", "\uD322"}, {"\uD323", "\uD323"}, {"\uD324", "\uD324"},
    {"\uD325", "\uD325"}, {"\uD326", "\uD326"}, {"\uD327", "\uD327"}, {"\uD328", "\uD328"}, {"\uD329", "\uD329"},
    {"\uD32A", "\uD32A"}, {"\uD32B", "\uD32B"}, {"\uD32C", "\uD32C"}, {"\uD32D", "\uD32D"}, {"\uD32E", "\uD32E"},
    {"\uD32F", "\uD32F"}, {"\uD330", "\uD330"}, {"\uD331", "\uD331"}, {"\uD332", "\uD332"}, {"\uD333", "\uD333"},
    {"\uD334", "\uD334"}, {"\uD335", "\uD335"}, {"\uD336", "\uD336"}, {"\uD337", "\uD337"}, {"\uD338", "\uD338"},
    {"\uD339", "\uD339"}, {"\uD33A", "\uD33A"}, {"\uD33B", "\uD33B"}, {"\uD33C", "\uD33C"}, {"\uD33D", "\uD33D"},
    {"\uD33E", "\uD33E"}, {"\uD33F", "\uD33F"}, {"\uD340", "\uD340"}, {"\uD341", "\uD341"}, {"\uD342", "\uD342"},
    {"\uD343", "\uD343"}, {"\uD344", "\uD344"}, {"\uD345", "\uD345"}, {"\uD346", "\uD346"}, {"\uD347", "\uD347"},
    {"\uD348", "\uD348"}, {"\uD349", "\uD349"}, {"\uD34A", "\uD34A"}, {"\uD34B", "\uD34B"}, {"\uD34C", "\uD34C"},
    {"\uD34D", "\uD34D"}, {"\uD34E", "\uD34E"}, {"\uD34F", "\uD34F"}, {"\uD350", "\uD350"}, {"\uD351", "\uD351"},
    {"\uD352", "\uD352"}, {"\uD353", "\uD353"}, {"\uD354", "\uD354"}, {"\uD355", "\uD355"}, {"\uD356", "\uD356"},
    {"\uD357", "\uD357"}, {"\uD358", "\uD358"}, {"\uD359", "\uD359"}, {"\uD35A", "\uD35A"}, {"\uD35B", "\uD35B"},
    {"\uD35C", "\uD35C"}, {"\uD35D", "\uD35D"}, {"\uD35E", "\uD35E"}, {"\uD35F", "\uD35F"}, {"\uD360", "\uD360"},
    {"\uD361", "\uD361"}, {"\uD362", "\uD362"}, {"\uD363", "\uD363"}, {"\uD364", "\uD364"}, {"\uD365", "\uD365"},
    {"\uD366", "\uD366"}, {"\uD367", "\uD367"}, {"\uD368", "\uD368"}, {"\uD369", "\uD369"}, {"\uD36A", "\uD36A"},
    {"\uD36B", "\uD36B"}, {"\uD36C", "\uD36C"}, {"\uD36D", "\uD36D"}, {"\uD36E", "\uD36E"}, {"\uD36F", "\uD36F"},
    {"\uD370", "\uD370"}, {"\uD371", "\uD371"}, {"\uD372", "\uD372"}, {"\uD373", "\uD373"}, {"\uD374", "\uD374"},
    {"\uD375", "\uD375"}, {"\uD376", "\uD376"}, {"\uD377", "\uD377"}, {"\uD378", "\uD378"}, {"\uD379", "\uD379"},
    {"\uD37A", "\uD37A"}, {"\uD37B", "\uD37B"}, {"\uD37C", "\uD37C"}, {"\uD37D", "\uD37D"}, {"\uD37E", "\uD37E"},
    {"\uD37F", "\uD37F"}, {"\uD380", "\uD380"}, {"\uD381", "\uD381"}, {"\uD382", "\uD382"}, {"\uD383", "\uD383"},
    {"\uD384", "\uD384"}, {"\uD385", "\uD385"}, {"\uD386", "\uD386"}, {"\uD387", "\uD387"}, {"\uD388", "\uD388"},
    {"\uD389", "\uD389"}, {"\uD38A", "\uD38A"}, {"\uD38B", "\uD38B"}, {"\uD38C", "\uD38C"}, {"\uD38D", "\uD38D"},
    {"\uD38E", "\uD38E"}, {"\uD38F", "\uD38F"}, {"\uD390", "\uD390"}, {"\uD391", "\uD391"}, {"\uD392", "\uD392"},
    {"\uD393", "\uD393"}, {"\uD394", "\uD394"}, {"\uD395", "\uD395"}, {"\uD396", "\uD396"}, {"\uD397", "\uD397"},
    {"\uD398", "\uD398"}, {"\uD399", "\uD399"}, {"\uD39A", "\uD39A"}, {"\uD39B", "\uD39B"}, {"\uD39C", "\uD39C"},
    {"\uD39D", "\uD39D"}, {"\uD39E", "\uD39E"}, {"\uD39F", "\uD39F"}, {"\uD3A0", "\uD3A0"}, {"\uD3A1", "\uD3A1"},
    {"\uD3A2", "\uD3A2"}, {"\uD3A3", "\uD3A3"}, {"\uD3A4", "\uD3A4"}, {"\uD3A5", "\uD3A5"}, {"\uD3A6", "\uD3A6"},
    {"\uD3A7", "\uD3A7"}, {"\uD3A8", "\uD3A8"}, {"\uD3A9", "\uD3A9"}, {"\uD3AA", "\uD3AA"}, {"\uD3AB", "\uD3AB"},
    {"\uD3AC", "\uD3AC"}, {"\uD3AD", "\uD3AD"}, {"\uD3AE", "\uD3AE"}, {"\uD3AF", "\uD3AF"}, {"\uD3B0", "\uD3B0"},
    {"\uD3B1", "\uD3B1"}, {"\uD3B2", "\uD3B2"}, {"\uD3B3", "\uD3B3"}, {"\uD3B4", "\uD3B4"}, {"\uD3B5", "\uD3B5"},
    {"\uD3B6", "\uD3B6"}, {"\uD3B7", "\uD3B7"}, {"\uD3B8", "\uD3B8"}, {"\uD3B9", "\uD3B9"}, {"\uD3BA", "\uD3BA"},
    {"\uD3BB", "\uD3BB"}, {"\uD3BC", "\uD3BC"}, {"\uD3BD", "\uD3BD"}, {"\uD3BE", "\uD3BE"}, {"\uD3BF", "\uD3BF"},
    {"\uD3C0", "\uD3C0"}, {"\uD3C1", "\uD3C1"}, {"\uD3C2", "\uD3C2"}, {"\uD3C3", "\uD3C3"}, {"\uD3C4", "\uD3C4"},
    {"\uD3C5", "\uD3C5"}, {"\uD3C6", "\uD3C6"}, {"\uD3C7", "\uD3C7"}, {"\uD3C8", "\uD3C8"}, {"\uD3C9", "\uD3C9"},
    {"\uD3CA", "\uD3CA"}, {"\uD3CB", "\uD3CB"}, {"\uD3CC", "\uD3CC"}, {"\uD3CD", "\uD3CD"}, {"\uD3CE", "\uD3CE"},
    {"\uD3CF", "\uD3CF"}, {"\uD3D0", "\uD3D0"}, {"\uD3D1", "\uD3D1"}, {"\uD3D2", "\uD3D2"}, {"\uD3D3", "\uD3D3"},
    {"\uD3D4", "\uD3D4"}, {"\uD3D5", "\uD3D5"}, {"\uD3D6", "\uD3D6"}, {"\uD3D7", "\uD3D7"}, {"\uD3D8", "\uD3D8"},
    {"\uD3D9", "\uD3D9"}, {"\uD3DA", "\uD3DA"}, {"\uD3DB", "\uD3DB"}, {"\uD3DC", "\uD3DC"}, {"\uD3DD", "\uD3DD"},
    {"\uD3DE", "\uD3DE"}, {"\uD3DF", "\uD3DF"}, {"\uD3E0", "\uD3E0"}, {"\uD3E1", "\uD3E1"}, {"\uD3E2", "\uD3E2"},
    {"\uD3E3", "\uD3E3"}, {"\uD3E4", "\uD3E4"}, {"\uD3E5", "\uD3E5"}, {"\uD3E6", "\uD3E6"}, {"\uD3E7", "\uD3E7"},
    {"\uD3E8", "\uD3E8"}, {"\uD3E9", "\uD3E9"}, {"\uD3EA", "\uD3EA"}, {"\uD3EB", "\uD3EB"}, {"\uD3EC", "\uD3EC"},
    {"\uD3ED", "\uD3ED"}, {"\uD3EE", "\uD3EE"}, {"\uD3EF", "\uD3EF"}, {"\uD3F0", "\uD3F0"}, {"\uD3F1", "\uD3F1"},
    {"\uD3F2", "\uD3F2"}, {"\uD3F3", "\uD3F3"}, {"\uD3F4", "\uD3F4"}, {"\uD3F5", "\uD3F5"}, {"\uD3F6", "\uD3F6"},
    {"\uD3F7", "\uD3F7"}, {"\uD3F8", "\uD3F8"}, {"\uD3F9", "\uD3F9"}, {"\uD3FA", "\uD3FA"}, {"\uD3FB", "\uD3FB"},
    {"\uD3FC", "\uD3FC"}, {"\uD3FD", "\uD3FD"}, {"\uD3FE", "\uD3FE"}, {"\uD3FF", "\uD3FF"}, {"\uD400", "\uD400"},
    {"\uD401", "\uD401"}, {"\uD402", "\uD402"}, {"\uD403", "\uD403"}, {"\uD404", "\uD404"}, {"\uD405", "\uD405"},
    {"\uD406", "\uD406"}, {"\uD407", "\uD407"}, {"\uD408", "\uD408"}, {"\uD409", "\uD409"}, {"\uD40A", "\uD40A"},
    {"\uD40B", "\uD40B"}, {"\uD40C", "\uD40C"}, {"\uD40D", "\uD40D"}, {"\uD40E", "\uD40E"}, {"\uD40F", "\uD40F"},
    {"\uD410", "\uD410"}, {"\uD411", "\uD411"}, {"\uD412", "\uD412"}, {"\uD413", "\uD413"}, {"\uD414", "\uD414"},
    {"\uD415", "\uD415"}, {"\uD416", "\uD416"}, {"\uD417", "\uD417"}, {"\uD418", "\uD418"}, {"\uD419", "\uD419"},
    {"\uD41A", "\uD41A"}, {"\uD41B", "\uD41B"}, {"\uD41C", "\uD41C"}, {"\uD41D", "\uD41D"}, {"\uD41E", "\uD41E"},
    {"\uD41F", "\uD41F"}, {"\uD420", "\uD420"}, {"\uD421", "\uD421"}, {"\uD422", "\uD422"}, {"\uD423", "\uD423"},
    {"\uD424", "\uD424"}, {"\uD425", "\uD425"}, {"\uD426", "\uD426"}, {"\uD427", "\uD427"}, {"\uD428", "\uD428"},
    {"\uD429", "\uD429"}, {"\uD42A", "\uD42A"}, {"\uD42B", "\uD42B"}, {"\uD42C", "\uD42C"}, {"\uD42D", "\uD42D"},
    {"\uD42E", "\uD42E"}, {"\uD42F", "\uD42F"}, {"\uD430", "\uD430"}, {"\uD431", "\uD431"}, {"\uD432", "\uD432"},
    {"\uD433", "\uD433"}, {"\uD434", "\uD434"}, {"\uD435", "\uD435"}, {"\uD436", "\uD436"}, {"\uD437", "\uD437"},
    {"\uD438", "\uD438"}, {"\uD439", "\uD439"}, {"\uD43A", "\uD43A"}, {"\uD43B", "\uD43B"}, {"\uD43C", "\uD43C"},
    {"\uD43D", "\uD43D"}, {"\uD43E", "\uD43E"}, {"\uD43F", "\uD43F"}, {"\uD440", "\uD440"}, {"\uD441", "\uD441"},
    {"\uD442", "\uD442"}, {"\uD443", "\uD443"}, {"\uD444", "\uD444"}, {"\uD445", "\uD445"}, {"\uD446", "\uD446"},
    {"\uD447", "\uD447"}, {"\uD448", "\uD448"}, {"\uD449", "\uD449"}, {"\uD44A", "\uD44A"}, {"\uD44B", "\uD44B"},
    {"\uD44C", "\uD44C"}, {"\uD44D", "\uD44D"}, {"\uD44E", "\uD44E"}, {"\uD44F", "\uD44F"}, {"\uD450", "\uD450"},
    {"\uD451", "\uD451"}, {"\uD452", "\uD452"}, {"\uD453", "\uD453"}, {"\uD454", "\uD454"}, {"\uD455", "\uD455"},
    {"\uD456", "\uD456"}, {"\uD457", "\uD457"}, {"\uD458", "\uD458"}, {"\uD459", "\uD459"}, {"\uD45A", "\uD45A"},
    {"\uD45B", "\uD45B"}, {"\uD45C", "\uD45C"}, {"\uD45D", "\uD45D"}, {"\uD45E", "\uD45E"}, {"\uD45F", "\uD45F"},
    {"\uD460", "\uD460"}, {"\uD461", "\uD461"}, {"\uD462", "\uD462"}, {"\uD463", "\uD463"}, {"\uD464", "\uD464"},
    {"\uD465", "\uD465"}, {"\uD466", "\uD466"}, {"\uD467", "\uD467"}, {"\uD468", "\uD468"}, {"\uD469", "\uD469"},
    {"\uD46A", "\uD46A"}, {"\uD46B", "\uD46B"}, {"\uD46C", "\uD46C"}, {"\uD46D", "\uD46D"}, {"\uD46E", "\uD46E"},
    {"\uD46F", "\uD46F"}, {"\uD470", "\uD470"}, {"\uD471", "\uD471"}, {"\uD472", "\uD472"}, {"\uD473", "\uD473"},
    {"\uD474", "\uD474"}, {"\uD475", "\uD475"}, {"\uD476", "\uD476"}, {"\uD477", "\uD477"}, {"\uD478", "\uD478"},
    {"\uD479", "\uD479"}, {"\uD47A", "\uD47A"}, {"\uD47B", "\uD47B"}, {"\uD47C", "\uD47C"}, {"\uD47D", "\uD47D"},
    {"\uD47E", "\uD47E"}, {"\uD47F", "\uD47F"}, {"\uD480", "\uD480"}, {"\uD481", "\uD481"}, {"\uD482", "\uD482"},
    {"\uD483", "\uD483"}, {"\uD484", "\uD484"}, {"\uD485", "\uD485"}, {"\uD486", "\uD486"}, {"\uD487", "\uD487"},
    {"\uD488", "\uD488"}, {"\uD489", "\uD489"}, {"\uD48A", "\uD48A"}, {"\uD48B", "\uD48B"}, {"\uD48C", "\uD48C"},
    {"\uD48D", "\uD48D"}, {"\uD48E", "\uD48E"}, {"\uD48F", "\uD48F"}, {"\uD490", "\uD490"}, {"\uD491", "\uD491"},
    {"\uD492", "\uD492"}, {"\uD493", "\uD493"}, {"\uD494", "\uD494"}, {"\uD495", "\uD495"}, {"\uD496", "\uD496"},
    {"\uD497", "\uD497"}, {"\uD498", "\uD498"}, {"\uD499", "\uD499"}, {"\uD49A", "\uD49A"}, {"\uD49B", "\uD49B"},
    {"\uD49C", "\uD49C"}, {"\uD49D", "\uD49D"}, {"\uD49E", "\uD49E"}, {"\uD49F", "\uD49F"}, {"\uD4A0", "\uD4A0"},
    {"\uD4A1", "\uD4A1"}, {"\uD4A2", "\uD4A2"}, {"\uD4A3", "\uD4A3"}, {"\uD4A4", "\uD4A4"}, {"\uD4A5", "\uD4A5"},
    {"\uD4A6", "\uD4A6"}, {"\uD4A7", "\uD4A7"}, {"\uD4A8", "\uD4A8"}, {"\uD4A9", "\uD4A9"}, {"\uD4AA", "\uD4AA"},
    {"\uD4AB", "\uD4AB"}, {"\uD4AC", "\uD4AC"}, {"\uD4AD", "\uD4AD"}, {"\uD4AE", "\uD4AE"}, {"\uD4AF", "\uD4AF"},
    {"\uD4B0", "\uD4B0"}, {"\uD4B1", "\uD4B1"}, {"\uD4B2", "\uD4B2"}, {"\uD4B3", "\uD4B3"}, {"\uD4B4", "\uD4B4"},
    {"\uD4B5", "\uD4B5"}, {"\uD4B6", "\uD4B6"}, {"\uD4B7", "\uD4B7"}, {"\uD4B8", "\uD4B8"}, {"\uD4B9", "\uD4B9"},
    {"\uD4BA", "\uD4BA"}, {"\uD4BB", "\uD4BB"}, {"\uD4BC", "\uD4BC"}, {"\uD4BD", "\uD4BD"}, {"\uD4BE", "\uD4BE"},
    {"\uD4BF", "\uD4BF"}, {"\uD4C0", "\uD4C0"}, {"\uD4C1", "\uD4C1"}, {"\uD4C2", "\uD4C2"}, {"\uD4C3", "\uD4C3"},
    {"\uD4C4", "\uD4C4"}, {"\uD4C5", "\uD4C5"}, {"\uD4C6", "\uD4C6"}, {"\uD4C7", "\uD4C7"}, {"\uD4C8", "\uD4C8"},
    {"\uD4C9", "\uD4C9"}, {"\uD4CA", "\uD4CA"}, {"\uD4CB", "\uD4CB"}, {"\uD4CC", "\uD4CC"}, {"\uD4CD", "\uD4CD"},
    {"\uD4CE", "\uD4CE"}, {"\uD4CF", "\uD4CF"}, {"\uD4D0", "\uD4D0"}, {"\uD4D1", "\uD4D1"}, {"\uD4D2", "\uD4D2"},
    {"\uD4D3", "\uD4D3"}, {"\uD4D4", "\uD4D4"}, {"\uD4D5", "\uD4D5"}, {"\uD4D6", "\uD4D6"}, {"\uD4D7", "\uD4D7"},
    {"\uD4D8", "\uD4D8"}, {"\uD4D9", "\uD4D9"}, {"\uD4DA", "\uD4DA"}, {"\uD4DB", "\uD4DB"}, {"\uD4DC", "\uD4DC"},
    {"\uD4DD", "\uD4DD"}, {"\uD4DE", "\uD4DE"}, {"\uD4DF", "\uD4DF"}, {"\uD4E0", "\uD4E0"}, {"\uD4E1", "\uD4E1"},
    {"\uD4E2", "\uD4E2"}, {"\uD4E3", "\uD4E3"}, {"\uD4E4", "\uD4E4"}, {"\uD4E5", "\uD4E5"}, {"\uD4E6", "\uD4E6"},
    {"\uD4E7", "\uD4E7"}, {"\uD4E8", "\uD4E8"}, {"\uD4E9", "\uD4E9"}, {"\uD4EA", "\uD4EA"}, {"\uD4EB", "\uD4EB"},
    {"\uD4EC", "\uD4EC"}, {"\uD4ED", "\uD4ED"}, {"\uD4EE", "\uD4EE"}, {"\uD4EF", "\uD4EF"}, {"\uD4F0", "\uD4F0"},
    {"\uD4F1", "\uD4F1"}, {"\uD4F2", "\uD4F2"}, {"\uD4F3", "\uD4F3"}, {"\uD4F4", "\uD4F4"}, {"\uD4F5", "\uD4F5"},
    {"\uD4F6", "\uD4F6"}, {"\uD4F7", "\uD4F7"}, {"\uD4F8", "\uD4F8"}, {"\uD4F9", "\uD4F9"}, {"\uD4FA", "\uD4FA"},
    {"\uD4FB", "\uD4FB"}, {"\uD4FC", "\uD4FC"}, {"\uD4FD", "\uD4FD"}, {"\uD4FE", "\uD4FE"}, {"\uD4FF", "\uD4FF"},
    {"\uD500", "\uD500"}, {"\uD501", "\uD501"}, {"\uD502", "\uD502"}, {"\uD503", "\uD503"}, {"\uD504", "\uD504"},
    {"\uD505", "\uD505"}, {"\uD506", "\uD506"}, {"\uD507", "\uD507"}, {"\uD508", "\uD508"}, {"\uD509", "\uD509"},
    {"\uD50A", "\uD50A"}, {"\uD50B", "\uD50B"}, {"\uD50C", "\uD50C"}, {"\uD50D", "\uD50D"}, {"\uD50E", "\uD50E"},
    {"\uD50F", "\uD50F"}, {"\uD510", "\uD510"}, {"\uD511", "\uD511"}, {"\uD512", "\uD512"}, {"\uD513", "\uD513"},
    {"\uD514", "\uD514"}, {"\uD515", "\uD515"}, {"\uD516", "\uD516"}, {"\uD517", "\uD517"}, {"\uD518", "\uD518"},
    {"\uD519", "\uD519"}, {"\uD51A", "\uD51A"}, {"\uD51B", "\uD51B"}, {"\uD51C", "\uD51C"}, {"\uD51D", "\uD51D"},
    {"\uD51E", "\uD51E"}, {"\uD51F", "\uD51F"}, {"\uD520", "\uD520"}, {"\uD521", "\uD521"}, {"\uD522", "\uD522"},
    {"\uD523", "\uD523"}, {"\uD524", "\uD524"}, {"\uD525", "\uD525"}, {"\uD526", "\uD526"}, {"\uD527", "\uD527"},
    {"\uD528", "\uD528"}, {"\uD529", "\uD529"}, {"\uD52A", "\uD52A"}, {"\uD52B", "\uD52B"}, {"\uD52C", "\uD52C"},
    {"\uD52D", "\uD52D"}, {"\uD52E", "\uD52E"}, {"\uD52F", "\uD52F"}, {"\uD530", "\uD530"}, {"\uD531", "\uD531"},
    {"\uD532", "\uD532"}, {"\uD533", "\uD533"}, {"\uD534", "\uD534"}, {"\uD535", "\uD535"}, {"\uD536", "\uD536"},
    {"\uD537", "\uD537"}, {"\uD538", "\uD538"}, {"\uD539", "\uD539"}, {"\uD53A", "\uD53A"}, {"\uD53B", "\uD53B"},
    {"\uD53C", "\uD53C"}, {"\uD53D", "\uD53D"}, {"\uD53E", "\uD53E"}, {"\uD53F", "\uD53F"}, {"\uD540", "\uD540"},
    {"\uD541", "\uD541"}, {"\uD542", "\uD542"}, {"\uD543", "\uD543"}, {"\uD544", "\uD544"}, {"\uD545", "\uD545"},
    {"\uD546", "\uD546"}, {"\uD547", "\uD547"}, {"\uD548", "\uD548"}, {"\uD549", "\uD549"}, {"\uD54A", "\uD54A"},
    {"\uD54B", "\uD54B"}, {"\uD54C", "\uD54C"}, {"\uD54D", "\uD54D"}, {"\uD54E", "\uD54E"}, {"\uD54F", "\uD54F"},
    {"\uD550", "\uD550"}, {"\uD551", "\uD551"}, {"\uD552", "\uD552"}, {"\uD553", "\uD553"}, {"\uD554", "\uD554"},
    {"\uD555", "\uD555"}, {"\uD556", "\uD556"}, {"\uD557", "\uD557"}, {"\uD558", "\uD558"}, {"\uD559", "\uD559"},
    {"\uD55A", "\uD55A"}, {"\uD55B", "\uD55B"}, {"\uD55C", "\uD55C"}, {"\uD55D", "\uD55D"}, {"\uD55E", "\uD55E"},
    {"\uD55F", "\uD55F"}, {"\uD560", "\uD560"}, {"\uD561", "\uD561"}, {"\uD562", "\uD562"}, {"\uD563", "\uD563"},
    {"\uD564", "\uD564"}, {"\uD565", "\uD565"}, {"\uD566", "\uD566"}, {"\uD567", "\uD567"}, {"\uD568", "\uD568"},
    {"\uD569", "\uD569"}, {"\uD56A", "\uD56A"}, {"\uD56B", "\uD56B"}, {"\uD56C", "\uD56C"}, {"\uD56D", "\uD56D"},
    {"\uD56E", "\uD56E"}, {"\uD56F", "\uD56F"}, {"\uD570", "\uD570"}, {"\uD571", "\uD571"}, {"\uD572", "\uD572"},
    {"\uD573", "\uD573"}, {"\uD574", "\uD574"}, {"\uD575", "\uD575"}, {"\uD576", "\uD576"}, {"\uD577", "\uD577"},
    {"\uD578", "\uD578"}, {"\uD579", "\uD579"}, {"\uD57A", "\uD57A"}, {"\uD57B", "\uD57B"}, {"\uD57C", "\uD57C"},
    {"\uD57D", "\uD57D"}, {"\uD57E", "\uD57E"}, {"\uD57F", "\uD57F"}, {"\uD580", "\uD580"}, {"\uD581", "\uD581"},
    {"\uD582", "\uD582"}, {"\uD583", "\uD583"}, {"\uD584", "\uD584"}, {"\uD585", "\uD585"}, {"\uD586", "\uD586"},
    {"\uD587", "\uD587"}, {"\uD588", "\uD588"}, {"\uD589", "\uD589"}, {"\uD58A", "\uD58A"}, {"\uD58B", "\uD58B"},
    {"\uD58C", "\uD58C"}, {"\uD58D", "\uD58D"}, {"\uD58E", "\uD58E"}, {"\uD58F", "\uD58F"}, {"\uD590", "\uD590"},
    {"\uD591", "\uD591"}, {"\uD592", "\uD592"}, {"\uD593", "\uD593"}, {"\uD594", "\uD594"}, {"\uD595", "\uD595"},
    {"\uD596", "\uD596"}, {"\uD597", "\uD597"}, {"\uD598", "\uD598"}, {"\uD599", "\uD599"}, {"\uD59A", "\uD59A"},
    {"\uD59B", "\uD59B"}, {"\uD59C", "\uD59C"}, {"\uD59D", "\uD59D"}, {"\uD59E", "\uD59E"}, {"\uD59F", "\uD59F"},
    {"\uD5A0", "\uD5A0"}, {"\uD5A1", "\uD5A1"}, {"\uD5A2", "\uD5A2"}, {"\uD5A3", "\uD5A3"}, {"\uD5A4", "\uD5A4"},
    {"\uD5A5", "\uD5A5"}, {"\uD5A6", "\uD5A6"}, {"\uD5A7", "\uD5A7"}, {"\uD5A8", "\uD5A8"}, {"\uD5A9", "\uD5A9"},
    {"\uD5AA", "\uD5AA"}, {"\uD5AB", "\uD5AB"}, {"\uD5AC", "\uD5AC"}, {"\uD5AD", "\uD5AD"}, {"\uD5AE", "\uD5AE"},
    {"\uD5AF", "\uD5AF"}, {"\uD5B0", "\uD5B0"}, {"\uD5B1", "\uD5B1"}, {"\uD5B2", "\uD5B2"}, {"\uD5B3", "\uD5B3"},
    {"\uD5B4", "\uD5B4"}, {"\uD5B5", "\uD5B5"}, {"\uD5B6", "\uD5B6"}, {"\uD5B7", "\uD5B7"}, {"\uD5B8", "\uD5B8"},
    {"\uD5B9", "\uD5B9"}, {"\uD5BA", "\uD5BA"}, {"\uD5BB", "\uD5BB"}, {"\uD5BC", "\uD5BC"}, {"\uD5BD", "\uD5BD"},
    {"\uD5BE", "\uD5BE"}, {"\uD5BF", "\uD5BF"}, {"\uD5C0", "\uD5C0"}, {"\uD5C1", "\uD5C1"}, {"\uD5C2", "\uD5C2"},
    {"\uD5C3", "\uD5C3"}, {"\uD5C4", "\uD5C4"}, {"\uD5C5", "\uD5C5"}, {"\uD5C6", "\uD5C6"}, {"\uD5C7", "\uD5C7"},
    {"\uD5C8", "\uD5C8"}, {"\uD5C9", "\uD5C9"}, {"\uD5CA", "\uD5CA"}, {"\uD5CB", "\uD5CB"}, {"\uD5CC", "\uD5CC"},
    {"\uD5CD", "\uD5CD"}, {"\uD5CE", "\uD5CE"}, {"\uD5CF", "\uD5CF"}, {"\uD5D0", "\uD5D0"}, {"\uD5D1", "\uD5D1"},
    {"\uD5D2", "\uD5D2"}, {"\uD5D3", "\uD5D3"}, {"\uD5D4", "\uD5D4"}, {"\uD5D5", "\uD5D5"}, {"\uD5D6", "\uD5D6"},
    {"\uD5D7", "\uD5D7"}, {"\uD5D8", "\uD5D8"}, {"\uD5D9", "\uD5D9"}, {"\uD5DA", "\uD5DA"}, {"\uD5DB", "\uD5DB"},
    {"\uD5DC", "\uD5DC"}, {"\uD5DD", "\uD5DD"}, {"\uD5DE", "\uD5DE"}, {"\uD5DF", "\uD5DF"}, {"\uD5E0", "\uD5E0"},
    {"\uD5E1", "\uD5E1"}, {"\uD5E2", "\uD5E2"}, {"\uD5E3", "\uD5E3"}, {"\uD5E4", "\uD5E4"}, {"\uD5E5", "\uD5E5"},
    {"\uD5E6", "\uD5E6"}, {"\uD5E7", "\uD5E7"}, {"\uD5E8", "\uD5E8"}, {"\uD5E9", "\uD5E9"}, {"\uD5EA", "\uD5EA"},
    {"\uD5EB", "\uD5EB"}, {"\uD5EC", "\uD5EC"}, {"\uD5ED", "\uD5ED"}, {"\uD5EE", "\uD5EE"}, {"\uD5EF", "\uD5EF"},
    {"\uD5F0", "\uD5F0"}, {"\uD5F1", "\uD5F1"}, {"\uD5F2", "\uD5F2"}, {"\uD5F3", "\uD5F3"}, {"\uD5F4", "\uD5F4"},
    {"\uD5F5", "\uD5F5"}, {"\uD5F6", "\uD5F6"}, {"\uD5F7", "\uD5F7"}, {"\uD5F8", "\uD5F8"}, {"\uD5F9", "\uD5F9"},
    {"\uD5FA", "\uD5FA"}, {"\uD5FB", "\uD5FB"}, {"\uD5FC", "\uD5FC"}, {"\uD5FD", "\uD5FD"}, {"\uD5FE", "\uD5FE"},
    {"\uD5FF", "\uD5FF"}, {"\uD600", "\uD600"}, {"\uD601", "\uD601"}, {"\uD602", "\uD602"}, {"\uD603", "\uD603"},
    {"\uD604", "\uD604"}, {"\uD605", "\uD605"}, {"\uD606", "\uD606"}, {"\uD607", "\uD607"}, {"\uD608", "\uD608"},
    {"\uD609", "\uD609"}, {"\uD60A", "\uD60A"}, {"\uD60B", "\uD60B"}, {"\uD60C", "\uD60C"}, {"\uD60D", "\uD60D"},
    {"\uD60E", "\uD60E"}, {"\uD60F", "\uD60F"}, {"\uD610", "\uD610"}, {"\uD611", "\uD611"}, {"\uD612", "\uD612"},
    {"\uD613", "\uD613"}, {"\uD614", "\uD614"}, {"\uD615", "\uD615"}, {"\uD616", "\uD616"}, {"\uD617", "\uD617"},
    {"\uD618", "\uD618"}, {"\uD619", "\uD619"}, {"\uD61A", "\uD61A"}, {"\uD61B", "\uD61B"}, {"\uD61C", "\uD61C"},
    {"\uD61D", "\uD61D"}, {"\uD61E", "\uD61E"}, {"\uD61F", "\uD61F"}, {"\uD620", "\uD620"}, {"\uD621", "\uD621"},
    {"\uD622", "\uD622"}, {"\uD623", "\uD623"}, {"\uD624", "\uD624"}, {"\uD625", "\uD625"}, {"\uD626", "\uD626"},
    {"\uD627", "\uD627"}, {"\uD628", "\uD628"}, {"\uD629", "\uD629"}, {"\uD62A", "\uD62A"}, {"\uD62B", "\uD62B"},
    {"\uD62C", "\uD62C"}, {"\uD62D", "\uD62D"}, {"\uD62E", "\uD62E"}, {"\uD62F", "\uD62F"}, {"\uD630", "\uD630"},
    {"\uD631", "\uD631"}, {"\uD632", "\uD632"}, {"\uD633", "\uD633"}, {"\uD634", "\uD634"}, {"\uD635", "\uD635"},
    {"\uD636", "\uD636"}, {"\uD637", "\uD637"}, {"\uD638", "\uD638"}, {"\uD639", "\uD639"}, {"\uD63A", "\uD63A"},
    {"\uD63B", "\uD63B"}, {"\uD63C", "\uD63C"}, {"\uD63D", "\uD63D"}, {"\uD63E", "\uD63E"}, {"\uD63F", "\uD63F"},
    {"\uD640", "\uD640"}, {"\uD641", "\uD641"}, {"\uD642", "\uD642"}, {"\uD643", "\uD643"}, {"\uD644", "\uD644"},
    {"\uD645", "\uD645"}, {"\uD646", "\uD646"}, {"\uD647", "\uD647"}, {"\uD648", "\uD648"}, {"\uD649", "\uD649"},
    {"\uD64A", "\uD64A"}, {"\uD64B", "\uD64B"}, {"\uD64C", "\uD64C"}, {"\uD64D", "\uD64D"}, {"\uD64E", "\uD64E"},
    {"\uD64F", "\uD64F"}, {"\uD650", "\uD650"}, {"\uD651", "\uD651"}, {"\uD652", "\uD652"}, {"\uD653", "\uD653"},
    {"\uD654", "\uD654"}, {"\uD655", "\uD655"}, {"\uD656", "\uD656"}, {"\uD657", "\uD657"}, {"\uD658", "\uD658"},
    {"\uD659", "\uD659"}, {"\uD65A", "\uD65A"}, {"\uD65B", "\uD65B"}, {"\uD65C", "\uD65C"}, {"\uD65D", "\uD65D"},
    {"\uD65E", "\uD65E"}, {"\uD65F", "\uD65F"}, {"\uD660", "\uD660"}, {"\uD661", "\uD661"}, {"\uD662", "\uD662"},
    {"\uD663", "\uD663"}, {"\uD664", "\uD664"}, {"\uD665", "\uD665"}, {"\uD666", "\uD666"}, {"\uD667", "\uD667"},
    {"\uD668", "\uD668"}, {"\uD669", "\uD669"}, {"\uD66A", "\uD66A"}, {"\uD66B", "\uD66B"}, {"\uD66C", "\uD66C"},
    {"\uD66D", "\uD66D"}, {"\uD66E", "\uD66E"}, {"\uD66F", "\uD66F"}, {"\uD670", "\uD670"}, {"\uD671", "\uD671"},
    {"\uD672", "\uD672"}, {"\uD673", "\uD673"}, {"\uD674", "\uD674"}, {"\uD675", "\uD675"}, {"\uD676", "\uD676"},
    {"\uD677", "\uD677"}, {"\uD678", "\uD678"}, {"\uD679", "\uD679"}, {"\uD67A", "\uD67A"}, {"\uD67B", "\uD67B"},
    {"\uD67C", "\uD67C"}, {"\uD67D", "\uD67D"}, {"\uD67E", "\uD67E"}, {"\uD67F", "\uD67F"}, {"\uD680", "\uD680"},
    {"\uD681", "\uD681"}, {"\uD682", "\uD682"}, {"\uD683", "\uD683"}, {"\uD684", "\uD684"}, {"\uD685", "\uD685"},
    {"\uD686", "\uD686"}, {"\uD687", "\uD687"}, {"\uD688", "\uD688"}, {"\uD689", "\uD689"}, {"\uD68A", "\uD68A"},
    {"\uD68B", "\uD68B"}, {"\uD68C", "\uD68C"}, {"\uD68D", "\uD68D"}, {"\uD68E", "\uD68E"}, {"\uD68F", "\uD68F"},
    {"\uD690", "\uD690"}, {"\uD691", "\uD691"}, {"\uD692", "\uD692"}, {"\uD693", "\uD693"}, {"\uD694", "\uD694"},
    {"\uD695", "\uD695"}, {"\uD696", "\uD696"}, {"\uD697", "\uD697"}, {"\uD698", "\uD698"}, {"\uD699", "\uD699"},
    {"\uD69A", "\uD69A"}, {"\uD69B", "\uD69B"}, {"\uD69C", "\uD69C"}, {"\uD69D", "\uD69D"}, {"\uD69E", "\uD69E"},
    {"\uD69F", "\uD69F"}, {"\uD6A0", "\uD6A0"}, {"\uD6A1", "\uD6A1"}, {"\uD6A2", "\uD6A2"}, {"\uD6A3", "\uD6A3"},
    {"\uD6A4", "\uD6A4"}, {"\uD6A5", "\uD6A5"}, {"\uD6A6", "\uD6A6"}, {"\uD6A7", "\uD6A7"}, {"\uD6A8", "\uD6A8"},
    {"\uD6A9", "\uD6A9"}, {"\uD6AA", "\uD6AA"}, {"\uD6AB", "\uD6AB"}, {"\uD6AC", "\uD6AC"}, {"\uD6AD", "\uD6AD"},
    {"\uD6AE", "\uD6AE"}, {"\uD6AF", "\uD6AF"}, {"\uD6B0", "\uD6B0"}, {"\uD6B1", "\uD6B1"}, {"\uD6B2", "\uD6B2"},
    {"\uD6B3", "\uD6B3"}, {"\uD6B4", "\uD6B4"}, {"\uD6B5", "\uD6B5"}, {"\uD6B6", "\uD6B6"}, {"\uD6B7", "\uD6B7"},
    {"\uD6B8", "\uD6B8"}, {"\uD6B9", "\uD6B9"}, {"\uD6BA", "\uD6BA"}, {"\uD6BB", "\uD6BB"}, {"\uD6BC", "\uD6BC"},
    {"\uD6BD", "\uD6BD"}, {"\uD6BE", "\uD6BE"}, {"\uD6BF", "\uD6BF"}, {"\uD6C0", "\uD6C0"}, {"\uD6C1", "\uD6C1"},
    {"\uD6C2", "\uD6C2"}, {"\uD6C3", "\uD6C3"}, {"\uD6C4", "\uD6C4"}, {"\uD6C5", "\uD6C5"}, {"\uD6C6", "\uD6C6"},
    {"\uD6C7", "\uD6C7"}, {"\uD6C8", "\uD6C8"}, {"\uD6C9", "\uD6C9"}, {"\uD6CA", "\uD6CA"}, {"\uD6CB", "\uD6CB"},
    {"\uD6CC", "\uD6CC"}, {"\uD6CD", "\uD6CD"}, {"\uD6CE", "\uD6CE"}, {"\uD6CF", "\uD6CF"}, {"\uD6D0", "\uD6D0"},
    {"\uD6D1", "\uD6D1"}, {"\uD6D2", "\uD6D2"}, {"\uD6D3", "\uD6D3"}, {"\uD6D4", "\uD6D4"}, {"\uD6D5", "\uD6D5"},
    {"\uD6D6", "\uD6D6"}, {"\uD6D7", "\uD6D7"}, {"\uD6D8", "\uD6D8"}, {"\uD6D9", "\uD6D9"}, {"\uD6DA", "\uD6DA"},
    {"\uD6DB", "\uD6DB"}, {"\uD6DC", "\uD6DC"}, {"\uD6DD", "\uD6DD"}, {"\uD6DE", "\uD6DE"}, {"\uD6DF", "\uD6DF"},
    {"\uD6E0", "\uD6E0"}, {"\uD6E1", "\uD6E1"}, {"\uD6E2", "\uD6E2"}, {"\uD6E3", "\uD6E3"}, {"\uD6E4", "\uD6E4"},
    {"\uD6E5", "\uD6E5"}, {"\uD6E6", "\uD6E6"}, {"\uD6E7", "\uD6E7"}, {"\uD6E8", "\uD6E8"}, {"\uD6E9", "\uD6E9"},
    {"\uD6EA", "\uD6EA"}, {"\uD6EB", "\uD6EB"}, {"\uD6EC", "\uD6EC"}, {"\uD6ED", "\uD6ED"}, {"\uD6EE", "\uD6EE"},
    {"\uD6EF", "\uD6EF"}, {"\uD6F0", "\uD6F0"}, {"\uD6F1", "\uD6F1"}, {"\uD6F2", "\uD6F2"}, {"\uD6F3", "\uD6F3"},
    {"\uD6F4", "\uD6F4"}, {"\uD6F5", "\uD6F5"}, {"\uD6F6", "\uD6F6"}, {"\uD6F7", "\uD6F7"}, {"\uD6F8", "\uD6F8"},
    {"\uD6F9", "\uD6F9"}, {"\uD6FA", "\uD6FA"}, {"\uD6FB", "\uD6FB"}, {"\uD6FC", "\uD6FC"}, {"\uD6FD", "\uD6FD"},
    {"\uD6FE", "\uD6FE"}, {"\uD6FF", "\uD6FF"}, {"\uD700", "\uD700"}, {"\uD701", "\uD701"}, {"\uD702", "\uD702"},
    {"\uD703", "\uD703"}, {"\uD704", "\uD704"}, {"\uD705", "\uD705"}, {"\uD706", "\uD706"}, {"\uD707", "\uD707"},
    {"\uD708", "\uD708"}, {"\uD709", "\uD709"}, {"\uD70A", "\uD70A"}, {"\uD70B", "\uD70B"}, {"\uD70C", "\uD70C"},
    {"\uD70D", "\uD70D"}, {"\uD70E", "\uD70E"}, {"\uD70F", "\uD70F"}, {"\uD710", "\uD710"}, {"\uD711", "\uD711"},
    {"\uD712", "\uD712"}, {"\uD713", "\uD713"}, {"\uD714", "\uD714"}, {"\uD715", "\uD715"}, {"\uD716", "\uD716"},
    {"\uD717", "\uD717"}, {"\uD718", "\uD718"}, {"\uD719", "\uD719"}, {"\uD71A", "\uD71A"}, {"\uD71B", "\uD71B"},
    {"\uD71C", "\uD71C"}, {"\uD71D", "\uD71D"}, {"\uD71E", "\uD71E"}, {"\uD71F", "\uD71F"}, {"\uD720", "\uD720"},
    {"\uD721", "\uD721"}, {"\uD722", "\uD722"}, {"\uD723", "\uD723"}, {"\uD724", "\uD724"}, {"\uD725", "\uD725"},
    {"\uD726", "\uD726"}, {"\uD727", "\uD727"}, {"\uD728", "\uD728"}, {"\uD729", "\uD729"}, {"\uD72A", "\uD72A"},
    {"\uD72B", "\uD72B"}, {"\uD72C", "\uD72C"}, {"\uD72D", "\uD72D"}, {"\uD72E", "\uD72E"}, {"\uD72F", "\uD72F"},
    {"\uD730", "\uD730"}, {"\uD731", "\uD731"}, {"\uD732", "\uD732"}, {"\uD733", "\uD733"}, {"\uD734", "\uD734"},
    {"\uD735", "\uD735"}, {"\uD736", "\uD736"}, {"\uD737", "\uD737"}, {"\uD738", "\uD738"}, {"\uD739", "\uD739"},
    {"\uD73A", "\uD73A"}, {"\uD73B", "\uD73B"}, {"\uD73C", "\uD73C"}, {"\uD73D", "\uD73D"}, {"\uD73E", "\uD73E"},
    {"\uD73F", "\uD73F"}, {"\uD740", "\uD740"}, {"\uD741", "\uD741"}, {"\uD742", "\uD742"}, {"\uD743", "\uD743"},
    {"\uD744", "\uD744"}, {"\uD745", "\uD745"}, {"\uD746", "\uD746"}, {"\uD747", "\uD747"}, {"\uD748", "\uD748"},
    {"\uD749", "\uD749"}, {"\uD74A", "\uD74A"}, {"\uD74B", "\uD74B"}, {"\uD74C", "\uD74C"}, {"\uD74D", "\uD74D"},
    {"\uD74E", "\uD74E"}, {"\uD74F", "\uD74F"}, {"\uD750", "\uD750"}, {"\uD751", "\uD751"}, {"\uD752", "\uD752"},
    {"\uD753", "\uD753"}, {"\uD754", "\uD754"}, {"\uD755", "\uD755"}, {"\uD756", "\uD756"}, {"\uD757", "\uD757"},
    {"\uD758", "\uD758"}, {"\uD759", "\uD759"}, {"\uD75A", "\uD75A"}, {"\uD75B", "\uD75B"}, {"\uD75C", "\uD75C"},
    {"\uD75D", "\uD75D"}, {"\uD75E", "\uD75E"}, {"\uD75F", "\uD75F"}, {"\uD760", "\uD760"}, {"\uD761", "\uD761"},
    {"\uD762", "\uD762"}, {"\uD763", "\uD763"}, {"\uD764", "\uD764"}, {"\uD765", "\uD765"}, {"\uD766", "\uD766"},
    {"\uD767", "\uD767"}, {"\uD768", "\uD768"}, {"\uD769", "\uD769"}, {"\uD76A", "\uD76A"}, {"\uD76B", "\uD76B"},
    {"\uD76C", "\uD76C"}, {"\uD76D", "\uD76D"}, {"\uD76E", "\uD76E"}, {"\uD76F", "\uD76F"}, {"\uD770", "\uD770"},
    {"\uD771", "\uD771"}, {"\uD772", "\uD772"}, {"\uD773", "\uD773"}, {"\uD774", "\uD774"}, {"\uD775", "\uD775"},
    {"\uD776", "\uD776"}, {"\uD777", "\uD777"}, {"\uD778", "\uD778"}, {"\uD779", "\uD779"}, {"\uD77A", "\uD77A"},
    {"\uD77B", "\uD77B"}, {"\uD77C", "\uD77C"}, {"\uD77D", "\uD77D"}, {"\uD77E", "\uD77E"}, {"\uD77F", "\uD77F"},
    {"\uD780", "\uD780"}, {"\uD781", "\uD781"}, {"\uD782", "\uD782"}, {"\uD783", "\uD783"}, {"\uD784", "\uD784"},
    {"\uD785", "\uD785"}, {"\uD786", "\uD786"}, {"\uD787", "\uD787"}, {"\uD788", "\uD788"}, {"\uD789", "\uD789"},
    {"\uD78A", "\uD78A"}, {"\uD78B", "\uD78B"}, {"\uD78C", "\uD78C"}, {"\uD78D", "\uD78D"}, {"\uD78E", "\uD78E"},
    {"\uD78F", "\uD78F"}, {"\uD790", "\uD790"}, {"\uD791", "\uD791"}, {"\uD792", "\uD792"}, {"\uD793", "\uD793"},
    {"\uD794", "\uD794"}, {"\uD795", "\uD795"}, {"\uD796", "\uD796"}, {"\uD797", "\uD797"}, {"\uD798", "\uD798"},
    {"\uD799", "\uD799"}, {"\uD79A", "\uD79A"}, {"\uD79B", "\uD79B"}, {"\uD79C", "\uD79C"}, {"\uD79D", "\uD79D"},
    {"\uD79E", "\uD79E"}, {"\uD79F", "\uD79F"}, {"\uD7A0", "\uD7A0"}, {"\uD7A1", "\uD7A1"}, {"\uD7A2", "\uD7A2"},
    {"\uD7A3", "\uD7A3"}, {"\uF900", "\u8C48"}, {"\uF901", "\u66F4"}, {"\uF902", "\u8ECA"}, {"\uF903", "\u8CC8"},
    {"\uF904", "\u6ED1"}, {"\uF905", "\u4E32"}, {"\uF906", "\u53E5"}, {"\uF907", "\u9F9C"}, {"\uF908", "\u9F9C"},
    {"\uF909", "\u5951"}, {"\uF90A", "\u91D1"}, {"\uF90B", "\u5587"}, {"\uF90C", "\u5948"}, {"\uF90D", "\u61F6"},
    {"\uF90E", "\u7669"}, {"\uF90F", "\u7F85"}, {"\uF910", "\u863F"}, {"\uF911", "\u87BA"}, {"\uF912", "\u88F8"},
    {"\uF913", "\u908F"}, {"\uF914", "\u6A02"}, {"\uF915", "\u6D1B"}, {"\uF916", "\u70D9"}, {"\uF917", "\u73DE"},
    {"\uF918", "\u843D"}, {"\uF919", "\u916A"}, {"\uF91A", "\u99F1"}, {"\uF91B", "\u4E82"}, {"\uF91C", "\u5375"},
    {"\uF91D", "\u6B04"}, {"\uF91E", "\u721B"}, {"\uF91F", "\u862D"}, {"\uF920", "\u9E1E"}, {"\uF921", "\u5D50"},
    {"\uF922", "\u6FEB"}, {"\uF923", "\u85CD"}, {"\uF924", "\u8964"}, {"\uF925", "\u62C9"}, {"\uF926", "\u81D8"},
    {"\uF927", "\u881F"}, {"\uF928", "\u5ECA"}, {"\uF929", "\u6717"}, {"\uF92A", "\u6D6A"}, {"\uF92B", "\u72FC"},
    {"\uF92C", "\u90CE"}, {"\uF92D", "\u4F86"}, {"\uF92E", "\u51B7"}, {"\uF92F", "\u52DE"}, {"\uF930", "\u64C4"},
    {"\uF931", "\u6AD3"}, {"\uF932", "\u7210"}, {"\uF933", "\u76E7"}, {"\uF934", "\u8001"}, {"\uF935", "\u8606"},
    {"\uF936", "\u865C"}, {"\uF937", "\u8DEF"}, {"\uF938", "\u9732"}, {"\uF939", "\u9B6F"}, {"\uF93A", "\u9DFA"},
    {"\uF93B", "\u788C"}, {"\uF93C", "\u797F"}, {"\uF93D", "\u7DA0"}, {"\uF93E", "\u83C9"}, {"\uF93F", "\u9304"},
    {"\uF940", "\u9E7F"}, {"\uF941", "\u8AD6"}, {"\uF942", "\u58DF"}, {"\uF943", "\u5F04"}, {"\uF944", "\u7C60"},
    {"\uF945", "\u807E"}, {"\uF946", "\u7262"}, {"\uF947", "\u78CA"}, {"\uF948", "\u8CC2"}, {"\uF949", "\u96F7"},
    {"\uF94A", "\u58D8"}, {"\uF94B", "\u5C62"}, {"\uF94C", "\u6A13"}, {"\uF94D", "\u6DDA"}, {"\uF94E", "\u6F0F"},
    {"\uF94F", "\u7D2F"}, {"\uF950", "\u7E37"}, {"\uF951", "\u964B"}, {"\uF952", "\u52D2"}, {"\uF953", "\u808B"},
    {"\uF954", "\u51DC"}, {"\uF955", "\u51CC"}, {"\uF956", "\u7A1C"}, {"\uF957", "\u7DBE"}, {"\uF958", "\u83F1"},
    {"\uF959", "\u9675"}, {"\uF95A", "\u8B80"}, {"\uF95B", "\u62CF"}, {"\uF95C", "\u6A02"}, {"\uF95D", "\u8AFE"},
    {"\uF95E", "\u4E39"}, {"\uF95F", "\u5BE7"}, {"\uF960", "\u6012"}, {"\uF961", "\u7387"}, {"\uF962", "\u7570"},
    {"\uF963", "\u5317"}, {"\uF964", "\u78FB"}, {"\uF965", "\u4FBF"}, {"\uF966", "\u5FA9"}, {"\uF967", "\u4E0D"},
    {"\uF968", "\u6CCC"}, {"\uF969", "\u6578"}, {"\uF96A", "\u7D22"}, {"\uF96B", "\u53C3"}, {"\uF96C", "\u585E"},
    {"\uF96D", "\u7701"}, {"\uF96E", "\u8449"}, {"\uF96F", "\u8AAA"}, {"\uF970", "\u6BBA"}, {"\uF971", "\u8FB0"},
    {"\uF972", "\u6C88"}, {"\uF973", "\u62FE"}, {"\uF974", "\u82E5"}, {"\uF975", "\u63A0"}, {"\uF976", "\u7565"},
    {"\uF977", "\u4EAE"}, {"\uF978", "\u5169"}, {"\uF979", "\u51C9"}, {"\uF97A", "\u6881"}, {"\uF97B", "\u7CE7"},
    {"\uF97C", "\u826F"}, {"\uF97D", "\u8AD2"}, {"\uF97E", "\u91CF"}, {"\uF97F", "\u52F5"}, {"\uF980", "\u5442"},
    {"\uF981", "\u5973"}, {"\uF982", "\u5EEC"}, {"\uF983", "\u65C5"}, {"\uF984", "\u6FFE"}, {"\uF985", "\u792A"},
    {"\uF986", "\u95AD"}, {"\uF987", "\u9A6A"}, {"\uF988", "\u9E97"}, {"\uF989", "\u9ECE"}, {"\uF98A", "\u529B"},
    {"\uF98B", "\u66C6"}, {"\uF98C", "\u6B77"}, {"\uF98D", "\u8F62"}, {"\uF98E", "\u5E74"}, {"\uF98F", "\u6190"},
    {"\uF990", "\u6200"}, {"\uF991", "\u649A"}, {"\uF992", "\u6F23"}, {"\uF993", "\u7149"}, {"\uF994", "\u7489"},
    {"\uF995", "\u79CA"}, {"\uF996", "\u7DF4"}, {"\uF997", "\u806F"}, {"\uF998", "\u8F26"}, {"\uF999", "\u84EE"},
    {"\uF99A", "\u9023"}, {"\uF99B", "\u934A"}, {"\uF99C", "\u5217"}, {"\uF99D", "\u52A3"}, {"\uF99E", "\u54BD"},
    {"\uF99F", "\u70C8"}, {"\uF9A0", "\u88C2"}, {"\uF9A1", "\u8AAA"}, {"\uF9A2", "\u5EC9"}, {"\uF9A3", "\u5FF5"},
    {"\uF9A4", "\u637B"}, {"\uF9A5", "\u6BAE"}, {"\uF9A6", "\u7C3E"}, {"\uF9A7", "\u7375"}, {"\uF9A8", "\u4EE4"},
    {"\uF9A9", "\u56F9"}, {"\uF9AA", "\u5BE7"}, {"\uF9AB", "\u5DBA"}, {"\uF9AC", "\u601C"}, {"\uF9AD", "\u73B2"},
    {"\uF9AE", "\u7469"}, {"\uF9AF", "\u7F9A"}, {"\uF9B0", "\u8046"}, {"\uF9B1", "\u9234"}, {"\uF9B2", "\u96F6"},
    {"\uF9B3", "\u9748"}, {"\uF9B4", "\u9818"}, {"\uF9B5", "\u4F8B"}, {"\uF9B6", "\u79AE"}, {"\uF9B7", "\u91B4"},
    {"\uF9B8", "\u96B8"}, {"\uF9B9", "\u60E1"}, {"\uF9BA", "\u4E86"}, {"\uF9BB", "\u50DA"}, {"\uF9BC", "\u5BEE"},
    {"\uF9BD", "\u5C3F"}, {"\uF9BE", "\u6599"}, {"\uF9BF", "\u6A02"}, {"\uF9C0", "\u71CE"}, {"\uF9C1", "\u7642"},
    {"\uF9C2", "\u84FC"}, {"\uF9C3", "\u907C"}, {"\uF9C4", "\u9F8D"}, {"\uF9C5", "\u6688"}, {"\uF9C6", "\u962E"},
    {"\uF9C7", "\u5289"}, {"\uF9C8", "\u677B"}, {"\uF9C9", "\u67F3"}, {"\uF9CA", "\u6D41"}, {"\uF9CB", "\u6E9C"},
    {"\uF9CC", "\u7409"}, {"\uF9CD", "\u7559"}, {"\uF9CE", "\u786B"}, {"\uF9CF", "\u7D10"}, {"\uF9D0", "\u985E"},
    {"\uF9D1", "\u516D"}, {"\uF9D2", "\u622E"}, {"\uF9D3", "\u9678"}, {"\uF9D4", "\u502B"}, {"\uF9D5", "\u5D19"},
    {"\uF9D6", "\u6DEA"}, {"\uF9D7", "\u8F2A"}, {"\uF9D8", "\u5F8B"}, {"\uF9D9", "\u6144"}, {"\uF9DA", "\u6817"},
    {"\uF9DB", "\u7387"}, {"\uF9DC", "\u9686"}, {"\uF9DD", "\u5229"}, {"\uF9DE", "\u540F"}, {"\uF9DF", "\u5C65"},
    {"\uF9E0", "\u6613"}, {"\uF9E1", "\u674E"}, {"\uF9E2", "\u68A8"}, {"\uF9E3", "\u6CE5"}, {"\uF9E4", "\u7406"},
    {"\uF9E5", "\u75E2"}, {"\uF9E6", "\u7F79"}, {"\uF9E7", "\u88CF"}, {"\uF9E8", "\u88E1"}, {"\uF9E9", "\u91CC"},
    {"\uF9EA", "\u96E2"}, {"\uF9EB", "\u533F"}, {"\uF9EC", "\u6EBA"}, {"\uF9ED", "\u541D"}, {"\uF9EE", "\u71D0"},
    {"\uF9EF", "\u7498"}, {"\uF9F0", "\u85FA"}, {"\uF9F1", "\u96A3"}, {"\uF9F2", "\u9C57"}, {"\uF9F3", "\u9E9F"},
    {"\uF9F4", "\u6797"}, {"\uF9F5", "\u6DCB"}, {"\uF9F6", "\u81E8"}, {"\uF9F7", "\u7ACB"}, {"\uF9F8", "\u7B20"},
    {"\uF9F9", "\u7C92"}, {"\uF9FA", "\u72C0"}, {"\uF9FB", "\u7099"}, {"\uF9FC", "\u8B58"}, {"\uF9FD", "\u4EC0"},
    {"\uF9FE", "\u8336"}, {"\uF9FF", "\u523A"}, {"\uFA00", "\u5207"}, {"\uFA01", "\u5EA6"}, {"\uFA02", "\u62D3"},
    {"\uFA03", "\u7CD6"}, {"\uFA04", "\u5B85"}, {"\uFA05", "\u6D1E"}, {"\uFA06", "\u66B4"}, {"\uFA07", "\u8F3B"},
    {"\uFA08", "\u884C"}, {"\uFA09", "\u964D"}, {"\uFA0A", "\u898B"}, {"\uFA0B", "\u5ED3"}, {"\uFA0C", "\u5140"},
    {"\uFA0D", "\u55C0"}, {"\uFA10", "\u585A"}, {"\uFA12", "\u6674"}, {"\uFA15", "\u51DE"}, {"\uFA16", "\u732A"},
    {"\uFA17", "\u76CA"}, {"\uFA18", "\u793C"}, {"\uFA19", "\u795E"}, {"\uFA1A", "\u7965"}, {"\uFA1B", "\u798F"},
    {"\uFA1C", "\u9756"}, {"\uFA1D", "\u7CBE"}, {"\uFA1E", "\u7FBD"}, {"\uFA20", "\u8612"}, {"\uFA22", "\u8AF8"},
    {"\uFA25", "\u9038"}, {"\uFA26", "\u90FD"}, {"\uFA2A", "\u98EF"}, {"\uFA2B", "\u98FC"}, {"\uFA2C", "\u9928"},
    {"\uFA2D", "\u9DB4"}, {"\uFA2E", "\u90DE"}, {"\uFA2F", "\u96B7"}, {"\uFA30", "\u4FAE"}, {"\uFA31", "\u50E7"},
    {"\uFA32", "\u514D"}, {"\uFA33", "\u52C9"}, {"\uFA34", "\u52E4"}, {"\uFA35", "\u5351"}, {"\uFA36", "\u559D"},
    {"\uFA37", "\u5606"}, {"\uFA38", "\u5668"}, {"\uFA39", "\u5840"}, {"\uFA3A", "\u58A8"}, {"\uFA3B", "\u5C64"},
    {"\uFA3C", "\u5C6E"}, {"\uFA3D", "\u6094"}, {"\uFA3E", "\u6168"}, {"\uFA3F", "\u618E"}, {"\uFA40", "\u61F2"},
    {"\uFA41", "\u654F"}, {"\uFA42", "\u65E2"}, {"\uFA43", "\u6691"}, {"\uFA44", "\u6885"}, {"\uFA45", "\u6D77"},
    {"\uFA46", "\u6E1A"}, {"\uFA47", "\u6F22"}, {"\uFA48", "\u716E"}, {"\uFA49", "\u722B"}, {"\uFA4A", "\u7422"},
    {"\uFA4B", "\u7891"}, {"\uFA4C", "\u793E"}, {"\uFA4D", "\u7949"}, {"\uFA4E", "\u7948"}, {"\uFA4F", "\u7950"},
    {"\uFA50", "\u7956"}, {"\uFA51", "\u795D"}, {"\uFA52", "\u798D"}, {"\uFA53", "\u798E"}, {"\uFA54", "\u7A40"},
    {"\uFA55", "\u7A81"}, {"\uFA56", "\u7BC0"}, {"\uFA57", "\u7DF4"}, {"\uFA58", "\u7E09"}, {"\uFA59", "\u7E41"},
    {"\uFA5A", "\u7F72"}, {"\uFA5B", "\u8005"}, {"\uFA5C", "\u81ED"}, {"\uFA5D", "\u8279"}, {"\uFA5E", "\u8279"},
    {"\uFA5F", "\u8457"}, {"\uFA60", "\u8910"}, {"\uFA61", "\u8996"}, {"\uFA62", "\u8B01"}, {"\uFA63", "\u8B39"},
    {"\uFA64", "\u8CD3"}, {"\uFA65", "\u8D08"}, {"\uFA66", "\u8FB6"}, {"\uFA67", "\u9038"}, {"\uFA68", "\u96E3"},
    {"\uFA69", "\u97FF"}, {"\uFA6A", "\u983B"}, {"\uFA6B", "\u6075"}, {"\uFA6C", "\U000242EE"}, {"\uFA6D", "\u8218"},
    {"\uFA70", "\u4E26"}, {"\uFA71", "\u51B5"}, {"\uFA72", "\u5168"}, {"\uFA73", "\u4F80"}, {"\uFA74", "\u5145"},
    {"\uFA75", "\u5180"}, {"\uFA76", "\u52C7"}, {"\uFA77", "\u52FA"}, {"\uFA78", "\u559D"}, {"\uFA79", "\u5555"},
    {"\uFA7A", "\u5599"}, {"\uFA7B", "\u55E2"}, {"\uFA7C", "\u585A"}, {"\uFA7D", "\u58B3"}, {"\uFA7E", "\u5944"},
    {"\uFA7F", "\u5954"}, {"\uFA80", "\u5A62"}, {"\uFA81", "\u5B28"}, {"\uFA82", "\u5ED2"}, {"\uFA83", "\u5ED9"},
    {"\uFA84", "\u5F69"}, {"\uFA85", "\u5FAD"}, {"\uFA86", "\u60D8"}, {"\uFA87", "\u614E"}, {"\uFA88", "\u6108"},
    {"\uFA89", "\u618E"}, {"\uFA8A", "\u6160"}, {"\uFA8B", "\u61F2"}, {"\uFA8C", "\u6234"}, {"\uFA8D", "\u63C4"},
    {"\uFA8E", "\u641C"}, {"\uFA8F", "\u6452"}, {"\uFA90", "\u6556"}, {"\uFA91", "\u6674"}, {"\uFA92", "\u6717"},
    {"\uFA93", "\u671B"}, {"\uFA94", "\u6756"}, {"\uFA95", "\u6B79"}, {"\uFA96", "\u6BBA"}, {"\uFA97", "\u6D41"},
    {"\uFA98", "\u6EDB"}, {"\uFA99", "\u6ECB"}, {"\uFA9A", "\u6F22"}, {"\uFA9B", "\u701E"}, {"\uFA9C", "\u716E"},
    {"\uFA9D", "\u77A7"}, {"\uFA9E", "\u7235"}, {"\uFA9F", "\u72AF"}, {"\uFAA0", "\u732A"}, {"\uFAA1", "\u7471"},
    {"\uFAA2", "\u7506"}, {"\uFAA3", "\u753B"}, {"\uFAA4", "\u761D"}, {"\uFAA5", "\u761F"}, {"\uFAA6", "\u76CA"},
    {"\uFAA7", "\u76DB"}, {"\uFAA8", "\u76F4"}, {"\uFAA9", "\u774A"}, {"\uFAAA", "\u7740"}, {"\uFAAB", "\u78CC"},
    {"\uFAAC", "\u7AB1"}, {"\uFAAD", "\u7BC0"}, {"\uFAAE", "\u7C7B"}, {"\uFAAF", "\u7D5B"}, {"\uFAB0", "\u7DF4"},
    {"\uFAB1", "\u7F3E"}, {"\uFAB2", "\u8005"}, {"\uFAB3", "\u8352"}, {"\uFAB4", "\u83EF"}, {"\uFAB5", "\u8779"},
    {"\uFAB6", "\u8941"}, {"\uFAB7", "\u8986"}, {"\uFAB8", "\u8996"}, {"\uFAB9", "\u8ABF"}, {"\uFABA", "\u8AF8"},
    {"\uFABB", "\u8ACB"}, {"\uFABC", "\u8B01"}, {"\uFABD", "\u8AFE"}, {"\uFABE", "\u8AED"}, {"\uFABF", "\u8B39"},
    {"\uFAC0", "\u8B8A"}, {"\uFAC1", "\u8D08"}, {"\uFAC2", "\u8F38"}, {"\uFAC3", "\u9072"}, {"\uFAC4", "\u9199"},
    {"\uFAC5", "\u9276"}, {"\uFAC6", "\u967C"}, {"\uFAC7", "\u96E3"}, {"\uFAC8", "\u9756"}, {"\uFAC9", "\u97DB"},
    {"\uFACA", "\u97FF"}, {"\uFACB", "\u980B"}, {"\uFACC", "\u983B"}, {"\uFACD", "\u9B12"}, {"\uFACE", "\u9F9C"},
    {"\uFACF", "\U0002284A"}, {"\uFAD0", "\U00022844"}, {"\uFAD1", "\U000233D5"}, {"\uFAD2", "\u3B9D"},
    {"\uFAD3", "\u4018"}, {"\uFAD4", "\u4039"}, {"\uFAD5", "\U00025249"}, {"\uFAD6", "\U00025CD0"},
    {"\uFAD7", "\U00027ED3"}, {"\uFAD8", "\u9F43"}, {"\uFAD9", "\u9F8E"}, {"\uFB00", "\uFB00"}, {"\uFB01", "\uFB01"},
    {"\uFB02", "\uFB02"}, {"\uFB03", "\uFB03"}, {"\uFB04", "\uFB04"}, {"\uFB05", "\uFB05"}, {"\uFB06", "\uFB06"},
    {"\uFB13", "\uFB13"}, {"\uFB14", "\uFB14"}, {"\uFB15", "\uFB15"}, {"\uFB16", "\uFB16"}, {"\uFB17", "\uFB17"},
    {"\uFB1D", "\u05D9\u05B4"}, {"\uFB1F", "\u05F2\u05B7"}, {"\uFB20", "\uFB20"}, {"\uFB21", "\uFB21"},
    {"\uFB22", "\uFB22"}, {"\uFB23", "\uFB23"}, {"\uFB24", "\uFB24"}, {"\uFB25", "\uFB25"}, {"\uFB26", "\uFB26"},
    {"\uFB27", "\uFB27"}, {"\uFB28", "\uFB28"}, {"\uFB29", "\uFB29"}, {"\uFB2A", "\u05E9\u05C1"},
    {"\uFB2B", "\u05E9\u05C2"}, {"\uFB2C", "\u05E9\u05BC\u05C1"}, {"\uFB2D", "\u05E9\u05BC\u05C2"},
    {"\uFB2E", "\u05D0\u05B7"}, {"\uFB2F", "\u05D0\u05B8"}, {"\uFB30", "\u05D0\u05BC"}, {"\uFB31", "\u05D1\u05BC"},
    {"\uFB32", "\u05D2\u05BC"}, {"\uFB33", "\u05D3\u05BC"}, {"\uFB34", "\u05D4\u05BC"}, {"\uFB35", "\u05D5\u05BC"},
    {"\uFB36", "\u05D6\u05BC"}, {"\uFB38", "\u05D8\u05BC"}, {"\uFB39", "\u05D9\u05BC"}, {"\uFB3A", "\u05DA\u05BC"},
    {"\uFB3B", "\u05DB\u05BC"}, {"\uFB3C", "\u05DC\u05BC"}, {"\uFB3E", "\u05DE\u05BC"}, {"\uFB40", "\u05E0\u05BC"},
    {"\uFB41", "\u05E1\u05BC"}, {"\uFB43", "\u05E3\u05BC"}, {"\uFB44", "\u05E4\u05BC"}, {"\uFB46", "\u05E6\u05BC"},
    {"\uFB47", "\u05E7\u05BC"}, {"\uFB48", "\u05E8\u05BC"}, {"\uFB49", "\u05E9\u05BC"}, {"\uFB4A", "\u05EA\u05BC"},
    {"\uFB4B", "\u05D5\u05B9"}, {"\uFB4C", "\u05D1\u05BF"}, {"\uFB4D", "\u05DB\u05BF"}, {"\uFB4E", "\u05E4\u05BF"},
    {"\uFB4F", "\uFB4F"}, {"\uFB50", "\uFB50"}, {"\uFB51", "\uFB51"}, {"\uFB52", "\uFB52"}, {"\uFB53", "\uFB53"},
    {"\uFB54", "\uFB54"}, {"\uFB55", "\uFB55"}, {"\uFB56", "\uFB56"}, {"\uFB57", "\uFB57"}, {"\uFB58", "\uFB58"},
    {"\uFB59", "\uFB59"}, {"\uFB5A", "\uFB5A"}, {"\uFB5B", "\uFB5B"}, {"\uFB5C", "\uFB5C"}, {"\uFB5D", "\uFB5D"},
    {"\uFB5E", "\uFB5E"}, {"\uFB5F", "\uFB5F"}, {"\uFB60", "\uFB60"}, {"\uFB61", "\uFB61"}, {"\uFB62", "\uFB62"},
    {"\uFB63", "\uFB63"}, {"\uFB64", "\uFB64"}, {"\uFB65", "\uFB65"}, {"\uFB66", "\uFB66"}, {"\uFB67", "\uFB67"},
    {"\uFB68", "\uFB68"}, {"\uFB69", "\uFB69"}, {"\uFB6A", "\uFB6A"}, {"\uFB6B", "\uFB6B"}, {"\uFB6C", "\uFB6C"},
    {"\uFB6D", "\uFB6D"}, {"\uFB6E", "\uFB6E"}, {"\uFB6F", "\uFB6F"}, {"\uFB70", "\uFB70"}, {"\uFB71", "\uFB71"},
    {"\uFB72", "\uFB72"}, {"\uFB73", "\uFB73"}, {"\uFB74", "\uFB74"}, {"\uFB75", "\uFB75"}, {"\uFB76", "\uFB76"},
    {"\uFB77", "\uFB77"}, {"\uFB78", "\uFB78"}, {"\uFB79", "\uFB79"}, {"\uFB7A", "\uFB7A"}, {"\uFB7B", "\uFB7B"},
    {"\uFB7C", "\uFB7C"}, {"\uFB7D", "\uFB7D"}, {"\uFB7E", "\uFB7E"}, {"\uFB7F", "\uFB7F"}, {"\uFB80", "\uFB80"},
    {"\uFB81", "\uFB81"}, {"\uFB82", "\uFB82"}, {"\uFB83", "\uFB83"}, {"\uFB84", "\uFB84"}, {"\uFB85", "\uFB85"},
    {"\uFB86", "\uFB86"}, {"\uFB87", "\uFB87"}, {"\uFB88", "\uFB88"}, {"\uFB89", "\uFB89"}, {"\uFB8A", "\uFB8A"},
    {"\uFB8B", "\uFB8B"}, {"\uFB8C", "\uFB8C"}, {"\uFB8D", "\uFB8D"}, {"\uFB8E", "\uFB8E"}, {"\uFB8F", "\uFB8F"},
    {"\uFB90", "\uFB90"}, {"\uFB91", "\uFB91"}, {"\uFB92", "\uFB92"}, {"\uFB93", "\uFB93"}, {"\uFB94", "\uFB94"},
    {"\uFB95", "\uFB95"}, {"\uFB96", "\uFB96"}, {"\uFB97", "\uFB97"}, {"\uFB98", "\uFB98"}, {"\uFB99", "\uFB99"},
    {"\uFB9A", "\uFB9A"}, {"\uFB9B", "\uFB9B"}, {"\uFB9C", "\uFB9C"}, {"\uFB9D", "\uFB9D"}, {"\uFB9E", "\uFB9E"},
    {"\uFB9F", "\uFB9F"}, {"\uFBA0", "\uFBA0"}, {"\uFBA1", "\uFBA1"}, {"\uFBA2", "\uFBA2"}, {"\uFBA3", "\uFBA3"},
    {"\uFBA4", "\uFBA4"}, {"\uFBA5", "\uFBA5"}, {"\uFBA6", "\uFBA6"}, {"\uFBA7", "\uFBA7"}, {"\uFBA8", "\uFBA8"},
    {"\uFBA9", "\uFBA9"}, {"\uFBAA", "\uFBAA"}, {"\uFBAB", "\uFBAB"}, {"\uFBAC", "\uFBAC"}, {"\uFBAD", "\uFBAD"},
    {"\uFBAE", "\uFBAE"}, {"\uFBAF", "\uFBAF"}, {"\uFBB0", "\uFBB0"}, {"\uFBB1", "\uFBB1"}, {"\uFBD3", "\uFBD3"},
    {"\uFBD4", "\uFBD4"}, {"\uFBD5", "\uFBD5"}, {"\uFBD6", "\uFBD6"}, {"\uFBD7", "\uFBD7"}, {"\uFBD8", "\uFBD8"},
    {"\uFBD9", "\uFBD9"}, {"\uFBDA", "\uFBDA"}, {"\uFBDB", "\uFBDB"}, {"\uFBDC", "\uFBDC"}, {"\uFBDD", "\uFBDD"},
    {"\uFBDE", "\uFBDE"}, {"\uFBDF", "\uFBDF"}, {"\uFBE0", "\uFBE0"}, {"\uFBE1", "\uFBE1"}, {"\uFBE2", "\uFBE2"},
    {"\uFBE3", "\uFBE3"}, {"\uFBE4", "\uFBE4"}, {"\uFBE5", "\uFBE5"}, {"\uFBE6", "\uFBE6"}, {"\uFBE7", "\uFBE7"},
    {"\uFBE8", "\uFBE8"}, {"\uFBE9", "\uFBE9"}, {"\uFBEA", "\uFBEA"}, {"\uFBEB", "\uFBEB"}, {"\uFBEC", "\uFBEC"},
    {"\uFBED", "\uFBED"}, {"\uFBEE", "\uFBEE"}, {"\uFBEF", "\uFBEF"}, {"\uFBF0", "\uFBF0"}, {"\uFBF1", "\uFBF1"},
    {"\uFBF2", "\uFBF2"}, {"\uFBF3", "\uFBF3"}, {"\uFBF4", "\uFBF4"}, {"\uFBF5", "\uFBF5"}, {"\uFBF6", "\uFBF6"},
    {"\uFBF7", "\uFBF7"}, {"\uFBF8", "\uFBF8"}, {"\uFBF9", "\uFBF9"}, {"\uFBFA", "\uFBFA"}, {"\uFBFB", "\uFBFB"},
    {"\uFBFC", "\uFBFC"}, {"\uFBFD", "\uFBFD"}, {"\uFBFE", "\uFBFE"}, {"\uFBFF", "\uFBFF"}, {"\uFC00", "\uFC00"},
    {"\uFC01", "\uFC01"}, {"\uFC02", "\uFC02"}, {"\uFC03", "\uFC03"}, {"\uFC04", "\uFC04"}, {"\uFC05", "\uFC05"},
    {"\uFC06", "\uFC06"}, {"\uFC07", "\uFC07"}, {"\uFC08", "\uFC08"}, {"\uFC09", "\uFC09"}, {"\uFC0A", "\uFC0A"},
    {"\uFC0B", "\uFC0B"}, {"\uFC0C", "\uFC0C"}, {"\uFC0D", "\uFC0D"}, {"\uFC0E", "\uFC0E"}, {"\uFC0F", "\uFC0F"},
    {"\uFC10", "\uFC10"}, {"\uFC11", "\uFC11"}, {"\uFC12", "\uFC12"}, {"\uFC13", "\uFC13"}, {"\uFC14", "\uFC14"},
    {"\uFC15", "\uFC15"}, {"\uFC16", "\uFC16"}, {"\uFC17", "\uFC17"}, {"\uFC18", "\uFC18"}, {"\uFC19", "\uFC19"},
    {"\uFC1A", "\uFC1A"}, {"\uFC1B", "\uFC1B"}, {"\uFC1C", "\uFC1C"}, {"\uFC1D", "\uFC1D"}, {"\uFC1E", "\uFC1E"},
    {"\uFC1F", "\uFC1F"}, {"\uFC20", "\uFC20"}, {"\uFC21", "\uFC21"}, {"\uFC22", "\uFC22"}, {"\uFC23", "\uFC23"},
    {"\uFC24", "\uFC24"}, {"\uFC25", "\uFC25"}, {"\uFC26", "\uFC26"}, {"\uFC27", "\uFC27"}, {"\uFC28", "\uFC28"},
    {"\uFC29", "\uFC29"}, {"\uFC2A", "\uFC2A"}, {"\uFC2B", "\uFC2B"}, {"\uFC2C", "\uFC2C"}, {"\uFC2D", "\uFC2D"},
    {"\uFC2E", "\uFC2E"}, {"\uFC2F", "\uFC2F"}, {"\uFC30", "\uFC30"}, {"\uFC31", "\uFC31"}, {"\uFC32", "\uFC32"},
    {"\uFC33", "\uFC33"}, {"\uFC34", "\uFC34"}, {"\uFC35", "\uFC35"}, {"\uFC36", "\uFC36"}, {"\uFC37", "\uFC37"},
    {"\uFC38", "\uFC38"}, {"\uFC39", "\uFC39"}, {"\uFC3A", "\uFC3A"}, {"\uFC3B", "\uFC3B"}, {"\uFC3C", "\uFC3C"},
    {"\uFC3D", "\uFC3D"}, {"\uFC3E", "\uFC3E"}, {"\uFC3F", "\uFC3F"}, {"\uFC40", "\uFC40"}, {"\uFC41", "\uFC41"},
    {"\uFC42", "\uFC42"}, {"\uFC43", "\uFC43"}, {"\uFC44", "\uFC44"}, {"\uFC45", "\uFC45"}, {"\uFC46", "\uFC46"},
    {"\uFC47", "\uFC47"}, {"\uFC48", "\uFC48"}, {"\uFC49", "\uFC49"}, {"\uFC4A", "\uFC4A"}, {"\uFC4B", "\uFC4B"},
    {"\uFC4C", "\uFC4C"}, {"\uFC4D", "\uFC4D"}, {"\uFC4E", "\uFC4E"}, {"\uFC4F", "\uFC4F"}, {"\uFC50", "\uFC50"},
    {"\uFC51", "\uFC51"}, {"\uFC52", "\uFC52"}, {"\uFC53", "\uFC53"}, {"\uFC54", "\uFC54"}, {"\uFC55", "\uFC55"},
    {"\uFC56", "\uFC56"}, {"\uFC57", "\uFC57"}, {"\uFC58", "\uFC58"}, {"\uFC59", "\uFC59"}, {"\uFC5A", "\uFC5A"},
    {"\uFC5B", "\uFC5B"}, {"\uFC5C", "\uFC5C"}, {"\uFC5D", "\uFC5D"}, {"\uFC5E", "\uFC5E"}, {"\uFC5F", "\uFC5F"},
    {"\uFC60", "\uFC60"}, {"\uFC61", "\uFC61"}, {"\uFC62", "\uFC62"}, {"\uFC63", "\uFC63"}, {"\uFC64", "\uFC64"},
    {"\uFC65", "\uFC65"}, {"\uFC66", "\uFC66"}, {"\uFC67", "\uFC67"}, {"\uFC68", "\uFC68"}, {"\uFC69", "\uFC69"},
    {"\uFC6A", "\uFC6A"}, {"\uFC6B", "\uFC6B"}, {"\uFC6C", "\uFC6C"}, {"\uFC6D", "\uFC6D"}, {"\uFC6E", "\uFC6E"},
    {"\uFC6F", "\uFC6F"}, {"\uFC70", "\uFC70"}, {"\uFC71", "\uFC71"}, {"\uFC72", "\uFC72"}, {"\uFC73", "\uFC73"},
    {"\uFC74", "\uFC74"}, {"\uFC75", "\uFC75"}, {"\uFC76", "\uFC76"}, {"\uFC77", "\uFC77"}, {"\uFC78", "\uFC78"},
    {"\uFC79", "\uFC79"}, {"\uFC7A", "\uFC7A"}, {"\uFC7B", "\uFC7B"}, {"\uFC7C", "\uFC7C"}, {"\uFC7D", "\uFC7D"},
    {"\uFC7E", "\uFC7E"}, {"\uFC7F", "\uFC7F"}, {"\uFC80", "\uFC80"}, {"\uFC81", "\uFC81"}, {"\uFC82", "\uFC82"},
    {"\uFC83", "\uFC83"}, {"\uFC84", "\uFC84"}, {"\uFC85", "\uFC85"}, {"\uFC86", "\uFC86"}, {"\uFC87", "\uFC87"},
    {"\uFC88", "\uFC88"}, {"\uFC89", "\uFC89"}, {"\uFC8A", "\uFC8A"}, {"\uFC8B", "\uFC8B"}, {"\uFC8C", "\uFC8C"},
    {"\uFC8D", "\uFC8D"}, {"\uFC8E", "\uFC8E"}, {"\uFC8F", "\uFC8F"}, {"\uFC90", "\uFC90"}, {"\uFC91", "\uFC91"},
    {"\uFC92", "\uFC92"}, {"\uFC93", "\uFC93"}, {"\uFC94", "\uFC94"}, {"\uFC95", "\uFC95"}, {"\uFC96", "\uFC96"},
    {"\uFC97", "\uFC97"}, {"\uFC98", "\uFC98"}, {"\uFC99", "\uFC99"}, {"\uFC9A", "\uFC9A"}, {"\uFC9B", "\uFC9B"},
    {"\uFC9C", "\uFC9C"}, {"\uFC9D", "\uFC9D"}, {"\uFC9E", "\uFC9E"}, {"\uFC9F", "\uFC9F"}, {"\uFCA0", "\uFCA0"},
    {"\uFCA1", "\uFCA1"}, {"\uFCA2", "\uFCA2"}, {"\uFCA3", "\uFCA3"}, {"\uFCA4", "\uFCA4"}, {"\uFCA5", "\uFCA5"},
    {"\uFCA6", "\uFCA6"}, {"\uFCA7", "\uFCA7"}, {"\uFCA8", "\uFCA8"}, {"\uFCA9", "\uFCA9"}, {"\uFCAA", "\uFCAA"},
    {"\uFCAB", "\uFCAB"}, {"\uFCAC", "\uFCAC"}, {"\uFCAD", "\uFCAD"}, {"\uFCAE", "\uFCAE"}, {"\uFCAF", "\uFCAF"},
    {"\uFCB0", "\uFCB0"}, {"\uFCB1", "\uFCB1"}, {"\uFCB2", "\uFCB2"}, {"\uFCB3", "\uFCB3"}, {"\uFCB4", "\uFCB4"},
    {"\uFCB5", "\uFCB5"}, {"\uFCB6", "\uFCB6"}, {"\uFCB7", "\uFCB7"}, {"\uFCB8", "\uFCB8"}, {"\uFCB9", "\uFCB9"},
    {"\uFCBA", "\uFCBA"}, {"\uFCBB", "\uFCBB"}, {"\uFCBC", "\uFCBC"}, {"\uFCBD", "\uFCBD"}, {"\uFCBE", "\uFCBE"},
    {"\uFCBF", "\uFCBF"}, {"\uFCC0", "\uFCC0"}, {"\uFCC1", "\uFCC1"}, {"\uFCC2", "\uFCC2"}, {"\uFCC3", "\uFCC3"},
    {"\uFCC4", "\uFCC4"}, {"\uFCC5", "\uFCC5"}, {"\uFCC6", "\uFCC6"}, {"\uFCC7", "\uFCC7"}, {"\uFCC8", "\uFCC8"},
    {"\uFCC9", "\uFCC9"}, {"\uFCCA", "\uFCCA"}, {"\uFCCB", "\uFCCB"}, {"\uFCCC", "\uFCCC"}, {"\uFCCD", "\uFCCD"},
    {"\uFCCE", "\uFCCE"}, {"\uFCCF", "\uFCCF"}, {"\uFCD0", "\uFCD0"}, {"\uFCD1", "\uFCD1"}, {"\uFCD2", "\uFCD2"},
    {"\uFCD3", "\uFCD3"}, {"\uFCD4", "\uFCD4"}, {"\uFCD5", "\uFCD5"}, {"\uFCD6", "\uFCD6"}, {"\uFCD7", "\uFCD7"},
    {"\uFCD8", "\uFCD8"}, {"\uFCD9", "\uFCD9"}, {"\uFCDA", "\uFCDA"}, {"\uFCDB", "\uFCDB"}, {"\uFCDC", "\uFCDC"},
    {"\uFCDD", "\uFCDD"}, {"\uFCDE", "\uFCDE"}, {"\uFCDF", "\uFCDF"}, {"\uFCE0", "\uFCE0"}, {"\uFCE1", "\uFCE1"},
    {"\uFCE2", "\uFCE2"}, {"\uFCE3", "\uFCE3"}, {"\uFCE4", "\uFCE4"}, {"\uFCE5", "\uFCE5"}, {"\uFCE6", "\uFCE6"},
    {"\uFCE7", "\uFCE7"}, {"\uFCE8", "\uFCE8"}, {"\uFCE9", "\uFCE9"}, {"\uFCEA", "\uFCEA"}, {"\uFCEB", "\uFCEB"},
    {"\uFCEC", "\uFCEC"}, {"\uFCED", "\uFCED"}, {"\uFCEE", "\uFCEE"}, {"\uFCEF", "\uFCEF"}, {"\uFCF0", "\uFCF0"},
    {"\uFCF1", "\uFCF1"}, {"\uFCF2", "\uFCF2"}, {"\uFCF3", "\uFCF3"}, {"\uFCF4", "\uFCF4"}, {"\uFCF5", "\uFCF5"},
    {"\uFCF6", "\uFCF6"}, {"\uFCF7", "\uFCF7"}, {"\uFCF8", "\uFCF8"}, {"\uFCF9", "\uFCF9"}, {"\uFCFA", "\uFCFA"},
    {"\uFCFB", "\uFCFB"}, {"\uFCFC", "\uFCFC"}, {"\uFCFD", "\uFCFD"}, {"\uFCFE", "\uFCFE"}, {"\uFCFF", "\uFCFF"},
    {"\uFD00", "\uFD00"}, {"\uFD01", "\uFD01"}, {"\uFD02", "\uFD02"}, {"\uFD03", "\uFD03"}, {"\uFD04", "\uFD04"},
    {"\uFD05", "\uFD05"}, {"\uFD06", "\uFD06"}, {"\uFD07", "\uFD07"}, {"\uFD08", "\uFD08"}, {"\uFD09", "\uFD09"},
    {"\uFD0A", "\uFD0A"}, {"\uFD0B", "\uFD0B"}, {"\uFD0C", "\uFD0C"}, {"\uFD0D", "\uFD0D"}, {"\uFD0E", "\uFD0E"},
    {"\uFD0F", "\uFD0F"}, {"\uFD10", "\uFD10"}, {"\uFD11", "\uFD11"}, {"\uFD12", "\uFD12"}, {"\uFD13", "\uFD13"},
    {"\uFD14", "\uFD14"}, {"\uFD15", "\uFD15"}, {"\uFD16", "\uFD16"}, {"\uFD17", "\uFD17"}, {"\uFD18", "\uFD18"},
    {"\uFD19", "\uFD19"}, {"\uFD1A", "\uFD1A"}, {"\uFD1B", "\uFD1B"}, {"\uFD1C", "\uFD1C"}, {"\uFD1D", "\uFD1D"},
    {"\uFD1E", "\uFD1E"}, {"\uFD1F", "\uFD1F"}, {"\uFD20", "\uFD20"}, {"\uFD21", "\uFD21"}, {"\uFD22", "\uFD22"},
    {"\uFD23", "\uFD23"}, {"\uFD24", "\uFD24"}, {"\uFD25", "\uFD25"}, {"\uFD26", "\uFD26"}, {"\uFD27", "\uFD27"},
    {"\uFD28", "\uFD28"}, {"\uFD29", "\uFD29"}, {"\uFD2A", "\uFD2A"}, {"\uFD2B", "\uFD2B"}, {"\uFD2C", "\uFD2C"},
    {"\uFD2D", "\uFD2D"}, {"\uFD2E", "\uFD2E"}, {"\uFD2F", "\uFD2F"}, {"\uFD30", "\uFD30"}, {"\uFD31", "\uFD31"},
    {"\uFD32", "\uFD32"}, {"\uFD33", "\uFD33"}, {"\uFD34", "\uFD34"}, {"\uFD35", "\uFD35"}, {"\uFD36", "\uFD36"},
    {"\uFD37", "\uFD37"}, {"\uFD38", "\uFD38"}, {"\uFD39", "\uFD39"}, {"\uFD3A", "\uFD3A"}, {"\uFD3B", "\uFD3B"},
    {"\uFD3C", "\uFD3C"}, {"\uFD3D", "\uFD3D"}, {"\uFD50", "\uFD50"}, {"\uFD51", "\uFD51"}, {"\uFD52", "\uFD52"},
    {"\uFD53", "\uFD53"}, {"\uFD54", "\uFD54"}, {"\uFD55", "\uFD55"}, {"\uFD56", "\uFD56"}, {"\uFD57", "\uFD57"},
    {"\uFD58", "\uFD58"}, {"\uFD59", "\uFD59"}, {"\uFD5A", "\uFD5A"}, {"\uFD5B", "\uFD5B"}, {"\uFD5C", "\uFD5C"},
    {"\uFD5D", "\uFD5D"}, {"\uFD5E", "\uFD5E"}, {"\uFD5F", "\uFD5F"}, {"\uFD60", "\uFD60"}, {"\uFD61", "\uFD61"},
    {"\uFD62", "\uFD62"}, {"\uFD63", "\uFD63"}, {"\uFD64", "\uFD64"}, {"\uFD65", "\uFD65"}, {"\uFD66", "\uFD66"},
    {"\uFD67", "\uFD67"}, {"\uFD68", "\uFD68"}, {"\uFD69", "\uFD69"}, {"\uFD6A", "\uFD6A"}, {"\uFD6B", "\uFD6B"},
    {"\uFD6C", "\uFD6C"}, {"\uFD6D", "\uFD6D"}, {"\uFD6E", "\uFD6E"}, {"\uFD6F", "\uFD6F"}, {"\uFD70", "\uFD70"},
    {"\uFD71", "\uFD71"}, {"\uFD72", "\uFD72"}, {"\uFD73", "\uFD73"}, {"\uFD74", "\uFD74"}, {"\uFD75", "\uFD75"},
    {"\uFD76", "\uFD76"}, {"\uFD77", "\uFD77"}, {"\uFD78", "\uFD78"}, {"\uFD79", "\uFD79"}, {"\uFD7A", "\uFD7A"},
    {"\uFD7B", "\uFD7B"}, {"\uFD7C", "\uFD7C"}, {"\uFD7D", "\uFD7D"}, {"\uFD7E", "\uFD7E"}, {"\uFD7F", "\uFD7F"},
    {"\uFD80", "\uFD80"}, {"\uFD81", "\uFD81"}, {"\uFD82", "\uFD82"}, {"\uFD83", "\uFD83"}, {"\uFD84", "\uFD84"},
    {"\uFD85", "\uFD85"}, {"\uFD86", "\uFD86"}, {"\uFD87", "\uFD87"}, {"\uFD88", "\uFD88"}, {"\uFD89", "\uFD89"},
    {"\uFD8A", "\uFD8A"}, {"\uFD8B", "\uFD8B"}, {"\uFD8C", "\uFD8C"}, {"\uFD8D", "\uFD8D"}, {"\uFD8E", "\uFD8E"},
    {"\uFD8F", "\uFD8F"}, {"\uFD92", "\uFD92"}, {"\uFD93", "\uFD93"}, {"\uFD94", "\uFD94"}, {"\uFD95", "\uFD95"},
    {"\uFD96", "\uFD96"}, {"\uFD97", "\uFD97"}, {"\uFD98", "\uFD98"}, {"\uFD99", "\uFD99"}, {"\uFD9A", "\uFD9A"},
    {"\uFD9B", "\uFD9B"}, {"\uFD9C", "\uFD9C"}, {"\uFD9D", "\uFD9D"}, {"\uFD9E", "\uFD9E"}, {"\uFD9F", "\uFD9F"},
    {"\uFDA0", "\uFDA0"}, {"\uFDA1", "\uFDA1"}, {"\uFDA2", "\uFDA2"}, {"\uFDA3", "\uFDA3"}, {"\uFDA4", "\uFDA4"},
    {"\uFDA5", "\uFDA5"}, {"\uFDA6", "\uFDA6"}, {"\uFDA7", "\uFDA7"}, {"\uFDA8", "\uFDA8"}, {"\uFDA9", "\uFDA9"},
    {"\uFDAA", "\uFDAA"}, {"\uFDAB", "\uFDAB"}, {"\uFDAC", "\uFDAC"}, {"\uFDAD", "\uFDAD"}, {"\uFDAE", "\uFDAE"},
    {"\uFDAF", "\uFDAF"}, {"\uFDB0", "\uFDB0"}, {"\uFDB1", "\uFDB1"}, {"\uFDB2", "\uFDB2"}, {"\uFDB3", "\uFDB3"},
    {"\uFDB4", "\uFDB4"}, {"\uFDB5", "\uFDB5"}, {"\uFDB6", "\uFDB6"}, {"\uFDB7", "\uFDB7"}, {"\uFDB8", "\uFDB8"},
    {"\uFDB9", "\uFDB9"}, {"\uFDBA", "\uFDBA"}, {"\uFDBB", "\uFDBB"}, {"\uFDBC", "\uFDBC"}, {"\uFDBD", "\uFDBD"},
    {"\uFDBE", "\uFDBE"}, {"\uFDBF", "\uFDBF"}, {"\uFDC0", "\uFDC0"}, {"\uFDC1", "\uFDC1"}, {"\uFDC2", "\uFDC2"},
    {"\uFDC3", "\uFDC3"}, {"\uFDC4", "\uFDC4"}, {"\uFDC5", "\uFDC5"}, {"\uFDC6", "\uFDC6"}, {"\uFDC7", "\uFDC7"},
    {"\uFDF0", "\uFDF0"}, {"\uFDF1", "\uFDF1"}, {"\uFDF2", "\uFDF2"}, {"\uFDF3", "\uFDF3"}, {"\uFDF4", "\uFDF4"},
    {"\uFDF5", "\uFDF5"}, {"\uFDF6", "\uFDF6"}, {"\uFDF7", "\uFDF7"}, {"\uFDF8", "\uFDF8"}, {"\uFDF9", "\uFDF9"},
    {"\uFDFA", "\uFDFA"}, {"\uFDFB", "\uFDFB"}, {"\uFDFC", "\uFDFC"}, {"\uFE10", "\uFE10"}, {"\uFE11", "\uFE11"},
    {"\uFE12", "\uFE12"}, {"\uFE13", "\uFE13"}, {"\uFE14", "\uFE14"}, {"\uFE15", "\uFE15"}, {"\uFE16", "\uFE16"},
    {"\uFE17", "\uFE17"}, {"\uFE18", "\uFE18"}, {"\uFE19", "\uFE19"}, {"\uFE30", "\uFE30"}, {"\uFE31", "\uFE31"},
    {"\uFE32", "\uFE32"}, {"\uFE33", "\uFE33"}, {"\uFE34", "\uFE34"}, {"\uFE35", "\uFE35"}, {"\uFE36", "\uFE36"},
    {"\uFE37", "\uFE37"}, {"\uFE38", "\uFE38"}, {"\uFE39", "\uFE39"}, {"\uFE3A", "\uFE3A"}, {"\uFE3B", "\uFE3B"},
    {"\uFE3C", "\uFE3C"}, {"\uFE3D", "\uFE3D"}, {"\uFE3E", "\uFE3E"}, {"\uFE3F", "\uFE3F"}, {"\uFE40", "\uFE40"},
    {"\uFE41", "\uFE41"}, {"\uFE42", "\uFE42"}, {"\uFE43", "\uFE43"}, {"\uFE44", "\uFE44"}, {"\uFE47", "\uFE47"},
    {"\uFE48", "\uFE48"}, {"\uFE49", "\uFE49"}, {"\uFE4A", "\uFE4A"}, {"\uFE4B", "\uFE4B"}, {"\uFE4C", "\uFE4C"},
    {"\uFE4D", "\uFE4D"}, {"\uFE4E", "\uFE4E"}, {"\uFE4F", "\uFE4F"}, {"\uFE50", "\uFE50"}, {"\uFE51", "\uFE51"},
    {"\uFE52", "\uFE52"}, {"\uFE54", "\uFE54"}, {"\uFE55", "\uFE55"}, {"\uFE56", "\uFE56"}, {"\uFE57", "\uFE57"},
    {"\uFE58", "\uFE58"}, {"\uFE59", "\uFE59"}, {"\uFE5A", "\uFE5A"}, {"\uFE5B", "\uFE5B"}, {"\uFE5C", "\uFE5C"},
    {"\uFE5D", "\uFE5D"}, {"\uFE5E", "\uFE5E"}, {"\uFE5F", "\uFE5F"}, {"\uFE60", "\uFE60"}, {"\uFE61", "\uFE61"},
    {"\uFE62", "\uFE62"}, {"\uFE63", "\uFE63"}, {"\uFE64", "\uFE64"}, {"\uFE65", "\uFE65"}, {"\uFE66", "\uFE66"},
    {"\uFE68", "\uFE68"}, {"\uFE69", "\uFE69"}, {"\uFE6A", "\uFE6A"}, {"\uFE6B", "\uFE6B"}, {"\uFE70", "\uFE70"},
    {"\uFE71", "\uFE71"}, {"\uFE72", "\uFE72"}, {"\uFE74", "\uFE74"}, {"\uFE76", "\uFE76"}, {"\uFE77", "\uFE77"},
    {"\uFE78", "\uFE78"}, {"\uFE79", "\uFE79"}, {"\uFE7A", "\uFE7A"}, {"\uFE7B", "\uFE7B"}, {"\uFE7C", "\uFE7C"},
    {"\uFE7D", "\uFE7D"}, {"\uFE7E", "\uFE7E"}, {"\uFE7F", "\uFE7F"}, {"\uFE80", "\uFE80"}, {"\uFE81", "\uFE81"},
    {"\uFE82", "\uFE82"}, {"\uFE83", "\uFE83"}, {"\uFE84", "\uFE84"}, {"\uFE85", "\uFE85"}, {"\uFE86", "\uFE86"},
    {"\uFE87", "\uFE87"}, {"\uFE88", "\uFE88"}, {"\uFE89", "\uFE89"}, {"\uFE8A", "\uFE8A"}, {"\uFE8B", "\uFE8B"},
    {"\uFE8C", "\uFE8C"}, {"\uFE8D", "\uFE8D"}, {"\uFE8E", "\uFE8E"}, {"\uFE8F", "\uFE8F"}, {"\uFE90", "\uFE90"},
    {"\uFE91", "\uFE91"}, {"\uFE92", "\uFE92"}, {"\uFE93", "\uFE93"}, {"\uFE94", "\uFE94"}, {"\uFE95", "\uFE95"},
    {"\uFE96", "\uFE96"}, {"\uFE97", "\uFE97"}, {"\uFE98", "\uFE98"}, {"\uFE99", "\uFE99"}, {"\uFE9A", "\uFE9A"},
    {"\uFE9B", "\uFE9B"}, {"\uFE9C", "\uFE9C"}, {"\uFE9D", "\uFE9D"}, {"\uFE9E", "\uFE9E"}, {"\uFE9F", "\uFE9F"},
    {"\uFEA0", "\uFEA0"}, {"\uFEA1", "\uFEA1"}, {"\uFEA2", "\uFEA2"}, {"\uFEA3", "\uFEA3"}, {"\uFEA4", "\uFEA4"},
    {"\uFEA5", "\uFEA5"}, {"\uFEA6", "\uFEA6"}, {"\uFEA7", "\uFEA7"}, {"\uFEA8", "\uFEA8"}, {"\uFEA9", "\uFEA9"},
    {"\uFEAA", "\uFEAA"}, {"\uFEAB", "\uFEAB"}, {"\uFEAC", "\uFEAC"}, {"\uFEAD", "\uFEAD"}, {"\uFEAE", "\uFEAE"},
    {"\uFEAF", "\uFEAF"}, {"\uFEB0", "\uFEB0"}, {"\uFEB1", "\uFEB1"}, {"\uFEB2", "\uFEB2"}, {"\uFEB3", "\uFEB3"},
    {"\uFEB4", "\uFEB4"}, {"\uFEB5", "\uFEB5"}, {"\uFEB6", "\uFEB6"}, {"\uFEB7", "\uFEB7"}, {"\uFEB8", "\uFEB8"},
    {"\uFEB9", "\uFEB9"}, {"\uFEBA", "\uFEBA"}, {"\uFEBB", "\uFEBB"}, {"\uFEBC", "\uFEBC"}, {"\uFEBD", "\uFEBD"},
    {"\uFEBE", "\uFEBE"}, {"\uFEBF", "\uFEBF"}, {"\uFEC0", "\uFEC0"}, {"\uFEC1", "\uFEC1"}, {"\uFEC2", "\uFEC2"},
    {"\uFEC3", "\uFEC3"}, {"\uFEC4", "\uFEC4"}, {"\uFEC5", "\uFEC5"}, {"\uFEC6", "\uFEC6"}, {"\uFEC7", "\uFEC7"},
    {"\uFEC8", "\uFEC8"}, {"\uFEC9", "\uFEC9"}, {"\uFECA", "\uFECA"}, {"\uFECB", "\uFECB"}, {"\uFECC", "\uFECC"},
    {"\uFECD", "\uFECD"}, {"\uFECE", "\uFECE"}, {"\uFECF", "\uFECF"}, {"\uFED0", "\uFED0"}, {"\uFED1", "\uFED1"},
    {"\uFED2", "\uFED2"}, {"\uFED3", "\uFED3"}, {"\uFED4", "\uFED4"}, {"\uFED5", "\uFED5"}, {"\uFED6", "\uFED6"},
    {"\uFED7", "\uFED7"}, {"\uFED8", "\uFED8"}, {"\uFED9", "\uFED9"}, {"\uFEDA", "\uFEDA"}, {"\uFEDB", "\uFEDB"},
    {"\uFEDC", "\uFEDC"}, {"\uFEDD", "\uFEDD"}, {"\uFEDE", "\uFEDE"}, {"\uFEDF", "\uFEDF"}, {"\uFEE0", "\uFEE0"},
    {"\uFEE1", "\uFEE1"}, {"\uFEE2", "\uFEE2"}, {"\uFEE3", "\uFEE3"}, {"\uFEE4", "\uFEE4"}, {"\uFEE5", "\uFEE5"},
    {"\uFEE6", "\uFEE6"}, {"\uFEE7", "\uFEE7"}, {"\uFEE8", "\uFEE8"}, {"\uFEE9", "\uFEE9"}, {"\uFEEA", "\uFEEA"},
    {"\uFEEB", "\uFEEB"}, {"\uFEEC", "\uFEEC"}, {"\uFEED", "\uFEED"}, {"\uFEEE", "\uFEEE"}, {"\uFEEF", "\uFEEF"},
    {"\uFEF0", "\uFEF0"}, {"\uFEF1", "\uFEF1"}, {"\uFEF2", "\uFEF2"}, {"\uFEF3", "\uFEF3"}, {"\uFEF4", "\uFEF4"},
    {"\uFEF5", "\uFEF5"}, {"\uFEF6", "\uFEF6"}, {"\uFEF7", "\uFEF7"}, {"\uFEF8", "\uFEF8"}, {"\uFEF9", "\uFEF9"},
    {"\uFEFA", "\uFEFA"}, {"\uFEFB", "\uFEFB"}, {"\uFEFC", "\uFEFC"}, {"\uFF01", "\uFF01"}, {"\uFF02", "\uFF02"},
    {"\uFF03", "\uFF03"}, {"\uFF04", "\uFF04"}, {"\uFF05", "\uFF05"}, {"\uFF06", "\uFF06"}, {"\uFF07", "\uFF07"},
    {"\uFF08", "\uFF08"}, {"\uFF09", "\uFF09"}, {"\uFF0A", "\uFF0A"}, {"\uFF0B", "\uFF0B"}, {"\uFF0C", "\uFF0C"},
    {"\uFF0D", "\uFF0D"}, {"\uFF0E", "\uFF0E"}, {"\uFF0F", "\uFF0F"}, {"\uFF10", "\uFF10"}, {"\uFF11", "\uFF11"},
    {"\uFF12", "\uFF12"}, {"\uFF13", "\uFF13"}, {"\uFF14", "\uFF14"}, {"\uFF15", "\uFF15"}, {"\uFF16", "\uFF16"},
    {"\uFF17", "\uFF17"}, {"\uFF18", "\uFF18"}, {"\uFF19", "\uFF19"}, {"\uFF1A", "\uFF1A"}, {"\uFF1B", "\uFF1B"},
    {"\uFF1C", "\uFF1C"}, {"\uFF1D", "\uFF1D"}, {"\uFF1E", "\uFF1E"}, {"\uFF1F", "\uFF1F"}, {"\uFF20", "\uFF20"},
    {"\uFF21", "\uFF21"}, {"\uFF22", "\uFF22"}, {"\uFF23", "\uFF23"}, {"\uFF24", "\uFF24"}, {"\uFF25", "\uFF25"},
    {"\uFF26", "\uFF26"}, {"\uFF27", "\uFF27"}, {"\uFF28", "\uFF28"}, {"\uFF29", "\uFF29"}, {"\uFF2A", "\uFF2A"},
    {"\uFF2B", "\uFF2B"}, {"\uFF2C", "\uFF2C"}, {"\uFF2D", "\uFF2D"}, {"\uFF2E", "\uFF2E"}, {"\uFF2F", "\uFF2F"},
    {"\uFF30", "\uFF30"}, {"\uFF31", "\uFF31"}, {"\uFF32", "\uFF32"}, {"\uFF33", "\uFF33"}, {"\uFF34", "\uFF34"},
    {"\uFF35", "\uFF35"}, {"\uFF36", "\uFF36"}, {"\uFF37", "\uFF37"}, {"\uFF38", "\uFF38"}, {"\uFF39", "\uFF39"},
    {"\uFF3A", "\uFF3A"}, {"\uFF3B", "\uFF3B"}, {"\uFF3C", "\uFF3C"}, {"\uFF3D", "\uFF3D"}, {"\uFF3E", "\uFF3E"},
    {"\uFF3F", "\uFF3F"}, {"\uFF40", "\uFF40"}, {"\uFF41", "\uFF41"}, {"\uFF42", "\uFF42"}, {"\uFF43", "\uFF43"},
    {"\uFF44", "\uFF44"}, {"\uFF45", "\uFF45"}, {"\uFF46", "\uFF46"}, {"\uFF47", "\uFF47"}, {"\uFF48", "\uFF48"},
    {"\uFF49", "\uFF49"}, {"\uFF4A", "\uFF4A"}, {"\uFF4B", "\uFF4B"}, {"\uFF4C", "\uFF4C"}, {"\uFF4D", "\uFF4D"},
    {"\uFF4E", "\uFF4E"}, {"\uFF4F", "\uFF4F"}, {"\uFF50", "\uFF50"}, {"\uFF51", "\uFF51"}, {"\uFF52", "\uFF52"},
    {"\uFF53", "\uFF53"}, {"\uFF54", "\uFF54"}, {"\uFF55", "\uFF55"}, {"\uFF56", "\uFF56"}, {"\uFF57", "\uFF57"},
    {"\uFF58", "\uFF58"}, {"\uFF59", "\uFF59"}, {"\uFF5A", "\uFF5A"}, {"\uFF5B", "\uFF5B"}, {"\uFF5C", "\uFF5C"},
    {"\uFF5D", "\uFF5D"}, {"\uFF5E", "\uFF5E"}, {"\uFF5F", "\uFF5F"}, {"\uFF60", "\uFF60"}, {"\uFF61", "\uFF61"},
    {"\uFF62", "\uFF62"}, {"\uFF63", "\uFF63"}, {"\uFF64", "\uFF64"}, {"\uFF65", "\uFF65"}, {"\uFF66", "\uFF66"},
    {"\uFF67", "\uFF67"}, {"\uFF68", "\uFF68"}, {"\uFF69", "\uFF69"}, {"\uFF6A", "\uFF6A"}, {"\uFF6B", "\uFF6B"},
    {"\uFF6C", "\uFF6C"}, {"\uFF6D", "\uFF6D"}, {"\uFF6E", "\uFF6E"}, {"\uFF6F", "\uFF6F"}, {"\uFF70", "\uFF70"},
    {"\uFF71", "\uFF71"}, {"\uFF72", "\uFF72"}, {"\uFF73", "\uFF73"}, {"\uFF74", "\uFF74"}, {"\uFF75", "\uFF75"},
    {"\uFF76", "\uFF76"}, {"\uFF77", "\uFF77"}, {"\uFF78", "\uFF78"}, {"\uFF79", "\uFF79"}, {"\uFF7A", "\uFF7A"},
    {"\uFF7B", "\uFF7B"}, {"\uFF7C", "\uFF7C"}, {"\uFF7D", "\uFF7D"}, {"\uFF7E", "\uFF7E"}, {"\uFF7F", "\uFF7F"},
    {"\uFF80", "\uFF80"}, {"\uFF81", "\uFF81"}, {"\uFF82", "\uFF82"}, {"\uFF83", "\uFF83"}, {"\uFF84", "\uFF84"},
    {"\uFF85", "\uFF85"}, {"\uFF86", "\uFF86"}, {"\uFF87", "\uFF87"}, {"\uFF88", "\uFF88"}, {"\uFF89", "\uFF89"},
    {"\uFF8A", "\uFF8A"}, {"\uFF8B", "\uFF8B"}, {"\uFF8C", "\uFF8C"}, {"\uFF8D", "\uFF8D"}, {"\uFF8E", "\uFF8E"},
    {"\uFF8F", "\uFF8F"}, {"\uFF90", "\uFF90"}, {"\uFF91", "\uFF91"}, {"\uFF92", "\uFF92"}, {"\uFF93", "\uFF93"},
    {"\uFF94", "\uFF94"}, {"\uFF95", "\uFF95"}, {"\uFF96", "\uFF96"}, {"\uFF97", "\uFF97"}, {"\uFF98", "\uFF98"},
    {"\uFF99", "\uFF99"}, {"\uFF9A", "\uFF9A"}, {"\uFF9B", "\uFF9B"}, {"\uFF9C", "\uFF9C"}, {"\uFF9D", "\uFF9D"},
    {"\uFF9E", "\uFF9E"}, {"\uFF9F", "\uFF9F"}, {"\uFFA0", "\uFFA0"}, {"\uFFA1", "\uFFA1"}, {"\uFFA2", "\uFFA2"},
    {"\uFFA3", "\uFFA3"}, {"\uFFA4", "\uFFA4"}, {"\uFFA5", "\uFFA5"}, {"\uFFA6", "\uFFA6"}, {"\uFFA7", "\uFFA7"},
    {"\uFFA8", "\uFFA8"}, {"\uFFA9", "\uFFA9"}, {"\uFFAA", "\uFFAA"}, {"\uFFAB", "\uFFAB"}, {"\uFFAC", "\uFFAC"},
    {"\uFFAD", "\uFFAD"}, {"\uFFAE", "\uFFAE"}, {"\uFFAF", "\uFFAF"}, {"\uFFB0", "\uFFB0"}, {"\uFFB1", "\uFFB1"},
    {"\uFFB2", "\uFFB2"}, {"\uFFB3", "\uFFB3"}, {"\uFFB4", "\uFFB4"}, {"\uFFB5", "\uFFB5"}, {"\uFFB6", "\uFFB6"},
    {"\uFFB7", "\uFFB7"}, {"\uFFB8", "\uFFB8"}, {"\uFFB9", "\uFFB9"}, {"\uFFBA", "\uFFBA"}, {"\uFFBB", "\uFFBB"},
    {"\uFFBC", "\uFFBC"}, {"\uFFBD", "\uFFBD"}, {"\uFFBE", "\uFFBE"}, {"\uFFC2", "\uFFC2"}, {"\uFFC3", "\uFFC3"},
    {"\uFFC4", "\uFFC4"}, {"\uFFC5", "\uFFC5"}, {"\uFFC6", "\uFFC6"}, {"\uFFC7", "\uFFC7"}, {"\uFFCA", "\uFFCA"},
    {"\uFFCB", "\uFFCB"}, {"\uFFCC", "\uFFCC"}, {"\uFFCD", "\uFFCD"}, {"\uFFCE", "\uFFCE"}, {"\uFFCF", "\uFFCF"},
    {"\uFFD2", "\uFFD2"}, {"\uFFD3", "\uFFD3"}, {"\uFFD4", "\uFFD4"}, {"\uFFD5", "\uFFD5"}, {"\uFFD6", "\uFFD6"},
    {"\uFFD7", "\uFFD7"}, {"\uFFDA", "\uFFDA"}, {"\uFFDB", "\uFFDB"}, {"\uFFDC", "\uFFDC"}, {"\uFFE0", "\uFFE0"},
    {"\uFFE1", "\uFFE1"}, {"\uFFE2", "\uFFE2"}, {"\uFFE3", "\uFFE3"}, {"\uFFE4", "\uFFE4"}, {"\uFFE5", "\uFFE5"},
    {"\uFFE6", "\uFFE6"}, {"\uFFE8", "\uFFE8"}, {"\uFFE9", "\uFFE9"}, {"\uFFEA", "\uFFEA"}, {"\uFFEB", "\uFFEB"},
    {"\uFFEC", "\uFFEC"}, {"\uFFED", "\uFFED"}, {"\uFFEE", "\uFFEE"}, {"\U00010781", "\U00010781"},
    {"\U00010782", "\U00010782"}, {"\U00010783", "\U00010783"}, {"\U00010784", "\U00010784"},
    {"\U00010785", "\U00010785"}, {"\U00010787", "\U00010787"}, {"\U00010788", "\U00010788"},
    {"\U00010789", "\U00010789"}, {"\U0001078A", "\U0001078A"}, {"\U0001078B", "\U0001078B"},
    {"\U0001078C", "\U0001078C"}, {"\U0001078D", "\U0001078D"}, {"\U0001078E", "\U0001078E"},
    {"\U0001078F", "\U0001078F"}, {"\U00010790", "\U00010790"}, {"\U00010791", "\U00010791"},
    {"\U00010792", "\U00010792"}, {"\U00010793", "\U00010793"}, {"\U00010794", "\U00010794"},
    {"\U00010795", "\U00010795"}, {"\U00010796", "\U00010796"}, {"\U00010797", "\U00010797"},
    {"\U00010798", "\U00010798"}, {"\U00010799", "\U00010799"}, {"\U0001079A", "\U0001079A"},
    {"\U0001079B", "\U0001079B"}, {"\U0001079C", "\U0001079C"}, {"\U0001079D", "\U0001079D"},
    {"\U0001079E", "\U0001079E"}, {"\U0001079F", "\U0001079F"}, {"\U000107A0", "\U000107A0"},
    {"\U000107A1", "\U000107A1"}, {"\U000107A2", "\U000107A2"}, {"\U000107A3", "\U000107A3"},
    {"\U000107A4", "\U000107A4"}, {"\U000107A5", "\U000107A5"}, {"\U000107A6", "\U000107A6"},
    {"\U000107A7", "\U000107A7"}, {"\U000107A8", "\U000107A8"}, {"\U000107A9", "\U000107A9"},
    {"\U000107AA", "\U000107AA"}, {"\U000107AB", "\U000107AB"}, {"\U000107AC", "\U000107AC"},
    {"\U000107AD", "\U000107AD"}, {"\U000107AE", "\U000107AE"}, {"\U000107AF", "\U000107AF"},
    {"\U000107B0", "\U000107B0"}, {"\U000107B2", "\U000107B2"}, {"\U000107B3", "\U000107B3"},
    {"\U000107B4", "\U000107B4"}, {"\U000107B5", "\U000107B5"}, {"\U000107B6", "\U000107B6"},
    {"\U000107B7", "\U000107B7"}, {"\U000107B8", "\U000107B8"}, {"\U000107B9", "\U000107B9"},
    {"\U000107BA", "\U000107BA"}, {"\U0001109A", "\U0001109A"}, {"\U0001109C", "\U0001109C"},
    {"\U000110AB", "\U000110AB"}, {"\U0001112E", "\U0001112E"}, {"\U0001112F", "\U0001112F"},
    {"\U0001134B", "\U0001134B"}, {"\U0001134C", "\U0001134C"}, {"\U000114BB", "\U000114BB"},
    {"\U000114BC", "\U000114BC"}, {"\U000114BE", "\U000114BE"}, {"\U000115BA", "\U000115BA"},
    {"\U000115BB", "\U000115BB"}, {"\U00011938", "\U00011938"}, {"\U0001D15E", "\U0001D157\U0001D165"},
    {"\U0001D15F", "\U0001D158\U0001D165"}, {"\U0001D160", "\U0001D158\U0001D165\U0001D16E"},
    {"\U0001D161", "\U0001D158\U0001D165\U0001D16F"}, {"\U0001D162", "\U0001D158\U0001D165\U0001D170"},
    {"\U0001D163", "\U0001D158\U0001D165\U0001D171"}, {"\U0001D164", "\U0001D158\U0001D165\U0001D172"},
    {"\U0001D1BB", "\U0001D1B9\U0001D165"}, {"\U0001D1BC", "\U0001D1BA\U0001D165"},
    {"\U0001D1BD", "\U0001D1B9\U0001D165\U0001D16E"}, {"\U0001D1BE", "\U0001D1BA\U0001D165\U0001D16E"},
    {"\U0001D1BF", "\U0001D1B9\U0001D165\U0001D16F"}, {"\U0001D1C0", "\U0001D1BA\U0001D165\U0001D16F"},
    {"\U0001D400", "\U0001D400"}, {"\U0001D401", "\U0001D401"}, {"\U0001D402", "\U0001D402"},
    {"\U0001D403", "\U0001D403"}, {"\U0001D404", "\U0001D404"}, {"\U0001D405", "\U0001D405"},
    {"\U0001D406", "\U0001D406"}, {"\U0001D407", "\U0001D407"}, {"\U0001D408", "\U0001D408"},
    {"\U0001D409", "\U0001D409"}, {"\U0001D40A", "\U0001D40A"}, {"\U0001D40B", "\U0001D40B"},
    {"\U0001D40C", "\U0001D40C"}, {"\U0001D40D", "\U0001D40D"}, {"\U0001D40E", "\U0001D40E"},
    {"\U0001D40F", "\U0001D40F"}, {"\U0001D410", "\U0001D410"}, {"\U0001D411", "\U0001D411"},
    {"\U0001D412", "\U0001D412"}, {"\U0001D413", "\U0001D413"}, {"\U0001D414", "\U0001D414"},
    {"\U0001D415", "\U0001D415"}, {"\U0001D416", "\U0001D416"}, {"\U0001D417", "\U0001D417"},
    {"\U0001D418", "\U0001D418"}, {"\U0001D419", "\U0001D419"}, {"\U0001D41A", "\U0001D41A"},
    {"\U0001D41B", "\U0001D41B"}, {"\U0001D41C", "\U0001D41C"}, {"\U0001D41D", "\U0001D41D"},
    {"\U0001D41E", "\U0001D41E"}, {"\U0001D41F", "\U0001D41F"}, {"\U0001D420", "\U0001D420"},
    {"\U0001D421", "\U0001D421"}, {"\U0001D422", "\U0001D422"}, {"\U0001D423", "\U0001D423"},
    {"\U0001D424", "\U0001D424"}, {"\U0001D425", "\U0001D425"}, {"\U0001D426", "\U0001D426"},
    {"\U0001D427", "\U0001D427"}, {"\U0001D428", "\U0001D428"}, {"\U0001D429", "\U0001D429"},
    {"\U0001D42A", "\U0001D42A"}, {"\U0001D42B", "\U0001D42B"}, {"\U0001D42C", "\U0001D42C"},
    {"\U0001D42D", "\U0001D42D"}, {"\U0001D42E", "\U0001D42E"}, {"\U0001D42F", "\U0001D42F"},
    {"\U0001D430", "\U0001D430"}, {"\U0001D431", "\U0001D431"}, {"\U0001D432", "\U0001D432"},
    {"\U0001D433", "\U0001D433"}, {"\U0001D434", "\U0001D434"}, {"\U0001D435", "\U0001D435"},
    {"\U0001D436", "\U0001D436"}, {"\U0001D437", "\U0001D437"}, {"\U0001D438", "\U0001D438"},
    {"\U0001D439", "\U0001D439"}, {"\U0001D43A", "\U0001D43A"}, {"\U0001D43B", "\U0001D43B"},
    {"\U0001D43C", "\U0001D43C"}, {"\U0001D43D", "\U0001D43D"}, {"\U0001D43E", "\U0001D43E"},
    {"\U0001D43F", "\U0001D43F"}, {"\U0001D440", "\U0001D440"}, {"\U0001D441", "\U0001D441"},
    {"\U0001D442", "\U0001D442"}, {"\U0001D443", "\U0001D443"}, {"\U0001D444", "\U0001D444"},
    {"\U0001D445", "\U0001D445"}, {"\U0001D446", "\U0001D446"}, {"\U0001D447", "\U0001D447"},
    {"\U0001D448", "\U0001D448"}, {"\U0001D449", "\U0001D449"}, {"\U0001D44A", "\U0001D44A"},
    {"\U0001D44B", "\U0001D44B"}, {"\U0001D44C", "\U0001D44C"}, {"\U0001D44D", "\U0001D44D"},
    {"\U0001D44E", "\U0001D44E"}, {"\U0001D44F", "\U0001D44F"}, {"\U0001D450", "\U0001D450"},
    {"\U0001D451", "\U0001D451"}, {"\U0001D452", "\U0001D452"}, {"\U0001D453", "\U0001D453"},
    {"\U0001D454", "\U0001D454"}, {"\U0001D456", "\U0001D456"}, {"\U0001D457", "\U0001D457"},
    {"\U0001D458", "\U0001D458"}, {"\U0001D459", "\U0001D459"}, {"\U0001D45A", "\U0001D45A"},
    {"\U0001D45B", "\U0001D45B"}, {"\U0001D45C", "\U0001D45C"}, {"\U0001D45D", "\U0001D45D"},
    {"\U0001D45E", "\U0001D45E"}, {"\U0001D45F", "\U0001D45F"}, {"\U0001D460", "\U0001D460"},
    {"\U0001D461", "\U0001D461"}, {"\U0001D462", "\U0001D462"}, {"\U0001D463", "\U0001D463"},
    {"\U0001D464", "\U0001D464"}, {"\U0001D465", "\U0001D465"}, {"\U0001D466", "\U0001D466"},
    {"\U0001D467", "\U0001D467"}, {"\U0001D468", "\U0001D468"}, {"\U0001D469", "\U0001D469"},
    {"\U0001D46A", "\U0001D46A"}, {"\U0001D46B", "\U0001D46B"}, {"\U0001D46C", "\U0001D46C"},
    {"\U0001D46D", "\U0001D46D"}, {"\U0001D46E", "\U0001D46E"}, {"\U0001D46F", "\U0001D46F"},
    {"\U0001D470", "\U0001D470"}, {"\U0001D471", "\U0001D471"}, {"\U0001D472", "\U0001D472"},
    {"\U0001D473", "\U0001D473"}, {"\U0001D474", "\U0001D474"}, {"\U0001D475", "\U0001D475"},
    {"\U0001D476", "\U0001D476"}, {"\U0001D477", "\U0001D477"}, {"\U0001D478", "\U0001D478"},
    {"\U0001D479", "\U0001D479"}, {"\U0001D47A", "\U0001D47A"}, {"\U0001D47B", "\U0001D47B"},
    {"\U0001D47C", "\U0001D47C"}, {"\U0001D47D", "\U0001D47D"}, {"\U0001D47E", "\U0001D47E"},
    {"\U0001D47F", "\U0001D47F"}, {"\U0001D480", "\U0001D480"}, {"\U0001D481", "\U0001D481"},
    {"\U0001D482", "\U0001D482"}, {"\U0001D483", "\U0001D483"}, {"\U0001D484", "\U0001D484"},
    {"\U0001D485", "\U0001D485"}, {"\U0001D486", "\U0001D486"}, {"\U0001D487", "\U0001D487"},
    {"\U0001D488", "\U0001D488"}, {"\U0001D489", "\U0001D489"}, {"\U0001D48A", "\U0001D48A"},
    {"\U0001D48B", "\U0001D48B"}, {"\U0001D48C", "\U0001D48C"}, {"\U0001D48D", "\U0001D48D"},
    {"\U0001D48E", "\U0001D48E"}, {"\U0001D48F", "\U0001D48F"}, {"\U0001D490", "\U0001D490"},
    {"\U0001D491", "\U0001D491"}, {"\U0001D492", "\U0001D492"}, {"\U0001D493", "\U0001D493"},
    {"\U0001D494", "\U0001D494"}, {"\U0001D495", "\U0001D495"}, {"\U0001D496", "\U0001D496"},
    {"\U0001D497", "\U0001D497"}, {"\U0001D498", "\U0001D498"}, {"\U0001D499", "\U0001D499"},
    {"\U0001D49A", "\U0001D49A"}, {"\U0001D49B", "\U0001D49B"}, {"\U0001D49C", "\U0001D49C"},
    {"\U0001D49E", "\U0001D49E"}, {"\U0001D49F", "\U0001D49F"}, {"\U0001D4A2", "\U0001D4A2"},
    {"\U0001D4A5", "\U0001D4A5"}, {"\U0001D4A6", "\U0001D4A6"}, {"\U0001D4A9", "\U0001D4A9"},
    {"\U0001D4AA", "\U0001D4AA"}, {"\U0001D4AB", "\U0001D4AB"}, {"\U0001D4AC", "\U0001D4AC"},
    {"\U0001D4AE", "\U0001D4AE"}, {"\U0001D4AF", "\U0001D4AF"}, {"\U0001D4B0", "\U0001D4B0"},
    {"\U0001D4B1", "\U0001D4B1"}, {"\U0001D4B2", "\U0001D4B2"}, {"\U0001D4B3", "\U0001D4B3"},
    {"\U0001D4B4", "\U0001D4B4"}, {"\U0001D4B5", "\U0001D4B5"}, {"\U0001D4B6", "\U0001D4B6"},
    {"\U0001D4B7", "\U0001D4B7"}, {"\U0001D4B8", "\U0001D4B8"}, {"\U0001D4B9", "\U0001D4B9"},
    {"\U0001D4BB", "\U0001D4BB"}, {"\U0001D4BD", "\U0001D4BD"}, {"\U0001D4BE", "\U0001D4BE"},
    {"\U0001D4BF", "\U0001D4BF"}, {"\U0001D4C0", "\U0001D4C0"}, {"\U0001D4C1", "\U0001D4C1"},
    {"\U0001D4C2", "\U0001D4C2"}, {"\U0001D4C3", "\U0001D4C3"}, {"\U0001D4C5", "\U0001D4C5"},
    {"\U0001D4C6", "\U0001D4C6"}, {"\U0001D4C7", "\U0001D4C7"}, {"\U0001D4C8", "\U0001D4C8"},
    {"\U0001D4C9", "\U0001D4C9"}, {"\U0001D4CA", "\U0001D4CA"}, {"\U0001D4CB", "\U0001D4CB"},
    {"\U0001D4CC", "\U0001D4CC"}, {"\U0001D4CD", "\U0001D4CD"}, {"\U0001D4CE", "\U0001D4CE"},
    {"\U0001D4CF", "\U0001D4CF"}, {"\U0001D4D0", "\U0001D4D0"}, {"\U0001D4D1", "\U0001D4D1"},
    {"\U0001D4D2", "\U0001D4D2"}, {"\U0001D4D3", "\U0001D4D3"}, {"\U0001D4D4", "\U0001D4D4"},
    {"\U0001D4D5", "\U0001D4D5"}, {"\U0001D4D6", "\U0001D4D6"}, {"\U0001D4D7", "\U0001D4D7"},
    {"\U0001D4D8", "\U0001D4D8"}, {"\U0001D4D9", "\U0001D4D9"}, {"\U0001D4DA", "\U0001D4DA"},
    {"\U0001D4DB", "\U0001D4DB"}, {"\U0001D4DC", "\U0001D4DC"}, {"\U0001D4DD", "\U0001D4DD"},
    {"\U0001D4DE", "\U0001D4DE"}, {"\U0001D4DF", "\U0001D4DF"}, {"\U0001D4E0", "\U0001D4E0"},
    {"\U0001D4E1", "\U0001D4E1"}, {"\U0001D4E2", "\U0001D4E2"}, {"\U0001D4E3", "\U0001D4E3"},
    {"\U0001D4E4", "\U0001D4E4"}, {"\U0001D4E5", "\U0001D4E5"}, {"\U0001D4E6", "\U0001D4E6"},
    {"\U0001D4E7", "\U0001D4E7"}, {"\U0001D4E8", "\U0001D4E8"}, {"\U0001D4E9", "\U0001D4E9"},
    {"\U0001D4EA", "\U0001D4EA"}, {"\U0001D4EB", "\U0001D4EB"}, {"\U0001D4EC", "\U0001D4EC"},
    {"\U0001D4ED", "\U0001D4ED"}, {"\U0001D4EE", "\U0001D4EE"}, {"\U0001D4EF", "\U0001D4EF"},
    {"\U0001D4F0", "\U0001D4F0"}, {"\U0001D4F1", "\U0001D4F1"}, {"\U0001D4F2", "\U0001D4F2"},
    {"\U0001D4F3", "\U0001D4F3"}, {"\U0001D4F4", "\U0001D4F4"}, {"\U0001D4F5", "\U0001D4F5"},
    {"\U0001D4F6", "\U0001D4F6"}, {"\U0001D4F7", "\U0001D4F7"}, {"\U0001D4F8", "\U0001D4F8"},
    {"\U0001D4F9", "\U0001D4F9"}, {"\U0001D4FA", "\U0001D4FA"}, {"\U0001D4FB", "\U0001D4FB"},
    {"\U0001D4FC", "\U0001D4FC"}, {"\U0001D4FD", "\U0001D4FD"}, {"\U0001D4FE", "\U0001D4FE"},
    {"\U0001D4FF", "\U0001D4FF"}, {"\U0001D500", "\U0001D500"}, {"\U0001D501", "\U0001D501"},
    {"\U0001D502", "\U0001D502"}, {"\U0001D503", "\U0001D503"}, {"\U0001D504", "\U0001D504"},
    {"\U0001D505", "\U0001D505"}, {"\U0001D507", "\U0001D507"}, {"\U0001D508", "\U0001D508"},
    {"\U0001D509", "\U0001D509"}, {"\U0001D50A", "\U0001D50A"}, {"\U0001D50D", "\U0001D50D"},
    {"\U0001D50E", "\U0001D50E"}, {"\U0001D50F", "\U0001D50F"}, {"\U0001D510", "\U0001D510"},
    {"\U0001D511", "\U0001D511"}, {"\U0001D512", "\U0001D512"}, {"\U0001D513", "\U0001D513"},
    {"\U0001D514", "\U0001D514"}, {"\U0001D516", "\U0001D516"}, {"\U0001D517", "\U0001D517"},
    {"\U0001D518", "\U0001D518"}, {"\U0001D519", "\U0001D519"}, {"\U0001D51A", "\U0001D51A"},
    {"\U0001D51B", "\U0001D51B"}, {"\U0001D51C", "\U0001D51C"}, {"\U0001D51E", "\U0001D51E"},
    {"\U0001D51F", "\U0001D51F"}, {"\U0001D520", "\U0001D520"}, {"\U0001D521", "\U0001D521"},
    {"\U0001D522", "\U0001D522"}, {"\U0001D523", "\U0001D523"}, {"\U0001D524", "\U0001D524"},
    {"\U0001D525", "\U0001D525"}, {"\U0001D526", "\U0001D526"}, {"\U0001D527", "\U0001D527"},
    {"\U0001D528", "\U0001D528"}, {"\U0001D529", "\U0001D529"}, {"\U0001D52A", "\U0001D52A"},
    {"\U0001D52B", "\U0001D52B"}, {"\U0001D52C", "\U0001D52C"}, {"\U0001D52D", "\U0001D52D"},
    {"\U0001D52E", "\U0001D52E"}, {"\U0001D52F", "\U0001D52F"}, {"\U0001D530", "\U0001D530"},
    {"\U0001D531", "\U0001D531"}, {"\U0001D532", "\U0001D532"}, {"\U0001D533", "\U0001D533"},
    {"\U0001D534", "\U0001D534"}, {"\U0001D535", "\U0001D535"}, {"\U0001D536", "\U0001D536"},
    {"\U0001D537", "\U0001D537"}, {"\U0001D538", "\U0001D538"}, {"\U0001D539", "\U0001D539"},
    {"\U0001D53B", "\U0001D53B"}, {"\U0001D53C", "\U0001D53C"}, {"\U0001D53D", "\U0001D53D"},
    {"\U0001D53E", "\U0001D53E"}, {"\U0001D540", "\U0001D540"}, {"\U0001D541", "\U0001D541"},
    {"\U0001D542", "\U0001D542"}, {"\U0001D543", "\U0001D543"}, {"\U0001D544", "\U0001D544"},
    {"\U0001D546", "\U0001D546"}, {"\U0001D54A", "\U0001D54A"}, {"\U0001D54B", "\U0001D54B"},
    {"\U0001D54C", "\U0001D54C"}, {"\U0001D54D", "\U0001D54D"}, {"\U0001D54E", "\U0001D54E"},
    {"\U0001D54F", "\U0001D54F"}, {"\U0001D550", "\U0001D550"}, {"\U0001D552", "\U0001D552"},
    {"\U0001D553", "\U0001D553"}, {"\U0001D554", "\U0001D554"}, {"\U0001D555", "\U0001D555"},
    {"\U0001D556", "\U0001D556"}, {"\U0001D557", "\U0001D557"}, {"\U0001D558", "\U0001D558"},
    {"\U0001D559", "\U0001D559"}, {"\U0001D55A", "\U0001D55A"}, {"\U0001D55B", "\U0001D55B"},
    {"\U0001D55C", "\U0001D55C"}, {"\U0001D55D", "\U0001D55D"}, {"\U0001D55E", "\U0001D55E"},
    {"\U0001D55F", "\U0001D55F"}, {"\U0001D560", "\U0001D560"}, {"\U0001D561", "\U0001D561"},
    {"\U0001D562", "\U0001D562"}, {"\U0001D563", "\U0001D563"}, {"\U0001D564", "\U0001D564"},
    {"\U0001D565", "\U0001D565"}, {"\U0001D566", "\U0001D566"}, {"\U0001D567", "\U0001D567"},
    {"\U0001D568", "\U0001D568"}, {"\U0001D569", "\U0001D569"}, {"\U0001D56A", "\U0001D56A"},
    {"\U0001D56B", "\U0001D56B"}, {"\U0001D56C", "\U0001D56C"}, {"\U0001D56D", "\U0001D56D"},
    {"\U0001D56E", "\U0001D56E"}, {"\U0001D56F", "\U0001D56F"}, {"\U0001D570", "\U0001D570"},
    {"\U0001D571", "\U0001D571"}, {"\U0001D572", "\U0001D572"}, {"\U0001D573", "\U0001D573"},
    {"\U0001D574", "\U0001D574"}, {"\U0001D575", "\U0001D575"}, {"\U0001D576", "\U0001D576"},
    {"\U0001D577", "\U0001D577"}, {"\U0001D578", "\U0001D578"}, {"\U0001D579", "\U0001D579"},
    {"\U0001D57A", "\U0001D57A"}, {"\U0001D57B", "\U0001D57B"}, {"\U0001D57C", "\U0001D57C"},
    {"\U0001D57D", "\U0001D57D"}, {"\U0001D57E", "\U0001D57E"}, {"\U0001D57F", "\U0001D57F"},
    {"\U0001D580", "\U0001D580"}, {"\U0001D581", "\U0001D581"}, {"\U0001D582", "\U0001D582"},
    {"\U0001D583", "\U0001D583"}, {"\U0001D584", "\U0001D584"}, {"\U0001D585", "\U0001D585"},
    {"\U0001D586", "\U0001D586"}, {"\U0001D587", "\U0001D587"}, {"\U0001D588", "\U0001D588"},
    {"\U0001D589", "\U0001D589"}, {"\U0001D58A", "\U0001D58A"}, {"\U0001D58B", "\U0001D58B"},
    {"\U0001D58C", "\U0001D58C"}, {"\U0001D58D", "\U0001D58D"}, {"\U0001D58E", "\U0001D58E"},
    {"\U0001D58F", "\U0001D58F"}, {"\U0001D590", "\U0001D590"}, {"\U0001D591", "\U0001D591"},
    {"\U0001D592", "\U0001D592"}, {"\U0001D593", "\U0001D593"}, {"\U0001D594", "\U0001D594"},
    {"\U0001D595", "\U0001D595"}, {"\U0001D596", "\U0001D596"}, {"\U0001D597", "\U0001D597"},
    {"\U0001D598", "\U0001D598"}, {"\U0001D599", "\U0001D599"}, {"\U0001D59A", "\U0001D59A"},
    {"\U0001D59B", "\U0001D59B"}, {"\U0001D59C", "\U0001D59C"}, {"\U0001D59D", "\U0001D59D"},
    {"\U0001D59E", "\U0001D59E"}, {"\U0001D59F", "\U0001D59F"}, {"\U0001D5A0", "\U0001D5A0"},
    {"\U0001D5A1", "\U0001D5A1"}, {"\U0001D5A2", "\U0001D5A2"}, {"\U0001D5A3", "\U0001D5A3"},
    {"\U0001D5A4", "\U0001D5A4"}, {"\U0001D5A5", "\U0001D5A5"}, {"\U0001D5A6", "\U0001D5A6"},
    {"\U0001D5A7", "\U0001D5A7"}, {"\U0001D5A8", "\U0001D5A8"}, {"\U0001D5A9", "\U0001D5A9"},
    {"\U0001D5AA", "\U0001D5AA"}, {"\U0001D5AB", "\U0001D5AB"}, {"\U0001D5AC", "\U0001D5AC"},
    {"\U0001D5AD", "\U0001D5AD"}, {"\U0001D5AE", "\U0001D5AE"}, {"\U0001D5AF", "\U0001D5AF"},
    {"\U0001D5B0", "\U0001D5B0"}, {"\U0001D5B1", "\U0001D5B1"}, {"\U0001D5B2", "\U0001D5B2"},
    {"\U0001D5B3", "\U0001D5B3"}, {"\U0001D5B4", "\U0001D5B4"}, {"\U0001D5B5", "\U0001D5B5"},
    {"\U0001D5B6", "\U0001D5B6"}, {"\U0001D5B7", "\U0001D5B7"}, {"\U0001D5B8", "\U0001D5B8"},
    {"\U0001D5B9", "\U0001D5B9"}, {"\U0001D5BA", "\U0001D5BA"}, {"\U0001D5BB", "\U0001D5BB"},
    {"\U0001D5BC", "\U0001D5BC"}, {"\U0001D5BD", "\U0001D5BD"}, {"\U0001D5BE", "\U0001D5BE"},
    {"\U0001D5BF", "\U0001D5BF"}, {"\U0001D5C0", "\U0001D5C0"}, {"\U0001D5C1", "\U0001D5C1"},
    {"\U0001D5C2", "\U0001D5C2"}, {"\U0001D5C3", "\U0001D5C3"}, {"\U0001D5C4", "\U0001D5C4"},
    {"\U0001D5C5", "\U0001D5C5"}, {"\U0001D5C6", "\U0001D5C6"}, {"\U0001D5C7", "\U0001D5C7"},
    {"\U0001D5C8", "\U0001D5C8"}, {"\U0001D5C9", "\U0001D5C9"}, {"\U0001D5CA", "\U0001D5CA"},
    {"\U0001D5CB", "\U0001D5CB"}, {"\U0001D5CC", "\U0001D5CC"}, {"\U0001D5CD", "\U0001D5CD"},
    {"\U0001D5CE", "\U0001D5CE"}, {"\U0001D5CF", "\U0001D5CF"}, {"\U0001D5D0", "\U0001D5D0"},
    {"\U0001D5D1", "\U0001D5D1"}, {"\U0001D5D2", "\U0001D5D2"}, {"\U0001D5D3", "\U0001D5D3"},
    {"\U0001D5D4", "\U0001D5D4"}, {"\U0001D5D5", "\U0001D5D5"}, {"\U0001D5D6", "\U0001D5D6"},
    {"\U0001D5D7", "\U0001D5D7"}, {"\U0001D5D8", "\U0001D5D8"}, {"\U0001D5D9", "\U0001D5D9"},
    {"\U0001D5DA", "\U0001D5DA"}, {"\U0001D5DB", "\U0001D5DB"}, {"\U0001D5DC", "\U0001D5DC"},
    {"\U0001D5DD", "\U0001D5DD"}, {"\U0001D5DE", "\U0001D5DE"}, {"\U0001D5DF", "\U0001D5DF"},
    {"\U0001D5E0", "\U0001D5E0"}, {"\U0001D5E1", "\U0001D5E1"}, {"\U0001D5E2", "\U0001D5E2"},
    {"\U0001D5E3", "\U0001D5E3"}, {"\U0001D5E4", "\U0001D5E4"}, {"\U0001D5E5", "\U0001D5E5"},
    {"\U0001D5E6", "\U0001D5E6"}, {"\U0001D5E7", "\U0001D5E7"}, {"\U0001D5E8", "\U0001D5E8"},
    {"\U0001D5E9", "\U0001D5E9"}, {"\U0001D5EA", "\U0001D5EA"}, {"\U0001D5EB", "\U0001D5EB"},
    {"\U0001D5EC", "\U0001D5EC"}, {"\U0001D5ED", "\U0001D5ED"}, {"\U0001D5EE", "\U0001D5EE"},
    {"\U0001D5EF", "\U0001D5EF"}, {"\U0001D5F0", "\U0001D5F0"}, {"\U0001D5F1", "\U0001D5F1"},
    {"\U0001D5F2", "\U0001D5F2"}, {"\U0001D5F3", "\U0001D5F3"}, {"\U0001D5F4", "\U0001D5F4"},
    {"\U0001D5F5", "\U0001D5F5"}, {"\U0001D5F6", "\U0001D5F6"}, {"\U0001D5F7", "\U0001D5F7"},
    {"\U0001D5F8", "\U0001D5F8"}, {"\U0001D5F9", "\U0001D5F9"}, {"\U0001D5FA", "\U0001D5FA"},
    {"\U0001D5FB", "\U0001D5FB"}, {"\U0001D5FC", "\U0001D5FC"}, {"\U0001D5FD", "\U0001D5FD"},
    {"\U0001D5FE", "\U0001D5FE"}, {"\U0001D5FF", "\U0001D5FF"}, {"\U0001D600", "\U0001D600"},
    {"\U0001D601", "\U0001D601"}, {"\U0001D602", "\U0001D602"}, {"\U0001D603", "\U0001D603"},
    {"\U0001D604", "\U0001D604"}, {"\U0001D605", "\U0001D605"}, {"\U0001D606", "\U0001D606"},
    {"\U0001D607", "\U0001D607"}, {"\U0001D608", "\U0001D608"}, {"\U0001D609", "\U0001D609"},
    {"\U0001D60A", "\U0001D60A"}, {"\U0001D60B", "\U0001D60B"}, {"\U0001D60C", "\U0001D60C"},
    {"\U0001D60D", "\U0001D60D"}, {"\U0001D60E", "\U0001D60E"}, {"\U0001D60F", "\U0001D60F"},
    {"\U0001D610", "\U0001D610"}, {"\U0001D611", "\U0001D611"}, {"\U0001D612", "\U0001D612"},
    {"\U0001D613", "\U0001D613"}, {"\U0001D614", "\U0001D614"}, {"\U0001D615", "\U0001D615"},
    {"\U0001D616", "\U0001D616"}, {"\U0001D617", "\U0001D617"}, {"\U0001D618", "\U0001D618"},
    {"\U0001D619", "\U0001D619"}, {"\U0001D61A", "\U0001D61A"}, {"\U0001D61B", "\U0001D61B"},
    {"\U0001D61C", "\U0001D61C"}, {"\U0001D61D", "\U0001D61D"}, {"\U0001D61E", "\U0001D61E"},
    {"\U0001D61F", "\U0001D61F"}, {"\U0001D620", "\U0001D620"}, {"\U0001D621", "\U0001D621"},
    {"\U0001D622", "\U0001D622"}, {"\U0001D623", "\U0001D623"}, {"\U0001D624", "\U0001D624"},
    {"\U0001D625", "\U0001D625"}, {"\U0001D626", "\U0001D626"}, {"\U0001D627", "\U0001D627"},
    {"\U0001D628", "\U0001D628"}, {"\U0001D629", "\U0001D629"}, {"\U0001D62A", "\U0001D62A"},
    {"\U0001D62B", "\U0001D62B"}, {"\U0001D62C", "\U0001D62C"}, {"\U0001D62D", "\U0001D62D"},
    {"\U0001D62E", "\U0001D62E"}, {"\U0001D62F", "\U0001D62F"}, {"\U0001D630", "\U0001D630"},
    {"\U0001D631", "\U0001D631"}, {"\U0001D632", "\U0001D632"}, {"\U0001D633", "\U0001D633"},
    {"\U0001D634", "\U0001D634"}, {"\U0001D635", "\U0001D635"}, {"\U0001D636", "\U0001D636"},
    {"\U0001D637", "\U0001D637"}, {"\U0001D638", "\U0001D638"}, {"\U0001D639", "\U0001D639"},
    {"\U0001D63A", "\U0001D63A"}, {"\U0001D63B", "\U0001D63B"}, {"\U0001D63C", "\U0001D63C"},
    {"\U0001D63D", "\U0001D63D"}, {"\U0001D63E", "\U0001D63E"}, {"\U0001D63F", "\U0001D63F"},
    {"\U0001D640", "\U0001D640"}, {"\U0001D641", "\U0001D641"}, {"\U0001D642", "\U0001D642"},
    {"\U0001D643", "\U0001D643"}, {"\U0001D644", "\U0001D644"}, {"\U0001D645", "\U0001D645"},
    {"\U0001D646", "\U0001D646"}, {"\U0001D647", "\U0001D647"}, {"\U0001D648", "\U0001D648"},
    {"\U0001D649", "\U0001D649"}, {"\U0001D64A", "\U0001D64A"}, {"\U0001D64B", "\U0001D64B"},
    {"\U0001D64C", "\U0001D64C"}, {"\U0001D64D", "\U0001D64D"}, {"\U0001D64E", "\U0001D64E"},
    {"\U0001D64F", "\U0001D64F"}, {"\U0001D650", "\U0001D650"}, {"\U0001D651", "\U0001D651"},
    {"\U0001D652", "\U0001D652"}, {"\U0001D653", "\U0001D653"}, {"\U0001D654", "\U0001D654"},
    {"\U0001D655", "\U0001D655"}, {"\U0001D656", "\U0001D656"}, {"\U0001D657", "\U0001D657"},
    {"\U0001D658", "\U0001D658"}, {"\U0001D659", "\U0001D659"}, {"\U0001D65A", "\U0001D65A"},
    {"\U0001D65B", "\U0001D65B"}, {"\U0001D65C", "\U0001D65C"}, {"\U0001D65D", "\U0001D65D"},
    {"\U0001D65E", "\U0001D65E"}, {"\U0001D65F", "\U0001D65F"}, {"\U0001D660", "\U0001D660"},
    {"\U0001D661", "\U0001D661"}, {"\U0001D662", "\U0001D662"}, {"\U0001D663", "\U0001D663"},
    {"\U0001D664", "\U0001D664"}, {"\U0001D665", "\U0001D665"}, {"\U0001D666", "\U0001D666"},
    {"\U0001D667", "\U0001D667"}, {"\U0001D668", "\U0001D668"}, {"\U0001D669", "\U0001D669"},
    {"\U0001D66A", "\U0001D66A"}, {"\U0001D66B", "\U0001D66B"}, {"\U0001D66C", "\U0001D66C"},
    {"\U0001D66D", "\U0001D66D"}, {"\U0001D66E", "\U0001D66E"}, {"\U0001D66F", "\U0001D66F"},
    {"\U0001D670", "\U0001D670"}, {"\U0001D671", "\U0001D671"}, {"\U0001D672", "\U0001D672"},
    {"\U0001D673", "\U0001D673"}, {"\U0001D674", "\U0001D674"}, {"\U0001D675", "\U0001D675"},
    {"\U0001D676", "\U0001D676"}, {"\U0001D677", "\U0001D677"}, {"\U0001D678", "\U0001D678"},
    {"\U0001D679", "\U0001D679"}, {"\U0001D67A", "\U0001D67A"}, {"\U0001D67B", "\U0001D67B"},
    {"\U0001D67C", "\U0001D67C"}, {"\U0001D67D", "\U0001D67D"}, {"\U0001D67E", "\U0001D67E"},
    {"\U0001D67F", "\U0001D67F"}, {"\U0001D680", "\U0001D680"}, {"\U0001D681", "\U0001D681"},
    {"\U0001D682", "\U0001D682"}, {"\U0001D683", "\U0001D683"}, {"\U0001D684", "\U0001D684"},
    {"\U0001D685", "\U0001D685"}, {"\U0001D686", "\U0001D686"}, {"\U0001D687", "\U0001D687"},
    {"\U0001D688", "\U0001D688"}, {"\U0001D689", "\U0001D689"}, {"\U0001D68A", "\U0001D68A"},
    {"\U0001D68B", "\U0001D68B"}, {"\U0001D68C", "\U0001D68C"}, {"\U0001D68D", "\U0001D68D"},
    {"\U0001D68E", "\U0001D68E"}, {"\U0001D68F", "\U0001D68F"}, {"\U0001D690", "\U0001D690"},
    {"\U0001D691", "\U0001D691"}, {"\U0001D692", "\U0001D692"}, {"\U0001D693", "\U0001D693"},
    {"\U0001D694", "\U0001D694"}, {"\U0001D695", "\U0001D695"}, {"\U0001D696", "\U0001D696"},
    {"\U0001D697", "\U0001D697"}, {"\U0001D698", "\U0001D698"}, {"\U0001D699", "\U0001D699"},
    {"\U0001D69A", "\U0001D69A"}, {"\U0001D69B", "\U0001D69B"}, {"\U0001D69C", "\U0001D69C"},
    {"\U0001D69D", "\U0001D69D"}, {"\U0001D69E", "\U0001D69E"}, {"\U0001D69F", "\U0001D69F"},
    {"\U0001D6A0", "\U0001D6A0"}, {"\U0001D6A1", "\U0001D6A1"}, {"\U0001D6A2", "\U0001D6A2"},
    {"\U0001D6A3", "\U0001D6A3"}, {"\U0001D6A4", "\U0001D6A4"}, {"\U0001D6A5", "\U0001D6A5"},
    {"\U0001D6A8", "\U0001D6A8"}, {"\U0001D6A9", "\U0001D6A9"}, {"\U0001D6AA", "\U0001D6AA"},
    {"\U0001D6AB", "\U0001D6AB"}, {"\U0001D6AC", "\U0001D6AC"}, {"\U0001D6AD", "\U0001D6AD"},
    {"\U0001D6AE", "\U0001D6AE"}, {"\U0001D6AF", "\U0001D6AF"}, {"\U0001D6B0", "\U0001D6B0"},
    {"\U0001D6B1", "\U0001D6B1"}, {"\U0001D6B2", "\U0001D6B2"}, {"\U0001D6B3", "\U0001D6B3"},
    {"\U0001D6B4", "\U0001D6B4"}, {"\U0001D6B5", "\U0001D6B5"}, {"\U0001D6B6", "\U0001D6B6"},
    {"\U0001D6B7", "\U0001D6B7"}, {"\U0001D6B8", "\U0001D6B8"}, {"\U0001D6B9", "\U0001D6B9"},
    {"\U0001D6BA", "\U0001D6BA"}, {"\U0001D6BB", "\U0001D6BB"}, {"\U0001D6BC", "\U0001D6BC"},
    {"\U0001D6BD", "\U0001D6BD"}, {"\U0001D6BE", "\U0001D6BE"}, {"\U0001D6BF", "\U0001D6BF"},
    {"\U0001D6C0", "\U0001D6C0"}, {"\U0001D6C1", "\U0001D6C1"}, {"\U0001D6C2", "\U0001D6C2"},
    {"\U0001D6C3", "\U0001D6C3"}, {"\U0001D6C4", "\U0001D6C4"}, {"\U0001D6C5", "\U0001D6C5"},
    {"\U0001D6C6", "\U0001D6C6"}, {"\U0001D6C7", "\U0001D6C7"}, {"\U0001D6C8", "\U0001D6C8"},
    {"\U0001D6C9", "\U0001D6C9"}, {"\U0001D6CA", "\U0001D6CA"}, {"\U0001D6CB", "\U0001D6CB"},
    {"\U0001D6CC", "\U0001D6CC"}, {"\U0001D6CD", "\U0001D6CD"}, {"\U0001D6CE", "\U0001D6CE"},
    {"\U0001D6CF", "\U0001D6CF"}, {"\U0001D6D0", "\U0001D6D0"}, {"\U0001D6D1", "\U0001D6D1"},
    {"\U0001D6D2", "\U0001D6D2"}, {"\U0001D6D3", "\U0001D6D3"}, {"\U0001D6D4", "\U0001D6D4"},
    {"\U0001D6D5", "\U0001D6D5"}, {"\U0001D6D6", "\U0001D6D6"}, {"\U0001D6D7", "\U0001D6D7"},
    {"\U0001D6D8", "\U0001D6D8"}, {"\U0001D6D9", "\U0001D6D9"}, {"\U0001D6DA", "\U0001D6DA"},
    {"\U0001D6DB", "\U0001D6DB"}, {"\U0001D6DC", "\U0001D6DC"}, {"\U0001D6DD", "\U0001D6DD"},
    {"\U0001D6DE", "\U0001D6DE"}, {"\U0001D6DF", "\U0001D6DF"}, {"\U0001D6E0", "\U0001D6E0"},
    {"\U0001D6E1", "\U0001D6E1"}, {"\U0001D6E2", "\U0001D6E2"}, {"\U0001D6E3", "\U0001D6E3"},
    {"\U0001D6E4", "\U0001D6E4"}, {"\U0001D6E5", "\U0001D6E5"}, {"\U0001D6E6", "\U0001D6E6"},
    {"\U0001D6E7", "\U0001D6E7"}, {"\U0001D6E8", "\U0001D6E8"}, {"\U0001D6E9", "\U0001D6E9"},
    {"\U0001D6EA", "\U0001D6EA"}, {"\U0001D6EB", "\U0001D6EB"}, {"\U0001D6EC", "\U0001D6EC"},
    {"\U0001D6ED", "\U0001D6ED"}, {"\U0001D6EE", "\U0001D6EE"}, {"\U0001D6EF", "\U0001D6EF"},
    {"\U0001D6F0", "\U0001D6F0"}, {"\U0001D6F1", "\U0001D6F1"}, {"\U0001D6F2", "\U0001D6F2"},
    {"\U0001D6F3", "\U0001D6F3"}, {"\U0001D6F4", "\U0001D6F4"}, {"\U0001D6F5", "\U0001D6F5"},
    {"\U0001D6F6", "\U0001D6F6"}, {"\U0001D6F7", "\U0001D6F7"}, {"\U0001D6F8", "\U0001D6F8"},
    {"\U0001D6F9", "\U0001D6F9"}, {"\U0001D6FA", "\U0001D6FA"}, {"\U0001D6FB", "\U0001D6FB"},
    {"\U0001D6FC", "\U0001D6FC"}, {"\U0001D6FD", "\U0001D6FD"}, {"\U0001D6FE", "\U0001D6FE"},
    {"\U0001D6FF", "\U0001D6FF"}, {"\U0001D700", "\U0001D700"}, {"\U0001D701", "\U0001D701"},
    {"\U0001D702", "\U0001D702"}, {"\U0001D703", "\U0001D703"}, {"\U0001D704", "\U0001D704"},
    {"\U0001D705", "\U0001D705"}, {"\U0001D706", "\U0001D706"}, {"\U0001D707", "\U0001D707"},
    {"\U0001D708", "\U0001D708"}, {"\U0001D709", "\U0001D709"}, {"\U0001D70A", "\U0001D70A"},
    {"\U0001D70B", "\U0001D70B"}, {"\U0001D70C", "\U0001D70C"}, {"\U0001D70D", "\U0001D70D"},
    {"\U0001D70E", "\U0001D70E"}, {"\U0001D70F", "\U0001D70F"}, {"\U0001D710", "\U0001D710"},
    {"\U0001D711", "\U0001D711"}, {"\U0001D712", "\U0001D712"}, {"\U0001D713", "\U0001D713"},
    {"\U0001D714", "\U0001D714"}, {"\U0001D715", "\U0001D715"}, {"\U0001D716", "\U0001D716"},
    {"\U0001D717", "\U0001D717"}, {"\U0001D718", "\U0001D718"}, {"\U0001D719", "\U0001D719"},
    {"\U0001D71A", "\U0001D71A"}, {"\U0001D71B", "\U0001D71B"}, {"\U0001D71C", "\U0001D71C"},
    {"\U0001D71D", "\U0001D71D"}, {"\U0001D71E", "\U0001D71E"}, {"\U0001D71F", "\U0001D71F"},
    {"\U0001D720", "\U0001D720"}, {"\U0001D721", "\U0001D721"}, {"\U0001D722", "\U0001D722"},
    {"\U0001D723", "\U0001D723"}, {"\U0001D724", "\U0001D724"}, {"\U0001D725", "\U0001D725"},
    {"\U0001D726", "\U0001D726"}, {"\U0001D727", "\U0001D727"}, {"\U0001D728", "\U0001D728"},
    {"\U0001D729", "\U0001D729"}, {"\U0001D72A", "\U0001D72A"}, {"\U0001D72B", "\U0001D72B"},
    {"\U0001D72C", "\U0001D72C"}, {"\U0001D72D", "\U0001D72D"}, {"\U0001D72E", "\U0001D72E"},
    {"\U0001D72F", "\U0001D72F"}, {"\U0001D730", "\U0001D730"}, {"\U0001D731", "\U0001D731"},
    {"\U0001D732", "\U0001D732"}, {"\U0001D733", "\U0001D733"}, {"\U0001D734", "\U0001D734"},
    {"\U0001D735", "\U0001D735"}, {"\U0001D736", "\U0001D736"}, {"\U0001D737", "\U0001D737"},
    {"\U0001D738", "\U0001D738"}, {"\U0001D739", "\U0001D739"}, {"\U0001D73A", "\U0001D73A"},
    {"\U0001D73B", "\U0001D73B"}, {"\U0001D73C", "\U0001D73C"}, {"\U0001D73D", "\U0001D73D"},
    {"\U0001D73E", "\U0001D73E"}, {"\U0001D73F", "\U0001D73F"}, {"\U0001D740", "\U0001D740"},
    {"\U0001D741", "\U0001D741"}, {"\U0001D742", "\U0001D742"}, {"\U0001D743", "\U0001D743"},
    {"\U0001D744", "\U0001D744"}, {"\U0001D745", "\U0001D745"}, {"\U0001D746", "\U0001D746"},
    {"\U0001D747", "\U0001D747"}, {"\U0001D748", "\U0001D748"}, {"\U0001D749", "\U0001D749"},
    {"\U0001D74A", "\U0001D74A"}, {"\U0001D74B", "\U0001D74B"}, {"\U0001D74C", "\U0001D74C"},
    {"\U0001D74D", "\U0001D74D"}, {"\U0001D74E", "\U0001D74E"}, {"\U0001D74F", "\U0001D74F"},
    {"\U0001D750", "\U0001D750"}, {"\U0001D751", "\U0001D751"}, {"\U0001D752", "\U0001D752"},
    {"\U0001D753", "\U0001D753"}, {"\U0001D754", "\U0001D754"}, {"\U0001D755", "\U0001D755"},
    {"\U0001D756", "\U0001D756"}, {"\U0001D757", "\U0001D757"}, {"\U0001D758", "\U0001D758"},
    {"\U0001D759", "\U0001D759"}, {"\U0001D75A", "\U0001D75A"}, {"\U0001D75B", "\U0001D75B"},
    {"\U0001D75C", "\U0001D75C"}, {"\U0001D75D", "\U0001D75D"}, {"\U0001D75E", "\U0001D75E"},
    {"\U0001D75F", "\U0001D75F"}, {"\U0001D760", "\U0001D760"}, {"\U0001D761", "\U0001D761"},
    {"\U0001D762", "\U0001D762"}, {"\U0001D763", "\U0001D763"}, {"\U0001D764", "\U0001D764"},
    {"\U0001D765", "\U0001D765"}, {"\U0001D766", "\U0001D766"}, {"\U0001D767", "\U0001D767"},
    {"\U0001D768", "\U0001D768"}, {"\U0001D769", "\U0001D769"}, {"\U0001D76A", "\U0001D76A"},
    {"\U0001D76B", "\U0001D76B"}, {"\U0001D76C", "\U0001D76C"}, {"\U0001D76D", "\U0001D76D"},
    {"\U0001D76E", "\U0001D76E"}, {"\U0001D76F", "\U0001D76F"}, {"\U0001D770", "\U0001D770"},
    {"\U0001D771", "\U0001D771"}, {"\U0001D772", "\U0001D772"}, {"\U0001D773", "\U0001D773"},
    {"\U0001D774", "\U0001D774"}, {"\U0001D775", "\U0001D775"}, {"\U0001D776", "\U0001D776"},
    {"\U0001D777", "\U0001D777"}, {"\U0001D778", "\U0001D778"}, {"\U0001D779", "\U0001D779"},
    {"\U0001D77A", "\U0001D77A"}, {"\U0001D77B", "\U0001D77B"}, {"\U0001D77C", "\U0001D77C"},
    {"\U0001D77D", "\U0001D77D"}, {"\U0001D77E", "\U0001D77E"}, {"\U0001D77F", "\U0001D77F"},
    {"\U0001D780", "\U0001D780"}, {"\U0001D781", "\U0001D781"}, {"\U0001D782", "\U0001D782"},
    {"\U0001D783", "\U0001D783"}, {"\U0001D784", "\U0001D784"}, {"\U0001D785", "\U0001D785"},
    {"\U0001D786", "\U0001D786"}, {"\U0001D787", "\U0001D787"}, {"\U0001D788", "\U0001D788"},
    {"\U0001D789", "\U0001D789"}, {"\U0001D78A", "\U0001D78A"}, {"\U0001D78B", "\U0001D78B"},
    {"\U0001D78C", "\U0001D78C"}, {"\U0001D78D", "\U0001D78D"}, {"\U0001D78E", "\U0001D78E"},
    {"\U0001D78F", "\U0001D78F"}, {"\U0001D790", "\U0001D790"}, {"\U0001D791", "\U0001D791"},
    {"\U0001D792", "\U0001D792"}, {"\U0001D793", "\U0001D793"}, {"\U0001D794", "\U0001D794"},
    {"\U0001D795", "\U0001D795"}, {"\U0001D796", "\U0001D796"}, {"\U0001D797", "\U0001D797"},
    {"\U0001D798", "\U0001D798"}, {"\U0001D799", "\U0001D799"}, {"\U0001D79A", "\U0001D79A"},
    {"\U0001D79B", "\U0001D79B"}, {"\U0001D79C", "\U0001D79C"}, {"\U0001D79D", "\U0001D79D"},
    {"\U0001D79E", "\U0001D79E"}, {"\U0001D79F", "\U0001D79F"}, {"\U0001D7A0", "\U0001D7A0"},
    {"\U0001D7A1", "\U0001D7A1"}, {"\U0001D7A2", "\U0001D7A2"}, {"\U0001D7A3", "\U0001D7A3"},
    {"\U0001D7A4", "\U0001D7A4"}, {"\U0001D7A5", "\U0001D7A5"}, {"\U0001D7A6", "\U0001D7A6"},
    {"\U0001D7A7", "\U0001D7A7"}, {"\U0001D7A8", "\U0001D7A8"}, {"\U0001D7A9", "\U0001D7A9"},
    {"\U0001D7AA", "\U0001D7AA"}, {"\U0001D7AB", "\U0001D7AB"}, {"\U0001D7AC", "\U0001D7AC"},
    {"\U0001D7AD", "\U0001D7AD"}, {"\U0001D7AE", "\U0001D7AE"}, {"\U0001D7AF", "\U0001D7AF"},
    {"\U0001D7B0", "\U0001D7B0"}, {"\U0001D7B1", "\U0001D7B1"}, {"\U0001D7B2", "\U0001D7B2"},
    {"\U0001D7B3", "\U0001D7B3"}, {"\U0001D7B4", "\U0001D7B4"}, {"\U0001D7B5", "\U0001D7B5"},
    {"\U0001D7B6", "\U0001D7B6"}, {"\U0001D7B7", "\U0001D7B7"}, {"\U0001D7B8", "\U0001D7B8"},
    {"\U0001D7B9", "\U0001D7B9"}, {"\U0001D7BA", "\U0001D7BA"}, {"\U0001D7BB", "\U0001D7BB"},
    {"\U0001D7BC", "\U0001D7BC"}, {"\U0001D7BD", "\U0001D7BD"}, {"\U0001D7BE", "\U0001D7BE"},
    {"\U0001D7BF", "\U0001D7BF"}, {"\U0001D7C0", "\U0001D7C0"}, {"\U0001D7C1", "\U0001D7C1"},
    {"\U0001D7C2", "\U0001D7C2"}, {"\U0001D7C3", "\U0001D7C3"}, {"\U0001D7C4", "\U0001D7C4"},
    {"\U0001D7C5", "\U0001D7C5"}, {"\U0001D7C6", "\U0001D7C6"}, {"\U0001D7C7", "\U0001D7C7"},
    {"\U0001D7C8", "\U0001D7C8"}, {"\U0001D7C9", "\U0001D7C9"}, {"\U0001D7CA", "\U0001D7CA"},
    {"\U0001D7CB", "\U0001D7CB"}, {"\U0001D7CE", "\U0001D7CE"}, {"\U0001D7CF", "\U0001D7CF"},
    {"\U0001D7D0", "\U0001D7D0"}, {"\U0001D7D1", "\U0001D7D1"}, {"\U0001D7D2", "\U0001D7D2"},
    {"\U0001D7D3", "\U0001D7D3"}, {"\U0001D7D4", "\U0001D7D4"}, {"\U0001D7D5", "\U0001D7D5"},
    {"\U0001D7D6", "\U0001D7D6"}, {"\U0001D7D7", "\U0001D7D7"}, {"\U0001D7D8", "\U0001D7D8"},
    {"\U0001D7D9", "\U0001D7D9"}, {"\U0001D7DA", "\U0001D7DA"}, {"\U0001D7DB", "\U0001D7DB"},
    {"\U0001D7DC", "\U0001D7DC"}, {"\U0001D7DD", "\U0001D7DD"}, {"\U0001D7DE", "\U0001D7DE"},
    {"\U0001D7DF", "\U0001D7DF"}, {"\U0001D7E0", "\U0001D7E0"}, {"\U0001D7E1", "\U0001D7E1"},
    {"\U0001D7E2", "\U0001D7E2"}, {"\U0001D7E3", "\U0001D7E3"}, {"\U0001D7E4", "\U0001D7E4"},
    {"\U0001D7E5", "\U0001D7E5"}, {"\U0001D7E6", "\U0001D7E6"}, {"\U0001D7E7", "\U0001D7E7"},
    {"\U0001D7E8", "\U0001D7E8"}, {"\U0001D7E9", "\U0001D7E9"}, {"\U0001D7EA", "\U0001D7EA"},
    {"\U0001D7EB", "\U0001D7EB"}, {"\U0001D7EC", "\U0001D7EC"}, {"\U0001D7ED", "\U0001D7ED"},
    {"\U0001D7EE", "\U0001D7EE"}, {"\U0001D7EF", "\U0001D7EF"}, {"\U0001D7F0", "\U0001D7F0"},
    {"\U0001D7F1", "\U0001D7F1"}, {"\U0001D7F2", "\U0001D7F2"}, {"\U0001D7F3", "\U0001D7F3"},
    {"\U0001D7F4", "\U0001D7F4"}, {"\U0001D7F5", "\U0001D7F5"}, {"\U0001D7F6", "\U0001D7F6"},
    {"\U0001D7F7", "\U0001D7F7"}, {"\U0001D7F8", "\U0001D7F8"}, {"\U0001D7F9", "\U0001D7F9"},
    {"\U0001D7FA", "\U0001D7FA"}, {"\U0001D7FB", "\U0001D7FB"}, {"\U0001D7FC", "\U0001D7FC"},
    {"\U0001D7FD", "\U0001D7FD"}, {"\U0001D7FE", "\U0001D7FE"}, {"\U0001D7FF", "\U0001D7FF"},
    {"\U0001E030", "\U0001E030"}, {"\U0001E031", "\U0001E031"}, {"\U0001E032", "\U0001E032"},
    {"\U0001E033", "\U0001E033"}, {"\U0001E034", "\U0001E034"}, {"\U0001E035", "\U0001E035"},
    {"\U0001E036", "\U0001E036"}, {"\U0001E037", "\U0001E037"}, {"\U0001E038", "\U0001E038"},
    {"\U0001E039", "\U0001E039"}, {"\U0001E03A", "\U0001E03A"}, {"\U0001E03B", "\U0001E03B"},
    {"\U0001E03C", "\U0001E03C"}, {"\U0001E03D", "\U0001E03D"}, {"\U0001E03E", "\U0001E03E"},
    {"\U0001E03F", "\U0001E03F"}, {"\U0001E040", "\U0001E040"}, {"\U0001E041", "\U0001E041"},
    {"\U0001E042", "\U0001E042"}, {"\U0001E043", "\U0001E043"}, {"\U0001E044", "\U0001E044"},
    {"\U0001E045", "\U0001E045"}, {"\U0001E046", "\U0001E046"}, {"\U0001E047", "\U0001E047"},
    {"\U0001E048", "\U0001E048"}, {"\U0001E049", "\U0001E049"}, {"\U0001E04A", "\U0001E04A"},
    {"\U0001E04B", "\U0001E04B"}, {"\U0001E04C", "\U0001E04C"}, {"\U0001E04D", "\U0001E04D"},
    {"\U0001E04E", "\U0001E04E"}, {"\U0001E04F", "\U0001E04F"}, {"\U0001E050", "\U0001E050"},
    {"\U0001E051", "\U0001E051"}, {"\U0001E052", "\U0001E052"}, {"\U0001E053", "\U0001E053"},
    {"\U0001E054", "\U0001E054"}, {"\U0001E055", "\U0001E055"}, {"\U0001E056", "\U0001E056"},
    {"\U0001E057", "\U0001E057"}, {"\U0001E058", "\U0001E058"}, {"\U0001E059", "\U0001E059"},
    {"\U0001E05A", "\U0001E05A"}, {"\U0001E05B", "\U0001E05B"}, {"\U0001E05C", "\U0001E05C"},
    {"\U0001E05D", "\U0001E05D"}, {"\U0001E05E", "\U0001E05E"}, {"\U0001E05F", "\U0001E05F"},
    {"\U0001E060", "\U0001E060"}, {"\U0001E061", "\U0001E061"}, {"\U0001E062", "\U0001E062"},
    {"\U0001E063", "\U0001E063"}, {"\U0001E064", "\U0001E064"}, {"\U0001E065", "\U0001E065"},
    {"\U0001E066", "\U0001E066"}, {"\U0001E067", "\U0001E067"}, {"\U0001E068", "\U0001E068"},
    {"\U0001E069", "\U0001E069"}, {"\U0001E06A", "\U0001E06A"}, {"\U0001E06B", "\U0001E06B"},
    {"\U0001E06C", "\U0001E06C"}, {"\U0001E06D", "\U0001E06D"}, {"\U0001EE00", "\U0001EE00"},
    {"\U0001EE01", "\U0001EE01"}, {"\U0001EE02", "\U0001EE02"}, {"\U0001EE03", "\U0001EE03"},
    {"\U0001EE05", "\U0001EE05"}, {"\U0001EE06", "\U0001EE06"}, {"\U0001EE07", "\U0001EE07"},
    {"\U0001EE08", "\U0001EE08"}, {"\U0001EE09", "\U0001EE09"}, {"\U0001EE0A", "\U0001EE0A"},
    {"\U0001EE0B", "\U0001EE0B"}, {"\U0001EE0C", "\U0001EE0C"}, {"\U0001EE0D", "\U0001EE0D"},
    {"\U0001EE0E", "\U0001EE0E"}, {"\U0001EE0F", "\U0001EE0F"}, {"\U0001EE10", "\U0001EE10"},
    {"\U0001EE11", "\U0001EE11"}, {"\U0001EE12", "\U0001EE12"}, {"\U0001EE13", "\U0001EE13"},
    {"\U0001EE14", "\U0001EE14"}, {"\U0001EE15", "\U0001EE15"}, {"\U0001EE16", "\U0001EE16"},
    {"\U0001EE17", "\U0001EE17"}, {"\U0001EE18", "\U0001EE18"}, {"\U0001EE19", "\U0001EE19"},
    {"\U0001EE1A", "\U0001EE1A"}, {"\U0001EE1B", "\U0001EE1B"}, {"\U0001EE1C", "\U0001EE1C"},
    {"\U0001EE1D", "\U0001EE1D"}, {"\U0001EE1E", "\U0001EE1E"}, {"\U0001EE1F", "\U0001EE1F"},
    {"\U0001EE21", "\U0001EE21"}, {"\U0001EE22", "\U0001EE22"}, {"\U0001EE24", "\U0001EE24"},
    {"\U0001EE27", "\U0001EE27"}, {"\U0001EE29", "\U0001EE29"}, {"\U0001EE2A", "\U0001EE2A"},
    {"\U0001EE2B", "\U0001EE2B"}, {"\U0001EE2C", "\U0001EE2C"}, {"\U0001EE2D", "\U0001EE2D"},
    {"\U0001EE2E", "\U0001EE2E"}, {"\U0001EE2F", "\U0001EE2F"}, {"\U0001EE30", "\U0001EE30"},
    {"\U0001EE31", "\U0001EE31"}, {"\U0001EE32", "\U0001EE32"}, {"\U0001EE34", "\U0001EE34"},
    {"\U0001EE35", "\U0001EE35"}, {"\U0001EE36", "\U0001EE36"}, {"\U0001EE37", "\U0001EE37"},
    {"\U0001EE39", "\U0001EE39"}, {"\U0001EE3B", "\U0001EE3B"}, {"\U0001EE42", "\U0001EE42"},
    {"\U0001EE47", "\U0001EE47"}, {"\U0001EE49", "\U0001EE49"}, {"\U0001EE4B", "\U0001EE4B"},
    {"\U0001EE4D", "\U0001EE4D"}, {"\U0001EE4E", "\U0001EE4E"}, {"\U0001EE4F", "\U0001EE4F"},
    {"\U0001EE51", "\U0001EE51"}, {"\U0001EE52", "\U0001EE52"}, {"\U0001EE54", "\U0001EE54"},
    {"\U0001EE57", "\U0001EE57"}, {"\U0001EE59", "\U0001EE59"}, {"\U0001EE5B", "\U0001EE5B"},
    {"\U0001EE5D", "\U0001EE5D"}, {"\U0001EE5F", "\U0001EE5F"}, {"\U0001EE61", "\U0001EE61"},
    {"\U0001EE62", "\U0001EE62"}, {"\U0001EE64", "\U0001EE64"}, {"\U0001EE67", "\U0001EE67"},
    {"\U0001EE68", "\U0001EE68"}, {"\U0001EE69", "\U0001EE69"}, {"\U0001EE6A", "\U0001EE6A"},
    {"\U0001EE6C", "\U0001EE6C"}, {"\U0001EE6D", "\U0001EE6D"}, {"\U0001EE6E", "\U0001EE6E"},
    {"\U0001EE6F", "\U0001EE6F"}, {"\U0001EE70", "\U0001EE70"}, {"\U0001EE71", "\U0001EE71"},
    {"\U0001EE72", "\U0001EE72"}, {"\U0001EE74", "\U0001EE74"}, {"\U0001EE75", "\U0001EE75"},
    {"\U0001EE76", "\U0001EE76"}, {"\U0001EE77", "\U0001EE77"}, {"\U0001EE79", "\U0001EE79"},
    {"\U0001EE7A", "\U0001EE7A"}, {"\U0001EE7B", "\U0001EE7B"}, {"\U0001EE7C", "\U0001EE7C"},
    {"\U0001EE7E", "\U0001EE7E"}, {"\U0001EE80", "\U0001EE80"}, {"\U0001EE81", "\U0001EE81"},
    {"\U0001EE82", "\U0001EE82"}, {"\U0001EE83", "\U0001EE83"}, {"\U0001EE84", "\U0001EE84"},
    {"\U0001EE85", "\U0001EE85"}, {"\U0001EE86", "\U0001EE86"}, {"\U0001EE87", "\U0001EE87"},
    {"\U0001EE88", "\U0001EE88"}, {"\U0001EE89", "\U0001EE89"}, {"\U0001EE8B", "\U0001EE8B"},
    {"\U0001EE8C", "\U0001EE8C"}, {"\U0001EE8D", "\U0001EE8D"}, {"\U0001EE8E", "\U0001EE8E"},
    {"\U0001EE8F", "\U0001EE8F"}, {"\U0001EE90", "\U0001EE90"}, {"\U0001EE91", "\U0001EE91"},
    {"\U0001EE92", "\U0001EE92"}, {"\U0001EE93", "\U0001EE93"}, {"\U0001EE94", "\U0001EE94"},
    {"\U0001EE95", "\U0001EE95"}, {"\U0001EE96", "\U0001EE96"}, {"\U0001EE97", "\U0001EE97"},
    {"\U0001EE98", "\U0001EE98"}, {"\U0001EE99", "\U0001EE99"}, {"\U0001EE9A", "\U0001EE9A"},
    {"\U0001EE9B", "\U0001EE9B"}, {"\U0001EEA1", "\U0001EEA1"}, {"\U0001EEA2", "\U0001EEA2"},
    {"\U0001EEA3", "\U0001EEA3"}, {"\U0001EEA5", "\U0001EEA5"}, {"\U0001EEA6", "\U0001EEA6"},
    {"\U0001EEA7", "\U0001EEA7"}, {"\U0001EEA8", "\U0001EEA8"}, {"\U0001EEA9", "\U0001EEA9"},
    {"\U0001EEAB", "\U0001EEAB"}, {"\U0001EEAC", "\U0001EEAC"}, {"\U0001EEAD", "\U0001EEAD"},
    {"\U0001EEAE", "\U0001EEAE"}, {"\U0001EEAF", "\U0001EEAF"}, {"\U0001EEB0", "\U0001EEB0"},
    {"\U0001EEB1", "\U0001EEB1"}, {"\U0001EEB2", "\U0001EEB2"}, {"\U0001EEB3", "\U0001EEB3"},
    {"\U0001EEB4", "\U0001EEB4"}, {"\U0001EEB5", "\U0001EEB5"}, {"\U0001EEB6", "\U0001EEB6"},
    {"\U0001EEB7", "\U0001EEB7"}, {"\U0001EEB8", "\U0001EEB8"}, {"\U0001EEB9", "\U0001EEB9"},
    {"\U0001EEBA", "\U0001EEBA"}, {"\U0001EEBB", "\U0001EEBB"}, {"\U0001F100", "\U0001F100"},
    {"\U0001F101", "\U0001F101"}, {"\U0001F102", "\U0001F102"}, {"\U0001F103", "\U0001F103"},
    {"\U0001F104", "\U0001F104"}, {"\U0001F105", "\U0001F105"}, {"\U0001F106", "\U0001F106"},
    {"\U0001F107", "\U0001F107"}, {"\U0001F108", "\U0001F108"}, {"\U0001F109", "\U0001F109"},
    {"\U0001F10A", "\U0001F10A"}, {"\U0001F110", "\U0001F110"}, {"\U0001F111", "\U0001F111"},
    {"\U0001F112", "\U0001F112"}, {"\U0001F113", "\U0001F113"}, {"\U0001F114", "\U0001F114"},
    {"\U0001F115", "\U0001F115"}, {"\U0001F116", "\U0001F116"}, {"\U0001F117", "\U0001F117"},
    {"\U0001F118", "\U0001F118"}, {"\U0001F119", "\U0001F119"}, {"\U0001F11A", "\U0001F11A"},
    {"\U0001F11B", "\U0001F11B"}, {"\U0001F11C", "\U0001F11C"}, {"\U0001F11D", "\U0001F11D"},
    {"\U0001F11E", "\U0001F11E"}, {"\U0001F11F", "\U0001F11F"}, {"\U0001F120", "\U0001F120"},
    {"\U0001F121", "\U0001F121"}, {"\U0001F122", "\U0001F122"}, {"\U0001F123", "\U0001F123"},
    {"\U0001F124", "\U0001F124"}, {"\U0001F125", "\U0001F125"}, {"\U0001F126", "\U0001F126"},
    {"\U0001F127", "\U0001F127"}, {"\U0001F128", "\U0001F128"}, {"\U0001F129", "\U0001F129"},
    {"\U0001F12A", "\U0001F12A"}, {"\U0001F12B", "\U0001F12B"}, {"\U0001F12C", "\U0001F12C"},
    {"\U0001F12D", "\U0001F12D"}, {"\U0001F12E", "\U0001F12E"}, {"\U0001F130", "\U0001F130"},
    {"\U0001F131", "\U0001F131"}, {"\U0001F132", "\U0001F132"}, {"\U0001F133", "\U0001F133"},
    {"\U0001F134", "\U0001F134"}, {"\U0001F135", "\U0001F135"}, {"\U0001F136", "\U0001F136"},
    {"\U0001F137", "\U0001F137"}, {"\U0001F138", "\U0001F138"}, {"\U0001F139", "\U0001F139"},
    {"\U0001F13A", "\U0001F13A"}, {"\U0001F13B", "\U0001F13B"}, {"\U0001F13C", "\U0001F13C"},
    {"\U0001F13D", "\U0001F13D"}, {"\U0001F13E", "\U0001F13E"}, {"\U0001F13F", "\U0001F13F"},
    {"\U0001F140", "\U0001F140"}, {"\U0001F141", "\U0001F141"}, {"\U0001F142", "\U0001F142"},
    {"\U0001F143", "\U0001F143"}, {"\U0001F144", "\U0001F144"}, {"\U0001F145", "\U0001F145"},
    {"\U0001F146", "\U0001F146"}, {"\U0001F147", "\U0001F147"}, {"\U0001F148", "\U0001F148"},
    {"\U0001F149", "\U0001F149"}, {"\U0001F14A", "\U0001F14A"}, {"\U0001F14B", "\U0001F14B"},
    {"\U0001F14C", "\U0001F14C"}, {"\U0001F14D", "\U0001F14D"}, {"\U0001F14E", "\U0001F14E"},
    {"\U0001F14F", "\U0001F14F"}, {"\U0001F16A", "\U0001F16A"}, {"\U0001F16B", "\U0001F16B"},
    {"\U0001F16C", "\U0001F16C"}, {"\U0001F190", "\U0001F190"}, {"\U0001F200", "\U0001F200"},
    {"\U0001F201", "\U0001F201"}, {"\U0001F202", "\U0001F202"}, {"\U0001F210", "\U0001F210"},
    {"\U0001F211", "\U0001F211"}, {"\U0001F212", "\U0001F212"}, {"\U0001F213", "\U0001F213"},
    {"\U0001F214", "\U0001F214"}, {"\U0001F215", "\U0001F215"}, {"\U0001F216", "\U0001F216"},
    {"\U0001F217", "\U0001F217"}, {"\U0001F218", "\U0001F218"}, {"\U0001F219", "\U0001F219"},
    {"\U0001F21A", "\U0001F21A"}, {"\U0001F21B", "\U0001F21B"}, {"\U0001F21C", "\U0001F21C"},
    {"\U0001F21D", "\U0001F21D"}, {"\U0001F21E", "\U0001F21E"}, {"\U0001F21F", "\U0001F21F"},
    {"\U0001F220", "\U0001F220"}, {"\U0001F221", "\U0001F221"}, {"\U0001F222", "\U0001F222"},
    {"\U0001F223", "\U0001F223"}, {"\U0001F224", "\U0001F224"}, {"\U0001F225", "\U0001F225"},
    {"\U0001F226", "\U0001F226"}, {"\U0001F227", "\U0001F227"}, {"\U0001F228", "\U0001F228"},
    {"\U0001F229", "\U0001F229"}, {"\U0001F22A", "\U0001F22A"}, {"\U0001F22B", "\U0001F22B"},
    {"\U0001F22C", "\U0001F22C"}, {"\U0001F22D", "\U0001F22D"}, {"\U0001F22E", "\U0001F22E"},
    {"\U0001F22F", "\U0001F22F"}, {"\U0001F230", "\U0001F230"}, {"\U0001F231", "\U0001F231"},
    {"\U0001F232", "\U0001F232"}, {"\U0001F233", "\U0001F233"}, {"\U0001F234", "\U0001F234"},
    {"\U0001F235", "\U0001F235"}, {"\U0001F236", "\U0001F236"}, {"\U0001F237", "\U0001F237"},
    {"\U0001F238", "\U0001F238"}, {"\U0001F239", "\U0001F239"}, {"\U0001F23A", "\U0001F23A"},
    {"\U0001F23B", "\U0001F23B"}, {"\U0001F240", "\U0001F240"}, {"\U0001F241", "\U0001F241"},
    {"\U0001F242", "\U0001F242"}, {"\U0001F243", "\U0001F243"}, {"\U0001F244", "\U0001F244"},
    {"\U0001F245", "\U0001F245"}, {"\U0001F246", "\U0001F246"}, {"\U0001F247", "\U0001F247"},
    {"\U0001F248", "\U0001F248"}, {"\U0001F250", "\U0001F250"}, {"\U0001F251", "\U0001F251"},
    {"\U0001FBF0", "\U0001FBF0"}, {"\U0001FBF1", "\U0001FBF1"}, {"\U0001FBF2", "\U0001FBF2"},
    {"\U0001FBF3", "\U0001FBF3"}, {"\U0001FBF4", "\U0001FBF4"}, {"\U0001FBF5", "\U0001FBF5"},
    {"\U0001FBF6", "\U0001FBF6"}, {"\U0001FBF7", "\U0001FBF7"}, {"\U0001FBF8", "\U0001FBF8"},
    {"\U0001FBF9", "\U0001FBF9"}, {"\U0002F800", "\u4E3D"}, {"\U0002F801", "\u4E38"}, {"\U0002F802", "\u4E41"},
    {"\U0002F803", "\U00020122"}, {"\U0002F804", "\u4F60"}, {"\U0002F805", "\u4FAE"}, {"\U0002F806", "\u4FBB"},
    {"\U0002F807", "\u5002"}, {"\U0002F808", "\u507A"}, {"\U0002F809", "\u5099"}, {"\U0002F80A", "\u50E7"},
    {"\U0002F80B", "\u50CF"}, {"\U0002F80C", "\u349E"}, {"\U0002F80D", "\U0002063A"}, {"\U0002F80E", "\u514D"},
    {"\U0002F80F", "\u5154"}, {"\U0002F810", "\u5164"}, {"\U0002F811", "\u5177"}, {"\U0002F812", "\U0002051C"},
    {"\U0002F813", "\u34B9"}, {"\U0002F814", "\u5167"}, {"\U0002F815", "\u518D"}, {"\U0002F816", "\U0002054B"},
    {"\U0002F817", "\u5197"}, {"\U0002F818", "\u51A4"}, {"\U0002F819", "\u4ECC"}, {"\U0002F81A", "\u51AC"},
    {"\U0002F81B", "\u51B5"}, {"\U0002F81C", "\U000291DF"}, {"\U0002F81D", "\u51F5"}, {"\U0002F81E", "\u5203"},
    {"\U0002F81F", "\u34DF"}, {"\U0002F820", "\u523B"}, {"\U0002F821", "\u5246"}, {"\U0002F822", "\u5272"},
    {"\U0002F823", "\u5277"}, {"\U0002F824", "\u3515"}, {"\U0002F825", "\u52C7"}, {"\U0002F826", "\u52C9"},
    {"\U0002F827", "\u52E4"}, {"\U0002F828", "\u52FA"}, {"\U0002F829", "\u5305"}, {"\U0002F82A", "\u5306"},
    {"\U0002F82B", "\u5317"}, {"\U0002F82C", "\u5349"}, {"\U0002F82D", "\u5351"}, {"\U0002F82E", "\u535A"},
    {"\U0002F82F", "\u5373"}, {"\U0002F830", "\u537D"}, {"\U0002F831", "\u537F"}, {"\U0002F832", "\u537F"},
    {"\U0002F833", "\u537F"}, {"\U0002F834", "\U00020A2C"}, {"\U0002F835", "\u7070"}, {"\U0002F836", "\u53CA"},
    {"\U0002F837", "\u53DF"}, {"\U0002F838", "\U00020B63"}, {"\U0002F839", "\u53EB"}, {"\U0002F83A", "\u53F1"},
    {"\U0002F83B", "\u5406"}, {"\U0002F83C", "\u549E"}, {"\U0002F83D", "\u5438"}, {"\U0002F83E", "\u5448"},
    {"\U0002F83F", "\u5468"}, {"\U0002F840", "\u54A2"}, {"\U0002F841", "\u54F6"}, {"\U0002F842", "\u5510"},
    {"\U0002F843", "\u5553"}, {"\U0002F844", "\u5563"}, {"\U0002F845", "\u5584"}, {"\U0002F846", "\u5584"},
    {"\U0002F847", "\u5599"}, {"\U0002F848", "\u55AB"}, {"\U0002F849", "\u55B3"}, {"\U0002F84A", "\u55C2"},
    {"\U0002F84B", "\u5716"}, {"\U0002F84C", "\u5606"}, {"\U0002F84D", "\u5717"}, {"\U0002F84E", "\u5651"},
    {"\U0002F84F", "\u5674"}, {"\U0002F850", "\u5207"}, {"\U0002F851", "\u58EE"}, {"\U0002F852", "\u57CE"},
    {"\U0002F853", "\u57F4"}, {"\U0002F854", "\u580D"}, {"\U0002F855", "\u578B"}, {"\U0002F856", "\u5832"},
    {"\U0002F857", "\u5831"}, {"\U0002F858", "\u58AC"}, {"\U0002F859", "\U000214E4"}, {"\U0002F85A", "\u58F2"},
    {"\U0002F85B", "\u58F7"}, {"\U0002F85C", "\u5906"}, {"\U0002F85D", "\u591A"}, {"\U0002F85E", "\u5922"},
    {"\U0002F85F", "\u5962"}, {"\U0002F860", "\U000216A8"}, {"\U0002F861", "\U000216EA"}, {"\U0002F862", "\u59EC"},
    {"\U0002F863", "\u5A1B"}, {"\U0002F864", "\u5A27"}, {"\U0002F865", "\u59D8"}, {"\U0002F866", "\u5A66"},
    {"\U0002F867", "\u36EE"}, {"\U0002F868", "\u36FC"}, {"\U0002F869", "\u5B08"}, {"\U0002F86A", "\u5B3E"},
    {"\U0002F86B", "\u5B3E"}, {"\U0002F86C", "\U000219C8"}, {"\U0002F86D", "\u5BC3"}, {"\U0002F86E", "\u5BD8"},
    {"\U0002F86F", "\u5BE7"}, {"\U0002F870", "\u5BF3"}, {"\U0002F871", "\U00021B18"}, {"\U0002F872", "\u5BFF"},
    {"\U0002F873", "\u5C06"}, {"\U0002F874", "\u5F53"}, {"\U0002F875", "\u5C22"}, {"\U0002F876", "\u3781"},
    {"\U0002F877", "\u5C60"}, {"\U0002F878", "\u5C6E"}, {"\U0002F879", "\u5CC0"}, {"\U0002F87A", "\u5C8D"},
    {"\U0002F87B", "\U00021DE4"}, {"\U0002F87C", "\u5D43"}, {"\U0002F87D", "\U00021DE6"}, {"\U0002F87E", "\u5D6E"},
    {"\U0002F87F", "\u5D6B"}, {"\U0002F880", "\u5D7C"}, {"\U0002F881", "\u5DE1"}, {"\U0002F882", "\u5DE2"},
    {"\U0002F883", "\u382F"}, {"\U0002F884", "\u5DFD"}, {"\U0002F885", "\u5E28"}, {"\U0002F886", "\u5E3D"},
    {"\U0002F887", "\u5E69"}, {"\U0002F888", "\u3862"}, {"\U0002F889", "\U00022183"}, {"\U0002F88A", "\u387C"},
    {"\U0002F88B", "\u5EB0"}, {"\U0002F88C", "\u5EB3"}, {"\U0002F88D", "\u5EB6"}, {"\U0002F88E", "\u5ECA"},
    {"\U0002F88F", "\U0002A392"}, {"\U0002F890", "\u5EFE"}, {"\U0002F891", "\U00022331"}, {"\U0002F892", "\U00022331"},
    {"\U0002F893", "\u8201"}, {"\U0002F894", "\u5F22"}, {"\U0002F895", "\u5F22"}, {"\U0002F896", "\u38C7"},
    {"\U0002F897", "\U000232B8"}, {"\U0002F898", "\U000261DA"}, {"\U0002F899", "\u5F62"}, {"\U0002F89A", "\u5F6B"},
    {"\U0002F89B", "\u38E3"}, {"\U0002F89C", "\u5F9A"}, {"\U0002F89D", "\u5FCD"}, {"\U0002F89E", "\u5FD7"},
    {"\U0002F89F", "\u5FF9"}, {"\U0002F8A0", "\u6081"}, {"\U0002F8A1", "\u393A"}, {"\U0002F8A2", "\u391C"},
    {"\U0002F8A3", "\u6094"}, {"\U0002F8A4", "\U000226D4"}, {"\U0002F8A5", "\u60C7"}, {"\U0002F8A6", "\u6148"},
    {"\U0002F8A7", "\u614C"}, {"\U0002F8A8", "\u614E"}, {"\U0002F8A9", "\u614C"}, {"\U0002F8AA", "\u617A"},
    {"\U0002F8AB", "\u618E"}, {"\U0002F8AC", "\u61B2"}, {"\U0002F8AD", "\u61A4"}, {"\U0002F8AE", "\u61AF"},
    {"\U0002F8AF", "\u61DE"}, {"\U0002F8B0", "\u61F2"}, {"\U0002F8B1", "\u61F6"}, {"\U0002F8B2", "\u6210"},
    {"\U0002F8B3", "\u621B"}, {"\U0002F8B4", "\u625D"}, {"\U0002F8B5", "\u62B1"}, {"\U0002F8B6", "\u62D4"},
    {"\U0002F8B7", "\u6350"}, {"\U0002F8B8", "\U00022B0C"}, {"\U0002F8B9", "\u633D"}, {"\U0002F8BA", "\u62FC"},
    {"\U0002F8BB", "\u6368"}, {"\U0002F8BC", "\u6383"}, {"\U0002F8BD", "\u63E4"}, {"\U0002F8BE", "\U00022BF1"},
    {"\U0002F8BF", "\u6422"}, {"\U0002F8C0", "\u63C5"}, {"\U0002F8C1", "\u63A9"}, {"\U0002F8C2", "\u3A2E"},
    {"\U0002F8C3", "\u6469"}, {"\U0002F8C4", "\u647E"}, {"\U0002F8C5", "\u649D"}, {"\U0002F8C6", "\u6477"},
    {"\U0002F8C7", "\u3A6C"}, {"\U0002F8C8", "\u654F"}, {"\U0002F8C9", "\u656C"}, {"\U0002F8CA", "\U0002300A"},
    {"\U0002F8CB", "\u65E3"}, {"\U0002F8CC", "\u66F8"}, {"\U0002F8CD", "\u6649"}, {"\U0002F8CE", "\u3B19"},
    {"\U0002F8CF", "\u6691"}, {"\U0002F8D0", "\u3B08"}, {"\U0002F8D1", "\u3AE4"}, {"\U0002F8D2", "\u5192"},
    {"\U0002F8D3", "\u5195"}, {"\U0002F8D4", "\u6700"}, {"\U0002F8D5", "\u669C"}, {"\U0002F8D6", "\u80AD"},
    {"\U0002F8D7", "\u43D9"}, {"\U0002F8D8", "\u6717"}, {"\U0002F8D9", "\u671B"}, {"\U0002F8DA", "\u6721"},
    {"\U0002F8DB", "\u675E"}, {"\U0002F8DC", "\u6753"}, {"\U0002F8DD", "\U000233C3"}, {"\U0002F8DE", "\u3B49"},
    {"\U0002F8DF", "\u67FA"}, {"\U0002F8E0", "\u6785"}, {"\U0002F8E1", "\u6852"}, {"\U0002F8E2", "\u6885"},
    {"\U0002F8E3", "\U0002346D"}, {"\U0002F8E4", "\u688E"}, {"\U0002F8E5", "\u681F"}, {"\U0002F8E6", "\u6914"},
    {"\U0002F8E7", "\u3B9D"}, {"\U0002F8E8", "\u6942"}, {"\U0002F8E9", "\u69A3"}, {"\U0002F8EA", "\u69EA"},
    {"\U0002F8EB", "\u6AA8"}, {"\U0002F8EC", "\U000236A3"}, {"\U0002F8ED", "\u6ADB"}, {"\U0002F8EE", "\u3C18"},
    {"\U0002F8EF", "\u6B21"}, {"\U0002F8F0", "\U000238A7"}, {"\U0002F8F1", "\u6B54"}, {"\U0002F8F2", "\u3C4E"},
    {"\U0002F8F3", "\u6B72"}, {"\U0002F8F4", "\u6B9F"}, {"\U0002F8F5", "\u6BBA"}, {"\U0002F8F6", "\u6BBB"},
    {"\U0002F8F7", "\U00023A8D"}, {"\U0002F8F8", "\U00021D0B"}, {"\U0002F8F9", "\U00023AFA"}, {"\U0002F8FA", "\u6C4E"},
    {"\U0002F8FB", "\U00023CBC"}, {"\U0002F8FC", "\u6CBF"}, {"\U0002F8FD", "\u6CCD"}, {"\U0002F8FE", "\u6C67"},
    {"\U0002F8FF", "\u6D16"}, {"\U0002F900", "\u6D3E"}, {"\U0002F901", "\u6D77"}, {"\U0002F902", "\u6D41"},
    {"\U0002F903", "\u6D69"}, {"\U0002F904", "\u6D78"}, {"\U0002F905", "\u6D85"}, {"\U0002F906", "\U00023D1E"},
    {"\U0002F907", "\u6D34"}, {"\U0002F908", "\u6E2F"}, {"\U0002F909", "\u6E6E"}, {"\U0002F90A", "\u3D33"},
    {"\U0002F90B", "\u6ECB"}, {"\U0002F90C", "\u6EC7"}, {"\U0002F90D", "\U00023ED1"}, {"\U0002F90E", "\u6DF9"},
    {"\U0002F90F", "\u6F6E"}, {"\U0002F910", "\U00023F5E"}, {"\U0002F911", "\U00023F8E"}, {"\U0002F912", "\u6FC6"},
    {"\U0002F913", "\u7039"}, {"\U0002F914", "\u701E"}, {"\U0002F915", "\u701B"}, {"\U0002F916", "\u3D96"},
    {"\U0002F917", "\u704A"}, {"\U0002F918", "\u707D"}, {"\U0002F919", "\u7077"}, {"\U0002F91A", "\u70AD"},
    {"\U0002F91B", "\U00020525"}, {"\U0002F91C", "\u7145"}, {"\U0002F91D", "\U00024263"}, {"\U0002F91E", "\u719C"},
    {"\U0002F91F", "\U000243AB"}, {"\U0002F920", "\u7228"}, {"\U0002F921", "\u7235"}, {"\U0002F922", "\u7250"},
    {"\U0002F923", "\U00024608"}, {"\U0002F924", "\u7280"}, {"\U0002F925", "\u7295"}, {"\U0002F926", "\U00024735"},
    {"\U0002F927", "\U00024814"}, {"\U0002F928", "\u737A"}, {"\U0002F929", "\u738B"}, {"\U0002F92A", "\u3EAC"},
    {"\U0002F92B", "\u73A5"}, {"\U0002F92C", "\u3EB8"}, {"\U0002F92D", "\u3EB8"}, {"\U0002F92E", "\u7447"},
    {"\U0002F92F", "\u745C"}, {"\U0002F930", "\u7471"}, {"\U0002F931", "\u7485"}, {"\U0002F932", "\u74CA"},
    {"\U0002F933", "\u3F1B"}, {"\U0002F934", "\u7524"}, {"\U0002F935", "\U00024C36"}, {"\U0002F936", "\u753E"},
    {"\U0002F937", "\U00024C92"}, {"\U0002F938", "\u7570"}, {"\U0002F939", "\U0002219F"}, {"\U0002F93A", "\u7610"},
    {"\U0002F93B", "\U00024FA1"}, {"\U0002F93C", "\U00024FB8"}, {"\U0002F93D", "\U00025044"}, {"\U0002F93E", "\u3FFC"},
    {"\U0002F93F", "\u4008"}, {"\U0002F940", "\u76F4"}, {"\U0002F941", "\U000250F3"}, {"\U0002F942", "\U000250F2"},
    {"\U0002F943", "\U00025119"}, {"\U0002F944", "\U00025133"}, {"\U0002F945", "\u771E"}, {"\U0002F946", "\u771F"},
    {"\U0002F947", "\u771F"}, {"\U0002F948", "\u774A"}, {"\U0002F949", "\u4039"}, {"\U0002F94A", "\u778B"},
    {"\U0002F94B", "\u4046"}, {"\U0002F94C", "\u4096"}, {"\U0002F94D", "\U0002541D"}, {"\U0002F94E", "\u784E"},
    {"\U0002F94F", "\u788C"}, {"\U0002F950", "\u78CC"}, {"\U0002F951", "\u40E3"}, {"\U0002F952", "\U00025626"},
    {"\U0002F953", "\u7956"}, {"\U0002F954", "\U0002569A"}, {"\U0002F955", "\U000256C5"}, {"\U0002F956", "\u798F"},
    {"\U0002F957", "\u79EB"}, {"\U0002F958", "\u412F"}, {"\U0002F959", "\u7A40"}, {"\U0002F95A", "\u7A4A"},
    {"\U0002F95B", "\u7A4F"}, {"\U0002F95C", "\U0002597C"}, {"\U0002F95D", "\U00025AA7"}, {"\U0002F95E", "\U00025AA7"},
    {"\U0002F95F", "\u7AEE"}, {"\U0002F960", "\u4202"}, {"\U0002F961", "\U00025BAB"}, {"\U0002F962", "\u7BC6"},
    {"\U0002F963", "\u7BC9"}, {"\U0002F964", "\u4227"}, {"\U0002F965", "\U00025C80"}, {"\U0002F966", "\u7CD2"},
    {"\U0002F967", "\u42A0"}, {"\U0002F968", "\u7CE8"}, {"\U0002F969", "\u7CE3"}, {"\U0002F96A", "\u7D00"},
    {"\U0002F96B", "\U00025F86"}, {"\U0002F96C", "\u7D63"}, {"\U0002F96D", "\u4301"}, {"\U0002F96E", "\u7DC7"},
    {"\U0002F96F", "\u7E02"}, {"\U0002F970", "\u7E45"}, {"\U0002F971", "\u4334"}, {"\U0002F972", "\U00026228"},
    {"\U0002F973", "\U00026247"}, {"\U0002F974", "\u4359"}, {"\U0002F975", "\U000262D9"}, {"\U0002F976", "\u7F7A"},
    {"\U0002F977", "\U0002633E"}, {"\U0002F978", "\u7F95"}, {"\U0002F979", "\u7FFA"}, {"\U0002F97A", "\u8005"},
    {"\U0002F97B", "\U000264DA"}, {"\U0002F97C", "\U00026523"}, {"\U0002F97D", "\u8060"}, {"\U0002F97E", "\U000265A8"},
    {"\U0002F97F", "\u8070"}, {"\U0002F980", "\U0002335F"}, {"\U0002F981", "\u43D5"}, {"\U0002F982", "\u80B2"},
    {"\U0002F983", "\u8103"}, {"\U0002F984", "\u440B"}, {"\U0002F985", "\u813E"}, {"\U0002F986", "\u5AB5"},
    {"\U0002F987", "\U000267A7"}, {"\U0002F988", "\U000267B5"}, {"\U0002F989", "\U00023393"},
    {"\U0002F98A", "\U0002339C"}, {"\U0002F98B", "\u8201"}, {"\U0002F98C", "\u8204"}, {"\U0002F98D", "\u8F9E"},
    {"\U0002F98E", "\u446B"}, {"\U0002F98F", "\u8291"}, {"\U0002F990", "\u828B"}, {"\U0002F991", "\u829D"},
    {"\U0002F992", "\u52B3"}, {"\U0002F993", "\u82B1"}, {"\U0002F994", "\u82B3"}, {"\U0002F995", "\u82BD"},
    {"\U0002F996", "\u82E6"}, {"\U0002F997", "\U00026B3C"}, {"\U0002F998", "\u82E5"}, {"\U0002F999", "\u831D"},
    {"\U0002F99A", "\u8363"}, {"\U0002F99B", "\u83AD"}, {"\U0002F99C", "\u8323"}, {"\U0002F99D", "\u83BD"},
    {"\U0002F99E", "\u83E7"}, {"\U0002F99F", "\u8457"}, {"\U0002F9A0", "\u8353"}, {"\U0002F9A1", "\u83CA"},
    {"\U0002F9A2", "\u83CC"}, {"\U0002F9A3", "\u83DC"}, {"\U0002F9A4", "\U00026C36"}, {"\U0002F9A5", "\U00026D6B"},
    {"\U0002F9A6", "\U00026CD5"}, {"\U0002F9A7", "\u452B"}, {"\U0002F9A8", "\u84F1"}, {"\U0002F9A9", "\u84F3"},
    {"\U0002F9AA", "\u8516"}, {"\U0002F9AB", "\U000273CA"}, {"\U0002F9AC", "\u8564"}, {"\U0002F9AD", "\U00026F2C"},
    {"\U0002F9AE", "\u455D"}, {"\U0002F9AF", "\u4561"}, {"\U0002F9B0", "\U00026FB1"}, {"\U0002F9B1", "\U000270D2"},
    {"\U0002F9B2", "\u456B"}, {"\U0002F9B3", "\u8650"}, {"\U0002F9B4", "\u865C"}, {"\U0002F9B5", "\u8667"},
    {"\U0002F9B6", "\u8669"}, {"\U0002F9B7", "\u86A9"}, {"\U0002F9B8", "\u8688"}, {"\U0002F9B9", "\u870E"},
    {"\U0002F9BA", "\u86E2"}, {"\U0002F9BB", "\u8779"}, {"\U0002F9BC", "\u8728"}, {"\U0002F9BD", "\u876B"},
    {"\U0002F9BE", "\u8786"}, {"\U0002F9BF", "\u45D7"}, {"\U0002F9C0", "\u87E1"}, {"\U0002F9C1", "\u8801"},
    {"\U0002F9C2", "\u45F9"}, {"\U0002F9C3", "\u8860"}, {"\U0002F9C4", "\u8863"}, {"\U0002F9C5", "\U00027667"},
    {"\U0002F9C6", "\u88D7"}, {"\U0002F9C7", "\u88DE"}, {"\U0002F9C8", "\u4635"}, {"\U0002F9C9", "\u88FA"},
    {"\U0002F9CA", "\u34BB"}, {"\U0002F9CB", "\U000278AE"}, {"\U0002F9CC", "\U00027966"}, {"\U0002F9CD", "\u46BE"},
    {"\U0002F9CE", "\u46C7"}, {"\U0002F9CF", "\u8AA0"}, {"\U0002F9D0", "\u8AED"}, {"\U0002F9D1", "\u8B8A"},
    {"\U0002F9D2", "\u8C55"}, {"\U0002F9D3", "\U00027CA8"}, {"\U0002F9D4", "\u8CAB"}, {"\U0002F9D5", "\u8CC1"},
    {"\U0002F9D6", "\u8D1B"}, {"\U0002F9D7", "\u8D77"}, {"\U0002F9D8", "\U00027F2F"}, {"\U0002F9D9", "\U00020804"},
    {"\U0002F9DA", "\u8DCB"}, {"\U0002F9DB", "\u8DBC"}, {"\U0002F9DC", "\u8DF0"}, {"\U0002F9DD", "\U000208DE"},
    {"\U0002F9DE", "\u8ED4"}, {"\U0002F9DF", "\u8F38"}, {"\U0002F9E0", "\U000285D2"}, {"\U0002F9E1", "\U000285ED"},
    {"\U0002F9E2", "\u9094"}, {"\U0002F9E3", "\u90F1"}, {"\U0002F9E4", "\u9111"}, {"\U0002F9E5", "\U0002872E"},
    {"\U0002F9E6", "\u911B"}, {"\U0002F9E7", "\u9238"}, {"\U0002F9E8", "\u92D7"}, {"\U0002F9E9", "\u92D8"},
    {"\U0002F9EA", "\u927C"}, {"\U0002F9EB", "\u93F9"}, {"\U0002F9EC", "\u9415"}, {"\U0002F9ED", "\U00028BFA"},
    {"\U0002F9EE", "\u958B"}, {"\U0002F9EF", "\u4995"}, {"\U0002F9F0", "\u95B7"}, {"\U0002F9F1", "\U00028D77"},
    {"\U0002F9F2", "\u49E6"}, {"\U0002F9F3", "\u96C3"}, {"\U0002F9F4", "\u5DB2"}, {"\U0002F9F5", "\u9723"},
    {"\U0002F9F6", "\U00029145"}, {"\U0002F9F7", "\U0002921A"}, {"\U0002F9F8", "\u4A6E"}, {"\U0002F9F9", "\u4A76"},
    {"\U0002F9FA", "\u97E0"}, {"\U0002F9FB", "\U0002940A"}, {"\U0002F9FC", "\u4AB2"}, {"\U0002F9FD", "\U00029496"},
    {"\U0002F9FE", "\u980B"}, {"\U0002F9FF", "\u980B"}, {"\U0002FA00", "\u9829"}, {"\U0002FA01", "\U000295B6"},
    {"\U0002FA02", "\u98E2"}, {"\U0002FA03", "\u4B33"}, {"\U0002FA04", "\u9929"}, {"\U0002FA05", "\u99A7"},
    {"\U0002FA06", "\u99C2"}, {"\U0002FA07", "\u99FE"}, {"\U0002FA08", "\u4BCE"}, {"\U0002FA09", "\U00029B30"},
    {"\U0002FA0A", "\u9B12"}, {"\U0002FA0B", "\u9C40"}, {"\U0002FA0C", "\u9CFD"}, {"\U0002FA0D", "\u4CCE"},
    {"\U0002FA0E", "\u4CED"}, {"\U0002FA0F", "\u9D67"}, {"\U0002FA10", "\U0002A0CE"}, {"\U0002FA11", "\u4CF8"},
    {"\U0002FA12", "\U0002A105"}, {"\U0002FA13", "\U0002A20E"}, {"\U0002FA14", "\U0002A291"}, {"\U0002FA15", "\u9EBB"},
    {"\U0002FA16", "\u4D56"}, {"\U0002FA17", "\u9EF9"}, {"\U0002FA18", "\u9EFE"}, {"\U0002FA19", "\u9F05"},
    {"\U0002FA1A", "\u9F0F"}, {"\U0002FA1B", "\u9F16"}, {"\U0002FA1C", "\u9F3B"}, {"\U0002FA1D", "\U0002A600"},
    {"\u0061\u0315\u0300\u05AE\u0300\u0062", "\u00E0\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0300\u0315\u0300\u05AE\u0062", "\u00E0\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0301\u0062", "\u00E0\u05AE\u0301\u0315\u0062"},
    {"\u0061\u0301\u0315\u0300\u05AE\u0062", "\u00E1\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0302\u0062", "\u00E0\u05AE\u0302\u0315\u0062"},
    {"\u0061\u0302\u0315\u0300\u05AE\u0062", "\u1EA7\u05AE\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0303\u0062", "\u00E0\u05AE\u0303\u0315\u0062"},
    {"\u0061\u0303\u0315\u0300\u05AE\u0062", "\u00E3\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0304\u0062", "\u00E0\u05AE\u0304\u0315\u0062"},
    {"\u0061\u0304\u0315\u0300\u05AE\u0062", "\u0101\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0305\u0062", "\u00E0\u05AE\u0305\u0315\u0062"},
    {"\u0061\u0305\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0305\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0306\u0062", "\u00E0\u05AE\u0306\u0315\u0062"},
    {"\u0061\u0306\u0315\u0300\u05AE\u0062", "\u1EB1\u05AE\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0307\u0062", "\u00E0\u05AE\u0307\u0315\u0062"},
    {"\u0061\u0307\u0315\u0300\u05AE\u0062", "\u0227\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0308\u0062", "\u00E0\u05AE\u0308\u0315\u0062"},
    {"\u0061\u0308\u0315\u0300\u05AE\u0062", "\u00E4\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0309\u0062", "\u00E0\u05AE\u0309\u0315\u0062"},
    {"\u0061\u0309\u0315\u0300\u05AE\u0062", "\u1EA3\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u030A\u0062", "\u00E0\u05AE\u030A\u0315\u0062"},
    {"\u0061\u030A\u0315\u0300\u05AE\u0062", "\u00E5\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u030B\u0062", "\u00E0\u05AE\u030B\u0315\u0062"},
    {"\u0061\u030B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u030B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u030C\u0062", "\u00E0\u05AE\u030C\u0315\u0062"},
    {"\u0061\u030C\u0315\u0300\u05AE\u0062", "\u01CE\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u030D\u0062", "\u00E0\u05AE\u030D\u0315\u0062"},
    {"\u0061\u030D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u030D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u030E\u0062", "\u00E0\u05AE\u030E\u0315\u0062"},
    {"\u0061\u030E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u030E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u030F\u0062", "\u00E0\u05AE\u030F\u0315\u0062"},
    {"\u0061\u030F\u0315\u0300\u05AE\u0062", "\u0201\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0310\u0062", "\u00E0\u05AE\u0310\u0315\u0062"},
    {"\u0061\u0310\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0310\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0311\u0062", "\u00E0\u05AE\u0311\u0315\u0062"},
    {"\u0061\u0311\u0315\u0300\u05AE\u0062", "\u0203\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0312\u0062", "\u00E0\u05AE\u0312\u0315\u0062"},
    {"\u0061\u0312\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0312\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0313\u0062", "\u00E0\u05AE\u0313\u0315\u0062"},
    {"\u0061\u0313\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0313\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0314\u0062", "\u00E0\u05AE\u0314\u0315\u0062"},
    {"\u0061\u0314\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0314\u0300\u0315\u0062"},
    {"\u0061\u035C\u0315\u0300\u0315\u0062", "\u00E0\u0315\u0315\u035C\u0062"},
    {"\u0061\u0315\u035C\u0315\u0300\u0062", "\u00E0\u0315\u0315\u035C\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0316\u0062", "\u0061\u1DFA\u0316\u0316\u059A\u0062"},
    {"\u0061\u0316\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0316\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0317\u0062", "\u0061\u1DFA\u0316\u0317\u059A\u0062"},
    {"\u0061\u0317\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0317\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0318\u0062", "\u0061\u1DFA\u0316\u0318\u059A\u0062"},
    {"\u0061\u0318\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0318\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0319\u0062", "\u0061\u1DFA\u0316\u0319\u059A\u0062"},
    {"\u0061\u0319\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0319\u0316\u059A\u0062"},
    {"\u0061\u035C\u0315\u0300\u031A\u0062", "\u00E0\u0315\u031A\u035C\u0062"},
    {"\u0061\u031A\u035C\u0315\u0300\u0062", "\u00E0\u031A\u0315\u035C\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\u031B\u0062", "\u0061\u1DCE\u031B\u031B\u1DFA\u0062"},
    {"\u0061\u031B\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\u031B\u031B\u1DFA\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u031C\u0062", "\u0061\u1DFA\u0316\u031C\u059A\u0062"},
    {"\u0061\u031C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u031C\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u031D\u0062", "\u0061\u1DFA\u0316\u031D\u059A\u0062"},
    {"\u0061\u031D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u031D\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u031E\u0062", "\u0061\u1DFA\u0316\u031E\u059A\u0062"},
    {"\u0061\u031E\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u031E\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u031F\u0062", "\u0061\u1DFA\u0316\u031F\u059A\u0062"},
    {"\u0061\u031F\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u031F\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0320\u0062", "\u0061\u1DFA\u0316\u0320\u059A\u0062"},
    {"\u0061\u0320\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0320\u0316\u059A\u0062"},
    {"\u0061\u1DCE\u0321\u0F74\u0321\u0062", "\u0061\u0F74\u0321\u0321\u1DCE\u0062"},
    {"\u0061\u0321\u1DCE\u0321\u0F74\u0062", "\u0061\u0F74\u0321\u0321\u1DCE\u0062"},
    {"\u0061\u1DCE\u0321\u0F74\u0322\u0062", "\u0061\u0F74\u0321\u0322\u1DCE\u0062"},
    {"\u0061\u0322\u1DCE\u0321\u0F74\u0062", "\u0061\u0F74\u0322\u0321\u1DCE\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0323\u0062", "\u0061\u1DFA\u0316\u0323\u059A\u0062"},
    {"\u0061\u0323\u059A\u0316\u1DFA\u0062", "\u1EA1\u1DFA\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0324\u0062", "\u0061\u1DFA\u0316\u0324\u059A\u0062"},
    {"\u0061\u0324\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0324\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0325\u0062", "\u0061\u1DFA\u0316\u0325\u059A\u0062"},
    {"\u0061\u0325\u059A\u0316\u1DFA\u0062", "\u1E01\u1DFA\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0326\u0062", "\u0061\u1DFA\u0316\u0326\u059A\u0062"},
    {"\u0061\u0326\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0326\u0316\u059A\u0062"},
    {"\u0061\u1DCE\u0321\u0F74\u0327\u0062", "\u0061\u0F74\u0321\u0327\u1DCE\u0062"},
    {"\u0061\u0327\u1DCE\u0321\u0F74\u0062", "\u0061\u0F74\u0327\u0321\u1DCE\u0062"},
    {"\u0061\u1DCE\u0321\u0F74\u0328\u0062", "\u0061\u0F74\u0321\u0328\u1DCE\u0062"},
    {"\u0061\u0328\u1DCE\u0321\u0F74\u0062", "\u0105\u0F74\u0321\u1DCE\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0329\u0062", "\u0061\u1DFA\u0316\u0329\u059A\u0062"},
    {"\u0061\u0329\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0329\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u032A\u0062", "\u0061\u1DFA\u0316\u032A\u059A\u0062"},
    {"\u0061\u032A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u032A\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u032B\u0062", "\u0061\u1DFA\u0316\u032B\u059A\u0062"},
    {"\u0061\u032B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u032B\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u032C\u0062", "\u0061\u1DFA\u0316\u032C\u059A\u0062"},
    {"\u0061\u032C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u032C\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u032D\u0062", "\u0061\u1DFA\u0316\u032D\u059A\u0062"},
    {"\u0061\u032D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u032D\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u032E\u0062", "\u0061\u1DFA\u0316\u032E\u059A\u0062"},
    {"\u0061\u032E\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u032E\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u032F\u0062", "\u0061\u1DFA\u0316\u032F\u059A\u0062"},
    {"\u0061\u032F\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u032F\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0330\u0062", "\u0061\u1DFA\u0316\u0330\u059A\u0062"},
    {"\u0061\u0330\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0330\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0331\u0062", "\u0061\u1DFA\u0316\u0331\u059A\u0062"},
    {"\u0061\u0331\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0331\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0332\u0062", "\u0061\u1DFA\u0316\u0332\u059A\u0062"},
    {"\u0061\u0332\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0332\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0333\u0062", "\u0061\u1DFA\u0316\u0333\u059A\u0062"},
    {"\u0061\u0333\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0333\u0316\u059A\u0062"},
    {"\u0061\U00016FF0\u0334\u0334\u0062", "\u0061\u0334\u0334\U00016FF0\u0062"},
    {"\u0061\u0334\U00016FF0\u0334\u0062", "\u0061\u0334\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u0335\u0062", "\u0061\u0334\u0335\U00016FF0\u0062"},
    {"\u0061\u0335\U00016FF0\u0334\u0062", "\u0061\u0335\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u0336\u0062", "\u0061\u0334\u0336\U00016FF0\u0062"},
    {"\u0061\u0336\U00016FF0\u0334\u0062", "\u0061\u0336\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u0337\u0062", "\u0061\u0334\u0337\U00016FF0\u0062"},
    {"\u0061\u0337\U00016FF0\u0334\u0062", "\u0061\u0337\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u0338\u0062", "\u0061\u0334\u0338\U00016FF0\u0062"},
    {"\u0061\u0338\U00016FF0\u0334\u0062", "\u0061\u0338\u0334\U00016FF0\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0339\u0062", "\u0061\u1DFA\u0316\u0339\u059A\u0062"},
    {"\u0061\u0339\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0339\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u033A\u0062", "\u0061\u1DFA\u0316\u033A\u059A\u0062"},
    {"\u0061\u033A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u033A\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u033B\u0062", "\u0061\u1DFA\u0316\u033B\u059A\u0062"},
    {"\u0061\u033B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u033B\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u033C\u0062", "\u0061\u1DFA\u0316\u033C\u059A\u0062"},
    {"\u0061\u033C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u033C\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u033D\u0062", "\u00E0\u05AE\u033D\u0315\u0062"},
    {"\u0061\u033D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u033D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u033E\u0062", "\u00E0\u05AE\u033E\u0315\u0062"},
    {"\u0061\u033E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u033E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u033F\u0062", "\u00E0\u05AE\u033F\u0315\u0062"},
    {"\u0061\u033F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u033F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0340\u0062", "\u00E0\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0340\u0315\u0300\u05AE\u0062", "\u00E0\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0341\u0062", "\u00E0\u05AE\u0301\u0315\u0062"},
    {"\u0061\u0341\u0315\u0300\u05AE\u0062", "\u00E1\u05AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0342\u0062", "\u00E0\u05AE\u0342\u0315\u0062"},
    {"\u0061\u0342\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0342\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0343\u0062", "\u00E0\u05AE\u0313\u0315\u0062"},
    {"\u0061\u0343\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0313\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0344\u0062", "\u00E0\u05AE\u0308\u0301\u0315\u0062"},
    {"\u0061\u0344\u0315\u0300\u05AE\u0062", "\u00E4\u05AE\u0301\u0300\u0315\u0062"},
    {"\u0061\u0345\u035D\u0345\u0062", "\u0061\u035D\u0345\u0345\u0062"},
    {"\u0061\u0345\u0345\u035D\u0062", "\u0061\u035D\u0345\u0345\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0346\u0062", "\u00E0\u05AE\u0346\u0315\u0062"},
    {"\u0061\u0346\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0346\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0347\u0062", "\u0061\u1DFA\u0316\u0347\u059A\u0062"},
    {"\u0061\u0347\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0347\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0348\u0062", "\u0061\u1DFA\u0316\u0348\u059A\u0062"},
    {"\u0061\u0348\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0348\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0349\u0062", "\u0061\u1DFA\u0316\u0349\u059A\u0062"},
    {"\u0061\u0349\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0349\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u034A\u0062", "\u00E0\u05AE\u034A\u0315\u0062"},
    {"\u0061\u034A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u034A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u034B\u0062", "\u00E0\u05AE\u034B\u0315\u0062"},
    {"\u0061\u034B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u034B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u034C\u0062", "\u00E0\u05AE\u034C\u0315\u0062"},
    {"\u0061\u034C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u034C\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u034D\u0062", "\u0061\u1DFA\u0316\u034D\u059A\u0062"},
    {"\u0061\u034D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u034D\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u034E\u0062", "\u0061\u1DFA\u0316\u034E\u059A\u0062"},
    {"\u0061\u034E\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u034E\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0350\u0062", "\u00E0\u05AE\u0350\u0315\u0062"},
    {"\u0061\u0350\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0350\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0351\u0062", "\u00E0\u05AE\u0351\u0315\u0062"},
    {"\u0061\u0351\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0351\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0352\u0062", "\u00E0\u05AE\u0352\u0315\u0062"},
    {"\u0061\u0352\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0352\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0353\u0062", "\u0061\u1DFA\u0316\u0353\u059A\u0062"},
    {"\u0061\u0353\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0353\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0354\u0062", "\u0061\u1DFA\u0316\u0354\u059A\u0062"},
    {"\u0061\u0354\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0354\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0355\u0062", "\u0061\u1DFA\u0316\u0355\u059A\u0062"},
    {"\u0061\u0355\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0355\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0356\u0062", "\u0061\u1DFA\u0316\u0356\u059A\u0062"},
    {"\u0061\u0356\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0356\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0357\u0062", "\u00E0\u05AE\u0357\u0315\u0062"},
    {"\u0061\u0357\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0357\u0300\u0315\u0062"},
    {"\u0061\u035C\u0315\u0300\u0358\u0062", "\u00E0\u0315\u0358\u035C\u0062"},
    {"\u0061\u0358\u035C\u0315\u0300\u0062", "\u00E0\u0358\u0315\u035C\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0359\u0062", "\u0061\u1DFA\u0316\u0359\u059A\u0062"},
    {"\u0061\u0359\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0359\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u035A\u0062", "\u0061\u1DFA\u0316\u035A\u059A\u0062"},
    {"\u0061\u035A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u035A\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u035B\u0062", "\u00E0\u05AE\u035B\u0315\u0062"},
    {"\u0061\u035B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u035B\u0300\u0315\u0062"},
    {"\u0061\u035D\u035C\u0315\u035C\u0062", "\u0061\u0315\u035C\u035C\u035D\u0062"},
    {"\u0061\u035C\u035D\u035C\u0315\u0062", "\u0061\u0315\u035C\u035C\u035D\u0062"},
    {"\u0061\u0345\u035D\u035C\u035D\u0062", "\u0061\u035C\u035D\u035D\u0345\u0062"},
    {"\u0061\u035D\u0345\u035D\u035C\u0062", "\u0061\u035C\u035D\u035D\u0345\u0062"},
    {"\u0061\u0345\u035D\u035C\u035E\u0062", "\u0061\u035C\u035D\u035E\u0345\u0062"},
    {"\u0061\u035E\u0345\u035D\u035C\u0062", "\u0061\u035C\u035E\u035D\u0345\u0062"},
    {"\u0061\u035D\u035C\u0315\u035F\u0062", "\u0061\u0315\u035C\u035F\u035D\u0062"},
    {"\u0061\u035F\u035D\u035C\u0315\u0062", "\u0061\u0315\u035F\u035C\u035D\u0062"},
    {"\u0061\u0345\u035D\u035C\u0360\u0062", "\u0061\u035C\u035D\u0360\u0345\u0062"},
    {"\u0061\u0360\u0345\u035D\u035C\u0062", "\u0061\u035C\u0360\u035D\u0345\u0062"},
    {"\u0061\u0345\u035D\u035C\u0361\u0062", "\u0061\u035C\u035D\u0361\u0345\u0062"},
    {"\u0061\u0361\u0345\u035D\u035C\u0062", "\u0061\u035C\u0361\u035D\u0345\u0062"},
    {"\u0061\u035D\u035C\u0315\u0362\u0062", "\u0061\u0315\u035C\u0362\u035D\u0062"},
    {"\u0061\u0362\u035D\u035C\u0315\u0062", "\u0061\u0315\u0362\u035C\u035D\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0363\u0062", "\u00E0\u05AE\u0363\u0315\u0062"},
    {"\u0061\u0363\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0363\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0364\u0062", "\u00E0\u05AE\u0364\u0315\u0062"},
    {"\u0061\u0364\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0364\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0365\u0062", "\u00E0\u05AE\u0365\u0315\u0062"},
    {"\u0061\u0365\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0365\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0366\u0062", "\u00E0\u05AE\u0366\u0315\u0062"},
    {"\u0061\u0366\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0366\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0367\u0062", "\u00E0\u05AE\u0367\u0315\u0062"},
    {"\u0061\u0367\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0367\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0368\u0062", "\u00E0\u05AE\u0368\u0315\u0062"},
    {"\u0061\u0368\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0368\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0369\u0062", "\u00E0\u05AE\u0369\u0315\u0062"},
    {"\u0061\u0369\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0369\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u036A\u0062", "\u00E0\u05AE\u036A\u0315\u0062"},
    {"\u0061\u036A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u036A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u036B\u0062", "\u00E0\u05AE\u036B\u0315\u0062"},
    {"\u0061\u036B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u036B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u036C\u0062", "\u00E0\u05AE\u036C\u0315\u0062"},
    {"\u0061\u036C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u036C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u036D\u0062", "\u00E0\u05AE\u036D\u0315\u0062"},
    {"\u0061\u036D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u036D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u036E\u0062", "\u00E0\u05AE\u036E\u0315\u0062"},
    {"\u0061\u036E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u036E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u036F\u0062", "\u00E0\u05AE\u036F\u0315\u0062"},
    {"\u0061\u036F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u036F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0483\u0062", "\u00E0\u05AE\u0483\u0315\u0062"},
    {"\u0061\u0483\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0483\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0484\u0062", "\u00E0\u05AE\u0484\u0315\u0062"},
    {"\u0061\u0484\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0484\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0485\u0062", "\u00E0\u05AE\u0485\u0315\u0062"},
    {"\u0061\u0485\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0485\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0486\u0062", "\u00E0\u05AE\u0486\u0315\u0062"},
    {"\u0061\u0486\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0486\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0487\u0062", "\u00E0\u05AE\u0487\u0315\u0062"},
    {"\u0061\u0487\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0487\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0591\u0062", "\u0061\u1DFA\u0316\u0591\u059A\u0062"},
    {"\u0061\u0591\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0591\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0592\u0062", "\u00E0\u05AE\u0592\u0315\u0062"},
    {"\u0061\u0592\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0592\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0593\u0062", "\u00E0\u05AE\u0593\u0315\u0062"},
    {"\u0061\u0593\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0593\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0594\u0062", "\u00E0\u05AE\u0594\u0315\u0062"},
    {"\u0061\u0594\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0594\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0595\u0062", "\u00E0\u05AE\u0595\u0315\u0062"},
    {"\u0061\u0595\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0595\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0596\u0062", "\u0061\u1DFA\u0316\u0596\u059A\u0062"},
    {"\u0061\u0596\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0596\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0597\u0062", "\u00E0\u05AE\u0597\u0315\u0062"},
    {"\u0061\u0597\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0597\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0598\u0062", "\u00E0\u05AE\u0598\u0315\u0062"},
    {"\u0061\u0598\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0598\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0599\u0062", "\u00E0\u05AE\u0599\u0315\u0062"},
    {"\u0061\u0599\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0599\u0300\u0315\u0062"},
    {"\u0061\u302E\u059A\u0316\u059A\u0062", "\u0061\u0316\u059A\u059A\u302E\u0062"},
    {"\u0061\u059A\u302E\u059A\u0316\u0062", "\u0061\u0316\u059A\u059A\u302E\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u059B\u0062", "\u0061\u1DFA\u0316\u059B\u059A\u0062"},
    {"\u0061\u059B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u059B\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u059C\u0062", "\u00E0\u05AE\u059C\u0315\u0062"},
    {"\u0061\u059C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u059C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u059D\u0062", "\u00E0\u05AE\u059D\u0315\u0062"},
    {"\u0061\u059D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u059D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u059E\u0062", "\u00E0\u05AE\u059E\u0315\u0062"},
    {"\u0061\u059E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u059E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u059F\u0062", "\u00E0\u05AE\u059F\u0315\u0062"},
    {"\u0061\u059F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u059F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05A0\u0062", "\u00E0\u05AE\u05A0\u0315\u0062"},
    {"\u0061\u05A0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05A0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05A1\u0062", "\u00E0\u05AE\u05A1\u0315\u0062"},
    {"\u0061\u05A1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05A1\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05A2\u0062", "\u0061\u1DFA\u0316\u05A2\u059A\u0062"},
    {"\u0061\u05A2\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05A2\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05A3\u0062", "\u0061\u1DFA\u0316\u05A3\u059A\u0062"},
    {"\u0061\u05A3\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05A3\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05A4\u0062", "\u0061\u1DFA\u0316\u05A4\u059A\u0062"},
    {"\u0061\u05A4\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05A4\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05A5\u0062", "\u0061\u1DFA\u0316\u05A5\u059A\u0062"},
    {"\u0061\u05A5\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05A5\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05A6\u0062", "\u0061\u1DFA\u0316\u05A6\u059A\u0062"},
    {"\u0061\u05A6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05A6\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05A7\u0062", "\u0061\u1DFA\u0316\u05A7\u059A\u0062"},
    {"\u0061\u05A7\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05A7\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05A8\u0062", "\u00E0\u05AE\u05A8\u0315\u0062"},
    {"\u0061\u05A8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05A8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05A9\u0062", "\u00E0\u05AE\u05A9\u0315\u0062"},
    {"\u0061\u05A9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05A9\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05AA\u0062", "\u0061\u1DFA\u0316\u05AA\u059A\u0062"},
    {"\u0061\u05AA\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05AA\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05AB\u0062", "\u00E0\u05AE\u05AB\u0315\u0062"},
    {"\u0061\u05AB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05AB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05AC\u0062", "\u00E0\u05AE\u05AC\u0315\u0062"},
    {"\u0061\u05AC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05AC\u0300\u0315\u0062"},
    {"\u0061\u302E\u059A\u0316\u05AD\u0062", "\u0061\u0316\u059A\u05AD\u302E\u0062"},
    {"\u0061\u05AD\u302E\u059A\u0316\u0062", "\u0061\u0316\u05AD\u059A\u302E\u0062"},
    {"\u0061\u0300\u05AE\U0001D16D\u05AE\u0062", "\u00E0\U0001D16D\u05AE\u05AE\u0062"},
    {"\u0061\u05AE\u0300\u05AE\U0001D16D\u0062", "\u00E0\U0001D16D\u05AE\u05AE\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05AF\u0062", "\u00E0\u05AE\u05AF\u0315\u0062"},
    {"\u0061\u05AF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05AF\u0300\u0315\u0062"},
    {"\u0061\u05B1\u05B0\u094D\u05B0\u0062", "\u0061\u094D\u05B0\u05B0\u05B1\u0062"},
    {"\u0061\u05B0\u05B1\u05B0\u094D\u0062", "\u0061\u094D\u05B0\u05B0\u05B1\u0062"},
    {"\u0061\u05B2\u05B1\u05B0\u05B1\u0062", "\u0061\u05B0\u05B1\u05B1\u05B2\u0062"},
    {"\u0061\u05B1\u05B2\u05B1\u05B0\u0062", "\u0061\u05B0\u05B1\u05B1\u05B2\u0062"},
    {"\u0061\u05B3\u05B2\u05B1\u05B2\u0062", "\u0061\u05B1\u05B2\u05B2\u05B3\u0062"},
    {"\u0061\u05B2\u05B3\u05B2\u05B1\u0062", "\u0061\u05B1\u05B2\u05B2\u05B3\u0062"},
    {"\u0061\u05B4\u05B3\u05B2\u05B3\u0062", "\u0061\u05B2\u05B3\u05B3\u05B4\u0062"},
    {"\u0061\u05B3\u05B4\u05B3\u05B2\u0062", "\u0061\u05B2\u05B3\u05B3\u05B4\u0062"},
    {"\u0061\u05B5\u05B4\u05B3\u05B4\u0062", "\u0061\u05B3\u05B4\u05B4\u05B5\u0062"},
    {"\u0061\u05B4\u05B5\u05B4\u05B3\u0062", "\u0061\u05B3\u05B4\u05B4\u05B5\u0062"},
    {"\u0061\u05B6\u05B5\u05B4\u05B5\u0062", "\u0061\u05B4\u05B5\u05B5\u05B6\u0062"},
    {"\u0061\u05B5\u05B6\u05B5\u05B4\u0062", "\u0061\u05B4\u05B5\u05B5\u05B6\u0062"},
    {"\u0061\u05B7\u05B6\u05B5\u05B6\u0062", "\u0061\u05B5\u05B6\u05B6\u05B7\u0062"},
    {"\u0061\u05B6\u05B7\u05B6\u05B5\u0062", "\u0061\u05B5\u05B6\u05B6\u05B7\u0062"},
    {"\u0061\u05B8\u05B7\u05B6\u05B7\u0062", "\u0061\u05B6\u05B7\u05B7\u05B8\u0062"},
    {"\u0061\u05B7\u05B8\u05B7\u05B6\u0062", "\u0061\u05B6\u05B7\u05B7\u05B8\u0062"},
    {"\u0061\u05B9\u05B8\u05B7\u05B8\u0062", "\u0061\u05B7\u05B8\u05B8\u05B9\u0062"},
    {"\u0061\u05B8\u05B9\u05B8\u05B7\u0062", "\u0061\u05B7\u05B8\u05B8\u05B9\u0062"},
    {"\u0061\u05BB\u05B9\u05B8\u05B9\u0062", "\u0061\u05B8\u05B9\u05B9\u05BB\u0062"},
    {"\u0061\u05B9\u05BB\u05B9\u05B8\u0062", "\u0061\u05B8\u05B9\u05B9\u05BB\u0062"},
    {"\u0061\u05BB\u05B9\u05B8\u05BA\u0062", "\u0061\u05B8\u05B9\u05BA\u05BB\u0062"},
    {"\u0061\u05BA\u05BB\u05B9\u05B8\u0062", "\u0061\u05B8\u05BA\u05B9\u05BB\u0062"},
    {"\u0061\u05BC\u05BB\u05B9\u05BB\u0062", "\u0061\u05B9\u05BB\u05BB\u05BC\u0062"},
    {"\u0061\u05BB\u05BC\u05BB\u05B9\u0062", "\u0061\u05B9\u05BB\u05BB\u05BC\u0062"},
    {"\u0061\u05BD\u05BC\u05BB\u05BC\u0062", "\u0061\u05BB\u05BC\u05BC\u05BD\u0062"},
    {"\u0061\u05BC\u05BD\u05BC\u05BB\u0062", "\u0061\u05BB\u05BC\u05BC\u05BD\u0062"},
    {"\u0061\u05BF\u05BD\u05BC\u05BD\u0062", "\u0061\u05BC\u05BD\u05BD\u05BF\u0062"},
    {"\u0061\u05BD\u05BF\u05BD\u05BC\u0062", "\u0061\u05BC\u05BD\u05BD\u05BF\u0062"},
    {"\u0061\u05C1\u05BF\u05BD\u05BF\u0062", "\u0061\u05BD\u05BF\u05BF\u05C1\u0062"},
    {"\u0061\u05BF\u05C1\u05BF\u05BD\u0062", "\u0061\u05BD\u05BF\u05BF\u05C1\u0062"},
    {"\u0061\u05C2\u05C1\u05BF\u05C1\u0062", "\u0061\u05BF\u05C1\u05C1\u05C2\u0062"},
    {"\u0061\u05C1\u05C2\u05C1\u05BF\u0062", "\u0061\u05BF\u05C1\u05C1\u05C2\u0062"},
    {"\u0061\uFB1E\u05C2\u05C1\u05C2\u0062", "\u0061\u05C1\u05C2\u05C2\uFB1E\u0062"},
    {"\u0061\u05C2\uFB1E\u05C2\u05C1\u0062", "\u0061\u05C1\u05C2\u05C2\uFB1E\u0062"},
    {"\u0061\u0315\u0300\u05AE\u05C4\u0062", "\u00E0\u05AE\u05C4\u0315\u0062"},
    {"\u0061\u05C4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u05C4\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u05C5\u0062", "\u0061\u1DFA\u0316\u05C5\u059A\u0062"},
    {"\u0061\u05C5\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u05C5\u0316\u059A\u0062"},
    {"\u0061\u05B9\u05B8\u05B7\u05C7\u0062", "\u0061\u05B7\u05B8\u05C7\u05B9\u0062"},
    {"\u0061\u05C7\u05B9\u05B8\u05B7\u0062", "\u0061\u05B7\u05C7\u05B8\u05B9\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0610\u0062", "\u00E0\u05AE\u0610\u0315\u0062"},
    {"\u0061\u0610\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0610\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0611\u0062", "\u00E0\u05AE\u0611\u0315\u0062"},
    {"\u0061\u0611\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0611\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0612\u0062", "\u00E0\u05AE\u0612\u0315\u0062"},
    {"\u0061\u0612\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0612\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0613\u0062", "\u00E0\u05AE\u0613\u0315\u0062"},
    {"\u0061\u0613\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0613\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0614\u0062", "\u00E0\u05AE\u0614\u0315\u0062"},
    {"\u0061\u0614\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0614\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0615\u0062", "\u00E0\u05AE\u0615\u0315\u0062"},
    {"\u0061\u0615\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0615\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0616\u0062", "\u00E0\u05AE\u0616\u0315\u0062"},
    {"\u0061\u0616\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0616\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0617\u0062", "\u00E0\u05AE\u0617\u0315\u0062"},
    {"\u0061\u0617\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0617\u0300\u0315\u0062"},
    {"\u0061\u0619\u0618\u064D\u0618\u0062", "\u0061\u064D\u0618\u0618\u0619\u0062"},
    {"\u0061\u0618\u0619\u0618\u064D\u0062", "\u0061\u064D\u0618\u0618\u0619\u0062"},
    {"\u0061\u061A\u0619\u0618\u0619\u0062", "\u0061\u0618\u0619\u0619\u061A\u0062"},
    {"\u0061\u0619\u061A\u0619\u0618\u0062", "\u0061\u0618\u0619\u0619\u061A\u0062"},
    {"\u0061\u0651\u061A\u0619\u061A\u0062", "\u0061\u0619\u061A\u061A\u0651\u0062"},
    {"\u0061\u061A\u0651\u061A\u0619\u0062", "\u0061\u0619\u061A\u061A\u0651\u0062"},
    {"\u0061\u064C\u064B\uFB1E\u064B\u0062", "\u0061\uFB1E\u064B\u064B\u064C\u0062"},
    {"\u0061\u064B\u064C\u064B\uFB1E\u0062", "\u0061\uFB1E\u064B\u064B\u064C\u0062"},
    {"\u0061\u064D\u064C\u064B\u064C\u0062", "\u0061\u064B\u064C\u064C\u064D\u0062"},
    {"\u0061\u064C\u064D\u064C\u064B\u0062", "\u0061\u064B\u064C\u064C\u064D\u0062"},
    {"\u0061\u0618\u064D\u064C\u064D\u0062", "\u0061\u064C\u064D\u064D\u0618\u0062"},
    {"\u0061\u064D\u0618\u064D\u064C\u0062", "\u0061\u064C\u064D\u064D\u0618\u0062"},
    {"\u0061\u0619\u0618\u064D\u064E\u0062", "\u0061\u064D\u0618\u064E\u0619\u0062"},
    {"\u0061\u064E\u0619\u0618\u064D\u0062", "\u0061\u064D\u064E\u0618\u0619\u0062"},
    {"\u0061\u061A\u0619\u0618\u064F\u0062", "\u0061\u0618\u0619\u064F\u061A\u0062"},
    {"\u0061\u064F\u061A\u0619\u0618\u0062", "\u0061\u0618\u064F\u0619\u061A\u0062"},
    {"\u0061\u0651\u061A\u0619\u0650\u0062", "\u0061\u0619\u061A\u0650\u0651\u0062"},
    {"\u0061\u0650\u0651\u061A\u0619\u0062", "\u0061\u0619\u0650\u061A\u0651\u0062"},
    {"\u0061\u0652\u0651\u061A\u0651\u0062", "\u0061\u061A\u0651\u0651\u0652\u0062"},
    {"\u0061\u0651\u0652\u0651\u061A\u0062", "\u0061\u061A\u0651\u0651\u0652\u0062"},
    {"\u0061\u0670\u0652\u0651\u0652\u0062", "\u0061\u0651\u0652\u0652\u0670\u0062"},
    {"\u0061\u0652\u0670\u0652\u0651\u0062", "\u0061\u0651\u0652\u0652\u0670\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0653\u0062", "\u00E0\u05AE\u0653\u0315\u0062"},
    {"\u0061\u0653\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0653\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0654\u0062", "\u00E0\u05AE\u0654\u0315\u0062"},
    {"\u0061\u0654\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0654\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0655\u0062", "\u0061\u1DFA\u0316\u0655\u059A\u0062"},
    {"\u0061\u0655\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0655\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0656\u0062", "\u0061\u1DFA\u0316\u0656\u059A\u0062"},
    {"\u0061\u0656\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0656\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0657\u0062", "\u00E0\u05AE\u0657\u0315\u0062"},
    {"\u0061\u0657\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0657\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0658\u0062", "\u00E0\u05AE\u0658\u0315\u0062"},
    {"\u0061\u0658\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0658\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0659\u0062", "\u00E0\u05AE\u0659\u0315\u0062"},
    {"\u0061\u0659\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0659\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u065A\u0062", "\u00E0\u05AE\u065A\u0315\u0062"},
    {"\u0061\u065A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u065A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u065B\u0062", "\u00E0\u05AE\u065B\u0315\u0062"},
    {"\u0061\u065B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u065B\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u065C\u0062", "\u0061\u1DFA\u0316\u065C\u059A\u0062"},
    {"\u0061\u065C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u065C\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u065D\u0062", "\u00E0\u05AE\u065D\u0315\u0062"},
    {"\u0061\u065D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u065D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u065E\u0062", "\u00E0\u05AE\u065E\u0315\u0062"},
    {"\u0061\u065E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u065E\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u065F\u0062", "\u0061\u1DFA\u0316\u065F\u059A\u0062"},
    {"\u0061\u065F\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u065F\u0316\u059A\u0062"},
    {"\u0061\u0711\u0670\u0652\u0670\u0062", "\u0061\u0652\u0670\u0670\u0711\u0062"},
    {"\u0061\u0670\u0711\u0670\u0652\u0062", "\u0061\u0652\u0670\u0670\u0711\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06D6\u0062", "\u00E0\u05AE\u06D6\u0315\u0062"},
    {"\u0061\u06D6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06D6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06D7\u0062", "\u00E0\u05AE\u06D7\u0315\u0062"},
    {"\u0061\u06D7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06D7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06D8\u0062", "\u00E0\u05AE\u06D8\u0315\u0062"},
    {"\u0061\u06D8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06D8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06D9\u0062", "\u00E0\u05AE\u06D9\u0315\u0062"},
    {"\u0061\u06D9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06D9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06DA\u0062", "\u00E0\u05AE\u06DA\u0315\u0062"},
    {"\u0061\u06DA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06DA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06DB\u0062", "\u00E0\u05AE\u06DB\u0315\u0062"},
    {"\u0061\u06DB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06DB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06DC\u0062", "\u00E0\u05AE\u06DC\u0315\u0062"},
    {"\u0061\u06DC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06DC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06DF\u0062", "\u00E0\u05AE\u06DF\u0315\u0062"},
    {"\u0061\u06DF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06DF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06E0\u0062", "\u00E0\u05AE\u06E0\u0315\u0062"},
    {"\u0061\u06E0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06E0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06E1\u0062", "\u00E0\u05AE\u06E1\u0315\u0062"},
    {"\u0061\u06E1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06E1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06E2\u0062", "\u00E0\u05AE\u06E2\u0315\u0062"},
    {"\u0061\u06E2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06E2\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u06E3\u0062", "\u0061\u1DFA\u0316\u06E3\u059A\u0062"},
    {"\u0061\u06E3\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u06E3\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06E4\u0062", "\u00E0\u05AE\u06E4\u0315\u0062"},
    {"\u0061\u06E4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06E4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06E7\u0062", "\u00E0\u05AE\u06E7\u0315\u0062"},
    {"\u0061\u06E7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06E7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06E8\u0062", "\u00E0\u05AE\u06E8\u0315\u0062"},
    {"\u0061\u06E8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06E8\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u06EA\u0062", "\u0061\u1DFA\u0316\u06EA\u059A\u0062"},
    {"\u0061\u06EA\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u06EA\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06EB\u0062", "\u00E0\u05AE\u06EB\u0315\u0062"},
    {"\u0061\u06EB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06EB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u06EC\u0062", "\u00E0\u05AE\u06EC\u0315\u0062"},
    {"\u0061\u06EC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u06EC\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u06ED\u0062", "\u0061\u1DFA\u0316\u06ED\u059A\u0062"},
    {"\u0061\u06ED\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u06ED\u0316\u059A\u0062"},
    {"\u0061\u0C55\u0711\u0670\u0711\u0062", "\u0061\u0670\u0711\u0711\u0C55\u0062"},
    {"\u0061\u0711\u0C55\u0711\u0670\u0062", "\u0061\u0670\u0711\u0711\u0C55\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0730\u0062", "\u00E0\u05AE\u0730\u0315\u0062"},
    {"\u0061\u0730\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0730\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0731\u0062", "\u0061\u1DFA\u0316\u0731\u059A\u0062"},
    {"\u0061\u0731\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0731\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0732\u0062", "\u00E0\u05AE\u0732\u0315\u0062"},
    {"\u0061\u0732\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0732\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0733\u0062", "\u00E0\u05AE\u0733\u0315\u0062"},
    {"\u0061\u0733\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0733\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0734\u0062", "\u0061\u1DFA\u0316\u0734\u059A\u0062"},
    {"\u0061\u0734\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0734\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0735\u0062", "\u00E0\u05AE\u0735\u0315\u0062"},
    {"\u0061\u0735\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0735\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0736\u0062", "\u00E0\u05AE\u0736\u0315\u0062"},
    {"\u0061\u0736\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0736\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0737\u0062", "\u0061\u1DFA\u0316\u0737\u059A\u0062"},
    {"\u0061\u0737\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0737\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0738\u0062", "\u0061\u1DFA\u0316\u0738\u059A\u0062"},
    {"\u0061\u0738\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0738\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0739\u0062", "\u0061\u1DFA\u0316\u0739\u059A\u0062"},
    {"\u0061\u0739\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0739\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u073A\u0062", "\u00E0\u05AE\u073A\u0315\u0062"},
    {"\u0061\u073A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u073A\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u073B\u0062", "\u0061\u1DFA\u0316\u073B\u059A\u0062"},
    {"\u0061\u073B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u073B\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u073C\u0062", "\u0061\u1DFA\u0316\u073C\u059A\u0062"},
    {"\u0061\u073C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u073C\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u073D\u0062", "\u00E0\u05AE\u073D\u0315\u0062"},
    {"\u0061\u073D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u073D\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u073E\u0062", "\u0061\u1DFA\u0316\u073E\u059A\u0062"},
    {"\u0061\u073E\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u073E\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u073F\u0062", "\u00E0\u05AE\u073F\u0315\u0062"},
    {"\u0061\u073F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u073F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0740\u0062", "\u00E0\u05AE\u0740\u0315\u0062"},
    {"\u0061\u0740\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0740\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0741\u0062", "\u00E0\u05AE\u0741\u0315\u0062"},
    {"\u0061\u0741\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0741\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0742\u0062", "\u0061\u1DFA\u0316\u0742\u059A\u0062"},
    {"\u0061\u0742\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0742\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0743\u0062", "\u00E0\u05AE\u0743\u0315\u0062"},
    {"\u0061\u0743\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0743\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0744\u0062", "\u0061\u1DFA\u0316\u0744\u059A\u0062"},
    {"\u0061\u0744\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0744\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0745\u0062", "\u00E0\u05AE\u0745\u0315\u0062"},
    {"\u0061\u0745\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0745\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0746\u0062", "\u0061\u1DFA\u0316\u0746\u059A\u0062"},
    {"\u0061\u0746\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0746\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0747\u0062", "\u00E0\u05AE\u0747\u0315\u0062"},
    {"\u0061\u0747\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0747\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0748\u0062", "\u0061\u1DFA\u0316\u0748\u059A\u0062"},
    {"\u0061\u0748\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0748\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0749\u0062", "\u00E0\u05AE\u0749\u0315\u0062"},
    {"\u0061\u0749\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0749\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u074A\u0062", "\u00E0\u05AE\u074A\u0315\u0062"},
    {"\u0061\u074A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u074A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07EB\u0062", "\u00E0\u05AE\u07EB\u0315\u0062"},
    {"\u0061\u07EB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07EB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07EC\u0062", "\u00E0\u05AE\u07EC\u0315\u0062"},
    {"\u0061\u07EC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07EC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07ED\u0062", "\u00E0\u05AE\u07ED\u0315\u0062"},
    {"\u0061\u07ED\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07ED\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07EE\u0062", "\u00E0\u05AE\u07EE\u0315\u0062"},
    {"\u0061\u07EE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07EE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07EF\u0062", "\u00E0\u05AE\u07EF\u0315\u0062"},
    {"\u0061\u07EF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07EF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07F0\u0062", "\u00E0\u05AE\u07F0\u0315\u0062"},
    {"\u0061\u07F0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07F0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07F1\u0062", "\u00E0\u05AE\u07F1\u0315\u0062"},
    {"\u0061\u07F1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07F1\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u07F2\u0062", "\u0061\u1DFA\u0316\u07F2\u059A\u0062"},
    {"\u0061\u07F2\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u07F2\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u07F3\u0062", "\u00E0\u05AE\u07F3\u0315\u0062"},
    {"\u0061\u07F3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u07F3\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u07FD\u0062", "\u0061\u1DFA\u0316\u07FD\u059A\u0062"},
    {"\u0061\u07FD\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u07FD\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0816\u0062", "\u00E0\u05AE\u0816\u0315\u0062"},
    {"\u0061\u0816\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0816\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0817\u0062", "\u00E0\u05AE\u0817\u0315\u0062"},
    {"\u0061\u0817\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0817\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0818\u0062", "\u00E0\u05AE\u0818\u0315\u0062"},
    {"\u0061\u0818\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0818\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0819\u0062", "\u00E0\u05AE\u0819\u0315\u0062"},
    {"\u0061\u0819\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0819\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u081B\u0062", "\u00E0\u05AE\u081B\u0315\u0062"},
    {"\u0061\u081B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u081B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u081C\u0062", "\u00E0\u05AE\u081C\u0315\u0062"},
    {"\u0061\u081C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u081C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u081D\u0062", "\u00E0\u05AE\u081D\u0315\u0062"},
    {"\u0061\u081D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u081D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u081E\u0062", "\u00E0\u05AE\u081E\u0315\u0062"},
    {"\u0061\u081E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u081E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u081F\u0062", "\u00E0\u05AE\u081F\u0315\u0062"},
    {"\u0061\u081F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u081F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0820\u0062", "\u00E0\u05AE\u0820\u0315\u0062"},
    {"\u0061\u0820\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0820\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0821\u0062", "\u00E0\u05AE\u0821\u0315\u0062"},
    {"\u0061\u0821\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0821\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0822\u0062", "\u00E0\u05AE\u0822\u0315\u0062"},
    {"\u0061\u0822\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0822\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0823\u0062", "\u00E0\u05AE\u0823\u0315\u0062"},
    {"\u0061\u0823\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0823\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0825\u0062", "\u00E0\u05AE\u0825\u0315\u0062"},
    {"\u0061\u0825\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0825\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0826\u0062", "\u00E0\u05AE\u0826\u0315\u0062"},
    {"\u0061\u0826\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0826\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0827\u0062", "\u00E0\u05AE\u0827\u0315\u0062"},
    {"\u0061\u0827\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0827\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0829\u0062", "\u00E0\u05AE\u0829\u0315\u0062"},
    {"\u0061\u0829\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0829\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u082A\u0062", "\u00E0\u05AE\u082A\u0315\u0062"},
    {"\u0061\u082A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u082A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u082B\u0062", "\u00E0\u05AE\u082B\u0315\u0062"},
    {"\u0061\u082B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u082B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u082C\u0062", "\u00E0\u05AE\u082C\u0315\u0062"},
    {"\u0061\u082C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u082C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u082D\u0062", "\u00E0\u05AE\u082D\u0315\u0062"},
    {"\u0061\u082D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u082D\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0859\u0062", "\u0061\u1DFA\u0316\u0859\u059A\u0062"},
    {"\u0061\u0859\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0859\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u085A\u0062", "\u0061\u1DFA\u0316\u085A\u059A\u0062"},
    {"\u0061\u085A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u085A\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u085B\u0062", "\u0061\u1DFA\u0316\u085B\u059A\u0062"},
    {"\u0061\u085B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u085B\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0898\u0062", "\u00E0\u05AE\u0898\u0315\u0062"},
    {"\u0061\u0898\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0898\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0899\u0062", "\u0061\u1DFA\u0316\u0899\u059A\u0062"},
    {"\u0061\u0899\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0899\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u089A\u0062", "\u0061\u1DFA\u0316\u089A\u059A\u0062"},
    {"\u0061\u089A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u089A\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u089B\u0062", "\u0061\u1DFA\u0316\u089B\u059A\u0062"},
    {"\u0061\u089B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u089B\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u089C\u0062", "\u00E0\u05AE\u089C\u0315\u0062"},
    {"\u0061\u089C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u089C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u089D\u0062", "\u00E0\u05AE\u089D\u0315\u0062"},
    {"\u0061\u089D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u089D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u089E\u0062", "\u00E0\u05AE\u089E\u0315\u0062"},
    {"\u0061\u089E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u089E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u089F\u0062", "\u00E0\u05AE\u089F\u0315\u0062"},
    {"\u0061\u089F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u089F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08CA\u0062", "\u00E0\u05AE\u08CA\u0315\u0062"},
    {"\u0061\u08CA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08CA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08CB\u0062", "\u00E0\u05AE\u08CB\u0315\u0062"},
    {"\u0061\u08CB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08CB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08CC\u0062", "\u00E0\u05AE\u08CC\u0315\u0062"},
    {"\u0061\u08CC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08CC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08CD\u0062", "\u00E0\u05AE\u08CD\u0315\u0062"},
    {"\u0061\u08CD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08CD\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08CE\u0062", "\u00E0\u05AE\u08CE\u0315\u0062"},
    {"\u0061\u08CE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08CE\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08CF\u0062", "\u0061\u1DFA\u0316\u08CF\u059A\u0062"},
    {"\u0061\u08CF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08CF\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08D0\u0062", "\u0061\u1DFA\u0316\u08D0\u059A\u0062"},
    {"\u0061\u08D0\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08D0\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08D1\u0062", "\u0061\u1DFA\u0316\u08D1\u059A\u0062"},
    {"\u0061\u08D1\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08D1\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08D2\u0062", "\u0061\u1DFA\u0316\u08D2\u059A\u0062"},
    {"\u0061\u08D2\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08D2\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08D3\u0062", "\u0061\u1DFA\u0316\u08D3\u059A\u0062"},
    {"\u0061\u08D3\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08D3\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08D4\u0062", "\u00E0\u05AE\u08D4\u0315\u0062"},
    {"\u0061\u08D4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08D4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08D5\u0062", "\u00E0\u05AE\u08D5\u0315\u0062"},
    {"\u0061\u08D5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08D5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08D6\u0062", "\u00E0\u05AE\u08D6\u0315\u0062"},
    {"\u0061\u08D6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08D6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08D7\u0062", "\u00E0\u05AE\u08D7\u0315\u0062"},
    {"\u0061\u08D7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08D7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08D8\u0062", "\u00E0\u05AE\u08D8\u0315\u0062"},
    {"\u0061\u08D8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08D8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08D9\u0062", "\u00E0\u05AE\u08D9\u0315\u0062"},
    {"\u0061\u08D9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08D9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08DA\u0062", "\u00E0\u05AE\u08DA\u0315\u0062"},
    {"\u0061\u08DA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08DA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08DB\u0062", "\u00E0\u05AE\u08DB\u0315\u0062"},
    {"\u0061\u08DB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08DB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08DC\u0062", "\u00E0\u05AE\u08DC\u0315\u0062"},
    {"\u0061\u08DC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08DC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08DD\u0062", "\u00E0\u05AE\u08DD\u0315\u0062"},
    {"\u0061\u08DD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08DD\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08DE\u0062", "\u00E0\u05AE\u08DE\u0315\u0062"},
    {"\u0061\u08DE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08DE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08DF\u0062", "\u00E0\u05AE\u08DF\u0315\u0062"},
    {"\u0061\u08DF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08DF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08E0\u0062", "\u00E0\u05AE\u08E0\u0315\u0062"},
    {"\u0061\u08E0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08E0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08E1\u0062", "\u00E0\u05AE\u08E1\u0315\u0062"},
    {"\u0061\u08E1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08E1\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08E3\u0062", "\u0061\u1DFA\u0316\u08E3\u059A\u0062"},
    {"\u0061\u08E3\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08E3\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08E4\u0062", "\u00E0\u05AE\u08E4\u0315\u0062"},
    {"\u0061\u08E4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08E4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08E5\u0062", "\u00E0\u05AE\u08E5\u0315\u0062"},
    {"\u0061\u08E5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08E5\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08E6\u0062", "\u0061\u1DFA\u0316\u08E6\u059A\u0062"},
    {"\u0061\u08E6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08E6\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08E7\u0062", "\u00E0\u05AE\u08E7\u0315\u0062"},
    {"\u0061\u08E7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08E7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08E8\u0062", "\u00E0\u05AE\u08E8\u0315\u0062"},
    {"\u0061\u08E8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08E8\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08E9\u0062", "\u0061\u1DFA\u0316\u08E9\u059A\u0062"},
    {"\u0061\u08E9\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08E9\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08EA\u0062", "\u00E0\u05AE\u08EA\u0315\u0062"},
    {"\u0061\u08EA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08EA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08EB\u0062", "\u00E0\u05AE\u08EB\u0315\u0062"},
    {"\u0061\u08EB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08EB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08EC\u0062", "\u00E0\u05AE\u08EC\u0315\u0062"},
    {"\u0061\u08EC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08EC\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08ED\u0062", "\u0061\u1DFA\u0316\u08ED\u059A\u0062"},
    {"\u0061\u08ED\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08ED\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08EE\u0062", "\u0061\u1DFA\u0316\u08EE\u059A\u0062"},
    {"\u0061\u08EE\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08EE\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08EF\u0062", "\u0061\u1DFA\u0316\u08EF\u059A\u0062"},
    {"\u0061\u08EF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08EF\u0316\u059A\u0062"},
    {"\u0061\u064C\u064B\uFB1E\u08F0\u0062", "\u0061\uFB1E\u064B\u08F0\u064C\u0062"},
    {"\u0061\u08F0\u064C\u064B\uFB1E\u0062", "\u0061\uFB1E\u08F0\u064B\u064C\u0062"},
    {"\u0061\u064D\u064C\u064B\u08F1\u0062", "\u0061\u064B\u064C\u08F1\u064D\u0062"},
    {"\u0061\u08F1\u064D\u064C\u064B\u0062", "\u0061\u064B\u08F1\u064C\u064D\u0062"},
    {"\u0061\u0618\u064D\u064C\u08F2\u0062", "\u0061\u064C\u064D\u08F2\u0618\u0062"},
    {"\u0061\u08F2\u0618\u064D\u064C\u0062", "\u0061\u064C\u08F2\u064D\u0618\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08F3\u0062", "\u00E0\u05AE\u08F3\u0315\u0062"},
    {"\u0061\u08F3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08F3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08F4\u0062", "\u00E0\u05AE\u08F4\u0315\u0062"},
    {"\u0061\u08F4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08F4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08F5\u0062", "\u00E0\u05AE\u08F5\u0315\u0062"},
    {"\u0061\u08F5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08F5\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08F6\u0062", "\u0061\u1DFA\u0316\u08F6\u059A\u0062"},
    {"\u0061\u08F6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08F6\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08F7\u0062", "\u00E0\u05AE\u08F7\u0315\u0062"},
    {"\u0061\u08F7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08F7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08F8\u0062", "\u00E0\u05AE\u08F8\u0315\u0062"},
    {"\u0061\u08F8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08F8\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08F9\u0062", "\u0061\u1DFA\u0316\u08F9\u059A\u0062"},
    {"\u0061\u08F9\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08F9\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u08FA\u0062", "\u0061\u1DFA\u0316\u08FA\u059A\u0062"},
    {"\u0061\u08FA\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u08FA\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08FB\u0062", "\u00E0\u05AE\u08FB\u0315\u0062"},
    {"\u0061\u08FB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08FB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08FC\u0062", "\u00E0\u05AE\u08FC\u0315\u0062"},
    {"\u0061\u08FC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08FC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08FD\u0062", "\u00E0\u05AE\u08FD\u0315\u0062"},
    {"\u0061\u08FD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08FD\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08FE\u0062", "\u00E0\u05AE\u08FE\u0315\u0062"},
    {"\u0061\u08FE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08FE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u08FF\u0062", "\u00E0\u05AE\u08FF\u0315\u0062"},
    {"\u0061\u08FF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u08FF\u0300\u0315\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u093C\u0062", "\u0061\U00016FF0\u093C\u093C\u3099\u0062"},
    {"\u0061\u093C\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u093C\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u094D\u0062", "\u0061\u3099\u094D\u094D\u05B0\u0062"},
    {"\u0061\u094D\u05B0\u094D\u3099\u0062", "\u0061\u3099\u094D\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0951\u0062", "\u00E0\u05AE\u0951\u0315\u0062"},
    {"\u0061\u0951\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0951\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0952\u0062", "\u0061\u1DFA\u0316\u0952\u059A\u0062"},
    {"\u0061\u0952\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0952\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0953\u0062", "\u00E0\u05AE\u0953\u0315\u0062"},
    {"\u0061\u0953\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0953\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0954\u0062", "\u00E0\u05AE\u0954\u0315\u0062"},
    {"\u0061\u0954\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0954\u0300\u0315\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u09BC\u0062", "\u0061\U00016FF0\u093C\u09BC\u3099\u0062"},
    {"\u0061\u09BC\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u09BC\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u09CD\u0062", "\u0061\u3099\u094D\u09CD\u05B0\u0062"},
    {"\u0061\u09CD\u05B0\u094D\u3099\u0062", "\u0061\u3099\u09CD\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u09FE\u0062", "\u00E0\u05AE\u09FE\u0315\u0062"},
    {"\u0061\u09FE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u09FE\u0300\u0315\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u0A3C\u0062", "\u0061\U00016FF0\u093C\u0A3C\u3099\u0062"},
    {"\u0061\u0A3C\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u0A3C\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0A4D\u0062", "\u0061\u3099\u094D\u0A4D\u05B0\u0062"},
    {"\u0061\u0A4D\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0A4D\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u0ABC\u0062", "\u0061\U00016FF0\u093C\u0ABC\u3099\u0062"},
    {"\u0061\u0ABC\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u0ABC\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0ACD\u0062", "\u0061\u3099\u094D\u0ACD\u05B0\u0062"},
    {"\u0061\u0ACD\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0ACD\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u0B3C\u0062", "\u0061\U00016FF0\u093C\u0B3C\u3099\u0062"},
    {"\u0061\u0B3C\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u0B3C\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0B4D\u0062", "\u0061\u3099\u094D\u0B4D\u05B0\u0062"},
    {"\u0061\u0B4D\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0B4D\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0BCD\u0062", "\u0061\u3099\u094D\u0BCD\u05B0\u0062"},
    {"\u0061\u0BCD\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0BCD\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u0C3C\u0062", "\u0061\U00016FF0\u093C\u0C3C\u3099\u0062"},
    {"\u0061\u0C3C\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u0C3C\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0C4D\u0062", "\u0061\u3099\u094D\u0C4D\u05B0\u0062"},
    {"\u0061\u0C4D\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0C4D\u094D\u05B0\u0062"},
    {"\u0061\u0C56\u0C55\u0711\u0C55\u0062", "\u0061\u0711\u0C55\u0C55\u0C56\u0062"},
    {"\u0061\u0C55\u0C56\u0C55\u0711\u0062", "\u0061\u0711\u0C55\u0C55\u0C56\u0062"},
    {"\u0061\u0E38\u0C56\u0C55\u0C56\u0062", "\u0061\u0C55\u0C56\u0C56\u0E38\u0062"},
    {"\u0061\u0C56\u0E38\u0C56\u0C55\u0062", "\u0061\u0C55\u0C56\u0C56\u0E38\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u0CBC\u0062", "\u0061\U00016FF0\u093C\u0CBC\u3099\u0062"},
    {"\u0061\u0CBC\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u0CBC\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0CCD\u0062", "\u0061\u3099\u094D\u0CCD\u05B0\u0062"},
    {"\u0061\u0CCD\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0CCD\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0D3B\u0062", "\u0061\u3099\u094D\u0D3B\u05B0\u0062"},
    {"\u0061\u0D3B\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0D3B\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0D3C\u0062", "\u0061\u3099\u094D\u0D3C\u05B0\u0062"},
    {"\u0061\u0D3C\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0D3C\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0D4D\u0062", "\u0061\u3099\u094D\u0D4D\u05B0\u0062"},
    {"\u0061\u0D4D\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0D4D\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0DCA\u0062", "\u0061\u3099\u094D\u0DCA\u05B0\u0062"},
    {"\u0061\u0DCA\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0DCA\u094D\u05B0\u0062"},
    {"\u0061\u0E48\u0E38\u0C56\u0E38\u0062", "\u0061\u0C56\u0E38\u0E38\u0E48\u0062"},
    {"\u0061\u0E38\u0E48\u0E38\u0C56\u0062", "\u0061\u0C56\u0E38\u0E38\u0E48\u0062"},
    {"\u0061\u0E48\u0E38\u0C56\u0E39\u0062", "\u0061\u0C56\u0E38\u0E39\u0E48\u0062"},
    {"\u0061\u0E39\u0E48\u0E38\u0C56\u0062", "\u0061\u0C56\u0E39\u0E38\u0E48\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0E3A\u0062", "\u0061\u3099\u094D\u0E3A\u05B0\u0062"},
    {"\u0061\u0E3A\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0E3A\u094D\u05B0\u0062"},
    {"\u0061\u0EB8\u0E48\u0E38\u0E48\u0062", "\u0061\u0E38\u0E48\u0E48\u0EB8\u0062"},
    {"\u0061\u0E48\u0EB8\u0E48\u0E38\u0062", "\u0061\u0E38\u0E48\u0E48\u0EB8\u0062"},
    {"\u0061\u0EB8\u0E48\u0E38\u0E49\u0062", "\u0061\u0E38\u0E48\u0E49\u0EB8\u0062"},
    {"\u0061\u0E49\u0EB8\u0E48\u0E38\u0062", "\u0061\u0E38\u0E49\u0E48\u0EB8\u0062"},
    {"\u0061\u0EB8\u0E48\u0E38\u0E4A\u0062", "\u0061\u0E38\u0E48\u0E4A\u0EB8\u0062"},
    {"\u0061\u0E4A\u0EB8\u0E48\u0E38\u0062", "\u0061\u0E38\u0E4A\u0E48\u0EB8\u0062"},
    {"\u0061\u0EB8\u0E48\u0E38\u0E4B\u0062", "\u0061\u0E38\u0E48\u0E4B\u0EB8\u0062"},
    {"\u0061\u0E4B\u0EB8\u0E48\u0E38\u0062", "\u0061\u0E38\u0E4B\u0E48\u0EB8\u0062"},
    {"\u0061\u0EC8\u0EB8\u0E48\u0EB8\u0062", "\u0061\u0E48\u0EB8\u0EB8\u0EC8\u0062"},
    {"\u0061\u0EB8\u0EC8\u0EB8\u0E48\u0062", "\u0061\u0E48\u0EB8\u0EB8\u0EC8\u0062"},
    {"\u0061\u0EC8\u0EB8\u0E48\u0EB9\u0062", "\u0061\u0E48\u0EB8\u0EB9\u0EC8\u0062"},
    {"\u0061\u0EB9\u0EC8\u0EB8\u0E48\u0062", "\u0061\u0E48\u0EB9\u0EB8\u0EC8\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0EBA\u0062", "\u0061\u3099\u094D\u0EBA\u05B0\u0062"},
    {"\u0061\u0EBA\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0EBA\u094D\u05B0\u0062"},
    {"\u0061\u0F71\u0EC8\u0EB8\u0EC8\u0062", "\u0061\u0EB8\u0EC8\u0EC8\u0F71\u0062"},
    {"\u0061\u0EC8\u0F71\u0EC8\u0EB8\u0062", "\u0061\u0EB8\u0EC8\u0EC8\u0F71\u0062"},
    {"\u0061\u0F71\u0EC8\u0EB8\u0EC9\u0062", "\u0061\u0EB8\u0EC8\u0EC9\u0F71\u0062"},
    {"\u0061\u0EC9\u0F71\u0EC8\u0EB8\u0062", "\u0061\u0EB8\u0EC9\u0EC8\u0F71\u0062"},
    {"\u0061\u0F71\u0EC8\u0EB8\u0ECA\u0062", "\u0061\u0EB8\u0EC8\u0ECA\u0F71\u0062"},
    {"\u0061\u0ECA\u0F71\u0EC8\u0EB8\u0062", "\u0061\u0EB8\u0ECA\u0EC8\u0F71\u0062"},
    {"\u0061\u0F71\u0EC8\u0EB8\u0ECB\u0062", "\u0061\u0EB8\u0EC8\u0ECB\u0F71\u0062"},
    {"\u0061\u0ECB\u0F71\u0EC8\u0EB8\u0062", "\u0061\u0EB8\u0ECB\u0EC8\u0F71\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0F18\u0062", "\u0061\u1DFA\u0316\u0F18\u059A\u0062"},
    {"\u0061\u0F18\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0F18\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0F19\u0062", "\u0061\u1DFA\u0316\u0F19\u059A\u0062"},
    {"\u0061\u0F19\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0F19\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0F35\u0062", "\u0061\u1DFA\u0316\u0F35\u059A\u0062"},
    {"\u0061\u0F35\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0F35\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0F37\u0062", "\u0061\u1DFA\u0316\u0F37\u059A\u0062"},
    {"\u0061\u0F37\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0F37\u0316\u059A\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\u0F39\u0062", "\u0061\u1DCE\u031B\u0F39\u1DFA\u0062"},
    {"\u0061\u0F39\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\u0F39\u031B\u1DFA\u0062"},
    {"\u0061\u0F72\u0F71\u0EC8\u0F71\u0062", "\u0061\u0EC8\u0F71\u0F71\u0F72\u0062"},
    {"\u0061\u0F71\u0F72\u0F71\u0EC8\u0062", "\u0061\u0EC8\u0F71\u0F71\u0F72\u0062"},
    {"\u0061\u0F74\u0F72\u0F71\u0F72\u0062", "\u0061\u0F71\u0F72\u0F72\u0F74\u0062"},
    {"\u0061\u0F72\u0F74\u0F72\u0F71\u0062", "\u0061\u0F71\u0F72\u0F72\u0F74\u0062"},
    {"\u0061\u0321\u0F74\u0F72\u0F74\u0062", "\u0061\u0F72\u0F74\u0F74\u0321\u0062"},
    {"\u0061\u0F74\u0321\u0F74\u0F72\u0062", "\u0061\u0F72\u0F74\u0F74\u0321\u0062"},
    {"\u0061\u0F74\u0F72\u0F71\u0F7A\u0062", "\u0061\u0F71\u0F72\u0F7A\u0F74\u0062"},
    {"\u0061\u0F7A\u0F74\u0F72\u0F71\u0062", "\u0061\u0F71\u0F7A\u0F72\u0F74\u0062"},
    {"\u0061\u0F74\u0F72\u0F71\u0F7B\u0062", "\u0061\u0F71\u0F72\u0F7B\u0F74\u0062"},
    {"\u0061\u0F7B\u0F74\u0F72\u0F71\u0062", "\u0061\u0F71\u0F7B\u0F72\u0F74\u0062"},
    {"\u0061\u0F74\u0F72\u0F71\u0F7C\u0062", "\u0061\u0F71\u0F72\u0F7C\u0F74\u0062"},
    {"\u0061\u0F7C\u0F74\u0F72\u0F71\u0062", "\u0061\u0F71\u0F7C\u0F72\u0F74\u0062"},
    {"\u0061\u0F74\u0F72\u0F71\u0F7D\u0062", "\u0061\u0F71\u0F72\u0F7D\u0F74\u0062"},
    {"\u0061\u0F7D\u0F74\u0F72\u0F71\u0062", "\u0061\u0F71\u0F7D\u0F72\u0F74\u0062"},
    {"\u0061\u0F74\u0F72\u0F71\u0F80\u0062", "\u0061\u0F71\u0F72\u0F80\u0F74\u0062"},
    {"\u0061\u0F80\u0F74\u0F72\u0F71\u0062", "\u0061\u0F71\u0F80\u0F72\u0F74\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0F82\u0062", "\u00E0\u05AE\u0F82\u0315\u0062"},
    {"\u0061\u0F82\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0F82\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0F83\u0062", "\u00E0\u05AE\u0F83\u0315\u0062"},
    {"\u0061\u0F83\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0F83\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\u0F84\u0062", "\u0061\u3099\u094D\u0F84\u05B0\u0062"},
    {"\u0061\u0F84\u05B0\u094D\u3099\u0062", "\u0061\u3099\u0F84\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0F86\u0062", "\u00E0\u05AE\u0F86\u0315\u0062"},
    {"\u0061\u0F86\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0F86\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u0F87\u0062", "\u00E0\u05AE\u0F87\u0315\u0062"},
    {"\u0061\u0F87\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u0F87\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u0FC6\u0062", "\u0061\u1DFA\u0316\u0FC6\u059A\u0062"},
    {"\u0061\u0FC6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u0FC6\u0316\u059A\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u1037\u0062", "\u0061\U00016FF0\u093C\u1037\u3099\u0062"},
    {"\u0061\u1037\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u1037\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1039\u0062", "\u0061\u3099\u094D\u1039\u05B0\u0062"},
    {"\u0061\u1039\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1039\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u103A\u0062", "\u0061\u3099\u094D\u103A\u05B0\u0062"},
    {"\u0061\u103A\u05B0\u094D\u3099\u0062", "\u0061\u3099\u103A\u094D\u05B0\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u108D\u0062", "\u0061\u1DFA\u0316\u108D\u059A\u0062"},
    {"\u0061\u108D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u108D\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u135D\u0062", "\u00E0\u05AE\u135D\u0315\u0062"},
    {"\u0061\u135D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u135D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u135E\u0062", "\u00E0\u05AE\u135E\u0315\u0062"},
    {"\u0061\u135E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u135E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u135F\u0062", "\u00E0\u05AE\u135F\u0315\u0062"},
    {"\u0061\u135F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u135F\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1714\u0062", "\u0061\u3099\u094D\u1714\u05B0\u0062"},
    {"\u0061\u1714\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1714\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1715\u0062", "\u0061\u3099\u094D\u1715\u05B0\u0062"},
    {"\u0061\u1715\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1715\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1734\u0062", "\u0061\u3099\u094D\u1734\u05B0\u0062"},
    {"\u0061\u1734\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1734\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u17D2\u0062", "\u0061\u3099\u094D\u17D2\u05B0\u0062"},
    {"\u0061\u17D2\u05B0\u094D\u3099\u0062", "\u0061\u3099\u17D2\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u17DD\u0062", "\u00E0\u05AE\u17DD\u0315\u0062"},
    {"\u0061\u17DD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u17DD\u0300\u0315\u0062"},
    {"\u0061\u0300\u05AE\U0001D16D\u18A9\u0062", "\u00E0\U0001D16D\u05AE\u18A9\u0062"},
    {"\u0061\u18A9\u0300\u05AE\U0001D16D\u0062", "\u00E0\U0001D16D\u18A9\u05AE\u0062"},
    {"\u0061\u302E\u059A\u0316\u1939\u0062", "\u0061\u0316\u059A\u1939\u302E\u0062"},
    {"\u0061\u1939\u302E\u059A\u0316\u0062", "\u0061\u0316\u1939\u059A\u302E\u0062"},
    {"\u0061\u0315\u0300\u05AE\u193A\u0062", "\u00E0\u05AE\u193A\u0315\u0062"},
    {"\u0061\u193A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u193A\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u193B\u0062", "\u0061\u1DFA\u0316\u193B\u059A\u0062"},
    {"\u0061\u193B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u193B\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A17\u0062", "\u00E0\u05AE\u1A17\u0315\u0062"},
    {"\u0061\u1A17\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A17\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1A18\u0062", "\u0061\u1DFA\u0316\u1A18\u059A\u0062"},
    {"\u0061\u1A18\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1A18\u0316\u059A\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1A60\u0062", "\u0061\u3099\u094D\u1A60\u05B0\u0062"},
    {"\u0061\u1A60\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1A60\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A75\u0062", "\u00E0\u05AE\u1A75\u0315\u0062"},
    {"\u0061\u1A75\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A75\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A76\u0062", "\u00E0\u05AE\u1A76\u0315\u0062"},
    {"\u0061\u1A76\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A76\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A77\u0062", "\u00E0\u05AE\u1A77\u0315\u0062"},
    {"\u0061\u1A77\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A77\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A78\u0062", "\u00E0\u05AE\u1A78\u0315\u0062"},
    {"\u0061\u1A78\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A78\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A79\u0062", "\u00E0\u05AE\u1A79\u0315\u0062"},
    {"\u0061\u1A79\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A79\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A7A\u0062", "\u00E0\u05AE\u1A7A\u0315\u0062"},
    {"\u0061\u1A7A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A7A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A7B\u0062", "\u00E0\u05AE\u1A7B\u0315\u0062"},
    {"\u0061\u1A7B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A7B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1A7C\u0062", "\u00E0\u05AE\u1A7C\u0315\u0062"},
    {"\u0061\u1A7C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1A7C\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1A7F\u0062", "\u0061\u1DFA\u0316\u1A7F\u059A\u0062"},
    {"\u0061\u1A7F\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1A7F\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AB0\u0062", "\u00E0\u05AE\u1AB0\u0315\u0062"},
    {"\u0061\u1AB0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AB0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AB1\u0062", "\u00E0\u05AE\u1AB1\u0315\u0062"},
    {"\u0061\u1AB1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AB1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AB2\u0062", "\u00E0\u05AE\u1AB2\u0315\u0062"},
    {"\u0061\u1AB2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AB2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AB3\u0062", "\u00E0\u05AE\u1AB3\u0315\u0062"},
    {"\u0061\u1AB3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AB3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AB4\u0062", "\u00E0\u05AE\u1AB4\u0315\u0062"},
    {"\u0061\u1AB4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AB4\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AB5\u0062", "\u0061\u1DFA\u0316\u1AB5\u059A\u0062"},
    {"\u0061\u1AB5\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AB5\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AB6\u0062", "\u0061\u1DFA\u0316\u1AB6\u059A\u0062"},
    {"\u0061\u1AB6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AB6\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AB7\u0062", "\u0061\u1DFA\u0316\u1AB7\u059A\u0062"},
    {"\u0061\u1AB7\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AB7\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AB8\u0062", "\u0061\u1DFA\u0316\u1AB8\u059A\u0062"},
    {"\u0061\u1AB8\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AB8\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AB9\u0062", "\u0061\u1DFA\u0316\u1AB9\u059A\u0062"},
    {"\u0061\u1AB9\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AB9\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1ABA\u0062", "\u0061\u1DFA\u0316\u1ABA\u059A\u0062"},
    {"\u0061\u1ABA\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1ABA\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1ABB\u0062", "\u00E0\u05AE\u1ABB\u0315\u0062"},
    {"\u0061\u1ABB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1ABB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1ABC\u0062", "\u00E0\u05AE\u1ABC\u0315\u0062"},
    {"\u0061\u1ABC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1ABC\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1ABD\u0062", "\u0061\u1DFA\u0316\u1ABD\u059A\u0062"},
    {"\u0061\u1ABD\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1ABD\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1ABF\u0062", "\u0061\u1DFA\u0316\u1ABF\u059A\u0062"},
    {"\u0061\u1ABF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1ABF\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AC0\u0062", "\u0061\u1DFA\u0316\u1AC0\u059A\u0062"},
    {"\u0061\u1AC0\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AC0\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AC1\u0062", "\u00E0\u05AE\u1AC1\u0315\u0062"},
    {"\u0061\u1AC1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AC1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AC2\u0062", "\u00E0\u05AE\u1AC2\u0315\u0062"},
    {"\u0061\u1AC2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AC2\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AC3\u0062", "\u0061\u1DFA\u0316\u1AC3\u059A\u0062"},
    {"\u0061\u1AC3\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AC3\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1AC4\u0062", "\u0061\u1DFA\u0316\u1AC4\u059A\u0062"},
    {"\u0061\u1AC4\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1AC4\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AC5\u0062", "\u00E0\u05AE\u1AC5\u0315\u0062"},
    {"\u0061\u1AC5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AC5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AC6\u0062", "\u00E0\u05AE\u1AC6\u0315\u0062"},
    {"\u0061\u1AC6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AC6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AC7\u0062", "\u00E0\u05AE\u1AC7\u0315\u0062"},
    {"\u0061\u1AC7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AC7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AC8\u0062", "\u00E0\u05AE\u1AC8\u0315\u0062"},
    {"\u0061\u1AC8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AC8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1AC9\u0062", "\u00E0\u05AE\u1AC9\u0315\u0062"},
    {"\u0061\u1AC9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1AC9\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1ACA\u0062", "\u0061\u1DFA\u0316\u1ACA\u059A\u0062"},
    {"\u0061\u1ACA\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1ACA\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1ACB\u0062", "\u00E0\u05AE\u1ACB\u0315\u0062"},
    {"\u0061\u1ACB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1ACB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1ACC\u0062", "\u00E0\u05AE\u1ACC\u0315\u0062"},
    {"\u0061\u1ACC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1ACC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1ACD\u0062", "\u00E0\u05AE\u1ACD\u0315\u0062"},
    {"\u0061\u1ACD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1ACD\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1ACE\u0062", "\u00E0\u05AE\u1ACE\u0315\u0062"},
    {"\u0061\u1ACE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1ACE\u0300\u0315\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u1B34\u0062", "\u0061\U00016FF0\u093C\u1B34\u3099\u0062"},
    {"\u0061\u1B34\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u1B34\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1B44\u0062", "\u0061\u3099\u094D\u1B44\u05B0\u0062"},
    {"\u0061\u1B44\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1B44\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B6B\u0062", "\u00E0\u05AE\u1B6B\u0315\u0062"},
    {"\u0061\u1B6B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B6B\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1B6C\u0062", "\u0061\u1DFA\u0316\u1B6C\u059A\u0062"},
    {"\u0061\u1B6C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1B6C\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B6D\u0062", "\u00E0\u05AE\u1B6D\u0315\u0062"},
    {"\u0061\u1B6D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B6D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B6E\u0062", "\u00E0\u05AE\u1B6E\u0315\u0062"},
    {"\u0061\u1B6E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B6E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B6F\u0062", "\u00E0\u05AE\u1B6F\u0315\u0062"},
    {"\u0061\u1B6F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B6F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B70\u0062", "\u00E0\u05AE\u1B70\u0315\u0062"},
    {"\u0061\u1B70\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B70\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B71\u0062", "\u00E0\u05AE\u1B71\u0315\u0062"},
    {"\u0061\u1B71\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B71\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B72\u0062", "\u00E0\u05AE\u1B72\u0315\u0062"},
    {"\u0061\u1B72\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B72\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1B73\u0062", "\u00E0\u05AE\u1B73\u0315\u0062"},
    {"\u0061\u1B73\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1B73\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1BAA\u0062", "\u0061\u3099\u094D\u1BAA\u05B0\u0062"},
    {"\u0061\u1BAA\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1BAA\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1BAB\u0062", "\u0061\u3099\u094D\u1BAB\u05B0\u0062"},
    {"\u0061\u1BAB\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1BAB\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u1BE6\u0062", "\u0061\U00016FF0\u093C\u1BE6\u3099\u0062"},
    {"\u0061\u1BE6\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u1BE6\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1BF2\u0062", "\u0061\u3099\u094D\u1BF2\u05B0\u0062"},
    {"\u0061\u1BF2\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1BF2\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\u1BF3\u0062", "\u0061\u3099\u094D\u1BF3\u05B0\u0062"},
    {"\u0061\u1BF3\u05B0\u094D\u3099\u0062", "\u0061\u3099\u1BF3\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\u1C37\u0062", "\u0061\U00016FF0\u093C\u1C37\u3099\u0062"},
    {"\u0061\u1C37\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\u1C37\u093C\u3099\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CD0\u0062", "\u00E0\u05AE\u1CD0\u0315\u0062"},
    {"\u0061\u1CD0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CD0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CD1\u0062", "\u00E0\u05AE\u1CD1\u0315\u0062"},
    {"\u0061\u1CD1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CD1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CD2\u0062", "\u00E0\u05AE\u1CD2\u0315\u0062"},
    {"\u0061\u1CD2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CD2\u0300\u0315\u0062"},
    {"\u0061\U00016FF0\u0334\u1CD4\u0062", "\u0061\u0334\u1CD4\U00016FF0\u0062"},
    {"\u0061\u1CD4\U00016FF0\u0334\u0062", "\u0061\u1CD4\u0334\U00016FF0\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CD5\u0062", "\u0061\u1DFA\u0316\u1CD5\u059A\u0062"},
    {"\u0061\u1CD5\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CD5\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CD6\u0062", "\u0061\u1DFA\u0316\u1CD6\u059A\u0062"},
    {"\u0061\u1CD6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CD6\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CD7\u0062", "\u0061\u1DFA\u0316\u1CD7\u059A\u0062"},
    {"\u0061\u1CD7\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CD7\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CD8\u0062", "\u0061\u1DFA\u0316\u1CD8\u059A\u0062"},
    {"\u0061\u1CD8\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CD8\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CD9\u0062", "\u0061\u1DFA\u0316\u1CD9\u059A\u0062"},
    {"\u0061\u1CD9\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CD9\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CDA\u0062", "\u00E0\u05AE\u1CDA\u0315\u0062"},
    {"\u0061\u1CDA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CDA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CDB\u0062", "\u00E0\u05AE\u1CDB\u0315\u0062"},
    {"\u0061\u1CDB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CDB\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CDC\u0062", "\u0061\u1DFA\u0316\u1CDC\u059A\u0062"},
    {"\u0061\u1CDC\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CDC\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CDD\u0062", "\u0061\u1DFA\u0316\u1CDD\u059A\u0062"},
    {"\u0061\u1CDD\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CDD\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CDE\u0062", "\u0061\u1DFA\u0316\u1CDE\u059A\u0062"},
    {"\u0061\u1CDE\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CDE\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CDF\u0062", "\u0061\u1DFA\u0316\u1CDF\u059A\u0062"},
    {"\u0061\u1CDF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CDF\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CE0\u0062", "\u00E0\u05AE\u1CE0\u0315\u0062"},
    {"\u0061\u1CE0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CE0\u0300\u0315\u0062"},
    {"\u0061\U00016FF0\u0334\u1CE2\u0062", "\u0061\u0334\u1CE2\U00016FF0\u0062"},
    {"\u0061\u1CE2\U00016FF0\u0334\u0062", "\u0061\u1CE2\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u1CE3\u0062", "\u0061\u0334\u1CE3\U00016FF0\u0062"},
    {"\u0061\u1CE3\U00016FF0\u0334\u0062", "\u0061\u1CE3\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u1CE4\u0062", "\u0061\u0334\u1CE4\U00016FF0\u0062"},
    {"\u0061\u1CE4\U00016FF0\u0334\u0062", "\u0061\u1CE4\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u1CE5\u0062", "\u0061\u0334\u1CE5\U00016FF0\u0062"},
    {"\u0061\u1CE5\U00016FF0\u0334\u0062", "\u0061\u1CE5\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u1CE6\u0062", "\u0061\u0334\u1CE6\U00016FF0\u0062"},
    {"\u0061\u1CE6\U00016FF0\u0334\u0062", "\u0061\u1CE6\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u1CE7\u0062", "\u0061\u0334\u1CE7\U00016FF0\u0062"},
    {"\u0061\u1CE7\U00016FF0\u0334\u0062", "\u0061\u1CE7\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u1CE8\u0062", "\u0061\u0334\u1CE8\U00016FF0\u0062"},
    {"\u0061\u1CE8\U00016FF0\u0334\u0062", "\u0061\u1CE8\u0334\U00016FF0\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1CED\u0062", "\u0061\u1DFA\u0316\u1CED\u059A\u0062"},
    {"\u0061\u1CED\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1CED\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CF4\u0062", "\u00E0\u05AE\u1CF4\u0315\u0062"},
    {"\u0061\u1CF4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CF4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CF8\u0062", "\u00E0\u05AE\u1CF8\u0315\u0062"},
    {"\u0061\u1CF8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CF8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1CF9\u0062", "\u00E0\u05AE\u1CF9\u0315\u0062"},
    {"\u0061\u1CF9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1CF9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC0\u0062", "\u00E0\u05AE\u1DC0\u0315\u0062"},
    {"\u0061\u1DC0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC1\u0062", "\u00E0\u05AE\u1DC1\u0315\u0062"},
    {"\u0061\u1DC1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC1\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1DC2\u0062", "\u0061\u1DFA\u0316\u1DC2\u059A\u0062"},
    {"\u0061\u1DC2\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1DC2\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC3\u0062", "\u00E0\u05AE\u1DC3\u0315\u0062"},
    {"\u0061\u1DC3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC4\u0062", "\u00E0\u05AE\u1DC4\u0315\u0062"},
    {"\u0061\u1DC4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC5\u0062", "\u00E0\u05AE\u1DC5\u0315\u0062"},
    {"\u0061\u1DC5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC6\u0062", "\u00E0\u05AE\u1DC6\u0315\u0062"},
    {"\u0061\u1DC6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC7\u0062", "\u00E0\u05AE\u1DC7\u0315\u0062"},
    {"\u0061\u1DC7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC8\u0062", "\u00E0\u05AE\u1DC8\u0315\u0062"},
    {"\u0061\u1DC8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DC9\u0062", "\u00E0\u05AE\u1DC9\u0315\u0062"},
    {"\u0061\u1DC9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DC9\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1DCA\u0062", "\u0061\u1DFA\u0316\u1DCA\u059A\u0062"},
    {"\u0061\u1DCA\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1DCA\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DCB\u0062", "\u00E0\u05AE\u1DCB\u0315\u0062"},
    {"\u0061\u1DCB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DCB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DCC\u0062", "\u00E0\u05AE\u1DCC\u0315\u0062"},
    {"\u0061\u1DCC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DCC\u0300\u0315\u0062"},
    {"\u0061\u0345\u035D\u035C\u1DCD\u0062", "\u0061\u035C\u035D\u1DCD\u0345\u0062"},
    {"\u0061\u1DCD\u0345\u035D\u035C\u0062", "\u0061\u035C\u1DCD\u035D\u0345\u0062"},
    {"\u0061\u031B\u1DCE\u0321\u1DCE\u0062", "\u0061\u0321\u1DCE\u1DCE\u031B\u0062"},
    {"\u0061\u1DCE\u031B\u1DCE\u0321\u0062", "\u0061\u0321\u1DCE\u1DCE\u031B\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1DCF\u0062", "\u0061\u1DFA\u0316\u1DCF\u059A\u0062"},
    {"\u0061\u1DCF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1DCF\u0316\u059A\u0062"},
    {"\u0061\u1DCE\u0321\u0F74\u1DD0\u0062", "\u0061\u0F74\u0321\u1DD0\u1DCE\u0062"},
    {"\u0061\u1DD0\u1DCE\u0321\u0F74\u0062", "\u0061\u0F74\u1DD0\u0321\u1DCE\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD1\u0062", "\u00E0\u05AE\u1DD1\u0315\u0062"},
    {"\u0061\u1DD1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD2\u0062", "\u00E0\u05AE\u1DD2\u0315\u0062"},
    {"\u0061\u1DD2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD3\u0062", "\u00E0\u05AE\u1DD3\u0315\u0062"},
    {"\u0061\u1DD3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD4\u0062", "\u00E0\u05AE\u1DD4\u0315\u0062"},
    {"\u0061\u1DD4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD5\u0062", "\u00E0\u05AE\u1DD5\u0315\u0062"},
    {"\u0061\u1DD5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD6\u0062", "\u00E0\u05AE\u1DD6\u0315\u0062"},
    {"\u0061\u1DD6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD7\u0062", "\u00E0\u05AE\u1DD7\u0315\u0062"},
    {"\u0061\u1DD7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD8\u0062", "\u00E0\u05AE\u1DD8\u0315\u0062"},
    {"\u0061\u1DD8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DD9\u0062", "\u00E0\u05AE\u1DD9\u0315\u0062"},
    {"\u0061\u1DD9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DD9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DDA\u0062", "\u00E0\u05AE\u1DDA\u0315\u0062"},
    {"\u0061\u1DDA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DDA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DDB\u0062", "\u00E0\u05AE\u1DDB\u0315\u0062"},
    {"\u0061\u1DDB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DDB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DDC\u0062", "\u00E0\u05AE\u1DDC\u0315\u0062"},
    {"\u0061\u1DDC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DDC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DDD\u0062", "\u00E0\u05AE\u1DDD\u0315\u0062"},
    {"\u0061\u1DDD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DDD\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DDE\u0062", "\u00E0\u05AE\u1DDE\u0315\u0062"},
    {"\u0061\u1DDE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DDE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DDF\u0062", "\u00E0\u05AE\u1DDF\u0315\u0062"},
    {"\u0061\u1DDF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DDF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE0\u0062", "\u00E0\u05AE\u1DE0\u0315\u0062"},
    {"\u0061\u1DE0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE1\u0062", "\u00E0\u05AE\u1DE1\u0315\u0062"},
    {"\u0061\u1DE1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE2\u0062", "\u00E0\u05AE\u1DE2\u0315\u0062"},
    {"\u0061\u1DE2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE3\u0062", "\u00E0\u05AE\u1DE3\u0315\u0062"},
    {"\u0061\u1DE3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE4\u0062", "\u00E0\u05AE\u1DE4\u0315\u0062"},
    {"\u0061\u1DE4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE5\u0062", "\u00E0\u05AE\u1DE5\u0315\u0062"},
    {"\u0061\u1DE5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE6\u0062", "\u00E0\u05AE\u1DE6\u0315\u0062"},
    {"\u0061\u1DE6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE7\u0062", "\u00E0\u05AE\u1DE7\u0315\u0062"},
    {"\u0061\u1DE7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE8\u0062", "\u00E0\u05AE\u1DE8\u0315\u0062"},
    {"\u0061\u1DE8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DE9\u0062", "\u00E0\u05AE\u1DE9\u0315\u0062"},
    {"\u0061\u1DE9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DE9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DEA\u0062", "\u00E0\u05AE\u1DEA\u0315\u0062"},
    {"\u0061\u1DEA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DEA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DEB\u0062", "\u00E0\u05AE\u1DEB\u0315\u0062"},
    {"\u0061\u1DEB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DEB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DEC\u0062", "\u00E0\u05AE\u1DEC\u0315\u0062"},
    {"\u0061\u1DEC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DEC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DED\u0062", "\u00E0\u05AE\u1DED\u0315\u0062"},
    {"\u0061\u1DED\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DED\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DEE\u0062", "\u00E0\u05AE\u1DEE\u0315\u0062"},
    {"\u0061\u1DEE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DEE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DEF\u0062", "\u00E0\u05AE\u1DEF\u0315\u0062"},
    {"\u0061\u1DEF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DEF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DF0\u0062", "\u00E0\u05AE\u1DF0\u0315\u0062"},
    {"\u0061\u1DF0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DF0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DF1\u0062", "\u00E0\u05AE\u1DF1\u0315\u0062"},
    {"\u0061\u1DF1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DF1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DF2\u0062", "\u00E0\u05AE\u1DF2\u0315\u0062"},
    {"\u0061\u1DF2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DF2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DF3\u0062", "\u00E0\u05AE\u1DF3\u0315\u0062"},
    {"\u0061\u1DF3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DF3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DF4\u0062", "\u00E0\u05AE\u1DF4\u0315\u0062"},
    {"\u0061\u1DF4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DF4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DF5\u0062", "\u00E0\u05AE\u1DF5\u0315\u0062"},
    {"\u0061\u1DF5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DF5\u0300\u0315\u0062"},
    {"\u0061\u035C\u0315\u0300\u1DF6\u0062", "\u00E0\u0315\u1DF6\u035C\u0062"},
    {"\u0061\u1DF6\u035C\u0315\u0300\u0062", "\u00E0\u1DF6\u0315\u035C\u0062"},
    {"\u0061\u0300\u05AE\U0001D16D\u1DF7\u0062", "\u00E0\U0001D16D\u05AE\u1DF7\u0062"},
    {"\u0061\u1DF7\u0300\u05AE\U0001D16D\u0062", "\u00E0\U0001D16D\u1DF7\u05AE\u0062"},
    {"\u0061\u0300\u05AE\U0001D16D\u1DF8\u0062", "\u00E0\U0001D16D\u05AE\u1DF8\u0062"},
    {"\u0061\u1DF8\u0300\u05AE\U0001D16D\u0062", "\u00E0\U0001D16D\u1DF8\u05AE\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1DF9\u0062", "\u0061\u1DFA\u0316\u1DF9\u059A\u0062"},
    {"\u0061\u1DF9\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1DF9\u0316\u059A\u0062"},
    {"\u0061\u0316\u1DFA\u031B\u1DFA\u0062", "\u0061\u031B\u1DFA\u1DFA\u0316\u0062"},
    {"\u0061\u1DFA\u0316\u1DFA\u031B\u0062", "\u0061\u031B\u1DFA\u1DFA\u0316\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DFB\u0062", "\u00E0\u05AE\u1DFB\u0315\u0062"},
    {"\u0061\u1DFB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DFB\u0300\u0315\u0062"},
    {"\u0061\u035D\u035C\u0315\u1DFC\u0062", "\u0061\u0315\u035C\u1DFC\u035D\u0062"},
    {"\u0061\u1DFC\u035D\u035C\u0315\u0062", "\u0061\u0315\u1DFC\u035C\u035D\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1DFD\u0062", "\u0061\u1DFA\u0316\u1DFD\u059A\u0062"},
    {"\u0061\u1DFD\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1DFD\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u1DFE\u0062", "\u00E0\u05AE\u1DFE\u0315\u0062"},
    {"\u0061\u1DFE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u1DFE\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u1DFF\u0062", "\u0061\u1DFA\u0316\u1DFF\u059A\u0062"},
    {"\u0061\u1DFF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u1DFF\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20D0\u0062", "\u00E0\u05AE\u20D0\u0315\u0062"},
    {"\u0061\u20D0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20D0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20D1\u0062", "\u00E0\u05AE\u20D1\u0315\u0062"},
    {"\u0061\u20D1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20D1\u0300\u0315\u0062"},
    {"\u0061\U00016FF0\u0334\u20D2\u0062", "\u0061\u0334\u20D2\U00016FF0\u0062"},
    {"\u0061\u20D2\U00016FF0\u0334\u0062", "\u0061\u20D2\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u20D3\u0062", "\u0061\u0334\u20D3\U00016FF0\u0062"},
    {"\u0061\u20D3\U00016FF0\u0334\u0062", "\u0061\u20D3\u0334\U00016FF0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20D4\u0062", "\u00E0\u05AE\u20D4\u0315\u0062"},
    {"\u0061\u20D4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20D4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20D5\u0062", "\u00E0\u05AE\u20D5\u0315\u0062"},
    {"\u0061\u20D5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20D5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20D6\u0062", "\u00E0\u05AE\u20D6\u0315\u0062"},
    {"\u0061\u20D6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20D6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20D7\u0062", "\u00E0\u05AE\u20D7\u0315\u0062"},
    {"\u0061\u20D7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20D7\u0300\u0315\u0062"},
    {"\u0061\U00016FF0\u0334\u20D8\u0062", "\u0061\u0334\u20D8\U00016FF0\u0062"},
    {"\u0061\u20D8\U00016FF0\u0334\u0062", "\u0061\u20D8\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u20D9\u0062", "\u0061\u0334\u20D9\U00016FF0\u0062"},
    {"\u0061\u20D9\U00016FF0\u0334\u0062", "\u0061\u20D9\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u20DA\u0062", "\u0061\u0334\u20DA\U00016FF0\u0062"},
    {"\u0061\u20DA\U00016FF0\u0334\u0062", "\u0061\u20DA\u0334\U00016FF0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20DB\u0062", "\u00E0\u05AE\u20DB\u0315\u0062"},
    {"\u0061\u20DB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20DB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20DC\u0062", "\u00E0\u05AE\u20DC\u0315\u0062"},
    {"\u0061\u20DC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20DC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20E1\u0062", "\u00E0\u05AE\u20E1\u0315\u0062"},
    {"\u0061\u20E1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20E1\u0300\u0315\u0062"},
    {"\u0061\U00016FF0\u0334\u20E5\u0062", "\u0061\u0334\u20E5\U00016FF0\u0062"},
    {"\u0061\u20E5\U00016FF0\u0334\u0062", "\u0061\u20E5\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u20E6\u0062", "\u0061\u0334\u20E6\U00016FF0\u0062"},
    {"\u0061\u20E6\U00016FF0\u0334\u0062", "\u0061\u20E6\u0334\U00016FF0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20E7\u0062", "\u00E0\u05AE\u20E7\u0315\u0062"},
    {"\u0061\u20E7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20E7\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u20E8\u0062", "\u0061\u1DFA\u0316\u20E8\u059A\u0062"},
    {"\u0061\u20E8\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u20E8\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20E9\u0062", "\u00E0\u05AE\u20E9\u0315\u0062"},
    {"\u0061\u20E9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20E9\u0300\u0315\u0062"},
    {"\u0061\U00016FF0\u0334\u20EA\u0062", "\u0061\u0334\u20EA\U00016FF0\u0062"},
    {"\u0061\u20EA\U00016FF0\u0334\u0062", "\u0061\u20EA\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\u20EB\u0062", "\u0061\u0334\u20EB\U00016FF0\u0062"},
    {"\u0061\u20EB\U00016FF0\u0334\u0062", "\u0061\u20EB\u0334\U00016FF0\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u20EC\u0062", "\u0061\u1DFA\u0316\u20EC\u059A\u0062"},
    {"\u0061\u20EC\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u20EC\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u20ED\u0062", "\u0061\u1DFA\u0316\u20ED\u059A\u0062"},
    {"\u0061\u20ED\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u20ED\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u20EE\u0062", "\u0061\u1DFA\u0316\u20EE\u059A\u0062"},
    {"\u0061\u20EE\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u20EE\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\u20EF\u0062", "\u0061\u1DFA\u0316\u20EF\u059A\u0062"},
    {"\u0061\u20EF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\u20EF\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\u20F0\u0062", "\u00E0\u05AE\u20F0\u0315\u0062"},
    {"\u0061\u20F0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u20F0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2CEF\u0062", "\u00E0\u05AE\u2CEF\u0315\u0062"},
    {"\u0061\u2CEF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2CEF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2CF0\u0062", "\u00E0\u05AE\u2CF0\u0315\u0062"},
    {"\u0061\u2CF0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2CF0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2CF1\u0062", "\u00E0\u05AE\u2CF1\u0315\u0062"},
    {"\u0061\u2CF1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2CF1\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\u2D7F\u0062", "\u0061\u3099\u094D\u2D7F\u05B0\u0062"},
    {"\u0061\u2D7F\u05B0\u094D\u3099\u0062", "\u0061\u3099\u2D7F\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE0\u0062", "\u00E0\u05AE\u2DE0\u0315\u0062"},
    {"\u0061\u2DE0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE1\u0062", "\u00E0\u05AE\u2DE1\u0315\u0062"},
    {"\u0061\u2DE1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE2\u0062", "\u00E0\u05AE\u2DE2\u0315\u0062"},
    {"\u0061\u2DE2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE3\u0062", "\u00E0\u05AE\u2DE3\u0315\u0062"},
    {"\u0061\u2DE3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE4\u0062", "\u00E0\u05AE\u2DE4\u0315\u0062"},
    {"\u0061\u2DE4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE5\u0062", "\u00E0\u05AE\u2DE5\u0315\u0062"},
    {"\u0061\u2DE5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE6\u0062", "\u00E0\u05AE\u2DE6\u0315\u0062"},
    {"\u0061\u2DE6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE7\u0062", "\u00E0\u05AE\u2DE7\u0315\u0062"},
    {"\u0061\u2DE7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE8\u0062", "\u00E0\u05AE\u2DE8\u0315\u0062"},
    {"\u0061\u2DE8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DE9\u0062", "\u00E0\u05AE\u2DE9\u0315\u0062"},
    {"\u0061\u2DE9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DE9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DEA\u0062", "\u00E0\u05AE\u2DEA\u0315\u0062"},
    {"\u0061\u2DEA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DEA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DEB\u0062", "\u00E0\u05AE\u2DEB\u0315\u0062"},
    {"\u0061\u2DEB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DEB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DEC\u0062", "\u00E0\u05AE\u2DEC\u0315\u0062"},
    {"\u0061\u2DEC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DEC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DED\u0062", "\u00E0\u05AE\u2DED\u0315\u0062"},
    {"\u0061\u2DED\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DED\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DEE\u0062", "\u00E0\u05AE\u2DEE\u0315\u0062"},
    {"\u0061\u2DEE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DEE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DEF\u0062", "\u00E0\u05AE\u2DEF\u0315\u0062"},
    {"\u0061\u2DEF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DEF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF0\u0062", "\u00E0\u05AE\u2DF0\u0315\u0062"},
    {"\u0061\u2DF0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF1\u0062", "\u00E0\u05AE\u2DF1\u0315\u0062"},
    {"\u0061\u2DF1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF2\u0062", "\u00E0\u05AE\u2DF2\u0315\u0062"},
    {"\u0061\u2DF2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF3\u0062", "\u00E0\u05AE\u2DF3\u0315\u0062"},
    {"\u0061\u2DF3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF4\u0062", "\u00E0\u05AE\u2DF4\u0315\u0062"},
    {"\u0061\u2DF4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF5\u0062", "\u00E0\u05AE\u2DF5\u0315\u0062"},
    {"\u0061\u2DF5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF6\u0062", "\u00E0\u05AE\u2DF6\u0315\u0062"},
    {"\u0061\u2DF6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF7\u0062", "\u00E0\u05AE\u2DF7\u0315\u0062"},
    {"\u0061\u2DF7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF8\u0062", "\u00E0\u05AE\u2DF8\u0315\u0062"},
    {"\u0061\u2DF8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DF9\u0062", "\u00E0\u05AE\u2DF9\u0315\u0062"},
    {"\u0061\u2DF9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DF9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DFA\u0062", "\u00E0\u05AE\u2DFA\u0315\u0062"},
    {"\u0061\u2DFA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DFA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DFB\u0062", "\u00E0\u05AE\u2DFB\u0315\u0062"},
    {"\u0061\u2DFB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DFB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DFC\u0062", "\u00E0\u05AE\u2DFC\u0315\u0062"},
    {"\u0061\u2DFC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DFC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DFD\u0062", "\u00E0\u05AE\u2DFD\u0315\u0062"},
    {"\u0061\u2DFD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DFD\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DFE\u0062", "\u00E0\u05AE\u2DFE\u0315\u0062"},
    {"\u0061\u2DFE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DFE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\u2DFF\u0062", "\u00E0\u05AE\u2DFF\u0315\u0062"},
    {"\u0061\u2DFF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\u2DFF\u0300\u0315\u0062"},
    {"\u0061\u0316\u1DFA\u031B\u302A\u0062", "\u0061\u031B\u1DFA\u302A\u0316\u0062"},
    {"\u0061\u302A\u0316\u1DFA\u031B\u0062", "\u0061\u031B\u302A\u1DFA\u0316\u0062"},
    {"\u0061\u0300\u05AE\U0001D16D\u302B\u0062", "\u00E0\U0001D16D\u05AE\u302B\u0062"},
    {"\u0061\u302B\u0300\u05AE\U0001D16D\u0062", "\u00E0\U0001D16D\u302B\u05AE\u0062"},
    {"\u0061\u035C\u0315\u0300\u302C\u0062", "\u00E0\u0315\u302C\u035C\u0062"},
    {"\u0061\u302C\u035C\u0315\u0300\u0062", "\u00E0\u302C\u0315\u035C\u0062"},
    {"\u0061\u302E\u059A\u0316\u302D\u0062", "\u0061\u0316\u059A\u302D\u302E\u0062"},
    {"\u0061\u302D\u302E\u059A\u0316\u0062", "\u0061\u0316\u302D\u059A\u302E\u0062"},
    {"\u0061\U0001D16D\u302E\u059A\u302E\u0062", "\u0061\u059A\u302E\u302E\U0001D16D\u0062"},
    {"\u0061\u302E\U0001D16D\u302E\u059A\u0062", "\u0061\u059A\u302E\u302E\U0001D16D\u0062"},
    {"\u0061\U0001D16D\u302E\u059A\u302F\u0062", "\u0061\u059A\u302E\u302F\U0001D16D\u0062"},
    {"\u0061\u302F\U0001D16D\u302E\u059A\u0062", "\u0061\u059A\u302F\u302E\U0001D16D\u0062"},
    {"\u0061\u094D\u3099\u093C\u3099\u0062", "\u0061\u093C\u3099\u3099\u094D\u0062"},
    {"\u0061\u3099\u094D\u3099\u093C\u0062", "\u0061\u093C\u3099\u3099\u094D\u0062"},
    {"\u0061\u094D\u3099\u093C\u309A\u0062", "\u0061\u093C\u3099\u309A\u094D\u0062"},
    {"\u0061\u309A\u094D\u3099\u093C\u0062", "\u0061\u093C\u309A\u3099\u094D\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA66F\u0062", "\u00E0\u05AE\uA66F\u0315\u0062"},
    {"\u0061\uA66F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA66F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA674\u0062", "\u00E0\u05AE\uA674\u0315\u0062"},
    {"\u0061\uA674\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA674\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA675\u0062", "\u00E0\u05AE\uA675\u0315\u0062"},
    {"\u0061\uA675\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA675\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA676\u0062", "\u00E0\u05AE\uA676\u0315\u0062"},
    {"\u0061\uA676\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA676\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA677\u0062", "\u00E0\u05AE\uA677\u0315\u0062"},
    {"\u0061\uA677\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA677\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA678\u0062", "\u00E0\u05AE\uA678\u0315\u0062"},
    {"\u0061\uA678\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA678\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA679\u0062", "\u00E0\u05AE\uA679\u0315\u0062"},
    {"\u0061\uA679\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA679\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA67A\u0062", "\u00E0\u05AE\uA67A\u0315\u0062"},
    {"\u0061\uA67A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA67A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA67B\u0062", "\u00E0\u05AE\uA67B\u0315\u0062"},
    {"\u0061\uA67B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA67B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA67C\u0062", "\u00E0\u05AE\uA67C\u0315\u0062"},
    {"\u0061\uA67C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA67C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA67D\u0062", "\u00E0\u05AE\uA67D\u0315\u0062"},
    {"\u0061\uA67D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA67D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA69E\u0062", "\u00E0\u05AE\uA69E\u0315\u0062"},
    {"\u0061\uA69E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA69E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA69F\u0062", "\u00E0\u05AE\uA69F\u0315\u0062"},
    {"\u0061\uA69F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA69F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA6F0\u0062", "\u00E0\u05AE\uA6F0\u0315\u0062"},
    {"\u0061\uA6F0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA6F0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA6F1\u0062", "\u00E0\u05AE\uA6F1\u0315\u0062"},
    {"\u0061\uA6F1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA6F1\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\uA806\u0062", "\u0061\u3099\u094D\uA806\u05B0\u0062"},
    {"\u0061\uA806\u05B0\u094D\u3099\u0062", "\u0061\u3099\uA806\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\uA82C\u0062", "\u0061\u3099\u094D\uA82C\u05B0\u0062"},
    {"\u0061\uA82C\u05B0\u094D\u3099\u0062", "\u0061\u3099\uA82C\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\uA8C4\u0062", "\u0061\u3099\u094D\uA8C4\u05B0\u0062"},
    {"\u0061\uA8C4\u05B0\u094D\u3099\u0062", "\u0061\u3099\uA8C4\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E0\u0062", "\u00E0\u05AE\uA8E0\u0315\u0062"},
    {"\u0061\uA8E0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E1\u0062", "\u00E0\u05AE\uA8E1\u0315\u0062"},
    {"\u0061\uA8E1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E1\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E2\u0062", "\u00E0\u05AE\uA8E2\u0315\u0062"},
    {"\u0061\uA8E2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E3\u0062", "\u00E0\u05AE\uA8E3\u0315\u0062"},
    {"\u0061\uA8E3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E3\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E4\u0062", "\u00E0\u05AE\uA8E4\u0315\u0062"},
    {"\u0061\uA8E4\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E4\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E5\u0062", "\u00E0\u05AE\uA8E5\u0315\u0062"},
    {"\u0061\uA8E5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E5\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E6\u0062", "\u00E0\u05AE\uA8E6\u0315\u0062"},
    {"\u0061\uA8E6\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E6\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E7\u0062", "\u00E0\u05AE\uA8E7\u0315\u0062"},
    {"\u0061\uA8E7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E8\u0062", "\u00E0\u05AE\uA8E8\u0315\u0062"},
    {"\u0061\uA8E8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8E9\u0062", "\u00E0\u05AE\uA8E9\u0315\u0062"},
    {"\u0061\uA8E9\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8E9\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8EA\u0062", "\u00E0\u05AE\uA8EA\u0315\u0062"},
    {"\u0061\uA8EA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8EA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8EB\u0062", "\u00E0\u05AE\uA8EB\u0315\u0062"},
    {"\u0061\uA8EB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8EB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8EC\u0062", "\u00E0\u05AE\uA8EC\u0315\u0062"},
    {"\u0061\uA8EC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8EC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8ED\u0062", "\u00E0\u05AE\uA8ED\u0315\u0062"},
    {"\u0061\uA8ED\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8ED\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8EE\u0062", "\u00E0\u05AE\uA8EE\u0315\u0062"},
    {"\u0061\uA8EE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8EE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8EF\u0062", "\u00E0\u05AE\uA8EF\u0315\u0062"},
    {"\u0061\uA8EF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8EF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8F0\u0062", "\u00E0\u05AE\uA8F0\u0315\u0062"},
    {"\u0061\uA8F0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8F0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uA8F1\u0062", "\u00E0\u05AE\uA8F1\u0315\u0062"},
    {"\u0061\uA8F1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uA8F1\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uA92B\u0062", "\u0061\u1DFA\u0316\uA92B\u059A\u0062"},
    {"\u0061\uA92B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uA92B\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uA92C\u0062", "\u0061\u1DFA\u0316\uA92C\u059A\u0062"},
    {"\u0061\uA92C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uA92C\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uA92D\u0062", "\u0061\u1DFA\u0316\uA92D\u059A\u0062"},
    {"\u0061\uA92D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uA92D\u0316\u059A\u0062"},
    {"\u0061\u05B0\u094D\u3099\uA953\u0062", "\u0061\u3099\u094D\uA953\u05B0\u0062"},
    {"\u0061\uA953\u05B0\u094D\u3099\u0062", "\u0061\u3099\uA953\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\uA9B3\u0062", "\u0061\U00016FF0\u093C\uA9B3\u3099\u0062"},
    {"\u0061\uA9B3\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\uA9B3\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\uA9C0\u0062", "\u0061\u3099\u094D\uA9C0\u05B0\u0062"},
    {"\u0061\uA9C0\u05B0\u094D\u3099\u0062", "\u0061\u3099\uA9C0\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAAB0\u0062", "\u00E0\u05AE\uAAB0\u0315\u0062"},
    {"\u0061\uAAB0\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAAB0\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAAB2\u0062", "\u00E0\u05AE\uAAB2\u0315\u0062"},
    {"\u0061\uAAB2\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAAB2\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAAB3\u0062", "\u00E0\u05AE\uAAB3\u0315\u0062"},
    {"\u0061\uAAB3\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAAB3\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uAAB4\u0062", "\u0061\u1DFA\u0316\uAAB4\u059A\u0062"},
    {"\u0061\uAAB4\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uAAB4\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAAB7\u0062", "\u00E0\u05AE\uAAB7\u0315\u0062"},
    {"\u0061\uAAB7\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAAB7\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAAB8\u0062", "\u00E0\u05AE\uAAB8\u0315\u0062"},
    {"\u0061\uAAB8\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAAB8\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAABE\u0062", "\u00E0\u05AE\uAABE\u0315\u0062"},
    {"\u0061\uAABE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAABE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAABF\u0062", "\u00E0\u05AE\uAABF\u0315\u0062"},
    {"\u0061\uAABF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAABF\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uAAC1\u0062", "\u00E0\u05AE\uAAC1\u0315\u0062"},
    {"\u0061\uAAC1\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uAAC1\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\uAAF6\u0062", "\u0061\u3099\u094D\uAAF6\u05B0\u0062"},
    {"\u0061\uAAF6\u05B0\u094D\u3099\u0062", "\u0061\u3099\uAAF6\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\uABED\u0062", "\u0061\u3099\u094D\uABED\u05B0\u0062"},
    {"\u0061\uABED\u05B0\u094D\u3099\u0062", "\u0061\u3099\uABED\u094D\u05B0\u0062"},
    {"\u0061\u064B\uFB1E\u05C2\uFB1E\u0062", "\u0061\u05C2\uFB1E\uFB1E\u064B\u0062"},
    {"\u0061\uFB1E\u064B\uFB1E\u05C2\u0062", "\u0061\u05C2\uFB1E\uFB1E\u064B\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE20\u0062", "\u00E0\u05AE\uFE20\u0315\u0062"},
    {"\u0061\uFE20\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE20\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE21\u0062", "\u00E0\u05AE\uFE21\u0315\u0062"},
    {"\u0061\uFE21\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE21\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE22\u0062", "\u00E0\u05AE\uFE22\u0315\u0062"},
    {"\u0061\uFE22\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE22\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE23\u0062", "\u00E0\u05AE\uFE23\u0315\u0062"},
    {"\u0061\uFE23\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE23\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE24\u0062", "\u00E0\u05AE\uFE24\u0315\u0062"},
    {"\u0061\uFE24\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE24\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE25\u0062", "\u00E0\u05AE\uFE25\u0315\u0062"},
    {"\u0061\uFE25\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE25\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE26\u0062", "\u00E0\u05AE\uFE26\u0315\u0062"},
    {"\u0061\uFE26\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE26\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uFE27\u0062", "\u0061\u1DFA\u0316\uFE27\u059A\u0062"},
    {"\u0061\uFE27\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uFE27\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uFE28\u0062", "\u0061\u1DFA\u0316\uFE28\u059A\u0062"},
    {"\u0061\uFE28\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uFE28\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uFE29\u0062", "\u0061\u1DFA\u0316\uFE29\u059A\u0062"},
    {"\u0061\uFE29\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uFE29\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uFE2A\u0062", "\u0061\u1DFA\u0316\uFE2A\u059A\u0062"},
    {"\u0061\uFE2A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uFE2A\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uFE2B\u0062", "\u0061\u1DFA\u0316\uFE2B\u059A\u0062"},
    {"\u0061\uFE2B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uFE2B\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uFE2C\u0062", "\u0061\u1DFA\u0316\uFE2C\u059A\u0062"},
    {"\u0061\uFE2C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uFE2C\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\uFE2D\u0062", "\u0061\u1DFA\u0316\uFE2D\u059A\u0062"},
    {"\u0061\uFE2D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\uFE2D\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE2E\u0062", "\u00E0\u05AE\uFE2E\u0315\u0062"},
    {"\u0061\uFE2E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE2E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\uFE2F\u0062", "\u00E0\u05AE\uFE2F\u0315\u0062"},
    {"\u0061\uFE2F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\uFE2F\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U000101FD\u0062", "\u0061\u1DFA\u0316\U000101FD\u059A\u0062"},
    {"\u0061\U000101FD\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U000101FD\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U000102E0\u0062", "\u0061\u1DFA\u0316\U000102E0\u059A\u0062"},
    {"\u0061\U000102E0\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U000102E0\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010376\u0062", "\u00E0\u05AE\U00010376\u0315\u0062"},
    {"\u0061\U00010376\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010376\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010377\u0062", "\u00E0\u05AE\U00010377\u0315\u0062"},
    {"\u0061\U00010377\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010377\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010378\u0062", "\u00E0\u05AE\U00010378\u0315\u0062"},
    {"\u0061\U00010378\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010378\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010379\u0062", "\u00E0\u05AE\U00010379\u0315\u0062"},
    {"\u0061\U00010379\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010379\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001037A\u0062", "\u00E0\u05AE\U0001037A\u0315\u0062"},
    {"\u0061\U0001037A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001037A\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010A0D\u0062", "\u0061\u1DFA\u0316\U00010A0D\u059A\u0062"},
    {"\u0061\U00010A0D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010A0D\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010A0F\u0062", "\u00E0\u05AE\U00010A0F\u0315\u0062"},
    {"\u0061\U00010A0F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010A0F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010A38\u0062", "\u00E0\u05AE\U00010A38\u0315\u0062"},
    {"\u0061\U00010A38\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010A38\u0300\u0315\u0062"},
    {"\u0061\U00016FF0\u0334\U00010A39\u0062", "\u0061\u0334\U00010A39\U00016FF0\u0062"},
    {"\u0061\U00010A39\U00016FF0\u0334\u0062", "\u0061\U00010A39\u0334\U00016FF0\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010A3A\u0062", "\u0061\u1DFA\u0316\U00010A3A\u059A\u0062"},
    {"\u0061\U00010A3A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010A3A\u0316\u059A\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00010A3F\u0062", "\u0061\u3099\u094D\U00010A3F\u05B0\u0062"},
    {"\u0061\U00010A3F\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00010A3F\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010AE5\u0062", "\u00E0\u05AE\U00010AE5\u0315\u0062"},
    {"\u0061\U00010AE5\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010AE5\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010AE6\u0062", "\u0061\u1DFA\u0316\U00010AE6\u059A\u0062"},
    {"\u0061\U00010AE6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010AE6\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010D24\u0062", "\u00E0\u05AE\U00010D24\u0315\u0062"},
    {"\u0061\U00010D24\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010D24\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010D25\u0062", "\u00E0\u05AE\U00010D25\u0315\u0062"},
    {"\u0061\U00010D25\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010D25\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010D26\u0062", "\u00E0\u05AE\U00010D26\u0315\u0062"},
    {"\u0061\U00010D26\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010D26\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010D27\u0062", "\u00E0\u05AE\U00010D27\u0315\u0062"},
    {"\u0061\U00010D27\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010D27\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010EAB\u0062", "\u00E0\u05AE\U00010EAB\u0315\u0062"},
    {"\u0061\U00010EAB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010EAB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010EAC\u0062", "\u00E0\u05AE\U00010EAC\u0315\u0062"},
    {"\u0061\U00010EAC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010EAC\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010EFD\u0062", "\u0061\u1DFA\u0316\U00010EFD\u059A\u0062"},
    {"\u0061\U00010EFD\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010EFD\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010EFE\u0062", "\u0061\u1DFA\u0316\U00010EFE\u059A\u0062"},
    {"\u0061\U00010EFE\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010EFE\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010EFF\u0062", "\u0061\u1DFA\u0316\U00010EFF\u059A\u0062"},
    {"\u0061\U00010EFF\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010EFF\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F46\u0062", "\u0061\u1DFA\u0316\U00010F46\u059A\u0062"},
    {"\u0061\U00010F46\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F46\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F47\u0062", "\u0061\u1DFA\u0316\U00010F47\u059A\u0062"},
    {"\u0061\U00010F47\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F47\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010F48\u0062", "\u00E0\u05AE\U00010F48\u0315\u0062"},
    {"\u0061\U00010F48\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010F48\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010F49\u0062", "\u00E0\u05AE\U00010F49\u0315\u0062"},
    {"\u0061\U00010F49\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010F49\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010F4A\u0062", "\u00E0\u05AE\U00010F4A\u0315\u0062"},
    {"\u0061\U00010F4A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010F4A\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F4B\u0062", "\u0061\u1DFA\u0316\U00010F4B\u059A\u0062"},
    {"\u0061\U00010F4B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F4B\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010F4C\u0062", "\u00E0\u05AE\U00010F4C\u0315\u0062"},
    {"\u0061\U00010F4C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010F4C\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F4D\u0062", "\u0061\u1DFA\u0316\U00010F4D\u059A\u0062"},
    {"\u0061\U00010F4D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F4D\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F4E\u0062", "\u0061\u1DFA\u0316\U00010F4E\u059A\u0062"},
    {"\u0061\U00010F4E\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F4E\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F4F\u0062", "\u0061\u1DFA\u0316\U00010F4F\u059A\u0062"},
    {"\u0061\U00010F4F\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F4F\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F50\u0062", "\u0061\u1DFA\u0316\U00010F50\u059A\u0062"},
    {"\u0061\U00010F50\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F50\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010F82\u0062", "\u00E0\u05AE\U00010F82\u0315\u0062"},
    {"\u0061\U00010F82\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010F82\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F83\u0062", "\u0061\u1DFA\u0316\U00010F83\u059A\u0062"},
    {"\u0061\U00010F83\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F83\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00010F84\u0062", "\u00E0\u05AE\U00010F84\u0315\u0062"},
    {"\u0061\U00010F84\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00010F84\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U00010F85\u0062", "\u0061\u1DFA\u0316\U00010F85\u059A\u0062"},
    {"\u0061\U00010F85\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U00010F85\u0316\u059A\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011046\u0062", "\u0061\u3099\u094D\U00011046\u05B0\u0062"},
    {"\u0061\U00011046\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011046\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011070\u0062", "\u0061\u3099\u094D\U00011070\u05B0\u0062"},
    {"\u0061\U00011070\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011070\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U0001107F\u0062", "\u0061\u3099\u094D\U0001107F\u05B0\u0062"},
    {"\u0061\U0001107F\u05B0\u094D\u3099\u0062", "\u0061\u3099\U0001107F\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U000110B9\u0062", "\u0061\u3099\u094D\U000110B9\u05B0\u0062"},
    {"\u0061\U000110B9\u05B0\u094D\u3099\u0062", "\u0061\u3099\U000110B9\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U000110BA\u0062", "\u0061\U00016FF0\u093C\U000110BA\u3099\u0062"},
    {"\u0061\U000110BA\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U000110BA\u093C\u3099\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011100\u0062", "\u00E0\u05AE\U00011100\u0315\u0062"},
    {"\u0061\U00011100\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011100\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011101\u0062", "\u00E0\u05AE\U00011101\u0315\u0062"},
    {"\u0061\U00011101\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011101\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011102\u0062", "\u00E0\u05AE\U00011102\u0315\u0062"},
    {"\u0061\U00011102\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011102\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011133\u0062", "\u0061\u3099\u094D\U00011133\u05B0\u0062"},
    {"\u0061\U00011133\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011133\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011134\u0062", "\u0061\u3099\u094D\U00011134\u05B0\u0062"},
    {"\u0061\U00011134\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011134\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U00011173\u0062", "\u0061\U00016FF0\u093C\U00011173\u3099\u0062"},
    {"\u0061\U00011173\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U00011173\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U000111C0\u0062", "\u0061\u3099\u094D\U000111C0\u05B0\u0062"},
    {"\u0061\U000111C0\u05B0\u094D\u3099\u0062", "\u0061\u3099\U000111C0\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U000111CA\u0062", "\u0061\U00016FF0\u093C\U000111CA\u3099\u0062"},
    {"\u0061\U000111CA\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U000111CA\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011235\u0062", "\u0061\u3099\u094D\U00011235\u05B0\u0062"},
    {"\u0061\U00011235\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011235\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U00011236\u0062", "\u0061\U00016FF0\u093C\U00011236\u3099\u0062"},
    {"\u0061\U00011236\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U00011236\u093C\u3099\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U000112E9\u0062", "\u0061\U00016FF0\u093C\U000112E9\u3099\u0062"},
    {"\u0061\U000112E9\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U000112E9\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U000112EA\u0062", "\u0061\u3099\u094D\U000112EA\u05B0\u0062"},
    {"\u0061\U000112EA\u05B0\u094D\u3099\u0062", "\u0061\u3099\U000112EA\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U0001133B\u0062", "\u0061\U00016FF0\u093C\U0001133B\u3099\u0062"},
    {"\u0061\U0001133B\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U0001133B\u093C\u3099\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U0001133C\u0062", "\u0061\U00016FF0\u093C\U0001133C\u3099\u0062"},
    {"\u0061\U0001133C\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U0001133C\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U0001134D\u0062", "\u0061\u3099\u094D\U0001134D\u05B0\u0062"},
    {"\u0061\U0001134D\u05B0\u094D\u3099\u0062", "\u0061\u3099\U0001134D\u094D\u05B0\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011366\u0062", "\u00E0\u05AE\U00011366\u0315\u0062"},
    {"\u0061\U00011366\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011366\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011367\u0062", "\u00E0\u05AE\U00011367\u0315\u0062"},
    {"\u0061\U00011367\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011367\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011368\u0062", "\u00E0\u05AE\U00011368\u0315\u0062"},
    {"\u0061\U00011368\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011368\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011369\u0062", "\u00E0\u05AE\U00011369\u0315\u0062"},
    {"\u0061\U00011369\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011369\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001136A\u0062", "\u00E0\u05AE\U0001136A\u0315\u0062"},
    {"\u0061\U0001136A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001136A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001136B\u0062", "\u00E0\u05AE\U0001136B\u0315\u0062"},
    {"\u0061\U0001136B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001136B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001136C\u0062", "\u00E0\u05AE\U0001136C\u0315\u0062"},
    {"\u0061\U0001136C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001136C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011370\u0062", "\u00E0\u05AE\U00011370\u0315\u0062"},
    {"\u0061\U00011370\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011370\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011371\u0062", "\u00E0\u05AE\U00011371\u0315\u0062"},
    {"\u0061\U00011371\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011371\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011372\u0062", "\u00E0\u05AE\U00011372\u0315\u0062"},
    {"\u0061\U00011372\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011372\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011373\u0062", "\u00E0\u05AE\U00011373\u0315\u0062"},
    {"\u0061\U00011373\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011373\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00011374\u0062", "\u00E0\u05AE\U00011374\u0315\u0062"},
    {"\u0061\U00011374\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00011374\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011442\u0062", "\u0061\u3099\u094D\U00011442\u05B0\u0062"},
    {"\u0061\U00011442\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011442\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U00011446\u0062", "\u0061\U00016FF0\u093C\U00011446\u3099\u0062"},
    {"\u0061\U00011446\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U00011446\u093C\u3099\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001145E\u0062", "\u00E0\u05AE\U0001145E\u0315\u0062"},
    {"\u0061\U0001145E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001145E\u0300\u0315\u0062"},
    {"\u0061\u05B0\u094D\u3099\U000114C2\u0062", "\u0061\u3099\u094D\U000114C2\u05B0\u0062"},
    {"\u0061\U000114C2\u05B0\u094D\u3099\u0062", "\u0061\u3099\U000114C2\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U000114C3\u0062", "\u0061\U00016FF0\u093C\U000114C3\u3099\u0062"},
    {"\u0061\U000114C3\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U000114C3\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U000115BF\u0062", "\u0061\u3099\u094D\U000115BF\u05B0\u0062"},
    {"\u0061\U000115BF\u05B0\u094D\u3099\u0062", "\u0061\u3099\U000115BF\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U000115C0\u0062", "\u0061\U00016FF0\u093C\U000115C0\u3099\u0062"},
    {"\u0061\U000115C0\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U000115C0\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U0001163F\u0062", "\u0061\u3099\u094D\U0001163F\u05B0\u0062"},
    {"\u0061\U0001163F\u05B0\u094D\u3099\u0062", "\u0061\u3099\U0001163F\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U000116B6\u0062", "\u0061\u3099\u094D\U000116B6\u05B0\u0062"},
    {"\u0061\U000116B6\u05B0\u094D\u3099\u0062", "\u0061\u3099\U000116B6\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U000116B7\u0062", "\u0061\U00016FF0\u093C\U000116B7\u3099\u0062"},
    {"\u0061\U000116B7\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U000116B7\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U0001172B\u0062", "\u0061\u3099\u094D\U0001172B\u05B0\u0062"},
    {"\u0061\U0001172B\u05B0\u094D\u3099\u0062", "\u0061\u3099\U0001172B\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011839\u0062", "\u0061\u3099\u094D\U00011839\u05B0\u0062"},
    {"\u0061\U00011839\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011839\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U0001183A\u0062", "\u0061\U00016FF0\u093C\U0001183A\u3099\u0062"},
    {"\u0061\U0001183A\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U0001183A\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U0001193D\u0062", "\u0061\u3099\u094D\U0001193D\u05B0\u0062"},
    {"\u0061\U0001193D\u05B0\u094D\u3099\u0062", "\u0061\u3099\U0001193D\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U0001193E\u0062", "\u0061\u3099\u094D\U0001193E\u05B0\u0062"},
    {"\u0061\U0001193E\u05B0\u094D\u3099\u0062", "\u0061\u3099\U0001193E\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U00011943\u0062", "\u0061\U00016FF0\u093C\U00011943\u3099\u0062"},
    {"\u0061\U00011943\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U00011943\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U000119E0\u0062", "\u0061\u3099\u094D\U000119E0\u05B0\u0062"},
    {"\u0061\U000119E0\u05B0\u094D\u3099\u0062", "\u0061\u3099\U000119E0\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011A34\u0062", "\u0061\u3099\u094D\U00011A34\u05B0\u0062"},
    {"\u0061\U00011A34\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011A34\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011A47\u0062", "\u0061\u3099\u094D\U00011A47\u05B0\u0062"},
    {"\u0061\U00011A47\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011A47\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011A99\u0062", "\u0061\u3099\u094D\U00011A99\u05B0\u0062"},
    {"\u0061\U00011A99\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011A99\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011C3F\u0062", "\u0061\u3099\u094D\U00011C3F\u05B0\u0062"},
    {"\u0061\U00011C3F\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011C3F\u094D\u05B0\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U00011D42\u0062", "\u0061\U00016FF0\u093C\U00011D42\u3099\u0062"},
    {"\u0061\U00011D42\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U00011D42\u093C\u3099\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011D44\u0062", "\u0061\u3099\u094D\U00011D44\u05B0\u0062"},
    {"\u0061\U00011D44\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011D44\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011D45\u0062", "\u0061\u3099\u094D\U00011D45\u05B0\u0062"},
    {"\u0061\U00011D45\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011D45\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011D97\u0062", "\u0061\u3099\u094D\U00011D97\u05B0\u0062"},
    {"\u0061\U00011D97\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011D97\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011F41\u0062", "\u0061\u3099\u094D\U00011F41\u05B0\u0062"},
    {"\u0061\U00011F41\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011F41\u094D\u05B0\u0062"},
    {"\u0061\u05B0\u094D\u3099\U00011F42\u0062", "\u0061\u3099\u094D\U00011F42\u05B0\u0062"},
    {"\u0061\U00011F42\u05B0\u094D\u3099\u0062", "\u0061\u3099\U00011F42\u094D\u05B0\u0062"},
    {"\u0061\U00016FF0\u0334\U00016AF0\u0062", "\u0061\u0334\U00016AF0\U00016FF0\u0062"},
    {"\u0061\U00016AF0\U00016FF0\u0334\u0062", "\u0061\U00016AF0\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\U00016AF1\u0062", "\u0061\u0334\U00016AF1\U00016FF0\u0062"},
    {"\u0061\U00016AF1\U00016FF0\u0334\u0062", "\u0061\U00016AF1\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\U00016AF2\u0062", "\u0061\u0334\U00016AF2\U00016FF0\u0062"},
    {"\u0061\U00016AF2\U00016FF0\u0334\u0062", "\u0061\U00016AF2\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\U00016AF3\u0062", "\u0061\u0334\U00016AF3\U00016FF0\u0062"},
    {"\u0061\U00016AF3\U00016FF0\u0334\u0062", "\u0061\U00016AF3\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\U00016AF4\u0062", "\u0061\u0334\U00016AF4\U00016FF0\u0062"},
    {"\u0061\U00016AF4\U00016FF0\u0334\u0062", "\u0061\U00016AF4\u0334\U00016FF0\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00016B30\u0062", "\u00E0\u05AE\U00016B30\u0315\u0062"},
    {"\u0061\U00016B30\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00016B30\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00016B31\u0062", "\u00E0\u05AE\U00016B31\u0315\u0062"},
    {"\u0061\U00016B31\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00016B31\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00016B32\u0062", "\u00E0\u05AE\U00016B32\u0315\u0062"},
    {"\u0061\U00016B32\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00016B32\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00016B33\u0062", "\u00E0\u05AE\U00016B33\u0315\u0062"},
    {"\u0061\U00016B33\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00016B33\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00016B34\u0062", "\u00E0\u05AE\U00016B34\u0315\u0062"},
    {"\u0061\U00016B34\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00016B34\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00016B35\u0062", "\u00E0\u05AE\U00016B35\u0315\u0062"},
    {"\u0061\U00016B35\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00016B35\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U00016B36\u0062", "\u00E0\u05AE\U00016B36\u0315\u0062"},
    {"\u0061\U00016B36\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U00016B36\u0300\u0315\u0062"},
    {"\u0061\u093C\U00016FF0\u0334\U00016FF0\u0062", "\u0061\u0334\U00016FF0\U00016FF0\u093C\u0062"},
    {"\u0061\U00016FF0\u093C\U00016FF0\u0334\u0062", "\u0061\u0334\U00016FF0\U00016FF0\u093C\u0062"},
    {"\u0061\u093C\U00016FF0\u0334\U00016FF1\u0062", "\u0061\u0334\U00016FF0\U00016FF1\u093C\u0062"},
    {"\u0061\U00016FF1\u093C\U00016FF0\u0334\u0062", "\u0061\u0334\U00016FF1\U00016FF0\u093C\u0062"},
    {"\u0061\U00016FF0\u0334\U0001BC9E\u0062", "\u0061\u0334\U0001BC9E\U00016FF0\u0062"},
    {"\u0061\U0001BC9E\U00016FF0\u0334\u0062", "\u0061\U0001BC9E\u0334\U00016FF0\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\U0001D165\u0062", "\u0061\u1DCE\u031B\U0001D165\u1DFA\u0062"},
    {"\u0061\U0001D165\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\U0001D165\u031B\u1DFA\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\U0001D166\u0062", "\u0061\u1DCE\u031B\U0001D166\u1DFA\u0062"},
    {"\u0061\U0001D166\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\U0001D166\u031B\u1DFA\u0062"},
    {"\u0061\U00016FF0\u0334\U0001D167\u0062", "\u0061\u0334\U0001D167\U00016FF0\u0062"},
    {"\u0061\U0001D167\U00016FF0\u0334\u0062", "\u0061\U0001D167\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\U0001D168\u0062", "\u0061\u0334\U0001D168\U00016FF0\u0062"},
    {"\u0061\U0001D168\U00016FF0\u0334\u0062", "\u0061\U0001D168\u0334\U00016FF0\u0062"},
    {"\u0061\U00016FF0\u0334\U0001D169\u0062", "\u0061\u0334\U0001D169\U00016FF0\u0062"},
    {"\u0061\U0001D169\U00016FF0\u0334\u0062", "\u0061\U0001D169\u0334\U00016FF0\u0062"},
    {"\u0061\u05AE\U0001D16D\u302E\U0001D16D\u0062", "\u0061\u302E\U0001D16D\U0001D16D\u05AE\u0062"},
    {"\u0061\U0001D16D\u05AE\U0001D16D\u302E\u0062", "\u0061\u302E\U0001D16D\U0001D16D\u05AE\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\U0001D16E\u0062", "\u0061\u1DCE\u031B\U0001D16E\u1DFA\u0062"},
    {"\u0061\U0001D16E\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\U0001D16E\u031B\u1DFA\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\U0001D16F\u0062", "\u0061\u1DCE\u031B\U0001D16F\u1DFA\u0062"},
    {"\u0061\U0001D16F\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\U0001D16F\u031B\u1DFA\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\U0001D170\u0062", "\u0061\u1DCE\u031B\U0001D170\u1DFA\u0062"},
    {"\u0061\U0001D170\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\U0001D170\u031B\u1DFA\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\U0001D171\u0062", "\u0061\u1DCE\u031B\U0001D171\u1DFA\u0062"},
    {"\u0061\U0001D171\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\U0001D171\u031B\u1DFA\u0062"},
    {"\u0061\u1DFA\u031B\u1DCE\U0001D172\u0062", "\u0061\u1DCE\u031B\U0001D172\u1DFA\u0062"},
    {"\u0061\U0001D172\u1DFA\u031B\u1DCE\u0062", "\u0061\u1DCE\U0001D172\u031B\u1DFA\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D17B\u0062", "\u0061\u1DFA\u0316\U0001D17B\u059A\u0062"},
    {"\u0061\U0001D17B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D17B\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D17C\u0062", "\u0061\u1DFA\u0316\U0001D17C\u059A\u0062"},
    {"\u0061\U0001D17C\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D17C\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D17D\u0062", "\u0061\u1DFA\u0316\U0001D17D\u059A\u0062"},
    {"\u0061\U0001D17D\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D17D\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D17E\u0062", "\u0061\u1DFA\u0316\U0001D17E\u059A\u0062"},
    {"\u0061\U0001D17E\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D17E\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D17F\u0062", "\u0061\u1DFA\u0316\U0001D17F\u059A\u0062"},
    {"\u0061\U0001D17F\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D17F\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D180\u0062", "\u0061\u1DFA\u0316\U0001D180\u059A\u0062"},
    {"\u0061\U0001D180\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D180\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D181\u0062", "\u0061\u1DFA\u0316\U0001D181\u059A\u0062"},
    {"\u0061\U0001D181\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D181\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D182\u0062", "\u0061\u1DFA\u0316\U0001D182\u059A\u0062"},
    {"\u0061\U0001D182\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D182\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D185\u0062", "\u00E0\u05AE\U0001D185\u0315\u0062"},
    {"\u0061\U0001D185\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D185\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D186\u0062", "\u00E0\u05AE\U0001D186\u0315\u0062"},
    {"\u0061\U0001D186\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D186\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D187\u0062", "\u00E0\u05AE\U0001D187\u0315\u0062"},
    {"\u0061\U0001D187\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D187\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D188\u0062", "\u00E0\u05AE\U0001D188\u0315\u0062"},
    {"\u0061\U0001D188\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D188\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D189\u0062", "\u00E0\u05AE\U0001D189\u0315\u0062"},
    {"\u0061\U0001D189\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D189\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D18A\u0062", "\u0061\u1DFA\u0316\U0001D18A\u059A\u0062"},
    {"\u0061\U0001D18A\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D18A\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001D18B\u0062", "\u0061\u1DFA\u0316\U0001D18B\u059A\u0062"},
    {"\u0061\U0001D18B\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001D18B\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D1AA\u0062", "\u00E0\u05AE\U0001D1AA\u0315\u0062"},
    {"\u0061\U0001D1AA\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D1AA\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D1AB\u0062", "\u00E0\u05AE\U0001D1AB\u0315\u0062"},
    {"\u0061\U0001D1AB\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D1AB\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D1AC\u0062", "\u00E0\u05AE\U0001D1AC\u0315\u0062"},
    {"\u0061\U0001D1AC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D1AC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D1AD\u0062", "\u00E0\u05AE\U0001D1AD\u0315\u0062"},
    {"\u0061\U0001D1AD\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D1AD\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D242\u0062", "\u00E0\u05AE\U0001D242\u0315\u0062"},
    {"\u0061\U0001D242\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D242\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D243\u0062", "\u00E0\u05AE\U0001D243\u0315\u0062"},
    {"\u0061\U0001D243\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D243\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001D244\u0062", "\u00E0\u05AE\U0001D244\u0315\u0062"},
    {"\u0061\U0001D244\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001D244\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E000\u0062", "\u00E0\u05AE\U0001E000\u0315\u0062"},
    {"\u0061\U0001E000\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E000\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E001\u0062", "\u00E0\u05AE\U0001E001\u0315\u0062"},
    {"\u0061\U0001E001\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E001\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E002\u0062", "\u00E0\u05AE\U0001E002\u0315\u0062"},
    {"\u0061\U0001E002\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E002\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E003\u0062", "\u00E0\u05AE\U0001E003\u0315\u0062"},
    {"\u0061\U0001E003\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E003\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E004\u0062", "\u00E0\u05AE\U0001E004\u0315\u0062"},
    {"\u0061\U0001E004\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E004\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E005\u0062", "\u00E0\u05AE\U0001E005\u0315\u0062"},
    {"\u0061\U0001E005\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E005\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E006\u0062", "\u00E0\u05AE\U0001E006\u0315\u0062"},
    {"\u0061\U0001E006\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E006\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E008\u0062", "\u00E0\u05AE\U0001E008\u0315\u0062"},
    {"\u0061\U0001E008\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E008\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E009\u0062", "\u00E0\u05AE\U0001E009\u0315\u0062"},
    {"\u0061\U0001E009\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E009\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E00A\u0062", "\u00E0\u05AE\U0001E00A\u0315\u0062"},
    {"\u0061\U0001E00A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E00A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E00B\u0062", "\u00E0\u05AE\U0001E00B\u0315\u0062"},
    {"\u0061\U0001E00B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E00B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E00C\u0062", "\u00E0\u05AE\U0001E00C\u0315\u0062"},
    {"\u0061\U0001E00C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E00C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E00D\u0062", "\u00E0\u05AE\U0001E00D\u0315\u0062"},
    {"\u0061\U0001E00D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E00D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E00E\u0062", "\u00E0\u05AE\U0001E00E\u0315\u0062"},
    {"\u0061\U0001E00E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E00E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E00F\u0062", "\u00E0\u05AE\U0001E00F\u0315\u0062"},
    {"\u0061\U0001E00F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E00F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E010\u0062", "\u00E0\u05AE\U0001E010\u0315\u0062"},
    {"\u0061\U0001E010\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E010\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E011\u0062", "\u00E0\u05AE\U0001E011\u0315\u0062"},
    {"\u0061\U0001E011\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E011\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E012\u0062", "\u00E0\u05AE\U0001E012\u0315\u0062"},
    {"\u0061\U0001E012\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E012\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E013\u0062", "\u00E0\u05AE\U0001E013\u0315\u0062"},
    {"\u0061\U0001E013\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E013\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E014\u0062", "\u00E0\u05AE\U0001E014\u0315\u0062"},
    {"\u0061\U0001E014\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E014\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E015\u0062", "\u00E0\u05AE\U0001E015\u0315\u0062"},
    {"\u0061\U0001E015\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E015\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E016\u0062", "\u00E0\u05AE\U0001E016\u0315\u0062"},
    {"\u0061\U0001E016\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E016\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E017\u0062", "\u00E0\u05AE\U0001E017\u0315\u0062"},
    {"\u0061\U0001E017\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E017\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E018\u0062", "\u00E0\u05AE\U0001E018\u0315\u0062"},
    {"\u0061\U0001E018\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E018\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E01B\u0062", "\u00E0\u05AE\U0001E01B\u0315\u0062"},
    {"\u0061\U0001E01B\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E01B\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E01C\u0062", "\u00E0\u05AE\U0001E01C\u0315\u0062"},
    {"\u0061\U0001E01C\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E01C\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E01D\u0062", "\u00E0\u05AE\U0001E01D\u0315\u0062"},
    {"\u0061\U0001E01D\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E01D\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E01E\u0062", "\u00E0\u05AE\U0001E01E\u0315\u0062"},
    {"\u0061\U0001E01E\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E01E\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E01F\u0062", "\u00E0\u05AE\U0001E01F\u0315\u0062"},
    {"\u0061\U0001E01F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E01F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E020\u0062", "\u00E0\u05AE\U0001E020\u0315\u0062"},
    {"\u0061\U0001E020\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E020\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E021\u0062", "\u00E0\u05AE\U0001E021\u0315\u0062"},
    {"\u0061\U0001E021\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E021\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E023\u0062", "\u00E0\u05AE\U0001E023\u0315\u0062"},
    {"\u0061\U0001E023\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E023\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E024\u0062", "\u00E0\u05AE\U0001E024\u0315\u0062"},
    {"\u0061\U0001E024\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E024\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E026\u0062", "\u00E0\u05AE\U0001E026\u0315\u0062"},
    {"\u0061\U0001E026\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E026\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E027\u0062", "\u00E0\u05AE\U0001E027\u0315\u0062"},
    {"\u0061\U0001E027\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E027\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E028\u0062", "\u00E0\u05AE\U0001E028\u0315\u0062"},
    {"\u0061\U0001E028\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E028\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E029\u0062", "\u00E0\u05AE\U0001E029\u0315\u0062"},
    {"\u0061\U0001E029\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E029\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E02A\u0062", "\u00E0\u05AE\U0001E02A\u0315\u0062"},
    {"\u0061\U0001E02A\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E02A\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E08F\u0062", "\u00E0\u05AE\U0001E08F\u0315\u0062"},
    {"\u0061\U0001E08F\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E08F\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E130\u0062", "\u00E0\u05AE\U0001E130\u0315\u0062"},
    {"\u0061\U0001E130\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E130\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E131\u0062", "\u00E0\u05AE\U0001E131\u0315\u0062"},
    {"\u0061\U0001E131\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E131\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E132\u0062", "\u00E0\u05AE\U0001E132\u0315\u0062"},
    {"\u0061\U0001E132\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E132\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E133\u0062", "\u00E0\u05AE\U0001E133\u0315\u0062"},
    {"\u0061\U0001E133\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E133\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E134\u0062", "\u00E0\u05AE\U0001E134\u0315\u0062"},
    {"\u0061\U0001E134\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E134\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E135\u0062", "\u00E0\u05AE\U0001E135\u0315\u0062"},
    {"\u0061\U0001E135\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E135\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E136\u0062", "\u00E0\u05AE\U0001E136\u0315\u0062"},
    {"\u0061\U0001E136\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E136\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E2AE\u0062", "\u00E0\u05AE\U0001E2AE\u0315\u0062"},
    {"\u0061\U0001E2AE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E2AE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E2EC\u0062", "\u00E0\u05AE\U0001E2EC\u0315\u0062"},
    {"\u0061\U0001E2EC\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E2EC\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E2ED\u0062", "\u00E0\u05AE\U0001E2ED\u0315\u0062"},
    {"\u0061\U0001E2ED\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E2ED\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E2EE\u0062", "\u00E0\u05AE\U0001E2EE\u0315\u0062"},
    {"\u0061\U0001E2EE\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E2EE\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E2EF\u0062", "\u00E0\u05AE\U0001E2EF\u0315\u0062"},
    {"\u0061\U0001E2EF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E2EF\u0300\u0315\u0062"},
    {"\u0061\u035C\u0315\u0300\U0001E4EC\u0062", "\u00E0\u0315\U0001E4EC\u035C\u0062"},
    {"\u0061\U0001E4EC\u035C\u0315\u0300\u0062", "\u00E0\U0001E4EC\u0315\u035C\u0062"},
    {"\u0061\u035C\u0315\u0300\U0001E4ED\u0062", "\u00E0\u0315\U0001E4ED\u035C\u0062"},
    {"\u0061\U0001E4ED\u035C\u0315\u0300\u0062", "\u00E0\U0001E4ED\u0315\u035C\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E4EE\u0062", "\u0061\u1DFA\u0316\U0001E4EE\u059A\u0062"},
    {"\u0061\U0001E4EE\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E4EE\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E4EF\u0062", "\u00E0\u05AE\U0001E4EF\u0315\u0062"},
    {"\u0061\U0001E4EF\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E4EF\u0300\u0315\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E8D0\u0062", "\u0061\u1DFA\u0316\U0001E8D0\u059A\u0062"},
    {"\u0061\U0001E8D0\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E8D0\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E8D1\u0062", "\u0061\u1DFA\u0316\U0001E8D1\u059A\u0062"},
    {"\u0061\U0001E8D1\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E8D1\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E8D2\u0062", "\u0061\u1DFA\u0316\U0001E8D2\u059A\u0062"},
    {"\u0061\U0001E8D2\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E8D2\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E8D3\u0062", "\u0061\u1DFA\u0316\U0001E8D3\u059A\u0062"},
    {"\u0061\U0001E8D3\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E8D3\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E8D4\u0062", "\u0061\u1DFA\u0316\U0001E8D4\u059A\u0062"},
    {"\u0061\U0001E8D4\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E8D4\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E8D5\u0062", "\u0061\u1DFA\u0316\U0001E8D5\u059A\u0062"},
    {"\u0061\U0001E8D5\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E8D5\u0316\u059A\u0062"},
    {"\u0061\u059A\u0316\u1DFA\U0001E8D6\u0062", "\u0061\u1DFA\u0316\U0001E8D6\u059A\u0062"},
    {"\u0061\U0001E8D6\u059A\u0316\u1DFA\u0062", "\u0061\u1DFA\U0001E8D6\u0316\u059A\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E944\u0062", "\u00E0\u05AE\U0001E944\u0315\u0062"},
    {"\u0061\U0001E944\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E944\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E945\u0062", "\u00E0\u05AE\U0001E945\u0315\u0062"},
    {"\u0061\U0001E945\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E945\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E946\u0062", "\u00E0\u05AE\U0001E946\u0315\u0062"},
    {"\u0061\U0001E946\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E946\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E947\u0062", "\u00E0\u05AE\U0001E947\u0315\u0062"},
    {"\u0061\U0001E947\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E947\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E948\u0062", "\u00E0\u05AE\U0001E948\u0315\u0062"},
    {"\u0061\U0001E948\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E948\u0300\u0315\u0062"},
    {"\u0061\u0315\u0300\u05AE\U0001E949\u0062", "\u00E0\u05AE\U0001E949\u0315\u0062"},
    {"\u0061\U0001E949\u0315\u0300\u05AE\u0062", "\u0061\u05AE\U0001E949\u0300\u0315\u0062"},
    {"\u0061\u3099\u093C\U00016FF0\U0001E94A\u0062", "\u0061\U00016FF0\u093C\U0001E94A\u3099\u0062"},
    {"\u0061\U0001E94A\u3099\u093C\U00016FF0\u0062", "\u0061\U00016FF0\U0001E94A\u093C\u3099\u0062"},
    {"\u09C7\u0334\u09BE", "\u09C7\u0334\u09BE"}, {"\u09C7\u0334\u09D7", "\u09C7\u0334\u09D7"},
    {"\u0B47\u0334\u0B3E", "\u0B47\u0334\u0B3E"}, {"\u0B47\u0334\u0B56", "\u0B47\u0334\u0B56"},
    {"\u0B47\u0334\u0B57", "\u0B47\u0334\u0B57"}, {"\u0B92\u0334\u0BD7", "\u0B92\u0334\u0BD7"},
    {"\u0BC6\u0334\u0BBE", "\u0BC6\u0334\u0BBE"}, {"\u0BC6\u0334\u0BD7", "\u0BC6\u0334\u0BD7"},
    {"\u0BC7\u0334\u0BBE", "\u0BC7\u0334\u0BBE"}, {"\u0CBF\u0334\u0CD5", "\u0CBF\u0334\u0CD5"},
    {"\u0CC6\u0334\u0CC2", "\u0CC6\u0334\u0CC2"}, {"\u0CC6\u0334\u0CD5", "\u0CC6\u0334\u0CD5"},
    {"\u0CC6\u0334\u0CD6", "\u0CC6\u0334\u0CD6"}, {"\u0CCA\u0334\u0CD5", "\u0CCA\u0334\u0CD5"},
    {"\u0D46\u0334\u0D3E", "\u0D46\u0334\u0D3E"}, {"\u0D46\u0334\u0D57", "\u0D46\u0334\u0D57"},
    {"\u0D47\u0334\u0D3E", "\u0D47\u0334\u0D3E"}, {"\u0DD9\u0334\u0DCF", "\u0DD9\u0334\u0DCF"},
    {"\u0DD9\u0334\u0DDF", "\u0DD9\u0334\u0DDF"}, {"\u0F40\u0334\u0FB5", "\u0F40\u0334\u0FB5"},
    {"\u0F42\u0334\u0FB7", "\u0F42\u0334\u0FB7"}, {"\u0F4C\u0334\u0FB7", "\u0F4C\u0334\u0FB7"},
    {"\u0F51\u0334\u0FB7", "\u0F51\u0334\u0FB7"}, {"\u0F56\u0334\u0FB7", "\u0F56\u0334\u0FB7"},
    {"\u0F5B\u0334\u0FB7", "\u0F5B\u0334\u0FB7"}, {"\u0F90\u0334\u0FB5", "\u0F90\u0334\u0FB5"},
    {"\u0F92\u0334\u0FB7", "\u0F92\u0334\u0FB7"}, {"\u0F9C\u0334\u0FB7", "\u0F9C\u0334\u0FB7"},
    {"\u0FA1\u0334\u0FB7", "\u0FA1\u0334\u0FB7"}, {"\u0FA6\u0334\u0FB7", "\u0FA6\u0334\u0FB7"},
    {"\u0FAB\u0334\u0FB7", "\u0FAB\u0334\u0FB7"}, {"\u1025\u0334\u102E", "\u1025\u0334\u102E"},
    {"\u1100\u0334\u1161", "\u1100\u0334\u1161"}, {"\u1100\u0334\u116E", "\u1100\u0334\u116E"},
    {"\u1101\u0334\u1166", "\u1101\u0334\u1166"}, {"\u1101\u0334\u1173", "\u1101\u0334\u1173"},
    {"\u1102\u0334\u116B", "\u1102\u0334\u116B"}, {"\u1103\u0334\u1163", "\u1103\u0334\u1163"},
    {"\u1103\u0334\u1170", "\u1103\u0334\u1170"}, {"\u1104\u0334\u1168", "\u1104\u0334\u1168"},
    {"\u1104\u0334\u1175", "\u1104\u0334\u1175"}, {"\u1105\u0334\u116D", "\u1105\u0334\u116D"},
    {"\u1106\u0334\u1165", "\u1106\u0334\u1165"}, {"\u1106\u0334\u1172", "\u1106\u0334\u1172"},
    {"\u1107\u0334\u116A", "\u1107\u0334\u116A"}, {"\u1108\u0334\u1162", "\u1108\u0334\u1162"},
    {"\u1108\u0334\u116F", "\u1108\u0334\u116F"}, {"\u1109\u0334\u1167", "\u1109\u0334\u1167"},
    {"\u1109\u0334\u1174", "\u1109\u0334\u1174"}, {"\u110A\u0334\u116C", "\u110A\u0334\u116C"},
    {"\u110B\u0334\u1164", "\u110B\u0334\u1164"}, {"\u110B\u0334\u1171", "\u110B\u0334\u1171"},
    {"\u110C\u0334\u1169", "\u110C\u0334\u1169"}, {"\u110D\u0334\u1161", "\u110D\u0334\u1161"},
    {"\u110D\u0334\u116E", "\u110D\u0334\u116E"}, {"\u110E\u0334\u1166", "\u110E\u0334\u1166"},
    {"\u110E\u0334\u1173", "\u110E\u0334\u1173"}, {"\u110F\u0334\u116B", "\u110F\u0334\u116B"},
    {"\u1110\u0334\u1163", "\u1110\u0334\u1163"}, {"\u1110\u0334\u1170", "\u1110\u0334\u1170"},
    {"\u1111\u0334\u1168", "\u1111\u0334\u1168"}, {"\u1111\u0334\u1175", "\u1111\u0334\u1175"},
    {"\u1112\u0334\u116D", "\u1112\u0334\u116D"}, {"\u1B05\u0334\u1B35", "\u1B05\u0334\u1B35"},
    {"\u1B07\u0334\u1B35", "\u1B07\u0334\u1B35"}, {"\u1B09\u0334\u1B35", "\u1B09\u0334\u1B35"},
    {"\u1B0B\u0334\u1B35", "\u1B0B\u0334\u1B35"}, {"\u1B0D\u0334\u1B35", "\u1B0D\u0334\u1B35"},
    {"\u1B11\u0334\u1B35", "\u1B11\u0334\u1B35"}, {"\u1B3A\u0334\u1B35", "\u1B3A\u0334\u1B35"},
    {"\u1B3C\u0334\u1B35", "\u1B3C\u0334\u1B35"}, {"\u1B3E\u0334\u1B35", "\u1B3E\u0334\u1B35"},
    {"\u1B3F\u0334\u1B35", "\u1B3F\u0334\u1B35"}, {"\u1B42\u0334\u1B35", "\u1B42\u0334\u1B35"},
    {"\uAC54\u0334\u11AE", "\uAC54\u0334\u11AE"}, {"\uACA8\u0334\u11B5", "\uACA8\u0334\u11B5"},
    {"\uACFC\u0334\u11BC", "\uACFC\u0334\u11BC"}, {"\uADC0\u0334\u11AE", "\uADC0\u0334\u11AE"},
    {"\uAE14\u0334\u11B5", "\uAE14\u0334\u11B5"}, {"\uAE68\u0334\u11BC", "\uAE68\u0334\u11BC"},
    {"\uAF2C\u0334\u11AE", "\uAF2C\u0334\u11AE"}, {"\uAF80\u0334\u11B5", "\uAF80\u0334\u11B5"},
    {"\uAFD4\u0334\u11BC", "\uAFD4\u0334\u11BC"}, {"\uB098\u0334\u11AE", "\uB098\u0334\u11AE"},
    {"\uB0EC\u0334\u11B5", "\uB0EC\u0334\u11B5"}, {"\uB140\u0334\u11BC", "\uB140\u0334\u11BC"},
    {"\uB204\u0334\u11AE", "\uB204\u0334\u11AE"}, {"\uB258\u0334\u11B5", "\uB258\u0334\u11B5"},
    {"\uB2AC\u0334\u11BC", "\uB2AC\u0334\u11BC"}, {"\uB370\u0334\u11AE", "\uB370\u0334\u11AE"},
    {"\uB3C4\u0334\u11B5", "\uB3C4\u0334\u11B5"}, {"\uB418\u0334\u11BC", "\uB418\u0334\u11BC"},
    {"\uB4DC\u0334\u11AE", "\uB4DC\u0334\u11AE"}, {"\uB530\u0334\u11B5", "\uB530\u0334\u11B5"},
    {"\uB584\u0334\u11BC", "\uB584\u0334\u11BC"}, {"\uB648\u0334\u11AE", "\uB648\u0334\u11AE"},
    {"\uB69C\u0334\u11B5", "\uB69C\u0334\u11B5"}, {"\uB6F0\u0334\u11BC", "\uB6F0\u0334\u11BC"},
    {"\uB7B4\u0334\u11AE", "\uB7B4\u0334\u11AE"}, {"\uB808\u0334\u11B5", "\uB808\u0334\u11B5"},
    {"\uB85C\u0334\u11BC", "\uB85C\u0334\u11BC"}, {"\uB920\u0334\u11AE", "\uB920\u0334\u11AE"},
    {"\uB974\u0334\u11B5", "\uB974\u0334\u11B5"}, {"\uB9C8\u0334\u11BC", "\uB9C8\u0334\u11BC"},
    {"\uBA8C\u0334\u11AE", "\uBA8C\u0334\u11AE"}, {"\uBAE0\u0334\u11B5", "\uBAE0\u0334\u11B5"},
    {"\uBB34\u0334\u11BC", "\uBB34\u0334\u11BC"}, {"\uBBF8\u0334\u11AE", "\uBBF8\u0334\u11AE"},
    {"\uBC4C\u0334\u11B5", "\uBC4C\u0334\u11B5"}, {"\uBCA0\u0334\u11BC", "\uBCA0\u0334\u11BC"},
    {"\uBD64\u0334\u11AE", "\uBD64\u0334\u11AE"}, {"\uBDB8\u0334\u11B5", "\uBDB8\u0334\u11B5"},
    {"\uBE0C\u0334\u11BC", "\uBE0C\u0334\u11BC"}, {"\uBED0\u0334\u11AE", "\uBED0\u0334\u11AE"},
    {"\uBF24\u0334\u11B5", "\uBF24\u0334\u11B5"}, {"\uBF78\u0334\u11BC", "\uBF78\u0334\u11BC"},
    {"\uC03C\u0334\u11AE", "\uC03C\u0334\u11AE"}, {"\uC090\u0334\u11B5", "\uC090\u0334\u11B5"},
    {"\uC0E4\u0334\u11BC", "\uC0E4\u0334\u11BC"}, {"\uC1A8\u0334\u11AE", "\uC1A8\u0334\u11AE"},
    {"\uC1FC\u0334\u11B5", "\uC1FC\u0334\u11B5"}, {"\uC250\u0334\u11BC", "\uC250\u0334\u11BC"},
    {"\uC314\u0334\u11AE", "\uC314\u0334\u11AE"}, {"\uC368\u0334\u11B5", "\uC368\u0334\u11B5"},
    {"\uC3BC\u0334\u11BC", "\uC3BC\u0334\u11BC"}, {"\uC480\u0334\u11AE", "\uC480\u0334\u11AE"},
    {"\uC4D4\u0334\u11B5", "\uC4D4\u0334\u11B5"}, {"\uC528\u0334\u11BC", "\uC528\u0334\u11BC"},
    {"\uC5EC\u0334\u11AE", "\uC5EC\u0334\u11AE"}, {"\uC640\u0334\u11B5", "\uC640\u0334\u11B5"},
    {"\uC694\u0334\u11BC", "\uC694\u0334\u11BC"}, {"\uC758\u0334\u11AE", "\uC758\u0334\u11AE"},
    {"\uC7AC\u0334\u11B5", "\uC7AC\u0334\u11B5"}, {"\uC800\u0334\u11BC", "\uC800\u0334\u11BC"},
    {"\uC8C4\u0334\u11AE", "\uC8C4\u0334\u11AE"}, {"\uC918\u0334\u11B5", "\uC918\u0334\u11B5"},
    {"\uC96C\u0334\u11BC", "\uC96C\u0334\u11BC"}, {"\uCA30\u0334\u11AE", "\uCA30\u0334\u11AE"},
    {"\uCA84\u0334\u11B5", "\uCA84\u0334\u11B5"}, {"\uCAD8\u0334\u11BC", "\uCAD8\u0334\u11BC"},
    {"\uCB9C\u0334\u11AE", "\uCB9C\u0334\u11AE"}, {"\uCBF0\u0334\u11B5", "\uCBF0\u0334\u11B5"},
    {"\uCC44\u0334\u11BC", "\uCC44\u0334\u11BC"}, {"\uCD08\u0334\u11AE", "\uCD08\u0334\u11AE"},
    {"\uCD5C\u0334\u11B5", "\uCD5C\u0334\u11B5"}, {"\uCDB0\u0334\u11BC", "\uCDB0\u0334\u11BC"},
    {"\uCE74\u0334\u11AE", "\uCE74\u0334\u11AE"}, {"\uCEC8\u0334\u11B5", "\uCEC8\u0334\u11B5"},
    {"\uCF1C\u0334\u11BC", "\uCF1C\u0334\u11BC"}, {"\uCFE0\u0334\u11AE", "\uCFE0\u0334\u11AE"},
    {"\uD034\u0334\u11B5", "\uD034\u0334\u11B5"}, {"\uD088\u0334\u11BC", "\uD088\u0334\u11BC"},
    {"\uD14C\u0334\u11AE", "\uD14C\u0334\u11AE"}, {"\uD1A0\u0334\u11B5", "\uD1A0\u0334\u11B5"},
    {"\uD1F4\u0334\u11BC", "\uD1F4\u0334\u11BC"}, {"\uD2B8\u0334\u11AE", "\uD2B8\u0334\u11AE"},
    {"\uD30C\u0334\u11B5", "\uD30C\u0334\u11B5"}, {"\uD360\u0334\u11BC", "\uD360\u0334\u11BC"},
    {"\uD424\u0334\u11AE", "\uD424\u0334\u11AE"}, {"\uD478\u0334\u11B5", "\uD478\u0334\u11B5"},
    {"\uD4CC\u0334\u11BC", "\uD4CC\u0334\u11BC"}, {"\uD590\u0334\u11AE", "\uD590\u0334\u11AE"},
    {"\uD5E4\u0334\u11B5", "\uD5E4\u0334\u11B5"}, {"\uD638\u0334\u11BC", "\uD638\u0334\u11BC"},
    {"\uD6FC\u0334\u11AE", "\uD6FC\u0334\u11AE"}, {"\uD750\u0334\u11B5", "\uD750\u0334\u11B5"},
    {"\U00011131\u0334\U00011127", "\U00011131\u0334\U00011127"},
    {"\U00011132\u0334\U00011127", "\U00011132\u0334\U00011127"},
    {"\U00011347\u0334\U0001133E", "\U00011347\u0334\U0001133E"},
    {"\U00011347\u0334\U00011357", "\U00011347\u0334\U00011357"},
    {"\U000114B9\u0334\U000114B0", "\U000114B9\u0334\U000114B0"},
    {"\U000114B9\u0334\U000114BA", "\U000114B9\u0334\U000114BA"},
    {"\U000114B9\u0334\U000114BD", "\U000114B9\u0334\U000114BD"},
    {"\U000115B8\u0334\U000115AF", "\U000115B8\u0334\U000115AF"},
    {"\U000115B9\u0334\U000115AF", "\U000115B9\u0334\U000115AF"},
    {"\U00011935\u0334\U00011930", "\U00011935\u0334\U00011930"}
};

