// Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
// This source file is part of the Cangjie project, licensed under Apache-2.0
// with Runtime Library Exception.
//
// See https://cangjie-lang.cn/pages/LICENSE for license information.

/**
 * @file
 *
 * This file provides unicode normalisation data.
 */

// NOTE: The following code was generated by "NormalisationTests.py", do not edit directly

#ifndef CANGJIE_UTILS_UNICODETABLES_NORMALISATIONDATA_H
#define CANGJIE_UTILS_UNICODETABLES_NORMALISATIONDATA_H
namespace Cangjie::Unicode {
namespace {
constexpr short COMPOSITION_TABLE_SALT[] {
    0x000, 0x000, 0x000, 0x000, 0x25D, 0x003, 0x05D, 0x000, 0x002, 0x009, 0x004, 0x087, 0x006, 0x135, 0x001, 0x000,
    0x000, 0x004, 0x003, 0x0E1, 0x078, 0x000, 0x002, 0x029, 0x008, 0x08F, 0x024, 0x000, 0x000, 0x000, 0x031, 0x000,
    0x000, 0x06D, 0x000, 0x033, 0x001, 0x04C, 0x000, 0x001, 0x000, 0x000, 0x008, 0x07C, 0x006, 0x04C, 0x045, 0x02A,
    0x002, 0x000, 0x000, 0x000, 0x00A, 0x000, 0x000, 0x059, 0x000, 0x010, 0x003, 0x009, 0x00E, 0x006, 0x001, 0x00C,
    0x010, 0x000, 0x000, 0x000, 0x03D, 0x000, 0x000, 0x02A, 0x000, 0x000, 0x001, 0x020, 0x00A, 0x000, 0x001, 0x00E,
    0x002, 0x010, 0x022, 0x000, 0x061, 0x000, 0x004, 0x015, 0x000, 0x004, 0x003, 0x000, 0x000, 0x003, 0x000, 0x00D,
    0x001, 0x001, 0x024, 0x003, 0x004, 0x000, 0x000, 0x018, 0x058, 0x000, 0x000, 0x00A, 0x019, 0x010, 0x000, 0x002,
    0x000, 0x000, 0x012, 0x015, 0x000, 0x00C, 0x007, 0x003, 0x000, 0x01A, 0x007, 0x00C, 0x001, 0x005, 0x004, 0x021,
    0x001, 0x002, 0x000, 0x000, 0x001, 0x00A, 0x000, 0x00A, 0x000, 0x004, 0x009, 0x005, 0x00D, 0x005, 0x000, 0x003,
    0x006, 0x026, 0x00B, 0x000, 0x004, 0x006, 0x000, 0x013, 0x000, 0x000, 0x004, 0x001, 0x000, 0x000, 0x000, 0x024,
    0x001, 0x01D, 0x001, 0x000, 0x000, 0x010, 0x000, 0x001, 0x001, 0x001, 0x000, 0x000, 0x00A, 0x000, 0x00D, 0x000,
    0x010, 0x000, 0x006, 0x005, 0x000, 0x000, 0x009, 0x003, 0x001, 0x000, 0x000, 0x000, 0x000, 0x002, 0x001, 0x002,
    0x000, 0x000, 0x016, 0x001, 0x002, 0x000, 0x001, 0x000, 0x006, 0x001, 0x025, 0x005, 0x000, 0x00A, 0x00D, 0x002,
    0x000, 0x001, 0x000, 0x000, 0x012, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x001, 0x000, 0x004, 0x009, 0x000,
    0x001, 0x004, 0x000, 0x004, 0x001, 0x006, 0x00B, 0x003, 0x006, 0x007, 0x000, 0x000, 0x000, 0x00D, 0x00F, 0x00E,
    0x000, 0x001, 0x001, 0x004, 0x00F, 0x010, 0x000, 0x005, 0x000, 0x019, 0x001, 0x00E, 0x000, 0x008, 0x001, 0x003,
    0x000, 0x000, 0x005, 0x001, 0x000, 0x000, 0x011, 0x000, 0x004, 0x005, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000,
    0x002, 0x001, 0x000, 0x000, 0x002, 0x001, 0x001, 0x005, 0x008, 0x000, 0x000, 0x00C, 0x00A, 0x000, 0x006, 0x009,
    0x003, 0x001, 0x006, 0x001, 0x000, 0x01B, 0x001, 0x00E, 0x000, 0x008, 0x005, 0x003, 0x015, 0x000, 0x002, 0x007,
    0x00B, 0x003, 0x000, 0x00A, 0x003, 0x000, 0x006, 0x000, 0x00A, 0x000, 0x001, 0x003, 0x008, 0x000, 0x009, 0x000,
    0x001, 0x002, 0x000, 0x005, 0x000, 0x001, 0x000, 0x000, 0x000, 0x017, 0x000, 0x000, 0x002, 0x000, 0x005, 0x016,
    0x000, 0x010, 0x003, 0x004, 0x011, 0x001, 0x003, 0x000, 0x000, 0x000, 0x004, 0x001, 0x000, 0x005, 0x000, 0x002,
    0x001, 0x000, 0x002, 0x000, 0x002, 0x002, 0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x012, 0x001, 0x004, 0x00A,
    0x00B, 0x004, 0x000, 0x002, 0x000, 0x003, 0x000, 0x004, 0x005, 0x000, 0x000, 0x011, 0x001, 0x006, 0x006, 0x000,
    0x002, 0x000, 0x001, 0x000, 0x004, 0x000, 0x000, 0x001, 0x001, 0x007, 0x000, 0x003, 0x00A, 0x000, 0x001, 0x00A,
    0x002, 0x000, 0x001, 0x000, 0x000, 0x00D, 0x005, 0x001, 0x001, 0x000, 0x000, 0x005, 0x006, 0x008, 0x004, 0x005,
    0x000, 0x00B, 0x000, 0x004, 0x00B, 0x000, 0x000, 0x001, 0x005, 0x000, 0x00B, 0x000, 0x006, 0x000, 0x000, 0x000,
    0x000, 0x001, 0x000, 0x004, 0x000, 0x006, 0x000, 0x000, 0x007, 0x013, 0x004, 0x019, 0x003, 0x001, 0x000, 0x001,
    0x006, 0x006, 0x000, 0x000, 0x000, 0x000, 0x00C, 0x002, 0x003, 0x000, 0x004, 0x000, 0x001, 0x000, 0x001, 0x005,
    0x001, 0x001, 0x002, 0x001, 0x000, 0x000, 0x000, 0x000, 0x009, 0x000, 0x000, 0x007, 0x001, 0x009, 0x006, 0x004,
    0x001, 0x005, 0x000, 0x001, 0x002, 0x008, 0x000, 0x009, 0x000, 0x000, 0x001, 0x003, 0x00B, 0x000, 0x001, 0x000,
    0x000, 0x005, 0x000, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000, 0x002, 0x001, 0x002, 0x000, 0x000, 0x000, 0x004,
    0x001, 0x000, 0x006, 0x002, 0x005, 0x008, 0x012, 0x000, 0x000, 0x000, 0x003, 0x001, 0x000, 0x000, 0x000, 0x002,
    0x003, 0x003, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x003, 0x000, 0x000, 0x002, 0x001, 0x004, 0x00D, 0x000,
    0x000, 0x00B, 0x000, 0x001, 0x000, 0x000, 0x00C, 0x000, 0x000, 0x000, 0x005, 0x008, 0x002, 0x000, 0x002, 0x001,
    0x006, 0x001, 0x001, 0x001, 0x000, 0x002, 0x000, 0x005, 0x001, 0x001, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000,
    0x00E, 0x010, 0x000, 0x005, 0x004, 0x002, 0x001, 0x000, 0x000, 0x003, 0x001, 0x000, 0x002, 0x001, 0x004, 0x000,
    0x000, 0x003, 0x000, 0x001, 0x001, 0x003, 0x001, 0x005, 0x002, 0x003, 0x004, 0x000, 0x003, 0x003, 0x006, 0x000,
    0x000, 0x001, 0x000, 0x002, 0x00E, 0x001, 0x002, 0x001, 0x004, 0x002, 0x005, 0x002, 0x001, 0x001, 0x000, 0x001,
    0x000, 0x005, 0x005, 0x006, 0x006, 0x005, 0x000, 0x002, 0x001, 0x000, 0x002, 0x004, 0x001, 0x000, 0x005, 0x000,
    0x006, 0x002, 0x008, 0x000, 0x000, 0x007, 0x001, 0x002, 0x002, 0x005, 0x004, 0x011, 0x000, 0x003, 0x000, 0x001,
    0x000, 0x001, 0x004, 0x000, 0x003, 0x002, 0x000, 0x001, 0x003, 0x000, 0x00B, 0x006, 0x000, 0x006, 0x000, 0x004,
    0x001, 0x002, 0x000, 0x001, 0x000, 0x002, 0x001, 0x002, 0x000, 0x005, 0x001, 0x000, 0x000, 0x000, 0x001, 0x003,
    0x002, 0x006, 0x000, 0x000, 0x002, 0x004, 0x006, 0x000, 0x000, 0x000, 0x000, 0x00C, 0x00C, 0x000, 0x000, 0x000,
    0x004, 0x004, 0x000, 0x008, 0x003, 0x001, 0x000, 0x001, 0x000, 0x003, 0x000, 0x000, 0x005, 0x000, 0x005, 0x001,
    0x000, 0x003, 0x004, 0x001, 0x002, 0x003, 0x000, 0x001, 0x007, 0x000, 0x000, 0x007, 0x000, 0x002, 0x002, 0x000,
    0x000, 0x001, 0x001, 0x001, 0x001, 0x00B, 0x000, 0x004, 0x000, 0x001, 0x001, 0x000, 0x002, 0x001, 0x001, 0x005,
    0x000, 0x000, 0x003, 0x006, 0x000, 0x000, 0x004, 0x002, 0x001, 0x003, 0x003, 0x00A, 0x007, 0x000, 0x004, 0x001,
    0x006, 0x000, 0x001, 0x000, 0x000, 0x002, 0x001, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x001, 0x001,
    0x001, 0x004, 0x000, 0x003, 0x000, 0x001, 0x000, 0x000, 0x001, 0x000, 0x001, 0x000, 0x004, 0x000, 0x001, 0x000,
    0x006, 0x000, 0x001, 0x000, 0x004, 0x000, 0x001, 0x002, 0x006, 0x000, 0x002, 0x000, 0x003, 0x007, 0x000, 0x003,
    0x000, 0x001, 0x001, 0x000, 0x000, 0x003, 0x005, 0x002, 0x000, 0x001, 0x001, 0x002, 0x002, 0x004, 0x001, 0x000,
    0x000, 0x001, 0x000, 0x003, 0x002, 0x000, 0x001, 0x000, 0x002, 0x004, 0x002, 0x000, 0x001, 0x005, 0x000, 0x000,
    0x002, 0x001, 0x001, 0x000, 0x000, 0x001, 0x000, 0x005, 0x002, 0x000, 0x008, 0x003, 0x001, 0x001, 0x001, 0x003,
    0x004, 0x000, 0x002, 0x000, 0x001, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x006, 0x000, 0x000,
    0x000, 0x003, 0x000, 0x000, 0x002, 0x002, 0x000, 0x001, 0x003, 0x001, 0x003, 0x001, 0x002, 0x000, 0x001, 0x002,
    0x000, 0x000, 0x001, 0x000, 0x003, 0x001, 0x002, 0x000, 0x002, 0x001, 0x000, 0x002, 0x004, 0x000, 0x005, 0x005,
    0x000, 0x005, 0x002, 0x000, 0x001, 0x003, 0x001, 0x000, 0x002, 0x006, 0x002, 0x001, 0x000, 0x000, 0x000, 0x003
};

/**
 Key: codepoint
 Value: first: index into COMPOSITION_TABLE_CHARS,
        second: length
 */
constexpr std::pair<unsigned, UTF32> COMPOSITION_TABLE_KV[] {
    {0x064A0654, 0x000626}, {0x00690309, 0x001EC9}, {0x00650306, 0x000115}, {0x0423030B, 0x0004F2},
    {0x0047030C, 0x0001E6}, {0x00570301, 0x001E82}, {0x00C50301, 0x0001FA}, {0x21D20338, 0x0021CF},
    {0x00430307, 0x00010A}, {0x007A0307, 0x00017C}, {0x0049030C, 0x0001CF}, {0x00720307, 0x001E59},
    {0x304B3099, 0x00304C}, {0x1F610345, 0x001FA1}, {0x00410307, 0x000226}, {0x006B0323, 0x001E33},
    {0x03990304, 0x001FD9}, {0x1F490301, 0x001F4D}, {0x03CA0342, 0x001FD7}, {0x00550304, 0x00016A},
    {0x30DB309A, 0x0030DD}, {0x1F6E0345, 0x001FAE}, {0x00420331, 0x001E06}, {0x041E0308, 0x0004E6},
    {0x00410325, 0x001E00}, {0x00520331, 0x001E5E}, {0x1FF60345, 0x001FF7}, {0x22720338, 0x002274},
    {0x22480338, 0x002249}, {0x1FBF0301, 0x001FCE}, {0x30C63099, 0x0030C7}, {0x00760323, 0x001E7F},
    {0x00700307, 0x001E57}, {0x1F510301, 0x001F55}, {0x00750328, 0x000173}, {0x305B3099, 0x00305C},
    {0x0041030A, 0x0000C5}, {0x01A10323, 0x001EE3}, {0x00550311, 0x000216}, {0x00530307, 0x001E60},
    {0x00DC030C, 0x0001D9}, {0x004F0300, 0x0000D2}, {0x006F0307, 0x00022F}, {0x00470301, 0x0001F4},
    {0x00610309, 0x001EA3}, {0x1F080301, 0x001F0C}, {0x03B90301, 0x0003AF}, {0x04330301, 0x000453},
    {0x1F200345, 0x001F90}, {0x00620307, 0x001E03}, {0x1F030345, 0x001F83}, {0x00570308, 0x001E84},
    {0x005A0307, 0x00017B}, {0x30C13099, 0x0030C2}, {0x01A10309, 0x001EDF}, {0x06270655, 0x000625},
    {0x03BF0314, 0x001F41}, {0x00670301, 0x0001F5}, {0x039F0301, 0x00038C}, {0x00EA0301, 0x001EBF},
    {0x0063030C, 0x00010D}, {0x1F000345, 0x001F80}, {0x04130301, 0x000403}, {0x004B0323, 0x001E32},
    {0x00790301, 0x0000FD}, {0x00770301, 0x001E83}, {0x1F0E0345, 0x001F8E}, {0x00480308, 0x001E26},
    {0x30A63099, 0x0030F4}, {0x01020300, 0x001EB0}, {0x006C0301, 0x00013A}, {0x00450309, 0x001EBA},
    {0x1F390301, 0x001F3D}, {0x00690311, 0x00020B}, {0x04230304, 0x0004EE}, {0x0061030C, 0x0001CE},
    {0x1F100300, 0x001F12}, {0x04380300, 0x00045D}, {0x00480323, 0x001E24}, {0x1B111B35, 0x001B12},
    {0x00430301, 0x000106}, {0x00540323, 0x001E6C}, {0x00490303, 0x000128}, {0x1EA10302, 0x001EAD},
    {0x04350308, 0x000451}, {0x00610307, 0x000227}, {0x1F000300, 0x001F02}, {0x006D0307, 0x001E41},
    {0x00760303, 0x001E7D}, {0x00730327, 0x00015F}, {0x00470304, 0x001E20}, {0x00470306, 0x00011E},
    {0x1F6D0345, 0x001FAD}, {0x006F0303, 0x0000F5}, {0x006B0331, 0x001E35}, {0x00720331, 0x001E5F},
    {0x01B00300, 0x001EEB}, {0x1B0B1B35, 0x001B0C}, {0x0055032D, 0x001E76}, {0x0061030A, 0x0000E5},
    {0x30463099, 0x003094}, {0x1B3A1B35, 0x001B3B}, {0x0055030A, 0x00016E}, {0x0928093C, 0x000929},
    {0x03C90313, 0x001F60}, {0x00650330, 0x001E1B}, {0x00590303, 0x001EF8}, {0x00450330, 0x001E1A},
    {0x00640331, 0x001E0F}, {0x03B90308, 0x0003CA}, {0x309D3099, 0x00309E}, {0x0443030B, 0x0004F3},
    {0x0B470B3E, 0x000B4B}, {0x006F030F, 0x00020D}, {0x006E0323, 0x001E47}, {0x00690308, 0x0000EF},
    {0x0065032D, 0x001E19}, {0x015A0307, 0x001E64}, {0x1F180301, 0x001F1C}, {0x1F090301, 0x001F0D},
    {0x1F270345, 0x001F97}, {0x007A0302, 0x001E91}, {0x00590301, 0x0000DD}, {0x004C0331, 0x001E3A},
    {0x1F640345, 0x001FA4}, {0x1EB90302, 0x001EC7}, {0x1F240345, 0x001F94}, {0x01130300, 0x001E15},
    {0x0069030F, 0x000209}, {0x00740331, 0x001E6F}, {0x1F480301, 0x001F4C}, {0x007A0331, 0x001E95},
    {0x1F290345, 0x001F99}, {0x00D40301, 0x001ED0}, {0x00C40304, 0x0001DE}, {0x03970301, 0x000389},
    {0x0072030C, 0x000159}, {0x1F110301, 0x001F15}, {0x00F40309, 0x001ED5}, {0x00450327, 0x000228},
    {0x006F031B, 0x0001A1}, {0x00C60304, 0x0001E2}, {0x03990308, 0x0003AA}, {0x03CE0345, 0x001FF4},
    {0x006D0301, 0x001E3F}, {0x01030309, 0x001EB3}, {0x006F0302, 0x0000F4}, {0x0073030C, 0x000161},
    {0x00750301, 0x0000FA}, {0x1F690301, 0x001F6D}, {0x03A90301, 0x00038F}, {0x003D0338, 0x002260},
    {0x1FC60345, 0x001FC7}, {0x00770300, 0x001E81}, {0x02280306, 0x001E1C}, {0x006C0331, 0x001E3B},
    {0x30AD3099, 0x0030AE}, {0x1EB80302, 0x001EC6}, {0x00550302, 0x0000DB}, {0x0DD90DCF, 0x000DDC},
    {0x03A50304, 0x001FE9}, {0x03A90314, 0x001F69}, {0x00740327, 0x000163}, {0x00530326, 0x000218},
    {0x0055030B, 0x000170}, {0x306F309A, 0x003071}, {0x006B0327, 0x000137}, {0x00750330, 0x001E75},
    {0x00730301, 0x00015B}, {0x1F300342, 0x001F36}, {0x00470307, 0x000120}, {0x0CC60CD5, 0x000CC7},
    {0x1F690300, 0x001F6B}, {0x01030301, 0x001EAF}, {0x00750311, 0x000217}, {0x0930093C, 0x000931},
    {0x30613099, 0x003062}, {0x00770323, 0x001E89}, {0x00F50301, 0x001E4D}, {0x00FC0300, 0x0001DC},
    {0x0049030F, 0x000208}, {0x00690302, 0x0000EE}, {0x1F230345, 0x001F93}, {0x00F40300, 0x001ED3},
    {0x044B0308, 0x0004F9}, {0x1F2E0345, 0x001F9E}, {0x00650300, 0x0000E8}, {0x00490308, 0x0000CF},
    {0x1F280301, 0x001F2C}, {0x1F180300, 0x001F1A}, {0x06270653, 0x000622}, {0x1F200301, 0x001F24},
    {0x22030338, 0x002204}, {0x00790304, 0x000233}, {0x1F390300, 0x001F3B}, {0x00610325, 0x001E01},
    {0x00790309, 0x001EF7}, {0x01AF0303, 0x001EEE}, {0x006F0301, 0x0000F3}, {0x00640323, 0x001E0D},
    {0x304F3099, 0x003050}, {0x1F010345, 0x001F81}, {0x00CA0309, 0x001EC2}, {0x03D20308, 0x0003D4},
    {0x1F500301, 0x001F54}, {0x1F010300, 0x001F03}, {0x03A90345, 0x001FFC}, {0x04270308, 0x0004F4},
    {0x00530302, 0x00015C}, {0x00520301, 0x000154}, {0x00450306, 0x000114}, {0x00530323, 0x001E62},
    {0x00670306, 0x00011F}, {0x22760338, 0x002278}, {0x04350300, 0x000450}, {0x30B53099, 0x0030B6},
    {0x006F030B, 0x000151}, {0x04180304, 0x0004E2}, {0x00630307, 0x00010B}, {0x03D20301, 0x0003D3},
    {0x227C0338, 0x0022E0}, {0x00610304, 0x000101}, {0x00A80300, 0x001FED}, {0x00440331, 0x001E0E},
    {0x00650311, 0x000207}, {0x00F80301, 0x0001FF}, {0x0075030C, 0x0001D4}, {0x00530327, 0x00015E},
    {0x30573099, 0x003058}, {0x03B70345, 0x001FC3}, {0x0069030C, 0x0001D0}, {0x006E0327, 0x000146},
    {0x00780307, 0x001E8B}, {0x1F000342, 0x001F06}, {0x01B00303, 0x001EEF}, {0x00470327, 0x000122},
    {0x00C20309, 0x001EA8}, {0x006C032D, 0x001E3D}, {0x304D3099, 0x00304E}, {0x00690303, 0x000129},
    {0x01AF0323, 0x001EF0}, {0x004F0302, 0x0000D4}, {0x01020301, 0x001EAE}, {0x04470308, 0x0004F5},
    {0x22A80338, 0x0022AD}, {0x03C50300, 0x001F7A}, {0x03910313, 0x001F08}, {0x0064032D, 0x001E13},
    {0x00CF0301, 0x001E2E}, {0x0061030F, 0x000201}, {0x1EA10306, 0x001EB7}, {0x00790323, 0x001EF5},
    {0x21900338, 0x00219A}, {0x1F250345, 0x001F95}, {0x004F0304, 0x00014C}, {0x004F0306, 0x00014E},
    {0x30B33099, 0x0030B4}, {0x00440327, 0x001E10}, {0x0B920BD7, 0x000B94}, {0x00550308, 0x0000DC},
    {0x00650323, 0x001EB9}, {0x307B3099, 0x00307C}, {0x004F030C, 0x0001D1}, {0x00670304, 0x001E21},
    {0x006A030C, 0x0001F0}, {0x00550323, 0x001EE4}, {0x01A10301, 0x001EDB}, {0x00590323, 0x001EF4},
    {0x00410300, 0x0000C0}, {0x30B93099, 0x0030BA}, {0x04230308, 0x0004F0}, {0x00530301, 0x00015A},
    {0x30D8309A, 0x0030DA}, {0x00750309, 0x001EE7}, {0x00550330, 0x001E74}, {0x00520327, 0x000156},
    {0x04370308, 0x0004DF}, {0x00CA0300, 0x001EC0}, {0x21940338, 0x0021AE}, {0x03B10306, 0x001FB0},
    {0x1F610342, 0x001F67}, {0x223C0338, 0x002241}, {0x30D23099, 0x0030D3}, {0x1F6B0345, 0x001FAB},
    {0x00490307, 0x000130}, {0x00410323, 0x001EA0}, {0x00550309, 0x001EE6}, {0x0075030B, 0x000171},
    {0x30533099, 0x003054}, {0x305D3099, 0x00305E}, {0x004C0323, 0x001E36}, {0x02260304, 0x0001E0},
    {0x0475030F, 0x000477}, {0x00490328, 0x00012E}, {0x1F210300, 0x001F23}, {0x1F610301, 0x001F65},
    {0x1F210342, 0x001F27}, {0x00670302, 0x00011D}, {0x004E0301, 0x000143}, {0x004E0303, 0x0000D1},
    {0x03990300, 0x001FDA}, {0x03BF0301, 0x0003CC}, {0x04150300, 0x000400}, {0x03C90314, 0x001F61},
    {0x22A20338, 0x0022AC}, {0x30DB3099, 0x0030DC}, {0x03A50314, 0x001F59}, {0x0052030F, 0x000210},
    {0x004E0323, 0x001E46}, {0x1F0D0345, 0x001F8D}, {0x1ECD0302, 0x001ED9}, {0x00FC030C, 0x0001DA},
    {0x00D60304, 0x00022A}, {0x1F000301, 0x001F04}, {0x30CF3099, 0x0030D0}, {0x04350306, 0x0004D7},
    {0x220B0338, 0x00220C}, {0x00590300, 0x001EF2}, {0x04170308, 0x0004DE}, {0x006E030C, 0x000148},
    {0x004C030C, 0x00013D}, {0x01690301, 0x001E79}, {0x04100308, 0x0004D2}, {0x01A00301, 0x001EDA},
    {0x0041030F, 0x000200}, {0x00720301, 0x000155}, {0x00450303, 0x001EBC}, {0x1B0D1B35, 0x001B0E},
    {0x01120301, 0x001E16}, {0x004A0302, 0x000134}, {0x03BF0300, 0x001F78}, {0x30593099, 0x00305A},
    {0x004F030B, 0x000150}, {0x00610328, 0x000105}, {0x30D83099, 0x0030D9}, {0x1F2B0345, 0x001F9B},
    {0x1F400301, 0x001F44}, {0x0065030F, 0x000205}, {0x03AE0345, 0x001FC4}, {0x01680301, 0x001E78},
    {0x00740326, 0x00021B}, {0x03B90342, 0x001FD6}, {0x1F6F0345, 0x001FAF}, {0x03A50301, 0x00038E},
    {0x1F090345, 0x001F89}, {0x00550300, 0x0000D9}, {0x0041030C, 0x0001CD}, {0x00430327, 0x0000C7},
    {0x00460307, 0x001E1E}, {0x03B50301, 0x0003AD}, {0x0D470D3E, 0x000D4B}, {0x00610311, 0x000203},
    {0x00D50308, 0x001E4E}, {0x03C90300, 0x001F7C}, {0x04430306, 0x00045E}, {0x1FFE0301, 0x001FDE},
    {0x03990301, 0x00038A}, {0x00790307, 0x001E8F}, {0x1E5A0304, 0x001E5C}, {0x0075030F, 0x000215},
    {0x09C709BE, 0x0009CB}, {0x1B071B35, 0x001B08}, {0x00690330, 0x001E2D}, {0x307B309A, 0x00307D},
    {0x30C83099, 0x0030C9}, {0x22B30338, 0x0022EB}, {0x01B00301, 0x001EE9}, {0x00790300, 0x001EF3},
    {0x00570307, 0x001E86}, {0x00690328, 0x00012F}, {0x005A0323, 0x001E92}, {0x03C50342, 0x001FE6},
    {0x004F0309, 0x001ECE}, {0x1F290342, 0x001F2F}, {0x01A00300, 0x001EDC}, {0x1F2A0345, 0x001F9A},
    {0x014D0301, 0x001E53}, {0x21D00338, 0x0021CD}, {0x00550328, 0x000172}, {0x00680331, 0x001E96},
    {0x0068030C, 0x00021F}, {0x004C0301, 0x000139}, {0x22860338, 0x002288}, {0x039F0314, 0x001F49},
    {0x03A50306, 0x001FE8}, {0x0B470B56, 0x000B48}, {0x30753099, 0x003076}, {0x1E5B0304, 0x001E5D},
    {0x1F6A0345, 0x001FAA}, {0x00540327, 0x000162}, {0x01020303, 0x001EB4}, {0x039F0313, 0x001F48},
    {0x1F090342, 0x001F0F}, {0x04100306, 0x0004D0}, {0x014D0300, 0x001E51}, {0x04430304, 0x0004EF},
    {0x21920338, 0x00219B}, {0x22610338, 0x002262}, {0x00F50304, 0x00022D}, {0x03B90313, 0x001F30},
    {0x006F0308, 0x0000F6}, {0x00730307, 0x001E61}, {0x0075031B, 0x0001B0}, {0x30B73099, 0x0030B8},
    {0x1E620307, 0x001E68}, {0x00410306, 0x000102}, {0x03970314, 0x001F29}, {0x00630302, 0x000109},
    {0x006A0302, 0x000135}, {0x00E50301, 0x0001FB}, {0x00730326, 0x000219}, {0x1F740345, 0x001FC2},
    {0x00650309, 0x001EBB}, {0x005A030C, 0x00017D}, {0x22250338, 0x002226}, {0x03A90313, 0x001F68},
    {0x00720327, 0x000157}, {0x1F090300, 0x001F0B}, {0x04360308, 0x0004DD}, {0x1F080345, 0x001F88},
    {0x00620331, 0x001E07}, {0x22730338, 0x002275}, {0x00560323, 0x001E7E}, {0x004F0323, 0x001ECC},
    {0x022E0304, 0x000230}, {0x06D50654, 0x0006C0}, {0x03B10313, 0x001F00}, {0x004F0303, 0x0000D5},
    {0x1F010301, 0x001F05}, {0x00650304, 0x000113}, {0x00450323, 0x001EB8}, {0x0BC60BBE, 0x000BCA},
    {0x22650338, 0x002271}, {0x03910314, 0x001F09}, {0x01120300, 0x001E14}, {0x004E0307, 0x001E44},
    {0x00680308, 0x001E27}, {0x004F0311, 0x00020E}, {0x00550303, 0x000168}, {0x03A10314, 0x001FEC},
    {0x03B10301, 0x0003AC}, {0x0055030F, 0x000214}, {0x003E0338, 0x00226F}, {0x01610307, 0x001E67},
    {0x1F040345, 0x001F84}, {0x00450300, 0x0000C8}, {0x1B091B35, 0x001B0A}, {0x30FD3099, 0x0030FE},
    {0x1F680301, 0x001F6C}, {0x00650303, 0x001EBD}, {0x03B90304, 0x001FD1}, {0x09C709D7, 0x0009CC},
    {0x042B0308, 0x0004F8}, {0x004E0327, 0x000145}, {0x1F630345, 0x001FA3}, {0x04380306, 0x000439},
    {0x03B10314, 0x001F01}, {0x00540326, 0x00021A}, {0x00740307, 0x001E6B}, {0x03C90301, 0x0003CE},
    {0x03990314, 0x001F39}, {0x30B13099, 0x0030B2}, {0x00750302, 0x0000FB}, {0x0CC60CD6, 0x000CC8},
    {0x30BD3099, 0x0030BE}, {0x006E0300, 0x0001F9}, {0x1F390342, 0x001F3F}, {0x02270304, 0x0001E1},
    {0x22080338, 0x002209}, {0x04180306, 0x000419}, {0x0044030C, 0x00010E}, {0x0075030A, 0x00016F},
    {0x06270654, 0x000623}, {0x00750306, 0x00016D}, {0x03B70300, 0x001F74}, {0x1F660345, 0x001FA6},
    {0x1F690345, 0x001FA9}, {0x015B0307, 0x001E65}, {0x1F280342, 0x001F2E}, {0x1F700345, 0x001FB2},
    {0x1F0F0345, 0x001F8F}, {0x00540331, 0x001E6E}, {0x227B0338, 0x002281}, {0x22870338, 0x002289},
    {0x1F010342, 0x001F07}, {0x03A50308, 0x0003AB}, {0x1F650345, 0x001FA5}, {0x00D40300, 0x001ED2},
    {0x00F60304, 0x00022B}, {0x0CBF0CD5, 0x000CC0}, {0x1F380342, 0x001F3E}, {0x22B20338, 0x0022EA},
    {0x0072030F, 0x000211}, {0x30BF3099, 0x0030C0}, {0x04E90308, 0x0004EB}, {0x22830338, 0x002285},
    {0x03CB0300, 0x001FE2}, {0x00CA0301, 0x001EBE}, {0x00590304, 0x000232}, {0x00690301, 0x0000ED},
    {0x305F3099, 0x003060}, {0x00440307, 0x001E0A}, {0x1ECC0302, 0x001ED8}, {0x1F210345, 0x001F91},
    {0x00410311, 0x000202}, {0x00720311, 0x000213}, {0x03A50300, 0x001FEA}, {0x1F590300, 0x001F5B},
    {0x00E40304, 0x0001DF}, {0x1F500300, 0x001F52}, {0x224D0338, 0x00226D}, {0x006E0301, 0x000144},
    {0x0075032D, 0x001E77}, {0x00F40301, 0x001ED1}, {0x03C90342, 0x001FF6}, {0x03B70301, 0x0003AE},
    {0x006E0307, 0x001E45}, {0x00410304, 0x000100}, {0x1F190301, 0x001F1D}, {0x03B10304, 0x001FB1},
    {0x3078309A, 0x00307A}, {0x00570323, 0x001E88}, {0x04430308, 0x0004F1}, {0x0045032D, 0x001E18},
    {0x04150308, 0x000401}, {0x004F0328, 0x0001EA}, {0x04D90308, 0x0004DB}, {0x04060308, 0x000407},
    {0x00F40303, 0x001ED7}, {0x03B90306, 0x001FD0}, {0x00650307, 0x000117}, {0x1F680342, 0x001F6E},
    {0x04380304, 0x0004E3}, {0x1F410300, 0x001F43}, {0x1FFE0300, 0x001FDD}, {0x004F0301, 0x0000D3},
    {0x00640327, 0x001E11}, {0x02290306, 0x001E1D}, {0x007A0301, 0x00017A}, {0x00620323, 0x001E05},
    {0x1F7C0345, 0x001FF2}, {0x01B00323, 0x001EF1}, {0x1F600301, 0x001F64}, {0x30663099, 0x003067},
    {0x22640338, 0x002270}, {0x1F310300, 0x001F33}, {0x00610323, 0x001EA1}, {0x1F480300, 0x001F4A},
    {0x00550301, 0x0000DA}, {0x0C460C56, 0x000C48}, {0x03CA0300, 0x001FD2}, {0x01B7030C, 0x0001EE},
    {0x00720323, 0x001E5B}, {0x1F200342, 0x001F26}, {0x04300308, 0x0004D3}, {0x22820338, 0x002284},
    {0x1F590301, 0x001F5D}, {0x1F080342, 0x001F0E}, {0x00440323, 0x001E0C}, {0x1025102E, 0x001026},
    {0x03910304, 0x001FB9}, {0x004B0331, 0x001E34}, {0x00690300, 0x0000EC}, {0x0048032E, 0x001E2A},
    {0x00630301, 0x000107}, {0x1F690342, 0x001F6F}, {0x03B50313, 0x001F10}, {0x30CF309A, 0x0030D1},
    {0x004E030C, 0x000147}, {0x0B470B57, 0x000B4C}, {0x03910301, 0x000386}, {0x00650328, 0x000119},
    {0x1FBF0300, 0x001FCD}, {0x03B70342, 0x001FC6}, {0x00450307, 0x000116}, {0x1F380301, 0x001F3C},
    {0x3075309A, 0x003077}, {0x004B0301, 0x001E30}, {0x01030300, 0x001EB1}, {0x00E20303, 0x001EAB},
    {0x00410302, 0x0000C2}, {0x00650308, 0x0000EB}, {0x00580307, 0x001E8A}, {0x0054030C, 0x000164},
    {0x03C50313, 0x001F50}, {0x03B50314, 0x001F11}, {0x1B3E1B35, 0x001B40}, {0x1F100301, 0x001F14},
    {0x3072309A, 0x003074}, {0x1F280345, 0x001F98}, {0x22770338, 0x002279}, {0x227A0338, 0x002280},
    {0x00470302, 0x00011C}, {0x00450308, 0x0000CB}, {0x00550324, 0x001E72}, {0x1F2C0345, 0x001F9C},
    {0x004B0327, 0x000136}, {0x00490302, 0x0000CE}, {0x00680302, 0x000125}, {0x00520307, 0x001E58},
    {0x00610301, 0x0000E1}, {0x004B030C, 0x0001E8}, {0x00490309, 0x001EC8}, {0x006C030C, 0x00013E},
    {0x004D0307, 0x001E40}, {0x1E360304, 0x001E38}, {0x03C50304, 0x001FE1}, {0x0079030A, 0x001E99},
    {0x03970313, 0x001F28}, {0x0054032D, 0x001E70}, {0x1F490300, 0x001F4B}, {0x1B421B35, 0x001B43},
    {0x03B70313, 0x001F20}, {0x00EF0301, 0x001E2F}, {0x00E70301, 0x001E09}, {0x016A0308, 0x001E7A},
    {0x00CA0303, 0x001EC4}, {0x03B10300, 0x001F70}, {0x06D20654, 0x0006D3}, {0x30D53099, 0x0030D6},
    {0x1F2F0345, 0x001F9F}, {0x03B50300, 0x001F72}, {0x00750324, 0x001E73}, {0x04150306, 0x0004D6},
    {0x0065030C, 0x00011B}, {0x00570302, 0x000174}, {0x1EA00306, 0x001EB6}, {0x1F070345, 0x001F87},
    {0x00A80301, 0x000385}, {0x00790302, 0x000177}, {0x006E032D, 0x001E4B}, {0x006F030C, 0x0001D2},
    {0x03C90345, 0x001FF3}, {0x00430302, 0x000108}, {0x00790303, 0x001EF9}, {0x00740323, 0x001E6D},
    {0x00E20309, 0x001EA9}, {0x1F300300, 0x001F32}, {0x006B0301, 0x001E31}, {0x22920338, 0x0022E3},
    {0x03950314, 0x001F19}, {0x1F290301, 0x001F2D}, {0x00450328, 0x000118}, {0x1FB60345, 0x001FB7},
    {0x00D50304, 0x00022C}, {0x04300306, 0x0004D1}, {0x00F50308, 0x001E4F}, {0x1EA00302, 0x001EAC},
    {0x1F680300, 0x001F6A}, {0x03970300, 0x001FCA}, {0x00450301, 0x0000C9}, {0x00690304, 0x00012B},
    {0x0BC60BD7, 0x000BCC}, {0x006F0304, 0x00014D}, {0x004F0308, 0x0000D6}, {0x0BC70BBE, 0x000BCB},
    {0x0055030C, 0x0001D3}, {0x03AC0345, 0x001FB4}, {0x1FBF0342, 0x001FCF}, {0x30D2309A, 0x0030D4},
    {0x00660307, 0x001E1F}, {0x004E0300, 0x0001F8}, {0x00790308, 0x0000FF}, {0x0068032E, 0x001E2B},
    {0x0064030C, 0x00010F}, {0x004F0307, 0x00022E}, {0x1F590342, 0x001F5F}, {0x30AF3099, 0x0030B0},
    {0x00E60304, 0x0001E3}, {0x03C50301, 0x0003CD}, {0x00770308, 0x001E85}, {0x03B90314, 0x001F31},
    {0x00750323, 0x001EE5}, {0x00590309, 0x001EF6}, {0x0292030C, 0x0001EF}, {0x00550306, 0x00016C},
    {0x00E60301, 0x0001FD}, {0x016B0308, 0x001E7B}, {0x004F030F, 0x00020C}, {0x03BF0313, 0x001F40},
    {0x00D80301, 0x0001FE}, {0x00C20303, 0x001EAA}, {0x1F510300, 0x001F53}, {0x01B00309, 0x001EED},
    {0x004E032D, 0x001E4A}, {0x006F0309, 0x001ECF}, {0x04180300, 0x00040D}, {0x22A90338, 0x0022AE},
    {0x1F680345, 0x001FA8}, {0x1B3C1B35, 0x001B3D}, {0x1F400300, 0x001F42}, {0x1F0B0345, 0x001F8B},
    {0x03C50306, 0x001FE0}, {0x0044032D, 0x001E12}, {0x0CCA0CD5, 0x000CCB}, {0x00EA0303, 0x001EC5},
    {0x04230306, 0x00040E}, {0x00C70301, 0x001E08}, {0x007A030C, 0x00017E}, {0x00670307, 0x000121},
    {0x00450311, 0x000206}, {0x006F0300, 0x0000F2}, {0x30BB3099, 0x0030BC}, {0x04180308, 0x0004E4},
    {0x30513099, 0x003052}, {0x006C0323, 0x001E37}, {0x03B70314, 0x001F21}, {0x0077030A, 0x001E98},
    {0x00690323, 0x001ECB}, {0x00610303, 0x0000E3}, {0x30F13099, 0x0030F9}, {0x03B10345, 0x001FB3},
    {0x0D460D3E, 0x000D4A}, {0x03B90300, 0x001F76}, {0x21D40338, 0x0021CE}, {0x1F620345, 0x001FA2},
    {0x00770302, 0x000175}, {0x00FC0304, 0x0001D6}, {0x01130301, 0x001E17}, {0x30683099, 0x003069},
    {0x1F600342, 0x001F66}, {0x00680323, 0x001E25}, {0x03950313, 0x001F18}, {0x00EA0300, 0x001EC1},
    {0x03CB0342, 0x001FE7}, {0x22430338, 0x002244}, {0x30783099, 0x003079}, {0x03990313, 0x001F38},
    {0x00490330, 0x001E2C}, {0x00770307, 0x001E87}, {0x00650301, 0x0000E9}, {0x00680327, 0x001E29},
    {0x22B50338, 0x0022ED}, {0x03B10342, 0x001FB6}, {0x03910306, 0x001FB8}, {0x004D0301, 0x001E3E},
    {0x00410309, 0x001EA2}, {0x1B051B35, 0x001B06}, {0x003C0338, 0x00226E}, {0x00590308, 0x000178},
    {0x01030303, 0x001EB5}, {0x00480327, 0x001E28}, {0x006D0323, 0x001E43}, {0x30643099, 0x003065},
    {0x04560308, 0x000457}, {0x00590302, 0x000176}, {0x06C10654, 0x0006C2}, {0x043A0301, 0x00045C},
    {0x00E20300, 0x001EA7}, {0x03950301, 0x000388}, {0x00630327, 0x0000E7}, {0x017F0307, 0x001E9B},
    {0x06480654, 0x000624}, {0x30AB3099, 0x0030AC}, {0x01A00323, 0x001EE2}, {0x04D80308, 0x0004DA},
    {0x005A0331, 0x001E94}, {0x0067030C, 0x0001E7}, {0x039F0300, 0x001FF8}, {0x00650327, 0x000229},
    {0x00490323, 0x001ECA}, {0x1F110300, 0x001F13}, {0x1F510342, 0x001F57}, {0x004D0323, 0x001E42},
    {0x1F300301, 0x001F34}, {0x006C0327, 0x00013C}, {0x1F050345, 0x001F85}, {0x01A10300, 0x001EDD},
    {0x04160308, 0x0004DC}, {0x00640307, 0x001E0B}, {0x004C032D, 0x001E3C}, {0x03C10314, 0x001FE5},
    {0x01EA0304, 0x0001EC}, {0x1F080300, 0x001F0A}, {0x00650302, 0x0000EA}, {0x03910300, 0x001FBA},
    {0x00700301, 0x001E55}, {0x1F020345, 0x001F82}, {0x01020309, 0x001EB2}, {0x00750303, 0x000169},
    {0x1F0C0345, 0x001F8C}, {0x03CB0301, 0x0003B0}, {0x00740308, 0x001E97}, {0x03950300, 0x001FC8},
    {0x227D0338, 0x0022E1}, {0x007A0323, 0x001E93}, {0x006F0311, 0x00020F}, {0x006F0328, 0x0001EB},
    {0x1F200300, 0x001F22}, {0x1F190300, 0x001F1B}, {0x00560303, 0x001E7C}, {0x006B030C, 0x0001E9},
    {0x04E80308, 0x0004EA}, {0x03A90300, 0x001FFA}, {0x00A80342, 0x001FC1}, {0x04360306, 0x0004C2},
    {0x00DC0301, 0x0001D7}, {0x00750304, 0x00016B}, {0x22450338, 0x002247}, {0x00490304, 0x00012A},
    {0x04380308, 0x0004E5}, {0x0D460D57, 0x000D4C}, {0x00750300, 0x0000F9}, {0x22B40338, 0x0022EC},
    {0x00750308, 0x0000FC}, {0x03C50314, 0x001F51}, {0x01600307, 0x001E66}, {0x04160306, 0x0004C1},
    {0x0055031B, 0x0001AF}, {0x22AB0338, 0x0022AF}, {0x014C0300, 0x001E50}, {0x1F310342, 0x001F37},
    {0x1F260345, 0x001F96}, {0x22910338, 0x0022E2}, {0x00500301, 0x001E54}, {0x004C0327, 0x00013B},
    {0x005A0301, 0x000179}, {0x00420307, 0x001E02}, {0x03C10313, 0x001FE4}, {0x1F410301, 0x001F45},
    {0x00500307, 0x001E56}, {0x0043030C, 0x00010C}, {0x00730323, 0x001E63}, {0x30553099, 0x003056},
    {0x306F3099, 0x003070}, {0x044D0308, 0x0004ED}, {0x1F670345, 0x001FA7}, {0x01AF0301, 0x001EE8},
    {0x1F290300, 0x001F2B}, {0x1B3F1B35, 0x001B41}, {0x00450302, 0x0000CA}, {0x006F0306, 0x00014F},
    {0x00FC0301, 0x0001D8}, {0x30F23099, 0x0030FA}, {0x1F2D0345, 0x001F9D}, {0x014C0301, 0x001E52},
    {0x00610308, 0x0000E4}, {0x1F600345, 0x001FA0}, {0x1F0A0345, 0x001F8A}, {0x00610306, 0x000103},
    {0x1F600300, 0x001F62}, {0x01AF0300, 0x001EEA}, {0x043E0308, 0x0004E7}, {0x22230338, 0x002224},
    {0x03CA0301, 0x000390}, {0x30D5309A, 0x0030D7}, {0x1F220345, 0x001F92}, {0x00D50301, 0x001E4C},
    {0x1F6C0345, 0x001FAC}, {0x00540307, 0x001E6A}, {0x1E370304, 0x001E39}, {0x0DD90DCA, 0x000DDA},
    {0x01A10303, 0x001EE1}, {0x0048030C, 0x00021E}, {0x00EA0309, 0x001EC3}, {0x0052030C, 0x000158},
    {0x00D40303, 0x001ED6}, {0x0045030C, 0x00011A}, {0x30EF3099, 0x0030F7}, {0x00480302, 0x000124},
    {0x00520323, 0x001E5A}, {0x00C20300, 0x001EA6}, {0x0074032D, 0x001E71}, {0x042D0308, 0x0004EC},
    {0x0DD90DDF, 0x000DDE}, {0x00410308, 0x0000C4}, {0x0474030F, 0x000476}, {0x00C60301, 0x0001FC},
    {0x1F310301, 0x001F35}, {0x1F610300, 0x001F63}, {0x0CC60CC2, 0x000CCA}, {0x00C20301, 0x001EA4},
    {0x03C50308, 0x0003CB}, {0x00E20301, 0x001EA5}, {0x1F500342, 0x001F56}, {0x00610300, 0x0000E0},
    {0x00490311, 0x00020A}, {0x00670327, 0x000123}, {0x00590307, 0x001E8E}, {0x03970345, 0x001FCC},
    {0x00D40309, 0x001ED4}, {0x01A00303, 0x001EE0}, {0x1FFE0342, 0x001FDF}, {0x041A0301, 0x00040C},
    {0x0074030C, 0x000165}, {0x00DC0300, 0x0001DB}, {0x00780308, 0x001E8D}, {0x00DC0304, 0x0001D5},
    {0x00610302, 0x0000E2}, {0x005A0302, 0x001E90}, {0x0933093C, 0x000934}, {0x004F031B, 0x0001A0},
    {0x00520311, 0x000212}, {0x006E0303, 0x0000F1}, {0x0045030F, 0x000204}, {0x01AF0309, 0x001EEC},
    {0x00450304, 0x000112}, {0x1F210301, 0x001F25}, {0x022F0304, 0x000231}, {0x03990306, 0x001FD8},
    {0x004E0331, 0x001E48}, {0x1F380300, 0x001F3A}, {0x00490306, 0x00012C}, {0x00690306, 0x00012D},
    {0x1F060345, 0x001F86}, {0x00490301, 0x0000CD}, {0x00570300, 0x001E80}, {0x30F03099, 0x0030F8},
    {0x0053030C, 0x000160}, {0x00490300, 0x0000CC}, {0x30723099, 0x003073}, {0x1F280300, 0x001F2A},
    {0x00480307, 0x001E22}, {0x01A00309, 0x001EDE}, {0x01EB0304, 0x0001ED}, {0x1E630307, 0x001E69},
    {0x006F0323, 0x001ECD}, {0x00410303, 0x0000C3}, {0x03910345, 0x001FBC}, {0x00410328, 0x000104},
    {0x00680307, 0x001E23}, {0x006E0331, 0x001E49}, {0x0DDC0DCA, 0x000DDD}, {0x00580308, 0x001E8C},
    {0x00410301, 0x0000C1}, {0x30C43099, 0x0030C5}, {0x00420323, 0x001E04}, {0x00730302, 0x00015D}
};

const std::tuple<UTF32, UTF32, UTF32> COMPOSITION_TABLE_ASTRAL_VALUES[] {
    {0x11099, 0x110BA, 0x1109A}, {0x1109B, 0x110BA, 0x1109C}, {0x110A5, 0x110BA, 0x110AB}, {0x11131, 0x11127, 0x1112E},
    {0x11132, 0x11127, 0x1112F}, {0x11347, 0x1133E, 0x1134B}, {0x11347, 0x11357, 0x1134C}, {0x114B9, 0x114B0, 0x114BC},
    {0x114B9, 0x114BA, 0x114BB}, {0x114B9, 0x114BD, 0x114BE}, {0x115B8, 0x115AF, 0x115BA}, {0x115B9, 0x115AF, 0x115BB},
    {0x11935, 0x11930, 0x11938}
};

struct Cmp1 {
    bool operator()(const std::tuple<UTF32, UTF32, UTF32>& a, UTF32 b) const
    {
        return std::get<0>(a) < b;
    }
    bool operator()(UTF32 a, const std::tuple<UTF32, UTF32, UTF32>& b) const
    {
        return a < std::get<0>(b);
    }
} const cmp1{};

std::optional<UTF32> CompositionTableAstral(UTF32 c1, UTF32 c2)
{
    auto [begin, end] = std::equal_range(std::begin(COMPOSITION_TABLE_ASTRAL_VALUES),
        std::end(COMPOSITION_TABLE_ASTRAL_VALUES), c1, cmp1);
    if (begin == std::end(COMPOSITION_TABLE_ASTRAL_VALUES)) { // not found
        return std::nullopt;
    }
    for (auto it{begin}; it != end; ++it) {
        if (std::get<1>(*it) == c2) {
            return {std::get<2>(*it)};
        }
    }
    return std::nullopt;
}

constexpr UTF32 CANONICAL_DECOMPOSED_CHARS[]{
    0x0041, 0x0300, 0x0041, 0x0301, 0x0041, 0x0302, 0x0041, 0x0303, 0x0041, 0x0308, 0x0041, 0x030A, 0x0043, 0x0327,
    0x0045, 0x0300, 0x0045, 0x0301, 0x0045, 0x0302, 0x0045, 0x0308, 0x0049, 0x0300, 0x0049, 0x0301, 0x0049, 0x0302,
    0x0049, 0x0308, 0x004E, 0x0303, 0x004F, 0x0300, 0x004F, 0x0301, 0x004F, 0x0302, 0x004F, 0x0303, 0x004F, 0x0308,
    0x0055, 0x0300, 0x0055, 0x0301, 0x0055, 0x0302, 0x0055, 0x0308, 0x0059, 0x0301, 0x0061, 0x0300, 0x0061, 0x0301,
    0x0061, 0x0302, 0x0061, 0x0303, 0x0061, 0x0308, 0x0061, 0x030A, 0x0063, 0x0327, 0x0065, 0x0300, 0x0065, 0x0301,
    0x0065, 0x0302, 0x0065, 0x0308, 0x0069, 0x0300, 0x0069, 0x0301, 0x0069, 0x0302, 0x0069, 0x0308, 0x006E, 0x0303,
    0x006F, 0x0300, 0x006F, 0x0301, 0x006F, 0x0302, 0x006F, 0x0303, 0x006F, 0x0308, 0x0075, 0x0300, 0x0075, 0x0301,
    0x0075, 0x0302, 0x0075, 0x0308, 0x0079, 0x0301, 0x0079, 0x0308, 0x0041, 0x0304, 0x0061, 0x0304, 0x0041, 0x0306,
    0x0061, 0x0306, 0x0041, 0x0328, 0x0061, 0x0328, 0x0043, 0x0301, 0x0063, 0x0301, 0x0043, 0x0302, 0x0063, 0x0302,
    0x0043, 0x0307, 0x0063, 0x0307, 0x0043, 0x030C, 0x0063, 0x030C, 0x0044, 0x030C, 0x0064, 0x030C, 0x0045, 0x0304,
    0x0065, 0x0304, 0x0045, 0x0306, 0x0065, 0x0306, 0x0045, 0x0307, 0x0065, 0x0307, 0x0045, 0x0328, 0x0065, 0x0328,
    0x0045, 0x030C, 0x0065, 0x030C, 0x0047, 0x0302, 0x0067, 0x0302, 0x0047, 0x0306, 0x0067, 0x0306, 0x0047, 0x0307,
    0x0067, 0x0307, 0x0047, 0x0327, 0x0067, 0x0327, 0x0048, 0x0302, 0x0068, 0x0302, 0x0049, 0x0303, 0x0069, 0x0303,
    0x0049, 0x0304, 0x0069, 0x0304, 0x0049, 0x0306, 0x0069, 0x0306, 0x0049, 0x0328, 0x0069, 0x0328, 0x0049, 0x0307,
    0x004A, 0x0302, 0x006A, 0x0302, 0x004B, 0x0327, 0x006B, 0x0327, 0x004C, 0x0301, 0x006C, 0x0301, 0x004C, 0x0327,
    0x006C, 0x0327, 0x004C, 0x030C, 0x006C, 0x030C, 0x004E, 0x0301, 0x006E, 0x0301, 0x004E, 0x0327, 0x006E, 0x0327,
    0x004E, 0x030C, 0x006E, 0x030C, 0x004F, 0x0304, 0x006F, 0x0304, 0x004F, 0x0306, 0x006F, 0x0306, 0x004F, 0x030B,
    0x006F, 0x030B, 0x0052, 0x0301, 0x0072, 0x0301, 0x0052, 0x0327, 0x0072, 0x0327, 0x0052, 0x030C, 0x0072, 0x030C,
    0x0053, 0x0301, 0x0073, 0x0301, 0x0053, 0x0302, 0x0073, 0x0302, 0x0053, 0x0327, 0x0073, 0x0327, 0x0053, 0x030C,
    0x0073, 0x030C, 0x0054, 0x0327, 0x0074, 0x0327, 0x0054, 0x030C, 0x0074, 0x030C, 0x0055, 0x0303, 0x0075, 0x0303,
    0x0055, 0x0304, 0x0075, 0x0304, 0x0055, 0x0306, 0x0075, 0x0306, 0x0055, 0x030A, 0x0075, 0x030A, 0x0055, 0x030B,
    0x0075, 0x030B, 0x0055, 0x0328, 0x0075, 0x0328, 0x0057, 0x0302, 0x0077, 0x0302, 0x0059, 0x0302, 0x0079, 0x0302,
    0x0059, 0x0308, 0x005A, 0x0301, 0x007A, 0x0301, 0x005A, 0x0307, 0x007A, 0x0307, 0x005A, 0x030C, 0x007A, 0x030C,
    0x004F, 0x031B, 0x006F, 0x031B, 0x0055, 0x031B, 0x0075, 0x031B, 0x0041, 0x030C, 0x0061, 0x030C, 0x0049, 0x030C,
    0x0069, 0x030C, 0x004F, 0x030C, 0x006F, 0x030C, 0x0055, 0x030C, 0x0075, 0x030C, 0x0055, 0x0308, 0x0304, 0x0075,
    0x0308, 0x0304, 0x0055, 0x0308, 0x0301, 0x0075, 0x0308, 0x0301, 0x0055, 0x0308, 0x030C, 0x0075, 0x0308, 0x030C,
    0x0055, 0x0308, 0x0300, 0x0075, 0x0308, 0x0300, 0x0041, 0x0308, 0x0304, 0x0061, 0x0308, 0x0304, 0x0041, 0x0307,
    0x0304, 0x0061, 0x0307, 0x0304, 0x00C6, 0x0304, 0x00E6, 0x0304, 0x0047, 0x030C, 0x0067, 0x030C, 0x004B, 0x030C,
    0x006B, 0x030C, 0x004F, 0x0328, 0x006F, 0x0328, 0x004F, 0x0328, 0x0304, 0x006F, 0x0328, 0x0304, 0x01B7, 0x030C,
    0x0292, 0x030C, 0x006A, 0x030C, 0x0047, 0x0301, 0x0067, 0x0301, 0x004E, 0x0300, 0x006E, 0x0300, 0x0041, 0x030A,
    0x0301, 0x0061, 0x030A, 0x0301, 0x00C6, 0x0301, 0x00E6, 0x0301, 0x00D8, 0x0301, 0x00F8, 0x0301, 0x0041, 0x030F,
    0x0061, 0x030F, 0x0041, 0x0311, 0x0061, 0x0311, 0x0045, 0x030F, 0x0065, 0x030F, 0x0045, 0x0311, 0x0065, 0x0311,
    0x0049, 0x030F, 0x0069, 0x030F, 0x0049, 0x0311, 0x0069, 0x0311, 0x004F, 0x030F, 0x006F, 0x030F, 0x004F, 0x0311,
    0x006F, 0x0311, 0x0052, 0x030F, 0x0072, 0x030F, 0x0052, 0x0311, 0x0072, 0x0311, 0x0055, 0x030F, 0x0075, 0x030F,
    0x0055, 0x0311, 0x0075, 0x0311, 0x0053, 0x0326, 0x0073, 0x0326, 0x0054, 0x0326, 0x0074, 0x0326, 0x0048, 0x030C,
    0x0068, 0x030C, 0x0041, 0x0307, 0x0061, 0x0307, 0x0045, 0x0327, 0x0065, 0x0327, 0x004F, 0x0308, 0x0304, 0x006F,
    0x0308, 0x0304, 0x004F, 0x0303, 0x0304, 0x006F, 0x0303, 0x0304, 0x004F, 0x0307, 0x006F, 0x0307, 0x004F, 0x0307,
    0x0304, 0x006F, 0x0307, 0x0304, 0x0059, 0x0304, 0x0079, 0x0304, 0x0300, 0x0301, 0x0313, 0x0308, 0x0301, 0x02B9,
    0x003B, 0x00A8, 0x0301, 0x0391, 0x0301, 0x00B7, 0x0395, 0x0301, 0x0397, 0x0301, 0x0399, 0x0301, 0x039F, 0x0301,
    0x03A5, 0x0301, 0x03A9, 0x0301, 0x03B9, 0x0308, 0x0301, 0x0399, 0x0308, 0x03A5, 0x0308, 0x03B1, 0x0301, 0x03B5,
    0x0301, 0x03B7, 0x0301, 0x03B9, 0x0301, 0x03C5, 0x0308, 0x0301, 0x03B9, 0x0308, 0x03C5, 0x0308, 0x03BF, 0x0301,
    0x03C5, 0x0301, 0x03C9, 0x0301, 0x03D2, 0x0301, 0x03D2, 0x0308, 0x0415, 0x0300, 0x0415, 0x0308, 0x0413, 0x0301,
    0x0406, 0x0308, 0x041A, 0x0301, 0x0418, 0x0300, 0x0423, 0x0306, 0x0418, 0x0306, 0x0438, 0x0306, 0x0435, 0x0300,
    0x0435, 0x0308, 0x0433, 0x0301, 0x0456, 0x0308, 0x043A, 0x0301, 0x0438, 0x0300, 0x0443, 0x0306, 0x0474, 0x030F,
    0x0475, 0x030F, 0x0416, 0x0306, 0x0436, 0x0306, 0x0410, 0x0306, 0x0430, 0x0306, 0x0410, 0x0308, 0x0430, 0x0308,
    0x0415, 0x0306, 0x0435, 0x0306, 0x04D8, 0x0308, 0x04D9, 0x0308, 0x0416, 0x0308, 0x0436, 0x0308, 0x0417, 0x0308,
    0x0437, 0x0308, 0x0418, 0x0304, 0x0438, 0x0304, 0x0418, 0x0308, 0x0438, 0x0308, 0x041E, 0x0308, 0x043E, 0x0308,
    0x04E8, 0x0308, 0x04E9, 0x0308, 0x042D, 0x0308, 0x044D, 0x0308, 0x0423, 0x0304, 0x0443, 0x0304, 0x0423, 0x0308,
    0x0443, 0x0308, 0x0423, 0x030B, 0x0443, 0x030B, 0x0427, 0x0308, 0x0447, 0x0308, 0x042B, 0x0308, 0x044B, 0x0308,
    0x0627, 0x0653, 0x0627, 0x0654, 0x0648, 0x0654, 0x0627, 0x0655, 0x064A, 0x0654, 0x06D5, 0x0654, 0x06C1, 0x0654,
    0x06D2, 0x0654, 0x0928, 0x093C, 0x0930, 0x093C, 0x0933, 0x093C, 0x0915, 0x093C, 0x0916, 0x093C, 0x0917, 0x093C,
    0x091C, 0x093C, 0x0921, 0x093C, 0x0922, 0x093C, 0x092B, 0x093C, 0x092F, 0x093C, 0x09C7, 0x09BE, 0x09C7, 0x09D7,
    0x09A1, 0x09BC, 0x09A2, 0x09BC, 0x09AF, 0x09BC, 0x0A32, 0x0A3C, 0x0A38, 0x0A3C, 0x0A16, 0x0A3C, 0x0A17, 0x0A3C,
    0x0A1C, 0x0A3C, 0x0A2B, 0x0A3C, 0x0B47, 0x0B56, 0x0B47, 0x0B3E, 0x0B47, 0x0B57, 0x0B21, 0x0B3C, 0x0B22, 0x0B3C,
    0x0B92, 0x0BD7, 0x0BC6, 0x0BBE, 0x0BC7, 0x0BBE, 0x0BC6, 0x0BD7, 0x0C46, 0x0C56, 0x0CBF, 0x0CD5, 0x0CC6, 0x0CD5,
    0x0CC6, 0x0CD6, 0x0CC6, 0x0CC2, 0x0CC6, 0x0CC2, 0x0CD5, 0x0D46, 0x0D3E, 0x0D47, 0x0D3E, 0x0D46, 0x0D57, 0x0DD9,
    0x0DCA, 0x0DD9, 0x0DCF, 0x0DD9, 0x0DCF, 0x0DCA, 0x0DD9, 0x0DDF, 0x0F42, 0x0FB7, 0x0F4C, 0x0FB7, 0x0F51, 0x0FB7,
    0x0F56, 0x0FB7, 0x0F5B, 0x0FB7, 0x0F40, 0x0FB5, 0x0F71, 0x0F72, 0x0F71, 0x0F74, 0x0FB2, 0x0F80, 0x0FB3, 0x0F80,
    0x0F71, 0x0F80, 0x0F92, 0x0FB7, 0x0F9C, 0x0FB7, 0x0FA1, 0x0FB7, 0x0FA6, 0x0FB7, 0x0FAB, 0x0FB7, 0x0F90, 0x0FB5,
    0x1025, 0x102E, 0x1B05, 0x1B35, 0x1B07, 0x1B35, 0x1B09, 0x1B35, 0x1B0B, 0x1B35, 0x1B0D, 0x1B35, 0x1B11, 0x1B35,
    0x1B3A, 0x1B35, 0x1B3C, 0x1B35, 0x1B3E, 0x1B35, 0x1B3F, 0x1B35, 0x1B42, 0x1B35, 0x0041, 0x0325, 0x0061, 0x0325,
    0x0042, 0x0307, 0x0062, 0x0307, 0x0042, 0x0323, 0x0062, 0x0323, 0x0042, 0x0331, 0x0062, 0x0331, 0x0043, 0x0327,
    0x0301, 0x0063, 0x0327, 0x0301, 0x0044, 0x0307, 0x0064, 0x0307, 0x0044, 0x0323, 0x0064, 0x0323, 0x0044, 0x0331,
    0x0064, 0x0331, 0x0044, 0x0327, 0x0064, 0x0327, 0x0044, 0x032D, 0x0064, 0x032D, 0x0045, 0x0304, 0x0300, 0x0065,
    0x0304, 0x0300, 0x0045, 0x0304, 0x0301, 0x0065, 0x0304, 0x0301, 0x0045, 0x032D, 0x0065, 0x032D, 0x0045, 0x0330,
    0x0065, 0x0330, 0x0045, 0x0327, 0x0306, 0x0065, 0x0327, 0x0306, 0x0046, 0x0307, 0x0066, 0x0307, 0x0047, 0x0304,
    0x0067, 0x0304, 0x0048, 0x0307, 0x0068, 0x0307, 0x0048, 0x0323, 0x0068, 0x0323, 0x0048, 0x0308, 0x0068, 0x0308,
    0x0048, 0x0327, 0x0068, 0x0327, 0x0048, 0x032E, 0x0068, 0x032E, 0x0049, 0x0330, 0x0069, 0x0330, 0x0049, 0x0308,
    0x0301, 0x0069, 0x0308, 0x0301, 0x004B, 0x0301, 0x006B, 0x0301, 0x004B, 0x0323, 0x006B, 0x0323, 0x004B, 0x0331,
    0x006B, 0x0331, 0x004C, 0x0323, 0x006C, 0x0323, 0x004C, 0x0323, 0x0304, 0x006C, 0x0323, 0x0304, 0x004C, 0x0331,
    0x006C, 0x0331, 0x004C, 0x032D, 0x006C, 0x032D, 0x004D, 0x0301, 0x006D, 0x0301, 0x004D, 0x0307, 0x006D, 0x0307,
    0x004D, 0x0323, 0x006D, 0x0323, 0x004E, 0x0307, 0x006E, 0x0307, 0x004E, 0x0323, 0x006E, 0x0323, 0x004E, 0x0331,
    0x006E, 0x0331, 0x004E, 0x032D, 0x006E, 0x032D, 0x004F, 0x0303, 0x0301, 0x006F, 0x0303, 0x0301, 0x004F, 0x0303,
    0x0308, 0x006F, 0x0303, 0x0308, 0x004F, 0x0304, 0x0300, 0x006F, 0x0304, 0x0300, 0x004F, 0x0304, 0x0301, 0x006F,
    0x0304, 0x0301, 0x0050, 0x0301, 0x0070, 0x0301, 0x0050, 0x0307, 0x0070, 0x0307, 0x0052, 0x0307, 0x0072, 0x0307,
    0x0052, 0x0323, 0x0072, 0x0323, 0x0052, 0x0323, 0x0304, 0x0072, 0x0323, 0x0304, 0x0052, 0x0331, 0x0072, 0x0331,
    0x0053, 0x0307, 0x0073, 0x0307, 0x0053, 0x0323, 0x0073, 0x0323, 0x0053, 0x0301, 0x0307, 0x0073, 0x0301, 0x0307,
    0x0053, 0x030C, 0x0307, 0x0073, 0x030C, 0x0307, 0x0053, 0x0323, 0x0307, 0x0073, 0x0323, 0x0307, 0x0054, 0x0307,
    0x0074, 0x0307, 0x0054, 0x0323, 0x0074, 0x0323, 0x0054, 0x0331, 0x0074, 0x0331, 0x0054, 0x032D, 0x0074, 0x032D,
    0x0055, 0x0324, 0x0075, 0x0324, 0x0055, 0x0330, 0x0075, 0x0330, 0x0055, 0x032D, 0x0075, 0x032D, 0x0055, 0x0303,
    0x0301, 0x0075, 0x0303, 0x0301, 0x0055, 0x0304, 0x0308, 0x0075, 0x0304, 0x0308, 0x0056, 0x0303, 0x0076, 0x0303,
    0x0056, 0x0323, 0x0076, 0x0323, 0x0057, 0x0300, 0x0077, 0x0300, 0x0057, 0x0301, 0x0077, 0x0301, 0x0057, 0x0308,
    0x0077, 0x0308, 0x0057, 0x0307, 0x0077, 0x0307, 0x0057, 0x0323, 0x0077, 0x0323, 0x0058, 0x0307, 0x0078, 0x0307,
    0x0058, 0x0308, 0x0078, 0x0308, 0x0059, 0x0307, 0x0079, 0x0307, 0x005A, 0x0302, 0x007A, 0x0302, 0x005A, 0x0323,
    0x007A, 0x0323, 0x005A, 0x0331, 0x007A, 0x0331, 0x0068, 0x0331, 0x0074, 0x0308, 0x0077, 0x030A, 0x0079, 0x030A,
    0x017F, 0x0307, 0x0041, 0x0323, 0x0061, 0x0323, 0x0041, 0x0309, 0x0061, 0x0309, 0x0041, 0x0302, 0x0301, 0x0061,
    0x0302, 0x0301, 0x0041, 0x0302, 0x0300, 0x0061, 0x0302, 0x0300, 0x0041, 0x0302, 0x0309, 0x0061, 0x0302, 0x0309,
    0x0041, 0x0302, 0x0303, 0x0061, 0x0302, 0x0303, 0x0041, 0x0323, 0x0302, 0x0061, 0x0323, 0x0302, 0x0041, 0x0306,
    0x0301, 0x0061, 0x0306, 0x0301, 0x0041, 0x0306, 0x0300, 0x0061, 0x0306, 0x0300, 0x0041, 0x0306, 0x0309, 0x0061,
    0x0306, 0x0309, 0x0041, 0x0306, 0x0303, 0x0061, 0x0306, 0x0303, 0x0041, 0x0323, 0x0306, 0x0061, 0x0323, 0x0306,
    0x0045, 0x0323, 0x0065, 0x0323, 0x0045, 0x0309, 0x0065, 0x0309, 0x0045, 0x0303, 0x0065, 0x0303, 0x0045, 0x0302,
    0x0301, 0x0065, 0x0302, 0x0301, 0x0045, 0x0302, 0x0300, 0x0065, 0x0302, 0x0300, 0x0045, 0x0302, 0x0309, 0x0065,
    0x0302, 0x0309, 0x0045, 0x0302, 0x0303, 0x0065, 0x0302, 0x0303, 0x0045, 0x0323, 0x0302, 0x0065, 0x0323, 0x0302,
    0x0049, 0x0309, 0x0069, 0x0309, 0x0049, 0x0323, 0x0069, 0x0323, 0x004F, 0x0323, 0x006F, 0x0323, 0x004F, 0x0309,
    0x006F, 0x0309, 0x004F, 0x0302, 0x0301, 0x006F, 0x0302, 0x0301, 0x004F, 0x0302, 0x0300, 0x006F, 0x0302, 0x0300,
    0x004F, 0x0302, 0x0309, 0x006F, 0x0302, 0x0309, 0x004F, 0x0302, 0x0303, 0x006F, 0x0302, 0x0303, 0x004F, 0x0323,
    0x0302, 0x006F, 0x0323, 0x0302, 0x004F, 0x031B, 0x0301, 0x006F, 0x031B, 0x0301, 0x004F, 0x031B, 0x0300, 0x006F,
    0x031B, 0x0300, 0x004F, 0x031B, 0x0309, 0x006F, 0x031B, 0x0309, 0x004F, 0x031B, 0x0303, 0x006F, 0x031B, 0x0303,
    0x004F, 0x031B, 0x0323, 0x006F, 0x031B, 0x0323, 0x0055, 0x0323, 0x0075, 0x0323, 0x0055, 0x0309, 0x0075, 0x0309,
    0x0055, 0x031B, 0x0301, 0x0075, 0x031B, 0x0301, 0x0055, 0x031B, 0x0300, 0x0075, 0x031B, 0x0300, 0x0055, 0x031B,
    0x0309, 0x0075, 0x031B, 0x0309, 0x0055, 0x031B, 0x0303, 0x0075, 0x031B, 0x0303, 0x0055, 0x031B, 0x0323, 0x0075,
    0x031B, 0x0323, 0x0059, 0x0300, 0x0079, 0x0300, 0x0059, 0x0323, 0x0079, 0x0323, 0x0059, 0x0309, 0x0079, 0x0309,
    0x0059, 0x0303, 0x0079, 0x0303, 0x03B1, 0x0313, 0x03B1, 0x0314, 0x03B1, 0x0313, 0x0300, 0x03B1, 0x0314, 0x0300,
    0x03B1, 0x0313, 0x0301, 0x03B1, 0x0314, 0x0301, 0x03B1, 0x0313, 0x0342, 0x03B1, 0x0314, 0x0342, 0x0391, 0x0313,
    0x0391, 0x0314, 0x0391, 0x0313, 0x0300, 0x0391, 0x0314, 0x0300, 0x0391, 0x0313, 0x0301, 0x0391, 0x0314, 0x0301,
    0x0391, 0x0313, 0x0342, 0x0391, 0x0314, 0x0342, 0x03B5, 0x0313, 0x03B5, 0x0314, 0x03B5, 0x0313, 0x0300, 0x03B5,
    0x0314, 0x0300, 0x03B5, 0x0313, 0x0301, 0x03B5, 0x0314, 0x0301, 0x0395, 0x0313, 0x0395, 0x0314, 0x0395, 0x0313,
    0x0300, 0x0395, 0x0314, 0x0300, 0x0395, 0x0313, 0x0301, 0x0395, 0x0314, 0x0301, 0x03B7, 0x0313, 0x03B7, 0x0314,
    0x03B7, 0x0313, 0x0300, 0x03B7, 0x0314, 0x0300, 0x03B7, 0x0313, 0x0301, 0x03B7, 0x0314, 0x0301, 0x03B7, 0x0313,
    0x0342, 0x03B7, 0x0314, 0x0342, 0x0397, 0x0313, 0x0397, 0x0314, 0x0397, 0x0313, 0x0300, 0x0397, 0x0314, 0x0300,
    0x0397, 0x0313, 0x0301, 0x0397, 0x0314, 0x0301, 0x0397, 0x0313, 0x0342, 0x0397, 0x0314, 0x0342, 0x03B9, 0x0313,
    0x03B9, 0x0314, 0x03B9, 0x0313, 0x0300, 0x03B9, 0x0314, 0x0300, 0x03B9, 0x0313, 0x0301, 0x03B9, 0x0314, 0x0301,
    0x03B9, 0x0313, 0x0342, 0x03B9, 0x0314, 0x0342, 0x0399, 0x0313, 0x0399, 0x0314, 0x0399, 0x0313, 0x0300, 0x0399,
    0x0314, 0x0300, 0x0399, 0x0313, 0x0301, 0x0399, 0x0314, 0x0301, 0x0399, 0x0313, 0x0342, 0x0399, 0x0314, 0x0342,
    0x03BF, 0x0313, 0x03BF, 0x0314, 0x03BF, 0x0313, 0x0300, 0x03BF, 0x0314, 0x0300, 0x03BF, 0x0313, 0x0301, 0x03BF,
    0x0314, 0x0301, 0x039F, 0x0313, 0x039F, 0x0314, 0x039F, 0x0313, 0x0300, 0x039F, 0x0314, 0x0300, 0x039F, 0x0313,
    0x0301, 0x039F, 0x0314, 0x0301, 0x03C5, 0x0313, 0x03C5, 0x0314, 0x03C5, 0x0313, 0x0300, 0x03C5, 0x0314, 0x0300,
    0x03C5, 0x0313, 0x0301, 0x03C5, 0x0314, 0x0301, 0x03C5, 0x0313, 0x0342, 0x03C5, 0x0314, 0x0342, 0x03A5, 0x0314,
    0x03A5, 0x0314, 0x0300, 0x03A5, 0x0314, 0x0301, 0x03A5, 0x0314, 0x0342, 0x03C9, 0x0313, 0x03C9, 0x0314, 0x03C9,
    0x0313, 0x0300, 0x03C9, 0x0314, 0x0300, 0x03C9, 0x0313, 0x0301, 0x03C9, 0x0314, 0x0301, 0x03C9, 0x0313, 0x0342,
    0x03C9, 0x0314, 0x0342, 0x03A9, 0x0313, 0x03A9, 0x0314, 0x03A9, 0x0313, 0x0300, 0x03A9, 0x0314, 0x0300, 0x03A9,
    0x0313, 0x0301, 0x03A9, 0x0314, 0x0301, 0x03A9, 0x0313, 0x0342, 0x03A9, 0x0314, 0x0342, 0x03B1, 0x0300, 0x03B1,
    0x0301, 0x03B5, 0x0300, 0x03B5, 0x0301, 0x03B7, 0x0300, 0x03B7, 0x0301, 0x03B9, 0x0300, 0x03B9, 0x0301, 0x03BF,
    0x0300, 0x03BF, 0x0301, 0x03C5, 0x0300, 0x03C5, 0x0301, 0x03C9, 0x0300, 0x03C9, 0x0301, 0x03B1, 0x0313, 0x0345,
    0x03B1, 0x0314, 0x0345, 0x03B1, 0x0313, 0x0300, 0x0345, 0x03B1, 0x0314, 0x0300, 0x0345, 0x03B1, 0x0313, 0x0301,
    0x0345, 0x03B1, 0x0314, 0x0301, 0x0345, 0x03B1, 0x0313, 0x0342, 0x0345, 0x03B1, 0x0314, 0x0342, 0x0345, 0x0391,
    0x0313, 0x0345, 0x0391, 0x0314, 0x0345, 0x0391, 0x0313, 0x0300, 0x0345, 0x0391, 0x0314, 0x0300, 0x0345, 0x0391,
    0x0313, 0x0301, 0x0345, 0x0391, 0x0314, 0x0301, 0x0345, 0x0391, 0x0313, 0x0342, 0x0345, 0x0391, 0x0314, 0x0342,
    0x0345, 0x03B7, 0x0313, 0x0345, 0x03B7, 0x0314, 0x0345, 0x03B7, 0x0313, 0x0300, 0x0345, 0x03B7, 0x0314, 0x0300,
    0x0345, 0x03B7, 0x0313, 0x0301, 0x0345, 0x03B7, 0x0314, 0x0301, 0x0345, 0x03B7, 0x0313, 0x0342, 0x0345, 0x03B7,
    0x0314, 0x0342, 0x0345, 0x0397, 0x0313, 0x0345, 0x0397, 0x0314, 0x0345, 0x0397, 0x0313, 0x0300, 0x0345, 0x0397,
    0x0314, 0x0300, 0x0345, 0x0397, 0x0313, 0x0301, 0x0345, 0x0397, 0x0314, 0x0301, 0x0345, 0x0397, 0x0313, 0x0342,
    0x0345, 0x0397, 0x0314, 0x0342, 0x0345, 0x03C9, 0x0313, 0x0345, 0x03C9, 0x0314, 0x0345, 0x03C9, 0x0313, 0x0300,
    0x0345, 0x03C9, 0x0314, 0x0300, 0x0345, 0x03C9, 0x0313, 0x0301, 0x0345, 0x03C9, 0x0314, 0x0301, 0x0345, 0x03C9,
    0x0313, 0x0342, 0x0345, 0x03C9, 0x0314, 0x0342, 0x0345, 0x03A9, 0x0313, 0x0345, 0x03A9, 0x0314, 0x0345, 0x03A9,
    0x0313, 0x0300, 0x0345, 0x03A9, 0x0314, 0x0300, 0x0345, 0x03A9, 0x0313, 0x0301, 0x0345, 0x03A9, 0x0314, 0x0301,
    0x0345, 0x03A9, 0x0313, 0x0342, 0x0345, 0x03A9, 0x0314, 0x0342, 0x0345, 0x03B1, 0x0306, 0x03B1, 0x0304, 0x03B1,
    0x0300, 0x0345, 0x03B1, 0x0345, 0x03B1, 0x0301, 0x0345, 0x03B1, 0x0342, 0x03B1, 0x0342, 0x0345, 0x0391, 0x0306,
    0x0391, 0x0304, 0x0391, 0x0300, 0x0391, 0x0301, 0x0391, 0x0345, 0x03B9, 0x00A8, 0x0342, 0x03B7, 0x0300, 0x0345,
    0x03B7, 0x0345, 0x03B7, 0x0301, 0x0345, 0x03B7, 0x0342, 0x03B7, 0x0342, 0x0345, 0x0395, 0x0300, 0x0395, 0x0301,
    0x0397, 0x0300, 0x0397, 0x0301, 0x0397, 0x0345, 0x1FBF, 0x0300, 0x1FBF, 0x0301, 0x1FBF, 0x0342, 0x03B9, 0x0306,
    0x03B9, 0x0304, 0x03B9, 0x0308, 0x0300, 0x03B9, 0x0308, 0x0301, 0x03B9, 0x0342, 0x03B9, 0x0308, 0x0342, 0x0399,
    0x0306, 0x0399, 0x0304, 0x0399, 0x0300, 0x0399, 0x0301, 0x1FFE, 0x0300, 0x1FFE, 0x0301, 0x1FFE, 0x0342, 0x03C5,
    0x0306, 0x03C5, 0x0304, 0x03C5, 0x0308, 0x0300, 0x03C5, 0x0308, 0x0301, 0x03C1, 0x0313, 0x03C1, 0x0314, 0x03C5,
    0x0342, 0x03C5, 0x0308, 0x0342, 0x03A5, 0x0306, 0x03A5, 0x0304, 0x03A5, 0x0300, 0x03A5, 0x0301, 0x03A1, 0x0314,
    0x00A8, 0x0300, 0x00A8, 0x0301, 0x0060, 0x03C9, 0x0300, 0x0345, 0x03C9, 0x0345, 0x03C9, 0x0301, 0x0345, 0x03C9,
    0x0342, 0x03C9, 0x0342, 0x0345, 0x039F, 0x0300, 0x039F, 0x0301, 0x03A9, 0x0300, 0x03A9, 0x0301, 0x03A9, 0x0345,
    0x00B4, 0x2002, 0x2003, 0x03A9, 0x004B, 0x0041, 0x030A, 0x2190, 0x0338, 0x2192, 0x0338, 0x2194, 0x0338, 0x21D0,
    0x0338, 0x21D4, 0x0338, 0x21D2, 0x0338, 0x2203, 0x0338, 0x2208, 0x0338, 0x220B, 0x0338, 0x2223, 0x0338, 0x2225,
    0x0338, 0x223C, 0x0338, 0x2243, 0x0338, 0x2245, 0x0338, 0x2248, 0x0338, 0x003D, 0x0338, 0x2261, 0x0338, 0x224D,
    0x0338, 0x003C, 0x0338, 0x003E, 0x0338, 0x2264, 0x0338, 0x2265, 0x0338, 0x2272, 0x0338, 0x2273, 0x0338, 0x2276,
    0x0338, 0x2277, 0x0338, 0x227A, 0x0338, 0x227B, 0x0338, 0x2282, 0x0338, 0x2283, 0x0338, 0x2286, 0x0338, 0x2287,
    0x0338, 0x22A2, 0x0338, 0x22A8, 0x0338, 0x22A9, 0x0338, 0x22AB, 0x0338, 0x227C, 0x0338, 0x227D, 0x0338, 0x2291,
    0x0338, 0x2292, 0x0338, 0x22B2, 0x0338, 0x22B3, 0x0338, 0x22B4, 0x0338, 0x22B5, 0x0338, 0x3008, 0x3009, 0x2ADD,
    0x0338, 0x304B, 0x3099, 0x304D, 0x3099, 0x304F, 0x3099, 0x3051, 0x3099, 0x3053, 0x3099, 0x3055, 0x3099, 0x3057,
    0x3099, 0x3059, 0x3099, 0x305B, 0x3099, 0x305D, 0x3099, 0x305F, 0x3099, 0x3061, 0x3099, 0x3064, 0x3099, 0x3066,
    0x3099, 0x3068, 0x3099, 0x306F, 0x3099, 0x306F, 0x309A, 0x3072, 0x3099, 0x3072, 0x309A, 0x3075, 0x3099, 0x3075,
    0x309A, 0x3078, 0x3099, 0x3078, 0x309A, 0x307B, 0x3099, 0x307B, 0x309A, 0x3046, 0x3099, 0x309D, 0x3099, 0x30AB,
    0x3099, 0x30AD, 0x3099, 0x30AF, 0x3099, 0x30B1, 0x3099, 0x30B3, 0x3099, 0x30B5, 0x3099, 0x30B7, 0x3099, 0x30B9,
    0x3099, 0x30BB, 0x3099, 0x30BD, 0x3099, 0x30BF, 0x3099, 0x30C1, 0x3099, 0x30C4, 0x3099, 0x30C6, 0x3099, 0x30C8,
    0x3099, 0x30CF, 0x3099, 0x30CF, 0x309A, 0x30D2, 0x3099, 0x30D2, 0x309A, 0x30D5, 0x3099, 0x30D5, 0x309A, 0x30D8,
    0x3099, 0x30D8, 0x309A, 0x30DB, 0x3099, 0x30DB, 0x309A, 0x30A6, 0x3099, 0x30EF, 0x3099, 0x30F0, 0x3099, 0x30F1,
    0x3099, 0x30F2, 0x3099, 0x30FD, 0x3099, 0x8C48, 0x66F4, 0x8ECA, 0x8CC8, 0x6ED1, 0x4E32, 0x53E5, 0x9F9C, 0x9F9C,
    0x5951, 0x91D1, 0x5587, 0x5948, 0x61F6, 0x7669, 0x7F85, 0x863F, 0x87BA, 0x88F8, 0x908F, 0x6A02, 0x6D1B, 0x70D9,
    0x73DE, 0x843D, 0x916A, 0x99F1, 0x4E82, 0x5375, 0x6B04, 0x721B, 0x862D, 0x9E1E, 0x5D50, 0x6FEB, 0x85CD, 0x8964,
    0x62C9, 0x81D8, 0x881F, 0x5ECA, 0x6717, 0x6D6A, 0x72FC, 0x90CE, 0x4F86, 0x51B7, 0x52DE, 0x64C4, 0x6AD3, 0x7210,
    0x76E7, 0x8001, 0x8606, 0x865C, 0x8DEF, 0x9732, 0x9B6F, 0x9DFA, 0x788C, 0x797F, 0x7DA0, 0x83C9, 0x9304, 0x9E7F,
    0x8AD6, 0x58DF, 0x5F04, 0x7C60, 0x807E, 0x7262, 0x78CA, 0x8CC2, 0x96F7, 0x58D8, 0x5C62, 0x6A13, 0x6DDA, 0x6F0F,
    0x7D2F, 0x7E37, 0x964B, 0x52D2, 0x808B, 0x51DC, 0x51CC, 0x7A1C, 0x7DBE, 0x83F1, 0x9675, 0x8B80, 0x62CF, 0x6A02,
    0x8AFE, 0x4E39, 0x5BE7, 0x6012, 0x7387, 0x7570, 0x5317, 0x78FB, 0x4FBF, 0x5FA9, 0x4E0D, 0x6CCC, 0x6578, 0x7D22,
    0x53C3, 0x585E, 0x7701, 0x8449, 0x8AAA, 0x6BBA, 0x8FB0, 0x6C88, 0x62FE, 0x82E5, 0x63A0, 0x7565, 0x4EAE, 0x5169,
    0x51C9, 0x6881, 0x7CE7, 0x826F, 0x8AD2, 0x91CF, 0x52F5, 0x5442, 0x5973, 0x5EEC, 0x65C5, 0x6FFE, 0x792A, 0x95AD,
    0x9A6A, 0x9E97, 0x9ECE, 0x529B, 0x66C6, 0x6B77, 0x8F62, 0x5E74, 0x6190, 0x6200, 0x649A, 0x6F23, 0x7149, 0x7489,
    0x79CA, 0x7DF4, 0x806F, 0x8F26, 0x84EE, 0x9023, 0x934A, 0x5217, 0x52A3, 0x54BD, 0x70C8, 0x88C2, 0x8AAA, 0x5EC9,
    0x5FF5, 0x637B, 0x6BAE, 0x7C3E, 0x7375, 0x4EE4, 0x56F9, 0x5BE7, 0x5DBA, 0x601C, 0x73B2, 0x7469, 0x7F9A, 0x8046,
    0x9234, 0x96F6, 0x9748, 0x9818, 0x4F8B, 0x79AE, 0x91B4, 0x96B8, 0x60E1, 0x4E86, 0x50DA, 0x5BEE, 0x5C3F, 0x6599,
    0x6A02, 0x71CE, 0x7642, 0x84FC, 0x907C, 0x9F8D, 0x6688, 0x962E, 0x5289, 0x677B, 0x67F3, 0x6D41, 0x6E9C, 0x7409,
    0x7559, 0x786B, 0x7D10, 0x985E, 0x516D, 0x622E, 0x9678, 0x502B, 0x5D19, 0x6DEA, 0x8F2A, 0x5F8B, 0x6144, 0x6817,
    0x7387, 0x9686, 0x5229, 0x540F, 0x5C65, 0x6613, 0x674E, 0x68A8, 0x6CE5, 0x7406, 0x75E2, 0x7F79, 0x88CF, 0x88E1,
    0x91CC, 0x96E2, 0x533F, 0x6EBA, 0x541D, 0x71D0, 0x7498, 0x85FA, 0x96A3, 0x9C57, 0x9E9F, 0x6797, 0x6DCB, 0x81E8,
    0x7ACB, 0x7B20, 0x7C92, 0x72C0, 0x7099, 0x8B58, 0x4EC0, 0x8336, 0x523A, 0x5207, 0x5EA6, 0x62D3, 0x7CD6, 0x5B85,
    0x6D1E, 0x66B4, 0x8F3B, 0x884C, 0x964D, 0x898B, 0x5ED3, 0x5140, 0x55C0, 0x585A, 0x6674, 0x51DE, 0x732A, 0x76CA,
    0x793C, 0x795E, 0x7965, 0x798F, 0x9756, 0x7CBE, 0x7FBD, 0x8612, 0x8AF8, 0x9038, 0x90FD, 0x98EF, 0x98FC, 0x9928,
    0x9DB4, 0x90DE, 0x96B7, 0x4FAE, 0x50E7, 0x514D, 0x52C9, 0x52E4, 0x5351, 0x559D, 0x5606, 0x5668, 0x5840, 0x58A8,
    0x5C64, 0x5C6E, 0x6094, 0x6168, 0x618E, 0x61F2, 0x654F, 0x65E2, 0x6691, 0x6885, 0x6D77, 0x6E1A, 0x6F22, 0x716E,
    0x722B, 0x7422, 0x7891, 0x793E, 0x7949, 0x7948, 0x7950, 0x7956, 0x795D, 0x798D, 0x798E, 0x7A40, 0x7A81, 0x7BC0,
    0x7DF4, 0x7E09, 0x7E41, 0x7F72, 0x8005, 0x81ED, 0x8279, 0x8279, 0x8457, 0x8910, 0x8996, 0x8B01, 0x8B39, 0x8CD3,
    0x8D08, 0x8FB6, 0x9038, 0x96E3, 0x97FF, 0x983B, 0x6075, 0x242EE, 0x8218, 0x4E26, 0x51B5, 0x5168, 0x4F80, 0x5145,
    0x5180, 0x52C7, 0x52FA, 0x559D, 0x5555, 0x5599, 0x55E2, 0x585A, 0x58B3, 0x5944, 0x5954, 0x5A62, 0x5B28, 0x5ED2,
    0x5ED9, 0x5F69, 0x5FAD, 0x60D8, 0x614E, 0x6108, 0x618E, 0x6160, 0x61F2, 0x6234, 0x63C4, 0x641C, 0x6452, 0x6556,
    0x6674, 0x6717, 0x671B, 0x6756, 0x6B79, 0x6BBA, 0x6D41, 0x6EDB, 0x6ECB, 0x6F22, 0x701E, 0x716E, 0x77A7, 0x7235,
    0x72AF, 0x732A, 0x7471, 0x7506, 0x753B, 0x761D, 0x761F, 0x76CA, 0x76DB, 0x76F4, 0x774A, 0x7740, 0x78CC, 0x7AB1,
    0x7BC0, 0x7C7B, 0x7D5B, 0x7DF4, 0x7F3E, 0x8005, 0x8352, 0x83EF, 0x8779, 0x8941, 0x8986, 0x8996, 0x8ABF, 0x8AF8,
    0x8ACB, 0x8B01, 0x8AFE, 0x8AED, 0x8B39, 0x8B8A, 0x8D08, 0x8F38, 0x9072, 0x9199, 0x9276, 0x967C, 0x96E3, 0x9756,
    0x97DB, 0x97FF, 0x980B, 0x983B, 0x9B12, 0x9F9C, 0x2284A, 0x22844, 0x233D5, 0x3B9D, 0x4018, 0x4039, 0x25249, 0x25CD0,
    0x27ED3, 0x9F43, 0x9F8E, 0x05D9, 0x05B4, 0x05F2, 0x05B7, 0x05E9, 0x05C1, 0x05E9, 0x05C2, 0x05E9, 0x05BC, 0x05C1,
    0x05E9, 0x05BC, 0x05C2, 0x05D0, 0x05B7, 0x05D0, 0x05B8, 0x05D0, 0x05BC, 0x05D1, 0x05BC, 0x05D2, 0x05BC, 0x05D3,
    0x05BC, 0x05D4, 0x05BC, 0x05D5, 0x05BC, 0x05D6, 0x05BC, 0x05D8, 0x05BC, 0x05D9, 0x05BC, 0x05DA, 0x05BC, 0x05DB,
    0x05BC, 0x05DC, 0x05BC, 0x05DE, 0x05BC, 0x05E0, 0x05BC, 0x05E1, 0x05BC, 0x05E3, 0x05BC, 0x05E4, 0x05BC, 0x05E6,
    0x05BC, 0x05E7, 0x05BC, 0x05E8, 0x05BC, 0x05E9, 0x05BC, 0x05EA, 0x05BC, 0x05D5, 0x05B9, 0x05D1, 0x05BF, 0x05DB,
    0x05BF, 0x05E4, 0x05BF, 0x11099, 0x110BA, 0x1109B, 0x110BA, 0x110A5, 0x110BA, 0x11131, 0x11127, 0x11132, 0x11127,
    0x11347, 0x1133E, 0x11347, 0x11357, 0x114B9, 0x114BA, 0x114B9, 0x114B0, 0x114B9, 0x114BD, 0x115B8, 0x115AF, 0x115B9,
    0x115AF, 0x11935, 0x11930, 0x1D157, 0x1D165, 0x1D158, 0x1D165, 0x1D158, 0x1D165, 0x1D16E, 0x1D158, 0x1D165, 0x1D16F,
    0x1D158, 0x1D165, 0x1D170, 0x1D158, 0x1D165, 0x1D171, 0x1D158, 0x1D165, 0x1D172, 0x1D1B9, 0x1D165, 0x1D1BA, 0x1D165,
    0x1D1B9, 0x1D165, 0x1D16E, 0x1D1BA, 0x1D165, 0x1D16E, 0x1D1B9, 0x1D165, 0x1D16F, 0x1D1BA, 0x1D165, 0x1D16F, 0x4E3D,
    0x4E38, 0x4E41, 0x20122, 0x4F60, 0x4FAE, 0x4FBB, 0x5002, 0x507A, 0x5099, 0x50E7, 0x50CF, 0x349E, 0x2063A, 0x514D,
    0x5154, 0x5164, 0x5177, 0x2051C, 0x34B9, 0x5167, 0x518D, 0x2054B, 0x5197, 0x51A4, 0x4ECC, 0x51AC, 0x51B5, 0x291DF,
    0x51F5, 0x5203, 0x34DF, 0x523B, 0x5246, 0x5272, 0x5277, 0x3515, 0x52C7, 0x52C9, 0x52E4, 0x52FA, 0x5305, 0x5306,
    0x5317, 0x5349, 0x5351, 0x535A, 0x5373, 0x537D, 0x537F, 0x537F, 0x537F, 0x20A2C, 0x7070, 0x53CA, 0x53DF, 0x20B63,
    0x53EB, 0x53F1, 0x5406, 0x549E, 0x5438, 0x5448, 0x5468, 0x54A2, 0x54F6, 0x5510, 0x5553, 0x5563, 0x5584, 0x5584,
    0x5599, 0x55AB, 0x55B3, 0x55C2, 0x5716, 0x5606, 0x5717, 0x5651, 0x5674, 0x5207, 0x58EE, 0x57CE, 0x57F4, 0x580D,
    0x578B, 0x5832, 0x5831, 0x58AC, 0x214E4, 0x58F2, 0x58F7, 0x5906, 0x591A, 0x5922, 0x5962, 0x216A8, 0x216EA, 0x59EC,
    0x5A1B, 0x5A27, 0x59D8, 0x5A66, 0x36EE, 0x36FC, 0x5B08, 0x5B3E, 0x5B3E, 0x219C8, 0x5BC3, 0x5BD8, 0x5BE7, 0x5BF3,
    0x21B18, 0x5BFF, 0x5C06, 0x5F53, 0x5C22, 0x3781, 0x5C60, 0x5C6E, 0x5CC0, 0x5C8D, 0x21DE4, 0x5D43, 0x21DE6, 0x5D6E,
    0x5D6B, 0x5D7C, 0x5DE1, 0x5DE2, 0x382F, 0x5DFD, 0x5E28, 0x5E3D, 0x5E69, 0x3862, 0x22183, 0x387C, 0x5EB0, 0x5EB3,
    0x5EB6, 0x5ECA, 0x2A392, 0x5EFE, 0x22331, 0x22331, 0x8201, 0x5F22, 0x5F22, 0x38C7, 0x232B8, 0x261DA, 0x5F62, 0x5F6B,
    0x38E3, 0x5F9A, 0x5FCD, 0x5FD7, 0x5FF9, 0x6081, 0x393A, 0x391C, 0x6094, 0x226D4, 0x60C7, 0x6148, 0x614C, 0x614E,
    0x614C, 0x617A, 0x618E, 0x61B2, 0x61A4, 0x61AF, 0x61DE, 0x61F2, 0x61F6, 0x6210, 0x621B, 0x625D, 0x62B1, 0x62D4,
    0x6350, 0x22B0C, 0x633D, 0x62FC, 0x6368, 0x6383, 0x63E4, 0x22BF1, 0x6422, 0x63C5, 0x63A9, 0x3A2E, 0x6469, 0x647E,
    0x649D, 0x6477, 0x3A6C, 0x654F, 0x656C, 0x2300A, 0x65E3, 0x66F8, 0x6649, 0x3B19, 0x6691, 0x3B08, 0x3AE4, 0x5192,
    0x5195, 0x6700, 0x669C, 0x80AD, 0x43D9, 0x6717, 0x671B, 0x6721, 0x675E, 0x6753, 0x233C3, 0x3B49, 0x67FA, 0x6785,
    0x6852, 0x6885, 0x2346D, 0x688E, 0x681F, 0x6914, 0x3B9D, 0x6942, 0x69A3, 0x69EA, 0x6AA8, 0x236A3, 0x6ADB, 0x3C18,
    0x6B21, 0x238A7, 0x6B54, 0x3C4E, 0x6B72, 0x6B9F, 0x6BBA, 0x6BBB, 0x23A8D, 0x21D0B, 0x23AFA, 0x6C4E, 0x23CBC, 0x6CBF,
    0x6CCD, 0x6C67, 0x6D16, 0x6D3E, 0x6D77, 0x6D41, 0x6D69, 0x6D78, 0x6D85, 0x23D1E, 0x6D34, 0x6E2F, 0x6E6E, 0x3D33,
    0x6ECB, 0x6EC7, 0x23ED1, 0x6DF9, 0x6F6E, 0x23F5E, 0x23F8E, 0x6FC6, 0x7039, 0x701E, 0x701B, 0x3D96, 0x704A, 0x707D,
    0x7077, 0x70AD, 0x20525, 0x7145, 0x24263, 0x719C, 0x243AB, 0x7228, 0x7235, 0x7250, 0x24608, 0x7280, 0x7295, 0x24735,
    0x24814, 0x737A, 0x738B, 0x3EAC, 0x73A5, 0x3EB8, 0x3EB8, 0x7447, 0x745C, 0x7471, 0x7485, 0x74CA, 0x3F1B, 0x7524,
    0x24C36, 0x753E, 0x24C92, 0x7570, 0x2219F, 0x7610, 0x24FA1, 0x24FB8, 0x25044, 0x3FFC, 0x4008, 0x76F4, 0x250F3,
    0x250F2, 0x25119, 0x25133, 0x771E, 0x771F, 0x771F, 0x774A, 0x4039, 0x778B, 0x4046, 0x4096, 0x2541D, 0x784E, 0x788C,
    0x78CC, 0x40E3, 0x25626, 0x7956, 0x2569A, 0x256C5, 0x798F, 0x79EB, 0x412F, 0x7A40, 0x7A4A, 0x7A4F, 0x2597C, 0x25AA7,
    0x25AA7, 0x7AEE, 0x4202, 0x25BAB, 0x7BC6, 0x7BC9, 0x4227, 0x25C80, 0x7CD2, 0x42A0, 0x7CE8, 0x7CE3, 0x7D00, 0x25F86,
    0x7D63, 0x4301, 0x7DC7, 0x7E02, 0x7E45, 0x4334, 0x26228, 0x26247, 0x4359, 0x262D9, 0x7F7A, 0x2633E, 0x7F95, 0x7FFA,
    0x8005, 0x264DA, 0x26523, 0x8060, 0x265A8, 0x8070, 0x2335F, 0x43D5, 0x80B2, 0x8103, 0x440B, 0x813E, 0x5AB5, 0x267A7,
    0x267B5, 0x23393, 0x2339C, 0x8201, 0x8204, 0x8F9E, 0x446B, 0x8291, 0x828B, 0x829D, 0x52B3, 0x82B1, 0x82B3, 0x82BD,
    0x82E6, 0x26B3C, 0x82E5, 0x831D, 0x8363, 0x83AD, 0x8323, 0x83BD, 0x83E7, 0x8457, 0x8353, 0x83CA, 0x83CC, 0x83DC,
    0x26C36, 0x26D6B, 0x26CD5, 0x452B, 0x84F1, 0x84F3, 0x8516, 0x273CA, 0x8564, 0x26F2C, 0x455D, 0x4561, 0x26FB1,
    0x270D2, 0x456B, 0x8650, 0x865C, 0x8667, 0x8669, 0x86A9, 0x8688, 0x870E, 0x86E2, 0x8779, 0x8728, 0x876B, 0x8786,
    0x45D7, 0x87E1, 0x8801, 0x45F9, 0x8860, 0x8863, 0x27667, 0x88D7, 0x88DE, 0x4635, 0x88FA, 0x34BB, 0x278AE, 0x27966,
    0x46BE, 0x46C7, 0x8AA0, 0x8AED, 0x8B8A, 0x8C55, 0x27CA8, 0x8CAB, 0x8CC1, 0x8D1B, 0x8D77, 0x27F2F, 0x20804, 0x8DCB,
    0x8DBC, 0x8DF0, 0x208DE, 0x8ED4, 0x8F38, 0x285D2, 0x285ED, 0x9094, 0x90F1, 0x9111, 0x2872E, 0x911B, 0x9238, 0x92D7,
    0x92D8, 0x927C, 0x93F9, 0x9415, 0x28BFA, 0x958B, 0x4995, 0x95B7, 0x28D77, 0x49E6, 0x96C3, 0x5DB2, 0x9723, 0x29145,
    0x2921A, 0x4A6E, 0x4A76, 0x97E0, 0x2940A, 0x4AB2, 0x29496, 0x980B, 0x980B, 0x9829, 0x295B6, 0x98E2, 0x4B33, 0x9929,
    0x99A7, 0x99C2, 0x99FE, 0x4BCE, 0x29B30, 0x9B12, 0x9C40, 0x9CFD, 0x4CCE, 0x4CED, 0x9D67, 0x2A0CE, 0x4CF8, 0x2A105,
    0x2A20E, 0x2A291, 0x9EBB, 0x4D56, 0x9EF9, 0x9EFE, 0x9F05, 0x9F0F, 0x9F16, 0x9F3B, 0x2A600
};

constexpr short CANONICAL_DECOMPOSED_SALT[] {
    0xCAE, 0x00E, 0x000, 0x000, 0x45A, 0x23F, 0x000, 0x1E8, 0x028, 0x280, 0x000, 0x006, 0x14C, 0x201, 0x006, 0x020,
    0x003, 0x000, 0x071, 0x18B, 0x00D, 0x14D, 0x0D3, 0x000, 0x002, 0x085, 0x045, 0x00A, 0x004, 0x0E9, 0x021, 0x000,
    0x000, 0x0AA, 0x002, 0x105, 0x000, 0x1B5, 0x00D, 0x000, 0x000, 0x000, 0x001, 0x000, 0x006, 0x067, 0x008, 0x000,
    0x002, 0x000, 0x000, 0x047, 0x032, 0x000, 0x000, 0x03C, 0x045, 0x000, 0x000, 0x001, 0x000, 0x002, 0x010, 0x001,
    0x000, 0x000, 0x001, 0x000, 0x0CE, 0x02C, 0x000, 0x01D, 0x000, 0x012, 0x000, 0x000, 0x011, 0x003, 0x01C, 0x007,
    0x000, 0x001, 0x06A, 0x001, 0x016, 0x000, 0x06F, 0x000, 0x001, 0x025, 0x000, 0x027, 0x010, 0x000, 0x022, 0x000,
    0x0BC, 0x000, 0x009, 0x000, 0x000, 0x015, 0x000, 0x000, 0x013, 0x000, 0x087, 0x000, 0x03A, 0x027, 0x000, 0x005,
    0x016, 0x005, 0x014, 0x012, 0x021, 0x005, 0x002, 0x001, 0x000, 0x015, 0x026, 0x000, 0x004, 0x000, 0x000, 0x001,
    0x017, 0x019, 0x000, 0x004, 0x000, 0x003, 0x000, 0x010, 0x001, 0x001, 0x000, 0x005, 0x001, 0x000, 0x000, 0x022,
    0x000, 0x002, 0x004, 0x013, 0x000, 0x011, 0x05A, 0x005, 0x013, 0x00D, 0x04E, 0x008, 0x004, 0x018, 0x009, 0x064,
    0x026, 0x000, 0x011, 0x000, 0x005, 0x030, 0x000, 0x001, 0x001, 0x000, 0x002, 0x001, 0x03E, 0x046, 0x005, 0x000,
    0x001, 0x000, 0x001, 0x037, 0x000, 0x000, 0x005, 0x003, 0x000, 0x013, 0x002, 0x000, 0x001, 0x000, 0x006, 0x000,
    0x00B, 0x01C, 0x001, 0x000, 0x005, 0x02F, 0x001, 0x000, 0x008, 0x01D, 0x030, 0x000, 0x025, 0x002, 0x012, 0x000,
    0x000, 0x023, 0x002, 0x000, 0x000, 0x00B, 0x018, 0x00E, 0x000, 0x011, 0x00C, 0x015, 0x002, 0x000, 0x000, 0x003,
    0x000, 0x008, 0x008, 0x008, 0x000, 0x000, 0x009, 0x00E, 0x000, 0x001, 0x009, 0x02C, 0x003, 0x001, 0x016, 0x011,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x004, 0x018, 0x001, 0x030, 0x004, 0x00C, 0x00E, 0x009, 0x000, 0x003,
    0x00B, 0x000, 0x002, 0x005, 0x000, 0x010, 0x003, 0x002, 0x006, 0x00B, 0x008, 0x00A, 0x000, 0x008, 0x003, 0x001,
    0x025, 0x003, 0x01B, 0x002, 0x012, 0x005, 0x007, 0x012, 0x000, 0x010, 0x000, 0x011, 0x000, 0x009, 0x000, 0x009,
    0x000, 0x00C, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x008, 0x000, 0x000, 0x000, 0x003, 0x000, 0x000, 0x000,
    0x017, 0x000, 0x000, 0x003, 0x00C, 0x000, 0x000, 0x002, 0x001, 0x043, 0x000, 0x000, 0x00B, 0x005, 0x009, 0x000,
    0x000, 0x022, 0x002, 0x004, 0x002, 0x002, 0x001, 0x001, 0x014, 0x001, 0x031, 0x000, 0x004, 0x020, 0x009, 0x007,
    0x001, 0x021, 0x016, 0x001, 0x002, 0x000, 0x006, 0x000, 0x00E, 0x000, 0x005, 0x012, 0x00E, 0x004, 0x000, 0x000,
    0x01D, 0x000, 0x000, 0x006, 0x000, 0x00A, 0x000, 0x000, 0x000, 0x016, 0x000, 0x000, 0x000, 0x000, 0x008, 0x000,
    0x001, 0x000, 0x00B, 0x000, 0x001, 0x000, 0x000, 0x000, 0x004, 0x000, 0x000, 0x016, 0x000, 0x001, 0x000, 0x001,
    0x01D, 0x007, 0x000, 0x001, 0x006, 0x004, 0x001, 0x003, 0x00E, 0x009, 0x010, 0x008, 0x002, 0x001, 0x000, 0x000,
    0x003, 0x002, 0x002, 0x022, 0x000, 0x000, 0x004, 0x013, 0x011, 0x000, 0x002, 0x00D, 0x000, 0x001, 0x004, 0x00C,
    0x001, 0x016, 0x00E, 0x002, 0x000, 0x000, 0x004, 0x000, 0x000, 0x000, 0x000, 0x000, 0x015, 0x000, 0x000, 0x003,
    0x000, 0x000, 0x000, 0x00C, 0x000, 0x005, 0x004, 0x000, 0x000, 0x011, 0x00D, 0x011, 0x000, 0x004, 0x000, 0x003,
    0x002, 0x001, 0x003, 0x001, 0x002, 0x002, 0x002, 0x001, 0x001, 0x003, 0x001, 0x001, 0x000, 0x002, 0x002, 0x002,
    0x001, 0x00D, 0x000, 0x000, 0x000, 0x001, 0x002, 0x006, 0x00D, 0x001, 0x001, 0x004, 0x00C, 0x002, 0x006, 0x000,
    0x004, 0x027, 0x01C, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x00A, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x00F, 0x007, 0x008, 0x000, 0x003, 0x000, 0x004, 0x000, 0x000, 0x001, 0x000, 0x00F, 0x001, 0x000,
    0x000, 0x000, 0x002, 0x003, 0x000, 0x016, 0x00B, 0x005, 0x000, 0x000, 0x002, 0x008, 0x004, 0x000, 0x008, 0x000,
    0x000, 0x000, 0x003, 0x004, 0x000, 0x001, 0x00B, 0x001, 0x000, 0x000, 0x018, 0x009, 0x004, 0x007, 0x000, 0x001,
    0x002, 0x001, 0x000, 0x000, 0x001, 0x01E, 0x000, 0x002, 0x001, 0x000, 0x000, 0x009, 0x000, 0x000, 0x003, 0x00A,
    0x002, 0x003, 0x001, 0x000, 0x004, 0x000, 0x004, 0x01F, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x024,
    0x007, 0x005, 0x002, 0x002, 0x00A, 0x001, 0x000, 0x000, 0x003, 0x000, 0x001, 0x00C, 0x000, 0x001, 0x000, 0x000,
    0x001, 0x002, 0x001, 0x00B, 0x000, 0x000, 0x001, 0x003, 0x006, 0x002, 0x00C, 0x00E, 0x01E, 0x000, 0x000, 0x010,
    0x000, 0x001, 0x002, 0x00D, 0x003, 0x000, 0x006, 0x000, 0x002, 0x00A, 0x004, 0x000, 0x00F, 0x010, 0x002, 0x001,
    0x002, 0x006, 0x000, 0x000, 0x00B, 0x000, 0x005, 0x00D, 0x002, 0x000, 0x003, 0x007, 0x000, 0x005, 0x004, 0x000,
    0x000, 0x006, 0x001, 0x000, 0x000, 0x00F, 0x003, 0x000, 0x000, 0x00C, 0x000, 0x017, 0x002, 0x009, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x002, 0x000, 0x007, 0x001, 0x003, 0x00D, 0x000, 0x005, 0x007, 0x004, 0x008, 0x000, 0x00B,
    0x008, 0x009, 0x001, 0x000, 0x000, 0x009, 0x005, 0x000, 0x008, 0x001, 0x000, 0x006, 0x000, 0x008, 0x000, 0x007,
    0x000, 0x002, 0x002, 0x005, 0x004, 0x005, 0x000, 0x000, 0x001, 0x013, 0x008, 0x000, 0x000, 0x001, 0x000, 0x00A,
    0x000, 0x006, 0x000, 0x000, 0x000, 0x000, 0x00C, 0x002, 0x004, 0x002, 0x000, 0x000, 0x003, 0x000, 0x004, 0x000,
    0x003, 0x002, 0x007, 0x001, 0x000, 0x000, 0x000, 0x003, 0x000, 0x000, 0x000, 0x003, 0x000, 0x000, 0x000, 0x004,
    0x000, 0x001, 0x000, 0x002, 0x000, 0x000, 0x002, 0x007, 0x000, 0x004, 0x000, 0x001, 0x001, 0x001, 0x009, 0x002,
    0x002, 0x006, 0x003, 0x000, 0x000, 0x000, 0x001, 0x006, 0x005, 0x002, 0x000, 0x000, 0x004, 0x001, 0x002, 0x011,
    0x001, 0x000, 0x000, 0x001, 0x001, 0x005, 0x000, 0x001, 0x000, 0x007, 0x000, 0x000, 0x000, 0x000, 0x003, 0x00E,
    0x000, 0x000, 0x003, 0x000, 0x000, 0x000, 0x002, 0x001, 0x000, 0x010, 0x000, 0x000, 0x000, 0x002, 0x000, 0x002,
    0x002, 0x006, 0x000, 0x009, 0x000, 0x006, 0x000, 0x001, 0x006, 0x005, 0x001, 0x001, 0x002, 0x008, 0x002, 0x003,
    0x001, 0x004, 0x001, 0x000, 0x000, 0x00D, 0x002, 0x000, 0x000, 0x001, 0x02F, 0x001, 0x002, 0x001, 0x006, 0x015,
    0x000, 0x000, 0x000, 0x00C, 0x004, 0x000, 0x000, 0x000, 0x000, 0x01A, 0x000, 0x000, 0x000, 0x000, 0x003, 0x007,
    0x000, 0x009, 0x002, 0x001, 0x000, 0x001, 0x001, 0x000, 0x000, 0x000, 0x003, 0x000, 0x002, 0x000, 0x00A, 0x000,
    0x000, 0x001, 0x000, 0x00E, 0x002, 0x002, 0x009, 0x002, 0x00B, 0x002, 0x001, 0x003, 0x001, 0x000, 0x000, 0x00A,
    0x003, 0x001, 0x001, 0x002, 0x002, 0x002, 0x000, 0x002, 0x009, 0x000, 0x000, 0x001, 0x006, 0x001, 0x000, 0x007,
    0x018, 0x001, 0x000, 0x007, 0x001, 0x001, 0x000, 0x019, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x003, 0x000, 0x000, 0x000, 0x000, 0x000, 0x004, 0x002, 0x000, 0x000, 0x001, 0x000, 0x00B, 0x001, 0x005, 0x000,
    0x000, 0x000, 0x003, 0x002, 0x006, 0x002, 0x001, 0x005, 0x001, 0x006, 0x003, 0x001, 0x002, 0x001, 0x001, 0x01C,
    0x006, 0x002, 0x002, 0x003, 0x001, 0x008, 0x000, 0x002, 0x000, 0x001, 0x003, 0x001, 0x016, 0x006, 0x00B, 0x000,
    0x004, 0x004, 0x001, 0x002, 0x000, 0x000, 0x000, 0x000, 0x004, 0x000, 0x004, 0x000, 0x000, 0x000, 0x016, 0x000,
    0x000, 0x000, 0x000, 0x003, 0x000, 0x000, 0x000, 0x001, 0x000, 0x004, 0x009, 0x00F, 0x005, 0x000, 0x001, 0x001,
    0x008, 0x000, 0x001, 0x000, 0x000, 0x001, 0x002, 0x001, 0x001, 0x001, 0x000, 0x001, 0x000, 0x008, 0x001, 0x002,
    0x001, 0x003, 0x002, 0x000, 0x002, 0x004, 0x001, 0x001, 0x004, 0x000, 0x00F, 0x000, 0x000, 0x000, 0x002, 0x009,
    0x001, 0x000, 0x002, 0x000, 0x002, 0x004, 0x001, 0x000, 0x007, 0x005, 0x003, 0x002, 0x00A, 0x002, 0x003, 0x000,
    0x005, 0x000, 0x000, 0x000, 0x006, 0x002, 0x00A, 0x000, 0x001, 0x006, 0x005, 0x000, 0x002, 0x003, 0x001, 0x008,
    0x002, 0x000, 0x001, 0x000, 0x014, 0x000, 0x001, 0x002, 0x005, 0x000, 0x001, 0x001, 0x000, 0x001, 0x000, 0x002,
    0x009, 0x000, 0x003, 0x001, 0x000, 0x00D, 0x001, 0x000, 0x000, 0x001, 0x004, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x002, 0x00E, 0x000, 0x002, 0x017, 0x005, 0x000, 0x000, 0x001, 0x002, 0x008, 0x000, 0x001, 0x009, 0x003, 0x000,
    0x001, 0x007, 0x000, 0x004, 0x001, 0x008, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x002, 0x002, 0x005,
    0x000, 0x005, 0x004, 0x001, 0x000, 0x003, 0x000, 0x002, 0x002, 0x003, 0x001, 0x00F, 0x001, 0x003, 0x002, 0x000,
    0x000, 0x000, 0x001, 0x005, 0x000, 0x002, 0x007, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x008, 0x006,
    0x000, 0x000, 0x001, 0x000, 0x000, 0x00A, 0x004, 0x005, 0x000, 0x000, 0x000, 0x001, 0x000, 0x002, 0x000, 0x000,
    0x000, 0x004, 0x000, 0x009, 0x001, 0x001, 0x000, 0x006, 0x000, 0x000, 0x010, 0x001, 0x002, 0x005, 0x001, 0x001,
    0x000, 0x000, 0x004, 0x000, 0x002, 0x002, 0x002, 0x000, 0x000, 0x001, 0x001, 0x003, 0x001, 0x003, 0x000, 0x003,
    0x000, 0x000, 0x000, 0x000, 0x001, 0x006, 0x004, 0x001, 0x001, 0x002, 0x008, 0x003, 0x003, 0x000, 0x000, 0x004,
    0x002, 0x001, 0x00E, 0x020, 0x000, 0x001, 0x001, 0x00C, 0x000, 0x000, 0x000, 0x004, 0x000, 0x002, 0x000, 0x000,
    0x000, 0x004, 0x00A, 0x002, 0x001, 0x004, 0x006, 0x000, 0x000, 0x000, 0x006, 0x006, 0x000, 0x003, 0x000, 0x004,
    0x001, 0x007, 0x001, 0x006, 0x008, 0x001, 0x007, 0x001, 0x001, 0x000, 0x001, 0x002, 0x003, 0x000, 0x006, 0x000,
    0x000, 0x001, 0x008, 0x000, 0x003, 0x001, 0x001, 0x006, 0x002, 0x000, 0x002, 0x004, 0x006, 0x001, 0x004, 0x003,
    0x006, 0x001, 0x003, 0x002, 0x004, 0x002, 0x000, 0x006, 0x002, 0x000, 0x005, 0x001, 0x001, 0x002, 0x000, 0x001,
    0x002, 0x001, 0x001, 0x002, 0x002, 0x007, 0x003, 0x003, 0x000, 0x001, 0x007, 0x001, 0x00E, 0x000, 0x001, 0x000,
    0x00B, 0x000, 0x001, 0x002, 0x001, 0x001, 0x003, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x005, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x002, 0x000, 0x000, 0x003, 0x006, 0x003, 0x002, 0x006,
    0x000, 0x001, 0x003, 0x001, 0x002, 0x001, 0x002, 0x003, 0x000, 0x003, 0x001, 0x002, 0x004, 0x003, 0x000, 0x000,
    0x010, 0x001, 0x002, 0x000, 0x001, 0x000, 0x003, 0x001, 0x002, 0x001, 0x001, 0x001, 0x000, 0x001, 0x000, 0x001,
    0x000, 0x000, 0x000, 0x002, 0x000, 0x000, 0x005, 0x005, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x005,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x002, 0x004, 0x002, 0x001, 0x001, 0x000, 0x002,
    0x000, 0x000, 0x001, 0x000, 0x007, 0x00B, 0x003, 0x001, 0x002, 0x001, 0x002, 0x001, 0x007, 0x001, 0x004, 0x001,
    0x001, 0x000, 0x001, 0x000, 0x001, 0x003, 0x001, 0x002, 0x002, 0x005, 0x001, 0x001, 0x009, 0x001, 0x001, 0x001,
    0x000, 0x002, 0x003, 0x001, 0x000, 0x000, 0x008, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x003,
    0x000, 0x000, 0x000, 0x005, 0x000, 0x004, 0x000, 0x000, 0x000, 0x001, 0x003, 0x001, 0x000, 0x001, 0x001, 0x003,
    0x001, 0x000, 0x000, 0x000, 0x003, 0x004, 0x009, 0x006, 0x000, 0x009, 0x006, 0x002, 0x001, 0x003, 0x001, 0x001,
    0x002, 0x004, 0x002, 0x003, 0x002, 0x000, 0x006, 0x001, 0x000, 0x002, 0x000, 0x000, 0x005, 0x00A, 0x001, 0x000,
    0x000, 0x004, 0x000, 0x000, 0x004, 0x000, 0x001, 0x002, 0x001, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x00D, 0x000, 0x000, 0x003, 0x003, 0x000, 0x001, 0x002,
    0x001, 0x000, 0x003, 0x000, 0x001, 0x000, 0x000, 0x000, 0x003, 0x000, 0x001, 0x002, 0x001, 0x000, 0x004, 0x002,
    0x000, 0x001, 0x003, 0x000, 0x002, 0x003, 0x005, 0x005, 0x000, 0x000, 0x005, 0x001, 0x001, 0x010, 0x001, 0x003,
    0x002, 0x000, 0x001, 0x001, 0x003, 0x001, 0x006, 0x005, 0x001, 0x002, 0x001, 0x002, 0x000, 0x003, 0x000, 0x001,
    0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x003, 0x007, 0x001, 0x002, 0x003, 0x000, 0x006, 0x002, 0x001, 0x000,
    0x000, 0x001, 0x000, 0x002, 0x001, 0x000, 0x003, 0x001, 0x001, 0x003, 0x000, 0x002, 0x001, 0x001, 0x002, 0x001,
    0x000, 0x000, 0x001, 0x000, 0x003, 0x000, 0x000, 0x002, 0x003, 0x000, 0x002, 0x000, 0x002, 0x001, 0x000, 0x003,
    0x000, 0x001, 0x000, 0x000, 0x005, 0x002, 0x002, 0x002, 0x000, 0x002, 0x007, 0x005, 0x003, 0x001, 0x000, 0x00A,
    0x001, 0x001, 0x004, 0x000, 0x006, 0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x001, 0x001, 0x002, 0x000, 0x003,
    0x001, 0x001, 0x001, 0x003, 0x003, 0x001, 0x004, 0x001, 0x000, 0x001, 0x001, 0x001, 0x003, 0x001, 0x005, 0x000,
    0x002, 0x000, 0x001, 0x001, 0x000, 0x004, 0x000, 0x002, 0x001, 0x000, 0x000, 0x000, 0x004, 0x002, 0x000, 0x000,
    0x000, 0x000, 0x004, 0x002, 0x003, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x00A, 0x001, 0x002, 0x002, 0x001,
    0x003, 0x000, 0x006, 0x001, 0x003, 0x006, 0x000, 0x002, 0x000, 0x000, 0x001, 0x000, 0x004, 0x005, 0x004, 0x001,
    0x002, 0x000, 0x003, 0x000, 0x001, 0x002, 0x004, 0x001, 0x000, 0x003, 0x000, 0x000, 0x000, 0x000, 0x001, 0x001,
    0x001, 0x001, 0x001, 0x003, 0x000, 0x001, 0x001, 0x000, 0x003, 0x000, 0x001, 0x004, 0x00A, 0x000, 0x003, 0x004,
    0x005, 0x005, 0x007, 0x003, 0x003, 0x002, 0x000, 0x001, 0x002, 0x002, 0x004, 0x000, 0x001, 0x000, 0x000, 0x000,
    0x002, 0x000, 0x000, 0x009, 0x003, 0x010, 0x001, 0x000, 0x002, 0x000, 0x001, 0x004, 0x000, 0x005, 0x002, 0x000,
    0x005, 0x000, 0x001, 0x001, 0x004, 0x000, 0x007, 0x006, 0x004, 0x000, 0x000, 0x001, 0x007, 0x000, 0x002, 0x003,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x000, 0x000, 0x003, 0x000, 0x001, 0x005, 0x002, 0x006,
    0x001, 0x002, 0x005, 0x006, 0x002, 0x004, 0x000, 0x003, 0x001, 0x002, 0x001, 0x001, 0x000, 0x000, 0x002, 0x001,
    0x003, 0x006, 0x001, 0x001, 0x001, 0x003, 0x007, 0x000, 0x000, 0x000, 0x002, 0x004, 0x000, 0x001, 0x001, 0x003,
    0x001, 0x001, 0x002, 0x000, 0x001, 0x000, 0x005, 0x002, 0x005, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x000, 0x005, 0x000, 0x007, 0x000, 0x000, 0x000, 0x000, 0x004, 0x000, 0x002, 0x004,
    0x000, 0x000, 0x000, 0x001, 0x000, 0x000, 0x002, 0x000, 0x000, 0x001, 0x000, 0x001, 0x001, 0x001, 0x004, 0x002,
    0x00B, 0x001, 0x000, 0x000, 0x001, 0x004, 0x002, 0x000, 0x001, 0x004, 0x001, 0x002, 0x002, 0x001, 0x002, 0x002,
    0x000, 0x000, 0x000, 0x005, 0x002, 0x002, 0x000, 0x000, 0x004, 0x004, 0x005, 0x002, 0x000, 0x000, 0x00D, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x006, 0x000, 0x003, 0x000, 0x000, 0x000, 0x001, 0x002, 0x001, 0x001,
    0x002, 0x009, 0x003, 0x000, 0x000, 0x003, 0x000, 0x001, 0x001, 0x001, 0x002, 0x000, 0x002, 0x003, 0x001, 0x004,
    0x000, 0x002, 0x007, 0x001, 0x000, 0x002, 0x001, 0x001, 0x001, 0x002, 0x000, 0x005, 0x003, 0x000, 0x000, 0x001,
    0x000, 0x005, 0x000, 0x001, 0x000, 0x007, 0x000, 0x000, 0x002, 0x001, 0x001, 0x000, 0x000, 0x000, 0x000, 0x000,
    0x000, 0x000, 0x000, 0x000, 0x002, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x004, 0x004, 0x000, 0x000, 0x001,
    0x002, 0x006, 0x000, 0x000, 0x002, 0x001, 0x002, 0x000, 0x001, 0x000, 0x002, 0x002, 0x002, 0x006, 0x001, 0x001,
    0x007, 0x000, 0x001, 0x002, 0x005, 0x001, 0x002, 0x001, 0x001, 0x001, 0x003, 0x002, 0x002, 0x001, 0x004, 0x000,
    0x000, 0x000, 0x004, 0x001, 0x001, 0x000, 0x002, 0x000, 0x001, 0x003, 0x000, 0x001, 0x002
};

/**
 Key: codepoint
 Value: first: index into CANONICAL_DECOMPOSED_CHARS,
        second: length
 */
constexpr std::pair<unsigned, std::pair<short, short>> CANONICAL_DECOMPOSED_KV[] {
    {0x4EE, {0x29A, 0x2}}, {0x2F869, {0xB99, 0x1}}, {0x30B2, {0x8A9, 0x2}}, {0x1F2E, {0x60A, 0x3}},
    {0x120, {0x0A6, 0x2}}, {0xF905, {0x8E6, 0x1}}, {0xF9E8, {0x9C9, 0x1}}, {0x1E3A, {0x3D2, 0x2}},
    {0xF965, {0x946, 0x1}}, {0x1EBD, {0x4F6, 0x2}}, {0x2F83A, {0xB6A, 0x1}}, {0x101, {0x06C, 0x2}},
    {0xF986, {0x967, 0x1}}, {0xFA57, {0xA2C, 0x1}}, {0x1F91, {0x704, 0x3}}, {0x4DF, {0x284, 0x2}},
    {0x1E2, {0x17E, 0x2}}, {0x229, {0x1F2, 0x2}}, {0x1AF, {0x146, 0x2}}, {0xFA66, {0xA3B, 0x1}}, {0x1F39, {0x628, 0x2}},
    {0x1E7A, {0x464, 0x3}}, {0x1F6C, {0x69D, 0x3}}, {0xFAA8, {0xA7B, 0x1}}, {0x2F8CE, {0xBFE, 0x1}},
    {0x128, {0x0B2, 0x2}}, {0xFA4B, {0xA20, 0x1}}, {0x2F818, {0xB48, 0x1}}, {0x2F988, {0xCB8, 0x1}},
    {0xF974, {0x955, 0x1}}, {0x1EA9, {0x4BF, 0x3}}, {0x1F51, {0x65E, 0x2}}, {0x2F833, {0xB63, 0x1}},
    {0x2F8FC, {0xC2C, 0x1}}, {0x38F, {0x224, 0x2}}, {0xFA3E, {0xA13, 0x1}}, {0xFA5E, {0xA33, 0x1}},
    {0xFA1E, {0x9FA, 0x1}}, {0x2F9F7, {0xD27, 0x1}}, {0x15F, {0x106, 0x2}}, {0x1E35, {0x3C6, 0x2}},
    {0xFB47, {0xAE3, 0x2}}, {0x2F962, {0xC92, 0x1}}, {0xFA86, {0xA59, 0x1}}, {0xF92F, {0x910, 0x1}},
    {0x2F8DD, {0xC0D, 0x1}}, {0xF73, {0x324, 0x2}}, {0x1E15, {0x37F, 0x3}}, {0x1ED0, {0x526, 0x3}},
    {0xF9CA, {0x9AB, 0x1}}, {0x4E6, {0x28E, 0x2}}, {0x1FA2, {0x743, 0x4}}, {0x2F999, {0xCC9, 0x1}},
    {0x1FC2, {0x797, 0x3}}, {0x2F8C7, {0xBF7, 0x1}}, {0xFABC, {0xA8F, 0x1}}, {0x30B4, {0x8AB, 0x2}},
    {0x2F9B9, {0xCE9, 0x1}}, {0x1E73, {0x454, 0x2}}, {0xF95B, {0x93C, 0x1}}, {0x2F952, {0xC82, 0x1}},
    {0xFA5F, {0xA34, 0x1}}, {0x1B08, {0x33E, 0x2}}, {0x2204, {0x81D, 0x2}}, {0x1EA2, {0x4AC, 0x2}},
    {0x1EA, {0x18A, 0x2}}, {0x129, {0x0B4, 0x2}}, {0xF920, {0x901, 0x1}}, {0x1F85, {0x6D7, 0x4}},
    {0x1E93, {0x498, 0x2}}, {0x2F9B2, {0xCE2, 0x1}}, {0x2F821, {0xB51, 0x1}}, {0x2F9D6, {0xD06, 0x1}},
    {0xFA65, {0xA3A, 0x1}}, {0xF971, {0x952, 0x1}}, {0x230, {0x204, 0x3}}, {0x16D, {0x11E, 0x2}}, {0x21B, {0x1E6, 0x2}},
    {0x2F9D4, {0xD04, 0x1}}, {0x1D161, {0xB14, 0x3}}, {0xFA94, {0xA67, 0x1}}, {0x403, {0x24A, 0x2}},
    {0x16A, {0x118, 0x2}}, {0x958, {0x2C4, 0x2}}, {0x2F922, {0xC52, 0x1}}, {0xF93D, {0x91E, 0x1}},
    {0x1E39, {0x3CF, 0x3}}, {0x2F870, {0xBA0, 0x1}}, {0x1EAE, {0x4CE, 0x3}}, {0x1F35, {0x61D, 0x3}},
    {0xFA2F, {0xA04, 0x1}}, {0x15E, {0x104, 0x2}}, {0x1E43, {0x3E4, 0x2}}, {0x2F842, {0xB72, 0x1}},
    {0xF9B1, {0x992, 0x1}}, {0xFA5D, {0xA32, 0x1}}, {0xF9D2, {0x9B3, 0x1}}, {0x1ED8, {0x53E, 0x3}},
    {0xFACA, {0xA9D, 0x1}}, {0x1EDC, {0x54A, 0x3}}, {0x2F9FD, {0xD2D, 0x1}}, {0x2F90B, {0xC3B, 0x1}},
    {0x1EC9, {0x518, 0x2}}, {0x2329, {0x869, 0x1}}, {0x1E96, {0x49E, 0x2}}, {0x2F9A0, {0xCD0, 0x1}},
    {0xF9D0, {0x9B1, 0x1}}, {0x4ED, {0x298, 0x2}}, {0xC2, {0x004, 0x2}}, {0x1E79, {0x461, 0x3}}, {0x4F1, {0x2A0, 0x2}},
    {0x1FD0, {0x7B4, 0x2}}, {0x1EF5, {0x58E, 0x2}}, {0x125, {0x0B0, 0x2}}, {0xFB2C, {0xAB5, 0x3}},
    {0x387, {0x219, 0x1}}, {0xF9EF, {0x9D0, 0x1}}, {0x2F9F5, {0xD25, 0x1}}, {0x170, {0x124, 0x2}},
    {0x2270, {0x839, 0x2}}, {0x2F9CC, {0xCFC, 0x1}}, {0xFA6D, {0xA42, 0x1}}, {0xF980, {0x961, 0x1}},
    {0xF907, {0x8E8, 0x1}}, {0x2F857, {0xB87, 0x1}}, {0x1EB9, {0x4EE, 0x2}}, {0x2F8D5, {0xC05, 0x1}},
    {0xF9F9, {0x9DA, 0x1}}, {0x2F8A2, {0xBD2, 0x1}}, {0xF94B, {0x92C, 0x1}}, {0x2F87E, {0xBAE, 0x1}},
    {0xF91F, {0x900, 0x1}}, {0xF9EC, {0x9CD, 0x1}}, {0x4F4, {0x2A6, 0x2}}, {0x451, {0x25A, 0x2}},
    {0x22AD, {0x853, 0x2}}, {0x2F917, {0xC47, 0x1}}, {0x2F861, {0xB91, 0x1}}, {0xF91D, {0x8FE, 0x1}},
    {0xFA96, {0xA69, 0x1}}, {0xF6, {0x05C, 0x2}}, {0x1E27, {0x3A8, 0x2}}, {0x1F48, {0x64C, 0x2}},
    {0x1FEB, {0x7EA, 0x2}}, {0x1EE5, {0x564, 0x2}}, {0x2F99F, {0xCCF, 0x1}}, {0x2F8E8, {0xC18, 0x1}},
    {0xF9DF, {0x9C0, 0x1}}, {0x1EAF, {0x4D1, 0x3}}, {0xF92A, {0x90B, 0x1}}, {0xFA78, {0xA4B, 0x1}},
    {0xFA6C, {0xA41, 0x1}}, {0x1E22, {0x39E, 0x2}}, {0x1EEA, {0x570, 0x3}}, {0x2F850, {0xB80, 0x1}},
    {0x2F9C9, {0xCF9, 0x1}}, {0xF91C, {0x8FD, 0x1}}, {0xA33, {0x2DE, 0x2}}, {0xE7, {0x040, 0x2}},
    {0x2F80B, {0xB3B, 0x1}}, {0xFA91, {0xA64, 0x1}}, {0x9DD, {0x2DA, 0x2}}, {0x2F848, {0xB78, 0x1}},
    {0xF966, {0x947, 0x1}}, {0xFB36, {0xACB, 0x2}}, {0xF957, {0x938, 0x1}}, {0x2F88A, {0xBBA, 0x1}},
    {0x305C, {0x87D, 0x2}}, {0x2F982, {0xCB2, 0x1}}, {0x122, {0x0AA, 0x2}}, {0xF95D, {0x93E, 0x1}},
    {0x2F8CC, {0xBFC, 0x1}}, {0x2F86A, {0xB9A, 0x1}}, {0x1F81, {0x6C8, 0x3}}, {0x212A, {0x80E, 0x1}},
    {0x17E, {0x140, 0x2}}, {0xF9A9, {0x98A, 0x1}}, {0xFABD, {0xA90, 0x1}}, {0x2F91E, {0xC4E, 0x1}},
    {0xF9EB, {0x9CC, 0x1}}, {0x2F937, {0xC67, 0x1}}, {0x2F8A6, {0xBD6, 0x1}}, {0x1E42, {0x3E2, 0x2}},
    {0x1112F, {0xAFB, 0x2}}, {0x1FA8, {0x75B, 0x3}}, {0xC0, {0x000, 0x2}}, {0x2F8DA, {0xC0A, 0x1}},
    {0x2F9B5, {0xCE5, 0x1}}, {0x2F8C1, {0xBF1, 0x1}}, {0xF9B4, {0x995, 0x1}}, {0x171, {0x126, 0x2}},
    {0xF952, {0x933, 0x1}}, {0xFA08, {0x9E9, 0x1}}, {0x1FAC, {0x769, 0x4}}, {0x1FB, {0x1A5, 0x3}},
    {0xF912, {0x8F3, 0x1}}, {0x1F11, {0x5C6, 0x2}}, {0x201, {0x1B2, 0x2}}, {0x2F8B9, {0xBE9, 0x1}},
    {0x2FA1C, {0xD4C, 0x1}}, {0x2F8B5, {0xBE5, 0x1}}, {0x1E88, {0x482, 0x2}}, {0xFAB8, {0xA8B, 0x1}},
    {0xFA43, {0xA18, 0x1}}, {0x144, {0x0DA, 0x2}}, {0x1E8B, {0x488, 0x2}}, {0x2F9E1, {0xD11, 0x1}},
    {0xF97C, {0x95D, 0x1}}, {0xF985, {0x966, 0x1}}, {0x1F06, {0x5A8, 0x3}}, {0x1FB2, {0x77D, 0x3}},
    {0x2F9DB, {0xD0B, 0x1}}, {0x1FE4, {0x7DB, 0x2}}, {0xFAC3, {0xA96, 0x1}}, {0x177, {0x132, 0x2}},
    {0x2F948, {0xC78, 0x1}}, {0xCB, {0x014, 0x2}}, {0x1F9F, {0x739, 0x4}}, {0xFA99, {0xA6C, 0x1}},
    {0x2F942, {0xC72, 0x1}}, {0x2F976, {0xCA6, 0x1}}, {0xF988, {0x969, 0x1}}, {0x1FE6, {0x7DF, 0x2}},
    {0x156, {0x0F4, 0x2}}, {0x1E8E, {0x48E, 0x2}}, {0x2F8FE, {0xC2E, 0x1}}, {0x1E46, {0x3EA, 0x2}},
    {0x2F81E, {0xB4E, 0x1}}, {0x45D, {0x262, 0x2}}, {0x1FCF, {0x7B2, 0x2}}, {0x1ECF, {0x524, 0x2}},
    {0x1E48, {0x3EE, 0x2}}, {0xF9CB, {0x9AC, 0x1}}, {0x2F946, {0xC76, 0x1}}, {0xFACF, {0xAA2, 0x1}},
    {0x109, {0x07C, 0x2}}, {0x22E3, {0x85F, 0x2}}, {0xF52, {0x31C, 0x2}}, {0x304C, {0x86D, 0x2}},
    {0xF9B2, {0x993, 0x1}}, {0x12C, {0x0BA, 0x2}}, {0x2F969, {0xC99, 0x1}}, {0x2F9A5, {0xCD5, 0x1}},
    {0x307A, {0x899, 0x2}}, {0x2F9BE, {0xCEE, 0x1}}, {0x1F1B, {0x5DB, 0x3}}, {0x1F5D, {0x677, 0x3}},
    {0x2F9AB, {0xCDB, 0x1}}, {0x2F8F1, {0xC21, 0x1}}, {0xF9BE, {0x99F, 0x1}}, {0xF9B8, {0x999, 0x1}},
    {0x1FB4, {0x782, 0x3}}, {0x1EDF, {0x553, 0x3}}, {0x22F, {0x202, 0x2}}, {0x934, {0x2C2, 0x2}},
    {0x2F98A, {0xCBA, 0x1}}, {0x1FE8, {0x7E4, 0x2}}, {0xFAAB, {0xA7E, 0x1}}, {0xFA5B, {0xA30, 0x1}},
    {0x4D3, {0x274, 0x2}}, {0x2226, {0x825, 0x2}}, {0x2FA03, {0xD33, 0x1}}, {0xFA12, {0x9F0, 0x1}},
    {0x1EE4, {0x562, 0x2}}, {0x1FD6, {0x7BE, 0x2}}, {0xF931, {0x912, 0x1}}, {0xFAA1, {0xA74, 0x1}},
    {0x2F936, {0xC66, 0x1}}, {0x1FE9, {0x7E6, 0x2}}, {0x1FF4, {0x7F8, 0x3}}, {0x2F86C, {0xB9C, 0x1}},
    {0x2F911, {0xC41, 0x1}}, {0x95F, {0x2D2, 0x2}}, {0xCD, {0x018, 0x2}}, {0x2F95E, {0xC8E, 0x1}},
    {0xF98F, {0x970, 0x1}}, {0x1E08, {0x362, 0x3}}, {0x30FA, {0x8DD, 0x2}}, {0x4DA, {0x27A, 0x2}},
    {0xF9C5, {0x9A6, 0x1}}, {0x1D8, {0x163, 0x3}}, {0x1EC, {0x18E, 0x3}}, {0xF95E, {0x93F, 0x1}},
    {0xFB4E, {0xAF1, 0x2}}, {0xC5, {0x00A, 0x2}}, {0x2F87D, {0xBAD, 0x1}}, {0x1B0C, {0x342, 0x2}},
    {0x2F9C6, {0xCF6, 0x1}}, {0x2F879, {0xBA9, 0x1}}, {0x2F9F2, {0xD22, 0x1}}, {0x1ECE, {0x522, 0x2}},
    {0xDDA, {0x30F, 0x2}}, {0x1F80, {0x6C5, 0x3}}, {0x3074, {0x891, 0x2}}, {0x2289, {0x84F, 0x2}},
    {0x1D0, {0x150, 0x2}}, {0x1EAC, {0x4C8, 0x3}}, {0x2F851, {0xB81, 0x1}}, {0x22C, {0x1FA, 0x3}},
    {0x1F9E, {0x735, 0x4}}, {0x2F9D2, {0xD02, 0x1}}, {0xFA05, {0x9E6, 0x1}}, {0x2F88C, {0xBBC, 0x1}},
    {0x1FFD, {0x80A, 0x1}}, {0x1F0B, {0x5B5, 0x3}}, {0xFABA, {0xA8D, 0x1}}, {0x1E82, {0x476, 0x2}},
    {0x2F8C2, {0xBF2, 0x1}}, {0x1F30, {0x610, 0x2}}, {0x1F87, {0x6DF, 0x4}}, {0xFA61, {0xA36, 0x1}},
    {0x1B06, {0x33C, 0x2}}, {0x2F9E8, {0xD18, 0x1}}, {0x2F80E, {0xB3E, 0x1}}, {0x1F00, {0x598, 0x2}},
    {0xFA03, {0x9E4, 0x1}}, {0x202, {0x1B4, 0x2}}, {0x1CE, {0x14C, 0x2}}, {0x2FA12, {0xD42, 0x1}},
    {0x2F84F, {0xB7F, 0x1}}, {0x4C1, {0x26A, 0x2}}, {0xFA81, {0xA54, 0x1}}, {0xFAC7, {0xA9A, 0x1}},
    {0xF9BB, {0x99C, 0x1}}, {0x16F, {0x122, 0x2}}, {0x114, {0x08E, 0x2}}, {0xCC7, {0x300, 0x2}}, {0x1B0E, {0x344, 0x2}},
    {0x2F9D1, {0xD01, 0x1}}, {0x139, {0x0CC, 0x2}}, {0x2F836, {0xB66, 0x1}}, {0xB48, {0x2EA, 0x2}},
    {0x30F9, {0x8DB, 0x2}}, {0xFA79, {0xA4C, 0x1}}, {0x3058, {0x879, 0x2}}, {0x2F971, {0xCA1, 0x1}},
    {0x2F928, {0xC58, 0x1}}, {0x1FC, {0x1A8, 0x2}}, {0x2224, {0x823, 0x2}}, {0xFAB3, {0xA86, 0x1}},
    {0x2F8E7, {0xC17, 0x1}}, {0x1FDE, {0x7CD, 0x2}}, {0x1E7, {0x184, 0x2}}, {0x1E13, {0x37A, 0x2}},
    {0xFA5A, {0xA2F, 0x1}}, {0x1FCE, {0x7B0, 0x2}}, {0x1E58, {0x416, 0x2}}, {0x2F964, {0xC94, 0x1}},
    {0xFABE, {0xA91, 0x1}}, {0x1E0F, {0x372, 0x2}}, {0x2F938, {0xC68, 0x1}}, {0x11D, {0x0A0, 0x2}},
    {0xF994, {0x975, 0x1}}, {0xF947, {0x928, 0x1}}, {0x3AA, {0x229, 0x2}}, {0xF981, {0x962, 0x1}},
    {0x1E30, {0x3BC, 0x2}}, {0x1F14, {0x5CE, 0x3}}, {0xF9F1, {0x9D2, 0x1}}, {0x1FA9, {0x75E, 0x3}},
    {0x1E62, {0x42C, 0x2}}, {0x2F85D, {0xB8D, 0x1}}, {0xFA4E, {0xA23, 0x1}}, {0x1F22, {0x5E8, 0x3}},
    {0x2F838, {0xB68, 0x1}}, {0x2F9A6, {0xCD6, 0x1}}, {0xF93F, {0x920, 0x1}}, {0x2F9F3, {0xD23, 0x1}},
    {0xFAAD, {0xA80, 0x1}}, {0x2F87A, {0xBAA, 0x1}}, {0x2F830, {0xB60, 0x1}}, {0x2F8C8, {0xBF8, 0x1}},
    {0x10A, {0x07E, 0x2}}, {0x20B, {0x1C6, 0x2}}, {0x1F77, {0x6B7, 0x2}}, {0xFAB4, {0xA87, 0x1}},
    {0x2F985, {0xCB5, 0x1}}, {0xF9F7, {0x9D8, 0x1}}, {0x2F94F, {0xC7F, 0x1}}, {0xFA40, {0xA15, 0x1}},
    {0x2F968, {0xC98, 0x1}}, {0xFA8C, {0xA5F, 0x1}}, {0xCE, {0x01A, 0x2}}, {0xFAC0, {0xA93, 0x1}},
    {0x3062, {0x883, 0x2}}, {0xF9, {0x05E, 0x2}}, {0x1FB0, {0x779, 0x2}}, {0xB94, {0x2F4, 0x2}},
    {0x2F926, {0xC56, 0x1}}, {0x1F84, {0x6D3, 0x4}}, {0x4EF, {0x29C, 0x2}}, {0xF9D, {0x330, 0x2}},
    {0x226D, {0x833, 0x2}}, {0x1F28, {0x5FA, 0x2}}, {0x2F955, {0xC85, 0x1}}, {0x2279, {0x843, 0x2}},
    {0xFAB6, {0xA89, 0x1}}, {0xF935, {0x916, 0x1}}, {0x439, {0x256, 0x2}}, {0x11938, {0xB0B, 0x2}},
    {0xEE, {0x04E, 0x2}}, {0x17B, {0x13A, 0x2}}, {0x1E0C, {0x36C, 0x2}}, {0x1E6A, {0x442, 0x2}}, {0x214, {0x1D8, 0x2}},
    {0xF57, {0x31E, 0x2}}, {0x2F825, {0xB55, 0x1}}, {0x114BB, {0xB01, 0x2}}, {0x100, {0x06A, 0x2}},
    {0x1E6, {0x182, 0x2}}, {0x2F951, {0xC81, 0x1}}, {0x2F9CE, {0xCFE, 0x1}}, {0x2F984, {0xCB4, 0x1}},
    {0x22EB, {0x863, 0x2}}, {0x1F6B, {0x69A, 0x3}}, {0x13B, {0x0D0, 0x2}}, {0x2F9E9, {0xD19, 0x1}},
    {0x2F8BE, {0xBEE, 0x1}}, {0x2F823, {0xB53, 0x1}}, {0x2F9D3, {0xD03, 0x1}}, {0x2F97C, {0xCAC, 0x1}},
    {0xFA49, {0xA1E, 0x1}}, {0x1EB1, {0x4D7, 0x3}}, {0x2F998, {0xCC8, 0x1}}, {0x304E, {0x86F, 0x2}},
    {0x1F0D, {0x5BB, 0x3}}, {0xD4A, {0x309, 0x2}}, {0xFB39, {0xACF, 0x2}}, {0x305A, {0x87B, 0x2}},
    {0xF9B0, {0x991, 0x1}}, {0x2F8FF, {0xC2F, 0x1}}, {0x30AE, {0x8A5, 0x2}}, {0x2F977, {0xCA7, 0x1}},
    {0x1FA, {0x1A2, 0x3}}, {0x1E20, {0x39A, 0x2}}, {0xF917, {0x8F8, 0x1}}, {0xF989, {0x96A, 0x1}},
    {0xF90E, {0x8EF, 0x1}}, {0xFB34, {0xAC7, 0x2}}, {0x2F889, {0xBB9, 0x1}}, {0x2F866, {0xB96, 0x1}},
    {0x2F865, {0xB95, 0x1}}, {0x12F, {0x0C0, 0x2}}, {0x2FA0E, {0xD3E, 0x1}}, {0x1E61, {0x42A, 0x2}},
    {0x1FD, {0x1AA, 0x2}}, {0x2F803, {0xB33, 0x1}}, {0x1FE3, {0x7D8, 0x3}}, {0xFA44, {0xA19, 0x1}},
    {0x1FA6, {0x753, 0x4}}, {0x20F, {0x1CE, 0x2}}, {0x1FA4, {0x74B, 0x4}}, {0xCCB, {0x306, 0x3}},
    {0xFA4F, {0xA24, 0x1}}, {0x2F997, {0xCC7, 0x1}}, {0x1E4B, {0x3F4, 0x2}}, {0xFAA2, {0xA75, 0x1}},
    {0x2F839, {0xB69, 0x1}}, {0x1F55, {0x669, 0x3}}, {0x1E32, {0x3C0, 0x2}}, {0xF9F0, {0x9D1, 0x1}},
    {0xEA, {0x046, 0x2}}, {0x2F8D4, {0xC04, 0x1}}, {0xF969, {0x94A, 0x1}}, {0xFA, {0x060, 0x2}}, {0x1E33, {0x3C2, 0x2}},
    {0x1E6F, {0x44C, 0x2}}, {0xF9AA, {0x98B, 0x1}}, {0xF938, {0x919, 0x1}}, {0x2F826, {0xB56, 0x1}},
    {0xF93C, {0x91D, 0x1}}, {0x4E2, {0x286, 0x2}}, {0x1E5F, {0x426, 0x2}}, {0x4C2, {0x26C, 0x2}}, {0x4DD, {0x280, 0x2}},
    {0x390, {0x226, 0x3}}, {0x2F923, {0xC53, 0x1}}, {0x419, {0x254, 0x2}}, {0x2F8E9, {0xC19, 0x1}},
    {0x1B3B, {0x348, 0x2}}, {0x2F860, {0xB90, 0x1}}, {0x1EC0, {0x4FE, 0x3}}, {0x124, {0x0AE, 0x2}},
    {0x2F935, {0xC65, 0x1}}, {0x21CD, {0x817, 0x2}}, {0x2F81F, {0xB4F, 0x1}}, {0x1F95, {0x713, 0x4}},
    {0xFA59, {0xA2E, 0x1}}, {0xFB4A, {0xAE9, 0x2}}, {0x137, {0x0CA, 0x2}}, {0x2FA19, {0xD49, 0x1}},
    {0x1E8C, {0x48A, 0x2}}, {0x2FA11, {0xD41, 0x1}}, {0xF992, {0x973, 0x1}}, {0xF99B, {0x97C, 0x1}},
    {0x226F, {0x837, 0x2}}, {0x2F908, {0xC38, 0x1}}, {0x1EA1, {0x4AA, 0x2}}, {0x30C7, {0x8BD, 0x2}},
    {0xF5C, {0x320, 0x2}}, {0x114BC, {0xB03, 0x2}}, {0xF91A, {0x8FB, 0x1}}, {0xFB49, {0xAE7, 0x2}},
    {0x2F892, {0xBC2, 0x1}}, {0x1D1BB, {0xB20, 0x2}}, {0x40E, {0x252, 0x2}}, {0x1E7E, {0x46E, 0x2}},
    {0x1FD3, {0x7BB, 0x3}}, {0x1FB6, {0x785, 0x2}}, {0x164, {0x110, 0x2}}, {0x2F92B, {0xC5B, 0x1}},
    {0x1F3D, {0x633, 0x3}}, {0x386, {0x217, 0x2}}, {0x1F24, {0x5EE, 0x3}}, {0xFACD, {0xAA0, 0x1}},
    {0xFA17, {0x9F3, 0x1}}, {0x1E17, {0x385, 0x3}}, {0xFA0B, {0x9EC, 0x1}}, {0x2F980, {0xCB0, 0x1}},
    {0xFA2D, {0xA02, 0x1}}, {0x2F88E, {0xBBE, 0x1}}, {0xFB2E, {0xABB, 0x2}}, {0xFA31, {0xA06, 0x1}},
    {0x1F09, {0x5B0, 0x2}}, {0x2F815, {0xB45, 0x1}}, {0x2F9CA, {0xCFA, 0x1}}, {0xFA55, {0xA2A, 0x1}},
    {0x2F9F9, {0xD29, 0x1}}, {0x1F62, {0x681, 0x3}}, {0x106, {0x076, 0x2}}, {0x1EBF, {0x4FB, 0x3}},
    {0x1F38, {0x626, 0x2}}, {0x1F20, {0x5E4, 0x2}}, {0x2F965, {0xC95, 0x1}}, {0x2F829, {0xB59, 0x1}},
    {0x1FFB, {0x806, 0x2}}, {0xC9, {0x010, 0x2}}, {0x147, {0x0E0, 0x2}}, {0x2F9C3, {0xCF3, 0x1}}, {0x213, {0x1D6, 0x2}},
    {0x1F9D, {0x731, 0x4}}, {0x1F25, {0x5F1, 0x3}}, {0x2F9AF, {0xCDF, 0x1}}, {0xFA77, {0xA4A, 0x1}},
    {0x2209, {0x81F, 0x2}}, {0xF76, {0x328, 0x2}}, {0xF956, {0x937, 0x1}}, {0x1FCC, {0x7AC, 0x2}},
    {0x1FA0, {0x73D, 0x3}}, {0x13C, {0x0D2, 0x2}}, {0x1EB3, {0x4DD, 0x3}}, {0x1E5A, {0x41A, 0x2}},
    {0xFB35, {0xAC9, 0x2}}, {0xF9B5, {0x996, 0x1}}, {0xFA0A, {0x9EB, 0x1}}, {0x1FA5, {0x74F, 0x4}},
    {0x22E, {0x200, 0x2}}, {0x1EEE, {0x57C, 0x3}}, {0x1D5, {0x15A, 0x3}}, {0x15C, {0x100, 0x2}}, {0xE3, {0x03A, 0x2}},
    {0xFA8B, {0xA5E, 0x1}}, {0x3079, {0x897, 0x2}}, {0xFB38, {0xACD, 0x2}}, {0x2F855, {0xB85, 0x1}},
    {0xFA9E, {0xA71, 0x1}}, {0x14E, {0x0E8, 0x2}}, {0x1E75, {0x458, 0x2}}, {0xFA46, {0xA1B, 0x1}},
    {0x2FA0A, {0xD3A, 0x1}}, {0x211, {0x1D2, 0x2}}, {0x2F8A9, {0xBD9, 0x1}}, {0x115, {0x090, 0x2}},
    {0x30D1, {0x8C3, 0x2}}, {0x1E47, {0x3EC, 0x2}}, {0x2F8E0, {0xC10, 0x1}}, {0xFA7E, {0xA51, 0x1}},
    {0x1FD8, {0x7C3, 0x2}}, {0x1E92, {0x496, 0x2}}, {0x2F867, {0xB97, 0x1}}, {0xFB1D, {0xAAD, 0x2}},
    {0xF97D, {0x95E, 0x1}}, {0xFAB9, {0xA8C, 0x1}}, {0x2F846, {0xB76, 0x1}}, {0x1E7D, {0x46C, 0x2}},
    {0xFAC8, {0xA9B, 0x1}}, {0x104, {0x072, 0x2}}, {0x4F5, {0x2A8, 0x2}}, {0x2FA10, {0xD40, 0x1}},
    {0xF975, {0x956, 0x1}}, {0xF96A, {0x94B, 0x1}}, {0xFA2B, {0xA00, 0x1}}, {0x1F73, {0x6AF, 0x2}},
    {0x2F957, {0xC87, 0x1}}, {0x1EDD, {0x54D, 0x3}}, {0x3AD, {0x22F, 0x2}}, {0x2F924, {0xC54, 0x1}},
    {0xFAD4, {0xAA7, 0x1}}, {0x2F97B, {0xCAB, 0x1}}, {0x2F853, {0xB83, 0x1}}, {0xFA3F, {0xA14, 0x1}},
    {0xFA8A, {0xA5D, 0x1}}, {0xFB4C, {0xAED, 0x2}}, {0x1F3B, {0x62D, 0x3}}, {0xC4, {0x008, 0x2}},
    {0x1109A, {0xAF3, 0x2}}, {0x341, {0x20F, 0x1}}, {0x1E0D, {0x36E, 0x2}}, {0x4DC, {0x27E, 0x2}},
    {0xFA10, {0x9EF, 0x1}}, {0x1EF1, {0x585, 0x3}}, {0x2F903, {0xC33, 0x1}}, {0x1FED, {0x7EE, 0x2}},
    {0x1FEF, {0x7F2, 0x1}}, {0x1EA4, {0x4B0, 0x3}}, {0x21F, {0x1EA, 0x2}}, {0xFA92, {0xA65, 0x1}},
    {0x2F8A4, {0xBD4, 0x1}}, {0xF9C8, {0x9A9, 0x1}}, {0xF9A0, {0x981, 0x1}}, {0x1E31, {0x3BE, 0x2}},
    {0xF903, {0x8E4, 0x1}}, {0x3D4, {0x244, 0x2}}, {0x2F809, {0xB39, 0x1}}, {0x1E07, {0x360, 0x2}},
    {0x1FB1, {0x77B, 0x2}}, {0x2F8D1, {0xC01, 0x1}}, {0x1E11, {0x376, 0x2}}, {0x1FD2, {0x7B8, 0x3}},
    {0x1D15E, {0xB0D, 0x2}}, {0x2F941, {0xC71, 0x1}}, {0xF962, {0x943, 0x1}}, {0x1EF0, {0x582, 0x3}},
    {0x1EE0, {0x556, 0x3}}, {0x3052, {0x873, 0x2}}, {0x148, {0x0E2, 0x2}}, {0x1F44, {0x646, 0x3}},
    {0x2F930, {0xC60, 0x1}}, {0x1E0B, {0x36A, 0x2}}, {0x2F83E, {0xB6E, 0x1}}, {0x3094, {0x89F, 0x2}},
    {0x1E5B, {0x41C, 0x2}}, {0xFA54, {0xA29, 0x1}}, {0xF9FC, {0x9DD, 0x1}}, {0x1DE, {0x172, 0x3}},
    {0x1E02, {0x356, 0x2}}, {0x2F9E4, {0xD14, 0x1}}, {0xF97F, {0x960, 0x1}}, {0x1FE1, {0x7D3, 0x2}},
    {0x1ECB, {0x51C, 0x2}}, {0x2F947, {0xC77, 0x1}}, {0x2F82D, {0xB5D, 0x1}}, {0x1F6D, {0x6A0, 0x3}},
    {0x1E4C, {0x3F6, 0x3}}, {0x1E00, {0x352, 0x2}}, {0x2F93C, {0xC6C, 0x1}}, {0x2F9C4, {0xCF4, 0x1}},
    {0x1F2D, {0x607, 0x3}}, {0x38C, {0x220, 0x2}}, {0x115BB, {0xB09, 0x2}}, {0xFA0C, {0x9ED, 0x1}},
    {0x2F986, {0xCB6, 0x1}}, {0x1F0A, {0x5B2, 0x3}}, {0x1F83, {0x6CF, 0x4}}, {0x1EE3, {0x55F, 0x3}},
    {0x2F93E, {0xC6E, 0x1}}, {0x2F8ED, {0xC1D, 0x1}}, {0x2F981, {0xCB1, 0x1}}, {0x1F54, {0x666, 0x3}},
    {0x1E16, {0x382, 0x3}}, {0xFA6A, {0xA3F, 0x1}}, {0x179, {0x136, 0x2}}, {0xFB2D, {0xAB8, 0x3}},
    {0xF90B, {0x8EC, 0x1}}, {0xFB3E, {0xAD7, 0x2}}, {0x2F9B0, {0xCE0, 0x1}}, {0xF932, {0x913, 0x1}},
    {0x1EE6, {0x566, 0x2}}, {0x2F85E, {0xB8E, 0x1}}, {0x2F8D7, {0xC07, 0x1}}, {0x1E40, {0x3DE, 0x2}},
    {0x22ED, {0x867, 0x2}}, {0x1F43, {0x643, 0x3}}, {0x4E5, {0x28C, 0x2}}, {0xFAA5, {0xA78, 0x1}},
    {0x1FA3, {0x747, 0x4}}, {0x2F967, {0xC97, 0x1}}, {0xF993, {0x974, 0x1}}, {0x2F88D, {0xBBD, 0x1}},
    {0xED, {0x04C, 0x2}}, {0x2F906, {0xC36, 0x1}}, {0xFA98, {0xA6B, 0x1}}, {0x2F901, {0xC31, 0x1}},
    {0x1FF7, {0x7FD, 0x3}}, {0x95C, {0x2CC, 0x2}}, {0xFA60, {0xA35, 0x1}}, {0x3CA, {0x238, 0x2}},
    {0xFA62, {0xA37, 0x1}}, {0x2F8C3, {0xBF3, 0x1}}, {0x1ECA, {0x51A, 0x2}}, {0xF950, {0x931, 0x1}},
    {0x173, {0x12A, 0x2}}, {0x2F99A, {0xCCA, 0x1}}, {0x2F970, {0xCA0, 0x1}}, {0x2F85A, {0xB8A, 0x1}},
    {0x2FA13, {0xD43, 0x1}}, {0xF98B, {0x96C, 0x1}}, {0x2F913, {0xC43, 0x1}}, {0xFB9, {0x338, 0x2}},
    {0xF919, {0x8FA, 0x1}}, {0x1EBA, {0x4F0, 0x2}}, {0x2F890, {0xBC0, 0x1}}, {0xF953, {0x934, 0x1}},
    {0x1EB2, {0x4DA, 0x3}}, {0xF904, {0x8E5, 0x1}}, {0x1DC, {0x16F, 0x3}}, {0x3AB, {0x22B, 0x2}},
    {0xF94E, {0x92F, 0x1}}, {0x2F8DF, {0xC0F, 0x1}}, {0x1F19, {0x5D6, 0x2}}, {0x30BC, {0x8B3, 0x2}},
    {0x305E, {0x87F, 0x2}}, {0x1E87, {0x480, 0x2}}, {0xF9FA, {0x9DB, 0x1}}, {0x2F82B, {0xB5B, 0x1}},
    {0x2F81D, {0xB4D, 0x1}}, {0x2F8A3, {0xBD3, 0x1}}, {0x2FA04, {0xD34, 0x1}}, {0xFA3A, {0xA0F, 0x1}},
    {0x4E4, {0x28A, 0x2}}, {0x2F9D5, {0xD05, 0x1}}, {0x2F90D, {0xC3D, 0x1}}, {0xF967, {0x948, 0x1}},
    {0xFAD3, {0xAA6, 0x1}}, {0x1FF2, {0x7F3, 0x3}}, {0x1E86, {0x47E, 0x2}}, {0xF92D, {0x90E, 0x1}},
    {0x1EF7, {0x592, 0x2}}, {0xFA89, {0xA5C, 0x1}}, {0x2F874, {0xBA4, 0x1}}, {0x2F852, {0xB82, 0x1}},
    {0xF9CD, {0x9AE, 0x1}}, {0x2F854, {0xB84, 0x1}}, {0x1E25, {0x3A4, 0x2}}, {0x1EC1, {0x501, 0x3}},
    {0x1EDB, {0x547, 0x3}}, {0x205, {0x1BA, 0x2}}, {0x2F843, {0xB73, 0x1}}, {0x2F8B1, {0xBE1, 0x1}},
    {0x1FB8, {0x78A, 0x2}}, {0xBCB, {0x2F8, 0x2}}, {0x2F84C, {0xB7C, 0x1}}, {0xFA30, {0xA05, 0x1}},
    {0x9CB, {0x2D4, 0x2}}, {0x2F858, {0xB88, 0x1}}, {0x1F5B, {0x674, 0x3}}, {0x6C2, {0x2BA, 0x2}},
    {0x2F950, {0xC80, 0x1}}, {0xB5C, {0x2F0, 0x2}}, {0xFA4D, {0xA22, 0x1}}, {0x1F93, {0x70B, 0x4}},
    {0xFA74, {0xA47, 0x1}}, {0x1F59, {0x672, 0x2}}, {0x2FA1D, {0xD4D, 0x1}}, {0xFA70, {0xA43, 0x1}},
    {0xFA18, {0x9F4, 0x1}}, {0x2F888, {0xBB8, 0x1}}, {0x2F8B7, {0xBE7, 0x1}}, {0xF99D, {0x97E, 0x1}},
    {0xF9DB, {0x9BC, 0x1}}, {0xF940, {0x921, 0x1}}, {0x1F8D, {0x6F5, 0x4}}, {0x1F97, {0x71B, 0x4}},
    {0x1E10, {0x374, 0x2}}, {0xF997, {0x978, 0x1}}, {0x2F956, {0xC86, 0x1}}, {0x2F9AA, {0xCDA, 0x1}},
    {0x1E41, {0x3E0, 0x2}}, {0x2F90C, {0xC3C, 0x1}}, {0x2F862, {0xB92, 0x1}}, {0x1E66, {0x436, 0x3}},
    {0x1EF8, {0x594, 0x2}}, {0x2F849, {0xB79, 0x1}}, {0x2F894, {0xBC4, 0x1}}, {0x1E7F, {0x470, 0x2}},
    {0x1F29, {0x5FC, 0x2}}, {0xFA1C, {0x9F8, 0x1}}, {0x1EB0, {0x4D4, 0x3}}, {0x1F74, {0x6B1, 0x2}},
    {0x1EE9, {0x56D, 0x3}}, {0x1FBB, {0x790, 0x2}}, {0x162, {0x10C, 0x2}}, {0xD2, {0x020, 0x2}}, {0xFA97, {0xA6A, 0x1}},
    {0x2F824, {0xB54, 0x1}}, {0x233, {0x20C, 0x2}}, {0x22AF, {0x857, 0x2}}, {0x1FEC, {0x7EC, 0x2}},
    {0xFA7F, {0xA52, 0x1}}, {0x2F94A, {0xC7A, 0x1}}, {0x2F887, {0xBB7, 0x1}}, {0x2FA17, {0xD47, 0x1}},
    {0x931, {0x2C0, 0x2}}, {0x130, {0x0C2, 0x2}}, {0x135, {0x0C6, 0x2}}, {0x3076, {0x893, 0x2}}, {0xFA2, {0x332, 0x2}},
    {0x4F8, {0x2AA, 0x2}}, {0x1F27, {0x5F7, 0x3}}, {0xF963, {0x944, 0x1}}, {0xF94D, {0x92E, 0x1}},
    {0x340, {0x20E, 0x1}}, {0x2F9CD, {0xCFD, 0x1}}, {0x1E01, {0x354, 0x2}}, {0x1ED3, {0x52F, 0x3}},
    {0x103, {0x070, 0x2}}, {0x200, {0x1B0, 0x2}}, {0x17C, {0x13C, 0x2}}, {0xF92C, {0x90D, 0x1}}, {0x1E12, {0x378, 0x2}},
    {0xFB33, {0xAC5, 0x2}}, {0xFA93, {0xA66, 0x1}}, {0xF5, {0x05A, 0x2}}, {0x30F8, {0x8D9, 0x2}}, {0x210, {0x1D0, 0x2}},
    {0xF3, {0x056, 0x2}}, {0x2F804, {0xB34, 0x1}}, {0x2F8C0, {0xBF0, 0x1}}, {0x21A, {0x1E4, 0x2}},
    {0x1E1C, {0x390, 0x3}}, {0x11E, {0x0A2, 0x2}}, {0x1F8F, {0x6FD, 0x4}}, {0xFA4C, {0xA21, 0x1}},
    {0x95B, {0x2CA, 0x2}}, {0xFA45, {0xA1A, 0x1}}, {0xFAD5, {0xAA8, 0x1}}, {0x2F82E, {0xB5E, 0x1}},
    {0xFA5C, {0xA31, 0x1}}, {0xF9B7, {0x998, 0x1}}, {0x206, {0x1BC, 0x2}}, {0x1FC7, {0x7A1, 0x3}},
    {0x3CB, {0x23A, 0x2}}, {0xF9DC, {0x9BD, 0x1}}, {0x22B, {0x1F7, 0x3}}, {0xF92E, {0x90F, 0x1}},
    {0x1EE2, {0x55C, 0x3}}, {0x2F88F, {0xBBF, 0x1}}, {0x2F94C, {0xC7C, 0x1}}, {0xFA84, {0xA57, 0x1}},
    {0x2F9E3, {0xD13, 0x1}}, {0xF9D6, {0x9B7, 0x1}}, {0x15D, {0x102, 0x2}}, {0x1E24, {0x3A2, 0x2}},
    {0x2F95C, {0xC8C, 0x1}}, {0x1EA6, {0x4B6, 0x3}}, {0x1EA8, {0x4BC, 0x3}}, {0x30F7, {0x8D7, 0x2}},
    {0xF977, {0x958, 0x1}}, {0xFAC4, {0xA97, 0x1}}, {0xFA3B, {0xA10, 0x1}}, {0x2F904, {0xC34, 0x1}},
    {0xF9AB, {0x98C, 0x1}}, {0x4EB, {0x294, 0x2}}, {0xFA20, {0x9FB, 0x1}}, {0x2F907, {0xC37, 0x1}},
    {0x1EC6, {0x510, 0x3}}, {0x2FA05, {0xD35, 0x1}}, {0x110AB, {0xAF7, 0x2}}, {0x1E3F, {0x3DC, 0x2}},
    {0x2285, {0x84B, 0x2}}, {0x343, {0x210, 0x1}}, {0xF9DA, {0x9BB, 0x1}}, {0x2FA07, {0xD37, 0x1}},
    {0x2FA15, {0xD45, 0x1}}, {0x4F3, {0x2A4, 0x2}}, {0x113, {0x08C, 0x2}}, {0x1F7B, {0x6BF, 0x2}},
    {0x21CF, {0x81B, 0x2}}, {0x1F7A, {0x6BD, 0x2}}, {0xE5, {0x03E, 0x2}}, {0x307D, {0x89D, 0x2}},
    {0x2FA14, {0xD44, 0x1}}, {0x2F891, {0xBC1, 0x1}}, {0x2F9E5, {0xD15, 0x1}}, {0x2F983, {0xCB3, 0x1}},
    {0x1F90, {0x701, 0x3}}, {0x1E85, {0x47C, 0x2}}, {0xD4, {0x024, 0x2}}, {0x22E0, {0x859, 0x2}}, {0x3AE, {0x231, 0x2}},
    {0x2F8AE, {0xBDE, 0x1}}, {0xF9FB, {0x9DC, 0x1}}, {0xF99C, {0x97D, 0x1}}, {0x217, {0x1DE, 0x2}},
    {0x1EB7, {0x4E9, 0x3}}, {0x2F8AA, {0xBDA, 0x1}}, {0x385, {0x215, 0x2}}, {0xFA16, {0x9F2, 0x1}},
    {0x2F9E2, {0xD12, 0x1}}, {0x1E1, {0x17B, 0x3}}, {0x2FA00, {0xD30, 0x1}}, {0x154, {0x0F0, 0x2}},
    {0x1FB7, {0x787, 0x3}}, {0x1EEF, {0x57F, 0x3}}, {0xFA02, {0x9E3, 0x1}}, {0x2F990, {0xCC0, 0x1}},
    {0x1E52, {0x408, 0x3}}, {0x624, {0x2B2, 0x2}}, {0x2F99D, {0xCCD, 0x1}}, {0x2F883, {0xBB3, 0x1}},
    {0x1FD7, {0x7C0, 0x3}}, {0xF9CC, {0x9AD, 0x1}}, {0xF926, {0x907, 0x1}}, {0x1E56, {0x412, 0x2}},
    {0xFA06, {0x9E7, 0x1}}, {0xFA51, {0xA26, 0x1}}, {0x1EF4, {0x58C, 0x2}}, {0x2F9DA, {0xD0A, 0x1}},
    {0x1E36, {0x3C8, 0x2}}, {0x6D3, {0x2BC, 0x2}}, {0x2F9FF, {0xD2F, 0x1}}, {0x2F8E2, {0xC12, 0x1}},
    {0x1EAA, {0x4C2, 0x3}}, {0x2F8AD, {0xBDD, 0x1}}, {0xFA07, {0x9E8, 0x1}}, {0x2F97A, {0xCAA, 0x1}},
    {0x2F966, {0xC96, 0x1}}, {0x1E80, {0x472, 0x2}}, {0x1D2, {0x154, 0x2}}, {0x1F63, {0x684, 0x3}},
    {0x1FAD, {0x76D, 0x4}}, {0xF91E, {0x8FF, 0x1}}, {0xFAA0, {0xA73, 0x1}}, {0x2F863, {0xB93, 0x1}},
    {0x30DD, {0x8D3, 0x2}}, {0x45E, {0x264, 0x2}}, {0x2F91A, {0xC4A, 0x1}}, {0x1E05, {0x35C, 0x2}},
    {0x11A, {0x09A, 0x2}}, {0x1F61, {0x67F, 0x2}}, {0x2FA1B, {0xD4B, 0x1}}, {0x2F9E0, {0xD10, 0x1}},
    {0x13D, {0x0D4, 0x2}}, {0xFB32, {0xAC3, 0x2}}, {0x1EA5, {0x4B3, 0x3}}, {0xDDD, {0x313, 0x3}}, {0x118, {0x096, 0x2}},
    {0x207, {0x1BE, 0x2}}, {0x1FFA, {0x804, 0x2}}, {0x2F93F, {0xC6F, 0x1}}, {0x2F886, {0xBB6, 0x1}},
    {0xF9E0, {0x9C1, 0x1}}, {0xF970, {0x951, 0x1}}, {0x2F97E, {0xCAE, 0x1}}, {0xF972, {0x953, 0x1}},
    {0x136, {0x0C8, 0x2}}, {0x1B0A, {0x340, 0x2}}, {0x3073, {0x88F, 0x2}}, {0xF916, {0x8F7, 0x1}},
    {0x22E2, {0x85D, 0x2}}, {0x2F921, {0xC51, 0x1}}, {0x2260, {0x82F, 0x2}}, {0x1F66, {0x68D, 0x3}},
    {0x2F80F, {0xB3F, 0x1}}, {0x2001, {0x80C, 0x1}}, {0x1F88, {0x6E3, 0x3}}, {0xFAA6, {0xA79, 0x1}},
    {0x1FAE, {0x771, 0x4}}, {0xFAA4, {0xA77, 0x1}}, {0x1F3A, {0x62A, 0x3}}, {0xFAC1, {0xA94, 0x1}},
    {0xFA8F, {0xA62, 0x1}}, {0x95D, {0x2CE, 0x2}}, {0xF9D1, {0x9B2, 0x1}}, {0x1B41, {0x34E, 0x2}},
    {0xF948, {0x929, 0x1}}, {0x1E3C, {0x3D6, 0x2}}, {0xFAD9, {0xAAC, 0x1}}, {0x400, {0x246, 0x2}},
    {0xF96D, {0x94E, 0x1}}, {0x1E7C, {0x46A, 0x2}}, {0x3D3, {0x242, 0x2}}, {0x172, {0x128, 0x2}},
    {0x1E1F, {0x398, 0x2}}, {0xFA9F, {0xA72, 0x1}}, {0x226E, {0x835, 0x2}}, {0x2F822, {0xB52, 0x1}},
    {0xF75, {0x326, 0x2}}, {0x2F871, {0xBA1, 0x1}}, {0x2F812, {0xB42, 0x1}}, {0x2275, {0x83F, 0x2}},
    {0x1F3F, {0x639, 0x3}}, {0x30D7, {0x8CB, 0x2}}, {0xD9, {0x02A, 0x2}}, {0x2F8AB, {0xBDB, 0x1}},
    {0xFA7A, {0xA4D, 0x1}}, {0xF915, {0x8F6, 0x1}}, {0x1E1D, {0x393, 0x3}}, {0x1EB, {0x18C, 0x2}},
    {0x2F808, {0xB38, 0x1}}, {0x2F98E, {0xCBE, 0x1}}, {0xFA53, {0xA28, 0x1}}, {0xF9A6, {0x987, 0x1}},
    {0x2F80C, {0xB3C, 0x1}}, {0x2F8F5, {0xC25, 0x1}}, {0x2FA02, {0xD32, 0x1}}, {0x1E81, {0x474, 0x2}},
    {0xF930, {0x911, 0x1}}, {0x3060, {0x881, 0x2}}, {0x1FEA, {0x7E8, 0x2}}, {0x38A, {0x21E, 0x2}},
    {0x2F85C, {0xB8C, 0x1}}, {0x1FC9, {0x7A6, 0x2}}, {0x2F86F, {0xB9F, 0x1}}, {0x2F90A, {0xC3A, 0x1}},
    {0x2F902, {0xC32, 0x1}}, {0x2F835, {0xB65, 0x1}}, {0x14D, {0x0E6, 0x2}}, {0x1D162, {0xB17, 0x3}},
    {0xF923, {0x904, 0x1}}, {0x2F896, {0xBC6, 0x1}}, {0x22D, {0x1FD, 0x3}}, {0xF9F2, {0x9D3, 0x1}},
    {0x30C2, {0x8B9, 0x2}}, {0x30D4, {0x8C7, 0x2}}, {0xF97E, {0x95F, 0x1}}, {0x1FE2, {0x7D5, 0x3}},
    {0xEC, {0x04A, 0x2}}, {0x1F49, {0x64E, 0x2}}, {0xFA8D, {0xA60, 0x1}}, {0x2F898, {0xBC8, 0x1}},
    {0x1EB5, {0x4E3, 0x3}}, {0x2F994, {0xCC4, 0x1}}, {0x12B, {0x0B8, 0x2}}, {0x20E, {0x1CC, 0x2}},
    {0x168, {0x114, 0x2}}, {0x1F56, {0x66C, 0x3}}, {0x2F8A0, {0xBD0, 0x1}}, {0xFA52, {0xA27, 0x1}},
    {0x2F93D, {0xC6D, 0x1}}, {0xDA, {0x02C, 0x2}}, {0x1EC4, {0x50A, 0x3}}, {0x1E95, {0x49C, 0x2}},
    {0x1F67, {0x690, 0x3}}, {0x2F9C1, {0xCF1, 0x1}}, {0xF9DE, {0x9BF, 0x1}}, {0x2F83D, {0xB6D, 0x1}},
    {0xF9ED, {0x9CE, 0x1}}, {0xFABF, {0xA92, 0x1}}, {0x457, {0x25E, 0x2}}, {0xFA0D, {0x9EE, 0x1}},
    {0xFAB1, {0xA84, 0x1}}, {0x2F8FA, {0xC2A, 0x1}}, {0x1E49, {0x3F0, 0x2}}, {0xF91B, {0x8FC, 0x1}},
    {0x1E50, {0x402, 0x3}}, {0xF94A, {0x92B, 0x1}}, {0xFA90, {0xA63, 0x1}}, {0x2284, {0x849, 0x2}},
    {0x1EA0, {0x4A8, 0x2}}, {0x169, {0x116, 0x2}}, {0xF900, {0x8E1, 0x1}}, {0x1EEB, {0x573, 0x3}},
    {0xF9E5, {0x9C6, 0x1}}, {0x2F9EA, {0xD1A, 0x1}}, {0x2F8AC, {0xBDC, 0x1}}, {0x2F8F8, {0xC28, 0x1}},
    {0xCC8, {0x302, 0x2}}, {0x2F8F6, {0xC26, 0x1}}, {0xF968, {0x949, 0x1}}, {0x1E6C, {0x446, 0x2}},
    {0x2F8D8, {0xC08, 0x1}}, {0x1EB6, {0x4E6, 0x3}}, {0x2F899, {0xBC9, 0x1}}, {0xC3, {0x006, 0x2}},
    {0x1B0, {0x148, 0x2}}, {0x1F13, {0x5CB, 0x3}}, {0x1E63, {0x42E, 0x2}}, {0x112, {0x08A, 0x2}},
    {0x2F920, {0xC50, 0x1}}, {0xFA04, {0x9E5, 0x1}}, {0x2F8D9, {0xC09, 0x1}}, {0x1E38, {0x3CC, 0x3}},
    {0x1F94, {0x70F, 0x4}}, {0x2F940, {0xC70, 0x1}}, {0x2F97D, {0xCAD, 0x1}}, {0x2F84E, {0xB7E, 0x1}},
    {0xF9A5, {0x986, 0x1}}, {0x9DC, {0x2D8, 0x2}}, {0xFC, {0x064, 0x2}}, {0x1EEC, {0x576, 0x3}}, {0x1A0, {0x142, 0x2}},
    {0x2F9B4, {0xCE4, 0x1}}, {0xBCA, {0x2F6, 0x2}}, {0x2F834, {0xB64, 0x1}}, {0x2FA0B, {0xD3B, 0x1}},
    {0xFAD8, {0xAAB, 0x1}}, {0x30C5, {0x8BB, 0x2}}, {0xF9F5, {0x9D6, 0x1}}, {0x2F84B, {0xB7B, 0x1}},
    {0x1E5E, {0x424, 0x2}}, {0x2F8C6, {0xBF6, 0x1}}, {0x2F93B, {0xC6B, 0x1}}, {0x151, {0x0EE, 0x2}},
    {0x1FFC, {0x808, 0x2}}, {0xFA39, {0xA0E, 0x1}}, {0x1E09, {0x365, 0x3}}, {0xF999, {0x97A, 0x1}},
    {0x2F8E6, {0xC16, 0x1}}, {0x2F8BA, {0xBEA, 0x1}}, {0x2F876, {0xBA6, 0x1}}, {0x123, {0x0AC, 0x2}},
    {0xFB3C, {0xAD5, 0x2}}, {0xF996, {0x977, 0x1}}, {0x1E8D, {0x48C, 0x2}}, {0x10C, {0x082, 0x2}},
    {0x2F8EE, {0xC1E, 0x1}}, {0xF909, {0x8EA, 0x1}}, {0xFA4A, {0xA1F, 0x1}}, {0x2F9A9, {0xCD9, 0x1}},
    {0x2F806, {0xB36, 0x1}}, {0x30D0, {0x8C1, 0x2}}, {0x2F9BB, {0xCEB, 0x1}}, {0x2F975, {0xCA5, 0x1}},
    {0x2FA18, {0xD48, 0x1}}, {0x2F989, {0xCB9, 0x1}}, {0xF987, {0x968, 0x1}}, {0x2F80A, {0xB3A, 0x1}},
    {0xF998, {0x979, 0x1}}, {0xF979, {0x95A, 0x1}}, {0xF90D, {0x8EE, 0x1}}, {0xF922, {0x903, 0x1}},
    {0x1F8C, {0x6F1, 0x4}}, {0x1F37, {0x623, 0x3}}, {0xFB48, {0xAE5, 0x2}}, {0x3067, {0x887, 0x2}},
    {0x2F932, {0xC62, 0x1}}, {0x1ED2, {0x52C, 0x3}}, {0xD1, {0x01E, 0x2}}, {0x1E28, {0x3AA, 0x2}},
    {0x178, {0x134, 0x2}}, {0x2F9AC, {0xCDC, 0x1}}, {0x161, {0x10A, 0x2}}, {0xFAD0, {0xAA3, 0x1}},
    {0x401, {0x248, 0x2}}, {0x2241, {0x827, 0x2}}, {0xF9BD, {0x99E, 0x1}}, {0x2F8F0, {0xC20, 0x1}},
    {0x1E45, {0x3E8, 0x2}}, {0xF9D9, {0x9BA, 0x1}}, {0xFAA9, {0xA7C, 0x1}}, {0xFA35, {0xA0A, 0x1}},
    {0x4D2, {0x272, 0x2}}, {0x1E34, {0x3C4, 0x2}}, {0xF927, {0x908, 0x1}}, {0x1EC3, {0x507, 0x3}},
    {0x2F8DE, {0xC0E, 0x1}}, {0x2F9A2, {0xCD2, 0x1}}, {0xF943, {0x924, 0x1}}, {0x1E8F, {0x490, 0x2}},
    {0xF9D5, {0x9B6, 0x1}}, {0xF982, {0x963, 0x1}}, {0x1F50, {0x65C, 0x2}}, {0x1F92, {0x707, 0x4}},
    {0xF81, {0x32C, 0x2}}, {0xFA87, {0xA5A, 0x1}}, {0x2F94E, {0xC7E, 0x1}}, {0x1FAB, {0x765, 0x4}},
    {0xFA3D, {0xA12, 0x1}}, {0x1D9, {0x166, 0x3}}, {0x2F996, {0xCC6, 0x1}}, {0x1E8A, {0x486, 0x2}},
    {0xFA58, {0xA2D, 0x1}}, {0x1FC1, {0x795, 0x2}}, {0x2F961, {0xC91, 0x1}}, {0x344, {0x211, 0x2}},
    {0x1F34, {0x61A, 0x3}}, {0xF9A8, {0x989, 0x1}}, {0x163, {0x10E, 0x2}}, {0xFB4B, {0xAEB, 0x2}},
    {0x9CC, {0x2D6, 0x2}}, {0x1E71, {0x450, 0x2}}, {0xE2, {0x038, 0x2}}, {0xF9F3, {0x9D4, 0x1}},
    {0x2F89E, {0xBCE, 0x1}}, {0x2F8B3, {0xBE3, 0x1}}, {0x1F4D, {0x659, 0x3}}, {0x1EF9, {0x596, 0x2}},
    {0x2F82F, {0xB5F, 0x1}}, {0xFA2E, {0xA03, 0x1}}, {0x2F814, {0xB44, 0x1}}, {0xFAD1, {0xAA4, 0x1}},
    {0x1EC5, {0x50D, 0x3}}, {0x9DF, {0x2DC, 0x2}}, {0x2F8A1, {0xBD1, 0x1}}, {0xF939, {0x91A, 0x1}},
    {0x228, {0x1F0, 0x2}}, {0x2F8D2, {0xC02, 0x1}}, {0x1D1BD, {0xB24, 0x3}}, {0x1F86, {0x6DB, 0x4}},
    {0x2F868, {0xB98, 0x1}}, {0x22A, {0x1F4, 0x3}}, {0x2F8E3, {0xC13, 0x1}}, {0xA5A, {0x2E4, 0x2}},
    {0x1FC8, {0x7A4, 0x2}}, {0xFA22, {0x9FC, 0x1}}, {0x1ED, {0x191, 0x3}}, {0xF99F, {0x980, 0x1}},
    {0x2F9B8, {0xCE8, 0x1}}, {0x2F9E7, {0xD17, 0x1}}, {0xFABB, {0xA8E, 0x1}}, {0x1D6, {0x15D, 0x3}},
    {0xFB31, {0xAC1, 0x2}}, {0x146, {0x0DE, 0x2}}, {0x1EF2, {0x588, 0x2}}, {0x1FA1, {0x740, 0x3}},
    {0x1E18, {0x388, 0x2}}, {0xFA9B, {0xA6E, 0x1}}, {0xFA80, {0xA53, 0x1}}, {0xFACC, {0xA9F, 0x1}},
    {0x17A, {0x138, 0x2}}, {0x1E3B, {0x3D4, 0x2}}, {0x1E74, {0x456, 0x2}}, {0x2F86B, {0xB9B, 0x1}},
    {0x1E23, {0x3A0, 0x2}}, {0x175, {0x12E, 0x2}}, {0x1E3E, {0x3DA, 0x2}}, {0x4DB, {0x27C, 0x2}},
    {0x219B, {0x813, 0x2}}, {0x1E84, {0x47A, 0x2}}, {0xF9CF, {0x9B0, 0x1}}, {0x1E44, {0x3E6, 0x2}},
    {0x1E1A, {0x38C, 0x2}}, {0x1F65, {0x68A, 0x3}}, {0xF929, {0x90A, 0x1}}, {0x2247, {0x82B, 0x2}},
    {0x4F2, {0x2A2, 0x2}}, {0x2F87C, {0xBAC, 0x1}}, {0x1E2F, {0x3B9, 0x3}}, {0x2F84A, {0xB7A, 0x1}},
    {0x2F98C, {0xCBC, 0x1}}, {0x2F9A1, {0xCD1, 0x1}}, {0x1EC8, {0x516, 0x2}}, {0x157, {0x0F6, 0x2}},
    {0x2F8BF, {0xBEF, 0x1}}, {0xFB41, {0xADB, 0x2}}, {0x4F9, {0x2AC, 0x2}}, {0x2F995, {0xCC5, 0x1}},
    {0x12E, {0x0BE, 0x2}}, {0xF9B6, {0x997, 0x1}}, {0x1EBC, {0x4F4, 0x2}}, {0x1E21, {0x39C, 0x2}},
    {0x2F841, {0xB71, 0x1}}, {0x116, {0x092, 0x2}}, {0x453, {0x25C, 0x2}}, {0x2F992, {0xCC2, 0x1}},
    {0x1D164, {0xB1D, 0x3}}, {0x2F8E1, {0xC11, 0x1}}, {0xFA75, {0xA48, 0x1}}, {0xF902, {0x8E3, 0x1}},
    {0xF908, {0x8E9, 0x1}}, {0x2F817, {0xB47, 0x1}}, {0xF95F, {0x940, 0x1}}, {0x2F83B, {0xB6B, 0x1}},
    {0x10F, {0x088, 0x2}}, {0xD3, {0x022, 0x2}}, {0x3069, {0x889, 0x2}}, {0x1E65, {0x433, 0x3}}, {0xFB43, {0xADD, 0x2}},
    {0x30BA, {0x8B1, 0x2}}, {0x1F9B, {0x729, 0x4}}, {0x16C, {0x11C, 0x2}}, {0xC7, {0x00C, 0x2}},
    {0x2F96B, {0xC9B, 0x1}}, {0xF9F8, {0x9D9, 0x1}}, {0x158, {0x0F8, 0x2}}, {0x1D163, {0xB1A, 0x3}},
    {0x1EA7, {0x4B9, 0x3}}, {0x2288, {0x84D, 0x2}}, {0xFACB, {0xA9E, 0x1}}, {0xF901, {0x8E2, 0x1}},
    {0x1F8E, {0x6F9, 0x4}}, {0x2FA09, {0xD39, 0x1}}, {0x2F9C8, {0xCF8, 0x1}}, {0x1E0E, {0x370, 0x2}},
    {0xF949, {0x92A, 0x1}}, {0xE8, {0x042, 0x2}}, {0xFA3C, {0xA11, 0x1}}, {0x2F8EC, {0xC1C, 0x1}},
    {0x2F8DB, {0xC0B, 0x1}}, {0x218, {0x1E0, 0x2}}, {0x3065, {0x885, 0x2}}, {0xFA7C, {0xA4F, 0x1}},
    {0x1F82, {0x6CB, 0x4}}, {0x1E9B, {0x4A6, 0x2}}, {0x209, {0x1C2, 0x2}}, {0x1FD1, {0x7B6, 0x2}},
    {0x2F9FA, {0xD2A, 0x1}}, {0x30F4, {0x8D5, 0x2}}, {0x1F1A, {0x5D8, 0x3}}, {0x1E5C, {0x41E, 0x3}},
    {0xFA6B, {0xA40, 0x1}}, {0x2F9DE, {0xD0E, 0x1}}, {0xF9C6, {0x9A7, 0x1}}, {0x1DA, {0x169, 0x3}},
    {0x1F0E, {0x5BE, 0x3}}, {0xF97B, {0x95C, 0x1}}, {0xF9C3, {0x9A4, 0x1}}, {0x117, {0x094, 0x2}},
    {0xF945, {0x926, 0x1}}, {0x2F9FE, {0xD2E, 0x1}}, {0x1ED6, {0x538, 0x3}}, {0x625, {0x2B4, 0x2}},
    {0x2F9BC, {0xCEC, 0x1}}, {0x2249, {0x82D, 0x2}}, {0x1D4, {0x158, 0x2}}, {0x2F9F0, {0xD20, 0x1}},
    {0x2F931, {0xC61, 0x1}}, {0x2F92A, {0xC5A, 0x1}}, {0x1FDB, {0x7C9, 0x2}}, {0xFA7B, {0xA4E, 0x1}},
    {0x2F882, {0xBB2, 0x1}}, {0x2F8EF, {0xC1F, 0x1}}, {0xF94F, {0x930, 0x1}}, {0xF93, {0x32E, 0x2}},
    {0x2F945, {0xC75, 0x1}}, {0x3056, {0x877, 0x2}}, {0x959, {0x2C6, 0x2}}, {0x22AC, {0x851, 0x2}},
    {0x1FF6, {0x7FB, 0x2}}, {0x2F801, {0xB31, 0x1}}, {0xF921, {0x902, 0x1}}, {0xFA41, {0xA16, 0x1}},
    {0xF9FE, {0x9DF, 0x1}}, {0xFAA3, {0xA76, 0x1}}, {0x2F8B4, {0xBE4, 0x1}}, {0x20C, {0x1C8, 0x2}},
    {0xF9C1, {0x9A2, 0x1}}, {0x2000, {0x80B, 0x1}}, {0x2F905, {0xC35, 0x1}}, {0x40D, {0x250, 0x2}},
    {0x1F79, {0x6BB, 0x2}}, {0x2F95B, {0xC8B, 0x1}}, {0x1E72, {0x452, 0x2}}, {0x2F91B, {0xC4B, 0x1}},
    {0xF9E1, {0x9C2, 0x1}}, {0x2F9CB, {0xCFB, 0x1}}, {0x2F84D, {0xB7D, 0x1}}, {0x2F8A7, {0xBD7, 0x1}},
    {0x1F05, {0x5A5, 0x3}}, {0xFB30, {0xABF, 0x2}}, {0xFA01, {0x9E2, 0x1}}, {0xEF, {0x050, 0x2}},
    {0x1D1C0, {0xB2D, 0x3}}, {0x2F819, {0xB49, 0x1}}, {0xCA, {0x012, 0x2}}, {0x21AE, {0x815, 0x2}},
    {0x1E2E, {0x3B6, 0x3}}, {0x30DA, {0x8CF, 0x2}}, {0x2F880, {0xBB0, 0x1}}, {0x2F832, {0xB62, 0x1}},
    {0x1DB, {0x16C, 0x3}}, {0x4E7, {0x290, 0x2}}, {0x2F85B, {0xB8B, 0x1}}, {0x1F0, {0x198, 0x2}},
    {0x2F9C7, {0xCF7, 0x1}}, {0x1E68, {0x43C, 0x3}}, {0xF90C, {0x8ED, 0x1}}, {0xFB4D, {0xAEF, 0x2}},
    {0x2F8F4, {0xC24, 0x1}}, {0x3B0, {0x235, 0x3}}, {0xF90F, {0x8F0, 0x1}}, {0x2F89F, {0xBCF, 0x1}},
    {0x1F9A, {0x725, 0x4}}, {0xFA88, {0xA5B, 0x1}}, {0x1D1BF, {0xB2A, 0x3}}, {0x3071, {0x88D, 0x2}},
    {0xFA69, {0xA3E, 0x1}}, {0x1026, {0x33A, 0x2}}, {0xFA1A, {0x9F6, 0x1}}, {0x1E03, {0x358, 0x2}},
    {0xF928, {0x909, 0x1}}, {0x2F974, {0xCA4, 0x1}}, {0xB4B, {0x2EC, 0x2}}, {0x1F1D, {0x5E1, 0x3}},
    {0x165, {0x112, 0x2}}, {0xFAD2, {0xAA5, 0x1}}, {0xFAC9, {0xA9C, 0x1}}, {0x2F897, {0xBC7, 0x1}},
    {0x2FA0F, {0xD3F, 0x1}}, {0x2F9AE, {0xCDE, 0x1}}, {0xC8, {0x00E, 0x2}}, {0x2F8BC, {0xBEC, 0x1}},
    {0x2F96A, {0xC9A, 0x1}}, {0x2F9FB, {0xD2B, 0x1}}, {0x2F8CD, {0xBFD, 0x1}}, {0xFB1F, {0xAAF, 0x2}},
    {0x2F94B, {0xC7B, 0x1}}, {0x2F811, {0xB41, 0x1}}, {0x95A, {0x2C8, 0x2}}, {0x30DC, {0x8D1, 0x2}},
    {0xF78, {0x32A, 0x2}}, {0x2F909, {0xC39, 0x1}}, {0x22AE, {0x855, 0x2}}, {0xF9D8, {0x9B9, 0x1}},
    {0xFA8E, {0xA61, 0x1}}, {0x1E2A, {0x3AE, 0x2}}, {0x108, {0x07A, 0x2}}, {0x2F9CF, {0xCFF, 0x1}},
    {0x1E7B, {0x467, 0x3}}, {0x2F8CB, {0xBFB, 0x1}}, {0xFAC2, {0xA95, 0x1}}, {0x1D15F, {0xB0F, 0x2}},
    {0xF924, {0x905, 0x1}}, {0xF96F, {0x950, 0x1}}, {0x1EDE, {0x550, 0x3}}, {0x2F987, {0xCB7, 0x1}},
    {0x1F72, {0x6AD, 0x2}}, {0x1ED4, {0x532, 0x3}}, {0x2F8B2, {0xBE2, 0x1}}, {0xFA42, {0xA17, 0x1}},
    {0x626, {0x2B6, 0x2}}, {0xFA9D, {0xA70, 0x1}}, {0x2F9B3, {0xCE3, 0x1}}, {0x2F919, {0xC49, 0x1}},
    {0xF9D3, {0x9B4, 0x1}}, {0xFA71, {0xA44, 0x1}}, {0x1F2F, {0x60D, 0x3}}, {0x1ED9, {0x541, 0x3}},
    {0xFB2F, {0xABD, 0x2}}, {0x2F8DC, {0xC0C, 0x1}}, {0x1EB4, {0x4E0, 0x3}}, {0xFA25, {0x9FD, 0x1}},
    {0x2F86D, {0xB9D, 0x1}}, {0x4EA, {0x292, 0x2}}, {0x1ECD, {0x520, 0x2}}, {0x1F01, {0x59A, 0x2}},
    {0x2F8D0, {0xC00, 0x1}}, {0x2F93A, {0xC6A, 0x1}}, {0x40C, {0x24E, 0x2}}, {0xF93A, {0x91B, 0x1}},
    {0xF9FF, {0x9E0, 0x1}}, {0x1E26, {0x3A6, 0x2}}, {0x1F08, {0x5AE, 0x2}}, {0x1F03, {0x59F, 0x3}},
    {0xFAD7, {0xAAA, 0x1}}, {0x2F884, {0xBB4, 0x1}}, {0x2F845, {0xB75, 0x1}}, {0x38E, {0x222, 0x2}},
    {0x4D0, {0x26E, 0x2}}, {0x30BE, {0x8B5, 0x2}}, {0x1F32, {0x614, 0x3}}, {0x2FA08, {0xD38, 0x1}},
    {0x17D, {0x13E, 0x2}}, {0x1E3D, {0x3D8, 0x2}}, {0xFA2C, {0xA01, 0x1}}, {0x2F95F, {0xC8F, 0x1}},
    {0x2F99C, {0xCCC, 0x1}}, {0x1F6F, {0x6A6, 0x3}}, {0xF937, {0x918, 0x1}}, {0xFA34, {0xA09, 0x1}},
    {0x1F2A, {0x5FE, 0x3}}, {0xF69, {0x322, 0x2}}, {0xE0, {0x034, 0x2}}, {0x2F978, {0xCA8, 0x1}},
    {0x2F97F, {0xCAF, 0x1}}, {0x1EF, {0x196, 0x2}}, {0x1B43, {0x350, 0x2}}, {0x155, {0x0F2, 0x2}},
    {0x1FC6, {0x79F, 0x2}}, {0x20A, {0x1C4, 0x2}}, {0x3077, {0x895, 0x2}}, {0x1E1B, {0x38E, 0x2}},
    {0x2F885, {0xBB5, 0x1}}, {0x20D, {0x1CA, 0x2}}, {0xF9C4, {0x9A5, 0x1}}, {0xF9A7, {0x988, 0x1}},
    {0xF98E, {0x96F, 0x1}}, {0xF4D, {0x31A, 0x2}}, {0x2F805, {0xB35, 0x1}}, {0x159, {0x0FA, 0x2}}, {0xF4, {0x058, 0x2}},
    {0x1F40, {0x63C, 0x2}}, {0xFA00, {0x9E1, 0x1}}, {0x2F9F6, {0xD26, 0x1}}, {0xFAAE, {0xA81, 0x1}},
    {0xFA15, {0x9F1, 0x1}}, {0x212B, {0x80F, 0x2}}, {0x2FA06, {0xD36, 0x1}}, {0xD5, {0x026, 0x2}},
    {0x1E2D, {0x3B4, 0x2}}, {0x1F0F, {0x5C1, 0x3}}, {0x2271, {0x83B, 0x2}}, {0x1F71, {0x6AB, 0x2}},
    {0xFA47, {0xA1C, 0x1}}, {0xD4B, {0x30B, 0x2}}, {0x2F81C, {0xB4C, 0x1}}, {0x1FB9, {0x78C, 0x2}},
    {0xFA26, {0x9FE, 0x1}}, {0x1FF9, {0x802, 0x2}}, {0x134, {0x0C4, 0x2}}, {0xF991, {0x972, 0x1}},
    {0x1D160, {0xB11, 0x3}}, {0xF9AC, {0x98D, 0x1}}, {0x2F828, {0xB58, 0x1}}, {0x1FD9, {0x7C5, 0x2}},
    {0x2F8EB, {0xC1B, 0x1}}, {0x2F88B, {0xBBB, 0x1}}, {0x2F9B1, {0xCE1, 0x1}}, {0xF9BC, {0x99D, 0x1}},
    {0xFA2A, {0x9FF, 0x1}}, {0x307C, {0x89B, 0x2}}, {0x1F5, {0x19C, 0x2}}, {0x1F78, {0x6B9, 0x2}},
    {0xFA72, {0xA45, 0x1}}, {0x2280, {0x845, 0x2}}, {0x2F918, {0xC48, 0x1}}, {0xE4, {0x03C, 0x2}},
    {0x2F802, {0xB32, 0x1}}, {0x2F8D6, {0xC06, 0x1}}, {0x388, {0x21A, 0x2}}, {0xFAC5, {0xA98, 0x1}},
    {0x10D, {0x084, 0x2}}, {0xF958, {0x939, 0x1}}, {0x1EBE, {0x4F8, 0x3}}, {0xF90A, {0x8EB, 0x1}},
    {0x1F9, {0x1A0, 0x2}}, {0xB4C, {0x2EE, 0x2}}, {0x1F57, {0x66F, 0x3}}, {0x1E06, {0x35E, 0x2}},
    {0x1ED1, {0x529, 0x3}}, {0x1FF3, {0x7F6, 0x2}}, {0x1E2B, {0x3B0, 0x2}}, {0x1EB8, {0x4EC, 0x2}},
    {0x2F875, {0xBA5, 0x1}}, {0xF942, {0x923, 0x1}}, {0x1F6A, {0x697, 0x3}}, {0x1E0, {0x178, 0x3}},
    {0x2F94D, {0xC7D, 0x1}}, {0xC48, {0x2FC, 0x2}}, {0x2F810, {0xB40, 0x1}}, {0x1F36, {0x620, 0x3}},
    {0x2F8F3, {0xC23, 0x1}}, {0xFD, {0x066, 0x2}}, {0xF961, {0x942, 0x1}}, {0x2F873, {0xBA3, 0x1}},
    {0x37E, {0x214, 0x1}}, {0xF911, {0x8F2, 0x1}}, {0xFAC6, {0xA99, 0x1}}, {0x2F89D, {0xBCD, 0x1}},
    {0x2F960, {0xC90, 0x1}}, {0xFA82, {0xA55, 0x1}}, {0x2F96F, {0xC9F, 0x1}}, {0x1F33, {0x617, 0x3}},
    {0x1F5F, {0x67A, 0x3}}, {0x1E67, {0x439, 0x3}}, {0x30D9, {0x8CD, 0x2}}, {0xF99A, {0x97B, 0x1}},
    {0x22EC, {0x865, 0x2}}, {0x204, {0x1B8, 0x2}}, {0xDC, {0x030, 0x2}}, {0x2F925, {0xC55, 0x1}},
    {0xFA68, {0xA3D, 0x1}}, {0x2F840, {0xB70, 0x1}}, {0x3CD, {0x23E, 0x2}}, {0x1E90, {0x492, 0x2}},
    {0x1F75, {0x6B3, 0x2}}, {0xDDC, {0x311, 0x2}}, {0x2F83F, {0xB6F, 0x1}}, {0xF976, {0x957, 0x1}},
    {0x2F86E, {0xB9E, 0x1}}, {0x150, {0x0EC, 0x2}}, {0x1E99, {0x4A4, 0x2}}, {0x1D1, {0x152, 0x2}},
    {0x2F916, {0xC46, 0x1}}, {0x2F929, {0xC59, 0x1}}, {0x1F04, {0x5A2, 0x3}}, {0x1FA7, {0x757, 0x4}},
    {0x1DF, {0x175, 0x3}}, {0xFB44, {0xADF, 0x2}}, {0x11C, {0x09E, 0x2}}, {0x13A, {0x0CE, 0x2}}, {0x1F10, {0x5C4, 0x2}},
    {0x2F8C4, {0xBF4, 0x1}}, {0x1E97, {0x4A0, 0x2}}, {0xF954, {0x935, 0x1}}, {0x2F900, {0xC30, 0x1}},
    {0x30FE, {0x8DF, 0x2}}, {0x30B6, {0x8AD, 0x2}}, {0x1F69, {0x695, 0x2}}, {0xF9AD, {0x98E, 0x1}},
    {0x1E77, {0x45C, 0x2}}, {0xFA37, {0xA0C, 0x1}}, {0xF934, {0x915, 0x1}}, {0xFAB0, {0xA83, 0x1}},
    {0x22EA, {0x861, 0x2}}, {0x2F89C, {0xBCC, 0x1}}, {0x227, {0x1EE, 0x2}}, {0x1F2B, {0x601, 0x3}},
    {0x2F979, {0xCA9, 0x1}}, {0x2F954, {0xC84, 0x1}}, {0x1E1E, {0x396, 0x2}}, {0xF9AE, {0x98F, 0x1}},
    {0x2F8E5, {0xC15, 0x1}}, {0x3AF, {0x233, 0x2}}, {0x1F4C, {0x656, 0x3}}, {0xF941, {0x922, 0x1}},
    {0x2F934, {0xC64, 0x1}}, {0xF9A3, {0x984, 0x1}}, {0x929, {0x2BE, 0x2}}, {0x2F89B, {0xBCB, 0x1}},
    {0x2F8B0, {0xBE0, 0x1}}, {0x1E83, {0x478, 0x2}}, {0x2F9EC, {0xD1C, 0x1}}, {0x1F60, {0x67D, 0x2}},
    {0x623, {0x2B0, 0x2}}, {0x1E6E, {0x44A, 0x2}}, {0x1112E, {0xAF9, 0x2}}, {0xB5D, {0x2F2, 0x2}},
    {0x215, {0x1DA, 0x2}}, {0x2F9BD, {0xCED, 0x1}}, {0x176, {0x130, 0x2}}, {0x1EAB, {0x4C5, 0x3}},
    {0x2F9E6, {0xD16, 0x1}}, {0x2F864, {0xB94, 0x1}}, {0x1F31, {0x612, 0x2}}, {0x2F92F, {0xC5F, 0x1}},
    {0x2F820, {0xB50, 0x1}}, {0x1FDA, {0x7C7, 0x2}}, {0x2F82C, {0xB5C, 0x1}}, {0x1F45, {0x649, 0x3}},
    {0x1F7C, {0x6C1, 0x2}}, {0x1E53, {0x40B, 0x3}}, {0x2F972, {0xCA2, 0x1}}, {0x2FA1A, {0xD4A, 0x1}},
    {0xF960, {0x941, 0x1}}, {0x1D7, {0x160, 0x3}}, {0x1EE8, {0x56A, 0x3}}, {0xCCA, {0x304, 0x2}},
    {0x1F42, {0x640, 0x3}}, {0x2F95D, {0xC8D, 0x1}}, {0x1EE, {0x194, 0x2}}, {0x2F8D3, {0xC03, 0x1}},
    {0x1E4D, {0x3F9, 0x3}}, {0xD6, {0x028, 0x2}}, {0x1F96, {0x717, 0x4}}, {0xF918, {0x8F9, 0x1}},
    {0xF9AF, {0x990, 0x1}}, {0x2F8FB, {0xC2B, 0x1}}, {0x1E60, {0x428, 0x2}}, {0x1B12, {0x346, 0x2}},
    {0xF9FD, {0x9DE, 0x1}}, {0x2F9EB, {0xD1B, 0x1}}, {0x1E64, {0x430, 0x3}}, {0xFB2B, {0xAB3, 0x2}},
    {0x1FE0, {0x7D1, 0x2}}, {0x2F915, {0xC45, 0x1}}, {0x2F81B, {0xB4B, 0x1}}, {0x1FDD, {0x7CB, 0x2}},
    {0x2F8B6, {0xBE6, 0x1}}, {0x1E89, {0x484, 0x2}}, {0xF9B9, {0x99A, 0x1}}, {0x1FB3, {0x780, 0x2}},
    {0x1E3, {0x180, 0x2}}, {0x4E3, {0x288, 0x2}}, {0xCF, {0x01C, 0x2}}, {0xF1, {0x052, 0x2}}, {0x2F9BF, {0xCEF, 0x1}},
    {0x2F8C9, {0xBF9, 0x1}}, {0x2F8A8, {0xBD8, 0x1}}, {0x2F95A, {0xC8A, 0x1}}, {0x2F9A8, {0xCD8, 0x1}},
    {0x1A1, {0x144, 0x2}}, {0xF99E, {0x97F, 0x1}}, {0xFB46, {0xAE1, 0x2}}, {0xF9C7, {0x9A8, 0x1}},
    {0x476, {0x266, 0x2}}, {0x1CD, {0x14A, 0x2}}, {0xF9BF, {0x9A0, 0x1}}, {0x1EAD, {0x4CB, 0x3}}, {0x105, {0x074, 0x2}},
    {0x2F9A4, {0xCD4, 0x1}}, {0x15B, {0x0FE, 0x2}}, {0xF9C9, {0x9AA, 0x1}}, {0x119, {0x098, 0x2}},
    {0xF946, {0x927, 0x1}}, {0x3054, {0x875, 0x2}}, {0x2FA0C, {0xD3C, 0x1}}, {0x1CF, {0x14E, 0x2}},
    {0xFA7D, {0xA50, 0x1}}, {0xF944, {0x925, 0x1}}, {0xFA1D, {0x9F9, 0x1}}, {0x2F9C2, {0xCF2, 0x1}},
    {0xF964, {0x945, 0x1}}, {0x219, {0x1E2, 0x2}}, {0xF9DD, {0x9BE, 0x1}}, {0x1F8B, {0x6ED, 0x4}},
    {0x2262, {0x831, 0x2}}, {0xF9B3, {0x994, 0x1}}, {0xF9A2, {0x983, 0x1}}, {0x3050, {0x871, 0x2}},
    {0x1E8, {0x186, 0x2}}, {0x30D3, {0x8C5, 0x2}}, {0x30C9, {0x8BF, 0x2}}, {0xF95A, {0x93B, 0x1}},
    {0xF98A, {0x96B, 0x1}}, {0xFA76, {0xA49, 0x1}}, {0x2F816, {0xB46, 0x1}}, {0x1B40, {0x34C, 0x2}},
    {0x212, {0x1D4, 0x2}}, {0x1E91, {0x494, 0x2}}, {0xF9E4, {0x9C5, 0x1}}, {0x1F98, {0x71F, 0x3}},
    {0xF910, {0x8F1, 0x1}}, {0x2F9D8, {0xD08, 0x1}}, {0x2F91D, {0xC4D, 0x1}}, {0x1F9C, {0x72D, 0x4}},
    {0xDB, {0x02E, 0x2}}, {0x232, {0x20A, 0x2}}, {0xF995, {0x976, 0x1}}, {0xF9E2, {0x9C3, 0x1}}, {0x1F23, {0x5EB, 0x3}},
    {0xDDE, {0x316, 0x2}}, {0xF9CE, {0x9AF, 0x1}}, {0x1EED, {0x579, 0x3}}, {0x1F0C, {0x5B8, 0x3}},
    {0x2F91C, {0xC4C, 0x1}}, {0x30B0, {0x8A7, 0x2}}, {0xF990, {0x971, 0x1}}, {0x1F68, {0x693, 0x2}},
    {0x1FBC, {0x792, 0x2}}, {0x2F9B7, {0xCE7, 0x1}}, {0xF96B, {0x94C, 0x1}}, {0xFA09, {0x9EA, 0x1}},
    {0x1FF, {0x1AE, 0x2}}, {0x2F910, {0xC40, 0x1}}, {0x2F9F4, {0xD24, 0x1}}, {0x2F87F, {0xBAF, 0x1}},
    {0x1E59, {0x418, 0x2}}, {0x114BE, {0xB05, 0x2}}, {0xF96C, {0x94D, 0x1}}, {0xFAC, {0x336, 0x2}},
    {0xF913, {0x8F4, 0x1}}, {0x2F80D, {0xB3D, 0x1}}, {0x2F927, {0xC57, 0x1}}, {0x2F837, {0xB67, 0x1}},
    {0x30AC, {0x8A3, 0x2}}, {0x1FEE, {0x7F0, 0x2}}, {0xF9A1, {0x982, 0x1}}, {0x1E54, {0x40E, 0x2}},
    {0x1F6E, {0x6A3, 0x3}}, {0xFAB7, {0xA8A, 0x1}}, {0xFB3B, {0xAD3, 0x2}}, {0x2F9F1, {0xD21, 0x1}},
    {0xA36, {0x2E0, 0x2}}, {0x1F89, {0x6E6, 0x3}}, {0x1ECC, {0x51E, 0x2}}, {0x2F958, {0xC88, 0x1}},
    {0x16B, {0x11A, 0x2}}, {0x2F944, {0xC74, 0x1}}, {0x2F8F9, {0xC29, 0x1}}, {0x407, {0x24C, 0x2}},
    {0x1EF6, {0x590, 0x2}}, {0x2F9A3, {0xCD3, 0x1}}, {0x2F881, {0xBB1, 0x1}}, {0x1134C, {0xAFF, 0x2}},
    {0x2F81A, {0xB4A, 0x1}}, {0x2F9DD, {0xD0D, 0x1}}, {0xFA64, {0xA39, 0x1}}, {0x2F8AF, {0xBDF, 0x1}},
    {0x2F9ED, {0xD1D, 0x1}}, {0xF9EA, {0x9CB, 0x1}}, {0x1109C, {0xAF5, 0x2}}, {0x14F, {0x0EA, 0x2}},
    {0xF97A, {0x95B, 0x1}}, {0x2F949, {0xC79, 0x1}}, {0xA5B, {0x2E6, 0x2}}, {0xF936, {0x917, 0x1}},
    {0xA5E, {0x2E8, 0x2}}, {0x2F89A, {0xBCA, 0x1}}, {0x1F4B, {0x653, 0x3}}, {0xF984, {0x965, 0x1}},
    {0x1E6D, {0x448, 0x2}}, {0x2F90E, {0xC3E, 0x1}}, {0x232A, {0x86A, 0x1}}, {0x2FA0D, {0xD3D, 0x1}},
    {0xFAB2, {0xA85, 0x1}}, {0x450, {0x258, 0x2}}, {0x1F02, {0x59C, 0x3}}, {0xFA32, {0xA07, 0x1}},
    {0x1F76, {0x6B5, 0x2}}, {0x2F96D, {0xC9D, 0x1}}, {0x2F9A7, {0xCD7, 0x1}}, {0x1EA3, {0x4AE, 0x2}},
    {0xF9BA, {0x99B, 0x1}}, {0x1F15, {0x5D1, 0x3}}, {0x1FAF, {0x775, 0x4}}, {0x160, {0x108, 0x2}},
    {0x2F963, {0xC93, 0x1}}, {0xF925, {0x906, 0x1}}, {0xF9F6, {0x9D7, 0x1}}, {0x30C0, {0x8B7, 0x2}},
    {0x21E, {0x1E8, 0x2}}, {0xFA9C, {0xA6F, 0x1}}, {0xFB3A, {0xAD1, 0x2}}, {0x1FBA, {0x78E, 0x2}},
    {0x374, {0x213, 0x1}}, {0x2ADC, {0x86B, 0x2}}, {0x2F91F, {0xC4F, 0x1}}, {0xCC0, {0x2FE, 0x2}},
    {0x1EF3, {0x58A, 0x2}}, {0x1FC3, {0x79A, 0x2}}, {0x2F8BD, {0xBED, 0x1}}, {0x11F, {0x0A4, 0x2}},
    {0xFA7, {0x334, 0x2}}, {0xF9F4, {0x9D5, 0x1}}, {0xBCC, {0x2FA, 0x2}}, {0x2F847, {0xB77, 0x1}},
    {0x1F4A, {0x650, 0x3}}, {0x2F98F, {0xCBF, 0x1}}, {0xF96E, {0x94F, 0x1}}, {0xF9E6, {0x9C7, 0x1}},
    {0xF9E3, {0x9C4, 0x1}}, {0x2F844, {0xB74, 0x1}}, {0x2F813, {0xB43, 0x1}}, {0xFAB5, {0xA88, 0x1}},
    {0x1FAA, {0x761, 0x4}}, {0xC1, {0x002, 0x2}}, {0x1E6B, {0x444, 0x2}}, {0x1FE5, {0x7DD, 0x2}},
    {0x2F807, {0xB37, 0x1}}, {0x2F85F, {0xB8F, 0x1}}, {0xF93B, {0x91C, 0x1}}, {0x1F8, {0x19E, 0x2}},
    {0x1E69, {0x43F, 0x3}}, {0x1FE7, {0x7E1, 0x3}}, {0x1E57, {0x414, 0x2}}, {0xCC, {0x016, 0x2}},
    {0x2F99B, {0xCCB, 0x1}}, {0x4F0, {0x29E, 0x2}}, {0x2F8FD, {0xC2D, 0x1}}, {0x121, {0x0A8, 0x2}},
    {0xF2, {0x054, 0x2}}, {0xFA9A, {0xA6D, 0x1}}, {0x2F9EF, {0xD1F, 0x1}}, {0x2F878, {0xBA8, 0x1}},
    {0xF959, {0x93A, 0x1}}, {0x1134B, {0xAFD, 0x2}}, {0x1FBE, {0x794, 0x1}}, {0xFA56, {0xA2B, 0x1}},
    {0x1D1BE, {0xB27, 0x3}}, {0x2F8BB, {0xBEB, 0x1}}, {0x2F8E4, {0xC14, 0x1}}, {0x1E19, {0x38A, 0x2}},
    {0x2F92D, {0xC5D, 0x1}}, {0x1F2C, {0x604, 0x3}}, {0xE1, {0x036, 0x2}}, {0x2F9B6, {0xCE6, 0x1}},
    {0xF98D, {0x96E, 0x1}}, {0xF914, {0x8F5, 0x1}}, {0xFA19, {0x9F5, 0x1}}, {0xFACE, {0xAA1, 0x1}},
    {0x15A, {0x0FC, 0x2}}, {0x2274, {0x83D, 0x2}}, {0xF94C, {0x92D, 0x1}}, {0x1FC4, {0x79C, 0x3}},
    {0x115BA, {0xB07, 0x2}}, {0x2F8B8, {0xBE8, 0x1}}, {0x2FA01, {0xD31, 0x1}}, {0x2F8EA, {0xC1A, 0x1}},
    {0x1E98, {0x4A2, 0x2}}, {0x2F98B, {0xCBB, 0x1}}, {0x2F9DC, {0xD0C, 0x1}}, {0x1F99, {0x722, 0x3}},
    {0x1F8A, {0x6E9, 0x4}}, {0x1F1C, {0x5DE, 0x3}}, {0xFA38, {0xA0D, 0x1}}, {0x2F953, {0xC83, 0x1}},
    {0x2F8F7, {0xC27, 0x1}}, {0x1F41, {0x63E, 0x2}}, {0x1EC7, {0x513, 0x3}}, {0x2FA16, {0xD46, 0x1}},
    {0x2F859, {0xB89, 0x1}}, {0x2F959, {0xC89, 0x1}}, {0x2F8CF, {0xBFF, 0x1}}, {0x14C, {0x0E4, 0x2}},
    {0x2F993, {0xCC3, 0x1}}, {0x13E, {0x0D6, 0x2}}, {0x12A, {0x0B6, 0x2}}, {0x2F991, {0xCC1, 0x1}},
    {0x1FCA, {0x7A8, 0x2}}, {0x389, {0x21C, 0x2}}, {0xFA73, {0xA46, 0x1}}, {0x2F9D9, {0xD09, 0x1}},
    {0x143, {0x0D8, 0x2}}, {0x2F893, {0xBC3, 0x1}}, {0x2F827, {0xB57, 0x1}}, {0xFA63, {0xA38, 0x1}},
    {0x3AC, {0x22D, 0x2}}, {0x1F07, {0x5AB, 0x3}}, {0x1EBB, {0x4F2, 0x2}}, {0x2F943, {0xC73, 0x1}},
    {0xFA67, {0xA3C, 0x1}}, {0x4D6, {0x276, 0x2}}, {0x1F12, {0x5C8, 0x3}}, {0x1F4, {0x19A, 0x2}},
    {0x1E37, {0x3CA, 0x2}}, {0x2F90F, {0xC3F, 0x1}}, {0x1F18, {0x5D4, 0x2}}, {0x477, {0x268, 0x2}},
    {0x102, {0x06E, 0x2}}, {0x2F800, {0xB30, 0x1}}, {0xFAAF, {0xA82, 0x1}}, {0x6C0, {0x2B8, 0x2}}, {0xEB, {0x048, 0x2}},
    {0x1EDA, {0x544, 0x3}}, {0x1F7D, {0x6C3, 0x2}}, {0xA59, {0x2E2, 0x2}}, {0x2F8F2, {0xC22, 0x1}},
    {0x309E, {0x8A1, 0x2}}, {0x30D6, {0x8C9, 0x2}}, {0x2F92E, {0xC5E, 0x1}}, {0xF933, {0x914, 0x1}},
    {0x2F96E, {0xC9E, 0x1}}, {0x1E55, {0x410, 0x2}}, {0x2281, {0x847, 0x2}}, {0x1E4E, {0x3FC, 0x3}},
    {0x2F872, {0xBA2, 0x1}}, {0x2F9FC, {0xD2C, 0x1}}, {0x1D1BC, {0xB22, 0x2}}, {0xFA50, {0xA25, 0x1}},
    {0x2F92C, {0xC5C, 0x1}}, {0x3070, {0x88B, 0x2}}, {0xF9E9, {0x9CA, 0x1}}, {0x2F83C, {0xB6C, 0x1}},
    {0x2F9F8, {0xD28, 0x1}}, {0x1F52, {0x660, 0x3}}, {0xFAAC, {0xA7F, 0x1}}, {0x1E94, {0x49A, 0x2}},
    {0xFAD6, {0xAA9, 0x1}}, {0x1FCB, {0x7AA, 0x2}}, {0xFA33, {0xA08, 0x1}}, {0xFA1B, {0x9F7, 0x1}},
    {0xF9EE, {0x9CF, 0x1}}, {0x1E2C, {0x3B2, 0x2}}, {0x203, {0x1B6, 0x2}}, {0x2F877, {0xBA7, 0x1}},
    {0x1FF8, {0x800, 0x2}}, {0x1E9, {0x188, 0x2}}, {0x1FE, {0x1AC, 0x2}}, {0x2F96C, {0xC9C, 0x1}},
    {0x1E51, {0x405, 0x3}}, {0x4DE, {0x282, 0x2}}, {0xF9A4, {0x985, 0x1}}, {0xFB40, {0xAD9, 0x2}},
    {0x622, {0x2AE, 0x2}}, {0x3CC, {0x23C, 0x2}}, {0x2F99E, {0xCCE, 0x1}}, {0xF92B, {0x90C, 0x1}},
    {0x22E1, {0x85B, 0x2}}, {0x174, {0x12C, 0x2}}, {0x1E4A, {0x3F2, 0x2}}, {0x2F939, {0xC69, 0x1}},
    {0x3CE, {0x240, 0x2}}, {0xFAA7, {0xA7A, 0x1}}, {0xFA85, {0xA58, 0x1}}, {0xF9E7, {0x9C8, 0x1}},
    {0x107, {0x078, 0x2}}, {0xFA95, {0xA68, 0x1}}, {0xF973, {0x954, 0x1}}, {0x2F933, {0xC63, 0x1}},
    {0xF9C2, {0x9A3, 0x1}}, {0x1EE1, {0x559, 0x3}}, {0x1D3, {0x156, 0x2}}, {0x2F9D0, {0xD00, 0x1}},
    {0xFB2A, {0xAB1, 0x2}}, {0xFB, {0x062, 0x2}}, {0x1E4F, {0x3FF, 0x3}}, {0x1F26, {0x5F4, 0x3}}, {0xDD, {0x032, 0x2}},
    {0x226, {0x1EC, 0x2}}, {0x2F831, {0xB61, 0x1}}, {0x2F9EE, {0xD1E, 0x1}}, {0xF955, {0x936, 0x1}},
    {0x16E, {0x120, 0x2}}, {0x2F8A5, {0xBD5, 0x1}}, {0x11B, {0x09C, 0x2}}, {0x1E76, {0x45A, 0x2}},
    {0xD4C, {0x30D, 0x2}}, {0x1F3C, {0x630, 0x3}}, {0x1E0A, {0x368, 0x2}}, {0x1E78, {0x45E, 0x3}},
    {0x2F82A, {0xB5A, 0x1}}, {0x12D, {0x0BC, 0x2}}, {0x2F8C5, {0xBF5, 0x1}}, {0x1F3E, {0x636, 0x3}},
    {0xF95C, {0x93D, 0x1}}, {0x1F21, {0x5E6, 0x2}}, {0x2F9D7, {0xD07, 0x1}}, {0x1F70, {0x6A9, 0x2}},
    {0x2F914, {0xC44, 0x1}}, {0xFA83, {0xA56, 0x1}}, {0x1ED5, {0x535, 0x3}}, {0x1EE7, {0x568, 0x2}},
    {0x2278, {0x841, 0x2}}, {0xF9C0, {0x9A1, 0x1}}, {0x1ED7, {0x53B, 0x3}}, {0x2F8CA, {0xBFA, 0x1}},
    {0x1B3D, {0x34A, 0x2}}, {0x2F9AD, {0xCDD, 0x1}}, {0x95E, {0x2D0, 0x2}}, {0x220C, {0x821, 0x2}},
    {0x1FDF, {0x7CF, 0x2}}, {0xFA48, {0xA1D, 0x1}}, {0x1E04, {0x35A, 0x2}}, {0x4D7, {0x278, 0x2}},
    {0x216, {0x1DC, 0x2}}, {0x1E70, {0x44E, 0x2}}, {0x2F856, {0xB86, 0x1}}, {0xE9, {0x044, 0x2}},
    {0xF951, {0x932, 0x1}}, {0x231, {0x207, 0x3}}, {0x1F53, {0x663, 0x3}}, {0x1E14, {0x37C, 0x3}},
    {0xF983, {0x964, 0x1}}, {0xF9D4, {0x9B5, 0x1}}, {0x2F973, {0xCA3, 0x1}}, {0x2F9DF, {0xD0F, 0x1}},
    {0xF98C, {0x96D, 0x1}}, {0x208, {0x1C0, 0x2}}, {0x2F895, {0xBC5, 0x1}}, {0xFAAA, {0xA7D, 0x1}},
    {0x45C, {0x260, 0x2}}, {0x30B8, {0x8AF, 0x2}}, {0x2244, {0x829, 0x2}}, {0xFF, {0x068, 0x2}}, {0x4D1, {0x270, 0x2}},
    {0x2126, {0x80D, 0x1}}, {0x10B, {0x080, 0x2}}, {0x145, {0x0DC, 0x2}}, {0xF978, {0x959, 0x1}},
    {0x1FCD, {0x7AE, 0x2}}, {0x2F912, {0xC42, 0x1}}, {0xFA36, {0xA0B, 0x1}}, {0x2F9C0, {0xCF0, 0x1}},
    {0x4EC, {0x296, 0x2}}, {0x10E, {0x086, 0x2}}, {0x2F98D, {0xCBD, 0x1}}, {0x1E5D, {0x421, 0x3}},
    {0xF43, {0x318, 0x2}}, {0x1E29, {0x3AC, 0x2}}, {0xF93E, {0x91F, 0x1}}, {0x2F9C5, {0xCF5, 0x1}},
    {0x21CE, {0x819, 0x2}}, {0x2F87B, {0xBAB, 0x1}}, {0x2F9BA, {0xCEA, 0x1}}, {0x1EC2, {0x504, 0x3}},
    {0x219A, {0x811, 0x2}}, {0x1F64, {0x687, 0x3}}, {0xF906, {0x8E7, 0x1}}, {0xF9D7, {0x9B8, 0x1}}
};

}
} // namespace Cangjie::Unicode
#endif // CANGJIE_UTILS_UNICODETABLES_NORMALISATIONDATA_H
