// Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
// This source file is part of the Cangjie project, licensed under Apache-2.0
// with Runtime Library Exception.
//
// See https://cangjie-lang.cn/pages/LICENSE for license information.

// TOKEN(token id, token value for human reading, token literal, token priority)
// Note that stdlib/ast/AnyKind.cj should be modified at the same time that this file has been changed.
#ifdef TOKEN
TOKEN(DOT, "dot", ".", 0)
TOKEN(COMMA, "comma", ",", 0)
TOKEN(LPAREN, "l_paren", "(", 0)
TOKEN(RPAREN, "r_paren", ")", 0)
TOKEN(LSQUARE, "l_square", "[", 0)
TOKEN(RSQUARE, "r_square", "]", 0)
TOKEN(LCURL, "l_curl", "{", 0)
TOKEN(RCURL, "r_curl", "}", 0)
TOKEN(EXP, "exp", "**", 16)
TOKEN(MUL, "mul", "*", 15)
TOKEN(MOD, "mod", "%", 15)
TOKEN(DIV, "div", "/", 15)
TOKEN(ADD, "add", "+", 14)
TOKEN(SUB, "sub", "-", 14)
TOKEN(INCR, "incr", "++", 0)
TOKEN(DECR, "decr", "--", 0)
TOKEN(AND, "and", "&&", 5)
TOKEN(OR, "or", "||", 3)
TOKEN(COALESCING, "coalescing", "??", 2)
TOKEN(PIPELINE, "pipeline", "|>", 1)
TOKEN(COMPOSITION, "composition", "~>", 1)
TOKEN(NOT, "not", "!", 0)
TOKEN(BITAND, "bit_and", "&", 8)
TOKEN(BITOR, "bit_or", "|", 6)
TOKEN(BITXOR, "bit_xor", "^", 7)
TOKEN(BITNOT, "bit_not", "~", 0)
TOKEN(LSHIFT, "lshift", "<<", 13)
TOKEN(RSHIFT, "rshift", ">>", 13)
TOKEN(COLON, "colon", ":", 0)
TOKEN(SEMI, "semi", ";", 0)
TOKEN(ASSIGN, "assign", "=", 0)
TOKEN(ADD_ASSIGN, "add_assign", "+=", 0)
TOKEN(SUB_ASSIGN, "sub_assign", "-=", 0)
TOKEN(MUL_ASSIGN, "mul_assign", "*=", 0)
TOKEN(EXP_ASSIGN, "exp_assign", "**=", 0)
TOKEN(DIV_ASSIGN, "div_assign", "/=", 0)
TOKEN(MOD_ASSIGN, "mod_assign", "%=", 0)
TOKEN(AND_ASSIGN, "and_assign", "&&=", 0)
TOKEN(OR_ASSIGN, "or_assign", "||=", 0)
TOKEN(BITAND_ASSIGN, "bit_and_assign", "&=", 0)
TOKEN(BITOR_ASSIGN, "bit_or_assign", "|=", 0)
TOKEN(BITXOR_ASSIGN, "bit_xor_assign", "^=", 0)
TOKEN(LSHIFT_ASSIGN, "lshift_assign", "<<=", 0)
TOKEN(RSHIFT_ASSIGN, "rshift_assign", ">>=", 0)
TOKEN(ARROW, "arrow", "->", 0)
TOKEN(BACKARROW, "backarrow", "<-", 0)
TOKEN(DOUBLE_ARROW, "double_arrow", "=>", 0)
TOKEN(RANGEOP, "range_op", "..", 11)
TOKEN(CLOSEDRANGEOP, "closed_range_op", "..=", 11)
TOKEN(ELLIPSIS, "ellipsis", "...", 0)
TOKEN(HASH, "hash", "#", 0)
TOKEN(AT, "at", "@", 0)
TOKEN(QUEST, "quest", "?", 1)
TOKEN(LT, "less", "<", 10)
TOKEN(GT, "greater", ">", 10)
TOKEN(LE, "less_equal", "<=", 10)
TOKEN(GE, "greater_equal", ">=", 10)
TOKEN(IS, "is", "is", 10)
TOKEN(AS, "as", "as", 10)
TOKEN(NOTEQ, "not_equal", "!=", 9)
TOKEN(EQUAL, "equal", "==", 9)
TOKEN(WILDCARD, "wildcard", "_", 0)
TOKEN(INT8, "Int8", "Int8", 0)
TOKEN(INT16, "Int16", "Int16", 0)
TOKEN(INT32, "Int32", "Int32", 0)
TOKEN(INT64, "Int64", "Int64", 0)
TOKEN(INTNATIVE, "IntNative", "IntNative", 0)
TOKEN(UINT8, "UInt8", "UInt8", 0)
TOKEN(UINT16, "UInt16", "UInt16", 0)
TOKEN(UINT32, "UInt32", "UInt32", 0)
TOKEN(UINT64, "UInt64", "UInt64", 0)
TOKEN(UINTNATIVE, "UIntNative", "UIntNative", 0)
TOKEN(FLOAT16, "Float16", "Float16", 0)
TOKEN(FLOAT32, "Float32", "Float32", 0)
TOKEN(FLOAT64, "Float64", "Float64", 0)
TOKEN(RUNE, "Rune", "Rune", 0)
TOKEN(BOOLEAN, "Bool", "Bool", 0)
TOKEN(NOTHING, "Nothing", "Nothing", 0)
TOKEN(UNIT, "Unit", "Unit", 0)
TOKEN(STRUCT, "struct", "struct", 0)
TOKEN(ENUM, "enum", "enum", 0)
TOKEN(VARRAY, "VArray", "VArray", 0)
TOKEN(THISTYPE, "This", "This", 0)
TOKEN(PACKAGE, "package", "package", 0)
TOKEN(IMPORT, "import", "import", 0)
TOKEN(CLASS, "class", "class", 0)
TOKEN(INTERFACE, "interface", "interface", 0)
TOKEN(FUNC, "func", "func", 0)
TOKEN(MACRO, "macro", "macro", 0)
TOKEN(QUOTE, "quote", "quote", 0)
TOKEN(DOLLAR, "dollar", "$", 0)
TOKEN(LET, "let", "let", 0)
TOKEN(VAR, "var", "var", 0)
TOKEN(CONST, "const", "const", 0)
TOKEN(TYPE, "type", "type", 0)
TOKEN(INIT, "init", "init", 0)
TOKEN(THIS, "this", "this", 0)
TOKEN(SUPER, "super", "super", 0)
TOKEN(IF, "if", "if", 0)
TOKEN(ELSE, "else", "else", 0)
TOKEN(CASE, "case", "case", 0)
TOKEN(TRY, "try", "try", 0)
TOKEN(CATCH, "catch", "catch", 0)
TOKEN(FINALLY, "finally", "finally", 0)
TOKEN(FOR, "for", "for", 0)
TOKEN(DO, "do", "do", 0)
TOKEN(WHILE, "while", "while", 0)
TOKEN(THROW, "throw", "throw", 0)
TOKEN(RETURN, "return", "return", 0)
TOKEN(CONTINUE, "continue", "continue", 0)
TOKEN(BREAK, "break", "break", 0)
TOKEN(IN, "in", "in", 0)
TOKEN(NOT_IN, "not_in", "!in", 0)
TOKEN(MATCH, "match", "match", 0)
TOKEN(WHERE, "where", "where", 0)
TOKEN(EXTEND, "extend", "extend", 0)
TOKEN(WITH, "with", "with", 0)
TOKEN(PROP, "prop", "prop", 0)
TOKEN(STATIC, "static", "static", 0)
TOKEN(PUBLIC, "public", "public", 0)
TOKEN(PRIVATE, "private", "private", 0)
TOKEN(INTERNAL, "internal", "internal", 0)
TOKEN(PROTECTED, "protected", "protected", 0)
TOKEN(OVERRIDE, "override", "override", 0)
TOKEN(REDEF, "redef", "redef", 0)
TOKEN(ABSTRACT, "abstract", "abstract", 0)
TOKEN(SEALED, "sealed", "sealed", 0)
TOKEN(OPEN, "open", "open", 0)
TOKEN(FOREIGN, "foreign", "foreign", 0)
TOKEN(INOUT, "inout", "inout", 0)
TOKEN(MUT, "mut", "mut", 0)
TOKEN(UNSAFE, "unsafe", "unsafe", 0)
TOKEN(OPERATOR, "operator", "operator", 0)
TOKEN(SPAWN, "spawn", "spawn", 0)
TOKEN(SYNCHRONIZED, "synchronized", "synchronized", 0)
TOKEN(UPPERBOUND, "upperbound", "<:", 0)
TOKEN(MAIN, "main", "main", 0)
TOKEN(IDENTIFIER, "identifier", "", 0)
TOKEN(PACKAGE_IDENTIFIER, "package_identifier", "", 0)
TOKEN(INTEGER_LITERAL, "integer_literal", "", 0)
TOKEN(RUNE_BYTE_LITERAL, "rune_byte_literal", "", 0)
TOKEN(FLOAT_LITERAL, "float_literal", "", 0)
TOKEN(COMMENT, "comment", "", 0)
TOKEN(NL, "newline", "", 0)
TOKEN(END, "end", "", 0)
TOKEN(SENTINEL, "sentinel", "", 0)
TOKEN(RUNE_LITERAL, "char_literal", "", 0)
TOKEN(STRING_LITERAL, "string_literal", "", 0)
TOKEN(JSTRING_LITERAL, "jstring_literal", "", 0)
TOKEN(MULTILINE_STRING, "multiline_string", "", 0)
TOKEN(MULTILINE_RAW_STRING, "multiline_raw_string", "", 0)
TOKEN(BOOL_LITERAL, "bool_literal", "", 0)
TOKEN(UNIT_LITERAL, "unit_literal", "", 0) // Will not be produced from Lexer.
TOKEN(DOLLAR_IDENTIFIER, "dollar_identifier", "", 0)
TOKEN(ANNOTATION, "annotation", "", 0)
TOKEN(AT_EXCL, "at_exclamation", "@!", 0)
TOKEN(ILLEGAL, "illegal", "", 0)
#endif
