// Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
// This source file is part of the Cangjie project, licensed under Apache-2.0
// with Runtime Library Exception.
//
// See https://cangjie-lang.cn/pages/LICENSE for license information.

/**
 * @file
 *
 * This file lists all values --target-cpu option supports (Equivalent to what LLVM 15.0.4 supports).
 */

#ifdef CANGJIE_X86_64_TARGET_CPU
CANGJIE_X86_64_TARGET_CPU("alderlake")
CANGJIE_X86_64_TARGET_CPU("amdfam10")
CANGJIE_X86_64_TARGET_CPU("athlon")
CANGJIE_X86_64_TARGET_CPU("athlon-4")
CANGJIE_X86_64_TARGET_CPU("athlon-fx")
CANGJIE_X86_64_TARGET_CPU("athlon-mp")
CANGJIE_X86_64_TARGET_CPU("athlon-tbird")
CANGJIE_X86_64_TARGET_CPU("athlon-xp")
CANGJIE_X86_64_TARGET_CPU("athlon64")
CANGJIE_X86_64_TARGET_CPU("athlon64-sse3")
CANGJIE_X86_64_TARGET_CPU("atom")
CANGJIE_X86_64_TARGET_CPU("barcelona")
CANGJIE_X86_64_TARGET_CPU("bdver1")
CANGJIE_X86_64_TARGET_CPU("bdver2")
CANGJIE_X86_64_TARGET_CPU("bdver3")
CANGJIE_X86_64_TARGET_CPU("bdver4")
CANGJIE_X86_64_TARGET_CPU("bonnell")
CANGJIE_X86_64_TARGET_CPU("broadwell")
CANGJIE_X86_64_TARGET_CPU("btver1")
CANGJIE_X86_64_TARGET_CPU("btver2")
CANGJIE_X86_64_TARGET_CPU("c3")
CANGJIE_X86_64_TARGET_CPU("c3-2")
CANGJIE_X86_64_TARGET_CPU("cannonlake")
CANGJIE_X86_64_TARGET_CPU("cascadelake")
CANGJIE_X86_64_TARGET_CPU("cooperlake")
CANGJIE_X86_64_TARGET_CPU("core-avx-i")
CANGJIE_X86_64_TARGET_CPU("core-avx2")
CANGJIE_X86_64_TARGET_CPU("core2")
CANGJIE_X86_64_TARGET_CPU("corei7")
CANGJIE_X86_64_TARGET_CPU("corei7-avx")
CANGJIE_X86_64_TARGET_CPU("generic")
CANGJIE_X86_64_TARGET_CPU("geode")
CANGJIE_X86_64_TARGET_CPU("goldmont")
CANGJIE_X86_64_TARGET_CPU("goldmont-plus")
CANGJIE_X86_64_TARGET_CPU("haswell")
CANGJIE_X86_64_TARGET_CPU("i386")
CANGJIE_X86_64_TARGET_CPU("i486")
CANGJIE_X86_64_TARGET_CPU("i586")
CANGJIE_X86_64_TARGET_CPU("i686")
CANGJIE_X86_64_TARGET_CPU("icelake-client")
CANGJIE_X86_64_TARGET_CPU("icelake-server")
CANGJIE_X86_64_TARGET_CPU("ivybridge")
CANGJIE_X86_64_TARGET_CPU("k6")
CANGJIE_X86_64_TARGET_CPU("k6-2")
CANGJIE_X86_64_TARGET_CPU("k6-3")
CANGJIE_X86_64_TARGET_CPU("k8")
CANGJIE_X86_64_TARGET_CPU("k8-sse3")
CANGJIE_X86_64_TARGET_CPU("knl")
CANGJIE_X86_64_TARGET_CPU("knm")
CANGJIE_X86_64_TARGET_CPU("lakemont")
CANGJIE_X86_64_TARGET_CPU("nehalem")
CANGJIE_X86_64_TARGET_CPU("nocona")
CANGJIE_X86_64_TARGET_CPU("opteron")
CANGJIE_X86_64_TARGET_CPU("opteron-sse3")
CANGJIE_X86_64_TARGET_CPU("penryn")
CANGJIE_X86_64_TARGET_CPU("pentium")
CANGJIE_X86_64_TARGET_CPU("pentium-m")
CANGJIE_X86_64_TARGET_CPU("pentium-mmx")
CANGJIE_X86_64_TARGET_CPU("pentium2")
CANGJIE_X86_64_TARGET_CPU("pentium3")
CANGJIE_X86_64_TARGET_CPU("pentium3m")
CANGJIE_X86_64_TARGET_CPU("pentium4")
CANGJIE_X86_64_TARGET_CPU("pentium4m")
CANGJIE_X86_64_TARGET_CPU("pentiumpro")
CANGJIE_X86_64_TARGET_CPU("prescott")
CANGJIE_X86_64_TARGET_CPU("rocketlake")
CANGJIE_X86_64_TARGET_CPU("sandybridge")
CANGJIE_X86_64_TARGET_CPU("sapphirerapids")
CANGJIE_X86_64_TARGET_CPU("silvermont")
CANGJIE_X86_64_TARGET_CPU("skx")
CANGJIE_X86_64_TARGET_CPU("skylake")
CANGJIE_X86_64_TARGET_CPU("skylake-avx512")
CANGJIE_X86_64_TARGET_CPU("slm")
CANGJIE_X86_64_TARGET_CPU("tigerlake")
CANGJIE_X86_64_TARGET_CPU("tremont")
CANGJIE_X86_64_TARGET_CPU("westmere")
CANGJIE_X86_64_TARGET_CPU("winchip-c6")
CANGJIE_X86_64_TARGET_CPU("winchip2")
CANGJIE_X86_64_TARGET_CPU("x86-64")
CANGJIE_X86_64_TARGET_CPU("x86-64-v2")
CANGJIE_X86_64_TARGET_CPU("x86-64-v3")
CANGJIE_X86_64_TARGET_CPU("x86-64-v4")
CANGJIE_X86_64_TARGET_CPU("yonah")
CANGJIE_X86_64_TARGET_CPU("znver1")
CANGJIE_X86_64_TARGET_CPU("znver2")
CANGJIE_X86_64_TARGET_CPU("znver3")
#endif

#ifdef CANGJIE_AARCH64_TARGET_CPU
CANGJIE_AARCH64_TARGET_CPU("a64fx")
CANGJIE_AARCH64_TARGET_CPU("ampere1")
CANGJIE_AARCH64_TARGET_CPU("apple-a10")
CANGJIE_AARCH64_TARGET_CPU("apple-a11")
CANGJIE_AARCH64_TARGET_CPU("apple-a12")
CANGJIE_AARCH64_TARGET_CPU("apple-a13")
CANGJIE_AARCH64_TARGET_CPU("apple-a14")
CANGJIE_AARCH64_TARGET_CPU("apple-a7")
CANGJIE_AARCH64_TARGET_CPU("apple-a8")
CANGJIE_AARCH64_TARGET_CPU("apple-a9")
CANGJIE_AARCH64_TARGET_CPU("apple-latest")
CANGJIE_AARCH64_TARGET_CPU("apple-m1")
CANGJIE_AARCH64_TARGET_CPU("apple-s4")
CANGJIE_AARCH64_TARGET_CPU("apple-s5")
CANGJIE_AARCH64_TARGET_CPU("carmel")
CANGJIE_AARCH64_TARGET_CPU("cortex-a34")
CANGJIE_AARCH64_TARGET_CPU("cortex-a35")
CANGJIE_AARCH64_TARGET_CPU("cortex-a510")
CANGJIE_AARCH64_TARGET_CPU("cortex-a53")
CANGJIE_AARCH64_TARGET_CPU("cortex-a55")
CANGJIE_AARCH64_TARGET_CPU("cortex-a57")
CANGJIE_AARCH64_TARGET_CPU("cortex-a65")
CANGJIE_AARCH64_TARGET_CPU("cortex-a65ae")
CANGJIE_AARCH64_TARGET_CPU("cortex-a710")
CANGJIE_AARCH64_TARGET_CPU("cortex-a72")
CANGJIE_AARCH64_TARGET_CPU("cortex-a73")
CANGJIE_AARCH64_TARGET_CPU("cortex-a75")
CANGJIE_AARCH64_TARGET_CPU("cortex-a76")
CANGJIE_AARCH64_TARGET_CPU("cortex-a76ae")
CANGJIE_AARCH64_TARGET_CPU("cortex-a77")
CANGJIE_AARCH64_TARGET_CPU("cortex-a78")
CANGJIE_AARCH64_TARGET_CPU("cortex-a78c")
CANGJIE_AARCH64_TARGET_CPU("cortex-r82")
CANGJIE_AARCH64_TARGET_CPU("cortex-x1")
CANGJIE_AARCH64_TARGET_CPU("cortex-x1c")
CANGJIE_AARCH64_TARGET_CPU("cortex-x2")
CANGJIE_AARCH64_TARGET_CPU("cyclone")
CANGJIE_AARCH64_TARGET_CPU("exynos-m3")
CANGJIE_AARCH64_TARGET_CPU("exynos-m4")
CANGJIE_AARCH64_TARGET_CPU("exynos-m5")
CANGJIE_AARCH64_TARGET_CPU("falkor")
CANGJIE_AARCH64_TARGET_CPU("generic")
CANGJIE_AARCH64_TARGET_CPU("kryo")
CANGJIE_AARCH64_TARGET_CPU("neoverse-512tvb")
CANGJIE_AARCH64_TARGET_CPU("neoverse-e1")
CANGJIE_AARCH64_TARGET_CPU("neoverse-n1")
CANGJIE_AARCH64_TARGET_CPU("neoverse-n2")
CANGJIE_AARCH64_TARGET_CPU("neoverse-v1")
CANGJIE_AARCH64_TARGET_CPU("saphira")
CANGJIE_AARCH64_TARGET_CPU("thunderx")
CANGJIE_AARCH64_TARGET_CPU("thunderx2t99")
CANGJIE_AARCH64_TARGET_CPU("thunderx3t110")
CANGJIE_AARCH64_TARGET_CPU("thunderxt81")
CANGJIE_AARCH64_TARGET_CPU("thunderxt83")
CANGJIE_AARCH64_TARGET_CPU("thunderxt88")
CANGJIE_AARCH64_TARGET_CPU("tsv110")
#endif
